# coding: utf-8

"""
    DocuSign Click API

    Elastic signing (also known as DocuSign Click)  lets you capture consent to standard agreement terms with a single click: terms and conditions, terms of service, terms of use, privacy policies, and more. The Click API lets you include this customizable elastic template solution in your DocuSign integrations.  # noqa: E501

    OpenAPI spec version: v1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..client.configuration import Configuration
from ..client.api_client import ApiClient


class AccountsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_bulk_clickwrap_agreements(self, account_id, clickwrap_id, **kwargs):
        """
        Starts an export of clickwrap agreements for a specified date range.
        Starts an asynchronus process to export clickwrap agreements for a specified date range. An email will be sent to the creator after it has been processed.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_bulk_clickwrap_agreements(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param BulkClickwrapRequest bulk_clickwrap_request: Data used to start a bulk agreements export.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_bulk_clickwrap_agreements_with_http_info(account_id, clickwrap_id, **kwargs)
        else:
            (data) = self.create_bulk_clickwrap_agreements_with_http_info(account_id, clickwrap_id, **kwargs)
            return data

    def create_bulk_clickwrap_agreements_with_http_info(self, account_id, clickwrap_id, **kwargs):
        """
        Starts an export of clickwrap agreements for a specified date range.
        Starts an asynchronus process to export clickwrap agreements for a specified date range. An email will be sent to the creator after it has been processed.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_bulk_clickwrap_agreements_with_http_info(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param BulkClickwrapRequest bulk_clickwrap_request: Data used to start a bulk agreements export.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id', 'bulk_clickwrap_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_bulk_clickwrap_agreements" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_bulk_clickwrap_agreements`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `create_bulk_clickwrap_agreements`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/bulk_agreements'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'bulk_clickwrap_request' in params:
            body_params = params['bulk_clickwrap_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_clickwrap(self, account_id, **kwargs):
        """
        Creates a clickwrap for an account.
        Creates a clickwrap for an account.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_clickwrap(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param ClickwrapRequest clickwrap_request: Request body for working with clickwrap.
        :return: ClickwrapVersionSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_clickwrap_with_http_info(account_id, **kwargs)
        else:
            (data) = self.create_clickwrap_with_http_info(account_id, **kwargs)
            return data

    def create_clickwrap_with_http_info(self, account_id, **kwargs):
        """
        Creates a clickwrap for an account.
        Creates a clickwrap for an account.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_clickwrap_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param ClickwrapRequest clickwrap_request: Request body for working with clickwrap.
        :return: ClickwrapVersionSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_clickwrap" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_clickwrap`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'clickwrap_request' in params:
            body_params = params['clickwrap_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapVersionSummaryResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_clickwrap_version(self, account_id, clickwrap_id, **kwargs):
        """
        Creates a new clickwrap version.
        Creates a new version of an existing clickwrap. In a new version, you can replace the uploaded documents, change the display settings, and change the name of the clickwrap. The version number is automatically incremented based on the last version of the clickwrap.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_clickwrap_version(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param ClickwrapRequest clickwrap_request: Request body for working with clickwrap.
        :return: ClickwrapVersionSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_clickwrap_version_with_http_info(account_id, clickwrap_id, **kwargs)
        else:
            (data) = self.create_clickwrap_version_with_http_info(account_id, clickwrap_id, **kwargs)
            return data

    def create_clickwrap_version_with_http_info(self, account_id, clickwrap_id, **kwargs):
        """
        Creates a new clickwrap version.
        Creates a new version of an existing clickwrap. In a new version, you can replace the uploaded documents, change the display settings, and change the name of the clickwrap. The version number is automatically incremented based on the last version of the clickwrap.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_clickwrap_version_with_http_info(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param ClickwrapRequest clickwrap_request: Request body for working with clickwrap.
        :return: ClickwrapVersionSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id', 'clickwrap_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_clickwrap_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_clickwrap_version`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `create_clickwrap_version`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'clickwrap_request' in params:
            body_params = params['clickwrap_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapVersionSummaryResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_has_agreed(self, account_id, clickwrap_id, **kwargs):
        """
        Creates a unique URL for the agreement that you can embed in your application.
        Creates a unique URL for the agreement that you can embed in your application.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage` and `click.send`.  The request must include at least the `clientUserId`. This is a value that you generate to identify the unique recipient of the agreement.  If you are using a [dynamic content][] document, you can supply the values in the documentData property of the request, like this:  ```json {   \"clientUserId\": \"cl-bc7f-48a9\",   \"documentData\": {     \"fullName\": \"T. J. Fanning\",     \"email\": \"tj@example.com\",     \"company\": \"Fanning Indusdtries\",     \"title\": \"Cat wrangler\",     \"date\": \"2022-10-13T05:17:14-07:00\"   } } ```  A response will look like this. The `agreementUrl` is unique to the user identified by the `clientUserId`. Your user can open the URL to approve the agreement. The `documentData` property appears only if you provided it in the request.  ```json {   \"accountId\": \"624e3e00-xxxx-xxxx-xxxx-43918c520dab\",   \"clickwrapId\": \"0e64e4a7-xxxx-xxxx-xxxx-ce5a93b162af\",   \"clientUserId\": \"tcl-bc7f-48a9j\",   \"agreementId\": \"1f346c7d-xxxx-xxxx-xxxx-a5c968666785\",   \"documents\": [ . . .],   \"consumerDisclosureEnabled\": true,   \"agreementUrl\": \"https://demo.docusign.net/clickapi/v1/redeem?agreementToken=AcTZT8g ... cxEqrUsA1lQ8DPPy05dE0\",   \"createdOn\": \"2022-10-20T16:27:25.1287685Z\",   \"status\": \"created\",   \"versionId\": \"5957716d-xxxx-xxxx-xxxx-e1594f00ff12\",   \"versionNumber\": 1,   \"settings\": {     \"displayName\": \"Agree with me\",     \"hasDeclineButton\": true,     .  . .     \"statementAlignment\": \"bottom\"   },   \"documentData\": {     \"fullName\": \"T. J. Fanning\",     \"email\": \"tj@example.com\",     \"company\": \"Fanning Indusdtries\",     \"title\": \"Cat wrangler\",     \"date\": \"2022-10-13T05:17:14-07:00\"   } } ```  This method returns the following result codes and response bodies depending on whether the user has agreed.   | Agreed | Response code | Response body          | | :----- | :------------ | :--------------------- | | No     | 201           | Full response as above | | Yes    | 200           | No response (empty)    |   ### Related topics  - [Add dynamic content to your clickwrap][dynamic content] - [How to embed a clickwrap][embed-howto]   [dynamic content]:  /docs/click-api/click101/customize-clickwrap-fields/#add-dynamic-content-to-your-clickwrap [embedding]:        /docs/click-api/click101/customize-clickwrap-fields/#embed-clickwraps-that-contain-dynamic-content [embed-howto]:      /docs/click-api/how-to/embed-clickwraps/ 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_has_agreed(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param UserAgreementRequest user_agreement_request: Data used to create the agreement.
        :return: UserAgreementResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_has_agreed_with_http_info(account_id, clickwrap_id, **kwargs)
        else:
            (data) = self.create_has_agreed_with_http_info(account_id, clickwrap_id, **kwargs)
            return data

    def create_has_agreed_with_http_info(self, account_id, clickwrap_id, **kwargs):
        """
        Creates a unique URL for the agreement that you can embed in your application.
        Creates a unique URL for the agreement that you can embed in your application.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage` and `click.send`.  The request must include at least the `clientUserId`. This is a value that you generate to identify the unique recipient of the agreement.  If you are using a [dynamic content][] document, you can supply the values in the documentData property of the request, like this:  ```json {   \"clientUserId\": \"cl-bc7f-48a9\",   \"documentData\": {     \"fullName\": \"T. J. Fanning\",     \"email\": \"tj@example.com\",     \"company\": \"Fanning Indusdtries\",     \"title\": \"Cat wrangler\",     \"date\": \"2022-10-13T05:17:14-07:00\"   } } ```  A response will look like this. The `agreementUrl` is unique to the user identified by the `clientUserId`. Your user can open the URL to approve the agreement. The `documentData` property appears only if you provided it in the request.  ```json {   \"accountId\": \"624e3e00-xxxx-xxxx-xxxx-43918c520dab\",   \"clickwrapId\": \"0e64e4a7-xxxx-xxxx-xxxx-ce5a93b162af\",   \"clientUserId\": \"tcl-bc7f-48a9j\",   \"agreementId\": \"1f346c7d-xxxx-xxxx-xxxx-a5c968666785\",   \"documents\": [ . . .],   \"consumerDisclosureEnabled\": true,   \"agreementUrl\": \"https://demo.docusign.net/clickapi/v1/redeem?agreementToken=AcTZT8g ... cxEqrUsA1lQ8DPPy05dE0\",   \"createdOn\": \"2022-10-20T16:27:25.1287685Z\",   \"status\": \"created\",   \"versionId\": \"5957716d-xxxx-xxxx-xxxx-e1594f00ff12\",   \"versionNumber\": 1,   \"settings\": {     \"displayName\": \"Agree with me\",     \"hasDeclineButton\": true,     .  . .     \"statementAlignment\": \"bottom\"   },   \"documentData\": {     \"fullName\": \"T. J. Fanning\",     \"email\": \"tj@example.com\",     \"company\": \"Fanning Indusdtries\",     \"title\": \"Cat wrangler\",     \"date\": \"2022-10-13T05:17:14-07:00\"   } } ```  This method returns the following result codes and response bodies depending on whether the user has agreed.   | Agreed | Response code | Response body          | | :----- | :------------ | :--------------------- | | No     | 201           | Full response as above | | Yes    | 200           | No response (empty)    |   ### Related topics  - [Add dynamic content to your clickwrap][dynamic content] - [How to embed a clickwrap][embed-howto]   [dynamic content]:  /docs/click-api/click101/customize-clickwrap-fields/#add-dynamic-content-to-your-clickwrap [embedding]:        /docs/click-api/click101/customize-clickwrap-fields/#embed-clickwraps-that-contain-dynamic-content [embed-howto]:      /docs/click-api/how-to/embed-clickwraps/ 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_has_agreed_with_http_info(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param UserAgreementRequest user_agreement_request: Data used to create the agreement.
        :return: UserAgreementResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id', 'user_agreement_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_has_agreed" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_has_agreed`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `create_has_agreed`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/agreements'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'user_agreement_request' in params:
            body_params = params['user_agreement_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='UserAgreementResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_clickwrap(self, account_id, clickwrap_id, **kwargs):
        """
        Deletes a clickwrap and all of its versions.
        Deletes the clickwrap specified by `clickwrapId` and all of its versions. Active clickwraps are not deleted  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_clickwrap(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param str versions: A comma-separated list of versions to delete.
        :return: ClickwrapVersionsDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_clickwrap_with_http_info(account_id, clickwrap_id, **kwargs)
        else:
            (data) = self.delete_clickwrap_with_http_info(account_id, clickwrap_id, **kwargs)
            return data

    def delete_clickwrap_with_http_info(self, account_id, clickwrap_id, **kwargs):
        """
        Deletes a clickwrap and all of its versions.
        Deletes the clickwrap specified by `clickwrapId` and all of its versions. Active clickwraps are not deleted  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_clickwrap_with_http_info(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param str versions: A comma-separated list of versions to delete.
        :return: ClickwrapVersionsDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id', 'versions']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_clickwrap" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_clickwrap`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `delete_clickwrap`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']

        query_params = {}
        if 'versions' in params:
            query_params['versions'] = params['versions']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapVersionsDeleteResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_clickwrap_version(self, account_id, clickwrap_id, version_id, **kwargs):
        """
        Deletes a clickwrap version by version ID.
        Deletes the clickwrap version specified by `versionId` of the clickwrap specified by `clickwrapId`.  **Note:** This endpoint requires the version ID (a GUID), not the version number (an integer).  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_clickwrap_version(account_id, clickwrap_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param str version_id: The ID of the clickwrap version. (required)
        :return: ClickwrapVersionDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_clickwrap_version_with_http_info(account_id, clickwrap_id, version_id, **kwargs)
        else:
            (data) = self.delete_clickwrap_version_with_http_info(account_id, clickwrap_id, version_id, **kwargs)
            return data

    def delete_clickwrap_version_with_http_info(self, account_id, clickwrap_id, version_id, **kwargs):
        """
        Deletes a clickwrap version by version ID.
        Deletes the clickwrap version specified by `versionId` of the clickwrap specified by `clickwrapId`.  **Note:** This endpoint requires the version ID (a GUID), not the version number (an integer).  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_clickwrap_version_with_http_info(account_id, clickwrap_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param str version_id: The ID of the clickwrap version. (required)
        :return: ClickwrapVersionDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id', 'version_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_clickwrap_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_clickwrap_version`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `delete_clickwrap_version`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `delete_clickwrap_version`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions/{versionId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapVersionDeleteResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_clickwrap_versions(self, account_id, clickwrap_id, **kwargs):
        """
        Deletes the versions of a clickwrap.
        Deletes all versions of a clickwrap, or only the ones specified in the `clickwrapVersionIds` query parameter.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_clickwrap_versions(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param str clickwrap_version_ids: A comma-separated list of clickwrap version IDs to delete.
        :return: ClickwrapVersionsDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_clickwrap_versions_with_http_info(account_id, clickwrap_id, **kwargs)
        else:
            (data) = self.delete_clickwrap_versions_with_http_info(account_id, clickwrap_id, **kwargs)
            return data

    def delete_clickwrap_versions_with_http_info(self, account_id, clickwrap_id, **kwargs):
        """
        Deletes the versions of a clickwrap.
        Deletes all versions of a clickwrap, or only the ones specified in the `clickwrapVersionIds` query parameter.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_clickwrap_versions_with_http_info(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param str clickwrap_version_ids: A comma-separated list of clickwrap version IDs to delete.
        :return: ClickwrapVersionsDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id', 'clickwrap_version_ids']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_clickwrap_versions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_clickwrap_versions`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `delete_clickwrap_versions`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']

        query_params = {}
        if 'clickwrap_version_ids' in params:
            query_params['clickwrapVersionIds'] = params['clickwrap_version_ids']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapVersionsDeleteResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_clickwraps(self, account_id, **kwargs):
        """
        Deletes clickwraps for an account.
        Deletes all clickwraps for an account or only the ones specified in the `clickwrapIds` query parameter.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_clickwraps(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_ids: A comma-separated list of clickwrap IDs to delete.
        :return: ClickwrapsDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_clickwraps_with_http_info(account_id, **kwargs)
        else:
            (data) = self.delete_clickwraps_with_http_info(account_id, **kwargs)
            return data

    def delete_clickwraps_with_http_info(self, account_id, **kwargs):
        """
        Deletes clickwraps for an account.
        Deletes all clickwraps for an account or only the ones specified in the `clickwrapIds` query parameter.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_clickwraps_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_ids: A comma-separated list of clickwrap IDs to delete.
        :return: ClickwrapsDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_ids']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_clickwraps" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_clickwraps`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}
        if 'clickwrap_ids' in params:
            query_params['clickwrapIds'] = params['clickwrap_ids']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapsDeleteResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_agreement(self, account_id, agreement_id, clickwrap_id, **kwargs):
        """
        Gets a specific agreement for a specified clickwrap.
        Gets the agreement specified by `agreementId`.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage` or `click.send`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_agreement(account_id, agreement_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str agreement_id: The agreement ID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :return: UserAgreementResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_agreement_with_http_info(account_id, agreement_id, clickwrap_id, **kwargs)
        else:
            (data) = self.get_agreement_with_http_info(account_id, agreement_id, clickwrap_id, **kwargs)
            return data

    def get_agreement_with_http_info(self, account_id, agreement_id, clickwrap_id, **kwargs):
        """
        Gets a specific agreement for a specified clickwrap.
        Gets the agreement specified by `agreementId`.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage` or `click.send`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_agreement_with_http_info(account_id, agreement_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str agreement_id: The agreement ID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :return: UserAgreementResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'agreement_id', 'clickwrap_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_agreement" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_agreement`")
        # verify the required parameter 'agreement_id' is set
        if ('agreement_id' not in params) or (params['agreement_id'] is None):
            raise ValueError("Missing the required parameter `agreement_id` when calling `get_agreement`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `get_agreement`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/agreements/{agreementId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'agreement_id' in params:
            path_params['agreementId'] = params['agreement_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='UserAgreementResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_agreement_document(self, account_id, clickwrap_id, order_or_disclosure, version_id, **kwargs):
        """
        Downloads a document at an order within the agreement.
        Downloads a specific document from the agreement presented to the user.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.sign`
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_agreement_document(account_id, clickwrap_id, order_or_disclosure, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param str order_or_disclosure: The order of the document or consumer_disclosure. (required)
        :param str version_id: The ID of the clickwrap version. (required)
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_agreement_document_with_http_info(account_id, clickwrap_id, order_or_disclosure, version_id, **kwargs)
        else:
            (data) = self.get_agreement_document_with_http_info(account_id, clickwrap_id, order_or_disclosure, version_id, **kwargs)
            return data

    def get_agreement_document_with_http_info(self, account_id, clickwrap_id, order_or_disclosure, version_id, **kwargs):
        """
        Downloads a document at an order within the agreement.
        Downloads a specific document from the agreement presented to the user.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.sign`
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_agreement_document_with_http_info(account_id, clickwrap_id, order_or_disclosure, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param str order_or_disclosure: The order of the document or consumer_disclosure. (required)
        :param str version_id: The ID of the clickwrap version. (required)
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id', 'order_or_disclosure', 'version_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_agreement_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_agreement_document`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `get_agreement_document`")
        # verify the required parameter 'order_or_disclosure' is set
        if ('order_or_disclosure' not in params) or (params['order_or_disclosure'] is None):
            raise ValueError("Missing the required parameter `order_or_disclosure` when calling `get_agreement_document`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `get_agreement_document`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions/{versionId}/documents/{orderOrDisclosure}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']
        if 'order_or_disclosure' in params:
            path_params['orderOrDisclosure'] = params['order_or_disclosure']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Document',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_agreement_pdf(self, account_id, agreement_id, clickwrap_id, **kwargs):
        """
        Gets the completed user agreement PDF.
        Gets the PDF of  `agreementId` for the clickwrap specified by `clickwrapId`.  The response to this method is the bytes of the PDF file. The response includes the HTTP header `application/pdf`.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage` or `click.send`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_agreement_pdf(account_id, agreement_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str agreement_id: The agreement ID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param str include_coc: When **true,** the Certificate of Completion will be appended to the PDF. The default value is **false.**
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_agreement_pdf_with_http_info(account_id, agreement_id, clickwrap_id, **kwargs)
        else:
            (data) = self.get_agreement_pdf_with_http_info(account_id, agreement_id, clickwrap_id, **kwargs)
            return data

    def get_agreement_pdf_with_http_info(self, account_id, agreement_id, clickwrap_id, **kwargs):
        """
        Gets the completed user agreement PDF.
        Gets the PDF of  `agreementId` for the clickwrap specified by `clickwrapId`.  The response to this method is the bytes of the PDF file. The response includes the HTTP header `application/pdf`.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage` or `click.send`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_agreement_pdf_with_http_info(account_id, agreement_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str agreement_id: The agreement ID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param str include_coc: When **true,** the Certificate of Completion will be appended to the PDF. The default value is **false.**
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'agreement_id', 'clickwrap_id', 'include_coc']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_agreement_pdf" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_agreement_pdf`")
        # verify the required parameter 'agreement_id' is set
        if ('agreement_id' not in params) or (params['agreement_id'] is None):
            raise ValueError("Missing the required parameter `agreement_id` when calling `get_agreement_pdf`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `get_agreement_pdf`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/agreements/{agreementId}/download'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'agreement_id' in params:
            path_params['agreementId'] = params['agreement_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']

        query_params = {}
        if 'include_coc' in params:
            query_params['include_coc'] = params['include_coc']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/pdf'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_clickwrap(self, account_id, clickwrap_id, **kwargs):
        """
        Gets a  single clickwrap object.
        Retrieves the definition of the specified clickwrap.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_clickwrap(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :return: ClickwrapVersionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_clickwrap_with_http_info(account_id, clickwrap_id, **kwargs)
        else:
            (data) = self.get_clickwrap_with_http_info(account_id, clickwrap_id, **kwargs)
            return data

    def get_clickwrap_with_http_info(self, account_id, clickwrap_id, **kwargs):
        """
        Gets a  single clickwrap object.
        Retrieves the definition of the specified clickwrap.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_clickwrap_with_http_info(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :return: ClickwrapVersionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_clickwrap" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_clickwrap`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `get_clickwrap`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapVersionResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_clickwrap_agreements(self, account_id, clickwrap_id, **kwargs):
        """
        Get user agreements
        Retrieves the user agreements for a specified clickwrap. Each `userAgreementResponse` object describes a single user's response to the clickwrap. You can also filter the agreements by date, status, page number, and client user ID.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_clickwrap_agreements(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param str client_user_id: The client user ID to filter to a single user's agreements.
        :param str from_date: The earliest date to return agreements from.
        :param str page_number: The results for this endpoint are paginated. Use this parameter to indicate which page to return. The `minimumPagesRemaining` value in the response indicates whether to continue querying for additional pages.  For example, if the page size is 40: * If this property is set to 0 (the default), the endpoint returns results 1-40. * If this property is set to 1, the endpoint returns results 41-80.  The default value is 0. 
        :param str status: User agreement status. One of:  - `created` - `agreed` - `declined`
        :param str to_date: The latest date to return agreements from.
        :return: ClickwrapAgreementsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_clickwrap_agreements_with_http_info(account_id, clickwrap_id, **kwargs)
        else:
            (data) = self.get_clickwrap_agreements_with_http_info(account_id, clickwrap_id, **kwargs)
            return data

    def get_clickwrap_agreements_with_http_info(self, account_id, clickwrap_id, **kwargs):
        """
        Get user agreements
        Retrieves the user agreements for a specified clickwrap. Each `userAgreementResponse` object describes a single user's response to the clickwrap. You can also filter the agreements by date, status, page number, and client user ID.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_clickwrap_agreements_with_http_info(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param str client_user_id: The client user ID to filter to a single user's agreements.
        :param str from_date: The earliest date to return agreements from.
        :param str page_number: The results for this endpoint are paginated. Use this parameter to indicate which page to return. The `minimumPagesRemaining` value in the response indicates whether to continue querying for additional pages.  For example, if the page size is 40: * If this property is set to 0 (the default), the endpoint returns results 1-40. * If this property is set to 1, the endpoint returns results 41-80.  The default value is 0. 
        :param str status: User agreement status. One of:  - `created` - `agreed` - `declined`
        :param str to_date: The latest date to return agreements from.
        :return: ClickwrapAgreementsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id', 'client_user_id', 'from_date', 'page_number', 'status', 'to_date']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_clickwrap_agreements" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_clickwrap_agreements`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `get_clickwrap_agreements`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/users'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']

        query_params = {}
        if 'client_user_id' in params:
            query_params['client_user_id'] = params['client_user_id']
        if 'from_date' in params:
            query_params['from_date'] = params['from_date']
        if 'page_number' in params:
            query_params['page_number'] = params['page_number']
        if 'status' in params:
            query_params['status'] = params['status']
        if 'to_date' in params:
            query_params['to_date'] = params['to_date']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapAgreementsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_clickwrap_version(self, account_id, clickwrap_id, version_id, **kwargs):
        """
        Gets a specific version of a clickwrap by version ID.
        Gets the version specified by `versionId`  from the clickwrap `clickwrapId`.  **Note:** This endpoint requires the version ID (a GUID), not the version number (an integer).  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_clickwrap_version(account_id, clickwrap_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param str version_id: The ID of the clickwrap version. (required)
        :return: ClickwrapVersionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_clickwrap_version_with_http_info(account_id, clickwrap_id, version_id, **kwargs)
        else:
            (data) = self.get_clickwrap_version_with_http_info(account_id, clickwrap_id, version_id, **kwargs)
            return data

    def get_clickwrap_version_with_http_info(self, account_id, clickwrap_id, version_id, **kwargs):
        """
        Gets a specific version of a clickwrap by version ID.
        Gets the version specified by `versionId`  from the clickwrap `clickwrapId`.  **Note:** This endpoint requires the version ID (a GUID), not the version number (an integer).  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_clickwrap_version_with_http_info(account_id, clickwrap_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param str version_id: The ID of the clickwrap version. (required)
        :return: ClickwrapVersionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id', 'version_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_clickwrap_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_clickwrap_version`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `get_clickwrap_version`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `get_clickwrap_version`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions/{versionId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapVersionResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_clickwrap_version_agreements(self, account_id, clickwrap_id, version_id, **kwargs):
        """
        Gets the agreement responses for a clickwrap version by version ID.
        Gets the agreement responses for a specific version.  **Note:** This endpoint requires the version ID (a GUID), not the version number (an integer).  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_clickwrap_version_agreements(account_id, clickwrap_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param str version_id: The ID of the clickwrap version. (required)
        :param str client_user_id: The client user ID to filter to a single user's agreements.
        :param str from_date: The earliest date to return agreements from.
        :param str page_number: The results for this endpoint are paginated. Use this parameter to indicate which page to return. The `minimumPagesRemaining` value in the response indicates whether to continue querying for additional pages.  For example, if the page size is 40: * If this property is set to 0 (the default), the endpoint returns results 1-40. * If this property is set to 1, the endpoint returns results 41-80.  The default value is 0. 
        :param str status: User agreement status. One of:  - `created` - `agreed` - `declined`
        :param str to_date: The latest date to return agreements from.
        :return: ClickwrapAgreementsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_clickwrap_version_agreements_with_http_info(account_id, clickwrap_id, version_id, **kwargs)
        else:
            (data) = self.get_clickwrap_version_agreements_with_http_info(account_id, clickwrap_id, version_id, **kwargs)
            return data

    def get_clickwrap_version_agreements_with_http_info(self, account_id, clickwrap_id, version_id, **kwargs):
        """
        Gets the agreement responses for a clickwrap version by version ID.
        Gets the agreement responses for a specific version.  **Note:** This endpoint requires the version ID (a GUID), not the version number (an integer).  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_clickwrap_version_agreements_with_http_info(account_id, clickwrap_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param str version_id: The ID of the clickwrap version. (required)
        :param str client_user_id: The client user ID to filter to a single user's agreements.
        :param str from_date: The earliest date to return agreements from.
        :param str page_number: The results for this endpoint are paginated. Use this parameter to indicate which page to return. The `minimumPagesRemaining` value in the response indicates whether to continue querying for additional pages.  For example, if the page size is 40: * If this property is set to 0 (the default), the endpoint returns results 1-40. * If this property is set to 1, the endpoint returns results 41-80.  The default value is 0. 
        :param str status: User agreement status. One of:  - `created` - `agreed` - `declined`
        :param str to_date: The latest date to return agreements from.
        :return: ClickwrapAgreementsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id', 'version_id', 'client_user_id', 'from_date', 'page_number', 'status', 'to_date']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_clickwrap_version_agreements" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_clickwrap_version_agreements`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `get_clickwrap_version_agreements`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `get_clickwrap_version_agreements`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions/{versionId}/users'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}
        if 'client_user_id' in params:
            query_params['client_user_id'] = params['client_user_id']
        if 'from_date' in params:
            query_params['from_date'] = params['from_date']
        if 'page_number' in params:
            query_params['page_number'] = params['page_number']
        if 'status' in params:
            query_params['status'] = params['status']
        if 'to_date' in params:
            query_params['to_date'] = params['to_date']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapAgreementsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_clickwrap_versions(self, account_id, clickwrap_id, **kwargs):
        """
        Gets all the versions of a clickwrap.
        Gets all the versions of a clickwrap for an account.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_clickwrap_versions(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :return: ClickwrapVersionsPagedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_clickwrap_versions_with_http_info(account_id, clickwrap_id, **kwargs)
        else:
            (data) = self.get_clickwrap_versions_with_http_info(account_id, clickwrap_id, **kwargs)
            return data

    def get_clickwrap_versions_with_http_info(self, account_id, clickwrap_id, **kwargs):
        """
        Gets all the versions of a clickwrap.
        Gets all the versions of a clickwrap for an account.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_clickwrap_versions_with_http_info(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :return: ClickwrapVersionsPagedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_clickwrap_versions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_clickwrap_versions`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `get_clickwrap_versions`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapVersionsPagedResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_clickwraps(self, account_id, **kwargs):
        """
        Gets all the clickwraps for a user.
        Gets all the clickwraps for a user.   **Note:** This endpoint returns a list of `clickwrapVersionSummaryResponse` objects. Each version of each clickwrap is returned as a separate entry in the list.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_clickwraps(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str filter: Names of columns by which to filter and values to match on.
        :param str from_date: The earliest date to return clickwraps from.
        :param str name: The name of the clickwraps to return.
        :param str owner_user_id: The user ID of the owner.
        :param str page_number: The results for this endpoint are paginated. Use this parameter to indicate which page to return. The `minimumPagesRemaining` value in the response indicates whether to continue querying for additional pages.  For example, if the page size is 40: * If this property is set to 0 (the default), the endpoint returns results 1-40. * If this property is set to 1, the endpoint returns results 41-80.  The default value is 0. 
        :param str status: The status of the clickwraps to filter by. One of:  - `active` - `inactive`  
        :param str to_date: The latest date to return clickwraps from.
        :return: ClickwrapVersionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_clickwraps_with_http_info(account_id, **kwargs)
        else:
            (data) = self.get_clickwraps_with_http_info(account_id, **kwargs)
            return data

    def get_clickwraps_with_http_info(self, account_id, **kwargs):
        """
        Gets all the clickwraps for a user.
        Gets all the clickwraps for a user.   **Note:** This endpoint returns a list of `clickwrapVersionSummaryResponse` objects. Each version of each clickwrap is returned as a separate entry in the list.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_clickwraps_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str filter: Names of columns by which to filter and values to match on.
        :param str from_date: The earliest date to return clickwraps from.
        :param str name: The name of the clickwraps to return.
        :param str owner_user_id: The user ID of the owner.
        :param str page_number: The results for this endpoint are paginated. Use this parameter to indicate which page to return. The `minimumPagesRemaining` value in the response indicates whether to continue querying for additional pages.  For example, if the page size is 40: * If this property is set to 0 (the default), the endpoint returns results 1-40. * If this property is set to 1, the endpoint returns results 41-80.  The default value is 0. 
        :param str status: The status of the clickwraps to filter by. One of:  - `active` - `inactive`  
        :param str to_date: The latest date to return clickwraps from.
        :return: ClickwrapVersionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'filter', 'from_date', 'name', 'owner_user_id', 'page_number', 'status', 'to_date']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_clickwraps" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_clickwraps`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}
        if 'filter' in params:
            query_params['filter'] = params['filter']
        if 'from_date' in params:
            query_params['from_date'] = params['from_date']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'owner_user_id' in params:
            query_params['ownerUserId'] = params['owner_user_id']
        if 'page_number' in params:
            query_params['page_number'] = params['page_number']
        if 'status' in params:
            query_params['status'] = params['status']
        if 'to_date' in params:
            query_params['to_date'] = params['to_date']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapVersionsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_service_information(self, **kwargs):
        """
        Gets the current version and other information about the Click API.
        The response includes information about the Click API, including the service version, build version, and linked sites.  This method does not require authentication.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_service_information(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ServiceInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_service_information_with_http_info(**kwargs)
        else:
            (data) = self.get_service_information_with_http_info(**kwargs)
            return data

    def get_service_information_with_http_info(self, **kwargs):
        """
        Gets the current version and other information about the Click API.
        The response includes information about the Click API, including the service version, build version, and linked sites.  This method does not require authentication.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_service_information_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ServiceInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_service_information" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        resource_path = '/service_information'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ServiceInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_clickwrap(self, account_id, clickwrap_id, **kwargs):
        """
        Update a clickwrap by ID.
        Update a subset of properties on the clickwrap.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_clickwrap(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param ClickwrapTransferRequest clickwrap_transfer_request: Data used to transfer a clickwrap from one user to another.
        :return: ClickwrapVersionSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_clickwrap_with_http_info(account_id, clickwrap_id, **kwargs)
        else:
            (data) = self.update_clickwrap_with_http_info(account_id, clickwrap_id, **kwargs)
            return data

    def update_clickwrap_with_http_info(self, account_id, clickwrap_id, **kwargs):
        """
        Update a clickwrap by ID.
        Update a subset of properties on the clickwrap.  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_clickwrap_with_http_info(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param ClickwrapTransferRequest clickwrap_transfer_request: Data used to transfer a clickwrap from one user to another.
        :return: ClickwrapVersionSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id', 'clickwrap_transfer_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_clickwrap" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_clickwrap`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `update_clickwrap`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'clickwrap_transfer_request' in params:
            body_params = params['clickwrap_transfer_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapVersionSummaryResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_clickwrap_version(self, account_id, clickwrap_id, version_id, **kwargs):
        """
        Updates clickwrap version status and ownership.
        Updates the clickwrap version status and ownership by transferring from previous user ID to new user ID.  **Note:** This endpoint requires the version ID (a GUID), not the version number (an integer).  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_clickwrap_version(account_id, clickwrap_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param str version_id: The ID of the clickwrap version. (required)
        :param ClickwrapRequest clickwrap_request: Request body for working with clickwrap.
        :return: ClickwrapVersionSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_clickwrap_version_with_http_info(account_id, clickwrap_id, version_id, **kwargs)
        else:
            (data) = self.update_clickwrap_version_with_http_info(account_id, clickwrap_id, version_id, **kwargs)
            return data

    def update_clickwrap_version_with_http_info(self, account_id, clickwrap_id, version_id, **kwargs):
        """
        Updates clickwrap version status and ownership.
        Updates the clickwrap version status and ownership by transferring from previous user ID to new user ID.  **Note:** This endpoint requires the version ID (a GUID), not the version number (an integer).  [Required authentication scopes](/docs/click-api/click101/auth/): `click.manage`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_clickwrap_version_with_http_info(account_id, clickwrap_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID GUID. (required)
        :param str clickwrap_id: The ID of the clickwrap. (required)
        :param str version_id: The ID of the clickwrap version. (required)
        :param ClickwrapRequest clickwrap_request: Request body for working with clickwrap.
        :return: ClickwrapVersionSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id', 'version_id', 'clickwrap_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_clickwrap_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_clickwrap_version`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `update_clickwrap_version`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `update_clickwrap_version`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions/{versionId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'clickwrap_request' in params:
            body_params = params['clickwrap_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapVersionSummaryResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
