"""
Sketchnu has Numba implementations of sketch algorithms and other useful functions 
that utilize hash functions.

Copyright (C) 2022 Matthew Hendrey

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

"""
import numpy as np

sub_algorithm_threshold = np.array(
    [80, 220, 400, 900, 1800, 3100, 6500, 11500, 20000, 50000], dtype=np.int64
)

raw_estimate = np.array(
    [
        # Precision 7
        [
            135.67359,
            136.92574,
            138.81076,
            140.71480,
            142.62965,
            144.56475,
            145.86830,
            147.82875,
            149.81179,
            151.80804,
            153.81081,
            155.16093,
            157.20507,
            159.25388,
            161.32448,
            163.39604,
            165.48345,
            166.90168,
            169.01498,
            171.15215,
            173.29646,
            175.46343,
            176.89672,
            179.09328,
            181.28463,
            183.49510,
            185.71635,
            187.21338,
            189.47832,
            191.73335,
            194.00417,
            196.30964,
            198.62118,
            200.17085,
            202.51510,
            204.85294,
            207.20128,
            209.55431,
            211.13637,
            213.52564,
            215.92685,
            218.34082,
            220.75713,
            223.19102,
            224.81689,
            227.27468,
            229.73683,
            232.23050,
            234.70881,
            236.36208,
            238.86482,
            241.37555,
            243.90797,
            246.45148,
            248.13759,
            250.67194,
            253.21883,
            255.78219,
            258.35169,
            260.93687,
            262.67065,
            265.29218,
            267.88910,
            270.51961,
            273.14783,
            274.88126,
            277.52054,
            280.15595,
            282.81402,
            285.48741,
            287.26761,
            289.96800,
            292.63930,
            295.33024,
            298.04897,
            300.76707,
            302.58487,
            305.29375,
            308.02490,
            310.74623,
            313.46404,
            315.29618,
            318.05833,
            320.82777,
            323.59298,
            326.36986,
            329.15497,
            331.00165,
            333.77679,
            336.57423,
            339.37808,
            342.18787,
            344.06802,
            346.89343,
            349.70954,
            352.56573,
            355.39834,
            357.31726,
            360.16243,
            363.03222,
            365.88092,
            368.74226,
            371.60359,
            373.50928,
            376.38014,
            379.20729,
            382.08166,
            384.94969,
            386.85446,
            389.73554,
            392.59438,
            395.47258,
            398.38954,
            400.32852,
            403.19854,
            406.12582,
            409.05525,
            411.95727,
            414.86586,
            416.82239,
            419.71717,
            422.63711,
            425.55252,
            428.47712,
            430.43995,
            433.40316,
            436.33597,
            439.29566,
            442.19450,
            445.15151,
            447.09522,
            450.01344,
            452.95695,
            455.91177,
            458.89316,
            460.81684,
            463.75074,
            466.69036,
            469.64315,
            472.59666,
            474.55098,
            477.48583,
            480.38715,
            483.36192,
            486.31964,
            489.28669,
            491.24317,
            494.21656,
            497.18228,
            500.16690,
            503.10838,
            505.08946,
            508.07007,
            511.05757,
            514.01999,
            516.98474,
            518.97831,
            521.98485,
            524.90580,
            527.90236,
            530.89895,
            533.86819,
            535.86874,
            538.87046,
            541.79523,
            544.76827,
            547.73518,
            549.71153,
            552.70880,
            555.68860,
            558.65338,
            561.64970,
            564.67059,
            566.64599,
            569.60442,
            572.60668,
            575.58860,
            578.54984,
            580.51354,
            583.49508,
            586.45982,
            589.44712,
            592.39019,
            594.40790,
            597.41022,
            600.43003,
            603.40043,
            606.35446,
            609.37265,
            611.37513,
            614.39250,
            617.37232,
            620.35313,
            623.37829,
            625.33964,
            628.36503,
            631.34186,
            634.36009,
            637.32806,
            640.33792,
        ],
        # Precision 8
        [
            311.23928,
            314.63599,
            318.03096,
            321.48157,
            325.62079,
            329.09182,
            332.58003,
            336.80826,
            340.34417,
            343.91156,
            348.21340,
            351.81670,
            355.44368,
            359.80843,
            363.49092,
            367.16972,
            371.61165,
            375.32768,
            379.07132,
            383.57646,
            387.35144,
            391.16198,
            395.76732,
            399.61186,
            403.47863,
            408.12906,
            412.01568,
            415.92405,
            420.65273,
            424.62110,
            428.59373,
            433.39182,
            437.40990,
            441.43015,
            446.27474,
            450.34770,
            454.42728,
            459.34395,
            463.45833,
            467.58335,
            472.54657,
            476.71450,
            480.90707,
            485.94335,
            490.13082,
            494.32829,
            499.41950,
            503.65177,
            507.91174,
            513.09059,
            517.39210,
            521.69601,
            526.01833,
            531.21454,
            535.54729,
            539.89861,
            545.14606,
            549.52627,
            553.93438,
            559.23610,
            563.65192,
            568.08352,
            573.40339,
            577.87648,
            582.36035,
            587.73970,
            592.20210,
            596.72937,
            602.14936,
            606.70578,
            611.23037,
            616.67949,
            621.26318,
            625.82227,
            631.33704,
            635.89501,
            640.47231,
            646.02460,
            650.64667,
            655.26650,
            660.81363,
            665.45143,
            670.11693,
            675.67207,
            680.31325,
            685.00098,
            690.61593,
            695.29350,
            699.98420,
            705.59945,
            710.30211,
            715.01858,
            720.68548,
            725.39565,
            730.11817,
            735.82401,
            740.56813,
            745.33129,
            751.02641,
            755.81676,
            760.59288,
            765.37193,
            771.12042,
            775.88371,
            780.71548,
            786.48025,
            791.26683,
            796.11633,
            801.91881,
            806.76020,
            811.58444,
            817.37558,
            822.21761,
            827.04089,
            832.84124,
            837.71115,
            842.55083,
            848.39311,
            853.23723,
            858.12133,
            863.96546,
            868.83852,
            873.73939,
            879.58996,
            884.42434,
            889.26979,
            895.10791,
            899.99040,
            904.88679,
            910.77097,
            915.62045,
            920.52210,
            926.45467,
            931.36906,
            936.26239,
            942.18394,
            947.12828,
            952.06556,
            957.95050,
            962.84805,
            967.78603,
            973.69568,
            978.63919,
            983.57645,
            989.49200,
            994.42922,
            999.29778,
            1005.20485,
            1010.14777,
            1015.09981,
            1020.01945,
            1025.98403,
            1030.92160,
            1035.90964,
            1041.81829,
            1046.71473,
            1051.62819,
            1057.65133,
            1062.60272,
            1067.56140,
            1073.54782,
            1078.52242,
            1083.47622,
            1089.46034,
            1094.44611,
            1099.41017,
            1105.35316,
            1110.32490,
            1115.30006,
            1121.26065,
            1126.18196,
            1131.14504,
            1137.12586,
            1142.05471,
            1147.02982,
            1152.99298,
            1157.97503,
            1162.94443,
            1168.96724,
            1173.92273,
            1178.97306,
            1184.92770,
            1189.81864,
            1194.80036,
            1200.78144,
            1205.72545,
            1210.74209,
            1216.71620,
            1221.70348,
            1226.68532,
            1232.66397,
            1237.64556,
            1242.62604,
            1248.66475,
            1253.64593,
            1258.61371,
            1264.62592,
            1269.61009,
            1274.64570,
            1280.62573,
        ],
        # Precision 9
        [
            596.54394,
            603.15085,
            610.45623,
            617.80084,
            625.21010,
            632.66881,
            640.18234,
            647.05085,
            654.66449,
            662.32979,
            670.05982,
            677.83475,
            685.65321,
            693.49733,
            700.68424,
            708.64377,
            716.62401,
            724.68144,
            732.78464,
            740.92494,
            749.11606,
            756.59364,
            764.88812,
            773.20862,
            781.55248,
            789.95260,
            798.37866,
            806.86774,
            814.60328,
            823.17683,
            831.78970,
            840.43132,
            849.11546,
            857.83710,
            866.60704,
            874.62127,
            883.46496,
            892.35011,
            901.29321,
            910.26211,
            919.29203,
            928.31637,
            936.56422,
            945.65538,
            954.81180,
            963.98964,
            973.17240,
            982.41772,
            991.70061,
            1000.15710,
            1009.52037,
            1018.90397,
            1028.29311,
            1037.74692,
            1047.23020,
            1055.85243,
            1065.38780,
            1074.90044,
            1084.48202,
            1094.09957,
            1103.78521,
            1113.44217,
            1122.25321,
            1131.98374,
            1141.75686,
            1151.50779,
            1161.30704,
            1171.11591,
            1181.01792,
            1190.04714,
            1199.94057,
            1209.88501,
            1219.89388,
            1229.87791,
            1239.88743,
            1249.87101,
            1259.03763,
            1269.10556,
            1279.19187,
            1289.25693,
            1299.35875,
            1309.51800,
            1319.73387,
            1328.96346,
            1339.19503,
            1349.40689,
            1359.68852,
            1369.99885,
            1380.25560,
            1390.55404,
            1399.91570,
            1410.25631,
            1420.54224,
            1430.94593,
            1441.32315,
            1451.74055,
            1462.13016,
            1471.61330,
            1482.03871,
            1492.45418,
            1502.91042,
            1513.38496,
            1523.85817,
            1533.39685,
            1543.89032,
            1554.48736,
            1565.01937,
            1575.48963,
            1586.08910,
            1596.58983,
            1606.14372,
            1616.74495,
            1627.38086,
            1638.03417,
            1648.68093,
            1659.34340,
            1670.00268,
            1679.69912,
            1690.31775,
            1700.93386,
            1711.58951,
            1722.29232,
            1732.97913,
            1743.72184,
            1753.44750,
            1764.14549,
            1774.88854,
            1785.56620,
            1796.31359,
            1807.06344,
            1817.72936,
            1827.52740,
            1838.35553,
            1849.15341,
            1860.01134,
            1870.76432,
            1881.60635,
            1892.40009,
            1902.23756,
            1913.08244,
            1923.88645,
            1934.71596,
            1945.53224,
            1956.36778,
            1967.21927,
            1977.15931,
            1987.97460,
            1998.83302,
            2009.68703,
            2020.58916,
            2031.42354,
            2041.31262,
            2052.11977,
            2062.98344,
            2073.87787,
            2084.79366,
            2095.69858,
            2106.60664,
            2116.55692,
            2127.39958,
            2138.31016,
            2149.14203,
            2159.99299,
            2170.94973,
            2181.82084,
            2191.75745,
            2202.68106,
            2213.66543,
            2224.60428,
            2235.51677,
            2246.40866,
            2257.26024,
            2267.24914,
            2278.11180,
            2289.05668,
            2300.02878,
            2311.00123,
            2321.97981,
            2333.01058,
            2343.02465,
            2353.96855,
            2364.92040,
            2375.86624,
            2386.77865,
            2397.65609,
            2408.66360,
            2418.66240,
            2429.66076,
            2440.65193,
            2451.63216,
            2462.60821,
            2473.60385,
            2484.61274,
            2494.58873,
            2505.48469,
            2516.37425,
            2527.37218,
            2538.34828,
            2549.34986,
            2560.29244,
        ],
        # Precision 10
        [
            1260.94013,
            1275.24543,
            1289.64773,
            1304.15300,
            1318.75283,
            1334.14474,
            1348.91331,
            1363.76357,
            1378.72231,
            1393.75219,
            1409.55383,
            1424.74304,
            1440.04609,
            1455.44648,
            1470.92472,
            1487.18826,
            1502.84319,
            1518.52910,
            1534.33156,
            1550.23691,
            1566.93820,
            1583.02246,
            1599.13707,
            1615.36782,
            1631.63975,
            1648.77337,
            1665.20236,
            1681.69705,
            1698.26018,
            1714.91789,
            1732.46369,
            1749.27435,
            1766.13496,
            1783.12026,
            1800.98230,
            1818.07947,
            1835.21377,
            1852.44734,
            1869.78152,
            1887.97381,
            1905.36100,
            1922.84202,
            1940.41057,
            1958.03256,
            1976.61185,
            1994.39846,
            2012.22960,
            2030.05445,
            2047.96298,
            2066.81060,
            2084.89300,
            2102.98054,
            2121.08926,
            2139.25300,
            2158.36564,
            2176.75995,
            2195.18761,
            2213.61806,
            2232.09054,
            2251.49860,
            2270.08715,
            2288.75772,
            2307.41643,
            2326.14386,
            2345.82627,
            2364.62794,
            2383.57426,
            2402.57862,
            2422.41144,
            2441.43599,
            2460.48735,
            2479.55140,
            2498.68582,
            2518.77021,
            2537.95416,
            2557.19870,
            2576.45269,
            2595.72795,
            2616.04346,
            2635.49991,
            2654.90240,
            2674.38702,
            2693.95254,
            2714.36743,
            2733.89009,
            2753.40267,
            2773.05541,
            2792.75802,
            2813.41000,
            2833.18227,
            2853.07496,
            2872.79216,
            2892.66544,
            2913.42849,
            2933.40149,
            2953.24184,
            2973.11755,
            2993.13340,
            3014.09358,
            3034.12046,
            3054.11141,
            3074.18262,
            3095.26371,
            3115.38678,
            3135.54266,
            3155.73634,
            3175.93452,
            3197.10085,
            3217.33361,
            3237.48925,
            3257.75678,
            3277.93489,
            3299.15129,
            3319.51901,
            3339.82637,
            3360.28647,
            3380.58492,
            3401.86834,
            3422.23782,
            3442.64550,
            3463.06079,
            3483.46237,
            3504.88162,
            3525.30651,
            3545.88931,
            3566.33460,
            3586.92006,
            3608.46129,
            3628.96754,
            3649.45978,
            3669.95653,
            3690.54789,
            3712.01755,
            3732.59198,
            3753.24077,
            3773.77816,
            3795.34856,
            3815.94523,
            3836.64365,
            3857.30653,
            3877.99801,
            3899.76049,
            3920.41669,
            3941.20753,
            3961.84233,
            3982.59152,
            4004.38558,
            4025.07325,
            4045.80961,
            4066.43515,
            4087.28952,
            4109.10749,
            4129.95958,
            4150.79673,
            4171.62196,
            4192.35722,
            4214.14539,
            4235.00448,
            4255.89137,
            4276.66926,
            4297.36141,
            4319.24306,
            4340.13400,
            4360.90526,
            4381.72448,
            4402.57492,
            4424.39279,
            4445.32465,
            4466.24634,
            4487.21226,
            4509.13862,
            4530.02912,
            4550.88867,
            4571.81949,
            4592.69847,
            4614.46970,
            4635.27047,
            4656.01946,
            4676.91511,
            4697.86935,
            4719.74808,
            4740.62074,
            4761.57725,
            4782.54178,
            4803.58695,
            4825.57461,
            4846.39543,
            4867.27060,
            4888.20805,
            4909.13474,
            4931.09410,
            4952.05798,
            4973.00024,
            4993.88406,
            5014.88684,
            5036.87950,
            5057.87437,
            5078.77916,
            5099.73303,
            5121.59193,
        ],
        # Precision 11
        [
            2522.74824,
            2551.38912,
            2580.23501,
            2609.92641,
            2639.10491,
            2669.16445,
            2698.71700,
            2728.42480,
            2759.02575,
            2789.11801,
            2820.10853,
            2850.50216,
            2881.09545,
            2912.63146,
            2943.59338,
            2975.43503,
            3006.68892,
            3038.89637,
            3070.50770,
            3102.26798,
            3134.98392,
            3167.08141,
            3200.06817,
            3232.53851,
            3265.09584,
            3298.59221,
            3331.43215,
            3365.23015,
            3398.39018,
            3431.69681,
            3465.92171,
            3499.49222,
            3534.04864,
            3567.98380,
            3602.79790,
            3637.00593,
            3671.32184,
            3706.60960,
            3741.17685,
            3776.70227,
            3811.54448,
            3846.51101,
            3882.45640,
            3917.68062,
            3953.88839,
            3989.38390,
            4024.96777,
            4061.55674,
            4097.44608,
            4134.28351,
            4170.36664,
            4207.49960,
            4243.86855,
            4280.32073,
            4317.76931,
            4354.40440,
            4392.01912,
            4428.90823,
            4465.81822,
            4503.75342,
            4540.86846,
            4578.94946,
            4616.32208,
            4653.78160,
            4692.28054,
            4729.92831,
            4768.58624,
            4806.46511,
            4845.26757,
            4883.30855,
            4921.46838,
            4960.57957,
            4998.84016,
            5038.19178,
            5076.53029,
            5115.04128,
            5154.53043,
            5193.15421,
            5232.88226,
            5271.75474,
            5310.64289,
            5350.48629,
            5389.53571,
            5429.53329,
            5468.65561,
            5508.85867,
            5548.23690,
            5587.52116,
            5627.78765,
            5667.30926,
            5707.75298,
            5747.36766,
            5786.96311,
            5827.55948,
            5867.37350,
            5908.21836,
            5948.02192,
            5987.92528,
            6028.71926,
            6068.84024,
            6109.91351,
            6150.08719,
            6191.14390,
            6231.46477,
            6271.77436,
            6313.00656,
            6353.41231,
            6394.82702,
            6435.23449,
            6475.50560,
            6516.88325,
            6557.45455,
            6598.95336,
            6639.50612,
            6680.15592,
            6721.86675,
            6762.57243,
            6804.36040,
            6845.08880,
            6886.86566,
            6927.68875,
            6968.55891,
            7010.58754,
            7051.58836,
            7093.53097,
            7134.41371,
            7175.39492,
            7217.46127,
            7258.44044,
            7300.56748,
            7341.67753,
            7382.78961,
            7424.89469,
            7466.09677,
            7508.32577,
            7549.73634,
            7591.91085,
            7633.09968,
            7674.41901,
            7716.72541,
            7758.07788,
            7800.49251,
            7841.78921,
            7883.14635,
            7925.60476,
            7967.11062,
            8009.53301,
            8050.91383,
            8092.49082,
            8134.84756,
            8176.22921,
            8218.78938,
            8260.36369,
            8302.91329,
            8344.49830,
            8386.03550,
            8428.53435,
            8470.27786,
            8512.92996,
            8554.56092,
            8596.32769,
            8639.01349,
            8680.74827,
            8723.57769,
            8765.30791,
            8806.88299,
            8849.52669,
            8891.08775,
            8933.89972,
            8975.63575,
            9018.33515,
            9060.23562,
            9102.17518,
            9144.87312,
            9186.66317,
            9229.24153,
            9270.87025,
            9312.66552,
            9355.33420,
            9397.18631,
            9439.98205,
            9481.72676,
            9523.49616,
            9566.20943,
            9607.98720,
            9650.93464,
            9692.87486,
            9735.60792,
            9777.39548,
            9819.41336,
            9862.27666,
            9904.27527,
            9947.15685,
            9989.07021,
            10030.81024,
            10073.58946,
            10115.42767,
            10158.31065,
            10200.17663,
            10243.02003,
        ],
        # Precision 12
        [
            4713.43295,
            4770.45432,
            4827.87917,
            4886.40806,
            4944.63319,
            5003.24136,
            5062.96399,
            5122.35357,
            5182.19477,
            5243.09177,
            5303.61669,
            5364.53430,
            5426.59215,
            5488.31922,
            5550.39997,
            5613.58731,
            5676.43182,
            5739.67613,
            5804.02166,
            5867.94172,
            5932.28136,
            5997.63657,
            6062.66420,
            6128.06904,
            6194.47349,
            6260.55973,
            6326.93347,
            6394.41154,
            6461.47164,
            6528.99685,
            6597.47381,
            6665.59277,
            6734.06695,
            6803.62425,
            6872.63964,
            6941.94230,
            7012.42802,
            7082.47314,
            7152.69561,
            7223.99138,
            7294.80831,
            7365.90946,
            7438.09981,
            7509.89472,
            7581.86575,
            7655.00879,
            7727.67909,
            7800.56366,
            7874.55164,
            7947.95015,
            8021.65928,
            8096.38762,
            8170.59393,
            8244.92661,
            8320.51149,
            8395.33720,
            8470.55145,
            8546.72165,
            8622.44825,
            8698.36253,
            8775.31443,
            8851.66698,
            8928.23997,
            9005.94216,
            9082.92896,
            9160.14872,
            9238.50504,
            9316.15571,
            9394.00446,
            9472.83351,
            9550.96469,
            9629.29452,
            9708.72761,
            9787.33631,
            9866.34473,
            9946.29937,
            10025.62348,
            10104.98339,
            10185.53056,
            10265.36340,
            10345.34198,
            10426.38751,
            10506.70029,
            10587.09958,
            10668.72063,
            10749.53322,
            10830.44683,
            10912.51132,
            10993.62598,
            11075.00689,
            11157.33577,
            11238.95576,
            11320.64792,
            11403.36866,
            11485.33973,
            11567.56325,
            11650.72647,
            11733.20318,
            11815.60156,
            11899.17220,
            11981.86093,
            12065.66838,
            12148.58649,
            12231.60371,
            12315.49662,
            12398.81420,
            12482.05319,
            12566.41385,
            12649.86132,
            12733.34407,
            12818.17488,
            12901.95693,
            12985.87375,
            13070.89388,
            13154.82132,
            13238.80603,
            13323.87793,
            13408.12488,
            13492.50075,
            13577.84560,
            13662.30973,
            13746.80398,
            13832.47311,
            13917.01734,
            14001.68740,
            14087.46309,
            14172.23633,
            14256.94956,
            14342.77035,
            14427.87857,
            14513.02981,
            14599.10178,
            14684.19002,
            14769.40571,
            14855.54687,
            14940.77713,
            15026.25903,
            15112.54062,
            15198.00968,
            15283.61664,
            15370.23430,
            15455.97636,
            15541.67962,
            15628.43066,
            15714.26097,
            15799.92672,
            15886.57506,
            15972.33801,
            16058.38673,
            16145.46258,
            16231.48013,
            16317.38797,
            16404.42636,
            16490.44878,
            16576.81147,
            16663.90962,
            16750.05778,
            16836.22304,
            16923.28880,
            17009.50157,
            17095.79111,
            17183.12282,
            17269.36515,
            17355.78127,
            17443.10680,
            17529.49616,
            17615.84451,
            17703.28528,
            17789.68649,
            17875.98644,
            17963.43945,
            18049.91433,
            18136.62560,
            18223.96560,
            18310.45528,
            18397.04417,
            18484.45365,
            18571.04741,
            18657.66211,
            18745.21668,
            18831.70350,
            18918.46261,
            19006.00651,
            19092.68215,
            19179.40934,
            19267.07982,
            19353.89972,
            19440.36897,
            19528.10118,
            19614.69235,
            19701.27777,
            19788.85566,
            19875.56838,
            19962.38723,
            20050.18863,
            20136.63550,
            20223.36442,
            20311.22316,
            20398.01456,
            20485.77751,
        ],
        # Precision 13
        [
            9624.87154,
            9739.63382,
            9855.23818,
            9971.55701,
            10088.71311,
            10206.65364,
            10325.32308,
            10445.45795,
            10565.66786,
            10686.62822,
            10808.31894,
            10930.77592,
            11053.94383,
            11178.63151,
            11303.28521,
            11428.79370,
            11555.02401,
            11681.87106,
            11809.35524,
            11938.35365,
            12067.25602,
            12196.88922,
            12327.19269,
            12458.24528,
            12589.96189,
            12723.14762,
            12856.23428,
            12989.89907,
            13124.33411,
            13259.34939,
            13394.92741,
            13532.03336,
            13669.03280,
            13806.48434,
            13944.64724,
            14083.39388,
            14222.75510,
            14363.57849,
            14504.19244,
            14645.17777,
            14786.97546,
            14929.21980,
            15072.04482,
            15216.26081,
            15360.17245,
            15504.71764,
            15649.84485,
            15795.50923,
            15941.60896,
            16088.97658,
            16235.94577,
            16383.61730,
            16531.80401,
            16680.43599,
            16829.26349,
            16979.65759,
            17129.73644,
            17280.26036,
            17431.20218,
            17582.62530,
            17734.46579,
            17887.46836,
            18039.92695,
            18192.97207,
            18346.40857,
            18500.39321,
            18654.69152,
            18810.40625,
            18965.52821,
            19121.12370,
            19277.07721,
            19433.32025,
            19589.93651,
            19747.65549,
            19904.91898,
            20062.73792,
            20220.84835,
            20379.16906,
            20537.79089,
            20697.84753,
            20856.88986,
            21016.51215,
            21176.37187,
            21336.68845,
            21497.27387,
            21659.18025,
            21820.20266,
            21981.67235,
            22143.20932,
            22305.23820,
            22467.43102,
            22630.87040,
            22793.65941,
            22956.60022,
            23120.00843,
            23283.59299,
            23447.38967,
            23612.28990,
            23776.40113,
            23940.62387,
            24105.24797,
            24270.08852,
            24435.31608,
            24601.39494,
            24766.65723,
            24932.26994,
            25097.99156,
            25264.11301,
            25430.50157,
            25597.65007,
            25764.10242,
            25930.69278,
            26097.36862,
            26264.07007,
            26431.26778,
            26599.50421,
            26766.73326,
            26934.36017,
            27102.12800,
            27269.92594,
            27438.14401,
            27607.24283,
            27775.56642,
            27944.14869,
            28112.77366,
            28281.56183,
            28450.33609,
            28620.00916,
            28789.20875,
            28958.30545,
            29127.50474,
            29296.54720,
            29466.11531,
            29636.83468,
            29806.46224,
            29976.02511,
            30145.74395,
            30315.71062,
            30486.10292,
            30656.96488,
            30827.14139,
            30997.54427,
            31168.02183,
            31338.67618,
            31509.62299,
            31681.33077,
            31852.06956,
            32022.91126,
            32193.74870,
            32364.62841,
            32535.47906,
            32707.48964,
            32878.63984,
            33049.49939,
            33220.67357,
            33391.77712,
            33563.28113,
            33735.59371,
            33907.03237,
            34078.50079,
            34250.17586,
            34421.85397,
            34593.21625,
            34765.80784,
            34937.56049,
            35109.17753,
            35280.77753,
            35452.62537,
            35624.51009,
            35797.45634,
            35969.43472,
            36141.29058,
            36313.52109,
            36485.16340,
            36656.94976,
            36829.88496,
            37001.63666,
            37173.59192,
            37345.59497,
            37517.63094,
            37689.70297,
            37862.97152,
            38035.36113,
            38207.36548,
            38379.87983,
            38551.99192,
            38724.18151,
            38897.63120,
            39070.24400,
            39242.62893,
            39414.90126,
            39587.40097,
            39759.57577,
            39933.10554,
            40105.96927,
            40278.33320,
            40450.39742,
            40622.73455,
            40795.35932,
            40968.75035,
        ],
        # Precision 14
        [
            18274.24046,
            18501.47139,
            18730.95111,
            18962.09948,
            19194.91786,
            19429.41599,
            19665.61586,
            19903.46033,
            20142.15002,
            20383.09301,
            20625.74589,
            20869.94633,
            21115.80106,
            21363.29697,
            21612.26936,
            21862.84865,
            22114.34381,
            22367.99355,
            22623.29451,
            22880.07745,
            23138.44107,
            23398.27095,
            23659.54650,
            23921.56601,
            24185.87631,
            24451.51986,
            24718.57265,
            24986.96813,
            25256.95976,
            25528.26493,
            25800.87955,
            26074.09987,
            26349.53774,
            26626.41804,
            26904.37804,
            27183.76570,
            27464.64313,
            27746.59658,
            28029.92052,
            28313.70572,
            28599.64827,
            28886.75537,
            29175.10903,
            29464.59314,
            29755.18823,
            30047.13262,
            30339.45183,
            30633.50540,
            30928.96673,
            31225.52869,
            31523.06844,
            31821.58551,
            32121.43735,
            32422.15186,
            32722.99378,
            33025.95550,
            33329.94447,
            33634.92138,
            33940.82799,
            34247.78644,
            34555.58343,
            34864.30457,
            35173.35956,
            35483.83799,
            35795.26000,
            36107.86480,
            36421.23642,
            36735.40931,
            37050.67209,
            37365.65645,
            37682.31390,
            38000.04247,
            38318.52878,
            38637.58119,
            38957.48006,
            39278.27387,
            39599.91952,
            39921.08675,
            40244.00634,
            40567.66345,
            40892.22268,
            41217.08979,
            41542.83623,
            41869.23749,
            42196.48876,
            42523.25686,
            42851.56088,
            43180.05491,
            43509.50746,
            43839.55853,
            44170.05593,
            44501.17037,
            44831.99831,
            45164.44583,
            45497.02874,
            45830.29396,
            46164.01477,
            46498.12660,
            46832.93734,
            47168.39933,
            47503.33058,
            47839.66197,
            48176.18105,
            48513.73328,
            48851.15554,
            49189.08158,
            49527.48401,
            49866.28244,
            50204.82170,
            50544.08256,
            50884.00006,
            51224.10524,
            51564.69912,
            51905.78211,
            52247.17996,
            52587.86238,
            52929.88660,
            53272.82437,
            53615.55420,
            53958.73362,
            54302.24854,
            54646.03491,
            54989.67277,
            55332.79570,
            55677.28577,
            56021.68663,
            56366.82825,
            56711.78060,
            57057.23586,
            57402.90295,
            57748.99404,
            58094.43067,
            58440.84883,
            58787.43608,
            59134.26402,
            59481.63523,
            59828.82560,
            60176.13616,
            60523.38011,
            60871.49940,
            61219.46256,
            61567.66507,
            61915.99159,
            62264.80634,
            62613.70075,
            62963.01384,
            63310.95889,
            63659.70767,
            64009.25709,
            64358.45179,
            64708.09017,
            65057.67170,
            65407.99330,
            65757.89978,
            66106.60223,
            66457.11762,
            66807.07411,
            67157.78201,
            67508.05533,
            67858.64244,
            68209.60027,
            68559.38260,
            68910.20840,
            69260.80534,
            69611.90458,
            69963.10275,
            70314.58450,
            70665.85320,
            71017.15467,
            71368.10107,
            71719.95773,
            72071.68169,
            72423.50831,
            72775.15686,
            73126.80983,
            73478.86494,
            73830.57792,
            74181.64060,
            74533.55006,
            74885.84372,
            75238.12349,
            75590.50399,
            75942.93566,
            76295.13464,
            76646.59576,
            76999.30043,
            77351.66566,
            77704.11213,
            78057.01509,
            78409.65202,
            78762.61472,
            79115.69773,
            79467.73329,
            79821.19789,
            80173.91467,
            80527.19584,
            80880.30620,
            81233.19742,
            81586.23304,
            81939.56665,
        ],
        # Precision 15
        [
            34656.23943,
            35106.32041,
            35560.43108,
            36018.04442,
            36479.35519,
            36944.10022,
            37411.90047,
            37883.64564,
            38358.86711,
            38837.52017,
            39319.63216,
            39804.67165,
            40293.71707,
            40786.15265,
            41281.79562,
            41780.68556,
            42283.06359,
            42787.99411,
            43296.88907,
            43809.17192,
            44324.62428,
            44843.38556,
            45364.44421,
            45889.56910,
            46417.87628,
            46949.34656,
            47483.78047,
            48020.54115,
            48561.15895,
            49104.56829,
            49651.02372,
            50200.56744,
            50752.93454,
            51307.70513,
            51865.93960,
            52427.07789,
            52991.00736,
            53557.69800,
            54126.41062,
            54698.70242,
            55273.57661,
            55851.11725,
            56431.53236,
            57014.18009,
            57598.68339,
            58186.73179,
            58777.01266,
            59370.13583,
            59965.84085,
            60563.02241,
            61163.29826,
            61766.10168,
            62370.96418,
            62978.29574,
            63586.70314,
            64198.40934,
            64812.81756,
            65429.27824,
            66047.80626,
            66668.71901,
            67290.64320,
            67915.62942,
            68542.37616,
            69171.30310,
            69802.06189,
            70433.98172,
            71068.77747,
            71705.31106,
            72343.84977,
            72984.40806,
            73625.63837,
            74269.68118,
            74915.32305,
            75562.73301,
            76212.04123,
            76863.05460,
            77514.40880,
            78168.53446,
            78824.04091,
            79481.40226,
            80139.77560,
            80798.82290,
            81460.49369,
            82123.57648,
            82788.21753,
            83454.14973,
            84121.51909,
            84789.14348,
            85458.97308,
            86130.22313,
            86803.13930,
            87476.74144,
            88151.13521,
            88826.88216,
            89504.12934,
            90182.76427,
            90862.31059,
            91541.91712,
            92223.81709,
            92906.67895,
            93590.47560,
            94275.26130,
            94961.27344,
            95647.22631,
            96335.06126,
            97023.55087,
            97713.10715,
            98403.63762,
            99094.09273,
            99786.21731,
            100479.33384,
            101173.46872,
            101868.07994,
            102562.23191,
            103258.55060,
            103955.48497,
            104652.94575,
            105351.15186,
            106049.80572,
            106748.21497,
            107448.42677,
            108149.21098,
            108850.28969,
            109552.35900,
            110254.34439,
            110957.60548,
            111661.52956,
            112365.73746,
            113070.43044,
            113776.13300,
            114480.81543,
            115187.80739,
            115895.16970,
            116602.43442,
            117310.73608,
            118018.44353,
            118726.85104,
            119436.09076,
            120145.66827,
            120855.77690,
            121565.27060,
            122275.63095,
            122987.74540,
            123698.86505,
            124410.23485,
            125122.42880,
            125833.62955,
            126545.97126,
            127259.12773,
            127972.26129,
            128686.64137,
            129399.51904,
            130114.59089,
            130828.96844,
            131543.53435,
            132257.96155,
            132972.39173,
            133688.21848,
            134404.23823,
            135120.69867,
            135836.79841,
            136553.51125,
            137269.41358,
            137986.53954,
            138703.22252,
            139419.94686,
            140137.02886,
            140853.53850,
            141570.75240,
            142288.61370,
            143007.00799,
            143725.66681,
            144444.35834,
            145161.82324,
            145880.79049,
            146599.55264,
            147318.15250,
            148036.75341,
            148755.31226,
            149475.15538,
            150194.51421,
            150914.44084,
            151633.60702,
            152352.13311,
            153071.93485,
            153791.70931,
            154512.43355,
            155232.07891,
            155952.48302,
            156671.67955,
            157392.57141,
            158113.67282,
            158834.70397,
            159555.75565,
            160274.93036,
            160996.20568,
            161717.83059,
            162439.37818,
            163160.56229,
            163881.34087,
        ],
        # Precision 16
        [
            75690.02942,
            76606.38777,
            77529.31447,
            78459.19407,
            79394.96439,
            80336.76699,
            81285.65472,
            82240.09199,
            83201.45264,
            84168.32314,
            85141.37836,
            86121.28912,
            87106.71240,
            88098.18169,
            89095.99377,
            90099.58880,
            91109.55091,
            92124.65399,
            93145.37803,
            94172.95111,
            95205.65636,
            96243.86742,
            97288.50943,
            98337.76486,
            99393.47248,
            100454.04430,
            101519.95578,
            102592.08547,
            103669.06532,
            104751.11230,
            105839.28778,
            106932.22970,
            108030.64475,
            109133.60393,
            110241.63512,
            111355.49953,
            112473.49248,
            113596.06498,
            114724.73873,
            115857.50425,
            116995.68609,
            118137.42562,
            119284.08069,
            120436.19487,
            121591.55997,
            122751.83181,
            123917.51786,
            125086.52128,
            126260.54623,
            127438.21676,
            128619.87801,
            129806.63304,
            130996.65312,
            132190.30236,
            133388.90295,
            134590.74928,
            135797.67352,
            137006.89053,
            138219.84342,
            139437.89091,
            140658.41867,
            141882.85775,
            143111.05033,
            144342.37369,
            145577.72794,
            146815.35063,
            148056.20408,
            149301.77370,
            150549.88577,
            151801.79093,
            153056.40035,
            154313.73415,
            155574.29901,
            156837.93328,
            158104.26957,
            159373.99777,
            160645.95408,
            161921.39173,
            163199.00058,
            164479.00022,
            165763.09262,
            167047.93940,
            168335.46479,
            169626.73453,
            170918.89250,
            172214.52867,
            173511.99540,
            174812.09509,
            176114.78895,
            177419.75961,
            178726.33783,
            180035.98549,
            181346.91252,
            182660.90660,
            183975.84795,
            185292.89113,
            186612.10699,
            187932.79382,
            189255.73313,
            190580.85788,
            191906.43655,
            193235.05030,
            194565.02003,
            195895.97247,
            197229.24277,
            198563.85129,
            199899.97749,
            201238.51453,
            202577.42814,
            203918.49545,
            205261.09549,
            206604.15850,
            207949.19660,
            209294.97052,
            210641.92457,
            211991.17760,
            213340.62615,
            214692.64690,
            216044.32842,
            217396.35725,
            218751.85416,
            220106.90479,
            221463.68861,
            222822.00159,
            224181.09762,
            225542.76525,
            226902.76213,
            228264.07569,
            229628.23463,
            230991.79360,
            232355.88754,
            233721.33869,
            235086.71909,
            236454.81846,
            237822.09524,
            239190.46419,
            240561.20285,
            241931.34309,
            243302.77950,
            244674.49281,
            246046.30817,
            247420.59580,
            248794.33394,
            250168.82984,
            251544.40260,
            252919.76020,
            254296.91470,
            255674.18434,
            257051.82169,
            258429.98717,
            259808.38026,
            261186.59483,
            262567.02749,
            263946.00496,
            265327.59224,
            266707.90939,
            268088.48716,
            269469.95162,
            270851.62085,
            272233.10669,
            273616.66959,
            274999.29618,
            276383.89055,
            277768.01579,
            279151.66392,
            280537.69522,
            281922.51346,
            283307.67263,
            284694.05454,
            286078.47861,
            287464.39638,
            288850.24939,
            290236.84620,
            291624.26335,
            293010.50176,
            294398.57053,
            295787.20608,
            297175.22938,
            298564.59624,
            299952.31205,
            301340.49775,
            302729.11528,
            304117.44550,
            305506.09312,
            306895.83186,
            308284.74134,
            309674.10756,
            311063.31088,
            312453.43548,
            313844.64881,
            315235.17153,
            316625.53473,
            318017.69566,
            319408.61404,
            320801.04620,
            322192.36304,
            323582.86818,
            324974.69871,
            326365.59519,
            327757.29623,
        ],
    ]
)

bias_data = np.array(
    [
        # Precision 7
        [
            55.67359,
            54.92574,
            53.81076,
            52.71480,
            51.62965,
            50.56475,
            49.86830,
            48.82875,
            47.81179,
            46.80804,
            45.81081,
            45.16093,
            44.20507,
            43.25388,
            42.32448,
            41.39604,
            40.48345,
            39.90168,
            39.01498,
            38.15215,
            37.29646,
            36.46343,
            35.89672,
            35.09328,
            34.28463,
            33.49510,
            32.71635,
            32.21338,
            31.47832,
            30.73335,
            30.00417,
            29.30964,
            28.62118,
            28.17085,
            27.51510,
            26.85294,
            26.20128,
            25.55431,
            25.13637,
            24.52564,
            23.92685,
            23.34082,
            22.75713,
            22.19102,
            21.81689,
            21.27468,
            20.73683,
            20.23050,
            19.70881,
            19.36208,
            18.86482,
            18.37555,
            17.90797,
            17.45148,
            17.13759,
            16.67194,
            16.21883,
            15.78219,
            15.35169,
            14.93687,
            14.67065,
            14.29218,
            13.88910,
            13.51961,
            13.14783,
            12.88126,
            12.52054,
            12.15595,
            11.81402,
            11.48741,
            11.26761,
            10.96800,
            10.63930,
            10.33024,
            10.04897,
            9.76707,
            9.58487,
            9.29375,
            9.02490,
            8.74623,
            8.46404,
            8.29618,
            8.05833,
            7.82777,
            7.59298,
            7.36986,
            7.15497,
            7.00165,
            6.77679,
            6.57423,
            6.37808,
            6.18787,
            6.06802,
            5.89343,
            5.70954,
            5.56573,
            5.39834,
            5.31726,
            5.16243,
            5.03222,
            4.88092,
            4.74226,
            4.60359,
            4.50928,
            4.38014,
            4.20729,
            4.08166,
            3.94969,
            3.85446,
            3.73554,
            3.59438,
            3.47258,
            3.38954,
            3.32852,
            3.19854,
            3.12582,
            3.05525,
            2.95727,
            2.86586,
            2.82239,
            2.71717,
            2.63711,
            2.55252,
            2.47712,
            2.43995,
            2.40316,
            2.33597,
            2.29566,
            2.19450,
            2.15151,
            2.09522,
            2.01344,
            1.95695,
            1.91177,
            1.89316,
            1.81684,
            1.75074,
            1.69036,
            1.64315,
            1.59666,
            1.55098,
            1.48583,
            1.38715,
            1.36192,
            1.31964,
            1.28669,
            1.24317,
            1.21656,
            1.18228,
            1.16690,
            1.10838,
            1.08946,
            1.07007,
            1.05757,
            1.01999,
            0.98474,
            0.97831,
            0.98485,
            0.90580,
            0.90236,
            0.89895,
            0.86819,
            0.86874,
            0.87046,
            0.79523,
            0.76827,
            0.73518,
            0.71153,
            0.70880,
            0.68860,
            0.65338,
            0.64970,
            0.67059,
            0.64599,
            0.60442,
            0.60668,
            0.58860,
            0.54984,
            0.51354,
            0.49508,
            0.45982,
            0.44712,
            0.39019,
            0.40790,
            0.41022,
            0.43003,
            0.40043,
            0.35446,
            0.37265,
            0.37513,
            0.39250,
            0.37232,
            0.35313,
            0.37829,
            0.33964,
            0.36503,
            0.34186,
            0.36009,
            0.32806,
            0.33792,
        ],
        # Precision 8
        [
            91.23928,
            89.63599,
            88.03096,
            86.48157,
            84.62079,
            83.09182,
            81.58003,
            79.80826,
            78.34417,
            76.91156,
            75.21340,
            73.81670,
            72.44368,
            70.80843,
            69.49092,
            68.16972,
            66.61165,
            65.32768,
            64.07132,
            62.57646,
            61.35144,
            60.16198,
            58.76732,
            57.61186,
            56.47863,
            55.12906,
            54.01568,
            52.92405,
            51.65273,
            50.62110,
            49.59373,
            48.39182,
            47.40990,
            46.43015,
            45.27474,
            44.34770,
            43.42728,
            42.34395,
            41.45833,
            40.58335,
            39.54657,
            38.71450,
            37.90707,
            36.94335,
            36.13082,
            35.32829,
            34.41950,
            33.65177,
            32.91174,
            32.09059,
            31.39210,
            30.69601,
            30.01833,
            29.21454,
            28.54729,
            27.89861,
            27.14606,
            26.52627,
            25.93438,
            25.23610,
            24.65192,
            24.08352,
            23.40339,
            22.87648,
            22.36035,
            21.73970,
            21.20210,
            20.72937,
            20.14936,
            19.70578,
            19.23037,
            18.67949,
            18.26318,
            17.82227,
            17.33704,
            16.89501,
            16.47231,
            16.02460,
            15.64667,
            15.26650,
            14.81363,
            14.45143,
            14.11693,
            13.67207,
            13.31325,
            13.00098,
            12.61593,
            12.29350,
            11.98420,
            11.59945,
            11.30211,
            11.01858,
            10.68548,
            10.39565,
            10.11817,
            9.82401,
            9.56813,
            9.33129,
            9.02641,
            8.81676,
            8.59288,
            8.37193,
            8.12042,
            7.88371,
            7.71548,
            7.48025,
            7.26683,
            7.11633,
            6.91881,
            6.76020,
            6.58444,
            6.37558,
            6.21761,
            6.04089,
            5.84124,
            5.71115,
            5.55083,
            5.39311,
            5.23723,
            5.12133,
            4.96546,
            4.83852,
            4.73939,
            4.58996,
            4.42434,
            4.26979,
            4.10791,
            3.99040,
            3.88679,
            3.77097,
            3.62045,
            3.52210,
            3.45467,
            3.36906,
            3.26239,
            3.18394,
            3.12828,
            3.06556,
            2.95050,
            2.84805,
            2.78603,
            2.69568,
            2.63919,
            2.57645,
            2.49200,
            2.42922,
            2.29778,
            2.20485,
            2.14777,
            2.09981,
            2.01945,
            1.98403,
            1.92160,
            1.90964,
            1.81829,
            1.71473,
            1.62819,
            1.65133,
            1.60272,
            1.56140,
            1.54782,
            1.52242,
            1.47622,
            1.46034,
            1.44611,
            1.41017,
            1.35316,
            1.32490,
            1.30006,
            1.26065,
            1.18196,
            1.14504,
            1.12586,
            1.05471,
            1.02982,
            0.99298,
            0.97503,
            0.94443,
            0.96724,
            0.92273,
            0.97306,
            0.92770,
            0.81864,
            0.80036,
            0.78144,
            0.72545,
            0.74209,
            0.71620,
            0.70348,
            0.68532,
            0.66397,
            0.64556,
            0.62604,
            0.66475,
            0.64593,
            0.61371,
            0.62592,
            0.61009,
            0.64570,
            0.62573,
        ],
        # Precision 9
        [
            196.54394,
            193.15085,
            189.45623,
            185.80084,
            182.21010,
            178.66881,
            175.18234,
            172.05085,
            168.66449,
            165.32979,
            162.05982,
            158.83475,
            155.65321,
            152.49733,
            149.68424,
            146.64377,
            143.62401,
            140.68144,
            137.78464,
            134.92494,
            132.11606,
            129.59364,
            126.88812,
            124.20862,
            121.55248,
            118.95260,
            116.37866,
            113.86774,
            111.60328,
            109.17683,
            106.78970,
            104.43132,
            102.11546,
            99.83710,
            97.60704,
            95.62127,
            93.46496,
            91.35011,
            89.29321,
            87.26211,
            85.29203,
            83.31637,
            81.56422,
            79.65538,
            77.81180,
            75.98964,
            74.17240,
            72.41772,
            70.70061,
            69.15710,
            67.52037,
            65.90397,
            64.29311,
            62.74692,
            61.23020,
            59.85243,
            58.38780,
            56.90044,
            55.48202,
            54.09957,
            52.78521,
            51.44217,
            50.25321,
            48.98374,
            47.75686,
            46.50779,
            45.30704,
            44.11591,
            43.01792,
            42.04714,
            40.94057,
            39.88501,
            38.89388,
            37.87791,
            36.88743,
            35.87101,
            35.03763,
            34.10556,
            33.19187,
            32.25693,
            31.35875,
            30.51800,
            29.73387,
            28.96346,
            28.19503,
            27.40689,
            26.68852,
            25.99885,
            25.25560,
            24.55404,
            23.91570,
            23.25631,
            22.54224,
            21.94593,
            21.32315,
            20.74055,
            20.13016,
            19.61330,
            19.03871,
            18.45418,
            17.91042,
            17.38496,
            16.85817,
            16.39685,
            15.89032,
            15.48736,
            15.01937,
            14.48963,
            14.08910,
            13.58983,
            13.14372,
            12.74495,
            12.38086,
            12.03417,
            11.68093,
            11.34340,
            11.00268,
            10.69912,
            10.31775,
            9.93386,
            9.58951,
            9.29232,
            8.97913,
            8.72184,
            8.44750,
            8.14549,
            7.88854,
            7.56620,
            7.31359,
            7.06344,
            6.72936,
            6.52740,
            6.35553,
            6.15341,
            6.01134,
            5.76432,
            5.60635,
            5.40009,
            5.23756,
            5.08244,
            4.88645,
            4.71596,
            4.53224,
            4.36778,
            4.21927,
            4.15931,
            3.97460,
            3.83302,
            3.68703,
            3.58916,
            3.42354,
            3.31262,
            3.11977,
            2.98344,
            2.87787,
            2.79366,
            2.69858,
            2.60664,
            2.55692,
            2.39958,
            2.31016,
            2.14203,
            1.99299,
            1.94973,
            1.82084,
            1.75745,
            1.68106,
            1.66543,
            1.60428,
            1.51677,
            1.40866,
            1.26024,
            1.24914,
            1.11180,
            1.05668,
            1.02878,
            1.00123,
            0.97981,
            1.01058,
            1.02465,
            0.96855,
            0.92040,
            0.86624,
            0.77865,
            0.65609,
            0.66360,
            0.66240,
            0.66076,
            0.65193,
            0.63216,
            0.60821,
            0.60385,
            0.61274,
            0.58873,
            0.48469,
            0.37425,
            0.37218,
            0.34828,
            0.34986,
            0.29244,
        ],
        # Precision 10
        [
            360.94013,
            354.24543,
            347.64773,
            341.15300,
            334.75283,
            328.14474,
            321.91331,
            315.76357,
            309.72231,
            303.75219,
            297.55383,
            291.74304,
            286.04609,
            280.44648,
            274.92472,
            269.18826,
            263.84319,
            258.52910,
            253.33156,
            248.23691,
            242.93820,
            238.02246,
            233.13707,
            228.36782,
            223.63975,
            218.77337,
            214.20236,
            209.69705,
            205.26018,
            200.91789,
            196.46369,
            192.27435,
            188.13496,
            184.12026,
            179.98230,
            176.07947,
            172.21377,
            168.44734,
            164.78152,
            160.97381,
            157.36100,
            153.84202,
            150.41057,
            147.03256,
            143.61185,
            140.39846,
            137.22960,
            134.05445,
            130.96298,
            127.81060,
            124.89300,
            121.98054,
            119.08926,
            116.25300,
            113.36564,
            110.75995,
            108.18761,
            105.61806,
            103.09054,
            100.49860,
            98.08715,
            95.75772,
            93.41643,
            91.14386,
            88.82627,
            86.62794,
            84.57426,
            82.57862,
            80.41144,
            78.43599,
            76.48735,
            74.55140,
            72.68582,
            70.77021,
            68.95416,
            67.19870,
            65.45269,
            63.72795,
            62.04346,
            60.49991,
            58.90240,
            57.38702,
            55.95254,
            54.36743,
            52.89009,
            51.40267,
            50.05541,
            48.75802,
            47.41000,
            46.18227,
            45.07496,
            43.79216,
            42.66544,
            41.42849,
            40.40149,
            39.24184,
            38.11755,
            37.13340,
            36.09358,
            35.12046,
            34.11141,
            33.18262,
            32.26371,
            31.38678,
            30.54266,
            29.73634,
            28.93452,
            28.10085,
            27.33361,
            26.48925,
            25.75678,
            24.93489,
            24.15129,
            23.51901,
            22.82637,
            22.28647,
            21.58492,
            20.86834,
            20.23782,
            19.64550,
            19.06079,
            18.46237,
            17.88162,
            17.30651,
            16.88931,
            16.33460,
            15.92006,
            15.46129,
            14.96754,
            14.45978,
            13.95653,
            13.54789,
            13.01755,
            12.59198,
            12.24077,
            11.77816,
            11.34856,
            10.94523,
            10.64365,
            10.30653,
            9.99801,
            9.76049,
            9.41669,
            9.20753,
            8.84233,
            8.59152,
            8.38558,
            8.07325,
            7.80961,
            7.43515,
            7.28952,
            7.10749,
            6.95958,
            6.79673,
            6.62196,
            6.35722,
            6.14539,
            6.00448,
            5.89137,
            5.66926,
            5.36141,
            5.24306,
            5.13400,
            4.90526,
            4.72448,
            4.57492,
            4.39279,
            4.32465,
            4.24634,
            4.21226,
            4.13862,
            4.02912,
            3.88867,
            3.81949,
            3.69847,
            3.46970,
            3.27047,
            3.01946,
            2.91511,
            2.86935,
            2.74808,
            2.62074,
            2.57725,
            2.54178,
            2.58695,
            2.57461,
            2.39543,
            2.27060,
            2.20805,
            2.13474,
            2.09410,
            2.05798,
            2.00024,
            1.88406,
            1.88684,
            1.87950,
            1.87437,
            1.77916,
            1.73303,
            1.59193,
        ],
        # Precision 11
        [
            722.74824,
            709.38912,
            696.23501,
            682.92641,
            670.10491,
            657.16445,
            644.71700,
            632.42480,
            620.02575,
            608.11801,
            596.10853,
            584.50216,
            573.09545,
            561.63146,
            550.59338,
            539.43503,
            528.68892,
            517.89637,
            507.50770,
            497.26798,
            486.98392,
            477.08141,
            467.06817,
            457.53851,
            448.09584,
            438.59221,
            429.43215,
            420.23015,
            411.39018,
            402.69681,
            393.92171,
            385.49222,
            377.04864,
            368.98380,
            360.79790,
            353.00593,
            345.32184,
            337.60960,
            330.17685,
            322.70227,
            315.54448,
            308.51101,
            301.45640,
            294.68062,
            287.88839,
            281.38390,
            274.96777,
            268.55674,
            262.44608,
            256.28351,
            250.36664,
            244.49960,
            238.86855,
            233.32073,
            227.76931,
            222.40440,
            217.01912,
            211.90823,
            206.81822,
            201.75342,
            196.86846,
            191.94946,
            187.32208,
            182.78160,
            178.28054,
            173.92831,
            169.58624,
            165.46511,
            161.26757,
            157.30855,
            153.46838,
            149.57957,
            145.84016,
            142.19178,
            138.53029,
            135.04128,
            131.53043,
            128.15421,
            124.88226,
            121.75474,
            118.64289,
            115.48629,
            112.53571,
            109.53329,
            106.65561,
            103.85867,
            101.23690,
            98.52116,
            95.78765,
            93.30926,
            90.75298,
            88.36766,
            85.96311,
            83.55948,
            81.37350,
            79.21836,
            77.02192,
            74.92528,
            72.71926,
            70.84024,
            68.91351,
            67.08719,
            65.14390,
            63.46477,
            61.77436,
            60.00656,
            58.41231,
            56.82702,
            55.23449,
            53.50560,
            51.88325,
            50.45455,
            48.95336,
            47.50612,
            46.15592,
            44.86675,
            43.57243,
            42.36040,
            41.08880,
            39.86566,
            38.68875,
            37.55891,
            36.58754,
            35.58836,
            34.53097,
            33.41371,
            32.39492,
            31.46127,
            30.44044,
            29.56748,
            28.67753,
            27.78961,
            26.89469,
            26.09677,
            25.32577,
            24.73634,
            23.91085,
            23.09968,
            22.41901,
            21.72541,
            21.07788,
            20.49251,
            19.78921,
            19.14635,
            18.60476,
            18.11062,
            17.53301,
            16.91383,
            16.49082,
            15.84756,
            15.22921,
            14.78938,
            14.36369,
            13.91329,
            13.49830,
            13.03550,
            12.53435,
            12.27786,
            11.92996,
            11.56092,
            11.32769,
            11.01349,
            10.74827,
            10.57769,
            10.30791,
            9.88299,
            9.52669,
            9.08775,
            8.89972,
            8.63575,
            8.33515,
            8.23562,
            8.17518,
            7.87312,
            7.66317,
            7.24153,
            6.87025,
            6.66552,
            6.33420,
            6.18631,
            5.98205,
            5.72676,
            5.49616,
            5.20943,
            4.98720,
            4.93464,
            4.87486,
            4.60792,
            4.39548,
            4.41336,
            4.27666,
            4.27527,
            4.15685,
            4.07021,
            3.81024,
            3.58946,
            3.42767,
            3.31065,
            3.17663,
            3.02003,
        ],
        # Precision 12
        [
            1613.43295,
            1583.45432,
            1553.87917,
            1524.40806,
            1495.63319,
            1467.24136,
            1438.96399,
            1411.35357,
            1384.19477,
            1357.09177,
            1330.61669,
            1304.53430,
            1278.59215,
            1253.31922,
            1228.39997,
            1203.58731,
            1179.43182,
            1155.67613,
            1132.02166,
            1108.94172,
            1086.28136,
            1063.63657,
            1041.66420,
            1020.06904,
            998.47349,
            977.55973,
            956.93347,
            936.41154,
            916.47164,
            896.99685,
            877.47381,
            858.59277,
            840.06695,
            821.62425,
            803.63964,
            785.94230,
            768.42802,
            751.47314,
            734.69561,
            717.99138,
            701.80831,
            685.90946,
            670.09981,
            654.89472,
            639.86575,
            625.00879,
            610.67909,
            596.56366,
            582.55164,
            568.95015,
            555.65928,
            542.38762,
            529.59393,
            516.92661,
            504.51149,
            492.33720,
            480.55145,
            468.72165,
            457.44825,
            446.36253,
            435.31443,
            424.66698,
            414.23997,
            403.94216,
            393.92896,
            384.14872,
            374.50504,
            365.15571,
            356.00446,
            346.83351,
            337.96469,
            329.29452,
            320.72761,
            312.33631,
            304.34473,
            296.29937,
            288.62348,
            280.98339,
            273.53056,
            266.36340,
            259.34198,
            252.38751,
            245.70029,
            239.09958,
            232.72063,
            226.53322,
            220.44683,
            214.51132,
            208.62598,
            203.00689,
            197.33577,
            191.95576,
            186.64792,
            181.36866,
            176.33973,
            171.56325,
            166.72647,
            162.20318,
            157.60156,
            153.17220,
            148.86093,
            144.66838,
            140.58649,
            136.60371,
            132.49662,
            128.81420,
            125.05319,
            121.41385,
            117.86132,
            114.34407,
            111.17488,
            107.95693,
            104.87375,
            101.89388,
            98.82132,
            95.80603,
            92.87793,
            90.12488,
            87.50075,
            84.84560,
            82.30973,
            79.80398,
            77.47311,
            75.01734,
            72.68740,
            70.46309,
            68.23633,
            65.94956,
            63.77035,
            61.87857,
            60.02981,
            58.10178,
            56.19002,
            54.40571,
            52.54687,
            50.77713,
            49.25903,
            47.54062,
            46.00968,
            44.61664,
            43.23430,
            41.97636,
            40.67962,
            39.43066,
            38.26097,
            36.92672,
            35.57506,
            34.33801,
            33.38673,
            32.46258,
            31.48013,
            30.38797,
            29.42636,
            28.44878,
            27.81147,
            26.90962,
            26.05778,
            25.22304,
            24.28880,
            23.50157,
            22.79111,
            22.12282,
            21.36515,
            20.78127,
            20.10680,
            19.49616,
            18.84451,
            18.28528,
            17.68649,
            16.98644,
            16.43945,
            15.91433,
            15.62560,
            14.96560,
            14.45528,
            14.04417,
            13.45365,
            13.04741,
            12.66211,
            12.21668,
            11.70350,
            11.46261,
            11.00651,
            10.68215,
            10.40934,
            10.07982,
            9.89972,
            9.36897,
            9.10118,
            8.69235,
            8.27777,
            7.85566,
            7.56838,
            7.38723,
            7.18863,
            6.63550,
            6.36442,
            6.22316,
            6.01456,
            5.77751,
        ],
        # Precision 13
        [
            3124.87154,
            3066.63382,
            3009.23818,
            2952.55701,
            2896.71311,
            2841.65364,
            2787.32308,
            2733.45795,
            2680.66786,
            2628.62822,
            2577.31894,
            2526.77592,
            2476.94383,
            2427.63151,
            2379.28521,
            2331.79370,
            2285.02401,
            2238.87106,
            2193.35524,
            2148.35365,
            2104.25602,
            2060.88922,
            2018.19269,
            1976.24528,
            1934.96189,
            1894.14762,
            1854.23428,
            1814.89907,
            1776.33411,
            1738.34939,
            1700.92741,
            1664.03336,
            1628.03280,
            1592.48434,
            1557.64724,
            1523.39388,
            1489.75510,
            1456.57849,
            1424.19244,
            1392.17777,
            1360.97546,
            1330.21980,
            1300.04482,
            1270.26081,
            1241.17245,
            1212.71764,
            1184.84485,
            1157.50923,
            1130.60896,
            1103.97658,
            1077.94577,
            1052.61730,
            1027.80401,
            1003.43599,
            979.26349,
            955.65759,
            932.73644,
            910.26036,
            888.20218,
            866.62530,
            845.46579,
            824.46836,
            803.92695,
            783.97207,
            764.40857,
            745.39321,
            726.69152,
            708.40625,
            690.52821,
            673.12370,
            656.07721,
            639.32025,
            622.93651,
            606.65549,
            590.91898,
            575.73792,
            560.84835,
            546.16906,
            531.79089,
            517.84753,
            503.88986,
            490.51215,
            477.37187,
            464.68845,
            452.27387,
            440.18025,
            428.20266,
            416.67235,
            405.20932,
            394.23820,
            383.43102,
            372.87040,
            362.65941,
            352.60022,
            343.00843,
            333.59299,
            324.38967,
            315.28990,
            306.40113,
            297.62387,
            289.24797,
            281.08852,
            273.31608,
            265.39494,
            257.65723,
            250.26994,
            242.99156,
            236.11301,
            229.50157,
            222.65007,
            216.10242,
            209.69278,
            203.36862,
            197.07007,
            191.26778,
            185.50421,
            179.73326,
            174.36017,
            169.12800,
            163.92594,
            159.14401,
            154.24283,
            149.56642,
            145.14869,
            140.77366,
            136.56183,
            132.33609,
            128.00916,
            124.20875,
            120.30545,
            116.50474,
            112.54720,
            109.11531,
            105.83468,
            102.46224,
            99.02511,
            95.74395,
            92.71062,
            90.10292,
            86.96488,
            84.14139,
            81.54427,
            79.02183,
            76.67618,
            74.62299,
            72.33077,
            70.06956,
            67.91126,
            65.74870,
            63.62841,
            61.47906,
            59.48964,
            57.63984,
            55.49939,
            53.67357,
            51.77712,
            50.28113,
            48.59371,
            47.03237,
            45.50079,
            44.17586,
            42.85397,
            41.21625,
            39.80784,
            38.56049,
            37.17753,
            35.77753,
            34.62537,
            33.51009,
            32.45634,
            31.43472,
            30.29058,
            29.52109,
            28.16340,
            26.94976,
            25.88496,
            24.63666,
            23.59192,
            22.59497,
            21.63094,
            20.70297,
            19.97152,
            19.36113,
            18.36548,
            17.87983,
            16.99192,
            16.18151,
            15.63120,
            15.24400,
            14.62893,
            13.90126,
            13.40097,
            12.57577,
            12.10554,
            11.96927,
            11.33320,
            10.39742,
            9.73455,
            9.35932,
            8.75035,
        ],
        # Precision 14
        [
            6774.24046,
            6648.47139,
            6523.95111,
            6401.09948,
            6279.91786,
            6160.41599,
            6042.61586,
            5926.46033,
            5812.15002,
            5699.09301,
            5587.74589,
            5477.94633,
            5369.80106,
            5263.29697,
            5158.26936,
            5054.84865,
            4953.34381,
            4852.99355,
            4754.29451,
            4657.07745,
            4561.44107,
            4467.27095,
            4374.54650,
            4283.56601,
            4193.87631,
            4105.51986,
            4018.57265,
            3932.96813,
            3848.95976,
            3766.26493,
            3684.87955,
            3605.09987,
            3526.53774,
            3449.41804,
            3373.37804,
            3298.76570,
            3225.64313,
            3153.59658,
            3082.92052,
            3013.70572,
            2945.64827,
            2878.75537,
            2813.10903,
            2748.59314,
            2685.18823,
            2623.13262,
            2562.45183,
            2502.50540,
            2443.96673,
            2386.52869,
            2330.06844,
            2274.58551,
            2220.43735,
            2167.15186,
            2114.99378,
            2063.95550,
            2013.94447,
            1964.92138,
            1916.82799,
            1869.78644,
            1823.58343,
            1778.30457,
            1734.35956,
            1690.83799,
            1648.26000,
            1606.86480,
            1566.23642,
            1526.40931,
            1487.67209,
            1449.65645,
            1412.31390,
            1376.04247,
            1340.52878,
            1305.58119,
            1271.48006,
            1238.27387,
            1205.91952,
            1174.08675,
            1143.00634,
            1112.66345,
            1083.22268,
            1054.08979,
            1025.83623,
            998.23749,
            971.48876,
            945.25686,
            919.56088,
            894.05491,
            869.50746,
            845.55853,
            822.05593,
            799.17037,
            776.99831,
            755.44583,
            734.02874,
            713.29396,
            693.01477,
            673.12660,
            653.93734,
            635.39933,
            617.33058,
            599.66197,
            582.18105,
            565.73328,
            549.15554,
            533.08158,
            517.48401,
            502.28244,
            487.82170,
            473.08256,
            459.00006,
            445.10524,
            431.69912,
            418.78211,
            406.17996,
            393.86238,
            381.88660,
            370.82437,
            359.55420,
            348.73362,
            338.24854,
            328.03491,
            317.67277,
            307.79570,
            298.28577,
            288.68663,
            279.82825,
            270.78060,
            262.23586,
            253.90295,
            245.99404,
            238.43067,
            230.84883,
            223.43608,
            216.26402,
            209.63523,
            202.82560,
            196.13616,
            190.38011,
            184.49940,
            178.46256,
            172.66507,
            166.99159,
            161.80634,
            156.70075,
            152.01384,
            146.95889,
            141.70767,
            137.25709,
            132.45179,
            128.09017,
            123.67170,
            119.99330,
            115.89978,
            111.60223,
            108.11762,
            104.07411,
            100.78201,
            97.05533,
            93.64244,
            90.60027,
            87.38260,
            84.20840,
            80.80534,
            77.90458,
            75.10275,
            72.58450,
            69.85320,
            67.15467,
            65.10107,
            62.95773,
            60.68169,
            58.50831,
            56.15686,
            53.80983,
            51.86494,
            49.57792,
            47.64060,
            45.55006,
            43.84372,
            42.12349,
            40.50399,
            38.93566,
            37.13464,
            35.59576,
            34.30043,
            32.66566,
            31.11213,
            30.01509,
            28.65202,
            27.61472,
            26.69773,
            25.73329,
            25.19789,
            23.91467,
            23.19584,
            22.30620,
            21.19742,
            20.23304,
            19.56665,
        ],
        # Precision 15
        [
            14656.23943,
            14384.32041,
            14115.43108,
            13850.04442,
            13588.35519,
            13330.10022,
            13075.90047,
            12824.64564,
            12576.86711,
            12332.52017,
            12091.63216,
            11854.67165,
            11620.71707,
            11390.15265,
            11162.79562,
            10938.68556,
            10718.06359,
            10500.99411,
            10286.88907,
            10076.17192,
            9868.62428,
            9664.38556,
            9463.44421,
            9265.56910,
            9070.87628,
            8879.34656,
            8690.78047,
            8505.54115,
            8323.15895,
            8143.56829,
            7967.02372,
            7793.56744,
            7622.93454,
            7455.70513,
            7290.93960,
            7129.07789,
            6970.00736,
            6813.69800,
            6660.41062,
            6509.70242,
            6361.57661,
            6216.11725,
            6073.53236,
            5933.18009,
            5795.68339,
            5660.73179,
            5528.01266,
            5398.13583,
            5270.84085,
            5146.02241,
            5023.29826,
            4903.10168,
            4784.96418,
            4669.29574,
            4555.70314,
            4444.40934,
            4335.81756,
            4229.27824,
            4124.80626,
            4022.71901,
            3922.64320,
            3824.62942,
            3728.37616,
            3634.30310,
            3542.06189,
            3451.98172,
            3363.77747,
            3277.31106,
            3192.84977,
            3110.40806,
            3029.63837,
            2950.68118,
            2873.32305,
            2797.73301,
            2724.04123,
            2652.05460,
            2581.40880,
            2512.53446,
            2445.04091,
            2379.40226,
            2314.77560,
            2251.82290,
            2190.49369,
            2130.57648,
            2072.21753,
            2015.14973,
            1959.51909,
            1905.14348,
            1851.97308,
            1800.22313,
            1750.13930,
            1700.74144,
            1653.13521,
            1605.88216,
            1560.12934,
            1515.76427,
            1472.31059,
            1429.91712,
            1388.81709,
            1348.67895,
            1309.47560,
            1271.26130,
            1234.27344,
            1198.22631,
            1163.06126,
            1128.55087,
            1095.10715,
            1062.63762,
            1031.09273,
            1000.21731,
            970.33384,
            941.46872,
            913.07994,
            885.23191,
            858.55060,
            832.48497,
            806.94575,
            782.15186,
            757.80572,
            734.21497,
            711.42677,
            689.21098,
            667.28969,
            646.35900,
            626.34439,
            606.60548,
            587.52956,
            568.73746,
            550.43044,
            533.13300,
            515.81543,
            499.80739,
            484.16970,
            468.43442,
            453.73608,
            439.44353,
            424.85104,
            411.09076,
            397.66827,
            384.77690,
            372.27060,
            359.63095,
            348.74540,
            336.86505,
            325.23485,
            314.42880,
            303.62955,
            292.97126,
            283.12773,
            273.26129,
            264.64137,
            255.51904,
            247.59089,
            238.96844,
            230.53435,
            221.96155,
            214.39173,
            207.21848,
            200.23823,
            193.69867,
            186.79841,
            180.51125,
            174.41358,
            168.53954,
            162.22252,
            155.94686,
            150.02886,
            144.53850,
            138.75240,
            133.61370,
            129.00799,
            124.66681,
            120.35834,
            115.82324,
            111.79049,
            107.55264,
            103.15250,
            98.75341,
            95.31226,
            92.15538,
            88.51421,
            85.44084,
            81.60702,
            78.13311,
            74.93485,
            71.70931,
            69.43355,
            66.07891,
            63.48302,
            60.67955,
            58.57141,
            56.67282,
            54.70397,
            52.75565,
            49.93036,
            48.20568,
            46.83059,
            45.37818,
            43.56229,
            41.34087,
        ],
        # Precision 16
        [
            25690.02942,
            25211.38777,
            24739.31447,
            24273.19407,
            23813.96439,
            23360.76699,
            22913.65472,
            22473.09199,
            22038.45264,
            21610.32314,
            21188.37836,
            20772.28912,
            20362.71240,
            19959.18169,
            19560.99377,
            19169.58880,
            18783.55091,
            18403.65399,
            18029.37803,
            17660.95111,
            17298.65636,
            16941.86742,
            16590.50943,
            16244.76486,
            15904.47248,
            15570.04430,
            15240.95578,
            14917.08547,
            14599.06532,
            14286.11230,
            13978.28778,
            13676.22970,
            13378.64475,
            13086.60393,
            12799.63512,
            12517.49953,
            12240.49248,
            11968.06498,
            11700.73873,
            11438.50425,
            11180.68609,
            10927.42562,
            10679.08069,
            10435.19487,
            10195.55997,
            9960.83181,
            9730.51786,
            9504.52128,
            9282.54623,
            9065.21676,
            8851.87801,
            8642.63304,
            8437.65312,
            8236.30236,
            8038.90295,
            7845.74928,
            7656.67352,
            7470.89053,
            7288.84342,
            7110.89091,
            6936.41867,
            6765.85775,
            6598.05033,
            6434.37369,
            6273.72794,
            6116.35063,
            5962.20408,
            5811.77370,
            5664.88577,
            5520.79093,
            5380.40035,
            5242.73415,
            5107.29901,
            4975.93328,
            4847.26957,
            4720.99776,
            4597.95408,
            4477.39173,
            4360.00058,
            4245.00022,
            4133.09262,
            4022.93940,
            3915.46479,
            3810.73453,
            3707.89250,
            3607.52867,
            3509.99540,
            3415.09509,
            3321.78895,
            3231.75961,
            3143.33783,
            3056.98549,
            2972.91252,
            2890.90660,
            2810.84795,
            2732.89113,
            2656.10699,
            2581.79382,
            2509.73313,
            2438.85788,
            2369.43655,
            2302.05030,
            2237.02003,
            2172.97247,
            2110.24277,
            2049.85129,
            1990.97749,
            1933.51453,
            1877.42814,
            1822.49545,
            1770.09549,
            1718.15850,
            1667.19660,
            1617.97052,
            1569.92457,
            1523.17760,
            1477.62615,
            1433.64690,
            1390.32842,
            1347.35725,
            1306.85416,
            1266.90479,
            1228.68861,
            1191.00159,
            1155.09762,
            1120.76525,
            1085.76213,
            1052.07569,
            1020.23463,
            988.79360,
            957.88754,
            927.33869,
            897.71909,
            869.81846,
            842.09524,
            815.46419,
            790.20285,
            765.34309,
            740.77950,
            717.49281,
            694.30817,
            672.59580,
            651.33394,
            630.82984,
            610.40260,
            590.76020,
            571.91470,
            554.18434,
            536.82169,
            518.98717,
            502.38026,
            485.59483,
            470.02749,
            454.00496,
            439.59224,
            424.90939,
            410.48716,
            395.95162,
            382.62085,
            369.10669,
            356.66959,
            344.29618,
            332.89055,
            322.01579,
            310.66392,
            300.69522,
            290.51346,
            280.67263,
            271.05454,
            260.47861,
            250.39638,
            241.24939,
            232.84620,
            224.26335,
            215.50176,
            208.57053,
            201.20608,
            194.22938,
            187.59624,
            180.31205,
            173.49775,
            166.11528,
            159.44550,
            153.09312,
            146.83186,
            140.74134,
            134.10756,
            128.31088,
            123.43548,
            118.64881,
            114.17153,
            109.53473,
            105.69566,
            101.61404,
            98.04620,
            94.36304,
            89.86818,
            85.69871,
            81.59519,
            77.29623,
        ],
    ]
)

# Constants used to remove bias for low cardinality estimates. Getting just the
# data for precision between [7, 16]. These are taken from the HyperLogLog++
# authors compiled tables found in https://goo.gl/iU*Ig
#
# NOTE: They claim that they have 200 records for each precision, but a few
#       actually had 201 points. I've removed the last point when that happens.
raw_estimate_paper = np.array(
    [
        # Precision 7
        [
            92,
            93.4934,
            94.9758,
            96.4574,
            97.9718,
            99.4954,
            101.5302,
            103.0756,
            104.6374,
            106.1782,
            107.7888,
            109.9522,
            111.592,
            113.2532,
            114.9086,
            116.5938,
            118.9474,
            120.6796,
            122.4394,
            124.2176,
            125.9768,
            128.4214,
            130.2528,
            132.0102,
            133.8658,
            135.7278,
            138.3044,
            140.1316,
            142.093,
            144.0032,
            145.9092,
            148.6306,
            150.5294,
            152.5756,
            154.6508,
            156.662,
            159.552,
            161.3724,
            163.617,
            165.5754,
            167.7872,
            169.8444,
            172.7988,
            174.8606,
            177.2118,
            179.3566,
            181.4476,
            184.5882,
            186.6816,
            189.0824,
            191.0258,
            193.6048,
            196.4436,
            198.7274,
            200.957,
            203.147,
            205.4364,
            208.7592,
            211.3386,
            213.781,
            215.8028,
            218.656,
            221.6544,
            223.996,
            226.4718,
            229.1544,
            231.6098,
            234.5956,
            237.0616,
            239.5758,
            242.4878,
            244.5244,
            248.2146,
            250.724,
            252.8722,
            255.5198,
            258.0414,
            261.941,
            264.9048,
            266.87,
            269.4304,
            272.028,
            274.4708,
            278.37,
            281.0624,
            283.4668,
            286.5532,
            289.4352,
            293.2564,
            295.2744,
            298.2118,
            300.7472,
            304.1456,
            307.2928,
            309.7504,
            312.5528,
            315.979,
            318.2102,
            322.1834,
            324.3494,
            327.325,
            330.6614,
            332.903,
            337.2544,
            339.9042,
            343.215,
            345.2864,
            348.0814,
            352.6764,
            355.301,
            357.139,
            360.658,
            363.1732,
            366.5902,
            369.9538,
            373.0828,
            375.922,
            378.9902,
            382.7328,
            386.4538,
            388.1136,
            391.2234,
            394.0878,
            396.708,
            401.1556,
            404.1852,
            406.6372,
            409.6822,
            412.7796,
            416.6078,
            418.4916,
            422.131,
            424.5376,
            428.1988,
            432.211,
            434.4502,
            438.5282,
            440.912,
            444.0448,
            447.7432,
            450.8524,
            453.7988,
            456.7858,
            458.8868,
            463.9886,
            466.5064,
            468.9124,
            472.6616,
            475.4682,
            478.582,
            481.304,
            485.2738,
            488.6894,
            490.329,
            496.106,
            497.6908,
            501.1374,
            504.5322,
            506.8848,
            510.3324,
            513.4512,
            516.179,
            520.4412,
            522.6066,
            526.167,
            528.7794,
            533.379,
            536.067,
            538.46,
            542.9116,
            545.692,
            547.9546,
            552.493,
            555.2722,
            557.335,
            562.449,
            564.2014,
            569.0738,
            571.0974,
            574.8564,
            578.2996,
            581.409,
            583.9704,
            585.8098,
            589.6528,
            594.5998,
            595.958,
            600.068,
            603.3278,
            608.2016,
            609.9632,
            612.864,
            615.43,
            620.7794,
            621.272,
            625.8644,
            629.206,
            633.219,
            634.5154,
            638.6102,
        ],
        # Precision 8
        [
            184.2152,
            187.2454,
            190.2096,
            193.6652,
            196.6312,
            199.6822,
            203.249,
            206.3296,
            210.0038,
            213.2074,
            216.4612,
            220.27,
            223.5178,
            227.4412,
            230.8032,
            234.1634,
            238.1688,
            241.6074,
            245.6946,
            249.2664,
            252.8228,
            257.0432,
            260.6824,
            264.9464,
            268.6268,
            272.2626,
            276.8376,
            280.4034,
            284.8956,
            288.8522,
            292.7638,
            297.3552,
            301.3556,
            305.7526,
            309.9292,
            313.8954,
            318.8198,
            322.7668,
            327.298,
            331.6688,
            335.9466,
            340.9746,
            345.1672,
            349.3474,
            354.3028,
            358.8912,
            364.114,
            368.4646,
            372.9744,
            378.4092,
            382.6022,
            387.843,
            392.5684,
            397.1652,
            402.5426,
            407.4152,
            412.5388,
            417.3592,
            422.1366,
            427.486,
            432.3918,
            437.5076,
            442.509,
            447.3834,
            453.3498,
            458.0668,
            463.7346,
            469.1228,
            473.4528,
            479.7,
            484.644,
            491.0518,
            495.5774,
            500.9068,
            506.432,
            512.1666,
            517.434,
            522.6644,
            527.4894,
            533.6312,
            538.3804,
            544.292,
            550.5496,
            556.0234,
            562.8206,
            566.6146,
            572.4188,
            579.117,
            583.6762,
            590.6576,
            595.7864,
            601.509,
            607.5334,
            612.9204,
            619.772,
            624.2924,
            630.8654,
            636.1836,
            642.745,
            649.1316,
            655.0386,
            660.0136,
            666.6342,
            671.6196,
            678.1866,
            684.4282,
            689.3324,
            695.4794,
            702.5038,
            708.129,
            713.528,
            720.3204,
            726.463,
            732.7928,
            739.123,
            744.7418,
            751.2192,
            756.5102,
            762.6066,
            769.0184,
            775.2224,
            781.4014,
            787.7618,
            794.1436,
            798.6506,
            805.6378,
            811.766,
            819.7514,
            824.5776,
            828.7322,
            837.8048,
            843.6302,
            849.9336,
            854.4798,
            861.3388,
            867.9894,
            873.8196,
            880.3136,
            886.2308,
            892.4588,
            899.0816,
            905.4076,
            912.0064,
            917.3878,
            923.619,
            929.998,
            937.3482,
            943.9506,
            947.991,
            955.1144,
            962.203,
            968.8222,
            975.7324,
            981.7826,
            988.7666,
            994.2648,
            1000.3128,
            1007.4082,
            1013.7536,
            1020.3376,
            1026.7156,
            1031.7478,
            1037.4292,
            1045.393,
            1051.2278,
            1058.3434,
            1062.8726,
            1071.884,
            1076.806,
            1082.9176,
            1089.1678,
            1095.5032,
            1102.525,
            1107.2264,
            1115.315,
            1120.93,
            1127.252,
            1134.1496,
            1139.0408,
            1147.5448,
            1153.3296,
            1158.1974,
            1166.5262,
            1174.3328,
            1175.657,
            1184.4222,
            1190.9172,
            1197.1292,
            1204.4606,
            1210.4578,
            1218.8728,
            1225.3336,
            1226.6592,
            1236.5768,
            1241.363,
            1249.4074,
            1254.6566,
            1260.8014,
            1266.5454,
            1274.5192,
        ],
        # Precision 9
        [
            369,
            374.8294,
            381.2452,
            387.6698,
            394.1464,
            400.2024,
            406.8782,
            413.6598,
            420.462,
            427.2826,
            433.7102,
            440.7416,
            447.9366,
            455.1046,
            462.285,
            469.0668,
            476.306,
            483.8448,
            491.301,
            498.9886,
            506.2422,
            513.8138,
            521.7074,
            529.7428,
            537.8402,
            545.1664,
            553.3534,
            561.594,
            569.6886,
            577.7876,
            585.65,
            594.228,
            602.8036,
            611.1666,
            620.0818,
            628.0824,
            637.2574,
            646.302,
            655.1644,
            664.0056,
            672.3802,
            681.7192,
            690.5234,
            700.2084,
            708.831,
            718.485,
            728.1112,
            737.4764,
            746.76,
            756.3368,
            766.5538,
            775.5058,
            785.2646,
            795.5902,
            804.3818,
            814.8998,
            824.9532,
            835.2062,
            845.2798,
            854.4728,
            864.9582,
            875.3292,
            886.171,
            896.781,
            906.5716,
            916.7048,
            927.5322,
            937.875,
            949.3972,
            958.3464,
            969.7274,
            980.2834,
            992.1444,
            1003.4264,
            1013.0166,
            1024.018,
            1035.0438,
            1046.34,
            1057.6856,
            1068.9836,
            1079.0312,
            1091.677,
            1102.3188,
            1113.4846,
            1124.4424,
            1135.739,
            1147.1488,
            1158.9202,
            1169.406,
            1181.5342,
            1193.2834,
            1203.8954,
            1216.3286,
            1226.2146,
            1239.6684,
            1251.9946,
            1262.123,
            1275.4338,
            1285.7378,
            1296.076,
            1308.9692,
            1320.4964,
            1333.0998,
            1343.9864,
            1357.7754,
            1368.3208,
            1380.4838,
            1392.7388,
            1406.0758,
            1416.9098,
            1428.9728,
            1440.9228,
            1453.9292,
            1462.617,
            1476.05,
            1490.2996,
            1500.6128,
            1513.7392,
            1524.5174,
            1536.6322,
            1548.2584,
            1562.3766,
            1572.423,
            1587.1232,
            1596.5164,
            1610.5938,
            1622.5972,
            1633.1222,
            1647.7674,
            1658.5044,
            1671.57,
            1683.7044,
            1695.4142,
            1708.7102,
            1720.6094,
            1732.6522,
            1747.841,
            1756.4072,
            1769.9786,
            1782.3276,
            1797.5216,
            1808.3186,
            1819.0694,
            1834.354,
            1844.575,
            1856.2808,
            1871.1288,
            1880.7852,
            1893.9622,
            1906.3418,
            1920.6548,
            1932.9302,
            1945.8584,
            1955.473,
            1968.8248,
            1980.6446,
            1995.9598,
            2008.349,
            2019.8556,
            2033.0334,
            2044.0206,
            2059.3956,
            2069.9174,
            2082.6084,
            2093.7036,
            2106.6108,
            2118.9124,
            2132.301,
            2144.7628,
            2159.8422,
            2171.0212,
            2183.101,
            2193.5112,
            2208.052,
            2221.3194,
            2233.3282,
            2247.295,
            2257.7222,
            2273.342,
            2286.5638,
            2299.6786,
            2310.8114,
            2322.3312,
            2335.516,
            2349.874,
            2363.5968,
            2373.865,
            2387.1918,
            2401.8328,
            2414.8496,
            2424.544,
            2436.7592,
            2447.1682,
            2464.1958,
            2474.3438,
            2489.0006,
            2497.4526,
            2513.6586,
            2527.19,
            2540.7028,
        ],
        # Precision 10
        [
            738.1256,
            750.4234,
            763.1064,
            775.4732,
            788.4636,
            801.0644,
            814.488,
            827.9654,
            841.0832,
            854.7864,
            868.1992,
            882.2176,
            896.5228,
            910.1716,
            924.7752,
            938.899,
            953.6126,
            968.6492,
            982.9474,
            998.5214,
            1013.1064,
            1028.6364,
            1044.2468,
            1059.4588,
            1075.3832,
            1091.0584,
            1106.8606,
            1123.3868,
            1139.5062,
            1156.1862,
            1172.463,
            1189.339,
            1206.1936,
            1223.1292,
            1240.1854,
            1257.2908,
            1275.3324,
            1292.8518,
            1310.5204,
            1328.4854,
            1345.9318,
            1364.552,
            1381.4658,
            1400.4256,
            1419.849,
            1438.152,
            1456.8956,
            1474.8792,
            1494.118,
            1513.62,
            1532.5132,
            1551.9322,
            1570.7726,
            1590.6086,
            1610.5332,
            1630.5918,
            1650.4294,
            1669.7662,
            1690.4106,
            1710.7338,
            1730.9012,
            1750.4486,
            1770.1556,
            1791.6338,
            1812.7312,
            1833.6264,
            1853.9526,
            1874.8742,
            1896.8326,
            1918.1966,
            1939.5594,
            1961.07,
            1983.037,
            2003.1804,
            2026.071,
            2047.4884,
            2070.0848,
            2091.2944,
            2114.333,
            2135.9626,
            2158.2902,
            2181.0814,
            2202.0334,
            2224.4832,
            2246.39,
            2269.7202,
            2292.1714,
            2314.2358,
            2338.9346,
            2360.891,
            2384.0264,
            2408.3834,
            2430.1544,
            2454.8684,
            2476.9896,
            2501.4368,
            2522.8702,
            2548.0408,
            2570.6738,
            2593.5208,
            2617.0158,
            2640.2302,
            2664.0962,
            2687.4986,
            2714.2588,
            2735.3914,
            2759.6244,
            2781.8378,
            2808.0072,
            2830.6516,
            2856.2454,
            2877.2136,
            2903.4546,
            2926.785,
            2951.2294,
            2976.468,
            3000.867,
            3023.6508,
            3049.91,
            3073.5984,
            3098.162,
            3121.5564,
            3146.2328,
            3170.9484,
            3195.5902,
            3221.3346,
            3242.7032,
            3271.6112,
            3296.5546,
            3317.7376,
            3345.072,
            3369.9518,
            3394.326,
            3418.1818,
            3444.6926,
            3469.086,
            3494.2754,
            3517.8698,
            3544.248,
            3565.3768,
            3588.7234,
            3616.979,
            3643.7504,
            3668.6812,
            3695.72,
            3719.7392,
            3742.6224,
            3770.4456,
            3795.6602,
            3819.9058,
            3844.002,
            3869.517,
            3895.6824,
            3920.8622,
            3947.1364,
            3973.985,
            3995.4772,
            4021.62,
            4046.628,
            4074.65,
            4096.2256,
            4121.831,
            4146.6406,
            4173.276,
            4195.0744,
            4223.9696,
            4251.3708,
            4272.9966,
            4300.8046,
            4326.302,
            4353.1248,
            4374.312,
            4403.0322,
            4426.819,
            4450.0598,
            4478.5206,
            4504.8116,
            4528.8928,
            4553.9584,
            4578.8712,
            4603.8384,
            4632.3872,
            4655.5128,
            4675.821,
            4704.6222,
            4731.9862,
            4755.4174,
            4781.2628,
            4804.332,
            4832.3048,
            4862.8752,
            4883.4148,
            4906.9544,
            4935.3516,
            4954.3532,
            4984.0248,
            5011.217,
            5035.3258,
            5057.3672,
            5084.1828,
        ],
        # Precision 11
        [
            1477,
            1501.6014,
            1526.5802,
            1551.7942,
            1577.3042,
            1603.2062,
            1629.8402,
            1656.2292,
            1682.9462,
            1709.9926,
            1737.3026,
            1765.4252,
            1793.0578,
            1821.6092,
            1849.626,
            1878.5568,
            1908.527,
            1937.5154,
            1967.1874,
            1997.3878,
            2027.37,
            2058.1972,
            2089.5728,
            2120.1012,
            2151.9668,
            2183.292,
            2216.0772,
            2247.8578,
            2280.6562,
            2313.041,
            2345.714,
            2380.3112,
            2414.1806,
            2447.9854,
            2481.656,
            2516.346,
            2551.5154,
            2586.8378,
            2621.7448,
            2656.6722,
            2693.5722,
            2729.1462,
            2765.4124,
            2802.8728,
            2838.898,
            2876.408,
            2913.4926,
            2951.4938,
            2989.6776,
            3026.282,
            3065.7704,
            3104.1012,
            3143.7388,
            3181.6876,
            3221.1872,
            3261.5048,
            3300.0214,
            3339.806,
            3381.409,
            3421.4144,
            3461.4294,
            3502.2286,
            3544.651,
            3586.6156,
            3627.337,
            3670.083,
            3711.1538,
            3753.5094,
            3797.01,
            3838.6686,
            3882.1678,
            3922.8116,
            3967.9978,
            4009.9204,
            4054.3286,
            4097.5706,
            4140.6014,
            4185.544,
            4229.5976,
            4274.583,
            4316.9438,
            4361.672,
            4406.2786,
            4451.8628,
            4496.1834,
            4543.505,
            4589.1816,
            4632.5188,
            4678.2294,
            4724.8908,
            4769.0194,
            4817.052,
            4861.4588,
            4910.1596,
            4956.4344,
            5002.5238,
            5048.13,
            5093.6374,
            5142.8162,
            5187.7894,
            5237.3984,
            5285.6078,
            5331.0858,
            5379.1036,
            5428.6258,
            5474.6018,
            5522.7618,
            5571.5822,
            5618.59,
            5667.9992,
            5714.88,
            5763.454,
            5808.6982,
            5860.3644,
            5910.2914,
            5953.571,
            6005.9232,
            6055.1914,
            6104.5882,
            6154.5702,
            6199.7036,
            6251.1764,
            6298.7596,
            6350.0302,
            6398.061,
            6448.4694,
            6495.933,
            6548.0474,
            6597.7166,
            6646.9416,
            6695.9208,
            6742.6328,
            6793.5276,
            6842.1934,
            6894.2372,
            6945.3864,
            6996.9228,
            7044.2372,
            7094.1374,
            7142.2272,
            7192.2942,
            7238.8338,
            7288.9006,
            7344.0908,
            7394.8544,
            7443.5176,
            7490.4148,
            7542.9314,
            7595.6738,
            7641.9878,
            7694.3688,
            7743.0448,
            7797.522,
            7845.53,
            7899.594,
            7950.3132,
            7996.455,
            8050.9442,
            8092.9114,
            8153.1374,
            8197.4472,
            8252.8278,
            8301.8728,
            8348.6776,
            8401.4698,
            8453.551,
            8504.6598,
            8553.8944,
            8604.1276,
            8657.6514,
            8710.3062,
            8758.908,
            8807.8706,
            8862.1702,
            8910.4668,
            8960.77,
            9007.2766,
            9063.164,
            9121.0534,
            9164.1354,
            9218.1594,
            9267.767,
            9319.0594,
            9372.155,
            9419.7126,
            9474.3722,
            9520.1338,
            9572.368,
            9622.7702,
            9675.8448,
            9726.5396,
            9778.7378,
            9827.6554,
            9878.1922,
            9928.7782,
            9978.3984,
            10026.578,
            10076.5626,
            10137.1618,
            10177.5244,
        ],
        # Precision 12
        [
            2954,
            3003.4782,
            3053.3568,
            3104.3666,
            3155.324,
            3206.9598,
            3259.648,
            3312.539,
            3366.1474,
            3420.2576,
            3474.8376,
            3530.6076,
            3586.451,
            3643.38,
            3700.4104,
            3757.5638,
            3815.9676,
            3875.193,
            3934.838,
            3994.8548,
            4055.018,
            4117.1742,
            4178.4482,
            4241.1294,
            4304.4776,
            4367.4044,
            4431.8724,
            4496.3732,
            4561.4304,
            4627.5326,
            4693.949,
            4761.5532,
            4828.7256,
            4897.6182,
            4965.5186,
            5034.4528,
            5104.865,
            5174.7164,
            5244.6828,
            5316.6708,
            5387.8312,
            5459.9036,
            5532.476,
            5604.8652,
            5679.6718,
            5753.757,
            5830.2072,
            5905.2828,
            5980.0434,
            6056.6264,
            6134.3192,
            6211.5746,
            6290.0816,
            6367.1176,
            6447.9796,
            6526.5576,
            6606.1858,
            6686.9144,
            6766.1142,
            6847.0818,
            6927.9664,
            7010.9096,
            7091.0816,
            7175.3962,
            7260.3454,
            7344.018,
            7426.4214,
            7511.3106,
            7596.0686,
            7679.8094,
            7765.818,
            7852.4248,
            7936.834,
            8022.363,
            8109.5066,
            8200.4554,
            8288.5832,
            8373.366,
            8463.4808,
            8549.7682,
            8642.0522,
            8728.3288,
            8820.9528,
            8907.727,
            9001.0794,
            9091.2522,
            9179.988,
            9269.852,
            9362.6394,
            9453.642,
            9546.9024,
            9640.6616,
            9732.6622,
            9824.3254,
            9917.7484,
            10007.9392,
            10106.7508,
            10196.2152,
            10289.8114,
            10383.5494,
            10482.3064,
            10576.8734,
            10668.7872,
            10764.7156,
            10862.0196,
            10952.793,
            11049.9748,
            11146.0702,
            11241.4492,
            11339.2772,
            11434.2336,
            11530.741,
            11627.6136,
            11726.311,
            11821.5964,
            11918.837,
            12015.3724,
            12113.0162,
            12213.0424,
            12306.9804,
            12408.4518,
            12504.8968,
            12604.586,
            12700.9332,
            12798.705,
            12898.5142,
            12997.0488,
            13094.788,
            13198.475,
            13292.7764,
            13392.9698,
            13486.8574,
            13590.1616,
            13686.5838,
            13783.6264,
            13887.2638,
            13992.0978,
            14081.0844,
            14189.9956,
            14280.0912,
            14382.4956,
            14486.4384,
            14588.1082,
            14686.2392,
            14782.276,
            14888.0284,
            14985.1864,
            15088.8596,
            15187.0998,
            15285.027,
            15383.6694,
            15495.8266,
            15591.3736,
            15694.2008,
            15790.3246,
            15898.4116,
            15997.4522,
            16095.5014,
            16198.8514,
            16291.7492,
            16402.6424,
            16499.1266,
            16606.2436,
            16697.7186,
            16796.3946,
            16902.3376,
            17005.7672,
            17100.814,
            17206.8282,
            17305.8262,
            17416.0744,
            17508.4092,
            17617.0178,
            17715.4554,
            17816.758,
            17920.1748,
            18012.9236,
            18119.7984,
            18223.2248,
            18324.2482,
            18426.6276,
            18525.0932,
            18629.8976,
            18733.2588,
            18831.0466,
            18940.1366,
            19032.2696,
            19131.729,
            19243.4864,
            19349.6932,
            19442.866,
            19547.9448,
            19653.2798,
            19754.4034,
            19854.0692,
            19965.1224,
            20065.1774,
            20158.2212,
            20253.353,
            20366.3264,
        ],
        # Precision 13
        [
            5908.5052,
            6007.2672,
            6107.347,
            6208.5794,
            6311.2622,
            6414.5514,
            6519.3376,
            6625.6952,
            6732.5988,
            6841.3552,
            6950.5972,
            7061.3082,
            7173.5646,
            7287.109,
            7401.8216,
            7516.4344,
            7633.3802,
            7751.2962,
            7870.3784,
            7990.292,
            8110.79,
            8233.4574,
            8356.6036,
            8482.2712,
            8607.7708,
            8735.099,
            8863.1858,
            8993.4746,
            9123.8496,
            9255.6794,
            9388.5448,
            9522.7516,
            9657.3106,
            9792.6094,
            9930.5642,
            10068.794,
            10206.7256,
            10347.81,
            10490.3196,
            10632.0778,
            10775.9916,
            10920.4662,
            11066.124,
            11213.073,
            11358.0362,
            11508.1006,
            11659.1716,
            11808.7514,
            11959.4884,
            12112.1314,
            12265.037,
            12420.3756,
            12578.933,
            12734.311,
            12890.0006,
            13047.2144,
            13207.3096,
            13368.5144,
            13528.024,
            13689.847,
            13852.7528,
            14018.3168,
            14180.5372,
            14346.9668,
            14513.5074,
            14677.867,
            14846.2186,
            15017.4186,
            15184.9716,
            15356.339,
            15529.2972,
            15697.3578,
            15871.8686,
            16042.187,
            16216.4094,
            16389.4188,
            16565.9126,
            16742.3272,
            16919.0042,
            17094.7592,
            17273.965,
            17451.8342,
            17634.4254,
            17810.5984,
            17988.9242,
            18171.051,
            18354.7938,
            18539.466,
            18721.0408,
            18904.9972,
            19081.867,
            19271.9118,
            19451.8694,
            19637.9816,
            19821.2922,
            20013.1292,
            20199.3858,
            20387.8726,
            20572.9514,
            20770.7764,
            20955.1714,
            21144.751,
            21329.9952,
            21520.709,
            21712.7016,
            21906.3868,
            22096.2626,
            22286.0524,
            22475.051,
            22665.5098,
            22862.8492,
            23055.5294,
            23249.6138,
            23437.848,
            23636.273,
            23826.093,
            24020.3296,
            24213.3896,
            24411.7392,
            24602.9614,
            24805.7952,
            24998.1552,
            25193.9588,
            25389.0166,
            25585.8392,
            25780.6976,
            25981.2728,
            26175.977,
            26376.5252,
            26570.1964,
            26773.387,
            26962.9812,
            27163.0586,
            27368.164,
            27565.0534,
            27758.7428,
            27961.1276,
            28163.2324,
            28362.3816,
            28565.7668,
            28758.644,
            28956.9768,
            29163.4722,
            29354.7026,
            29561.1186,
            29767.9948,
            29959.9986,
            30164.0492,
            30366.9818,
            30562.5338,
            30762.9928,
            30976.1592,
            31166.274,
            31376.722,
            31570.3734,
            31770.809,
            31974.8934,
            32179.5286,
            32387.5442,
            32582.3504,
            32794.076,
            32989.9528,
            33191.842,
            33392.4684,
            33595.659,
            33801.8672,
            34000.3414,
            34200.0922,
            34402.6792,
            34610.0638,
            34804.0084,
            35011.13,
            35218.669,
            35418.6634,
            35619.0792,
            35830.6534,
            36028.4966,
            36229.7902,
            36438.6422,
            36630.7764,
            36833.3102,
            37048.6728,
            37247.3916,
            37453.5904,
            37669.3614,
            37854.5526,
            38059.305,
            38268.0936,
            38470.2516,
            38674.7064,
            38876.167,
            39068.3794,
            39281.9144,
            39492.8566,
            39684.8628,
            39898.4108,
            40093.1836,
            40297.6858,
            40489.7086,
            40717.2424,
        ],
        # Precision 14
        [
            11817.475,
            12015.0046,
            12215.3792,
            12417.7504,
            12623.1814,
            12830.0086,
            13040.0072,
            13252.503,
            13466.178,
            13683.2738,
            13902.0344,
            14123.9798,
            14347.394,
            14573.7784,
            14802.6894,
            15033.6824,
            15266.9134,
            15502.8624,
            15741.4944,
            15980.7956,
            16223.8916,
            16468.6316,
            16715.733,
            16965.5726,
            17217.204,
            17470.666,
            17727.8516,
            17986.7886,
            18247.6902,
            18510.9632,
            18775.304,
            19044.7486,
            19314.4408,
            19587.202,
            19862.2576,
            20135.924,
            20417.0324,
            20697.9788,
            20979.6112,
            21265.0274,
            21550.723,
            21841.6906,
            22132.162,
            22428.1406,
            22722.127,
            23020.5606,
            23319.7394,
            23620.4014,
            23925.2728,
            24226.9224,
            24535.581,
            24845.505,
            25155.9618,
            25470.3828,
            25785.9702,
            26103.7764,
            26420.4132,
            26742.0186,
            27062.8852,
            27388.415,
            27714.6024,
            28042.296,
            28365.4494,
            28701.1526,
            29031.8008,
            29364.2156,
            29704.497,
            30037.1458,
            30380.111,
            30723.8168,
            31059.5114,
            31404.9498,
            31751.6752,
            32095.2686,
            32444.7792,
            32794.767,
            33145.204,
            33498.4226,
            33847.6502,
            34209.006,
            34560.849,
            34919.4838,
            35274.9778,
            35635.1322,
            35996.3266,
            36359.1394,
            36722.8266,
            37082.8516,
            37447.7354,
            37815.9606,
            38191.0692,
            38559.4106,
            38924.8112,
            39294.6726,
            39663.973,
            40042.261,
            40416.2036,
            40779.2036,
            41161.6436,
            41540.9014,
            41921.1998,
            42294.7698,
            42678.5264,
            43061.3464,
            43432.375,
            43818.432,
            44198.6598,
            44583.0138,
            44970.4794,
            45353.924,
            45729.858,
            46118.2224,
            46511.5724,
            46900.7386,
            47280.6964,
            47668.1472,
            48055.6796,
            48446.9436,
            48838.7146,
            49217.7296,
            49613.7796,
            50010.7508,
            50410.0208,
            50793.7886,
            51190.2456,
            51583.1882,
            51971.0796,
            52376.5338,
            52763.319,
            53165.5534,
            53556.5594,
            53948.2702,
            54346.352,
            54748.7914,
            55138.577,
            55543.4824,
            55941.1748,
            56333.7746,
            56745.1552,
            57142.7944,
            57545.2236,
            57935.9956,
            58348.5268,
            58737.5474,
            59158.5962,
            59542.6896,
            59958.8004,
            60349.3788,
            60755.0212,
            61147.6144,
            61548.194,
            61946.0696,
            62348.6042,
            62763.603,
            63162.781,
            63560.635,
            63974.3482,
            64366.4908,
            64771.5876,
            65176.7346,
            65597.3916,
            65995.915,
            66394.0384,
            66822.9396,
            67203.6336,
            67612.2032,
            68019.0078,
            68420.0388,
            68821.22,
            69235.8388,
            69640.0724,
            70055.155,
            70466.357,
            70863.4266,
            71276.2482,
            71677.0306,
            72080.2006,
            72493.0214,
            72893.5952,
            73314.5856,
            73714.9852,
            74125.3022,
            74521.2122,
            74933.6814,
            75341.5904,
            75743.0244,
            76166.0278,
            76572.1322,
            76973.1028,
            77381.6284,
            77800.6092,
            78189.328,
            78607.0962,
            79012.2508,
            79407.8358,
            79825.725,
            80238.701,
            80646.891,
            81035.6436,
            81460.0448,
        ],
        # Precision 15
        [
            23635.0036,
            24030.8034,
            24431.4744,
            24837.1524,
            25246.7928,
            25661.326,
            26081.3532,
            26505.2806,
            26933.9892,
            27367.7098,
            27805.318,
            28248.799,
            28696.4382,
            29148.8244,
            29605.5138,
            30066.8668,
            30534.2344,
            31006.32,
            31480.778,
            31962.2418,
            32447.3324,
            32938.0232,
            33432.731,
            33930.728,
            34433.9896,
            34944.1402,
            35457.5588,
            35974.5958,
            36497.3296,
            37021.9096,
            37554.326,
            38088.0826,
            38628.8816,
            39171.3192,
            39723.2326,
            40274.5554,
            40832.3142,
            41390.613,
            41959.5908,
            42532.5466,
            43102.0344,
            43683.5072,
            44266.694,
            44851.2822,
            45440.7862,
            46038.0586,
            46640.3164,
            47241.064,
            47846.155,
            48454.7396,
            49076.9168,
            49692.542,
            50317.4778,
            50939.65,
            51572.5596,
            52210.2906,
            52843.7396,
            53481.3996,
            54127.236,
            54770.406,
            55422.6598,
            56078.7958,
            56736.7174,
            57397.6784,
            58064.5784,
            58730.308,
            59404.9784,
            60077.0864,
            60751.9158,
            61444.1386,
            62115.817,
            62808.7742,
            63501.4774,
            64187.5454,
            64883.6622,
            65582.7468,
            66274.5318,
            66976.9276,
            67688.7764,
            68402.138,
            69109.6274,
            69822.9706,
            70543.6108,
            71265.5202,
            71983.3848,
            72708.4656,
            73433.384,
            74158.4664,
            74896.4868,
            75620.9564,
            76362.1434,
            77098.3204,
            77835.7662,
            78582.6114,
            79323.9902,
            80067.8658,
            80814.9246,
            81567.0136,
            82310.8536,
            83061.9952,
            83821.4096,
            84580.8608,
            85335.547,
            86092.5802,
            86851.6506,
            87612.311,
            88381.2016,
            89146.3296,
            89907.8974,
            90676.846,
            91451.4152,
            92224.5518,
            92995.8686,
            93763.5066,
            94551.2796,
            95315.1944,
            96096.1806,
            96881.0918,
            97665.679,
            98442.68,
            99229.3002,
            100011.0994,
            100790.6386,
            101580.1564,
            102377.7484,
            103152.1392,
            103944.2712,
            104730.216,
            105528.6336,
            106324.9398,
            107117.6706,
            107890.3988,
            108695.2266,
            109485.238,
            110294.7876,
            111075.0958,
            111878.0496,
            112695.2864,
            113464.5486,
            114270.0474,
            115068.608,
            115884.3626,
            116673.2588,
            117483.3716,
            118275.097,
            119085.4092,
            119879.2808,
            120687.5868,
            121499.9944,
            122284.916,
            123095.9254,
            123912.5038,
            124709.0454,
            125503.7182,
            126323.259,
            127138.9412,
            127943.8294,
            128755.646,
            129556.5354,
            130375.3298,
            131161.4734,
            131971.1962,
            132787.5458,
            133588.1056,
            134431.351,
            135220.2906,
            136023.398,
            136846.6558,
            137667.0004,
            138463.663,
            139283.7154,
            140074.6146,
            140901.3072,
            141721.8548,
            142543.2322,
            143356.1096,
            144173.7412,
            144973.0948,
            145794.3162,
            146609.5714,
            147420.003,
            148237.9784,
            149050.5696,
            149854.761,
            150663.1966,
            151494.0754,
            152313.1416,
            153112.6902,
            153935.7206,
            154746.9262,
            155559.547,
            156401.9746,
            157228.7036,
            158008.7254,
            158820.75,
            159646.9184,
            160470.4458,
            161279.5348,
            162093.3114,
            162918.542,
        ],
        # Precision 16
        [
            47271,
            48062.3584,
            48862.7074,
            49673.152,
            50492.8416,
            51322.9514,
            52161.03,
            53009.407,
            53867.6348,
            54734.206,
            55610.5144,
            56496.2096,
            57390.795,
            58297.268,
            59210.6448,
            60134.665,
            61068.0248,
            62010.4472,
            62962.5204,
            63923.5742,
            64895.0194,
            65876.4182,
            66862.6136,
            67862.6968,
            68868.8908,
            69882.8544,
            70911.271,
            71944.0924,
            72990.0326,
            74040.692,
            75100.6336,
            76174.7826,
            77252.5998,
            78340.2974,
            79438.2572,
            80545.4976,
            81657.2796,
            82784.6336,
            83915.515,
            85059.7362,
            86205.9368,
            87364.4424,
            88530.3358,
            89707.3744,
            90885.9638,
            92080.197,
            93275.5738,
            94479.391,
            95695.918,
            96919.2236,
            98148.4602,
            99382.3474,
            100625.6974,
            101878.0284,
            103141.6278,
            104409.4588,
            105686.2882,
            106967.5402,
            108261.6032,
            109548.1578,
            110852.0728,
            112162.231,
            113479.0072,
            114806.2626,
            116137.9072,
            117469.5048,
            118813.5186,
            120165.4876,
            121516.2556,
            122875.766,
            124250.5444,
            125621.2222,
            127003.2352,
            128387.848,
            129775.2644,
            131181.7776,
            132577.3086,
            133979.9458,
            135394.1132,
            136800.9078,
            138233.217,
            139668.5308,
            141085.212,
            142535.2122,
            143969.0684,
            145420.2872,
            146878.1542,
            148332.7572,
            149800.3202,
            151269.66,
            152743.6104,
            154213.0948,
            155690.288,
            157169.4246,
            158672.1756,
            160160.059,
            161650.6854,
            163145.7772,
            164645.6726,
            166159.1952,
            167682.1578,
            169177.3328,
            170700.0118,
            172228.8964,
            173732.6664,
            175265.5556,
            176787.799,
            178317.111,
            179856.6914,
            181400.865,
            182943.4612,
            184486.742,
            186033.4698,
            187583.7886,
            189148.1868,
            190688.4526,
            192250.1926,
            193810.9042,
            195354.2972,
            196938.7682,
            198493.5898,
            200079.2824,
            201618.912,
            203205.5492,
            204765.5798,
            206356.1124,
            207929.3064,
            209498.7196,
            211086.229,
            212675.1324,
            214256.7892,
            215826.2392,
            217412.8474,
            218995.6724,
            220618.6038,
            222207.1166,
            223781.0364,
            225387.4332,
            227005.7928,
            228590.4336,
            230217.8738,
            231805.1054,
            233408.9,
            234995.3432,
            236601.4956,
            238190.7904,
            239817.2548,
            241411.2832,
            243002.4066,
            244640.1884,
            246255.3128,
            247849.3508,
            249479.9734,
            251106.8822,
            252705.027,
            254332.9242,
            255935.129,
            257526.9014,
            259154.772,
            260777.625,
            262390.253,
            264004.4906,
            265643.59,
            267255.4076,
            268873.426,
            270470.7252,
            272106.4804,
            273722.4456,
            275337.794,
            276945.7038,
            278592.9154,
            280204.3726,
            281841.1606,
            283489.171,
            285130.1716,
            286735.3362,
            288364.7164,
            289961.1814,
            291595.5524,
            293285.683,
            294899.6668,
            296499.3434,
            298128.0462,
            299761.8946,
            301394.2424,
            302997.6748,
            304615.1478,
            306269.7724,
            307886.114,
            309543.1028,
            311153.2862,
            312782.8546,
            314421.2008,
            316033.2438,
            317692.9636,
            319305.2648,
            320948.7406,
            322566.3364,
            324228.4224,
            325847.1542,
        ],
    ],
    dtype=np.float64,
)

bias_data_paper = np.array(
    [
        # precision 7
        [
            91,
            89.4934,
            87.9758,
            86.4574,
            84.9718,
            83.4954,
            81.5302,
            80.0756,
            78.6374,
            77.1782,
            75.7888,
            73.9522,
            72.592,
            71.2532,
            69.9086,
            68.5938,
            66.9474,
            65.6796,
            64.4394,
            63.2176,
            61.9768,
            60.4214,
            59.2528,
            58.0102,
            56.8658,
            55.7278,
            54.3044,
            53.1316,
            52.093,
            51.0032,
            49.9092,
            48.6306,
            47.5294,
            46.5756,
            45.6508,
            44.662,
            43.552,
            42.3724,
            41.617,
            40.5754,
            39.7872,
            38.8444,
            37.7988,
            36.8606,
            36.2118,
            35.3566,
            34.4476,
            33.5882,
            32.6816,
            32.0824,
            31.0258,
            30.6048,
            29.4436,
            28.7274,
            27.957,
            27.147,
            26.4364,
            25.7592,
            25.3386,
            24.781,
            23.8028,
            23.656,
            22.6544,
            21.996,
            21.4718,
            21.1544,
            20.6098,
            19.5956,
            19.0616,
            18.5758,
            18.4878,
            17.5244,
            17.2146,
            16.724,
            15.8722,
            15.5198,
            15.0414,
            14.941,
            14.9048,
            13.87,
            13.4304,
            13.028,
            12.4708,
            12.37,
            12.0624,
            11.4668,
            11.5532,
            11.4352,
            11.2564,
            10.2744,
            10.2118,
            9.74720000000002,
            10.1456,
            9.2928,
            8.75040000000001,
            8.55279999999999,
            8.97899999999998,
            8.21019999999999,
            8.18340000000001,
            7.3494,
            7.32499999999999,
            7.66140000000001,
            6.90300000000002,
            7.25439999999998,
            6.9042,
            7.21499999999997,
            6.28640000000001,
            6.08139999999997,
            6.6764,
            6.30099999999999,
            5.13900000000001,
            5.65800000000002,
            5.17320000000001,
            4.59019999999998,
            4.9538,
            5.08280000000002,
            4.92200000000003,
            4.99020000000002,
            4.7328,
            5.4538,
            4.11360000000002,
            4.22340000000003,
            4.08780000000002,
            3.70800000000003,
            4.15559999999999,
            4.18520000000001,
            3.63720000000001,
            3.68220000000002,
            3.77960000000002,
            3.6078,
            2.49160000000001,
            3.13099999999997,
            2.5376,
            3.19880000000001,
            3.21100000000001,
            2.4502,
            3.52820000000003,
            2.91199999999998,
            3.04480000000001,
            2.7432,
            2.85239999999999,
            2.79880000000003,
            2.78579999999999,
            1.88679999999999,
            2.98860000000002,
            2.50639999999999,
            1.91239999999999,
            2.66160000000002,
            2.46820000000002,
            1.58199999999999,
            1.30399999999997,
            2.27379999999999,
            2.68939999999998,
            1.32900000000001,
            3.10599999999999,
            1.69080000000002,
            2.13740000000001,
            2.53219999999999,
            1.88479999999998,
            1.33240000000001,
            1.45119999999997,
            1.17899999999997,
            2.44119999999998,
            1.60659999999996,
            2.16700000000003,
            0.77940000000001,
            2.37900000000002,
            2.06700000000001,
            1.46000000000004,
            2.91160000000002,
            1.69200000000001,
            0.954600000000028,
            2.49300000000005,
            2.2722,
            1.33500000000004,
            2.44899999999996,
            1.20140000000004,
            3.07380000000001,
            2.09739999999999,
            2.85640000000001,
            2.29960000000005,
            2.40899999999999,
            1.97040000000004,
            0.809799999999996,
            1.65279999999996,
            2.59979999999996,
            0.95799999999997,
            2.06799999999998,
            2.32780000000002,
            4.20159999999998,
            1.96320000000003,
            1.86400000000003,
            1.42999999999995,
            3.77940000000001,
            1.27200000000005,
            1.86440000000005,
            2.20600000000002,
            3.21900000000005,
            1.5154,
            2.61019999999996,
        ],
        # precision 8
        [
            183.2152,
            180.2454,
            177.2096,
            173.6652,
            170.6312,
            167.6822,
            164.249,
            161.3296,
            158.0038,
            155.2074,
            152.4612,
            149.27,
            146.5178,
            143.4412,
            140.8032,
            138.1634,
            135.1688,
            132.6074,
            129.6946,
            127.2664,
            124.8228,
            122.0432,
            119.6824,
            116.9464,
            114.6268,
            112.2626,
            109.8376,
            107.4034,
            104.8956,
            102.8522,
            100.7638,
            98.3552,
            96.3556,
            93.7526,
            91.9292,
            89.8954,
            87.8198,
            85.7668,
            83.298,
            81.6688,
            79.9466,
            77.9746,
            76.1672,
            74.3474,
            72.3028,
            70.8912,
            69.114,
            67.4646,
            65.9744,
            64.4092,
            62.6022,
            60.843,
            59.5684,
            58.1652,
            56.5426,
            55.4152,
            53.5388,
            52.3592,
            51.1366,
            49.486,
            48.3918,
            46.5076,
            45.509,
            44.3834,
            43.3498,
            42.0668,
            40.7346,
            40.1228,
            38.4528,
            37.7,
            36.644,
            36.0518,
            34.5774,
            33.9068,
            32.432,
            32.1666,
            30.434,
            29.6644,
            28.4894,
            27.6312,
            26.3804,
            26.292,
            25.5496000000001,
            25.0234,
            24.8206,
            22.6146,
            22.4188,
            22.117,
            20.6762,
            20.6576,
            19.7864,
            19.509,
            18.5334,
            17.9204,
            17.772,
            16.2924,
            16.8654,
            15.1836,
            15.745,
            15.1316,
            15.0386,
            14.0136,
            13.6342,
            12.6196,
            12.1866,
            12.4281999999999,
            11.3324,
            10.4794000000001,
            11.5038,
            10.129,
            9.52800000000002,
            10.3203999999999,
            9.46299999999997,
            9.79280000000006,
            9.12300000000005,
            8.74180000000001,
            9.2192,
            7.51020000000005,
            7.60659999999996,
            7.01840000000004,
            7.22239999999999,
            7.40139999999997,
            6.76179999999999,
            7.14359999999999,
            5.65060000000005,
            5.63779999999997,
            5.76599999999996,
            6.75139999999999,
            5.57759999999996,
            3.73220000000003,
            5.8048,
            5.63019999999995,
            4.93359999999996,
            3.47979999999995,
            4.33879999999999,
            3.98940000000005,
            3.81960000000004,
            3.31359999999995,
            3.23080000000004,
            3.4588,
            3.08159999999998,
            3.4076,
            3.00639999999999,
            2.38779999999997,
            2.61900000000003,
            1.99800000000005,
            3.34820000000002,
            2.95060000000001,
            0.990999999999985,
            2.11440000000005,
            2.20299999999997,
            2.82219999999995,
            2.73239999999998,
            2.7826,
            3.76660000000004,
            2.26480000000004,
            2.31280000000004,
            2.40819999999997,
            2.75360000000001,
            3.33759999999995,
            2.71559999999999,
            1.7478000000001,
            1.42920000000004,
            2.39300000000003,
            2.22779999999989,
            2.34339999999997,
            0.87259999999992,
            3.88400000000001,
            1.80600000000004,
            1.91759999999999,
            1.16779999999994,
            1.50320000000011,
            2.52500000000009,
            0.226400000000012,
            2.31500000000005,
            0.930000000000064,
            1.25199999999995,
            2.14959999999996,
            0.0407999999999902,
            2.5447999999999,
            1.32960000000003,
            0.197400000000016,
            2.52620000000002,
            3.33279999999991,
            -1.34300000000007,
            0.422199999999975,
            0.917200000000093,
            1.12920000000008,
            1.46060000000011,
            1.45779999999991,
            2.8728000000001,
            3.33359999999993,
            -1.34079999999994,
            1.57680000000005,
            0.363000000000056,
            1.40740000000005,
            0.656600000000026,
            0.801400000000058,
            -0.454600000000028,
            1.51919999999996,
        ],
        # precision 9
        [
            368,
            361.8294,
            355.2452,
            348.6698,
            342.1464,
            336.2024,
            329.8782,
            323.6598,
            317.462,
            311.2826,
            305.7102,
            299.7416,
            293.9366,
            288.1046,
            282.285,
            277.0668,
            271.306,
            265.8448,
            260.301,
            254.9886,
            250.2422,
            244.8138,
            239.7074,
            234.7428,
            229.8402,
            225.1664,
            220.3534,
            215.594,
            210.6886,
            205.7876,
            201.65,
            197.228,
            192.8036,
            188.1666,
            184.0818,
            180.0824,
            176.2574,
            172.302,
            168.1644,
            164.0056,
            160.3802,
            156.7192,
            152.5234,
            149.2084,
            145.831,
            142.485,
            139.1112,
            135.4764,
            131.76,
            129.3368,
            126.5538,
            122.5058,
            119.2646,
            116.5902,
            113.3818,
            110.8998,
            107.9532,
            105.2062,
            102.2798,
            99.4728,
            96.9582,
            94.3292,
            92.171,
            89.7809999999999,
            87.5716,
            84.7048,
            82.5322,
            79.875,
            78.3972,
            75.3464,
            73.7274,
            71.2834,
            70.1444,
            68.4263999999999,
            66.0166,
            64.018,
            62.0437999999999,
            60.3399999999999,
            58.6856,
            57.9836,
            55.0311999999999,
            54.6769999999999,
            52.3188,
            51.4846,
            49.4423999999999,
            47.739,
            46.1487999999999,
            44.9202,
            43.4059999999999,
            42.5342000000001,
            41.2834,
            38.8954000000001,
            38.3286000000001,
            36.2146,
            36.6684,
            35.9946,
            33.123,
            33.4338,
            31.7378000000001,
            29.076,
            28.9692,
            27.4964,
            27.0998,
            25.9864,
            26.7754,
            24.3208,
            23.4838,
            22.7388000000001,
            24.0758000000001,
            21.9097999999999,
            20.9728,
            19.9228000000001,
            19.9292,
            16.617,
            17.05,
            18.2996000000001,
            15.6128000000001,
            15.7392,
            14.5174,
            13.6322,
            12.2583999999999,
            13.3766000000001,
            11.423,
            13.1232,
            9.51639999999998,
            10.5938000000001,
            9.59719999999993,
            8.12220000000002,
            9.76739999999995,
            7.50440000000003,
            7.56999999999994,
            6.70440000000008,
            6.41419999999994,
            6.71019999999999,
            5.60940000000005,
            4.65219999999999,
            6.84099999999989,
            3.4072000000001,
            3.97859999999991,
            3.32760000000007,
            5.52160000000003,
            3.31860000000006,
            2.06940000000009,
            4.35400000000004,
            1.57500000000005,
            0.280799999999999,
            2.12879999999996,
            -0.214799999999968,
            -0.0378000000000611,
            -0.658200000000079,
            0.654800000000023,
            -0.0697999999999865,
            0.858400000000074,
            -2.52700000000004,
            -2.1751999999999,
            -3.35539999999992,
            -1.04019999999991,
            -0.651000000000067,
            -2.14439999999991,
            -1.96659999999997,
            -3.97939999999994,
            -0.604400000000169,
            -3.08260000000018,
            -3.39159999999993,
            -5.29640000000018,
            -5.38920000000007,
            -5.08759999999984,
            -4.69900000000007,
            -5.23720000000003,
            -3.15779999999995,
            -4.97879999999986,
            -4.89899999999989,
            -7.48880000000008,
            -5.94799999999987,
            -5.68060000000014,
            -6.67180000000008,
            -4.70499999999993,
            -7.27779999999984,
            -4.6579999999999,
            -4.4362000000001,
            -4.32139999999981,
            -5.18859999999995,
            -6.66879999999992,
            -6.48399999999992,
            -5.1260000000002,
            -4.4032000000002,
            -6.13500000000022,
            -5.80819999999994,
            -4.16719999999987,
            -4.15039999999999,
            -7.45600000000013,
            -7.24080000000004,
            -9.83179999999993,
            -5.80420000000004,
            -8.6561999999999,
            -6.99940000000015,
            -10.5473999999999,
            -7.34139999999979,
            -6.80999999999995,
            -6.29719999999998,
        ],
        # precision 10
        [
            737.1256,
            724.4234,
            711.1064,
            698.4732,
            685.4636,
            673.0644,
            660.488,
            647.9654,
            636.0832,
            623.7864,
            612.1992,
            600.2176,
            588.5228,
            577.1716,
            565.7752,
            554.899,
            543.6126,
            532.6492,
            521.9474,
            511.5214,
            501.1064,
            490.6364,
            480.2468,
            470.4588,
            460.3832,
            451.0584,
            440.8606,
            431.3868,
            422.5062,
            413.1862,
            404.463,
            395.339,
            386.1936,
            378.1292,
            369.1854,
            361.2908,
            353.3324,
            344.8518,
            337.5204,
            329.4854,
            321.9318,
            314.552,
            306.4658,
            299.4256,
            292.849,
            286.152,
            278.8956,
            271.8792,
            265.118,
            258.62,
            252.5132,
            245.9322,
            239.7726,
            233.6086,
            227.5332,
            222.5918,
            216.4294,
            210.7662,
            205.4106,
            199.7338,
            194.9012,
            188.4486,
            183.1556,
            178.6338,
            173.7312,
            169.6264,
            163.9526,
            159.8742,
            155.8326,
            151.1966,
            147.5594,
            143.07,
            140.037,
            134.1804,
            131.071,
            127.4884,
            124.0848,
            120.2944,
            117.333,
            112.9626,
            110.2902,
            107.0814,
            103.0334,
            99.4832000000001,
            96.3899999999999,
            93.7202000000002,
            90.1714000000002,
            87.2357999999999,
            85.9346,
            82.8910000000001,
            80.0264000000002,
            78.3834000000002,
            75.1543999999999,
            73.8683999999998,
            70.9895999999999,
            69.4367999999999,
            64.8701999999998,
            65.0408000000002,
            61.6738,
            59.5207999999998,
            57.0158000000001,
            54.2302,
            53.0962,
            50.4985999999999,
            52.2588000000001,
            47.3914,
            45.6244000000002,
            42.8377999999998,
            43.0072,
            40.6516000000001,
            40.2453999999998,
            35.2136,
            36.4546,
            33.7849999999999,
            33.2294000000002,
            32.4679999999998,
            30.8670000000002,
            28.6507999999999,
            28.9099999999999,
            27.5983999999999,
            26.1619999999998,
            24.5563999999999,
            23.2328000000002,
            21.9484000000002,
            21.5902000000001,
            21.3346000000001,
            17.7031999999999,
            20.6111999999998,
            19.5545999999999,
            15.7375999999999,
            17.0720000000001,
            16.9517999999998,
            15.326,
            13.1817999999998,
            14.6925999999999,
            13.0859999999998,
            13.2754,
            10.8697999999999,
            11.248,
            7.3768,
            4.72339999999986,
            7.97899999999981,
            8.7503999999999,
            7.68119999999999,
            9.7199999999998,
            7.73919999999998,
            5.6224000000002,
            7.44560000000001,
            6.6601999999998,
            5.9058,
            4.00199999999995,
            4.51699999999983,
            4.68240000000014,
            3.86220000000003,
            5.13639999999987,
            5.98500000000013,
            2.47719999999981,
            2.61999999999989,
            1.62800000000016,
            4.65000000000009,
            0.225599999999758,
            0.831000000000131,
            -0.359400000000278,
            1.27599999999984,
            -2.92559999999958,
            -0.0303999999996449,
            2.37079999999969,
            -2.0033999999996,
            0.804600000000391,
            0.30199999999968,
            1.1247999999996,
            -2.6880000000001,
            0.0321999999996478,
            -1.18099999999959,
            -3.9402,
            -1.47940000000017,
            -0.188400000000001,
            -2.10720000000038,
            -2.04159999999956,
            -3.12880000000041,
            -4.16160000000036,
            -0.612799999999879,
            -3.48719999999958,
            -8.17900000000009,
            -5.37780000000021,
            -4.01379999999972,
            -5.58259999999973,
            -5.73719999999958,
            -7.66799999999967,
            -5.69520000000011,
            -1.1247999999996,
            -5.58520000000044,
            -8.04560000000038,
            -4.64840000000004,
            -11.6468000000004,
            -7.97519999999986,
            -5.78300000000036,
            -7.67420000000038,
            -10.6328000000003,
            -9.81720000000041,
        ],
        # precision 11
        [
            1476,
            1449.6014,
            1423.5802,
            1397.7942,
            1372.3042,
            1347.2062,
            1321.8402,
            1297.2292,
            1272.9462,
            1248.9926,
            1225.3026,
            1201.4252,
            1178.0578,
            1155.6092,
            1132.626,
            1110.5568,
            1088.527,
            1066.5154,
            1045.1874,
            1024.3878,
            1003.37,
            982.1972,
            962.5728,
            942.1012,
            922.9668,
            903.292,
            884.0772,
            864.8578,
            846.6562,
            828.041,
            809.714,
            792.3112,
            775.1806,
            757.9854,
            740.656,
            724.346,
            707.5154,
            691.8378,
            675.7448,
            659.6722,
            645.5722,
            630.1462,
            614.4124,
            600.8728,
            585.898,
            572.408,
            558.4926,
            544.4938,
            531.6776,
            517.282,
            505.7704,
            493.1012,
            480.7388,
            467.6876,
            456.1872,
            445.5048,
            433.0214,
            420.806,
            411.409,
            400.4144,
            389.4294,
            379.2286,
            369.651,
            360.6156,
            350.337,
            342.083,
            332.1538,
            322.5094,
            315.01,
            305.6686,
            298.1678,
            287.8116,
            280.9978,
            271.9204,
            265.3286,
            257.5706,
            249.6014,
            242.544,
            235.5976,
            229.583,
            220.9438,
            214.672,
            208.2786,
            201.8628,
            195.1834,
            191.505,
            186.1816,
            178.5188,
            172.2294,
            167.8908,
            161.0194,
            158.052,
            151.4588,
            148.1596,
            143.4344,
            138.5238,
            133.13,
            127.6374,
            124.8162,
            118.7894,
            117.3984,
            114.6078,
            109.0858,
            105.1036,
            103.6258,
            98.6018000000004,
            95.7618000000002,
            93.5821999999998,
            88.5900000000001,
            86.9992000000002,
            82.8800000000001,
            80.4539999999997,
            74.6981999999998,
            74.3644000000004,
            73.2914000000001,
            65.5709999999999,
            66.9232000000002,
            65.1913999999997,
            62.5882000000001,
            61.5702000000001,
            55.7035999999998,
            56.1764000000003,
            52.7596000000003,
            53.0302000000001,
            49.0609999999997,
            48.4694,
            44.933,
            46.0474000000004,
            44.7165999999997,
            41.9416000000001,
            39.9207999999999,
            35.6328000000003,
            35.5276000000003,
            33.1934000000001,
            33.2371999999996,
            33.3864000000003,
            33.9228000000003,
            30.2371999999996,
            29.1373999999996,
            25.2272000000003,
            24.2942000000003,
            19.8338000000003,
            18.9005999999999,
            23.0907999999999,
            21.8544000000002,
            19.5176000000001,
            15.4147999999996,
            16.9314000000004,
            18.6737999999996,
            12.9877999999999,
            14.3688000000002,
            12.0447999999997,
            15.5219999999999,
            12.5299999999997,
            14.5940000000001,
            14.3131999999996,
            9.45499999999993,
            12.9441999999999,
            3.91139999999996,
            13.1373999999996,
            5.44720000000052,
            9.82779999999912,
            7.87279999999919,
            3.67760000000089,
            5.46980000000076,
            5.55099999999948,
            5.65979999999945,
            3.89439999999922,
            3.1275999999998,
            5.65140000000065,
            6.3062000000009,
            3.90799999999945,
            1.87060000000019,
            5.17020000000048,
            2.46680000000015,
            0.770000000000437,
            -3.72340000000077,
            1.16400000000067,
            8.05340000000069,
            0.135399999999208,
            2.15940000000046,
            0.766999999999825,
            1.0594000000001,
            3.15500000000065,
            -0.287399999999252,
            2.37219999999979,
            -2.86620000000039,
            -1.63199999999961,
            -2.22979999999916,
            -0.15519999999924,
            -1.46039999999994,
            -0.262199999999211,
            -2.34460000000036,
            -2.8078000000005,
            -3.22179999999935,
            -5.60159999999996,
            -8.42200000000048,
            -9.43740000000071,
            0.161799999999857,
            -10.4755999999998,
        ],
        # precision 12
        [
            2953,
            2900.4782,
            2848.3568,
            2796.3666,
            2745.324,
            2694.9598,
            2644.648,
            2595.539,
            2546.1474,
            2498.2576,
            2450.8376,
            2403.6076,
            2357.451,
            2311.38,
            2266.4104,
            2221.5638,
            2176.9676,
            2134.193,
            2090.838,
            2048.8548,
            2007.018,
            1966.1742,
            1925.4482,
            1885.1294,
            1846.4776,
            1807.4044,
            1768.8724,
            1731.3732,
            1693.4304,
            1657.5326,
            1621.949,
            1586.5532,
            1551.7256,
            1517.6182,
            1483.5186,
            1450.4528,
            1417.865,
            1385.7164,
            1352.6828,
            1322.6708,
            1291.8312,
            1260.9036,
            1231.476,
            1201.8652,
            1173.6718,
            1145.757,
            1119.2072,
            1092.2828,
            1065.0434,
            1038.6264,
            1014.3192,
            988.5746,
            965.0816,
            940.1176,
            917.9796,
            894.5576,
            871.1858,
            849.9144,
            827.1142,
            805.0818,
            783.9664,
            763.9096,
            742.0816,
            724.3962,
            706.3454,
            688.018,
            667.4214,
            650.3106,
            633.0686,
            613.8094,
            597.818,
            581.4248,
            563.834,
            547.363,
            531.5066,
            520.455400000001,
            505.583199999999,
            488.366,
            476.480799999999,
            459.7682,
            450.0522,
            434.328799999999,
            423.952799999999,
            408.727000000001,
            399.079400000001,
            387.252200000001,
            373.987999999999,
            360.852000000001,
            351.6394,
            339.642,
            330.902400000001,
            322.661599999999,
            311.662200000001,
            301.3254,
            291.7484,
            279.939200000001,
            276.7508,
            263.215200000001,
            254.811400000001,
            245.5494,
            242.306399999999,
            234.8734,
            223.787200000001,
            217.7156,
            212.0196,
            200.793,
            195.9748,
            189.0702,
            182.449199999999,
            177.2772,
            170.2336,
            164.741,
            158.613600000001,
            155.311,
            147.5964,
            142.837,
            137.3724,
            132.0162,
            130.0424,
            121.9804,
            120.451800000001,
            114.8968,
            111.585999999999,
            105.933199999999,
            101.705,
            98.5141999999996,
            95.0488000000005,
            89.7880000000005,
            91.4750000000004,
            83.7764000000006,
            80.9698000000008,
            72.8574000000008,
            73.1615999999995,
            67.5838000000003,
            62.6263999999992,
            63.2638000000006,
            66.0977999999996,
            52.0843999999997,
            58.9956000000002,
            47.0912000000008,
            46.4956000000002,
            48.4383999999991,
            47.1082000000006,
            43.2392,
            37.2759999999998,
            40.0283999999992,
            35.1864000000005,
            35.8595999999998,
            32.0998,
            28.027,
            23.6694000000007,
            33.8266000000003,
            26.3736000000008,
            27.2008000000005,
            21.3245999999999,
            26.4115999999995,
            23.4521999999997,
            19.5013999999992,
            19.8513999999996,
            10.7492000000002,
            18.6424000000006,
            13.1265999999996,
            18.2436000000016,
            6.71860000000015,
            3.39459999999963,
            6.33759999999893,
            7.76719999999841,
            0.813999999998487,
            3.82819999999992,
            0.826199999999517,
            8.07440000000133,
            -1.59080000000176,
            5.01780000000144,
            0.455399999998917,
            -0.24199999999837,
            0.174800000000687,
            -9.07640000000174,
            -4.20160000000033,
            -3.77520000000004,
            -4.75179999999818,
            -5.3724000000002,
            -8.90680000000066,
            -6.10239999999976,
            -5.74120000000039,
            -9.95339999999851,
            -3.86339999999836,
            -13.7304000000004,
            -16.2710000000006,
            -7.51359999999841,
            -3.30679999999847,
            -13.1339999999982,
            -10.0551999999989,
            -6.72019999999975,
            -8.59660000000076,
            -10.9307999999983,
            -1.8775999999998,
            -4.82259999999951,
            -13.7788,
            -21.6470000000008,
            -10.6735999999983,
        ],
        # precision 13
        [
            5907.5052,
            5802.2672,
            5697.347,
            5593.5794,
            5491.2622,
            5390.5514,
            5290.3376,
            5191.6952,
            5093.5988,
            4997.3552,
            4902.5972,
            4808.3082,
            4715.5646,
            4624.109,
            4533.8216,
            4444.4344,
            4356.3802,
            4269.2962,
            4183.3784,
            4098.292,
            4014.79,
            3932.4574,
            3850.6036,
            3771.2712,
            3691.7708,
            3615.099,
            3538.1858,
            3463.4746,
            3388.8496,
            3315.6794,
            3244.5448,
            3173.7516,
            3103.3106,
            3033.6094,
            2966.5642,
            2900.794,
            2833.7256,
            2769.81,
            2707.3196,
            2644.0778,
            2583.9916,
            2523.4662,
            2464.124,
            2406.073,
            2347.0362,
            2292.1006,
            2238.1716,
            2182.7514,
            2128.4884,
            2077.1314,
            2025.037,
            1975.3756,
            1928.933,
            1879.311,
            1831.0006,
            1783.2144,
            1738.3096,
            1694.5144,
            1649.024,
            1606.847,
            1564.7528,
            1525.3168,
            1482.5372,
            1443.9668,
            1406.5074,
            1365.867,
            1329.2186,
            1295.4186,
            1257.9716,
            1225.339,
            1193.2972,
            1156.3578,
            1125.8686,
            1091.187,
            1061.4094,
            1029.4188,
            1000.9126,
            972.3272,
            944.004199999999,
            915.7592,
            889.965,
            862.834200000001,
            840.4254,
            812.598399999999,
            785.924200000001,
            763.050999999999,
            741.793799999999,
            721.466,
            699.040799999999,
            677.997200000002,
            649.866999999998,
            634.911800000002,
            609.8694,
            591.981599999999,
            570.2922,
            557.129199999999,
            538.3858,
            521.872599999999,
            502.951400000002,
            495.776399999999,
            475.171399999999,
            459.751,
            439.995200000001,
            426.708999999999,
            413.7016,
            402.3868,
            387.262599999998,
            372.0524,
            357.050999999999,
            342.5098,
            334.849200000001,
            322.529399999999,
            311.613799999999,
            295.848000000002,
            289.273000000001,
            274.093000000001,
            263.329600000001,
            251.389599999999,
            245.7392,
            231.9614,
            229.7952,
            217.155200000001,
            208.9588,
            199.016599999999,
            190.839199999999,
            180.6976,
            176.272799999999,
            166.976999999999,
            162.5252,
            151.196400000001,
            149.386999999999,
            133.981199999998,
            130.0586,
            130.164000000001,
            122.053400000001,
            110.7428,
            108.1276,
            106.232400000001,
            100.381600000001,
            98.7668000000012,
            86.6440000000002,
            79.9768000000004,
            82.4722000000002,
            68.7026000000005,
            70.1186000000016,
            71.9948000000004,
            58.998599999999,
            59.0492000000013,
            56.9818000000014,
            47.5338000000011,
            42.9928,
            51.1591999999982,
            37.2740000000013,
            42.7220000000016,
            31.3734000000004,
            26.8090000000011,
            25.8934000000008,
            26.5286000000015,
            29.5442000000003,
            19.3503999999994,
            26.0760000000009,
            17.9527999999991,
            14.8419999999969,
            10.4683999999979,
            8.65899999999965,
            9.86720000000059,
            4.34139999999752,
            -0.907800000000861,
            -3.32080000000133,
            -0.936199999996461,
            -11.9916000000012,
            -8.87000000000262,
            -6.33099999999831,
            -11.3366000000024,
            -15.9207999999999,
            -9.34659999999712,
            -15.5034000000014,
            -19.2097999999969,
            -15.357799999998,
            -28.2235999999975,
            -30.6898000000001,
            -19.3271999999997,
            -25.6083999999973,
            -24.409599999999,
            -13.6385999999984,
            -33.4473999999973,
            -32.6949999999997,
            -28.9063999999998,
            -31.7483999999968,
            -32.2935999999972,
            -35.8329999999987,
            -47.620600000002,
            -39.0855999999985,
            -33.1434000000008,
            -46.1371999999974,
            -37.5892000000022,
            -46.8164000000033,
            -47.3142000000007,
            -60.2914000000019,
            -37.7575999999972,
        ],
        # precision 14
        [
            11816.475,
            11605.0046,
            11395.3792,
            11188.7504,
            10984.1814,
            10782.0086,
            10582.0072,
            10384.503,
            10189.178,
            9996.2738,
            9806.0344,
            9617.9798,
            9431.394,
            9248.7784,
            9067.6894,
            8889.6824,
            8712.9134,
            8538.8624,
            8368.4944,
            8197.7956,
            8031.8916,
            7866.6316,
            7703.733,
            7544.5726,
            7386.204,
            7230.666,
            7077.8516,
            6926.7886,
            6778.6902,
            6631.9632,
            6487.304,
            6346.7486,
            6206.4408,
            6070.202,
            5935.2576,
            5799.924,
            5671.0324,
            5541.9788,
            5414.6112,
            5290.0274,
            5166.723,
            5047.6906,
            4929.162,
            4815.1406,
            4699.127,
            4588.5606,
            4477.7394,
            4369.4014,
            4264.2728,
            4155.9224,
            4055.581,
            3955.505,
            3856.9618,
            3761.3828,
            3666.9702,
            3575.7764,
            3482.4132,
            3395.0186,
            3305.8852,
            3221.415,
            3138.6024,
            3056.296,
            2970.4494,
            2896.1526,
            2816.8008,
            2740.2156,
            2670.497,
            2594.1458,
            2527.111,
            2460.8168,
            2387.5114,
            2322.9498,
            2260.6752,
            2194.2686,
            2133.7792,
            2074.767,
            2015.204,
            1959.4226,
            1898.6502,
            1850.006,
            1792.849,
            1741.4838,
            1687.9778,
            1638.1322,
            1589.3266,
            1543.1394,
            1496.8266,
            1447.8516,
            1402.7354,
            1361.9606,
            1327.0692,
            1285.4106,
            1241.8112,
            1201.6726,
            1161.973,
            1130.261,
            1094.2036,
            1048.2036,
            1020.6436,
            990.901400000002,
            961.199800000002,
            924.769800000002,
            899.526400000002,
            872.346400000002,
            834.375,
            810.432000000001,
            780.659800000001,
            756.013800000001,
            733.479399999997,
            707.923999999999,
            673.858,
            652.222399999999,
            636.572399999997,
            615.738599999997,
            586.696400000001,
            564.147199999999,
            541.679600000003,
            523.943599999999,
            505.714599999999,
            475.729599999999,
            461.779600000002,
            449.750800000002,
            439.020799999998,
            412.7886,
            400.245600000002,
            383.188199999997,
            362.079599999997,
            357.533799999997,
            334.319000000003,
            327.553399999997,
            308.559399999998,
            291.270199999999,
            279.351999999999,
            271.791400000002,
            252.576999999997,
            247.482400000001,
            236.174800000001,
            218.774599999997,
            220.155200000001,
            208.794399999999,
            201.223599999998,
            182.995600000002,
            185.5268,
            164.547400000003,
            176.5962,
            150.689599999998,
            157.8004,
            138.378799999999,
            134.021200000003,
            117.614399999999,
            108.194000000003,
            97.0696000000025,
            89.6042000000016,
            95.6030000000028,
            84.7810000000027,
            72.635000000002,
            77.3482000000004,
            59.4907999999996,
            55.5875999999989,
            50.7346000000034,
            61.3916000000027,
            50.9149999999936,
            39.0384000000049,
            58.9395999999979,
            29.633600000001,
            28.2032000000036,
            26.0078000000067,
            17.0387999999948,
            9.22000000000116,
            13.8387999999977,
            8.07240000000456,
            14.1549999999988,
            15.3570000000036,
            3.42660000000615,
            6.24820000000182,
            -2.96940000000177,
            -8.79940000000352,
            -5.97860000000219,
            -14.4048000000039,
            -3.4143999999942,
            -13.0148000000045,
            -11.6977999999945,
            -25.7878000000055,
            -22.3185999999987,
            -24.409599999999,
            -31.9756000000052,
            -18.9722000000038,
            -22.8678000000073,
            -30.8972000000067,
            -32.3715999999986,
            -22.3907999999938,
            -43.6720000000059,
            -35.9038,
            -39.7492000000057,
            -54.1641999999993,
            -45.2749999999942,
            -42.2989999999991,
            -44.1089999999967,
            -64.3564000000042,
            -49.9551999999967,
        ],
        # precision 15
        [
            23634.0036,
            23210.8034,
            22792.4744,
            22379.1524,
            21969.7928,
            21565.326,
            21165.3532,
            20770.2806,
            20379.9892,
            19994.7098,
            19613.318,
            19236.799,
            18865.4382,
            18498.8244,
            18136.5138,
            17778.8668,
            17426.2344,
            17079.32,
            16734.778,
            16397.2418,
            16063.3324,
            15734.0232,
            15409.731,
            15088.728,
            14772.9896,
            14464.1402,
            14157.5588,
            13855.5958,
            13559.3296,
            13264.9096,
            12978.326,
            12692.0826,
            12413.8816,
            12137.3192,
            11870.2326,
            11602.5554,
            11340.3142,
            11079.613,
            10829.5908,
            10583.5466,
            10334.0344,
            10095.5072,
            9859.694,
            9625.2822,
            9395.7862,
            9174.0586,
            8957.3164,
            8738.064,
            8524.155,
            8313.7396,
            8116.9168,
            7913.542,
            7718.4778,
            7521.65,
            7335.5596,
            7154.2906,
            6968.7396,
            6786.3996,
            6613.236,
            6437.406,
            6270.6598,
            6107.7958,
            5945.7174,
            5787.6784,
            5635.5784,
            5482.308,
            5337.9784,
            5190.0864,
            5045.9158,
            4919.1386,
            4771.817,
            4645.7742,
            4518.4774,
            4385.5454,
            4262.6622,
            4142.74679999999,
            4015.5318,
            3897.9276,
            3790.7764,
            3685.13800000001,
            3573.6274,
            3467.9706,
            3368.61079999999,
            3271.5202,
            3170.3848,
            3076.4656,
            2982.38400000001,
            2888.4664,
            2806.4868,
            2711.9564,
            2634.1434,
            2551.3204,
            2469.7662,
            2396.61139999999,
            2318.9902,
            2243.8658,
            2171.9246,
            2105.01360000001,
            2028.8536,
            1960.9952,
            1901.4096,
            1841.86079999999,
            1777.54700000001,
            1714.5802,
            1654.65059999999,
            1596.311,
            1546.2016,
            1492.3296,
            1433.8974,
            1383.84600000001,
            1339.4152,
            1293.5518,
            1245.8686,
            1193.50659999999,
            1162.27959999999,
            1107.19439999999,
            1069.18060000001,
            1035.09179999999,
            999.679000000004,
            957.679999999993,
            925.300199999998,
            888.099400000006,
            848.638600000006,
            818.156400000007,
            796.748399999997,
            752.139200000005,
            725.271200000003,
            692.216,
            671.633600000001,
            647.939799999993,
            621.670599999998,
            575.398799999995,
            561.226599999995,
            532.237999999998,
            521.787599999996,
            483.095799999996,
            467.049599999998,
            465.286399999997,
            415.548599999995,
            401.047399999996,
            380.607999999993,
            377.362599999993,
            347.258799999996,
            338.371599999999,
            310.096999999994,
            301.409199999995,
            276.280799999993,
            265.586800000005,
            258.994399999996,
            223.915999999997,
            215.925399999993,
            213.503800000006,
            191.045400000003,
            166.718200000003,
            166.259000000005,
            162.941200000001,
            148.829400000002,
            141.645999999993,
            123.535399999993,
            122.329800000007,
            89.473399999988,
            80.1962000000058,
            77.5457999999926,
            59.1056000000099,
            83.3509999999951,
            52.2906000000075,
            36.3979999999865,
            40.6558000000077,
            42.0003999999899,
            19.6630000000005,
            19.7153999999864,
            -8.38539999999921,
            -0.692799999989802,
            0.854800000000978,
            3.23219999999856,
            -3.89040000000386,
            -5.25880000001052,
            -24.9052000000083,
            -22.6837999999989,
            -26.4286000000138,
            -34.997000000003,
            -37.0216000000073,
            -43.430400000012,
            -58.2390000000014,
            -68.8034000000043,
            -56.9245999999985,
            -57.8583999999973,
            -77.3097999999882,
            -73.2793999999994,
            -81.0738000000129,
            -87.4530000000086,
            -65.0254000000132,
            -57.296399999992,
            -96.2746000000043,
            -103.25,
            -96.081600000005,
            -91.5542000000132,
            -102.465200000006,
            -107.688599999994,
            -101.458000000013,
        ],
        # precision 16
        [
            47270,
            46423.3584,
            45585.7074,
            44757.152,
            43938.8416,
            43130.9514,
            42330.03,
            41540.407,
            40759.6348,
            39988.206,
            39226.5144,
            38473.2096,
            37729.795,
            36997.268,
            36272.6448,
            35558.665,
            34853.0248,
            34157.4472,
            33470.5204,
            32793.5742,
            32127.0194,
            31469.4182,
            30817.6136,
            30178.6968,
            29546.8908,
            28922.8544,
            28312.271,
            27707.0924,
            27114.0326,
            26526.692,
            25948.6336,
            25383.7826,
            24823.5998,
            24272.2974,
            23732.2572,
            23201.4976,
            22674.2796,
            22163.6336,
            21656.515,
            21161.7362,
            20669.9368,
            20189.4424,
            19717.3358,
            19256.3744,
            18795.9638,
            18352.197,
            17908.5738,
            17474.391,
            17052.918,
            16637.2236,
            16228.4602,
            15823.3474,
            15428.6974,
            15043.0284,
            14667.6278,
            14297.4588,
            13935.2882,
            13578.5402,
            13234.6032,
            12882.1578,
            12548.0728,
            12219.231,
            11898.0072,
            11587.2626,
            11279.9072,
            10973.5048,
            10678.5186,
            10392.4876,
            10105.2556,
            9825.766,
            9562.5444,
            9294.2222,
            9038.2352,
            8784.848,
            8533.2644,
            8301.7776,
            8058.30859999999,
            7822.94579999999,
            7599.11319999999,
            7366.90779999999,
            7161.217,
            6957.53080000001,
            6736.212,
            6548.21220000001,
            6343.06839999999,
            6156.28719999999,
            5975.15419999999,
            5791.75719999999,
            5621.32019999999,
            5451.66,
            5287.61040000001,
            5118.09479999999,
            4957.288,
            4798.4246,
            4662.17559999999,
            4512.05900000001,
            4364.68539999999,
            4220.77720000001,
            4082.67259999999,
            3957.19519999999,
            3842.15779999999,
            3699.3328,
            3583.01180000001,
            3473.8964,
            3338.66639999999,
            3233.55559999999,
            3117.799,
            3008.111,
            2909.69140000001,
            2814.86499999999,
            2719.46119999999,
            2624.742,
            2532.46979999999,
            2444.7886,
            2370.1868,
            2272.45259999999,
            2196.19260000001,
            2117.90419999999,
            2023.2972,
            1969.76819999999,
            1885.58979999999,
            1833.2824,
            1733.91200000001,
            1682.54920000001,
            1604.57980000001,
            1556.11240000001,
            1491.3064,
            1421.71960000001,
            1371.22899999999,
            1322.1324,
            1264.7892,
            1196.23920000001,
            1143.8474,
            1088.67240000001,
            1073.60380000001,
            1023.11660000001,
            959.036400000012,
            927.433199999999,
            906.792799999996,
            853.433599999989,
            841.873800000001,
            791.1054,
            756.899999999994,
            704.343200000003,
            672.495599999995,
            622.790399999998,
            611.254799999995,
            567.283200000005,
            519.406599999988,
            519.188400000014,
            495.312800000014,
            451.350799999986,
            443.973399999988,
            431.882199999993,
            392.027000000002,
            380.924200000009,
            345.128999999986,
            298.901400000002,
            287.771999999997,
            272.625,
            247.253000000026,
            222.490600000019,
            223.590000000026,
            196.407599999977,
            176.425999999978,
            134.725199999986,
            132.4804,
            110.445599999977,
            86.7939999999944,
            56.7038000000175,
            64.915399999998,
            38.3726000000024,
            37.1606000000029,
            46.170999999973,
            49.1716000000015,
            15.3362000000197,
            6.71639999997569,
            -34.8185999999987,
            -39.4476000000141,
            12.6830000000191,
            -12.3331999999937,
            -50.6565999999875,
            -59.9538000000175,
            -65.1054000000004,
            -70.7576000000117,
            -106.325200000021,
            -126.852200000023,
            -110.227599999984,
            -132.885999999999,
            -113.897200000007,
            -142.713800000027,
            -151.145399999979,
            -150.799200000009,
            -177.756200000003,
            -156.036399999983,
            -182.735199999996,
            -177.259399999981,
            -198.663600000029,
            -174.577600000019,
            -193.84580000001,
        ],
    ],
    dtype=np.float64,
)
