"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const ec2 = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-ec2-vpc-gateway');
const vpc = new ec2.Vpc(stack, 'MyVpc', {
    maxAzs: 1,
    subnetConfiguration: [
        {
            subnetType: ec2.SubnetType.PUBLIC,
            name: 'Public',
        },
        {
            subnetType: ec2.SubnetType.ISOLATED,
            name: 'Isolated',
        },
    ],
});
vpc.isolatedSubnets[0].addRoute('MyRoute', {
    routerId: vpc.internetGatewayId,
    routerType: ec2.RouterType.GATEWAY,
    destinationCidrBlock: '8.8.8.8/32',
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcudnBjLWdhdGV3YXkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnRlZy52cGMtZ2F0ZXdheS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHFDQUFxQztBQUNyQyw4QkFBOEI7QUFFOUIsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7QUFDMUIsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSx5QkFBeUIsQ0FBQyxDQUFDO0FBRTVELE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsQ0FBQyxLQUFLLEVBQUUsT0FBTyxFQUFFO0lBQ3RDLE1BQU0sRUFBRSxDQUFDO0lBQ1QsbUJBQW1CLEVBQUU7UUFDbkI7WUFDRSxVQUFVLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxNQUFNO1lBQ2pDLElBQUksRUFBRSxRQUFRO1NBQ2Y7UUFDRDtZQUNFLFVBQVUsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLFFBQVE7WUFDbkMsSUFBSSxFQUFFLFVBQVU7U0FDakI7S0FDRjtDQUNGLENBQUMsQ0FBQztBQUVGLEdBQUcsQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFnQixDQUFDLFFBQVEsQ0FBQyxTQUFTLEVBQUU7SUFDekQsUUFBUSxFQUFFLEdBQUcsQ0FBQyxpQkFBa0I7SUFDaEMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsT0FBTztJQUNsQyxvQkFBb0IsRUFBRSxZQUFZO0NBQ25DLENBQUMsQ0FBQztBQUVILEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCAqIGFzIGVjMiBmcm9tICcuLi9saWInO1xuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKGFwcCwgJ2F3cy1jZGstZWMyLXZwYy1nYXRld2F5Jyk7XG5cbmNvbnN0IHZwYyA9IG5ldyBlYzIuVnBjKHN0YWNrLCAnTXlWcGMnLCB7XG4gIG1heEF6czogMSxcbiAgc3VibmV0Q29uZmlndXJhdGlvbjogW1xuICAgIHtcbiAgICAgIHN1Ym5ldFR5cGU6IGVjMi5TdWJuZXRUeXBlLlBVQkxJQyxcbiAgICAgIG5hbWU6ICdQdWJsaWMnLFxuICAgIH0sXG4gICAge1xuICAgICAgc3VibmV0VHlwZTogZWMyLlN1Ym5ldFR5cGUuSVNPTEFURUQsXG4gICAgICBuYW1lOiAnSXNvbGF0ZWQnLFxuICAgIH0sXG4gIF0sXG59KTtcblxuKHZwYy5pc29sYXRlZFN1Ym5ldHNbMF0gYXMgZWMyLlN1Ym5ldCkuYWRkUm91dGUoJ015Um91dGUnLCB7XG4gIHJvdXRlcklkOiB2cGMuaW50ZXJuZXRHYXRld2F5SWQhLFxuICByb3V0ZXJUeXBlOiBlYzIuUm91dGVyVHlwZS5HQVRFV0FZLFxuICBkZXN0aW5hdGlvbkNpZHJCbG9jazogJzguOC44LjgvMzInLFxufSk7XG5cbmFwcC5zeW50aCgpO1xuIl19