#!/usr/bin/env python
# -*- coding: utf-8; -*-

# Copyright (c) 2021, 2023 Oracle and/or its affiliates.
# Licensed under the Universal Permissive License v 1.0 as shown at https://oss.oracle.com/licenses/upl/
"""
This is a driver script auto-generated by Oracle ADS to run Python script in OCI Data Science Jobs.

The following environment variables are used:
CODE_ENTRYPOINT:
    Relative path to the entry script/module file in the user code directory.
ENTRY_FUNCTION:
    Optional, function name in the entry script/module to be invoked.
    If this is not specified, the entry script will be run as Python script.
PYTHON_PATH:
    Optional, additional paths to be added to sys.path for looking up modules and packages.
    The root of the user code will be added by default.
    Multiple paths can be separated by os.pathsep, which is colon(:) for Linux and Mac, semicolon(;) for Windows.
OUTPUT_DIR:
    Optional, output directory to be copied to object storage.
OUTPUT_URI:
    Optional, object storage URI for saving files from the output directory.
WORKING_DIR:
    Optional, the working directory of the user code.
    This can be specified as a relative path from /home/datascience/decompressed_artifact/code
    If this is not specified, the working directory will be /home/datascience/decompressed_artifact/code

This module requires the following package:
oci


"""
try:
    # This is used by ADS and testing
    from .driver_utils import OCIHelper, JobRunner
except ImportError:
    # This is used when the script is in a job run.
    from driver_utils import OCIHelper, JobRunner


def main():
    """The main function for running the job."""
    JobRunner().set_working_dir().conda_unpack().setup_python_path().run()
    OCIHelper.copy_outputs()


if __name__ == "__main__":
    main()
