"""Functions to convert WCxf files to MadGraph param_cards for SMEFTsim."""

from numpy import angle
from collections import OrderedDict
from wilson.wcxf.converters.SMEFTsim_param_card_elements import *
from wilson.util import smeftutil


def initialize_smeftsim_card(model_set):

  if model_set == 'A':
    # initialize card with empty blocks
    card = {'Block': OrderedDict()}
    card['Block']['FRBlock'] = OrderedDict()
    card['Block']['FRBlock10'] = OrderedDict()
    card['Block']['FRBlock11'] = OrderedDict()
    card['Block']['FRBlock12'] = OrderedDict()
    card['Block']['FRBlock13'] = OrderedDict()
    card['Block']['FRBlock14'] = OrderedDict()
    card['Block']['FRBlock15'] = OrderedDict()
    card['Block']['FRBlock16'] = OrderedDict()
    card['Block']['FRBlock17'] = OrderedDict()
    card['Block']['FRBlock18'] = OrderedDict()
    card['Block']['FRBlock19'] = OrderedDict()
    card['Block']['FRBlock2'] = OrderedDict()
    card['Block']['FRBlock20'] = OrderedDict()
    card['Block']['FRBlock21'] = OrderedDict()
    card['Block']['FRBlock25'] = OrderedDict()
    card['Block']['FRBlock26'] = OrderedDict()
    card['Block']['FRBlock27'] = OrderedDict()
    card['Block']['FRBlock28'] = OrderedDict()
    card['Block']['FRBlock29'] = OrderedDict()
    card['Block']['FRBlock3'] = OrderedDict()
    card['Block']['FRBlock30'] = OrderedDict()
    card['Block']['FRBlock31'] = OrderedDict()
    card['Block']['FRBlock32'] = OrderedDict()
    card['Block']['FRBlock4'] = OrderedDict()
    card['Block']['FRBlock48'] = OrderedDict()
    card['Block']['FRBlock5'] = OrderedDict()
    card['Block']['FRBlock6'] = OrderedDict()
    card['Block']['FRBlock7'] = OrderedDict()
    card['Block']['FRBlock70'] = OrderedDict()
    card['Block']['FRBlock71'] = OrderedDict()
    card['Block']['FRBlock72'] = OrderedDict()
    card['Block']['FRBlock73'] = OrderedDict()
    card['Block']['FRBlock74'] = OrderedDict()
    card['Block']['FRBlock8'] = OrderedDict()
    card['Block']['FRBlock9'] = OrderedDict()

  elif model_set == 'B':
    card = {'Block': OrderedDict()}
    card['Block']['FRBlock'] = OrderedDict()
    card['Block']['FRBlock10'] = OrderedDict()
    card['Block']['FRBlock11'] = OrderedDict()
    card['Block']['FRBlock15'] = OrderedDict()
    card['Block']['FRBlock16'] = OrderedDict()
    card['Block']['FRBlock18'] = OrderedDict()
    card['Block']['FRBlock19'] = OrderedDict()
    card['Block']['FRBlock21'] = OrderedDict()
    card['Block']['FRBlock22'] = OrderedDict()
    card['Block']['FRBlock24'] = OrderedDict()
    card['Block']['FRBlock25'] = OrderedDict()
    card['Block']['FRBlock27'] = OrderedDict()
    card['Block']['FRBlock28'] = OrderedDict()
    card['Block']['FRBlock30'] = OrderedDict()
    card['Block']['FRBlock31'] = OrderedDict()
    card['Block']['FRBlock33'] = OrderedDict()
    card['Block']['FRBlock34'] = OrderedDict()
    card['Block']['FRBlock36'] = OrderedDict()
    card['Block']['FRBlock37'] = OrderedDict()
    card['Block']['FRBlock45'] = OrderedDict()
    card['Block']['FRBlock46'] = OrderedDict()
    card['Block']['FRBlock6'] = OrderedDict()
    card['Block']['FRBlock69'] = OrderedDict()
    card['Block']['FRBlock7'] = OrderedDict()
    card['Block']['FRBlock70'] = OrderedDict()
    card['Block']['FRBlock72'] = OrderedDict()
    card['Block']['FRBlock73'] = OrderedDict()
    card['Block']['FRBlock75'] = OrderedDict()
    card['Block']['FRBlock76'] = OrderedDict()
    card['Block']['FRBlock78'] = OrderedDict()
    card['Block']['FRBlock79'] = OrderedDict()
    card['Block']['FRBlock8'] = OrderedDict()
    card['Block']['FRBlock81'] = OrderedDict()
    card['Block']['FRBlock82'] = OrderedDict()
    card['Block']['FRBlock9'] = OrderedDict()
    card['Block']['NEWCOUP'] = OrderedDict()

  return card


def smeftsim_card_fill(card, wc, model_set, lambda_smeft_value, input_scheme_value):

  _symm_fac = smeftutil.arrays2wcxf(smeftutil._scale_dict)
  def scaled_wc(key):
      """Return the coefficient scaled by the appropriate symmetry factor
      to account for the change from the flavor-non-redundant WCxf convention
      to the symmetrized SMEFTsim convention."""
      return wc[key] / _symm_fac[key]


  if model_set == 'A':
      # set block entries to WC values
      card['Block']['FRBlock'] = {'values': [
	  [1, format(angle(scaled_wc('phil1_12')),'.6e'), '# cHl1Ph12'],
	  [2, format(angle(scaled_wc('phil1_13')),'.6e'), '# cHl1Ph13'],
	  [3, format(angle(scaled_wc('phil1_23')),'.6e'), '# cHl1Ph23'],
	  [4, format(angle(scaled_wc('phil3_12')),'.6e'), '# cHl3Ph12'],
	  [5, format(angle(scaled_wc('phil3_13')),'.6e'), '# cHl3Ph13'],
	  [6, format(angle(scaled_wc('phil3_23')),'.6e'), '# cHl3Ph23'],
	  [7, format(angle(scaled_wc('phie_12')),'.6e'), '# cHePh12'],
	  [8, format(angle(scaled_wc('phie_13')),'.6e'), '# cHePh13'],
	  [9, format(angle(scaled_wc('phie_23')),'.6e'), '# cHePh23'],
	  [10, format(angle(scaled_wc('phiq1_12')),'.6e'), '# cHq1Ph12'],
	  [11, format(angle(scaled_wc('phiq1_13')),'.6e'), '# cHq1Ph13'],
	  [12, format(angle(scaled_wc('phiq1_23')),'.6e'), '# cHq1Ph23'],
	  [13, format(angle(scaled_wc('phiq3_12')),'.6e'), '# cHq3Ph12'],
	  [14, format(angle(scaled_wc('phiq3_13')),'.6e'), '# cHq3Ph13'],
	  [15, format(angle(scaled_wc('phiq3_23')),'.6e'), '# cHq3Ph23'],
	  [16, format(angle(scaled_wc('phiu_12')),'.6e'), '# cHuPh12'],
	  [17, format(angle(scaled_wc('phiu_13')),'.6e'), '# cHuPh13'],
	  [18, format(angle(scaled_wc('phiu_23')),'.6e'), '# cHuPh23'],
	  [19, format(angle(scaled_wc('phid_12')),'.6e'), '# cHdPh12'],
	  [20, format(angle(scaled_wc('phid_13')),'.6e'), '# cHdPh13'],
	  [21, format(angle(scaled_wc('phid_23')),'.6e'), '# cHdPh23'],
	  [22, format(angle(scaled_wc('ll_1112')),'.6e'), '# cllPh1112'],
	  [23, format(angle(scaled_wc('ll_1113')),'.6e'), '# cllPh1113'],
	  [24, format(angle(scaled_wc('ll_1123')),'.6e'), '# cllPh1123'],
	  [25, format(angle(scaled_wc('ll_1212')),'.6e'), '# cllPh1212'],
	  [26, format(angle(scaled_wc('ll_1213')),'.6e'), '# cllPh1213'],
	  [27, format(angle(scaled_wc('ll_1231')),'.6e'), '# cllPh1231'],
	  [28, format(angle(scaled_wc('ll_1222')),'.6e'), '# cllPh1222'],
	  [29, format(angle(scaled_wc('ll_1223')),'.6e'), '# cllPh1223'],
	  [30, format(angle(scaled_wc('ll_1232')),'.6e'), '# cllPh1232'],
	  [31, format(angle(scaled_wc('ll_1233')),'.6e'), '# cllPh1233'],
	  [32, format(angle(scaled_wc('ll_1313')),'.6e'), '# cllPh1313'],
	  [33, format(angle(scaled_wc('ll_1322')),'.6e'), '# cllPh1322'],
	  [34, format(angle(scaled_wc('ll_1332')),'.6e'), '# cllPh1332'],
	  [35, format(angle(scaled_wc('ll_1323')),'.6e'), '# cllPh1323'],
	  [36, format(angle(scaled_wc('ll_1333')),'.6e'), '# cllPh1333'],
	  [37, format(angle(scaled_wc('ll_2223')),'.6e'), '# cllPh2223'],
	  [38, format(angle(scaled_wc('ll_2323')),'.6e'), '# cllPh2323'],
	  [39, format(angle(scaled_wc('ll_2333')),'.6e'), '# cllPh3323'],
	  [40, format(angle(scaled_wc('qq1_1112')),'.6e'), '# cqq1Ph1112'],
	  [41, format(angle(scaled_wc('qq1_1113')),'.6e'), '# cqq1Ph1113'],
	  [42, format(angle(scaled_wc('qq1_1123')),'.6e'), '# cqq1Ph1123'],
	  [43, format(angle(scaled_wc('qq1_1212')),'.6e'), '# cqq1Ph1212'],
	  [44, format(angle(scaled_wc('qq1_1213')),'.6e'), '# cqq1Ph1213'],
	  [45, format(angle(scaled_wc('qq1_1231')),'.6e'), '# cqq1Ph1231'],
	  [46, format(angle(scaled_wc('qq1_1222')),'.6e'), '# cqq1Ph1222'],
	  [47, format(angle(scaled_wc('qq1_1223')),'.6e'), '# cqq1Ph1223'],
	  [48, format(angle(scaled_wc('qq1_1232')),'.6e'), '# cqq1Ph1232'],
	  [49, format(angle(scaled_wc('qq1_1233')),'.6e'), '# cqq1Ph1233'],
	  [50, format(angle(scaled_wc('qq1_1313')),'.6e'), '# cqq1Ph1313'],
	  [51, format(angle(scaled_wc('qq1_1322')),'.6e'), '# cqq1Ph1322'],
	  [52, format(angle(scaled_wc('qq1_1332')),'.6e'), '# cqq1Ph1332'],
	  [53, format(angle(scaled_wc('qq1_1323')),'.6e'), '# cqq1Ph1323'],
	  [54, format(angle(scaled_wc('qq1_1333')),'.6e'), '# cqq1Ph1333'],
	  [55, format(angle(scaled_wc('qq1_2223')),'.6e'), '# cqq1Ph2223'],
	  [56, format(angle(scaled_wc('qq1_2323')),'.6e'), '# cqq1Ph2323'],
	  [57, format(angle(scaled_wc('qq1_2333')),'.6e'), '# cqq1Ph3323'],
	  [58, format(angle(scaled_wc('qq3_1112')),'.6e'), '# cqq3Ph1112'],
	  [59, format(angle(scaled_wc('qq3_1113')),'.6e'), '# cqq3Ph1113'],
	  [60, format(angle(scaled_wc('qq3_1123')),'.6e'), '# cqq3Ph1123'],
	  [61, format(angle(scaled_wc('qq3_1212')),'.6e'), '# cqq3Ph1212'],
	  [62, format(angle(scaled_wc('qq3_1213')),'.6e'), '# cqq3Ph1213'],
	  [63, format(angle(scaled_wc('qq3_1231')),'.6e'), '# cqq3Ph1231'],
	  [64, format(angle(scaled_wc('qq3_1222')),'.6e'), '# cqq3Ph1222'],
	  [65, format(angle(scaled_wc('qq3_1223')),'.6e'), '# cqq3Ph1223'],
	  [66, format(angle(scaled_wc('qq3_1232')),'.6e'), '# cqq3Ph1232'],
	  [67, format(angle(scaled_wc('qq3_1233')),'.6e'), '# cqq3Ph1233'],
	  [68, format(angle(scaled_wc('qq3_1313')),'.6e'), '# cqq3Ph1313'],
	  [69, format(angle(scaled_wc('qq3_1322')),'.6e'), '# cqq3Ph1322'],
	  [70, format(angle(scaled_wc('qq3_1332')),'.6e'), '# cqq3Ph1332'],
	  [71, format(angle(scaled_wc('qq3_1323')),'.6e'), '# cqq3Ph1323'],
	  [72, format(angle(scaled_wc('qq3_1333')),'.6e'), '# cqq3Ph1333'],
	  [73, format(angle(scaled_wc('qq3_2223')),'.6e'), '# cqq3Ph2223'],
	  [74, format(angle(scaled_wc('qq3_2323')),'.6e'), '# cqq3Ph2323'],
	  [75, format(angle(scaled_wc('qq3_2333')),'.6e'), '# cqq3Ph3323'],
	  [76, format(angle(scaled_wc('uu_1112')),'.6e'), '# cuuPh1112'],
	  [77, format(angle(scaled_wc('uu_1113')),'.6e'), '# cuuPh1113'],
	  [78, format(angle(scaled_wc('uu_1123')),'.6e'), '# cuuPh1123'],
	  [79, format(angle(scaled_wc('uu_1212')),'.6e'), '# cuuPh1212'],
	  [80, format(angle(scaled_wc('uu_1213')),'.6e'), '# cuuPh1213'],
	  [81, format(angle(scaled_wc('uu_1231')),'.6e'), '# cuuPh1231'],
	  [82, format(angle(scaled_wc('uu_1222')),'.6e'), '# cuuPh1222'],
	  [83, format(angle(scaled_wc('uu_1223')),'.6e'), '# cuuPh1223'],
	  [84, format(angle(scaled_wc('uu_1232')),'.6e'), '# cuuPh1232'],
	  [85, format(angle(scaled_wc('uu_1233')),'.6e'), '# cuuPh1233'],
	  [86, format(angle(scaled_wc('uu_1313')),'.6e'), '# cuuPh1313'],
	  [87, format(angle(scaled_wc('uu_1322')),'.6e'), '# cuuPh1322'],
	  [88, format(angle(scaled_wc('uu_1332')),'.6e'), '# cuuPh1332'],
	  [89, format(angle(scaled_wc('uu_1323')),'.6e'), '# cuuPh1323'],
	  [90, format(angle(scaled_wc('uu_1333')),'.6e'), '# cuuPh1333'],
	  [91, format(angle(scaled_wc('uu_2223')),'.6e'), '# cuuPh2223'],
	  [92, format(angle(scaled_wc('uu_2323')),'.6e'), '# cuuPh2323'],
	  [93, format(angle(scaled_wc('uu_2333')),'.6e'), '# cuuPh3323'],
	  [94, format(angle(scaled_wc('dd_1112')),'.6e'), '# cddPh1112'],
	  [95, format(angle(scaled_wc('dd_1113')),'.6e'), '# cddPh1113'],
	  [96, format(angle(scaled_wc('dd_1123')),'.6e'), '# cddPh1123'],
	  [97, format(angle(scaled_wc('dd_1212')),'.6e'), '# cddPh1212'],
	  [98, format(angle(scaled_wc('dd_1213')),'.6e'), '# cddPh1213'],
	  [99, format(angle(scaled_wc('dd_1231')),'.6e'), '# cddPh1231'],
	  [100, format(angle(scaled_wc('dd_1222')),'.6e'), '# cddPh1222'],
	  [101, format(angle(scaled_wc('dd_1223')),'.6e'), '# cddPh1223'],
	  [102, format(angle(scaled_wc('dd_1232')),'.6e'), '# cddPh1232'],
	  [103, format(angle(scaled_wc('dd_1233')),'.6e'), '# cddPh1233'],
	  [104, format(angle(scaled_wc('dd_1313')),'.6e'), '# cddPh1313'],
	  [105, format(angle(scaled_wc('dd_1322')),'.6e'), '# cddPh1322'],
	  [106, format(angle(scaled_wc('dd_1332')),'.6e'), '# cddPh1332'],
	  [107, format(angle(scaled_wc('dd_1323')),'.6e'), '# cddPh1323'],
	  [108, format(angle(scaled_wc('dd_1333')),'.6e'), '# cddPh1333'],
	  [109, format(angle(scaled_wc('dd_2223')),'.6e'), '# cddPh2223'],
	  [110, format(angle(scaled_wc('dd_2323')),'.6e'), '# cddPh2323'],
	  [111, format(angle(scaled_wc('dd_2333')),'.6e'), '# cddPh3323'],
	  [112, format(angle(scaled_wc('ee_1112')),'.6e'), '# ceePh1112'],
	  [113, format(angle(scaled_wc('ee_1113')),'.6e'), '# ceePh1113'],
	  [114, format(angle(scaled_wc('ee_1123')),'.6e'), '# ceePh1123'],
	  [115, format(angle(scaled_wc('ee_1212')),'.6e'), '# ceePh1212'],
	  [116, format(angle(scaled_wc('ee_1213')),'.6e'), '# ceePh1213'],
	  [117, format(angle(scaled_wc('ee_1222')),'.6e'), '# ceePh1222'],
	  [118, format(angle(scaled_wc('ee_1232')),'.6e'), '# ceePh1232'],
	  [119, format(angle(scaled_wc('ee_1233')),'.6e'), '# ceePh1233'],
	  [120, format(angle(scaled_wc('ee_1313')),'.6e'), '# ceePh1313'],
	  [121, format(angle(scaled_wc('ee_1223')),'.6e'), '# ceePh1322'], # element 1322 replaced with 1223 in wcxf
	  [122, format(angle(scaled_wc('ee_1323')),'.6e'), '# ceePh1323'],
	  [123, format(angle(scaled_wc('ee_1333')),'.6e'), '# ceePh1333'],
	  [124, format(angle(scaled_wc('ee_2223')),'.6e'), '# ceePh2223'],
	  [125, format(angle(scaled_wc('ee_2323')),'.6e'), '# ceePh2323'],
	  [126, format(angle(scaled_wc('ee_2333')),'.6e'), '# ceePh3323'],
	  [127, format(angle(scaled_wc('lq1_1112')),'.6e'), '# clq1Ph1112'],
	  [128, format(angle(scaled_wc('lq1_1113')),'.6e'), '# clq1Ph1113'],
	  [129, format(angle(scaled_wc('lq1_1123')),'.6e'), '# clq1Ph1123'],
	  [130, format(angle(scaled_wc('lq1_1211')),'.6e'), '# clq1Ph1211'],
	  [131, format(angle(scaled_wc('lq1_1212')),'.6e'), '# clq1Ph1212'],
	  [132, format(angle(scaled_wc('lq1_1221')),'.6e'), '# clq1Ph1221'],
	  [133, format(angle(scaled_wc('lq1_1213')),'.6e'), '# clq1Ph1213'],
	  [134, format(angle(scaled_wc('lq1_1231')),'.6e'), '# clq1Ph1231'],
	  [135, format(angle(scaled_wc('lq1_1222')),'.6e'), '# clq1Ph1222'],
	  [136, format(angle(scaled_wc('lq1_1223')),'.6e'), '# clq1Ph1223'],
	  [137, format(angle(scaled_wc('lq1_1232')),'.6e'), '# clq1Ph1232'],
	  [138, format(angle(scaled_wc('lq1_1233')),'.6e'), '# clq1Ph1233'],
	  [139, format(angle(scaled_wc('lq1_1311')),'.6e'), '# clq1Ph1311'],
	  [140, format(angle(scaled_wc('lq1_1312')),'.6e'), '# clq1Ph1312'],
	  [141, format(angle(scaled_wc('lq1_1313')),'.6e'), '# clq1Ph1313'],
	  [142, format(angle(scaled_wc('lq1_1331')),'.6e'), '# clq1Ph1331'],
	  [143, format(angle(scaled_wc('lq1_1321')),'.6e'), '# clq1Ph1321'],
	  [144, format(angle(scaled_wc('lq1_1322')),'.6e'), '# clq1Ph1322'],
	  [145, format(angle(scaled_wc('lq1_1332')),'.6e'), '# clq1Ph1332'],
	  [146, format(angle(scaled_wc('lq1_1323')),'.6e'), '# clq1Ph1323'],
	  [147, format(angle(scaled_wc('lq1_1333')),'.6e'), '# clq1Ph1333'],
	  [148, format(angle(scaled_wc('lq1_2212')),'.6e'), '# clq1Ph2212'],
	  [149, format(angle(scaled_wc('lq1_2213')),'.6e'), '# clq1Ph2213'],
	  [150, format(angle(scaled_wc('lq1_2223')),'.6e'), '# clq1Ph2223'],
	  [151, format(angle(scaled_wc('lq1_2311')),'.6e'), '# clq1Ph2311'],
	  [152, format(angle(scaled_wc('lq1_2312')),'.6e'), '# clq1Ph2312'],
	  [153, format(angle(scaled_wc('lq1_2313')),'.6e'), '# clq1Ph2313'],
	  [154, format(angle(scaled_wc('lq1_2321')),'.6e'), '# clq1Ph2321'],
	  [155, format(angle(scaled_wc('lq1_2322')),'.6e'), '# clq1Ph2322'],
	  [156, format(angle(scaled_wc('lq1_2323')),'.6e'), '# clq1Ph2323'],
	  [157, format(angle(scaled_wc('lq1_2331')),'.6e'), '# clq1Ph2331'],
	  [158, format(angle(scaled_wc('lq1_2332')),'.6e'), '# clq1Ph2332'],
	  [159, format(angle(scaled_wc('lq1_2333')),'.6e'), '# clq1Ph2333'],
	  [160, format(angle(scaled_wc('lq1_3312')),'.6e'), '# clq1Ph3312'],
	  [161, format(angle(scaled_wc('lq1_3313')),'.6e'), '# clq1Ph3313'],
	  [162, format(angle(scaled_wc('lq1_3323')),'.6e'), '# clq1Ph3323'],
	  [163, format(angle(scaled_wc('lq3_1112')),'.6e'), '# clq3Ph1112'],
	  [164, format(angle(scaled_wc('lq3_1113')),'.6e'), '# clq3Ph1113'],
	  [165, format(angle(scaled_wc('lq3_1123')),'.6e'), '# clq3Ph1123'],
	  [166, format(angle(scaled_wc('lq3_1211')),'.6e'), '# clq3Ph1211'],
	  [167, format(angle(scaled_wc('lq3_1212')),'.6e'), '# clq3Ph1212'],
	  [168, format(angle(scaled_wc('lq3_1221')),'.6e'), '# clq3Ph1221'],
	  [169, format(angle(scaled_wc('lq3_1213')),'.6e'), '# clq3Ph1213'],
	  [170, format(angle(scaled_wc('lq3_1231')),'.6e'), '# clq3Ph1231'],
	  [171, format(angle(scaled_wc('lq3_1222')),'.6e'), '# clq3Ph1222'],
	  [172, format(angle(scaled_wc('lq3_1223')),'.6e'), '# clq3Ph1223'],
	  [173, format(angle(scaled_wc('lq3_1232')),'.6e'), '# clq3Ph1232'],
	  [174, format(angle(scaled_wc('lq3_1233')),'.6e'), '# clq3Ph1233'],
	  [175, format(angle(scaled_wc('lq3_1311')),'.6e'), '# clq3Ph1311'],
	  [176, format(angle(scaled_wc('lq3_1312')),'.6e'), '# clq3Ph1312'],
	  [177, format(angle(scaled_wc('lq3_1313')),'.6e'), '# clq3Ph1313'],
	  [178, format(angle(scaled_wc('lq3_1331')),'.6e'), '# clq3Ph1331'],
	  [179, format(angle(scaled_wc('lq3_1321')),'.6e'), '# clq3Ph1321'],
	  [180, format(angle(scaled_wc('lq3_1322')),'.6e'), '# clq3Ph1322'],
	  [181, format(angle(scaled_wc('lq3_1332')),'.6e'), '# clq3Ph1332'],
	  [182, format(angle(scaled_wc('lq3_1323')),'.6e'), '# clq3Ph1323'],
	  [183, format(angle(scaled_wc('lq3_1333')),'.6e'), '# clq3Ph1333'],
	  [184, format(angle(scaled_wc('lq3_2212')),'.6e'), '# clq3Ph2212'],
	  [185, format(angle(scaled_wc('lq3_2213')),'.6e'), '# clq3Ph2213'],
	  [186, format(angle(scaled_wc('lq3_2223')),'.6e'), '# clq3Ph2223'],
	  [187, format(angle(scaled_wc('lq3_2311')),'.6e'), '# clq3Ph2311'],
	  [188, format(angle(scaled_wc('lq3_2312')),'.6e'), '# clq3Ph2312'],
	  [189, format(angle(scaled_wc('lq3_2313')),'.6e'), '# clq3Ph2313'],
	  [190, format(angle(scaled_wc('lq3_2321')),'.6e'), '# clq3Ph2321'],
	  [191, format(angle(scaled_wc('lq3_2322')),'.6e'), '# clq3Ph2322'],
	  [192, format(angle(scaled_wc('lq3_2323')),'.6e'), '# clq3Ph2323'],
	  [193, format(angle(scaled_wc('lq3_2331')),'.6e'), '# clq3Ph2331'],
	  [194, format(angle(scaled_wc('lq3_2332')),'.6e'), '# clq3Ph2332'],
	  [195, format(angle(scaled_wc('lq3_2333')),'.6e'), '# clq3Ph2333'],
	  [196, format(angle(scaled_wc('lq3_3312')),'.6e'), '# clq3Ph3312'],
	  [197, format(angle(scaled_wc('lq3_3313')),'.6e'), '# clq3Ph3313'],
	  [198, format(angle(scaled_wc('lq3_3323')),'.6e'), '# clq3Ph3323'],
	  [199, format(angle(scaled_wc('eu_1112')),'.6e'), '# ceuPh1112'],
	  [200, format(angle(scaled_wc('eu_1113')),'.6e'), '# ceuPh1113'],
	  [201, format(angle(scaled_wc('eu_1123')),'.6e'), '# ceuPh1123'],
	  [202, format(angle(scaled_wc('eu_1211')),'.6e'), '# ceuPh1211'],
	  [203, format(angle(scaled_wc('eu_1212')),'.6e'), '# ceuPh1212'],
	  [204, format(angle(scaled_wc('eu_1221')),'.6e'), '# ceuPh1221'],
	  [205, format(angle(scaled_wc('eu_1213')),'.6e'), '# ceuPh1213'],
	  [206, format(angle(scaled_wc('eu_1231')),'.6e'), '# ceuPh1231'],
	  [207, format(angle(scaled_wc('eu_1222')),'.6e'), '# ceuPh1222'],
	  [208, format(angle(scaled_wc('eu_1223')),'.6e'), '# ceuPh1223'],
	  [209, format(angle(scaled_wc('eu_1232')),'.6e'), '# ceuPh1232'],
	  [210, format(angle(scaled_wc('eu_1233')),'.6e'), '# ceuPh1233'],
	  [211, format(angle(scaled_wc('eu_1311')),'.6e'), '# ceuPh1311'],
	  [212, format(angle(scaled_wc('eu_1312')),'.6e'), '# ceuPh1312'],
	  [213, format(angle(scaled_wc('eu_1313')),'.6e'), '# ceuPh1313'],
	  [214, format(angle(scaled_wc('eu_1331')),'.6e'), '# ceuPh1331'],
	  [215, format(angle(scaled_wc('eu_1321')),'.6e'), '# ceuPh1321'],
	  [216, format(angle(scaled_wc('eu_1322')),'.6e'), '# ceuPh1322'],
	  [217, format(angle(scaled_wc('eu_1332')),'.6e'), '# ceuPh1332'],
	  [218, format(angle(scaled_wc('eu_1323')),'.6e'), '# ceuPh1323'],
	  [219, format(angle(scaled_wc('eu_1333')),'.6e'), '# ceuPh1333'],
	  [220, format(angle(scaled_wc('eu_2212')),'.6e'), '# ceuPh2212'],
	  [221, format(angle(scaled_wc('eu_2213')),'.6e'), '# ceuPh2213'],
	  [222, format(angle(scaled_wc('eu_2223')),'.6e'), '# ceuPh2223'],
	  [223, format(angle(scaled_wc('eu_2311')),'.6e'), '# ceuPh2311'],
	  [224, format(angle(scaled_wc('eu_2312')),'.6e'), '# ceuPh2312'],
	  [225, format(angle(scaled_wc('eu_2313')),'.6e'), '# ceuPh2313'],
	  [226, format(angle(scaled_wc('eu_2321')),'.6e'), '# ceuPh2321'],
	  [227, format(angle(scaled_wc('eu_2322')),'.6e'), '# ceuPh2322'],
	  [228, format(angle(scaled_wc('eu_2323')),'.6e'), '# ceuPh2323'],
	  [229, format(angle(scaled_wc('eu_2331')),'.6e'), '# ceuPh2331'],
	  [230, format(angle(scaled_wc('eu_2332')),'.6e'), '# ceuPh2332'],
	  [231, format(angle(scaled_wc('eu_2333')),'.6e'), '# ceuPh2333'],
	  [232, format(angle(scaled_wc('eu_3312')),'.6e'), '# ceuPh3312'],
	  [233, format(angle(scaled_wc('eu_3313')),'.6e'), '# ceuPh3313'],
	  [234, format(angle(scaled_wc('eu_3323')),'.6e'), '# ceuPh3323'],
	  [235, format(angle(scaled_wc('ed_1112')),'.6e'), '# cedPh1112'],
	  [236, format(angle(scaled_wc('ed_1113')),'.6e'), '# cedPh1113'],
	  [237, format(angle(scaled_wc('ed_1123')),'.6e'), '# cedPh1123'],
	  [238, format(angle(scaled_wc('ed_1211')),'.6e'), '# cedPh1211'],
	  [239, format(angle(scaled_wc('ed_1212')),'.6e'), '# cedPh1212'],
	  [240, format(angle(scaled_wc('ed_1221')),'.6e'), '# cedPh1221'],
	  [241, format(angle(scaled_wc('ed_1213')),'.6e'), '# cedPh1213'],
	  [242, format(angle(scaled_wc('ed_1231')),'.6e'), '# cedPh1231'],
	  [243, format(angle(scaled_wc('ed_1222')),'.6e'), '# cedPh1222'],
	  [244, format(angle(scaled_wc('ed_1223')),'.6e'), '# cedPh1223'],
	  [245, format(angle(scaled_wc('ed_1232')),'.6e'), '# cedPh1232'],
	  [246, format(angle(scaled_wc('ed_1233')),'.6e'), '# cedPh1233'],
	  [247, format(angle(scaled_wc('ed_1311')),'.6e'), '# cedPh1311'],
	  [248, format(angle(scaled_wc('ed_1312')),'.6e'), '# cedPh1312'],
	  [249, format(angle(scaled_wc('ed_1313')),'.6e'), '# cedPh1313'],
	  [250, format(angle(scaled_wc('ed_1331')),'.6e'), '# cedPh1331'],
	  [251, format(angle(scaled_wc('ed_1321')),'.6e'), '# cedPh1321'],
	  [252, format(angle(scaled_wc('ed_1322')),'.6e'), '# cedPh1322'],
	  [253, format(angle(scaled_wc('ed_1332')),'.6e'), '# cedPh1332'],
	  [254, format(angle(scaled_wc('ed_1323')),'.6e'), '# cedPh1323'],
	  [255, format(angle(scaled_wc('ed_1333')),'.6e'), '# cedPh1333'],
	  [256, format(angle(scaled_wc('ed_2212')),'.6e'), '# cedPh2212'],
	  [257, format(angle(scaled_wc('ed_2213')),'.6e'), '# cedPh2213'],
	  [258, format(angle(scaled_wc('ed_2223')),'.6e'), '# cedPh2223'],
	  [259, format(angle(scaled_wc('ed_2311')),'.6e'), '# cedPh2311'],
	  [260, format(angle(scaled_wc('ed_2312')),'.6e'), '# cedPh2312'],
	  [261, format(angle(scaled_wc('ed_2313')),'.6e'), '# cedPh2313'],
	  [262, format(angle(scaled_wc('ed_2321')),'.6e'), '# cedPh2321'],
	  [263, format(angle(scaled_wc('ed_2322')),'.6e'), '# cedPh2322'],
	  [264, format(angle(scaled_wc('ed_2323')),'.6e'), '# cedPh2323'],
	  [265, format(angle(scaled_wc('ed_2331')),'.6e'), '# cedPh2331'],
	  [266, format(angle(scaled_wc('ed_2332')),'.6e'), '# cedPh2332'],
	  [267, format(angle(scaled_wc('ed_2333')),'.6e'), '# cedPh2333'],
	  [268, format(angle(scaled_wc('ed_3312')),'.6e'), '# cedPh3312'],
	  [269, format(angle(scaled_wc('ed_3313')),'.6e'), '# cedPh3313'],
	  [270, format(angle(scaled_wc('ed_3323')),'.6e'), '# cedPh3323'],
	  [271, format(angle(scaled_wc('ud1_1112')),'.6e'), '# cud1Ph1112'],
	  [272, format(angle(scaled_wc('ud1_1113')),'.6e'), '# cud1Ph1113'],
	  [273, format(angle(scaled_wc('ud1_1123')),'.6e'), '# cud1Ph1123'],
	  [274, format(angle(scaled_wc('ud1_1211')),'.6e'), '# cud1Ph1211'],
	  [275, format(angle(scaled_wc('ud1_1212')),'.6e'), '# cud1Ph1212'],
	  [276, format(angle(scaled_wc('ud1_1221')),'.6e'), '# cud1Ph1221'],
	  [277, format(angle(scaled_wc('ud1_1213')),'.6e'), '# cud1Ph1213'],
	  [278, format(angle(scaled_wc('ud1_1231')),'.6e'), '# cud1Ph1231'],
	  [279, format(angle(scaled_wc('ud1_1222')),'.6e'), '# cud1Ph1222'],
	  [280, format(angle(scaled_wc('ud1_1223')),'.6e'), '# cud1Ph1223'],
	  [281, format(angle(scaled_wc('ud1_1232')),'.6e'), '# cud1Ph1232'],
	  [282, format(angle(scaled_wc('ud1_1233')),'.6e'), '# cud1Ph1233'],
	  [283, format(angle(scaled_wc('ud1_1311')),'.6e'), '# cud1Ph1311'],
	  [284, format(angle(scaled_wc('ud1_1312')),'.6e'), '# cud1Ph1312'],
	  [285, format(angle(scaled_wc('ud1_1313')),'.6e'), '# cud1Ph1313'],
	  [286, format(angle(scaled_wc('ud1_1331')),'.6e'), '# cud1Ph1331'],
	  [287, format(angle(scaled_wc('ud1_1321')),'.6e'), '# cud1Ph1321'],
	  [288, format(angle(scaled_wc('ud1_1322')),'.6e'), '# cud1Ph1322'],
	  [289, format(angle(scaled_wc('ud1_1332')),'.6e'), '# cud1Ph1332'],
	  [290, format(angle(scaled_wc('ud1_1323')),'.6e'), '# cud1Ph1323'],
	  [291, format(angle(scaled_wc('ud1_1333')),'.6e'), '# cud1Ph1333'],
	  [292, format(angle(scaled_wc('ud1_2212')),'.6e'), '# cud1Ph2212'],
	  [293, format(angle(scaled_wc('ud1_2213')),'.6e'), '# cud1Ph2213'],
	  [294, format(angle(scaled_wc('ud1_2223')),'.6e'), '# cud1Ph2223'],
	  [295, format(angle(scaled_wc('ud1_2311')),'.6e'), '# cud1Ph2311'],
	  [296, format(angle(scaled_wc('ud1_2312')),'.6e'), '# cud1Ph2312'],
	  [297, format(angle(scaled_wc('ud1_2313')),'.6e'), '# cud1Ph2313'],
	  [298, format(angle(scaled_wc('ud1_2321')),'.6e'), '# cud1Ph2321'],
	  [299, format(angle(scaled_wc('ud1_2322')),'.6e'), '# cud1Ph2322'],
	  [300, format(angle(scaled_wc('ud1_2323')),'.6e'), '# cud1Ph2323'],
	  [301, format(angle(scaled_wc('ud1_2331')),'.6e'), '# cud1Ph2331'],
	  [302, format(angle(scaled_wc('ud1_2332')),'.6e'), '# cud1Ph2332'],
	  [303, format(angle(scaled_wc('ud1_2333')),'.6e'), '# cud1Ph2333'],
	  [304, format(angle(scaled_wc('ud1_3312')),'.6e'), '# cud1Ph3312'],
	  [305, format(angle(scaled_wc('ud1_3313')),'.6e'), '# cud1Ph3313'],
	  [306, format(angle(scaled_wc('ud1_3323')),'.6e'), '# cud1Ph3323'],
	  [307, format(angle(scaled_wc('ud8_1112')),'.6e'), '# cud8Ph1112'],
	  [308, format(angle(scaled_wc('ud8_1113')),'.6e'), '# cud8Ph1113'],
	  [309, format(angle(scaled_wc('ud8_1123')),'.6e'), '# cud8Ph1123'],
	  [310, format(angle(scaled_wc('ud8_1211')),'.6e'), '# cud8Ph1211'],
	  [311, format(angle(scaled_wc('ud8_1212')),'.6e'), '# cud8Ph1212'],
	  [312, format(angle(scaled_wc('ud8_1221')),'.6e'), '# cud8Ph1221'],
	  [313, format(angle(scaled_wc('ud8_1213')),'.6e'), '# cud8Ph1213'],
	  [314, format(angle(scaled_wc('ud8_1231')),'.6e'), '# cud8Ph1231'],
	  [315, format(angle(scaled_wc('ud8_1222')),'.6e'), '# cud8Ph1222'],
	  [316, format(angle(scaled_wc('ud8_1223')),'.6e'), '# cud8Ph1223'],
	  [317, format(angle(scaled_wc('ud8_1232')),'.6e'), '# cud8Ph1232'],
	  [318, format(angle(scaled_wc('ud8_1233')),'.6e'), '# cud8Ph1233'],
	  [319, format(angle(scaled_wc('ud8_1311')),'.6e'), '# cud8Ph1311'],
	  [320, format(angle(scaled_wc('ud8_1312')),'.6e'), '# cud8Ph1312'],
	  [321, format(angle(scaled_wc('ud8_1313')),'.6e'), '# cud8Ph1313'],
	  [322, format(angle(scaled_wc('ud8_1331')),'.6e'), '# cud8Ph1331'],
	  [323, format(angle(scaled_wc('ud8_1321')),'.6e'), '# cud8Ph1321'],
	  [324, format(angle(scaled_wc('ud8_1322')),'.6e'), '# cud8Ph1322'],
	  [325, format(angle(scaled_wc('ud8_1332')),'.6e'), '# cud8Ph1332'],
	  [326, format(angle(scaled_wc('ud8_1323')),'.6e'), '# cud8Ph1323'],
	  [327, format(angle(scaled_wc('ud8_1333')),'.6e'), '# cud8Ph1333'],
	  [328, format(angle(scaled_wc('ud8_2212')),'.6e'), '# cud8Ph2212'],
	  [329, format(angle(scaled_wc('ud8_2213')),'.6e'), '# cud8Ph2213'],
	  [330, format(angle(scaled_wc('ud8_2223')),'.6e'), '# cud8Ph2223'],
	  [331, format(angle(scaled_wc('ud8_2311')),'.6e'), '# cud8Ph2311'],
	  [332, format(angle(scaled_wc('ud8_2312')),'.6e'), '# cud8Ph2312'],
	  [333, format(angle(scaled_wc('ud8_2313')),'.6e'), '# cud8Ph2313'],
	  [334, format(angle(scaled_wc('ud8_2321')),'.6e'), '# cud8Ph2321'],
	  [335, format(angle(scaled_wc('ud8_2322')),'.6e'), '# cud8Ph2322'],
	  [336, format(angle(scaled_wc('ud8_2323')),'.6e'), '# cud8Ph2323'],
	  [337, format(angle(scaled_wc('ud8_2331')),'.6e'), '# cud8Ph2331'],
	  [338, format(angle(scaled_wc('ud8_2332')),'.6e'), '# cud8Ph2332'],
	  [339, format(angle(scaled_wc('ud8_2333')),'.6e'), '# cud8Ph2333'],
	  [340, format(angle(scaled_wc('ud8_3312')),'.6e'), '# cud8Ph3312'],
	  [341, format(angle(scaled_wc('ud8_3313')),'.6e'), '# cud8Ph3313'],
	  [342, format(angle(scaled_wc('ud8_3323')),'.6e'), '# cud8Ph3323'],
	  [343, format(angle(scaled_wc('le_1112')),'.6e'), '# clePh1112'],
	  [344, format(angle(scaled_wc('le_1113')),'.6e'), '# clePh1113'],
	  [345, format(angle(scaled_wc('le_1123')),'.6e'), '# clePh1123'],
	  [346, format(angle(scaled_wc('le_1211')),'.6e'), '# clePh1211'],
	  [347, format(angle(scaled_wc('le_1212')),'.6e'), '# clePh1212'],
	  [348, format(angle(scaled_wc('le_1221')),'.6e'), '# clePh1221'],
	  [349, format(angle(scaled_wc('le_1213')),'.6e'), '# clePh1213'],
	  [350, format(angle(scaled_wc('le_1231')),'.6e'), '# clePh1231'],
	  [351, format(angle(scaled_wc('le_1222')),'.6e'), '# clePh1222'],
	  [352, format(angle(scaled_wc('le_1223')),'.6e'), '# clePh1223'],
	  [353, format(angle(scaled_wc('le_1232')),'.6e'), '# clePh1232'],
	  [354, format(angle(scaled_wc('le_1233')),'.6e'), '# clePh1233'],
	  [355, format(angle(scaled_wc('le_1311')),'.6e'), '# clePh1311'],
	  [356, format(angle(scaled_wc('le_1312')),'.6e'), '# clePh1312'],
	  [357, format(angle(scaled_wc('le_1313')),'.6e'), '# clePh1313'],
	  [358, format(angle(scaled_wc('le_1331')),'.6e'), '# clePh1331'],
	  [359, format(angle(scaled_wc('le_1321')),'.6e'), '# clePh1321'],
	  [360, format(angle(scaled_wc('le_1322')),'.6e'), '# clePh1322'],
	  [361, format(angle(scaled_wc('le_1332')),'.6e'), '# clePh1332'],
	  [362, format(angle(scaled_wc('le_1323')),'.6e'), '# clePh1323'],
	  [363, format(angle(scaled_wc('le_1333')),'.6e'), '# clePh1333'],
	  [364, format(angle(scaled_wc('le_2212')),'.6e'), '# clePh2212'],
	  [365, format(angle(scaled_wc('le_2213')),'.6e'), '# clePh2213'],
	  [366, format(angle(scaled_wc('le_2223')),'.6e'), '# clePh2223'],
	  [367, format(angle(scaled_wc('le_2311')),'.6e'), '# clePh2311'],
	  [368, format(angle(scaled_wc('le_2312')),'.6e'), '# clePh2312'],
	  [369, format(angle(scaled_wc('le_2313')),'.6e'), '# clePh2313'],
	  [370, format(angle(scaled_wc('le_2321')),'.6e'), '# clePh2321'],
	  [371, format(angle(scaled_wc('le_2322')),'.6e'), '# clePh2322'],
	  [372, format(angle(scaled_wc('le_2323')),'.6e'), '# clePh2323'],
	  [373, format(angle(scaled_wc('le_2331')),'.6e'), '# clePh2331'],
	  [374, format(angle(scaled_wc('le_2332')),'.6e'), '# clePh2332'],
	  [375, format(angle(scaled_wc('le_2333')),'.6e'), '# clePh2333'],
	  [376, format(angle(scaled_wc('le_3312')),'.6e'), '# clePh3312'],
	  [377, format(angle(scaled_wc('le_3313')),'.6e'), '# clePh3313'],
	  [378, format(angle(scaled_wc('le_3323')),'.6e'), '# clePh3323'],
	  [379, format(angle(scaled_wc('lu_1112')),'.6e'), '# cluPh1112'],
	  [380, format(angle(scaled_wc('lu_1113')),'.6e'), '# cluPh1113'],
	  [381, format(angle(scaled_wc('lu_1123')),'.6e'), '# cluPh1123'],
	  [382, format(angle(scaled_wc('lu_1211')),'.6e'), '# cluPh1211'],
	  [383, format(angle(scaled_wc('lu_1212')),'.6e'), '# cluPh1212'],
	  [384, format(angle(scaled_wc('lu_1221')),'.6e'), '# cluPh1221'],
	  [385, format(angle(scaled_wc('lu_1213')),'.6e'), '# cluPh1213'],
	  [386, format(angle(scaled_wc('lu_1231')),'.6e'), '# cluPh1231'],
	  [387, format(angle(scaled_wc('lu_1222')),'.6e'), '# cluPh1222'],
	  [388, format(angle(scaled_wc('lu_1223')),'.6e'), '# cluPh1223'],
	  [389, format(angle(scaled_wc('lu_1232')),'.6e'), '# cluPh1232'],
	  [390, format(angle(scaled_wc('lu_1233')),'.6e'), '# cluPh1233'],
	  [391, format(angle(scaled_wc('lu_1311')),'.6e'), '# cluPh1311'],
	  [392, format(angle(scaled_wc('lu_1312')),'.6e'), '# cluPh1312'],
	  [393, format(angle(scaled_wc('lu_1313')),'.6e'), '# cluPh1313'],
	  [394, format(angle(scaled_wc('lu_1331')),'.6e'), '# cluPh1331'],
	  [395, format(angle(scaled_wc('lu_1321')),'.6e'), '# cluPh1321'],
	  [396, format(angle(scaled_wc('lu_1322')),'.6e'), '# cluPh1322'],
	  [397, format(angle(scaled_wc('lu_1332')),'.6e'), '# cluPh1332'],
	  [398, format(angle(scaled_wc('lu_1323')),'.6e'), '# cluPh1323'],
	  [399, format(angle(scaled_wc('lu_1333')),'.6e'), '# cluPh1333'],
	  [400, format(angle(scaled_wc('lu_2212')),'.6e'), '# cluPh2212'],
	  [401, format(angle(scaled_wc('lu_2213')),'.6e'), '# cluPh2213'],
	  [402, format(angle(scaled_wc('lu_2223')),'.6e'), '# cluPh2223'],
	  [403, format(angle(scaled_wc('lu_2311')),'.6e'), '# cluPh2311'],
	  [404, format(angle(scaled_wc('lu_2312')),'.6e'), '# cluPh2312'],
	  [405, format(angle(scaled_wc('lu_2313')),'.6e'), '# cluPh2313'],
	  [406, format(angle(scaled_wc('lu_2321')),'.6e'), '# cluPh2321'],
	  [407, format(angle(scaled_wc('lu_2322')),'.6e'), '# cluPh2322'],
	  [408, format(angle(scaled_wc('lu_2323')),'.6e'), '# cluPh2323'],
	  [409, format(angle(scaled_wc('lu_2331')),'.6e'), '# cluPh2331'],
	  [410, format(angle(scaled_wc('lu_2332')),'.6e'), '# cluPh2332'],
	  [411, format(angle(scaled_wc('lu_2333')),'.6e'), '# cluPh2333'],
	  [412, format(angle(scaled_wc('lu_3312')),'.6e'), '# cluPh3312'],
	  [413, format(angle(scaled_wc('lu_3313')),'.6e'), '# cluPh3313'],
	  [414, format(angle(scaled_wc('lu_3323')),'.6e'), '# cluPh3323'],
	  [415, format(angle(scaled_wc('ld_1112')),'.6e'), '# cldPh1112'],
	  [416, format(angle(scaled_wc('ld_1113')),'.6e'), '# cldPh1113'],
	  [417, format(angle(scaled_wc('ld_1123')),'.6e'), '# cldPh1123'],
	  [418, format(angle(scaled_wc('ld_1211')),'.6e'), '# cldPh1211'],
	  [419, format(angle(scaled_wc('ld_1212')),'.6e'), '# cldPh1212'],
	  [420, format(angle(scaled_wc('ld_1221')),'.6e'), '# cldPh1221'],
	  [421, format(angle(scaled_wc('ld_1213')),'.6e'), '# cldPh1213'],
	  [422, format(angle(scaled_wc('ld_1231')),'.6e'), '# cldPh1231'],
	  [423, format(angle(scaled_wc('ld_1222')),'.6e'), '# cldPh1222'],
	  [424, format(angle(scaled_wc('ld_1223')),'.6e'), '# cldPh1223'],
	  [425, format(angle(scaled_wc('ld_1232')),'.6e'), '# cldPh1232'],
	  [426, format(angle(scaled_wc('ld_1233')),'.6e'), '# cldPh1233'],
	  [427, format(angle(scaled_wc('ld_1311')),'.6e'), '# cldPh1311'],
	  [428, format(angle(scaled_wc('ld_1312')),'.6e'), '# cldPh1312'],
	  [429, format(angle(scaled_wc('ld_1313')),'.6e'), '# cldPh1313'],
	  [430, format(angle(scaled_wc('ld_1331')),'.6e'), '# cldPh1331'],
	  [431, format(angle(scaled_wc('ld_1321')),'.6e'), '# cldPh1321'],
	  [432, format(angle(scaled_wc('ld_1322')),'.6e'), '# cldPh1322'],
	  [433, format(angle(scaled_wc('ld_1332')),'.6e'), '# cldPh1332'],
	  [434, format(angle(scaled_wc('ld_1323')),'.6e'), '# cldPh1323'],
	  [435, format(angle(scaled_wc('ld_1333')),'.6e'), '# cldPh1333'],
	  [436, format(angle(scaled_wc('ld_2212')),'.6e'), '# cldPh2212'],
	  [437, format(angle(scaled_wc('ld_2213')),'.6e'), '# cldPh2213'],
	  [438, format(angle(scaled_wc('ld_2223')),'.6e'), '# cldPh2223'],
	  [439, format(angle(scaled_wc('ld_2311')),'.6e'), '# cldPh2311'],
	  [440, format(angle(scaled_wc('ld_2312')),'.6e'), '# cldPh2312'],
	  [441, format(angle(scaled_wc('ld_2313')),'.6e'), '# cldPh2313'],
	  [442, format(angle(scaled_wc('ld_2321')),'.6e'), '# cldPh2321'],
	  [443, format(angle(scaled_wc('ld_2322')),'.6e'), '# cldPh2322'],
	  [444, format(angle(scaled_wc('ld_2323')),'.6e'), '# cldPh2323'],
	  [445, format(angle(scaled_wc('ld_2331')),'.6e'), '# cldPh2331'],
	  [446, format(angle(scaled_wc('ld_2332')),'.6e'), '# cldPh2332'],
	  [447, format(angle(scaled_wc('ld_2333')),'.6e'), '# cldPh2333'],
	  [448, format(angle(scaled_wc('ld_3312')),'.6e'), '# cldPh3312'],
	  [449, format(angle(scaled_wc('ld_3313')),'.6e'), '# cldPh3313'],
	  [450, format(angle(scaled_wc('ld_3323')),'.6e'), '# cldPh3323'],
	  [451, format(angle(scaled_wc('qe_1112')),'.6e'), '# cqePh1112'],
	  [452, format(angle(scaled_wc('qe_1113')),'.6e'), '# cqePh1113'],
	  [453, format(angle(scaled_wc('qe_1123')),'.6e'), '# cqePh1123'],
	  [454, format(angle(scaled_wc('qe_1211')),'.6e'), '# cqePh1211'],
	  [455, format(angle(scaled_wc('qe_1212')),'.6e'), '# cqePh1212'],
	  [456, format(angle(scaled_wc('qe_1221')),'.6e'), '# cqePh1221'],
	  [457, format(angle(scaled_wc('qe_1213')),'.6e'), '# cqePh1213'],
	  [458, format(angle(scaled_wc('qe_1231')),'.6e'), '# cqePh1231'],
	  [459, format(angle(scaled_wc('qe_1222')),'.6e'), '# cqePh1222'],
	  [460, format(angle(scaled_wc('qe_1223')),'.6e'), '# cqePh1223'],
	  [461, format(angle(scaled_wc('qe_1232')),'.6e'), '# cqePh1232'],
	  [462, format(angle(scaled_wc('qe_1233')),'.6e'), '# cqePh1233'],
	  [463, format(angle(scaled_wc('qe_1311')),'.6e'), '# cqePh1311'],
	  [464, format(angle(scaled_wc('qe_1312')),'.6e'), '# cqePh1312'],
	  [465, format(angle(scaled_wc('qe_1313')),'.6e'), '# cqePh1313'],
	  [466, format(angle(scaled_wc('qe_1331')),'.6e'), '# cqePh1331'],
	  [467, format(angle(scaled_wc('qe_1321')),'.6e'), '# cqePh1321'],
	  [468, format(angle(scaled_wc('qe_1322')),'.6e'), '# cqePh1322'],
	  [469, format(angle(scaled_wc('qe_1332')),'.6e'), '# cqePh1332'],
	  [470, format(angle(scaled_wc('qe_1323')),'.6e'), '# cqePh1323'],
	  [471, format(angle(scaled_wc('qe_1333')),'.6e'), '# cqePh1333'],
	  [472, format(angle(scaled_wc('qe_2212')),'.6e'), '# cqePh2212'],
	  [473, format(angle(scaled_wc('qe_2213')),'.6e'), '# cqePh2213'],
	  [474, format(angle(scaled_wc('qe_2223')),'.6e'), '# cqePh2223'],
	  [475, format(angle(scaled_wc('qe_2311')),'.6e'), '# cqePh2311'],
	  [476, format(angle(scaled_wc('qe_2312')),'.6e'), '# cqePh2312'],
	  [477, format(angle(scaled_wc('qe_2313')),'.6e'), '# cqePh2313'],
	  [478, format(angle(scaled_wc('qe_2321')),'.6e'), '# cqePh2321'],
	  [479, format(angle(scaled_wc('qe_2322')),'.6e'), '# cqePh2322'],
	  [480, format(angle(scaled_wc('qe_2323')),'.6e'), '# cqePh2323'],
	  [481, format(angle(scaled_wc('qe_2331')),'.6e'), '# cqePh2331'],
	  [482, format(angle(scaled_wc('qe_2332')),'.6e'), '# cqePh2332'],
	  [483, format(angle(scaled_wc('qe_2333')),'.6e'), '# cqePh2333'],
	  [484, format(angle(scaled_wc('qe_3312')),'.6e'), '# cqePh3312'],
	  [485, format(angle(scaled_wc('qe_3313')),'.6e'), '# cqePh3313'],
	  [486, format(angle(scaled_wc('qe_3323')),'.6e'), '# cqePh3323'],
	  [487, format(angle(scaled_wc('qu1_1112')),'.6e'), '# cqu1Ph1112'],
	  [488, format(angle(scaled_wc('qu1_1113')),'.6e'), '# cqu1Ph1113'],
	  [489, format(angle(scaled_wc('qu1_1123')),'.6e'), '# cqu1Ph1123'],
	  [490, format(angle(scaled_wc('qu1_1211')),'.6e'), '# cqu1Ph1211'],
	  [491, format(angle(scaled_wc('qu1_1212')),'.6e'), '# cqu1Ph1212'],
	  [492, format(angle(scaled_wc('qu1_1221')),'.6e'), '# cqu1Ph1221'],
	  [493, format(angle(scaled_wc('qu1_1213')),'.6e'), '# cqu1Ph1213'],
	  [494, format(angle(scaled_wc('qu1_1231')),'.6e'), '# cqu1Ph1231'],
	  [495, format(angle(scaled_wc('qu1_1222')),'.6e'), '# cqu1Ph1222'],
	  [496, format(angle(scaled_wc('qu1_1223')),'.6e'), '# cqu1Ph1223'],
	  [497, format(angle(scaled_wc('qu1_1232')),'.6e'), '# cqu1Ph1232'],
	  [498, format(angle(scaled_wc('qu1_1233')),'.6e'), '# cqu1Ph1233'],
	  [499, format(angle(scaled_wc('qu1_1311')),'.6e'), '# cqu1Ph1311'],
	  [500, format(angle(scaled_wc('qu1_1312')),'.6e'), '# cqu1Ph1312'],
	  [501, format(angle(scaled_wc('qu1_1313')),'.6e'), '# cqu1Ph1313'],
	  [502, format(angle(scaled_wc('qu1_1331')),'.6e'), '# cqu1Ph1331'],
	  [503, format(angle(scaled_wc('qu1_1321')),'.6e'), '# cqu1Ph1321'],
	  [504, format(angle(scaled_wc('qu1_1322')),'.6e'), '# cqu1Ph1322'],
	  [505, format(angle(scaled_wc('qu1_1332')),'.6e'), '# cqu1Ph1332'],
	  [506, format(angle(scaled_wc('qu1_1323')),'.6e'), '# cqu1Ph1323'],
	  [507, format(angle(scaled_wc('qu1_1333')),'.6e'), '# cqu1Ph1333'],
	  [508, format(angle(scaled_wc('qu1_2212')),'.6e'), '# cqu1Ph2212'],
	  [509, format(angle(scaled_wc('qu1_2213')),'.6e'), '# cqu1Ph2213'],
	  [510, format(angle(scaled_wc('qu1_2223')),'.6e'), '# cqu1Ph2223'],
	  [511, format(angle(scaled_wc('qu1_2311')),'.6e'), '# cqu1Ph2311'],
	  [512, format(angle(scaled_wc('qu1_2312')),'.6e'), '# cqu1Ph2312'],
	  [513, format(angle(scaled_wc('qu1_2313')),'.6e'), '# cqu1Ph2313'],
	  [514, format(angle(scaled_wc('qu1_2321')),'.6e'), '# cqu1Ph2321'],
	  [515, format(angle(scaled_wc('qu1_2322')),'.6e'), '# cqu1Ph2322'],
	  [516, format(angle(scaled_wc('qu1_2323')),'.6e'), '# cqu1Ph2323'],
	  [517, format(angle(scaled_wc('qu1_2331')),'.6e'), '# cqu1Ph2331'],
	  [518, format(angle(scaled_wc('qu1_2332')),'.6e'), '# cqu1Ph2332'],
	  [519, format(angle(scaled_wc('qu1_2333')),'.6e'), '# cqu1Ph2333'],
	  [520, format(angle(scaled_wc('qu1_3312')),'.6e'), '# cqu1Ph3312'],
	  [521, format(angle(scaled_wc('qu1_3313')),'.6e'), '# cqu1Ph3313'],
	  [522, format(angle(scaled_wc('qu1_3323')),'.6e'), '# cqu1Ph3323'],
	  [523, format(angle(scaled_wc('qd1_1112')),'.6e'), '# cqd1Ph1112'],
	  [524, format(angle(scaled_wc('qd1_1113')),'.6e'), '# cqd1Ph1113'],
	  [525, format(angle(scaled_wc('qd1_1123')),'.6e'), '# cqd1Ph1123'],
	  [526, format(angle(scaled_wc('qd1_1211')),'.6e'), '# cqd1Ph1211'],
	  [527, format(angle(scaled_wc('qd1_1212')),'.6e'), '# cqd1Ph1212'],
	  [528, format(angle(scaled_wc('qd1_1221')),'.6e'), '# cqd1Ph1221'],
	  [529, format(angle(scaled_wc('qd1_1213')),'.6e'), '# cqd1Ph1213'],
	  [530, format(angle(scaled_wc('qd1_1231')),'.6e'), '# cqd1Ph1231'],
	  [531, format(angle(scaled_wc('qd1_1222')),'.6e'), '# cqd1Ph1222'],
	  [532, format(angle(scaled_wc('qd1_1223')),'.6e'), '# cqd1Ph1223'],
	  [533, format(angle(scaled_wc('qd1_1232')),'.6e'), '# cqd1Ph1232'],
	  [534, format(angle(scaled_wc('qd1_1233')),'.6e'), '# cqd1Ph1233'],
	  [535, format(angle(scaled_wc('qd1_1311')),'.6e'), '# cqd1Ph1311'],
	  [536, format(angle(scaled_wc('qd1_1312')),'.6e'), '# cqd1Ph1312'],
	  [537, format(angle(scaled_wc('qd1_1313')),'.6e'), '# cqd1Ph1313'],
	  [538, format(angle(scaled_wc('qd1_1331')),'.6e'), '# cqd1Ph1331'],
	  [539, format(angle(scaled_wc('qd1_1321')),'.6e'), '# cqd1Ph1321'],
	  [540, format(angle(scaled_wc('qd1_1322')),'.6e'), '# cqd1Ph1322'],
	  [541, format(angle(scaled_wc('qd1_1332')),'.6e'), '# cqd1Ph1332'],
	  [542, format(angle(scaled_wc('qd1_1323')),'.6e'), '# cqd1Ph1323'],
	  [543, format(angle(scaled_wc('qd1_1333')),'.6e'), '# cqd1Ph1333'],
	  [544, format(angle(scaled_wc('qd1_2212')),'.6e'), '# cqd1Ph2212'],
	  [545, format(angle(scaled_wc('qd1_2213')),'.6e'), '# cqd1Ph2213'],
	  [546, format(angle(scaled_wc('qd1_2223')),'.6e'), '# cqd1Ph2223'],
	  [547, format(angle(scaled_wc('qd1_2311')),'.6e'), '# cqd1Ph2311'],
	  [548, format(angle(scaled_wc('qd1_2312')),'.6e'), '# cqd1Ph2312'],
	  [549, format(angle(scaled_wc('qd1_2313')),'.6e'), '# cqd1Ph2313'],
	  [550, format(angle(scaled_wc('qd1_2321')),'.6e'), '# cqd1Ph2321'],
	  [551, format(angle(scaled_wc('qd1_2322')),'.6e'), '# cqd1Ph2322'],
	  [552, format(angle(scaled_wc('qd1_2323')),'.6e'), '# cqd1Ph2323'],
	  [553, format(angle(scaled_wc('qd1_2331')),'.6e'), '# cqd1Ph2331'],
	  [554, format(angle(scaled_wc('qd1_2332')),'.6e'), '# cqd1Ph2332'],
	  [555, format(angle(scaled_wc('qd1_2333')),'.6e'), '# cqd1Ph2333'],
	  [556, format(angle(scaled_wc('qd1_3312')),'.6e'), '# cqd1Ph3312'],
	  [557, format(angle(scaled_wc('qd1_3313')),'.6e'), '# cqd1Ph3313'],
	  [558, format(angle(scaled_wc('qd1_3323')),'.6e'), '# cqd1Ph3323'],
	  [559, format(angle(scaled_wc('qu8_1112')),'.6e'), '# cqu8Ph1112'],
	  [560, format(angle(scaled_wc('qu8_1113')),'.6e'), '# cqu8Ph1113'],
	  [561, format(angle(scaled_wc('qu8_1123')),'.6e'), '# cqu8Ph1123'],
	  [562, format(angle(scaled_wc('qu8_1211')),'.6e'), '# cqu8Ph1211'],
	  [563, format(angle(scaled_wc('qu8_1212')),'.6e'), '# cqu8Ph1212'],
	  [564, format(angle(scaled_wc('qu8_1221')),'.6e'), '# cqu8Ph1221'],
	  [565, format(angle(scaled_wc('qu8_1213')),'.6e'), '# cqu8Ph1213'],
	  [566, format(angle(scaled_wc('qu8_1231')),'.6e'), '# cqu8Ph1231'],
	  [567, format(angle(scaled_wc('qu8_1222')),'.6e'), '# cqu8Ph1222'],
	  [568, format(angle(scaled_wc('qu8_1223')),'.6e'), '# cqu8Ph1223'],
	  [569, format(angle(scaled_wc('qu8_1232')),'.6e'), '# cqu8Ph1232'],
	  [570, format(angle(scaled_wc('qu8_1233')),'.6e'), '# cqu8Ph1233'],
	  [571, format(angle(scaled_wc('qu8_1311')),'.6e'), '# cqu8Ph1311'],
	  [572, format(angle(scaled_wc('qu8_1312')),'.6e'), '# cqu8Ph1312'],
	  [573, format(angle(scaled_wc('qu8_1313')),'.6e'), '# cqu8Ph1313'],
	  [574, format(angle(scaled_wc('qu8_1331')),'.6e'), '# cqu8Ph1331'],
	  [575, format(angle(scaled_wc('qu8_1321')),'.6e'), '# cqu8Ph1321'],
	  [576, format(angle(scaled_wc('qu8_1322')),'.6e'), '# cqu8Ph1322'],
	  [577, format(angle(scaled_wc('qu8_1332')),'.6e'), '# cqu8Ph1332'],
	  [578, format(angle(scaled_wc('qu8_1323')),'.6e'), '# cqu8Ph1323'],
	  [579, format(angle(scaled_wc('qu8_1333')),'.6e'), '# cqu8Ph1333'],
	  [580, format(angle(scaled_wc('qu8_2212')),'.6e'), '# cqu8Ph2212'],
	  [581, format(angle(scaled_wc('qu8_2213')),'.6e'), '# cqu8Ph2213'],
	  [582, format(angle(scaled_wc('qu8_2223')),'.6e'), '# cqu8Ph2223'],
	  [583, format(angle(scaled_wc('qu8_2311')),'.6e'), '# cqu8Ph2311'],
	  [584, format(angle(scaled_wc('qu8_2312')),'.6e'), '# cqu8Ph2312'],
	  [585, format(angle(scaled_wc('qu8_2313')),'.6e'), '# cqu8Ph2313'],
	  [586, format(angle(scaled_wc('qu8_2321')),'.6e'), '# cqu8Ph2321'],
	  [587, format(angle(scaled_wc('qu8_2322')),'.6e'), '# cqu8Ph2322'],
	  [588, format(angle(scaled_wc('qu8_2323')),'.6e'), '# cqu8Ph2323'],
	  [589, format(angle(scaled_wc('qu8_2331')),'.6e'), '# cqu8Ph2331'],
	  [590, format(angle(scaled_wc('qu8_2332')),'.6e'), '# cqu8Ph2332'],
	  [591, format(angle(scaled_wc('qu8_2333')),'.6e'), '# cqu8Ph2333'],
	  [592, format(angle(scaled_wc('qu8_3312')),'.6e'), '# cqu8Ph3312'],
	  [593, format(angle(scaled_wc('qu8_3313')),'.6e'), '# cqu8Ph3313'],
	  [594, format(angle(scaled_wc('qu8_3323')),'.6e'), '# cqu8Ph3323'],
	  [595, format(angle(scaled_wc('qd8_1112')),'.6e'), '# cqd8Ph1112'],
	  [596, format(angle(scaled_wc('qd8_1113')),'.6e'), '# cqd8Ph1113'],
	  [597, format(angle(scaled_wc('qd8_1123')),'.6e'), '# cqd8Ph1123'],
	  [598, format(angle(scaled_wc('qd8_1211')),'.6e'), '# cqd8Ph1211'],
	  [599, format(angle(scaled_wc('qd8_1212')),'.6e'), '# cqd8Ph1212'],
	  [600, format(angle(scaled_wc('qd8_1221')),'.6e'), '# cqd8Ph1221'],
	  [601, format(angle(scaled_wc('qd8_1213')),'.6e'), '# cqd8Ph1213'],
	  [602, format(angle(scaled_wc('qd8_1231')),'.6e'), '# cqd8Ph1231'],
	  [603, format(angle(scaled_wc('qd8_1222')),'.6e'), '# cqd8Ph1222'],
	  [604, format(angle(scaled_wc('qd8_1223')),'.6e'), '# cqd8Ph1223'],
	  [605, format(angle(scaled_wc('qd8_1232')),'.6e'), '# cqd8Ph1232'],
	  [606, format(angle(scaled_wc('qd8_1233')),'.6e'), '# cqd8Ph1233'],
	  [607, format(angle(scaled_wc('qd8_1311')),'.6e'), '# cqd8Ph1311'],
	  [608, format(angle(scaled_wc('qd8_1312')),'.6e'), '# cqd8Ph1312'],
	  [609, format(angle(scaled_wc('qd8_1313')),'.6e'), '# cqd8Ph1313'],
	  [610, format(angle(scaled_wc('qd8_1331')),'.6e'), '# cqd8Ph1331'],
	  [611, format(angle(scaled_wc('qd8_1321')),'.6e'), '# cqd8Ph1321'],
	  [612, format(angle(scaled_wc('qd8_1322')),'.6e'), '# cqd8Ph1322'],
	  [613, format(angle(scaled_wc('qd8_1332')),'.6e'), '# cqd8Ph1332'],
	  [614, format(angle(scaled_wc('qd8_1323')),'.6e'), '# cqd8Ph1323'],
	  [615, format(angle(scaled_wc('qd8_1333')),'.6e'), '# cqd8Ph1333'],
	  [616, format(angle(scaled_wc('qd8_2212')),'.6e'), '# cqd8Ph2212'],
	  [617, format(angle(scaled_wc('qd8_2213')),'.6e'), '# cqd8Ph2213'],
	  [618, format(angle(scaled_wc('qd8_2223')),'.6e'), '# cqd8Ph2223'],
	  [619, format(angle(scaled_wc('qd8_2311')),'.6e'), '# cqd8Ph2311'],
	  [620, format(angle(scaled_wc('qd8_2312')),'.6e'), '# cqd8Ph2312'],
	  [621, format(angle(scaled_wc('qd8_2313')),'.6e'), '# cqd8Ph2313'],
	  [622, format(angle(scaled_wc('qd8_2321')),'.6e'), '# cqd8Ph2321'],
	  [623, format(angle(scaled_wc('qd8_2322')),'.6e'), '# cqd8Ph2322'],
	  [624, format(angle(scaled_wc('qd8_2323')),'.6e'), '# cqd8Ph2323'],
	  [625, format(angle(scaled_wc('qd8_2331')),'.6e'), '# cqd8Ph2331'],
	  [626, format(angle(scaled_wc('qd8_2332')),'.6e'), '# cqd8Ph2332'],
	  [627, format(angle(scaled_wc('qd8_2333')),'.6e'), '# cqd8Ph2333'],
	  [628, format(angle(scaled_wc('qd8_3312')),'.6e'), '# cqd8Ph3312'],
	  [629, format(angle(scaled_wc('qd8_3313')),'.6e'), '# cqd8Ph3313'],
	  [630, format(angle(scaled_wc('qd8_3323')),'.6e'), '# cqd8Ph3323'],
	  [631, format(lambda_smeft_value, '.6e'), '# LambdaSMEFT'],
	  [632, format(scaled_wc('G') * lambda_smeft_value**2,'.6e'), '# cG'],
	  [633, format(scaled_wc('Gtilde') * lambda_smeft_value**2,'.6e'), '# cGtil'],
	  [634, format(scaled_wc('W') * lambda_smeft_value**2,'.6e'), '# cW'],
	  [635, format(scaled_wc('Wtilde') * lambda_smeft_value**2,'.6e'), '# cWtil'],
	  [636, format(scaled_wc('phi') * lambda_smeft_value**2,'.6e'), '# cH'],
	  [637, format(scaled_wc('phiBox') * lambda_smeft_value**2,'.6e'), '# cHbox'],
	  [638, format(scaled_wc('phiD') * lambda_smeft_value**2,'.6e'), '# cHDD'],
	  [639, format(scaled_wc('phiG') * lambda_smeft_value**2,'.6e'), '# cHG'],
	  [640, format(scaled_wc('phiGtilde') * lambda_smeft_value**2,'.6e'), '# cHGtil'],
	  [641, format(scaled_wc('phiW') * lambda_smeft_value**2,'.6e'), '# cHW'],
	  [642, format(scaled_wc('phiWtilde') * lambda_smeft_value**2,'.6e'), '# cHWtil'],
	  [643, format(scaled_wc('phiB') * lambda_smeft_value**2,'.6e'), '# cHB'],
	  [644, format(scaled_wc('phiBtilde') * lambda_smeft_value**2,'.6e'), '# cHBtil'],
	  [645, format(scaled_wc('phiWB') * lambda_smeft_value**2,'.6e'), '# cHWB'],
	  [646, format(scaled_wc('phiWtildeB') * lambda_smeft_value**2,'.6e'), '# cHWBtil'],
	  [647, format(abs(scaled_wc('phil1_11')) * lambda_smeft_value**2,'.6e'), '# cHl1Abs11'],
	  [648, format(abs(scaled_wc('phil1_12')) * lambda_smeft_value**2,'.6e'), '# cHl1Abs12'],
	  [649, format(abs(scaled_wc('phil1_13')) * lambda_smeft_value**2,'.6e'), '# cHl1Abs13'],
	  [650, format(abs(scaled_wc('phil1_22')) * lambda_smeft_value**2,'.6e'), '# cHl1Abs22'],
	  [651, format(abs(scaled_wc('phil1_23')) * lambda_smeft_value**2,'.6e'), '# cHl1Abs23'],
	  [652, format(abs(scaled_wc('phil1_33')) * lambda_smeft_value**2,'.6e'), '# cHl1Abs33'],
	  [653, format(abs(scaled_wc('phil3_11')) * lambda_smeft_value**2,'.6e'), '# cHl3Abs11'],
	  [654, format(abs(scaled_wc('phil3_12')) * lambda_smeft_value**2,'.6e'), '# cHl3Abs12'],
	  [655, format(abs(scaled_wc('phil3_13')) * lambda_smeft_value**2,'.6e'), '# cHl3Abs13'],
	  [656, format(abs(scaled_wc('phil3_22')) * lambda_smeft_value**2,'.6e'), '# cHl3Abs22'],
	  [657, format(abs(scaled_wc('phil3_23')) * lambda_smeft_value**2,'.6e'), '# cHl3Abs23'],
	  [658, format(abs(scaled_wc('phil3_33')) * lambda_smeft_value**2,'.6e'), '# cHl3Abs33'],
	  [659, format(abs(scaled_wc('phiq1_11')) * lambda_smeft_value**2,'.6e'), '# cHq1Abs11'],
	  [660, format(abs(scaled_wc('phiq1_12')) * lambda_smeft_value**2,'.6e'), '# cHq1Abs12'],
	  [661, format(abs(scaled_wc('phiq1_13')) * lambda_smeft_value**2,'.6e'), '# cHq1Abs13'],
	  [662, format(abs(scaled_wc('phiq1_22')) * lambda_smeft_value**2,'.6e'), '# cHq1Abs22'],
	  [663, format(abs(scaled_wc('phiq1_23')) * lambda_smeft_value**2,'.6e'), '# cHq1Abs23'],
	  [664, format(abs(scaled_wc('phiq1_33')) * lambda_smeft_value**2,'.6e'), '# cHq1Abs33'],
	  [665, format(abs(scaled_wc('phiq3_11')) * lambda_smeft_value**2,'.6e'), '# cHq3Abs11'],
	  [666, format(abs(scaled_wc('phiq3_12')) * lambda_smeft_value**2,'.6e'), '# cHq3Abs12'],
	  [667, format(abs(scaled_wc('phiq3_13')) * lambda_smeft_value**2,'.6e'), '# cHq3Abs13'],
	  [668, format(abs(scaled_wc('phiq3_22')) * lambda_smeft_value**2,'.6e'), '# cHq3Abs22'],
	  [669, format(abs(scaled_wc('phiq3_23')) * lambda_smeft_value**2,'.6e'), '# cHq3Abs23'],
	  [670, format(abs(scaled_wc('phiq3_33')) * lambda_smeft_value**2,'.6e'), '# cHq3Abs33'],
	  [671, format(abs(scaled_wc('phie_11')) * lambda_smeft_value**2,'.6e'), '# cHeAbs11'],
	  [672, format(abs(scaled_wc('phie_12')) * lambda_smeft_value**2,'.6e'), '# cHeAbs12'],
	  [673, format(abs(scaled_wc('phie_13')) * lambda_smeft_value**2,'.6e'), '# cHeAbs13'],
	  [674, format(abs(scaled_wc('phie_22')) * lambda_smeft_value**2,'.6e'), '# cHeAbs22'],
	  [675, format(abs(scaled_wc('phie_23')) * lambda_smeft_value**2,'.6e'), '# cHeAbs23'],
	  [676, format(abs(scaled_wc('phie_33')) * lambda_smeft_value**2,'.6e'), '# cHeAbs33'],
	  [677, format(abs(scaled_wc('phiu_11')) * lambda_smeft_value**2,'.6e'), '# cHuAbs11'],
	  [678, format(abs(scaled_wc('phiu_12')) * lambda_smeft_value**2,'.6e'), '# cHuAbs12'],
	  [679, format(abs(scaled_wc('phiu_13')) * lambda_smeft_value**2,'.6e'), '# cHuAbs13'],
	  [680, format(abs(scaled_wc('phiu_22')) * lambda_smeft_value**2,'.6e'), '# cHuAbs22'],
	  [681, format(abs(scaled_wc('phiu_23')) * lambda_smeft_value**2,'.6e'), '# cHuAbs23'],
	  [682, format(abs(scaled_wc('phiu_33')) * lambda_smeft_value**2,'.6e'), '# cHuAbs33'],
	  [683, format(abs(scaled_wc('phid_11')) * lambda_smeft_value**2,'.6e'), '# cHdAbs11'],
	  [684, format(abs(scaled_wc('phid_12')) * lambda_smeft_value**2,'.6e'), '# cHdAbs12'],
	  [685, format(abs(scaled_wc('phid_13')) * lambda_smeft_value**2,'.6e'), '# cHdAbs13'],
	  [686, format(abs(scaled_wc('phid_22')) * lambda_smeft_value**2,'.6e'), '# cHdAbs22'],
	  [687, format(abs(scaled_wc('phid_23')) * lambda_smeft_value**2,'.6e'), '# cHdAbs23'],
	  [688, format(abs(scaled_wc('phid_33')) * lambda_smeft_value**2,'.6e'), '# cHdAbs33'],
	  [689, format(scaled_wc('ll_1111') * lambda_smeft_value**2,'.6e'), '# cllAbs1111'],
	  [690, format(scaled_wc('ll_1122') * lambda_smeft_value**2,'.6e'), '# cllAbs1122'],
	  [691, format(scaled_wc('ll_1221') * lambda_smeft_value**2,'.6e'), '# cllAbs1221'],
	  [692, format(scaled_wc('ll_1133') * lambda_smeft_value**2,'.6e'), '# cllAbs1133'],
	  [693, format(scaled_wc('ll_1331') * lambda_smeft_value**2,'.6e'), '# cllAbs1331'],
	  [694, format(scaled_wc('ll_2222') * lambda_smeft_value**2,'.6e'), '# cllAbs2222'],
	  [695, format(scaled_wc('ll_2233') * lambda_smeft_value**2,'.6e'), '# cllAbs2233'],
	  [696, format(scaled_wc('ll_2332') * lambda_smeft_value**2,'.6e'), '# cllAbs2332'],
	  [697, format(scaled_wc('ll_3333') * lambda_smeft_value**2,'.6e'), '# cllAbs3333'],
	  [698, format(abs(scaled_wc('ll_1112')) * lambda_smeft_value**2,'.6e'), '# cllAbs1112'],
	  [699, format(abs(scaled_wc('ll_1113')) * lambda_smeft_value**2,'.6e'), '# cllAbs1113'],
	  [700, format(abs(scaled_wc('ll_1123')) * lambda_smeft_value**2,'.6e'), '# cllAbs1123'],
	  [701, format(abs(scaled_wc('ll_1212')) * lambda_smeft_value**2,'.6e'), '# cllAbs1212'],
	  [702, format(abs(scaled_wc('ll_1213')) * lambda_smeft_value**2,'.6e'), '# cllAbs1213'],
	  [703, format(abs(scaled_wc('ll_1231')) * lambda_smeft_value**2,'.6e'), '# cllAbs1231'],
	  [704, format(abs(scaled_wc('ll_1222')) * lambda_smeft_value**2,'.6e'), '# cllAbs1222'],
	  [705, format(abs(scaled_wc('ll_1223')) * lambda_smeft_value**2,'.6e'), '# cllAbs1223'],
	  [706, format(abs(scaled_wc('ll_1232')) * lambda_smeft_value**2,'.6e'), '# cllAbs1232'],
	  [707, format(abs(scaled_wc('ll_1233')) * lambda_smeft_value**2,'.6e'), '# cllAbs1233'],
	  [708, format(abs(scaled_wc('ll_1313')) * lambda_smeft_value**2,'.6e'), '# cllAbs1313'],
	  [709, format(abs(scaled_wc('ll_1322')) * lambda_smeft_value**2,'.6e'), '# cllAbs1322'],
	  [710, format(abs(scaled_wc('ll_1332')) * lambda_smeft_value**2,'.6e'), '# cllAbs1332'],
	  [711, format(abs(scaled_wc('ll_1323')) * lambda_smeft_value**2,'.6e'), '# cllAbs1323'],
	  [712, format(abs(scaled_wc('ll_1333')) * lambda_smeft_value**2,'.6e'), '# cllAbs1333'],
	  [713, format(abs(scaled_wc('ll_2223')) * lambda_smeft_value**2,'.6e'), '# cllAbs2223'],
	  [714, format(abs(scaled_wc('ll_2323')) * lambda_smeft_value**2,'.6e'), '# cllAbs2323'],
	  [715, format(abs(scaled_wc('ll_2333')) * lambda_smeft_value**2,'.6e'), '# cllAbs3323'],
	  [716, format(scaled_wc('qq1_1111') * lambda_smeft_value**2,'.6e'), '# cqq1Abs1111'],
	  [717, format(scaled_wc('qq1_1122') * lambda_smeft_value**2,'.6e'), '# cqq1Abs1122'],
	  [718, format(scaled_wc('qq1_1221') * lambda_smeft_value**2,'.6e'), '# cqq1Abs1221'],
	  [719, format(scaled_wc('qq1_1133') * lambda_smeft_value**2,'.6e'), '# cqq1Abs1133'],
	  [720, format(scaled_wc('qq1_1331') * lambda_smeft_value**2,'.6e'), '# cqq1Abs1331'],
	  [721, format(scaled_wc('qq1_2222') * lambda_smeft_value**2,'.6e'), '# cqq1Abs2222'],
	  [722, format(scaled_wc('qq1_2233') * lambda_smeft_value**2,'.6e'), '# cqq1Abs2233'],
	  [723, format(scaled_wc('qq1_2332') * lambda_smeft_value**2,'.6e'), '# cqq1Abs2332'],
	  [724, format(scaled_wc('qq1_3333') * lambda_smeft_value**2,'.6e'), '# cqq1Abs3333'],
	  [725, format(abs(scaled_wc('qq1_1112')) * lambda_smeft_value**2,'.6e'), '# cqq1Abs1112'],
	  [726, format(abs(scaled_wc('qq1_1113')) * lambda_smeft_value**2,'.6e'), '# cqq1Abs1113'],
	  [727, format(abs(scaled_wc('qq1_1123')) * lambda_smeft_value**2,'.6e'), '# cqq1Abs1123'],
	  [728, format(abs(scaled_wc('qq1_1212')) * lambda_smeft_value**2,'.6e'), '# cqq1Abs1212'],
	  [729, format(abs(scaled_wc('qq1_1213')) * lambda_smeft_value**2,'.6e'), '# cqq1Abs1213'],
	  [730, format(abs(scaled_wc('qq1_1231')) * lambda_smeft_value**2,'.6e'), '# cqq1Abs1231'],
	  [731, format(abs(scaled_wc('qq1_1222')) * lambda_smeft_value**2,'.6e'), '# cqq1Abs1222'],
	  [732, format(abs(scaled_wc('qq1_1223')) * lambda_smeft_value**2,'.6e'), '# cqq1Abs1223'],
	  [733, format(abs(scaled_wc('qq1_1232')) * lambda_smeft_value**2,'.6e'), '# cqq1Abs1232'],
	  [734, format(abs(scaled_wc('qq1_1233')) * lambda_smeft_value**2,'.6e'), '# cqq1Abs1233'],
	  [735, format(abs(scaled_wc('qq1_1313')) * lambda_smeft_value**2,'.6e'), '# cqq1Abs1313'],
	  [736, format(abs(scaled_wc('qq1_1322')) * lambda_smeft_value**2,'.6e'), '# cqq1Abs1322'],
	  [737, format(abs(scaled_wc('qq1_1332')) * lambda_smeft_value**2,'.6e'), '# cqq1Abs1332'],
	  [738, format(abs(scaled_wc('qq1_1323')) * lambda_smeft_value**2,'.6e'), '# cqq1Abs1323'],
	  [739, format(abs(scaled_wc('qq1_1333')) * lambda_smeft_value**2,'.6e'), '# cqq1Abs1333'],
	  [740, format(abs(scaled_wc('qq1_2223')) * lambda_smeft_value**2,'.6e'), '# cqq1Abs2223'],
	  [741, format(abs(scaled_wc('qq1_2323')) * lambda_smeft_value**2,'.6e'), '# cqq1Abs2323'],
	  [742, format(abs(scaled_wc('qq1_2333')) * lambda_smeft_value**2,'.6e'), '# cqq1Abs3323'],
	  [743, format(scaled_wc('qq3_1111') * lambda_smeft_value**2,'.6e'), '# cqq3Abs1111'],
	  [744, format(scaled_wc('qq3_1122') * lambda_smeft_value**2,'.6e'), '# cqq3Abs1122'],
	  [745, format(scaled_wc('qq3_1221') * lambda_smeft_value**2,'.6e'), '# cqq3Abs1221'],
	  [746, format(scaled_wc('qq3_1133') * lambda_smeft_value**2,'.6e'), '# cqq3Abs1133'],
	  [747, format(scaled_wc('qq3_1331') * lambda_smeft_value**2,'.6e'), '# cqq3Abs1331'],
	  [748, format(scaled_wc('qq3_2222') * lambda_smeft_value**2,'.6e'), '# cqq3Abs2222'],
	  [749, format(scaled_wc('qq3_2233') * lambda_smeft_value**2,'.6e'), '# cqq3Abs2233'],
	  [750, format(scaled_wc('qq3_2332') * lambda_smeft_value**2,'.6e'), '# cqq3Abs2332'],
	  [751, format(scaled_wc('qq3_3333') * lambda_smeft_value**2,'.6e'), '# cqq3Abs3333'],
	  [752, format(abs(scaled_wc('qq3_1112')) * lambda_smeft_value**2,'.6e'), '# cqq3Abs1112'],
	  [753, format(abs(scaled_wc('qq3_1113')) * lambda_smeft_value**2,'.6e'), '# cqq3Abs1113'],
	  [754, format(abs(scaled_wc('qq3_1123')) * lambda_smeft_value**2,'.6e'), '# cqq3Abs1123'],
	  [755, format(abs(scaled_wc('qq3_1212')) * lambda_smeft_value**2,'.6e'), '# cqq3Abs1212'],
	  [756, format(abs(scaled_wc('qq3_1213')) * lambda_smeft_value**2,'.6e'), '# cqq3Abs1213'],
	  [757, format(abs(scaled_wc('qq3_1231')) * lambda_smeft_value**2,'.6e'), '# cqq3Abs1231'],
	  [758, format(abs(scaled_wc('qq3_1222')) * lambda_smeft_value**2,'.6e'), '# cqq3Abs1222'],
	  [759, format(abs(scaled_wc('qq3_1223')) * lambda_smeft_value**2,'.6e'), '# cqq3Abs1223'],
	  [760, format(abs(scaled_wc('qq3_1232')) * lambda_smeft_value**2,'.6e'), '# cqq3Abs1232'],
	  [761, format(abs(scaled_wc('qq3_1233')) * lambda_smeft_value**2,'.6e'), '# cqq3Abs1233'],
	  [762, format(abs(scaled_wc('qq3_1313')) * lambda_smeft_value**2,'.6e'), '# cqq3Abs1313'],
	  [763, format(abs(scaled_wc('qq3_1322')) * lambda_smeft_value**2,'.6e'), '# cqq3Abs1322'],
	  [764, format(abs(scaled_wc('qq3_1332')) * lambda_smeft_value**2,'.6e'), '# cqq3Abs1332'],
	  [765, format(abs(scaled_wc('qq3_1323')) * lambda_smeft_value**2,'.6e'), '# cqq3Abs1323'],
	  [766, format(abs(scaled_wc('qq3_1333')) * lambda_smeft_value**2,'.6e'), '# cqq3Abs1333'],
	  [767, format(abs(scaled_wc('qq3_2223')) * lambda_smeft_value**2,'.6e'), '# cqq3Abs2223'],
	  [768, format(abs(scaled_wc('qq3_2323')) * lambda_smeft_value**2,'.6e'), '# cqq3Abs2323'],
	  [769, format(abs(scaled_wc('qq3_2333')) * lambda_smeft_value**2,'.6e'), '# cqq3Abs3323'],
	  [770, format(scaled_wc('lq1_1111') * lambda_smeft_value**2,'.6e'), '# clq1Abs1111'],
	  [771, format(abs(scaled_wc('lq1_1112')) * lambda_smeft_value**2,'.6e'), '# clq1Abs1112'],
	  [772, format(abs(scaled_wc('lq1_1113')) * lambda_smeft_value**2,'.6e'), '# clq1Abs1113'],
	  [773, format(abs(scaled_wc('lq1_1123')) * lambda_smeft_value**2,'.6e'), '# clq1Abs1123'],
	  [774, format(scaled_wc('lq1_1122') * lambda_smeft_value**2,'.6e'), '# clq1Abs1122'],
	  [775, format(scaled_wc('lq1_1133') * lambda_smeft_value**2,'.6e'), '# clq1Abs1133'],
	  [776, format(abs(scaled_wc('lq1_1211')) * lambda_smeft_value**2,'.6e'), '# clq1Abs1211'],
	  [777, format(abs(scaled_wc('lq1_1212')) * lambda_smeft_value**2,'.6e'), '# clq1Abs1212'],
	  [778, format(abs(scaled_wc('lq1_1221')) * lambda_smeft_value**2,'.6e'), '# clq1Abs1221'],
	  [779, format(abs(scaled_wc('lq1_1213')) * lambda_smeft_value**2,'.6e'), '# clq1Abs1213'],
	  [780, format(abs(scaled_wc('lq1_1231')) * lambda_smeft_value**2,'.6e'), '# clq1Abs1231'],
	  [781, format(abs(scaled_wc('lq1_1222')) * lambda_smeft_value**2,'.6e'), '# clq1Abs1222'],
	  [782, format(abs(scaled_wc('lq1_1223')) * lambda_smeft_value**2,'.6e'), '# clq1Abs1223'],
	  [783, format(abs(scaled_wc('lq1_1232')) * lambda_smeft_value**2,'.6e'), '# clq1Abs1232'],
	  [784, format(abs(scaled_wc('lq1_1233')) * lambda_smeft_value**2,'.6e'), '# clq1Abs1233'],
	  [785, format(abs(scaled_wc('lq1_1311')) * lambda_smeft_value**2,'.6e'), '# clq1Abs1311'],
	  [786, format(abs(scaled_wc('lq1_1312')) * lambda_smeft_value**2,'.6e'), '# clq1Abs1312'],
	  [787, format(abs(scaled_wc('lq1_1313')) * lambda_smeft_value**2,'.6e'), '# clq1Abs1313'],
	  [788, format(abs(scaled_wc('lq1_1331')) * lambda_smeft_value**2,'.6e'), '# clq1Abs1331'],
	  [789, format(abs(scaled_wc('lq1_1321')) * lambda_smeft_value**2,'.6e'), '# clq1Abs1321'],
	  [790, format(abs(scaled_wc('lq1_1322')) * lambda_smeft_value**2,'.6e'), '# clq1Abs1322'],
	  [791, format(abs(scaled_wc('lq1_1332')) * lambda_smeft_value**2,'.6e'), '# clq1Abs1332'],
	  [792, format(abs(scaled_wc('lq1_1323')) * lambda_smeft_value**2,'.6e'), '# clq1Abs1323'],
	  [793, format(abs(scaled_wc('lq1_1333')) * lambda_smeft_value**2,'.6e'), '# clq1Abs1333'],
	  [794, format(scaled_wc('lq1_2211') * lambda_smeft_value**2,'.6e'), '# clq1Abs2211'],
	  [795, format(abs(scaled_wc('lq1_2212')) * lambda_smeft_value**2,'.6e'), '# clq1Abs2212'],
	  [796, format(abs(scaled_wc('lq1_2213')) * lambda_smeft_value**2,'.6e'), '# clq1Abs2213'],
	  [797, format(scaled_wc('lq1_2222') * lambda_smeft_value**2,'.6e'), '# clq1Abs2222'],
	  [798, format(abs(scaled_wc('lq1_2223')) * lambda_smeft_value**2,'.6e'), '# clq1Abs2223'],
	  [799, format(scaled_wc('lq1_2233') * lambda_smeft_value**2,'.6e'), '# clq1Abs2233'],
	  [800, format(abs(scaled_wc('lq1_2311')) * lambda_smeft_value**2,'.6e'), '# clq1Abs2311'],
	  [801, format(abs(scaled_wc('lq1_2312')) * lambda_smeft_value**2,'.6e'), '# clq1Abs2312'],
	  [802, format(abs(scaled_wc('lq1_2313')) * lambda_smeft_value**2,'.6e'), '# clq1Abs2313'],
	  [803, format(abs(scaled_wc('lq1_2321')) * lambda_smeft_value**2,'.6e'), '# clq1Abs2321'],
	  [804, format(abs(scaled_wc('lq1_2322')) * lambda_smeft_value**2,'.6e'), '# clq1Abs2322'],
	  [805, format(abs(scaled_wc('lq1_2323')) * lambda_smeft_value**2,'.6e'), '# clq1Abs2323'],
	  [806, format(abs(scaled_wc('lq1_2331')) * lambda_smeft_value**2,'.6e'), '# clq1Abs2331'],
	  [807, format(abs(scaled_wc('lq1_2332')) * lambda_smeft_value**2,'.6e'), '# clq1Abs2332'],
	  [808, format(abs(scaled_wc('lq1_2333')) * lambda_smeft_value**2,'.6e'), '# clq1Abs2333'],
	  [809, format(scaled_wc('lq1_3311') * lambda_smeft_value**2,'.6e'), '# clq1Abs3311'],
	  [810, format(abs(scaled_wc('lq1_3312')) * lambda_smeft_value**2,'.6e'), '# clq1Abs3312'],
	  [811, format(abs(scaled_wc('lq1_3313')) * lambda_smeft_value**2,'.6e'), '# clq1Abs3313'],
	  [812, format(scaled_wc('lq1_3322') * lambda_smeft_value**2,'.6e'), '# clq1Abs3322'],
	  [813, format(scaled_wc('lq1_3333') * lambda_smeft_value**2,'.6e'), '# clq1Abs3333'],
	  [814, format(abs(scaled_wc('lq1_3323')) * lambda_smeft_value**2,'.6e'), '# clq1Abs3323'],
	  [815, format(scaled_wc('lq3_1111') * lambda_smeft_value**2,'.6e'),      '# clq3Abs1111'],
	  [816, format(abs(scaled_wc('lq3_1112')) * lambda_smeft_value**2,'.6e'), '# clq3Abs1112'],
	  [817, format(abs(scaled_wc('lq3_1113')) * lambda_smeft_value**2,'.6e'), '# clq3Abs1113'],
	  [818, format(abs(scaled_wc('lq3_1123')) * lambda_smeft_value**2,'.6e'), '# clq3Abs1123'],
	  [819, format(scaled_wc('lq3_1122') * lambda_smeft_value**2,'.6e'),      '# clq3Abs1122'],
	  [820, format(scaled_wc('lq3_1133') * lambda_smeft_value**2,'.6e'),      '# clq3Abs1133'],
	  [821, format(abs(scaled_wc('lq3_1211')) * lambda_smeft_value**2,'.6e'), '# clq3Abs1211'],
	  [822, format(abs(scaled_wc('lq3_1212')) * lambda_smeft_value**2,'.6e'), '# clq3Abs1212'],
	  [823, format(abs(scaled_wc('lq3_1221')) * lambda_smeft_value**2,'.6e'), '# clq3Abs1221'],
	  [824, format(abs(scaled_wc('lq3_1213')) * lambda_smeft_value**2,'.6e'), '# clq3Abs1213'],
	  [825, format(abs(scaled_wc('lq3_1231')) * lambda_smeft_value**2,'.6e'), '# clq3Abs1231'],
	  [826, format(abs(scaled_wc('lq3_1222')) * lambda_smeft_value**2,'.6e'), '# clq3Abs1222'],
	  [827, format(abs(scaled_wc('lq3_1223')) * lambda_smeft_value**2,'.6e'), '# clq3Abs1223'],
	  [828, format(abs(scaled_wc('lq3_1232')) * lambda_smeft_value**2,'.6e'), '# clq3Abs1232'],
	  [829, format(abs(scaled_wc('lq3_1233')) * lambda_smeft_value**2,'.6e'), '# clq3Abs1233'],
	  [830, format(abs(scaled_wc('lq3_1311')) * lambda_smeft_value**2,'.6e'), '# clq3Abs1311'],
	  [831, format(abs(scaled_wc('lq3_1312')) * lambda_smeft_value**2,'.6e'), '# clq3Abs1312'],
	  [832, format(abs(scaled_wc('lq3_1313')) * lambda_smeft_value**2,'.6e'), '# clq3Abs1313'],
	  [833, format(abs(scaled_wc('lq3_1331')) * lambda_smeft_value**2,'.6e'), '# clq3Abs1331'],
	  [834, format(abs(scaled_wc('lq3_1321')) * lambda_smeft_value**2,'.6e'), '# clq3Abs1321'],
	  [835, format(abs(scaled_wc('lq3_1322')) * lambda_smeft_value**2,'.6e'), '# clq3Abs1322'],
	  [836, format(abs(scaled_wc('lq3_1332')) * lambda_smeft_value**2,'.6e'), '# clq3Abs1332'],
	  [837, format(abs(scaled_wc('lq3_1323')) * lambda_smeft_value**2,'.6e'), '# clq3Abs1323'],
	  [838, format(abs(scaled_wc('lq3_1333')) * lambda_smeft_value**2,'.6e'), '# clq3Abs1333'],
	  [839, format(scaled_wc('lq3_2211') * lambda_smeft_value**2,'.6e'),      '# clq3Abs2211'],
	  [840, format(abs(scaled_wc('lq3_2212')) * lambda_smeft_value**2,'.6e'), '# clq3Abs2212'],
	  [841, format(abs(scaled_wc('lq3_2213')) * lambda_smeft_value**2,'.6e'), '# clq3Abs2213'],
	  [842, format(scaled_wc('lq3_2222') * lambda_smeft_value**2,'.6e'),      '# clq3Abs2222'],
	  [843, format(abs(scaled_wc('lq3_2223')) * lambda_smeft_value**2,'.6e'), '# clq3Abs2223'],
	  [844, format(scaled_wc('lq3_2233') * lambda_smeft_value**2,'.6e'),      '# clq3Abs2233'],
	  [845, format(abs(scaled_wc('lq3_2311')) * lambda_smeft_value**2,'.6e'), '# clq3Abs2311'],
	  [846, format(abs(scaled_wc('lq3_2312')) * lambda_smeft_value**2,'.6e'), '# clq3Abs2312'],
	  [847, format(abs(scaled_wc('lq3_2313')) * lambda_smeft_value**2,'.6e'), '# clq3Abs2313'],
	  [848, format(abs(scaled_wc('lq3_2321')) * lambda_smeft_value**2,'.6e'), '# clq3Abs2321'],
	  [849, format(abs(scaled_wc('lq3_2322')) * lambda_smeft_value**2,'.6e'), '# clq3Abs2322'],
	  [850, format(abs(scaled_wc('lq3_2323')) * lambda_smeft_value**2,'.6e'), '# clq3Abs2323'],
	  [851, format(abs(scaled_wc('lq3_2331')) * lambda_smeft_value**2,'.6e'), '# clq3Abs2331'],
	  [852, format(abs(scaled_wc('lq3_2332')) * lambda_smeft_value**2,'.6e'), '# clq3Abs2332'],
	  [853, format(abs(scaled_wc('lq3_2333')) * lambda_smeft_value**2,'.6e'), '# clq3Abs2333'],
	  [854, format(scaled_wc('lq3_3311') * lambda_smeft_value**2,'.6e'),      '# clq3Abs3311'],
	  [855, format(abs(scaled_wc('lq3_3312')) * lambda_smeft_value**2,'.6e'), '# clq3Abs3312'],
	  [856, format(abs(scaled_wc('lq3_3313')) * lambda_smeft_value**2,'.6e'), '# clq3Abs3313'],
	  [857, format(scaled_wc('lq3_3322') * lambda_smeft_value**2,'.6e'),      '# clq3Abs3322'],
	  [858, format(scaled_wc('lq3_3333') * lambda_smeft_value**2,'.6e'),      '# clq3Abs3333'],
	  [859, format(abs(scaled_wc('lq3_3323')) * lambda_smeft_value**2,'.6e'), '# clq3Abs3323'],
	  [860, format(scaled_wc('ee_1111') * lambda_smeft_value**2,'.6e'),      '# ceeAbs1111'],
          [861, format(scaled_wc('ee_1122') * lambda_smeft_value**2,'.6e'),      '# ceeAbs1122'],
          [862, format(scaled_wc('ee_1133') * lambda_smeft_value**2,'.6e'),      '# ceeAbs1133'],
          [863, format(scaled_wc('ee_2222') * lambda_smeft_value**2,'.6e'),      '# ceeAbs2222'],
          [864, format(scaled_wc('ee_2233') * lambda_smeft_value**2,'.6e'),      '# ceeAbs2233'],
          [865, format(abs(scaled_wc('ee_1112')) * lambda_smeft_value**2,'.6e'),      '# ceeAbs1112'],
          [866, format(abs(scaled_wc('ee_3333')) * lambda_smeft_value**2,'.6e'),      '# ceeAbs3333'],
          [867, format(abs(scaled_wc('ee_1123')) * lambda_smeft_value**2,'.6e'),      '# ceeAbs1123'],
          [868, format(abs(scaled_wc('ee_1113')) * lambda_smeft_value**2,'.6e'),      '# ceeAbs1113'],
          [869, format(abs(scaled_wc('ee_1213')) * lambda_smeft_value**2,'.6e'),      '# ceeAbs1213'],
          [870, format(abs(scaled_wc('ee_1212')) * lambda_smeft_value**2,'.6e'),      '# ceeAbs1212'],
          [871, format(abs(scaled_wc('ee_1232')) * lambda_smeft_value**2,'.6e'),      '# ceeAbs1232'],
          [872, format(abs(scaled_wc('ee_1222')) * lambda_smeft_value**2,'.6e'),      '# ceeAbs1222'],
          [873, format(abs(scaled_wc('ee_1313')) * lambda_smeft_value**2,'.6e'),      '# ceeAbs1313'],
          [874, format(abs(scaled_wc('ee_1233')) * lambda_smeft_value**2,'.6e'),      '# ceeAbs1233'],
          [875, format(abs(scaled_wc('ee_1323')) * lambda_smeft_value**2,'.6e'),      '# ceeAbs1323'],
          [876, format(abs(scaled_wc('ee_1223')) * lambda_smeft_value**2,'.6e'),      '# ceeAbs1322'],  # element 1322 replaced with 1223 in wcxf
          [877, format(abs(scaled_wc('ee_2223')) * lambda_smeft_value**2,'.6e'),      '# ceeAbs2223'],
          [878, format(abs(scaled_wc('ee_1333')) * lambda_smeft_value**2,'.6e'),      '# ceeAbs1333'],
          [879, format(abs(scaled_wc('ee_2333')) * lambda_smeft_value**2,'.6e'),      '# ceeAbs3323'],  # element 3323 replaced with 2223 in wcxf
          [880, format(abs(scaled_wc('ee_2323')) * lambda_smeft_value**2,'.6e'),      '# ceeAbs2323'],
	  [881, format(scaled_wc('uu_1111') * lambda_smeft_value**2,'.6e'),      '# cuuAbs1111'],
	  [882, format(scaled_wc('uu_1122') * lambda_smeft_value**2,'.6e'),      '# cuuAbs1122'],
	  [883, format(scaled_wc('uu_1221') * lambda_smeft_value**2,'.6e'),      '# cuuAbs1221'],
	  [884, format(scaled_wc('uu_1133') * lambda_smeft_value**2,'.6e'),      '# cuuAbs1133'],
	  [885, format(scaled_wc('uu_1331') * lambda_smeft_value**2,'.6e'),      '# cuuAbs1331'],
	  [886, format(scaled_wc('uu_2222') * lambda_smeft_value**2,'.6e'),      '# cuuAbs2222'],
	  [887, format(scaled_wc('uu_2233') * lambda_smeft_value**2,'.6e'),      '# cuuAbs2233'],
	  [888, format(scaled_wc('uu_2332') * lambda_smeft_value**2,'.6e'),      '# cuuAbs2332'],
	  [889, format(scaled_wc('uu_3333') * lambda_smeft_value**2,'.6e'),      '# cuuAbs3333'],
	  [890, format(abs(scaled_wc('uu_1112')) * lambda_smeft_value**2,'.6e'), '# cuuAbs1112'],
	  [891, format(abs(scaled_wc('uu_1113')) * lambda_smeft_value**2,'.6e'), '# cuuAbs1113'],
	  [892, format(abs(scaled_wc('uu_1123')) * lambda_smeft_value**2,'.6e'), '# cuuAbs1123'],
	  [893, format(abs(scaled_wc('uu_1212')) * lambda_smeft_value**2,'.6e'), '# cuuAbs1212'],
	  [894, format(abs(scaled_wc('uu_1213')) * lambda_smeft_value**2,'.6e'), '# cuuAbs1213'],
	  [895, format(abs(scaled_wc('uu_1231')) * lambda_smeft_value**2,'.6e'), '# cuuAbs1231'],
	  [896, format(abs(scaled_wc('uu_1222')) * lambda_smeft_value**2,'.6e'), '# cuuAbs1222'],
	  [897, format(abs(scaled_wc('uu_1223')) * lambda_smeft_value**2,'.6e'), '# cuuAbs1223'],
	  [898, format(abs(scaled_wc('uu_1232')) * lambda_smeft_value**2,'.6e'), '# cuuAbs1232'],
	  [899, format(abs(scaled_wc('uu_1233')) * lambda_smeft_value**2,'.6e'), '# cuuAbs1233'],
	  [900, format(abs(scaled_wc('uu_1313')) * lambda_smeft_value**2,'.6e'), '# cuuAbs1313'],
	  [901, format(abs(scaled_wc('uu_1322')) * lambda_smeft_value**2,'.6e'), '# cuuAbs1322'],
	  [902, format(abs(scaled_wc('uu_1332')) * lambda_smeft_value**2,'.6e'), '# cuuAbs1332'],
	  [903, format(abs(scaled_wc('uu_1323')) * lambda_smeft_value**2,'.6e'), '# cuuAbs1323'],
	  [904, format(abs(scaled_wc('uu_1333')) * lambda_smeft_value**2,'.6e'), '# cuuAbs1333'],
	  [905, format(abs(scaled_wc('uu_2223')) * lambda_smeft_value**2,'.6e'), '# cuuAbs2223'],
	  [906, format(abs(scaled_wc('uu_2323')) * lambda_smeft_value**2,'.6e'), '# cuuAbs2323'],
	  [907, format(abs(scaled_wc('uu_2333')) * lambda_smeft_value**2,'.6e'), '# cuuAbs3323'],
	  [908, format(scaled_wc('dd_1111') * lambda_smeft_value**2,'.6e'),      '# cddAbs1111'],
	  [909, format(scaled_wc('dd_1122') * lambda_smeft_value**2,'.6e'),      '# cddAbs1122'],
	  [910, format(scaled_wc('dd_1221') * lambda_smeft_value**2,'.6e'),      '# cddAbs1221'],
	  [911, format(scaled_wc('dd_1133') * lambda_smeft_value**2,'.6e'),      '# cddAbs1133'],
	  [912, format(scaled_wc('dd_1331') * lambda_smeft_value**2,'.6e'),      '# cddAbs1331'],
	  [913, format(scaled_wc('dd_2222') * lambda_smeft_value**2,'.6e'),      '# cddAbs2222'],
	  [914, format(scaled_wc('dd_2233') * lambda_smeft_value**2,'.6e'),      '# cddAbs2233'],
	  [915, format(scaled_wc('dd_2332') * lambda_smeft_value**2,'.6e'),      '# cddAbs2332'],
	  [916, format(scaled_wc('dd_3333') * lambda_smeft_value**2,'.6e'),      '# cddAbs3333'],
	  [917, format(abs(scaled_wc('dd_1112')) * lambda_smeft_value**2,'.6e'), '# cddAbs1112'],
	  [918, format(abs(scaled_wc('dd_1113')) * lambda_smeft_value**2,'.6e'), '# cddAbs1113'],
	  [919, format(abs(scaled_wc('dd_1123')) * lambda_smeft_value**2,'.6e'), '# cddAbs1123'],
	  [920, format(abs(scaled_wc('dd_1212')) * lambda_smeft_value**2,'.6e'), '# cddAbs1212'],
	  [921, format(abs(scaled_wc('dd_1213')) * lambda_smeft_value**2,'.6e'), '# cddAbs1213'],
	  [922, format(abs(scaled_wc('dd_1231')) * lambda_smeft_value**2,'.6e'), '# cddAbs1231'],
	  [923, format(abs(scaled_wc('dd_1222')) * lambda_smeft_value**2,'.6e'), '# cddAbs1222'],
	  [924, format(abs(scaled_wc('dd_1223')) * lambda_smeft_value**2,'.6e'), '# cddAbs1223'],
	  [925, format(abs(scaled_wc('dd_1232')) * lambda_smeft_value**2,'.6e'), '# cddAbs1232'],
	  [926, format(abs(scaled_wc('dd_1233')) * lambda_smeft_value**2,'.6e'), '# cddAbs1233'],
	  [927, format(abs(scaled_wc('dd_1313')) * lambda_smeft_value**2,'.6e'), '# cddAbs1313'],
	  [928, format(abs(scaled_wc('dd_1322')) * lambda_smeft_value**2,'.6e'), '# cddAbs1322'],
	  [929, format(abs(scaled_wc('dd_1332')) * lambda_smeft_value**2,'.6e'), '# cddAbs1332'],
	  [930, format(abs(scaled_wc('dd_1323')) * lambda_smeft_value**2,'.6e'), '# cddAbs1323'],
	  [931, format(abs(scaled_wc('dd_1333')) * lambda_smeft_value**2,'.6e'), '# cddAbs1333'],
	  [932, format(abs(scaled_wc('dd_2223')) * lambda_smeft_value**2,'.6e'), '# cddAbs2223'],
	  [933, format(abs(scaled_wc('dd_2323')) * lambda_smeft_value**2,'.6e'), '# cddAbs2323'],
	  [934, format(abs(scaled_wc('dd_2333')) * lambda_smeft_value**2,'.6e'), '# cddAbs3323'],
	  [935, format(scaled_wc('eu_1111') * lambda_smeft_value**2,'.6e'),      '# ceuAbs1111'],
	  [936, format(abs(scaled_wc('eu_1112')) * lambda_smeft_value**2,'.6e'), '# ceuAbs1112'],
	  [937, format(abs(scaled_wc('eu_1113')) * lambda_smeft_value**2,'.6e'), '# ceuAbs1113'],
	  [938, format(abs(scaled_wc('eu_1123')) * lambda_smeft_value**2,'.6e'), '# ceuAbs1123'],
	  [939, format(scaled_wc('eu_1122') * lambda_smeft_value**2,'.6e'),      '# ceuAbs1122'],
	  [940, format(scaled_wc('eu_1133') * lambda_smeft_value**2,'.6e'),      '# ceuAbs1133'],
	  [941, format(abs(scaled_wc('eu_1211')) * lambda_smeft_value**2,'.6e'), '# ceuAbs1211'],
	  [942, format(abs(scaled_wc('eu_1212')) * lambda_smeft_value**2,'.6e'), '# ceuAbs1212'],
	  [943, format(abs(scaled_wc('eu_1221')) * lambda_smeft_value**2,'.6e'), '# ceuAbs1221'],
	  [944, format(abs(scaled_wc('eu_1213')) * lambda_smeft_value**2,'.6e'), '# ceuAbs1213'],
	  [945, format(abs(scaled_wc('eu_1231')) * lambda_smeft_value**2,'.6e'), '# ceuAbs1231'],
	  [946, format(abs(scaled_wc('eu_1222')) * lambda_smeft_value**2,'.6e'), '# ceuAbs1222'],
	  [947, format(abs(scaled_wc('eu_1223')) * lambda_smeft_value**2,'.6e'), '# ceuAbs1223'],
	  [948, format(abs(scaled_wc('eu_1232')) * lambda_smeft_value**2,'.6e'), '# ceuAbs1232'],
	  [949, format(abs(scaled_wc('eu_1233')) * lambda_smeft_value**2,'.6e'), '# ceuAbs1233'],
	  [950, format(abs(scaled_wc('eu_1311')) * lambda_smeft_value**2,'.6e'), '# ceuAbs1311'],
	  [951, format(abs(scaled_wc('eu_1312')) * lambda_smeft_value**2,'.6e'), '# ceuAbs1312'],
	  [952, format(abs(scaled_wc('eu_1313')) * lambda_smeft_value**2,'.6e'), '# ceuAbs1313'],
	  [953, format(abs(scaled_wc('eu_1331')) * lambda_smeft_value**2,'.6e'), '# ceuAbs1331'],
	  [954, format(abs(scaled_wc('eu_1321')) * lambda_smeft_value**2,'.6e'), '# ceuAbs1321'],
	  [955, format(abs(scaled_wc('eu_1322')) * lambda_smeft_value**2,'.6e'), '# ceuAbs1322'],
	  [956, format(abs(scaled_wc('eu_1332')) * lambda_smeft_value**2,'.6e'), '# ceuAbs1332'],
	  [957, format(abs(scaled_wc('eu_1323')) * lambda_smeft_value**2,'.6e'), '# ceuAbs1323'],
	  [958, format(abs(scaled_wc('eu_1333')) * lambda_smeft_value**2,'.6e'), '# ceuAbs1333'],
	  [959, format(scaled_wc('eu_2211') * lambda_smeft_value**2,'.6e'),      '# ceuAbs2211'],
	  [960, format(abs(scaled_wc('eu_2212')) * lambda_smeft_value**2,'.6e'), '# ceuAbs2212'],
	  [961, format(abs(scaled_wc('eu_2213')) * lambda_smeft_value**2,'.6e'), '# ceuAbs2213'],
	  [962, format(scaled_wc('eu_2222') * lambda_smeft_value**2,'.6e'),      '# ceuAbs2222'],
	  [963, format(abs(scaled_wc('eu_2223')) * lambda_smeft_value**2,'.6e'), '# ceuAbs2223'],
	  [964, format(scaled_wc('eu_2233') * lambda_smeft_value**2,'.6e'),      '# ceuAbs2233'],
	  [965, format(abs(scaled_wc('eu_2311')) * lambda_smeft_value**2,'.6e'), '# ceuAbs2311'],
	  [966, format(abs(scaled_wc('eu_2312')) * lambda_smeft_value**2,'.6e'), '# ceuAbs2312'],
	  [967, format(abs(scaled_wc('eu_2313')) * lambda_smeft_value**2,'.6e'), '# ceuAbs2313'],
	  [968, format(abs(scaled_wc('eu_2321')) * lambda_smeft_value**2,'.6e'), '# ceuAbs2321'],
	  [969, format(abs(scaled_wc('eu_2322')) * lambda_smeft_value**2,'.6e'), '# ceuAbs2322'],
	  [970, format(abs(scaled_wc('eu_2323')) * lambda_smeft_value**2,'.6e'), '# ceuAbs2323'],
	  [971, format(abs(scaled_wc('eu_2331')) * lambda_smeft_value**2,'.6e'), '# ceuAbs2331'],
	  [972, format(abs(scaled_wc('eu_2332')) * lambda_smeft_value**2,'.6e'), '# ceuAbs2332'],
	  [973, format(abs(scaled_wc('eu_2333')) * lambda_smeft_value**2,'.6e'), '# ceuAbs2333'],
	  [974, format(scaled_wc('eu_3311') * lambda_smeft_value**2,'.6e'),      '# ceuAbs3311'],
	  [975, format(abs(scaled_wc('eu_3312')) * lambda_smeft_value**2,'.6e'), '# ceuAbs3312'],
	  [976, format(abs(scaled_wc('eu_3313')) * lambda_smeft_value**2,'.6e'), '# ceuAbs3313'],
	  [977, format(scaled_wc('eu_3322') * lambda_smeft_value**2,'.6e'),      '# ceuAbs3322'],
	  [978, format(scaled_wc('eu_3333') * lambda_smeft_value**2,'.6e'),      '# ceuAbs3333'],
	  [979, format(abs(scaled_wc('eu_3323')) * lambda_smeft_value**2,'.6e'), '# ceuAbs3323'],
	  [980, format(scaled_wc('ed_1111') * lambda_smeft_value**2,'.6e'),      '# cedAbs1111'],
	  [981, format(abs(scaled_wc('ed_1112')) * lambda_smeft_value**2,'.6e'), '# cedAbs1112'],
	  [982, format(abs(scaled_wc('ed_1113')) * lambda_smeft_value**2,'.6e'), '# cedAbs1113'],
	  [983, format(abs(scaled_wc('ed_1123')) * lambda_smeft_value**2,'.6e'), '# cedAbs1123'],
	  [984, format(scaled_wc('ed_1122') * lambda_smeft_value**2,'.6e'),      '# cedAbs1122'],
	  [985, format(scaled_wc('ed_1133') * lambda_smeft_value**2,'.6e'),      '# cedAbs1133'],
	  [986, format(abs(scaled_wc('ed_1211')) * lambda_smeft_value**2,'.6e'), '# cedAbs1211'],
	  [987, format(abs(scaled_wc('ed_1212')) * lambda_smeft_value**2,'.6e'), '# cedAbs1212'],
	  [988, format(abs(scaled_wc('ed_1221')) * lambda_smeft_value**2,'.6e'), '# cedAbs1221'],
	  [989, format(abs(scaled_wc('ed_1213')) * lambda_smeft_value**2,'.6e'), '# cedAbs1213'],
	  [990, format(abs(scaled_wc('ed_1231')) * lambda_smeft_value**2,'.6e'), '# cedAbs1231'],
	  [991, format(abs(scaled_wc('ed_1222')) * lambda_smeft_value**2,'.6e'), '# cedAbs1222'],
	  [992, format(abs(scaled_wc('ed_1223')) * lambda_smeft_value**2,'.6e'), '# cedAbs1223'],
	  [993, format(abs(scaled_wc('ed_1232')) * lambda_smeft_value**2,'.6e'), '# cedAbs1232'],
	  [994, format(abs(scaled_wc('ed_1233')) * lambda_smeft_value**2,'.6e'), '# cedAbs1233'],
	  [995, format(abs(scaled_wc('ed_1311')) * lambda_smeft_value**2,'.6e'), '# cedAbs1311'],
	  [996, format(abs(scaled_wc('ed_1312')) * lambda_smeft_value**2,'.6e'), '# cedAbs1312'],
	  [997, format(abs(scaled_wc('ed_1313')) * lambda_smeft_value**2,'.6e'), '# cedAbs1313'],
	  [998, format(abs(scaled_wc('ed_1331')) * lambda_smeft_value**2,'.6e'), '# cedAbs1331'],
	  [999, format(abs(scaled_wc('ed_1321')) * lambda_smeft_value**2,'.6e'), '# cedAbs1321'],
	  [1000, format(abs(scaled_wc('ed_1322')) * lambda_smeft_value**2,'.6e'), '# cedAbs1322'],
	  [1001, format(abs(scaled_wc('ed_1332')) * lambda_smeft_value**2,'.6e'), '# cedAbs1332'],
	  [1002, format(abs(scaled_wc('ed_1323')) * lambda_smeft_value**2,'.6e'), '# cedAbs1323'],
	  [1003, format(abs(scaled_wc('ed_1333')) * lambda_smeft_value**2,'.6e'), '# cedAbs1333'],
	  [1004, format(scaled_wc('ed_2211') * lambda_smeft_value**2,'.6e'),      '# cedAbs2211'],
	  [1005, format(abs(scaled_wc('ed_2212')) * lambda_smeft_value**2,'.6e'), '# cedAbs2212'],
	  [1006, format(abs(scaled_wc('ed_2213')) * lambda_smeft_value**2,'.6e'), '# cedAbs2213'],
	  [1007, format(scaled_wc('ed_2222') * lambda_smeft_value**2,'.6e'),      '# cedAbs2222'],
	  [1008, format(abs(scaled_wc('ed_2223')) * lambda_smeft_value**2,'.6e'), '# cedAbs2223'],
	  [1009, format(scaled_wc('ed_2233') * lambda_smeft_value**2,'.6e'),      '# cedAbs2233'],
	  [1010, format(abs(scaled_wc('ed_2311')) * lambda_smeft_value**2,'.6e'), '# cedAbs2311'],
	  [1011, format(abs(scaled_wc('ed_2312')) * lambda_smeft_value**2,'.6e'), '# cedAbs2312'],
	  [1012, format(abs(scaled_wc('ed_2313')) * lambda_smeft_value**2,'.6e'), '# cedAbs2313'],
	  [1013, format(abs(scaled_wc('ed_2321')) * lambda_smeft_value**2,'.6e'), '# cedAbs2321'],
	  [1014, format(abs(scaled_wc('ed_2322')) * lambda_smeft_value**2,'.6e'), '# cedAbs2322'],
	  [1015, format(abs(scaled_wc('ed_2323')) * lambda_smeft_value**2,'.6e'), '# cedAbs2323'],
	  [1016, format(abs(scaled_wc('ed_2331')) * lambda_smeft_value**2,'.6e'), '# cedAbs2331'],
	  [1017, format(abs(scaled_wc('ed_2332')) * lambda_smeft_value**2,'.6e'), '# cedAbs2332'],
	  [1018, format(abs(scaled_wc('ed_2333')) * lambda_smeft_value**2,'.6e'), '# cedAbs2333'],
	  [1019, format(scaled_wc('ed_3311') * lambda_smeft_value**2,'.6e'),      '# cedAbs3311'],
	  [1020, format(abs(scaled_wc('ed_3312')) * lambda_smeft_value**2,'.6e'), '# cedAbs3312'],
	  [1021, format(abs(scaled_wc('ed_3313')) * lambda_smeft_value**2,'.6e'), '# cedAbs3313'],
	  [1022, format(scaled_wc('ed_3322') * lambda_smeft_value**2,'.6e'),      '# cedAbs3322'],
	  [1023, format(scaled_wc('ed_3333') * lambda_smeft_value**2,'.6e'),      '# cedAbs3333'],
	  [1024, format(abs(scaled_wc('ed_3323')) * lambda_smeft_value**2,'.6e'), '# cedAbs3323'],
	  [1025, format(scaled_wc('ud1_1111') * lambda_smeft_value**2,'.6e'),     '# cud1Abs1111'],
	  [1026, format(abs(scaled_wc('ud1_1112')) * lambda_smeft_value**2,'.6e'), '# cud1Abs1112'],
	  [1027, format(abs(scaled_wc('ud1_1113')) * lambda_smeft_value**2,'.6e'), '# cud1Abs1113'],
	  [1028, format(abs(scaled_wc('ud1_1123')) * lambda_smeft_value**2,'.6e'), '# cud1Abs1123'],
	  [1029, format(scaled_wc('ud1_1122') * lambda_smeft_value**2,'.6e'),      '# cud1Abs1122'],
	  [1030, format(scaled_wc('ud1_1133') * lambda_smeft_value**2,'.6e'),      '# cud1Abs1133'],
	  [1031, format(abs(scaled_wc('ud1_1211')) * lambda_smeft_value**2,'.6e'), '# cud1Abs1211'],
	  [1032, format(abs(scaled_wc('ud1_1212')) * lambda_smeft_value**2,'.6e'), '# cud1Abs1212'],
	  [1033, format(abs(scaled_wc('ud1_1221')) * lambda_smeft_value**2,'.6e'), '# cud1Abs1221'],
	  [1034, format(abs(scaled_wc('ud1_1213')) * lambda_smeft_value**2,'.6e'), '# cud1Abs1213'],
	  [1035, format(abs(scaled_wc('ud1_1231')) * lambda_smeft_value**2,'.6e'), '# cud1Abs1231'],
	  [1036, format(abs(scaled_wc('ud1_1222')) * lambda_smeft_value**2,'.6e'), '# cud1Abs1222'],
	  [1037, format(abs(scaled_wc('ud1_1223')) * lambda_smeft_value**2,'.6e'), '# cud1Abs1223'],
	  [1038, format(abs(scaled_wc('ud1_1232')) * lambda_smeft_value**2,'.6e'), '# cud1Abs1232'],
	  [1039, format(abs(scaled_wc('ud1_1233')) * lambda_smeft_value**2,'.6e'), '# cud1Abs1233'],
	  [1040, format(abs(scaled_wc('ud1_1311')) * lambda_smeft_value**2,'.6e'), '# cud1Abs1311'],
	  [1041, format(abs(scaled_wc('ud1_1312')) * lambda_smeft_value**2,'.6e'), '# cud1Abs1312'],
	  [1042, format(abs(scaled_wc('ud1_1313')) * lambda_smeft_value**2,'.6e'), '# cud1Abs1313'],
	  [1043, format(abs(scaled_wc('ud1_1331')) * lambda_smeft_value**2,'.6e'), '# cud1Abs1331'],
	  [1044, format(abs(scaled_wc('ud1_1321')) * lambda_smeft_value**2,'.6e'), '# cud1Abs1321'],
	  [1045, format(abs(scaled_wc('ud1_1322')) * lambda_smeft_value**2,'.6e'), '# cud1Abs1322'],
	  [1046, format(abs(scaled_wc('ud1_1332')) * lambda_smeft_value**2,'.6e'), '# cud1Abs1332'],
	  [1047, format(abs(scaled_wc('ud1_1323')) * lambda_smeft_value**2,'.6e'), '# cud1Abs1323'],
	  [1048, format(abs(scaled_wc('ud1_1333')) * lambda_smeft_value**2,'.6e'), '# cud1Abs1333'],
	  [1049, format(scaled_wc('ud1_2211') * lambda_smeft_value**2,'.6e'),      '# cud1Abs2211'],
	  [1050, format(abs(scaled_wc('ud1_2212')) * lambda_smeft_value**2,'.6e'), '# cud1Abs2212'],
	  [1051, format(abs(scaled_wc('ud1_2213')) * lambda_smeft_value**2,'.6e'), '# cud1Abs2213'],
	  [1052, format(scaled_wc('ud1_2222') * lambda_smeft_value**2,'.6e'),      '# cud1Abs2222'],
	  [1053, format(abs(scaled_wc('ud1_2223')) * lambda_smeft_value**2,'.6e'), '# cud1Abs2223'],
	  [1054, format(scaled_wc('ud1_2233') * lambda_smeft_value**2,'.6e'),      '# cud1Abs2233'],
	  [1055, format(abs(scaled_wc('ud1_2311')) * lambda_smeft_value**2,'.6e'), '# cud1Abs2311'],
	  [1056, format(abs(scaled_wc('ud1_2312')) * lambda_smeft_value**2,'.6e'), '# cud1Abs2312'],
	  [1057, format(abs(scaled_wc('ud1_2313')) * lambda_smeft_value**2,'.6e'), '# cud1Abs2313'],
	  [1058, format(abs(scaled_wc('ud1_2321')) * lambda_smeft_value**2,'.6e'), '# cud1Abs2321'],
	  [1059, format(abs(scaled_wc('ud1_2322')) * lambda_smeft_value**2,'.6e'), '# cud1Abs2322'],
	  [1060, format(abs(scaled_wc('ud1_2323')) * lambda_smeft_value**2,'.6e'), '# cud1Abs2323'],
	  [1061, format(abs(scaled_wc('ud1_2331')) * lambda_smeft_value**2,'.6e'), '# cud1Abs2331'],
	  [1062, format(abs(scaled_wc('ud1_2332')) * lambda_smeft_value**2,'.6e'), '# cud1Abs2332'],
	  [1063, format(abs(scaled_wc('ud1_2333')) * lambda_smeft_value**2,'.6e'), '# cud1Abs2333'],
	  [1064, format(scaled_wc('ud1_3311') * lambda_smeft_value**2,'.6e'),      '# cud1Abs3311'],
	  [1065, format(abs(scaled_wc('ud1_3312')) * lambda_smeft_value**2,'.6e'), '# cud1Abs3312'],
	  [1066, format(abs(scaled_wc('ud1_3313')) * lambda_smeft_value**2,'.6e'), '# cud1Abs3313'],
	  [1067, format(scaled_wc('ud1_3322') * lambda_smeft_value**2,'.6e'),      '# cud1Abs3322'],
	  [1068, format(scaled_wc('ud1_3333') * lambda_smeft_value**2,'.6e'),      '# cud1Abs3333'],
	  [1069, format(abs(scaled_wc('ud1_3323')) * lambda_smeft_value**2,'.6e'), '# cud1Abs3323'],
	  [1070, format(scaled_wc('ud8_1111') * lambda_smeft_value**2,'.6e'),      '# cud8Abs1111'],
	  [1071, format(abs(scaled_wc('ud8_1112')) * lambda_smeft_value**2,'.6e'), '# cud8Abs1112'],
	  [1072, format(abs(scaled_wc('ud8_1113')) * lambda_smeft_value**2,'.6e'), '# cud8Abs1113'],
	  [1073, format(abs(scaled_wc('ud8_1123')) * lambda_smeft_value**2,'.6e'), '# cud8Abs1123'],
	  [1074, format(scaled_wc('ud8_1122') * lambda_smeft_value**2,'.6e'),      '# cud8Abs1122'],
	  [1075, format(scaled_wc('ud8_1133') * lambda_smeft_value**2,'.6e'),      '# cud8Abs1133'],
	  [1076, format(abs(scaled_wc('ud8_1211')) * lambda_smeft_value**2,'.6e'), '# cud8Abs1211'],
	  [1077, format(abs(scaled_wc('ud8_1212')) * lambda_smeft_value**2,'.6e'), '# cud8Abs1212'],
	  [1078, format(abs(scaled_wc('ud8_1221')) * lambda_smeft_value**2,'.6e'), '# cud8Abs1221'],
	  [1079, format(abs(scaled_wc('ud8_1213')) * lambda_smeft_value**2,'.6e'), '# cud8Abs1213'],
	  [1080, format(abs(scaled_wc('ud8_1231')) * lambda_smeft_value**2,'.6e'), '# cud8Abs1231'],
	  [1081, format(abs(scaled_wc('ud8_1222')) * lambda_smeft_value**2,'.6e'), '# cud8Abs1222'],
	  [1082, format(abs(scaled_wc('ud8_1223')) * lambda_smeft_value**2,'.6e'), '# cud8Abs1223'],
	  [1083, format(abs(scaled_wc('ud8_1232')) * lambda_smeft_value**2,'.6e'), '# cud8Abs1232'],
	  [1084, format(abs(scaled_wc('ud8_1233')) * lambda_smeft_value**2,'.6e'), '# cud8Abs1233'],
	  [1085, format(abs(scaled_wc('ud8_1311')) * lambda_smeft_value**2,'.6e'), '# cud8Abs1311'],
	  [1086, format(abs(scaled_wc('ud8_1312')) * lambda_smeft_value**2,'.6e'), '# cud8Abs1312'],
	  [1087, format(abs(scaled_wc('ud8_1313')) * lambda_smeft_value**2,'.6e'), '# cud8Abs1313'],
	  [1088, format(abs(scaled_wc('ud8_1331')) * lambda_smeft_value**2,'.6e'), '# cud8Abs1331'],
	  [1089, format(abs(scaled_wc('ud8_1321')) * lambda_smeft_value**2,'.6e'), '# cud8Abs1321'],
	  [1090, format(abs(scaled_wc('ud8_1322')) * lambda_smeft_value**2,'.6e'), '# cud8Abs1322'],
	  [1091, format(abs(scaled_wc('ud8_1332')) * lambda_smeft_value**2,'.6e'), '# cud8Abs1332'],
	  [1092, format(abs(scaled_wc('ud8_1323')) * lambda_smeft_value**2,'.6e'), '# cud8Abs1323'],
	  [1093, format(abs(scaled_wc('ud8_1333')) * lambda_smeft_value**2,'.6e'), '# cud8Abs1333'],
	  [1094, format(scaled_wc('ud8_2211') * lambda_smeft_value**2,'.6e'),      '# cud8Abs2211'],
	  [1095, format(abs(scaled_wc('ud8_2212')) * lambda_smeft_value**2,'.6e'), '# cud8Abs2212'],
	  [1096, format(abs(scaled_wc('ud8_2213')) * lambda_smeft_value**2,'.6e'), '# cud8Abs2213'],
	  [1097, format(scaled_wc('ud8_2222') * lambda_smeft_value**2,'.6e'),      '# cud8Abs2222'],
	  [1098, format(abs(scaled_wc('ud8_2223')) * lambda_smeft_value**2,'.6e'), '# cud8Abs2223'],
	  [1099, format(scaled_wc('ud8_2233') * lambda_smeft_value**2,'.6e'),      '# cud8Abs2233'],
	  [1100, format(abs(scaled_wc('ud8_2311')) * lambda_smeft_value**2,'.6e'), '# cud8Abs2311'],
	  [1101, format(abs(scaled_wc('ud8_2312')) * lambda_smeft_value**2,'.6e'), '# cud8Abs2312'],
	  [1102, format(abs(scaled_wc('ud8_2313')) * lambda_smeft_value**2,'.6e'), '# cud8Abs2313'],
	  [1103, format(abs(scaled_wc('ud8_2321')) * lambda_smeft_value**2,'.6e'), '# cud8Abs2321'],
	  [1104, format(abs(scaled_wc('ud8_2322')) * lambda_smeft_value**2,'.6e'), '# cud8Abs2322'],
	  [1105, format(abs(scaled_wc('ud8_2323')) * lambda_smeft_value**2,'.6e'), '# cud8Abs2323'],
	  [1106, format(abs(scaled_wc('ud8_2331')) * lambda_smeft_value**2,'.6e'), '# cud8Abs2331'],
	  [1107, format(abs(scaled_wc('ud8_2332')) * lambda_smeft_value**2,'.6e'), '# cud8Abs2332'],
	  [1108, format(abs(scaled_wc('ud8_2333')) * lambda_smeft_value**2,'.6e'), '# cud8Abs2333'],
	  [1109, format(scaled_wc('ud8_3311') * lambda_smeft_value**2,'.6e'),      '# cud8Abs3311'],
	  [1110, format(abs(scaled_wc('ud8_3312')) * lambda_smeft_value**2,'.6e'), '# cud8Abs3312'],
	  [1111, format(abs(scaled_wc('ud8_3313')) * lambda_smeft_value**2,'.6e'), '# cud8Abs3313'],
	  [1112, format(scaled_wc('ud8_3322') * lambda_smeft_value**2,'.6e'),      '# cud8Abs3322'],
	  [1113, format(scaled_wc('ud8_3333') * lambda_smeft_value**2,'.6e'),      '# cud8Abs3333'],
	  [1114, format(abs(scaled_wc('ud8_3323')) * lambda_smeft_value**2,'.6e'), '# cud8Abs3323'],
	  [1115, format(scaled_wc('le_1111') * lambda_smeft_value**2,'.6e'),      '# cleAbs1111'],
	  [1116, format(abs(scaled_wc('le_1112')) * lambda_smeft_value**2,'.6e'), '# cleAbs1112'],
	  [1117, format(abs(scaled_wc('le_1113')) * lambda_smeft_value**2,'.6e'), '# cleAbs1113'],
	  [1118, format(abs(scaled_wc('le_1123')) * lambda_smeft_value**2,'.6e'), '# cleAbs1123'],
	  [1119, format(scaled_wc('le_1122') * lambda_smeft_value**2,'.6e'),      '# cleAbs1122'],
	  [1120, format(scaled_wc('le_1133') * lambda_smeft_value**2,'.6e'),      '# cleAbs1133'],
	  [1121, format(abs(scaled_wc('le_1211')) * lambda_smeft_value**2,'.6e'), '# cleAbs1211'],
	  [1122, format(abs(scaled_wc('le_1212')) * lambda_smeft_value**2,'.6e'), '# cleAbs1212'],
	  [1123, format(abs(scaled_wc('le_1221')) * lambda_smeft_value**2,'.6e'), '# cleAbs1221'],
	  [1124, format(abs(scaled_wc('le_1213')) * lambda_smeft_value**2,'.6e'), '# cleAbs1213'],
	  [1125, format(abs(scaled_wc('le_1231')) * lambda_smeft_value**2,'.6e'), '# cleAbs1231'],
	  [1126, format(abs(scaled_wc('le_1222')) * lambda_smeft_value**2,'.6e'), '# cleAbs1222'],
	  [1127, format(abs(scaled_wc('le_1223')) * lambda_smeft_value**2,'.6e'), '# cleAbs1223'],
	  [1128, format(abs(scaled_wc('le_1232')) * lambda_smeft_value**2,'.6e'), '# cleAbs1232'],
	  [1129, format(abs(scaled_wc('le_1233')) * lambda_smeft_value**2,'.6e'), '# cleAbs1233'],
	  [1130, format(abs(scaled_wc('le_1311')) * lambda_smeft_value**2,'.6e'), '# cleAbs1311'],
	  [1131, format(abs(scaled_wc('le_1312')) * lambda_smeft_value**2,'.6e'), '# cleAbs1312'],
	  [1132, format(abs(scaled_wc('le_1313')) * lambda_smeft_value**2,'.6e'), '# cleAbs1313'],
	  [1133, format(abs(scaled_wc('le_1331')) * lambda_smeft_value**2,'.6e'), '# cleAbs1331'],
	  [1134, format(abs(scaled_wc('le_1321')) * lambda_smeft_value**2,'.6e'), '# cleAbs1321'],
	  [1135, format(abs(scaled_wc('le_1322')) * lambda_smeft_value**2,'.6e'), '# cleAbs1322'],
	  [1136, format(abs(scaled_wc('le_1332')) * lambda_smeft_value**2,'.6e'), '# cleAbs1332'],
	  [1137, format(abs(scaled_wc('le_1323')) * lambda_smeft_value**2,'.6e'), '# cleAbs1323'],
	  [1138, format(abs(scaled_wc('le_1333')) * lambda_smeft_value**2,'.6e'), '# cleAbs1333'],
	  [1139, format(scaled_wc('le_2211') * lambda_smeft_value**2,'.6e'),      '# cleAbs2211'],
	  [1140, format(abs(scaled_wc('le_2212')) * lambda_smeft_value**2,'.6e'), '# cleAbs2212'],
	  [1141, format(abs(scaled_wc('le_2213')) * lambda_smeft_value**2,'.6e'), '# cleAbs2213'],
	  [1142, format(scaled_wc('le_2222') * lambda_smeft_value**2,'.6e'),      '# cleAbs2222'],
	  [1143, format(abs(scaled_wc('le_2223')) * lambda_smeft_value**2,'.6e'), '# cleAbs2223'],
	  [1144, format(scaled_wc('le_2233') * lambda_smeft_value**2,'.6e'),      '# cleAbs2233'],
	  [1145, format(abs(scaled_wc('le_2311')) * lambda_smeft_value**2,'.6e'), '# cleAbs2311'],
	  [1146, format(abs(scaled_wc('le_2312')) * lambda_smeft_value**2,'.6e'), '# cleAbs2312'],
	  [1147, format(abs(scaled_wc('le_2313')) * lambda_smeft_value**2,'.6e'), '# cleAbs2313'],
	  [1148, format(abs(scaled_wc('le_2321')) * lambda_smeft_value**2,'.6e'), '# cleAbs2321'],
	  [1149, format(abs(scaled_wc('le_2322')) * lambda_smeft_value**2,'.6e'), '# cleAbs2322'],
	  [1150, format(abs(scaled_wc('le_2323')) * lambda_smeft_value**2,'.6e'), '# cleAbs2323'],
	  [1151, format(abs(scaled_wc('le_2331')) * lambda_smeft_value**2,'.6e'), '# cleAbs2331'],
	  [1152, format(abs(scaled_wc('le_2332')) * lambda_smeft_value**2,'.6e'), '# cleAbs2332'],
	  [1153, format(abs(scaled_wc('le_2333')) * lambda_smeft_value**2,'.6e'), '# cleAbs2333'],
	  [1154, format(scaled_wc('le_3311') * lambda_smeft_value**2,'.6e'),      '# cleAbs3311'],
	  [1155, format(abs(scaled_wc('le_3312')) * lambda_smeft_value**2,'.6e'), '# cleAbs3312'],
	  [1156, format(abs(scaled_wc('le_3313')) * lambda_smeft_value**2,'.6e'), '# cleAbs3313'],
	  [1157, format(scaled_wc('le_3322') * lambda_smeft_value**2,'.6e'),      '# cleAbs3322'],
	  [1158, format(scaled_wc('le_3333') * lambda_smeft_value**2,'.6e'),      '# cleAbs3333'],
	  [1159, format(abs(scaled_wc('le_3323')) * lambda_smeft_value**2,'.6e'), '# cleAbs3323'],
	  [1160, format(scaled_wc('lu_1111') * lambda_smeft_value**2,'.6e'),      '# cluAbs1111'],
	  [1161, format(abs(scaled_wc('lu_1112')) * lambda_smeft_value**2,'.6e'), '# cluAbs1112'],
	  [1162, format(abs(scaled_wc('lu_1113')) * lambda_smeft_value**2,'.6e'), '# cluAbs1113'],
	  [1163, format(abs(scaled_wc('lu_1123')) * lambda_smeft_value**2,'.6e'), '# cluAbs1123'],
	  [1164, format(scaled_wc('lu_1122') * lambda_smeft_value**2,'.6e'),      '# cluAbs1122'],
	  [1165, format(scaled_wc('lu_1133') * lambda_smeft_value**2,'.6e'),      '# cluAbs1133'],
	  [1166, format(abs(scaled_wc('lu_1211')) * lambda_smeft_value**2,'.6e'), '# cluAbs1211'],
	  [1167, format(abs(scaled_wc('lu_1212')) * lambda_smeft_value**2,'.6e'), '# cluAbs1212'],
	  [1168, format(abs(scaled_wc('lu_1221')) * lambda_smeft_value**2,'.6e'), '# cluAbs1221'],
	  [1169, format(abs(scaled_wc('lu_1213')) * lambda_smeft_value**2,'.6e'), '# cluAbs1213'],
	  [1170, format(abs(scaled_wc('lu_1231')) * lambda_smeft_value**2,'.6e'), '# cluAbs1231'],
	  [1171, format(abs(scaled_wc('lu_1222')) * lambda_smeft_value**2,'.6e'), '# cluAbs1222'],
	  [1172, format(abs(scaled_wc('lu_1223')) * lambda_smeft_value**2,'.6e'), '# cluAbs1223'],
	  [1173, format(abs(scaled_wc('lu_1232')) * lambda_smeft_value**2,'.6e'), '# cluAbs1232'],
	  [1174, format(abs(scaled_wc('lu_1233')) * lambda_smeft_value**2,'.6e'), '# cluAbs1233'],
	  [1175, format(abs(scaled_wc('lu_1311')) * lambda_smeft_value**2,'.6e'), '# cluAbs1311'],
	  [1176, format(abs(scaled_wc('lu_1312')) * lambda_smeft_value**2,'.6e'), '# cluAbs1312'],
	  [1177, format(abs(scaled_wc('lu_1313')) * lambda_smeft_value**2,'.6e'), '# cluAbs1313'],
	  [1178, format(abs(scaled_wc('lu_1331')) * lambda_smeft_value**2,'.6e'), '# cluAbs1331'],
	  [1179, format(abs(scaled_wc('lu_1321')) * lambda_smeft_value**2,'.6e'), '# cluAbs1321'],
	  [1180, format(abs(scaled_wc('lu_1322')) * lambda_smeft_value**2,'.6e'), '# cluAbs1322'],
	  [1181, format(abs(scaled_wc('lu_1332')) * lambda_smeft_value**2,'.6e'), '# cluAbs1332'],
	  [1182, format(abs(scaled_wc('lu_1323')) * lambda_smeft_value**2,'.6e'), '# cluAbs1323'],
	  [1183, format(abs(scaled_wc('lu_1333')) * lambda_smeft_value**2,'.6e'), '# cluAbs1333'],
	  [1184, format(scaled_wc('lu_2211') * lambda_smeft_value**2,'.6e'),      '# cluAbs2211'],
	  [1185, format(abs(scaled_wc('lu_2212')) * lambda_smeft_value**2,'.6e'), '# cluAbs2212'],
	  [1186, format(abs(scaled_wc('lu_2213')) * lambda_smeft_value**2,'.6e'), '# cluAbs2213'],
	  [1187, format(scaled_wc('lu_2222') * lambda_smeft_value**2,'.6e'),      '# cluAbs2222'],
	  [1188, format(abs(scaled_wc('lu_2223')) * lambda_smeft_value**2,'.6e'), '# cluAbs2223'],
	  [1189, format(scaled_wc('lu_2233') * lambda_smeft_value**2,'.6e'),      '# cluAbs2233'],
	  [1190, format(abs(scaled_wc('lu_2311')) * lambda_smeft_value**2,'.6e'), '# cluAbs2311'],
	  [1191, format(abs(scaled_wc('lu_2312')) * lambda_smeft_value**2,'.6e'), '# cluAbs2312'],
	  [1192, format(abs(scaled_wc('lu_2313')) * lambda_smeft_value**2,'.6e'), '# cluAbs2313'],
	  [1193, format(abs(scaled_wc('lu_2321')) * lambda_smeft_value**2,'.6e'), '# cluAbs2321'],
	  [1194, format(abs(scaled_wc('lu_2322')) * lambda_smeft_value**2,'.6e'), '# cluAbs2322'],
	  [1195, format(abs(scaled_wc('lu_2323')) * lambda_smeft_value**2,'.6e'), '# cluAbs2323'],
	  [1196, format(abs(scaled_wc('lu_2331')) * lambda_smeft_value**2,'.6e'), '# cluAbs2331'],
	  [1197, format(abs(scaled_wc('lu_2332')) * lambda_smeft_value**2,'.6e'), '# cluAbs2332'],
	  [1198, format(abs(scaled_wc('lu_2333')) * lambda_smeft_value**2,'.6e'), '# cluAbs2333'],
	  [1199, format(scaled_wc('lu_3311') * lambda_smeft_value**2,'.6e'),      '# cluAbs3311'],
	  [1200, format(abs(scaled_wc('lu_3312')) * lambda_smeft_value**2,'.6e'), '# cluAbs3312'],
	  [1201, format(abs(scaled_wc('lu_3313')) * lambda_smeft_value**2,'.6e'), '# cluAbs3313'],
	  [1202, format(scaled_wc('lu_3322') * lambda_smeft_value**2,'.6e'),      '# cluAbs3322'],
	  [1203, format(scaled_wc('lu_3333') * lambda_smeft_value**2,'.6e'),      '# cluAbs3333'],
	  [1204, format(abs(scaled_wc('lu_3323')) * lambda_smeft_value**2,'.6e'), '# cluAbs3323'],
	  [1205, format(scaled_wc('ld_1111') * lambda_smeft_value**2,'.6e'),      '# cldAbs1111'],
	  [1206, format(abs(scaled_wc('ld_1112')) * lambda_smeft_value**2,'.6e'), '# cldAbs1112'],
	  [1207, format(abs(scaled_wc('ld_1113')) * lambda_smeft_value**2,'.6e'), '# cldAbs1113'],
	  [1208, format(abs(scaled_wc('ld_1123')) * lambda_smeft_value**2,'.6e'), '# cldAbs1123'],
	  [1209, format(scaled_wc('ld_1122') * lambda_smeft_value**2,'.6e'),      '# cldAbs1122'],
	  [1210, format(scaled_wc('ld_1133') * lambda_smeft_value**2,'.6e'),      '# cldAbs1133'],
	  [1211, format(abs(scaled_wc('ld_1211')) * lambda_smeft_value**2,'.6e'), '# cldAbs1211'],
	  [1212, format(abs(scaled_wc('ld_1212')) * lambda_smeft_value**2,'.6e'), '# cldAbs1212'],
	  [1213, format(abs(scaled_wc('ld_1221')) * lambda_smeft_value**2,'.6e'), '# cldAbs1221'],
	  [1214, format(abs(scaled_wc('ld_1213')) * lambda_smeft_value**2,'.6e'), '# cldAbs1213'],
	  [1215, format(abs(scaled_wc('ld_1231')) * lambda_smeft_value**2,'.6e'), '# cldAbs1231'],
	  [1216, format(abs(scaled_wc('ld_1222')) * lambda_smeft_value**2,'.6e'), '# cldAbs1222'],
	  [1217, format(abs(scaled_wc('ld_1223')) * lambda_smeft_value**2,'.6e'), '# cldAbs1223'],
	  [1218, format(abs(scaled_wc('ld_1232')) * lambda_smeft_value**2,'.6e'), '# cldAbs1232'],
	  [1219, format(abs(scaled_wc('ld_1233')) * lambda_smeft_value**2,'.6e'), '# cldAbs1233'],
	  [1220, format(abs(scaled_wc('ld_1311')) * lambda_smeft_value**2,'.6e'), '# cldAbs1311'],
	  [1221, format(abs(scaled_wc('ld_1312')) * lambda_smeft_value**2,'.6e'), '# cldAbs1312'],
	  [1222, format(abs(scaled_wc('ld_1313')) * lambda_smeft_value**2,'.6e'), '# cldAbs1313'],
	  [1223, format(abs(scaled_wc('ld_1331')) * lambda_smeft_value**2,'.6e'), '# cldAbs1331'],
	  [1224, format(abs(scaled_wc('ld_1321')) * lambda_smeft_value**2,'.6e'), '# cldAbs1321'],
	  [1225, format(abs(scaled_wc('ld_1322')) * lambda_smeft_value**2,'.6e'), '# cldAbs1322'],
	  [1226, format(abs(scaled_wc('ld_1332')) * lambda_smeft_value**2,'.6e'), '# cldAbs1332'],
	  [1227, format(abs(scaled_wc('ld_1323')) * lambda_smeft_value**2,'.6e'), '# cldAbs1323'],
	  [1228, format(abs(scaled_wc('ld_1333')) * lambda_smeft_value**2,'.6e'), '# cldAbs1333'],
	  [1229, format(scaled_wc('ld_2211') * lambda_smeft_value**2,'.6e'),      '# cldAbs2211'],
	  [1230, format(abs(scaled_wc('ld_2212')) * lambda_smeft_value**2,'.6e'), '# cldAbs2212'],
	  [1231, format(abs(scaled_wc('ld_2213')) * lambda_smeft_value**2,'.6e'), '# cldAbs2213'],
	  [1232, format(scaled_wc('ld_2222') * lambda_smeft_value**2,'.6e'),      '# cldAbs2222'],
	  [1233, format(abs(scaled_wc('ld_2223')) * lambda_smeft_value**2,'.6e'), '# cldAbs2223'],
	  [1234, format(scaled_wc('ld_2233') * lambda_smeft_value**2,'.6e'),      '# cldAbs2233'],
	  [1235, format(abs(scaled_wc('ld_2311')) * lambda_smeft_value**2,'.6e'), '# cldAbs2311'],
	  [1236, format(abs(scaled_wc('ld_2312')) * lambda_smeft_value**2,'.6e'), '# cldAbs2312'],
	  [1237, format(abs(scaled_wc('ld_2313')) * lambda_smeft_value**2,'.6e'), '# cldAbs2313'],
	  [1238, format(abs(scaled_wc('ld_2321')) * lambda_smeft_value**2,'.6e'), '# cldAbs2321'],
	  [1239, format(abs(scaled_wc('ld_2322')) * lambda_smeft_value**2,'.6e'), '# cldAbs2322'],
	  [1240, format(abs(scaled_wc('ld_2323')) * lambda_smeft_value**2,'.6e'), '# cldAbs2323'],
	  [1241, format(abs(scaled_wc('ld_2331')) * lambda_smeft_value**2,'.6e'), '# cldAbs2331'],
	  [1242, format(abs(scaled_wc('ld_2332')) * lambda_smeft_value**2,'.6e'), '# cldAbs2332'],
	  [1243, format(abs(scaled_wc('ld_2333')) * lambda_smeft_value**2,'.6e'), '# cldAbs2333'],
	  [1244, format(scaled_wc('ld_3311') * lambda_smeft_value**2,'.6e'),      '# cldAbs3311'],
	  [1245, format(abs(scaled_wc('ld_3312')) * lambda_smeft_value**2,'.6e'), '# cldAbs3312'],
	  [1246, format(abs(scaled_wc('ld_3313')) * lambda_smeft_value**2,'.6e'), '# cldAbs3313'],
	  [1247, format(scaled_wc('ld_3322') * lambda_smeft_value**2,'.6e'),      '# cldAbs3322'],
	  [1248, format(scaled_wc('ld_3333') * lambda_smeft_value**2,'.6e'),      '# cldAbs3333'],
	  [1249, format(abs(scaled_wc('ld_3323')) * lambda_smeft_value**2,'.6e'), '# cldAbs3323'],
	  [1250, format(scaled_wc('qe_1111') * lambda_smeft_value**2,'.6e'),      '# cqeAbs1111'],
	  [1251, format(abs(scaled_wc('qe_1112')) * lambda_smeft_value**2,'.6e'), '# cqeAbs1112'],
	  [1252, format(abs(scaled_wc('qe_1113')) * lambda_smeft_value**2,'.6e'), '# cqeAbs1113'],
	  [1253, format(abs(scaled_wc('qe_1123')) * lambda_smeft_value**2,'.6e'), '# cqeAbs1123'],
	  [1254, format(scaled_wc('qe_1122') * lambda_smeft_value**2,'.6e'),      '# cqeAbs1122'],
	  [1255, format(scaled_wc('qe_1133') * lambda_smeft_value**2,'.6e'),      '# cqeAbs1133'],
	  [1256, format(abs(scaled_wc('qe_1211')) * lambda_smeft_value**2,'.6e'), '# cqeAbs1211'],
	  [1257, format(abs(scaled_wc('qe_1212')) * lambda_smeft_value**2,'.6e'), '# cqeAbs1212'],
	  [1258, format(abs(scaled_wc('qe_1221')) * lambda_smeft_value**2,'.6e'), '# cqeAbs1221'],
	  [1259, format(abs(scaled_wc('qe_1213')) * lambda_smeft_value**2,'.6e'), '# cqeAbs1213'],
	  [1260, format(abs(scaled_wc('qe_1231')) * lambda_smeft_value**2,'.6e'), '# cqeAbs1231'],
	  [1261, format(abs(scaled_wc('qe_1222')) * lambda_smeft_value**2,'.6e'), '# cqeAbs1222'],
	  [1262, format(abs(scaled_wc('qe_1223')) * lambda_smeft_value**2,'.6e'), '# cqeAbs1223'],
	  [1263, format(abs(scaled_wc('qe_1232')) * lambda_smeft_value**2,'.6e'), '# cqeAbs1232'],
	  [1264, format(abs(scaled_wc('qe_1233')) * lambda_smeft_value**2,'.6e'), '# cqeAbs1233'],
	  [1265, format(abs(scaled_wc('qe_1311')) * lambda_smeft_value**2,'.6e'), '# cqeAbs1311'],
	  [1266, format(abs(scaled_wc('qe_1312')) * lambda_smeft_value**2,'.6e'), '# cqeAbs1312'],
	  [1267, format(abs(scaled_wc('qe_1313')) * lambda_smeft_value**2,'.6e'), '# cqeAbs1313'],
	  [1268, format(abs(scaled_wc('qe_1331')) * lambda_smeft_value**2,'.6e'), '# cqeAbs1331'],
	  [1269, format(abs(scaled_wc('qe_1321')) * lambda_smeft_value**2,'.6e'), '# cqeAbs1321'],
	  [1270, format(abs(scaled_wc('qe_1322')) * lambda_smeft_value**2,'.6e'), '# cqeAbs1322'],
	  [1271, format(abs(scaled_wc('qe_1332')) * lambda_smeft_value**2,'.6e'), '# cqeAbs1332'],
	  [1272, format(abs(scaled_wc('qe_1323')) * lambda_smeft_value**2,'.6e'), '# cqeAbs1323'],
	  [1273, format(abs(scaled_wc('qe_1333')) * lambda_smeft_value**2,'.6e'), '# cqeAbs1333'],
	  [1274, format(scaled_wc('qe_2211') * lambda_smeft_value**2,'.6e'),      '# cqeAbs2211'],
	  [1275, format(abs(scaled_wc('qe_2212')) * lambda_smeft_value**2,'.6e'), '# cqeAbs2212'],
	  [1276, format(abs(scaled_wc('qe_2213')) * lambda_smeft_value**2,'.6e'), '# cqeAbs2213'],
	  [1277, format(scaled_wc('qe_2222') * lambda_smeft_value**2,'.6e'),      '# cqeAbs2222'],
	  [1278, format(abs(scaled_wc('qe_2223')) * lambda_smeft_value**2,'.6e'), '# cqeAbs2223'],
	  [1279, format(scaled_wc('qe_2233') * lambda_smeft_value**2,'.6e'),      '# cqeAbs2233'],
	  [1280, format(abs(scaled_wc('qe_2311')) * lambda_smeft_value**2,'.6e'), '# cqeAbs2311'],
	  [1281, format(abs(scaled_wc('qe_2312')) * lambda_smeft_value**2,'.6e'), '# cqeAbs2312'],
	  [1282, format(abs(scaled_wc('qe_2313')) * lambda_smeft_value**2,'.6e'), '# cqeAbs2313'],
	  [1283, format(abs(scaled_wc('qe_2321')) * lambda_smeft_value**2,'.6e'), '# cqeAbs2321'],
	  [1284, format(abs(scaled_wc('qe_2322')) * lambda_smeft_value**2,'.6e'), '# cqeAbs2322'],
	  [1285, format(abs(scaled_wc('qe_2323')) * lambda_smeft_value**2,'.6e'), '# cqeAbs2323'],
	  [1286, format(abs(scaled_wc('qe_2331')) * lambda_smeft_value**2,'.6e'), '# cqeAbs2331'],
	  [1287, format(abs(scaled_wc('qe_2332')) * lambda_smeft_value**2,'.6e'), '# cqeAbs2332'],
	  [1288, format(abs(scaled_wc('qe_2333')) * lambda_smeft_value**2,'.6e'), '# cqeAbs2333'],
	  [1289, format(scaled_wc('qe_3311') * lambda_smeft_value**2,'.6e'),      '# cqeAbs3311'],
	  [1290, format(abs(scaled_wc('qe_3312')) * lambda_smeft_value**2,'.6e'), '# cqeAbs3312'],
	  [1291, format(abs(scaled_wc('qe_3313')) * lambda_smeft_value**2,'.6e'), '# cqeAbs3313'],
	  [1292, format(scaled_wc('qe_3322') * lambda_smeft_value**2,'.6e'),      '# cqeAbs3322'],
	  [1293, format(scaled_wc('qe_3333') * lambda_smeft_value**2,'.6e'),      '# cqeAbs3333'],
	  [1294, format(abs(scaled_wc('qe_3323')) * lambda_smeft_value**2,'.6e'), '# cqeAbs3323'],
	  [1295, format(scaled_wc('qu1_1111') * lambda_smeft_value**2,'.6e'),      '# cqu1Abs1111'],
	  [1296, format(abs(scaled_wc('qu1_1112')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs1112'],
	  [1297, format(abs(scaled_wc('qu1_1113')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs1113'],
	  [1298, format(abs(scaled_wc('qu1_1123')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs1123'],
	  [1299, format(scaled_wc('qu1_1122') * lambda_smeft_value**2,'.6e'),      '# cqu1Abs1122'],
	  [1300, format(scaled_wc('qu1_1133') * lambda_smeft_value**2,'.6e'),      '# cqu1Abs1133'],
	  [1301, format(abs(scaled_wc('qu1_1211')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs1211'],
	  [1302, format(abs(scaled_wc('qu1_1212')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs1212'],
	  [1303, format(abs(scaled_wc('qu1_1221')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs1221'],
	  [1304, format(abs(scaled_wc('qu1_1213')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs1213'],
	  [1305, format(abs(scaled_wc('qu1_1231')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs1231'],
	  [1306, format(abs(scaled_wc('qu1_1222')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs1222'],
	  [1307, format(abs(scaled_wc('qu1_1223')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs1223'],
	  [1308, format(abs(scaled_wc('qu1_1232')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs1232'],
	  [1309, format(abs(scaled_wc('qu1_1233')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs1233'],
	  [1310, format(abs(scaled_wc('qu1_1311')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs1311'],
	  [1311, format(abs(scaled_wc('qu1_1312')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs1312'],
	  [1312, format(abs(scaled_wc('qu1_1313')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs1313'],
	  [1313, format(abs(scaled_wc('qu1_1331')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs1331'],
	  [1314, format(abs(scaled_wc('qu1_1321')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs1321'],
	  [1315, format(abs(scaled_wc('qu1_1322')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs1322'],
	  [1316, format(abs(scaled_wc('qu1_1332')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs1332'],
	  [1317, format(abs(scaled_wc('qu1_1323')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs1323'],
	  [1318, format(abs(scaled_wc('qu1_1333')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs1333'],
	  [1319, format(scaled_wc('qu1_2211') * lambda_smeft_value**2,'.6e'),      '# cqu1Abs2211'],
	  [1320, format(abs(scaled_wc('qu1_2212')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs2212'],
	  [1321, format(abs(scaled_wc('qu1_2213')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs2213'],
	  [1322, format(scaled_wc('qu1_2222') * lambda_smeft_value**2,'.6e'),      '# cqu1Abs2222'],
	  [1323, format(abs(scaled_wc('qu1_2223')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs2223'],
	  [1324, format(scaled_wc('qu1_2233') * lambda_smeft_value**2,'.6e'),      '# cqu1Abs2233'],
	  [1325, format(abs(scaled_wc('qu1_2311')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs2311'],
	  [1326, format(abs(scaled_wc('qu1_2312')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs2312'],
	  [1327, format(abs(scaled_wc('qu1_2313')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs2313'],
	  [1328, format(abs(scaled_wc('qu1_2321')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs2321'],
	  [1329, format(abs(scaled_wc('qu1_2322')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs2322'],
	  [1330, format(abs(scaled_wc('qu1_2323')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs2323'],
	  [1331, format(abs(scaled_wc('qu1_2331')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs2331'],
	  [1332, format(abs(scaled_wc('qu1_2332')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs2332'],
	  [1333, format(abs(scaled_wc('qu1_2333')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs2333'],
	  [1334, format(scaled_wc('qu1_3311') * lambda_smeft_value**2,'.6e'),      '# cqu1Abs3311'],
	  [1335, format(abs(scaled_wc('qu1_3312')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs3312'],
	  [1336, format(abs(scaled_wc('qu1_3313')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs3313'],
	  [1337, format(scaled_wc('qu1_3322') * lambda_smeft_value**2,'.6e'),      '# cqu1Abs3322'],
	  [1338, format(scaled_wc('qu1_3333') * lambda_smeft_value**2,'.6e'),      '# cqu1Abs3333'],
	  [1339, format(abs(scaled_wc('qu1_3323')) * lambda_smeft_value**2,'.6e'), '# cqu1Abs3323'],
	  [1340, format(scaled_wc('qu8_1111') * lambda_smeft_value**2,'.6e'),      '# cqu8Abs1111'],
	  [1341, format(abs(scaled_wc('qu8_1112')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs1112'],
	  [1342, format(abs(scaled_wc('qu8_1113')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs1113'],
	  [1343, format(abs(scaled_wc('qu8_1123')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs1123'],
	  [1344, format(scaled_wc('qu8_1122') * lambda_smeft_value**2,'.6e'),      '# cqu8Abs1122'],
	  [1345, format(scaled_wc('qu8_1133') * lambda_smeft_value**2,'.6e'),      '# cqu8Abs1133'],
	  [1346, format(abs(scaled_wc('qu8_1211')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs1211'],
	  [1347, format(abs(scaled_wc('qu8_1212')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs1212'],
	  [1348, format(abs(scaled_wc('qu8_1221')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs1221'],
	  [1349, format(abs(scaled_wc('qu8_1213')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs1213'],
	  [1350, format(abs(scaled_wc('qu8_1231')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs1231'],
	  [1351, format(abs(scaled_wc('qu8_1222')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs1222'],
	  [1352, format(abs(scaled_wc('qu8_1223')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs1223'],
	  [1353, format(abs(scaled_wc('qu8_1232')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs1232'],
	  [1354, format(abs(scaled_wc('qu8_1233')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs1233'],
	  [1355, format(abs(scaled_wc('qu8_1311')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs1311'],
	  [1356, format(abs(scaled_wc('qu8_1312')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs1312'],
	  [1357, format(abs(scaled_wc('qu8_1313')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs1313'],
	  [1358, format(abs(scaled_wc('qu8_1331')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs1331'],
	  [1359, format(abs(scaled_wc('qu8_1321')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs1321'],
	  [1360, format(abs(scaled_wc('qu8_1322')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs1322'],
	  [1361, format(abs(scaled_wc('qu8_1332')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs1332'],
	  [1362, format(abs(scaled_wc('qu8_1323')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs1323'],
	  [1363, format(abs(scaled_wc('qu8_1333')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs1333'],
	  [1364, format(scaled_wc('qu8_2211') * lambda_smeft_value**2,'.6e'),      '# cqu8Abs2211'],
	  [1365, format(abs(scaled_wc('qu8_2212')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs2212'],
	  [1366, format(abs(scaled_wc('qu8_2213')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs2213'],
	  [1367, format(scaled_wc('qu8_2222') * lambda_smeft_value**2,'.6e'),      '# cqu8Abs2222'],
	  [1368, format(abs(scaled_wc('qu8_2223')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs2223'],
	  [1369, format(scaled_wc('qu8_2233') * lambda_smeft_value**2,'.6e'),      '# cqu8Abs2233'],
	  [1370, format(abs(scaled_wc('qu8_2311')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs2311'],
	  [1371, format(abs(scaled_wc('qu8_2312')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs2312'],
	  [1372, format(abs(scaled_wc('qu8_2313')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs2313'],
	  [1373, format(abs(scaled_wc('qu8_2321')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs2321'],
	  [1374, format(abs(scaled_wc('qu8_2322')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs2322'],
	  [1375, format(abs(scaled_wc('qu8_2323')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs2323'],
	  [1376, format(abs(scaled_wc('qu8_2331')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs2331'],
	  [1377, format(abs(scaled_wc('qu8_2332')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs2332'],
	  [1378, format(abs(scaled_wc('qu8_2333')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs2333'],
	  [1379, format(scaled_wc('qu8_3311') * lambda_smeft_value**2,'.6e'),      '# cqu8Abs3311'],
	  [1380, format(abs(scaled_wc('qu8_3312')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs3312'],
	  [1381, format(abs(scaled_wc('qu8_3313')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs3313'],
	  [1382, format(scaled_wc('qu8_3322') * lambda_smeft_value**2,'.6e'),      '# cqu8Abs3322'],
	  [1383, format(scaled_wc('qu8_3333') * lambda_smeft_value**2,'.6e'),      '# cqu8Abs3333'],
	  [1384, format(abs(scaled_wc('qu8_3323')) * lambda_smeft_value**2,'.6e'), '# cqu8Abs3323'],
	  [1385, format(scaled_wc('qd1_1111') * lambda_smeft_value**2,'.6e'),      '# cqd1Abs1111'],
	  [1386, format(abs(scaled_wc('qd1_1112')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs1112'],
	  [1387, format(abs(scaled_wc('qd1_1113')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs1113'],
	  [1388, format(abs(scaled_wc('qd1_1123')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs1123'],
	  [1389, format(scaled_wc('qd1_1122') * lambda_smeft_value**2,'.6e'),      '# cqd1Abs1122'],
	  [1390, format(scaled_wc('qd1_1133') * lambda_smeft_value**2,'.6e'),      '# cqd1Abs1133'],
	  [1391, format(abs(scaled_wc('qd1_1211')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs1211'],
	  [1392, format(abs(scaled_wc('qd1_1212')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs1212'],
	  [1393, format(abs(scaled_wc('qd1_1221')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs1221'],
	  [1394, format(abs(scaled_wc('qd1_1213')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs1213'],
	  [1395, format(abs(scaled_wc('qd1_1231')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs1231'],
	  [1396, format(abs(scaled_wc('qd1_1222')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs1222'],
	  [1397, format(abs(scaled_wc('qd1_1223')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs1223'],
	  [1398, format(abs(scaled_wc('qd1_1232')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs1232'],
	  [1399, format(abs(scaled_wc('qd1_1233')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs1233'],
	  [1400, format(abs(scaled_wc('qd1_1311')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs1311'],
	  [1401, format(abs(scaled_wc('qd1_1312')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs1312'],
	  [1402, format(abs(scaled_wc('qd1_1313')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs1313'],
	  [1403, format(abs(scaled_wc('qd1_1331')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs1331'],
	  [1404, format(abs(scaled_wc('qd1_1321')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs1321'],
	  [1405, format(abs(scaled_wc('qd1_1322')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs1322'],
	  [1406, format(abs(scaled_wc('qd1_1332')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs1332'],
	  [1407, format(abs(scaled_wc('qd1_1323')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs1323'],
	  [1408, format(abs(scaled_wc('qd1_1333')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs1333'],
	  [1409, format(scaled_wc('qd1_2211') * lambda_smeft_value**2,'.6e'),      '# cqd1Abs2211'],
	  [1410, format(abs(scaled_wc('qd1_2212')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs2212'],
	  [1411, format(abs(scaled_wc('qd1_2213')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs2213'],
	  [1412, format(scaled_wc('qd1_2222') * lambda_smeft_value**2,'.6e'),      '# cqd1Abs2222'],
	  [1413, format(abs(scaled_wc('qd1_2223')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs2223'],
	  [1414, format(scaled_wc('qd1_2233') * lambda_smeft_value**2,'.6e'),      '# cqd1Abs2233'],
	  [1415, format(abs(scaled_wc('qd1_2311')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs2311'],
	  [1416, format(abs(scaled_wc('qd1_2312')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs2312'],
	  [1417, format(abs(scaled_wc('qd1_2313')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs2313'],
	  [1418, format(abs(scaled_wc('qd1_2321')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs2321'],
	  [1419, format(abs(scaled_wc('qd1_2322')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs2322'],
	  [1420, format(abs(scaled_wc('qd1_2323')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs2323'],
	  [1421, format(abs(scaled_wc('qd1_2331')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs2331'],
	  [1422, format(abs(scaled_wc('qd1_2332')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs2332'],
	  [1423, format(abs(scaled_wc('qd1_2333')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs2333'],
	  [1424, format(scaled_wc('qd1_3311') * lambda_smeft_value**2,'.6e'),      '# cqd1Abs3311'],
	  [1425, format(abs(scaled_wc('qd1_3312')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs3312'],
	  [1426, format(abs(scaled_wc('qd1_3313')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs3313'],
	  [1427, format(scaled_wc('qd1_3322') * lambda_smeft_value**2,'.6e'),      '# cqd1Abs3322'],
	  [1428, format(scaled_wc('qd1_3333') * lambda_smeft_value**2,'.6e'),      '# cqd1Abs3333'],
	  [1429, format(abs(scaled_wc('qd1_3323')) * lambda_smeft_value**2,'.6e'), '# cqd1Abs3323'],
	  [1430, format(scaled_wc('qd8_1111') * lambda_smeft_value**2,'.6e'),      '# cqd8Abs1111'],
	  [1431, format(abs(scaled_wc('qd8_1112')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs1112'],
	  [1432, format(abs(scaled_wc('qd8_1113')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs1113'],
	  [1433, format(abs(scaled_wc('qd8_1123')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs1123'],
	  [1434, format(scaled_wc('qd8_1122') * lambda_smeft_value**2,'.6e'),      '# cqd8Abs1122'],
	  [1435, format(scaled_wc('qd8_1133') * lambda_smeft_value**2,'.6e'),      '# cqd8Abs1133'],
	  [1436, format(abs(scaled_wc('qd8_1211')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs1211'],
	  [1437, format(abs(scaled_wc('qd8_1212')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs1212'],
	  [1438, format(abs(scaled_wc('qd8_1221')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs1221'],
	  [1439, format(abs(scaled_wc('qd8_1213')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs1213'],
	  [1440, format(abs(scaled_wc('qd8_1231')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs1231'],
	  [1441, format(abs(scaled_wc('qd8_1222')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs1222'],
	  [1442, format(abs(scaled_wc('qd8_1223')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs1223'],
	  [1443, format(abs(scaled_wc('qd8_1232')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs1232'],
	  [1444, format(abs(scaled_wc('qd8_1233')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs1233'],
	  [1445, format(abs(scaled_wc('qd8_1311')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs1311'],
	  [1446, format(abs(scaled_wc('qd8_1312')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs1312'],
	  [1447, format(abs(scaled_wc('qd8_1313')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs1313'],
	  [1448, format(abs(scaled_wc('qd8_1331')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs1331'],
	  [1449, format(abs(scaled_wc('qd8_1321')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs1321'],
	  [1450, format(abs(scaled_wc('qd8_1322')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs1322'],
	  [1451, format(abs(scaled_wc('qd8_1332')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs1332'],
	  [1452, format(abs(scaled_wc('qd8_1323')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs1323'],
	  [1453, format(abs(scaled_wc('qd8_1333')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs1333'],
	  [1454, format(scaled_wc('qd8_2211') * lambda_smeft_value**2,'.6e'),      '# cqd8Abs2211'],
	  [1455, format(abs(scaled_wc('qd8_2212')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs2212'],
	  [1456, format(abs(scaled_wc('qd8_2213')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs2213'],
	  [1457, format(scaled_wc('qd8_2222') * lambda_smeft_value**2,'.6e'),      '# cqd8Abs2222'],
	  [1458, format(abs(scaled_wc('qd8_2223')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs2223'],
	  [1459, format(scaled_wc('qd8_2233') * lambda_smeft_value**2,'.6e'),      '# cqd8Abs2233'],
	  [1460, format(abs(scaled_wc('qd8_2311')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs2311'],
	  [1461, format(abs(scaled_wc('qd8_2312')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs2312'],
	  [1462, format(abs(scaled_wc('qd8_2313')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs2313'],
	  [1463, format(abs(scaled_wc('qd8_2321')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs2321'],
	  [1464, format(abs(scaled_wc('qd8_2322')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs2322'],
	  [1465, format(abs(scaled_wc('qd8_2323')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs2323'],
	  [1466, format(abs(scaled_wc('qd8_2331')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs2331'],
	  [1467, format(abs(scaled_wc('qd8_2332')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs2332'],
	  [1468, format(abs(scaled_wc('qd8_2333')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs2333'],
	  [1469, format(scaled_wc('qd8_3311') * lambda_smeft_value**2,'.6e'),      '# cqd8Abs3311'],
	  [1470, format(abs(scaled_wc('qd8_3312')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs3312'],
	  [1471, format(abs(scaled_wc('qd8_3313')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs3313'],
	  [1472, format(scaled_wc('qd8_3322') * lambda_smeft_value**2,'.6e'),      '# cqd8Abs3322'],
	  [1473, format(scaled_wc('qd8_3333') * lambda_smeft_value**2,'.6e'),      '# cqd8Abs3333'],
	  [1474, format(abs(scaled_wc('qd8_3323')) * lambda_smeft_value**2,'.6e'), '# cqd8Abs3323']
  ]}

      card['Block']['FRBlock10'] = {'values': [
	  [1, 1, format(angle(scaled_wc('phiud_11')),'.6e'), '# cHudPh1x1'],
	  [1, 2, format(angle(scaled_wc('phiud_12')),'.6e'), '# cHudPh1x2'],
	  [1, 3, format(angle(scaled_wc('phiud_13')),'.6e'), '# cHudPh1x3'],
	  [2, 1, format(angle(scaled_wc('phiud_21')),'.6e'), '# cHudPh2x1'],
	  [2, 2, format(angle(scaled_wc('phiud_22')),'.6e'), '# cHudPh2x2'],
	  [2, 3, format(angle(scaled_wc('phiud_23')),'.6e'), '# cHudPh2x3'],
	  [3, 1, format(angle(scaled_wc('phiud_31')),'.6e'), '# cHudPh3x1'],
	  [3, 2, format(angle(scaled_wc('phiud_32')),'.6e'), '# cHudPh3x2'],
	  [3, 3, format(angle(scaled_wc('phiud_33')),'.6e'), '# cHudPh3x3'],
      ]}

      card['Block']['FRBlock11'] = {'values': [
	  [1, 1, format(angle(scaled_wc('ephi_11')),'.6e'), '# ceHPh1x1'],
	  [1, 2, format(angle(scaled_wc('ephi_12')),'.6e'), '# ceHPh1x2'],
	  [1, 3, format(angle(scaled_wc('ephi_13')),'.6e'), '# ceHPh1x3'],
	  [2, 1, format(angle(scaled_wc('ephi_21')),'.6e'), '# ceHPh2x1'],
	  [2, 2, format(angle(scaled_wc('ephi_22')),'.6e'), '# ceHPh2x2'],
	  [2, 3, format(angle(scaled_wc('ephi_23')),'.6e'), '# ceHPh2x3'],
	  [3, 1, format(angle(scaled_wc('ephi_31')),'.6e'), '# ceHPh3x1'],
	  [3, 2, format(angle(scaled_wc('ephi_32')),'.6e'), '# ceHPh3x2'],
	  [3, 3, format(angle(scaled_wc('ephi_33')),'.6e'), '# ceHPh3x3'],
      ]}

      card['Block']['FRBlock12'] = {'values': [
	  [1, 1, format(angle(scaled_wc('uphi_11')),'.6e'), '# cuHPh1x1'],
	  [1, 2, format(angle(scaled_wc('uphi_12')),'.6e'), '# cuHPh1x2'],
	  [1, 3, format(angle(scaled_wc('uphi_13')),'.6e'), '# cuHPh1x3'],
	  [2, 1, format(angle(scaled_wc('uphi_21')),'.6e'), '# cuHPh2x1'],
	  [2, 2, format(angle(scaled_wc('uphi_22')),'.6e'), '# cuHPh2x2'],
	  [2, 3, format(angle(scaled_wc('uphi_23')),'.6e'), '# cuHPh2x3'],
	  [3, 1, format(angle(scaled_wc('uphi_31')),'.6e'), '# cuHPh3x1'],
	  [3, 2, format(angle(scaled_wc('uphi_32')),'.6e'), '# cuHPh3x2'],
	  [3, 3, format(angle(scaled_wc('uphi_33')),'.6e'), '# cuHPh3x3'],
      ]}

      card['Block']['FRBlock13'] = {'values': [
	  [1, 1, format(angle(scaled_wc('dphi_11')),'.6e'), '# cdHPh1x1'],
	  [1, 2, format(angle(scaled_wc('dphi_12')),'.6e'), '# cdHPh1x2'],
	  [1, 3, format(angle(scaled_wc('dphi_13')),'.6e'), '# cdHPh1x3'],
	  [2, 1, format(angle(scaled_wc('dphi_21')),'.6e'), '# cdHPh2x1'],
	  [2, 2, format(angle(scaled_wc('dphi_22')),'.6e'), '# cdHPh2x2'],
	  [2, 3, format(angle(scaled_wc('dphi_23')),'.6e'), '# cdHPh2x3'],
	  [3, 1, format(angle(scaled_wc('dphi_31')),'.6e'), '# cdHPh3x1'],
	  [3, 2, format(angle(scaled_wc('dphi_32')),'.6e'), '# cdHPh3x2'],
	  [3, 3, format(angle(scaled_wc('dphi_33')),'.6e'), '# cdHPh3x3'],
      ]}

      card['Block']['FRBlock14'] = {'values': [
	  [1, 1, 1, 1, format(angle(scaled_wc('ledq_1111')),'.6e'), '# cledqPh1x1x1x1'],
	  [1, 1, 1, 2, format(angle(scaled_wc('ledq_1112')),'.6e'), '# cledqPh1x1x1x2'],
	  [1, 1, 1, 3, format(angle(scaled_wc('ledq_1113')),'.6e'), '# cledqPh1x1x1x3'],
	  [1, 1, 2, 1, format(angle(scaled_wc('ledq_1121')),'.6e'), '# cledqPh1x1x2x1'],
	  [1, 1, 2, 2, format(angle(scaled_wc('ledq_1122')),'.6e'), '# cledqPh1x1x2x2'],
	  [1, 1, 2, 3, format(angle(scaled_wc('ledq_1123')),'.6e'), '# cledqPh1x1x2x3'],
	  [1, 1, 3, 1, format(angle(scaled_wc('ledq_1131')),'.6e'), '# cledqPh1x1x3x1'],
	  [1, 1, 3, 2, format(angle(scaled_wc('ledq_1132')),'.6e'), '# cledqPh1x1x3x2'],
	  [1, 1, 3, 3, format(angle(scaled_wc('ledq_1133')),'.6e'), '# cledqPh1x1x3x3'],
	  [1, 2, 1, 1, format(angle(scaled_wc('ledq_1211')),'.6e'), '# cledqPh1x2x1x1'],
	  [1, 2, 1, 2, format(angle(scaled_wc('ledq_1212')),'.6e'), '# cledqPh1x2x1x2'],
	  [1, 2, 1, 3, format(angle(scaled_wc('ledq_1213')),'.6e'), '# cledqPh1x2x1x3'],
	  [1, 2, 2, 1, format(angle(scaled_wc('ledq_1221')),'.6e'), '# cledqPh1x2x2x1'],
	  [1, 2, 2, 2, format(angle(scaled_wc('ledq_1222')),'.6e'), '# cledqPh1x2x2x2'],
	  [1, 2, 2, 3, format(angle(scaled_wc('ledq_1223')),'.6e'), '# cledqPh1x2x2x3'],
	  [1, 2, 3, 1, format(angle(scaled_wc('ledq_1231')),'.6e'), '# cledqPh1x2x3x1'],
	  [1, 2, 3, 2, format(angle(scaled_wc('ledq_1232')),'.6e'), '# cledqPh1x2x3x2'],
	  [1, 2, 3, 3, format(angle(scaled_wc('ledq_1233')),'.6e'), '# cledqPh1x2x3x3'],
	  [1, 3, 1, 1, format(angle(scaled_wc('ledq_1311')),'.6e'), '# cledqPh1x3x1x1'],
	  [1, 3, 1, 2, format(angle(scaled_wc('ledq_1312')),'.6e'), '# cledqPh1x3x1x2'],
	  [1, 3, 1, 3, format(angle(scaled_wc('ledq_1313')),'.6e'), '# cledqPh1x3x1x3'],
	  [1, 3, 2, 1, format(angle(scaled_wc('ledq_1321')),'.6e'), '# cledqPh1x3x2x1'],
	  [1, 3, 2, 2, format(angle(scaled_wc('ledq_1322')),'.6e'), '# cledqPh1x3x2x2'],
	  [1, 3, 2, 3, format(angle(scaled_wc('ledq_1323')),'.6e'), '# cledqPh1x3x2x3'],
	  [1, 3, 3, 1, format(angle(scaled_wc('ledq_1331')),'.6e'), '# cledqPh1x3x3x1'],
	  [1, 3, 3, 2, format(angle(scaled_wc('ledq_1332')),'.6e'), '# cledqPh1x3x3x2'],
	  [1, 3, 3, 3, format(angle(scaled_wc('ledq_1333')),'.6e'), '# cledqPh1x3x3x3'],
	  [2, 1, 1, 1, format(angle(scaled_wc('ledq_2111')),'.6e'), '# cledqPh2x1x1x1'],
	  [2, 1, 1, 2, format(angle(scaled_wc('ledq_2112')),'.6e'), '# cledqPh2x1x1x2'],
	  [2, 1, 1, 3, format(angle(scaled_wc('ledq_2113')),'.6e'), '# cledqPh2x1x1x3'],
	  [2, 1, 2, 1, format(angle(scaled_wc('ledq_2121')),'.6e'), '# cledqPh2x1x2x1'],
	  [2, 1, 2, 2, format(angle(scaled_wc('ledq_2122')),'.6e'), '# cledqPh2x1x2x2'],
	  [2, 1, 2, 3, format(angle(scaled_wc('ledq_2123')),'.6e'), '# cledqPh2x1x2x3'],
	  [2, 1, 3, 1, format(angle(scaled_wc('ledq_2131')),'.6e'), '# cledqPh2x1x3x1'],
	  [2, 1, 3, 2, format(angle(scaled_wc('ledq_2132')),'.6e'), '# cledqPh2x1x3x2'],
	  [2, 1, 3, 3, format(angle(scaled_wc('ledq_2133')),'.6e'), '# cledqPh2x1x3x3'],
	  [2, 2, 1, 1, format(angle(scaled_wc('ledq_2211')),'.6e'), '# cledqPh2x2x1x1'],
	  [2, 2, 1, 2, format(angle(scaled_wc('ledq_2212')),'.6e'), '# cledqPh2x2x1x2'],
	  [2, 2, 1, 3, format(angle(scaled_wc('ledq_2213')),'.6e'), '# cledqPh2x2x1x3'],
	  [2, 2, 2, 1, format(angle(scaled_wc('ledq_2221')),'.6e'), '# cledqPh2x2x2x1'],
	  [2, 2, 2, 2, format(angle(scaled_wc('ledq_2222')),'.6e'), '# cledqPh2x2x2x2'],
	  [2, 2, 2, 3, format(angle(scaled_wc('ledq_2223')),'.6e'), '# cledqPh2x2x2x3'],
	  [2, 2, 3, 1, format(angle(scaled_wc('ledq_2231')),'.6e'), '# cledqPh2x2x3x1'],
	  [2, 2, 3, 2, format(angle(scaled_wc('ledq_2232')),'.6e'), '# cledqPh2x2x3x2'],
	  [2, 2, 3, 3, format(angle(scaled_wc('ledq_2233')),'.6e'), '# cledqPh2x2x3x3'],
	  [2, 3, 1, 1, format(angle(scaled_wc('ledq_2311')),'.6e'), '# cledqPh2x3x1x1'],
	  [2, 3, 1, 2, format(angle(scaled_wc('ledq_2312')),'.6e'), '# cledqPh2x3x1x2'],
	  [2, 3, 1, 3, format(angle(scaled_wc('ledq_2313')),'.6e'), '# cledqPh2x3x1x3'],
	  [2, 3, 2, 1, format(angle(scaled_wc('ledq_2321')),'.6e'), '# cledqPh2x3x2x1'],
	  [2, 3, 2, 2, format(angle(scaled_wc('ledq_2322')),'.6e'), '# cledqPh2x3x2x2'],
	  [2, 3, 2, 3, format(angle(scaled_wc('ledq_2323')),'.6e'), '# cledqPh2x3x2x3'],
	  [2, 3, 3, 1, format(angle(scaled_wc('ledq_2331')),'.6e'), '# cledqPh2x3x3x1'],
	  [2, 3, 3, 2, format(angle(scaled_wc('ledq_2332')),'.6e'), '# cledqPh2x3x3x2'],
	  [2, 3, 3, 3, format(angle(scaled_wc('ledq_2333')),'.6e'), '# cledqPh2x3x3x3'],
	  [3, 1, 1, 1, format(angle(scaled_wc('ledq_3111')),'.6e'), '# cledqPh3x1x1x1'],
	  [3, 1, 1, 2, format(angle(scaled_wc('ledq_3112')),'.6e'), '# cledqPh3x1x1x2'],
	  [3, 1, 1, 3, format(angle(scaled_wc('ledq_3113')),'.6e'), '# cledqPh3x1x1x3'],
	  [3, 1, 2, 1, format(angle(scaled_wc('ledq_3121')),'.6e'), '# cledqPh3x1x2x1'],
	  [3, 1, 2, 2, format(angle(scaled_wc('ledq_3122')),'.6e'), '# cledqPh3x1x2x2'],
	  [3, 1, 2, 3, format(angle(scaled_wc('ledq_3123')),'.6e'), '# cledqPh3x1x2x3'],
	  [3, 1, 3, 1, format(angle(scaled_wc('ledq_3131')),'.6e'), '# cledqPh3x1x3x1'],
	  [3, 1, 3, 2, format(angle(scaled_wc('ledq_3132')),'.6e'), '# cledqPh3x1x3x2'],
	  [3, 1, 3, 3, format(angle(scaled_wc('ledq_3133')),'.6e'), '# cledqPh3x1x3x3'],
	  [3, 2, 1, 1, format(angle(scaled_wc('ledq_3211')),'.6e'), '# cledqPh3x2x1x1'],
	  [3, 2, 1, 2, format(angle(scaled_wc('ledq_3212')),'.6e'), '# cledqPh3x2x1x2'],
	  [3, 2, 1, 3, format(angle(scaled_wc('ledq_3213')),'.6e'), '# cledqPh3x2x1x3'],
	  [3, 2, 2, 1, format(angle(scaled_wc('ledq_3221')),'.6e'), '# cledqPh3x2x2x1'],
	  [3, 2, 2, 2, format(angle(scaled_wc('ledq_3222')),'.6e'), '# cledqPh3x2x2x2'],
	  [3, 2, 2, 3, format(angle(scaled_wc('ledq_3223')),'.6e'), '# cledqPh3x2x2x3'],
	  [3, 2, 3, 1, format(angle(scaled_wc('ledq_3231')),'.6e'), '# cledqPh3x2x3x1'],
	  [3, 2, 3, 2, format(angle(scaled_wc('ledq_3232')),'.6e'), '# cledqPh3x2x3x2'],
	  [3, 2, 3, 3, format(angle(scaled_wc('ledq_3233')),'.6e'), '# cledqPh3x2x3x3'],
	  [3, 3, 1, 1, format(angle(scaled_wc('ledq_3311')),'.6e'), '# cledqPh3x3x1x1'],
	  [3, 3, 1, 2, format(angle(scaled_wc('ledq_3312')),'.6e'), '# cledqPh3x3x1x2'],
	  [3, 3, 1, 3, format(angle(scaled_wc('ledq_3313')),'.6e'), '# cledqPh3x3x1x3'],
	  [3, 3, 2, 1, format(angle(scaled_wc('ledq_3321')),'.6e'), '# cledqPh3x3x2x1'],
	  [3, 3, 2, 2, format(angle(scaled_wc('ledq_3322')),'.6e'), '# cledqPh3x3x2x2'],
	  [3, 3, 2, 3, format(angle(scaled_wc('ledq_3323')),'.6e'), '# cledqPh3x3x2x3'],
	  [3, 3, 3, 1, format(angle(scaled_wc('ledq_3331')),'.6e'), '# cledqPh3x3x3x1'],
	  [3, 3, 3, 2, format(angle(scaled_wc('ledq_3332')),'.6e'), '# cledqPh3x3x3x2'],
	  [3, 3, 3, 3, format(angle(scaled_wc('ledq_3333')),'.6e'), '# cledqPh3x3x3x3'],
      ]}

      card['Block']['FRBlock15'] = {'values': [
	  [1, 1, 1, 1, format(angle(scaled_wc('quqd1_1111')),'.6e'), '# cquqd1Ph1x1x1x1'],
	  [1, 1, 1, 2, format(angle(scaled_wc('quqd1_1112')),'.6e'), '# cquqd1Ph1x1x1x2'],
	  [1, 1, 1, 3, format(angle(scaled_wc('quqd1_1113')),'.6e'), '# cquqd1Ph1x1x1x3'],
	  [1, 1, 2, 1, format(angle(scaled_wc('quqd1_1121')),'.6e'), '# cquqd1Ph1x1x2x1'],
	  [1, 1, 2, 2, format(angle(scaled_wc('quqd1_1122')),'.6e'), '# cquqd1Ph1x1x2x2'],
	  [1, 1, 2, 3, format(angle(scaled_wc('quqd1_1123')),'.6e'), '# cquqd1Ph1x1x2x3'],
	  [1, 1, 3, 1, format(angle(scaled_wc('quqd1_1131')),'.6e'), '# cquqd1Ph1x1x3x1'],
	  [1, 1, 3, 2, format(angle(scaled_wc('quqd1_1132')),'.6e'), '# cquqd1Ph1x1x3x2'],
	  [1, 1, 3, 3, format(angle(scaled_wc('quqd1_1133')),'.6e'), '# cquqd1Ph1x1x3x3'],
	  [1, 2, 1, 1, format(angle(scaled_wc('quqd1_1211')),'.6e'), '# cquqd1Ph1x2x1x1'],
	  [1, 2, 1, 2, format(angle(scaled_wc('quqd1_1212')),'.6e'), '# cquqd1Ph1x2x1x2'],
	  [1, 2, 1, 3, format(angle(scaled_wc('quqd1_1213')),'.6e'), '# cquqd1Ph1x2x1x3'],
	  [1, 2, 2, 1, format(angle(scaled_wc('quqd1_1221')),'.6e'), '# cquqd1Ph1x2x2x1'],
	  [1, 2, 2, 2, format(angle(scaled_wc('quqd1_1222')),'.6e'), '# cquqd1Ph1x2x2x2'],
	  [1, 2, 2, 3, format(angle(scaled_wc('quqd1_1223')),'.6e'), '# cquqd1Ph1x2x2x3'],
	  [1, 2, 3, 1, format(angle(scaled_wc('quqd1_1231')),'.6e'), '# cquqd1Ph1x2x3x1'],
	  [1, 2, 3, 2, format(angle(scaled_wc('quqd1_1232')),'.6e'), '# cquqd1Ph1x2x3x2'],
	  [1, 2, 3, 3, format(angle(scaled_wc('quqd1_1233')),'.6e'), '# cquqd1Ph1x2x3x3'],
	  [1, 3, 1, 1, format(angle(scaled_wc('quqd1_1311')),'.6e'), '# cquqd1Ph1x3x1x1'],
	  [1, 3, 1, 2, format(angle(scaled_wc('quqd1_1312')),'.6e'), '# cquqd1Ph1x3x1x2'],
	  [1, 3, 1, 3, format(angle(scaled_wc('quqd1_1313')),'.6e'), '# cquqd1Ph1x3x1x3'],
	  [1, 3, 2, 1, format(angle(scaled_wc('quqd1_1321')),'.6e'), '# cquqd1Ph1x3x2x1'],
	  [1, 3, 2, 2, format(angle(scaled_wc('quqd1_1322')),'.6e'), '# cquqd1Ph1x3x2x2'],
	  [1, 3, 2, 3, format(angle(scaled_wc('quqd1_1323')),'.6e'), '# cquqd1Ph1x3x2x3'],
	  [1, 3, 3, 1, format(angle(scaled_wc('quqd1_1331')),'.6e'), '# cquqd1Ph1x3x3x1'],
	  [1, 3, 3, 2, format(angle(scaled_wc('quqd1_1332')),'.6e'), '# cquqd1Ph1x3x3x2'],
	  [1, 3, 3, 3, format(angle(scaled_wc('quqd1_1333')),'.6e'), '# cquqd1Ph1x3x3x3'],
	  [2, 1, 1, 1, format(angle(scaled_wc('quqd1_2111')),'.6e'), '# cquqd1Ph2x1x1x1'],
	  [2, 1, 1, 2, format(angle(scaled_wc('quqd1_2112')),'.6e'), '# cquqd1Ph2x1x1x2'],
	  [2, 1, 1, 3, format(angle(scaled_wc('quqd1_2113')),'.6e'), '# cquqd1Ph2x1x1x3'],
	  [2, 1, 2, 1, format(angle(scaled_wc('quqd1_2121')),'.6e'), '# cquqd1Ph2x1x2x1'],
	  [2, 1, 2, 2, format(angle(scaled_wc('quqd1_2122')),'.6e'), '# cquqd1Ph2x1x2x2'],
	  [2, 1, 2, 3, format(angle(scaled_wc('quqd1_2123')),'.6e'), '# cquqd1Ph2x1x2x3'],
	  [2, 1, 3, 1, format(angle(scaled_wc('quqd1_2131')),'.6e'), '# cquqd1Ph2x1x3x1'],
	  [2, 1, 3, 2, format(angle(scaled_wc('quqd1_2132')),'.6e'), '# cquqd1Ph2x1x3x2'],
	  [2, 1, 3, 3, format(angle(scaled_wc('quqd1_2133')),'.6e'), '# cquqd1Ph2x1x3x3'],
	  [2, 2, 1, 1, format(angle(scaled_wc('quqd1_2211')),'.6e'), '# cquqd1Ph2x2x1x1'],
	  [2, 2, 1, 2, format(angle(scaled_wc('quqd1_2212')),'.6e'), '# cquqd1Ph2x2x1x2'],
	  [2, 2, 1, 3, format(angle(scaled_wc('quqd1_2213')),'.6e'), '# cquqd1Ph2x2x1x3'],
	  [2, 2, 2, 1, format(angle(scaled_wc('quqd1_2221')),'.6e'), '# cquqd1Ph2x2x2x1'],
	  [2, 2, 2, 2, format(angle(scaled_wc('quqd1_2222')),'.6e'), '# cquqd1Ph2x2x2x2'],
	  [2, 2, 2, 3, format(angle(scaled_wc('quqd1_2223')),'.6e'), '# cquqd1Ph2x2x2x3'],
	  [2, 2, 3, 1, format(angle(scaled_wc('quqd1_2231')),'.6e'), '# cquqd1Ph2x2x3x1'],
	  [2, 2, 3, 2, format(angle(scaled_wc('quqd1_2232')),'.6e'), '# cquqd1Ph2x2x3x2'],
	  [2, 2, 3, 3, format(angle(scaled_wc('quqd1_2233')),'.6e'), '# cquqd1Ph2x2x3x3'],
	  [2, 3, 1, 1, format(angle(scaled_wc('quqd1_2311')),'.6e'), '# cquqd1Ph2x3x1x1'],
	  [2, 3, 1, 2, format(angle(scaled_wc('quqd1_2312')),'.6e'), '# cquqd1Ph2x3x1x2'],
	  [2, 3, 1, 3, format(angle(scaled_wc('quqd1_2313')),'.6e'), '# cquqd1Ph2x3x1x3'],
	  [2, 3, 2, 1, format(angle(scaled_wc('quqd1_2321')),'.6e'), '# cquqd1Ph2x3x2x1'],
	  [2, 3, 2, 2, format(angle(scaled_wc('quqd1_2322')),'.6e'), '# cquqd1Ph2x3x2x2'],
	  [2, 3, 2, 3, format(angle(scaled_wc('quqd1_2323')),'.6e'), '# cquqd1Ph2x3x2x3'],
	  [2, 3, 3, 1, format(angle(scaled_wc('quqd1_2331')),'.6e'), '# cquqd1Ph2x3x3x1'],
	  [2, 3, 3, 2, format(angle(scaled_wc('quqd1_2332')),'.6e'), '# cquqd1Ph2x3x3x2'],
	  [2, 3, 3, 3, format(angle(scaled_wc('quqd1_2333')),'.6e'), '# cquqd1Ph2x3x3x3'],
	  [3, 1, 1, 1, format(angle(scaled_wc('quqd1_3111')),'.6e'), '# cquqd1Ph3x1x1x1'],
	  [3, 1, 1, 2, format(angle(scaled_wc('quqd1_3112')),'.6e'), '# cquqd1Ph3x1x1x2'],
	  [3, 1, 1, 3, format(angle(scaled_wc('quqd1_3113')),'.6e'), '# cquqd1Ph3x1x1x3'],
	  [3, 1, 2, 1, format(angle(scaled_wc('quqd1_3121')),'.6e'), '# cquqd1Ph3x1x2x1'],
	  [3, 1, 2, 2, format(angle(scaled_wc('quqd1_3122')),'.6e'), '# cquqd1Ph3x1x2x2'],
	  [3, 1, 2, 3, format(angle(scaled_wc('quqd1_3123')),'.6e'), '# cquqd1Ph3x1x2x3'],
	  [3, 1, 3, 1, format(angle(scaled_wc('quqd1_3131')),'.6e'), '# cquqd1Ph3x1x3x1'],
	  [3, 1, 3, 2, format(angle(scaled_wc('quqd1_3132')),'.6e'), '# cquqd1Ph3x1x3x2'],
	  [3, 1, 3, 3, format(angle(scaled_wc('quqd1_3133')),'.6e'), '# cquqd1Ph3x1x3x3'],
	  [3, 2, 1, 1, format(angle(scaled_wc('quqd1_3211')),'.6e'), '# cquqd1Ph3x2x1x1'],
	  [3, 2, 1, 2, format(angle(scaled_wc('quqd1_3212')),'.6e'), '# cquqd1Ph3x2x1x2'],
	  [3, 2, 1, 3, format(angle(scaled_wc('quqd1_3213')),'.6e'), '# cquqd1Ph3x2x1x3'],
	  [3, 2, 2, 1, format(angle(scaled_wc('quqd1_3221')),'.6e'), '# cquqd1Ph3x2x2x1'],
	  [3, 2, 2, 2, format(angle(scaled_wc('quqd1_3222')),'.6e'), '# cquqd1Ph3x2x2x2'],
	  [3, 2, 2, 3, format(angle(scaled_wc('quqd1_3223')),'.6e'), '# cquqd1Ph3x2x2x3'],
	  [3, 2, 3, 1, format(angle(scaled_wc('quqd1_3231')),'.6e'), '# cquqd1Ph3x2x3x1'],
	  [3, 2, 3, 2, format(angle(scaled_wc('quqd1_3232')),'.6e'), '# cquqd1Ph3x2x3x2'],
	  [3, 2, 3, 3, format(angle(scaled_wc('quqd1_3233')),'.6e'), '# cquqd1Ph3x2x3x3'],
	  [3, 3, 1, 1, format(angle(scaled_wc('quqd1_3311')),'.6e'), '# cquqd1Ph3x3x1x1'],
	  [3, 3, 1, 2, format(angle(scaled_wc('quqd1_3312')),'.6e'), '# cquqd1Ph3x3x1x2'],
	  [3, 3, 1, 3, format(angle(scaled_wc('quqd1_3313')),'.6e'), '# cquqd1Ph3x3x1x3'],
	  [3, 3, 2, 1, format(angle(scaled_wc('quqd1_3321')),'.6e'), '# cquqd1Ph3x3x2x1'],
	  [3, 3, 2, 2, format(angle(scaled_wc('quqd1_3322')),'.6e'), '# cquqd1Ph3x3x2x2'],
	  [3, 3, 2, 3, format(angle(scaled_wc('quqd1_3323')),'.6e'), '# cquqd1Ph3x3x2x3'],
	  [3, 3, 3, 1, format(angle(scaled_wc('quqd1_3331')),'.6e'), '# cquqd1Ph3x3x3x1'],
	  [3, 3, 3, 2, format(angle(scaled_wc('quqd1_3332')),'.6e'), '# cquqd1Ph3x3x3x2'],
	  [3, 3, 3, 3, format(angle(scaled_wc('quqd1_3333')),'.6e'), '# cquqd1Ph3x3x3x3'],
      ]}

      card['Block']['FRBlock16'] = {'values': [
	  [1, 1, 1, 1, format(angle(scaled_wc('quqd8_1111')),'.6e'), '# cquqd8Ph1x1x1x1'],
	  [1, 1, 1, 2, format(angle(scaled_wc('quqd8_1112')),'.6e'), '# cquqd8Ph1x1x1x2'],
	  [1, 1, 1, 3, format(angle(scaled_wc('quqd8_1113')),'.6e'), '# cquqd8Ph1x1x1x3'],
	  [1, 1, 2, 1, format(angle(scaled_wc('quqd8_1121')),'.6e'), '# cquqd8Ph1x1x2x1'],
	  [1, 1, 2, 2, format(angle(scaled_wc('quqd8_1122')),'.6e'), '# cquqd8Ph1x1x2x2'],
	  [1, 1, 2, 3, format(angle(scaled_wc('quqd8_1123')),'.6e'), '# cquqd8Ph1x1x2x3'],
	  [1, 1, 3, 1, format(angle(scaled_wc('quqd8_1131')),'.6e'), '# cquqd8Ph1x1x3x1'],
	  [1, 1, 3, 2, format(angle(scaled_wc('quqd8_1132')),'.6e'), '# cquqd8Ph1x1x3x2'],
	  [1, 1, 3, 3, format(angle(scaled_wc('quqd8_1133')),'.6e'), '# cquqd8Ph1x1x3x3'],
	  [1, 2, 1, 1, format(angle(scaled_wc('quqd8_1211')),'.6e'), '# cquqd8Ph1x2x1x1'],
	  [1, 2, 1, 2, format(angle(scaled_wc('quqd8_1212')),'.6e'), '# cquqd8Ph1x2x1x2'],
	  [1, 2, 1, 3, format(angle(scaled_wc('quqd8_1213')),'.6e'), '# cquqd8Ph1x2x1x3'],
	  [1, 2, 2, 1, format(angle(scaled_wc('quqd8_1221')),'.6e'), '# cquqd8Ph1x2x2x1'],
	  [1, 2, 2, 2, format(angle(scaled_wc('quqd8_1222')),'.6e'), '# cquqd8Ph1x2x2x2'],
	  [1, 2, 2, 3, format(angle(scaled_wc('quqd8_1223')),'.6e'), '# cquqd8Ph1x2x2x3'],
	  [1, 2, 3, 1, format(angle(scaled_wc('quqd8_1231')),'.6e'), '# cquqd8Ph1x2x3x1'],
	  [1, 2, 3, 2, format(angle(scaled_wc('quqd8_1232')),'.6e'), '# cquqd8Ph1x2x3x2'],
	  [1, 2, 3, 3, format(angle(scaled_wc('quqd8_1233')),'.6e'), '# cquqd8Ph1x2x3x3'],
	  [1, 3, 1, 1, format(angle(scaled_wc('quqd8_1311')),'.6e'), '# cquqd8Ph1x3x1x1'],
	  [1, 3, 1, 2, format(angle(scaled_wc('quqd8_1312')),'.6e'), '# cquqd8Ph1x3x1x2'],
	  [1, 3, 1, 3, format(angle(scaled_wc('quqd8_1313')),'.6e'), '# cquqd8Ph1x3x1x3'],
	  [1, 3, 2, 1, format(angle(scaled_wc('quqd8_1321')),'.6e'), '# cquqd8Ph1x3x2x1'],
	  [1, 3, 2, 2, format(angle(scaled_wc('quqd8_1322')),'.6e'), '# cquqd8Ph1x3x2x2'],
	  [1, 3, 2, 3, format(angle(scaled_wc('quqd8_1323')),'.6e'), '# cquqd8Ph1x3x2x3'],
	  [1, 3, 3, 1, format(angle(scaled_wc('quqd8_1331')),'.6e'), '# cquqd8Ph1x3x3x1'],
	  [1, 3, 3, 2, format(angle(scaled_wc('quqd8_1332')),'.6e'), '# cquqd8Ph1x3x3x2'],
	  [1, 3, 3, 3, format(angle(scaled_wc('quqd8_1333')),'.6e'), '# cquqd8Ph1x3x3x3'],
	  [2, 1, 1, 1, format(angle(scaled_wc('quqd8_2111')),'.6e'), '# cquqd8Ph2x1x1x1'],
	  [2, 1, 1, 2, format(angle(scaled_wc('quqd8_2112')),'.6e'), '# cquqd8Ph2x1x1x2'],
	  [2, 1, 1, 3, format(angle(scaled_wc('quqd8_2113')),'.6e'), '# cquqd8Ph2x1x1x3'],
	  [2, 1, 2, 1, format(angle(scaled_wc('quqd8_2121')),'.6e'), '# cquqd8Ph2x1x2x1'],
	  [2, 1, 2, 2, format(angle(scaled_wc('quqd8_2122')),'.6e'), '# cquqd8Ph2x1x2x2'],
	  [2, 1, 2, 3, format(angle(scaled_wc('quqd8_2123')),'.6e'), '# cquqd8Ph2x1x2x3'],
	  [2, 1, 3, 1, format(angle(scaled_wc('quqd8_2131')),'.6e'), '# cquqd8Ph2x1x3x1'],
	  [2, 1, 3, 2, format(angle(scaled_wc('quqd8_2132')),'.6e'), '# cquqd8Ph2x1x3x2'],
	  [2, 1, 3, 3, format(angle(scaled_wc('quqd8_2133')),'.6e'), '# cquqd8Ph2x1x3x3'],
	  [2, 2, 1, 1, format(angle(scaled_wc('quqd8_2211')),'.6e'), '# cquqd8Ph2x2x1x1'],
	  [2, 2, 1, 2, format(angle(scaled_wc('quqd8_2212')),'.6e'), '# cquqd8Ph2x2x1x2'],
	  [2, 2, 1, 3, format(angle(scaled_wc('quqd8_2213')),'.6e'), '# cquqd8Ph2x2x1x3'],
	  [2, 2, 2, 1, format(angle(scaled_wc('quqd8_2221')),'.6e'), '# cquqd8Ph2x2x2x1'],
	  [2, 2, 2, 2, format(angle(scaled_wc('quqd8_2222')),'.6e'), '# cquqd8Ph2x2x2x2'],
	  [2, 2, 2, 3, format(angle(scaled_wc('quqd8_2223')),'.6e'), '# cquqd8Ph2x2x2x3'],
	  [2, 2, 3, 1, format(angle(scaled_wc('quqd8_2231')),'.6e'), '# cquqd8Ph2x2x3x1'],
	  [2, 2, 3, 2, format(angle(scaled_wc('quqd8_2232')),'.6e'), '# cquqd8Ph2x2x3x2'],
	  [2, 2, 3, 3, format(angle(scaled_wc('quqd8_2233')),'.6e'), '# cquqd8Ph2x2x3x3'],
	  [2, 3, 1, 1, format(angle(scaled_wc('quqd8_2311')),'.6e'), '# cquqd8Ph2x3x1x1'],
	  [2, 3, 1, 2, format(angle(scaled_wc('quqd8_2312')),'.6e'), '# cquqd8Ph2x3x1x2'],
	  [2, 3, 1, 3, format(angle(scaled_wc('quqd8_2313')),'.6e'), '# cquqd8Ph2x3x1x3'],
	  [2, 3, 2, 1, format(angle(scaled_wc('quqd8_2321')),'.6e'), '# cquqd8Ph2x3x2x1'],
	  [2, 3, 2, 2, format(angle(scaled_wc('quqd8_2322')),'.6e'), '# cquqd8Ph2x3x2x2'],
	  [2, 3, 2, 3, format(angle(scaled_wc('quqd8_2323')),'.6e'), '# cquqd8Ph2x3x2x3'],
	  [2, 3, 3, 1, format(angle(scaled_wc('quqd8_2331')),'.6e'), '# cquqd8Ph2x3x3x1'],
	  [2, 3, 3, 2, format(angle(scaled_wc('quqd8_2332')),'.6e'), '# cquqd8Ph2x3x3x2'],
	  [2, 3, 3, 3, format(angle(scaled_wc('quqd8_2333')),'.6e'), '# cquqd8Ph2x3x3x3'],
	  [3, 1, 1, 1, format(angle(scaled_wc('quqd8_3111')),'.6e'), '# cquqd8Ph3x1x1x1'],
	  [3, 1, 1, 2, format(angle(scaled_wc('quqd8_3112')),'.6e'), '# cquqd8Ph3x1x1x2'],
	  [3, 1, 1, 3, format(angle(scaled_wc('quqd8_3113')),'.6e'), '# cquqd8Ph3x1x1x3'],
	  [3, 1, 2, 1, format(angle(scaled_wc('quqd8_3121')),'.6e'), '# cquqd8Ph3x1x2x1'],
	  [3, 1, 2, 2, format(angle(scaled_wc('quqd8_3122')),'.6e'), '# cquqd8Ph3x1x2x2'],
	  [3, 1, 2, 3, format(angle(scaled_wc('quqd8_3123')),'.6e'), '# cquqd8Ph3x1x2x3'],
	  [3, 1, 3, 1, format(angle(scaled_wc('quqd8_3131')),'.6e'), '# cquqd8Ph3x1x3x1'],
	  [3, 1, 3, 2, format(angle(scaled_wc('quqd8_3132')),'.6e'), '# cquqd8Ph3x1x3x2'],
	  [3, 1, 3, 3, format(angle(scaled_wc('quqd8_3133')),'.6e'), '# cquqd8Ph3x1x3x3'],
	  [3, 2, 1, 1, format(angle(scaled_wc('quqd8_3211')),'.6e'), '# cquqd8Ph3x2x1x1'],
	  [3, 2, 1, 2, format(angle(scaled_wc('quqd8_3212')),'.6e'), '# cquqd8Ph3x2x1x2'],
	  [3, 2, 1, 3, format(angle(scaled_wc('quqd8_3213')),'.6e'), '# cquqd8Ph3x2x1x3'],
	  [3, 2, 2, 1, format(angle(scaled_wc('quqd8_3221')),'.6e'), '# cquqd8Ph3x2x2x1'],
	  [3, 2, 2, 2, format(angle(scaled_wc('quqd8_3222')),'.6e'), '# cquqd8Ph3x2x2x2'],
	  [3, 2, 2, 3, format(angle(scaled_wc('quqd8_3223')),'.6e'), '# cquqd8Ph3x2x2x3'],
	  [3, 2, 3, 1, format(angle(scaled_wc('quqd8_3231')),'.6e'), '# cquqd8Ph3x2x3x1'],
	  [3, 2, 3, 2, format(angle(scaled_wc('quqd8_3232')),'.6e'), '# cquqd8Ph3x2x3x2'],
	  [3, 2, 3, 3, format(angle(scaled_wc('quqd8_3233')),'.6e'), '# cquqd8Ph3x2x3x3'],
	  [3, 3, 1, 1, format(angle(scaled_wc('quqd8_3311')),'.6e'), '# cquqd8Ph3x3x1x1'],
	  [3, 3, 1, 2, format(angle(scaled_wc('quqd8_3312')),'.6e'), '# cquqd8Ph3x3x1x2'],
	  [3, 3, 1, 3, format(angle(scaled_wc('quqd8_3313')),'.6e'), '# cquqd8Ph3x3x1x3'],
	  [3, 3, 2, 1, format(angle(scaled_wc('quqd8_3321')),'.6e'), '# cquqd8Ph3x3x2x1'],
	  [3, 3, 2, 2, format(angle(scaled_wc('quqd8_3322')),'.6e'), '# cquqd8Ph3x3x2x2'],
	  [3, 3, 2, 3, format(angle(scaled_wc('quqd8_3323')),'.6e'), '# cquqd8Ph3x3x2x3'],
	  [3, 3, 3, 1, format(angle(scaled_wc('quqd8_3331')),'.6e'), '# cquqd8Ph3x3x3x1'],
	  [3, 3, 3, 2, format(angle(scaled_wc('quqd8_3332')),'.6e'), '# cquqd8Ph3x3x3x2'],
	  [3, 3, 3, 3, format(angle(scaled_wc('quqd8_3333')),'.6e'), '# cquqd8Ph3x3x3x3'],
      ]}

      card['Block']['FRBlock17'] = {'values': [
	  [1, 1, 1, 1, format(angle(scaled_wc('lequ1_1111')),'.6e'), '# clequ1Ph1x1x1x1'],
	  [1, 1, 1, 2, format(angle(scaled_wc('lequ1_1112')),'.6e'), '# clequ1Ph1x1x1x2'],
	  [1, 1, 1, 3, format(angle(scaled_wc('lequ1_1113')),'.6e'), '# clequ1Ph1x1x1x3'],
	  [1, 1, 2, 1, format(angle(scaled_wc('lequ1_1121')),'.6e'), '# clequ1Ph1x1x2x1'],
	  [1, 1, 2, 2, format(angle(scaled_wc('lequ1_1122')),'.6e'), '# clequ1Ph1x1x2x2'],
	  [1, 1, 2, 3, format(angle(scaled_wc('lequ1_1123')),'.6e'), '# clequ1Ph1x1x2x3'],
	  [1, 1, 3, 1, format(angle(scaled_wc('lequ1_1131')),'.6e'), '# clequ1Ph1x1x3x1'],
	  [1, 1, 3, 2, format(angle(scaled_wc('lequ1_1132')),'.6e'), '# clequ1Ph1x1x3x2'],
	  [1, 1, 3, 3, format(angle(scaled_wc('lequ1_1133')),'.6e'), '# clequ1Ph1x1x3x3'],
	  [1, 2, 1, 1, format(angle(scaled_wc('lequ1_1211')),'.6e'), '# clequ1Ph1x2x1x1'],
	  [1, 2, 1, 2, format(angle(scaled_wc('lequ1_1212')),'.6e'), '# clequ1Ph1x2x1x2'],
	  [1, 2, 1, 3, format(angle(scaled_wc('lequ1_1213')),'.6e'), '# clequ1Ph1x2x1x3'],
	  [1, 2, 2, 1, format(angle(scaled_wc('lequ1_1221')),'.6e'), '# clequ1Ph1x2x2x1'],
	  [1, 2, 2, 2, format(angle(scaled_wc('lequ1_1222')),'.6e'), '# clequ1Ph1x2x2x2'],
	  [1, 2, 2, 3, format(angle(scaled_wc('lequ1_1223')),'.6e'), '# clequ1Ph1x2x2x3'],
	  [1, 2, 3, 1, format(angle(scaled_wc('lequ1_1231')),'.6e'), '# clequ1Ph1x2x3x1'],
	  [1, 2, 3, 2, format(angle(scaled_wc('lequ1_1232')),'.6e'), '# clequ1Ph1x2x3x2'],
	  [1, 2, 3, 3, format(angle(scaled_wc('lequ1_1233')),'.6e'), '# clequ1Ph1x2x3x3'],
	  [1, 3, 1, 1, format(angle(scaled_wc('lequ1_1311')),'.6e'), '# clequ1Ph1x3x1x1'],
	  [1, 3, 1, 2, format(angle(scaled_wc('lequ1_1312')),'.6e'), '# clequ1Ph1x3x1x2'],
	  [1, 3, 1, 3, format(angle(scaled_wc('lequ1_1313')),'.6e'), '# clequ1Ph1x3x1x3'],
	  [1, 3, 2, 1, format(angle(scaled_wc('lequ1_1321')),'.6e'), '# clequ1Ph1x3x2x1'],
	  [1, 3, 2, 2, format(angle(scaled_wc('lequ1_1322')),'.6e'), '# clequ1Ph1x3x2x2'],
	  [1, 3, 2, 3, format(angle(scaled_wc('lequ1_1323')),'.6e'), '# clequ1Ph1x3x2x3'],
	  [1, 3, 3, 1, format(angle(scaled_wc('lequ1_1331')),'.6e'), '# clequ1Ph1x3x3x1'],
	  [1, 3, 3, 2, format(angle(scaled_wc('lequ1_1332')),'.6e'), '# clequ1Ph1x3x3x2'],
	  [1, 3, 3, 3, format(angle(scaled_wc('lequ1_1333')),'.6e'), '# clequ1Ph1x3x3x3'],
	  [2, 1, 1, 1, format(angle(scaled_wc('lequ1_2111')),'.6e'), '# clequ1Ph2x1x1x1'],
	  [2, 1, 1, 2, format(angle(scaled_wc('lequ1_2112')),'.6e'), '# clequ1Ph2x1x1x2'],
	  [2, 1, 1, 3, format(angle(scaled_wc('lequ1_2113')),'.6e'), '# clequ1Ph2x1x1x3'],
	  [2, 1, 2, 1, format(angle(scaled_wc('lequ1_2121')),'.6e'), '# clequ1Ph2x1x2x1'],
	  [2, 1, 2, 2, format(angle(scaled_wc('lequ1_2122')),'.6e'), '# clequ1Ph2x1x2x2'],
	  [2, 1, 2, 3, format(angle(scaled_wc('lequ1_2123')),'.6e'), '# clequ1Ph2x1x2x3'],
	  [2, 1, 3, 1, format(angle(scaled_wc('lequ1_2131')),'.6e'), '# clequ1Ph2x1x3x1'],
	  [2, 1, 3, 2, format(angle(scaled_wc('lequ1_2132')),'.6e'), '# clequ1Ph2x1x3x2'],
	  [2, 1, 3, 3, format(angle(scaled_wc('lequ1_2133')),'.6e'), '# clequ1Ph2x1x3x3'],
	  [2, 2, 1, 1, format(angle(scaled_wc('lequ1_2211')),'.6e'), '# clequ1Ph2x2x1x1'],
	  [2, 2, 1, 2, format(angle(scaled_wc('lequ1_2212')),'.6e'), '# clequ1Ph2x2x1x2'],
	  [2, 2, 1, 3, format(angle(scaled_wc('lequ1_2213')),'.6e'), '# clequ1Ph2x2x1x3'],
	  [2, 2, 2, 1, format(angle(scaled_wc('lequ1_2221')),'.6e'), '# clequ1Ph2x2x2x1'],
	  [2, 2, 2, 2, format(angle(scaled_wc('lequ1_2222')),'.6e'), '# clequ1Ph2x2x2x2'],
	  [2, 2, 2, 3, format(angle(scaled_wc('lequ1_2223')),'.6e'), '# clequ1Ph2x2x2x3'],
	  [2, 2, 3, 1, format(angle(scaled_wc('lequ1_2231')),'.6e'), '# clequ1Ph2x2x3x1'],
	  [2, 2, 3, 2, format(angle(scaled_wc('lequ1_2232')),'.6e'), '# clequ1Ph2x2x3x2'],
	  [2, 2, 3, 3, format(angle(scaled_wc('lequ1_2233')),'.6e'), '# clequ1Ph2x2x3x3'],
	  [2, 3, 1, 1, format(angle(scaled_wc('lequ1_2311')),'.6e'), '# clequ1Ph2x3x1x1'],
	  [2, 3, 1, 2, format(angle(scaled_wc('lequ1_2312')),'.6e'), '# clequ1Ph2x3x1x2'],
	  [2, 3, 1, 3, format(angle(scaled_wc('lequ1_2313')),'.6e'), '# clequ1Ph2x3x1x3'],
	  [2, 3, 2, 1, format(angle(scaled_wc('lequ1_2321')),'.6e'), '# clequ1Ph2x3x2x1'],
	  [2, 3, 2, 2, format(angle(scaled_wc('lequ1_2322')),'.6e'), '# clequ1Ph2x3x2x2'],
	  [2, 3, 2, 3, format(angle(scaled_wc('lequ1_2323')),'.6e'), '# clequ1Ph2x3x2x3'],
	  [2, 3, 3, 1, format(angle(scaled_wc('lequ1_2331')),'.6e'), '# clequ1Ph2x3x3x1'],
	  [2, 3, 3, 2, format(angle(scaled_wc('lequ1_2332')),'.6e'), '# clequ1Ph2x3x3x2'],
	  [2, 3, 3, 3, format(angle(scaled_wc('lequ1_2333')),'.6e'), '# clequ1Ph2x3x3x3'],
	  [3, 1, 1, 1, format(angle(scaled_wc('lequ1_3111')),'.6e'), '# clequ1Ph3x1x1x1'],
	  [3, 1, 1, 2, format(angle(scaled_wc('lequ1_3112')),'.6e'), '# clequ1Ph3x1x1x2'],
	  [3, 1, 1, 3, format(angle(scaled_wc('lequ1_3113')),'.6e'), '# clequ1Ph3x1x1x3'],
	  [3, 1, 2, 1, format(angle(scaled_wc('lequ1_3121')),'.6e'), '# clequ1Ph3x1x2x1'],
	  [3, 1, 2, 2, format(angle(scaled_wc('lequ1_3122')),'.6e'), '# clequ1Ph3x1x2x2'],
	  [3, 1, 2, 3, format(angle(scaled_wc('lequ1_3123')),'.6e'), '# clequ1Ph3x1x2x3'],
	  [3, 1, 3, 1, format(angle(scaled_wc('lequ1_3131')),'.6e'), '# clequ1Ph3x1x3x1'],
	  [3, 1, 3, 2, format(angle(scaled_wc('lequ1_3132')),'.6e'), '# clequ1Ph3x1x3x2'],
	  [3, 1, 3, 3, format(angle(scaled_wc('lequ1_3133')),'.6e'), '# clequ1Ph3x1x3x3'],
	  [3, 2, 1, 1, format(angle(scaled_wc('lequ1_3211')),'.6e'), '# clequ1Ph3x2x1x1'],
	  [3, 2, 1, 2, format(angle(scaled_wc('lequ1_3212')),'.6e'), '# clequ1Ph3x2x1x2'],
	  [3, 2, 1, 3, format(angle(scaled_wc('lequ1_3213')),'.6e'), '# clequ1Ph3x2x1x3'],
	  [3, 2, 2, 1, format(angle(scaled_wc('lequ1_3221')),'.6e'), '# clequ1Ph3x2x2x1'],
	  [3, 2, 2, 2, format(angle(scaled_wc('lequ1_3222')),'.6e'), '# clequ1Ph3x2x2x2'],
	  [3, 2, 2, 3, format(angle(scaled_wc('lequ1_3223')),'.6e'), '# clequ1Ph3x2x2x3'],
	  [3, 2, 3, 1, format(angle(scaled_wc('lequ1_3231')),'.6e'), '# clequ1Ph3x2x3x1'],
	  [3, 2, 3, 2, format(angle(scaled_wc('lequ1_3232')),'.6e'), '# clequ1Ph3x2x3x2'],
	  [3, 2, 3, 3, format(angle(scaled_wc('lequ1_3233')),'.6e'), '# clequ1Ph3x2x3x3'],
	  [3, 3, 1, 1, format(angle(scaled_wc('lequ1_3311')),'.6e'), '# clequ1Ph3x3x1x1'],
	  [3, 3, 1, 2, format(angle(scaled_wc('lequ1_3312')),'.6e'), '# clequ1Ph3x3x1x2'],
	  [3, 3, 1, 3, format(angle(scaled_wc('lequ1_3313')),'.6e'), '# clequ1Ph3x3x1x3'],
	  [3, 3, 2, 1, format(angle(scaled_wc('lequ1_3321')),'.6e'), '# clequ1Ph3x3x2x1'],
	  [3, 3, 2, 2, format(angle(scaled_wc('lequ1_3322')),'.6e'), '# clequ1Ph3x3x2x2'],
	  [3, 3, 2, 3, format(angle(scaled_wc('lequ1_3323')),'.6e'), '# clequ1Ph3x3x2x3'],
	  [3, 3, 3, 1, format(angle(scaled_wc('lequ1_3331')),'.6e'), '# clequ1Ph3x3x3x1'],
	  [3, 3, 3, 2, format(angle(scaled_wc('lequ1_3332')),'.6e'), '# clequ1Ph3x3x3x2'],
	  [3, 3, 3, 3, format(angle(scaled_wc('lequ1_3333')),'.6e'), '# clequ1Ph3x3x3x3'],
      ]}

      card['Block']['FRBlock18'] = {'values': [
	  [1, 1, 1, 1, format(angle(scaled_wc('lequ3_1111')),'.6e'), '# clequ3Ph1x1x1x1'],
	  [1, 1, 1, 2, format(angle(scaled_wc('lequ3_1112')),'.6e'), '# clequ3Ph1x1x1x2'],
	  [1, 1, 1, 3, format(angle(scaled_wc('lequ3_1113')),'.6e'), '# clequ3Ph1x1x1x3'],
	  [1, 1, 2, 1, format(angle(scaled_wc('lequ3_1121')),'.6e'), '# clequ3Ph1x1x2x1'],
	  [1, 1, 2, 2, format(angle(scaled_wc('lequ3_1122')),'.6e'), '# clequ3Ph1x1x2x2'],
	  [1, 1, 2, 3, format(angle(scaled_wc('lequ3_1123')),'.6e'), '# clequ3Ph1x1x2x3'],
	  [1, 1, 3, 1, format(angle(scaled_wc('lequ3_1131')),'.6e'), '# clequ3Ph1x1x3x1'],
	  [1, 1, 3, 2, format(angle(scaled_wc('lequ3_1132')),'.6e'), '# clequ3Ph1x1x3x2'],
	  [1, 1, 3, 3, format(angle(scaled_wc('lequ3_1133')),'.6e'), '# clequ3Ph1x1x3x3'],
	  [1, 2, 1, 1, format(angle(scaled_wc('lequ3_1211')),'.6e'), '# clequ3Ph1x2x1x1'],
	  [1, 2, 1, 2, format(angle(scaled_wc('lequ3_1212')),'.6e'), '# clequ3Ph1x2x1x2'],
	  [1, 2, 1, 3, format(angle(scaled_wc('lequ3_1213')),'.6e'), '# clequ3Ph1x2x1x3'],
	  [1, 2, 2, 1, format(angle(scaled_wc('lequ3_1221')),'.6e'), '# clequ3Ph1x2x2x1'],
	  [1, 2, 2, 2, format(angle(scaled_wc('lequ3_1222')),'.6e'), '# clequ3Ph1x2x2x2'],
	  [1, 2, 2, 3, format(angle(scaled_wc('lequ3_1223')),'.6e'), '# clequ3Ph1x2x2x3'],
	  [1, 2, 3, 1, format(angle(scaled_wc('lequ3_1231')),'.6e'), '# clequ3Ph1x2x3x1'],
	  [1, 2, 3, 2, format(angle(scaled_wc('lequ3_1232')),'.6e'), '# clequ3Ph1x2x3x2'],
	  [1, 2, 3, 3, format(angle(scaled_wc('lequ3_1233')),'.6e'), '# clequ3Ph1x2x3x3'],
	  [1, 3, 1, 1, format(angle(scaled_wc('lequ3_1311')),'.6e'), '# clequ3Ph1x3x1x1'],
	  [1, 3, 1, 2, format(angle(scaled_wc('lequ3_1312')),'.6e'), '# clequ3Ph1x3x1x2'],
	  [1, 3, 1, 3, format(angle(scaled_wc('lequ3_1313')),'.6e'), '# clequ3Ph1x3x1x3'],
	  [1, 3, 2, 1, format(angle(scaled_wc('lequ3_1321')),'.6e'), '# clequ3Ph1x3x2x1'],
	  [1, 3, 2, 2, format(angle(scaled_wc('lequ3_1322')),'.6e'), '# clequ3Ph1x3x2x2'],
	  [1, 3, 2, 3, format(angle(scaled_wc('lequ3_1323')),'.6e'), '# clequ3Ph1x3x2x3'],
	  [1, 3, 3, 1, format(angle(scaled_wc('lequ3_1331')),'.6e'), '# clequ3Ph1x3x3x1'],
	  [1, 3, 3, 2, format(angle(scaled_wc('lequ3_1332')),'.6e'), '# clequ3Ph1x3x3x2'],
	  [1, 3, 3, 3, format(angle(scaled_wc('lequ3_1333')),'.6e'), '# clequ3Ph1x3x3x3'],
	  [2, 1, 1, 1, format(angle(scaled_wc('lequ3_2111')),'.6e'), '# clequ3Ph2x1x1x1'],
	  [2, 1, 1, 2, format(angle(scaled_wc('lequ3_2112')),'.6e'), '# clequ3Ph2x1x1x2'],
	  [2, 1, 1, 3, format(angle(scaled_wc('lequ3_2113')),'.6e'), '# clequ3Ph2x1x1x3'],
	  [2, 1, 2, 1, format(angle(scaled_wc('lequ3_2121')),'.6e'), '# clequ3Ph2x1x2x1'],
	  [2, 1, 2, 2, format(angle(scaled_wc('lequ3_2122')),'.6e'), '# clequ3Ph2x1x2x2'],
	  [2, 1, 2, 3, format(angle(scaled_wc('lequ3_2123')),'.6e'), '# clequ3Ph2x1x2x3'],
	  [2, 1, 3, 1, format(angle(scaled_wc('lequ3_2131')),'.6e'), '# clequ3Ph2x1x3x1'],
	  [2, 1, 3, 2, format(angle(scaled_wc('lequ3_2132')),'.6e'), '# clequ3Ph2x1x3x2'],
	  [2, 1, 3, 3, format(angle(scaled_wc('lequ3_2133')),'.6e'), '# clequ3Ph2x1x3x3'],
	  [2, 2, 1, 1, format(angle(scaled_wc('lequ3_2211')),'.6e'), '# clequ3Ph2x2x1x1'],
	  [2, 2, 1, 2, format(angle(scaled_wc('lequ3_2212')),'.6e'), '# clequ3Ph2x2x1x2'],
	  [2, 2, 1, 3, format(angle(scaled_wc('lequ3_2213')),'.6e'), '# clequ3Ph2x2x1x3'],
	  [2, 2, 2, 1, format(angle(scaled_wc('lequ3_2221')),'.6e'), '# clequ3Ph2x2x2x1'],
	  [2, 2, 2, 2, format(angle(scaled_wc('lequ3_2222')),'.6e'), '# clequ3Ph2x2x2x2'],
	  [2, 2, 2, 3, format(angle(scaled_wc('lequ3_2223')),'.6e'), '# clequ3Ph2x2x2x3'],
	  [2, 2, 3, 1, format(angle(scaled_wc('lequ3_2231')),'.6e'), '# clequ3Ph2x2x3x1'],
	  [2, 2, 3, 2, format(angle(scaled_wc('lequ3_2232')),'.6e'), '# clequ3Ph2x2x3x2'],
	  [2, 2, 3, 3, format(angle(scaled_wc('lequ3_2233')),'.6e'), '# clequ3Ph2x2x3x3'],
	  [2, 3, 1, 1, format(angle(scaled_wc('lequ3_2311')),'.6e'), '# clequ3Ph2x3x1x1'],
	  [2, 3, 1, 2, format(angle(scaled_wc('lequ3_2312')),'.6e'), '# clequ3Ph2x3x1x2'],
	  [2, 3, 1, 3, format(angle(scaled_wc('lequ3_2313')),'.6e'), '# clequ3Ph2x3x1x3'],
	  [2, 3, 2, 1, format(angle(scaled_wc('lequ3_2321')),'.6e'), '# clequ3Ph2x3x2x1'],
	  [2, 3, 2, 2, format(angle(scaled_wc('lequ3_2322')),'.6e'), '# clequ3Ph2x3x2x2'],
	  [2, 3, 2, 3, format(angle(scaled_wc('lequ3_2323')),'.6e'), '# clequ3Ph2x3x2x3'],
	  [2, 3, 3, 1, format(angle(scaled_wc('lequ3_2331')),'.6e'), '# clequ3Ph2x3x3x1'],
	  [2, 3, 3, 2, format(angle(scaled_wc('lequ3_2332')),'.6e'), '# clequ3Ph2x3x3x2'],
	  [2, 3, 3, 3, format(angle(scaled_wc('lequ3_2333')),'.6e'), '# clequ3Ph2x3x3x3'],
	  [3, 1, 1, 1, format(angle(scaled_wc('lequ3_3111')),'.6e'), '# clequ3Ph3x1x1x1'],
	  [3, 1, 1, 2, format(angle(scaled_wc('lequ3_3112')),'.6e'), '# clequ3Ph3x1x1x2'],
	  [3, 1, 1, 3, format(angle(scaled_wc('lequ3_3113')),'.6e'), '# clequ3Ph3x1x1x3'],
	  [3, 1, 2, 1, format(angle(scaled_wc('lequ3_3121')),'.6e'), '# clequ3Ph3x1x2x1'],
	  [3, 1, 2, 2, format(angle(scaled_wc('lequ3_3122')),'.6e'), '# clequ3Ph3x1x2x2'],
	  [3, 1, 2, 3, format(angle(scaled_wc('lequ3_3123')),'.6e'), '# clequ3Ph3x1x2x3'],
	  [3, 1, 3, 1, format(angle(scaled_wc('lequ3_3131')),'.6e'), '# clequ3Ph3x1x3x1'],
	  [3, 1, 3, 2, format(angle(scaled_wc('lequ3_3132')),'.6e'), '# clequ3Ph3x1x3x2'],
	  [3, 1, 3, 3, format(angle(scaled_wc('lequ3_3133')),'.6e'), '# clequ3Ph3x1x3x3'],
	  [3, 2, 1, 1, format(angle(scaled_wc('lequ3_3211')),'.6e'), '# clequ3Ph3x2x1x1'],
	  [3, 2, 1, 2, format(angle(scaled_wc('lequ3_3212')),'.6e'), '# clequ3Ph3x2x1x2'],
	  [3, 2, 1, 3, format(angle(scaled_wc('lequ3_3213')),'.6e'), '# clequ3Ph3x2x1x3'],
	  [3, 2, 2, 1, format(angle(scaled_wc('lequ3_3221')),'.6e'), '# clequ3Ph3x2x2x1'],
	  [3, 2, 2, 2, format(angle(scaled_wc('lequ3_3222')),'.6e'), '# clequ3Ph3x2x2x2'],
	  [3, 2, 2, 3, format(angle(scaled_wc('lequ3_3223')),'.6e'), '# clequ3Ph3x2x2x3'],
	  [3, 2, 3, 1, format(angle(scaled_wc('lequ3_3231')),'.6e'), '# clequ3Ph3x2x3x1'],
	  [3, 2, 3, 2, format(angle(scaled_wc('lequ3_3232')),'.6e'), '# clequ3Ph3x2x3x2'],
	  [3, 2, 3, 3, format(angle(scaled_wc('lequ3_3233')),'.6e'), '# clequ3Ph3x2x3x3'],
	  [3, 3, 1, 1, format(angle(scaled_wc('lequ3_3311')),'.6e'), '# clequ3Ph3x3x1x1'],
	  [3, 3, 1, 2, format(angle(scaled_wc('lequ3_3312')),'.6e'), '# clequ3Ph3x3x1x2'],
	  [3, 3, 1, 3, format(angle(scaled_wc('lequ3_3313')),'.6e'), '# clequ3Ph3x3x1x3'],
	  [3, 3, 2, 1, format(angle(scaled_wc('lequ3_3321')),'.6e'), '# clequ3Ph3x3x2x1'],
	  [3, 3, 2, 2, format(angle(scaled_wc('lequ3_3322')),'.6e'), '# clequ3Ph3x3x2x2'],
	  [3, 3, 2, 3, format(angle(scaled_wc('lequ3_3323')),'.6e'), '# clequ3Ph3x3x2x3'],
	  [3, 3, 3, 1, format(angle(scaled_wc('lequ3_3331')),'.6e'), '# clequ3Ph3x3x3x1'],
	  [3, 3, 3, 2, format(angle(scaled_wc('lequ3_3332')),'.6e'), '# clequ3Ph3x3x3x2'],
	  [3, 3, 3, 3, format(angle(scaled_wc('lequ3_3333')),'.6e'), '# clequ3Ph3x3x3x3'],
      ]}

      card['Block']['FRBlock19'] = {'values': [
	  [1, 1, format(abs(scaled_wc('ephi_11')) * lambda_smeft_value**2,'.6e'), '# ceHAbs1x1'],
	  [1, 2, format(abs(scaled_wc('ephi_12')) * lambda_smeft_value**2,'.6e'), '# ceHAbs1x2'],
	  [1, 3, format(abs(scaled_wc('ephi_13')) * lambda_smeft_value**2,'.6e'), '# ceHAbs1x3'],
	  [2, 1, format(abs(scaled_wc('ephi_21')) * lambda_smeft_value**2,'.6e'), '# ceHAbs2x1'],
	  [2, 2, format(abs(scaled_wc('ephi_22')) * lambda_smeft_value**2,'.6e'), '# ceHAbs2x2'],
	  [2, 3, format(abs(scaled_wc('ephi_23')) * lambda_smeft_value**2,'.6e'), '# ceHAbs2x3'],
	  [3, 1, format(abs(scaled_wc('ephi_31')) * lambda_smeft_value**2,'.6e'), '# ceHAbs3x1'],
	  [3, 2, format(abs(scaled_wc('ephi_32')) * lambda_smeft_value**2,'.6e'), '# ceHAbs3x2'],
	  [3, 3, format(abs(scaled_wc('ephi_33')) * lambda_smeft_value**2,'.6e'), '# ceHAbs3x3'],
      ]}

      card['Block']['FRBlock2'] = {'values': [
	  [1, 1, format(angle(scaled_wc('eW_11')),'.6e'), '# ceWPh1x1'],
	  [1, 2, format(angle(scaled_wc('eW_12')),'.6e'), '# ceWPh1x2'],
	  [1, 3, format(angle(scaled_wc('eW_13')),'.6e'), '# ceWPh1x3'],
	  [2, 1, format(angle(scaled_wc('eW_21')),'.6e'), '# ceWPh2x1'],
	  [2, 2, format(angle(scaled_wc('eW_22')),'.6e'), '# ceWPh2x2'],
	  [2, 3, format(angle(scaled_wc('eW_23')),'.6e'), '# ceWPh2x3'],
	  [3, 1, format(angle(scaled_wc('eW_31')),'.6e'), '# ceWPh3x1'],
	  [3, 2, format(angle(scaled_wc('eW_32')),'.6e'), '# ceWPh3x2'],
	  [3, 3, format(angle(scaled_wc('eW_33')),'.6e'), '# ceWPh3x3'],
      ]}

      card['Block']['FRBlock20'] = {'values': [
	  [1, 1, format(abs(scaled_wc('uphi_11')) * lambda_smeft_value**2,'.6e'), '# cuHAbs1x1'],
	  [1, 2, format(abs(scaled_wc('uphi_12')) * lambda_smeft_value**2,'.6e'), '# cuHAbs1x2'],
	  [1, 3, format(abs(scaled_wc('uphi_13')) * lambda_smeft_value**2,'.6e'), '# cuHAbs1x3'],
	  [2, 1, format(abs(scaled_wc('uphi_21')) * lambda_smeft_value**2,'.6e'), '# cuHAbs2x1'],
	  [2, 2, format(abs(scaled_wc('uphi_22')) * lambda_smeft_value**2,'.6e'), '# cuHAbs2x2'],
	  [2, 3, format(abs(scaled_wc('uphi_23')) * lambda_smeft_value**2,'.6e'), '# cuHAbs2x3'],
	  [3, 1, format(abs(scaled_wc('uphi_31')) * lambda_smeft_value**2,'.6e'), '# cuHAbs3x1'],
	  [3, 2, format(abs(scaled_wc('uphi_32')) * lambda_smeft_value**2,'.6e'), '# cuHAbs3x2'],
	  [3, 3, format(abs(scaled_wc('uphi_33')) * lambda_smeft_value**2,'.6e'), '# cuHAbs3x3'],
      ]}

      card['Block']['FRBlock21'] = {'values': [
	  [1, 1, format(abs(scaled_wc('dphi_11')) * lambda_smeft_value**2,'.6e'), '# cdHAbs1x1'],
	  [1, 2, format(abs(scaled_wc('dphi_12')) * lambda_smeft_value**2,'.6e'), '# cdHAbs1x2'],
	  [1, 3, format(abs(scaled_wc('dphi_13')) * lambda_smeft_value**2,'.6e'), '# cdHAbs1x3'],
	  [2, 1, format(abs(scaled_wc('dphi_21')) * lambda_smeft_value**2,'.6e'), '# cdHAbs2x1'],
	  [2, 2, format(abs(scaled_wc('dphi_22')) * lambda_smeft_value**2,'.6e'), '# cdHAbs2x2'],
	  [2, 3, format(abs(scaled_wc('dphi_23')) * lambda_smeft_value**2,'.6e'), '# cdHAbs2x3'],
	  [3, 1, format(abs(scaled_wc('dphi_31')) * lambda_smeft_value**2,'.6e'), '# cdHAbs3x1'],
	  [3, 2, format(abs(scaled_wc('dphi_32')) * lambda_smeft_value**2,'.6e'), '# cdHAbs3x2'],
	  [3, 3, format(abs(scaled_wc('dphi_33')) * lambda_smeft_value**2,'.6e'), '# cdHAbs3x3'],
      ]}

      card['Block']['FRBlock25'] = {'values': [
	  [1, 1, format(abs(scaled_wc('eW_11')) * lambda_smeft_value**2,'.6e'), '# ceWAbs1x1'],
	  [1, 2, format(abs(scaled_wc('eW_12')) * lambda_smeft_value**2,'.6e'), '# ceWAbs1x2'],
	  [1, 3, format(abs(scaled_wc('eW_13')) * lambda_smeft_value**2,'.6e'), '# ceWAbs1x3'],
	  [2, 1, format(abs(scaled_wc('eW_21')) * lambda_smeft_value**2,'.6e'), '# ceWAbs2x1'],
	  [2, 2, format(abs(scaled_wc('eW_22')) * lambda_smeft_value**2,'.6e'), '# ceWAbs2x2'],
	  [2, 3, format(abs(scaled_wc('eW_23')) * lambda_smeft_value**2,'.6e'), '# ceWAbs2x3'],
	  [3, 1, format(abs(scaled_wc('eW_31')) * lambda_smeft_value**2,'.6e'), '# ceWAbs3x1'],
	  [3, 2, format(abs(scaled_wc('eW_32')) * lambda_smeft_value**2,'.6e'), '# ceWAbs3x2'],
	  [3, 3, format(abs(scaled_wc('eW_33')) * lambda_smeft_value**2,'.6e'), '# ceWAbs3x3'],
      ]}

      card['Block']['FRBlock26'] = {'values': [
	  [1, 1, format(abs(scaled_wc('eB_11')) * lambda_smeft_value**2,'.6e'), '# ceBAbs1x1'],
	  [1, 2, format(abs(scaled_wc('eB_12')) * lambda_smeft_value**2,'.6e'), '# ceBAbs1x2'],
	  [1, 3, format(abs(scaled_wc('eB_13')) * lambda_smeft_value**2,'.6e'), '# ceBAbs1x3'],
	  [2, 1, format(abs(scaled_wc('eB_21')) * lambda_smeft_value**2,'.6e'), '# ceBAbs2x1'],
	  [2, 2, format(abs(scaled_wc('eB_22')) * lambda_smeft_value**2,'.6e'), '# ceBAbs2x2'],
	  [2, 3, format(abs(scaled_wc('eB_23')) * lambda_smeft_value**2,'.6e'), '# ceBAbs2x3'],
	  [3, 1, format(abs(scaled_wc('eB_31')) * lambda_smeft_value**2,'.6e'), '# ceBAbs3x1'],
	  [3, 2, format(abs(scaled_wc('eB_32')) * lambda_smeft_value**2,'.6e'), '# ceBAbs3x2'],
	  [3, 3, format(abs(scaled_wc('eB_33')) * lambda_smeft_value**2,'.6e'), '# ceBAbs3x3'],
      ]}

      card['Block']['FRBlock27'] = {'values': [
	  [1, 1, format(abs(scaled_wc('uG_11')) * lambda_smeft_value**2,'.6e'), '# cuGAbs1x1'],
	  [1, 2, format(abs(scaled_wc('uG_12')) * lambda_smeft_value**2,'.6e'), '# cuGAbs1x2'],
	  [1, 3, format(abs(scaled_wc('uG_13')) * lambda_smeft_value**2,'.6e'), '# cuGAbs1x3'],
	  [2, 1, format(abs(scaled_wc('uG_21')) * lambda_smeft_value**2,'.6e'), '# cuGAbs2x1'],
	  [2, 2, format(abs(scaled_wc('uG_22')) * lambda_smeft_value**2,'.6e'), '# cuGAbs2x2'],
	  [2, 3, format(abs(scaled_wc('uG_23')) * lambda_smeft_value**2,'.6e'), '# cuGAbs2x3'],
	  [3, 1, format(abs(scaled_wc('uG_31')) * lambda_smeft_value**2,'.6e'), '# cuGAbs3x1'],
	  [3, 2, format(abs(scaled_wc('uG_32')) * lambda_smeft_value**2,'.6e'), '# cuGAbs3x2'],
	  [3, 3, format(abs(scaled_wc('uG_33')) * lambda_smeft_value**2,'.6e'), '# cuGAbs3x3'],
      ]}

      card['Block']['FRBlock28'] = {'values': [
	  [1, 1, format(abs(scaled_wc('uW_11')) * lambda_smeft_value**2,'.6e'), '# cuWAbs1x1'],
	  [1, 2, format(abs(scaled_wc('uW_12')) * lambda_smeft_value**2,'.6e'), '# cuWAbs1x2'],
	  [1, 3, format(abs(scaled_wc('uW_13')) * lambda_smeft_value**2,'.6e'), '# cuWAbs1x3'],
	  [2, 1, format(abs(scaled_wc('uW_21')) * lambda_smeft_value**2,'.6e'), '# cuWAbs2x1'],
	  [2, 2, format(abs(scaled_wc('uW_22')) * lambda_smeft_value**2,'.6e'), '# cuWAbs2x2'],
	  [2, 3, format(abs(scaled_wc('uW_23')) * lambda_smeft_value**2,'.6e'), '# cuWAbs2x3'],
	  [3, 1, format(abs(scaled_wc('uW_31')) * lambda_smeft_value**2,'.6e'), '# cuWAbs3x1'],
	  [3, 2, format(abs(scaled_wc('uW_32')) * lambda_smeft_value**2,'.6e'), '# cuWAbs3x2'],
	  [3, 3, format(abs(scaled_wc('uW_33')) * lambda_smeft_value**2,'.6e'), '# cuWAbs3x3'],
      ]}

      card['Block']['FRBlock29'] = {'values': [
	  [1, 1, format(abs(scaled_wc('uB_11')) * lambda_smeft_value**2,'.6e'), '# cuBAbs1x1'],
	  [1, 2, format(abs(scaled_wc('uB_12')) * lambda_smeft_value**2,'.6e'), '# cuBAbs1x2'],
	  [1, 3, format(abs(scaled_wc('uB_13')) * lambda_smeft_value**2,'.6e'), '# cuBAbs1x3'],
	  [2, 1, format(abs(scaled_wc('uB_21')) * lambda_smeft_value**2,'.6e'), '# cuBAbs2x1'],
	  [2, 2, format(abs(scaled_wc('uB_22')) * lambda_smeft_value**2,'.6e'), '# cuBAbs2x2'],
	  [2, 3, format(abs(scaled_wc('uB_23')) * lambda_smeft_value**2,'.6e'), '# cuBAbs2x3'],
	  [3, 1, format(abs(scaled_wc('uB_31')) * lambda_smeft_value**2,'.6e'), '# cuBAbs3x1'],
	  [3, 2, format(abs(scaled_wc('uB_32')) * lambda_smeft_value**2,'.6e'), '# cuBAbs3x2'],
	  [3, 3, format(abs(scaled_wc('uB_33')) * lambda_smeft_value**2,'.6e'), '# cuBAbs3x3'],
      ]}

      card['Block']['FRBlock3'] = {'values': [
	  [1, 1, format(angle(scaled_wc('eB_11')),'.6e'), '# ceBPh1x1'],
	  [1, 2, format(angle(scaled_wc('eB_12')),'.6e'), '# ceBPh1x2'],
	  [1, 3, format(angle(scaled_wc('eB_13')),'.6e'), '# ceBPh1x3'],
	  [2, 1, format(angle(scaled_wc('eB_21')),'.6e'), '# ceBPh2x1'],
	  [2, 2, format(angle(scaled_wc('eB_22')),'.6e'), '# ceBPh2x2'],
	  [2, 3, format(angle(scaled_wc('eB_23')),'.6e'), '# ceBPh2x3'],
	  [3, 1, format(angle(scaled_wc('eB_31')),'.6e'), '# ceBPh3x1'],
	  [3, 2, format(angle(scaled_wc('eB_32')),'.6e'), '# ceBPh3x2'],
	  [3, 3, format(angle(scaled_wc('eB_33')),'.6e'), '# ceBPh3x3'],
      ]}

      card['Block']['FRBlock30'] = {'values': [
	  [1, 1, format(abs(scaled_wc('dG_11')) * lambda_smeft_value**2,'.6e'), '# cdGAbs1x1'],
	  [1, 2, format(abs(scaled_wc('dG_12')) * lambda_smeft_value**2,'.6e'), '# cdGAbs1x2'],
	  [1, 3, format(abs(scaled_wc('dG_13')) * lambda_smeft_value**2,'.6e'), '# cdGAbs1x3'],
	  [2, 1, format(abs(scaled_wc('dG_21')) * lambda_smeft_value**2,'.6e'), '# cdGAbs2x1'],
	  [2, 2, format(abs(scaled_wc('dG_22')) * lambda_smeft_value**2,'.6e'), '# cdGAbs2x2'],
	  [2, 3, format(abs(scaled_wc('dG_23')) * lambda_smeft_value**2,'.6e'), '# cdGAbs2x3'],
	  [3, 1, format(abs(scaled_wc('dG_31')) * lambda_smeft_value**2,'.6e'), '# cdGAbs3x1'],
	  [3, 2, format(abs(scaled_wc('dG_32')) * lambda_smeft_value**2,'.6e'), '# cdGAbs3x2'],
	  [3, 3, format(abs(scaled_wc('dG_33')) * lambda_smeft_value**2,'.6e'), '# cdGAbs3x3'],
      ]}

      card['Block']['FRBlock31'] = {'values': [
	  [1, 1, format(abs(scaled_wc('dW_11')) * lambda_smeft_value**2,'.6e'), '# cdWAbs1x1'],
	  [1, 2, format(abs(scaled_wc('dW_12')) * lambda_smeft_value**2,'.6e'), '# cdWAbs1x2'],
	  [1, 3, format(abs(scaled_wc('dW_13')) * lambda_smeft_value**2,'.6e'), '# cdWAbs1x3'],
	  [2, 1, format(abs(scaled_wc('dW_21')) * lambda_smeft_value**2,'.6e'), '# cdWAbs2x1'],
	  [2, 2, format(abs(scaled_wc('dW_22')) * lambda_smeft_value**2,'.6e'), '# cdWAbs2x2'],
	  [2, 3, format(abs(scaled_wc('dW_23')) * lambda_smeft_value**2,'.6e'), '# cdWAbs2x3'],
	  [3, 1, format(abs(scaled_wc('dW_31')) * lambda_smeft_value**2,'.6e'), '# cdWAbs3x1'],
	  [3, 2, format(abs(scaled_wc('dW_32')) * lambda_smeft_value**2,'.6e'), '# cdWAbs3x2'],
	  [3, 3, format(abs(scaled_wc('dW_33')) * lambda_smeft_value**2,'.6e'), '# cdWAbs3x3'],
      ]}

      card['Block']['FRBlock32'] = {'values': [
	  [1, 1, format(abs(scaled_wc('dB_11')) * lambda_smeft_value**2,'.6e'), '# cdBAbs1x1'],
	  [1, 2, format(abs(scaled_wc('dB_12')) * lambda_smeft_value**2,'.6e'), '# cdBAbs1x2'],
	  [1, 3, format(abs(scaled_wc('dB_13')) * lambda_smeft_value**2,'.6e'), '# cdBAbs1x3'],
	  [2, 1, format(abs(scaled_wc('dB_21')) * lambda_smeft_value**2,'.6e'), '# cdBAbs2x1'],
	  [2, 2, format(abs(scaled_wc('dB_22')) * lambda_smeft_value**2,'.6e'), '# cdBAbs2x2'],
	  [2, 3, format(abs(scaled_wc('dB_23')) * lambda_smeft_value**2,'.6e'), '# cdBAbs2x3'],
	  [3, 1, format(abs(scaled_wc('dB_31')) * lambda_smeft_value**2,'.6e'), '# cdBAbs3x1'],
	  [3, 2, format(abs(scaled_wc('dB_32')) * lambda_smeft_value**2,'.6e'), '# cdBAbs3x2'],
	  [3, 3, format(abs(scaled_wc('dB_33')) * lambda_smeft_value**2,'.6e'), '# cdBAbs3x3'],
      ]}

      card['Block']['FRBlock4'] = {'values': [
	  [1, 1, format(angle(scaled_wc('uG_11')),'.6e'), '# cuGPh1x1'],
	  [1, 2, format(angle(scaled_wc('uG_12')),'.6e'), '# cuGPh1x2'],
	  [1, 3, format(angle(scaled_wc('uG_13')),'.6e'), '# cuGPh1x3'],
	  [2, 1, format(angle(scaled_wc('uG_21')),'.6e'), '# cuGPh2x1'],
	  [2, 2, format(angle(scaled_wc('uG_22')),'.6e'), '# cuGPh2x2'],
	  [2, 3, format(angle(scaled_wc('uG_23')),'.6e'), '# cuGPh2x3'],
	  [3, 1, format(angle(scaled_wc('uG_31')),'.6e'), '# cuGPh3x1'],
	  [3, 2, format(angle(scaled_wc('uG_32')),'.6e'), '# cuGPh3x2'],
	  [3, 3, format(angle(scaled_wc('uG_33')),'.6e'), '# cuGPh3x3'],
      ]}

      card['Block']['FRBlock48'] = {'values': [
	  [1, 1, format(abs(scaled_wc('phiud_11')) * lambda_smeft_value**2,'.6e'), '# cHudAbs1x1'],
	  [1, 2, format(abs(scaled_wc('phiud_12')) * lambda_smeft_value**2,'.6e'), '# cHudAbs1x2'],
	  [1, 3, format(abs(scaled_wc('phiud_13')) * lambda_smeft_value**2,'.6e'), '# cHudAbs1x3'],
	  [2, 1, format(abs(scaled_wc('phiud_21')) * lambda_smeft_value**2,'.6e'), '# cHudAbs2x1'],
	  [2, 2, format(abs(scaled_wc('phiud_22')) * lambda_smeft_value**2,'.6e'), '# cHudAbs2x2'],
	  [2, 3, format(abs(scaled_wc('phiud_23')) * lambda_smeft_value**2,'.6e'), '# cHudAbs2x3'],
	  [3, 1, format(abs(scaled_wc('phiud_31')) * lambda_smeft_value**2,'.6e'), '# cHudAbs3x1'],
	  [3, 2, format(abs(scaled_wc('phiud_32')) * lambda_smeft_value**2,'.6e'), '# cHudAbs3x2'],
	  [3, 3, format(abs(scaled_wc('phiud_33')) * lambda_smeft_value**2,'.6e'), '# cHudAbs3x3'],
      ]}

      card['Block']['FRBlock5'] = {'values': [
	  [1, 1, format(angle(scaled_wc('uW_11')),'.6e'), '# cuWPh1x1'],
	  [1, 2, format(angle(scaled_wc('uW_12')),'.6e'), '# cuWPh1x2'],
	  [1, 3, format(angle(scaled_wc('uW_13')),'.6e'), '# cuWPh1x3'],
	  [2, 1, format(angle(scaled_wc('uW_21')),'.6e'), '# cuWPh2x1'],
	  [2, 2, format(angle(scaled_wc('uW_22')),'.6e'), '# cuWPh2x2'],
	  [2, 3, format(angle(scaled_wc('uW_23')),'.6e'), '# cuWPh2x3'],
	  [3, 1, format(angle(scaled_wc('uW_31')),'.6e'), '# cuWPh3x1'],
	  [3, 2, format(angle(scaled_wc('uW_32')),'.6e'), '# cuWPh3x2'],
	  [3, 3, format(angle(scaled_wc('uW_33')),'.6e'), '# cuWPh3x3'],
      ]}

      card['Block']['FRBlock6'] = {'values': [
	  [1, 1, format(angle(scaled_wc('uB_11')),'.6e'), '# cuBPh1x1'],
	  [1, 2, format(angle(scaled_wc('uB_12')),'.6e'), '# cuBPh1x2'],
	  [1, 3, format(angle(scaled_wc('uB_13')),'.6e'), '# cuBPh1x3'],
	  [2, 1, format(angle(scaled_wc('uB_21')),'.6e'), '# cuBPh2x1'],
	  [2, 2, format(angle(scaled_wc('uB_22')),'.6e'), '# cuBPh2x2'],
	  [2, 3, format(angle(scaled_wc('uB_23')),'.6e'), '# cuBPh2x3'],
	  [3, 1, format(angle(scaled_wc('uB_31')),'.6e'), '# cuBPh3x1'],
	  [3, 2, format(angle(scaled_wc('uB_32')),'.6e'), '# cuBPh3x2'],
	  [3, 3, format(angle(scaled_wc('uB_33')),'.6e'), '# cuBPh3x3'],
      ]}

      card['Block']['FRBlock7'] = {'values': [
	  [1, 1, format(angle(scaled_wc('dG_11')),'.6e'), '# cdGPh1x1'],
	  [1, 2, format(angle(scaled_wc('dG_12')),'.6e'), '# cdGPh1x2'],
	  [1, 3, format(angle(scaled_wc('dG_13')),'.6e'), '# cdGPh1x3'],
	  [2, 1, format(angle(scaled_wc('dG_21')),'.6e'), '# cdGPh2x1'],
	  [2, 2, format(angle(scaled_wc('dG_22')),'.6e'), '# cdGPh2x2'],
	  [2, 3, format(angle(scaled_wc('dG_23')),'.6e'), '# cdGPh2x3'],
	  [3, 1, format(angle(scaled_wc('dG_31')),'.6e'), '# cdGPh3x1'],
	  [3, 2, format(angle(scaled_wc('dG_32')),'.6e'), '# cdGPh3x2'],
	  [3, 3, format(angle(scaled_wc('dG_33')),'.6e'), '# cdGPh3x3'],
      ]}

      card['Block']['FRBlock70'] = {'values': [
	  [1, 1, 1, 1, format(abs(scaled_wc('ledq_1111')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x1x1x1'],
	  [1, 1, 1, 2, format(abs(scaled_wc('ledq_1112')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x1x1x2'],
	  [1, 1, 1, 3, format(abs(scaled_wc('ledq_1113')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x1x1x3'],
	  [1, 1, 2, 1, format(abs(scaled_wc('ledq_1121')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x1x2x1'],
	  [1, 1, 2, 2, format(abs(scaled_wc('ledq_1122')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x1x2x2'],
	  [1, 1, 2, 3, format(abs(scaled_wc('ledq_1123')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x1x2x3'],
	  [1, 1, 3, 1, format(abs(scaled_wc('ledq_1131')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x1x3x1'],
	  [1, 1, 3, 2, format(abs(scaled_wc('ledq_1132')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x1x3x2'],
	  [1, 1, 3, 3, format(abs(scaled_wc('ledq_1133')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x1x3x3'],
	  [1, 2, 1, 1, format(abs(scaled_wc('ledq_1211')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x2x1x1'],
	  [1, 2, 1, 2, format(abs(scaled_wc('ledq_1212')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x2x1x2'],
	  [1, 2, 1, 3, format(abs(scaled_wc('ledq_1213')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x2x1x3'],
	  [1, 2, 2, 1, format(abs(scaled_wc('ledq_1221')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x2x2x1'],
	  [1, 2, 2, 2, format(abs(scaled_wc('ledq_1222')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x2x2x2'],
	  [1, 2, 2, 3, format(abs(scaled_wc('ledq_1223')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x2x2x3'],
	  [1, 2, 3, 1, format(abs(scaled_wc('ledq_1231')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x2x3x1'],
	  [1, 2, 3, 2, format(abs(scaled_wc('ledq_1232')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x2x3x2'],
	  [1, 2, 3, 3, format(abs(scaled_wc('ledq_1233')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x2x3x3'],
	  [1, 3, 1, 1, format(abs(scaled_wc('ledq_1311')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x3x1x1'],
	  [1, 3, 1, 2, format(abs(scaled_wc('ledq_1312')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x3x1x2'],
	  [1, 3, 1, 3, format(abs(scaled_wc('ledq_1313')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x3x1x3'],
	  [1, 3, 2, 1, format(abs(scaled_wc('ledq_1321')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x3x2x1'],
	  [1, 3, 2, 2, format(abs(scaled_wc('ledq_1322')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x3x2x2'],
	  [1, 3, 2, 3, format(abs(scaled_wc('ledq_1323')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x3x2x3'],
	  [1, 3, 3, 1, format(abs(scaled_wc('ledq_1331')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x3x3x1'],
	  [1, 3, 3, 2, format(abs(scaled_wc('ledq_1332')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x3x3x2'],
	  [1, 3, 3, 3, format(abs(scaled_wc('ledq_1333')) * lambda_smeft_value**2,'.6e'), '# cledqAbs1x3x3x3'],
	  [2, 1, 1, 1, format(abs(scaled_wc('ledq_2111')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x1x1x1'],
	  [2, 1, 1, 2, format(abs(scaled_wc('ledq_2112')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x1x1x2'],
	  [2, 1, 1, 3, format(abs(scaled_wc('ledq_2113')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x1x1x3'],
	  [2, 1, 2, 1, format(abs(scaled_wc('ledq_2121')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x1x2x1'],
	  [2, 1, 2, 2, format(abs(scaled_wc('ledq_2122')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x1x2x2'],
	  [2, 1, 2, 3, format(abs(scaled_wc('ledq_2123')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x1x2x3'],
	  [2, 1, 3, 1, format(abs(scaled_wc('ledq_2131')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x1x3x1'],
	  [2, 1, 3, 2, format(abs(scaled_wc('ledq_2132')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x1x3x2'],
	  [2, 1, 3, 3, format(abs(scaled_wc('ledq_2133')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x1x3x3'],
	  [2, 2, 1, 1, format(abs(scaled_wc('ledq_2211')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x2x1x1'],
	  [2, 2, 1, 2, format(abs(scaled_wc('ledq_2212')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x2x1x2'],
	  [2, 2, 1, 3, format(abs(scaled_wc('ledq_2213')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x2x1x3'],
	  [2, 2, 2, 1, format(abs(scaled_wc('ledq_2221')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x2x2x1'],
	  [2, 2, 2, 2, format(abs(scaled_wc('ledq_2222')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x2x2x2'],
	  [2, 2, 2, 3, format(abs(scaled_wc('ledq_2223')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x2x2x3'],
	  [2, 2, 3, 1, format(abs(scaled_wc('ledq_2231')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x2x3x1'],
	  [2, 2, 3, 2, format(abs(scaled_wc('ledq_2232')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x2x3x2'],
	  [2, 2, 3, 3, format(abs(scaled_wc('ledq_2233')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x2x3x3'],
	  [2, 3, 1, 1, format(abs(scaled_wc('ledq_2311')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x3x1x1'],
	  [2, 3, 1, 2, format(abs(scaled_wc('ledq_2312')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x3x1x2'],
	  [2, 3, 1, 3, format(abs(scaled_wc('ledq_2313')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x3x1x3'],
	  [2, 3, 2, 1, format(abs(scaled_wc('ledq_2321')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x3x2x1'],
	  [2, 3, 2, 2, format(abs(scaled_wc('ledq_2322')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x3x2x2'],
	  [2, 3, 2, 3, format(abs(scaled_wc('ledq_2323')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x3x2x3'],
	  [2, 3, 3, 1, format(abs(scaled_wc('ledq_2331')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x3x3x1'],
	  [2, 3, 3, 2, format(abs(scaled_wc('ledq_2332')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x3x3x2'],
	  [2, 3, 3, 3, format(abs(scaled_wc('ledq_2333')) * lambda_smeft_value**2,'.6e'), '# cledqAbs2x3x3x3'],
	  [3, 1, 1, 1, format(abs(scaled_wc('ledq_3111')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x1x1x1'],
	  [3, 1, 1, 2, format(abs(scaled_wc('ledq_3112')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x1x1x2'],
	  [3, 1, 1, 3, format(abs(scaled_wc('ledq_3113')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x1x1x3'],
	  [3, 1, 2, 1, format(abs(scaled_wc('ledq_3121')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x1x2x1'],
	  [3, 1, 2, 2, format(abs(scaled_wc('ledq_3122')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x1x2x2'],
	  [3, 1, 2, 3, format(abs(scaled_wc('ledq_3123')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x1x2x3'],
	  [3, 1, 3, 1, format(abs(scaled_wc('ledq_3131')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x1x3x1'],
	  [3, 1, 3, 2, format(abs(scaled_wc('ledq_3132')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x1x3x2'],
	  [3, 1, 3, 3, format(abs(scaled_wc('ledq_3133')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x1x3x3'],
	  [3, 2, 1, 1, format(abs(scaled_wc('ledq_3211')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x2x1x1'],
	  [3, 2, 1, 2, format(abs(scaled_wc('ledq_3212')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x2x1x2'],
	  [3, 2, 1, 3, format(abs(scaled_wc('ledq_3213')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x2x1x3'],
	  [3, 2, 2, 1, format(abs(scaled_wc('ledq_3221')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x2x2x1'],
	  [3, 2, 2, 2, format(abs(scaled_wc('ledq_3222')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x2x2x2'],
	  [3, 2, 2, 3, format(abs(scaled_wc('ledq_3223')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x2x2x3'],
	  [3, 2, 3, 1, format(abs(scaled_wc('ledq_3231')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x2x3x1'],
	  [3, 2, 3, 2, format(abs(scaled_wc('ledq_3232')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x2x3x2'],
	  [3, 2, 3, 3, format(abs(scaled_wc('ledq_3233')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x2x3x3'],
	  [3, 3, 1, 1, format(abs(scaled_wc('ledq_3311')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x3x1x1'],
	  [3, 3, 1, 2, format(abs(scaled_wc('ledq_3312')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x3x1x2'],
	  [3, 3, 1, 3, format(abs(scaled_wc('ledq_3313')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x3x1x3'],
	  [3, 3, 2, 1, format(abs(scaled_wc('ledq_3321')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x3x2x1'],
	  [3, 3, 2, 2, format(abs(scaled_wc('ledq_3322')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x3x2x2'],
	  [3, 3, 2, 3, format(abs(scaled_wc('ledq_3323')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x3x2x3'],
	  [3, 3, 3, 1, format(abs(scaled_wc('ledq_3331')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x3x3x1'],
	  [3, 3, 3, 2, format(abs(scaled_wc('ledq_3332')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x3x3x2'],
	  [3, 3, 3, 3, format(abs(scaled_wc('ledq_3333')) * lambda_smeft_value**2,'.6e'), '# cledqAbs3x3x3x3'],
      ]}

      card['Block']['FRBlock71'] = {'values': [
	  [1, 1, 1, 1, format(abs(scaled_wc('quqd1_1111')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x1x1x1'],
	  [1, 1, 1, 2, format(abs(scaled_wc('quqd1_1112')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x1x1x2'],
	  [1, 1, 1, 3, format(abs(scaled_wc('quqd1_1113')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x1x1x3'],
	  [1, 1, 2, 1, format(abs(scaled_wc('quqd1_1121')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x1x2x1'],
	  [1, 1, 2, 2, format(abs(scaled_wc('quqd1_1122')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x1x2x2'],
	  [1, 1, 2, 3, format(abs(scaled_wc('quqd1_1123')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x1x2x3'],
	  [1, 1, 3, 1, format(abs(scaled_wc('quqd1_1131')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x1x3x1'],
	  [1, 1, 3, 2, format(abs(scaled_wc('quqd1_1132')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x1x3x2'],
	  [1, 1, 3, 3, format(abs(scaled_wc('quqd1_1133')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x1x3x3'],
	  [1, 2, 1, 1, format(abs(scaled_wc('quqd1_1211')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x2x1x1'],
	  [1, 2, 1, 2, format(abs(scaled_wc('quqd1_1212')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x2x1x2'],
	  [1, 2, 1, 3, format(abs(scaled_wc('quqd1_1213')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x2x1x3'],
	  [1, 2, 2, 1, format(abs(scaled_wc('quqd1_1221')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x2x2x1'],
	  [1, 2, 2, 2, format(abs(scaled_wc('quqd1_1222')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x2x2x2'],
	  [1, 2, 2, 3, format(abs(scaled_wc('quqd1_1223')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x2x2x3'],
	  [1, 2, 3, 1, format(abs(scaled_wc('quqd1_1231')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x2x3x1'],
	  [1, 2, 3, 2, format(abs(scaled_wc('quqd1_1232')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x2x3x2'],
	  [1, 2, 3, 3, format(abs(scaled_wc('quqd1_1233')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x2x3x3'],
	  [1, 3, 1, 1, format(abs(scaled_wc('quqd1_1311')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x3x1x1'],
	  [1, 3, 1, 2, format(abs(scaled_wc('quqd1_1312')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x3x1x2'],
	  [1, 3, 1, 3, format(abs(scaled_wc('quqd1_1313')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x3x1x3'],
	  [1, 3, 2, 1, format(abs(scaled_wc('quqd1_1321')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x3x2x1'],
	  [1, 3, 2, 2, format(abs(scaled_wc('quqd1_1322')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x3x2x2'],
	  [1, 3, 2, 3, format(abs(scaled_wc('quqd1_1323')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x3x2x3'],
	  [1, 3, 3, 1, format(abs(scaled_wc('quqd1_1331')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x3x3x1'],
	  [1, 3, 3, 2, format(abs(scaled_wc('quqd1_1332')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x3x3x2'],
	  [1, 3, 3, 3, format(abs(scaled_wc('quqd1_1333')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs1x3x3x3'],
	  [2, 1, 1, 1, format(abs(scaled_wc('quqd1_2111')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x1x1x1'],
	  [2, 1, 1, 2, format(abs(scaled_wc('quqd1_2112')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x1x1x2'],
	  [2, 1, 1, 3, format(abs(scaled_wc('quqd1_2113')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x1x1x3'],
	  [2, 1, 2, 1, format(abs(scaled_wc('quqd1_2121')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x1x2x1'],
	  [2, 1, 2, 2, format(abs(scaled_wc('quqd1_2122')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x1x2x2'],
	  [2, 1, 2, 3, format(abs(scaled_wc('quqd1_2123')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x1x2x3'],
	  [2, 1, 3, 1, format(abs(scaled_wc('quqd1_2131')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x1x3x1'],
	  [2, 1, 3, 2, format(abs(scaled_wc('quqd1_2132')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x1x3x2'],
	  [2, 1, 3, 3, format(abs(scaled_wc('quqd1_2133')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x1x3x3'],
	  [2, 2, 1, 1, format(abs(scaled_wc('quqd1_2211')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x2x1x1'],
	  [2, 2, 1, 2, format(abs(scaled_wc('quqd1_2212')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x2x1x2'],
	  [2, 2, 1, 3, format(abs(scaled_wc('quqd1_2213')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x2x1x3'],
	  [2, 2, 2, 1, format(abs(scaled_wc('quqd1_2221')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x2x2x1'],
	  [2, 2, 2, 2, format(abs(scaled_wc('quqd1_2222')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x2x2x2'],
	  [2, 2, 2, 3, format(abs(scaled_wc('quqd1_2223')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x2x2x3'],
	  [2, 2, 3, 1, format(abs(scaled_wc('quqd1_2231')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x2x3x1'],
	  [2, 2, 3, 2, format(abs(scaled_wc('quqd1_2232')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x2x3x2'],
	  [2, 2, 3, 3, format(abs(scaled_wc('quqd1_2233')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x2x3x3'],
	  [2, 3, 1, 1, format(abs(scaled_wc('quqd1_2311')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x3x1x1'],
	  [2, 3, 1, 2, format(abs(scaled_wc('quqd1_2312')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x3x1x2'],
	  [2, 3, 1, 3, format(abs(scaled_wc('quqd1_2313')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x3x1x3'],
	  [2, 3, 2, 1, format(abs(scaled_wc('quqd1_2321')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x3x2x1'],
	  [2, 3, 2, 2, format(abs(scaled_wc('quqd1_2322')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x3x2x2'],
	  [2, 3, 2, 3, format(abs(scaled_wc('quqd1_2323')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x3x2x3'],
	  [2, 3, 3, 1, format(abs(scaled_wc('quqd1_2331')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x3x3x1'],
	  [2, 3, 3, 2, format(abs(scaled_wc('quqd1_2332')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x3x3x2'],
	  [2, 3, 3, 3, format(abs(scaled_wc('quqd1_2333')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs2x3x3x3'],
	  [3, 1, 1, 1, format(abs(scaled_wc('quqd1_3111')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x1x1x1'],
	  [3, 1, 1, 2, format(abs(scaled_wc('quqd1_3112')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x1x1x2'],
	  [3, 1, 1, 3, format(abs(scaled_wc('quqd1_3113')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x1x1x3'],
	  [3, 1, 2, 1, format(abs(scaled_wc('quqd1_3121')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x1x2x1'],
	  [3, 1, 2, 2, format(abs(scaled_wc('quqd1_3122')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x1x2x2'],
	  [3, 1, 2, 3, format(abs(scaled_wc('quqd1_3123')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x1x2x3'],
	  [3, 1, 3, 1, format(abs(scaled_wc('quqd1_3131')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x1x3x1'],
	  [3, 1, 3, 2, format(abs(scaled_wc('quqd1_3132')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x1x3x2'],
	  [3, 1, 3, 3, format(abs(scaled_wc('quqd1_3133')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x1x3x3'],
	  [3, 2, 1, 1, format(abs(scaled_wc('quqd1_3211')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x2x1x1'],
	  [3, 2, 1, 2, format(abs(scaled_wc('quqd1_3212')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x2x1x2'],
	  [3, 2, 1, 3, format(abs(scaled_wc('quqd1_3213')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x2x1x3'],
	  [3, 2, 2, 1, format(abs(scaled_wc('quqd1_3221')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x2x2x1'],
	  [3, 2, 2, 2, format(abs(scaled_wc('quqd1_3222')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x2x2x2'],
	  [3, 2, 2, 3, format(abs(scaled_wc('quqd1_3223')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x2x2x3'],
	  [3, 2, 3, 1, format(abs(scaled_wc('quqd1_3231')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x2x3x1'],
	  [3, 2, 3, 2, format(abs(scaled_wc('quqd1_3232')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x2x3x2'],
	  [3, 2, 3, 3, format(abs(scaled_wc('quqd1_3233')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x2x3x3'],
	  [3, 3, 1, 1, format(abs(scaled_wc('quqd1_3311')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x3x1x1'],
	  [3, 3, 1, 2, format(abs(scaled_wc('quqd1_3312')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x3x1x2'],
	  [3, 3, 1, 3, format(abs(scaled_wc('quqd1_3313')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x3x1x3'],
	  [3, 3, 2, 1, format(abs(scaled_wc('quqd1_3321')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x3x2x1'],
	  [3, 3, 2, 2, format(abs(scaled_wc('quqd1_3322')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x3x2x2'],
	  [3, 3, 2, 3, format(abs(scaled_wc('quqd1_3323')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x3x2x3'],
	  [3, 3, 3, 1, format(abs(scaled_wc('quqd1_3331')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x3x3x1'],
	  [3, 3, 3, 2, format(abs(scaled_wc('quqd1_3332')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x3x3x2'],
	  [3, 3, 3, 3, format(abs(scaled_wc('quqd1_3333')) * lambda_smeft_value**2,'.6e'), '# cquqd1Abs3x3x3x3'],
      ]}

      card['Block']['FRBlock72'] = {'values': [
	  [1, 1, 1, 1, format(abs(scaled_wc('quqd8_1111')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x1x1x1'],
	  [1, 1, 1, 2, format(abs(scaled_wc('quqd8_1112')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x1x1x2'],
	  [1, 1, 1, 3, format(abs(scaled_wc('quqd8_1113')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x1x1x3'],
	  [1, 1, 2, 1, format(abs(scaled_wc('quqd8_1121')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x1x2x1'],
	  [1, 1, 2, 2, format(abs(scaled_wc('quqd8_1122')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x1x2x2'],
	  [1, 1, 2, 3, format(abs(scaled_wc('quqd8_1123')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x1x2x3'],
	  [1, 1, 3, 1, format(abs(scaled_wc('quqd8_1131')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x1x3x1'],
	  [1, 1, 3, 2, format(abs(scaled_wc('quqd8_1132')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x1x3x2'],
	  [1, 1, 3, 3, format(abs(scaled_wc('quqd8_1133')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x1x3x3'],
	  [1, 2, 1, 1, format(abs(scaled_wc('quqd8_1211')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x2x1x1'],
	  [1, 2, 1, 2, format(abs(scaled_wc('quqd8_1212')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x2x1x2'],
	  [1, 2, 1, 3, format(abs(scaled_wc('quqd8_1213')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x2x1x3'],
	  [1, 2, 2, 1, format(abs(scaled_wc('quqd8_1221')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x2x2x1'],
	  [1, 2, 2, 2, format(abs(scaled_wc('quqd8_1222')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x2x2x2'],
	  [1, 2, 2, 3, format(abs(scaled_wc('quqd8_1223')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x2x2x3'],
	  [1, 2, 3, 1, format(abs(scaled_wc('quqd8_1231')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x2x3x1'],
	  [1, 2, 3, 2, format(abs(scaled_wc('quqd8_1232')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x2x3x2'],
	  [1, 2, 3, 3, format(abs(scaled_wc('quqd8_1233')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x2x3x3'],
	  [1, 3, 1, 1, format(abs(scaled_wc('quqd8_1311')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x3x1x1'],
	  [1, 3, 1, 2, format(abs(scaled_wc('quqd8_1312')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x3x1x2'],
	  [1, 3, 1, 3, format(abs(scaled_wc('quqd8_1313')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x3x1x3'],
	  [1, 3, 2, 1, format(abs(scaled_wc('quqd8_1321')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x3x2x1'],
	  [1, 3, 2, 2, format(abs(scaled_wc('quqd8_1322')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x3x2x2'],
	  [1, 3, 2, 3, format(abs(scaled_wc('quqd8_1323')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x3x2x3'],
	  [1, 3, 3, 1, format(abs(scaled_wc('quqd8_1331')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x3x3x1'],
	  [1, 3, 3, 2, format(abs(scaled_wc('quqd8_1332')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x3x3x2'],
	  [1, 3, 3, 3, format(abs(scaled_wc('quqd8_1333')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs1x3x3x3'],
	  [2, 1, 1, 1, format(abs(scaled_wc('quqd8_2111')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x1x1x1'],
	  [2, 1, 1, 2, format(abs(scaled_wc('quqd8_2112')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x1x1x2'],
	  [2, 1, 1, 3, format(abs(scaled_wc('quqd8_2113')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x1x1x3'],
	  [2, 1, 2, 1, format(abs(scaled_wc('quqd8_2121')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x1x2x1'],
	  [2, 1, 2, 2, format(abs(scaled_wc('quqd8_2122')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x1x2x2'],
	  [2, 1, 2, 3, format(abs(scaled_wc('quqd8_2123')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x1x2x3'],
	  [2, 1, 3, 1, format(abs(scaled_wc('quqd8_2131')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x1x3x1'],
	  [2, 1, 3, 2, format(abs(scaled_wc('quqd8_2132')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x1x3x2'],
	  [2, 1, 3, 3, format(abs(scaled_wc('quqd8_2133')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x1x3x3'],
	  [2, 2, 1, 1, format(abs(scaled_wc('quqd8_2211')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x2x1x1'],
	  [2, 2, 1, 2, format(abs(scaled_wc('quqd8_2212')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x2x1x2'],
	  [2, 2, 1, 3, format(abs(scaled_wc('quqd8_2213')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x2x1x3'],
	  [2, 2, 2, 1, format(abs(scaled_wc('quqd8_2221')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x2x2x1'],
	  [2, 2, 2, 2, format(abs(scaled_wc('quqd8_2222')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x2x2x2'],
	  [2, 2, 2, 3, format(abs(scaled_wc('quqd8_2223')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x2x2x3'],
	  [2, 2, 3, 1, format(abs(scaled_wc('quqd8_2231')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x2x3x1'],
	  [2, 2, 3, 2, format(abs(scaled_wc('quqd8_2232')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x2x3x2'],
	  [2, 2, 3, 3, format(abs(scaled_wc('quqd8_2233')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x2x3x3'],
	  [2, 3, 1, 1, format(abs(scaled_wc('quqd8_2311')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x3x1x1'],
	  [2, 3, 1, 2, format(abs(scaled_wc('quqd8_2312')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x3x1x2'],
	  [2, 3, 1, 3, format(abs(scaled_wc('quqd8_2313')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x3x1x3'],
	  [2, 3, 2, 1, format(abs(scaled_wc('quqd8_2321')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x3x2x1'],
	  [2, 3, 2, 2, format(abs(scaled_wc('quqd8_2322')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x3x2x2'],
	  [2, 3, 2, 3, format(abs(scaled_wc('quqd8_2323')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x3x2x3'],
	  [2, 3, 3, 1, format(abs(scaled_wc('quqd8_2331')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x3x3x1'],
	  [2, 3, 3, 2, format(abs(scaled_wc('quqd8_2332')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x3x3x2'],
	  [2, 3, 3, 3, format(abs(scaled_wc('quqd8_2333')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs2x3x3x3'],
	  [3, 1, 1, 1, format(abs(scaled_wc('quqd8_3111')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x1x1x1'],
	  [3, 1, 1, 2, format(abs(scaled_wc('quqd8_3112')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x1x1x2'],
	  [3, 1, 1, 3, format(abs(scaled_wc('quqd8_3113')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x1x1x3'],
	  [3, 1, 2, 1, format(abs(scaled_wc('quqd8_3121')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x1x2x1'],
	  [3, 1, 2, 2, format(abs(scaled_wc('quqd8_3122')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x1x2x2'],
	  [3, 1, 2, 3, format(abs(scaled_wc('quqd8_3123')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x1x2x3'],
	  [3, 1, 3, 1, format(abs(scaled_wc('quqd8_3131')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x1x3x1'],
	  [3, 1, 3, 2, format(abs(scaled_wc('quqd8_3132')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x1x3x2'],
	  [3, 1, 3, 3, format(abs(scaled_wc('quqd8_3133')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x1x3x3'],
	  [3, 2, 1, 1, format(abs(scaled_wc('quqd8_3211')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x2x1x1'],
	  [3, 2, 1, 2, format(abs(scaled_wc('quqd8_3212')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x2x1x2'],
	  [3, 2, 1, 3, format(abs(scaled_wc('quqd8_3213')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x2x1x3'],
	  [3, 2, 2, 1, format(abs(scaled_wc('quqd8_3221')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x2x2x1'],
	  [3, 2, 2, 2, format(abs(scaled_wc('quqd8_3222')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x2x2x2'],
	  [3, 2, 2, 3, format(abs(scaled_wc('quqd8_3223')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x2x2x3'],
	  [3, 2, 3, 1, format(abs(scaled_wc('quqd8_3231')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x2x3x1'],
	  [3, 2, 3, 2, format(abs(scaled_wc('quqd8_3232')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x2x3x2'],
	  [3, 2, 3, 3, format(abs(scaled_wc('quqd8_3233')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x2x3x3'],
	  [3, 3, 1, 1, format(abs(scaled_wc('quqd8_3311')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x3x1x1'],
	  [3, 3, 1, 2, format(abs(scaled_wc('quqd8_3312')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x3x1x2'],
	  [3, 3, 1, 3, format(abs(scaled_wc('quqd8_3313')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x3x1x3'],
	  [3, 3, 2, 1, format(abs(scaled_wc('quqd8_3321')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x3x2x1'],
	  [3, 3, 2, 2, format(abs(scaled_wc('quqd8_3322')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x3x2x2'],
	  [3, 3, 2, 3, format(abs(scaled_wc('quqd8_3323')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x3x2x3'],
	  [3, 3, 3, 1, format(abs(scaled_wc('quqd8_3331')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x3x3x1'],
	  [3, 3, 3, 2, format(abs(scaled_wc('quqd8_3332')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x3x3x2'],
	  [3, 3, 3, 3, format(abs(scaled_wc('quqd8_3333')) * lambda_smeft_value**2,'.6e'), '# cquqd8Abs3x3x3x3'],
      ]}

      card['Block']['FRBlock73'] = {'values': [
	  [1, 1, 1, 1, format(abs(scaled_wc('lequ1_1111')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x1x1x1'],
	  [1, 1, 1, 2, format(abs(scaled_wc('lequ1_1112')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x1x1x2'],
	  [1, 1, 1, 3, format(abs(scaled_wc('lequ1_1113')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x1x1x3'],
	  [1, 1, 2, 1, format(abs(scaled_wc('lequ1_1121')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x1x2x1'],
	  [1, 1, 2, 2, format(abs(scaled_wc('lequ1_1122')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x1x2x2'],
	  [1, 1, 2, 3, format(abs(scaled_wc('lequ1_1123')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x1x2x3'],
	  [1, 1, 3, 1, format(abs(scaled_wc('lequ1_1131')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x1x3x1'],
	  [1, 1, 3, 2, format(abs(scaled_wc('lequ1_1132')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x1x3x2'],
	  [1, 1, 3, 3, format(abs(scaled_wc('lequ1_1133')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x1x3x3'],
	  [1, 2, 1, 1, format(abs(scaled_wc('lequ1_1211')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x2x1x1'],
	  [1, 2, 1, 2, format(abs(scaled_wc('lequ1_1212')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x2x1x2'],
	  [1, 2, 1, 3, format(abs(scaled_wc('lequ1_1213')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x2x1x3'],
	  [1, 2, 2, 1, format(abs(scaled_wc('lequ1_1221')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x2x2x1'],
	  [1, 2, 2, 2, format(abs(scaled_wc('lequ1_1222')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x2x2x2'],
	  [1, 2, 2, 3, format(abs(scaled_wc('lequ1_1223')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x2x2x3'],
	  [1, 2, 3, 1, format(abs(scaled_wc('lequ1_1231')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x2x3x1'],
	  [1, 2, 3, 2, format(abs(scaled_wc('lequ1_1232')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x2x3x2'],
	  [1, 2, 3, 3, format(abs(scaled_wc('lequ1_1233')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x2x3x3'],
	  [1, 3, 1, 1, format(abs(scaled_wc('lequ1_1311')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x3x1x1'],
	  [1, 3, 1, 2, format(abs(scaled_wc('lequ1_1312')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x3x1x2'],
	  [1, 3, 1, 3, format(abs(scaled_wc('lequ1_1313')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x3x1x3'],
	  [1, 3, 2, 1, format(abs(scaled_wc('lequ1_1321')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x3x2x1'],
	  [1, 3, 2, 2, format(abs(scaled_wc('lequ1_1322')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x3x2x2'],
	  [1, 3, 2, 3, format(abs(scaled_wc('lequ1_1323')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x3x2x3'],
	  [1, 3, 3, 1, format(abs(scaled_wc('lequ1_1331')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x3x3x1'],
	  [1, 3, 3, 2, format(abs(scaled_wc('lequ1_1332')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x3x3x2'],
	  [1, 3, 3, 3, format(abs(scaled_wc('lequ1_1333')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs1x3x3x3'],
	  [2, 1, 1, 1, format(abs(scaled_wc('lequ1_2111')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x1x1x1'],
	  [2, 1, 1, 2, format(abs(scaled_wc('lequ1_2112')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x1x1x2'],
	  [2, 1, 1, 3, format(abs(scaled_wc('lequ1_2113')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x1x1x3'],
	  [2, 1, 2, 1, format(abs(scaled_wc('lequ1_2121')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x1x2x1'],
	  [2, 1, 2, 2, format(abs(scaled_wc('lequ1_2122')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x1x2x2'],
	  [2, 1, 2, 3, format(abs(scaled_wc('lequ1_2123')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x1x2x3'],
	  [2, 1, 3, 1, format(abs(scaled_wc('lequ1_2131')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x1x3x1'],
	  [2, 1, 3, 2, format(abs(scaled_wc('lequ1_2132')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x1x3x2'],
	  [2, 1, 3, 3, format(abs(scaled_wc('lequ1_2133')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x1x3x3'],
	  [2, 2, 1, 1, format(abs(scaled_wc('lequ1_2211')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x2x1x1'],
	  [2, 2, 1, 2, format(abs(scaled_wc('lequ1_2212')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x2x1x2'],
	  [2, 2, 1, 3, format(abs(scaled_wc('lequ1_2213')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x2x1x3'],
	  [2, 2, 2, 1, format(abs(scaled_wc('lequ1_2221')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x2x2x1'],
	  [2, 2, 2, 2, format(abs(scaled_wc('lequ1_2222')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x2x2x2'],
	  [2, 2, 2, 3, format(abs(scaled_wc('lequ1_2223')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x2x2x3'],
	  [2, 2, 3, 1, format(abs(scaled_wc('lequ1_2231')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x2x3x1'],
	  [2, 2, 3, 2, format(abs(scaled_wc('lequ1_2232')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x2x3x2'],
	  [2, 2, 3, 3, format(abs(scaled_wc('lequ1_2233')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x2x3x3'],
	  [2, 3, 1, 1, format(abs(scaled_wc('lequ1_2311')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x3x1x1'],
	  [2, 3, 1, 2, format(abs(scaled_wc('lequ1_2312')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x3x1x2'],
	  [2, 3, 1, 3, format(abs(scaled_wc('lequ1_2313')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x3x1x3'],
	  [2, 3, 2, 1, format(abs(scaled_wc('lequ1_2321')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x3x2x1'],
	  [2, 3, 2, 2, format(abs(scaled_wc('lequ1_2322')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x3x2x2'],
	  [2, 3, 2, 3, format(abs(scaled_wc('lequ1_2323')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x3x2x3'],
	  [2, 3, 3, 1, format(abs(scaled_wc('lequ1_2331')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x3x3x1'],
	  [2, 3, 3, 2, format(abs(scaled_wc('lequ1_2332')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x3x3x2'],
	  [2, 3, 3, 3, format(abs(scaled_wc('lequ1_2333')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs2x3x3x3'],
	  [3, 1, 1, 1, format(abs(scaled_wc('lequ1_3111')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x1x1x1'],
	  [3, 1, 1, 2, format(abs(scaled_wc('lequ1_3112')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x1x1x2'],
	  [3, 1, 1, 3, format(abs(scaled_wc('lequ1_3113')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x1x1x3'],
	  [3, 1, 2, 1, format(abs(scaled_wc('lequ1_3121')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x1x2x1'],
	  [3, 1, 2, 2, format(abs(scaled_wc('lequ1_3122')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x1x2x2'],
	  [3, 1, 2, 3, format(abs(scaled_wc('lequ1_3123')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x1x2x3'],
	  [3, 1, 3, 1, format(abs(scaled_wc('lequ1_3131')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x1x3x1'],
	  [3, 1, 3, 2, format(abs(scaled_wc('lequ1_3132')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x1x3x2'],
	  [3, 1, 3, 3, format(abs(scaled_wc('lequ1_3133')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x1x3x3'],
	  [3, 2, 1, 1, format(abs(scaled_wc('lequ1_3211')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x2x1x1'],
	  [3, 2, 1, 2, format(abs(scaled_wc('lequ1_3212')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x2x1x2'],
	  [3, 2, 1, 3, format(abs(scaled_wc('lequ1_3213')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x2x1x3'],
	  [3, 2, 2, 1, format(abs(scaled_wc('lequ1_3221')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x2x2x1'],
	  [3, 2, 2, 2, format(abs(scaled_wc('lequ1_3222')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x2x2x2'],
	  [3, 2, 2, 3, format(abs(scaled_wc('lequ1_3223')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x2x2x3'],
	  [3, 2, 3, 1, format(abs(scaled_wc('lequ1_3231')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x2x3x1'],
	  [3, 2, 3, 2, format(abs(scaled_wc('lequ1_3232')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x2x3x2'],
	  [3, 2, 3, 3, format(abs(scaled_wc('lequ1_3233')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x2x3x3'],
	  [3, 3, 1, 1, format(abs(scaled_wc('lequ1_3311')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x3x1x1'],
	  [3, 3, 1, 2, format(abs(scaled_wc('lequ1_3312')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x3x1x2'],
	  [3, 3, 1, 3, format(abs(scaled_wc('lequ1_3313')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x3x1x3'],
	  [3, 3, 2, 1, format(abs(scaled_wc('lequ1_3321')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x3x2x1'],
	  [3, 3, 2, 2, format(abs(scaled_wc('lequ1_3322')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x3x2x2'],
	  [3, 3, 2, 3, format(abs(scaled_wc('lequ1_3323')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x3x2x3'],
	  [3, 3, 3, 1, format(abs(scaled_wc('lequ1_3331')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x3x3x1'],
	  [3, 3, 3, 2, format(abs(scaled_wc('lequ1_3332')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x3x3x2'],
	  [3, 3, 3, 3, format(abs(scaled_wc('lequ1_3333')) * lambda_smeft_value**2,'.6e'), '# clequ1Abs3x3x3x3'],
      ]}

      card['Block']['FRBlock74'] = {'values': [
	  [1, 1, 1, 1, format(abs(scaled_wc('lequ3_1111')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x1x1x1'],
	  [1, 1, 1, 2, format(abs(scaled_wc('lequ3_1112')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x1x1x2'],
	  [1, 1, 1, 3, format(abs(scaled_wc('lequ3_1113')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x1x1x3'],
	  [1, 1, 2, 1, format(abs(scaled_wc('lequ3_1121')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x1x2x1'],
	  [1, 1, 2, 2, format(abs(scaled_wc('lequ3_1122')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x1x2x2'],
	  [1, 1, 2, 3, format(abs(scaled_wc('lequ3_1123')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x1x2x3'],
	  [1, 1, 3, 1, format(abs(scaled_wc('lequ3_1131')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x1x3x1'],
	  [1, 1, 3, 2, format(abs(scaled_wc('lequ3_1132')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x1x3x2'],
	  [1, 1, 3, 3, format(abs(scaled_wc('lequ3_1133')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x1x3x3'],
	  [1, 2, 1, 1, format(abs(scaled_wc('lequ3_1211')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x2x1x1'],
	  [1, 2, 1, 2, format(abs(scaled_wc('lequ3_1212')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x2x1x2'],
	  [1, 2, 1, 3, format(abs(scaled_wc('lequ3_1213')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x2x1x3'],
	  [1, 2, 2, 1, format(abs(scaled_wc('lequ3_1221')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x2x2x1'],
	  [1, 2, 2, 2, format(abs(scaled_wc('lequ3_1222')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x2x2x2'],
	  [1, 2, 2, 3, format(abs(scaled_wc('lequ3_1223')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x2x2x3'],
	  [1, 2, 3, 1, format(abs(scaled_wc('lequ3_1231')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x2x3x1'],
	  [1, 2, 3, 2, format(abs(scaled_wc('lequ3_1232')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x2x3x2'],
	  [1, 2, 3, 3, format(abs(scaled_wc('lequ3_1233')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x2x3x3'],
	  [1, 3, 1, 1, format(abs(scaled_wc('lequ3_1311')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x3x1x1'],
	  [1, 3, 1, 2, format(abs(scaled_wc('lequ3_1312')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x3x1x2'],
	  [1, 3, 1, 3, format(abs(scaled_wc('lequ3_1313')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x3x1x3'],
	  [1, 3, 2, 1, format(abs(scaled_wc('lequ3_1321')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x3x2x1'],
	  [1, 3, 2, 2, format(abs(scaled_wc('lequ3_1322')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x3x2x2'],
	  [1, 3, 2, 3, format(abs(scaled_wc('lequ3_1323')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x3x2x3'],
	  [1, 3, 3, 1, format(abs(scaled_wc('lequ3_1331')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x3x3x1'],
	  [1, 3, 3, 2, format(abs(scaled_wc('lequ3_1332')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x3x3x2'],
	  [1, 3, 3, 3, format(abs(scaled_wc('lequ3_1333')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs1x3x3x3'],
	  [2, 1, 1, 1, format(abs(scaled_wc('lequ3_2111')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x1x1x1'],
	  [2, 1, 1, 2, format(abs(scaled_wc('lequ3_2112')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x1x1x2'],
	  [2, 1, 1, 3, format(abs(scaled_wc('lequ3_2113')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x1x1x3'],
	  [2, 1, 2, 1, format(abs(scaled_wc('lequ3_2121')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x1x2x1'],
	  [2, 1, 2, 2, format(abs(scaled_wc('lequ3_2122')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x1x2x2'],
	  [2, 1, 2, 3, format(abs(scaled_wc('lequ3_2123')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x1x2x3'],
	  [2, 1, 3, 1, format(abs(scaled_wc('lequ3_2131')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x1x3x1'],
	  [2, 1, 3, 2, format(abs(scaled_wc('lequ3_2132')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x1x3x2'],
	  [2, 1, 3, 3, format(abs(scaled_wc('lequ3_2133')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x1x3x3'],
	  [2, 2, 1, 1, format(abs(scaled_wc('lequ3_2211')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x2x1x1'],
	  [2, 2, 1, 2, format(abs(scaled_wc('lequ3_2212')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x2x1x2'],
	  [2, 2, 1, 3, format(abs(scaled_wc('lequ3_2213')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x2x1x3'],
	  [2, 2, 2, 1, format(abs(scaled_wc('lequ3_2221')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x2x2x1'],
	  [2, 2, 2, 2, format(abs(scaled_wc('lequ3_2222')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x2x2x2'],
	  [2, 2, 2, 3, format(abs(scaled_wc('lequ3_2223')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x2x2x3'],
	  [2, 2, 3, 1, format(abs(scaled_wc('lequ3_2231')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x2x3x1'],
	  [2, 2, 3, 2, format(abs(scaled_wc('lequ3_2232')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x2x3x2'],
	  [2, 2, 3, 3, format(abs(scaled_wc('lequ3_2233')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x2x3x3'],
	  [2, 3, 1, 1, format(abs(scaled_wc('lequ3_2311')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x3x1x1'],
	  [2, 3, 1, 2, format(abs(scaled_wc('lequ3_2312')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x3x1x2'],
	  [2, 3, 1, 3, format(abs(scaled_wc('lequ3_2313')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x3x1x3'],
	  [2, 3, 2, 1, format(abs(scaled_wc('lequ3_2321')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x3x2x1'],
	  [2, 3, 2, 2, format(abs(scaled_wc('lequ3_2322')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x3x2x2'],
	  [2, 3, 2, 3, format(abs(scaled_wc('lequ3_2323')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x3x2x3'],
	  [2, 3, 3, 1, format(abs(scaled_wc('lequ3_2331')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x3x3x1'],
	  [2, 3, 3, 2, format(abs(scaled_wc('lequ3_2332')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x3x3x2'],
	  [2, 3, 3, 3, format(abs(scaled_wc('lequ3_2333')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs2x3x3x3'],
	  [3, 1, 1, 1, format(abs(scaled_wc('lequ3_3111')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x1x1x1'],
	  [3, 1, 1, 2, format(abs(scaled_wc('lequ3_3112')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x1x1x2'],
	  [3, 1, 1, 3, format(abs(scaled_wc('lequ3_3113')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x1x1x3'],
	  [3, 1, 2, 1, format(abs(scaled_wc('lequ3_3121')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x1x2x1'],
	  [3, 1, 2, 2, format(abs(scaled_wc('lequ3_3122')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x1x2x2'],
	  [3, 1, 2, 3, format(abs(scaled_wc('lequ3_3123')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x1x2x3'],
	  [3, 1, 3, 1, format(abs(scaled_wc('lequ3_3131')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x1x3x1'],
	  [3, 1, 3, 2, format(abs(scaled_wc('lequ3_3132')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x1x3x2'],
	  [3, 1, 3, 3, format(abs(scaled_wc('lequ3_3133')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x1x3x3'],
	  [3, 2, 1, 1, format(abs(scaled_wc('lequ3_3211')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x2x1x1'],
	  [3, 2, 1, 2, format(abs(scaled_wc('lequ3_3212')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x2x1x2'],
	  [3, 2, 1, 3, format(abs(scaled_wc('lequ3_3213')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x2x1x3'],
	  [3, 2, 2, 1, format(abs(scaled_wc('lequ3_3221')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x2x2x1'],
	  [3, 2, 2, 2, format(abs(scaled_wc('lequ3_3222')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x2x2x2'],
	  [3, 2, 2, 3, format(abs(scaled_wc('lequ3_3223')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x2x2x3'],
	  [3, 2, 3, 1, format(abs(scaled_wc('lequ3_3231')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x2x3x1'],
	  [3, 2, 3, 2, format(abs(scaled_wc('lequ3_3232')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x2x3x2'],
	  [3, 2, 3, 3, format(abs(scaled_wc('lequ3_3233')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x2x3x3'],
	  [3, 3, 1, 1, format(abs(scaled_wc('lequ3_3311')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x3x1x1'],
	  [3, 3, 1, 2, format(abs(scaled_wc('lequ3_3312')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x3x1x2'],
	  [3, 3, 1, 3, format(abs(scaled_wc('lequ3_3313')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x3x1x3'],
	  [3, 3, 2, 1, format(abs(scaled_wc('lequ3_3321')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x3x2x1'],
	  [3, 3, 2, 2, format(abs(scaled_wc('lequ3_3322')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x3x2x2'],
	  [3, 3, 2, 3, format(abs(scaled_wc('lequ3_3323')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x3x2x3'],
	  [3, 3, 3, 1, format(abs(scaled_wc('lequ3_3331')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x3x3x1'],
	  [3, 3, 3, 2, format(abs(scaled_wc('lequ3_3332')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x3x3x2'],
	  [3, 3, 3, 3, format(abs(scaled_wc('lequ3_3333')) * lambda_smeft_value**2,'.6e'), '# clequ3Abs3x3x3x3'],
      ]}

      card['Block']['FRBlock8'] = {'values': [
	  [1, 1, format(angle(scaled_wc('dW_11')),'.6e'), '# cdWPh1x1'],
	  [1, 2, format(angle(scaled_wc('dW_12')),'.6e'), '# cdWPh1x2'],
	  [1, 3, format(angle(scaled_wc('dW_13')),'.6e'), '# cdWPh1x3'],
	  [2, 1, format(angle(scaled_wc('dW_21')),'.6e'), '# cdWPh2x1'],
	  [2, 2, format(angle(scaled_wc('dW_22')),'.6e'), '# cdWPh2x2'],
	  [2, 3, format(angle(scaled_wc('dW_23')),'.6e'), '# cdWPh2x3'],
	  [3, 1, format(angle(scaled_wc('dW_31')),'.6e'), '# cdWPh3x1'],
	  [3, 2, format(angle(scaled_wc('dW_32')),'.6e'), '# cdWPh3x2'],
	  [3, 3, format(angle(scaled_wc('dW_33')),'.6e'), '# cdWPh3x3'],
      ]}

      card['Block']['FRBlock9'] = {'values': [
	  [1, 1, format(angle(scaled_wc('dB_11')),'.6e'), '# cdBPh1x1'],
	  [1, 2, format(angle(scaled_wc('dB_12')),'.6e'), '# cdBPh1x2'],
	  [1, 3, format(angle(scaled_wc('dB_13')),'.6e'), '# cdBPh1x3'],
	  [2, 1, format(angle(scaled_wc('dB_21')),'.6e'), '# cdBPh2x1'],
	  [2, 2, format(angle(scaled_wc('dB_22')),'.6e'), '# cdBPh2x2'],
	  [2, 3, format(angle(scaled_wc('dB_23')),'.6e'), '# cdBPh2x3'],
	  [3, 1, format(angle(scaled_wc('dB_31')),'.6e'), '# cdBPh3x1'],
	  [3, 2, format(angle(scaled_wc('dB_32')),'.6e'), '# cdBPh3x2'],
	  [3, 3, format(angle(scaled_wc('dB_33')),'.6e'), '# cdBPh3x3'],
      ]}

      if input_scheme_value == 'mw':
          card['Block']['FRBlock']['values'].insert(1474,[1475, format(80.387, '.6e'), '# MW0'])

  elif model_set == 'B':

      card['Block']['FRBlock'] = {'values': [
	[1, format(abs(scaled_wc('phil1_11')* lambda_smeft_value**2), '.6e') , '# cHl1Abs11'],
	[2, format(abs(scaled_wc('phil1_12')* lambda_smeft_value**2), '.6e') , '# cHl1Abs12'],
	[3, format(abs(scaled_wc('phil1_13')* lambda_smeft_value**2), '.6e') , '# cHl1Abs13'],
	[4, format(abs(scaled_wc('phil1_22')* lambda_smeft_value**2), '.6e') , '# cHl1Abs22'],
	[5, format(abs(scaled_wc('phil1_23')* lambda_smeft_value**2), '.6e') , '# cHl1Abs23'],
	[6, format(abs(scaled_wc('phil1_33')* lambda_smeft_value**2), '.6e') , '# cHl1Abs33'],
	[7, format(angle(scaled_wc('phil1_12')), '.6e') , '# cHl1Ph12'],
	[8, format(angle(scaled_wc('phil1_13')), '.6e') , '# cHl1Ph13'],
	[9, format(angle(scaled_wc('phil1_23')), '.6e') , '# cHl1Ph23'],
	[10, format(abs(scaled_wc('phil3_11')* lambda_smeft_value**2), '.6e') ,'# cHL3Abs11'],
	[11, format(abs(scaled_wc('phil3_12')* lambda_smeft_value**2), '.6e') ,'# cHL3Abs12'],
	[12, format(abs(scaled_wc('phil3_13')* lambda_smeft_value**2), '.6e') ,'# cHL3Abs13'],
	[13, format(abs(scaled_wc('phil3_22')* lambda_smeft_value**2), '.6e') ,'# cHL3Abs22'],
	[14, format(abs(scaled_wc('phil3_23')* lambda_smeft_value**2), '.6e') ,'# cHL3Abs23'],
	[15, format(abs(scaled_wc('phil3_33')* lambda_smeft_value**2), '.6e') ,'# cHL3Abs33'],
	[16, format(angle(scaled_wc('phil3_12')), '.6e') ,'# cHL3Ph12'],
	[17, format(angle(scaled_wc('phil3_13')), '.6e') ,'# cHL3Ph13'],
	[18, format(angle(scaled_wc('phil3_23')), '.6e') ,'# cHL3Ph23'],
	[19, format(abs(scaled_wc('phiq1_11')* lambda_smeft_value**2), '.6e') ,'# cHq1Abs11'],
	[20, format(abs(scaled_wc('phiq1_12')* lambda_smeft_value**2), '.6e') ,'# cHq1Abs12'],
	[21, format(abs(scaled_wc('phiq1_13')* lambda_smeft_value**2), '.6e') ,'# cHq1Abs13'],
	[22, format(abs(scaled_wc('phiq1_22')* lambda_smeft_value**2), '.6e') ,'# cHq1Abs22'],
	[23, format(abs(scaled_wc('phiq1_23')* lambda_smeft_value**2), '.6e') ,'# cHq1Abs23'],
	[24, format(abs(scaled_wc('phiq1_33')* lambda_smeft_value**2), '.6e') ,'# cHq1Abs33'],
	[25, format(angle(scaled_wc('phiq1_12')), '.6e') ,'# cHq1Ph12'],
	[26, format(angle(scaled_wc('phiq1_13')), '.6e') ,'# cHq1Ph13'],
	[27, format(angle(scaled_wc('phiq1_23')), '.6e') ,'# cHq1Ph23'],
	[28, format(abs(scaled_wc('phiq3_11')* lambda_smeft_value**2), '.6e') ,'# cHQ3Abs11'],
	[29, format(abs(scaled_wc('phiq3_12')* lambda_smeft_value**2), '.6e') ,'# cHQ3Abs12'],
	[30, format(abs(scaled_wc('phiq3_13')* lambda_smeft_value**2), '.6e') ,'# cHQ3Abs13'],
	[31, format(abs(scaled_wc('phiq3_22')* lambda_smeft_value**2), '.6e') ,'# cHQ3Abs22'],
	[32, format(abs(scaled_wc('phiq3_23')* lambda_smeft_value**2), '.6e') ,'# cHQ3Abs23'],
	[33, format(abs(scaled_wc('phiq3_33')* lambda_smeft_value**2), '.6e') ,'# cHQ3Abs33'],
	[34, format(angle(scaled_wc('phiq3_12')), '.6e') ,'# cHQ3Ph12'],
	[35, format(angle(scaled_wc('phiq3_13')), '.6e') ,'# cHQ3Ph13'],
	[36, format(angle(scaled_wc('phiq3_23')), '.6e') ,'# cHQ3Ph23'],
	[37, format(abs(scaled_wc('phiu_11')* lambda_smeft_value**2), '.6e') ,'# cHuAbs11'],
	[38, format(abs(scaled_wc('phiu_12')* lambda_smeft_value**2), '.6e') ,'# cHuAbs12'],
	[39, format(abs(scaled_wc('phiu_13')* lambda_smeft_value**2), '.6e') ,'# cHuAbs13'],
	[40, format(abs(scaled_wc('phiu_22')* lambda_smeft_value**2), '.6e') ,'# cHuAbs22'],
	[41, format(abs(scaled_wc('phiu_23')* lambda_smeft_value**2), '.6e') ,'# cHuAbs23'],
	[42, format(abs(scaled_wc('phiu_33')* lambda_smeft_value**2), '.6e') ,'# cHuAbs33'],
	[43, format(angle(scaled_wc('phiu_12')), '.6e') ,'# cHuPh12'],
	[44, format(angle(scaled_wc('phiu_13')), '.6e') ,'# cHuPh13'],
	[45, format(angle(scaled_wc('phiu_23')), '.6e') ,'# cHuPh23'],
	[46, format(abs(scaled_wc('phid_11')* lambda_smeft_value**2), '.6e') ,'# cHdAbs11'],
	[47, format(abs(scaled_wc('phid_12')* lambda_smeft_value**2), '.6e') ,'# cHdAbs12'],
	[48, format(abs(scaled_wc('phid_13')* lambda_smeft_value**2), '.6e') ,'# cHdAbs13'],
	[49, format(abs(scaled_wc('phid_22')* lambda_smeft_value**2), '.6e') ,'# cHdAbs22'],
	[50, format(abs(scaled_wc('phid_23')* lambda_smeft_value**2), '.6e') ,'# cHdAbs23'],
	[51, format(abs(scaled_wc('phid_33')* lambda_smeft_value**2), '.6e') ,'# cHdAbs33'],
	[52, format(angle(scaled_wc('phid_12')), '.6e') ,'# cHdPh12'],
	[53, format(angle(scaled_wc('phid_13')), '.6e') ,'# cHdPh13'],
	[54, format(angle(scaled_wc('phid_23')), '.6e') ,'# cHdPh23'],
	[55, format(abs(scaled_wc('phie_11')* lambda_smeft_value**2), '.6e') ,'# cHeAbs11'],
	[56, format(abs(scaled_wc('phie_12')* lambda_smeft_value**2), '.6e') ,'# cHeAbs12'],
	[57, format(abs(scaled_wc('phie_13')* lambda_smeft_value**2), '.6e') ,'# cHeAbs13'],
	[58, format(abs(scaled_wc('phie_22')* lambda_smeft_value**2), '.6e') ,'# cHeAbs22'],
	[59, format(abs(scaled_wc('phie_23')* lambda_smeft_value**2), '.6e') ,'# cHeAbs23'],
	[60, format(abs(scaled_wc('phie_33')* lambda_smeft_value**2), '.6e') ,'# cHeAbs33'],
	[61, format(angle(scaled_wc('phie_12')), '.6e') ,'# cHePh12'],
	[62, format(angle(scaled_wc('phie_13')), '.6e') ,'# cHePh13'],
	[63, format(angle(scaled_wc('phie_23')), '.6e') ,'# cHePh23'],
	[64, format(scaled_wc('ll_1111')* lambda_smeft_value**2, '.6e') ,'# cllAbs1111'],
	[65, format(scaled_wc('ll_1122')* lambda_smeft_value**2, '.6e') ,'# cllAbs1122'],
	[66, format(scaled_wc('ll_1221')* lambda_smeft_value**2, '.6e') ,'# cllAbs1221'],
	[67, format(scaled_wc('ll_1133')* lambda_smeft_value**2, '.6e') ,'# cllAbs1133'],
	[68, format(scaled_wc('ll_1331')* lambda_smeft_value**2, '.6e') ,'# cllAbs1331'],
	[69, format(scaled_wc('ll_2222')* lambda_smeft_value**2, '.6e') ,'# cllAbs2222'],
	[70, format(scaled_wc('ll_2233')* lambda_smeft_value**2, '.6e') ,'# cllAbs2233'],
	[71, format(scaled_wc('ll_2332')* lambda_smeft_value**2, '.6e') ,'# cllAbs2332'],
	[72, format(scaled_wc('ll_3333')* lambda_smeft_value**2, '.6e') ,'# cllAbs3333'],
	[73, format(abs(scaled_wc('ll_1112'))* lambda_smeft_value**2, '.6e') ,'# cllAbs1112'],
	[74, format(abs(scaled_wc('ll_1113'))* lambda_smeft_value**2, '.6e') ,'# cllAbs1113'],
	[75, format(abs(scaled_wc('ll_1123'))* lambda_smeft_value**2, '.6e') ,'# cllAbs1123'],
	[76, format(abs(scaled_wc('ll_1212'))* lambda_smeft_value**2, '.6e') ,'# cllAbs1212'],
	[77, format(abs(scaled_wc('ll_1213'))* lambda_smeft_value**2, '.6e') ,'# cllAbs1213'],
	[78, format(abs(scaled_wc('ll_1231'))* lambda_smeft_value**2, '.6e') ,'# cllAbs1231'],
	[79, format(abs(scaled_wc('ll_1222'))* lambda_smeft_value**2, '.6e') ,'# cllAbs1222'],
	[80, format(abs(scaled_wc('ll_1223'))* lambda_smeft_value**2, '.6e') ,'# cllAbs1223'],
	[81, format(abs(scaled_wc('ll_1232'))* lambda_smeft_value**2, '.6e') ,'# cllAbs1232'],
	[82, format(abs(scaled_wc('ll_1233'))* lambda_smeft_value**2, '.6e') ,'# cllAbs1233'],
	[83, format(abs(scaled_wc('ll_1313'))* lambda_smeft_value**2, '.6e') ,'# cllAbs1313'],
	[84, format(abs(scaled_wc('ll_1322'))* lambda_smeft_value**2, '.6e') ,'# cllAbs1322'],
	[85, format(abs(scaled_wc('ll_1332'))* lambda_smeft_value**2, '.6e') ,'# cllAbs1332'],
	[86, format(abs(scaled_wc('ll_1323'))* lambda_smeft_value**2, '.6e') ,'# cllAbs1323'],
	[87, format(abs(scaled_wc('ll_1333'))* lambda_smeft_value**2, '.6e') ,'# cllAbs1333'],
	[88, format(abs(scaled_wc('ll_2223'))* lambda_smeft_value**2, '.6e') ,'# cllAbs2223'],
	[89, format(abs(scaled_wc('ll_2323'))* lambda_smeft_value**2, '.6e') ,'# cllAbs2323'],
	[90, format(abs(scaled_wc('ll_2333'))* lambda_smeft_value**2, '.6e') ,'# cllAbs3323'],
	[91, format(angle(scaled_wc('ll_1112')), '.6e') ,'# cllPh1112'],
	[92, format(angle(scaled_wc('ll_1113')), '.6e') ,'# cllPh1113'],
	[93, format(angle(scaled_wc('ll_1123')), '.6e') ,'# cllPh1123'],
	[94, format(angle(scaled_wc('ll_1212')), '.6e') ,'# cllPh1212'],
	[95, format(angle(scaled_wc('ll_1213')), '.6e') ,'# cllPh1213'],
	[96, format(angle(scaled_wc('ll_1231')), '.6e') ,'# cllPh1231'],
	[97, format(angle(scaled_wc('ll_1222')), '.6e') ,'# cllPh1222'],
	[98, format(angle(scaled_wc('ll_1223')), '.6e') ,'# cllPh1223'],
	[99, format(angle(scaled_wc('ll_1232')), '.6e') ,'# cllPh1232'],
	[100, format(angle(scaled_wc('ll_1233')), '.6e') ,'# cllPh1233'],
	[101, format(angle(scaled_wc('ll_1313')), '.6e') ,'# cllPh1313'],
	[102, format(angle(scaled_wc('ll_1322')), '.6e') ,'# cllPh1322'],
	[103, format(angle(scaled_wc('ll_1332')), '.6e') ,'# cllPh1332'],
	[104, format(angle(scaled_wc('ll_1323')), '.6e') ,'# cllPh1323'],
	[105, format(angle(scaled_wc('ll_1333')), '.6e') ,'# cllPh1333'],
	[106, format(angle(scaled_wc('ll_2223')), '.6e') ,'# cllPh2223'],
	[107, format(angle(scaled_wc('ll_2323')), '.6e') ,'# cllPh2323'],
	[108, format(angle(scaled_wc('ll_2333')), '.6e') ,'# cllPh3323'],
	[109, format(scaled_wc('qq1_1111')* lambda_smeft_value**2, '.6e') ,'# cqq1Abs1111'],
	[110, format(scaled_wc('qq1_1122')* lambda_smeft_value**2, '.6e') ,'# cqq1Abs1122'],
	[111, format(scaled_wc('qq1_1221')* lambda_smeft_value**2, '.6e') ,'# cqq1Abs1221'],
	[112, format(scaled_wc('qq1_1133')* lambda_smeft_value**2, '.6e') ,'# cqq1Abs1133'],
	[113, format(scaled_wc('qq1_1331')* lambda_smeft_value**2, '.6e') ,'# cqq1Abs1331'],
	[114, format(scaled_wc('qq1_2222')* lambda_smeft_value**2, '.6e') ,'# cqq1Abs2222'],
	[115, format(scaled_wc('qq1_2233')* lambda_smeft_value**2, '.6e') ,'# cqq1Abs2233'],
	[116, format(scaled_wc('qq1_2332')* lambda_smeft_value**2, '.6e') ,'# cqq1Abs2332'],
	[117, format(scaled_wc('qq1_3333')* lambda_smeft_value**2, '.6e') ,'# cqq1Abs3333'],
	[118, format(abs(scaled_wc('qq1_1112'))* lambda_smeft_value**2, '.6e') ,'# cqq1Abs1112'],
	[119, format(abs(scaled_wc('qq1_1113'))* lambda_smeft_value**2, '.6e') ,'# cqq1Abs1113'],
	[120, format(abs(scaled_wc('qq1_1123'))* lambda_smeft_value**2, '.6e') ,'# cqq1Abs1123'],
	[121, format(abs(scaled_wc('qq1_1212'))* lambda_smeft_value**2, '.6e') ,'# cqq1Abs1212'],
	[122, format(abs(scaled_wc('qq1_1213'))* lambda_smeft_value**2, '.6e') ,'# cqq1Abs1213'],
	[123, format(abs(scaled_wc('qq1_1231'))* lambda_smeft_value**2, '.6e') ,'# cqq1Abs1231'],
	[124, format(abs(scaled_wc('qq1_1222'))* lambda_smeft_value**2, '.6e') ,'# cqq1Abs1222'],
	[125, format(abs(scaled_wc('qq1_1223'))* lambda_smeft_value**2, '.6e') ,'# cqq1Abs1223'],
	[126, format(abs(scaled_wc('qq1_1232'))* lambda_smeft_value**2, '.6e') ,'# cqq1Abs1232'],
	[127, format(abs(scaled_wc('qq1_1233'))* lambda_smeft_value**2, '.6e') ,'# cqq1Abs1233'],
	[128, format(abs(scaled_wc('qq1_1313'))* lambda_smeft_value**2, '.6e') ,'# cqq1Abs1313'],
	[129, format(abs(scaled_wc('qq1_1322'))* lambda_smeft_value**2, '.6e') ,'# cqq1Abs1322'],
	[130, format(abs(scaled_wc('qq1_1332'))* lambda_smeft_value**2, '.6e') ,'# cqq1Abs1332'],
	[131, format(abs(scaled_wc('qq1_1323'))* lambda_smeft_value**2, '.6e') ,'# cqq1Abs1323'],
	[132, format(abs(scaled_wc('qq1_1333'))* lambda_smeft_value**2, '.6e') ,'# cqq1Abs1333'],
	[133, format(abs(scaled_wc('qq1_2223'))* lambda_smeft_value**2, '.6e') ,'# cqq1Abs2223'],
	[134, format(abs(scaled_wc('qq1_2323'))* lambda_smeft_value**2, '.6e') ,'# cqq1Abs2323'],
	[135, format(abs(scaled_wc('qq1_2333'))* lambda_smeft_value**2, '.6e') ,'# cqq1Abs3323'],
	[136, format(angle(scaled_wc('qq1_1112')), '.6e') ,'# cqq1Ph1112'],
	[137, format(angle(scaled_wc('qq1_1113')), '.6e') ,'# cqq1Ph1113'],
	[138, format(angle(scaled_wc('qq1_1123')), '.6e') ,'# cqq1Ph1123'],
	[139, format(angle(scaled_wc('qq1_1212')), '.6e') ,'# cqq1Ph1212'],
	[140, format(angle(scaled_wc('qq1_1213')), '.6e') ,'# cqq1Ph1213'],
	[141, format(angle(scaled_wc('qq1_1231')), '.6e') ,'# cqq1Ph1231'],
	[142, format(angle(scaled_wc('qq1_1222')), '.6e') ,'# cqq1Ph1222'],
	[143, format(angle(scaled_wc('qq1_1223')), '.6e') ,'# cqq1Ph1223'],
	[144, format(angle(scaled_wc('qq1_1232')), '.6e') ,'# cqq1Ph1232'],
	[145, format(angle(scaled_wc('qq1_1233')), '.6e') ,'# cqq1Ph1233'],
	[146, format(angle(scaled_wc('qq1_1313')), '.6e') ,'# cqq1Ph1313'],
	[147, format(angle(scaled_wc('qq1_1322')), '.6e') ,'# cqq1Ph1322'],
	[148, format(angle(scaled_wc('qq1_1332')), '.6e') ,'# cqq1Ph1332'],
	[149, format(angle(scaled_wc('qq1_1323')), '.6e') ,'# cqq1Ph1323'],
	[150, format(angle(scaled_wc('qq1_1333')), '.6e') ,'# cqq1Ph1333'],
	[151, format(angle(scaled_wc('qq1_2223')), '.6e') ,'# cqq1Ph2223'],
	[152, format(angle(scaled_wc('qq1_2323')), '.6e') ,'# cqq1Ph2323'],
	[153, format(angle(scaled_wc('qq1_2333')), '.6e') ,'# cqq1Ph3323'],
	[154, format(scaled_wc('qq3_1111')* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs1111'],
	[155, format(scaled_wc('qq3_1122')* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs1122'],
	[156, format(scaled_wc('qq3_1221')* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs1221'],
	[157, format(scaled_wc('qq3_1133')* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs1133'],
	[158, format(scaled_wc('qq3_1331')* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs1331'],
	[159, format(scaled_wc('qq3_2222')* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs2222'],
	[160, format(scaled_wc('qq3_2233')* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs2233'],
	[161, format(scaled_wc('qq3_2332')* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs2332'],
	[162, format(scaled_wc('qq3_3333')* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs3333'],
	[163, format(abs(scaled_wc('qq3_1112'))* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs1112'],
	[164, format(abs(scaled_wc('qq3_1113'))* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs1113'],
	[165, format(abs(scaled_wc('qq3_1123'))* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs1123'],
	[166, format(abs(scaled_wc('qq3_1212'))* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs1212'],
	[167, format(abs(scaled_wc('qq3_1213'))* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs1213'],
	[168, format(abs(scaled_wc('qq3_1231'))* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs1231'],
	[169, format(abs(scaled_wc('qq3_1222'))* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs1222'],
	[170, format(abs(scaled_wc('qq3_1223'))* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs1223'],
	[171, format(abs(scaled_wc('qq3_1232'))* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs1232'],
	[172, format(abs(scaled_wc('qq3_1233'))* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs1233'],
	[173, format(abs(scaled_wc('qq3_1313'))* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs1313'],
	[174, format(abs(scaled_wc('qq3_1322'))* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs1322'],
	[175, format(abs(scaled_wc('qq3_1332'))* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs1332'],
	[176, format(abs(scaled_wc('qq3_1323'))* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs1323'],
	[177, format(abs(scaled_wc('qq3_1333'))* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs1333'],
	[178, format(abs(scaled_wc('qq3_2223'))* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs2223'],
	[179, format(abs(scaled_wc('qq3_2323'))* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs2323'],
	[180, format(abs(scaled_wc('qq3_2333'))* lambda_smeft_value**2, '.6e') ,'# cQQ3Abs3323'],
	[181, format(angle(scaled_wc('qq3_1112')), '.6e') ,'# cQQ3Ph1112'],
	[182, format(angle(scaled_wc('qq3_1113')), '.6e') ,'# cQQ3Ph1113'],
	[183, format(angle(scaled_wc('qq3_1123')), '.6e') ,'# cQQ3Ph1123'],
	[184, format(angle(scaled_wc('qq3_1212')), '.6e') ,'# cQQ3Ph1212'],
	[185, format(angle(scaled_wc('qq3_1213')), '.6e') ,'# cQQ3Ph1213'],
	[186, format(angle(scaled_wc('qq3_1231')), '.6e') ,'# cQQ3Ph1231'],
	[187, format(angle(scaled_wc('qq3_1222')), '.6e') ,'# cQQ3Ph1222'],
	[188, format(angle(scaled_wc('qq3_1223')), '.6e') ,'# cQQ3Ph1223'],
	[189, format(angle(scaled_wc('qq3_1232')), '.6e') ,'# cQQ3Ph1232'],
	[190, format(angle(scaled_wc('qq3_1233')), '.6e') ,'# cQQ3Ph1233'],
	[191, format(angle(scaled_wc('qq3_1313')), '.6e') ,'# cQQ3Ph1313'],
	[192, format(angle(scaled_wc('qq3_1322')), '.6e') ,'# cQQ3Ph1322'],
	[193, format(angle(scaled_wc('qq3_1332')), '.6e') ,'# cQQ3Ph1332'],
	[194, format(angle(scaled_wc('qq3_1323')), '.6e') ,'# cQQ3Ph1323'],
	[195, format(angle(scaled_wc('qq3_1333')), '.6e') ,'# cQQ3Ph1333'],
	[196, format(angle(scaled_wc('qq3_2223')), '.6e') ,'# cQQ3Ph2223'],
	[197, format(angle(scaled_wc('qq3_2323')), '.6e') ,'# cQQ3Ph2323'],
	[198, format(angle(scaled_wc('qq3_2333')), '.6e') ,'# cQQ3Ph3323'],
	[199, format(scaled_wc('lq1_1111')* lambda_smeft_value**2, '.6e') ,'# clq1Abs1111'],
	[200, format(abs(scaled_wc('lq1_1112'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs1112'],
	[201, format(abs(scaled_wc('lq1_1113'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs1113'],
	[202, format(abs(scaled_wc('lq1_1123'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs1123'],
	[203, format(scaled_wc('lq1_1122')* lambda_smeft_value**2, '.6e') ,'# clq1Abs1122'],
	[204, format(scaled_wc('lq1_1133')* lambda_smeft_value**2, '.6e') ,'# clq1Abs1133'],
	[205, format(abs(scaled_wc('lq1_1211'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs1211'],
	[206, format(abs(scaled_wc('lq1_1212'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs1212'],
	[207, format(abs(scaled_wc('lq1_1221'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs1221'],
	[208, format(abs(scaled_wc('lq1_1213'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs1213'],
	[209, format(abs(scaled_wc('lq1_1231'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs1231'],
	[210, format(abs(scaled_wc('lq1_1222'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs1222'],
	[211, format(abs(scaled_wc('lq1_1223'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs1223'],
	[212, format(abs(scaled_wc('lq1_1232'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs1232'],
	[213, format(abs(scaled_wc('lq1_1233'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs1233'],
	[214, format(abs(scaled_wc('lq1_1311'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs1311'],
	[215, format(abs(scaled_wc('lq1_1312'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs1312'],
	[216, format(abs(scaled_wc('lq1_1313'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs1313'],
	[217, format(abs(scaled_wc('lq1_1331'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs1331'],
	[218, format(abs(scaled_wc('lq1_1321'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs1321'],
	[219, format(abs(scaled_wc('lq1_1322'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs1322'],
	[220, format(abs(scaled_wc('lq1_1332'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs1332'],
	[221, format(abs(scaled_wc('lq1_1323'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs1323'],
	[222, format(abs(scaled_wc('lq1_1333'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs1333'],
	[223, format(scaled_wc('lq1_2211')* lambda_smeft_value**2, '.6e') ,'# clq1Abs2211'],
	[224, format(abs(scaled_wc('lq1_2212'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs2212'],
	[225, format(abs(scaled_wc('lq1_2213'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs2213'],
	[226, format(scaled_wc('lq1_2222')* lambda_smeft_value**2, '.6e') ,'# clq1Abs2222'],
	[227, format(abs(scaled_wc('lq1_2223'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs2223'],
	[228, format(scaled_wc('lq1_2233')* lambda_smeft_value**2, '.6e') ,'# clq1Abs2233'],
	[229, format(abs(scaled_wc('lq1_2311'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs2311'],
	[230, format(abs(scaled_wc('lq1_2312'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs2312'],
	[231, format(abs(scaled_wc('lq1_2313'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs2313'],
	[232, format(abs(scaled_wc('lq1_2321'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs2321'],
	[233, format(abs(scaled_wc('lq1_2322'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs2322'],
	[234, format(abs(scaled_wc('lq1_2323'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs2323'],
	[235, format(abs(scaled_wc('lq1_2331'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs2331'],
	[236, format(abs(scaled_wc('lq1_2332'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs2332'],
	[237, format(abs(scaled_wc('lq1_2333'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs2333'],
	[238, format(scaled_wc('lq1_3311')* lambda_smeft_value**2, '.6e') ,'# clq1Abs3311'],
	[239, format(abs(scaled_wc('lq1_3312'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs3312'],
	[240, format(abs(scaled_wc('lq1_3313'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs3313'],
	[241, format(scaled_wc('lq1_3322')* lambda_smeft_value**2, '.6e') ,'# clq1Abs3322'],
	[242, format(scaled_wc('lq1_3333')* lambda_smeft_value**2, '.6e') ,'# clq1Abs3333'],
	[243, format(abs(scaled_wc('lq1_3323'))* lambda_smeft_value**2, '.6e') ,'# clq1Abs3323'],
	[244, format(angle(scaled_wc('lq1_1112')), '.6e') ,'# clq1Ph1112'],
	[245, format(angle(scaled_wc('lq1_2212')), '.6e') ,'# clq1Ph2212'],
	[246, format(angle(scaled_wc('lq1_1113')), '.6e') ,'# clq1Ph1113'],
	[247, format(angle(scaled_wc('lq1_1123')), '.6e') ,'# clq1Ph1123'],
	[248, format(angle(scaled_wc('lq1_1211')), '.6e') ,'# clq1Ph1211'],
	[249, format(angle(scaled_wc('lq1_1212')), '.6e') ,'# clq1Ph1212'],
	[250, format(angle(scaled_wc('lq1_1221')), '.6e') ,'# clq1Ph1221'],
	[251, format(angle(scaled_wc('lq1_1213')), '.6e') ,'# clq1Ph1213'],
	[252, format(angle(scaled_wc('lq1_1231')), '.6e') ,'# clq1Ph1231'],
	[253, format(angle(scaled_wc('lq1_1222')), '.6e') ,'# clq1Ph1222'],
	[254, format(angle(scaled_wc('lq1_1223')), '.6e') ,'# clq1Ph1223'],
	[255, format(angle(scaled_wc('lq1_1232')), '.6e') ,'# clq1Ph1232'],
	[256, format(angle(scaled_wc('lq1_1233')), '.6e') ,'# clq1Ph1233'],
	[257, format(angle(scaled_wc('lq1_1311')), '.6e') ,'# clq1Ph1311'],
	[258, format(angle(scaled_wc('lq1_1312')), '.6e') ,'# clq1Ph1312'],
	[259, format(angle(scaled_wc('lq1_1313')), '.6e') ,'# clq1Ph1313'],
	[260, format(angle(scaled_wc('lq1_1331')), '.6e') ,'# clq1Ph1331'],
	[261, format(angle(scaled_wc('lq1_1321')), '.6e') ,'# clq1Ph1321'],
	[262, format(angle(scaled_wc('lq1_1322')), '.6e') ,'# clq1Ph1322'],
	[263, format(angle(scaled_wc('lq1_1332')), '.6e') ,'# clq1Ph1332'],
	[264, format(angle(scaled_wc('lq1_1323')), '.6e') ,'# clq1Ph1323'],
	[265, format(angle(scaled_wc('lq1_1333')), '.6e') ,'# clq1Ph1333'],
	[266, format(angle(scaled_wc('lq1_2213')), '.6e') ,'# clq1Ph2213'],
	[267, format(angle(scaled_wc('lq1_2223')), '.6e') ,'# clq1Ph2223'],
	[268, format(angle(scaled_wc('lq1_2311')), '.6e') ,'# clq1Ph2311'],
	[269, format(angle(scaled_wc('lq1_2312')), '.6e') ,'# clq1Ph2312'],
	[270, format(angle(scaled_wc('lq1_2313')), '.6e') ,'# clq1Ph2313'],
	[271, format(angle(scaled_wc('lq1_2321')), '.6e') ,'# clq1Ph2321'],
	[272, format(angle(scaled_wc('lq1_2322')), '.6e') ,'# clq1Ph2322'],
	[273, format(angle(scaled_wc('lq1_2323')), '.6e') ,'# clq1Ph2323'],
	[274, format(angle(scaled_wc('lq1_2331')), '.6e') ,'# clq1Ph2331'],
	[275, format(angle(scaled_wc('lq1_2332')), '.6e') ,'# clq1Ph2332'],
	[276, format(angle(scaled_wc('lq1_2333')), '.6e') ,'# clq1Ph2333'],
	[277, format(angle(scaled_wc('lq1_3323')), '.6e') ,'# clq1Ph3323'],
	[278, format(angle(scaled_wc('lq1_3312')), '.6e') ,'# clq1Ph3312'],
	[279, format(angle(scaled_wc('lq1_3313')), '.6e') ,'# clq1Ph3313'],
	[280, format(scaled_wc('lq3_1111')* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs1111'],
	[281, format(abs(scaled_wc('lq3_1112'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs1112'],
	[282, format(abs(scaled_wc('lq3_1113'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs1113'],
	[283, format(abs(scaled_wc('lq3_1123'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs1123'],
	[284, format(scaled_wc('lq3_1122')* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs1122'],
	[285, format(scaled_wc('lq3_1133')* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs1133'],
	[286, format(abs(scaled_wc('lq3_1211'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs1211'],
	[287, format(abs(scaled_wc('lq3_1212'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs1212'],
	[288, format(abs(scaled_wc('lq3_1221'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs1221'],
	[289, format(abs(scaled_wc('lq3_1213'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs1213'],
	[290, format(abs(scaled_wc('lq3_1231'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs1231'],
	[291, format(abs(scaled_wc('lq3_1222'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs1222'],
	[292, format(abs(scaled_wc('lq3_1223'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs1223'],
	[293, format(abs(scaled_wc('lq3_1232'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs1232'],
	[294, format(abs(scaled_wc('lq3_1233'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs1233'],
	[295, format(abs(scaled_wc('lq3_1311'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs1311'],
	[296, format(abs(scaled_wc('lq3_1312'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs1312'],
	[297, format(abs(scaled_wc('lq3_1313'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs1313'],
	[298, format(abs(scaled_wc('lq3_1331'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs1331'],
	[299, format(abs(scaled_wc('lq3_1321'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs1321'],
	[300, format(abs(scaled_wc('lq3_1322'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs1322'],
	[301, format(abs(scaled_wc('lq3_1332'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs1332'],
	[302, format(abs(scaled_wc('lq3_1323'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs1323'],
	[303, format(abs(scaled_wc('lq3_1333'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs1333'],
	[304, format(scaled_wc('lq3_2211')* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs2211'],
	[305, format(abs(scaled_wc('lq3_2212'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs2212'],
	[306, format(abs(scaled_wc('lq3_2213'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs2213'],
	[307, format(scaled_wc('lq3_2222')* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs2222'],
	[308, format(abs(scaled_wc('lq3_2223'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs2223'],
	[309, format(scaled_wc('lq3_2233')* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs2233'],
	[310, format(abs(scaled_wc('lq3_2311'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs2311'],
	[311, format(abs(scaled_wc('lq3_2312'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs2312'],
	[312, format(abs(scaled_wc('lq3_2313'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs2313'],
	[313, format(abs(scaled_wc('lq3_2321'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs2321'],
	[314, format(abs(scaled_wc('lq3_2322'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs2322'],
	[315, format(abs(scaled_wc('lq3_2323'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs2323'],
	[316, format(abs(scaled_wc('lq3_2331'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs2331'],
	[317, format(abs(scaled_wc('lq3_2332'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs2332'],
	[318, format(abs(scaled_wc('lq3_2333'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs2333'],
	[319, format(scaled_wc('lq3_3311')* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs3311'],
	[320, format(abs(scaled_wc('lq3_3312'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs3312'],
	[321, format(abs(scaled_wc('lq3_3313'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs3313'],
	[322, format(scaled_wc('lq3_3322')* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs3322'],
	[323, format(scaled_wc('lq3_3333')* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs3333'],
	[324, format(abs(scaled_wc('lq3_3323'))* lambda_smeft_value**2, '.6e') ,'# cLQ3Abs3323'],
	[325, format(angle(scaled_wc('lq3_1112')), '.6e') ,'# cLQ3Ph1112'],
	[326, format(angle(scaled_wc('lq3_2212')), '.6e') ,'# cLQ3Ph2212'],
	[327, format(angle(scaled_wc('lq3_1113')), '.6e') ,'# cLQ3Ph1113'],
	[328, format(angle(scaled_wc('lq3_1123')), '.6e') ,'# cLQ3Ph1123'],
	[329, format(angle(scaled_wc('lq3_1211')), '.6e') ,'# cLQ3Ph1211'],
	[330, format(angle(scaled_wc('lq3_1212')), '.6e') ,'# cLQ3Ph1212'],
	[331, format(angle(scaled_wc('lq3_1221')), '.6e') ,'# cLQ3Ph1221'],
	[332, format(angle(scaled_wc('lq3_1213')), '.6e') ,'# cLQ3Ph1213'],
	[333, format(angle(scaled_wc('lq3_1231')), '.6e') ,'# cLQ3Ph1231'],
	[334, format(angle(scaled_wc('lq3_1222')), '.6e') ,'# cLQ3Ph1222'],
	[335, format(angle(scaled_wc('lq3_1223')), '.6e') ,'# cLQ3Ph1223'],
	[336, format(angle(scaled_wc('lq3_1232')), '.6e') ,'# cLQ3Ph1232'],
	[337, format(angle(scaled_wc('lq3_1233')), '.6e') ,'# cLQ3Ph1233'],
	[338, format(angle(scaled_wc('lq3_1311')), '.6e') ,'# cLQ3Ph1311'],
	[339, format(angle(scaled_wc('lq3_1312')), '.6e') ,'# cLQ3Ph1312'],
	[340, format(angle(scaled_wc('lq3_1313')), '.6e') ,'# cLQ3Ph1313'],
	[341, format(angle(scaled_wc('lq3_1331')), '.6e') ,'# cLQ3Ph1331'],
	[342, format(angle(scaled_wc('lq3_1321')), '.6e') ,'# cLQ3Ph1321'],
	[343, format(angle(scaled_wc('lq3_1322')), '.6e') ,'# cLQ3Ph1322'],
	[344, format(angle(scaled_wc('lq3_1332')), '.6e') ,'# cLQ3Ph1332'],
	[345, format(angle(scaled_wc('lq3_1323')), '.6e') ,'# cLQ3Ph1323'],
	[346, format(angle(scaled_wc('lq3_1333')), '.6e') ,'# cLQ3Ph1333'],
	[347, format(angle(scaled_wc('lq3_2213')), '.6e') ,'# cLQ3Ph2213'],
	[348, format(angle(scaled_wc('lq3_2223')), '.6e') ,'# cLQ3Ph2223'],
	[349, format(angle(scaled_wc('lq3_2311')), '.6e') ,'# cLQ3Ph2311'],
	[350, format(angle(scaled_wc('lq3_2312')), '.6e') ,'# cLQ3Ph2312'],
	[351, format(angle(scaled_wc('lq3_2313')), '.6e') ,'# cLQ3Ph2313'],
	[352, format(angle(scaled_wc('lq3_2321')), '.6e') ,'# cLQ3Ph2321'],
	[353, format(angle(scaled_wc('lq3_2322')), '.6e') ,'# cLQ3Ph2322'],
	[354, format(angle(scaled_wc('lq3_2323')), '.6e') ,'# cLQ3Ph2323'],
	[355, format(angle(scaled_wc('lq3_2331')), '.6e') ,'# cLQ3Ph2331'],
	[356, format(angle(scaled_wc('lq3_2332')), '.6e') ,'# cLQ3Ph2332'],
	[357, format(angle(scaled_wc('lq3_2333')), '.6e') ,'# cLQ3Ph2333'],
	[358, format(angle(scaled_wc('lq3_3323')), '.6e') ,'# cLQ3Ph3323'],
	[359, format(angle(scaled_wc('lq3_3312')), '.6e') ,'# cLQ3Ph3312'],
	[360, format(angle(scaled_wc('lq3_3313')), '.6e') ,'# cLQ3Ph3313'],
	[361, format(scaled_wc('uu_1111')* lambda_smeft_value**2, '.6e') ,'# cuuAbs1111'],
	[362, format(scaled_wc('uu_1122')* lambda_smeft_value**2, '.6e') ,'# cuuAbs1122'],
	[363, format(scaled_wc('uu_1221')* lambda_smeft_value**2, '.6e') ,'# cuuAbs1221'],
	[364, format(scaled_wc('uu_1133')* lambda_smeft_value**2, '.6e') ,'# cuuAbs1133'],
	[365, format(scaled_wc('uu_1331')* lambda_smeft_value**2, '.6e') ,'# cuuAbs1331'],
	[366, format(scaled_wc('uu_2222')* lambda_smeft_value**2, '.6e') ,'# cuuAbs2222'],
	[367, format(scaled_wc('uu_2233')* lambda_smeft_value**2, '.6e') ,'# cuuAbs2233'],
	[368, format(scaled_wc('uu_2332')* lambda_smeft_value**2, '.6e') ,'# cuuAbs2332'],
	[369, format(scaled_wc('uu_3333')* lambda_smeft_value**2, '.6e') ,'# cuuAbs3333'],
	[370, format(abs(scaled_wc('uu_1112'))* lambda_smeft_value**2, '.6e') ,'# cuuAbs1112'],
	[371, format(abs(scaled_wc('uu_1113'))* lambda_smeft_value**2, '.6e') ,'# cuuAbs1113'],
	[372, format(abs(scaled_wc('uu_1123'))* lambda_smeft_value**2, '.6e') ,'# cuuAbs1123'],
	[373, format(abs(scaled_wc('uu_1212'))* lambda_smeft_value**2, '.6e') ,'# cuuAbs1212'],
	[374, format(abs(scaled_wc('uu_1213'))* lambda_smeft_value**2, '.6e') ,'# cuuAbs1213'],
	[375, format(abs(scaled_wc('uu_1231'))* lambda_smeft_value**2, '.6e') ,'# cuuAbs1231'],
	[376, format(abs(scaled_wc('uu_1222'))* lambda_smeft_value**2, '.6e') ,'# cuuAbs1222'],
	[377, format(abs(scaled_wc('uu_1223'))* lambda_smeft_value**2, '.6e') ,'# cuuAbs1223'],
	[378, format(abs(scaled_wc('uu_1232'))* lambda_smeft_value**2, '.6e') ,'# cuuAbs1232'],
	[379, format(abs(scaled_wc('uu_1233'))* lambda_smeft_value**2, '.6e') ,'# cuuAbs1233'],
	[380, format(abs(scaled_wc('uu_1313'))* lambda_smeft_value**2, '.6e') ,'# cuuAbs1313'],
	[381, format(abs(scaled_wc('uu_1322'))* lambda_smeft_value**2, '.6e') ,'# cuuAbs1322'],
	[382, format(abs(scaled_wc('uu_1332'))* lambda_smeft_value**2, '.6e') ,'# cuuAbs1332'],
	[383, format(abs(scaled_wc('uu_1323'))* lambda_smeft_value**2, '.6e') ,'# cuuAbs1323'],
	[384, format(abs(scaled_wc('uu_1333'))* lambda_smeft_value**2, '.6e') ,'# cuuAbs1333'],
	[385, format(abs(scaled_wc('uu_2223'))* lambda_smeft_value**2, '.6e') ,'# cuuAbs2223'],
	[386, format(abs(scaled_wc('uu_2323'))* lambda_smeft_value**2, '.6e') ,'# cuuAbs2323'],
	[387, format(abs(scaled_wc('uu_2333'))* lambda_smeft_value**2, '.6e') ,'# cuuAbs3323'],
	[388, format(angle(scaled_wc('uu_1112')), '.6e') ,'# cuuPh1112'],
	[389, format(angle(scaled_wc('uu_1113')), '.6e') ,'# cuuPh1113'],
	[390, format(angle(scaled_wc('uu_1123')), '.6e') ,'# cuuPh1123'],
	[391, format(angle(scaled_wc('uu_1212')), '.6e') ,'# cuuPh1212'],
	[392, format(angle(scaled_wc('uu_1213')), '.6e') ,'# cuuPh1213'],
	[393, format(angle(scaled_wc('uu_1231')), '.6e') ,'# cuuPh1231'],
	[394, format(angle(scaled_wc('uu_1222')), '.6e') ,'# cuuPh1222'],
	[395, format(angle(scaled_wc('uu_1223')), '.6e') ,'# cuuPh1223'],
	[396, format(angle(scaled_wc('uu_1232')), '.6e') ,'# cuuPh1232'],
	[397, format(angle(scaled_wc('uu_1233')), '.6e') ,'# cuuPh1233'],
	[398, format(angle(scaled_wc('uu_1313')), '.6e') ,'# cuuPh1313'],
	[399, format(angle(scaled_wc('uu_1322')), '.6e') ,'# cuuPh1322'],
	[400, format(angle(scaled_wc('uu_1332')), '.6e') ,'# cuuPh1332'],
	[401, format(angle(scaled_wc('uu_1323')), '.6e') ,'# cuuPh1323'],
	[402, format(angle(scaled_wc('uu_1333')), '.6e') ,'# cuuPh1333'],
	[403, format(angle(scaled_wc('uu_2223')), '.6e') ,'# cuuPh2223'],
	[404, format(angle(scaled_wc('uu_2323')), '.6e') ,'# cuuPh2323'],
	[405, format(angle(scaled_wc('uu_2333')), '.6e') ,'# cuuPh3323'],
	[406, format(scaled_wc('dd_1111')* lambda_smeft_value**2, '.6e') ,'# cddAbs1111'],
	[407, format(scaled_wc('dd_1122')* lambda_smeft_value**2, '.6e') ,'# cddAbs1122'],
	[408, format(scaled_wc('dd_1221')* lambda_smeft_value**2, '.6e') ,'# cddAbs1221'],
	[409, format(scaled_wc('dd_1133')* lambda_smeft_value**2, '.6e') ,'# cddAbs1133'],
	[410, format(scaled_wc('dd_1331')* lambda_smeft_value**2, '.6e') ,'# cddAbs1331'],
	[411, format(scaled_wc('dd_2222')* lambda_smeft_value**2, '.6e') ,'# cddAbs2222'],
	[412, format(scaled_wc('dd_2233')* lambda_smeft_value**2, '.6e') ,'# cddAbs2233'],
	[413, format(scaled_wc('dd_2332')* lambda_smeft_value**2, '.6e') ,'# cddAbs2332'],
	[414, format(scaled_wc('dd_3333')* lambda_smeft_value**2, '.6e') ,'# cddAbs3333'],
	[415, format(abs(scaled_wc('dd_1112'))* lambda_smeft_value**2, '.6e') ,'# cddAbs1112'],
	[416, format(abs(scaled_wc('dd_1113'))* lambda_smeft_value**2, '.6e') ,'# cddAbs1113'],
	[417, format(abs(scaled_wc('dd_1123'))* lambda_smeft_value**2, '.6e') ,'# cddAbs1123'],
	[418, format(abs(scaled_wc('dd_1212'))* lambda_smeft_value**2, '.6e') ,'# cddAbs1212'],
	[419, format(abs(scaled_wc('dd_1213'))* lambda_smeft_value**2, '.6e') ,'# cddAbs1213'],
	[420, format(abs(scaled_wc('dd_1231'))* lambda_smeft_value**2, '.6e') ,'# cddAbs1231'],
	[421, format(abs(scaled_wc('dd_1222'))* lambda_smeft_value**2, '.6e') ,'# cddAbs1222'],
	[422, format(abs(scaled_wc('dd_1223'))* lambda_smeft_value**2, '.6e') ,'# cddAbs1223'],
	[423, format(abs(scaled_wc('dd_1232'))* lambda_smeft_value**2, '.6e') ,'# cddAbs1232'],
	[424, format(abs(scaled_wc('dd_1233'))* lambda_smeft_value**2, '.6e') ,'# cddAbs1233'],
	[425, format(abs(scaled_wc('dd_1313'))* lambda_smeft_value**2, '.6e') ,'# cddAbs1313'],
	[426, format(abs(scaled_wc('dd_1322'))* lambda_smeft_value**2, '.6e') ,'# cddAbs1322'],
	[427, format(abs(scaled_wc('dd_1332'))* lambda_smeft_value**2, '.6e') ,'# cddAbs1332'],
	[428, format(abs(scaled_wc('dd_1323'))* lambda_smeft_value**2, '.6e') ,'# cddAbs1323'],
	[429, format(abs(scaled_wc('dd_1333'))* lambda_smeft_value**2, '.6e') ,'# cddAbs1333'],
	[430, format(abs(scaled_wc('dd_2223'))* lambda_smeft_value**2, '.6e') ,'# cddAbs2223'],
	[431, format(abs(scaled_wc('dd_2323'))* lambda_smeft_value**2, '.6e') ,'# cddAbs2323'],
	[432, format(abs(scaled_wc('dd_2333'))* lambda_smeft_value**2, '.6e') ,'# cddAbs3323'],
	[433, format(angle(scaled_wc('dd_1112')), '.6e') ,'# cddPh1112'],
	[434, format(angle(scaled_wc('dd_1113')), '.6e') ,'# cddPh1113'],
	[435, format(angle(scaled_wc('dd_1123')), '.6e') ,'# cddPh1123'],
	[436, format(angle(scaled_wc('dd_1212')), '.6e') ,'# cddPh1212'],
	[437, format(angle(scaled_wc('dd_1213')), '.6e') ,'# cddPh1213'],
	[438, format(angle(scaled_wc('dd_1231')), '.6e') ,'# cddPh1231'],
	[439, format(angle(scaled_wc('dd_1222')), '.6e') ,'# cddPh1222'],
	[440, format(angle(scaled_wc('dd_1223')), '.6e') ,'# cddPh1223'],
	[441, format(angle(scaled_wc('dd_1232')), '.6e') ,'# cddPh1232'],
	[442, format(angle(scaled_wc('dd_1233')), '.6e') ,'# cddPh1233'],
	[443, format(angle(scaled_wc('dd_1313')), '.6e') ,'# cddPh1313'],
	[444, format(angle(scaled_wc('dd_1322')), '.6e') ,'# cddPh1322'],
	[445, format(angle(scaled_wc('dd_1332')), '.6e') ,'# cddPh1332'],
	[446, format(angle(scaled_wc('dd_1323')), '.6e') ,'# cddPh1323'],
	[447, format(angle(scaled_wc('dd_1333')), '.6e') ,'# cddPh1333'],
	[448, format(angle(scaled_wc('dd_2223')), '.6e') ,'# cddPh2223'],
	[449, format(angle(scaled_wc('dd_2323')), '.6e') ,'# cddPh2323'],
	[450, format(angle(scaled_wc('dd_2333')), '.6e') ,'# cddPh3323'],
	[451, format(scaled_wc('ee_1111')* lambda_smeft_value**2, '.6e') ,'# ceeAbs1111'],
	[452, format(scaled_wc('ee_2222')* lambda_smeft_value**2, '.6e') ,'# ceeAbs2222'],
	[453, format(scaled_wc('ee_3333')* lambda_smeft_value**2, '.6e') ,'# ceeAbs3333'],
	[454, format(scaled_wc('ee_1122')* lambda_smeft_value**2, '.6e') ,'# ceeAbs1122'],
	[455, format(scaled_wc('ee_1133')* lambda_smeft_value**2, '.6e') ,'# ceeAbs1133'],
	[456, format(scaled_wc('ee_2233')* lambda_smeft_value**2, '.6e') ,'# ceeAbs2233'],
	[457, format(abs(scaled_wc('ee_1212'))* lambda_smeft_value**2, '.6e') ,'# ceeAbs1212'],
	[458, format(abs(scaled_wc('ee_1213'))* lambda_smeft_value**2, '.6e') ,'# ceeAbs1213'],
	[459, format(abs(scaled_wc('ee_1232'))* lambda_smeft_value**2, '.6e') ,'# ceeAbs1232'],
	[460, format(abs(scaled_wc('ee_1313'))* lambda_smeft_value**2, '.6e') ,'# ceeAbs1313'],
	[461, format(abs(scaled_wc('ee_1323'))* lambda_smeft_value**2, '.6e') ,'# ceeAbs1323'],
	[462, format(abs(scaled_wc('ee_2323'))* lambda_smeft_value**2, '.6e') ,'# ceeAbs2323'],
	[463, format(abs(scaled_wc('ee_1112'))* lambda_smeft_value**2, '.6e') ,'# ceeAbs1112'],
	[464, format(abs(scaled_wc('ee_1222'))* lambda_smeft_value**2, '.6e') ,'# ceeAbs1222'],
	[465, format(abs(scaled_wc('ee_1233'))* lambda_smeft_value**2, '.6e') ,'# ceeAbs1233'],
	[466, format(abs(scaled_wc('ee_1113'))* lambda_smeft_value**2, '.6e') ,'# ceeAbs1113'],
	[467, format(abs(scaled_wc('ee_1223'))* lambda_smeft_value**2, '.6e') ,'# ceeAbs1322'], # element 1322 replaced with 1223 in wcxf
	[468, format(abs(scaled_wc('ee_1333'))* lambda_smeft_value**2, '.6e') ,'# ceeAbs1333'],
	[469, format(abs(scaled_wc('ee_1123'))* lambda_smeft_value**2, '.6e') ,'# ceeAbs1123'],
	[470, format(abs(scaled_wc('ee_2223'))* lambda_smeft_value**2, '.6e') ,'# ceeAbs2223'],
	[471, format(abs(scaled_wc('ee_2333'))* lambda_smeft_value**2, '.6e') ,'# ceeAbs3323'],
	[472, format(angle(scaled_wc('ee_1112')), '.6e') ,'# ceePh1112'],
	[473, format(angle(scaled_wc('ee_1113')), '.6e') ,'# ceePh1113'],
	[474, format(angle(scaled_wc('ee_1123')), '.6e') ,'# ceePh1123'],
	[475, format(angle(scaled_wc('ee_1212')), '.6e') ,'# ceePh1212'],
	[476, format(angle(scaled_wc('ee_1213')), '.6e') ,'# ceePh1213'],
	[477, format(angle(scaled_wc('ee_1323')), '.6e') ,'# ceePh1323'],
	[478, format(angle(scaled_wc('ee_1222')), '.6e') ,'# ceePh1222'],
	[479, format(angle(scaled_wc('ee_2333')), '.6e') ,'# ceePh3323'],
	[480, format(angle(scaled_wc('ee_1232')), '.6e') ,'# ceePh1232'],
	[481, format(angle(scaled_wc('ee_1233')), '.6e') ,'# ceePh1233'],
	[482, format(angle(scaled_wc('ee_1313')), '.6e') ,'# ceePh1313'],
	[483, format(angle(scaled_wc('ee_1223')), '.6e') ,'# ceePh1322'], # element 1322 replaced with 1223 in wcxf
	[484, format(angle(scaled_wc('ee_1333')), '.6e') ,'# ceePh1333'],
	[485, format(angle(scaled_wc('ee_2223')), '.6e') ,'# ceePh2223'],
	[486, format(angle(scaled_wc('ee_2323')), '.6e') ,'# ceePh2323'],
	[487, format(scaled_wc('ud1_1111')* lambda_smeft_value**2, '.6e') ,'# cud1Abs1111'],
	[488, format(abs(scaled_wc('ud1_1112'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs1112'],
	[489, format(abs(scaled_wc('ud1_1113'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs1113'],
	[490, format(abs(scaled_wc('ud1_1123'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs1123'],
	[491, format(scaled_wc('ud1_1122')* lambda_smeft_value**2, '.6e') ,'# cud1Abs1122'],
	[492, format(scaled_wc('ud1_1133')* lambda_smeft_value**2, '.6e') ,'# cud1Abs1133'],
	[493, format(abs(scaled_wc('ud1_1211'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs1211'],
	[494, format(abs(scaled_wc('ud1_1212'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs1212'],
	[495, format(abs(scaled_wc('ud1_1221'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs1221'],
	[496, format(abs(scaled_wc('ud1_1213'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs1213'],
	[497, format(abs(scaled_wc('ud1_1231'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs1231'],
	[498, format(abs(scaled_wc('ud1_1222'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs1222'],
	[499, format(abs(scaled_wc('ud1_1223'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs1223'],
	[500, format(abs(scaled_wc('ud1_1232'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs1232'],
	[501, format(abs(scaled_wc('ud1_1233'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs1233'],
	[502, format(abs(scaled_wc('ud1_1311'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs1311'],
	[503, format(abs(scaled_wc('ud1_1312'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs1312'],
	[504, format(abs(scaled_wc('ud1_1313'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs1313'],
	[505, format(abs(scaled_wc('ud1_1331'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs1331'],
	[506, format(abs(scaled_wc('ud1_1321'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs1321'],
	[507, format(abs(scaled_wc('ud1_1322'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs1322'],
	[508, format(abs(scaled_wc('ud1_1332'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs1332'],
	[509, format(abs(scaled_wc('ud1_1323'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs1323'],
	[510, format(abs(scaled_wc('ud1_1333'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs1333'],
	[511, format(scaled_wc('ud1_2211')* lambda_smeft_value**2, '.6e') ,'# cud1Abs2211'],
	[512, format(abs(scaled_wc('ud1_2212'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs2212'],
	[513, format(abs(scaled_wc('ud1_2213'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs2213'],
	[514, format(scaled_wc('ud1_2222')* lambda_smeft_value**2, '.6e') ,'# cud1Abs2222'],
	[515, format(abs(scaled_wc('ud1_2223'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs2223'],
	[516, format(scaled_wc('ud1_2233')* lambda_smeft_value**2, '.6e') ,'# cud1Abs2233'],
	[517, format(abs(scaled_wc('ud1_2311'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs2311'],
	[518, format(abs(scaled_wc('ud1_2312'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs2312'],
	[519, format(abs(scaled_wc('ud1_2313'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs2313'],
	[520, format(abs(scaled_wc('ud1_2321'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs2321'],
	[521, format(abs(scaled_wc('ud1_2322'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs2322'],
	[522, format(abs(scaled_wc('ud1_2323'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs2323'],
	[523, format(abs(scaled_wc('ud1_2331'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs2331'],
	[524, format(abs(scaled_wc('ud1_2332'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs2332'],
	[525, format(abs(scaled_wc('ud1_2333'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs2333'],
	[526, format(scaled_wc('ud1_3311')* lambda_smeft_value**2, '.6e') ,'# cud1Abs3311'],
	[527, format(abs(scaled_wc('ud1_3312'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs3312'],
	[528, format(abs(scaled_wc('ud1_3313'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs3313'],
	[529, format(scaled_wc('ud1_3322')* lambda_smeft_value**2, '.6e') ,'# cud1Abs3322'],
	[530, format(scaled_wc('ud1_3333')* lambda_smeft_value**2, '.6e') ,'# cud1Abs3333'],
	[531, format(abs(scaled_wc('ud1_3323'))* lambda_smeft_value**2, '.6e') ,'# cud1Abs3323'],
	[532, format(angle(scaled_wc('ud1_1112')), '.6e') ,'# cud1Ph1112'],
	[533, format(angle(scaled_wc('ud1_2212')), '.6e') ,'# cud1Ph2212'],
	[534, format(angle(scaled_wc('ud1_1113')), '.6e') ,'# cud1Ph1113'],
	[535, format(angle(scaled_wc('ud1_1123')), '.6e') ,'# cud1Ph1123'],
	[536, format(angle(scaled_wc('ud1_1211')), '.6e') ,'# cud1Ph1211'],
	[537, format(angle(scaled_wc('ud1_1212')), '.6e') ,'# cud1Ph1212'],
	[538, format(angle(scaled_wc('ud1_1221')), '.6e') ,'# cud1Ph1221'],
	[539, format(angle(scaled_wc('ud1_1213')), '.6e') ,'# cud1Ph1213'],
	[540, format(angle(scaled_wc('ud1_1231')), '.6e') ,'# cud1Ph1231'],
	[541, format(angle(scaled_wc('ud1_1222')), '.6e') ,'# cud1Ph1222'],
	[542, format(angle(scaled_wc('ud1_1223')), '.6e') ,'# cud1Ph1223'],
	[543, format(angle(scaled_wc('ud1_1232')), '.6e') ,'# cud1Ph1232'],
	[544, format(angle(scaled_wc('ud1_1233')), '.6e') ,'# cud1Ph1233'],
	[545, format(angle(scaled_wc('ud1_1311')), '.6e') ,'# cud1Ph1311'],
	[546, format(angle(scaled_wc('ud1_1312')), '.6e') ,'# cud1Ph1312'],
	[547, format(angle(scaled_wc('ud1_1313')), '.6e') ,'# cud1Ph1313'],
	[548, format(angle(scaled_wc('ud1_1331')), '.6e') ,'# cud1Ph1331'],
	[549, format(angle(scaled_wc('ud1_1321')), '.6e') ,'# cud1Ph1321'],
	[550, format(angle(scaled_wc('ud1_1322')), '.6e') ,'# cud1Ph1322'],
	[551, format(angle(scaled_wc('ud1_1332')), '.6e') ,'# cud1Ph1332'],
	[552, format(angle(scaled_wc('ud1_1323')), '.6e') ,'# cud1Ph1323'],
	[553, format(angle(scaled_wc('ud1_1333')), '.6e') ,'# cud1Ph1333'],
	[554, format(angle(scaled_wc('ud1_2213')), '.6e') ,'# cud1Ph2213'],
	[555, format(angle(scaled_wc('ud1_2223')), '.6e') ,'# cud1Ph2223'],
	[556, format(angle(scaled_wc('ud1_2311')), '.6e') ,'# cud1Ph2311'],
	[557, format(angle(scaled_wc('ud1_2312')), '.6e') ,'# cud1Ph2312'],
	[558, format(angle(scaled_wc('ud1_2313')), '.6e') ,'# cud1Ph2313'],
	[559, format(angle(scaled_wc('ud1_2321')), '.6e') ,'# cud1Ph2321'],
	[560, format(angle(scaled_wc('ud1_2322')), '.6e') ,'# cud1Ph2322'],
	[561, format(angle(scaled_wc('ud1_2323')), '.6e') ,'# cud1Ph2323'],
	[562, format(angle(scaled_wc('ud1_2331')), '.6e') ,'# cud1Ph2331'],
	[563, format(angle(scaled_wc('ud1_2332')), '.6e') ,'# cud1Ph2332'],
	[564, format(angle(scaled_wc('ud1_2333')), '.6e') ,'# cud1Ph2333'],
	[565, format(angle(scaled_wc('ud1_3323')), '.6e') ,'# cud1Ph3323'],
	[566, format(angle(scaled_wc('ud1_3312')), '.6e') ,'# cud1Ph3312'],
	[567, format(angle(scaled_wc('ud1_3313')), '.6e') ,'# cud1Ph3313'],
	[568, format(scaled_wc('ud8_1111')* lambda_smeft_value**2, '.6e') ,'# cUD8Abs1111'],
	[569, format(abs(scaled_wc('ud8_1112'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs1112'],
	[570, format(abs(scaled_wc('ud8_1113'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs1113'],
	[571, format(abs(scaled_wc('ud8_1123'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs1123'],
	[572, format(scaled_wc('ud8_1122')* lambda_smeft_value**2, '.6e') ,'# cUD8Abs1122'],
	[573, format(scaled_wc('ud8_1133')* lambda_smeft_value**2, '.6e') ,'# cUD8Abs1133'],
	[574, format(abs(scaled_wc('ud8_1211'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs1211'],
	[575, format(abs(scaled_wc('ud8_1212'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs1212'],
	[576, format(abs(scaled_wc('ud8_1221'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs1221'],
	[577, format(abs(scaled_wc('ud8_1213'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs1213'],
	[578, format(abs(scaled_wc('ud8_1231'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs1231'],
	[579, format(abs(scaled_wc('ud8_1222'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs1222'],
	[580, format(abs(scaled_wc('ud8_1223'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs1223'],
	[581, format(abs(scaled_wc('ud8_1232'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs1232'],
	[582, format(abs(scaled_wc('ud8_1233'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs1233'],
	[583, format(abs(scaled_wc('ud8_1311'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs1311'],
	[584, format(abs(scaled_wc('ud8_1312'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs1312'],
	[585, format(abs(scaled_wc('ud8_1313'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs1313'],
	[586, format(abs(scaled_wc('ud8_1331'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs1331'],
	[587, format(abs(scaled_wc('ud8_1321'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs1321'],
	[588, format(abs(scaled_wc('ud8_1322'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs1322'],
	[589, format(abs(scaled_wc('ud8_1332'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs1332'],
	[590, format(abs(scaled_wc('ud8_1323'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs1323'],
	[591, format(abs(scaled_wc('ud8_1333'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs1333'],
	[592, format(scaled_wc('ud8_2211')* lambda_smeft_value**2, '.6e') ,'# cUD8Abs2211'],
	[593, format(abs(scaled_wc('ud8_2212'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs2212'],
	[594, format(abs(scaled_wc('ud8_2213'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs2213'],
	[595, format(scaled_wc('ud8_2222')* lambda_smeft_value**2, '.6e') ,'# cUD8Abs2222'],
	[596, format(abs(scaled_wc('ud8_2223'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs2223'],
	[597, format(scaled_wc('ud8_2233')* lambda_smeft_value**2, '.6e') ,'# cUD8Abs2233'],
	[598, format(abs(scaled_wc('ud8_2311'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs2311'],
	[599, format(abs(scaled_wc('ud8_2312'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs2312'],
	[600, format(abs(scaled_wc('ud8_2313'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs2313'],
	[601, format(abs(scaled_wc('ud8_2321'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs2321'],
	[602, format(abs(scaled_wc('ud8_2322'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs2322'],
	[603, format(abs(scaled_wc('ud8_2323'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs2323'],
	[604, format(abs(scaled_wc('ud8_2331'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs2331'],
	[605, format(abs(scaled_wc('ud8_2332'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs2332'],
	[606, format(abs(scaled_wc('ud8_2333'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs2333'],
	[607, format(scaled_wc('ud8_3311')* lambda_smeft_value**2, '.6e') ,'# cUD8Abs3311'],
	[608, format(abs(scaled_wc('ud8_3312'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs3312'],
	[609, format(abs(scaled_wc('ud8_3313'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs3313'],
	[610, format(scaled_wc('ud8_3322')* lambda_smeft_value**2, '.6e') ,'# cUD8Abs3322'],
	[611, format(scaled_wc('ud8_3333')* lambda_smeft_value**2, '.6e') ,'# cUD8Abs3333'],
	[612, format(abs(scaled_wc('ud8_3323'))* lambda_smeft_value**2, '.6e') ,'# cUD8Abs3323'],
	[613, format(angle(scaled_wc('ud8_1112')), '.6e') ,'# cUD8Ph1112'],
	[614, format(angle(scaled_wc('ud8_2212')), '.6e') ,'# cUD8Ph2212'],
	[615, format(angle(scaled_wc('ud8_1113')), '.6e') ,'# cUD8Ph1113'],
	[616, format(angle(scaled_wc('ud8_1123')), '.6e') ,'# cUD8Ph1123'],
	[617, format(angle(scaled_wc('ud8_1211')), '.6e') ,'# cUD8Ph1211'],
	[618, format(angle(scaled_wc('ud8_1212')), '.6e') ,'# cUD8Ph1212'],
	[619, format(angle(scaled_wc('ud8_1221')), '.6e') ,'# cUD8Ph1221'],
	[620, format(angle(scaled_wc('ud8_1213')), '.6e') ,'# cUD8Ph1213'],
	[621, format(angle(scaled_wc('ud8_1231')), '.6e') ,'# cUD8Ph1231'],
	[622, format(angle(scaled_wc('ud8_1222')), '.6e') ,'# cUD8Ph1222'],
	[623, format(angle(scaled_wc('ud8_1223')), '.6e') ,'# cUD8Ph1223'],
	[624, format(angle(scaled_wc('ud8_1232')), '.6e') ,'# cUD8Ph1232'],
	[625, format(angle(scaled_wc('ud8_1233')), '.6e') ,'# cUD8Ph1233'],
	[626, format(angle(scaled_wc('ud8_1311')), '.6e') ,'# cUD8Ph1311'],
	[627, format(angle(scaled_wc('ud8_1312')), '.6e') ,'# cUD8Ph1312'],
	[628, format(angle(scaled_wc('ud8_1313')), '.6e') ,'# cUD8Ph1313'],
	[629, format(angle(scaled_wc('ud8_1331')), '.6e') ,'# cUD8Ph1331'],
	[630, format(angle(scaled_wc('ud8_1321')), '.6e') ,'# cUD8Ph1321'],
	[631, format(angle(scaled_wc('ud8_1322')), '.6e') ,'# cUD8Ph1322'],
	[632, format(angle(scaled_wc('ud8_1332')), '.6e') ,'# cUD8Ph1332'],
	[633, format(angle(scaled_wc('ud8_1323')), '.6e') ,'# cUD8Ph1323'],
	[634, format(angle(scaled_wc('ud8_1333')), '.6e') ,'# cUD8Ph1333'],
	[635, format(angle(scaled_wc('ud8_2213')), '.6e') ,'# cUD8Ph2213'],
	[636, format(angle(scaled_wc('ud8_2223')), '.6e') ,'# cUD8Ph2223'],
	[637, format(angle(scaled_wc('ud8_2311')), '.6e') ,'# cUD8Ph2311'],
	[638, format(angle(scaled_wc('ud8_2312')), '.6e') ,'# cUD8Ph2312'],
	[639, format(angle(scaled_wc('ud8_2313')), '.6e') ,'# cUD8Ph2313'],
	[640, format(angle(scaled_wc('ud8_2321')), '.6e') ,'# cUD8Ph2321'],
	[641, format(angle(scaled_wc('ud8_2322')), '.6e') ,'# cUD8Ph2322'],
	[642, format(angle(scaled_wc('ud8_2323')), '.6e') ,'# cUD8Ph2323'],
	[643, format(angle(scaled_wc('ud8_2331')), '.6e') ,'# cUD8Ph2331'],
	[644, format(angle(scaled_wc('ud8_2332')), '.6e') ,'# cUD8Ph2332'],
	[645, format(angle(scaled_wc('ud8_2333')), '.6e') ,'# cUD8Ph2333'],
	[646, format(angle(scaled_wc('ud8_3323')), '.6e') ,'# cUD8Ph3323'],
	[647, format(angle(scaled_wc('ud8_3312')), '.6e') ,'# cUD8Ph3312'],
	[648, format(angle(scaled_wc('ud8_3313')), '.6e') ,'# cUD8Ph3313'],
	[649, format(scaled_wc('eu_1111')* lambda_smeft_value**2, '.6e') ,'# ceuAbs1111'],
	[650, format(abs(scaled_wc('eu_1112'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs1112'],
	[651, format(abs(scaled_wc('eu_1113'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs1113'],
	[652, format(abs(scaled_wc('eu_1123'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs1123'],
	[653, format(scaled_wc('eu_1122')* lambda_smeft_value**2, '.6e') ,'# ceuAbs1122'],
	[654, format(scaled_wc('eu_1133')* lambda_smeft_value**2, '.6e') ,'# ceuAbs1133'],
	[655, format(abs(scaled_wc('eu_1211'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs1211'],
	[656, format(abs(scaled_wc('eu_1212'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs1212'],
	[657, format(abs(scaled_wc('eu_1221'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs1221'],
	[658, format(abs(scaled_wc('eu_1213'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs1213'],
	[659, format(abs(scaled_wc('eu_1231'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs1231'],
	[660, format(abs(scaled_wc('eu_1222'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs1222'],
	[661, format(abs(scaled_wc('eu_1223'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs1223'],
	[662, format(abs(scaled_wc('eu_1232'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs1232'],
	[663, format(abs(scaled_wc('eu_1233'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs1233'],
	[664, format(abs(scaled_wc('eu_1311'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs1311'],
	[665, format(abs(scaled_wc('eu_1312'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs1312'],
	[666, format(abs(scaled_wc('eu_1313'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs1313'],
	[667, format(abs(scaled_wc('eu_1331'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs1331'],
	[668, format(abs(scaled_wc('eu_1321'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs1321'],
	[669, format(abs(scaled_wc('eu_1322'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs1322'],
	[670, format(abs(scaled_wc('eu_1332'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs1332'],
	[671, format(abs(scaled_wc('eu_1323'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs1323'],
	[672, format(abs(scaled_wc('eu_1333'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs1333'],
	[673, format(scaled_wc('eu_2211')* lambda_smeft_value**2, '.6e') ,'# ceuAbs2211'],
	[674, format(abs(scaled_wc('eu_2212'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs2212'],
	[675, format(abs(scaled_wc('eu_2213'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs2213'],
	[676, format(scaled_wc('eu_2222')* lambda_smeft_value**2, '.6e') ,'# ceuAbs2222'],
	[677, format(abs(scaled_wc('eu_2223'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs2223'],
	[678, format(scaled_wc('eu_2233')* lambda_smeft_value**2, '.6e') ,'# ceuAbs2233'],
	[679, format(abs(scaled_wc('eu_2311'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs2311'],
	[680, format(abs(scaled_wc('eu_2312'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs2312'],
	[681, format(abs(scaled_wc('eu_2313'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs2313'],
	[682, format(abs(scaled_wc('eu_2321'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs2321'],
	[683, format(abs(scaled_wc('eu_2322'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs2322'],
	[684, format(abs(scaled_wc('eu_2323'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs2323'],
	[685, format(abs(scaled_wc('eu_2331'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs2331'],
	[686, format(abs(scaled_wc('eu_2332'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs2332'],
	[687, format(abs(scaled_wc('eu_2333'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs2333'],
	[688, format(scaled_wc('eu_3311')* lambda_smeft_value**2, '.6e') ,'# ceuAbs3311'],
	[689, format(abs(scaled_wc('eu_3312'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs3312'],
	[690, format(abs(scaled_wc('eu_3313'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs3313'],
	[691, format(scaled_wc('eu_3322')* lambda_smeft_value**2, '.6e') ,'# ceuAbs3322'],
	[692, format(scaled_wc('eu_3333')* lambda_smeft_value**2, '.6e') ,'# ceuAbs3333'],
	[693, format(abs(scaled_wc('eu_3323'))* lambda_smeft_value**2, '.6e') ,'# ceuAbs3323'],
	[694, format(angle(scaled_wc('eu_1112')), '.6e') ,'# ceuPh1112'],
	[695, format(angle(scaled_wc('eu_2212')), '.6e') ,'# ceuPh2212'],
	[696, format(angle(scaled_wc('eu_1113')), '.6e') ,'# ceuPh1113'],
	[697, format(angle(scaled_wc('eu_1123')), '.6e') ,'# ceuPh1123'],
	[698, format(angle(scaled_wc('eu_1211')), '.6e') ,'# ceuPh1211'],
	[699, format(angle(scaled_wc('eu_1212')), '.6e') ,'# ceuPh1212'],
	[700, format(angle(scaled_wc('eu_1221')), '.6e') ,'# ceuPh1221'],
	[701, format(angle(scaled_wc('eu_1213')), '.6e') ,'# ceuPh1213'],
	[702, format(angle(scaled_wc('eu_1231')), '.6e') ,'# ceuPh1231'],
	[703, format(angle(scaled_wc('eu_1222')), '.6e') ,'# ceuPh1222'],
	[704, format(angle(scaled_wc('eu_1223')), '.6e') ,'# ceuPh1223'],
	[705, format(angle(scaled_wc('eu_1232')), '.6e') ,'# ceuPh1232'],
	[706, format(angle(scaled_wc('eu_1233')), '.6e') ,'# ceuPh1233'],
	[707, format(angle(scaled_wc('eu_1311')), '.6e') ,'# ceuPh1311'],
	[708, format(angle(scaled_wc('eu_1312')), '.6e') ,'# ceuPh1312'],
	[709, format(angle(scaled_wc('eu_1313')), '.6e') ,'# ceuPh1313'],
	[710, format(angle(scaled_wc('eu_1331')), '.6e') ,'# ceuPh1331'],
	[711, format(angle(scaled_wc('eu_1321')), '.6e') ,'# ceuPh1321'],
	[712, format(angle(scaled_wc('eu_1322')), '.6e') ,'# ceuPh1322'],
	[713, format(angle(scaled_wc('eu_1332')), '.6e') ,'# ceuPh1332'],
	[714, format(angle(scaled_wc('eu_1323')), '.6e') ,'# ceuPh1323'],
	[715, format(angle(scaled_wc('eu_1333')), '.6e') ,'# ceuPh1333'],
	[716, format(angle(scaled_wc('eu_2213')), '.6e') ,'# ceuPh2213'],
	[717, format(angle(scaled_wc('eu_2223')), '.6e') ,'# ceuPh2223'],
	[718, format(angle(scaled_wc('eu_2311')), '.6e') ,'# ceuPh2311'],
	[719, format(angle(scaled_wc('eu_2312')), '.6e') ,'# ceuPh2312'],
	[720, format(angle(scaled_wc('eu_2313')), '.6e') ,'# ceuPh2313'],
	[721, format(angle(scaled_wc('eu_2321')), '.6e') ,'# ceuPh2321'],
	[722, format(angle(scaled_wc('eu_2322')), '.6e') ,'# ceuPh2322'],
	[723, format(angle(scaled_wc('eu_2323')), '.6e') ,'# ceuPh2323'],
	[724, format(angle(scaled_wc('eu_2331')), '.6e') ,'# ceuPh2331'],
	[725, format(angle(scaled_wc('eu_2332')), '.6e') ,'# ceuPh2332'],
	[726, format(angle(scaled_wc('eu_2333')), '.6e') ,'# ceuPh2333'],
	[727, format(angle(scaled_wc('eu_3323')), '.6e') ,'# ceuPh3323'],
	[728, format(angle(scaled_wc('eu_3312')), '.6e') ,'# ceuPh3312'],
	[729, format(angle(scaled_wc('eu_3313')), '.6e') ,'# ceuPh3313'],
	[730, format(scaled_wc('ed_1111')* lambda_smeft_value**2, '.6e') ,'# cedAbs1111'],
	[731, format(abs(scaled_wc('ed_1112'))* lambda_smeft_value**2, '.6e') ,'# cedAbs1112'],
	[732, format(abs(scaled_wc('ed_1113'))* lambda_smeft_value**2, '.6e') ,'# cedAbs1113'],
	[733, format(abs(scaled_wc('ed_1123'))* lambda_smeft_value**2, '.6e') ,'# cedAbs1123'],
	[734, format(scaled_wc('ed_1122')* lambda_smeft_value**2, '.6e') ,'# cedAbs1122'],
	[735, format(scaled_wc('ed_1133')* lambda_smeft_value**2, '.6e') ,'# cedAbs1133'],
	[736, format(abs(scaled_wc('ed_1211'))* lambda_smeft_value**2, '.6e') ,'# cedAbs1211'],
	[737, format(abs(scaled_wc('ed_1212'))* lambda_smeft_value**2, '.6e') ,'# cedAbs1212'],
	[738, format(abs(scaled_wc('ed_1221'))* lambda_smeft_value**2, '.6e') ,'# cedAbs1221'],
	[739, format(abs(scaled_wc('ed_1213'))* lambda_smeft_value**2, '.6e') ,'# cedAbs1213'],
	[740, format(abs(scaled_wc('ed_1231'))* lambda_smeft_value**2, '.6e') ,'# cedAbs1231'],
	[741, format(abs(scaled_wc('ed_1222'))* lambda_smeft_value**2, '.6e') ,'# cedAbs1222'],
	[742, format(abs(scaled_wc('ed_1223'))* lambda_smeft_value**2, '.6e') ,'# cedAbs1223'],
	[743, format(abs(scaled_wc('ed_1232'))* lambda_smeft_value**2, '.6e') ,'# cedAbs1232'],
	[744, format(abs(scaled_wc('ed_1233'))* lambda_smeft_value**2, '.6e') ,'# cedAbs1233'],
	[745, format(abs(scaled_wc('ed_1311'))* lambda_smeft_value**2, '.6e') ,'# cedAbs1311'],
	[746, format(abs(scaled_wc('ed_1312'))* lambda_smeft_value**2, '.6e') ,'# cedAbs1312'],
	[747, format(abs(scaled_wc('ed_1313'))* lambda_smeft_value**2, '.6e') ,'# cedAbs1313'],
	[748, format(abs(scaled_wc('ed_1331'))* lambda_smeft_value**2, '.6e') ,'# cedAbs1331'],
	[749, format(abs(scaled_wc('ed_1321'))* lambda_smeft_value**2, '.6e') ,'# cedAbs1321'],
	[750, format(abs(scaled_wc('ed_1322'))* lambda_smeft_value**2, '.6e') ,'# cedAbs1322'],
	[751, format(abs(scaled_wc('ed_1332'))* lambda_smeft_value**2, '.6e') ,'# cedAbs1332'],
	[752, format(abs(scaled_wc('ed_1323'))* lambda_smeft_value**2, '.6e') ,'# cedAbs1323'],
	[753, format(abs(scaled_wc('ed_1333'))* lambda_smeft_value**2, '.6e') ,'# cedAbs1333'],
	[754, format(scaled_wc('ed_2211')* lambda_smeft_value**2, '.6e') ,'# cedAbs2211'],
	[755, format(abs(scaled_wc('ed_2212'))* lambda_smeft_value**2, '.6e') ,'# cedAbs2212'],
	[756, format(abs(scaled_wc('ed_2213'))* lambda_smeft_value**2, '.6e') ,'# cedAbs2213'],
	[757, format(scaled_wc('ed_2222')* lambda_smeft_value**2, '.6e') ,'# cedAbs2222'],
	[758, format(abs(scaled_wc('ed_2223'))* lambda_smeft_value**2, '.6e') ,'# cedAbs2223'],
	[759, format(scaled_wc('ed_2233')* lambda_smeft_value**2, '.6e') ,'# cedAbs2233'],
	[760, format(abs(scaled_wc('ed_2311'))* lambda_smeft_value**2, '.6e') ,'# cedAbs2311'],
	[761, format(abs(scaled_wc('ed_2312'))* lambda_smeft_value**2, '.6e') ,'# cedAbs2312'],
	[762, format(abs(scaled_wc('ed_2313'))* lambda_smeft_value**2, '.6e') ,'# cedAbs2313'],
	[763, format(abs(scaled_wc('ed_2321'))* lambda_smeft_value**2, '.6e') ,'# cedAbs2321'],
	[764, format(abs(scaled_wc('ed_2322'))* lambda_smeft_value**2, '.6e') ,'# cedAbs2322'],
	[765, format(abs(scaled_wc('ed_2323'))* lambda_smeft_value**2, '.6e') ,'# cedAbs2323'],
	[766, format(abs(scaled_wc('ed_2331'))* lambda_smeft_value**2, '.6e') ,'# cedAbs2331'],
	[767, format(abs(scaled_wc('ed_2332'))* lambda_smeft_value**2, '.6e') ,'# cedAbs2332'],
	[768, format(abs(scaled_wc('ed_2333'))* lambda_smeft_value**2, '.6e') ,'# cedAbs2333'],
	[769, format(scaled_wc('ed_3311')* lambda_smeft_value**2, '.6e') ,'# cedAbs3311'],
	[770, format(abs(scaled_wc('ed_3312'))* lambda_smeft_value**2, '.6e') ,'# cedAbs3312'],
	[771, format(abs(scaled_wc('ed_3313'))* lambda_smeft_value**2, '.6e') ,'# cedAbs3313'],
	[772, format(scaled_wc('ed_3322')* lambda_smeft_value**2, '.6e') ,'# cedAbs3322'],
	[773, format(scaled_wc('ed_3333')* lambda_smeft_value**2, '.6e') ,'# cedAbs3333'],
	[774, format(abs(scaled_wc('ed_3323'))* lambda_smeft_value**2, '.6e') ,'# cedAbs3323'],
	[775, format(angle(scaled_wc('ed_1112')), '.6e') ,'# cedPh1112'],
	[776, format(angle(scaled_wc('ed_2212')), '.6e') ,'# cedPh2212'],
	[777, format(angle(scaled_wc('ed_1113')), '.6e') ,'# cedPh1113'],
	[778, format(angle(scaled_wc('ed_1123')), '.6e') ,'# cedPh1123'],
	[779, format(angle(scaled_wc('ed_1211')), '.6e') ,'# cedPh1211'],
	[780, format(angle(scaled_wc('ed_1212')), '.6e') ,'# cedPh1212'],
	[781, format(angle(scaled_wc('ed_1221')), '.6e') ,'# cedPh1221'],
	[782, format(angle(scaled_wc('ed_1213')), '.6e') ,'# cedPh1213'],
	[783, format(angle(scaled_wc('ed_1231')), '.6e') ,'# cedPh1231'],
	[784, format(angle(scaled_wc('ed_1222')), '.6e') ,'# cedPh1222'],
	[785, format(angle(scaled_wc('ed_1223')), '.6e') ,'# cedPh1223'],
	[786, format(angle(scaled_wc('ed_1232')), '.6e') ,'# cedPh1232'],
	[787, format(angle(scaled_wc('ed_1233')), '.6e') ,'# cedPh1233'],
	[788, format(angle(scaled_wc('ed_1311')), '.6e') ,'# cedPh1311'],
	[789, format(angle(scaled_wc('ed_1312')), '.6e') ,'# cedPh1312'],
	[790, format(angle(scaled_wc('ed_1313')), '.6e') ,'# cedPh1313'],
	[791, format(angle(scaled_wc('ed_1331')), '.6e') ,'# cedPh1331'],
	[792, format(angle(scaled_wc('ed_1321')), '.6e') ,'# cedPh1321'],
	[793, format(angle(scaled_wc('ed_1322')), '.6e') ,'# cedPh1322'],
	[794, format(angle(scaled_wc('ed_1332')), '.6e') ,'# cedPh1332'],
	[795, format(angle(scaled_wc('ed_1323')), '.6e') ,'# cedPh1323'],
	[796, format(angle(scaled_wc('ed_1333')), '.6e') ,'# cedPh1333'],
	[797, format(angle(scaled_wc('ed_2213')), '.6e') ,'# cedPh2213'],
	[798, format(angle(scaled_wc('ed_2223')), '.6e') ,'# cedPh2223'],
	[799, format(angle(scaled_wc('ed_2311')), '.6e') ,'# cedPh2311'],
	[800, format(angle(scaled_wc('ed_2312')), '.6e') ,'# cedPh2312'],
	[801, format(angle(scaled_wc('ed_2313')), '.6e') ,'# cedPh2313'],
	[802, format(angle(scaled_wc('ed_2321')), '.6e') ,'# cedPh2321'],
	[803, format(angle(scaled_wc('ed_2322')), '.6e') ,'# cedPh2322'],
	[804, format(angle(scaled_wc('ed_2323')), '.6e') ,'# cedPh2323'],
	[805, format(angle(scaled_wc('ed_2331')), '.6e') ,'# cedPh2331'],
	[806, format(angle(scaled_wc('ed_2332')), '.6e') ,'# cedPh2332'],
	[807, format(angle(scaled_wc('ed_2333')), '.6e') ,'# cedPh2333'],
	[808, format(angle(scaled_wc('ed_3323')), '.6e') ,'# cedPh3323'],
	[809, format(angle(scaled_wc('ed_3312')), '.6e') ,'# cedPh3312'],
	[810, format(angle(scaled_wc('ed_3313')), '.6e') ,'# cedPh3313'],
	[811, format(scaled_wc('qu1_1111')* lambda_smeft_value**2, '.6e') ,'# cqu1Abs1111'],
	[812, format(abs(scaled_wc('qu1_1112'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs1112'],
	[813, format(abs(scaled_wc('qu1_1113'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs1113'],
	[814, format(abs(scaled_wc('qu1_1123'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs1123'],
	[815, format(scaled_wc('qu1_1122')* lambda_smeft_value**2, '.6e') ,'# cqu1Abs1122'],
	[816, format(scaled_wc('qu1_1133')* lambda_smeft_value**2, '.6e') ,'# cqu1Abs1133'],
	[817, format(abs(scaled_wc('qu1_1211'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs1211'],
	[818, format(abs(scaled_wc('qu1_1212'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs1212'],
	[819, format(abs(scaled_wc('qu1_1221'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs1221'],
	[820, format(abs(scaled_wc('qu1_1213'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs1213'],
	[821, format(abs(scaled_wc('qu1_1231'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs1231'],
	[822, format(abs(scaled_wc('qu1_1222'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs1222'],
	[823, format(abs(scaled_wc('qu1_1223'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs1223'],
	[824, format(abs(scaled_wc('qu1_1232'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs1232'],
	[825, format(abs(scaled_wc('qu1_1233'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs1233'],
	[826, format(abs(scaled_wc('qu1_1311'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs1311'],
	[827, format(abs(scaled_wc('qu1_1312'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs1312'],
	[828, format(abs(scaled_wc('qu1_1313'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs1313'],
	[829, format(abs(scaled_wc('qu1_1331'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs1331'],
	[830, format(abs(scaled_wc('qu1_1321'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs1321'],
	[831, format(abs(scaled_wc('qu1_1322'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs1322'],
	[832, format(abs(scaled_wc('qu1_1332'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs1332'],
	[833, format(abs(scaled_wc('qu1_1323'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs1323'],
	[834, format(abs(scaled_wc('qu1_1333'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs1333'],
	[835, format(scaled_wc('qu1_2211')* lambda_smeft_value**2, '.6e') ,'# cqu1Abs2211'],
	[836, format(abs(scaled_wc('qu1_2212'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs2212'],
	[837, format(abs(scaled_wc('qu1_2213'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs2213'],
	[838, format(scaled_wc('qu1_2222')* lambda_smeft_value**2, '.6e') ,'# cqu1Abs2222'],
	[839, format(abs(scaled_wc('qu1_2223'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs2223'],
	[840, format(scaled_wc('qu1_2233')* lambda_smeft_value**2, '.6e') ,'# cqu1Abs2233'],
	[841, format(abs(scaled_wc('qu1_2311'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs2311'],
	[842, format(abs(scaled_wc('qu1_2312'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs2312'],
	[843, format(abs(scaled_wc('qu1_2313'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs2313'],
	[844, format(abs(scaled_wc('qu1_2321'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs2321'],
	[845, format(abs(scaled_wc('qu1_2322'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs2322'],
	[846, format(abs(scaled_wc('qu1_2323'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs2323'],
	[847, format(abs(scaled_wc('qu1_2331'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs2331'],
	[848, format(abs(scaled_wc('qu1_2332'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs2332'],
	[849, format(abs(scaled_wc('qu1_2333'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs2333'],
	[850, format(scaled_wc('qu1_3311')* lambda_smeft_value**2, '.6e') ,'# cqu1Abs3311'],
	[851, format(abs(scaled_wc('qu1_3312'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs3312'],
	[852, format(abs(scaled_wc('qu1_3313'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs3313'],
	[853, format(scaled_wc('qu1_3322')* lambda_smeft_value**2, '.6e') ,'# cqu1Abs3322'],
	[854, format(scaled_wc('qu1_3333')* lambda_smeft_value**2, '.6e') ,'# cqu1Abs3333'],
	[855, format(abs(scaled_wc('qu1_3323'))* lambda_smeft_value**2, '.6e') ,'# cqu1Abs3323'],
	[856, format(angle(scaled_wc('qu1_1112')), '.6e') ,'# cqu1Ph1112'],
	[857, format(angle(scaled_wc('qu1_2212')), '.6e') ,'# cqu1Ph2212'],
	[858, format(angle(scaled_wc('qu1_1113')), '.6e') ,'# cqu1Ph1113'],
	[859, format(angle(scaled_wc('qu1_1123')), '.6e') ,'# cqu1Ph1123'],
	[860, format(angle(scaled_wc('qu1_1211')), '.6e') ,'# cqu1Ph1211'],
	[861, format(angle(scaled_wc('qu1_1212')), '.6e') ,'# cqu1Ph1212'],
	[862, format(angle(scaled_wc('qu1_1221')), '.6e') ,'# cqu1Ph1221'],
	[863, format(angle(scaled_wc('qu1_1213')), '.6e') ,'# cqu1Ph1213'],
	[864, format(angle(scaled_wc('qu1_1231')), '.6e') ,'# cqu1Ph1231'],
	[865, format(angle(scaled_wc('qu1_1222')), '.6e') ,'# cqu1Ph1222'],
	[866, format(angle(scaled_wc('qu1_1223')), '.6e') ,'# cqu1Ph1223'],
	[867, format(angle(scaled_wc('qu1_1232')), '.6e') ,'# cqu1Ph1232'],
	[868, format(angle(scaled_wc('qu1_1233')), '.6e') ,'# cqu1Ph1233'],
	[869, format(angle(scaled_wc('qu1_1311')), '.6e') ,'# cqu1Ph1311'],
	[870, format(angle(scaled_wc('qu1_1312')), '.6e') ,'# cqu1Ph1312'],
	[871, format(angle(scaled_wc('qu1_1313')), '.6e') ,'# cqu1Ph1313'],
	[872, format(angle(scaled_wc('qu1_1331')), '.6e') ,'# cqu1Ph1331'],
	[873, format(angle(scaled_wc('qu1_1321')), '.6e') ,'# cqu1Ph1321'],
	[874, format(angle(scaled_wc('qu1_1322')), '.6e') ,'# cqu1Ph1322'],
	[875, format(angle(scaled_wc('qu1_1332')), '.6e') ,'# cqu1Ph1332'],
	[876, format(angle(scaled_wc('qu1_1323')), '.6e') ,'# cqu1Ph1323'],
	[877, format(angle(scaled_wc('qu1_1333')), '.6e') ,'# cqu1Ph1333'],
	[878, format(angle(scaled_wc('qu1_2213')), '.6e') ,'# cqu1Ph2213'],
	[879, format(angle(scaled_wc('qu1_2223')), '.6e') ,'# cqu1Ph2223'],
	[880, format(angle(scaled_wc('qu1_2311')), '.6e') ,'# cqu1Ph2311'],
	[881, format(angle(scaled_wc('qu1_2312')), '.6e') ,'# cqu1Ph2312'],
	[882, format(angle(scaled_wc('qu1_2313')), '.6e') ,'# cqu1Ph2313'],
	[883, format(angle(scaled_wc('qu1_2321')), '.6e') ,'# cqu1Ph2321'],
	[884, format(angle(scaled_wc('qu1_2322')), '.6e') ,'# cqu1Ph2322'],
	[885, format(angle(scaled_wc('qu1_2323')), '.6e') ,'# cqu1Ph2323'],
	[886, format(angle(scaled_wc('qu1_2331')), '.6e') ,'# cqu1Ph2331'],
	[887, format(angle(scaled_wc('qu1_2332')), '.6e') ,'# cqu1Ph2332'],
	[888, format(angle(scaled_wc('qu1_2333')), '.6e') ,'# cqu1Ph2333'],
	[889, format(angle(scaled_wc('qu1_3323')), '.6e') ,'# cqu1Ph3323'],
	[890, format(angle(scaled_wc('qu1_3312')), '.6e') ,'# cqu1Ph3312'],
	[891, format(angle(scaled_wc('qu1_3313')), '.6e') ,'# cqu1Ph3313'],
	[892, format(scaled_wc('qu8_1111')* lambda_smeft_value**2, '.6e') ,'# cQU8Abs1111'],
	[893, format(abs(scaled_wc('qu8_1112'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs1112'],
	[894, format(abs(scaled_wc('qu8_1113'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs1113'],
	[895, format(abs(scaled_wc('qu8_1123'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs1123'],
	[896, format(scaled_wc('qu8_1122')* lambda_smeft_value**2, '.6e') ,'# cQU8Abs1122'],
	[897, format(scaled_wc('qu8_1133')* lambda_smeft_value**2, '.6e') ,'# cQU8Abs1133'],
	[898, format(abs(scaled_wc('qu8_1211'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs1211'],
	[899, format(abs(scaled_wc('qu8_1212'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs1212'],
	[900, format(abs(scaled_wc('qu8_1221'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs1221'],
	[901, format(abs(scaled_wc('qu8_1213'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs1213'],
	[902, format(abs(scaled_wc('qu8_1231'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs1231'],
	[903, format(abs(scaled_wc('qu8_1222'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs1222'],
	[904, format(abs(scaled_wc('qu8_1223'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs1223'],
	[905, format(abs(scaled_wc('qu8_1232'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs1232'],
	[906, format(abs(scaled_wc('qu8_1233'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs1233'],
	[907, format(abs(scaled_wc('qu8_1311'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs1311'],
	[908, format(abs(scaled_wc('qu8_1312'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs1312'],
	[909, format(abs(scaled_wc('qu8_1313'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs1313'],
	[910, format(abs(scaled_wc('qu8_1331'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs1331'],
	[911, format(abs(scaled_wc('qu8_1321'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs1321'],
	[912, format(abs(scaled_wc('qu8_1322'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs1322'],
	[913, format(abs(scaled_wc('qu8_1332'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs1332'],
	[914, format(abs(scaled_wc('qu8_1323'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs1323'],
	[915, format(abs(scaled_wc('qu8_1333'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs1333'],
	[916, format(scaled_wc('qu8_2211')* lambda_smeft_value**2, '.6e') ,'# cQU8Abs2211'],
	[917, format(abs(scaled_wc('qu8_2212'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs2212'],
	[918, format(abs(scaled_wc('qu8_2213'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs2213'],
	[919, format(scaled_wc('qu8_2222')* lambda_smeft_value**2, '.6e') ,'# cQU8Abs2222'],
	[920, format(abs(scaled_wc('qu8_2223'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs2223'],
	[921, format(scaled_wc('qu8_2233')* lambda_smeft_value**2, '.6e') ,'# cQU8Abs2233'],
	[922, format(abs(scaled_wc('qu8_2311'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs2311'],
	[923, format(abs(scaled_wc('qu8_2312'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs2312'],
	[924, format(abs(scaled_wc('qu8_2313'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs2313'],
	[925, format(abs(scaled_wc('qu8_2321'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs2321'],
	[926, format(abs(scaled_wc('qu8_2322'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs2322'],
	[927, format(abs(scaled_wc('qu8_2323'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs2323'],
	[928, format(abs(scaled_wc('qu8_2331'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs2331'],
	[929, format(abs(scaled_wc('qu8_2332'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs2332'],
	[930, format(abs(scaled_wc('qu8_2333'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs2333'],
	[931, format(scaled_wc('qu8_3311')* lambda_smeft_value**2, '.6e') ,'# cQU8Abs3311'],
	[932, format(abs(scaled_wc('qu8_3312'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs3312'],
	[933, format(abs(scaled_wc('qu8_3313'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs3313'],
	[934, format(scaled_wc('qu8_3322')* lambda_smeft_value**2, '.6e') ,'# cQU8Abs3322'],
	[935, format(scaled_wc('qu8_3333')* lambda_smeft_value**2, '.6e') ,'# cQU8Abs3333'],
	[936, format(abs(scaled_wc('qu8_3323'))* lambda_smeft_value**2, '.6e') ,'# cQU8Abs3323'],
	[937, format(angle(scaled_wc('qu8_1112')), '.6e') ,'# cQU8Ph1112'],
	[938, format(angle(scaled_wc('qu8_2212')), '.6e') ,'# cQU8Ph2212'],
	[939, format(angle(scaled_wc('qu8_1113')), '.6e') ,'# cQU8Ph1113'],
	[940, format(angle(scaled_wc('qu8_1123')), '.6e') ,'# cQU8Ph1123'],
	[941, format(angle(scaled_wc('qu8_1211')), '.6e') ,'# cQU8Ph1211'],
	[942, format(angle(scaled_wc('qu8_1212')), '.6e') ,'# cQU8Ph1212'],
	[943, format(angle(scaled_wc('qu8_1221')), '.6e') ,'# cQU8Ph1221'],
	[944, format(angle(scaled_wc('qu8_1213')), '.6e') ,'# cQU8Ph1213'],
	[945, format(angle(scaled_wc('qu8_1231')), '.6e') ,'# cQU8Ph1231'],
	[946, format(angle(scaled_wc('qu8_1222')), '.6e') ,'# cQU8Ph1222'],
	[947, format(angle(scaled_wc('qu8_1223')), '.6e') ,'# cQU8Ph1223'],
	[948, format(angle(scaled_wc('qu8_1232')), '.6e') ,'# cQU8Ph1232'],
	[949, format(angle(scaled_wc('qu8_1233')), '.6e') ,'# cQU8Ph1233'],
	[950, format(angle(scaled_wc('qu8_1311')), '.6e') ,'# cQU8Ph1311'],
	[951, format(angle(scaled_wc('qu8_1312')), '.6e') ,'# cQU8Ph1312'],
	[952, format(angle(scaled_wc('qu8_1313')), '.6e') ,'# cQU8Ph1313'],
	[953, format(angle(scaled_wc('qu8_1331')), '.6e') ,'# cQU8Ph1331'],
	[954, format(angle(scaled_wc('qu8_1321')), '.6e') ,'# cQU8Ph1321'],
	[955, format(angle(scaled_wc('qu8_1322')), '.6e') ,'# cQU8Ph1322'],
	[956, format(angle(scaled_wc('qu8_1332')), '.6e') ,'# cQU8Ph1332'],
	[957, format(angle(scaled_wc('qu8_1323')), '.6e') ,'# cQU8Ph1323'],
	[958, format(angle(scaled_wc('qu8_1333')), '.6e') ,'# cQU8Ph1333'],
	[959, format(angle(scaled_wc('qu8_2213')), '.6e') ,'# cQU8Ph2213'],
	[960, format(angle(scaled_wc('qu8_2223')), '.6e') ,'# cQU8Ph2223'],
	[961, format(angle(scaled_wc('qu8_2311')), '.6e') ,'# cQU8Ph2311'],
	[962, format(angle(scaled_wc('qu8_2312')), '.6e') ,'# cQU8Ph2312'],
	[963, format(angle(scaled_wc('qu8_2313')), '.6e') ,'# cQU8Ph2313'],
	[964, format(angle(scaled_wc('qu8_2321')), '.6e') ,'# cQU8Ph2321'],
	[965, format(angle(scaled_wc('qu8_2322')), '.6e') ,'# cQU8Ph2322'],
	[966, format(angle(scaled_wc('qu8_2323')), '.6e') ,'# cQU8Ph2323'],
	[967, format(angle(scaled_wc('qu8_2331')), '.6e') ,'# cQU8Ph2331'],
	[968, format(angle(scaled_wc('qu8_2332')), '.6e') ,'# cQU8Ph2332'],
	[969, format(angle(scaled_wc('qu8_2333')), '.6e') ,'# cQU8Ph2333'],
	[970, format(angle(scaled_wc('qu8_3323')), '.6e') ,'# cQU8Ph3323'],
	[971, format(angle(scaled_wc('qu8_3312')), '.6e') ,'# cQU8Ph3312'],
	[972, format(angle(scaled_wc('qu8_3313')), '.6e') ,'# cQU8Ph3313'],
	[973, format(scaled_wc('qd1_1111')* lambda_smeft_value**2, '.6e') ,'# cqd1Abs1111'],
	[974, format(abs(scaled_wc('qd1_1112'))* lambda_smeft_value**2, '.6e') ,'# cqd1Abs1112'],
	[975, format(abs(scaled_wc('qd1_1113'))* lambda_smeft_value**2, '.6e') ,'# cqd1Abs1113'],
	[976, format(abs(scaled_wc('qd1_1123'))* lambda_smeft_value**2, '.6e') ,'# cqd1Abs1123'],
	[977, format(scaled_wc('qd1_1122')* lambda_smeft_value**2, '.6e') ,'# cqd1Abs1122'],
	[978, format(scaled_wc('qd1_1133')* lambda_smeft_value**2, '.6e') ,'# cqd1Abs1133'],
	[979, format(abs(scaled_wc('qd1_1211'))* lambda_smeft_value**2, '.6e') ,'# cqd1Abs1211'],
	[980, format(abs(scaled_wc('qd1_1212'))* lambda_smeft_value**2, '.6e') ,'# cqd1Abs1212'],
	[981, format(abs(scaled_wc('qd1_1221'))* lambda_smeft_value**2, '.6e') ,'# cqd1Abs1221'],
	[982, format(abs(scaled_wc('qd1_1213'))* lambda_smeft_value**2, '.6e') ,'# cqd1Abs1213'],
	[983, format(abs(scaled_wc('qd1_1231'))* lambda_smeft_value**2, '.6e') ,'# cqd1Abs1231'],
	[984, format(abs(scaled_wc('qd1_1222'))* lambda_smeft_value**2, '.6e') ,'# cqd1Abs1222'],
	[985, format(abs(scaled_wc('qd1_1223'))* lambda_smeft_value**2, '.6e') ,'# cqd1Abs1223'],
	[986, format(abs(scaled_wc('qd1_1232'))* lambda_smeft_value**2, '.6e') ,'# cqd1Abs1232'],
	[987, format(abs(scaled_wc('qd1_1233'))* lambda_smeft_value**2, '.6e') ,'# cqd1Abs1233'],
	[988, format(abs(scaled_wc('qd1_1311'))* lambda_smeft_value**2, '.6e') ,'# cqd1Abs1311'],
	[989, format(abs(scaled_wc('qd1_1312'))* lambda_smeft_value**2, '.6e') ,'# cqd1Abs1312'],
	[990, format(abs(scaled_wc('qd1_1313'))* lambda_smeft_value**2, '.6e') ,'# cqd1Abs1313'],
	[991, format(abs(scaled_wc('qd1_1331'))* lambda_smeft_value**2, '.6e') ,'# cqd1Abs1331'],
	[992, format(abs(scaled_wc('qd1_1321'))* lambda_smeft_value**2, '.6e') ,'# cqd1Abs1321'],
	[993, format(abs(scaled_wc('qd1_1322'))* lambda_smeft_value**2, '.6e') ,'# cqd1Abs1322'],
	[994, format(abs(scaled_wc('qd1_1332'))* lambda_smeft_value**2, '.6e') ,'# cqd1Abs1332'],
	[995, format(abs(scaled_wc('qd1_1323'))* lambda_smeft_value**2, '.6e') ,'# cqd1Abs1323'],
	[996, format(abs(scaled_wc('qd1_1333'))* lambda_smeft_value**2, '.6e') ,'# cqd1Abs1333'],
	[997, format(scaled_wc('qd1_2211')* lambda_smeft_value**2, '.6e') ,'# cqd1Abs2211'],
	[998, format(abs(scaled_wc('qd1_2212'))* lambda_smeft_value**2, '.6e') ,'# cqd1Abs2212'],
	[999, format(abs(scaled_wc('qd1_2213'))* lambda_smeft_value**2, '.6e') ,'# cqd1Abs2213'],
	[1000, format(scaled_wc('qd1_2222')* lambda_smeft_value**2, '.6e'), '# cqd1Abs2222'],
	[1001, format(abs(scaled_wc('qd1_2223'))* lambda_smeft_value**2, '.6e'), '# cqd1Abs2223'],
	[1002, format(scaled_wc('qd1_2233')* lambda_smeft_value**2, '.6e'), '# cqd1Abs2233'],
	[1003, format(abs(scaled_wc('qd1_2311'))* lambda_smeft_value**2, '.6e'), '# cqd1Abs2311'],
	[1004, format(abs(scaled_wc('qd1_2312'))* lambda_smeft_value**2, '.6e'), '# cqd1Abs2312'],
	[1005, format(abs(scaled_wc('qd1_2313'))* lambda_smeft_value**2, '.6e'), '# cqd1Abs2313'],
	[1006, format(abs(scaled_wc('qd1_2321'))* lambda_smeft_value**2, '.6e'), '# cqd1Abs2321'],
	[1007, format(abs(scaled_wc('qd1_2322'))* lambda_smeft_value**2, '.6e'), '# cqd1Abs2322'],
	[1008, format(abs(scaled_wc('qd1_2323'))* lambda_smeft_value**2, '.6e'), '# cqd1Abs2323'],
	[1009, format(abs(scaled_wc('qd1_2331'))* lambda_smeft_value**2, '.6e'), '# cqd1Abs2331'],
	[1010, format(abs(scaled_wc('qd1_2332'))* lambda_smeft_value**2, '.6e'), '# cqd1Abs2332'],
	[1011, format(abs(scaled_wc('qd1_2333'))* lambda_smeft_value**2, '.6e'), '# cqd1Abs2333'],
	[1012, format(scaled_wc('qd1_3311')* lambda_smeft_value**2, '.6e'), '# cqd1Abs3311'],
	[1013, format(abs(scaled_wc('qd1_3312'))* lambda_smeft_value**2, '.6e'), '# cqd1Abs3312'],
	[1014, format(abs(scaled_wc('qd1_3313'))* lambda_smeft_value**2, '.6e'), '# cqd1Abs3313'],
	[1015, format(scaled_wc('qd1_3322')* lambda_smeft_value**2, '.6e'), '# cqd1Abs3322'],
	[1016, format(scaled_wc('qd1_3333')* lambda_smeft_value**2, '.6e'), '# cqd1Abs3333'],
	[1017, format(abs(scaled_wc('qd1_3323'))* lambda_smeft_value**2, '.6e'), '# cqd1Abs3323'],
	[1018, format(angle(scaled_wc('qd1_1112')), '.6e'), '# cqd1Ph1112'],
	[1019, format(angle(scaled_wc('qd1_2212')), '.6e'), '# cqd1Ph2212'],
	[1020, format(angle(scaled_wc('qd1_1113')), '.6e'), '# cqd1Ph1113'],
	[1021, format(angle(scaled_wc('qd1_1123')), '.6e'), '# cqd1Ph1123'],
	[1022, format(angle(scaled_wc('qd1_1211')), '.6e'), '# cqd1Ph1211'],
	[1023, format(angle(scaled_wc('qd1_1212')), '.6e'), '# cqd1Ph1212'],
	[1024, format(angle(scaled_wc('qd1_1221')), '.6e'), '# cqd1Ph1221'],
	[1025, format(angle(scaled_wc('qd1_1213')), '.6e'), '# cqd1Ph1213'],
	[1026, format(angle(scaled_wc('qd1_1231')), '.6e'), '# cqd1Ph1231'],
	[1027, format(angle(scaled_wc('qd1_1222')), '.6e'), '# cqd1Ph1222'],
	[1028, format(angle(scaled_wc('qd1_1223')), '.6e'), '# cqd1Ph1223'],
	[1029, format(angle(scaled_wc('qd1_1232')), '.6e'), '# cqd1Ph1232'],
	[1030, format(angle(scaled_wc('qd1_1233')), '.6e'), '# cqd1Ph1233'],
	[1031, format(angle(scaled_wc('qd1_1311')), '.6e'), '# cqd1Ph1311'],
	[1032, format(angle(scaled_wc('qd1_1312')), '.6e'), '# cqd1Ph1312'],
	[1033, format(angle(scaled_wc('qd1_1313')), '.6e'), '# cqd1Ph1313'],
	[1034, format(angle(scaled_wc('qd1_1331')), '.6e'), '# cqd1Ph1331'],
	[1035, format(angle(scaled_wc('qd1_1321')), '.6e'), '# cqd1Ph1321'],
	[1036, format(angle(scaled_wc('qd1_1322')), '.6e'), '# cqd1Ph1322'],
	[1037, format(angle(scaled_wc('qd1_1332')), '.6e'), '# cqd1Ph1332'],
	[1038, format(angle(scaled_wc('qd1_1323')), '.6e'), '# cqd1Ph1323'],
	[1039, format(angle(scaled_wc('qd1_1333')), '.6e'), '# cqd1Ph1333'],
	[1040, format(angle(scaled_wc('qd1_2213')), '.6e'), '# cqd1Ph2213'],
	[1041, format(angle(scaled_wc('qd1_2223')), '.6e'), '# cqd1Ph2223'],
	[1042, format(angle(scaled_wc('qd1_2311')), '.6e'), '# cqd1Ph2311'],
	[1043, format(angle(scaled_wc('qd1_2312')), '.6e'), '# cqd1Ph2312'],
	[1044, format(angle(scaled_wc('qd1_2313')), '.6e'), '# cqd1Ph2313'],
	[1045, format(angle(scaled_wc('qd1_2321')), '.6e'), '# cqd1Ph2321'],
	[1046, format(angle(scaled_wc('qd1_2322')), '.6e'), '# cqd1Ph2322'],
	[1047, format(angle(scaled_wc('qd1_2323')), '.6e'), '# cqd1Ph2323'],
	[1048, format(angle(scaled_wc('qd1_2331')), '.6e'), '# cqd1Ph2331'],
	[1049, format(angle(scaled_wc('qd1_2332')), '.6e'), '# cqd1Ph2332'],
	[1050, format(angle(scaled_wc('qd1_2333')), '.6e'), '# cqd1Ph2333'],
	[1051, format(angle(scaled_wc('qd1_3323')), '.6e'), '# cqd1Ph3323'],
	[1052, format(angle(scaled_wc('qd1_3312')), '.6e'), '# cqd1Ph3312'],
	[1053, format(angle(scaled_wc('qd1_3313')), '.6e'), '# cqd1Ph3313'],
	[1054, format(scaled_wc('qd8_1111')* lambda_smeft_value**2, '.6e'), '# cQD8Abs1111'],
	[1055, format(abs(scaled_wc('qd8_1112'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs1112'],
	[1056, format(abs(scaled_wc('qd8_1113'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs1113'],
	[1057, format(abs(scaled_wc('qd8_1123'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs1123'],
	[1058, format(scaled_wc('qd8_1122')* lambda_smeft_value**2, '.6e'), '# cQD8Abs1122'],
	[1059, format(scaled_wc('qd8_1133')* lambda_smeft_value**2, '.6e'), '# cQD8Abs1133'],
	[1060, format(abs(scaled_wc('qd8_1211'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs1211'],
	[1061, format(abs(scaled_wc('qd8_1212'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs1212'],
	[1062, format(abs(scaled_wc('qd8_1221'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs1221'],
	[1063, format(abs(scaled_wc('qd8_1213'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs1213'],
	[1064, format(abs(scaled_wc('qd8_1231'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs1231'],
	[1065, format(abs(scaled_wc('qd8_1222'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs1222'],
	[1066, format(abs(scaled_wc('qd8_1223'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs1223'],
	[1067, format(abs(scaled_wc('qd8_1232'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs1232'],
	[1068, format(abs(scaled_wc('qd8_1233'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs1233'],
	[1069, format(abs(scaled_wc('qd8_1311'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs1311'],
	[1070, format(abs(scaled_wc('qd8_1312'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs1312'],
	[1071, format(abs(scaled_wc('qd8_1313'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs1313'],
	[1072, format(abs(scaled_wc('qd8_1331'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs1331'],
	[1073, format(abs(scaled_wc('qd8_1321'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs1321'],
	[1074, format(abs(scaled_wc('qd8_1322'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs1322'],
	[1075, format(abs(scaled_wc('qd8_1332'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs1332'],
	[1076, format(abs(scaled_wc('qd8_1323'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs1323'],
	[1077, format(abs(scaled_wc('qd8_1333'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs1333'],
	[1078, format(scaled_wc('qd8_2211')* lambda_smeft_value**2, '.6e'), '# cQD8Abs2211'],
	[1079, format(abs(scaled_wc('qd8_2212'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs2212'],
	[1080, format(abs(scaled_wc('qd8_2213'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs2213'],
	[1081, format(scaled_wc('qd8_2222')* lambda_smeft_value**2, '.6e'), '# cQD8Abs2222'],
	[1082, format(abs(scaled_wc('qd8_2223'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs2223'],
	[1083, format(scaled_wc('qd8_2233')* lambda_smeft_value**2, '.6e'), '# cQD8Abs2233'],
	[1084, format(abs(scaled_wc('qd8_2311'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs2311'],
	[1085, format(abs(scaled_wc('qd8_2312'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs2312'],
	[1086, format(abs(scaled_wc('qd8_2313'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs2313'],
	[1087, format(abs(scaled_wc('qd8_2321'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs2321'],
	[1088, format(abs(scaled_wc('qd8_2322'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs2322'],
	[1089, format(abs(scaled_wc('qd8_2323'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs2323'],
	[1090, format(abs(scaled_wc('qd8_2331'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs2331'],
	[1091, format(abs(scaled_wc('qd8_2332'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs2332'],
	[1092, format(abs(scaled_wc('qd8_2333'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs2333'],
	[1093, format(scaled_wc('qd8_3311')* lambda_smeft_value**2, '.6e'), '# cQD8Abs3311'],
	[1094, format(abs(scaled_wc('qd8_3312'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs3312'],
	[1095, format(abs(scaled_wc('qd8_3313'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs3313'],
	[1096, format(scaled_wc('qd8_3322')* lambda_smeft_value**2, '.6e'), '# cQD8Abs3322'],
	[1097, format(scaled_wc('qd8_3333')* lambda_smeft_value**2, '.6e'), '# cQD8Abs3333'],
	[1098, format(abs(scaled_wc('qd8_3323'))* lambda_smeft_value**2, '.6e'), '# cQD8Abs3323'],
	[1099, format(angle(scaled_wc('qd8_1112')), '.6e'), '# cQD8Ph1112'],
	[1100, format(angle(scaled_wc('qd8_2212')), '.6e'), '# cQD8Ph2212'],
	[1101, format(angle(scaled_wc('qd8_1113')), '.6e'), '# cQD8Ph1113'],
	[1102, format(angle(scaled_wc('qd8_1123')), '.6e'), '# cQD8Ph1123'],
	[1103, format(angle(scaled_wc('qd8_1211')), '.6e'), '# cQD8Ph1211'],
	[1104, format(angle(scaled_wc('qd8_1212')), '.6e'), '# cQD8Ph1212'],
	[1105, format(angle(scaled_wc('qd8_1221')), '.6e'), '# cQD8Ph1221'],
	[1106, format(angle(scaled_wc('qd8_1213')), '.6e'), '# cQD8Ph1213'],
	[1107, format(angle(scaled_wc('qd8_1231')), '.6e'), '# cQD8Ph1231'],
	[1108, format(angle(scaled_wc('qd8_1222')), '.6e'), '# cQD8Ph1222'],
	[1109, format(angle(scaled_wc('qd8_1223')), '.6e'), '# cQD8Ph1223'],
	[1110, format(angle(scaled_wc('qd8_1232')), '.6e'), '# cQD8Ph1232'],
	[1111, format(angle(scaled_wc('qd8_1233')), '.6e'), '# cQD8Ph1233'],
	[1112, format(angle(scaled_wc('qd8_1311')), '.6e'), '# cQD8Ph1311'],
	[1113, format(angle(scaled_wc('qd8_1312')), '.6e'), '# cQD8Ph1312'],
	[1114, format(angle(scaled_wc('qd8_1313')), '.6e'), '# cQD8Ph1313'],
	[1115, format(angle(scaled_wc('qd8_1331')), '.6e'), '# cQD8Ph1331'],
	[1116, format(angle(scaled_wc('qd8_1321')), '.6e'), '# cQD8Ph1321'],
	[1117, format(angle(scaled_wc('qd8_1322')), '.6e'), '# cQD8Ph1322'],
	[1118, format(angle(scaled_wc('qd8_1332')), '.6e'), '# cQD8Ph1332'],
	[1119, format(angle(scaled_wc('qd8_1323')), '.6e'), '# cQD8Ph1323'],
	[1120, format(angle(scaled_wc('qd8_1333')), '.6e'), '# cQD8Ph1333'],
	[1121, format(angle(scaled_wc('qd8_2213')), '.6e'), '# cQD8Ph2213'],
	[1122, format(angle(scaled_wc('qd8_2223')), '.6e'), '# cQD8Ph2223'],
	[1123, format(angle(scaled_wc('qd8_2311')), '.6e'), '# cQD8Ph2311'],
	[1124, format(angle(scaled_wc('qd8_2312')), '.6e'), '# cQD8Ph2312'],
	[1125, format(angle(scaled_wc('qd8_2313')), '.6e'), '# cQD8Ph2313'],
	[1126, format(angle(scaled_wc('qd8_2321')), '.6e'), '# cQD8Ph2321'],
	[1127, format(angle(scaled_wc('qd8_2322')), '.6e'), '# cQD8Ph2322'],
	[1128, format(angle(scaled_wc('qd8_2323')), '.6e'), '# cQD8Ph2323'],
	[1129, format(angle(scaled_wc('qd8_2331')), '.6e'), '# cQD8Ph2331'],
	[1130, format(angle(scaled_wc('qd8_2332')), '.6e'), '# cQD8Ph2332'],
	[1131, format(angle(scaled_wc('qd8_2333')), '.6e'), '# cQD8Ph2333'],
	[1132, format(angle(scaled_wc('qd8_3323')), '.6e'), '# cQD8Ph3323'],
	[1133, format(angle(scaled_wc('qd8_3312')), '.6e'), '# cQD8Ph3312'],
	[1134, format(angle(scaled_wc('qd8_3313')), '.6e'), '# cQD8Ph3313'],
	[1135, format(scaled_wc('le_1111')* lambda_smeft_value**2, '.6e'), '# cleAbs1111'],
	[1136, format(abs(scaled_wc('le_1112'))* lambda_smeft_value**2, '.6e'), '# cleAbs1112'],
	[1137, format(abs(scaled_wc('le_1113'))* lambda_smeft_value**2, '.6e'), '# cleAbs1113'],
	[1138, format(abs(scaled_wc('le_1123'))* lambda_smeft_value**2, '.6e'), '# cleAbs1123'],
	[1139, format(scaled_wc('le_1122')* lambda_smeft_value**2, '.6e'), '# cleAbs1122'],
	[1140, format(scaled_wc('le_1133')* lambda_smeft_value**2, '.6e'), '# cleAbs1133'],
	[1141, format(abs(scaled_wc('le_1211'))* lambda_smeft_value**2, '.6e'), '# cleAbs1211'],
	[1142, format(abs(scaled_wc('le_1212'))* lambda_smeft_value**2, '.6e'), '# cleAbs1212'],
	[1143, format(abs(scaled_wc('le_1221'))* lambda_smeft_value**2, '.6e'), '# cleAbs1221'],
	[1144, format(abs(scaled_wc('le_1213'))* lambda_smeft_value**2, '.6e'), '# cleAbs1213'],
	[1145, format(abs(scaled_wc('le_1231'))* lambda_smeft_value**2, '.6e'), '# cleAbs1231'],
	[1146, format(abs(scaled_wc('le_1222'))* lambda_smeft_value**2, '.6e'), '# cleAbs1222'],
	[1147, format(abs(scaled_wc('le_1223'))* lambda_smeft_value**2, '.6e'), '# cleAbs1223'],
	[1148, format(abs(scaled_wc('le_1232'))* lambda_smeft_value**2, '.6e'), '# cleAbs1232'],
	[1149, format(abs(scaled_wc('le_1233'))* lambda_smeft_value**2, '.6e'), '# cleAbs1233'],
	[1150, format(abs(scaled_wc('le_1311'))* lambda_smeft_value**2, '.6e'), '# cleAbs1311'],
	[1151, format(abs(scaled_wc('le_1312'))* lambda_smeft_value**2, '.6e'), '# cleAbs1312'],
	[1152, format(abs(scaled_wc('le_1313'))* lambda_smeft_value**2, '.6e'), '# cleAbs1313'],
	[1153, format(abs(scaled_wc('le_1331'))* lambda_smeft_value**2, '.6e'), '# cleAbs1331'],
	[1154, format(abs(scaled_wc('le_1321'))* lambda_smeft_value**2, '.6e'), '# cleAbs1321'],
	[1155, format(abs(scaled_wc('le_1322'))* lambda_smeft_value**2, '.6e'), '# cleAbs1322'],
	[1156, format(abs(scaled_wc('le_1332'))* lambda_smeft_value**2, '.6e'), '# cleAbs1332'],
	[1157, format(abs(scaled_wc('le_1323'))* lambda_smeft_value**2, '.6e'), '# cleAbs1323'],
	[1158, format(abs(scaled_wc('le_1333'))* lambda_smeft_value**2, '.6e'), '# cleAbs1333'],
	[1159, format(scaled_wc('le_2211')* lambda_smeft_value**2, '.6e'), '# cleAbs2211'],
	[1160, format(abs(scaled_wc('le_2212'))* lambda_smeft_value**2, '.6e'), '# cleAbs2212'],
	[1161, format(abs(scaled_wc('le_2213'))* lambda_smeft_value**2, '.6e'), '# cleAbs2213'],
	[1162, format(scaled_wc('le_2222')* lambda_smeft_value**2, '.6e'), '# cleAbs2222'],
	[1163, format(abs(scaled_wc('le_2223'))* lambda_smeft_value**2, '.6e'), '# cleAbs2223'],
	[1164, format(scaled_wc('le_2233')* lambda_smeft_value**2, '.6e'), '# cleAbs2233'],
	[1165, format(abs(scaled_wc('le_2311'))* lambda_smeft_value**2, '.6e'), '# cleAbs2311'],
	[1166, format(abs(scaled_wc('le_2312'))* lambda_smeft_value**2, '.6e'), '# cleAbs2312'],
	[1167, format(abs(scaled_wc('le_2313'))* lambda_smeft_value**2, '.6e'), '# cleAbs2313'],
	[1168, format(abs(scaled_wc('le_2321'))* lambda_smeft_value**2, '.6e'), '# cleAbs2321'],
	[1169, format(abs(scaled_wc('le_2322'))* lambda_smeft_value**2, '.6e'), '# cleAbs2322'],
	[1170, format(abs(scaled_wc('le_2323'))* lambda_smeft_value**2, '.6e'), '# cleAbs2323'],
	[1171, format(abs(scaled_wc('le_2331'))* lambda_smeft_value**2, '.6e'), '# cleAbs2331'],
	[1172, format(abs(scaled_wc('le_2332'))* lambda_smeft_value**2, '.6e'), '# cleAbs2332'],
	[1173, format(abs(scaled_wc('le_2333'))* lambda_smeft_value**2, '.6e'), '# cleAbs2333'],
	[1174, format(scaled_wc('le_3311')* lambda_smeft_value**2, '.6e'), '# cleAbs3311'],
	[1175, format(abs(scaled_wc('le_3312'))* lambda_smeft_value**2, '.6e'), '# cleAbs3312'],
	[1176, format(abs(scaled_wc('le_3313'))* lambda_smeft_value**2, '.6e'), '# cleAbs3313'],
	[1177, format(scaled_wc('le_3322')* lambda_smeft_value**2, '.6e'), '# cleAbs3322'],
	[1178, format(scaled_wc('le_3333')* lambda_smeft_value**2, '.6e'), '# cleAbs3333'],
	[1179, format(abs(scaled_wc('le_3323'))* lambda_smeft_value**2, '.6e'), '# cleAbs3323'],
	[1180, format(angle(scaled_wc('le_1112')), '.6e'), '# clePh1112'],
	[1181, format(angle(scaled_wc('le_2212')), '.6e'), '# clePh2212'],
	[1182, format(angle(scaled_wc('le_1113')), '.6e'), '# clePh1113'],
	[1183, format(angle(scaled_wc('le_1123')), '.6e'), '# clePh1123'],
	[1184, format(angle(scaled_wc('le_1211')), '.6e'), '# clePh1211'],
	[1185, format(angle(scaled_wc('le_1212')), '.6e'), '# clePh1212'],
	[1186, format(angle(scaled_wc('le_1221')), '.6e'), '# clePh1221'],
	[1187, format(angle(scaled_wc('le_1213')), '.6e'), '# clePh1213'],
	[1188, format(angle(scaled_wc('le_1231')), '.6e'), '# clePh1231'],
	[1189, format(angle(scaled_wc('le_1222')), '.6e'), '# clePh1222'],
	[1190, format(angle(scaled_wc('le_1223')), '.6e'), '# clePh1223'],
	[1191, format(angle(scaled_wc('le_1232')), '.6e'), '# clePh1232'],
	[1192, format(angle(scaled_wc('le_1233')), '.6e'), '# clePh1233'],
	[1193, format(angle(scaled_wc('le_1311')), '.6e'), '# clePh1311'],
	[1194, format(angle(scaled_wc('le_1312')), '.6e'), '# clePh1312'],
	[1195, format(angle(scaled_wc('le_1313')), '.6e'), '# clePh1313'],
	[1196, format(angle(scaled_wc('le_1331')), '.6e'), '# clePh1331'],
	[1197, format(angle(scaled_wc('le_1321')), '.6e'), '# clePh1321'],
	[1198, format(angle(scaled_wc('le_1322')), '.6e'), '# clePh1322'],
	[1199, format(angle(scaled_wc('le_1332')), '.6e'), '# clePh1332'],
	[1200, format(angle(scaled_wc('le_1323')), '.6e'), '# clePh1323'],
	[1201, format(angle(scaled_wc('le_1333')), '.6e'), '# clePh1333'],
	[1202, format(angle(scaled_wc('le_2213')), '.6e'), '# clePh2213'],
	[1203, format(angle(scaled_wc('le_2223')), '.6e'), '# clePh2223'],
	[1204, format(angle(scaled_wc('le_2311')), '.6e'), '# clePh2311'],
	[1205, format(angle(scaled_wc('le_2312')), '.6e'), '# clePh2312'],
	[1206, format(angle(scaled_wc('le_2313')), '.6e'), '# clePh2313'],
	[1207, format(angle(scaled_wc('le_2321')), '.6e'), '# clePh2321'],
	[1208, format(angle(scaled_wc('le_2322')), '.6e'), '# clePh2322'],
	[1209, format(angle(scaled_wc('le_2323')), '.6e'), '# clePh2323'],
	[1210, format(angle(scaled_wc('le_2331')), '.6e'), '# clePh2331'],
	[1211, format(angle(scaled_wc('le_2332')), '.6e'), '# clePh2332'],
	[1212, format(angle(scaled_wc('le_2333')), '.6e'), '# clePh2333'],
	[1213, format(angle(scaled_wc('le_3323')), '.6e'), '# clePh3323'],
	[1214, format(angle(scaled_wc('le_3312')), '.6e'), '# clePh3312'],
	[1215, format(angle(scaled_wc('le_3313')), '.6e'), '# clePh3313'],
	[1216, format(scaled_wc('lu_1111')* lambda_smeft_value**2, '.6e'), '# cluAbs1111'],
	[1217, format(abs(scaled_wc('lu_1112'))* lambda_smeft_value**2, '.6e'), '# cluAbs1112'],
	[1218, format(abs(scaled_wc('lu_1113'))* lambda_smeft_value**2, '.6e'), '# cluAbs1113'],
	[1219, format(abs(scaled_wc('lu_1123'))* lambda_smeft_value**2, '.6e'), '# cluAbs1123'],
	[1220, format(scaled_wc('lu_1122')* lambda_smeft_value**2, '.6e'), '# cluAbs1122'],
	[1221, format(scaled_wc('lu_1133')* lambda_smeft_value**2, '.6e'), '# cluAbs1133'],
	[1222, format(abs(scaled_wc('lu_1211'))* lambda_smeft_value**2, '.6e'), '# cluAbs1211'],
	[1223, format(abs(scaled_wc('lu_1212'))* lambda_smeft_value**2, '.6e'), '# cluAbs1212'],
	[1224, format(abs(scaled_wc('lu_1221'))* lambda_smeft_value**2, '.6e'), '# cluAbs1221'],
	[1225, format(abs(scaled_wc('lu_1213'))* lambda_smeft_value**2, '.6e'), '# cluAbs1213'],
	[1226, format(abs(scaled_wc('lu_1231'))* lambda_smeft_value**2, '.6e'), '# cluAbs1231'],
	[1227, format(abs(scaled_wc('lu_1222'))* lambda_smeft_value**2, '.6e'), '# cluAbs1222'],
	[1228, format(abs(scaled_wc('lu_1223'))* lambda_smeft_value**2, '.6e'), '# cluAbs1223'],
	[1229, format(abs(scaled_wc('lu_1232'))* lambda_smeft_value**2, '.6e'), '# cluAbs1232'],
	[1230, format(abs(scaled_wc('lu_1233'))* lambda_smeft_value**2, '.6e'), '# cluAbs1233'],
	[1231, format(abs(scaled_wc('lu_1311'))* lambda_smeft_value**2, '.6e'), '# cluAbs1311'],
	[1232, format(abs(scaled_wc('lu_1312'))* lambda_smeft_value**2, '.6e'), '# cluAbs1312'],
	[1233, format(abs(scaled_wc('lu_1313'))* lambda_smeft_value**2, '.6e'), '# cluAbs1313'],
	[1234, format(abs(scaled_wc('lu_1331'))* lambda_smeft_value**2, '.6e'), '# cluAbs1331'],
	[1235, format(abs(scaled_wc('lu_1321'))* lambda_smeft_value**2, '.6e'), '# cluAbs1321'],
	[1236, format(abs(scaled_wc('lu_1322'))* lambda_smeft_value**2, '.6e'), '# cluAbs1322'],
	[1237, format(abs(scaled_wc('lu_1332'))* lambda_smeft_value**2, '.6e'), '# cluAbs1332'],
	[1238, format(abs(scaled_wc('lu_1323'))* lambda_smeft_value**2, '.6e'), '# cluAbs1323'],
	[1239, format(abs(scaled_wc('lu_1333'))* lambda_smeft_value**2, '.6e'), '# cluAbs1333'],
	[1240, format(scaled_wc('lu_2211')* lambda_smeft_value**2, '.6e'), '# cluAbs2211'],
	[1241, format(abs(scaled_wc('lu_2212'))* lambda_smeft_value**2, '.6e'), '# cluAbs2212'],
	[1242, format(abs(scaled_wc('lu_2213'))* lambda_smeft_value**2, '.6e'), '# cluAbs2213'],
	[1243, format(scaled_wc('lu_2222')* lambda_smeft_value**2, '.6e'), '# cluAbs2222'],
	[1244, format(abs(scaled_wc('lu_2223'))* lambda_smeft_value**2, '.6e'), '# cluAbs2223'],
	[1245, format(scaled_wc('lu_2233')* lambda_smeft_value**2, '.6e'), '# cluAbs2233'],
	[1246, format(abs(scaled_wc('lu_2311'))* lambda_smeft_value**2, '.6e'), '# cluAbs2311'],
	[1247, format(abs(scaled_wc('lu_2312'))* lambda_smeft_value**2, '.6e'), '# cluAbs2312'],
	[1248, format(abs(scaled_wc('lu_2313'))* lambda_smeft_value**2, '.6e'), '# cluAbs2313'],
	[1249, format(abs(scaled_wc('lu_2321'))* lambda_smeft_value**2, '.6e'), '# cluAbs2321'],
	[1250, format(abs(scaled_wc('lu_2322'))* lambda_smeft_value**2, '.6e'), '# cluAbs2322'],
	[1251, format(abs(scaled_wc('lu_2323'))* lambda_smeft_value**2, '.6e'), '# cluAbs2323'],
	[1252, format(abs(scaled_wc('lu_2331'))* lambda_smeft_value**2, '.6e'), '# cluAbs2331'],
	[1253, format(abs(scaled_wc('lu_2332'))* lambda_smeft_value**2, '.6e'), '# cluAbs2332'],
	[1254, format(abs(scaled_wc('lu_2333'))* lambda_smeft_value**2, '.6e'), '# cluAbs2333'],
	[1255, format(scaled_wc('lu_3311')* lambda_smeft_value**2, '.6e'), '# cluAbs3311'],
	[1256, format(abs(scaled_wc('lu_3312'))* lambda_smeft_value**2, '.6e'), '# cluAbs3312'],
	[1257, format(abs(scaled_wc('lu_3313'))* lambda_smeft_value**2, '.6e'), '# cluAbs3313'],
	[1258, format(scaled_wc('lu_3322')* lambda_smeft_value**2, '.6e'), '# cluAbs3322'],
	[1259, format(scaled_wc('lu_3333')* lambda_smeft_value**2, '.6e'), '# cluAbs3333'],
	[1260, format(abs(scaled_wc('lu_3323'))* lambda_smeft_value**2, '.6e'), '# cluAbs3323'],
	[1261, format(angle(scaled_wc('lu_1112')), '.6e'), '# cluPh1112'],
	[1262, format(angle(scaled_wc('lu_2212')), '.6e'), '# cluPh2212'],
	[1263, format(angle(scaled_wc('lu_1113')), '.6e'), '# cluPh1113'],
	[1264, format(angle(scaled_wc('lu_1123')), '.6e'), '# cluPh1123'],
	[1265, format(angle(scaled_wc('lu_1211')), '.6e'), '# cluPh1211'],
	[1266, format(angle(scaled_wc('lu_1212')), '.6e'), '# cluPh1212'],
	[1267, format(angle(scaled_wc('lu_1221')), '.6e'), '# cluPh1221'],
	[1268, format(angle(scaled_wc('lu_1213')), '.6e'), '# cluPh1213'],
	[1269, format(angle(scaled_wc('lu_1231')), '.6e'), '# cluPh1231'],
	[1270, format(angle(scaled_wc('lu_1222')), '.6e'), '# cluPh1222'],
	[1271, format(angle(scaled_wc('lu_1223')), '.6e'), '# cluPh1223'],
	[1272, format(angle(scaled_wc('lu_1232')), '.6e'), '# cluPh1232'],
	[1273, format(angle(scaled_wc('lu_1233')), '.6e'), '# cluPh1233'],
	[1274, format(angle(scaled_wc('lu_1311')), '.6e'), '# cluPh1311'],
	[1275, format(angle(scaled_wc('lu_1312')), '.6e'), '# cluPh1312'],
	[1276, format(angle(scaled_wc('lu_1313')), '.6e'), '# cluPh1313'],
	[1277, format(angle(scaled_wc('lu_1331')), '.6e'), '# cluPh1331'],
	[1278, format(angle(scaled_wc('lu_1321')), '.6e'), '# cluPh1321'],
	[1279, format(angle(scaled_wc('lu_1322')), '.6e'), '# cluPh1322'],
	[1280, format(angle(scaled_wc('lu_1332')), '.6e'), '# cluPh1332'],
	[1281, format(angle(scaled_wc('lu_1323')), '.6e'), '# cluPh1323'],
	[1282, format(angle(scaled_wc('lu_1333')), '.6e'), '# cluPh1333'],
	[1283, format(angle(scaled_wc('lu_2213')), '.6e'), '# cluPh2213'],
	[1284, format(angle(scaled_wc('lu_2223')), '.6e'), '# cluPh2223'],
	[1285, format(angle(scaled_wc('lu_2311')), '.6e'), '# cluPh2311'],
	[1286, format(angle(scaled_wc('lu_2312')), '.6e'), '# cluPh2312'],
	[1287, format(angle(scaled_wc('lu_2313')), '.6e'), '# cluPh2313'],
	[1288, format(angle(scaled_wc('lu_2321')), '.6e'), '# cluPh2321'],
	[1289, format(angle(scaled_wc('lu_2322')), '.6e'), '# cluPh2322'],
	[1290, format(angle(scaled_wc('lu_2323')), '.6e'), '# cluPh2323'],
	[1291, format(angle(scaled_wc('lu_2331')), '.6e'), '# cluPh2331'],
	[1292, format(angle(scaled_wc('lu_2332')), '.6e'), '# cluPh2332'],
	[1293, format(angle(scaled_wc('lu_2333')), '.6e'), '# cluPh2333'],
	[1294, format(angle(scaled_wc('lu_3323')), '.6e'), '# cluPh3323'],
	[1295, format(angle(scaled_wc('lu_3312')), '.6e'), '# cluPh3312'],
	[1296, format(angle(scaled_wc('lu_3313')), '.6e'), '# cluPh3313'],
	[1297, format(scaled_wc('ld_1111')* lambda_smeft_value**2, '.6e'), '# cldAbs1111'],
	[1298, format(abs(scaled_wc('ld_1112'))* lambda_smeft_value**2, '.6e'), '# cldAbs1112'],
	[1299, format(abs(scaled_wc('ld_1113'))* lambda_smeft_value**2, '.6e'), '# cldAbs1113'],
	[1300, format(abs(scaled_wc('ld_1123'))* lambda_smeft_value**2, '.6e'), '# cldAbs1123'],
	[1301, format(scaled_wc('ld_1122')* lambda_smeft_value**2, '.6e'), '# cldAbs1122'],
	[1302, format(scaled_wc('ld_1133')* lambda_smeft_value**2, '.6e'), '# cldAbs1133'],
	[1303, format(abs(scaled_wc('ld_1211'))* lambda_smeft_value**2, '.6e'), '# cldAbs1211'],
	[1304, format(abs(scaled_wc('ld_1212'))* lambda_smeft_value**2, '.6e'), '# cldAbs1212'],
	[1305, format(abs(scaled_wc('ld_1221'))* lambda_smeft_value**2, '.6e'), '# cldAbs1221'],
	[1306, format(abs(scaled_wc('ld_1213'))* lambda_smeft_value**2, '.6e'), '# cldAbs1213'],
	[1307, format(abs(scaled_wc('ld_1231'))* lambda_smeft_value**2, '.6e'), '# cldAbs1231'],
	[1308, format(abs(scaled_wc('ld_1222'))* lambda_smeft_value**2, '.6e'), '# cldAbs1222'],
	[1309, format(abs(scaled_wc('ld_1223'))* lambda_smeft_value**2, '.6e'), '# cldAbs1223'],
	[1310, format(abs(scaled_wc('ld_1232'))* lambda_smeft_value**2, '.6e'), '# cldAbs1232'],
	[1311, format(abs(scaled_wc('ld_1233'))* lambda_smeft_value**2, '.6e'), '# cldAbs1233'],
	[1312, format(abs(scaled_wc('ld_1311'))* lambda_smeft_value**2, '.6e'), '# cldAbs1311'],
	[1313, format(abs(scaled_wc('ld_1312'))* lambda_smeft_value**2, '.6e'), '# cldAbs1312'],
	[1314, format(abs(scaled_wc('ld_1313'))* lambda_smeft_value**2, '.6e'), '# cldAbs1313'],
	[1315, format(abs(scaled_wc('ld_1331'))* lambda_smeft_value**2, '.6e'), '# cldAbs1331'],
	[1316, format(abs(scaled_wc('ld_1321'))* lambda_smeft_value**2, '.6e'), '# cldAbs1321'],
	[1317, format(abs(scaled_wc('ld_1322'))* lambda_smeft_value**2, '.6e'), '# cldAbs1322'],
	[1318, format(abs(scaled_wc('ld_1332'))* lambda_smeft_value**2, '.6e'), '# cldAbs1332'],
	[1319, format(abs(scaled_wc('ld_1323'))* lambda_smeft_value**2, '.6e'), '# cldAbs1323'],
	[1320, format(abs(scaled_wc('ld_1333'))* lambda_smeft_value**2, '.6e'), '# cldAbs1333'],
	[1321, format(scaled_wc('ld_2211')* lambda_smeft_value**2, '.6e'), '# cldAbs2211'],
	[1322, format(abs(scaled_wc('ld_2212'))* lambda_smeft_value**2, '.6e'), '# cldAbs2212'],
	[1323, format(abs(scaled_wc('ld_2213'))* lambda_smeft_value**2, '.6e'), '# cldAbs2213'],
	[1324, format(scaled_wc('ld_2222')* lambda_smeft_value**2, '.6e'), '# cldAbs2222'],
	[1325, format(abs(scaled_wc('ld_2223'))* lambda_smeft_value**2, '.6e'), '# cldAbs2223'],
	[1326, format(scaled_wc('ld_2233')* lambda_smeft_value**2, '.6e'), '# cldAbs2233'],
	[1327, format(abs(scaled_wc('ld_2311'))* lambda_smeft_value**2, '.6e'), '# cldAbs2311'],
	[1328, format(abs(scaled_wc('ld_2312'))* lambda_smeft_value**2, '.6e'), '# cldAbs2312'],
	[1329, format(abs(scaled_wc('ld_2313'))* lambda_smeft_value**2, '.6e'), '# cldAbs2313'],
	[1330, format(abs(scaled_wc('ld_2321'))* lambda_smeft_value**2, '.6e'), '# cldAbs2321'],
	[1331, format(abs(scaled_wc('ld_2322'))* lambda_smeft_value**2, '.6e'), '# cldAbs2322'],
	[1332, format(abs(scaled_wc('ld_2323'))* lambda_smeft_value**2, '.6e'), '# cldAbs2323'],
	[1333, format(abs(scaled_wc('ld_2331'))* lambda_smeft_value**2, '.6e'), '# cldAbs2331'],
	[1334, format(abs(scaled_wc('ld_2332'))* lambda_smeft_value**2, '.6e'), '# cldAbs2332'],
	[1335, format(abs(scaled_wc('ld_2333'))* lambda_smeft_value**2, '.6e'), '# cldAbs2333'],
	[1336, format(scaled_wc('ld_3311')* lambda_smeft_value**2, '.6e'), '# cldAbs3311'],
	[1337, format(abs(scaled_wc('ld_3312'))* lambda_smeft_value**2, '.6e'), '# cldAbs3312'],
	[1338, format(abs(scaled_wc('ld_3313'))* lambda_smeft_value**2, '.6e'), '# cldAbs3313'],
	[1339, format(scaled_wc('ld_3322')* lambda_smeft_value**2, '.6e'), '# cldAbs3322'],
	[1340, format(scaled_wc('ld_3333')* lambda_smeft_value**2, '.6e'), '# cldAbs3333'],
	[1341, format(abs(scaled_wc('ld_3323'))* lambda_smeft_value**2, '.6e'), '# cldAbs3323'],
	[1342, format(angle(scaled_wc('ld_1112')), '.6e'), '# cldPh1112'],
	[1343, format(angle(scaled_wc('ld_2212')), '.6e'), '# cldPh2212'],
	[1344, format(angle(scaled_wc('ld_1113')), '.6e'), '# cldPh1113'],
	[1345, format(angle(scaled_wc('ld_1123')), '.6e'), '# cldPh1123'],
	[1346, format(angle(scaled_wc('ld_1211')), '.6e'), '# cldPh1211'],
	[1347, format(angle(scaled_wc('ld_1212')), '.6e'), '# cldPh1212'],
	[1348, format(angle(scaled_wc('ld_1221')), '.6e'), '# cldPh1221'],
	[1349, format(angle(scaled_wc('ld_1213')), '.6e'), '# cldPh1213'],
	[1350, format(angle(scaled_wc('ld_1231')), '.6e'), '# cldPh1231'],
	[1351, format(angle(scaled_wc('ld_1222')), '.6e'), '# cldPh1222'],
	[1352, format(angle(scaled_wc('ld_1223')), '.6e'), '# cldPh1223'],
	[1353, format(angle(scaled_wc('ld_1232')), '.6e'), '# cldPh1232'],
	[1354, format(angle(scaled_wc('ld_1233')), '.6e'), '# cldPh1233'],
	[1355, format(angle(scaled_wc('ld_1311')), '.6e'), '# cldPh1311'],
	[1356, format(angle(scaled_wc('ld_1312')), '.6e'), '# cldPh1312'],
	[1357, format(angle(scaled_wc('ld_1313')), '.6e'), '# cldPh1313'],
	[1358, format(angle(scaled_wc('ld_1331')), '.6e'), '# cldPh1331'],
	[1359, format(angle(scaled_wc('ld_1321')), '.6e'), '# cldPh1321'],
	[1360, format(angle(scaled_wc('ld_1322')), '.6e'), '# cldPh1322'],
	[1361, format(angle(scaled_wc('ld_1332')), '.6e'), '# cldPh1332'],
	[1362, format(angle(scaled_wc('ld_1323')), '.6e'), '# cldPh1323'],
	[1363, format(angle(scaled_wc('ld_1333')), '.6e'), '# cldPh1333'],
	[1364, format(angle(scaled_wc('ld_2213')), '.6e'), '# cldPh2213'],
	[1365, format(angle(scaled_wc('ld_2223')), '.6e'), '# cldPh2223'],
	[1366, format(angle(scaled_wc('ld_2311')), '.6e'), '# cldPh2311'],
	[1367, format(angle(scaled_wc('ld_2312')), '.6e'), '# cldPh2312'],
	[1368, format(angle(scaled_wc('ld_2313')), '.6e'), '# cldPh2313'],
	[1369, format(angle(scaled_wc('ld_2321')), '.6e'), '# cldPh2321'],
	[1370, format(angle(scaled_wc('ld_2322')), '.6e'), '# cldPh2322'],
	[1371, format(angle(scaled_wc('ld_2323')), '.6e'), '# cldPh2323'],
	[1372, format(angle(scaled_wc('ld_2331')), '.6e'), '# cldPh2331'],
	[1373, format(angle(scaled_wc('ld_2332')), '.6e'), '# cldPh2332'],
	[1374, format(angle(scaled_wc('ld_2333')), '.6e'), '# cldPh2333'],
	[1375, format(angle(scaled_wc('ld_3323')), '.6e'), '# cldPh3323'],
	[1376, format(angle(scaled_wc('ld_3312')), '.6e'), '# cldPh3312'],
	[1377, format(angle(scaled_wc('ld_3313')), '.6e'), '# cldPh3313'],
	[1378, format(scaled_wc('qe_1111')* lambda_smeft_value**2, '.6e'), '# cqeAbs1111'],
	[1379, format(abs(scaled_wc('qe_1112'))* lambda_smeft_value**2, '.6e'), '# cqeAbs1112'],
	[1380, format(abs(scaled_wc('qe_1113'))* lambda_smeft_value**2, '.6e'), '# cqeAbs1113'],
	[1381, format(abs(scaled_wc('qe_1123'))* lambda_smeft_value**2, '.6e'), '# cqeAbs1123'],
	[1382, format(scaled_wc('qe_1122')* lambda_smeft_value**2, '.6e'), '# cqeAbs1122'],
	[1383, format(scaled_wc('qe_1133')* lambda_smeft_value**2, '.6e'), '# cqeAbs1133'],
	[1384, format(abs(scaled_wc('qe_1211'))* lambda_smeft_value**2, '.6e'), '# cqeAbs1211'],
	[1385, format(abs(scaled_wc('qe_1212'))* lambda_smeft_value**2, '.6e'), '# cqeAbs1212'],
	[1386, format(abs(scaled_wc('qe_1221'))* lambda_smeft_value**2, '.6e'), '# cqeAbs1221'],
	[1387, format(abs(scaled_wc('qe_1213'))* lambda_smeft_value**2, '.6e'), '# cqeAbs1213'],
	[1388, format(abs(scaled_wc('qe_1231'))* lambda_smeft_value**2, '.6e'), '# cqeAbs1231'],
	[1389, format(abs(scaled_wc('qe_1222'))* lambda_smeft_value**2, '.6e'), '# cqeAbs1222'],
	[1390, format(abs(scaled_wc('qe_1223'))* lambda_smeft_value**2, '.6e'), '# cqeAbs1223'],
	[1391, format(abs(scaled_wc('qe_1232'))* lambda_smeft_value**2, '.6e'), '# cqeAbs1232'],
	[1392, format(abs(scaled_wc('qe_1233'))* lambda_smeft_value**2, '.6e'), '# cqeAbs1233'],
	[1393, format(abs(scaled_wc('qe_1311'))* lambda_smeft_value**2, '.6e'), '# cqeAbs1311'],
	[1394, format(abs(scaled_wc('qe_1312'))* lambda_smeft_value**2, '.6e'), '# cqeAbs1312'],
	[1395, format(abs(scaled_wc('qe_1313'))* lambda_smeft_value**2, '.6e'), '# cqeAbs1313'],
	[1396, format(abs(scaled_wc('qe_1331'))* lambda_smeft_value**2, '.6e'), '# cqeAbs1331'],
	[1397, format(abs(scaled_wc('qe_1321'))* lambda_smeft_value**2, '.6e'), '# cqeAbs1321'],
	[1398, format(abs(scaled_wc('qe_1322'))* lambda_smeft_value**2, '.6e'), '# cqeAbs1322'],
	[1399, format(abs(scaled_wc('qe_1332'))* lambda_smeft_value**2, '.6e'), '# cqeAbs1332'],
	[1400, format(abs(scaled_wc('qe_1323'))* lambda_smeft_value**2, '.6e'), '# cqeAbs1323'],
	[1401, format(abs(scaled_wc('qe_1333'))* lambda_smeft_value**2, '.6e'), '# cqeAbs1333'],
	[1402, format(scaled_wc('qe_2211')* lambda_smeft_value**2, '.6e'), '# cqeAbs2211'],
	[1403, format(abs(scaled_wc('qe_2212'))* lambda_smeft_value**2, '.6e'), '# cqeAbs2212'],
	[1404, format(abs(scaled_wc('qe_2213'))* lambda_smeft_value**2, '.6e'), '# cqeAbs2213'],
	[1405, format(scaled_wc('qe_2222')* lambda_smeft_value**2, '.6e'), '# cqeAbs2222'],
	[1406, format(abs(scaled_wc('qe_2223'))* lambda_smeft_value**2, '.6e'), '# cqeAbs2223'],
	[1407, format(scaled_wc('qe_2233')* lambda_smeft_value**2, '.6e'), '# cqeAbs2233'],
	[1408, format(abs(scaled_wc('qe_2311'))* lambda_smeft_value**2, '.6e'), '# cqeAbs2311'],
	[1409, format(abs(scaled_wc('qe_2312'))* lambda_smeft_value**2, '.6e'), '# cqeAbs2312'],
	[1410, format(abs(scaled_wc('qe_2313'))* lambda_smeft_value**2, '.6e'), '# cqeAbs2313'],
	[1411, format(abs(scaled_wc('qe_2321'))* lambda_smeft_value**2, '.6e'), '# cqeAbs2321'],
	[1412, format(abs(scaled_wc('qe_2322'))* lambda_smeft_value**2, '.6e'), '# cqeAbs2322'],
	[1413, format(abs(scaled_wc('qe_2323'))* lambda_smeft_value**2, '.6e'), '# cqeAbs2323'],
	[1414, format(abs(scaled_wc('qe_2331'))* lambda_smeft_value**2, '.6e'), '# cqeAbs2331'],
	[1415, format(abs(scaled_wc('qe_2332'))* lambda_smeft_value**2, '.6e'), '# cqeAbs2332'],
	[1416, format(abs(scaled_wc('qe_2333'))* lambda_smeft_value**2, '.6e'), '# cqeAbs2333'],
	[1417, format(scaled_wc('qe_3311')* lambda_smeft_value**2, '.6e'), '# cqeAbs3311'],
	[1418, format(abs(scaled_wc('qe_3312'))* lambda_smeft_value**2, '.6e'), '# cqeAbs3312'],
	[1419, format(abs(scaled_wc('qe_3313'))* lambda_smeft_value**2, '.6e'), '# cqeAbs3313'],
	[1420, format(scaled_wc('qe_3322')* lambda_smeft_value**2, '.6e'), '# cqeAbs3322'],
	[1421, format(scaled_wc('qe_3333')* lambda_smeft_value**2, '.6e'), '# cqeAbs3333'],
	[1422, format(abs(scaled_wc('qe_3323'))* lambda_smeft_value**2, '.6e'), '# cqeAbs3323'],
	[1423, format(angle(scaled_wc('qe_1112')), '.6e'), '# cqePh1112'],
	[1424, format(angle(scaled_wc('qe_2212')), '.6e'), '# cqePh2212'],
	[1425, format(angle(scaled_wc('qe_1113')), '.6e'), '# cqePh1113'],
	[1426, format(angle(scaled_wc('qe_1123')), '.6e'), '# cqePh1123'],
	[1427, format(angle(scaled_wc('qe_1211')), '.6e'), '# cqePh1211'],
	[1428, format(angle(scaled_wc('qe_1212')), '.6e'), '# cqePh1212'],
	[1429, format(angle(scaled_wc('qe_1221')), '.6e'), '# cqePh1221'],
	[1430, format(angle(scaled_wc('qe_1213')), '.6e'), '# cqePh1213'],
	[1431, format(angle(scaled_wc('qe_1231')), '.6e'), '# cqePh1231'],
	[1432, format(angle(scaled_wc('qe_1222')), '.6e'), '# cqePh1222'],
	[1433, format(angle(scaled_wc('qe_1223')), '.6e'), '# cqePh1223'],
	[1434, format(angle(scaled_wc('qe_1232')), '.6e'), '# cqePh1232'],
	[1435, format(angle(scaled_wc('qe_1233')), '.6e'), '# cqePh1233'],
	[1436, format(angle(scaled_wc('qe_1311')), '.6e'), '# cqePh1311'],
	[1437, format(angle(scaled_wc('qe_1312')), '.6e'), '# cqePh1312'],
	[1438, format(angle(scaled_wc('qe_1313')), '.6e'), '# cqePh1313'],
	[1439, format(angle(scaled_wc('qe_1331')), '.6e'), '# cqePh1331'],
	[1440, format(angle(scaled_wc('qe_1321')), '.6e'), '# cqePh1321'],
	[1441, format(angle(scaled_wc('qe_1322')), '.6e'), '# cqePh1322'],
	[1442, format(angle(scaled_wc('qe_1332')), '.6e'), '# cqePh1332'],
	[1443, format(angle(scaled_wc('qe_1323')), '.6e'), '# cqePh1323'],
	[1444, format(angle(scaled_wc('qe_1333')), '.6e'), '# cqePh1333'],
	[1445, format(angle(scaled_wc('qe_2213')), '.6e'), '# cqePh2213'],
	[1446, format(angle(scaled_wc('qe_2223')), '.6e'), '# cqePh2223'],
	[1447, format(angle(scaled_wc('qe_2311')), '.6e'), '# cqePh2311'],
	[1448, format(angle(scaled_wc('qe_2312')), '.6e'), '# cqePh2312'],
	[1449, format(angle(scaled_wc('qe_2313')), '.6e'), '# cqePh2313'],
	[1450, format(angle(scaled_wc('qe_2321')), '.6e'), '# cqePh2321'],
	[1451, format(angle(scaled_wc('qe_2322')), '.6e'), '# cqePh2322'],
	[1452, format(angle(scaled_wc('qe_2323')), '.6e'), '# cqePh2323'],
	[1453, format(angle(scaled_wc('qe_2331')), '.6e'), '# cqePh2331'],
	[1454, format(angle(scaled_wc('qe_2332')), '.6e'), '# cqePh2332'],
	[1455, format(angle(scaled_wc('qe_2333')), '.6e'), '# cqePh2333'],
	[1456, format(angle(scaled_wc('qe_3323')), '.6e'), '# cqePh3323'],
	[1457, format(angle(scaled_wc('qe_3312')), '.6e'), '# cqePh3312'],
	[1458, format(angle(scaled_wc('qe_3313')), '.6e'), '# cqePh3313'],
      ]}

      card['Block']['FRBlock10'] = {'values': [
	  [1, 1, format(angle(scaled_wc('uphi_11')), '.6e'), '# cuHPh1x1'],
	  [1, 2, format(angle(scaled_wc('uphi_12')), '.6e'), '# cuHPh1x2'],
	  [1, 3, format(angle(scaled_wc('uphi_13')), '.6e'), '# cuHPh1x3'],
	  [2, 1, format(angle(scaled_wc('uphi_21')), '.6e'), '# cuHPh2x1'],
	  [2, 2, format(angle(scaled_wc('uphi_22')), '.6e'), '# cuHPh2x2'],
	  [2, 3, format(angle(scaled_wc('uphi_23')), '.6e'), '# cuHPh2x3'],
	  [3, 1, format(angle(scaled_wc('uphi_31')), '.6e'), '# cuHPh3x1'],
	  [3, 2, format(angle(scaled_wc('uphi_32')), '.6e'), '# cuHPh3x2'],
	  [3, 3, format(angle(scaled_wc('uphi_33')), '.6e'), '# cuHPh3x3'],
      ]}

      card['Block']['FRBlock11'] = {'values': [
	  [1, 1, format(angle(scaled_wc('dphi_11')), '.6e'), '# cdHPh1x1'],
	  [1, 2, format(angle(scaled_wc('dphi_12')), '.6e'), '# cdHPh1x2'],
	  [1, 3, format(angle(scaled_wc('dphi_13')), '.6e'), '# cdHPh1x3'],
	  [2, 1, format(angle(scaled_wc('dphi_21')), '.6e'), '# cdHPh2x1'],
	  [2, 2, format(angle(scaled_wc('dphi_22')), '.6e'), '# cdHPh2x2'],
	  [2, 3, format(angle(scaled_wc('dphi_23')), '.6e'), '# cdHPh2x3'],
	  [3, 1, format(angle(scaled_wc('dphi_31')), '.6e'), '# cdHPh3x1'],
	  [3, 2, format(angle(scaled_wc('dphi_32')), '.6e'), '# cdHPh3x2'],
	  [3, 3, format(angle(scaled_wc('dphi_33')), '.6e'), '# cdHPh3x3'],
      ]}

      card['Block']['FRBlock15'] = {'values': [
	  [1, 1, format(abs(scaled_wc('eW_11'))* lambda_smeft_value**2, '.6e'), '# ceWAbs1x1'],
	  [1, 2, format(abs(scaled_wc('eW_12'))* lambda_smeft_value**2, '.6e'), '# ceWAbs1x2'],
	  [1, 3, format(abs(scaled_wc('eW_13'))* lambda_smeft_value**2, '.6e'), '# ceWAbs1x3'],
	  [2, 1, format(abs(scaled_wc('eW_21'))* lambda_smeft_value**2, '.6e'), '# ceWAbs2x1'],
	  [2, 2, format(abs(scaled_wc('eW_22'))* lambda_smeft_value**2, '.6e'), '# ceWAbs2x2'],
	  [2, 3, format(abs(scaled_wc('eW_23'))* lambda_smeft_value**2, '.6e'), '# ceWAbs2x3'],
	  [3, 1, format(abs(scaled_wc('eW_31'))* lambda_smeft_value**2, '.6e'), '# ceWAbs3x1'],
	  [3, 2, format(abs(scaled_wc('eW_32'))* lambda_smeft_value**2, '.6e'), '# ceWAbs3x2'],
	  [3, 3, format(abs(scaled_wc('eW_33'))* lambda_smeft_value**2, '.6e'), '# ceWAbs3x3'],
      ]}

      card['Block']['FRBlock16'] = {'values': [
	  [1, 1, format(angle(scaled_wc('eW_11')), '.6e'), '# ceWPh1x1'],
	  [1, 2, format(angle(scaled_wc('eW_12')), '.6e'), '# ceWPh1x2'],
	  [1, 3, format(angle(scaled_wc('eW_13')), '.6e'), '# ceWPh1x3'],
	  [2, 1, format(angle(scaled_wc('eW_21')), '.6e'), '# ceWPh2x1'],
	  [2, 2, format(angle(scaled_wc('eW_22')), '.6e'), '# ceWPh2x2'],
	  [2, 3, format(angle(scaled_wc('eW_23')), '.6e'), '# ceWPh2x3'],
	  [3, 1, format(angle(scaled_wc('eW_31')), '.6e'), '# ceWPh3x1'],
	  [3, 2, format(angle(scaled_wc('eW_32')), '.6e'), '# ceWPh3x2'],
	  [3, 3, format(angle(scaled_wc('eW_33')), '.6e'), '# ceWPh3x3'],
      ]}

      card['Block']['FRBlock18'] = {'values': [
	  [1, 1, format(abs(scaled_wc('eB_11'))* lambda_smeft_value**2, '.6e'), '# ceBAbs1x1'],
	  [1, 2, format(abs(scaled_wc('eB_12'))* lambda_smeft_value**2, '.6e'), '# ceBAbs1x2'],
	  [1, 3, format(abs(scaled_wc('eB_13'))* lambda_smeft_value**2, '.6e'), '# ceBAbs1x3'],
	  [2, 1, format(abs(scaled_wc('eB_21'))* lambda_smeft_value**2, '.6e'), '# ceBAbs2x1'],
	  [2, 2, format(abs(scaled_wc('eB_22'))* lambda_smeft_value**2, '.6e'), '# ceBAbs2x2'],
	  [2, 3, format(abs(scaled_wc('eB_23'))* lambda_smeft_value**2, '.6e'), '# ceBAbs2x3'],
	  [3, 1, format(abs(scaled_wc('eB_31'))* lambda_smeft_value**2, '.6e'), '# ceBAbs3x1'],
	  [3, 2, format(abs(scaled_wc('eB_32'))* lambda_smeft_value**2, '.6e'), '# ceBAbs3x2'],
	  [3, 3, format(abs(scaled_wc('eB_33'))* lambda_smeft_value**2, '.6e'), '# ceBAbs3x3'],
      ]}

      card['Block']['FRBlock19'] = {'values': [
	  [1, 1, format(angle(scaled_wc('eB_11')), '.6e'), '# ceBPh1x1'],
	  [1, 2, format(angle(scaled_wc('eB_12')), '.6e'), '# ceBPh1x2'],
	  [1, 3, format(angle(scaled_wc('eB_13')), '.6e'), '# ceBPh1x3'],
	  [2, 1, format(angle(scaled_wc('eB_21')), '.6e'), '# ceBPh2x1'],
	  [2, 2, format(angle(scaled_wc('eB_22')), '.6e'), '# ceBPh2x2'],
	  [2, 3, format(angle(scaled_wc('eB_23')), '.6e'), '# ceBPh2x3'],
	  [3, 1, format(angle(scaled_wc('eB_31')), '.6e'), '# ceBPh3x1'],
	  [3, 2, format(angle(scaled_wc('eB_32')), '.6e'), '# ceBPh3x2'],
	  [3, 3, format(angle(scaled_wc('eB_33')), '.6e'), '# ceBPh3x3'],
      ]}

      card['Block']['FRBlock21'] = {'values': [
	  [1, 1, format(abs(scaled_wc('uG_11'))* lambda_smeft_value**2, '.6e'), '# cuGAbs1x1'],
	  [1, 2, format(abs(scaled_wc('uG_12'))* lambda_smeft_value**2, '.6e'), '# cuGAbs1x2'],
	  [1, 3, format(abs(scaled_wc('uG_13'))* lambda_smeft_value**2, '.6e'), '# cuGAbs1x3'],
	  [2, 1, format(abs(scaled_wc('uG_21'))* lambda_smeft_value**2, '.6e'), '# cuGAbs2x1'],
	  [2, 2, format(abs(scaled_wc('uG_22'))* lambda_smeft_value**2, '.6e'), '# cuGAbs2x2'],
	  [2, 3, format(abs(scaled_wc('uG_23'))* lambda_smeft_value**2, '.6e'), '# cuGAbs2x3'],
	  [3, 1, format(abs(scaled_wc('uG_31'))* lambda_smeft_value**2, '.6e'), '# cuGAbs3x1'],
	  [3, 2, format(abs(scaled_wc('uG_32'))* lambda_smeft_value**2, '.6e'), '# cuGAbs3x2'],
	  [3, 3, format(abs(scaled_wc('uG_33'))* lambda_smeft_value**2, '.6e'), '# cuGAbs3x3'],
      ]}

      card['Block']['FRBlock22'] = {'values': [
	  [1, 1, format(angle(scaled_wc('uG_11')), '.6e'), '# cuGPh1x1'],
	  [1, 2, format(angle(scaled_wc('uG_12')), '.6e'), '# cuGPh1x2'],
	  [1, 3, format(angle(scaled_wc('uG_13')), '.6e'), '# cuGPh1x3'],
	  [2, 1, format(angle(scaled_wc('uG_21')), '.6e'), '# cuGPh2x1'],
	  [2, 2, format(angle(scaled_wc('uG_22')), '.6e'), '# cuGPh2x2'],
	  [2, 3, format(angle(scaled_wc('uG_23')), '.6e'), '# cuGPh2x3'],
	  [3, 1, format(angle(scaled_wc('uG_31')), '.6e'), '# cuGPh3x1'],
	  [3, 2, format(angle(scaled_wc('uG_32')), '.6e'), '# cuGPh3x2'],
	  [3, 3, format(angle(scaled_wc('uG_33')), '.6e'), '# cuGPh3x3'],
      ]}

      card['Block']['FRBlock24'] = {'values': [
	  [1, 1, format(abs(scaled_wc('uW_11'))* lambda_smeft_value**2, '.6e'), '# cuWAbs1x1'],
	  [1, 2, format(abs(scaled_wc('uW_12'))* lambda_smeft_value**2, '.6e'), '# cuWAbs1x2'],
	  [1, 3, format(abs(scaled_wc('uW_13'))* lambda_smeft_value**2, '.6e'), '# cuWAbs1x3'],
	  [2, 1, format(abs(scaled_wc('uW_21'))* lambda_smeft_value**2, '.6e'), '# cuWAbs2x1'],
	  [2, 2, format(abs(scaled_wc('uW_22'))* lambda_smeft_value**2, '.6e'), '# cuWAbs2x2'],
	  [2, 3, format(abs(scaled_wc('uW_23'))* lambda_smeft_value**2, '.6e'), '# cuWAbs2x3'],
	  [3, 1, format(abs(scaled_wc('uW_31'))* lambda_smeft_value**2, '.6e'), '# cuWAbs3x1'],
	  [3, 2, format(abs(scaled_wc('uW_32'))* lambda_smeft_value**2, '.6e'), '# cuWAbs3x2'],
	  [3, 3, format(abs(scaled_wc('uW_33'))* lambda_smeft_value**2, '.6e'), '# cuWAbs3x3'],
      ]}

      card['Block']['FRBlock25'] = {'values': [
	  [1, 1, format(angle(scaled_wc('uW_11')), '.6e'), '# cuWPh1x1'],
	  [1, 2, format(angle(scaled_wc('uW_12')), '.6e'), '# cuWPh1x2'],
	  [1, 3, format(angle(scaled_wc('uW_13')), '.6e'), '# cuWPh1x3'],
	  [2, 1, format(angle(scaled_wc('uW_21')), '.6e'), '# cuWPh2x1'],
	  [2, 2, format(angle(scaled_wc('uW_22')), '.6e'), '# cuWPh2x2'],
	  [2, 3, format(angle(scaled_wc('uW_23')), '.6e'), '# cuWPh2x3'],
	  [3, 1, format(angle(scaled_wc('uW_31')), '.6e'), '# cuWPh3x1'],
	  [3, 2, format(angle(scaled_wc('uW_32')), '.6e'), '# cuWPh3x2'],
	  [3, 3, format(angle(scaled_wc('uW_33')), '.6e'), '# cuWPh3x3'],
      ]}

      card['Block']['FRBlock27'] = {'values': [
	  [1, 1, format(abs(scaled_wc('uB_11'))* lambda_smeft_value**2, '.6e'), '# cuBAbs1x1'],
	  [1, 2, format(abs(scaled_wc('uB_12'))* lambda_smeft_value**2, '.6e'), '# cuBAbs1x2'],
	  [1, 3, format(abs(scaled_wc('uB_13'))* lambda_smeft_value**2, '.6e'), '# cuBAbs1x3'],
	  [2, 1, format(abs(scaled_wc('uB_21'))* lambda_smeft_value**2, '.6e'), '# cuBAbs2x1'],
	  [2, 2, format(abs(scaled_wc('uB_22'))* lambda_smeft_value**2, '.6e'), '# cuBAbs2x2'],
	  [2, 3, format(abs(scaled_wc('uB_23'))* lambda_smeft_value**2, '.6e'), '# cuBAbs2x3'],
	  [3, 1, format(abs(scaled_wc('uB_31'))* lambda_smeft_value**2, '.6e'), '# cuBAbs3x1'],
	  [3, 2, format(abs(scaled_wc('uB_32'))* lambda_smeft_value**2, '.6e'), '# cuBAbs3x2'],
	  [3, 3, format(abs(scaled_wc('uB_33'))* lambda_smeft_value**2, '.6e'), '# cuBAbs3x3'],
      ]}

      card['Block']['FRBlock28'] = {'values': [
	  [1, 1, format(angle(scaled_wc('uB_11')), '.6e'), '# cuBPh1x1'],
	  [1, 2, format(angle(scaled_wc('uB_12')), '.6e'), '# cuBPh1x2'],
	  [1, 3, format(angle(scaled_wc('uB_13')), '.6e'), '# cuBPh1x3'],
	  [2, 1, format(angle(scaled_wc('uB_21')), '.6e'), '# cuBPh2x1'],
	  [2, 2, format(angle(scaled_wc('uB_22')), '.6e'), '# cuBPh2x2'],
	  [2, 3, format(angle(scaled_wc('uB_23')), '.6e'), '# cuBPh2x3'],
	  [3, 1, format(angle(scaled_wc('uB_31')), '.6e'), '# cuBPh3x1'],
	  [3, 2, format(angle(scaled_wc('uB_32')), '.6e'), '# cuBPh3x2'],
	  [3, 3, format(angle(scaled_wc('uB_33')), '.6e'), '# cuBPh3x3'],
      ]}

      card['Block']['FRBlock30'] = {'values': [
	  [1, 1, format(abs(scaled_wc('dG_11'))* lambda_smeft_value**2, '.6e'), '# cdGAbs1x1'],
	  [1, 2, format(abs(scaled_wc('dG_12'))* lambda_smeft_value**2, '.6e'), '# cdGAbs1x2'],
	  [1, 3, format(abs(scaled_wc('dG_13'))* lambda_smeft_value**2, '.6e'), '# cdGAbs1x3'],
	  [2, 1, format(abs(scaled_wc('dG_21'))* lambda_smeft_value**2, '.6e'), '# cdGAbs2x1'],
	  [2, 2, format(abs(scaled_wc('dG_22'))* lambda_smeft_value**2, '.6e'), '# cdGAbs2x2'],
	  [2, 3, format(abs(scaled_wc('dG_23'))* lambda_smeft_value**2, '.6e'), '# cdGAbs2x3'],
	  [3, 1, format(abs(scaled_wc('dG_31'))* lambda_smeft_value**2, '.6e'), '# cdGAbs3x1'],
	  [3, 2, format(abs(scaled_wc('dG_32'))* lambda_smeft_value**2, '.6e'), '# cdGAbs3x2'],
	  [3, 3, format(abs(scaled_wc('dG_33'))* lambda_smeft_value**2, '.6e'), '# cdGAbs3x3'],
      ]}

      card['Block']['FRBlock31'] = {'values': [
	  [1, 1, format(angle(scaled_wc('dG_11')), '.6e'), '# cdGPh1x1'],
	  [1, 2, format(angle(scaled_wc('dG_12')), '.6e'), '# cdGPh1x2'],
	  [1, 3, format(angle(scaled_wc('dG_13')), '.6e'), '# cdGPh1x3'],
	  [2, 1, format(angle(scaled_wc('dG_21')), '.6e'), '# cdGPh2x1'],
	  [2, 2, format(angle(scaled_wc('dG_22')), '.6e'), '# cdGPh2x2'],
	  [2, 3, format(angle(scaled_wc('dG_23')), '.6e'), '# cdGPh2x3'],
	  [3, 1, format(angle(scaled_wc('dG_31')), '.6e'), '# cdGPh3x1'],
	  [3, 2, format(angle(scaled_wc('dG_32')), '.6e'), '# cdGPh3x2'],
	  [3, 3, format(angle(scaled_wc('dG_33')), '.6e'), '# cdGPh3x3'],
      ]}

      card['Block']['FRBlock33'] = {'values': [
	  [1, 1, format(abs(scaled_wc('dW_11'))* lambda_smeft_value**2, '.6e'), '# cdWAbs1x1'],
	  [1, 2, format(abs(scaled_wc('dW_12'))* lambda_smeft_value**2, '.6e'), '# cdWAbs1x2'],
	  [1, 3, format(abs(scaled_wc('dW_13'))* lambda_smeft_value**2, '.6e'), '# cdWAbs1x3'],
	  [2, 1, format(abs(scaled_wc('dW_21'))* lambda_smeft_value**2, '.6e'), '# cdWAbs2x1'],
	  [2, 2, format(abs(scaled_wc('dW_22'))* lambda_smeft_value**2, '.6e'), '# cdWAbs2x2'],
	  [2, 3, format(abs(scaled_wc('dW_23'))* lambda_smeft_value**2, '.6e'), '# cdWAbs2x3'],
	  [3, 1, format(abs(scaled_wc('dW_31'))* lambda_smeft_value**2, '.6e'), '# cdWAbs3x1'],
	  [3, 2, format(abs(scaled_wc('dW_32'))* lambda_smeft_value**2, '.6e'), '# cdWAbs3x2'],
	  [3, 3, format(abs(scaled_wc('dW_33'))* lambda_smeft_value**2, '.6e'), '# cdWAbs3x3'],
      ]}

      card['Block']['FRBlock34'] = {'values': [
	  [1, 1, format(angle(scaled_wc('dW_11')), '.6e'), '# cdWPh1x1'],
	  [1, 2, format(angle(scaled_wc('dW_12')), '.6e'), '# cdWPh1x2'],
	  [1, 3, format(angle(scaled_wc('dW_13')), '.6e'), '# cdWPh1x3'],
	  [2, 1, format(angle(scaled_wc('dW_21')), '.6e'), '# cdWPh2x1'],
	  [2, 2, format(angle(scaled_wc('dW_22')), '.6e'), '# cdWPh2x2'],
	  [2, 3, format(angle(scaled_wc('dW_23')), '.6e'), '# cdWPh2x3'],
	  [3, 1, format(angle(scaled_wc('dW_31')), '.6e'), '# cdWPh3x1'],
	  [3, 2, format(angle(scaled_wc('dW_32')), '.6e'), '# cdWPh3x2'],
	  [3, 3, format(angle(scaled_wc('dW_33')), '.6e'), '# cdWPh3x3'],
      ]}

      card['Block']['FRBlock36'] = {'values': [
	  [1, 1, format(abs(scaled_wc('dB_11'))* lambda_smeft_value**2, '.6e'), '# cdBAbs1x1'],
	  [1, 2, format(abs(scaled_wc('dB_12'))* lambda_smeft_value**2, '.6e'), '# cdBAbs1x2'],
	  [1, 3, format(abs(scaled_wc('dB_13'))* lambda_smeft_value**2, '.6e'), '# cdBAbs1x3'],
	  [2, 1, format(abs(scaled_wc('dB_21'))* lambda_smeft_value**2, '.6e'), '# cdBAbs2x1'],
	  [2, 2, format(abs(scaled_wc('dB_22'))* lambda_smeft_value**2, '.6e'), '# cdBAbs2x2'],
	  [2, 3, format(abs(scaled_wc('dB_23'))* lambda_smeft_value**2, '.6e'), '# cdBAbs2x3'],
	  [3, 1, format(abs(scaled_wc('dB_31'))* lambda_smeft_value**2, '.6e'), '# cdBAbs3x1'],
	  [3, 2, format(abs(scaled_wc('dB_32'))* lambda_smeft_value**2, '.6e'), '# cdBAbs3x2'],
	  [3, 3, format(abs(scaled_wc('dB_33'))* lambda_smeft_value**2, '.6e'), '# cdBAbs3x3'],
      ]}

      card['Block']['FRBlock37'] = {'values': [
	  [1, 1, format(angle(scaled_wc('dB_11')), '.6e'), '# cdBPh1x1'],
	  [1, 2, format(angle(scaled_wc('dB_12')), '.6e'), '# cdBPh1x2'],
	  [1, 3, format(angle(scaled_wc('dB_13')), '.6e'), '# cdBPh1x3'],
	  [2, 1, format(angle(scaled_wc('dB_21')), '.6e'), '# cdBPh2x1'],
	  [2, 2, format(angle(scaled_wc('dB_22')), '.6e'), '# cdBPh2x2'],
	  [2, 3, format(angle(scaled_wc('dB_23')), '.6e'), '# cdBPh2x3'],
	  [3, 1, format(angle(scaled_wc('dB_31')), '.6e'), '# cdBPh3x1'],
	  [3, 2, format(angle(scaled_wc('dB_32')), '.6e'), '# cdBPh3x2'],
	  [3, 3, format(angle(scaled_wc('dB_33')), '.6e'), '# cdBPh3x3'],
      ]}

      card['Block']['FRBlock45'] = {'values': [
	  [1, 1, format(abs(scaled_wc('phiud_11'))* lambda_smeft_value**2, '.6e'), '# cHudAbs1x1'],
	  [1, 2, format(abs(scaled_wc('phiud_12'))* lambda_smeft_value**2, '.6e'), '# cHudAbs1x2'],
	  [1, 3, format(abs(scaled_wc('phiud_13'))* lambda_smeft_value**2, '.6e'), '# cHudAbs1x3'],
	  [2, 1, format(abs(scaled_wc('phiud_21'))* lambda_smeft_value**2, '.6e'), '# cHudAbs2x1'],
	  [2, 2, format(abs(scaled_wc('phiud_22'))* lambda_smeft_value**2, '.6e'), '# cHudAbs2x2'],
	  [2, 3, format(abs(scaled_wc('phiud_23'))* lambda_smeft_value**2, '.6e'), '# cHudAbs2x3'],
	  [3, 1, format(abs(scaled_wc('phiud_31'))* lambda_smeft_value**2, '.6e'), '# cHudAbs3x1'],
	  [3, 2, format(abs(scaled_wc('phiud_32'))* lambda_smeft_value**2, '.6e'), '# cHudAbs3x2'],
	  [3, 3, format(abs(scaled_wc('phiud_33'))* lambda_smeft_value**2, '.6e'), '# cHudAbs3x3'],
      ]}

      card['Block']['FRBlock46'] = {'values': [
	  [1, 1, format(angle(scaled_wc('phiud_11')), '.6e'), '# cHudPh1x1'],
	  [1, 2, format(angle(scaled_wc('phiud_12')), '.6e'), '# cHudPh1x2'],
	  [1, 3, format(angle(scaled_wc('phiud_13')), '.6e'), '# cHudPh1x3'],
	  [2, 1, format(angle(scaled_wc('phiud_21')), '.6e'), '# cHudPh2x1'],
	  [2, 2, format(angle(scaled_wc('phiud_22')), '.6e'), '# cHudPh2x2'],
	  [2, 3, format(angle(scaled_wc('phiud_23')), '.6e'), '# cHudPh2x3'],
	  [3, 1, format(angle(scaled_wc('phiud_31')), '.6e'), '# cHudPh3x1'],
	  [3, 2, format(angle(scaled_wc('phiud_32')), '.6e'), '# cHudPh3x2'],
	  [3, 3, format(angle(scaled_wc('phiud_33')), '.6e'), '# cHudPh3x3'],
      ]}

      card['Block']['FRBlock6'] = {'values': [
	  [1, 1, format(abs(scaled_wc('ephi_11'))* lambda_smeft_value**2, '.6e'), '# ceHAbs1x1'],
	  [1, 2, format(abs(scaled_wc('ephi_12'))* lambda_smeft_value**2, '.6e'), '# ceHAbs1x2'],
	  [1, 3, format(abs(scaled_wc('ephi_13'))* lambda_smeft_value**2, '.6e'), '# ceHAbs1x3'],
	  [2, 1, format(abs(scaled_wc('ephi_21'))* lambda_smeft_value**2, '.6e'), '# ceHAbs2x1'],
	  [2, 2, format(abs(scaled_wc('ephi_22'))* lambda_smeft_value**2, '.6e'), '# ceHAbs2x2'],
	  [2, 3, format(abs(scaled_wc('ephi_23'))* lambda_smeft_value**2, '.6e'), '# ceHAbs2x3'],
	  [3, 1, format(abs(scaled_wc('ephi_31'))* lambda_smeft_value**2, '.6e'), '# ceHAbs3x1'],
	  [3, 2, format(abs(scaled_wc('ephi_32'))* lambda_smeft_value**2, '.6e'), '# ceHAbs3x2'],
	  [3, 3, format(abs(scaled_wc('ephi_33'))* lambda_smeft_value**2, '.6e'), '# ceHAbs3x3'],
      ]}

      card['Block']['FRBlock69'] = {'values': [
	  [1, 1, 1, 1, format(abs(scaled_wc('ledq_1111'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x1x1x1'],
	  [1, 1, 1, 2, format(abs(scaled_wc('ledq_1112'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x1x1x2'],
	  [1, 1, 1, 3, format(abs(scaled_wc('ledq_1113'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x1x1x3'],
	  [1, 1, 2, 1, format(abs(scaled_wc('ledq_1121'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x1x2x1'],
	  [1, 1, 2, 2, format(abs(scaled_wc('ledq_1122'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x1x2x2'],
	  [1, 1, 2, 3, format(abs(scaled_wc('ledq_1123'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x1x2x3'],
	  [1, 1, 3, 1, format(abs(scaled_wc('ledq_1131'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x1x3x1'],
	  [1, 1, 3, 2, format(abs(scaled_wc('ledq_1132'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x1x3x2'],
	  [1, 1, 3, 3, format(abs(scaled_wc('ledq_1133'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x1x3x3'],
	  [1, 2, 1, 1, format(abs(scaled_wc('ledq_1211'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x2x1x1'],
	  [1, 2, 1, 2, format(abs(scaled_wc('ledq_1212'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x2x1x2'],
	  [1, 2, 1, 3, format(abs(scaled_wc('ledq_1213'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x2x1x3'],
	  [1, 2, 2, 1, format(abs(scaled_wc('ledq_1221'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x2x2x1'],
	  [1, 2, 2, 2, format(abs(scaled_wc('ledq_1222'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x2x2x2'],
	  [1, 2, 2, 3, format(abs(scaled_wc('ledq_1223'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x2x2x3'],
	  [1, 2, 3, 1, format(abs(scaled_wc('ledq_1231'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x2x3x1'],
	  [1, 2, 3, 2, format(abs(scaled_wc('ledq_1232'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x2x3x2'],
	  [1, 2, 3, 3, format(abs(scaled_wc('ledq_1233'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x2x3x3'],
	  [1, 3, 1, 1, format(abs(scaled_wc('ledq_1311'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x3x1x1'],
	  [1, 3, 1, 2, format(abs(scaled_wc('ledq_1312'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x3x1x2'],
	  [1, 3, 1, 3, format(abs(scaled_wc('ledq_1313'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x3x1x3'],
	  [1, 3, 2, 1, format(abs(scaled_wc('ledq_1321'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x3x2x1'],
	  [1, 3, 2, 2, format(abs(scaled_wc('ledq_1322'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x3x2x2'],
	  [1, 3, 2, 3, format(abs(scaled_wc('ledq_1323'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x3x2x3'],
	  [1, 3, 3, 1, format(abs(scaled_wc('ledq_1331'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x3x3x1'],
	  [1, 3, 3, 2, format(abs(scaled_wc('ledq_1332'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x3x3x2'],
	  [1, 3, 3, 3, format(abs(scaled_wc('ledq_1333'))* lambda_smeft_value**2, '.6e'), '# cledqAbs1x3x3x3'],
	  [2, 1, 1, 1, format(abs(scaled_wc('ledq_2111'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x1x1x1'],
	  [2, 1, 1, 2, format(abs(scaled_wc('ledq_2112'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x1x1x2'],
	  [2, 1, 1, 3, format(abs(scaled_wc('ledq_2113'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x1x1x3'],
	  [2, 1, 2, 1, format(abs(scaled_wc('ledq_2121'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x1x2x1'],
	  [2, 1, 2, 2, format(abs(scaled_wc('ledq_2122'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x1x2x2'],
	  [2, 1, 2, 3, format(abs(scaled_wc('ledq_2123'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x1x2x3'],
	  [2, 1, 3, 1, format(abs(scaled_wc('ledq_2131'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x1x3x1'],
	  [2, 1, 3, 2, format(abs(scaled_wc('ledq_2132'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x1x3x2'],
	  [2, 1, 3, 3, format(abs(scaled_wc('ledq_2133'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x1x3x3'],
	  [2, 2, 1, 1, format(abs(scaled_wc('ledq_2211'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x2x1x1'],
	  [2, 2, 1, 2, format(abs(scaled_wc('ledq_2212'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x2x1x2'],
	  [2, 2, 1, 3, format(abs(scaled_wc('ledq_2213'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x2x1x3'],
	  [2, 2, 2, 1, format(abs(scaled_wc('ledq_2221'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x2x2x1'],
	  [2, 2, 2, 2, format(abs(scaled_wc('ledq_2222'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x2x2x2'],
	  [2, 2, 2, 3, format(abs(scaled_wc('ledq_2223'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x2x2x3'],
	  [2, 2, 3, 1, format(abs(scaled_wc('ledq_2231'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x2x3x1'],
	  [2, 2, 3, 2, format(abs(scaled_wc('ledq_2232'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x2x3x2'],
	  [2, 2, 3, 3, format(abs(scaled_wc('ledq_2233'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x2x3x3'],
	  [2, 3, 1, 1, format(abs(scaled_wc('ledq_2311'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x3x1x1'],
	  [2, 3, 1, 2, format(abs(scaled_wc('ledq_2312'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x3x1x2'],
	  [2, 3, 1, 3, format(abs(scaled_wc('ledq_2313'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x3x1x3'],
	  [2, 3, 2, 1, format(abs(scaled_wc('ledq_2321'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x3x2x1'],
	  [2, 3, 2, 2, format(abs(scaled_wc('ledq_2322'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x3x2x2'],
	  [2, 3, 2, 3, format(abs(scaled_wc('ledq_2323'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x3x2x3'],
	  [2, 3, 3, 1, format(abs(scaled_wc('ledq_2331'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x3x3x1'],
	  [2, 3, 3, 2, format(abs(scaled_wc('ledq_2332'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x3x3x2'],
	  [2, 3, 3, 3, format(abs(scaled_wc('ledq_2333'))* lambda_smeft_value**2, '.6e'), '# cledqAbs2x3x3x3'],
	  [3, 1, 1, 1, format(abs(scaled_wc('ledq_3111'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x1x1x1'],
	  [3, 1, 1, 2, format(abs(scaled_wc('ledq_3112'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x1x1x2'],
	  [3, 1, 1, 3, format(abs(scaled_wc('ledq_3113'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x1x1x3'],
	  [3, 1, 2, 1, format(abs(scaled_wc('ledq_3121'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x1x2x1'],
	  [3, 1, 2, 2, format(abs(scaled_wc('ledq_3122'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x1x2x2'],
	  [3, 1, 2, 3, format(abs(scaled_wc('ledq_3123'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x1x2x3'],
	  [3, 1, 3, 1, format(abs(scaled_wc('ledq_3131'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x1x3x1'],
	  [3, 1, 3, 2, format(abs(scaled_wc('ledq_3132'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x1x3x2'],
	  [3, 1, 3, 3, format(abs(scaled_wc('ledq_3133'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x1x3x3'],
	  [3, 2, 1, 1, format(abs(scaled_wc('ledq_3211'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x2x1x1'],
	  [3, 2, 1, 2, format(abs(scaled_wc('ledq_3212'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x2x1x2'],
	  [3, 2, 1, 3, format(abs(scaled_wc('ledq_3213'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x2x1x3'],
	  [3, 2, 2, 1, format(abs(scaled_wc('ledq_3221'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x2x2x1'],
	  [3, 2, 2, 2, format(abs(scaled_wc('ledq_3222'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x2x2x2'],
	  [3, 2, 2, 3, format(abs(scaled_wc('ledq_3223'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x2x2x3'],
	  [3, 2, 3, 1, format(abs(scaled_wc('ledq_3231'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x2x3x1'],
	  [3, 2, 3, 2, format(abs(scaled_wc('ledq_3232'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x2x3x2'],
	  [3, 2, 3, 3, format(abs(scaled_wc('ledq_3233'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x2x3x3'],
	  [3, 3, 1, 1, format(abs(scaled_wc('ledq_3311'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x3x1x1'],
	  [3, 3, 1, 2, format(abs(scaled_wc('ledq_3312'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x3x1x2'],
	  [3, 3, 1, 3, format(abs(scaled_wc('ledq_3313'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x3x1x3'],
	  [3, 3, 2, 1, format(abs(scaled_wc('ledq_3321'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x3x2x1'],
	  [3, 3, 2, 2, format(abs(scaled_wc('ledq_3322'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x3x2x2'],
	  [3, 3, 2, 3, format(abs(scaled_wc('ledq_3323'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x3x2x3'],
	  [3, 3, 3, 1, format(abs(scaled_wc('ledq_3331'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x3x3x1'],
	  [3, 3, 3, 2, format(abs(scaled_wc('ledq_3332'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x3x3x2'],
	  [3, 3, 3, 3, format(abs(scaled_wc('ledq_3333'))* lambda_smeft_value**2, '.6e'), '# cledqAbs3x3x3x3'],
      ]}

      card['Block']['FRBlock7'] = {'values': [
	  [1, 1, format(abs(scaled_wc('uphi_11'))* lambda_smeft_value**2, '.6e'), '# cuHAbs1x1'],
	  [1, 2, format(abs(scaled_wc('uphi_12'))* lambda_smeft_value**2, '.6e'), '# cuHAbs1x2'],
	  [1, 3, format(abs(scaled_wc('uphi_13'))* lambda_smeft_value**2, '.6e'), '# cuHAbs1x3'],
	  [2, 1, format(abs(scaled_wc('uphi_21'))* lambda_smeft_value**2, '.6e'), '# cuHAbs2x1'],
	  [2, 2, format(abs(scaled_wc('uphi_22'))* lambda_smeft_value**2, '.6e'), '# cuHAbs2x2'],
	  [2, 3, format(abs(scaled_wc('uphi_23'))* lambda_smeft_value**2, '.6e'), '# cuHAbs2x3'],
	  [3, 1, format(abs(scaled_wc('uphi_31'))* lambda_smeft_value**2, '.6e'), '# cuHAbs3x1'],
	  [3, 2, format(abs(scaled_wc('uphi_32'))* lambda_smeft_value**2, '.6e'), '# cuHAbs3x2'],
	  [3, 3, format(abs(scaled_wc('uphi_33'))* lambda_smeft_value**2, '.6e'), '# cuHAbs3x3'],
      ]}

      card['Block']['FRBlock70'] = {'values': [
	  [1, 1, 1, 1, format(angle(scaled_wc('ledq_1111')), '.6e'), '# cledqPh1x1x1x1'],
	  [1, 1, 1, 2, format(angle(scaled_wc('ledq_1112')), '.6e'), '# cledqPh1x1x1x2'],
	  [1, 1, 1, 3, format(angle(scaled_wc('ledq_1113')), '.6e'), '# cledqPh1x1x1x3'],
	  [1, 1, 2, 1, format(angle(scaled_wc('ledq_1121')), '.6e'), '# cledqPh1x1x2x1'],
	  [1, 1, 2, 2, format(angle(scaled_wc('ledq_1122')), '.6e'), '# cledqPh1x1x2x2'],
	  [1, 1, 2, 3, format(angle(scaled_wc('ledq_1123')), '.6e'), '# cledqPh1x1x2x3'],
	  [1, 1, 3, 1, format(angle(scaled_wc('ledq_1131')), '.6e'), '# cledqPh1x1x3x1'],
	  [1, 1, 3, 2, format(angle(scaled_wc('ledq_1132')), '.6e'), '# cledqPh1x1x3x2'],
	  [1, 1, 3, 3, format(angle(scaled_wc('ledq_1133')), '.6e'), '# cledqPh1x1x3x3'],
	  [1, 2, 1, 1, format(angle(scaled_wc('ledq_1211')), '.6e'), '# cledqPh1x2x1x1'],
	  [1, 2, 1, 2, format(angle(scaled_wc('ledq_1212')), '.6e'), '# cledqPh1x2x1x2'],
	  [1, 2, 1, 3, format(angle(scaled_wc('ledq_1213')), '.6e'), '# cledqPh1x2x1x3'],
	  [1, 2, 2, 1, format(angle(scaled_wc('ledq_1221')), '.6e'), '# cledqPh1x2x2x1'],
	  [1, 2, 2, 2, format(angle(scaled_wc('ledq_1222')), '.6e'), '# cledqPh1x2x2x2'],
	  [1, 2, 2, 3, format(angle(scaled_wc('ledq_1223')), '.6e'), '# cledqPh1x2x2x3'],
	  [1, 2, 3, 1, format(angle(scaled_wc('ledq_1231')), '.6e'), '# cledqPh1x2x3x1'],
	  [1, 2, 3, 2, format(angle(scaled_wc('ledq_1232')), '.6e'), '# cledqPh1x2x3x2'],
	  [1, 2, 3, 3, format(angle(scaled_wc('ledq_1233')), '.6e'), '# cledqPh1x2x3x3'],
	  [1, 3, 1, 1, format(angle(scaled_wc('ledq_1311')), '.6e'), '# cledqPh1x3x1x1'],
	  [1, 3, 1, 2, format(angle(scaled_wc('ledq_1312')), '.6e'), '# cledqPh1x3x1x2'],
	  [1, 3, 1, 3, format(angle(scaled_wc('ledq_1313')), '.6e'), '# cledqPh1x3x1x3'],
	  [1, 3, 2, 1, format(angle(scaled_wc('ledq_1321')), '.6e'), '# cledqPh1x3x2x1'],
	  [1, 3, 2, 2, format(angle(scaled_wc('ledq_1322')), '.6e'), '# cledqPh1x3x2x2'],
	  [1, 3, 2, 3, format(angle(scaled_wc('ledq_1323')), '.6e'), '# cledqPh1x3x2x3'],
	  [1, 3, 3, 1, format(angle(scaled_wc('ledq_1331')), '.6e'), '# cledqPh1x3x3x1'],
	  [1, 3, 3, 2, format(angle(scaled_wc('ledq_1332')), '.6e'), '# cledqPh1x3x3x2'],
	  [1, 3, 3, 3, format(angle(scaled_wc('ledq_1333')), '.6e'), '# cledqPh1x3x3x3'],
	  [2, 1, 1, 1, format(angle(scaled_wc('ledq_2111')), '.6e'), '# cledqPh2x1x1x1'],
	  [2, 1, 1, 2, format(angle(scaled_wc('ledq_2112')), '.6e'), '# cledqPh2x1x1x2'],
	  [2, 1, 1, 3, format(angle(scaled_wc('ledq_2113')), '.6e'), '# cledqPh2x1x1x3'],
	  [2, 1, 2, 1, format(angle(scaled_wc('ledq_2121')), '.6e'), '# cledqPh2x1x2x1'],
	  [2, 1, 2, 2, format(angle(scaled_wc('ledq_2122')), '.6e'), '# cledqPh2x1x2x2'],
	  [2, 1, 2, 3, format(angle(scaled_wc('ledq_2123')), '.6e'), '# cledqPh2x1x2x3'],
	  [2, 1, 3, 1, format(angle(scaled_wc('ledq_2131')), '.6e'), '# cledqPh2x1x3x1'],
	  [2, 1, 3, 2, format(angle(scaled_wc('ledq_2132')), '.6e'), '# cledqPh2x1x3x2'],
	  [2, 1, 3, 3, format(angle(scaled_wc('ledq_2133')), '.6e'), '# cledqPh2x1x3x3'],
	  [2, 2, 1, 1, format(angle(scaled_wc('ledq_2211')), '.6e'), '# cledqPh2x2x1x1'],
	  [2, 2, 1, 2, format(angle(scaled_wc('ledq_2212')), '.6e'), '# cledqPh2x2x1x2'],
	  [2, 2, 1, 3, format(angle(scaled_wc('ledq_2213')), '.6e'), '# cledqPh2x2x1x3'],
	  [2, 2, 2, 1, format(angle(scaled_wc('ledq_2221')), '.6e'), '# cledqPh2x2x2x1'],
	  [2, 2, 2, 2, format(angle(scaled_wc('ledq_2222')), '.6e'), '# cledqPh2x2x2x2'],
	  [2, 2, 2, 3, format(angle(scaled_wc('ledq_2223')), '.6e'), '# cledqPh2x2x2x3'],
	  [2, 2, 3, 1, format(angle(scaled_wc('ledq_2231')), '.6e'), '# cledqPh2x2x3x1'],
	  [2, 2, 3, 2, format(angle(scaled_wc('ledq_2232')), '.6e'), '# cledqPh2x2x3x2'],
	  [2, 2, 3, 3, format(angle(scaled_wc('ledq_2233')), '.6e'), '# cledqPh2x2x3x3'],
	  [2, 3, 1, 1, format(angle(scaled_wc('ledq_2311')), '.6e'), '# cledqPh2x3x1x1'],
	  [2, 3, 1, 2, format(angle(scaled_wc('ledq_2312')), '.6e'), '# cledqPh2x3x1x2'],
	  [2, 3, 1, 3, format(angle(scaled_wc('ledq_2313')), '.6e'), '# cledqPh2x3x1x3'],
	  [2, 3, 2, 1, format(angle(scaled_wc('ledq_2321')), '.6e'), '# cledqPh2x3x2x1'],
	  [2, 3, 2, 2, format(angle(scaled_wc('ledq_2322')), '.6e'), '# cledqPh2x3x2x2'],
	  [2, 3, 2, 3, format(angle(scaled_wc('ledq_2323')), '.6e'), '# cledqPh2x3x2x3'],
	  [2, 3, 3, 1, format(angle(scaled_wc('ledq_2331')), '.6e'), '# cledqPh2x3x3x1'],
	  [2, 3, 3, 2, format(angle(scaled_wc('ledq_2332')), '.6e'), '# cledqPh2x3x3x2'],
	  [2, 3, 3, 3, format(angle(scaled_wc('ledq_2333')), '.6e'), '# cledqPh2x3x3x3'],
	  [3, 1, 1, 1, format(angle(scaled_wc('ledq_3111')), '.6e'), '# cledqPh3x1x1x1'],
	  [3, 1, 1, 2, format(angle(scaled_wc('ledq_3112')), '.6e'), '# cledqPh3x1x1x2'],
	  [3, 1, 1, 3, format(angle(scaled_wc('ledq_3113')), '.6e'), '# cledqPh3x1x1x3'],
	  [3, 1, 2, 1, format(angle(scaled_wc('ledq_3121')), '.6e'), '# cledqPh3x1x2x1'],
	  [3, 1, 2, 2, format(angle(scaled_wc('ledq_3122')), '.6e'), '# cledqPh3x1x2x2'],
	  [3, 1, 2, 3, format(angle(scaled_wc('ledq_3123')), '.6e'), '# cledqPh3x1x2x3'],
	  [3, 1, 3, 1, format(angle(scaled_wc('ledq_3131')), '.6e'), '# cledqPh3x1x3x1'],
	  [3, 1, 3, 2, format(angle(scaled_wc('ledq_3132')), '.6e'), '# cledqPh3x1x3x2'],
	  [3, 1, 3, 3, format(angle(scaled_wc('ledq_3133')), '.6e'), '# cledqPh3x1x3x3'],
	  [3, 2, 1, 1, format(angle(scaled_wc('ledq_3211')), '.6e'), '# cledqPh3x2x1x1'],
	  [3, 2, 1, 2, format(angle(scaled_wc('ledq_3212')), '.6e'), '# cledqPh3x2x1x2'],
	  [3, 2, 1, 3, format(angle(scaled_wc('ledq_3213')), '.6e'), '# cledqPh3x2x1x3'],
	  [3, 2, 2, 1, format(angle(scaled_wc('ledq_3221')), '.6e'), '# cledqPh3x2x2x1'],
	  [3, 2, 2, 2, format(angle(scaled_wc('ledq_3222')), '.6e'), '# cledqPh3x2x2x2'],
	  [3, 2, 2, 3, format(angle(scaled_wc('ledq_3223')), '.6e'), '# cledqPh3x2x2x3'],
	  [3, 2, 3, 1, format(angle(scaled_wc('ledq_3231')), '.6e'), '# cledqPh3x2x3x1'],
	  [3, 2, 3, 2, format(angle(scaled_wc('ledq_3232')), '.6e'), '# cledqPh3x2x3x2'],
	  [3, 2, 3, 3, format(angle(scaled_wc('ledq_3233')), '.6e'), '# cledqPh3x2x3x3'],
	  [3, 3, 1, 1, format(angle(scaled_wc('ledq_3311')), '.6e'), '# cledqPh3x3x1x1'],
	  [3, 3, 1, 2, format(angle(scaled_wc('ledq_3312')), '.6e'), '# cledqPh3x3x1x2'],
	  [3, 3, 1, 3, format(angle(scaled_wc('ledq_3313')), '.6e'), '# cledqPh3x3x1x3'],
	  [3, 3, 2, 1, format(angle(scaled_wc('ledq_3321')), '.6e'), '# cledqPh3x3x2x1'],
	  [3, 3, 2, 2, format(angle(scaled_wc('ledq_3322')), '.6e'), '# cledqPh3x3x2x2'],
	  [3, 3, 2, 3, format(angle(scaled_wc('ledq_3323')), '.6e'), '# cledqPh3x3x2x3'],
	  [3, 3, 3, 1, format(angle(scaled_wc('ledq_3331')), '.6e'), '# cledqPh3x3x3x1'],
	  [3, 3, 3, 2, format(angle(scaled_wc('ledq_3332')), '.6e'), '# cledqPh3x3x3x2'],
	  [3, 3, 3, 3, format(angle(scaled_wc('ledq_3333')), '.6e'), '# cledqPh3x3x3x3'],
      ]}

      card['Block']['FRBlock72'] = {'values': [
	  [1, 1, 1, 1, format(abs(scaled_wc('quqd1_1111'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x1x1x1'],
	  [1, 1, 1, 2, format(abs(scaled_wc('quqd1_1112'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x1x1x2'],
	  [1, 1, 1, 3, format(abs(scaled_wc('quqd1_1113'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x1x1x3'],
	  [1, 1, 2, 1, format(abs(scaled_wc('quqd1_1121'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x1x2x1'],
	  [1, 1, 2, 2, format(abs(scaled_wc('quqd1_1122'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x1x2x2'],
	  [1, 1, 2, 3, format(abs(scaled_wc('quqd1_1123'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x1x2x3'],
	  [1, 1, 3, 1, format(abs(scaled_wc('quqd1_1131'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x1x3x1'],
	  [1, 1, 3, 2, format(abs(scaled_wc('quqd1_1132'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x1x3x2'],
	  [1, 1, 3, 3, format(abs(scaled_wc('quqd1_1133'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x1x3x3'],
	  [1, 2, 1, 1, format(abs(scaled_wc('quqd1_1211'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x2x1x1'],
	  [1, 2, 1, 2, format(abs(scaled_wc('quqd1_1212'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x2x1x2'],
	  [1, 2, 1, 3, format(abs(scaled_wc('quqd1_1213'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x2x1x3'],
	  [1, 2, 2, 1, format(abs(scaled_wc('quqd1_1221'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x2x2x1'],
	  [1, 2, 2, 2, format(abs(scaled_wc('quqd1_1222'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x2x2x2'],
	  [1, 2, 2, 3, format(abs(scaled_wc('quqd1_1223'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x2x2x3'],
	  [1, 2, 3, 1, format(abs(scaled_wc('quqd1_1231'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x2x3x1'],
	  [1, 2, 3, 2, format(abs(scaled_wc('quqd1_1232'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x2x3x2'],
	  [1, 2, 3, 3, format(abs(scaled_wc('quqd1_1233'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x2x3x3'],
	  [1, 3, 1, 1, format(abs(scaled_wc('quqd1_1311'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x3x1x1'],
	  [1, 3, 1, 2, format(abs(scaled_wc('quqd1_1312'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x3x1x2'],
	  [1, 3, 1, 3, format(abs(scaled_wc('quqd1_1313'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x3x1x3'],
	  [1, 3, 2, 1, format(abs(scaled_wc('quqd1_1321'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x3x2x1'],
	  [1, 3, 2, 2, format(abs(scaled_wc('quqd1_1322'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x3x2x2'],
	  [1, 3, 2, 3, format(abs(scaled_wc('quqd1_1323'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x3x2x3'],
	  [1, 3, 3, 1, format(abs(scaled_wc('quqd1_1331'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x3x3x1'],
	  [1, 3, 3, 2, format(abs(scaled_wc('quqd1_1332'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x3x3x2'],
	  [1, 3, 3, 3, format(abs(scaled_wc('quqd1_1333'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs1x3x3x3'],
	  [2, 1, 1, 1, format(abs(scaled_wc('quqd1_2111'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x1x1x1'],
	  [2, 1, 1, 2, format(abs(scaled_wc('quqd1_2112'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x1x1x2'],
	  [2, 1, 1, 3, format(abs(scaled_wc('quqd1_2113'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x1x1x3'],
	  [2, 1, 2, 1, format(abs(scaled_wc('quqd1_2121'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x1x2x1'],
	  [2, 1, 2, 2, format(abs(scaled_wc('quqd1_2122'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x1x2x2'],
	  [2, 1, 2, 3, format(abs(scaled_wc('quqd1_2123'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x1x2x3'],
	  [2, 1, 3, 1, format(abs(scaled_wc('quqd1_2131'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x1x3x1'],
	  [2, 1, 3, 2, format(abs(scaled_wc('quqd1_2132'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x1x3x2'],
	  [2, 1, 3, 3, format(abs(scaled_wc('quqd1_2133'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x1x3x3'],
	  [2, 2, 1, 1, format(abs(scaled_wc('quqd1_2211'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x2x1x1'],
	  [2, 2, 1, 2, format(abs(scaled_wc('quqd1_2212'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x2x1x2'],
	  [2, 2, 1, 3, format(abs(scaled_wc('quqd1_2213'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x2x1x3'],
	  [2, 2, 2, 1, format(abs(scaled_wc('quqd1_2221'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x2x2x1'],
	  [2, 2, 2, 2, format(abs(scaled_wc('quqd1_2222'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x2x2x2'],
	  [2, 2, 2, 3, format(abs(scaled_wc('quqd1_2223'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x2x2x3'],
	  [2, 2, 3, 1, format(abs(scaled_wc('quqd1_2231'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x2x3x1'],
	  [2, 2, 3, 2, format(abs(scaled_wc('quqd1_2232'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x2x3x2'],
	  [2, 2, 3, 3, format(abs(scaled_wc('quqd1_2233'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x2x3x3'],
	  [2, 3, 1, 1, format(abs(scaled_wc('quqd1_2311'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x3x1x1'],
	  [2, 3, 1, 2, format(abs(scaled_wc('quqd1_2312'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x3x1x2'],
	  [2, 3, 1, 3, format(abs(scaled_wc('quqd1_2313'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x3x1x3'],
	  [2, 3, 2, 1, format(abs(scaled_wc('quqd1_2321'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x3x2x1'],
	  [2, 3, 2, 2, format(abs(scaled_wc('quqd1_2322'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x3x2x2'],
	  [2, 3, 2, 3, format(abs(scaled_wc('quqd1_2323'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x3x2x3'],
	  [2, 3, 3, 1, format(abs(scaled_wc('quqd1_2331'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x3x3x1'],
	  [2, 3, 3, 2, format(abs(scaled_wc('quqd1_2332'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x3x3x2'],
	  [2, 3, 3, 3, format(abs(scaled_wc('quqd1_2333'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs2x3x3x3'],
	  [3, 1, 1, 1, format(abs(scaled_wc('quqd1_3111'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x1x1x1'],
	  [3, 1, 1, 2, format(abs(scaled_wc('quqd1_3112'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x1x1x2'],
	  [3, 1, 1, 3, format(abs(scaled_wc('quqd1_3113'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x1x1x3'],
	  [3, 1, 2, 1, format(abs(scaled_wc('quqd1_3121'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x1x2x1'],
	  [3, 1, 2, 2, format(abs(scaled_wc('quqd1_3122'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x1x2x2'],
	  [3, 1, 2, 3, format(abs(scaled_wc('quqd1_3123'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x1x2x3'],
	  [3, 1, 3, 1, format(abs(scaled_wc('quqd1_3131'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x1x3x1'],
	  [3, 1, 3, 2, format(abs(scaled_wc('quqd1_3132'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x1x3x2'],
	  [3, 1, 3, 3, format(abs(scaled_wc('quqd1_3133'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x1x3x3'],
	  [3, 2, 1, 1, format(abs(scaled_wc('quqd1_3211'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x2x1x1'],
	  [3, 2, 1, 2, format(abs(scaled_wc('quqd1_3212'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x2x1x2'],
	  [3, 2, 1, 3, format(abs(scaled_wc('quqd1_3213'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x2x1x3'],
	  [3, 2, 2, 1, format(abs(scaled_wc('quqd1_3221'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x2x2x1'],
	  [3, 2, 2, 2, format(abs(scaled_wc('quqd1_3222'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x2x2x2'],
	  [3, 2, 2, 3, format(abs(scaled_wc('quqd1_3223'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x2x2x3'],
	  [3, 2, 3, 1, format(abs(scaled_wc('quqd1_3231'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x2x3x1'],
	  [3, 2, 3, 2, format(abs(scaled_wc('quqd1_3232'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x2x3x2'],
	  [3, 2, 3, 3, format(abs(scaled_wc('quqd1_3233'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x2x3x3'],
	  [3, 3, 1, 1, format(abs(scaled_wc('quqd1_3311'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x3x1x1'],
	  [3, 3, 1, 2, format(abs(scaled_wc('quqd1_3312'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x3x1x2'],
	  [3, 3, 1, 3, format(abs(scaled_wc('quqd1_3313'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x3x1x3'],
	  [3, 3, 2, 1, format(abs(scaled_wc('quqd1_3321'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x3x2x1'],
	  [3, 3, 2, 2, format(abs(scaled_wc('quqd1_3322'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x3x2x2'],
	  [3, 3, 2, 3, format(abs(scaled_wc('quqd1_3323'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x3x2x3'],
	  [3, 3, 3, 1, format(abs(scaled_wc('quqd1_3331'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x3x3x1'],
	  [3, 3, 3, 2, format(abs(scaled_wc('quqd1_3332'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x3x3x2'],
	  [3, 3, 3, 3, format(abs(scaled_wc('quqd1_3333'))* lambda_smeft_value**2, '.6e'), '# cquqd1Abs3x3x3x3'],
      ]}

      card['Block']['FRBlock73'] = {'values': [
	  [1, 1, 1, 1, format(angle(scaled_wc('quqd1_1111')), '.6e'), '# cquqd1Ph1x1x1x1'],
	  [1, 1, 1, 2, format(angle(scaled_wc('quqd1_1112')), '.6e'), '# cquqd1Ph1x1x1x2'],
	  [1, 1, 1, 3, format(angle(scaled_wc('quqd1_1113')), '.6e'), '# cquqd1Ph1x1x1x3'],
	  [1, 1, 2, 1, format(angle(scaled_wc('quqd1_1121')), '.6e'), '# cquqd1Ph1x1x2x1'],
	  [1, 1, 2, 2, format(angle(scaled_wc('quqd1_1122')), '.6e'), '# cquqd1Ph1x1x2x2'],
	  [1, 1, 2, 3, format(angle(scaled_wc('quqd1_1123')), '.6e'), '# cquqd1Ph1x1x2x3'],
	  [1, 1, 3, 1, format(angle(scaled_wc('quqd1_1131')), '.6e'), '# cquqd1Ph1x1x3x1'],
	  [1, 1, 3, 2, format(angle(scaled_wc('quqd1_1132')), '.6e'), '# cquqd1Ph1x1x3x2'],
	  [1, 1, 3, 3, format(angle(scaled_wc('quqd1_1133')), '.6e'), '# cquqd1Ph1x1x3x3'],
	  [1, 2, 1, 1, format(angle(scaled_wc('quqd1_1211')), '.6e'), '# cquqd1Ph1x2x1x1'],
	  [1, 2, 1, 2, format(angle(scaled_wc('quqd1_1212')), '.6e'), '# cquqd1Ph1x2x1x2'],
	  [1, 2, 1, 3, format(angle(scaled_wc('quqd1_1213')), '.6e'), '# cquqd1Ph1x2x1x3'],
	  [1, 2, 2, 1, format(angle(scaled_wc('quqd1_1221')), '.6e'), '# cquqd1Ph1x2x2x1'],
	  [1, 2, 2, 2, format(angle(scaled_wc('quqd1_1222')), '.6e'), '# cquqd1Ph1x2x2x2'],
	  [1, 2, 2, 3, format(angle(scaled_wc('quqd1_1223')), '.6e'), '# cquqd1Ph1x2x2x3'],
	  [1, 2, 3, 1, format(angle(scaled_wc('quqd1_1231')), '.6e'), '# cquqd1Ph1x2x3x1'],
	  [1, 2, 3, 2, format(angle(scaled_wc('quqd1_1232')), '.6e'), '# cquqd1Ph1x2x3x2'],
	  [1, 2, 3, 3, format(angle(scaled_wc('quqd1_1233')), '.6e'), '# cquqd1Ph1x2x3x3'],
	  [1, 3, 1, 1, format(angle(scaled_wc('quqd1_1311')), '.6e'), '# cquqd1Ph1x3x1x1'],
	  [1, 3, 1, 2, format(angle(scaled_wc('quqd1_1312')), '.6e'), '# cquqd1Ph1x3x1x2'],
	  [1, 3, 1, 3, format(angle(scaled_wc('quqd1_1313')), '.6e'), '# cquqd1Ph1x3x1x3'],
	  [1, 3, 2, 1, format(angle(scaled_wc('quqd1_1321')), '.6e'), '# cquqd1Ph1x3x2x1'],
	  [1, 3, 2, 2, format(angle(scaled_wc('quqd1_1322')), '.6e'), '# cquqd1Ph1x3x2x2'],
	  [1, 3, 2, 3, format(angle(scaled_wc('quqd1_1323')), '.6e'), '# cquqd1Ph1x3x2x3'],
	  [1, 3, 3, 1, format(angle(scaled_wc('quqd1_1331')), '.6e'), '# cquqd1Ph1x3x3x1'],
	  [1, 3, 3, 2, format(angle(scaled_wc('quqd1_1332')), '.6e'), '# cquqd1Ph1x3x3x2'],
	  [1, 3, 3, 3, format(angle(scaled_wc('quqd1_1333')), '.6e'), '# cquqd1Ph1x3x3x3'],
	  [2, 1, 1, 1, format(angle(scaled_wc('quqd1_2111')), '.6e'), '# cquqd1Ph2x1x1x1'],
	  [2, 1, 1, 2, format(angle(scaled_wc('quqd1_2112')), '.6e'), '# cquqd1Ph2x1x1x2'],
	  [2, 1, 1, 3, format(angle(scaled_wc('quqd1_2113')), '.6e'), '# cquqd1Ph2x1x1x3'],
	  [2, 1, 2, 1, format(angle(scaled_wc('quqd1_2121')), '.6e'), '# cquqd1Ph2x1x2x1'],
	  [2, 1, 2, 2, format(angle(scaled_wc('quqd1_2122')), '.6e'), '# cquqd1Ph2x1x2x2'],
	  [2, 1, 2, 3, format(angle(scaled_wc('quqd1_2123')), '.6e'), '# cquqd1Ph2x1x2x3'],
	  [2, 1, 3, 1, format(angle(scaled_wc('quqd1_2131')), '.6e'), '# cquqd1Ph2x1x3x1'],
	  [2, 1, 3, 2, format(angle(scaled_wc('quqd1_2132')), '.6e'), '# cquqd1Ph2x1x3x2'],
	  [2, 1, 3, 3, format(angle(scaled_wc('quqd1_2133')), '.6e'), '# cquqd1Ph2x1x3x3'],
	  [2, 2, 1, 1, format(angle(scaled_wc('quqd1_2211')), '.6e'), '# cquqd1Ph2x2x1x1'],
	  [2, 2, 1, 2, format(angle(scaled_wc('quqd1_2212')), '.6e'), '# cquqd1Ph2x2x1x2'],
	  [2, 2, 1, 3, format(angle(scaled_wc('quqd1_2213')), '.6e'), '# cquqd1Ph2x2x1x3'],
	  [2, 2, 2, 1, format(angle(scaled_wc('quqd1_2221')), '.6e'), '# cquqd1Ph2x2x2x1'],
	  [2, 2, 2, 2, format(angle(scaled_wc('quqd1_2222')), '.6e'), '# cquqd1Ph2x2x2x2'],
	  [2, 2, 2, 3, format(angle(scaled_wc('quqd1_2223')), '.6e'), '# cquqd1Ph2x2x2x3'],
	  [2, 2, 3, 1, format(angle(scaled_wc('quqd1_2231')), '.6e'), '# cquqd1Ph2x2x3x1'],
	  [2, 2, 3, 2, format(angle(scaled_wc('quqd1_2232')), '.6e'), '# cquqd1Ph2x2x3x2'],
	  [2, 2, 3, 3, format(angle(scaled_wc('quqd1_2233')), '.6e'), '# cquqd1Ph2x2x3x3'],
	  [2, 3, 1, 1, format(angle(scaled_wc('quqd1_2311')), '.6e'), '# cquqd1Ph2x3x1x1'],
	  [2, 3, 1, 2, format(angle(scaled_wc('quqd1_2312')), '.6e'), '# cquqd1Ph2x3x1x2'],
	  [2, 3, 1, 3, format(angle(scaled_wc('quqd1_2313')), '.6e'), '# cquqd1Ph2x3x1x3'],
	  [2, 3, 2, 1, format(angle(scaled_wc('quqd1_2321')), '.6e'), '# cquqd1Ph2x3x2x1'],
	  [2, 3, 2, 2, format(angle(scaled_wc('quqd1_2322')), '.6e'), '# cquqd1Ph2x3x2x2'],
	  [2, 3, 2, 3, format(angle(scaled_wc('quqd1_2323')), '.6e'), '# cquqd1Ph2x3x2x3'],
	  [2, 3, 3, 1, format(angle(scaled_wc('quqd1_2331')), '.6e'), '# cquqd1Ph2x3x3x1'],
	  [2, 3, 3, 2, format(angle(scaled_wc('quqd1_2332')), '.6e'), '# cquqd1Ph2x3x3x2'],
	  [2, 3, 3, 3, format(angle(scaled_wc('quqd1_2333')), '.6e'), '# cquqd1Ph2x3x3x3'],
	  [3, 1, 1, 1, format(angle(scaled_wc('quqd1_3111')), '.6e'), '# cquqd1Ph3x1x1x1'],
	  [3, 1, 1, 2, format(angle(scaled_wc('quqd1_3112')), '.6e'), '# cquqd1Ph3x1x1x2'],
	  [3, 1, 1, 3, format(angle(scaled_wc('quqd1_3113')), '.6e'), '# cquqd1Ph3x1x1x3'],
	  [3, 1, 2, 1, format(angle(scaled_wc('quqd1_3121')), '.6e'), '# cquqd1Ph3x1x2x1'],
	  [3, 1, 2, 2, format(angle(scaled_wc('quqd1_3122')), '.6e'), '# cquqd1Ph3x1x2x2'],
	  [3, 1, 2, 3, format(angle(scaled_wc('quqd1_3123')), '.6e'), '# cquqd1Ph3x1x2x3'],
	  [3, 1, 3, 1, format(angle(scaled_wc('quqd1_3131')), '.6e'), '# cquqd1Ph3x1x3x1'],
	  [3, 1, 3, 2, format(angle(scaled_wc('quqd1_3132')), '.6e'), '# cquqd1Ph3x1x3x2'],
	  [3, 1, 3, 3, format(angle(scaled_wc('quqd1_3133')), '.6e'), '# cquqd1Ph3x1x3x3'],
	  [3, 2, 1, 1, format(angle(scaled_wc('quqd1_3211')), '.6e'), '# cquqd1Ph3x2x1x1'],
	  [3, 2, 1, 2, format(angle(scaled_wc('quqd1_3212')), '.6e'), '# cquqd1Ph3x2x1x2'],
	  [3, 2, 1, 3, format(angle(scaled_wc('quqd1_3213')), '.6e'), '# cquqd1Ph3x2x1x3'],
	  [3, 2, 2, 1, format(angle(scaled_wc('quqd1_3221')), '.6e'), '# cquqd1Ph3x2x2x1'],
	  [3, 2, 2, 2, format(angle(scaled_wc('quqd1_3222')), '.6e'), '# cquqd1Ph3x2x2x2'],
	  [3, 2, 2, 3, format(angle(scaled_wc('quqd1_3223')), '.6e'), '# cquqd1Ph3x2x2x3'],
	  [3, 2, 3, 1, format(angle(scaled_wc('quqd1_3231')), '.6e'), '# cquqd1Ph3x2x3x1'],
	  [3, 2, 3, 2, format(angle(scaled_wc('quqd1_3232')), '.6e'), '# cquqd1Ph3x2x3x2'],
	  [3, 2, 3, 3, format(angle(scaled_wc('quqd1_3233')), '.6e'), '# cquqd1Ph3x2x3x3'],
	  [3, 3, 1, 1, format(angle(scaled_wc('quqd1_3311')), '.6e'), '# cquqd1Ph3x3x1x1'],
	  [3, 3, 1, 2, format(angle(scaled_wc('quqd1_3312')), '.6e'), '# cquqd1Ph3x3x1x2'],
	  [3, 3, 1, 3, format(angle(scaled_wc('quqd1_3313')), '.6e'), '# cquqd1Ph3x3x1x3'],
	  [3, 3, 2, 1, format(angle(scaled_wc('quqd1_3321')), '.6e'), '# cquqd1Ph3x3x2x1'],
	  [3, 3, 2, 2, format(angle(scaled_wc('quqd1_3322')), '.6e'), '# cquqd1Ph3x3x2x2'],
	  [3, 3, 2, 3, format(angle(scaled_wc('quqd1_3323')), '.6e'), '# cquqd1Ph3x3x2x3'],
	  [3, 3, 3, 1, format(angle(scaled_wc('quqd1_3331')), '.6e'), '# cquqd1Ph3x3x3x1'],
	  [3, 3, 3, 2, format(angle(scaled_wc('quqd1_3332')), '.6e'), '# cquqd1Ph3x3x3x2'],
	  [3, 3, 3, 3, format(angle(scaled_wc('quqd1_3333')), '.6e'), '# cquqd1Ph3x3x3x3'],
      ]}

      card['Block']['FRBlock75'] = {'values': [
	  [1, 1, 1, 1, format(abs(scaled_wc('quqd8_1111'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x1x1x1'],
	  [1, 1, 1, 2, format(abs(scaled_wc('quqd8_1112'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x1x1x2'],
	  [1, 1, 1, 3, format(abs(scaled_wc('quqd8_1113'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x1x1x3'],
	  [1, 1, 2, 1, format(abs(scaled_wc('quqd8_1121'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x1x2x1'],
	  [1, 1, 2, 2, format(abs(scaled_wc('quqd8_1122'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x1x2x2'],
	  [1, 1, 2, 3, format(abs(scaled_wc('quqd8_1123'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x1x2x3'],
	  [1, 1, 3, 1, format(abs(scaled_wc('quqd8_1131'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x1x3x1'],
	  [1, 1, 3, 2, format(abs(scaled_wc('quqd8_1132'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x1x3x2'],
	  [1, 1, 3, 3, format(abs(scaled_wc('quqd8_1133'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x1x3x3'],
	  [1, 2, 1, 1, format(abs(scaled_wc('quqd8_1211'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x2x1x1'],
	  [1, 2, 1, 2, format(abs(scaled_wc('quqd8_1212'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x2x1x2'],
	  [1, 2, 1, 3, format(abs(scaled_wc('quqd8_1213'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x2x1x3'],
	  [1, 2, 2, 1, format(abs(scaled_wc('quqd8_1221'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x2x2x1'],
	  [1, 2, 2, 2, format(abs(scaled_wc('quqd8_1222'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x2x2x2'],
	  [1, 2, 2, 3, format(abs(scaled_wc('quqd8_1223'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x2x2x3'],
	  [1, 2, 3, 1, format(abs(scaled_wc('quqd8_1231'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x2x3x1'],
	  [1, 2, 3, 2, format(abs(scaled_wc('quqd8_1232'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x2x3x2'],
	  [1, 2, 3, 3, format(abs(scaled_wc('quqd8_1233'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x2x3x3'],
	  [1, 3, 1, 1, format(abs(scaled_wc('quqd8_1311'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x3x1x1'],
	  [1, 3, 1, 2, format(abs(scaled_wc('quqd8_1312'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x3x1x2'],
	  [1, 3, 1, 3, format(abs(scaled_wc('quqd8_1313'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x3x1x3'],
	  [1, 3, 2, 1, format(abs(scaled_wc('quqd8_1321'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x3x2x1'],
	  [1, 3, 2, 2, format(abs(scaled_wc('quqd8_1322'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x3x2x2'],
	  [1, 3, 2, 3, format(abs(scaled_wc('quqd8_1323'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x3x2x3'],
	  [1, 3, 3, 1, format(abs(scaled_wc('quqd8_1331'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x3x3x1'],
	  [1, 3, 3, 2, format(abs(scaled_wc('quqd8_1332'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x3x3x2'],
	  [1, 3, 3, 3, format(abs(scaled_wc('quqd8_1333'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs1x3x3x3'],
	  [2, 1, 1, 1, format(abs(scaled_wc('quqd8_2111'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x1x1x1'],
	  [2, 1, 1, 2, format(abs(scaled_wc('quqd8_2112'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x1x1x2'],
	  [2, 1, 1, 3, format(abs(scaled_wc('quqd8_2113'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x1x1x3'],
	  [2, 1, 2, 1, format(abs(scaled_wc('quqd8_2121'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x1x2x1'],
	  [2, 1, 2, 2, format(abs(scaled_wc('quqd8_2122'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x1x2x2'],
	  [2, 1, 2, 3, format(abs(scaled_wc('quqd8_2123'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x1x2x3'],
	  [2, 1, 3, 1, format(abs(scaled_wc('quqd8_2131'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x1x3x1'],
	  [2, 1, 3, 2, format(abs(scaled_wc('quqd8_2132'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x1x3x2'],
	  [2, 1, 3, 3, format(abs(scaled_wc('quqd8_2133'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x1x3x3'],
	  [2, 2, 1, 1, format(abs(scaled_wc('quqd8_2211'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x2x1x1'],
	  [2, 2, 1, 2, format(abs(scaled_wc('quqd8_2212'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x2x1x2'],
	  [2, 2, 1, 3, format(abs(scaled_wc('quqd8_2213'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x2x1x3'],
	  [2, 2, 2, 1, format(abs(scaled_wc('quqd8_2221'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x2x2x1'],
	  [2, 2, 2, 2, format(abs(scaled_wc('quqd8_2222'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x2x2x2'],
	  [2, 2, 2, 3, format(abs(scaled_wc('quqd8_2223'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x2x2x3'],
	  [2, 2, 3, 1, format(abs(scaled_wc('quqd8_2231'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x2x3x1'],
	  [2, 2, 3, 2, format(abs(scaled_wc('quqd8_2232'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x2x3x2'],
	  [2, 2, 3, 3, format(abs(scaled_wc('quqd8_2233'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x2x3x3'],
	  [2, 3, 1, 1, format(abs(scaled_wc('quqd8_2311'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x3x1x1'],
	  [2, 3, 1, 2, format(abs(scaled_wc('quqd8_2312'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x3x1x2'],
	  [2, 3, 1, 3, format(abs(scaled_wc('quqd8_2313'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x3x1x3'],
	  [2, 3, 2, 1, format(abs(scaled_wc('quqd8_2321'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x3x2x1'],
	  [2, 3, 2, 2, format(abs(scaled_wc('quqd8_2322'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x3x2x2'],
	  [2, 3, 2, 3, format(abs(scaled_wc('quqd8_2323'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x3x2x3'],
	  [2, 3, 3, 1, format(abs(scaled_wc('quqd8_2331'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x3x3x1'],
	  [2, 3, 3, 2, format(abs(scaled_wc('quqd8_2332'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x3x3x2'],
	  [2, 3, 3, 3, format(abs(scaled_wc('quqd8_2333'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs2x3x3x3'],
	  [3, 1, 1, 1, format(abs(scaled_wc('quqd8_3111'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x1x1x1'],
	  [3, 1, 1, 2, format(abs(scaled_wc('quqd8_3112'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x1x1x2'],
	  [3, 1, 1, 3, format(abs(scaled_wc('quqd8_3113'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x1x1x3'],
	  [3, 1, 2, 1, format(abs(scaled_wc('quqd8_3121'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x1x2x1'],
	  [3, 1, 2, 2, format(abs(scaled_wc('quqd8_3122'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x1x2x2'],
	  [3, 1, 2, 3, format(abs(scaled_wc('quqd8_3123'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x1x2x3'],
	  [3, 1, 3, 1, format(abs(scaled_wc('quqd8_3131'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x1x3x1'],
	  [3, 1, 3, 2, format(abs(scaled_wc('quqd8_3132'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x1x3x2'],
	  [3, 1, 3, 3, format(abs(scaled_wc('quqd8_3133'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x1x3x3'],
	  [3, 2, 1, 1, format(abs(scaled_wc('quqd8_3211'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x2x1x1'],
	  [3, 2, 1, 2, format(abs(scaled_wc('quqd8_3212'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x2x1x2'],
	  [3, 2, 1, 3, format(abs(scaled_wc('quqd8_3213'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x2x1x3'],
	  [3, 2, 2, 1, format(abs(scaled_wc('quqd8_3221'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x2x2x1'],
	  [3, 2, 2, 2, format(abs(scaled_wc('quqd8_3222'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x2x2x2'],
	  [3, 2, 2, 3, format(abs(scaled_wc('quqd8_3223'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x2x2x3'],
	  [3, 2, 3, 1, format(abs(scaled_wc('quqd8_3231'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x2x3x1'],
	  [3, 2, 3, 2, format(abs(scaled_wc('quqd8_3232'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x2x3x2'],
	  [3, 2, 3, 3, format(abs(scaled_wc('quqd8_3233'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x2x3x3'],
	  [3, 3, 1, 1, format(abs(scaled_wc('quqd8_3311'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x3x1x1'],
	  [3, 3, 1, 2, format(abs(scaled_wc('quqd8_3312'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x3x1x2'],
	  [3, 3, 1, 3, format(abs(scaled_wc('quqd8_3313'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x3x1x3'],
	  [3, 3, 2, 1, format(abs(scaled_wc('quqd8_3321'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x3x2x1'],
	  [3, 3, 2, 2, format(abs(scaled_wc('quqd8_3322'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x3x2x2'],
	  [3, 3, 2, 3, format(abs(scaled_wc('quqd8_3323'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x3x2x3'],
	  [3, 3, 3, 1, format(abs(scaled_wc('quqd8_3331'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x3x3x1'],
	  [3, 3, 3, 2, format(abs(scaled_wc('quqd8_3332'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x3x3x2'],
	  [3, 3, 3, 3, format(abs(scaled_wc('quqd8_3333'))* lambda_smeft_value**2, '.6e'), '# cQUQD8Abs3x3x3x3'],
      ]}

      card['Block']['FRBlock76'] = {'values': [
	  [1, 1, 1, 1, format(angle(scaled_wc('quqd8_1111')), '.6e'), '# cQUQD8Ph1x1x1x1'],
	  [1, 1, 1, 2, format(angle(scaled_wc('quqd8_1112')), '.6e'), '# cQUQD8Ph1x1x1x2'],
	  [1, 1, 1, 3, format(angle(scaled_wc('quqd8_1113')), '.6e'), '# cQUQD8Ph1x1x1x3'],
	  [1, 1, 2, 1, format(angle(scaled_wc('quqd8_1121')), '.6e'), '# cQUQD8Ph1x1x2x1'],
	  [1, 1, 2, 2, format(angle(scaled_wc('quqd8_1122')), '.6e'), '# cQUQD8Ph1x1x2x2'],
	  [1, 1, 2, 3, format(angle(scaled_wc('quqd8_1123')), '.6e'), '# cQUQD8Ph1x1x2x3'],
	  [1, 1, 3, 1, format(angle(scaled_wc('quqd8_1131')), '.6e'), '# cQUQD8Ph1x1x3x1'],
	  [1, 1, 3, 2, format(angle(scaled_wc('quqd8_1132')), '.6e'), '# cQUQD8Ph1x1x3x2'],
	  [1, 1, 3, 3, format(angle(scaled_wc('quqd8_1133')), '.6e'), '# cQUQD8Ph1x1x3x3'],
	  [1, 2, 1, 1, format(angle(scaled_wc('quqd8_1211')), '.6e'), '# cQUQD8Ph1x2x1x1'],
	  [1, 2, 1, 2, format(angle(scaled_wc('quqd8_1212')), '.6e'), '# cQUQD8Ph1x2x1x2'],
	  [1, 2, 1, 3, format(angle(scaled_wc('quqd8_1213')), '.6e'), '# cQUQD8Ph1x2x1x3'],
	  [1, 2, 2, 1, format(angle(scaled_wc('quqd8_1221')), '.6e'), '# cQUQD8Ph1x2x2x1'],
	  [1, 2, 2, 2, format(angle(scaled_wc('quqd8_1222')), '.6e'), '# cQUQD8Ph1x2x2x2'],
	  [1, 2, 2, 3, format(angle(scaled_wc('quqd8_1223')), '.6e'), '# cQUQD8Ph1x2x2x3'],
	  [1, 2, 3, 1, format(angle(scaled_wc('quqd8_1231')), '.6e'), '# cQUQD8Ph1x2x3x1'],
	  [1, 2, 3, 2, format(angle(scaled_wc('quqd8_1232')), '.6e'), '# cQUQD8Ph1x2x3x2'],
	  [1, 2, 3, 3, format(angle(scaled_wc('quqd8_1233')), '.6e'), '# cQUQD8Ph1x2x3x3'],
	  [1, 3, 1, 1, format(angle(scaled_wc('quqd8_1311')), '.6e'), '# cQUQD8Ph1x3x1x1'],
	  [1, 3, 1, 2, format(angle(scaled_wc('quqd8_1312')), '.6e'), '# cQUQD8Ph1x3x1x2'],
	  [1, 3, 1, 3, format(angle(scaled_wc('quqd8_1313')), '.6e'), '# cQUQD8Ph1x3x1x3'],
	  [1, 3, 2, 1, format(angle(scaled_wc('quqd8_1321')), '.6e'), '# cQUQD8Ph1x3x2x1'],
	  [1, 3, 2, 2, format(angle(scaled_wc('quqd8_1322')), '.6e'), '# cQUQD8Ph1x3x2x2'],
	  [1, 3, 2, 3, format(angle(scaled_wc('quqd8_1323')), '.6e'), '# cQUQD8Ph1x3x2x3'],
	  [1, 3, 3, 1, format(angle(scaled_wc('quqd8_1331')), '.6e'), '# cQUQD8Ph1x3x3x1'],
	  [1, 3, 3, 2, format(angle(scaled_wc('quqd8_1332')), '.6e'), '# cQUQD8Ph1x3x3x2'],
	  [1, 3, 3, 3, format(angle(scaled_wc('quqd8_1333')), '.6e'), '# cQUQD8Ph1x3x3x3'],
	  [2, 1, 1, 1, format(angle(scaled_wc('quqd8_2111')), '.6e'), '# cQUQD8Ph2x1x1x1'],
	  [2, 1, 1, 2, format(angle(scaled_wc('quqd8_2112')), '.6e'), '# cQUQD8Ph2x1x1x2'],
	  [2, 1, 1, 3, format(angle(scaled_wc('quqd8_2113')), '.6e'), '# cQUQD8Ph2x1x1x3'],
	  [2, 1, 2, 1, format(angle(scaled_wc('quqd8_2121')), '.6e'), '# cQUQD8Ph2x1x2x1'],
	  [2, 1, 2, 2, format(angle(scaled_wc('quqd8_2122')), '.6e'), '# cQUQD8Ph2x1x2x2'],
	  [2, 1, 2, 3, format(angle(scaled_wc('quqd8_2123')), '.6e'), '# cQUQD8Ph2x1x2x3'],
	  [2, 1, 3, 1, format(angle(scaled_wc('quqd8_2131')), '.6e'), '# cQUQD8Ph2x1x3x1'],
	  [2, 1, 3, 2, format(angle(scaled_wc('quqd8_2132')), '.6e'), '# cQUQD8Ph2x1x3x2'],
	  [2, 1, 3, 3, format(angle(scaled_wc('quqd8_2133')), '.6e'), '# cQUQD8Ph2x1x3x3'],
	  [2, 2, 1, 1, format(angle(scaled_wc('quqd8_2211')), '.6e'), '# cQUQD8Ph2x2x1x1'],
	  [2, 2, 1, 2, format(angle(scaled_wc('quqd8_2212')), '.6e'), '# cQUQD8Ph2x2x1x2'],
	  [2, 2, 1, 3, format(angle(scaled_wc('quqd8_2213')), '.6e'), '# cQUQD8Ph2x2x1x3'],
	  [2, 2, 2, 1, format(angle(scaled_wc('quqd8_2221')), '.6e'), '# cQUQD8Ph2x2x2x1'],
	  [2, 2, 2, 2, format(angle(scaled_wc('quqd8_2222')), '.6e'), '# cQUQD8Ph2x2x2x2'],
	  [2, 2, 2, 3, format(angle(scaled_wc('quqd8_2223')), '.6e'), '# cQUQD8Ph2x2x2x3'],
	  [2, 2, 3, 1, format(angle(scaled_wc('quqd8_2231')), '.6e'), '# cQUQD8Ph2x2x3x1'],
	  [2, 2, 3, 2, format(angle(scaled_wc('quqd8_2232')), '.6e'), '# cQUQD8Ph2x2x3x2'],
	  [2, 2, 3, 3, format(angle(scaled_wc('quqd8_2233')), '.6e'), '# cQUQD8Ph2x2x3x3'],
	  [2, 3, 1, 1, format(angle(scaled_wc('quqd8_2311')), '.6e'), '# cQUQD8Ph2x3x1x1'],
	  [2, 3, 1, 2, format(angle(scaled_wc('quqd8_2312')), '.6e'), '# cQUQD8Ph2x3x1x2'],
	  [2, 3, 1, 3, format(angle(scaled_wc('quqd8_2313')), '.6e'), '# cQUQD8Ph2x3x1x3'],
	  [2, 3, 2, 1, format(angle(scaled_wc('quqd8_2321')), '.6e'), '# cQUQD8Ph2x3x2x1'],
	  [2, 3, 2, 2, format(angle(scaled_wc('quqd8_2322')), '.6e'), '# cQUQD8Ph2x3x2x2'],
	  [2, 3, 2, 3, format(angle(scaled_wc('quqd8_2323')), '.6e'), '# cQUQD8Ph2x3x2x3'],
	  [2, 3, 3, 1, format(angle(scaled_wc('quqd8_2331')), '.6e'), '# cQUQD8Ph2x3x3x1'],
	  [2, 3, 3, 2, format(angle(scaled_wc('quqd8_2332')), '.6e'), '# cQUQD8Ph2x3x3x2'],
	  [2, 3, 3, 3, format(angle(scaled_wc('quqd8_2333')), '.6e'), '# cQUQD8Ph2x3x3x3'],
	  [3, 1, 1, 1, format(angle(scaled_wc('quqd8_3111')), '.6e'), '# cQUQD8Ph3x1x1x1'],
	  [3, 1, 1, 2, format(angle(scaled_wc('quqd8_3112')), '.6e'), '# cQUQD8Ph3x1x1x2'],
	  [3, 1, 1, 3, format(angle(scaled_wc('quqd8_3113')), '.6e'), '# cQUQD8Ph3x1x1x3'],
	  [3, 1, 2, 1, format(angle(scaled_wc('quqd8_3121')), '.6e'), '# cQUQD8Ph3x1x2x1'],
	  [3, 1, 2, 2, format(angle(scaled_wc('quqd8_3122')), '.6e'), '# cQUQD8Ph3x1x2x2'],
	  [3, 1, 2, 3, format(angle(scaled_wc('quqd8_3123')), '.6e'), '# cQUQD8Ph3x1x2x3'],
	  [3, 1, 3, 1, format(angle(scaled_wc('quqd8_3131')), '.6e'), '# cQUQD8Ph3x1x3x1'],
	  [3, 1, 3, 2, format(angle(scaled_wc('quqd8_3132')), '.6e'), '# cQUQD8Ph3x1x3x2'],
	  [3, 1, 3, 3, format(angle(scaled_wc('quqd8_3133')), '.6e'), '# cQUQD8Ph3x1x3x3'],
	  [3, 2, 1, 1, format(angle(scaled_wc('quqd8_3211')), '.6e'), '# cQUQD8Ph3x2x1x1'],
	  [3, 2, 1, 2, format(angle(scaled_wc('quqd8_3212')), '.6e'), '# cQUQD8Ph3x2x1x2'],
	  [3, 2, 1, 3, format(angle(scaled_wc('quqd8_3213')), '.6e'), '# cQUQD8Ph3x2x1x3'],
	  [3, 2, 2, 1, format(angle(scaled_wc('quqd8_3221')), '.6e'), '# cQUQD8Ph3x2x2x1'],
	  [3, 2, 2, 2, format(angle(scaled_wc('quqd8_3222')), '.6e'), '# cQUQD8Ph3x2x2x2'],
	  [3, 2, 2, 3, format(angle(scaled_wc('quqd8_3223')), '.6e'), '# cQUQD8Ph3x2x2x3'],
	  [3, 2, 3, 1, format(angle(scaled_wc('quqd8_3231')), '.6e'), '# cQUQD8Ph3x2x3x1'],
	  [3, 2, 3, 2, format(angle(scaled_wc('quqd8_3232')), '.6e'), '# cQUQD8Ph3x2x3x2'],
	  [3, 2, 3, 3, format(angle(scaled_wc('quqd8_3233')), '.6e'), '# cQUQD8Ph3x2x3x3'],
	  [3, 3, 1, 1, format(angle(scaled_wc('quqd8_3311')), '.6e'), '# cQUQD8Ph3x3x1x1'],
	  [3, 3, 1, 2, format(angle(scaled_wc('quqd8_3312')), '.6e'), '# cQUQD8Ph3x3x1x2'],
	  [3, 3, 1, 3, format(angle(scaled_wc('quqd8_3313')), '.6e'), '# cQUQD8Ph3x3x1x3'],
	  [3, 3, 2, 1, format(angle(scaled_wc('quqd8_3321')), '.6e'), '# cQUQD8Ph3x3x2x1'],
	  [3, 3, 2, 2, format(angle(scaled_wc('quqd8_3322')), '.6e'), '# cQUQD8Ph3x3x2x2'],
	  [3, 3, 2, 3, format(angle(scaled_wc('quqd8_3323')), '.6e'), '# cQUQD8Ph3x3x2x3'],
	  [3, 3, 3, 1, format(angle(scaled_wc('quqd8_3331')), '.6e'), '# cQUQD8Ph3x3x3x1'],
	  [3, 3, 3, 2, format(angle(scaled_wc('quqd8_3332')), '.6e'), '# cQUQD8Ph3x3x3x2'],
	  [3, 3, 3, 3, format(angle(scaled_wc('quqd8_3333')), '.6e'), '# cQUQD8Ph3x3x3x3'],
      ]}

      card['Block']['FRBlock78'] = {'values': [
	  [1, 1, 1, 1, format(abs(scaled_wc('lequ1_1111'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x1x1x1'],
	  [1, 1, 1, 2, format(abs(scaled_wc('lequ1_1112'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x1x1x2'],
	  [1, 1, 1, 3, format(abs(scaled_wc('lequ1_1113'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x1x1x3'],
	  [1, 1, 2, 1, format(abs(scaled_wc('lequ1_1121'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x1x2x1'],
	  [1, 1, 2, 2, format(abs(scaled_wc('lequ1_1122'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x1x2x2'],
	  [1, 1, 2, 3, format(abs(scaled_wc('lequ1_1123'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x1x2x3'],
	  [1, 1, 3, 1, format(abs(scaled_wc('lequ1_1131'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x1x3x1'],
	  [1, 1, 3, 2, format(abs(scaled_wc('lequ1_1132'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x1x3x2'],
	  [1, 1, 3, 3, format(abs(scaled_wc('lequ1_1133'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x1x3x3'],
	  [1, 2, 1, 1, format(abs(scaled_wc('lequ1_1211'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x2x1x1'],
	  [1, 2, 1, 2, format(abs(scaled_wc('lequ1_1212'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x2x1x2'],
	  [1, 2, 1, 3, format(abs(scaled_wc('lequ1_1213'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x2x1x3'],
	  [1, 2, 2, 1, format(abs(scaled_wc('lequ1_1221'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x2x2x1'],
	  [1, 2, 2, 2, format(abs(scaled_wc('lequ1_1222'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x2x2x2'],
	  [1, 2, 2, 3, format(abs(scaled_wc('lequ1_1223'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x2x2x3'],
	  [1, 2, 3, 1, format(abs(scaled_wc('lequ1_1231'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x2x3x1'],
	  [1, 2, 3, 2, format(abs(scaled_wc('lequ1_1232'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x2x3x2'],
	  [1, 2, 3, 3, format(abs(scaled_wc('lequ1_1233'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x2x3x3'],
	  [1, 3, 1, 1, format(abs(scaled_wc('lequ1_1311'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x3x1x1'],
	  [1, 3, 1, 2, format(abs(scaled_wc('lequ1_1312'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x3x1x2'],
	  [1, 3, 1, 3, format(abs(scaled_wc('lequ1_1313'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x3x1x3'],
	  [1, 3, 2, 1, format(abs(scaled_wc('lequ1_1321'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x3x2x1'],
	  [1, 3, 2, 2, format(abs(scaled_wc('lequ1_1322'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x3x2x2'],
	  [1, 3, 2, 3, format(abs(scaled_wc('lequ1_1323'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x3x2x3'],
	  [1, 3, 3, 1, format(abs(scaled_wc('lequ1_1331'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x3x3x1'],
	  [1, 3, 3, 2, format(abs(scaled_wc('lequ1_1332'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x3x3x2'],
	  [1, 3, 3, 3, format(abs(scaled_wc('lequ1_1333'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs1x3x3x3'],
	  [2, 1, 1, 1, format(abs(scaled_wc('lequ1_2111'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x1x1x1'],
	  [2, 1, 1, 2, format(abs(scaled_wc('lequ1_2112'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x1x1x2'],
	  [2, 1, 1, 3, format(abs(scaled_wc('lequ1_2113'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x1x1x3'],
	  [2, 1, 2, 1, format(abs(scaled_wc('lequ1_2121'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x1x2x1'],
	  [2, 1, 2, 2, format(abs(scaled_wc('lequ1_2122'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x1x2x2'],
	  [2, 1, 2, 3, format(abs(scaled_wc('lequ1_2123'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x1x2x3'],
	  [2, 1, 3, 1, format(abs(scaled_wc('lequ1_2131'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x1x3x1'],
	  [2, 1, 3, 2, format(abs(scaled_wc('lequ1_2132'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x1x3x2'],
	  [2, 1, 3, 3, format(abs(scaled_wc('lequ1_2133'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x1x3x3'],
	  [2, 2, 1, 1, format(abs(scaled_wc('lequ1_2211'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x2x1x1'],
	  [2, 2, 1, 2, format(abs(scaled_wc('lequ1_2212'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x2x1x2'],
	  [2, 2, 1, 3, format(abs(scaled_wc('lequ1_2213'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x2x1x3'],
	  [2, 2, 2, 1, format(abs(scaled_wc('lequ1_2221'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x2x2x1'],
	  [2, 2, 2, 2, format(abs(scaled_wc('lequ1_2222'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x2x2x2'],
	  [2, 2, 2, 3, format(abs(scaled_wc('lequ1_2223'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x2x2x3'],
	  [2, 2, 3, 1, format(abs(scaled_wc('lequ1_2231'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x2x3x1'],
	  [2, 2, 3, 2, format(abs(scaled_wc('lequ1_2232'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x2x3x2'],
	  [2, 2, 3, 3, format(abs(scaled_wc('lequ1_2233'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x2x3x3'],
	  [2, 3, 1, 1, format(abs(scaled_wc('lequ1_2311'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x3x1x1'],
	  [2, 3, 1, 2, format(abs(scaled_wc('lequ1_2312'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x3x1x2'],
	  [2, 3, 1, 3, format(abs(scaled_wc('lequ1_2313'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x3x1x3'],
	  [2, 3, 2, 1, format(abs(scaled_wc('lequ1_2321'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x3x2x1'],
	  [2, 3, 2, 2, format(abs(scaled_wc('lequ1_2322'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x3x2x2'],
	  [2, 3, 2, 3, format(abs(scaled_wc('lequ1_2323'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x3x2x3'],
	  [2, 3, 3, 1, format(abs(scaled_wc('lequ1_2331'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x3x3x1'],
	  [2, 3, 3, 2, format(abs(scaled_wc('lequ1_2332'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x3x3x2'],
	  [2, 3, 3, 3, format(abs(scaled_wc('lequ1_2333'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs2x3x3x3'],
	  [3, 1, 1, 1, format(abs(scaled_wc('lequ1_3111'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x1x1x1'],
	  [3, 1, 1, 2, format(abs(scaled_wc('lequ1_3112'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x1x1x2'],
	  [3, 1, 1, 3, format(abs(scaled_wc('lequ1_3113'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x1x1x3'],
	  [3, 1, 2, 1, format(abs(scaled_wc('lequ1_3121'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x1x2x1'],
	  [3, 1, 2, 2, format(abs(scaled_wc('lequ1_3122'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x1x2x2'],
	  [3, 1, 2, 3, format(abs(scaled_wc('lequ1_3123'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x1x2x3'],
	  [3, 1, 3, 1, format(abs(scaled_wc('lequ1_3131'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x1x3x1'],
	  [3, 1, 3, 2, format(abs(scaled_wc('lequ1_3132'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x1x3x2'],
	  [3, 1, 3, 3, format(abs(scaled_wc('lequ1_3133'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x1x3x3'],
	  [3, 2, 1, 1, format(abs(scaled_wc('lequ1_3211'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x2x1x1'],
	  [3, 2, 1, 2, format(abs(scaled_wc('lequ1_3212'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x2x1x2'],
	  [3, 2, 1, 3, format(abs(scaled_wc('lequ1_3213'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x2x1x3'],
	  [3, 2, 2, 1, format(abs(scaled_wc('lequ1_3221'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x2x2x1'],
	  [3, 2, 2, 2, format(abs(scaled_wc('lequ1_3222'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x2x2x2'],
	  [3, 2, 2, 3, format(abs(scaled_wc('lequ1_3223'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x2x2x3'],
	  [3, 2, 3, 1, format(abs(scaled_wc('lequ1_3231'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x2x3x1'],
	  [3, 2, 3, 2, format(abs(scaled_wc('lequ1_3232'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x2x3x2'],
	  [3, 2, 3, 3, format(abs(scaled_wc('lequ1_3233'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x2x3x3'],
	  [3, 3, 1, 1, format(abs(scaled_wc('lequ1_3311'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x3x1x1'],
	  [3, 3, 1, 2, format(abs(scaled_wc('lequ1_3312'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x3x1x2'],
	  [3, 3, 1, 3, format(abs(scaled_wc('lequ1_3313'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x3x1x3'],
	  [3, 3, 2, 1, format(abs(scaled_wc('lequ1_3321'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x3x2x1'],
	  [3, 3, 2, 2, format(abs(scaled_wc('lequ1_3322'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x3x2x2'],
	  [3, 3, 2, 3, format(abs(scaled_wc('lequ1_3323'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x3x2x3'],
	  [3, 3, 3, 1, format(abs(scaled_wc('lequ1_3331'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x3x3x1'],
	  [3, 3, 3, 2, format(abs(scaled_wc('lequ1_3332'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x3x3x2'],
	  [3, 3, 3, 3, format(abs(scaled_wc('lequ1_3333'))* lambda_smeft_value**2, '.6e'), '# clequ1Abs3x3x3x3'],
      ]}

      card['Block']['FRBlock79'] = {'values': [
	  [1, 1, 1, 1, format(angle(scaled_wc('lequ1_1111')), '.6e'), '# clequ1Ph1x1x1x1'],
	  [1, 1, 1, 2, format(angle(scaled_wc('lequ1_1112')), '.6e'), '# clequ1Ph1x1x1x2'],
	  [1, 1, 1, 3, format(angle(scaled_wc('lequ1_1113')), '.6e'), '# clequ1Ph1x1x1x3'],
	  [1, 1, 2, 1, format(angle(scaled_wc('lequ1_1121')), '.6e'), '# clequ1Ph1x1x2x1'],
	  [1, 1, 2, 2, format(angle(scaled_wc('lequ1_1122')), '.6e'), '# clequ1Ph1x1x2x2'],
	  [1, 1, 2, 3, format(angle(scaled_wc('lequ1_1123')), '.6e'), '# clequ1Ph1x1x2x3'],
	  [1, 1, 3, 1, format(angle(scaled_wc('lequ1_1131')), '.6e'), '# clequ1Ph1x1x3x1'],
	  [1, 1, 3, 2, format(angle(scaled_wc('lequ1_1132')), '.6e'), '# clequ1Ph1x1x3x2'],
	  [1, 1, 3, 3, format(angle(scaled_wc('lequ1_1133')), '.6e'), '# clequ1Ph1x1x3x3'],
	  [1, 2, 1, 1, format(angle(scaled_wc('lequ1_1211')), '.6e'), '# clequ1Ph1x2x1x1'],
	  [1, 2, 1, 2, format(angle(scaled_wc('lequ1_1212')), '.6e'), '# clequ1Ph1x2x1x2'],
	  [1, 2, 1, 3, format(angle(scaled_wc('lequ1_1213')), '.6e'), '# clequ1Ph1x2x1x3'],
	  [1, 2, 2, 1, format(angle(scaled_wc('lequ1_1221')), '.6e'), '# clequ1Ph1x2x2x1'],
	  [1, 2, 2, 2, format(angle(scaled_wc('lequ1_1222')), '.6e'), '# clequ1Ph1x2x2x2'],
	  [1, 2, 2, 3, format(angle(scaled_wc('lequ1_1223')), '.6e'), '# clequ1Ph1x2x2x3'],
	  [1, 2, 3, 1, format(angle(scaled_wc('lequ1_1231')), '.6e'), '# clequ1Ph1x2x3x1'],
	  [1, 2, 3, 2, format(angle(scaled_wc('lequ1_1232')), '.6e'), '# clequ1Ph1x2x3x2'],
	  [1, 2, 3, 3, format(angle(scaled_wc('lequ1_1233')), '.6e'), '# clequ1Ph1x2x3x3'],
	  [1, 3, 1, 1, format(angle(scaled_wc('lequ1_1311')), '.6e'), '# clequ1Ph1x3x1x1'],
	  [1, 3, 1, 2, format(angle(scaled_wc('lequ1_1312')), '.6e'), '# clequ1Ph1x3x1x2'],
	  [1, 3, 1, 3, format(angle(scaled_wc('lequ1_1313')), '.6e'), '# clequ1Ph1x3x1x3'],
	  [1, 3, 2, 1, format(angle(scaled_wc('lequ1_1321')), '.6e'), '# clequ1Ph1x3x2x1'],
	  [1, 3, 2, 2, format(angle(scaled_wc('lequ1_1322')), '.6e'), '# clequ1Ph1x3x2x2'],
	  [1, 3, 2, 3, format(angle(scaled_wc('lequ1_1323')), '.6e'), '# clequ1Ph1x3x2x3'],
	  [1, 3, 3, 1, format(angle(scaled_wc('lequ1_1331')), '.6e'), '# clequ1Ph1x3x3x1'],
	  [1, 3, 3, 2, format(angle(scaled_wc('lequ1_1332')), '.6e'), '# clequ1Ph1x3x3x2'],
	  [1, 3, 3, 3, format(angle(scaled_wc('lequ1_1333')), '.6e'), '# clequ1Ph1x3x3x3'],
	  [2, 1, 1, 1, format(angle(scaled_wc('lequ1_2111')), '.6e'), '# clequ1Ph2x1x1x1'],
	  [2, 1, 1, 2, format(angle(scaled_wc('lequ1_2112')), '.6e'), '# clequ1Ph2x1x1x2'],
	  [2, 1, 1, 3, format(angle(scaled_wc('lequ1_2113')), '.6e'), '# clequ1Ph2x1x1x3'],
	  [2, 1, 2, 1, format(angle(scaled_wc('lequ1_2121')), '.6e'), '# clequ1Ph2x1x2x1'],
	  [2, 1, 2, 2, format(angle(scaled_wc('lequ1_2122')), '.6e'), '# clequ1Ph2x1x2x2'],
	  [2, 1, 2, 3, format(angle(scaled_wc('lequ1_2123')), '.6e'), '# clequ1Ph2x1x2x3'],
	  [2, 1, 3, 1, format(angle(scaled_wc('lequ1_2131')), '.6e'), '# clequ1Ph2x1x3x1'],
	  [2, 1, 3, 2, format(angle(scaled_wc('lequ1_2132')), '.6e'), '# clequ1Ph2x1x3x2'],
	  [2, 1, 3, 3, format(angle(scaled_wc('lequ1_2133')), '.6e'), '# clequ1Ph2x1x3x3'],
	  [2, 2, 1, 1, format(angle(scaled_wc('lequ1_2211')), '.6e'), '# clequ1Ph2x2x1x1'],
	  [2, 2, 1, 2, format(angle(scaled_wc('lequ1_2212')), '.6e'), '# clequ1Ph2x2x1x2'],
	  [2, 2, 1, 3, format(angle(scaled_wc('lequ1_2213')), '.6e'), '# clequ1Ph2x2x1x3'],
	  [2, 2, 2, 1, format(angle(scaled_wc('lequ1_2221')), '.6e'), '# clequ1Ph2x2x2x1'],
	  [2, 2, 2, 2, format(angle(scaled_wc('lequ1_2222')), '.6e'), '# clequ1Ph2x2x2x2'],
	  [2, 2, 2, 3, format(angle(scaled_wc('lequ1_2223')), '.6e'), '# clequ1Ph2x2x2x3'],
	  [2, 2, 3, 1, format(angle(scaled_wc('lequ1_2231')), '.6e'), '# clequ1Ph2x2x3x1'],
	  [2, 2, 3, 2, format(angle(scaled_wc('lequ1_2232')), '.6e'), '# clequ1Ph2x2x3x2'],
	  [2, 2, 3, 3, format(angle(scaled_wc('lequ1_2233')), '.6e'), '# clequ1Ph2x2x3x3'],
	  [2, 3, 1, 1, format(angle(scaled_wc('lequ1_2311')), '.6e'), '# clequ1Ph2x3x1x1'],
	  [2, 3, 1, 2, format(angle(scaled_wc('lequ1_2312')), '.6e'), '# clequ1Ph2x3x1x2'],
	  [2, 3, 1, 3, format(angle(scaled_wc('lequ1_2313')), '.6e'), '# clequ1Ph2x3x1x3'],
	  [2, 3, 2, 1, format(angle(scaled_wc('lequ1_2321')), '.6e'), '# clequ1Ph2x3x2x1'],
	  [2, 3, 2, 2, format(angle(scaled_wc('lequ1_2322')), '.6e'), '# clequ1Ph2x3x2x2'],
	  [2, 3, 2, 3, format(angle(scaled_wc('lequ1_2323')), '.6e'), '# clequ1Ph2x3x2x3'],
	  [2, 3, 3, 1, format(angle(scaled_wc('lequ1_2331')), '.6e'), '# clequ1Ph2x3x3x1'],
	  [2, 3, 3, 2, format(angle(scaled_wc('lequ1_2332')), '.6e'), '# clequ1Ph2x3x3x2'],
	  [2, 3, 3, 3, format(angle(scaled_wc('lequ1_2333')), '.6e'), '# clequ1Ph2x3x3x3'],
	  [3, 1, 1, 1, format(angle(scaled_wc('lequ1_3111')), '.6e'), '# clequ1Ph3x1x1x1'],
	  [3, 1, 1, 2, format(angle(scaled_wc('lequ1_3112')), '.6e'), '# clequ1Ph3x1x1x2'],
	  [3, 1, 1, 3, format(angle(scaled_wc('lequ1_3113')), '.6e'), '# clequ1Ph3x1x1x3'],
	  [3, 1, 2, 1, format(angle(scaled_wc('lequ1_3121')), '.6e'), '# clequ1Ph3x1x2x1'],
	  [3, 1, 2, 2, format(angle(scaled_wc('lequ1_3122')), '.6e'), '# clequ1Ph3x1x2x2'],
	  [3, 1, 2, 3, format(angle(scaled_wc('lequ1_3123')), '.6e'), '# clequ1Ph3x1x2x3'],
	  [3, 1, 3, 1, format(angle(scaled_wc('lequ1_3131')), '.6e'), '# clequ1Ph3x1x3x1'],
	  [3, 1, 3, 2, format(angle(scaled_wc('lequ1_3132')), '.6e'), '# clequ1Ph3x1x3x2'],
	  [3, 1, 3, 3, format(angle(scaled_wc('lequ1_3133')), '.6e'), '# clequ1Ph3x1x3x3'],
	  [3, 2, 1, 1, format(angle(scaled_wc('lequ1_3211')), '.6e'), '# clequ1Ph3x2x1x1'],
	  [3, 2, 1, 2, format(angle(scaled_wc('lequ1_3212')), '.6e'), '# clequ1Ph3x2x1x2'],
	  [3, 2, 1, 3, format(angle(scaled_wc('lequ1_3213')), '.6e'), '# clequ1Ph3x2x1x3'],
	  [3, 2, 2, 1, format(angle(scaled_wc('lequ1_3221')), '.6e'), '# clequ1Ph3x2x2x1'],
	  [3, 2, 2, 2, format(angle(scaled_wc('lequ1_3222')), '.6e'), '# clequ1Ph3x2x2x2'],
	  [3, 2, 2, 3, format(angle(scaled_wc('lequ1_3223')), '.6e'), '# clequ1Ph3x2x2x3'],
	  [3, 2, 3, 1, format(angle(scaled_wc('lequ1_3231')), '.6e'), '# clequ1Ph3x2x3x1'],
	  [3, 2, 3, 2, format(angle(scaled_wc('lequ1_3232')), '.6e'), '# clequ1Ph3x2x3x2'],
	  [3, 2, 3, 3, format(angle(scaled_wc('lequ1_3233')), '.6e'), '# clequ1Ph3x2x3x3'],
	  [3, 3, 1, 1, format(angle(scaled_wc('lequ1_3311')), '.6e'), '# clequ1Ph3x3x1x1'],
	  [3, 3, 1, 2, format(angle(scaled_wc('lequ1_3312')), '.6e'), '# clequ1Ph3x3x1x2'],
	  [3, 3, 1, 3, format(angle(scaled_wc('lequ1_3313')), '.6e'), '# clequ1Ph3x3x1x3'],
	  [3, 3, 2, 1, format(angle(scaled_wc('lequ1_3321')), '.6e'), '# clequ1Ph3x3x2x1'],
	  [3, 3, 2, 2, format(angle(scaled_wc('lequ1_3322')), '.6e'), '# clequ1Ph3x3x2x2'],
	  [3, 3, 2, 3, format(angle(scaled_wc('lequ1_3323')), '.6e'), '# clequ1Ph3x3x2x3'],
	  [3, 3, 3, 1, format(angle(scaled_wc('lequ1_3331')), '.6e'), '# clequ1Ph3x3x3x1'],
	  [3, 3, 3, 2, format(angle(scaled_wc('lequ1_3332')), '.6e'), '# clequ1Ph3x3x3x2'],
	  [3, 3, 3, 3, format(angle(scaled_wc('lequ1_3333')), '.6e'), '# clequ1Ph3x3x3x3'],
      ]}

      card['Block']['FRBlock8'] = {'values': [
	  [1, 1, format(abs(scaled_wc('dphi_11'))* lambda_smeft_value**2, '.6e'), '# cdHAbs1x1'],
	  [1, 2, format(abs(scaled_wc('dphi_12'))* lambda_smeft_value**2, '.6e'), '# cdHAbs1x2'],
	  [1, 3, format(abs(scaled_wc('dphi_13'))* lambda_smeft_value**2, '.6e'), '# cdHAbs1x3'],
	  [2, 1, format(abs(scaled_wc('dphi_21'))* lambda_smeft_value**2, '.6e'), '# cdHAbs2x1'],
	  [2, 2, format(abs(scaled_wc('dphi_22'))* lambda_smeft_value**2, '.6e'), '# cdHAbs2x2'],
	  [2, 3, format(abs(scaled_wc('dphi_23'))* lambda_smeft_value**2, '.6e'), '# cdHAbs2x3'],
	  [3, 1, format(abs(scaled_wc('dphi_31'))* lambda_smeft_value**2, '.6e'), '# cdHAbs3x1'],
	  [3, 2, format(abs(scaled_wc('dphi_32'))* lambda_smeft_value**2, '.6e'), '# cdHAbs3x2'],
	  [3, 3, format(abs(scaled_wc('dphi_33'))* lambda_smeft_value**2, '.6e'), '# cdHAbs3x3'],
      ]}

      card['Block']['FRBlock81'] = {'values': [
	  [1, 1, 1, 1, format(abs(scaled_wc('lequ3_1111'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x1x1x1'],
	  [1, 1, 1, 2, format(abs(scaled_wc('lequ3_1112'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x1x1x2'],
	  [1, 1, 1, 3, format(abs(scaled_wc('lequ3_1113'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x1x1x3'],
	  [1, 1, 2, 1, format(abs(scaled_wc('lequ3_1121'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x1x2x1'],
	  [1, 1, 2, 2, format(abs(scaled_wc('lequ3_1122'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x1x2x2'],
	  [1, 1, 2, 3, format(abs(scaled_wc('lequ3_1123'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x1x2x3'],
	  [1, 1, 3, 1, format(abs(scaled_wc('lequ3_1131'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x1x3x1'],
	  [1, 1, 3, 2, format(abs(scaled_wc('lequ3_1132'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x1x3x2'],
	  [1, 1, 3, 3, format(abs(scaled_wc('lequ3_1133'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x1x3x3'],
	  [1, 2, 1, 1, format(abs(scaled_wc('lequ3_1211'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x2x1x1'],
	  [1, 2, 1, 2, format(abs(scaled_wc('lequ3_1212'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x2x1x2'],
	  [1, 2, 1, 3, format(abs(scaled_wc('lequ3_1213'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x2x1x3'],
	  [1, 2, 2, 1, format(abs(scaled_wc('lequ3_1221'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x2x2x1'],
	  [1, 2, 2, 2, format(abs(scaled_wc('lequ3_1222'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x2x2x2'],
	  [1, 2, 2, 3, format(abs(scaled_wc('lequ3_1223'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x2x2x3'],
	  [1, 2, 3, 1, format(abs(scaled_wc('lequ3_1231'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x2x3x1'],
	  [1, 2, 3, 2, format(abs(scaled_wc('lequ3_1232'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x2x3x2'],
	  [1, 2, 3, 3, format(abs(scaled_wc('lequ3_1233'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x2x3x3'],
	  [1, 3, 1, 1, format(abs(scaled_wc('lequ3_1311'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x3x1x1'],
	  [1, 3, 1, 2, format(abs(scaled_wc('lequ3_1312'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x3x1x2'],
	  [1, 3, 1, 3, format(abs(scaled_wc('lequ3_1313'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x3x1x3'],
	  [1, 3, 2, 1, format(abs(scaled_wc('lequ3_1321'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x3x2x1'],
	  [1, 3, 2, 2, format(abs(scaled_wc('lequ3_1322'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x3x2x2'],
	  [1, 3, 2, 3, format(abs(scaled_wc('lequ3_1323'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x3x2x3'],
	  [1, 3, 3, 1, format(abs(scaled_wc('lequ3_1331'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x3x3x1'],
	  [1, 3, 3, 2, format(abs(scaled_wc('lequ3_1332'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x3x3x2'],
	  [1, 3, 3, 3, format(abs(scaled_wc('lequ3_1333'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs1x3x3x3'],
	  [2, 1, 1, 1, format(abs(scaled_wc('lequ3_2111'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x1x1x1'],
	  [2, 1, 1, 2, format(abs(scaled_wc('lequ3_2112'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x1x1x2'],
	  [2, 1, 1, 3, format(abs(scaled_wc('lequ3_2113'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x1x1x3'],
	  [2, 1, 2, 1, format(abs(scaled_wc('lequ3_2121'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x1x2x1'],
	  [2, 1, 2, 2, format(abs(scaled_wc('lequ3_2122'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x1x2x2'],
	  [2, 1, 2, 3, format(abs(scaled_wc('lequ3_2123'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x1x2x3'],
	  [2, 1, 3, 1, format(abs(scaled_wc('lequ3_2131'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x1x3x1'],
	  [2, 1, 3, 2, format(abs(scaled_wc('lequ3_2132'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x1x3x2'],
	  [2, 1, 3, 3, format(abs(scaled_wc('lequ3_2133'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x1x3x3'],
	  [2, 2, 1, 1, format(abs(scaled_wc('lequ3_2211'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x2x1x1'],
	  [2, 2, 1, 2, format(abs(scaled_wc('lequ3_2212'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x2x1x2'],
	  [2, 2, 1, 3, format(abs(scaled_wc('lequ3_2213'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x2x1x3'],
	  [2, 2, 2, 1, format(abs(scaled_wc('lequ3_2221'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x2x2x1'],
	  [2, 2, 2, 2, format(abs(scaled_wc('lequ3_2222'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x2x2x2'],
	  [2, 2, 2, 3, format(abs(scaled_wc('lequ3_2223'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x2x2x3'],
	  [2, 2, 3, 1, format(abs(scaled_wc('lequ3_2231'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x2x3x1'],
	  [2, 2, 3, 2, format(abs(scaled_wc('lequ3_2232'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x2x3x2'],
	  [2, 2, 3, 3, format(abs(scaled_wc('lequ3_2233'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x2x3x3'],
	  [2, 3, 1, 1, format(abs(scaled_wc('lequ3_2311'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x3x1x1'],
	  [2, 3, 1, 2, format(abs(scaled_wc('lequ3_2312'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x3x1x2'],
	  [2, 3, 1, 3, format(abs(scaled_wc('lequ3_2313'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x3x1x3'],
	  [2, 3, 2, 1, format(abs(scaled_wc('lequ3_2321'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x3x2x1'],
	  [2, 3, 2, 2, format(abs(scaled_wc('lequ3_2322'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x3x2x2'],
	  [2, 3, 2, 3, format(abs(scaled_wc('lequ3_2323'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x3x2x3'],
	  [2, 3, 3, 1, format(abs(scaled_wc('lequ3_2331'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x3x3x1'],
	  [2, 3, 3, 2, format(abs(scaled_wc('lequ3_2332'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x3x3x2'],
	  [2, 3, 3, 3, format(abs(scaled_wc('lequ3_2333'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs2x3x3x3'],
	  [3, 1, 1, 1, format(abs(scaled_wc('lequ3_3111'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x1x1x1'],
	  [3, 1, 1, 2, format(abs(scaled_wc('lequ3_3112'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x1x1x2'],
	  [3, 1, 1, 3, format(abs(scaled_wc('lequ3_3113'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x1x1x3'],
	  [3, 1, 2, 1, format(abs(scaled_wc('lequ3_3121'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x1x2x1'],
	  [3, 1, 2, 2, format(abs(scaled_wc('lequ3_3122'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x1x2x2'],
	  [3, 1, 2, 3, format(abs(scaled_wc('lequ3_3123'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x1x2x3'],
	  [3, 1, 3, 1, format(abs(scaled_wc('lequ3_3131'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x1x3x1'],
	  [3, 1, 3, 2, format(abs(scaled_wc('lequ3_3132'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x1x3x2'],
	  [3, 1, 3, 3, format(abs(scaled_wc('lequ3_3133'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x1x3x3'],
	  [3, 2, 1, 1, format(abs(scaled_wc('lequ3_3211'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x2x1x1'],
	  [3, 2, 1, 2, format(abs(scaled_wc('lequ3_3212'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x2x1x2'],
	  [3, 2, 1, 3, format(abs(scaled_wc('lequ3_3213'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x2x1x3'],
	  [3, 2, 2, 1, format(abs(scaled_wc('lequ3_3221'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x2x2x1'],
	  [3, 2, 2, 2, format(abs(scaled_wc('lequ3_3222'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x2x2x2'],
	  [3, 2, 2, 3, format(abs(scaled_wc('lequ3_3223'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x2x2x3'],
	  [3, 2, 3, 1, format(abs(scaled_wc('lequ3_3231'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x2x3x1'],
	  [3, 2, 3, 2, format(abs(scaled_wc('lequ3_3232'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x2x3x2'],
	  [3, 2, 3, 3, format(abs(scaled_wc('lequ3_3233'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x2x3x3'],
	  [3, 3, 1, 1, format(abs(scaled_wc('lequ3_3311'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x3x1x1'],
	  [3, 3, 1, 2, format(abs(scaled_wc('lequ3_3312'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x3x1x2'],
	  [3, 3, 1, 3, format(abs(scaled_wc('lequ3_3313'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x3x1x3'],
	  [3, 3, 2, 1, format(abs(scaled_wc('lequ3_3321'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x3x2x1'],
	  [3, 3, 2, 2, format(abs(scaled_wc('lequ3_3322'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x3x2x2'],
	  [3, 3, 2, 3, format(abs(scaled_wc('lequ3_3323'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x3x2x3'],
	  [3, 3, 3, 1, format(abs(scaled_wc('lequ3_3331'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x3x3x1'],
	  [3, 3, 3, 2, format(abs(scaled_wc('lequ3_3332'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x3x3x2'],
	  [3, 3, 3, 3, format(abs(scaled_wc('lequ3_3333'))* lambda_smeft_value**2, '.6e'), '# cLeQu3Abs3x3x3x3'],
      ]}

      card['Block']['FRBlock82'] = {'values': [
	  [1, 1, 1, 1, format(angle(scaled_wc('lequ3_1111')), '.6e'), '# cLeQu3Ph1x1x1x1'],
	  [1, 1, 1, 2, format(angle(scaled_wc('lequ3_1112')), '.6e'), '# cLeQu3Ph1x1x1x2'],
	  [1, 1, 1, 3, format(angle(scaled_wc('lequ3_1113')), '.6e'), '# cLeQu3Ph1x1x1x3'],
	  [1, 1, 2, 1, format(angle(scaled_wc('lequ3_1121')), '.6e'), '# cLeQu3Ph1x1x2x1'],
	  [1, 1, 2, 2, format(angle(scaled_wc('lequ3_1122')), '.6e'), '# cLeQu3Ph1x1x2x2'],
	  [1, 1, 2, 3, format(angle(scaled_wc('lequ3_1123')), '.6e'), '# cLeQu3Ph1x1x2x3'],
	  [1, 1, 3, 1, format(angle(scaled_wc('lequ3_1131')), '.6e'), '# cLeQu3Ph1x1x3x1'],
	  [1, 1, 3, 2, format(angle(scaled_wc('lequ3_1132')), '.6e'), '# cLeQu3Ph1x1x3x2'],
	  [1, 1, 3, 3, format(angle(scaled_wc('lequ3_1133')), '.6e'), '# cLeQu3Ph1x1x3x3'],
	  [1, 2, 1, 1, format(angle(scaled_wc('lequ3_1211')), '.6e'), '# cLeQu3Ph1x2x1x1'],
	  [1, 2, 1, 2, format(angle(scaled_wc('lequ3_1212')), '.6e'), '# cLeQu3Ph1x2x1x2'],
	  [1, 2, 1, 3, format(angle(scaled_wc('lequ3_1213')), '.6e'), '# cLeQu3Ph1x2x1x3'],
	  [1, 2, 2, 1, format(angle(scaled_wc('lequ3_1221')), '.6e'), '# cLeQu3Ph1x2x2x1'],
	  [1, 2, 2, 2, format(angle(scaled_wc('lequ3_1222')), '.6e'), '# cLeQu3Ph1x2x2x2'],
	  [1, 2, 2, 3, format(angle(scaled_wc('lequ3_1223')), '.6e'), '# cLeQu3Ph1x2x2x3'],
	  [1, 2, 3, 1, format(angle(scaled_wc('lequ3_1231')), '.6e'), '# cLeQu3Ph1x2x3x1'],
	  [1, 2, 3, 2, format(angle(scaled_wc('lequ3_1232')), '.6e'), '# cLeQu3Ph1x2x3x2'],
	  [1, 2, 3, 3, format(angle(scaled_wc('lequ3_1233')), '.6e'), '# cLeQu3Ph1x2x3x3'],
	  [1, 3, 1, 1, format(angle(scaled_wc('lequ3_1311')), '.6e'), '# cLeQu3Ph1x3x1x1'],
	  [1, 3, 1, 2, format(angle(scaled_wc('lequ3_1312')), '.6e'), '# cLeQu3Ph1x3x1x2'],
	  [1, 3, 1, 3, format(angle(scaled_wc('lequ3_1313')), '.6e'), '# cLeQu3Ph1x3x1x3'],
	  [1, 3, 2, 1, format(angle(scaled_wc('lequ3_1321')), '.6e'), '# cLeQu3Ph1x3x2x1'],
	  [1, 3, 2, 2, format(angle(scaled_wc('lequ3_1322')), '.6e'), '# cLeQu3Ph1x3x2x2'],
	  [1, 3, 2, 3, format(angle(scaled_wc('lequ3_1323')), '.6e'), '# cLeQu3Ph1x3x2x3'],
	  [1, 3, 3, 1, format(angle(scaled_wc('lequ3_1331')), '.6e'), '# cLeQu3Ph1x3x3x1'],
	  [1, 3, 3, 2, format(angle(scaled_wc('lequ3_1332')), '.6e'), '# cLeQu3Ph1x3x3x2'],
	  [1, 3, 3, 3, format(angle(scaled_wc('lequ3_1333')), '.6e'), '# cLeQu3Ph1x3x3x3'],
	  [2, 1, 1, 1, format(angle(scaled_wc('lequ3_2111')), '.6e'), '# cLeQu3Ph2x1x1x1'],
	  [2, 1, 1, 2, format(angle(scaled_wc('lequ3_2112')), '.6e'), '# cLeQu3Ph2x1x1x2'],
	  [2, 1, 1, 3, format(angle(scaled_wc('lequ3_2113')), '.6e'), '# cLeQu3Ph2x1x1x3'],
	  [2, 1, 2, 1, format(angle(scaled_wc('lequ3_2121')), '.6e'), '# cLeQu3Ph2x1x2x1'],
	  [2, 1, 2, 2, format(angle(scaled_wc('lequ3_2122')), '.6e'), '# cLeQu3Ph2x1x2x2'],
	  [2, 1, 2, 3, format(angle(scaled_wc('lequ3_2123')), '.6e'), '# cLeQu3Ph2x1x2x3'],
	  [2, 1, 3, 1, format(angle(scaled_wc('lequ3_2131')), '.6e'), '# cLeQu3Ph2x1x3x1'],
	  [2, 1, 3, 2, format(angle(scaled_wc('lequ3_2132')), '.6e'), '# cLeQu3Ph2x1x3x2'],
	  [2, 1, 3, 3, format(angle(scaled_wc('lequ3_2133')), '.6e'), '# cLeQu3Ph2x1x3x3'],
	  [2, 2, 1, 1, format(angle(scaled_wc('lequ3_2211')), '.6e'), '# cLeQu3Ph2x2x1x1'],
	  [2, 2, 1, 2, format(angle(scaled_wc('lequ3_2212')), '.6e'), '# cLeQu3Ph2x2x1x2'],
	  [2, 2, 1, 3, format(angle(scaled_wc('lequ3_2213')), '.6e'), '# cLeQu3Ph2x2x1x3'],
	  [2, 2, 2, 1, format(angle(scaled_wc('lequ3_2221')), '.6e'), '# cLeQu3Ph2x2x2x1'],
	  [2, 2, 2, 2, format(angle(scaled_wc('lequ3_2222')), '.6e'), '# cLeQu3Ph2x2x2x2'],
	  [2, 2, 2, 3, format(angle(scaled_wc('lequ3_2223')), '.6e'), '# cLeQu3Ph2x2x2x3'],
	  [2, 2, 3, 1, format(angle(scaled_wc('lequ3_2231')), '.6e'), '# cLeQu3Ph2x2x3x1'],
	  [2, 2, 3, 2, format(angle(scaled_wc('lequ3_2232')), '.6e'), '# cLeQu3Ph2x2x3x2'],
	  [2, 2, 3, 3, format(angle(scaled_wc('lequ3_2233')), '.6e'), '# cLeQu3Ph2x2x3x3'],
	  [2, 3, 1, 1, format(angle(scaled_wc('lequ3_2311')), '.6e'), '# cLeQu3Ph2x3x1x1'],
	  [2, 3, 1, 2, format(angle(scaled_wc('lequ3_2312')), '.6e'), '# cLeQu3Ph2x3x1x2'],
	  [2, 3, 1, 3, format(angle(scaled_wc('lequ3_2313')), '.6e'), '# cLeQu3Ph2x3x1x3'],
	  [2, 3, 2, 1, format(angle(scaled_wc('lequ3_2321')), '.6e'), '# cLeQu3Ph2x3x2x1'],
	  [2, 3, 2, 2, format(angle(scaled_wc('lequ3_2322')), '.6e'), '# cLeQu3Ph2x3x2x2'],
	  [2, 3, 2, 3, format(angle(scaled_wc('lequ3_2323')), '.6e'), '# cLeQu3Ph2x3x2x3'],
	  [2, 3, 3, 1, format(angle(scaled_wc('lequ3_2331')), '.6e'), '# cLeQu3Ph2x3x3x1'],
	  [2, 3, 3, 2, format(angle(scaled_wc('lequ3_2332')), '.6e'), '# cLeQu3Ph2x3x3x2'],
	  [2, 3, 3, 3, format(angle(scaled_wc('lequ3_2333')), '.6e'), '# cLeQu3Ph2x3x3x3'],
	  [3, 1, 1, 1, format(angle(scaled_wc('lequ3_3111')), '.6e'), '# cLeQu3Ph3x1x1x1'],
	  [3, 1, 1, 2, format(angle(scaled_wc('lequ3_3112')), '.6e'), '# cLeQu3Ph3x1x1x2'],
	  [3, 1, 1, 3, format(angle(scaled_wc('lequ3_3113')), '.6e'), '# cLeQu3Ph3x1x1x3'],
	  [3, 1, 2, 1, format(angle(scaled_wc('lequ3_3121')), '.6e'), '# cLeQu3Ph3x1x2x1'],
	  [3, 1, 2, 2, format(angle(scaled_wc('lequ3_3122')), '.6e'), '# cLeQu3Ph3x1x2x2'],
	  [3, 1, 2, 3, format(angle(scaled_wc('lequ3_3123')), '.6e'), '# cLeQu3Ph3x1x2x3'],
	  [3, 1, 3, 1, format(angle(scaled_wc('lequ3_3131')), '.6e'), '# cLeQu3Ph3x1x3x1'],
	  [3, 1, 3, 2, format(angle(scaled_wc('lequ3_3132')), '.6e'), '# cLeQu3Ph3x1x3x2'],
	  [3, 1, 3, 3, format(angle(scaled_wc('lequ3_3133')), '.6e'), '# cLeQu3Ph3x1x3x3'],
	  [3, 2, 1, 1, format(angle(scaled_wc('lequ3_3211')), '.6e'), '# cLeQu3Ph3x2x1x1'],
	  [3, 2, 1, 2, format(angle(scaled_wc('lequ3_3212')), '.6e'), '# cLeQu3Ph3x2x1x2'],
	  [3, 2, 1, 3, format(angle(scaled_wc('lequ3_3213')), '.6e'), '# cLeQu3Ph3x2x1x3'],
	  [3, 2, 2, 1, format(angle(scaled_wc('lequ3_3221')), '.6e'), '# cLeQu3Ph3x2x2x1'],
	  [3, 2, 2, 2, format(angle(scaled_wc('lequ3_3222')), '.6e'), '# cLeQu3Ph3x2x2x2'],
	  [3, 2, 2, 3, format(angle(scaled_wc('lequ3_3223')), '.6e'), '# cLeQu3Ph3x2x2x3'],
	  [3, 2, 3, 1, format(angle(scaled_wc('lequ3_3231')), '.6e'), '# cLeQu3Ph3x2x3x1'],
	  [3, 2, 3, 2, format(angle(scaled_wc('lequ3_3232')), '.6e'), '# cLeQu3Ph3x2x3x2'],
	  [3, 2, 3, 3, format(angle(scaled_wc('lequ3_3233')), '.6e'), '# cLeQu3Ph3x2x3x3'],
	  [3, 3, 1, 1, format(angle(scaled_wc('lequ3_3311')), '.6e'), '# cLeQu3Ph3x3x1x1'],
	  [3, 3, 1, 2, format(angle(scaled_wc('lequ3_3312')), '.6e'), '# cLeQu3Ph3x3x1x2'],
	  [3, 3, 1, 3, format(angle(scaled_wc('lequ3_3313')), '.6e'), '# cLeQu3Ph3x3x1x3'],
	  [3, 3, 2, 1, format(angle(scaled_wc('lequ3_3321')), '.6e'), '# cLeQu3Ph3x3x2x1'],
	  [3, 3, 2, 2, format(angle(scaled_wc('lequ3_3322')), '.6e'), '# cLeQu3Ph3x3x2x2'],
	  [3, 3, 2, 3, format(angle(scaled_wc('lequ3_3323')), '.6e'), '# cLeQu3Ph3x3x2x3'],
	  [3, 3, 3, 1, format(angle(scaled_wc('lequ3_3331')), '.6e'), '# cLeQu3Ph3x3x3x1'],
	  [3, 3, 3, 2, format(angle(scaled_wc('lequ3_3332')), '.6e'), '# cLeQu3Ph3x3x3x2'],
	  [3, 3, 3, 3, format(angle(scaled_wc('lequ3_3333')), '.6e'), '# cLeQu3Ph3x3x3x3'],
      ]}

      card['Block']['FRBlock9'] = {'values': [
	  [1, 1, format(angle(scaled_wc('ephi_11')), '.6e'), '# ceHPh1x1'],
	  [1, 2, format(angle(scaled_wc('ephi_12')), '.6e'), '# ceHPh1x2'],
	  [1, 3, format(angle(scaled_wc('ephi_13')), '.6e'), '# ceHPh1x3'],
	  [2, 1, format(angle(scaled_wc('ephi_21')), '.6e'), '# ceHPh2x1'],
	  [2, 2, format(angle(scaled_wc('ephi_22')), '.6e'), '# ceHPh2x2'],
	  [2, 3, format(angle(scaled_wc('ephi_23')), '.6e'), '# ceHPh2x3'],
	  [3, 1, format(angle(scaled_wc('ephi_31')), '.6e'), '# ceHPh3x1'],
	  [3, 2, format(angle(scaled_wc('ephi_32')), '.6e'), '# ceHPh3x2'],
	  [3, 3, format(angle(scaled_wc('ephi_33')), '.6e'), '# ceHPh3x3'],
      ]}

      card['Block']['NEWCOUP'] = {'values': [
	[0, format(lambda_smeft_value, '.6e'),'# Lambda'],
	[1, format(scaled_wc('phiBox')* lambda_smeft_value**2, '.6e'), '# cHBox'],
	[2, format(scaled_wc('phiD')* lambda_smeft_value**2, '.6e'), '# cHDD'],
	[3, format(scaled_wc('phi')* lambda_smeft_value**2, '.6e'), '# cH'],
	[4, format(scaled_wc('phiB')* lambda_smeft_value**2, '.6e'), '# cHB'],
	[5, format(scaled_wc('phiW')* lambda_smeft_value**2, '.6e'), '# cHW'],
	[6, format(scaled_wc('phiWB')* lambda_smeft_value**2, '.6e'), '# cHWB'],
	[7, format(scaled_wc('phiG')* lambda_smeft_value**2, '.6e'), '# cHG'],
	[8, format(scaled_wc('W')* lambda_smeft_value**2, '.6e'), '# cW'],
	[9, format(scaled_wc('G')* lambda_smeft_value**2, '.6e'), '# cG'],
	[10, format(scaled_wc('Wtilde')* lambda_smeft_value**2, '.6e'), '# cWtil'],
	[11, format(scaled_wc('Gtilde')* lambda_smeft_value**2, '.6e'), '# cGtil'],
	[12, format(scaled_wc('phiBtilde')* lambda_smeft_value**2, '.6e'), '# cHBtil'],
	[13, format(scaled_wc('phiWtilde')* lambda_smeft_value**2, '.6e'), '# cHWtil'],
	[14, format(scaled_wc('phiWtildeB')* lambda_smeft_value**2, '.6e'), '# cHWBtil'],
	[15, format(scaled_wc('phiGtilde')* lambda_smeft_value**2, '.6e'), '# cHGtil'],
	]}

  return card




def smeftsim_card_text(model_set, input_scheme_value):
   #corrections for mw input scheme
  if input_scheme_value == 'mw':
    if model_set == 'A':
      p_list = preamble_A.split('\n')
      del p_list[9]
      p_list[2]="## PARAM_CARD FOR SMEFTSIM SET A v2.0 - FLAVOR_GENERAL MW_INPUTS  ########"
      p_list[32]="24 80.387000 # W+ : MW0"
      p_list[35]="9000003 80.387000 # ghWp : MW0"
      p_list[36]="9000004 80.387000 # ghWm : MW0"
      p_list[41]="251 80.387000 # G+ : MW0"
      preamble = '\n'.join(p_list)
      postamble = postamble_A

    elif model_set == 'B':
      p_list = preamble_B.split('\n')
      del p_list[9], p_list[32], p_list[34], p_list[34], p_list[38]
      p_list[2]="## PARAM_CARD FOR SMEFTSIM SET B  - FLAVOR_GENERAL MW_INPUTS  ########"
      p_list[10]="    3 1.185000e-01 # aS"
      p_list.insert(26, "   24 8.038700e+01 # MW")
      p_list.insert(40, "   9000003 80.387000 # ghWp : MW" )
      p_list.insert(41, "   9000004 80.387000 # ghWm : MW" )
      p_list.insert(43, "   251 80.387000 # G+ : MW")
      preamble = '\n'.join(p_list)
      postamble = postamble_B

  elif input_scheme_value == 'alpha':
    if model_set == 'A':
      preamble = preamble_A
      postamble = postamble_A
    elif model_set == 'B':
      preamble = preamble_B
      postamble = postamble_B


  return preamble, postamble
