from math import sqrt, log, exp, pi
from numpy import einsum
import numpy as np
import ckmutil


Nc = 3
cf = 4 / 3
kd = np.eye(3)
kdt = np.array([[0, 0, 0], [0, 0, 0], [0, 0, 1]])
one = np.ones(3)
aEvan = bEvan = cEvan = dEvan = eEvan = 1


def _match_all_array(_C, par, scale):

    C = _C.copy()

    # AUXILIARY FUNCTIONS

    mW = par['m_W']
    GF = par['GF']
    GFx = GF - sqrt(2)/4 * ( -C['ll'][1,0,0,1] - C['ll'][0,1,1,0] + 2*C['phil3'][1,1] + 2*C['phil3'][0,0] )

    vT = sqrt(1/sqrt(2)/abs(GFx))
    eps = C["phiWB"] * vT**2
    g2b = 2*par["m_W"]/vT

    alpha_e = par['alpha_e']
    eb = sqrt(4*pi*alpha_e)
    g1b = eb*g2b/sqrt(g2b**2-eb**2) + eb**2*g2b/(g2b**2-eb**2) * eps

    mZ = sqrt(vT**2 / 4 * (1 + vT**2 / 2 * C["phiD"]) * (g2b**2 + g1b**2) + vT**2 / 2 * eps * g1b * g2b)
    mH = 125
    mt = 173
    mu = np.array([par['m_u'], par['m_c'], par['m_t']])
    md = np.array([par['m_d'], par['m_s'], par['m_b']])
    me = np.array([par['m_e'], par['m_mu'], par['m_tau']])

    g1bar = g1b
    g2bar = g2b
    g3bar = sqrt(4*pi*par['alpha_s'])

    # DEFINE DAGGERED WCs
    for _f in 'ude':
        for _b in ['B', 'G', 'phi', 'W' ]:
            if _f + _b in C:
                C[_f + _b + 'Dag'] = C[_f + _b].conjugate().T
    C['phiudDag'] = C['phiud'].conjugate().T
    C['ledqDag'] = einsum('rpts', C['ledq']).conjugate()
    C['lequ1Dag'] = einsum('rpts', C['lequ1']).conjugate()
    C['lequ3Dag'] = einsum('rpts', C['lequ3']).conjugate()
    C['quqd1Dag'] = einsum('rpts', C['quqd1']).conjugate()
    C['quqd8Dag'] = einsum('rpts', C['quqd8']).conjugate()

    # MATCHING CONDITIONS
    c = {}

    # 3-gluon
    c['Gtilde'] = (-(g3bar**2*C["Gtilde"]*log(scale**2/mt**2))/(16.*pi**2) + (g3bar**2*vT*complex(0,1)*C["uG"][2,2])/(96.*sqrt(2)*mt*pi**2) - (g3bar**2*vT*complex(0,1)*C["uGDag"][2,2])/(96.*sqrt(2)*mt*pi**2))
    c['G'] = (g3bar**3/(2880.*mt**2*pi**2) - (g3bar**2*C["G"]*log(scale**2/mt**2))/(16.*pi**2) - (g3bar**2*vT*C["uG"][2,2])/(96.*sqrt(2)*mt*pi**2) - (g3bar**2*vT*C["uGDag"][2,2])/(96.*sqrt(2)*mt*pi**2))

    # 4-fermi: here we don't need any CKM as we're  working in the up basis on both sides
    c['SduuLL'] = ((5*mW**2*einsum("prst",C["qqql"]))/(8.*pi**2*vT**2) - (3*mW**2*einsum("psrt",C["qqql"]))/(4.*pi**2*vT**2) - (mW**2*einsum("rpst",C["qqql"]))/(9.*pi**2*vT**2) - (mW**4*einsum("rpst",C["qqql"]))/(36.*mZ**2*pi**2*vT**2) + (11*mZ**2*einsum("rpst",C["qqql"]))/(144.*pi**2*vT**2) + (7*mW**2*einsum("rspt",C["qqql"]))/(36.*pi**2*vT**2) - (13*mW**4*einsum("rspt",C["qqql"]))/(72.*mZ**2*pi**2*vT**2) - (11*mZ**2*einsum("rspt",C["qqql"]))/(144.*pi**2*vT**2) + (mW**2*einsum("sprt",C["qqql"]))/(4.*pi**2*vT**2) + (5*mW**4*einsum("sprt",C["qqql"]))/(4.*mZ**2*pi**2*vT**2) + (5*mW**2*einsum("srpt",C["qqql"]))/(9.*pi**2*vT**2) + (13*mW**4*einsum("srpt",C["qqql"]))/(72.*mZ**2*pi**2*vT**2) + (11*mZ**2*einsum("srpt",C["qqql"]))/(144.*pi**2*vT**2) + (3*mt**4*einsum("rsTt,pT,TT",C["qqql"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt**2*mW**2*einsum("rsTt,pT,TT",C["qqql"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("rTst,pT,TT",C["qqql"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("rTst,pT,TT",C["qqql"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("srTt,pT,TT",C["qqql"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("srTt,pT,TT",C["qqql"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**6*einsum("rsTt,pT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("rsTt,pT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("rTst,pT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("rTst,pT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("srTt,pT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**4*mW**2*einsum("srTt,pT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("srTt,pT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**2*einsum("sTrt,pT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/((4*mt**2 - 4*mW**2)*pi**2*vT**2) + (mt**2*mW**2*einsum("Trst,pT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/((2*mt**2 - 2*mW**2)*pi**2*vT**2) - (mt**2*mW**2*einsum("Tsrt,pT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/(4.*(mt**2 - mW**2)*pi**2*vT**2) + (mW**2*einsum("prst",C["qqql"])*log(scale**2/mW**2))/(pi**2*vT**2) - (mW**2*einsum("psrt",C["qqql"])*log(scale**2/mW**2))/(2.*pi**2*vT**2) - (mW**2*einsum("rpst",C["qqql"])*log(scale**2/mW**2))/(4.*pi**2*vT**2) + (mW**2*einsum("rspt",C["qqql"])*log(scale**2/mW**2))/(4.*pi**2*vT**2) + (mW**2*einsum("sprt",C["qqql"])*log(scale**2/mW**2))/(2.*pi**2*vT**2) + (mW**2*einsum("srpt",C["qqql"])*log(scale**2/mW**2))/(4.*pi**2*vT**2) - (mt**4*mW**2*einsum("rsTt,pT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("rsTt,pT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("rTst,pT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("rTst,pT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("srTt,pT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (7*mt**2*mW**4*einsum("srTt,pT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**2*einsum("sTrt,pT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/(4.*(mt**2 - mW**2)*pi**2*vT**2) - (mt**2*mW**2*einsum("Trst,pT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/(2.*(mt**2 - mW**2)*pi**2*vT**2) + (mt**2*mW**2*einsum("Tsrt,pT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/((4*mt**2 - 4*mW**2)*pi**2*vT**2) - (mW**2*einsum("rpst",C["qqql"])*log(scale**2/mZ**2))/(6.*pi**2*vT**2) + (mW**4*einsum("rpst",C["qqql"])*log(scale**2/mZ**2))/(4.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("rpst",C["qqql"])*log(scale**2/mZ**2))/(24.*pi**2*vT**2) - (mW**2*einsum("rspt",C["qqql"])*log(scale**2/mZ**2))/(6.*pi**2*vT**2) + (7*mW**4*einsum("rspt",C["qqql"])*log(scale**2/mZ**2))/(12.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("rspt",C["qqql"])*log(scale**2/mZ**2))/(24.*pi**2*vT**2) - (mW**2*einsum("sprt",C["qqql"])*log(scale**2/mZ**2))/(3.*pi**2*vT**2) + (5*mW**4*einsum("sprt",C["qqql"])*log(scale**2/mZ**2))/(6.*mZ**2*pi**2*vT**2) + (mW**2*einsum("srpt",C["qqql"])*log(scale**2/mZ**2))/(6.*pi**2*vT**2) - (7*mW**4*einsum("srpt",C["qqql"])*log(scale**2/mZ**2))/(12.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("srpt",C["qqql"])*log(scale**2/mZ**2))/(24.*pi**2*vT**2))
    c['SuddLL'] = ((5*mW**2*einsum("prst",C["qqql"]))/(8.*pi**2*vT**2) - (3*mW**2*einsum("psrt",C["qqql"]))/(4.*pi**2*vT**2) - (7*mW**2*einsum("rpst",C["qqql"]))/(36.*pi**2*vT**2) + (mW**4*einsum("rpst",C["qqql"]))/(18.*mZ**2*pi**2*vT**2) + (11*mZ**2*einsum("rpst",C["qqql"]))/(144.*pi**2*vT**2) + (mW**2*einsum("rspt",C["qqql"]))/(9.*pi**2*vT**2) - (7*mW**4*einsum("rspt",C["qqql"]))/(72.*mZ**2*pi**2*vT**2) - (11*mZ**2*einsum("rspt",C["qqql"]))/(144.*pi**2*vT**2) + (5*mW**2*einsum("sprt",C["qqql"]))/(4.*pi**2*vT**2) + (mW**4*einsum("sprt",C["qqql"]))/(4.*mZ**2*pi**2*vT**2) + (23*mW**2*einsum("srpt",C["qqql"]))/(36.*pi**2*vT**2) + (7*mW**4*einsum("srpt",C["qqql"]))/(72.*mZ**2*pi**2*vT**2) + (11*mZ**2*einsum("srpt",C["qqql"]))/(144.*pi**2*vT**2) - (3*mt**4*einsum("rpTt,sT,TT",C["qqql"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("rpTt,sT,TT",C["qqql"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt**4*einsum("rTpt,sT,TT",C["qqql"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt**2*mW**2*einsum("rTpt,sT,TT",C["qqql"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("sTpt,rT,TT",C["qqql"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("sTpt,rT,TT",C["qqql"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("Tpst,rT,TT",C["qqql"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("Tpst,rT,TT",C["qqql"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("Trpt,sT,TT",C["qqql"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("Trpt,sT,TT",C["qqql"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt**4*einsum("Tspt,rT,TT",C["qqql"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt**2*mW**2*einsum("Tspt,rT,TT",C["qqql"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**2*mW**2*einsum("prTt,sT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/((2*mt**2 - 2*mW**2)*pi**2*vT**2) - (mt**2*mW**2*einsum("psTt,rT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/(4.*(mt**2 - mW**2)*pi**2*vT**2) - (mt**2*mW**2*einsum("pTrt,sT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/(4.*(mt**2 - mW**2)*pi**2*vT**2) + (mt**2*mW**2*einsum("pTst,rT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/((2*mt**2 - 2*mW**2)*pi**2*vT**2) - (mt**6*einsum("rpTt,sT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("rpTt,sT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*einsum("rTpt,sT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("rTpt,sT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**2*einsum("spTt,rT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/((4*mt**2 - 4*mW**2)*pi**2*vT**2) - (mt**6*einsum("sTpt,rT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**4*mW**2*einsum("sTpt,rT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("sTpt,rT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**2*einsum("Tprt,sT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/((4*mt**2 - 4*mW**2)*pi**2*vT**2) - (mt**6*einsum("Tpst,rT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("Tpst,rT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("Trpt,sT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**4*mW**2*einsum("Trpt,sT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("Trpt,sT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*einsum("Tspt,rT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("Tspt,rT,TT",C["qqql"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mW**2*einsum("prst",C["qqql"])*log(scale**2/mW**2))/(pi**2*vT**2) - (mW**2*einsum("psrt",C["qqql"])*log(scale**2/mW**2))/(2.*pi**2*vT**2) - (mW**2*einsum("rpst",C["qqql"])*log(scale**2/mW**2))/(4.*pi**2*vT**2) + (mW**2*einsum("rspt",C["qqql"])*log(scale**2/mW**2))/(4.*pi**2*vT**2) + (mW**2*einsum("sprt",C["qqql"])*log(scale**2/mW**2))/(2.*pi**2*vT**2) + (mW**2*einsum("srpt",C["qqql"])*log(scale**2/mW**2))/(4.*pi**2*vT**2) - (mt**2*mW**2*einsum("prTt,sT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/(2.*(mt**2 - mW**2)*pi**2*vT**2) + (mt**2*mW**2*einsum("psTt,rT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/((4*mt**2 - 4*mW**2)*pi**2*vT**2) + (mt**2*mW**2*einsum("pTrt,sT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/((4*mt**2 - 4*mW**2)*pi**2*vT**2) - (mt**2*mW**2*einsum("pTst,rT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/(2.*(mt**2 - mW**2)*pi**2*vT**2) + (mt**4*mW**2*einsum("rpTt,sT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("rpTt,sT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("rTpt,sT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("rTpt,sT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**2*einsum("spTt,rT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/(4.*(mt**2 - mW**2)*pi**2*vT**2) - (mt**4*mW**2*einsum("sTpt,rT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (7*mt**2*mW**4*einsum("sTpt,rT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**2*einsum("Tprt,sT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/(4.*(mt**2 - mW**2)*pi**2*vT**2) + (mt**4*mW**2*einsum("Tpst,rT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("Tpst,rT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("Trpt,sT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (7*mt**2*mW**4*einsum("Trpt,sT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("Tspt,rT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("Tspt,rT,TT",C["qqql"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mW**4*einsum("rpst",C["qqql"])*log(scale**2/mZ**2))/(12.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("rpst",C["qqql"])*log(scale**2/mZ**2))/(24.*pi**2*vT**2) + (mW**2*einsum("rspt",C["qqql"])*log(scale**2/mZ**2))/(3.*pi**2*vT**2) + (mW**4*einsum("rspt",C["qqql"])*log(scale**2/mZ**2))/(12.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("rspt",C["qqql"])*log(scale**2/mZ**2))/(24.*pi**2*vT**2) + (mW**2*einsum("sprt",C["qqql"])*log(scale**2/mZ**2))/(3.*pi**2*vT**2) + (mW**4*einsum("sprt",C["qqql"])*log(scale**2/mZ**2))/(6.*mZ**2*pi**2*vT**2) - (mW**2*einsum("srpt",C["qqql"])*log(scale**2/mZ**2))/(3.*pi**2*vT**2) - (mW**4*einsum("srpt",C["qqql"])*log(scale**2/mZ**2))/(12.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("srpt",C["qqql"])*log(scale**2/mZ**2))/(24.*pi**2*vT**2))
    c['SduuLR'] = ((7*mW**2*einsum("prst",C["qque"]))/(9.*pi**2*vT**2) + (5*aEvan*mW**2*einsum("prst",C["qque"]))/(12.*pi**2*vT**2) - (29*mW**4*einsum("prst",C["qque"]))/(36.*mZ**2*pi**2*vT**2) - (5*aEvan*mW**4*einsum("prst",C["qque"]))/(12.*mZ**2*pi**2*vT**2) - (127*mZ**2*einsum("prst",C["qque"]))/(288.*pi**2*vT**2) + (7*mW**2*einsum("rpst",C["qque"]))/(9.*pi**2*vT**2) + (5*aEvan*mW**2*einsum("rpst",C["qque"]))/(12.*pi**2*vT**2) - (29*mW**4*einsum("rpst",C["qque"]))/(36.*mZ**2*pi**2*vT**2) - (5*aEvan*mW**4*einsum("rpst",C["qque"]))/(12.*mZ**2*pi**2*vT**2) - (127*mZ**2*einsum("rpst",C["qque"]))/(288.*pi**2*vT**2) + (3*mt**4*einsum("rTst,pT,TT",C["qque"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt**2*mW**2*einsum("rTst,pT,TT",C["qque"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt**4*einsum("Trst,pT,TT",C["qque"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt**2*mW**2*einsum("Trst,pT,TT",C["qque"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**6*einsum("rTst,pT,TT",C["qque"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (7*mt**4*mW**2*einsum("rTst,pT,TT",C["qque"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("rTst,pT,TT",C["qque"],kd,kdt)*log(scale**2/mt**2))/(2.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*einsum("Trst,pT,TT",C["qque"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (7*mt**4*mW**2*einsum("Trst,pT,TT",C["qque"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("Trst,pT,TT",C["qque"],kd,kdt)*log(scale**2/mt**2))/(2.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mW**2*einsum("prst",C["qque"])*log(scale**2/mW**2))/(8.*pi**2*vT**2) - (3*mW**2*einsum("rpst",C["qque"])*log(scale**2/mW**2))/(8.*pi**2*vT**2) + (3*mt**4*mW**2*einsum("rTst,pT,TT",C["qque"],kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (15*mt**2*mW**4*einsum("rTst,pT,TT",C["qque"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**4*mW**2*einsum("Trst,pT,TT",C["qque"],kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (15*mt**2*mW**4*einsum("Trst,pT,TT",C["qque"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (23*mW**2*einsum("prst",C["qque"])*log(scale**2/mZ**2))/(24.*pi**2*vT**2) - (2*mW**4*einsum("prst",C["qque"])*log(scale**2/mZ**2))/(3.*mZ**2*pi**2*vT**2) - (23*mZ**2*einsum("prst",C["qque"])*log(scale**2/mZ**2))/(48.*pi**2*vT**2) + (23*mW**2*einsum("rpst",C["qque"])*log(scale**2/mZ**2))/(24.*pi**2*vT**2) - (2*mW**4*einsum("rpst",C["qque"])*log(scale**2/mZ**2))/(3.*mZ**2*pi**2*vT**2) - (23*mZ**2*einsum("rpst",C["qque"])*log(scale**2/mZ**2))/(48.*pi**2*vT**2))
    c['SdudRL'] = ((-7*mW**2*einsum("prst",C["duql"]))/(72.*pi**2*vT**2) - (aEvan*mW**2*einsum("prst",C["duql"]))/(12.*pi**2*vT**2) - (2*mW**4*einsum("prst",C["duql"]))/(9.*mZ**2*pi**2*vT**2) - (aEvan*mW**4*einsum("prst",C["duql"]))/(12.*mZ**2*pi**2*vT**2) - (43*mZ**2*einsum("prst",C["duql"]))/(288.*pi**2*vT**2) + (aEvan*mZ**2*einsum("prst",C["duql"]))/(6.*pi**2*vT**2) + (3*mt**4*einsum("prTt,sT,TT",C["duql"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt**2*mW**2*einsum("prTt,sT,TT",C["duql"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**6*einsum("prTt,sT,TT",C["duql"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (7*mt**4*mW**2*einsum("prTt,sT,TT",C["duql"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("prTt,sT,TT",C["duql"],kd,kdt)*log(scale**2/mt**2))/(2.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mW**2*einsum("prst",C["duql"])*log(scale**2/mW**2))/(8.*pi**2*vT**2) + (3*mt**4*mW**2*einsum("prTt,sT,TT",C["duql"],kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (15*mt**2*mW**4*einsum("prTt,sT,TT",C["duql"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (5*mW**2*einsum("prst",C["duql"])*log(scale**2/mZ**2))/(24.*pi**2*vT**2) - (mW**4*einsum("prst",C["duql"])*log(scale**2/mZ**2))/(6.*mZ**2*pi**2*vT**2) - (11*mZ**2*einsum("prst",C["duql"])*log(scale**2/mZ**2))/(48.*pi**2*vT**2))
    c['SduuRL'] = ((-47*mW**2*einsum("prst",C["duql"]))/(72.*pi**2*vT**2) - (7*aEvan*mW**2*einsum("prst",C["duql"]))/(12.*pi**2*vT**2) + (29*mW**4*einsum("prst",C["duql"]))/(36.*mZ**2*pi**2*vT**2) + (5*aEvan*mW**4*einsum("prst",C["duql"]))/(12.*mZ**2*pi**2*vT**2) + (91*mZ**2*einsum("prst",C["duql"]))/(288.*pi**2*vT**2) + (aEvan*mZ**2*einsum("prst",C["duql"]))/(6.*pi**2*vT**2) + (3*mW**2*einsum("prst",C["duql"])*log(scale**2/mW**2))/(8.*pi**2*vT**2) - (17*mW**2*einsum("prst",C["duql"])*log(scale**2/mZ**2))/(24.*pi**2*vT**2) + (2*mW**4*einsum("prst",C["duql"])*log(scale**2/mZ**2))/(3.*mZ**2*pi**2*vT**2) + (11*mZ**2*einsum("prst",C["duql"])*log(scale**2/mZ**2))/(48.*pi**2*vT**2))
    c['SduuRR'] = ((mW**2*einsum("prst",C["duue"]))/(18.*pi**2*vT**2) - (mW**4*einsum("prst",C["duue"]))/(36.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("prst",C["duue"]))/(36.*pi**2*vT**2) - (5*mW**2*einsum("psrt",C["duue"]))/(2.*pi**2*vT**2) + (5*mW**4*einsum("psrt",C["duue"]))/(4.*mZ**2*pi**2*vT**2) + (5*mZ**2*einsum("psrt",C["duue"]))/(4.*pi**2*vT**2) - (mW**2*einsum("prst",C["duue"])*log(scale**2/mZ**2))/(2.*pi**2*vT**2) + (mW**4*einsum("prst",C["duue"])*log(scale**2/mZ**2))/(4.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("prst",C["duue"])*log(scale**2/mZ**2))/(4.*pi**2*vT**2) - (5*mW**2*einsum("psrt",C["duue"])*log(scale**2/mZ**2))/(3.*pi**2*vT**2) + (5*mW**4*einsum("psrt",C["duue"])*log(scale**2/mZ**2))/(6.*mZ**2*pi**2*vT**2) + (5*mZ**2*einsum("psrt",C["duue"])*log(scale**2/mZ**2))/(6.*pi**2*vT**2))
    c['V1udLL'] = ((5*mW**2*einsum("prst",C["qq1"]))/(24.*pi**2*vT**2) - (bEvan*mW**2*einsum("prst",C["qq1"]))/(18.*pi**2*vT**2) + (5*mW**4*einsum("prst",C["qq1"]))/(6.*mZ**2*pi**2*vT**2) - (2*bEvan*mW**4*einsum("prst",C["qq1"]))/(9.*mZ**2*pi**2*vT**2) - (5*mZ**2*einsum("prst",C["qq1"]))/(48.*pi**2*vT**2) + (bEvan*mZ**2*einsum("prst",C["qq1"]))/(36.*pi**2*vT**2) - (83*mW**2*einsum("prst",C["qq3"]))/(24.*pi**2*vT**2) + (5*bEvan*mW**2*einsum("prst",C["qq3"]))/(9.*pi**2*vT**2) - (5*mW**4*einsum("prst",C["qq3"]))/(6.*mZ**2*pi**2*vT**2) + (2*bEvan*mW**4*einsum("prst",C["qq3"]))/(9.*mZ**2*pi**2*vT**2) + (5*mZ**2*einsum("prst",C["qq3"]))/(48.*pi**2*vT**2) - (bEvan*mZ**2*einsum("prst",C["qq3"]))/(36.*pi**2*vT**2) - (15*mW**2*einsum("ptsr",C["qq1"]))/(8.*Nc*pi**2*vT**2) + (bEvan*mW**2*einsum("ptsr",C["qq1"]))/(2.*Nc*pi**2*vT**2) + (43*mW**2*einsum("ptsr",C["qq3"]))/(24.*Nc*pi**2*vT**2) - (bEvan*mW**2*einsum("ptsr",C["qq3"]))/(9.*Nc*pi**2*vT**2) + (7*mW**4*einsum("ptsr",C["qq3"]))/(6.*mZ**2*Nc*pi**2*vT**2) + (bEvan*mW**4*einsum("ptsr",C["qq3"]))/(18.*mZ**2*Nc*pi**2*vT**2) - (5*mZ**2*einsum("ptsr",C["qq3"]))/(24.*Nc*pi**2*vT**2) + (bEvan*mZ**2*einsum("ptsr",C["qq3"]))/(18.*Nc*pi**2*vT**2) - (15*mW**2*einsum("srpt",C["qq1"]))/(8.*Nc*pi**2*vT**2) + (bEvan*mW**2*einsum("srpt",C["qq1"]))/(2.*Nc*pi**2*vT**2) + (43*mW**2*einsum("srpt",C["qq3"]))/(24.*Nc*pi**2*vT**2) - (bEvan*mW**2*einsum("srpt",C["qq3"]))/(9.*Nc*pi**2*vT**2) + (7*mW**4*einsum("srpt",C["qq3"]))/(6.*mZ**2*Nc*pi**2*vT**2) + (bEvan*mW**4*einsum("srpt",C["qq3"]))/(18.*mZ**2*Nc*pi**2*vT**2) - (5*mZ**2*einsum("srpt",C["qq3"]))/(24.*Nc*pi**2*vT**2) + (bEvan*mZ**2*einsum("srpt",C["qq3"]))/(18.*Nc*pi**2*vT**2) + (5*mW**2*einsum("stpr",C["qq1"]))/(24.*pi**2*vT**2) - (bEvan*mW**2*einsum("stpr",C["qq1"]))/(18.*pi**2*vT**2) + (5*mW**4*einsum("stpr",C["qq1"]))/(6.*mZ**2*pi**2*vT**2) - (2*bEvan*mW**4*einsum("stpr",C["qq1"]))/(9.*mZ**2*pi**2*vT**2) - (5*mZ**2*einsum("stpr",C["qq1"]))/(48.*pi**2*vT**2) + (bEvan*mZ**2*einsum("stpr",C["qq1"]))/(36.*pi**2*vT**2) - (83*mW**2*einsum("stpr",C["qq3"]))/(24.*pi**2*vT**2) + (5*bEvan*mW**2*einsum("stpr",C["qq3"]))/(9.*pi**2*vT**2) - (5*mW**4*einsum("stpr",C["qq3"]))/(6.*mZ**2*pi**2*vT**2) + (2*bEvan*mW**4*einsum("stpr",C["qq3"]))/(9.*mZ**2*pi**2*vT**2) + (5*mZ**2*einsum("stpr",C["qq3"]))/(48.*pi**2*vT**2) - (bEvan*mZ**2*einsum("stpr",C["qq3"]))/(36.*pi**2*vT**2) + (7*mH**2*einsum("pr,st",kd,kd))/(288.*pi**2*vT**4) + (87991*mW**2*einsum("pr,st",kd,kd))/(58320.*pi**2*vT**4) - (2*bEvan*mW**2*einsum("pr,st",kd,kd))/(81.*pi**2*vT**4) - (mW**4*einsum("pr,st",kd,kd))/(12.*mH**2*pi**2*vT**4) + (502*mW**8*einsum("pr,st",kd,kd))/(729.*mZ**6*pi**2*vT**4) - (16*bEvan*mW**8*einsum("pr,st",kd,kd))/(81.*mZ**6*pi**2*vT**4) - (7*mH**2*mW**4*einsum("pr,st",kd,kd))/(36.*mZ**4*pi**2*vT**4) - (878*mW**6*einsum("pr,st",kd,kd))/(1215.*mZ**4*pi**2*vT**4) + (4*bEvan*mW**6*einsum("pr,st",kd,kd))/(27.*mZ**4*pi**2*vT**4) - (2*mW**8*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**4) - (7*mH**2*mW**2*einsum("pr,st",kd,kd))/(144.*mZ**2*pi**2*vT**4) - (1171*mW**4*einsum("pr,st",kd,kd))/(4860.*mZ**2*pi**2*vT**4) + (2*bEvan*mW**4*einsum("pr,st",kd,kd))/(27.*mZ**2*pi**2*vT**4) - (mW**6*einsum("pr,st",kd,kd))/(18.*mH**2*mZ**2*pi**2*vT**4) - (13*mZ**2*einsum("pr,st",kd,kd))/(864.*pi**2*vT**4) - (mW**2*mZ**2*einsum("pr,st",kd,kd))/(36.*mH**2*pi**2*vT**4) + (mZ**4*einsum("pr,st",kd,kd))/(72.*mH**2*pi**2*vT**4) - (mt**4*Nc*einsum("pr,st",kd,kd))/(18.*mH**2*pi**2*vT**4) + (32*mW**4*Nc*einsum("pr,st",kd,kd))/(1215.*mt**2*pi**2*vT**4) + (4*mt**4*mW**4*Nc*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**4) + (32*mW**8*Nc*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**4*pi**2*vT**4) + (mt**4*mW**2*Nc*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**2*pi**2*vT**4) - (64*mW**6*Nc*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**2*pi**2*vT**4) - (C["phi"]*einsum("pr,st",kd,kd))/(24.*pi**2) + (mW**4*C["phi"]*einsum("pr,st",kd,kd))/(3.*mZ**4*pi**2) + (mW**2*C["phi"]*einsum("pr,st",kd,kd))/(12.*mZ**2*pi**2) + (mH**2*mW**2*C["phiB"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (41*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(36.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (5*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (4*mH**4*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (8*mW**10*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (7*mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (2*mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (7*mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (8*mW**10*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**2*C["phiB"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (7*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (11*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (7*mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (5*mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(36.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (5*mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(36.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mZ**6*C["phiB"]*einsum("pr,st",kd,kd))/(36.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (2*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (16*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (14*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (16*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (14*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (11*mH**2*C["phiBox"]*einsum("pr,st",kd,kd))/(144.*pi**2*vT**2) + (5*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(72.*pi**2*vT**2) - (mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(6.*mH**2*pi**2*vT**2) - (11*mH**2*mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(18.*mZ**4*pi**2*vT**2) - (4*mW**8*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) - (11*mH**2*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(72.*mZ**2*pi**2*vT**2) + (5*mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(18.*mZ**2*pi**2*vT**2) - (mW**6*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**2*pi**2*vT**2) - (5*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(144.*pi**2*vT**2) - (mW**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(18.*mH**2*pi**2*vT**2) + (mZ**4*C["phiBox"]*einsum("pr,st",kd,kd))/(36.*mH**2*pi**2*vT**2) - (mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*pi**2*vT**2) + (8*mt**4*mW**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**2*pi**2*vT**2) - (mH**2*C["phiD"]*einsum("pr,st",kd,kd))/(36.*pi**2*vT**2) - (455*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(23328.*pi**2*vT**2) + (bEvan*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(81.*pi**2*vT**2) - (mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(8.*mH**2*pi**2*vT**2) + (502*mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(729.*mZ**6*pi**2*vT**2) - (16*bEvan*mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(81.*mZ**6*pi**2*vT**2) + (mH**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(36.*mZ**4*pi**2*vT**2) - (673*mW**6*C["phiD"]*einsum("pr,st",kd,kd))/(1215.*mZ**4*pi**2*vT**2) + (2*bEvan*mW**6*C["phiD"]*einsum("pr,st",kd,kd))/(27.*mZ**4*pi**2*vT**2) - (mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) + (mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(32.*mZ**2*pi**2*vT**2) + (223*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(3240.*mZ**2*pi**2*vT**2) - (mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(432.*pi**2*vT**2) - (mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(72.*mH**2*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(36.*mH**2*pi**2*vT**2) + (2*mt**4*mW**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) + (32*mW**8*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**4*pi**2*vT**2) - (32*mW**6*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**2*pi**2*vT**2) - (mH**2*mW**2*C["phiW"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (35*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(36.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (4*mH**4*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (8*mW**10*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (7*mH**4*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (2*mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (mW**8*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (8*mW**10*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**2*C["phiW"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (7*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (4*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mW**8*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (7*mW**4*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(18.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**2*mZ**4*C["phiW"]*einsum("pr,st",kd,kd))/(12.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (16*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (14*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (16*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (2*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (14*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (7*g1bar*mH**2*mW*C["phiWB"]*einsum("pr,st",kd,kd))/(432.*(mH - mZ)*(mH + mZ)*pi**2*vT) + (6631*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(29160.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (4*bEvan*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) - (2*g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (680*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(729.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) - (32*bEvan*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) - (4*g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) - (g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (1801*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(7290.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (10*bEvan*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (1441*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(1458.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (32*bEvan*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (4*g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (g1bar*mH**4*mW*C["phiWB"]*einsum("pr,st",kd,kd))/(96.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (2581*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(29160.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (4*bEvan*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (629*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(7290.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (10*bEvan*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(18.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (19*g1bar*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(864.*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(18.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) - (g1bar*mW*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd))/(72.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) + (64*g1bar*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*mt**2*(mH - mZ)*(mH + mZ)*pi**2*vT) + (8*g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (8*g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (64*g1bar*mH**2*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*mt**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (64*g1bar*mH**2*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*mt**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (64*g1bar*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*mt**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (mW**3*C["W"]*einsum("pr,st",kd,kd))/(6.*pi**2*vT**3) - (4*mW**7*C["W"]*einsum("pr,st",kd,kd))/(3.*mZ**4*pi**2*vT**3) + (7*mW**5*C["W"]*einsum("pr,st",kd,kd))/(6.*mZ**2*pi**2*vT**3) + (121*mW**2*einsum("pr,st",C["phiq1"],kd))/(486.*pi**2*vT**2) - (2*bEvan*mW**2*einsum("pr,st",C["phiq1"],kd))/(27.*pi**2*vT**2) - (190*mW**6*einsum("pr,st",C["phiq1"],kd))/(243.*mZ**4*pi**2*vT**2) + (4*bEvan*mW**6*einsum("pr,st",C["phiq1"],kd))/(27.*mZ**4*pi**2*vT**2) + (35*mW**4*einsum("pr,st",C["phiq1"],kd))/(243.*mZ**2*pi**2*vT**2) - (2*bEvan*mW**4*einsum("pr,st",C["phiq1"],kd))/(27.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("pr,st",C["phiq1"],kd))/(72.*pi**2*vT**2) + (4229*mW**2*einsum("pr,st",C["phiq3"],kd))/(1944.*pi**2*vT**2) + (2*bEvan*mW**2*einsum("pr,st",C["phiq3"],kd))/(27.*pi**2*vT**2) + (190*mW**6*einsum("pr,st",C["phiq3"],kd))/(243.*mZ**4*pi**2*vT**2) - (4*bEvan*mW**6*einsum("pr,st",C["phiq3"],kd))/(27.*mZ**4*pi**2*vT**2) - (431*mW**4*einsum("pr,st",C["phiq3"],kd))/(972.*mZ**2*pi**2*vT**2) + (2*bEvan*mW**4*einsum("pr,st",C["phiq3"],kd))/(27.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("pr,st",C["phiq3"],kd))/(72.*pi**2*vT**2) + (mt**2*einsum("pt,sr",kd,kd))/(8.*pi**2*vT**4) - (mt**4*einsum("pt,sr",kd,kd))/(mH**2*pi**2*vT**4) + (7*mH**2*einsum("pt,sr",kd,kd))/(16.*Nc*pi**2*vT**4) + (13*mW**2*einsum("pt,sr",kd,kd))/(24.*Nc*pi**2*vT**4) + (bEvan*mW**2*einsum("pt,sr",kd,kd))/(18.*Nc*pi**2*vT**4) + (mW**4*einsum("pt,sr",kd,kd))/(2.*mH**2*Nc*pi**2*vT**4) - (7*mW**4*einsum("pt,sr",kd,kd))/(6.*mZ**2*Nc*pi**2*vT**4) - (bEvan*mW**4*einsum("pt,sr",kd,kd))/(18.*mZ**2*Nc*pi**2*vT**4) - (5*mZ**2*einsum("pt,sr",kd,kd))/(16.*Nc*pi**2*vT**4) + (mZ**4*einsum("pt,sr",kd,kd))/(4.*mH**2*Nc*pi**2*vT**4) - (15*g3bar**2*einsum("pt,sr",kd,kd))/(16.*pi**2*vT**2) + (bEvan*g3bar**2*einsum("pt,sr",kd,kd))/(4.*pi**2*vT**2) + (15*g3bar**2*einsum("pt,sr",kd,kd))/(16.*Nc**2*pi**2*vT**2) - (bEvan*g3bar**2*einsum("pt,sr",kd,kd))/(4.*Nc**2*pi**2*vT**2) - (3*C["phi"]*einsum("pt,sr",kd,kd))/(4.*Nc*pi**2) - (mW**2*mZ**2*C["phiB"]*einsum("pt,sr",kd,kd))/(2.*mH**2*Nc*pi**2*vT**2) + (mZ**4*C["phiB"]*einsum("pt,sr",kd,kd))/(2.*mH**2*Nc*pi**2*vT**2) - (2*mt**4*C["phiBox"]*einsum("pt,sr",kd,kd))/(mH**2*pi**2*vT**2) + (11*mH**2*C["phiBox"]*einsum("pt,sr",kd,kd))/(8.*Nc*pi**2*vT**2) - (5*mW**2*C["phiBox"]*einsum("pt,sr",kd,kd))/(8.*Nc*pi**2*vT**2) + (mW**4*C["phiBox"]*einsum("pt,sr",kd,kd))/(mH**2*Nc*pi**2*vT**2) + (mZ**4*C["phiBox"]*einsum("pt,sr",kd,kd))/(2.*mH**2*Nc*pi**2*vT**2) + (mt**4*C["phiD"]*einsum("pt,sr",kd,kd))/(2.*mH**2*pi**2*vT**2) - (11*mH**2*C["phiD"]*einsum("pt,sr",kd,kd))/(32.*Nc*pi**2*vT**2) + (mW**2*C["phiD"]*einsum("pt,sr",kd,kd))/(Nc*pi**2*vT**2) - (mW**4*C["phiD"]*einsum("pt,sr",kd,kd))/(4.*mH**2*Nc*pi**2*vT**2) - (7*mW**4*C["phiD"]*einsum("pt,sr",kd,kd))/(12.*mZ**2*Nc*pi**2*vT**2) - (bEvan*mW**4*C["phiD"]*einsum("pt,sr",kd,kd))/(36.*mZ**2*Nc*pi**2*vT**2) - (5*mZ**2*C["phiD"]*einsum("pt,sr",kd,kd))/(32.*Nc*pi**2*vT**2) + (mW**4*C["phiW"]*einsum("pt,sr",kd,kd))/(mH**2*Nc*pi**2*vT**2) + (mW**2*mZ**2*C["phiW"]*einsum("pt,sr",kd,kd))/(2.*mH**2*Nc*pi**2*vT**2) + (3*g1bar*mW*C["phiWB"]*einsum("pt,sr",kd,kd))/(4.*Nc*pi**2*vT) - (7*g1bar*mW**3*C["phiWB"]*einsum("pt,sr",kd,kd))/(6.*mZ**2*Nc*pi**2*vT) - (bEvan*g1bar*mW**3*C["phiWB"]*einsum("pt,sr",kd,kd))/(18.*mZ**2*Nc*pi**2*vT) + (g1bar*mW*mZ**2*C["phiWB"]*einsum("pt,sr",kd,kd))/(4.*mH**2*Nc*pi**2*vT) - (15*g3bar**2*einsum("pt,sr",C["phiq3"],kd))/(16.*pi**2) + (bEvan*g3bar**2*einsum("pt,sr",C["phiq3"],kd))/(4.*pi**2) + (15*g3bar**2*einsum("pt,sr",C["phiq3"],kd))/(16.*Nc**2*pi**2) - (bEvan*g3bar**2*einsum("pt,sr",C["phiq3"],kd))/(4.*Nc**2*pi**2) + (mt**2*einsum("pt,sr",C["phiq3"],kd))/(8.*pi**2*vT**2) - (19*mW**2*einsum("pt,sr",C["phiq3"],kd))/(12.*Nc*pi**2*vT**2) + (bEvan*mW**2*einsum("pt,sr",C["phiq3"],kd))/(18.*Nc*pi**2*vT**2) - (7*mW**4*einsum("pt,sr",C["phiq3"],kd))/(6.*mZ**2*Nc*pi**2*vT**2) - (bEvan*mW**4*einsum("pt,sr",C["phiq3"],kd))/(18.*mZ**2*Nc*pi**2*vT**2) - (15*g3bar**2*einsum("sr,pt",C["phiq3"],kd))/(16.*pi**2) + (bEvan*g3bar**2*einsum("sr,pt",C["phiq3"],kd))/(4.*pi**2) + (15*g3bar**2*einsum("sr,pt",C["phiq3"],kd))/(16.*Nc**2*pi**2) - (bEvan*g3bar**2*einsum("sr,pt",C["phiq3"],kd))/(4.*Nc**2*pi**2) + (mt**2*einsum("sr,pt",C["phiq3"],kd))/(8.*pi**2*vT**2) - (19*mW**2*einsum("sr,pt",C["phiq3"],kd))/(12.*Nc*pi**2*vT**2) + (bEvan*mW**2*einsum("sr,pt",C["phiq3"],kd))/(18.*Nc*pi**2*vT**2) - (7*mW**4*einsum("sr,pt",C["phiq3"],kd))/(6.*mZ**2*Nc*pi**2*vT**2) - (bEvan*mW**4*einsum("sr,pt",C["phiq3"],kd))/(18.*mZ**2*Nc*pi**2*vT**2) + (161*mW**2*einsum("st,pr",C["phiq1"],kd))/(972.*pi**2*vT**2) - (2*bEvan*mW**2*einsum("st,pr",C["phiq1"],kd))/(27.*pi**2*vT**2) + (338*mW**6*einsum("st,pr",C["phiq1"],kd))/(243.*mZ**4*pi**2*vT**2) - (8*bEvan*mW**6*einsum("st,pr",C["phiq1"],kd))/(27.*mZ**4*pi**2*vT**2) - (581*mW**4*einsum("st,pr",C["phiq1"],kd))/(486.*mZ**2*pi**2*vT**2) + (10*bEvan*mW**4*einsum("st,pr",C["phiq1"],kd))/(27.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("st,pr",C["phiq1"],kd))/(72.*pi**2*vT**2) + (5953*mW**2*einsum("st,pr",C["phiq3"],kd))/(1944.*pi**2*vT**2) - (2*bEvan*mW**2*einsum("st,pr",C["phiq3"],kd))/(27.*pi**2*vT**2) + (338*mW**6*einsum("st,pr",C["phiq3"],kd))/(243.*mZ**4*pi**2*vT**2) - (8*bEvan*mW**6*einsum("st,pr",C["phiq3"],kd))/(27.*mZ**4*pi**2*vT**2) - (478*mW**4*einsum("st,pr",C["phiq3"],kd))/(243.*mZ**2*pi**2*vT**2) + (10*bEvan*mW**4*einsum("st,pr",C["phiq3"],kd))/(27.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("st,pr",C["phiq3"],kd))/(72.*pi**2*vT**2) - (3*mt**4*einsum("prsT,tT,TT",C["qq1"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("prsT,tT,TT",C["qq1"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt**4*einsum("prsT,tT,TT",C["qq3"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt**2*mW**2*einsum("prsT,tT,TT",C["qq3"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("prTt,sT,TT",C["qq1"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("prTt,sT,TT",C["qq1"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt**4*einsum("prTt,sT,TT",C["qq3"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt**2*mW**2*einsum("prTt,sT,TT",C["qq3"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("pTsr,tT,TT",C["qq3"],kd,kdt))/(32.*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) - (3*mt**2*mW**2*einsum("pTsr,tT,TT",C["qq3"],kd,kdt))/(32.*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) - (3*mt**4*einsum("ptTr,sT,TT",C["qq3"],kd,kdt))/(32.*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) - (3*mt**2*mW**2*einsum("ptTr,sT,TT",C["qq3"],kd,kdt))/(32.*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) - (mt**2*einsum("pTTr,st,TT",C["qq1"],kd,kdt))/(24.*pi**2*vT**2) - (mW**2*einsum("pTTr,st,TT",C["qq1"],kd,kdt))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("pTTr,st,TT",C["qq1"],kd,kdt))/(12.*mZ**2*pi**2*vT**2) + (mW**4*einsum("pTTr,st,TT",C["qq1"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) - (mt**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(24.*pi**2*vT**2) - (mW**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(12.*mZ**2*pi**2*vT**2) + (mW**4*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) - (mt**2*einsum("ptTT,sr,TT",C["qq3"],kd,kdt))/(8.*pi**2*vT**2) + (mt**2*einsum("pTTt,sr,TT",C["qq1"],kd,kdt))/(16.*Nc*pi**2*vT**2) - (mt**2*einsum("pTTt,sr,TT",C["qq3"],kd,kdt))/(16.*Nc*pi**2*vT**2) - (3*mt**4*einsum("srpT,tT,TT",C["qq3"],kd,kdt))/(32.*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) - (3*mt**2*mW**2*einsum("srpT,tT,TT",C["qq3"],kd,kdt))/(32.*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) - (mt**2*einsum("srTT,pt,TT",C["qq3"],kd,kdt))/(8.*pi**2*vT**2) - (3*mt**4*einsum("sTpr,tT,TT",C["qq1"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("sTpr,tT,TT",C["qq1"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt**4*einsum("sTpr,tT,TT",C["qq3"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt**2*mW**2*einsum("sTpr,tT,TT",C["qq3"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**2*einsum("sTTr,pt,TT",C["qq1"],kd,kdt))/(16.*Nc*pi**2*vT**2) - (mt**2*einsum("sTTr,pt,TT",C["qq3"],kd,kdt))/(16.*Nc*pi**2*vT**2) - (mt**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(12.*pi**2*vT**2) + (4*mW**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(3.*mZ**2*pi**2*vT**2) - (4*mW**4*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) - (3*mt**4*einsum("Trpt,sT,TT",C["qq3"],kd,kdt))/(32.*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) - (3*mt**2*mW**2*einsum("Trpt,sT,TT",C["qq3"],kd,kdt))/(32.*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) - (mt**2*einsum("TrpT,st,TT",C["qq1"],kd,kdt))/(24.*pi**2*vT**2) - (mW**2*einsum("TrpT,st,TT",C["qq1"],kd,kdt))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("TrpT,st,TT",C["qq1"],kd,kdt))/(12.*mZ**2*pi**2*vT**2) + (mW**4*einsum("TrpT,st,TT",C["qq1"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) - (mt**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(24.*pi**2*vT**2) - (mW**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(12.*mZ**2*pi**2*vT**2) + (mW**4*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) + (mt**2*einsum("TrsT,pt,TT",C["qq1"],kd,kdt))/(16.*Nc*pi**2*vT**2) - (mt**2*einsum("TrsT,pt,TT",C["qq3"],kd,kdt))/(16.*Nc*pi**2*vT**2) - (3*mt**4*einsum("Ttpr,sT,TT",C["qq1"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("Ttpr,sT,TT",C["qq1"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt**4*einsum("Ttpr,sT,TT",C["qq3"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt**2*mW**2*einsum("Ttpr,sT,TT",C["qq3"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**2*einsum("TtpT,sr,TT",C["qq1"],kd,kdt))/(16.*Nc*pi**2*vT**2) - (mt**2*einsum("TtpT,sr,TT",C["qq3"],kd,kdt))/(16.*Nc*pi**2*vT**2) - (mt**2*einsum("TTpt,sr,TT",C["qq3"],kd,kdt))/(8.*pi**2*vT**2) - (mt**2*einsum("TTsr,pt,TT",C["qq3"],kd,kdt))/(8.*pi**2*vT**2) - (mt**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(12.*pi**2*vT**2) + (4*mW**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(3.*mZ**2*pi**2*vT**2) - (4*mW**4*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) + (mt**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(24.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) - (179*mt**6*mW**2*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(108.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) + (695*mt**4*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(216.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) - (61*mt**2*mW**6*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(36.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) + (4*mW**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) - (mt**8*mW**2*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(6.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) + (179*mt**6*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(108.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) - (307*mt**4*mW**6*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(108.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) + (13*mt**2*mW**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(9.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) - (4*mW**10*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) - (mt**8*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(192.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (3*mt**6*mW**2*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(64.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (5*mt**4*mW**4*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(64.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (7*mt**2*mW**6*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(192.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**8*mW**2*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(16.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (277*mt**6*mW**4*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(432.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (479*mt**4*mW**6*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(432.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (83*mt**2*mW**8*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(144.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (2*mW**10*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (g1bar*mt**8*mW*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(12.*(-mt + mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (29*g1bar*mt**6*mW**3*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(27.*(-mt + mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (113*g1bar*mt**4*mW**5*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(54.*(-mt + mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (43*g1bar*mt**2*mW**7*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(36.*(-mt + mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (4*g1bar*mW**9*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(27.*(-mt + mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (3*mt**4*mW**3*C["W"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(2.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**3) + (mt**2*mW**5*C["W"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(2.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**3) + (3*mt**4*mW**5*C["W"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(2.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**3) - (mt**2*mW**7*C["W"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(2.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**3) + (mt**4*einsum("pr,sT,tT,TT",C["phiq1"],kd,kd,kdt))/((32*mt**2 - 32*mW**2)*pi**2*vT**2) - (7*mt**2*mW**2*einsum("pr,sT,tT,TT",C["phiq1"],kd,kd,kdt))/((32*mt**2 - 32*mW**2)*pi**2*vT**2) - (7*mt**4*einsum("pr,sT,tT,TT",C["phiq3"],kd,kd,kdt))/(32.*(mt**2 - mW**2)*pi**2*vT**2) - (23*mt**2*mW**2*einsum("pr,sT,tT,TT",C["phiq3"],kd,kd,kdt))/(32.*(mt**2 - mW**2)*pi**2*vT**2) + (mt**2*einsum("prTT,sT,tT,TT",C["qq1"],kd,kd,kdt))/(8.*pi**2*vT**2) + (mt**2*einsum("prTT,sT,tT,TT",C["qq3"],kd,kd,kdt))/(8.*pi**2*vT**2) - (mt**4*einsum("prTT,sT,tT,TT",C["qu1"],kd,kd,kdt))/(32.*(mt**2 - mW**2)*pi**2*vT**2) + (7*mt**2*mW**2*einsum("prTT,sT,tT,TT",C["qu1"],kd,kd,kdt))/(32.*(mt**2 - mW**2)*pi**2*vT**2) - (9*mt**2*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt))/(32.*Nc*pi**2*vT**2) - (5*mW**2*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt))/(12.*Nc*pi**2*vT**2) + (11*mZ**2*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt))/(48.*Nc*pi**2*vT**2) + (9*mt**4*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt))/((96*mt**2*Nc - 96*mW**2*Nc)*pi**2*vT**2) + (103*mt**2*mW**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt))/((96*mt**2*Nc - 96*mW**2*Nc)*pi**2*vT**2) - (76*mW**4*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt))/((96*mt**2*Nc - 96*mW**2*Nc)*pi**2*vT**2) - (22*mt**2*mZ**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt))/((96*mt**2*Nc - 96*mW**2*Nc)*pi**2*vT**2) + (22*mW**2*mZ**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt))/((96*mt**2*Nc - 96*mW**2*Nc)*pi**2*vT**2) - (7*g1bar*mt*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt))/(96.*sqrt(2)*Nc*pi**2*vT) + (g1bar*mW**2*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt))/(3.*sqrt(2)*mt*Nc*pi**2*vT) - (5*g1bar*mZ**2*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt))/(24.*sqrt(2)*mt*Nc*pi**2*vT) - (5*cf*g3bar*mt*einsum("pT,sr,tT,TT",C["uG"],kd,kd,kdt))/(8.*sqrt(2)*Nc*pi**2*vT) + (mt**3*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt))/(2.*sqrt(2)*mH**2*pi**2*vT) + (7*mt*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt))/(32.*sqrt(2)*Nc*pi**2*vT) - (mW**4*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt))/(4.*sqrt(2)*mH**2*mt*Nc*pi**2*vT) - (mZ**4*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt))/(8.*sqrt(2)*mH**2*mt*Nc*pi**2*vT) + (3*mt**3*mW*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt))/(4.*sqrt(2)*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) - (55*mt*mW**3*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt))/(24.*sqrt(2)*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) + (7*mW**5*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt))/(6.*sqrt(2)*mt*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) + (5*mt*mW*mZ**2*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt))/(12.*sqrt(2)*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) - (5*mW**3*mZ**2*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt))/(12.*sqrt(2)*mt*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) + (mt**2*einsum("pTTr,sT,tT,TT",C["qq1"],kd,kd,kdt))/(8.*Nc*pi**2*vT**2) + (mt**2*einsum("pTTr,sT,tT,TT",C["qq3"],kd,kd,kdt))/(8.*Nc*pi**2*vT**2) + (mt**2*einsum("pTTT,sr,tT,TT",C["qu1"],kd,kd,kdt))/(4.*Nc*pi**2*vT**2) + (cf*mt**2*einsum("pTTT,sr,tT,TT",C["qu8"],kd,kd,kdt))/(4.*Nc*pi**2*vT**2) + (mt**4*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**2*mW**2*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (mt**4*mW**2*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt))/(16.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) - (mt**2*mW**4*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt))/(16.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) - (5*mt**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(192.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (2459*mt**6*mW**2*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(1728.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (5101*mt**4*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(1728.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (919*mt**2*mW**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(576.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (4*mW**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (5*mt**8*mW**2*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(48.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (311*mt**6*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(432.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (769*mt**4*mW**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(432.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (151*mt**2*mW**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(144.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (4*mW**10*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**7*mW*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(4.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (103*mt**5*mW**3*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(54.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (475*mt**3*mW**5*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(108.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (115*mt*mW**7*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(54.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**7*mW**3*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (59*mt**5*mW**5*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(54.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (35*mt**3*mW**7*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(54.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (17*mt*mW**9*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(27.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (9*mt**2*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt))/(32.*Nc*pi**2*vT**2) - (5*mW**2*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt))/(12.*Nc*pi**2*vT**2) + (11*mZ**2*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt))/(48.*Nc*pi**2*vT**2) + (9*mt**4*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt))/((96*mt**2*Nc - 96*mW**2*Nc)*pi**2*vT**2) + (103*mt**2*mW**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt))/((96*mt**2*Nc - 96*mW**2*Nc)*pi**2*vT**2) - (76*mW**4*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt))/((96*mt**2*Nc - 96*mW**2*Nc)*pi**2*vT**2) - (22*mt**2*mZ**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt))/((96*mt**2*Nc - 96*mW**2*Nc)*pi**2*vT**2) + (22*mW**2*mZ**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt))/((96*mt**2*Nc - 96*mW**2*Nc)*pi**2*vT**2) - (7*g1bar*mt*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt))/(96.*sqrt(2)*Nc*pi**2*vT) + (g1bar*mW**2*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt))/(3.*sqrt(2)*mt*Nc*pi**2*vT) - (5*g1bar*mZ**2*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt))/(24.*sqrt(2)*mt*Nc*pi**2*vT) - (5*cf*g3bar*mt*einsum("Tr,pt,sT,TT",C["uGDag"],kd,kd,kdt))/(8.*sqrt(2)*Nc*pi**2*vT) + (mt**3*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt))/(2.*sqrt(2)*mH**2*pi**2*vT) + (7*mt*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt))/(32.*sqrt(2)*Nc*pi**2*vT) - (mW**4*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt))/(4.*sqrt(2)*mH**2*mt*Nc*pi**2*vT) - (mZ**4*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt))/(8.*sqrt(2)*mH**2*mt*Nc*pi**2*vT) + (3*mt**3*mW*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt))/(4.*sqrt(2)*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) - (55*mt*mW**3*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt))/(24.*sqrt(2)*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) + (7*mW**5*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt))/(6.*sqrt(2)*mt*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) + (5*mt*mW*mZ**2*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt))/(12.*sqrt(2)*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) - (5*mW**3*mZ**2*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt))/(12.*sqrt(2)*mt*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) + (mt**2*einsum("TrpT,sT,tT,TT",C["qq1"],kd,kd,kdt))/(8.*Nc*pi**2*vT**2) + (mt**2*einsum("TrpT,sT,tT,TT",C["qq3"],kd,kd,kdt))/(8.*Nc*pi**2*vT**2) + (mt**2*einsum("TrTT,pt,sT,TT",C["qu1"],kd,kd,kdt))/(4.*Nc*pi**2*vT**2) + (cf*mt**2*einsum("TrTT,pt,sT,TT",C["qu8"],kd,kd,kdt))/(4.*Nc*pi**2*vT**2) + (mt**4*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**2*mW**2*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (mt**4*mW**2*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt))/(16.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) - (mt**2*mW**4*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt))/(16.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) - (5*mt**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(192.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (2459*mt**6*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(1728.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (5101*mt**4*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(1728.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (919*mt**2*mW**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(576.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (4*mW**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (5*mt**8*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(48.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (311*mt**6*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(432.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (769*mt**4*mW**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(432.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (151*mt**2*mW**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(144.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (4*mW**10*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**7*mW*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(4.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (103*mt**5*mW**3*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(54.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (475*mt**3*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(108.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (115*mt*mW**7*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(54.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**7*mW**3*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (59*mt**5*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(54.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (35*mt**3*mW**7*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(54.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (17*mt*mW**9*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(27.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(36.*sqrt(2)*mH**2*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(18.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(36.*sqrt(2)*mH**2*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(18.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (mt**2*einsum("TTpr,sT,tT,TT",C["qq1"],kd,kd,kdt))/(8.*pi**2*vT**2) + (mt**2*einsum("TTpr,sT,tT,TT",C["qq3"],kd,kd,kdt))/(8.*pi**2*vT**2) + (mt**2*einsum("TT,pt,sr,TT",C["phiq3"],kd,kd,kdt))/(4.*pi**2*vT**2) + (mt**3*einsum("TT,pt,sr,TT",C["uphi"],kd,kd,kdt))/(2.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*einsum("TT,pt,sr,TT",C["uphiDag"],kd,kd,kdt))/(2.*sqrt(2)*mH**2*pi**2*vT) - (mt**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiq1"],kdt))/(24.*pi**2*vT**2) + (mt**2*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiq1"],kdt))/(6.*mZ**2*pi**2*vT**2) + (mt**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiq3"],kdt))/(24.*pi**2*vT**2) - (mt**2*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiq3"],kdt))/(6.*mZ**2*pi**2*vT**2) + (mt**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(96.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (7*mt**2*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(96.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (mt**4*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(24.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) + (7*mt**2*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(24.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) - (g1bar*mt**5*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uB"],kdt))/(24.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) - (g1bar*mt**3*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uB"],kdt))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) + (g1bar*mt*mW**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uB"],kdt))/(12.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) - (g1bar*mt**5*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uBDag"],kdt))/(24.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) - (g1bar*mt**3*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uBDag"],kdt))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) + (g1bar*mt*mW**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uBDag"],kdt))/(12.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) - (mt**5*mW*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt))/(12.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**3*mW**3*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt))/(6.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**5*mW**3*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt))/(12.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**3*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt*mW**7*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt))/(6.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**5*mW*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(12.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**3*mW**3*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(6.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**5*mW**3*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(12.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**3*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt*mW**7*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(6.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mH**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(48.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mH**2*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (mH**4*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) - (mH**4*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(24.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) + (mH**2*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) - (mH**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(24.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(24.*pi**2) + (mW**4*C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*mZ**4*pi**2) + (mW**2*C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*mZ**2*pi**2) + (mH**4*mW**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (7*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (4*mH**6*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT**2) - (7*mH**6*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) - (4*mH**4*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) - (mH**6*mW**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (7*mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (4*mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (mH**2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (5*mH**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(72.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mH**2*mW**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (5*mH**4*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (5*mH**4*mW**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(36.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (8*mH**2*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mH**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(36.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(72.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (5*mH**4*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(144.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mH**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mH**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(36.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (7*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (4*mH**6*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT**2) + (7*mH**6*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) + (4*mH**4*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) + (mH**6*mW**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (7*mH**4*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (4*mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (mH**2*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (g1bar*mH**4*mW*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(48.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (2*g1bar*mH**6*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**6*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) + (2*g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**6*mW*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(144.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) - (2*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (3*mH**4*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/((8*mH**2*Nc - 8*mW**2*Nc)*pi**2*vT**4) - (6*mH**2*mW**2*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/((8*mH**2*Nc - 8*mW**2*Nc)*pi**2*vT**4) - (3*C["phi"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(4.*Nc*pi**2) + (5*mH**4*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/((4*mH**2*Nc - 4*mW**2*Nc)*pi**2*vT**2) - (8*mH**2*mW**2*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/((4*mH**2*Nc - 4*mW**2*Nc)*pi**2*vT**2) - (5*mH**4*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/((16*mH**2*Nc - 16*mW**2*Nc)*pi**2*vT**2) + (8*mH**2*mW**2*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/((16*mH**2*Nc - 16*mW**2*Nc)*pi**2*vT**2) + (3*mH**4*mt*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mH**2))/(16.*sqrt(2)*(mH - mt)*(mH + mt)*(mH - mW)*(mH + mW)*Nc*pi**2*vT) - (3*mH**2*mt*mW**2*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mH**2))/(8.*sqrt(2)*(mH - mt)*(mH + mt)*(mH - mW)*(mH + mW)*Nc*pi**2*vT) + (3*mH**4*mt*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mH**2))/(16.*sqrt(2)*(mH - mt)*(mH + mt)*(mH - mW)*(mH + mW)*Nc*pi**2*vT) - (3*mH**2*mt*mW**2*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mH**2))/(8.*sqrt(2)*(mH - mt)*(mH + mt)*(mH - mW)*(mH + mW)*Nc*pi**2*vT) + (mt**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(72.*pi**2*vT**4) - (mt**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(18.*mH**2*pi**2*vT**4) + (5*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*pi**2*vT**4) + (64*mW**8*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**6*pi**2*vT**4) - (mt**2*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**4) + (4*mt**4*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**4) - (32*mW**6*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**4) - (mt**2*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(36.*mZ**2*pi**2*vT**4) + (mt**4*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**2*pi**2*vT**4) + (mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**4) - (16*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**6*pi**2*vT**2) + (14*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**2*pi**2*vT**2) - (mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*pi**2*vT**2) + (8*mt**4*mW**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**2*pi**2*vT**2) - (mt**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(72.*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(36.*mH**2*pi**2*vT**2) - (5*mW**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(486.*pi**2*vT**2) + (64*mW**8*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**6*pi**2*vT**2) + (2*mt**4*mW**4*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**2) - (16*mW**6*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(72.*mZ**2*pi**2*vT**2) + (16*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**6*pi**2*vT**2) - (14*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**2) - (2*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**2*pi**2*vT**2) + (8*g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**6*pi**2*vT) + (128*g1bar*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**6*pi**2*vT) - (g1bar*mt**2*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT) + (g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT) - (112*g1bar*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**4*pi**2*vT) - (g1bar*mt**2*mW*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(72.*mZ**2*pi**2*vT) + (11*g1bar*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**2*pi**2*vT) + (mt**2*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(24.*pi**2*vT**2) - (5*mW**2*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) - (8*mW**6*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (5*mW**2*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) + (8*mW**6*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (13*mW**4*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) + (mt**2*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(4.*pi**2*vT**4) - (mt**4*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(mH**2*pi**2*vT**4) - (2*mt**4*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(mH**2*pi**2*vT**2) + (mt**4*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(2.*mH**2*pi**2*vT**2) + (mt**2*einsum("pt,sr",C["phiq3"],kd)*log(scale**2/mt**2))/(4.*pi**2*vT**2) + (mt**2*einsum("sr,pt",C["phiq3"],kd)*log(scale**2/mt**2))/(4.*pi**2*vT**2) + (mt**2*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (10*mW**2*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) + (16*mW**6*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) - (26*mW**4*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (10*mW**2*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) + (16*mW**6*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) - (26*mW**4*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) - (mt**6*einsum("prsT,tT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("prsT,tT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("prsT,tT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*einsum("prsT,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (13*mt**4*mW**2*einsum("prsT,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (7*mt**2*mW**4*einsum("prsT,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("prTt,sT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("prTt,sT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("prTt,sT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*einsum("prTt,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (13*mt**4*mW**2*einsum("prTt,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (7*mt**2*mW**4*einsum("prTt,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*Nc*einsum("prTT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*Nc*einsum("prTT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("prTT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("prTT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*Nc*einsum("prTT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("prTT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("prTT,st,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*Nc*einsum("prTT,st,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("prTT,st,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (3*mt**2*mW**2*einsum("pTsr,tT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/((8*mt**2*Nc - 8*mW**2*Nc)*pi**2*vT**2) - (mt**6*einsum("pTsr,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) + (mt**4*mW**2*einsum("pTsr,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(2.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) - (5*mt**2*mW**4*einsum("pTsr,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) - (3*mt**2*mW**2*einsum("ptTr,sT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/((8*mt**2*Nc - 8*mW**2*Nc)*pi**2*vT**2) - (mt**6*einsum("ptTr,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) + (mt**4*mW**2*einsum("ptTr,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(2.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) - (5*mt**2*mW**4*einsum("ptTr,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) + (mt**2*einsum("pTTr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*einsum("pTTr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("pTTr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*einsum("pTTr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*einsum("ptTT,sr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(4.*pi**2*vT**2) - (mt**2*einsum("pTTt,sr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(8.*Nc*pi**2*vT**2) + (mt**2*einsum("pTTt,sr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*Nc*pi**2*vT**2) - (3*mt**2*mW**2*einsum("srpT,tT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/((8*mt**2*Nc - 8*mW**2*Nc)*pi**2*vT**2) - (mt**6*einsum("srpT,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) + (mt**4*mW**2*einsum("srpT,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(2.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) - (5*mt**2*mW**4*einsum("srpT,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) - (mt**2*einsum("srTT,pt,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(4.*pi**2*vT**2) - (mt**6*einsum("sTpr,tT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("sTpr,tT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("sTpr,tT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*einsum("sTpr,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (13*mt**4*mW**2*einsum("sTpr,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (7*mt**2*mW**4*einsum("sTpr,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*einsum("sTTr,pt,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(8.*Nc*pi**2*vT**2) + (mt**2*einsum("sTTr,pt,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*Nc*pi**2*vT**2) + (mt**2*Nc*einsum("stTT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) - (2*mW**2*Nc*einsum("stTT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("stTT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) + (2*mW**4*Nc*einsum("stTT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("stTT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (2*mW**2*Nc*einsum("stTT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("stTT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) - (2*mW**4*Nc*einsum("stTT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("stTT,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) - (2*mW**2*Nc*einsum("stTT,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("stTT,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) + (2*mW**4*Nc*einsum("stTT,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) - (4*mW**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(3.*mZ**2*pi**2*vT**2) + (4*mW**4*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (3*mt**2*mW**2*einsum("Trpt,sT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/((8*mt**2*Nc - 8*mW**2*Nc)*pi**2*vT**2) - (mt**6*einsum("Trpt,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) + (mt**4*mW**2*einsum("Trpt,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(2.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) - (5*mt**2*mW**4*einsum("Trpt,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) + (mt**2*einsum("TrpT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*einsum("TrpT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("TrpT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*einsum("TrpT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*einsum("TrsT,pt,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(8.*Nc*pi**2*vT**2) + (mt**2*einsum("TrsT,pt,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*Nc*pi**2*vT**2) - (mt**6*einsum("Ttpr,sT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("Ttpr,sT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("Ttpr,sT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*einsum("Ttpr,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (13*mt**4*mW**2*einsum("Ttpr,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (7*mt**2*mW**4*einsum("Ttpr,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*Nc*einsum("TTpr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*Nc*einsum("TTpr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TTpr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("TTpr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TTpr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*Nc*einsum("TTpr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TTpr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("TTpr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*einsum("TtpT,sr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(8.*Nc*pi**2*vT**2) + (mt**2*einsum("TtpT,sr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*Nc*pi**2*vT**2) - (mt**2*einsum("TTpt,sr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(4.*pi**2*vT**2) - (mt**2*einsum("TTsr,pt,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(4.*pi**2*vT**2) + (mt**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) - (4*mW**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(3.*mZ**2*pi**2*vT**2) + (4*mW**4*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TTst,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) - (2*mW**2*Nc*einsum("TTst,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TTst,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) + (2*mW**4*Nc*einsum("TTst,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TTst,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (2*mW**2*Nc*einsum("TTst,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TTst,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) - (2*mW**4*Nc*einsum("TTst,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (5*mt**8*mW**2*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (25*mt**6*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(18.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (73*mt**4*mW**6*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (181*mt**2*mW**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(108.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (4*mW**10*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (4*mt**8*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (mt**6*mW**6*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (7*mt**4*mW**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(6.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (25*mt**2*mW**10*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (4*mW**12*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (mt**10*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt**8*mW**2*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (3*mt**6*mW**4*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (5*mt**4*mW**6*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt**2*mW**8*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt**10*mW**2*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (7*mt**8*mW**4*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(18.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (31*mt**6*mW**6*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt**4*mW**8*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(6.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (8*mt**2*mW**10*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (2*mW**12*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (13*g1bar*mt**8*mW**3*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(36.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) - (5*g1bar*mt**6*mW**5*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(18.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) - (3*g1bar*mt**4*mW**7*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (41*g1bar*mt**2*mW**9*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(54.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) - (4*g1bar*mW**11*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) - (mt**6*mW**3*C["W"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/((mt - mW)**3*(mt + mW)**3*pi**2*vT**3) + (mt**6*mW**5*C["W"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/((mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**3) - (mt**6*einsum("pr,sT,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("pr,sT,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("pr,sT,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("pr,sT,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (7*mt**4*mW**2*einsum("pr,sT,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (7*mt**2*mW**4*einsum("pr,sT,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*einsum("prTT,sT,tT,TT",C["qu1"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("prTT,sT,tT,TT",C["qu1"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("prTT,sT,tT,TT",C["qu1"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (5*mt**6*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) + (3*mt**4*mW**2*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) + (mt**2*mW**4*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) + (5*mt**4*mZ**2*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) - (3*mt**2*mW**2*mZ**2*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) - (mt**8*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) + (mt**6*mW**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) + (mt**4*mW**4*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) + (mt**2*mW**6*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) - (mt**6*mZ**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) + (5*mt**4*mW**2*mZ**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) - (3*mt**2*mW**4*mZ**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) - (5*g1bar*mt**5*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT) + (3*g1bar*mt**3*mW**2*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT) - (g1bar*mt*mW**4*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT) + (3*g3bar*mt*mW**2*einsum("pT,sr,tT,TT",C["uG"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)*(mt + mW)*pi**2*vT) - (3*g3bar*mt*mW**2*einsum("pT,sr,tT,TT",C["uG"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)*(mt + mW)*Nc**2*pi**2*vT) - (3*cf*g3bar*mt**3*einsum("pT,sr,tT,TT",C["uG"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)*(mt + mW)*Nc*pi**2*vT) + (3*cf*g3bar*mt*mW**2*einsum("pT,sr,tT,TT",C["uG"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)*(mt + mW)*Nc*pi**2*vT) + (mt**5*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) - (mt**7*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*mH**2*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) - (mt**3*mW**2*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) + (mt**5*mW**2*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*mH**2*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) - (3*mt**5*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*Nc*pi**2*vT) + (3*mt**3*mW**2*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*Nc*pi**2*vT) - (5*mt**5*mW**3*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) + (3*mt**3*mW**5*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) - (mt*mW**7*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) + (5*mt**5*mW*mZ**2*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) - (3*mt**3*mW**3*mZ**2*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) + (mt*mW**5*mZ**2*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) + (mt**2*einsum("pTTT,sr,tT,TT",C["qu1"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*Nc*pi**2*vT**2) + (cf*mt**2*einsum("pTTT,sr,tT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*Nc*pi**2*vT**2) + (mt**6*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*mW**2*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**4*mW**4*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**2*mW**6*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (7*mt**10*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (2*mt**8*mW**2*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (517*mt**6*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(288.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (157*mt**4*mW**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (371*mt**2*mW**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(216.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (4*mW**10*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (7*mt**10*mW**2*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (13*mt**8*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (109*mt**6*mW**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (25*mt**4*mW**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (59*mt**2*mW**10*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(54.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (4*mW**12*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (g1bar*mt*mW**4*einsum("sT,pr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt**2 - mW**2)*mZ**2*pi**2*vT) + (29*mt**7*mW**3*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (9*mt**5*mW**5*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (67*mt**3*mW**7*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt*mW**9*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (5*mt**7*mW**5*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (3*mt**5*mW**7*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt*mW**11*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (5*mt**6*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) + (3*mt**4*mW**2*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) + (mt**2*mW**4*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) + (5*mt**4*mZ**2*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) - (3*mt**2*mW**2*mZ**2*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) - (mt**8*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) + (mt**6*mW**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) + (mt**4*mW**4*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) + (mt**2*mW**6*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) - (mt**6*mZ**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) + (5*mt**4*mW**2*mZ**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) - (3*mt**2*mW**4*mZ**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) - (5*g1bar*mt**5*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT) + (3*g1bar*mt**3*mW**2*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT) - (g1bar*mt*mW**4*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT) + (3*g3bar*mt*mW**2*einsum("Tr,pt,sT,TT",C["uGDag"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)*(mt + mW)*pi**2*vT) - (3*g3bar*mt*mW**2*einsum("Tr,pt,sT,TT",C["uGDag"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)*(mt + mW)*Nc**2*pi**2*vT) - (3*cf*g3bar*mt**3*einsum("Tr,pt,sT,TT",C["uGDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)*(mt + mW)*Nc*pi**2*vT) + (3*cf*g3bar*mt*mW**2*einsum("Tr,pt,sT,TT",C["uGDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)*(mt + mW)*Nc*pi**2*vT) + (mt**5*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) - (mt**7*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*mH**2*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) - (mt**3*mW**2*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) + (mt**5*mW**2*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*mH**2*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) - (3*mt**5*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*Nc*pi**2*vT) + (3*mt**3*mW**2*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*Nc*pi**2*vT) - (5*mt**5*mW**3*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) + (3*mt**3*mW**5*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) - (mt*mW**7*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) + (5*mt**5*mW*mZ**2*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) - (3*mt**3*mW**3*mZ**2*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) + (mt*mW**5*mZ**2*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*Nc*pi**2*vT**2) + (mt**2*einsum("TrTT,pt,sT,TT",C["qu1"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*Nc*pi**2*vT**2) + (cf*mt**2*einsum("TrTT,pt,sT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*Nc*pi**2*vT**2) + (mt**6*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*mW**2*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**4*mW**4*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**2*mW**6*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (7*mt**10*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (2*mt**8*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (517*mt**6*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(288.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (157*mt**4*mW**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (371*mt**2*mW**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(216.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (4*mW**10*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (7*mt**10*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (13*mt**8*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (109*mt**6*mW**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (25*mt**4*mW**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (59*mt**2*mW**10*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(54.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (4*mW**12*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (g1bar*mt*mW**4*einsum("Tt,pr,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt**2 - mW**2)*mZ**2*pi**2*vT) + (29*mt**7*mW**3*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (9*mt**5*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (67*mt**3*mW**7*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt*mW**9*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (5*mt**7*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (3*mt**5*mW**7*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt*mW**11*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*pi**2*vT**2) + (mW**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*pi**2*vT**2) + (2*mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**2) - (8*mW**6*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*mZ**2*pi**2*vT**2) + (7*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*pi**2*vT**2) - (mW**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*pi**2*vT**2) - (2*mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**2) + (8*mW**6*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*mZ**2*pi**2*vT**2) - (7*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*pi**2*vT**2) + (mW**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*pi**2*vT**2) - (2*mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**2) - (8*mW**6*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*mZ**2*pi**2*vT**2) + (7*mW**4*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) - (11*g1bar*mt*mW**4*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*sqrt(2)*mZ**4*pi**2*vT) - (13*g1bar*mt*mW**2*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(216.*sqrt(2)*mZ**2*pi**2*vT) - (11*g1bar*mt*mW**4*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*sqrt(2)*mZ**4*pi**2*vT) - (13*g1bar*mt*mW**2*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(216.*sqrt(2)*mZ**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*sqrt(2)*mH**2*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*sqrt(2)*mH**2*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*mH**2*mZ**2*pi**2*vT) - (5*mt*mW*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*sqrt(2)*pi**2*vT**2) - (19*mt*mW**3*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*sqrt(2)*mZ**2*pi**2*vT**2) - (5*mt*mW*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*sqrt(2)*pi**2*vT**2) - (19*mt*mW**3*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*sqrt(2)*mZ**2*pi**2*vT**2) + (mt**2*einsum("TT,pt,sr,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*pi**2*vT**2) + (mt**3*einsum("TT,pt,sr,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*einsum("TT,pt,sr,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*mH**2*pi**2*vT) - (mt**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**4*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(6.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**2*mW**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(3.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (g1bar*mt**5*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uB"],kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (g1bar*mt**3*mW**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uB"],kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (g1bar*mt**5*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uBDag"],kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (g1bar*mt**3*mW**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uBDag"],kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (mt**5*mW**3*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(3.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**3*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**5*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(3.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mt**3*mW**7*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mt**5*mW**3*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(3.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**3*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**5*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(3.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mt**3*mW**7*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (3*mW**2*einsum("prst",C["qq3"])*log(scale**2/mW**2))/(2.*pi**2*vT**2) - (3*mW**2*einsum("ptsr",C["qq1"])*log(scale**2/mW**2))/(4.*Nc*pi**2*vT**2) + (3*mW**2*einsum("ptsr",C["qq3"])*log(scale**2/mW**2))/(4.*Nc*pi**2*vT**2) - (3*mW**2*einsum("srpt",C["qq1"])*log(scale**2/mW**2))/(4.*Nc*pi**2*vT**2) + (3*mW**2*einsum("srpt",C["qq3"])*log(scale**2/mW**2))/(4.*Nc*pi**2*vT**2) - (3*mW**2*einsum("stpr",C["qq3"])*log(scale**2/mW**2))/(2.*pi**2*vT**2) - (47*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(216.*pi**2*vT**4) + (mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(12.*mH**2*pi**2*vT**4) - (28*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(9.*mZ**6*pi**2*vT**4) + (161*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(54.*mZ**4*pi**2*vT**4) - (2*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**4*pi**2*vT**4) + (13*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(18.*mZ**2*pi**2*vT**4) - (mW**6*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mH**2*mZ**2*pi**2*vT**4) + (8*mW**10*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**6*pi**2*vT**2) - (7*mW**8*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**4*pi**2*vT**2) - (mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**2*pi**2*vT**2) + (mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mH**2*pi**2*vT**2) - (4*mW**8*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**4*pi**2*vT**2) - (mW**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**2*pi**2*vT**2) - (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(24.*mH**2*pi**2*vT**2) - (28*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(9.*mZ**6*pi**2*vT**2) + (175*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(108.*mZ**4*pi**2*vT**2) - (mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**4*pi**2*vT**2) + (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mZ**2*pi**2*vT**2) + (mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mH**2*pi**2*vT**2) - (8*mW**10*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**6*pi**2*vT**2) + (mW**8*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**4*pi**2*vT**2) - (44*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(9.*mZ**6*pi**2*vT) - (4*g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**6*pi**2*vT) + (89*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(36.*mZ**4*pi**2*vT) - (g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mH**2*mZ**4*pi**2*vT) + (85*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(216.*mZ**2*pi**2*vT) - (mW**3*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*pi**2*vT**3) - (16*mW**9*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mZ**6*pi**2*vT**3) + (46*mW**7*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mZ**4*pi**2*vT**3) + (5*mW**5*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mZ**2*pi**2*vT**3) + (7*mW**6*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mW**2))/(6.*mZ**4*pi**2*vT**2) - (7*mW**4*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mW**2))/(6.*mZ**2*pi**2*vT**2) + (25*mW**2*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mW**2))/(108.*pi**2*vT**2) - (7*mW**6*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mW**2))/(6.*mZ**4*pi**2*vT**2) + (91*mW**4*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mW**2))/(54.*mZ**2*pi**2*vT**2) - (3*mH**2*mW**4*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(8.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**4) + (9*mW**6*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(4.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**4) - (3*mW**8*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**4) + (3*mH**2*mW**2*mZ**2*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(4.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**4) - (21*mW**4*mZ**2*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(8.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**4) + (3*mW**6*mZ**2*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**4) - (3*g3bar**2*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(8.*pi**2*vT**2) + (3*g3bar**2*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(8.*Nc**2*pi**2*vT**2) + (15*mH**2*mW**4*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/((4*mH**4*Nc - 4*mH**2*mW**2*Nc)*pi**2*vT**2) - (12*mW**6*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/((4*mH**4*Nc - 4*mH**2*mW**2*Nc)*pi**2*vT**2) + (7*mH**2*mW**4*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(48.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (13*mW**6*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(12.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (3*mW**8*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(4.*mH**2*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (mH**2*mW**2*mZ**2*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(24.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (43*mW**4*mZ**2*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(48.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (3*mW**6*mZ**2*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(4.*mH**2*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (3*mW**4*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(mH**2*Nc*pi**2*vT**2) + (mW**2*einsum("pt,sr",C["phiq1"],kd)*log(scale**2/mW**2))/(4.*Nc*pi**2*vT**2) - (3*g3bar**2*einsum("pt,sr",C["phiq3"],kd)*log(scale**2/mW**2))/(8.*pi**2) + (3*g3bar**2*einsum("pt,sr",C["phiq3"],kd)*log(scale**2/mW**2))/(8.*Nc**2*pi**2) - (3*mW**2*einsum("pt,sr",C["phiq3"],kd)*log(scale**2/mW**2))/(4.*Nc*pi**2*vT**2) + (mW**2*einsum("sr,pt",C["phiq1"],kd)*log(scale**2/mW**2))/(4.*Nc*pi**2*vT**2) - (3*g3bar**2*einsum("sr,pt",C["phiq3"],kd)*log(scale**2/mW**2))/(8.*pi**2) + (3*g3bar**2*einsum("sr,pt",C["phiq3"],kd)*log(scale**2/mW**2))/(8.*Nc**2*pi**2) - (3*mW**2*einsum("sr,pt",C["phiq3"],kd)*log(scale**2/mW**2))/(4.*Nc*pi**2*vT**2) - (7*mW**6*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mW**2))/(3.*mZ**4*pi**2*vT**2) + (7*mW**4*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mW**2))/(3.*mZ**2*pi**2*vT**2) - (47*mW**2*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mW**2))/(108.*pi**2*vT**2) - (7*mW**6*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mW**2))/(3.*mZ**4*pi**2*vT**2) + (95*mW**4*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mW**2))/(27.*mZ**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("prsT,tT,TT",C["qq1"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**4*mW**2*einsum("prsT,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (27*mt**2*mW**4*einsum("prsT,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("prTt,sT,TT",C["qq1"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**4*mW**2*einsum("prTt,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (27*mt**2*mW**4*einsum("prTt,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**2*einsum("pTsr,tT,TT",C["qq1"],kd,kdt)*log(scale**2/mW**2))/((8*mt**2*Nc - 8*mW**2*Nc)*pi**2*vT**2) - (3*mt**4*mW**2*einsum("pTsr,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) + (9*mt**2*mW**4*einsum("pTsr,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) + (3*mt**2*mW**2*einsum("ptTr,sT,TT",C["qq1"],kd,kdt)*log(scale**2/mW**2))/((8*mt**2*Nc - 8*mW**2*Nc)*pi**2*vT**2) - (3*mt**4*mW**2*einsum("ptTr,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) + (9*mt**2*mW**4*einsum("ptTr,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) + (3*mt**2*mW**2*einsum("srpT,tT,TT",C["qq1"],kd,kdt)*log(scale**2/mW**2))/((8*mt**2*Nc - 8*mW**2*Nc)*pi**2*vT**2) - (3*mt**4*mW**2*einsum("srpT,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) + (9*mt**2*mW**4*einsum("srpT,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) + (3*mt**2*mW**4*einsum("sTpr,tT,TT",C["qq1"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**4*mW**2*einsum("sTpr,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (27*mt**2*mW**4*einsum("sTpr,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**2*einsum("Trpt,sT,TT",C["qq1"],kd,kdt)*log(scale**2/mW**2))/((8*mt**2*Nc - 8*mW**2*Nc)*pi**2*vT**2) - (3*mt**4*mW**2*einsum("Trpt,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) + (9*mt**2*mW**4*einsum("Trpt,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) + (3*mt**2*mW**4*einsum("Ttpr,sT,TT",C["qq1"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**4*mW**2*einsum("Ttpr,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (27*mt**2*mW**4*einsum("Ttpr,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (47*mt**8*mW**2*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(216.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (43*mt**6*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(54.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (155*mt**4*mW**6*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(72.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (13*mt**2*mW**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (16*mt**8*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (19*mt**6*mW**6*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (5*mt**4*mW**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(18.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (mt**2*mW**10*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(3.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (mt**6*mW**4*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt**4*mW**6*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt**2*mW**8*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (8*mt**8*mW**4*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (103*mt**6*mW**6*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(216.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt**4*mW**8*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt**2*mW**10*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(24.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (55*g1bar*mt**8*mW**3*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(108.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (47*g1bar*mt**6*mW**5*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(54.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) - (5*g1bar*mt**4*mW**7*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(36.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) - (g1bar*mt**2*mW**9*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(6.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (mt**6*mW**3*C["W"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/((mt - mW)**3*(mt + mW)**3*pi**2*vT**3) - (mt**6*mW**5*C["W"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/((mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**3) + (3*mt**2*mW**4*einsum("pr,sT,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**4*mW**2*einsum("pr,sT,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (27*mt**2*mW**4*einsum("pr,sT,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**2*mW**4*einsum("prTT,sT,tT,TT",C["qu1"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (5*mt**2*mW**4*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)*(mt + mW)*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (mt**2*mW**2*mZ**2*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)*(mt + mW)*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (mt**6*mW**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (mt**4*mW**4*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (9*mt**2*mW**6*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (mt**6*mZ**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (mt**4*mW**2*mZ**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (3*mt**2*mW**4*mZ**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (3*g1bar*mt*mW**4*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mt - mW)*(mt + mW)*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT) - (3*g3bar*mt*mW**2*einsum("pT,sr,tT,TT",C["uG"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*sqrt(2)*(mt - mW)*(mt + mW)*pi**2*vT) + (3*g3bar*mt*mW**2*einsum("pT,sr,tT,TT",C["uG"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*sqrt(2)*(mt - mW)*(mt + mW)*Nc**2*pi**2*vT) - (15*mt*mW**4*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mH - mW)*(mt - mW)*(mH + mW)*(mt + mW)*Nc*pi**2*vT) + (3*mW**6*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*mt*(mH - mW)*(mt - mW)*(mH + mW)*(mt + mW)*Nc*pi**2*vT) + (3*mt*mW**6*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*mH**2*(mH - mW)*(mt - mW)*(mH + mW)*(mt + mW)*Nc*pi**2*vT) - (3*mW**8*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*mH**2*mt*(mH - mW)*(mt - mW)*(mH + mW)*(mt + mW)*Nc*pi**2*vT) - (11*mt**3*mW**5*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (13*mt*mW**7*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (3*mW**9*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*mt*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (mt**3*mW**3*mZ**2*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (23*mt*mW**5*mZ**2*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (3*mW**7*mZ**2*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*mt*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (mt**2*mW**4*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**6*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (47*mt**8*mW**2*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(216.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (661*mt**6*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(864.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (301*mt**4*mW**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(144.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (101*mt**2*mW**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(96.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (16*mt**8*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (179*mt**6*mW**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(216.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt**4*mW**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(36.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (5*mt**2*mW**10*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(24.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (g1bar*mt*mW**4*einsum("sT,pr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt**2 - mW**2)*mZ**2*pi**2*vT) - (29*mt**7*mW**3*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (9*mt**5*mW**5*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (67*mt**3*mW**7*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(36.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt*mW**9*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(9.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*mt**7*mW**5*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(3.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (3*mt**5*mW**7*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt*mW**11*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(9.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (5*mt**2*mW**4*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)*(mt + mW)*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (mt**2*mW**2*mZ**2*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)*(mt + mW)*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (mt**6*mW**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (mt**4*mW**4*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (9*mt**2*mW**6*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (mt**6*mZ**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (mt**4*mW**2*mZ**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (3*mt**2*mW**4*mZ**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (3*g1bar*mt*mW**4*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mt - mW)*(mt + mW)*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT) - (3*g3bar*mt*mW**2*einsum("Tr,pt,sT,TT",C["uGDag"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*sqrt(2)*(mt - mW)*(mt + mW)*pi**2*vT) + (3*g3bar*mt*mW**2*einsum("Tr,pt,sT,TT",C["uGDag"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*sqrt(2)*(mt - mW)*(mt + mW)*Nc**2*pi**2*vT) - (15*mt*mW**4*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mH - mW)*(mt - mW)*(mH + mW)*(mt + mW)*Nc*pi**2*vT) + (3*mW**6*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*mt*(mH - mW)*(mt - mW)*(mH + mW)*(mt + mW)*Nc*pi**2*vT) + (3*mt*mW**6*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*mH**2*(mH - mW)*(mt - mW)*(mH + mW)*(mt + mW)*Nc*pi**2*vT) - (3*mW**8*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*mH**2*mt*(mH - mW)*(mt - mW)*(mH + mW)*(mt + mW)*Nc*pi**2*vT) - (11*mt**3*mW**5*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (13*mt*mW**7*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (3*mW**9*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*mt*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (mt**3*mW**3*mZ**2*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (23*mt*mW**5*mZ**2*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (3*mW**7*mZ**2*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*mt*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (mt**2*mW**4*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**6*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (47*mt**8*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(216.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (661*mt**6*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(864.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (301*mt**4*mW**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(144.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (101*mt**2*mW**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(96.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (16*mt**8*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (179*mt**6*mW**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(216.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt**4*mW**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(36.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (5*mt**2*mW**10*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(24.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (g1bar*mt*mW**4*einsum("Tt,pr,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt**2 - mW**2)*mZ**2*pi**2*vT) - (29*mt**7*mW**3*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (9*mt**5*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (67*mt**3*mW**7*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(36.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt*mW**9*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(9.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*mt**7*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(3.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (3*mt**5*mW**7*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt*mW**11*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(9.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt**2*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (g1bar*mt**5*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uB"],kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (g1bar*mt**3*mW**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uB"],kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (g1bar*mt**5*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uBDag"],kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (g1bar*mt**3*mW**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uBDag"],kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (mt**5*mW**3*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(3.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**3*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**5*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(3.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**3*mW**7*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**5*mW**3*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(3.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**3*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**5*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(3.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**3*mW**7*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mW**2*einsum("prst",C["qq1"])*log(scale**2/mZ**2))/(12.*pi**2*vT**2) + (mW**4*einsum("prst",C["qq1"])*log(scale**2/mZ**2))/(3.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("prst",C["qq1"])*log(scale**2/mZ**2))/(24.*pi**2*vT**2) - (mW**2*einsum("prst",C["qq3"])*log(scale**2/mZ**2))/(12.*pi**2*vT**2) - (mW**4*einsum("prst",C["qq3"])*log(scale**2/mZ**2))/(3.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("prst",C["qq3"])*log(scale**2/mZ**2))/(24.*pi**2*vT**2) + (mW**2*einsum("ptsr",C["qq3"])*log(scale**2/mZ**2))/(6.*Nc*pi**2*vT**2) + (2*mW**4*einsum("ptsr",C["qq3"])*log(scale**2/mZ**2))/(3.*mZ**2*Nc*pi**2*vT**2) - (mZ**2*einsum("ptsr",C["qq3"])*log(scale**2/mZ**2))/(12.*Nc*pi**2*vT**2) + (mW**2*einsum("srpt",C["qq3"])*log(scale**2/mZ**2))/(6.*Nc*pi**2*vT**2) + (2*mW**4*einsum("srpt",C["qq3"])*log(scale**2/mZ**2))/(3.*mZ**2*Nc*pi**2*vT**2) - (mZ**2*einsum("srpt",C["qq3"])*log(scale**2/mZ**2))/(12.*Nc*pi**2*vT**2) + (mW**2*einsum("stpr",C["qq1"])*log(scale**2/mZ**2))/(12.*pi**2*vT**2) + (mW**4*einsum("stpr",C["qq1"])*log(scale**2/mZ**2))/(3.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("stpr",C["qq1"])*log(scale**2/mZ**2))/(24.*pi**2*vT**2) - (mW**2*einsum("stpr",C["qq3"])*log(scale**2/mZ**2))/(12.*pi**2*vT**2) - (mW**4*einsum("stpr",C["qq3"])*log(scale**2/mZ**2))/(3.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("stpr",C["qq3"])*log(scale**2/mZ**2))/(24.*pi**2*vT**2) + (11*mH**2*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (59*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(162.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (52*mH**2*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**4) - (10*mH**2*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) - (52*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) - (11*mH**2*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) + (10*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) - (331*mW**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(1944.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mW**4*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mW**2*mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(12.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (mZ**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(24.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (5*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (40*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(9.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (2*mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (5*mH**2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(12.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (67*mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(18.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (2*mW**6*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mH**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(12.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (8*mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(9.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (5*mW**4*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mZ**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (5*mW**2*mZ**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(12.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mZ**8*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(12.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mW**4*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**2*mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mZ**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(12.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (11*mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(486.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (52*mH**2*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (5*mH**2*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (52*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (5*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (155*mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3888.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**4*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**2*mZ**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(24.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (40*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(9.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (2*mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (mH**2*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (43*mW**4*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(18.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (2*mW**6*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (5*mW**2*mZ**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(9.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mW**4*mZ**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mW**2*mZ**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (37*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (521*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (104*g1bar*mH**4*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT) - (19*g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) - (208*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) - (22*g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) - (205*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (104*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**2*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(48.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (317*g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(972.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mW**5*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (11*g1bar*mW*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(144.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mW**3*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mW*mZ**6*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(24.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (11*mW**2*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mZ**2))/(81.*pi**2*vT**2) - (10*mW**6*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mZ**2))/(81.*mZ**4*pi**2*vT**2) - (mW**4*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mZ**2))/(81.*mZ**2*pi**2*vT**2) - (11*mW**2*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mZ**2))/(81.*pi**2*vT**2) + (10*mW**6*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mZ**2))/(81.*mZ**4*pi**2*vT**2) + (mW**4*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mZ**2))/(81.*mZ**2*pi**2*vT**2) + (4*mW**4*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(3.*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**4) - (2*mW**6*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(3.*(mW - mZ)*mZ**2*(mW + mZ)*Nc*pi**2*vT**4) - (17*mW**2*mZ**2*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(12.*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**4) + (3*mZ**4*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(8.*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**4) + (3*mW**2*mZ**4*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**4) - (3*mZ**6*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mW - mZ)*(mW + mZ)*Nc*pi**2*vT**4) - (3*mW**2*mZ**2*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*Nc*pi**2*vT**2) + (3*mZ**4*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*Nc*pi**2*vT**2) + (3*mZ**4*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*Nc*pi**2*vT**2) - (16*mW**6*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/((48*mW**2*mZ**2*Nc - 48*mZ**4*Nc)*pi**2*vT**2) + (36*mW**4*mZ**2*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/((48*mW**2*mZ**2*Nc - 48*mZ**4*Nc)*pi**2*vT**2) - (38*mW**2*mZ**4*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/((48*mW**2*mZ**2*Nc - 48*mZ**4*Nc)*pi**2*vT**2) + (9*mZ**6*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/((48*mW**2*mZ**2*Nc - 48*mZ**4*Nc)*pi**2*vT**2) + (3*mW**2*mZ**2*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*Nc*pi**2*vT**2) - (2*g1bar*mW**3*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(3.*mZ**2*Nc*pi**2*vT) + (3*g1bar*mW*mZ**2*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*Nc*pi**2*vT) - (mW**2*einsum("pt,sr",C["phiq1"],kd)*log(scale**2/mZ**2))/(4.*Nc*pi**2*vT**2) - (mW**2*einsum("pt,sr",C["phiq3"],kd)*log(scale**2/mZ**2))/(12.*Nc*pi**2*vT**2) - (2*mW**4*einsum("pt,sr",C["phiq3"],kd)*log(scale**2/mZ**2))/(3.*mZ**2*Nc*pi**2*vT**2) - (mW**2*einsum("sr,pt",C["phiq1"],kd)*log(scale**2/mZ**2))/(4.*Nc*pi**2*vT**2) - (mW**2*einsum("sr,pt",C["phiq3"],kd)*log(scale**2/mZ**2))/(12.*Nc*pi**2*vT**2) - (2*mW**4*einsum("sr,pt",C["phiq3"],kd)*log(scale**2/mZ**2))/(3.*mZ**2*Nc*pi**2*vT**2) + (11*mW**2*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mZ**2))/(81.*pi**2*vT**2) + (32*mW**6*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mZ**2))/(81.*mZ**4*pi**2*vT**2) - (43*mW**4*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mZ**2))/(81.*mZ**2*pi**2*vT**2) + (11*mW**2*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mZ**2))/(81.*pi**2*vT**2) + (32*mW**6*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mZ**2))/(81.*mZ**4*pi**2*vT**2) - (43*mW**4*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mZ**2))/(81.*mZ**2*pi**2*vT**2) + (mt**2*mW**4*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (5*mt**2*mW**2*mZ**2*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/(8.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (mW**4*mZ**2*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (3*mt**2*mZ**4*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/(16.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (mW**2*mZ**4*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/((mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (mZ**6*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (mt**2*mW**4*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (5*mt**2*mW**2*mZ**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/(8.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (mW**4*mZ**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (3*mt**2*mZ**4*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/(16.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (mW**2*mZ**4*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/((mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (mZ**6*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (3*g1bar*mt*mW**4*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT) + (5*g1bar*mt*mW**2*mZ**2*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT) + (g1bar*mW**4*mZ**2*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mZ**2))/(sqrt(2)*mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT) - (5*g1bar*mt*mZ**4*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mZ**2))/(16.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT) - (13*g1bar*mW**2*mZ**4*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mZ**2))/(8.*sqrt(2)*mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT) + (5*g1bar*mZ**6*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mZ**2))/(8.*sqrt(2)*mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT) - (3*mZ**4*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mZ**2))/(8.*sqrt(2)*mH**2*mt*Nc*pi**2*vT) + (3*mt*mW**5*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (5*mt*mW**3*mZ**2*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (5*mt*mW*mZ**4*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mZ**2))/(8.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (13*mW**3*mZ**4*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*sqrt(2)*mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (5*mW*mZ**6*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*sqrt(2)*mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (mt**2*mW**4*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (5*mt**2*mW**2*mZ**2*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/(8.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (mW**4*mZ**2*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (3*mt**2*mZ**4*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/(16.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (mW**2*mZ**4*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/((mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (mZ**6*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (mt**2*mW**4*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (5*mt**2*mW**2*mZ**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/(8.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (mW**4*mZ**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (3*mt**2*mZ**4*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/(16.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (mW**2*mZ**4*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/((mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (mZ**6*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (3*g1bar*mt*mW**4*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT) + (5*g1bar*mt*mW**2*mZ**2*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT) + (g1bar*mW**4*mZ**2*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(sqrt(2)*mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT) - (5*g1bar*mt*mZ**4*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(16.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT) - (13*g1bar*mW**2*mZ**4*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(8.*sqrt(2)*mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT) + (5*g1bar*mZ**6*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(8.*sqrt(2)*mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT) - (3*mZ**4*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(8.*sqrt(2)*mH**2*mt*Nc*pi**2*vT) + (3*mt*mW**5*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (5*mt*mW**3*mZ**2*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (5*mt*mW*mZ**4*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(8.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (13*mW**3*mZ**4*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*sqrt(2)*mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (5*mW*mZ**6*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*sqrt(2)*mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) + (2*g1bar*mW**6*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**4*pi**2*vT) - (2*g1bar*mW**4*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**2*pi**2*vT) + (2*g1bar*mW**6*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**4*pi**2*vT) - (2*g1bar*mW**4*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**2*pi**2*vT) - (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*sqrt(2))/(9.*mH**2*mZ**4*pi**2*vT) - (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*sqrt(2))/(9.*mH**2*mZ**4*pi**2*vT) - (4*mW**3*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(81.*mt*pi**2*vT**2) - (4*mW**7*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**4*pi**2*vT**2) + (8*mW**5*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**2*pi**2*vT**2) - (4*mW**3*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*pi**2*vT**2) - (4*mW**7*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**4*pi**2*vT**2) + (8*mW**5*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**2*pi**2*vT**2) - (5*mt**3*mW**9*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (5*mt**3*mW**9*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (8*g1bar*mt*mW**6*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**6*pi**2*vT) + (8*g1bar*mt*mW**6*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**6*pi**2*vT) - (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*mH**2*mZ**4*pi**2*vT) - (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*mH**2*mZ**4*pi**2*vT) - (16*mt*mW**7*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**6*pi**2*vT**2) + (19*mt*mW**5*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**4*pi**2*vT**2) - (16*mt*mW**7*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**6*pi**2*vT**2) + (19*mt*mW**5*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**4*pi**2*vT**2) + (5*mt**3*mW**9*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2)*sqrt(2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (5*mt**3*mW**9*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2)*sqrt(2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mW**5*mZ**2*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mZ**2)*sqrt(2))/(mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2) - (mW**5*mZ**2*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mZ**2)*sqrt(2))/(mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*Nc*pi**2*vT**2))
    c['V8udLL'] = ((-15*mW**2*einsum("ptsr",C["qq1"]))/(4.*pi**2*vT**2) + (bEvan*mW**2*einsum("ptsr",C["qq1"]))/(pi**2*vT**2) + (43*mW**2*einsum("ptsr",C["qq3"]))/(12.*pi**2*vT**2) - (2*bEvan*mW**2*einsum("ptsr",C["qq3"]))/(9.*pi**2*vT**2) + (7*mW**4*einsum("ptsr",C["qq3"]))/(3.*mZ**2*pi**2*vT**2) + (bEvan*mW**4*einsum("ptsr",C["qq3"]))/(9.*mZ**2*pi**2*vT**2) - (5*mZ**2*einsum("ptsr",C["qq3"]))/(12.*pi**2*vT**2) + (bEvan*mZ**2*einsum("ptsr",C["qq3"]))/(9.*pi**2*vT**2) - (15*mW**2*einsum("srpt",C["qq1"]))/(4.*pi**2*vT**2) + (bEvan*mW**2*einsum("srpt",C["qq1"]))/(pi**2*vT**2) + (43*mW**2*einsum("srpt",C["qq3"]))/(12.*pi**2*vT**2) - (2*bEvan*mW**2*einsum("srpt",C["qq3"]))/(9.*pi**2*vT**2) + (7*mW**4*einsum("srpt",C["qq3"]))/(3.*mZ**2*pi**2*vT**2) + (bEvan*mW**4*einsum("srpt",C["qq3"]))/(9.*mZ**2*pi**2*vT**2) - (5*mZ**2*einsum("srpt",C["qq3"]))/(12.*pi**2*vT**2) + (bEvan*mZ**2*einsum("srpt",C["qq3"]))/(9.*pi**2*vT**2) - (g3bar**4*einsum("pr,st",kd,kd))/(120.*mt**2*pi**2) + (131*g3bar**2*einsum("pr,st",kd,kd))/(1296.*pi**2*vT**2) + (bEvan*g3bar**2*einsum("pr,st",kd,kd))/(36.*pi**2*vT**2) + (305*g3bar**2*mW**4*einsum("pr,st",kd,kd))/(324.*mZ**4*pi**2*vT**2) - (2*bEvan*g3bar**2*mW**4*einsum("pr,st",kd,kd))/(9.*mZ**4*pi**2*vT**2) + (121*g3bar**2*mW**2*einsum("pr,st",kd,kd))/(648.*mZ**2*pi**2*vT**2) - (bEvan*g3bar**2*mW**2*einsum("pr,st",kd,kd))/(18.*mZ**2*pi**2*vT**2) + (121*g3bar**2*C["phiD"]*einsum("pr,st",kd,kd))/(2592.*pi**2) - (bEvan*g3bar**2*C["phiD"]*einsum("pr,st",kd,kd))/(72.*pi**2) + (305*g3bar**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(648.*mZ**4*pi**2) - (bEvan*g3bar**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(9.*mZ**4*pi**2) + (305*g1bar*g3bar**2*mW**3*vT*C["phiWB"]*einsum("pr,st",kd,kd))/(324.*mZ**4*pi**2) - (2*bEvan*g1bar*g3bar**2*mW**3*vT*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*mZ**4*pi**2) + (121*g1bar*g3bar**2*mW*vT*C["phiWB"]*einsum("pr,st",kd,kd))/(1296.*mZ**2*pi**2) - (bEvan*g1bar*g3bar**2*mW*vT*C["phiWB"]*einsum("pr,st",kd,kd))/(36.*mZ**2*pi**2) - (121*g3bar**2*einsum("pr,st",C["phiq1"],kd))/(432.*pi**2) + (bEvan*g3bar**2*einsum("pr,st",C["phiq1"],kd))/(12.*pi**2) - (163*g3bar**2*mW**2*einsum("pr,st",C["phiq1"],kd))/(216.*mZ**2*pi**2) + (bEvan*g3bar**2*mW**2*einsum("pr,st",C["phiq1"],kd))/(6.*mZ**2*pi**2) + (205*g3bar**2*einsum("pr,st",C["phiq3"],kd))/(432.*pi**2) - (bEvan*g3bar**2*einsum("pr,st",C["phiq3"],kd))/(12.*pi**2) + (163*g3bar**2*mW**2*einsum("pr,st",C["phiq3"],kd))/(216.*mZ**2*pi**2) - (bEvan*g3bar**2*mW**2*einsum("pr,st",C["phiq3"],kd))/(6.*mZ**2*pi**2) + (7*mH**2*einsum("pt,sr",kd,kd))/(8.*pi**2*vT**4) + (13*mW**2*einsum("pt,sr",kd,kd))/(12.*pi**2*vT**4) + (bEvan*mW**2*einsum("pt,sr",kd,kd))/(9.*pi**2*vT**4) + (mW**4*einsum("pt,sr",kd,kd))/(mH**2*pi**2*vT**4) - (7*mW**4*einsum("pt,sr",kd,kd))/(3.*mZ**2*pi**2*vT**4) - (bEvan*mW**4*einsum("pt,sr",kd,kd))/(9.*mZ**2*pi**2*vT**4) - (5*mZ**2*einsum("pt,sr",kd,kd))/(8.*pi**2*vT**4) + (mZ**4*einsum("pt,sr",kd,kd))/(2.*mH**2*pi**2*vT**4) + (mt**2*Nc*einsum("pt,sr",kd,kd))/(4.*pi**2*vT**4) - (2*mt**4*Nc*einsum("pt,sr",kd,kd))/(mH**2*pi**2*vT**4) + (15*g3bar**2*einsum("pt,sr",kd,kd))/(8.*Nc*pi**2*vT**2) - (bEvan*g3bar**2*einsum("pt,sr",kd,kd))/(2.*Nc*pi**2*vT**2) - (3*C["phi"]*einsum("pt,sr",kd,kd))/(2.*pi**2) - (mW**2*mZ**2*C["phiB"]*einsum("pt,sr",kd,kd))/(mH**2*pi**2*vT**2) + (mZ**4*C["phiB"]*einsum("pt,sr",kd,kd))/(mH**2*pi**2*vT**2) + (11*mH**2*C["phiBox"]*einsum("pt,sr",kd,kd))/(4.*pi**2*vT**2) - (5*mW**2*C["phiBox"]*einsum("pt,sr",kd,kd))/(4.*pi**2*vT**2) + (2*mW**4*C["phiBox"]*einsum("pt,sr",kd,kd))/(mH**2*pi**2*vT**2) + (mZ**4*C["phiBox"]*einsum("pt,sr",kd,kd))/(mH**2*pi**2*vT**2) - (4*mt**4*Nc*C["phiBox"]*einsum("pt,sr",kd,kd))/(mH**2*pi**2*vT**2) - (11*mH**2*C["phiD"]*einsum("pt,sr",kd,kd))/(16.*pi**2*vT**2) + (2*mW**2*C["phiD"]*einsum("pt,sr",kd,kd))/(pi**2*vT**2) - (mW**4*C["phiD"]*einsum("pt,sr",kd,kd))/(2.*mH**2*pi**2*vT**2) - (7*mW**4*C["phiD"]*einsum("pt,sr",kd,kd))/(6.*mZ**2*pi**2*vT**2) - (bEvan*mW**4*C["phiD"]*einsum("pt,sr",kd,kd))/(18.*mZ**2*pi**2*vT**2) - (5*mZ**2*C["phiD"]*einsum("pt,sr",kd,kd))/(16.*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pt,sr",kd,kd))/(mH**2*pi**2*vT**2) + (2*mW**4*C["phiW"]*einsum("pt,sr",kd,kd))/(mH**2*pi**2*vT**2) + (mW**2*mZ**2*C["phiW"]*einsum("pt,sr",kd,kd))/(mH**2*pi**2*vT**2) + (3*g1bar*mW*C["phiWB"]*einsum("pt,sr",kd,kd))/(2.*pi**2*vT) - (7*g1bar*mW**3*C["phiWB"]*einsum("pt,sr",kd,kd))/(3.*mZ**2*pi**2*vT) - (bEvan*g1bar*mW**3*C["phiWB"]*einsum("pt,sr",kd,kd))/(9.*mZ**2*pi**2*vT) + (g1bar*mW*mZ**2*C["phiWB"]*einsum("pt,sr",kd,kd))/(2.*mH**2*pi**2*vT) + (15*g3bar**2*einsum("pt,sr",C["phiq3"],kd))/(8.*Nc*pi**2) - (bEvan*g3bar**2*einsum("pt,sr",C["phiq3"],kd))/(2.*Nc*pi**2) - (19*mW**2*einsum("pt,sr",C["phiq3"],kd))/(6.*pi**2*vT**2) + (bEvan*mW**2*einsum("pt,sr",C["phiq3"],kd))/(9.*pi**2*vT**2) - (7*mW**4*einsum("pt,sr",C["phiq3"],kd))/(3.*mZ**2*pi**2*vT**2) - (bEvan*mW**4*einsum("pt,sr",C["phiq3"],kd))/(9.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("pt,sr",C["phiq3"],kd))/(4.*pi**2*vT**2) + (15*g3bar**2*einsum("sr,pt",C["phiq3"],kd))/(8.*Nc*pi**2) - (bEvan*g3bar**2*einsum("sr,pt",C["phiq3"],kd))/(2.*Nc*pi**2) - (19*mW**2*einsum("sr,pt",C["phiq3"],kd))/(6.*pi**2*vT**2) + (bEvan*mW**2*einsum("sr,pt",C["phiq3"],kd))/(9.*pi**2*vT**2) - (7*mW**4*einsum("sr,pt",C["phiq3"],kd))/(3.*mZ**2*pi**2*vT**2) - (bEvan*mW**4*einsum("sr,pt",C["phiq3"],kd))/(9.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("sr,pt",C["phiq3"],kd))/(4.*pi**2*vT**2) - (121*g3bar**2*einsum("st,pr",C["phiq1"],kd))/(432.*pi**2) + (bEvan*g3bar**2*einsum("st,pr",C["phiq1"],kd))/(12.*pi**2) + (71*g3bar**2*mW**2*einsum("st,pr",C["phiq1"],kd))/(54.*mZ**2*pi**2) - (bEvan*g3bar**2*mW**2*einsum("st,pr",C["phiq1"],kd))/(3.*mZ**2*pi**2) - (37*g3bar**2*einsum("st,pr",C["phiq3"],kd))/(432.*pi**2) + (bEvan*g3bar**2*einsum("st,pr",C["phiq3"],kd))/(12.*pi**2) + (71*g3bar**2*mW**2*einsum("st,pr",C["phiq3"],kd))/(54.*mZ**2*pi**2) - (bEvan*g3bar**2*mW**2*einsum("st,pr",C["phiq3"],kd))/(3.*mZ**2*pi**2) - (3*mt**4*einsum("pTsr,tT,TT",C["qq3"],kd,kdt))/(16.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("pTsr,tT,TT",C["qq3"],kd,kdt))/(16.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("ptTr,sT,TT",C["qq3"],kd,kdt))/(16.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("ptTr,sT,TT",C["qq3"],kd,kdt))/(16.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (g3bar**2*einsum("pTTr,st,TT",C["qq1"],kd,kdt))/(24.*pi**2) + (g3bar**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(24.*pi**2) - (mt**2*Nc*einsum("ptTT,sr,TT",C["qq3"],kd,kdt))/(4.*pi**2*vT**2) + (mt**2*einsum("pTTt,sr,TT",C["qq1"],kd,kdt))/(8.*pi**2*vT**2) - (mt**2*einsum("pTTt,sr,TT",C["qq3"],kd,kdt))/(8.*pi**2*vT**2) - (3*mt**4*einsum("srpT,tT,TT",C["qq3"],kd,kdt))/(16.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("srpT,tT,TT",C["qq3"],kd,kdt))/(16.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (mt**2*Nc*einsum("srTT,pt,TT",C["qq3"],kd,kdt))/(4.*pi**2*vT**2) + (mt**2*einsum("sTTr,pt,TT",C["qq1"],kd,kdt))/(8.*pi**2*vT**2) - (mt**2*einsum("sTTr,pt,TT",C["qq3"],kd,kdt))/(8.*pi**2*vT**2) + (g3bar**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(12.*pi**2) - (3*mt**4*einsum("Trpt,sT,TT",C["qq3"],kd,kdt))/(16.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("Trpt,sT,TT",C["qq3"],kd,kdt))/(16.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (g3bar**2*einsum("TrpT,st,TT",C["qq1"],kd,kdt))/(24.*pi**2) + (g3bar**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(24.*pi**2) + (mt**2*einsum("TrsT,pt,TT",C["qq1"],kd,kdt))/(8.*pi**2*vT**2) - (mt**2*einsum("TrsT,pt,TT",C["qq3"],kd,kdt))/(8.*pi**2*vT**2) + (mt**2*einsum("TtpT,sr,TT",C["qq1"],kd,kdt))/(8.*pi**2*vT**2) - (mt**2*einsum("TtpT,sr,TT",C["qq3"],kd,kdt))/(8.*pi**2*vT**2) - (mt**2*Nc*einsum("TTpt,sr,TT",C["qq3"],kd,kdt))/(4.*pi**2*vT**2) - (mt**2*Nc*einsum("TTsr,pt,TT",C["qq3"],kd,kdt))/(4.*pi**2*vT**2) + (g3bar**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(12.*pi**2) - (7*g3bar**2*mt**6*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(96.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (35*g3bar**2*mt**4*mW**2*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(96.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (7*g3bar**2*mt**2*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(16.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (g3bar**2*mW**6*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(12.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**4*einsum("prTT,sT,tT,TT",C["qu8"],kd,kd,kdt))/(32.*(mt**2 - mW**2)*pi**2*vT**2) + (7*mt**2*mW**2*einsum("prTT,sT,tT,TT",C["qu8"],kd,kd,kdt))/(32.*(mt**2 - mW**2)*pi**2*vT**2) - (9*mt**2*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt))/(16.*pi**2*vT**2) - (5*mW**2*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt))/(6.*pi**2*vT**2) + (11*mZ**2*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt))/(24.*pi**2*vT**2) + (3*mt**4*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt))/(16.*(mt**2 - mW**2)*pi**2*vT**2) + (103*mt**2*mW**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt))/(48.*(mt**2 - mW**2)*pi**2*vT**2) - (19*mW**4*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt))/(12.*(mt**2 - mW**2)*pi**2*vT**2) - (11*mt**2*mZ**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt))/(24.*(mt**2 - mW**2)*pi**2*vT**2) + (11*mW**2*mZ**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt))/(24.*(mt**2 - mW**2)*pi**2*vT**2) - (7*g1bar*mt*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt))/(48.*sqrt(2)*pi**2*vT) - (5*g1bar*mZ**2*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt))/(12.*sqrt(2)*mt*pi**2*vT) - (5*cf*g3bar*mt*einsum("pT,sr,tT,TT",C["uG"],kd,kd,kdt))/(4.*sqrt(2)*pi**2*vT) + (7*mt*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt))/(16.*sqrt(2)*pi**2*vT) - (mW**4*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt))/(2.*sqrt(2)*mH**2*mt*pi**2*vT) - (mZ**4*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt))/(4.*sqrt(2)*mH**2*mt*pi**2*vT) + (mt**3*Nc*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt))/(sqrt(2)*mH**2*pi**2*vT) + (3*mt**3*mW*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt))/(2.*sqrt(2)*(mt - mW)*(mt + mW)*pi**2*vT**2) - (55*mt*mW**3*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt))/(12.*sqrt(2)*(mt - mW)*(mt + mW)*pi**2*vT**2) + (7*mW**5*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt))/(3.*sqrt(2)*mt*(mt - mW)*(mt + mW)*pi**2*vT**2) + (5*mt*mW*mZ**2*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt))/(6.*sqrt(2)*(mt - mW)*(mt + mW)*pi**2*vT**2) - (5*mW**3*mZ**2*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt))/(6.*sqrt(2)*mt*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**2*einsum("pTTr,sT,tT,TT",C["qq1"],kd,kd,kdt))/(4.*pi**2*vT**2) + (mt**2*einsum("pTTr,sT,tT,TT",C["qq3"],kd,kd,kdt))/(4.*pi**2*vT**2) + (mt**2*einsum("pTTT,sr,tT,TT",C["qu1"],kd,kd,kdt))/(2.*pi**2*vT**2) + (cf*mt**2*einsum("pTTT,sr,tT,TT",C["qu8"],kd,kd,kdt))/(2.*pi**2*vT**2) - (7*g3bar**2*mt**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(96.*(mt - mW)**3*(mt + mW)**3*pi**2) + (35*g3bar**2*mt**4*mW**2*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(96.*(mt - mW)**3*(mt + mW)**3*pi**2) - (7*g3bar**2*mt**2*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(16.*(mt - mW)**3*(mt + mW)**3*pi**2) + (g3bar**2*mW**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(12.*(mt - mW)**3*(mt + mW)**3*pi**2) + (5*g3bar**2*mt**5*mW*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(48.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2) - (19*g3bar**2*mt**3*mW**3*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(48.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2) + (5*g3bar**2*mt*mW**5*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2) - (9*mt**2*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt))/(16.*pi**2*vT**2) - (5*mW**2*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt))/(6.*pi**2*vT**2) + (11*mZ**2*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt))/(24.*pi**2*vT**2) + (3*mt**4*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt))/(16.*(mt**2 - mW**2)*pi**2*vT**2) + (103*mt**2*mW**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt))/(48.*(mt**2 - mW**2)*pi**2*vT**2) - (19*mW**4*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt))/(12.*(mt**2 - mW**2)*pi**2*vT**2) - (11*mt**2*mZ**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt))/(24.*(mt**2 - mW**2)*pi**2*vT**2) + (11*mW**2*mZ**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt))/(24.*(mt**2 - mW**2)*pi**2*vT**2) - (7*g1bar*mt*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt))/(48.*sqrt(2)*pi**2*vT) - (5*g1bar*mZ**2*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt))/(12.*sqrt(2)*mt*pi**2*vT) - (5*cf*g3bar*mt*einsum("Tr,pt,sT,TT",C["uGDag"],kd,kd,kdt))/(4.*sqrt(2)*pi**2*vT) + (7*mt*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt))/(16.*sqrt(2)*pi**2*vT) - (mW**4*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt))/(2.*sqrt(2)*mH**2*mt*pi**2*vT) - (mZ**4*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt))/(4.*sqrt(2)*mH**2*mt*pi**2*vT) + (mt**3*Nc*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt))/(sqrt(2)*mH**2*pi**2*vT) + (3*mt**3*mW*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt))/(2.*sqrt(2)*(mt - mW)*(mt + mW)*pi**2*vT**2) - (55*mt*mW**3*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt))/(12.*sqrt(2)*(mt - mW)*(mt + mW)*pi**2*vT**2) + (7*mW**5*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt))/(3.*sqrt(2)*mt*(mt - mW)*(mt + mW)*pi**2*vT**2) + (5*mt*mW*mZ**2*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt))/(6.*sqrt(2)*(mt - mW)*(mt + mW)*pi**2*vT**2) - (5*mW**3*mZ**2*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt))/(6.*sqrt(2)*mt*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**2*einsum("TrpT,sT,tT,TT",C["qq1"],kd,kd,kdt))/(4.*pi**2*vT**2) + (mt**2*einsum("TrpT,sT,tT,TT",C["qq3"],kd,kd,kdt))/(4.*pi**2*vT**2) + (mt**2*einsum("TrTT,pt,sT,TT",C["qu1"],kd,kd,kdt))/(2.*pi**2*vT**2) + (cf*mt**2*einsum("TrTT,pt,sT,TT",C["qu8"],kd,kd,kdt))/(2.*pi**2*vT**2) - (7*g3bar**2*mt**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(96.*(mt - mW)**3*(mt + mW)**3*pi**2) + (35*g3bar**2*mt**4*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(96.*(mt - mW)**3*(mt + mW)**3*pi**2) - (7*g3bar**2*mt**2*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(16.*(mt - mW)**3*(mt + mW)**3*pi**2) + (g3bar**2*mW**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(12.*(mt - mW)**3*(mt + mW)**3*pi**2) + (5*g3bar**2*mt**5*mW*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(48.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2) - (19*g3bar**2*mt**3*mW**3*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(48.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2) + (5*g3bar**2*mt*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2) + (g3bar**3*vT*einsum("TT,pr,st,TT",C["uG"],kd,kd,kdt))/(24.*sqrt(2)*mt*pi**2) + (g3bar**3*vT*einsum("TT,pr,st,TT",C["uGDag"],kd,kd,kdt))/(24.*sqrt(2)*mt*pi**2) + (mt**2*Nc*einsum("TT,pt,sr,TT",C["phiq3"],kd,kd,kdt))/(2.*pi**2*vT**2) + (mt**3*Nc*einsum("TT,pt,sr,TT",C["uphi"],kd,kd,kdt))/(sqrt(2)*mH**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pt,sr,TT",C["uphiDag"],kd,kd,kdt))/(sqrt(2)*mH**2*pi**2*vT) - (g3bar*mt**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uG"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT) - (3*g3bar*mt**3*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uG"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT) + (g3bar*mt*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uG"],kdt))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT) - (g3bar*mt**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uGDag"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT) - (3*g3bar*mt**3*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uGDag"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT) + (g3bar*mt*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uGDag"],kdt))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT) + (3*mH**4*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(4.*(mH**2 - mW**2)*pi**2*vT**4) - (3*mH**2*mW**2*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(2.*(mH**2 - mW**2)*pi**2*vT**4) - (3*C["phi"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(2.*pi**2) + (5*mH**4*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/((2*mH**2 - 2*mW**2)*pi**2*vT**2) - (8*mH**2*mW**2*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/((2*mH**2 - 2*mW**2)*pi**2*vT**2) - (5*mH**4*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(8.*(mH**2 - mW**2)*pi**2*vT**2) + (mH**2*mW**2*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/((mH**2 - mW**2)*pi**2*vT**2) + (3*mH**4*mt*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mH**2))/(8.*sqrt(2)*(mH - mt)*(mH + mt)*(mH - mW)*(mH + mW)*pi**2*vT) - (3*mH**2*mt*mW**2*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mH**2))/(4.*sqrt(2)*(mH - mt)*(mH + mt)*(mH - mW)*(mH + mW)*pi**2*vT) + (3*mH**4*mt*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mH**2))/(8.*sqrt(2)*(mH - mt)*(mH + mt)*(mH - mW)*(mH + mW)*pi**2*vT) - (3*mH**2*mt*mW**2*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mH**2))/(4.*sqrt(2)*(mH - mt)*(mH + mt)*(mH - mW)*(mH + mW)*pi**2*vT) + (mt**2*Nc*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(2.*pi**2*vT**4) - (2*mt**4*Nc*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(mH**2*pi**2*vT**4) - (4*mt**4*Nc*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(mH**2*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(mH**2*pi**2*vT**2) + (mt**2*Nc*einsum("pt,sr",C["phiq3"],kd)*log(scale**2/mt**2))/(2.*pi**2*vT**2) + (mt**2*Nc*einsum("sr,pt",C["phiq3"],kd)*log(scale**2/mt**2))/(2.*pi**2*vT**2) - (g3bar**2*einsum("prTT,st,TT",C["qu8"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2) - (3*mt**2*mW**2*einsum("pTsr,tT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(4.*(mt**2 - mW**2)*pi**2*vT**2) - (mt**6*einsum("pTsr,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("pTsr,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/((mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (5*mt**2*mW**4*einsum("pTsr,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**2*mW**2*einsum("ptTr,sT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(4.*(mt**2 - mW**2)*pi**2*vT**2) - (mt**6*einsum("ptTr,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("ptTr,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/((mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (5*mt**2*mW**4*einsum("ptTr,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (g3bar**2*einsum("pTTr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2) - (g3bar**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2) - (mt**2*Nc*einsum("ptTT,sr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(2.*pi**2*vT**2) - (mt**2*einsum("pTTt,sr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(4.*pi**2*vT**2) + (mt**2*einsum("pTTt,sr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(4.*pi**2*vT**2) - (3*mt**2*mW**2*einsum("srpT,tT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(4.*(mt**2 - mW**2)*pi**2*vT**2) - (mt**6*einsum("srpT,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("srpT,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/((mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (5*mt**2*mW**4*einsum("srpT,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*Nc*einsum("srTT,pt,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(2.*pi**2*vT**2) - (mt**2*einsum("sTTr,pt,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(4.*pi**2*vT**2) + (mt**2*einsum("sTTr,pt,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(4.*pi**2*vT**2) - (g3bar**2*einsum("stTT,pr,TT",C["qu8"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2) - (g3bar**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*pi**2) - (3*mt**2*mW**2*einsum("Trpt,sT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(4.*(mt**2 - mW**2)*pi**2*vT**2) - (mt**6*einsum("Trpt,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("Trpt,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/((mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (5*mt**2*mW**4*einsum("Trpt,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (g3bar**2*einsum("TrpT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2) - (g3bar**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2) - (mt**2*einsum("TrsT,pt,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(4.*pi**2*vT**2) + (mt**2*einsum("TrsT,pt,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(4.*pi**2*vT**2) - (mt**2*einsum("TtpT,sr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(4.*pi**2*vT**2) + (mt**2*einsum("TtpT,sr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(4.*pi**2*vT**2) - (mt**2*Nc*einsum("TTpt,sr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(2.*pi**2*vT**2) - (mt**2*Nc*einsum("TTsr,pt,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(2.*pi**2*vT**2) - (g3bar**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*pi**2) + (3*g3bar**2*mt**4*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (g3bar**2*mt**2*mW**6*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(3.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (g3bar**2*mW**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt**6*einsum("prTT,sT,tT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("prTT,sT,tT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("prTT,sT,tT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (5*mt**6*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (3*mt**4*mW**2*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (mt**2*mW**4*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (5*mt**4*mZ**2*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*pi**2*vT**2) - (3*mt**2*mW**2*mZ**2*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*pi**2*vT**2) - (mt**8*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (mt**6*mW**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (mt**4*mW**4*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (mt**2*mW**6*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) - (mt**6*mZ**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (5*mt**4*mW**2*mZ**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) - (3*mt**2*mW**4*mZ**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) - (5*g1bar*mt**5*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*pi**2*vT) + (3*g1bar*mt**3*mW**2*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*pi**2*vT) - (g1bar*mt*mW**4*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*pi**2*vT) - (3*cf*g3bar*mt**3*einsum("pT,sr,tT,TT",C["uG"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)*(mt + mW)*pi**2*vT) + (3*cf*g3bar*mt*mW**2*einsum("pT,sr,tT,TT",C["uG"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)*(mt + mW)*pi**2*vT) - (3*g3bar*mt*mW**2*einsum("pT,sr,tT,TT",C["uG"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)*(mt + mW)*Nc*pi**2*vT) - (3*mt**5*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) + (3*mt**3*mW**2*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) + (mt**5*Nc*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) - (mt**7*Nc*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*mH**2*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) - (mt**3*mW**2*Nc*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) + (mt**5*mW**2*Nc*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*mH**2*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) - (5*mt**5*mW**3*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (3*mt**3*mW**5*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) - (mt*mW**7*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (5*mt**5*mW*mZ**2*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) - (3*mt**3*mW**3*mZ**2*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (mt*mW**5*mZ**2*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (mt**2*einsum("pTTT,sr,tT,TT",C["qu1"],kd,kd,kdt)*log(scale**2/mt**2))/(pi**2*vT**2) + (cf*mt**2*einsum("pTTT,sr,tT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mt**2))/(pi**2*vT**2) + (3*g3bar**2*mt**4*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**4*(mt + mW)**4*pi**2) - (g3bar**2*mt**2*mW**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*(mt - mW)**4*(mt + mW)**4*pi**2) + (g3bar**2*mW**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2) + (g3bar*mt*mW**2*einsum("sT,pr,tT,TT",C["uG"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*(4*mt**2 - 4*mW**2)*pi**2*vT) - (g3bar**2*mt**3*mW**5*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2) + (g3bar**2*mt*mW**7*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2) - (5*mt**6*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (3*mt**4*mW**2*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (mt**2*mW**4*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (5*mt**4*mZ**2*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*pi**2*vT**2) - (3*mt**2*mW**2*mZ**2*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*pi**2*vT**2) - (mt**8*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (mt**6*mW**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (mt**4*mW**4*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (mt**2*mW**6*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) - (mt**6*mZ**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (5*mt**4*mW**2*mZ**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) - (3*mt**2*mW**4*mZ**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) - (5*g1bar*mt**5*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*pi**2*vT) + (3*g1bar*mt**3*mW**2*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*pi**2*vT) - (g1bar*mt*mW**4*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*pi**2*vT) - (3*cf*g3bar*mt**3*einsum("Tr,pt,sT,TT",C["uGDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)*(mt + mW)*pi**2*vT) + (3*cf*g3bar*mt*mW**2*einsum("Tr,pt,sT,TT",C["uGDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)*(mt + mW)*pi**2*vT) - (3*g3bar*mt*mW**2*einsum("Tr,pt,sT,TT",C["uGDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)*(mt + mW)*Nc*pi**2*vT) - (3*mt**5*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) + (3*mt**3*mW**2*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) + (mt**5*Nc*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) - (mt**7*Nc*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*mH**2*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) - (mt**3*mW**2*Nc*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) + (mt**5*mW**2*Nc*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*mH**2*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) - (5*mt**5*mW**3*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (3*mt**3*mW**5*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) - (mt*mW**7*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (5*mt**5*mW*mZ**2*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) - (3*mt**3*mW**3*mZ**2*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (mt*mW**5*mZ**2*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (mt**2*einsum("TrTT,pt,sT,TT",C["qu1"],kd,kd,kdt)*log(scale**2/mt**2))/(pi**2*vT**2) + (cf*mt**2*einsum("TrTT,pt,sT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mt**2))/(pi**2*vT**2) + (3*g3bar**2*mt**4*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**4*(mt + mW)**4*pi**2) - (g3bar**2*mt**2*mW**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*(mt - mW)**4*(mt + mW)**4*pi**2) + (g3bar**2*mW**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2) + (g3bar*mt*mW**2*einsum("Tt,pr,sT,TT",C["uGDag"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*(4*mt**2 - 4*mW**2)*pi**2*vT) - (g3bar**2*mt**3*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2) + (g3bar**2*mt*mW**7*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2) + (mt**2*Nc*einsum("TT,pt,sr,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(pi**2*vT**2) + (mt**3*Nc*einsum("TT,pt,sr,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*mH**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pt,sr,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*mH**2*pi**2*vT) - (g3bar*mt**5*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uG"],kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT) + (g3bar*mt**3*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uG"],kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT) - (g3bar*mt**5*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uGDag"],kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT) + (g3bar*mt**3*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uGDag"],kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT) - (3*mW**2*einsum("ptsr",C["qq1"])*log(scale**2/mW**2))/(2.*pi**2*vT**2) + (3*mW**2*einsum("ptsr",C["qq3"])*log(scale**2/mW**2))/(2.*pi**2*vT**2) - (3*mW**2*einsum("srpt",C["qq1"])*log(scale**2/mW**2))/(2.*pi**2*vT**2) + (3*mW**2*einsum("srpt",C["qq3"])*log(scale**2/mW**2))/(2.*pi**2*vT**2) - (g3bar**2*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*pi**2*vT**2) - (g3bar**2*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mW**2))/(6.*pi**2) - (3*mH**2*mW**4*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(4.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**4) + (9*mW**6*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(2.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**4) - (3*mW**8*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(mH**2*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**4) + (3*mH**2*mW**2*mZ**2*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(2.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**4) - (21*mW**4*mZ**2*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(4.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**4) + (3*mW**6*mZ**2*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(mH**2*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**4) + (3*g3bar**2*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(4.*Nc*pi**2*vT**2) + (15*mH**2*mW**4*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/((2*mH**4 - 2*mH**2*mW**2)*pi**2*vT**2) - (12*mW**6*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/((2*mH**4 - 2*mH**2*mW**2)*pi**2*vT**2) + (7*mH**2*mW**4*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(24.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**2) - (13*mW**6*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(6.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (3*mW**8*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (mH**2*mW**2*mZ**2*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(12.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (43*mW**4*mZ**2*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(24.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**2) - (3*mW**6*mZ**2*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (6*mW**4*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(mH**2*pi**2*vT**2) + (mW**2*einsum("pt,sr",C["phiq1"],kd)*log(scale**2/mW**2))/(2.*pi**2*vT**2) + (3*g3bar**2*einsum("pt,sr",C["phiq3"],kd)*log(scale**2/mW**2))/(4.*Nc*pi**2) - (3*mW**2*einsum("pt,sr",C["phiq3"],kd)*log(scale**2/mW**2))/(2.*pi**2*vT**2) + (mW**2*einsum("sr,pt",C["phiq1"],kd)*log(scale**2/mW**2))/(2.*pi**2*vT**2) + (3*g3bar**2*einsum("sr,pt",C["phiq3"],kd)*log(scale**2/mW**2))/(4.*Nc*pi**2) - (3*mW**2*einsum("sr,pt",C["phiq3"],kd)*log(scale**2/mW**2))/(2.*pi**2*vT**2) - (g3bar**2*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mW**2))/(6.*pi**2) + (3*mt**2*mW**2*einsum("pTsr,tT,TT",C["qq1"],kd,kdt)*log(scale**2/mW**2))/(4.*(mt**2 - mW**2)*pi**2*vT**2) - (3*mt**4*mW**2*einsum("pTsr,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (9*mt**2*mW**4*einsum("pTsr,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**2*einsum("ptTr,sT,TT",C["qq1"],kd,kdt)*log(scale**2/mW**2))/(4.*(mt**2 - mW**2)*pi**2*vT**2) - (3*mt**4*mW**2*einsum("ptTr,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (9*mt**2*mW**4*einsum("ptTr,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**2*einsum("srpT,tT,TT",C["qq1"],kd,kdt)*log(scale**2/mW**2))/(4.*(mt**2 - mW**2)*pi**2*vT**2) - (3*mt**4*mW**2*einsum("srpT,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (9*mt**2*mW**4*einsum("srpT,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**2*einsum("Trpt,sT,TT",C["qq1"],kd,kdt)*log(scale**2/mW**2))/(4.*(mt**2 - mW**2)*pi**2*vT**2) - (3*mt**4*mW**2*einsum("Trpt,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (9*mt**2*mW**4*einsum("Trpt,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (g3bar**2*mt**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (g3bar**2*mt**6*mW**2*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(3.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*g3bar**2*mt**4*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (3*mt**2*mW**4*einsum("prTT,sT,tT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (5*mt**2*mW**4*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)*(mt + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (mt**2*mW**2*mZ**2*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)*(mt + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (mt**6*mW**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (mt**4*mW**4*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) - (9*mt**2*mW**6*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) - (mt**6*mZ**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (mt**4*mW**2*mZ**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (3*mt**2*mW**4*mZ**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (3*g1bar*mt*mW**4*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*sqrt(2)*(mt - mW)*(mt + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT) + (3*g3bar*mt*mW**2*einsum("pT,sr,tT,TT",C["uG"],kd,kd,kdt)*log(scale**2/mW**2))/(sqrt(2)*(4*mt**2*Nc - 4*mW**2*Nc)*pi**2*vT) - (15*mt*mW**4*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*sqrt(2)*(mH - mW)*(mt - mW)*(mH + mW)*(mt + mW)*pi**2*vT) + (3*mW**6*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*mt*(mH - mW)*(mt - mW)*(mH + mW)*(mt + mW)*pi**2*vT) + (3*mt*mW**6*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*mH**2*(mH - mW)*(mt - mW)*(mH + mW)*(mt + mW)*pi**2*vT) - (3*mW**8*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*mH**2*mt*(mH - mW)*(mt - mW)*(mH + mW)*(mt + mW)*pi**2*vT) - (11*mt**3*mW**5*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (13*mt*mW**7*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) - (3*mW**9*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(sqrt(2)*mt*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) - (23*mt*mW**5*mZ**2*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (3*mW**7*mZ**2*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(sqrt(2)*mt*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (g3bar**2*mt**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2) - (g3bar**2*mt**6*mW**2*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(3.*(mt - mW)**4*(mt + mW)**4*pi**2) + (5*g3bar**2*mt**4*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**4*(mt + mW)**4*pi**2) - (g3bar*mt*mW**2*einsum("sT,pr,tT,TT",C["uG"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt**2 - mW**2)*pi**2*vT) + (g3bar**2*mt**3*mW**5*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2) - (g3bar**2*mt*mW**7*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2) - (5*mt**2*mW**4*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)*(mt + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (mt**2*mW**2*mZ**2*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)*(mt + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (mt**6*mW**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (mt**4*mW**4*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) - (9*mt**2*mW**6*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) - (mt**6*mZ**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (mt**4*mW**2*mZ**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (3*mt**2*mW**4*mZ**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (3*g1bar*mt*mW**4*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*sqrt(2)*(mt - mW)*(mt + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT) + (3*g3bar*mt*mW**2*einsum("Tr,pt,sT,TT",C["uGDag"],kd,kd,kdt)*log(scale**2/mW**2))/(sqrt(2)*(4*mt**2*Nc - 4*mW**2*Nc)*pi**2*vT) - (15*mt*mW**4*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*sqrt(2)*(mH - mW)*(mt - mW)*(mH + mW)*(mt + mW)*pi**2*vT) + (3*mW**6*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*mt*(mH - mW)*(mt - mW)*(mH + mW)*(mt + mW)*pi**2*vT) + (3*mt*mW**6*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*mH**2*(mH - mW)*(mt - mW)*(mH + mW)*(mt + mW)*pi**2*vT) - (3*mW**8*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*mH**2*mt*(mH - mW)*(mt - mW)*(mH + mW)*(mt + mW)*pi**2*vT) - (11*mt**3*mW**5*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (13*mt*mW**7*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) - (3*mW**9*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(sqrt(2)*mt*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) - (23*mt*mW**5*mZ**2*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (3*mW**7*mZ**2*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(sqrt(2)*mt*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (g3bar**2*mt**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2) - (g3bar**2*mt**6*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(3.*(mt - mW)**4*(mt + mW)**4*pi**2) + (5*g3bar**2*mt**4*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**4*(mt + mW)**4*pi**2) - (g3bar*mt*mW**2*einsum("Tt,pr,sT,TT",C["uGDag"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt**2 - mW**2)*pi**2*vT) + (g3bar**2*mt**3*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2) - (g3bar**2*mt*mW**7*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2) + (g3bar*mt**5*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uG"],kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT) - (g3bar*mt**3*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uG"],kdt)*log(scale**2/mW**2))/(8.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT) + (g3bar*mt**5*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uGDag"],kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT) - (g3bar*mt**3*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uGDag"],kdt)*log(scale**2/mW**2))/(8.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT) + (mW**2*einsum("ptsr",C["qq3"])*log(scale**2/mZ**2))/(3.*pi**2*vT**2) + (4*mW**4*einsum("ptsr",C["qq3"])*log(scale**2/mZ**2))/(3.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("ptsr",C["qq3"])*log(scale**2/mZ**2))/(6.*pi**2*vT**2) + (mW**2*einsum("srpt",C["qq3"])*log(scale**2/mZ**2))/(3.*pi**2*vT**2) + (4*mW**4*einsum("srpt",C["qq3"])*log(scale**2/mZ**2))/(3.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("srpt",C["qq3"])*log(scale**2/mZ**2))/(6.*pi**2*vT**2) - (11*g3bar**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(216.*pi**2*vT**2) + (13*g3bar**2*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(54.*mZ**4*pi**2*vT**2) + (11*g3bar**2*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(108.*mZ**2*pi**2*vT**2) + (11*g3bar**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(432.*pi**2) + (13*g3bar**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(108.*mZ**4*pi**2) + (13*g1bar*g3bar**2*mW**3*vT*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(54.*mZ**4*pi**2) + (11*g1bar*g3bar**2*mW*vT*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(216.*mZ**2*pi**2) - (11*g3bar**2*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mZ**2))/(72.*pi**2) - (5*g3bar**2*mW**2*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mZ**2))/(36.*mZ**2*pi**2) + (11*g3bar**2*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mZ**2))/(72.*pi**2) + (5*g3bar**2*mW**2*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mZ**2))/(36.*mZ**2*pi**2) + (8*mW**4*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(3.*(mW - mZ)*(mW + mZ)*pi**2*vT**4) - (4*mW**6*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(3.*(mW - mZ)*mZ**2*(mW + mZ)*pi**2*vT**4) - (17*mW**2*mZ**2*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(6.*(mW - mZ)*(mW + mZ)*pi**2*vT**4) + (3*mZ**4*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(4.*(mW - mZ)*(mW + mZ)*pi**2*vT**4) + (3*mW**2*mZ**4*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*(mW - mZ)*(mW + mZ)*pi**2*vT**4) - (3*mZ**6*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*(mW - mZ)*(mW + mZ)*pi**2*vT**4) - (3*mW**2*mZ**2*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(mH**2*pi**2*vT**2) + (3*mZ**4*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(mH**2*pi**2*vT**2) + (3*mZ**4*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(mH**2*pi**2*vT**2) - (3*mW**4*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(2.*(-mW**2 + mZ**2)*pi**2*vT**2) + (2*mW**6*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(3.*mZ**2*(-mW**2 + mZ**2)*pi**2*vT**2) + (19*mW**2*mZ**2*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(12.*(-mW**2 + mZ**2)*pi**2*vT**2) - (3*mZ**4*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(8.*(-mW**2 + mZ**2)*pi**2*vT**2) + (3*mW**2*mZ**2*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(mH**2*pi**2*vT**2) - (4*g1bar*mW**3*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(3.*mZ**2*pi**2*vT) + (3*g1bar*mW*mZ**2*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*pi**2*vT) - (mW**2*einsum("pt,sr",C["phiq1"],kd)*log(scale**2/mZ**2))/(2.*pi**2*vT**2) - (mW**2*einsum("pt,sr",C["phiq3"],kd)*log(scale**2/mZ**2))/(6.*pi**2*vT**2) - (4*mW**4*einsum("pt,sr",C["phiq3"],kd)*log(scale**2/mZ**2))/(3.*mZ**2*pi**2*vT**2) - (mW**2*einsum("sr,pt",C["phiq1"],kd)*log(scale**2/mZ**2))/(2.*pi**2*vT**2) - (mW**2*einsum("sr,pt",C["phiq3"],kd)*log(scale**2/mZ**2))/(6.*pi**2*vT**2) - (4*mW**4*einsum("sr,pt",C["phiq3"],kd)*log(scale**2/mZ**2))/(3.*mZ**2*pi**2*vT**2) - (11*g3bar**2*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mZ**2))/(72.*pi**2) + (4*g3bar**2*mW**2*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mZ**2))/(9.*mZ**2*pi**2) - (11*g3bar**2*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mZ**2))/(72.*pi**2) + (4*g3bar**2*mW**2*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mZ**2))/(9.*mZ**2*pi**2) + (mt**2*mW**4*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (5*mt**2*mW**2*mZ**2*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (mW**4*mZ**2*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/((mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) + (3*mt**2*mZ**4*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/(8.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) + (2*mW**2*mZ**4*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/((mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (mZ**6*einsum("pT,sr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/((mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (mt**2*mW**4*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) + (5*mt**2*mW**2*mZ**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) + (mW**4*mZ**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/((mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (3*mt**2*mZ**4*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/(8.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (2*mW**2*mZ**4*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/((mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) + (mZ**6*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/((mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (3*g1bar*mt*mW**4*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT) + (5*g1bar*mt*mW**2*mZ**2*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT) - (5*g1bar*mt*mZ**4*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mZ**2))/(8.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT) - (13*g1bar*mW**2*mZ**4*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*sqrt(2)*mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT) + (5*g1bar*mZ**6*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*sqrt(2)*mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT) - (3*mZ**4*einsum("pT,sr,tT,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*sqrt(2)*mH**2*mt*pi**2*vT) + (3*mt*mW**5*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mZ**2))/(sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (5*mt*mW**3*mZ**2*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mZ**2))/(sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) + (5*mt*mW*mZ**4*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) + (13*mW**3*mZ**4*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*sqrt(2)*mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (5*mW*mZ**6*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*sqrt(2)*mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) + (mt**2*mW**4*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (5*mt**2*mW**2*mZ**2*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (mW**4*mZ**2*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/((mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) + (3*mt**2*mZ**4*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/(8.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) + (2*mW**2*mZ**4*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/((mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (mZ**6*einsum("Tr,pt,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/((mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (mt**2*mW**4*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) + (5*mt**2*mW**2*mZ**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) + (mW**4*mZ**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/((mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (3*mt**2*mZ**4*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/(8.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (2*mW**2*mZ**4*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/((mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) + (mZ**6*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/((mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (3*g1bar*mt*mW**4*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT) + (5*g1bar*mt*mW**2*mZ**2*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT) - (5*g1bar*mt*mZ**4*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(8.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT) - (13*g1bar*mW**2*mZ**4*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*sqrt(2)*mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT) + (5*g1bar*mZ**6*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*sqrt(2)*mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT) - (3*mZ**4*einsum("Tr,pt,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*sqrt(2)*mH**2*mt*pi**2*vT) + (3*mt*mW**5*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (5*mt*mW**3*mZ**2*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) + (5*mt*mW*mZ**4*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) + (13*mW**3*mZ**4*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*sqrt(2)*mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (5*mW*mZ**6*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*sqrt(2)*mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) + (g1bar*mW**2*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt)*sqrt(2))/(3.*mt*pi**2*vT) + (g1bar*mW**2*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt)*sqrt(2))/(3.*mt*pi**2*vT) + (mt**3*mW**3*mZ**2*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2)*sqrt(2))/((mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (mt**3*mW**3*mZ**2*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2)*sqrt(2))/((mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (g1bar*mW**4*mZ**2*einsum("pT,sr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mZ**2)*sqrt(2))/(mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT) - (2*mW**5*mZ**2*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mZ**2)*sqrt(2))/(mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) + (g1bar*mW**4*mZ**2*einsum("Tr,pt,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mZ**2)*sqrt(2))/(mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT) - (2*mW**5*mZ**2*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mZ**2)*sqrt(2))/(mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2))
    c['VddLL'] = ((-5*mW**2*einsum("prst",C["qq1"]))/(24.*pi**2*vT**2) + (bEvan*mW**2*einsum("prst",C["qq1"]))/(18.*pi**2*vT**2) - (5*mW**4*einsum("prst",C["qq1"]))/(24.*mZ**2*pi**2*vT**2) + (bEvan*mW**4*einsum("prst",C["qq1"]))/(18.*mZ**2*pi**2*vT**2) - (5*mZ**2*einsum("prst",C["qq1"]))/(96.*pi**2*vT**2) + (bEvan*mZ**2*einsum("prst",C["qq1"]))/(72.*pi**2*vT**2) - (11*mW**2*einsum("prst",C["qq3"]))/(24.*pi**2*vT**2) + (11*bEvan*mW**2*einsum("prst",C["qq3"]))/(36.*pi**2*vT**2) - (5*mW**4*einsum("prst",C["qq3"]))/(24.*mZ**2*pi**2*vT**2) + (bEvan*mW**4*einsum("prst",C["qq3"]))/(18.*mZ**2*pi**2*vT**2) - (5*mZ**2*einsum("prst",C["qq3"]))/(96.*pi**2*vT**2) + (bEvan*mZ**2*einsum("prst",C["qq3"]))/(72.*pi**2*vT**2) - (5*mW**2*einsum("stpr",C["qq1"]))/(24.*pi**2*vT**2) + (bEvan*mW**2*einsum("stpr",C["qq1"]))/(18.*pi**2*vT**2) - (5*mW**4*einsum("stpr",C["qq1"]))/(24.*mZ**2*pi**2*vT**2) + (bEvan*mW**4*einsum("stpr",C["qq1"]))/(18.*mZ**2*pi**2*vT**2) - (5*mZ**2*einsum("stpr",C["qq1"]))/(96.*pi**2*vT**2) + (bEvan*mZ**2*einsum("stpr",C["qq1"]))/(72.*pi**2*vT**2) - (11*mW**2*einsum("stpr",C["qq3"]))/(24.*pi**2*vT**2) + (11*bEvan*mW**2*einsum("stpr",C["qq3"]))/(36.*pi**2*vT**2) - (5*mW**4*einsum("stpr",C["qq3"]))/(24.*mZ**2*pi**2*vT**2) + (bEvan*mW**4*einsum("stpr",C["qq3"]))/(18.*mZ**2*pi**2*vT**2) - (5*mZ**2*einsum("stpr",C["qq3"]))/(96.*pi**2*vT**2) + (bEvan*mZ**2*einsum("stpr",C["qq3"]))/(72.*pi**2*vT**2) + (g3bar**4*einsum("pr,st",kd,kd))/(480.*mt**2*Nc*pi**2) + (7*mH**2*einsum("pr,st",kd,kd))/(576.*pi**2*vT**4) - (1204*mW**2*einsum("pr,st",kd,kd))/(3645.*pi**2*vT**4) + (bEvan*mW**2*einsum("pr,st",kd,kd))/(162.*pi**2*vT**4) + (mW**4*einsum("pr,st",kd,kd))/(24.*mH**2*pi**2*vT**4) + (128*mW**8*einsum("pr,st",kd,kd))/(729.*mZ**6*pi**2*vT**4) - (2*bEvan*mW**8*einsum("pr,st",kd,kd))/(81.*mZ**6*pi**2*vT**4) + (7*mH**2*mW**4*einsum("pr,st",kd,kd))/(144.*mZ**4*pi**2*vT**4) + (13*mW**6*einsum("pr,st",kd,kd))/(135.*mZ**4*pi**2*vT**4) + (mW**8*einsum("pr,st",kd,kd))/(18.*mH**2*mZ**4*pi**2*vT**4) + (7*mH**2*mW**2*einsum("pr,st",kd,kd))/(144.*mZ**2*pi**2*vT**4) + (371*mW**4*einsum("pr,st",kd,kd))/(19440.*mZ**2*pi**2*vT**4) + (bEvan*mW**4*einsum("pr,st",kd,kd))/(54.*mZ**2*pi**2*vT**4) + (mW**6*einsum("pr,st",kd,kd))/(18.*mH**2*mZ**2*pi**2*vT**4) - (13*mZ**2*einsum("pr,st",kd,kd))/(1728.*pi**2*vT**4) + (mW**2*mZ**2*einsum("pr,st",kd,kd))/(36.*mH**2*pi**2*vT**4) + (mZ**4*einsum("pr,st",kd,kd))/(144.*mH**2*pi**2*vT**4) - (mt**4*Nc*einsum("pr,st",kd,kd))/(36.*mH**2*pi**2*vT**4) - (8*mW**4*Nc*einsum("pr,st",kd,kd))/(1215.*mt**2*pi**2*vT**4) - (mt**4*mW**4*Nc*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**4) - (8*mW**8*Nc*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**4*pi**2*vT**4) - (mt**4*mW**2*Nc*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**2*pi**2*vT**4) + (16*mW**6*Nc*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**2*pi**2*vT**4) - (131*g3bar**2*einsum("pr,st",kd,kd))/(5184.*Nc*pi**2*vT**2) - (bEvan*g3bar**2*einsum("pr,st",kd,kd))/(144.*Nc*pi**2*vT**2) + (121*g3bar**2*mW**4*einsum("pr,st",kd,kd))/(1296.*mZ**4*Nc*pi**2*vT**2) - (bEvan*g3bar**2*mW**4*einsum("pr,st",kd,kd))/(36.*mZ**4*Nc*pi**2*vT**2) + (121*g3bar**2*mW**2*einsum("pr,st",kd,kd))/(1296.*mZ**2*Nc*pi**2*vT**2) - (bEvan*g3bar**2*mW**2*einsum("pr,st",kd,kd))/(36.*mZ**2*Nc*pi**2*vT**2) - (C["phi"]*einsum("pr,st",kd,kd))/(48.*pi**2) - (mW**4*C["phi"]*einsum("pr,st",kd,kd))/(12.*mZ**4*pi**2) - (mW**2*C["phi"]*einsum("pr,st",kd,kd))/(12.*mZ**2*pi**2) - (mH**2*mW**2*C["phiB"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (5*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(36.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(18.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (2*mW**10*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (2*mW**10*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**2*C["phiB"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (2*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (13*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(72.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(18.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(72.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (7*mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(72.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mZ**6*C["phiB"]*einsum("pr,st",kd,kd))/(72.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (4*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (2*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (4*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (2*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (2*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (11*mH**2*C["phiBox"]*einsum("pr,st",kd,kd))/(288.*pi**2*vT**2) - (5*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(72.*pi**2*vT**2) + (mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(12.*mH**2*pi**2*vT**2) + (11*mH**2*mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(72.*mZ**4*pi**2*vT**2) + (mW**8*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) + (11*mH**2*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(72.*mZ**2*pi**2*vT**2) - (5*mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(72.*mZ**2*pi**2*vT**2) + (mW**6*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**2*pi**2*vT**2) - (5*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(288.*pi**2*vT**2) + (mW**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(18.*mH**2*pi**2*vT**2) + (mZ**4*C["phiBox"]*einsum("pr,st",kd,kd))/(72.*mH**2*pi**2*vT**2) - (mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(18.*mH**2*pi**2*vT**2) - (2*mt**4*mW**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) - (2*mt**4*mW**2*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**2*pi**2*vT**2) - (121*g3bar**2*C["phiD"]*einsum("pr,st",kd,kd))/(10368.*Nc*pi**2) + (bEvan*g3bar**2*C["phiD"]*einsum("pr,st",kd,kd))/(288.*Nc*pi**2) + (121*g3bar**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(2592.*mZ**4*Nc*pi**2) - (bEvan*g3bar**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(72.*mZ**4*Nc*pi**2) - (mH**2*C["phiD"]*einsum("pr,st",kd,kd))/(72.*pi**2*vT**2) - (271*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(23328.*pi**2*vT**2) - (bEvan*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(324.*pi**2*vT**2) + (mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(48.*mH**2*pi**2*vT**2) + (128*mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(729.*mZ**6*pi**2*vT**2) - (2*bEvan*mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(81.*mZ**6*pi**2*vT**2) - (mH**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(144.*mZ**4*pi**2*vT**2) + (13*mW**6*C["phiD"]*einsum("pr,st",kd,kd))/(135.*mZ**4*pi**2*vT**2) + (mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(36.*mH**2*mZ**4*pi**2*vT**2) - (mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(32.*mZ**2*pi**2*vT**2) + (181*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(6480.*mZ**2*pi**2*vT**2) - (mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(864.*pi**2*vT**2) + (mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(72.*mH**2*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(72.*mH**2*pi**2*vT**2) - (mt**4*mW**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(18.*mH**2*mZ**4*pi**2*vT**2) - (8*mW**8*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**4*pi**2*vT**2) + (8*mW**6*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**2*pi**2*vT**2) + (mH**2*mW**2*C["phiW"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(6.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (2*mW**10*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (2*mW**10*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**2*C["phiW"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**4*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(36.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**2*mZ**4*C["phiW"]*einsum("pr,st",kd,kd))/(24.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (2*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (4*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (2*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (4*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (2*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (7*g1bar*mH**2*mW*C["phiWB"]*einsum("pr,st",kd,kd))/(432.*(mH - mZ)*(mH + mZ)*pi**2*vT) + (1327*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(58320.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (bEvan*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(162.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(12.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (337*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(729.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) - (4*bEvan*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (7*g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(144.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (1793*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(14580.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (bEvan*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (593*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(1458.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (4*bEvan*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (g1bar*mH**4*mW*C["phiWB"]*einsum("pr,st",kd,kd))/(96.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (461*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(29160.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (bEvan*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(162.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (289*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(7290.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (bEvan*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(18.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (g1bar*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(864.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(18.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) - (g1bar*mW*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd))/(144.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) - (16*g1bar*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*mt**2*(mH - mZ)*(mH + mZ)*pi**2*vT) - (2*g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) - (g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (2*g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (16*g1bar*mH**2*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*mt**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (16*g1bar*mH**2*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*mt**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (16*g1bar*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*mt**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (121*g1bar*g3bar**2*mW**3*vT*C["phiWB"]*einsum("pr,st",kd,kd))/(1296.*mZ**4*Nc*pi**2) - (bEvan*g1bar*g3bar**2*mW**3*vT*C["phiWB"]*einsum("pr,st",kd,kd))/(36.*mZ**4*Nc*pi**2) + (121*g1bar*g3bar**2*mW*vT*C["phiWB"]*einsum("pr,st",kd,kd))/(2592.*mZ**2*Nc*pi**2) - (bEvan*g1bar*g3bar**2*mW*vT*C["phiWB"]*einsum("pr,st",kd,kd))/(72.*mZ**2*Nc*pi**2) - (mW**3*C["W"]*einsum("pr,st",kd,kd))/(6.*pi**2*vT**3) + (mW**7*C["W"]*einsum("pr,st",kd,kd))/(3.*mZ**4*pi**2*vT**3) - (mW**5*C["W"]*einsum("pr,st",kd,kd))/(6.*mZ**2*pi**2*vT**3) + (121*g3bar**2*einsum("pr,st",C["phiq1"],kd))/(1728.*Nc*pi**2) - (bEvan*g3bar**2*einsum("pr,st",C["phiq1"],kd))/(48.*Nc*pi**2) + (121*g3bar**2*mW**2*einsum("pr,st",C["phiq1"],kd))/(864.*mZ**2*Nc*pi**2) - (bEvan*g3bar**2*mW**2*einsum("pr,st",C["phiq1"],kd))/(24.*mZ**2*Nc*pi**2) - (5*mW**2*einsum("pr,st",C["phiq1"],kd))/(243.*pi**2*vT**2) + (bEvan*mW**2*einsum("pr,st",C["phiq1"],kd))/(54.*pi**2*vT**2) + (229*mW**6*einsum("pr,st",C["phiq1"],kd))/(972.*mZ**4*pi**2*vT**2) - (bEvan*mW**6*einsum("pr,st",C["phiq1"],kd))/(27.*mZ**4*pi**2*vT**2) - (67*mW**4*einsum("pr,st",C["phiq1"],kd))/(1944.*mZ**2*pi**2*vT**2) + (bEvan*mW**4*einsum("pr,st",C["phiq1"],kd))/(54.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("pr,st",C["phiq1"],kd))/(144.*pi**2*vT**2) + (37*g3bar**2*einsum("pr,st",C["phiq3"],kd))/(1728.*Nc*pi**2) - (bEvan*g3bar**2*einsum("pr,st",C["phiq3"],kd))/(48.*Nc*pi**2) + (121*g3bar**2*mW**2*einsum("pr,st",C["phiq3"],kd))/(864.*mZ**2*Nc*pi**2) - (bEvan*g3bar**2*mW**2*einsum("pr,st",C["phiq3"],kd))/(24.*mZ**2*Nc*pi**2) - (2045*mW**2*einsum("pr,st",C["phiq3"],kd))/(3888.*pi**2*vT**2) + (bEvan*mW**2*einsum("pr,st",C["phiq3"],kd))/(54.*pi**2*vT**2) + (229*mW**6*einsum("pr,st",C["phiq3"],kd))/(972.*mZ**4*pi**2*vT**2) - (bEvan*mW**6*einsum("pr,st",C["phiq3"],kd))/(27.*mZ**4*pi**2*vT**2) + (77*mW**4*einsum("pr,st",C["phiq3"],kd))/(486.*mZ**2*pi**2*vT**2) + (bEvan*mW**4*einsum("pr,st",C["phiq3"],kd))/(54.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("pr,st",C["phiq3"],kd))/(144.*pi**2*vT**2) - (g3bar**4*einsum("pt,sr",kd,kd))/(480.*mt**2*pi**2) + (131*g3bar**2*einsum("pt,sr",kd,kd))/(5184.*pi**2*vT**2) + (bEvan*g3bar**2*einsum("pt,sr",kd,kd))/(144.*pi**2*vT**2) - (121*g3bar**2*mW**4*einsum("pt,sr",kd,kd))/(1296.*mZ**4*pi**2*vT**2) + (bEvan*g3bar**2*mW**4*einsum("pt,sr",kd,kd))/(36.*mZ**4*pi**2*vT**2) - (121*g3bar**2*mW**2*einsum("pt,sr",kd,kd))/(1296.*mZ**2*pi**2*vT**2) + (bEvan*g3bar**2*mW**2*einsum("pt,sr",kd,kd))/(36.*mZ**2*pi**2*vT**2) + (121*g3bar**2*C["phiD"]*einsum("pt,sr",kd,kd))/(10368.*pi**2) - (bEvan*g3bar**2*C["phiD"]*einsum("pt,sr",kd,kd))/(288.*pi**2) - (121*g3bar**2*mW**4*C["phiD"]*einsum("pt,sr",kd,kd))/(2592.*mZ**4*pi**2) + (bEvan*g3bar**2*mW**4*C["phiD"]*einsum("pt,sr",kd,kd))/(72.*mZ**4*pi**2) - (121*g1bar*g3bar**2*mW**3*vT*C["phiWB"]*einsum("pt,sr",kd,kd))/(1296.*mZ**4*pi**2) + (bEvan*g1bar*g3bar**2*mW**3*vT*C["phiWB"]*einsum("pt,sr",kd,kd))/(36.*mZ**4*pi**2) - (121*g1bar*g3bar**2*mW*vT*C["phiWB"]*einsum("pt,sr",kd,kd))/(2592.*mZ**2*pi**2) + (bEvan*g1bar*g3bar**2*mW*vT*C["phiWB"]*einsum("pt,sr",kd,kd))/(72.*mZ**2*pi**2) - (121*g3bar**2*einsum("pt,sr",C["phiq1"],kd))/(1728.*pi**2) + (bEvan*g3bar**2*einsum("pt,sr",C["phiq1"],kd))/(48.*pi**2) - (121*g3bar**2*mW**2*einsum("pt,sr",C["phiq1"],kd))/(864.*mZ**2*pi**2) + (bEvan*g3bar**2*mW**2*einsum("pt,sr",C["phiq1"],kd))/(24.*mZ**2*pi**2) - (37*g3bar**2*einsum("pt,sr",C["phiq3"],kd))/(1728.*pi**2) + (bEvan*g3bar**2*einsum("pt,sr",C["phiq3"],kd))/(48.*pi**2) - (121*g3bar**2*mW**2*einsum("pt,sr",C["phiq3"],kd))/(864.*mZ**2*pi**2) + (bEvan*g3bar**2*mW**2*einsum("pt,sr",C["phiq3"],kd))/(24.*mZ**2*pi**2) - (121*g3bar**2*einsum("sr,pt",C["phiq1"],kd))/(1728.*pi**2) + (bEvan*g3bar**2*einsum("sr,pt",C["phiq1"],kd))/(48.*pi**2) - (121*g3bar**2*mW**2*einsum("sr,pt",C["phiq1"],kd))/(864.*mZ**2*pi**2) + (bEvan*g3bar**2*mW**2*einsum("sr,pt",C["phiq1"],kd))/(24.*mZ**2*pi**2) - (37*g3bar**2*einsum("sr,pt",C["phiq3"],kd))/(1728.*pi**2) + (bEvan*g3bar**2*einsum("sr,pt",C["phiq3"],kd))/(48.*pi**2) - (121*g3bar**2*mW**2*einsum("sr,pt",C["phiq3"],kd))/(864.*mZ**2*pi**2) + (bEvan*g3bar**2*mW**2*einsum("sr,pt",C["phiq3"],kd))/(24.*mZ**2*pi**2) + (121*g3bar**2*einsum("st,pr",C["phiq1"],kd))/(1728.*Nc*pi**2) - (bEvan*g3bar**2*einsum("st,pr",C["phiq1"],kd))/(48.*Nc*pi**2) + (121*g3bar**2*mW**2*einsum("st,pr",C["phiq1"],kd))/(864.*mZ**2*Nc*pi**2) - (bEvan*g3bar**2*mW**2*einsum("st,pr",C["phiq1"],kd))/(24.*mZ**2*Nc*pi**2) - (5*mW**2*einsum("st,pr",C["phiq1"],kd))/(243.*pi**2*vT**2) + (bEvan*mW**2*einsum("st,pr",C["phiq1"],kd))/(54.*pi**2*vT**2) + (229*mW**6*einsum("st,pr",C["phiq1"],kd))/(972.*mZ**4*pi**2*vT**2) - (bEvan*mW**6*einsum("st,pr",C["phiq1"],kd))/(27.*mZ**4*pi**2*vT**2) - (67*mW**4*einsum("st,pr",C["phiq1"],kd))/(1944.*mZ**2*pi**2*vT**2) + (bEvan*mW**4*einsum("st,pr",C["phiq1"],kd))/(54.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("st,pr",C["phiq1"],kd))/(144.*pi**2*vT**2) + (37*g3bar**2*einsum("st,pr",C["phiq3"],kd))/(1728.*Nc*pi**2) - (bEvan*g3bar**2*einsum("st,pr",C["phiq3"],kd))/(48.*Nc*pi**2) + (121*g3bar**2*mW**2*einsum("st,pr",C["phiq3"],kd))/(864.*mZ**2*Nc*pi**2) - (bEvan*g3bar**2*mW**2*einsum("st,pr",C["phiq3"],kd))/(24.*mZ**2*Nc*pi**2) - (2045*mW**2*einsum("st,pr",C["phiq3"],kd))/(3888.*pi**2*vT**2) + (bEvan*mW**2*einsum("st,pr",C["phiq3"],kd))/(54.*pi**2*vT**2) + (229*mW**6*einsum("st,pr",C["phiq3"],kd))/(972.*mZ**4*pi**2*vT**2) - (bEvan*mW**6*einsum("st,pr",C["phiq3"],kd))/(27.*mZ**4*pi**2*vT**2) + (77*mW**4*einsum("st,pr",C["phiq3"],kd))/(486.*mZ**2*pi**2*vT**2) + (bEvan*mW**4*einsum("st,pr",C["phiq3"],kd))/(54.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("st,pr",C["phiq3"],kd))/(144.*pi**2*vT**2) - (3*mt**4*einsum("prsT,tT,TT",C["qq1"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("prsT,tT,TT",C["qq1"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("prsT,tT,TT",C["qq3"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("prsT,tT,TT",C["qq3"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("prTt,sT,TT",C["qq1"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("prTt,sT,TT",C["qq1"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("prTt,sT,TT",C["qq3"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("prTt,sT,TT",C["qq3"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("pTst,rT,TT",C["qq1"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("pTst,rT,TT",C["qq1"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("pTst,rT,TT",C["qq3"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("pTst,rT,TT",C["qq3"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (g3bar**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(48.*Nc*pi**2) - (mt**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(24.*pi**2*vT**2) - (mW**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(12.*mZ**2*pi**2*vT**2) + (mW**4*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) + (g3bar**2*einsum("pTTt,sr,TT",C["qq3"],kd,kdt))/(48.*pi**2) - (3*mt**4*einsum("sTpr,tT,TT",C["qq1"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("sTpr,tT,TT",C["qq1"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("sTpr,tT,TT",C["qq3"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("sTpr,tT,TT",C["qq3"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("stpT,rT,TT",C["qq1"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("stpT,rT,TT",C["qq1"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("stpT,rT,TT",C["qq3"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("stpT,rT,TT",C["qq3"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("stTr,pT,TT",C["qq1"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("stTr,pT,TT",C["qq1"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("stTr,pT,TT",C["qq3"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("stTr,pT,TT",C["qq3"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (g3bar**2*einsum("sTTr,pt,TT",C["qq3"],kd,kdt))/(48.*pi**2) - (g3bar**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(48.*Nc*pi**2) - (mt**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(24.*pi**2*vT**2) - (mW**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(12.*mZ**2*pi**2*vT**2) + (mW**4*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) - (g3bar**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(48.*Nc*pi**2) - (mt**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(24.*pi**2*vT**2) - (mW**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(12.*mZ**2*pi**2*vT**2) + (mW**4*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) - (3*mt**4*einsum("Trst,pT,TT",C["qq1"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("Trst,pT,TT",C["qq1"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("Trst,pT,TT",C["qq3"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("Trst,pT,TT",C["qq3"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (g3bar**2*einsum("TrsT,pt,TT",C["qq3"],kd,kdt))/(48.*pi**2) - (3*mt**4*einsum("Ttpr,sT,TT",C["qq1"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("Ttpr,sT,TT",C["qq1"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("Ttpr,sT,TT",C["qq3"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("Ttpr,sT,TT",C["qq3"],kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (g3bar**2*einsum("TtpT,sr,TT",C["qq3"],kd,kdt))/(48.*pi**2) - (g3bar**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(48.*Nc*pi**2) - (mt**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(24.*pi**2*vT**2) - (mW**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(12.*mZ**2*pi**2*vT**2) + (mW**4*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) + (mt**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(48.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) + (17*mt**6*mW**2*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(432.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) - (4*mt**4*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) + (mt**2*mW**6*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(9.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) - (mW**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) + (mt**8*mW**2*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(24.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) - (179*mt**6*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(432.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) + (307*mt**4*mW**6*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(432.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) - (13*mt**2*mW**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(36.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) + (mW**10*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) + (7*g3bar**2*mt**6*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*Nc*pi**2*vT**2) - (35*g3bar**2*mt**4*mW**2*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*Nc*pi**2*vT**2) + (7*g3bar**2*mt**2*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(64.*(mt - mW)**3*(mt + mW)**3*Nc*pi**2*vT**2) - (g3bar**2*mW**6*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(48.*(mt - mW)**3*(mt + mW)**3*Nc*pi**2*vT**2) - (mt**8*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (3*mt**6*mW**2*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(128.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (5*mt**4*mW**4*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(128.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (7*mt**2*mW**6*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**8*mW**2*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(64.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (277*mt**6*mW**4*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(1728.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (479*mt**4*mW**6*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(1728.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (83*mt**2*mW**8*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(576.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mW**10*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(54.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (g1bar*mt**8*mW*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(48.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (29*g1bar*mt**6*mW**3*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(108.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (113*g1bar*mt**4*mW**5*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(216.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (43*g1bar*mt**2*mW**7*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(144.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (g1bar*mW**9*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (3*mt**4*mW**3*C["W"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**3) - (mt**2*mW**5*C["W"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**3) - (3*mt**4*mW**5*C["W"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(8.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**3) + (mt**2*mW**7*C["W"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(8.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**3) + (mt**4*einsum("pr,sT,tT,TT",C["phiq1"],kd,kd,kdt))/((64*mt**2 - 64*mW**2)*pi**2*vT**2) - (7*mt**2*mW**2*einsum("pr,sT,tT,TT",C["phiq1"],kd,kd,kdt))/((64*mt**2 - 64*mW**2)*pi**2*vT**2) + (7*mt**4*einsum("pr,sT,tT,TT",C["phiq3"],kd,kd,kdt))/((64*mt**2 - 64*mW**2)*pi**2*vT**2) - (25*mt**2*mW**2*einsum("pr,sT,tT,TT",C["phiq3"],kd,kd,kdt))/((64*mt**2 - 64*mW**2)*pi**2*vT**2) + (mt**2*einsum("prTT,sT,tT,TT",C["qq1"],kd,kd,kdt))/(16.*pi**2*vT**2) - (mt**2*einsum("prTT,sT,tT,TT",C["qq3"],kd,kd,kdt))/(16.*pi**2*vT**2) - (mt**4*einsum("prTT,sT,tT,TT",C["qu1"],kd,kd,kdt))/(64.*(mt**2 - mW**2)*pi**2*vT**2) + (7*mt**2*mW**2*einsum("prTT,sT,tT,TT",C["qu1"],kd,kd,kdt))/(64.*(mt**2 - mW**2)*pi**2*vT**2) + (mt**4*einsum("prTT,sT,tT,TT",C["qu8"],kd,kd,kdt))/((128*mt**2*Nc - 128*mW**2*Nc)*pi**2*vT**2) - (7*mt**2*mW**2*einsum("prTT,sT,tT,TT",C["qu8"],kd,kd,kdt))/((128*mt**2*Nc - 128*mW**2*Nc)*pi**2*vT**2) - (7*g3bar**2*mt**6*einsum("pt,rT,sT,TT",kd,kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (35*g3bar**2*mt**4*mW**2*einsum("pt,rT,sT,TT",kd,kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (7*g3bar**2*mt**2*mW**4*einsum("pt,rT,sT,TT",kd,kd,kd,kdt))/(64.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (g3bar**2*mW**6*einsum("pt,rT,sT,TT",kd,kd,kd,kdt))/(48.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (7*g3bar**2*mt**6*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*pi**2) + (35*g3bar**2*mt**4*mW**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*pi**2) - (7*g3bar**2*mt**2*mW**4*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt))/(64.*(mt - mW)**3*(mt + mW)**3*pi**2) + (g3bar**2*mW**6*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt))/(48.*(mt - mW)**3*(mt + mW)**3*pi**2) + (5*g3bar**2*mt**5*mW*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt))/(192.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2) - (19*g3bar**2*mt**3*mW**3*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt))/(192.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2) + (5*g3bar**2*mt*mW**5*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt))/(48.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2) + (mt**4*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**2*mW**2*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**4*mW**2*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt))/(64.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) + (mt**2*mW**4*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt))/(64.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) + (7*g3bar**2*mt**6*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) - (35*g3bar**2*mt**4*mW**2*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) + (7*g3bar**2*mt**2*mW**4*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(64.*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) - (g3bar**2*mW**6*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(48.*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) - (5*mt**8*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (541*mt**6*mW**2*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(3456.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (971*mt**4*mW**4*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(3456.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (185*mt**2*mW**6*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(1152.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mW**8*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (5*mt**8*mW**2*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(192.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (311*mt**6*mW**4*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(1728.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (769*mt**4*mW**6*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(1728.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (151*mt**2*mW**8*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(576.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mW**10*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (5*g3bar**2*mt**5*mW*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(192.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) + (19*g3bar**2*mt**3*mW**3*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(192.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) - (5*g3bar**2*mt*mW**5*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(48.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) + (mt**7*mW*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(8.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (103*mt**5*mW**3*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(216.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (29*mt**3*mW**5*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(54.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (17*mt*mW**7*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(108.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**7*mW**3*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(4.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (59*mt**5*mW**5*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(216.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (35*mt**3*mW**7*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(216.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (17*mt*mW**9*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(108.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mt**4*einsum("ptTT,rT,sT,TT",C["qu8"],kd,kd,kdt))/(128.*(mt**2 - mW**2)*pi**2*vT**2) + (7*mt**2*mW**2*einsum("ptTT,rT,sT,TT",C["qu8"],kd,kd,kdt))/(128.*(mt**2 - mW**2)*pi**2*vT**2) + (mt**2*einsum("pTTt,rT,sT,TT",C["qq3"],kd,kd,kdt))/(8.*pi**2*vT**2) - (7*g3bar**2*mt**6*einsum("sr,pT,tT,TT",kd,kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (35*g3bar**2*mt**4*mW**2*einsum("sr,pT,tT,TT",kd,kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (7*g3bar**2*mt**2*mW**4*einsum("sr,pT,tT,TT",kd,kd,kd,kdt))/(64.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (g3bar**2*mW**6*einsum("sr,pT,tT,TT",kd,kd,kd,kdt))/(48.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**4*einsum("srTT,pT,tT,TT",C["qu8"],kd,kd,kdt))/(128.*(mt**2 - mW**2)*pi**2*vT**2) + (7*mt**2*mW**2*einsum("srTT,pT,tT,TT",C["qu8"],kd,kd,kdt))/(128.*(mt**2 - mW**2)*pi**2*vT**2) + (mt**4*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**2*mW**2*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**4*mW**2*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt))/(64.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) + (mt**2*mW**4*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt))/(64.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) + (7*g3bar**2*mt**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) - (35*g3bar**2*mt**4*mW**2*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) + (7*g3bar**2*mt**2*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(64.*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) - (g3bar**2*mW**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(48.*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) - (5*mt**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (541*mt**6*mW**2*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(3456.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (971*mt**4*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(3456.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (185*mt**2*mW**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(1152.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mW**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (5*mt**8*mW**2*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(192.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (311*mt**6*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(1728.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (769*mt**4*mW**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(1728.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (151*mt**2*mW**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(576.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mW**10*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (5*g3bar**2*mt**5*mW*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(192.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) + (19*g3bar**2*mt**3*mW**3*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(192.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) - (5*g3bar**2*mt*mW**5*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(48.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) + (mt**7*mW*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(8.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (103*mt**5*mW**3*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(216.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (29*mt**3*mW**5*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(54.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (17*mt*mW**7*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(108.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**7*mW**3*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(4.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (59*mt**5*mW**5*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(216.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (35*mt**3*mW**7*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(216.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (17*mt*mW**9*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(108.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**8*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(48.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) + (17*mt**6*mW**2*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(432.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) - (4*mt**4*mW**4*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) + (mt**2*mW**6*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(9.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) - (mW**8*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) + (mt**8*mW**2*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(24.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) - (179*mt**6*mW**4*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(432.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) + (307*mt**4*mW**6*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(432.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) - (13*mt**2*mW**8*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(36.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) + (mW**10*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) + (7*g3bar**2*mt**6*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*Nc*pi**2*vT**2) - (35*g3bar**2*mt**4*mW**2*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*Nc*pi**2*vT**2) + (7*g3bar**2*mt**2*mW**4*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(64.*(mt - mW)**3*(mt + mW)**3*Nc*pi**2*vT**2) - (g3bar**2*mW**6*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(48.*(mt - mW)**3*(mt + mW)**3*Nc*pi**2*vT**2) - (mt**8*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (3*mt**6*mW**2*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(128.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (5*mt**4*mW**4*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(128.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (7*mt**2*mW**6*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**8*mW**2*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(64.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (277*mt**6*mW**4*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(1728.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (479*mt**4*mW**6*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(1728.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (83*mt**2*mW**8*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(576.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mW**10*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(54.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (g1bar*mt**8*mW*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(48.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (29*g1bar*mt**6*mW**3*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(108.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (113*g1bar*mt**4*mW**5*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(216.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (43*g1bar*mt**2*mW**7*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(144.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (g1bar*mW**9*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (3*mt**4*mW**3*C["W"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**3) - (mt**2*mW**5*C["W"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**3) - (3*mt**4*mW**5*C["W"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(8.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**3) + (mt**2*mW**7*C["W"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(8.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**3) + (mt**4*einsum("st,pT,rT,TT",C["phiq1"],kd,kd,kdt))/((64*mt**2 - 64*mW**2)*pi**2*vT**2) - (7*mt**2*mW**2*einsum("st,pT,rT,TT",C["phiq1"],kd,kd,kdt))/((64*mt**2 - 64*mW**2)*pi**2*vT**2) + (7*mt**4*einsum("st,pT,rT,TT",C["phiq3"],kd,kd,kdt))/((64*mt**2 - 64*mW**2)*pi**2*vT**2) - (25*mt**2*mW**2*einsum("st,pT,rT,TT",C["phiq3"],kd,kd,kdt))/((64*mt**2 - 64*mW**2)*pi**2*vT**2) - (7*g3bar**2*mt**6*einsum("sT,pt,rT,TT",C["phiq3"],kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*pi**2) + (35*g3bar**2*mt**4*mW**2*einsum("sT,pt,rT,TT",C["phiq3"],kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*pi**2) - (7*g3bar**2*mt**2*mW**4*einsum("sT,pt,rT,TT",C["phiq3"],kd,kd,kdt))/(64.*(mt - mW)**3*(mt + mW)**3*pi**2) + (g3bar**2*mW**6*einsum("sT,pt,rT,TT",C["phiq3"],kd,kd,kdt))/(48.*(mt - mW)**3*(mt + mW)**3*pi**2) + (5*g3bar**2*mt**5*mW*einsum("sT,pt,rT,TT",C["uW"],kd,kd,kdt))/(192.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2) - (19*g3bar**2*mt**3*mW**3*einsum("sT,pt,rT,TT",C["uW"],kd,kd,kdt))/(192.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2) + (5*g3bar**2*mt*mW**5*einsum("sT,pt,rT,TT",C["uW"],kd,kd,kdt))/(48.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2) + (mt**2*einsum("sTTr,pT,tT,TT",C["qq3"],kd,kd,kdt))/(8.*pi**2*vT**2) + (mt**2*einsum("stTT,pT,rT,TT",C["qq1"],kd,kd,kdt))/(16.*pi**2*vT**2) - (mt**2*einsum("stTT,pT,rT,TT",C["qq3"],kd,kd,kdt))/(16.*pi**2*vT**2) - (mt**4*einsum("stTT,pT,rT,TT",C["qu1"],kd,kd,kdt))/(64.*(mt**2 - mW**2)*pi**2*vT**2) + (7*mt**2*mW**2*einsum("stTT,pT,rT,TT",C["qu1"],kd,kd,kdt))/(64.*(mt**2 - mW**2)*pi**2*vT**2) + (mt**4*einsum("stTT,pT,rT,TT",C["qu8"],kd,kd,kdt))/((128*mt**2*Nc - 128*mW**2*Nc)*pi**2*vT**2) - (7*mt**2*mW**2*einsum("stTT,pT,rT,TT",C["qu8"],kd,kd,kdt))/((128*mt**2*Nc - 128*mW**2*Nc)*pi**2*vT**2) - (7*g3bar**2*mt**6*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*pi**2) + (35*g3bar**2*mt**4*mW**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*pi**2) - (7*g3bar**2*mt**2*mW**4*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt))/(64.*(mt - mW)**3*(mt + mW)**3*pi**2) + (g3bar**2*mW**6*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt))/(48.*(mt - mW)**3*(mt + mW)**3*pi**2) + (5*g3bar**2*mt**5*mW*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt))/(192.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2) - (19*g3bar**2*mt**3*mW**3*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt))/(192.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2) + (5*g3bar**2*mt*mW**5*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt))/(48.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2) + (mt**4*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**2*mW**2*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**4*mW**2*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt))/(64.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) + (mt**2*mW**4*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt))/(64.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) + (7*g3bar**2*mt**6*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) - (35*g3bar**2*mt**4*mW**2*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) + (7*g3bar**2*mt**2*mW**4*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(64.*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) - (g3bar**2*mW**6*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(48.*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) - (5*mt**8*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (541*mt**6*mW**2*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(3456.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (971*mt**4*mW**4*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(3456.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (185*mt**2*mW**6*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(1152.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mW**8*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (5*mt**8*mW**2*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(192.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (311*mt**6*mW**4*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(1728.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (769*mt**4*mW**6*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(1728.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (151*mt**2*mW**8*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(576.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mW**10*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (5*g3bar**2*mt**5*mW*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(192.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) + (19*g3bar**2*mt**3*mW**3*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(192.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) - (5*g3bar**2*mt*mW**5*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(48.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) + (mt**7*mW*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(8.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (103*mt**5*mW**3*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(216.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (29*mt**3*mW**5*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(54.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (17*mt*mW**7*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(108.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**7*mW**3*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(4.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (59*mt**5*mW**5*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(216.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (35*mt**3*mW**7*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(216.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (17*mt*mW**9*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(108.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**2*einsum("TrsT,pT,tT,TT",C["qq3"],kd,kd,kdt))/(8.*pi**2*vT**2) + (mt**4*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**2*mW**2*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt))/(128.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**4*mW**2*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt))/(64.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) + (mt**2*mW**4*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt))/(64.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) + (7*g3bar**2*mt**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) - (35*g3bar**2*mt**4*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) + (7*g3bar**2*mt**2*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(64.*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) - (g3bar**2*mW**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(48.*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) - (5*mt**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (541*mt**6*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(3456.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (971*mt**4*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(3456.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (185*mt**2*mW**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(1152.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mW**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (5*mt**8*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(192.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (311*mt**6*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(1728.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (769*mt**4*mW**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(1728.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (151*mt**2*mW**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(576.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mW**10*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (5*g3bar**2*mt**5*mW*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(192.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) + (19*g3bar**2*mt**3*mW**3*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(192.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) - (5*g3bar**2*mt*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(48.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2) + (mt**7*mW*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(8.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (103*mt**5*mW**3*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(216.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (29*mt**3*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(54.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (17*mt*mW**7*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(108.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**7*mW**3*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(4.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (59*mt**5*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(216.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (35*mt**3*mW**7*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(216.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (17*mt*mW**9*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(108.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (g1bar*mW**6*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt))/(81.*sqrt(2)*mt*mZ**4*pi**2*vT) + (g1bar*mW**4*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt))/(81.*sqrt(2)*mt*mZ**2*pi**2*vT) - (g1bar*mW**6*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt))/(81.*sqrt(2)*mt*mZ**4*pi**2*vT) + (g1bar*mW**4*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt))/(81.*sqrt(2)*mt*mZ**2*pi**2*vT) - (g3bar**3*vT*einsum("TT,pr,st,TT",C["uG"],kd,kd,kdt))/(96.*sqrt(2)*mt*Nc*pi**2) - (g3bar**3*vT*einsum("TT,pr,st,TT",C["uGDag"],kd,kd,kdt))/(96.*sqrt(2)*mt*Nc*pi**2) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(72.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(18.*sqrt(2)*mH**2*mZ**4*pi**2*vT) + (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(18.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(72.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(18.*sqrt(2)*mH**2*mZ**4*pi**2*vT) + (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(18.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (mt**2*einsum("TTpr,sT,tT,TT",C["qq1"],kd,kd,kdt))/(16.*pi**2*vT**2) - (mt**2*einsum("TTpr,sT,tT,TT",C["qq3"],kd,kd,kdt))/(16.*pi**2*vT**2) + (mt**2*einsum("TtpT,rT,sT,TT",C["qq3"],kd,kd,kdt))/(8.*pi**2*vT**2) + (g3bar**3*vT*einsum("TT,pt,sr,TT",C["uG"],kd,kd,kdt))/(96.*sqrt(2)*mt*pi**2) + (g3bar**3*vT*einsum("TT,pt,sr,TT",C["uGDag"],kd,kd,kdt))/(96.*sqrt(2)*mt*pi**2) - (7*g3bar**2*mt**6*einsum("Tt,sr,pT,TT",C["phiq3"],kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*pi**2) + (35*g3bar**2*mt**4*mW**2*einsum("Tt,sr,pT,TT",C["phiq3"],kd,kd,kdt))/(384.*(mt - mW)**3*(mt + mW)**3*pi**2) - (7*g3bar**2*mt**2*mW**4*einsum("Tt,sr,pT,TT",C["phiq3"],kd,kd,kdt))/(64.*(mt - mW)**3*(mt + mW)**3*pi**2) + (g3bar**2*mW**6*einsum("Tt,sr,pT,TT",C["phiq3"],kd,kd,kdt))/(48.*(mt - mW)**3*(mt + mW)**3*pi**2) + (5*g3bar**2*mt**5*mW*einsum("Tt,sr,pT,TT",C["uWDag"],kd,kd,kdt))/(192.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2) - (19*g3bar**2*mt**3*mW**3*einsum("Tt,sr,pT,TT",C["uWDag"],kd,kd,kdt))/(192.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2) + (5*g3bar**2*mt*mW**5*einsum("Tt,sr,pT,TT",C["uWDag"],kd,kd,kdt))/(48.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2) + (mt**2*einsum("TTst,pT,rT,TT",C["qq1"],kd,kd,kdt))/(16.*pi**2*vT**2) - (mt**2*einsum("TTst,pT,rT,TT",C["qq3"],kd,kd,kdt))/(16.*pi**2*vT**2) - (mt**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiq1"],kdt))/(48.*pi**2*vT**2) - (mt**2*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiq1"],kdt))/(24.*mZ**2*pi**2*vT**2) + (mt**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiq3"],kdt))/(48.*pi**2*vT**2) + (mt**2*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiq3"],kdt))/(24.*mZ**2*pi**2*vT**2) + (mt**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(192.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (7*mt**2*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(192.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**4*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(96.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) - (7*mt**2*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(96.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) + (g1bar*mt**5*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uB"],kdt))/(96.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) + (g1bar*mt**3*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uB"],kdt))/(32.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) - (g1bar*mt*mW**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uB"],kdt))/(48.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) + (g1bar*mt**5*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uBDag"],kdt))/(96.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) + (g1bar*mt**3*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uBDag"],kdt))/(32.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) - (g1bar*mt*mW**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uBDag"],kdt))/(48.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) + (g3bar*mt**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uG"],kdt))/(64.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT) + (3*g3bar*mt**3*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uG"],kdt))/(64.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT) - (g3bar*mt*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uG"],kdt))/(32.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT) + (g3bar*mt**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uGDag"],kdt))/(64.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT) + (3*g3bar*mt**3*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uGDag"],kdt))/(64.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT) - (g3bar*mt*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uGDag"],kdt))/(32.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT) + (mt**5*mW*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt))/(48.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**3*mW**3*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt))/(24.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**5*mW**3*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt))/(48.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**3*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt*mW**7*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt))/(24.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**5*mW*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(48.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**3*mW**3*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(24.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**5*mW**3*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(48.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**3*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt*mW**7*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(24.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (g3bar*mt**5*einsum("pt,rT,sT,TT,TT",kd,kd,kd,C["uG"],kdt))/(64.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT) - (3*g3bar*mt**3*mW**2*einsum("pt,rT,sT,TT,TT",kd,kd,kd,C["uG"],kdt))/(64.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT) + (g3bar*mt*mW**4*einsum("pt,rT,sT,TT,TT",kd,kd,kd,C["uG"],kdt))/(32.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT) - (g3bar*mt**5*einsum("pt,rT,sT,TT,TT",kd,kd,kd,C["uGDag"],kdt))/(64.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT) - (3*g3bar*mt**3*mW**2*einsum("pt,rT,sT,TT,TT",kd,kd,kd,C["uGDag"],kdt))/(64.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT) + (g3bar*mt*mW**4*einsum("pt,rT,sT,TT,TT",kd,kd,kd,C["uGDag"],kdt))/(32.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT) - (mt**6*einsum("pT,rT,sT,Tt,TT",kd,kd,kd,C["phiq3"],kdt))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (11*mt**4*mW**2*einsum("pT,rT,sT,Tt,TT",kd,kd,kd,C["phiq3"],kdt))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("pT,rT,sT,Tt,TT",kd,kd,kd,C["phiq3"],kdt))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**5*mW*einsum("pT,rT,sT,Tt,TT",kd,kd,kd,C["uWDag"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**3*mW**3*einsum("pT,rT,sT,Tt,TT",kd,kd,kd,C["uWDag"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("pT,rT,tT,sT,TT",kd,kd,kd,C["phiq3"],kdt))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (11*mt**4*mW**2*einsum("pT,rT,tT,sT,TT",kd,kd,kd,C["phiq3"],kdt))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("pT,rT,tT,sT,TT",kd,kd,kd,C["phiq3"],kdt))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**5*mW*einsum("pT,rT,tT,sT,TT",kd,kd,kd,C["uW"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**3*mW**3*einsum("pT,rT,tT,sT,TT",kd,kd,kd,C["uW"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("pT,sT,tT,Tr,TT",kd,kd,kd,C["phiq3"],kdt))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (11*mt**4*mW**2*einsum("pT,sT,tT,Tr,TT",kd,kd,kd,C["phiq3"],kdt))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("pT,sT,tT,Tr,TT",kd,kd,kd,C["phiq3"],kdt))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**5*mW*einsum("pT,sT,tT,Tr,TT",kd,kd,kd,C["uWDag"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**3*mW**3*einsum("pT,sT,tT,Tr,TT",kd,kd,kd,C["uWDag"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("rT,sT,tT,pT,TT",kd,kd,kd,kd,kdt))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**4) + (11*mt**4*mW**2*einsum("rT,sT,tT,pT,TT",kd,kd,kd,kd,kdt))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**4) - (mt**2*mW**4*einsum("rT,sT,tT,pT,TT",kd,kd,kd,kd,kdt))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**4) - (mt**6*einsum("rT,sT,tT,pT,TT",kd,kd,kd,C["phiq3"],kdt))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (11*mt**4*mW**2*einsum("rT,sT,tT,pT,TT",kd,kd,kd,C["phiq3"],kdt))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("rT,sT,tT,pT,TT",kd,kd,kd,C["phiq3"],kdt))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**5*mW*einsum("rT,sT,tT,pT,TT",kd,kd,kd,C["uW"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**3*mW**3*einsum("rT,sT,tT,pT,TT",kd,kd,kd,C["uW"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (g3bar*mt**5*einsum("sr,pT,tT,TT,TT",kd,kd,kd,C["uG"],kdt))/(64.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT) - (3*g3bar*mt**3*mW**2*einsum("sr,pT,tT,TT,TT",kd,kd,kd,C["uG"],kdt))/(64.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT) + (g3bar*mt*mW**4*einsum("sr,pT,tT,TT,TT",kd,kd,kd,C["uG"],kdt))/(32.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT) - (g3bar*mt**5*einsum("sr,pT,tT,TT,TT",kd,kd,kd,C["uGDag"],kdt))/(64.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT) - (3*g3bar*mt**3*mW**2*einsum("sr,pT,tT,TT,TT",kd,kd,kd,C["uGDag"],kdt))/(64.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT) + (g3bar*mt*mW**4*einsum("sr,pT,tT,TT,TT",kd,kd,kd,C["uGDag"],kdt))/(32.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT) - (mt**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiq1"],kdt))/(48.*pi**2*vT**2) - (mt**2*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiq1"],kdt))/(24.*mZ**2*pi**2*vT**2) + (mt**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiq3"],kdt))/(48.*pi**2*vT**2) + (mt**2*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiq3"],kdt))/(24.*mZ**2*pi**2*vT**2) + (mt**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(192.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (7*mt**2*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(192.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**4*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(96.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) - (7*mt**2*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(96.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) + (g1bar*mt**5*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uB"],kdt))/(96.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) + (g1bar*mt**3*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uB"],kdt))/(32.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) - (g1bar*mt*mW**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uB"],kdt))/(48.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) + (g1bar*mt**5*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uBDag"],kdt))/(96.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) + (g1bar*mt**3*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uBDag"],kdt))/(32.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) - (g1bar*mt*mW**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uBDag"],kdt))/(48.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) + (g3bar*mt**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uG"],kdt))/(64.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT) + (3*g3bar*mt**3*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uG"],kdt))/(64.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT) - (g3bar*mt*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uG"],kdt))/(32.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT) + (g3bar*mt**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uGDag"],kdt))/(64.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT) + (3*g3bar*mt**3*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uGDag"],kdt))/(64.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT) - (g3bar*mt*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uGDag"],kdt))/(32.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT) + (mt**5*mW*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt))/(48.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**3*mW**3*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt))/(24.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**5*mW**3*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt))/(48.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**3*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt*mW**7*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt))/(24.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**5*mW*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(48.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**3*mW**3*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(24.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**5*mW**3*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(48.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**3*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt*mW**7*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(24.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mH**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(96.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (mH**2*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mH**4*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(24.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) + (mH**4*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(24.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) - (mH**2*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) - (mH**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(48.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(48.*pi**2) - (mW**4*C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*mZ**4*pi**2) - (mW**2*C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*mZ**2*pi**2) - (mH**4*mW**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mH**6*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT**2) + (mH**6*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) + (mH**4*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) + (mH**6*mW**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (mH**2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (5*mH**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(144.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (2*mH**2*mW**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (5*mH**4*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(36.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (5*mH**4*mW**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(36.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (2*mH**2*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mH**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(72.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(72.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(72.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (5*mH**4*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(144.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mH**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(36.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mH**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(72.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mH**6*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT**2) - (mH**6*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) - (mH**4*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) - (mH**6*mW**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (mH**4*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (mH**2*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (g1bar*mH**4*mW*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(48.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**6*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**6*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(24.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**6*mW*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(144.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (mt**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(144.*pi**2*vT**4) - (mt**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(36.*mH**2*pi**2*vT**4) - (5*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*pi**2*vT**4) - (16*mW**8*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**6*pi**2*vT**4) + (mt**2*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(36.*mZ**4*pi**2*vT**4) - (mt**4*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**4) + (2*mW**6*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**4) + (mt**2*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(36.*mZ**2*pi**2*vT**4) - (mt**4*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**2*pi**2*vT**4) + (mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**4) + (4*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**6*pi**2*vT**2) - (2*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**2) - (2*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**2*pi**2*vT**2) - (mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(18.*mH**2*pi**2*vT**2) - (2*mt**4*mW**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**2) - (2*mt**4*mW**2*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**2*pi**2*vT**2) - (mt**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(144.*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(72.*mH**2*pi**2*vT**2) + (5*mW**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(486.*pi**2*vT**2) - (16*mW**8*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**6*pi**2*vT**2) - (mt**4*mW**4*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(18.*mH**2*mZ**4*pi**2*vT**2) + (mW**6*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(72.*mZ**2*pi**2*vT**2) - (4*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**6*pi**2*vT**2) + (2*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**2*pi**2*vT**2) - (2*g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**6*pi**2*vT) - (32*g1bar*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**6*pi**2*vT) + (g1bar*mt**2*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(36.*mZ**4*pi**2*vT) - (g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT) + (19*g1bar*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**4*pi**2*vT) + (g1bar*mt**2*mW*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(72.*mZ**2*pi**2*vT) + (4*g1bar*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**2*pi**2*vT) + (mt**2*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (5*mW**2*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(162.*pi**2*vT**2) - (4*mW**6*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(24.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(162.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (5*mW**2*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(162.*pi**2*vT**2) - (4*mW**6*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(24.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(162.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (5*mW**2*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(162.*pi**2*vT**2) - (4*mW**6*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(24.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(162.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (5*mW**2*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(162.*pi**2*vT**2) - (4*mW**6*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(24.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(162.*mZ**2*pi**2*vT**2) - (mt**6*einsum("prsT,tT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("prsT,tT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("prsT,tT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("prsT,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("prsT,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("prsT,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("prTt,sT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("prTt,sT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("prTt,sT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("prTt,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("prTt,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("prTt,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*Nc*einsum("prTT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) + (mW**2*Nc*einsum("prTT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(54.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(24.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("prTT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(54.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("prTT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (mW**2*Nc*einsum("prTT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(54.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(24.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("prTT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(54.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("prTT,st,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) + (mW**2*Nc*einsum("prTT,st,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(54.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(24.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("prTT,st,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(54.*mZ**2*pi**2*vT**2) + (g3bar**2*einsum("prTT,st,TT",C["qu8"],kd,kdt)*log(scale**2/mt**2))/(192.*Nc*pi**2) - (mt**6*einsum("pTst,rT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("pTst,rT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("pTst,rT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("pTst,rT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("pTst,rT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("pTst,rT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (g3bar**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(48.*Nc*pi**2) + (mt**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (g3bar**2*einsum("ptTT,sr,TT",C["qu8"],kd,kdt)*log(scale**2/mt**2))/(192.*pi**2) - (g3bar**2*einsum("pTTt,sr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2) - (g3bar**2*einsum("srTT,pt,TT",C["qu8"],kd,kdt)*log(scale**2/mt**2))/(192.*pi**2) - (mt**6*einsum("sTpr,tT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("sTpr,tT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("sTpr,tT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("sTpr,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("sTpr,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("sTpr,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("stpT,rT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("stpT,rT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("stpT,rT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("stpT,rT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("stpT,rT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("stpT,rT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("stTr,pT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("stTr,pT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("stTr,pT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("stTr,pT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("stTr,pT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("stTr,pT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (g3bar**2*einsum("sTTr,pt,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2) + (mt**2*Nc*einsum("stTT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) + (mW**2*Nc*einsum("stTT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(54.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("stTT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(24.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("stTT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(54.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("stTT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (mW**2*Nc*einsum("stTT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(54.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("stTT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(24.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("stTT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(54.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("stTT,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) + (mW**2*Nc*einsum("stTT,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(54.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("stTT,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(24.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("stTT,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(54.*mZ**2*pi**2*vT**2) + (g3bar**2*einsum("stTT,pr,TT",C["qu8"],kd,kdt)*log(scale**2/mt**2))/(192.*Nc*pi**2) + (g3bar**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(48.*Nc*pi**2) + (mt**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (g3bar**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(48.*Nc*pi**2) + (mt**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**6*einsum("Trst,pT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("Trst,pT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("Trst,pT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("Trst,pT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("Trst,pT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("Trst,pT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (g3bar**2*einsum("TrsT,pt,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2) - (mt**6*einsum("Ttpr,sT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("Ttpr,sT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("Ttpr,sT,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("Ttpr,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("Ttpr,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("Ttpr,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*Nc*einsum("TTpr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) + (mW**2*Nc*einsum("TTpr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(54.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TTpr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(24.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("TTpr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(54.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TTpr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (mW**2*Nc*einsum("TTpr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(54.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TTpr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(24.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("TTpr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(54.*mZ**2*pi**2*vT**2) - (g3bar**2*einsum("TtpT,sr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2) + (g3bar**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(48.*Nc*pi**2) + (mt**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TTst,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) + (mW**2*Nc*einsum("TTst,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(54.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TTst,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(24.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("TTst,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(54.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TTst,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (mW**2*Nc*einsum("TTst,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(54.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TTst,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(24.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("TTst,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(54.*mZ**2*pi**2*vT**2) - (11*mt**8*mW**2*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(144.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (25*mt**6*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (23*mt**4*mW**6*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (25*mt**2*mW**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(108.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (mW**10*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (mt**8*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (mt**6*mW**6*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(36.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (7*mt**4*mW**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (25*mt**2*mW**10*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(108.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (mW**12*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (3*g3bar**2*mt**4*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2*vT**2) + (g3bar**2*mt**2*mW**6*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2*vT**2) - (g3bar**2*mW**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2*vT**2) + (mt**10*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(192.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt**8*mW**2*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (3*mt**6*mW**4*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (5*mt**4*mW**6*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt**2*mW**8*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt**10*mW**2*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (7*mt**8*mW**4*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (31*mt**6*mW**6*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(288.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt**4*mW**8*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (2*mt**2*mW**10*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mW**12*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(54.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (13*g1bar*mt**8*mW**3*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(144.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (5*g1bar*mt**6*mW**5*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (3*g1bar*mt**4*mW**7*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) - (41*g1bar*mt**2*mW**9*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(216.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (g1bar*mW**11*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (mt**6*mW**3*C["W"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**3) - (mt**6*mW**5*C["W"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**3) - (mt**6*einsum("pr,sT,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("pr,sT,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("pr,sT,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*einsum("pr,sT,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (7*mt**4*mW**2*einsum("pr,sT,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("pr,sT,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*einsum("prTT,sT,tT,TT",C["qu1"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("prTT,sT,tT,TT",C["qu1"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("prTT,sT,tT,TT",C["qu1"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("prTT,sT,tT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) + (mt**4*mW**2*einsum("prTT,sT,tT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) - (mt**2*mW**4*einsum("prTT,sT,tT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) + (3*g3bar**2*mt**4*mW**4*einsum("pt,rT,sT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (g3bar**2*mt**2*mW**6*einsum("pt,rT,sT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (g3bar**2*mW**8*einsum("pt,rT,sT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (3*g3bar**2*mt**4*mW**4*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**4*(mt + mW)**4*pi**2) - (g3bar**2*mt**2*mW**6*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2) + (g3bar**2*mW**8*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2) + (g3bar*mt*mW**2*einsum("pT,sr,tT,TT",C["uG"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mt**2 - mW**2)*pi**2*vT) - (g3bar**2*mt**3*mW**5*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2) + (g3bar**2*mt*mW**7*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2) + (mt**6*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(192.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*mW**2*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**4*mW**4*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**2*mW**6*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (3*g3bar**2*mt**4*mW**4*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) + (g3bar**2*mt**2*mW**6*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) - (g3bar**2*mW**8*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) - (7*mt**10*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(192.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*mt**8*mW**2*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (83*mt**6*mW**4*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(576.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (35*mt**4*mW**6*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (91*mt**2*mW**8*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(432.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mW**10*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (7*mt**10*mW**2*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (13*mt**8*mW**4*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (109*mt**6*mW**6*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(288.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (25*mt**4*mW**8*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (59*mt**2*mW**10*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(216.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mW**12*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (g1bar*mt*mW**4*einsum("pT,st,rT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT) - (g3bar*mt*mW**2*einsum("pT,st,rT,TT",C["uG"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*(16*mt**2*Nc - 16*mW**2*Nc)*pi**2*vT) + (g3bar**2*mt**3*mW**5*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) - (g3bar**2*mt*mW**7*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) - (mt**7*mW**3*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (7*mt**3*mW**7*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt*mW**9*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*mt**7*mW**5*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (3*mt**5*mW**7*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (5*mt**3*mW**9*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt*mW**11*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt**6*einsum("ptTT,rT,sT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("ptTT,rT,sT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("ptTT,rT,sT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*g3bar**2*mt**4*mW**4*einsum("sr,pT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (g3bar**2*mt**2*mW**6*einsum("sr,pT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (g3bar**2*mW**8*einsum("sr,pT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt**6*einsum("srTT,pT,tT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("srTT,pT,tT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("srTT,pT,tT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(192.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*mW**2*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**4*mW**4*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**2*mW**6*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (3*g3bar**2*mt**4*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) + (g3bar**2*mt**2*mW**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) - (g3bar**2*mW**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) - (7*mt**10*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(192.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*mt**8*mW**2*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (83*mt**6*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(576.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (35*mt**4*mW**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (91*mt**2*mW**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(432.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mW**10*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (7*mt**10*mW**2*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (13*mt**8*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (109*mt**6*mW**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(288.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (25*mt**4*mW**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (59*mt**2*mW**10*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(216.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mW**12*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (g1bar*mt*mW**4*einsum("sT,pr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT) - (g3bar*mt*mW**2*einsum("sT,pr,tT,TT",C["uG"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*(16*mt**2*Nc - 16*mW**2*Nc)*pi**2*vT) + (g3bar**2*mt**3*mW**5*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) - (g3bar**2*mt*mW**7*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) - (mt**7*mW**3*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (7*mt**3*mW**7*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt*mW**9*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*mt**7*mW**5*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (3*mt**5*mW**7*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (5*mt**3*mW**9*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt*mW**11*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (11*mt**8*mW**2*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(144.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (25*mt**6*mW**4*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (23*mt**4*mW**6*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (25*mt**2*mW**8*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(108.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (mW**10*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (mt**8*mW**4*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (mt**6*mW**6*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(36.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (7*mt**4*mW**8*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (25*mt**2*mW**10*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(108.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (mW**12*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (3*g3bar**2*mt**4*mW**4*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2*vT**2) + (g3bar**2*mt**2*mW**6*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2*vT**2) - (g3bar**2*mW**8*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2*vT**2) + (mt**10*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(192.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt**8*mW**2*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (3*mt**6*mW**4*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (5*mt**4*mW**6*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt**2*mW**8*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt**10*mW**2*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (7*mt**8*mW**4*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (31*mt**6*mW**6*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(288.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt**4*mW**8*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (2*mt**2*mW**10*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mW**12*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(54.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (13*g1bar*mt**8*mW**3*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(144.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (5*g1bar*mt**6*mW**5*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (3*g1bar*mt**4*mW**7*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) - (41*g1bar*mt**2*mW**9*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(216.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (g1bar*mW**11*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (mt**6*mW**3*C["W"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**3) - (mt**6*mW**5*C["W"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**3) - (mt**6*einsum("st,pT,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("st,pT,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("st,pT,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*einsum("st,pT,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (7*mt**4*mW**2*einsum("st,pT,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("st,pT,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*g3bar**2*mt**4*mW**4*einsum("sT,pt,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**4*(mt + mW)**4*pi**2) - (g3bar**2*mt**2*mW**6*einsum("sT,pt,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2) + (g3bar**2*mW**8*einsum("sT,pt,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2) + (g3bar*mt*mW**2*einsum("sT,pt,rT,TT",C["uG"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mt**2 - mW**2)*pi**2*vT) - (g3bar**2*mt**3*mW**5*einsum("sT,pt,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2) + (g3bar**2*mt*mW**7*einsum("sT,pt,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2) + (mt**6*einsum("stTT,pT,rT,TT",C["qu1"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("stTT,pT,rT,TT",C["qu1"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("stTT,pT,rT,TT",C["qu1"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("stTT,pT,rT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) + (mt**4*mW**2*einsum("stTT,pT,rT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) - (mt**2*mW**4*einsum("stTT,pT,rT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) + (3*g3bar**2*mt**4*mW**4*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**4*(mt + mW)**4*pi**2) - (g3bar**2*mt**2*mW**6*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2) + (g3bar**2*mW**8*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2) + (g3bar*mt*mW**2*einsum("Tr,pt,sT,TT",C["uGDag"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mt**2 - mW**2)*pi**2*vT) - (g3bar**2*mt**3*mW**5*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2) + (g3bar**2*mt*mW**7*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2) + (mt**6*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(192.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*mW**2*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**4*mW**4*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**2*mW**6*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (3*g3bar**2*mt**4*mW**4*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) + (g3bar**2*mt**2*mW**6*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) - (g3bar**2*mW**8*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) - (7*mt**10*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(192.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*mt**8*mW**2*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (83*mt**6*mW**4*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(576.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (35*mt**4*mW**6*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (91*mt**2*mW**8*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(432.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mW**10*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (7*mt**10*mW**2*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (13*mt**8*mW**4*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (109*mt**6*mW**6*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(288.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (25*mt**4*mW**8*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (59*mt**2*mW**10*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(216.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mW**12*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (g1bar*mt*mW**4*einsum("Tr,st,pT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT) - (g3bar*mt*mW**2*einsum("Tr,st,pT,TT",C["uGDag"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*(16*mt**2*Nc - 16*mW**2*Nc)*pi**2*vT) + (g3bar**2*mt**3*mW**5*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) - (g3bar**2*mt*mW**7*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) - (mt**7*mW**3*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (7*mt**3*mW**7*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt*mW**9*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*mt**7*mW**5*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (3*mt**5*mW**7*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (5*mt**3*mW**9*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt*mW**11*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt**6*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(192.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*mW**2*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**4*mW**4*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**2*mW**6*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (3*g3bar**2*mt**4*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) + (g3bar**2*mt**2*mW**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) - (g3bar**2*mW**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) - (7*mt**10*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(192.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*mt**8*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (83*mt**6*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(576.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (35*mt**4*mW**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (91*mt**2*mW**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(432.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mW**10*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (7*mt**10*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (13*mt**8*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (109*mt**6*mW**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(288.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (25*mt**4*mW**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (59*mt**2*mW**10*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(216.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mW**12*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (g1bar*mt*mW**4*einsum("Tt,pr,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT) - (g3bar*mt*mW**2*einsum("Tt,pr,sT,TT",C["uGDag"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*(16*mt**2*Nc - 16*mW**2*Nc)*pi**2*vT) + (g3bar**2*mt**3*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) - (g3bar**2*mt*mW**7*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) - (mt**7*mW**3*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (7*mt**3*mW**7*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt*mW**9*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*mt**7*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (3*mt**5*mW**7*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (5*mt**3*mW**9*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt*mW**11*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*pi**2*vT**2) - (mW**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*pi**2*vT**2) - (mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*mZ**4*pi**2*vT**2) + (2*mW**6*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*pi**2*vT**2) + (mW**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*pi**2*vT**2) + (mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*mZ**4*pi**2*vT**2) - (2*mW**6*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*pi**2*vT**2) - (mW**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*pi**2*vT**2) + (mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*mZ**4*pi**2*vT**2) + (2*mW**6*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) + (5*g1bar*mt*mW**4*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*sqrt(2)*mZ**4*pi**2*vT) + (13*g1bar*mt*mW**2*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(216.*sqrt(2)*mZ**2*pi**2*vT) + (5*g1bar*mt*mW**4*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*sqrt(2)*mZ**4*pi**2*vT) + (13*g1bar*mt*mW**2*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(216.*sqrt(2)*mZ**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*mH**2*mZ**4*pi**2*vT) + (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*mH**2*mZ**4*pi**2*vT) + (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (5*mt*mW*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*sqrt(2)*pi**2*vT**2) - (13*mt*mW**5*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(54.*sqrt(2)*mZ**4*pi**2*vT**2) - (11*mt*mW**3*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*sqrt(2)*mZ**2*pi**2*vT**2) + (5*mt*mW*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*sqrt(2)*pi**2*vT**2) - (13*mt*mW**5*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(54.*sqrt(2)*mZ**4*pi**2*vT**2) - (11*mt*mW**3*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*sqrt(2)*mZ**2*pi**2*vT**2) + (3*g3bar**2*mt**4*mW**4*einsum("Tt,sr,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(64.*(mt - mW)**4*(mt + mW)**4*pi**2) - (g3bar**2*mt**2*mW**6*einsum("Tt,sr,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2) + (g3bar**2*mW**8*einsum("Tt,sr,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2) + (g3bar*mt*mW**2*einsum("Tt,sr,pT,TT",C["uGDag"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mt**2 - mW**2)*pi**2*vT) - (g3bar**2*mt**3*mW**5*einsum("Tt,sr,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2) + (g3bar**2*mt*mW**7*einsum("Tt,sr,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2) - (mt**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**4*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**2*mW**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (g1bar*mt**5*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uB"],kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (g1bar*mt**3*mW**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uB"],kdt)*log(scale**2/mt**2))/(48.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (g1bar*mt**5*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uBDag"],kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (g1bar*mt**3*mW**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uBDag"],kdt)*log(scale**2/mt**2))/(48.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (g3bar*mt**5*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uG"],kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2*vT) - (g3bar*mt**3*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uG"],kdt)*log(scale**2/mt**2))/(32.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2*vT) + (g3bar*mt**5*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uGDag"],kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2*vT) - (g3bar*mt**3*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uGDag"],kdt)*log(scale**2/mt**2))/(32.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2*vT) + (mt**5*mW**3*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**3*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**5*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**3*mW**7*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**5*mW**3*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**3*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**5*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**3*mW**7*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (g3bar*mt**5*mW**2*einsum("pt,rT,sT,TT,TT",kd,kd,kd,C["uG"],kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT) + (g3bar*mt**3*mW**4*einsum("pt,rT,sT,TT,TT",kd,kd,kd,C["uG"],kdt)*log(scale**2/mt**2))/(32.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT) - (g3bar*mt**5*mW**2*einsum("pt,rT,sT,TT,TT",kd,kd,kd,C["uGDag"],kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT) + (g3bar*mt**3*mW**4*einsum("pt,rT,sT,TT,TT",kd,kd,kd,C["uGDag"],kdt)*log(scale**2/mt**2))/(32.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT) + (3*mt**6*mW**2*einsum("pT,rT,sT,Tt,TT",kd,kd,kd,C["phiq3"],kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (3*mt**5*mW**3*einsum("pT,rT,sT,Tt,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (3*mt**6*mW**2*einsum("pT,rT,tT,sT,TT",kd,kd,kd,C["phiq3"],kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (3*mt**5*mW**3*einsum("pT,rT,tT,sT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (3*mt**6*mW**2*einsum("pT,sT,tT,Tr,TT",kd,kd,kd,C["phiq3"],kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (3*mt**5*mW**3*einsum("pT,sT,tT,Tr,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (3*mt**6*mW**2*einsum("rT,sT,tT,pT,TT",kd,kd,kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) + (3*mt**6*mW**2*einsum("rT,sT,tT,pT,TT",kd,kd,kd,C["phiq3"],kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (3*mt**5*mW**3*einsum("rT,sT,tT,pT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (g3bar*mt**5*mW**2*einsum("sr,pT,tT,TT,TT",kd,kd,kd,C["uG"],kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT) + (g3bar*mt**3*mW**4*einsum("sr,pT,tT,TT,TT",kd,kd,kd,C["uG"],kdt)*log(scale**2/mt**2))/(32.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT) - (g3bar*mt**5*mW**2*einsum("sr,pT,tT,TT,TT",kd,kd,kd,C["uGDag"],kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT) + (g3bar*mt**3*mW**4*einsum("sr,pT,tT,TT,TT",kd,kd,kd,C["uGDag"],kdt)*log(scale**2/mt**2))/(32.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT) - (mt**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**4*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**2*mW**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (g1bar*mt**5*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uB"],kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (g1bar*mt**3*mW**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uB"],kdt)*log(scale**2/mt**2))/(48.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (g1bar*mt**5*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uBDag"],kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (g1bar*mt**3*mW**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uBDag"],kdt)*log(scale**2/mt**2))/(48.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (g3bar*mt**5*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uG"],kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2*vT) - (g3bar*mt**3*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uG"],kdt)*log(scale**2/mt**2))/(32.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2*vT) + (g3bar*mt**5*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uGDag"],kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2*vT) - (g3bar*mt**3*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uGDag"],kdt)*log(scale**2/mt**2))/(32.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2*vT) + (mt**5*mW**3*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**3*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**5*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**3*mW**7*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**5*mW**3*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**3*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**5*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**3*mW**7*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (19*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(432.*pi**2*vT**4) + (mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(24.*mH**2*pi**2*vT**4) + (7*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(9.*mZ**6*pi**2*vT**4) - (49*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(108.*mZ**4*pi**2*vT**4) + (mW**8*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mH**2*mZ**4*pi**2*vT**4) - (5*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(9.*mZ**2*pi**2*vT**4) + (mW**6*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mH**2*mZ**2*pi**2*vT**4) + (g3bar**2*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(24.*Nc*pi**2*vT**2) - (2*mW**10*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**6*pi**2*vT**2) + (mW**8*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**4*pi**2*vT**2) + (mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**2*pi**2*vT**2) + (mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(12.*mH**2*pi**2*vT**2) + (mW**8*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**4*pi**2*vT**2) + (mW**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**2*pi**2*vT**2) - (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(48.*mH**2*pi**2*vT**2) + (7*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(9.*mZ**6*pi**2*vT**2) - (7*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(27.*mZ**4*pi**2*vT**2) + (mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(12.*mH**2*mZ**4*pi**2*vT**2) - (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(12.*mZ**2*pi**2*vT**2) + (mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(12.*mH**2*pi**2*vT**2) + (2*mW**10*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**6*pi**2*vT**2) + (11*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(9.*mZ**6*pi**2*vT) + (g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**6*pi**2*vT) - (11*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(36.*mZ**4*pi**2*vT) + (g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mH**2*mZ**4*pi**2*vT) - (55*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(216.*mZ**2*pi**2*vT) + (mW**3*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*pi**2*vT**3) + (4*mW**9*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mZ**6*pi**2*vT**3) - (7*mW**7*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mZ**4*pi**2*vT**3) - (11*mW**5*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mZ**2*pi**2*vT**3) + (7*mW**6*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mW**2))/(12.*mZ**4*pi**2*vT**2) - (7*mW**4*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mW**2))/(12.*mZ**2*pi**2*vT**2) + (g3bar**2*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mW**2))/(24.*Nc*pi**2) - (17*mW**2*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mW**2))/(216.*pi**2*vT**2) + (7*mW**6*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mW**2))/(12.*mZ**4*pi**2*vT**2) - (95*mW**4*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mW**2))/(108.*mZ**2*pi**2*vT**2) - (g3bar**2*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(24.*pi**2*vT**2) - (g3bar**2*einsum("pt,sr",C["phiq3"],kd)*log(scale**2/mW**2))/(24.*pi**2) - (g3bar**2*einsum("sr,pt",C["phiq3"],kd)*log(scale**2/mW**2))/(24.*pi**2) + (7*mW**6*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mW**2))/(12.*mZ**4*pi**2*vT**2) - (7*mW**4*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mW**2))/(12.*mZ**2*pi**2*vT**2) + (g3bar**2*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mW**2))/(24.*Nc*pi**2) - (17*mW**2*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mW**2))/(216.*pi**2*vT**2) + (7*mW**6*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mW**2))/(12.*mZ**4*pi**2*vT**2) - (95*mW**4*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mW**2))/(108.*mZ**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("prsT,tT,TT",C["qq1"],kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("prsT,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("prTt,sT,TT",C["qq1"],kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("prTt,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("pTst,rT,TT",C["qq1"],kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("pTst,rT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("sTpr,tT,TT",C["qq1"],kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("sTpr,tT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("stpT,rT,TT",C["qq1"],kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("stpT,rT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("stTr,pT,TT",C["qq1"],kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("stTr,pT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("Trst,pT,TT",C["qq1"],kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("Trst,pT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("Ttpr,sT,TT",C["qq1"],kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("Ttpr,sT,TT",C["qq3"],kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (17*mt**8*mW**2*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(432.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (43*mt**6*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(216.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (37*mt**4*mW**6*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(144.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (mt**2*mW**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (4*mt**8*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (19*mt**6*mW**6*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(108.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (5*mt**4*mW**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(72.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (mt**2*mW**10*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(12.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (g3bar**2*mt**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(48.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2*vT**2) + (g3bar**2*mt**6*mW**2*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(12.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2*vT**2) - (5*g3bar**2*mt**4*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2*vT**2) - (mt**6*mW**4*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt**4*mW**6*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt**2*mW**8*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (2*mt**8*mW**4*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (103*mt**6*mW**6*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(864.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt**4*mW**8*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(36.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt**2*mW**10*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(96.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (55*g1bar*mt**8*mW**3*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(432.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) - (47*g1bar*mt**6*mW**5*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(216.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (5*g1bar*mt**4*mW**7*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(144.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (g1bar*mt**2*mW**9*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(24.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) - (mt**6*mW**3*C["W"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**3) + (mt**6*mW**5*C["W"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**3) + (3*mt**2*mW**4*einsum("pr,sT,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**4*mW**2*einsum("pr,sT,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**2*mW**4*einsum("pr,sT,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**2*mW**4*einsum("prTT,sT,tT,TT",C["qu1"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("prTT,sT,tT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) + (g3bar**2*mt**8*einsum("pt,rT,sT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (g3bar**2*mt**6*mW**2*einsum("pt,rT,sT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*g3bar**2*mt**4*mW**4*einsum("pt,rT,sT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (g3bar**2*mt**8*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2) - (g3bar**2*mt**6*mW**2*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2) + (5*g3bar**2*mt**4*mW**4*einsum("pT,sr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**4*(mt + mW)**4*pi**2) - (g3bar*mt*mW**2*einsum("pT,sr,tT,TT",C["uG"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mt**2 - mW**2)*pi**2*vT) + (g3bar**2*mt**3*mW**5*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2) - (g3bar**2*mt*mW**7*einsum("pT,sr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2) - (mt**2*mW**4*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**6*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (g3bar**2*mt**8*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(48.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) + (g3bar**2*mt**6*mW**2*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(12.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) - (5*g3bar**2*mt**4*mW**4*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) + (17*mt**8*mW**2*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(432.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (371*mt**6*mW**4*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(1728.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (83*mt**4*mW**6*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(288.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (19*mt**2*mW**8*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(192.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (4*mt**8*mW**4*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (179*mt**6*mW**6*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(864.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt**4*mW**8*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(144.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (5*mt**2*mW**10*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(96.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (g1bar*mt*mW**4*einsum("pT,st,rT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mW**2))/(24.*sqrt(2)*(mt**2 - mW**2)*mZ**2*pi**2*vT) + (g3bar*mt*mW**2*einsum("pT,st,rT,TT",C["uG"],kd,kd,kdt)*log(scale**2/mW**2))/(sqrt(2)*(16*mt**2*Nc - 16*mW**2*Nc)*pi**2*vT) - (g3bar**2*mt**3*mW**5*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) + (g3bar**2*mt*mW**7*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) + (mt**7*mW**3*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(24.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (7*mt**3*mW**7*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(72.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt*mW**9*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(36.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (5*mt**7*mW**5*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (3*mt**5*mW**7*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (5*mt**3*mW**9*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(18.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt*mW**11*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(36.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (3*mt**2*mW**4*einsum("ptTT,rT,sT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (g3bar**2*mt**8*einsum("sr,pT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (g3bar**2*mt**6*mW**2*einsum("sr,pT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*g3bar**2*mt**4*mW**4*einsum("sr,pT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (3*mt**2*mW**4*einsum("srTT,pT,tT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**6*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (g3bar**2*mt**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(48.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) + (g3bar**2*mt**6*mW**2*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(12.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) - (5*g3bar**2*mt**4*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) + (17*mt**8*mW**2*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(432.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (371*mt**6*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(1728.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (83*mt**4*mW**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(288.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (19*mt**2*mW**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(192.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (4*mt**8*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (179*mt**6*mW**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(864.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt**4*mW**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(144.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (5*mt**2*mW**10*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(96.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (g1bar*mt*mW**4*einsum("sT,pr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mW**2))/(24.*sqrt(2)*(mt**2 - mW**2)*mZ**2*pi**2*vT) + (g3bar*mt*mW**2*einsum("sT,pr,tT,TT",C["uG"],kd,kd,kdt)*log(scale**2/mW**2))/(sqrt(2)*(16*mt**2*Nc - 16*mW**2*Nc)*pi**2*vT) - (g3bar**2*mt**3*mW**5*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) + (g3bar**2*mt*mW**7*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) + (mt**7*mW**3*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(24.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (7*mt**3*mW**7*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(72.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt*mW**9*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(36.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (5*mt**7*mW**5*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (3*mt**5*mW**7*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (5*mt**3*mW**9*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(18.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt*mW**11*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(36.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (17*mt**8*mW**2*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(432.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (43*mt**6*mW**4*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(216.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (37*mt**4*mW**6*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(144.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (mt**2*mW**8*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (4*mt**8*mW**4*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (19*mt**6*mW**6*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(108.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (5*mt**4*mW**8*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(72.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (mt**2*mW**10*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(12.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (g3bar**2*mt**8*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(48.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2*vT**2) + (g3bar**2*mt**6*mW**2*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(12.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2*vT**2) - (5*g3bar**2*mt**4*mW**4*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2*vT**2) - (mt**6*mW**4*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt**4*mW**6*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt**2*mW**8*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (2*mt**8*mW**4*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (103*mt**6*mW**6*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(864.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt**4*mW**8*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(36.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt**2*mW**10*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(96.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (55*g1bar*mt**8*mW**3*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(432.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) - (47*g1bar*mt**6*mW**5*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(216.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (5*g1bar*mt**4*mW**7*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(144.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (g1bar*mt**2*mW**9*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(24.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) - (mt**6*mW**3*C["W"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**3) + (mt**6*mW**5*C["W"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**3) + (3*mt**2*mW**4*einsum("st,pT,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**4*mW**2*einsum("st,pT,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**2*mW**4*einsum("st,pT,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (g3bar**2*mt**8*einsum("sT,pt,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2) - (g3bar**2*mt**6*mW**2*einsum("sT,pt,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2) + (5*g3bar**2*mt**4*mW**4*einsum("sT,pt,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**4*(mt + mW)**4*pi**2) - (g3bar*mt*mW**2*einsum("sT,pt,rT,TT",C["uG"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mt**2 - mW**2)*pi**2*vT) + (g3bar**2*mt**3*mW**5*einsum("sT,pt,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2) - (g3bar**2*mt*mW**7*einsum("sT,pt,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2) - (3*mt**2*mW**4*einsum("stTT,pT,rT,TT",C["qu1"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("stTT,pT,rT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) + (g3bar**2*mt**8*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2) - (g3bar**2*mt**6*mW**2*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2) + (5*g3bar**2*mt**4*mW**4*einsum("Tr,pt,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**4*(mt + mW)**4*pi**2) - (g3bar*mt*mW**2*einsum("Tr,pt,sT,TT",C["uGDag"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mt**2 - mW**2)*pi**2*vT) + (g3bar**2*mt**3*mW**5*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2) - (g3bar**2*mt*mW**7*einsum("Tr,pt,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2) - (mt**2*mW**4*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**6*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (g3bar**2*mt**8*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(48.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) + (g3bar**2*mt**6*mW**2*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(12.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) - (5*g3bar**2*mt**4*mW**4*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) + (17*mt**8*mW**2*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(432.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (371*mt**6*mW**4*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(1728.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (83*mt**4*mW**6*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(288.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (19*mt**2*mW**8*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(192.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (4*mt**8*mW**4*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (179*mt**6*mW**6*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(864.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt**4*mW**8*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(144.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (5*mt**2*mW**10*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(96.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (g1bar*mt*mW**4*einsum("Tr,st,pT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mW**2))/(24.*sqrt(2)*(mt**2 - mW**2)*mZ**2*pi**2*vT) + (g3bar*mt*mW**2*einsum("Tr,st,pT,TT",C["uGDag"],kd,kd,kdt)*log(scale**2/mW**2))/(sqrt(2)*(16*mt**2*Nc - 16*mW**2*Nc)*pi**2*vT) - (g3bar**2*mt**3*mW**5*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) + (g3bar**2*mt*mW**7*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) + (mt**7*mW**3*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(24.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (7*mt**3*mW**7*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(72.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt*mW**9*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(36.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (5*mt**7*mW**5*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (3*mt**5*mW**7*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (5*mt**3*mW**9*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(18.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt*mW**11*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(36.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt**2*mW**4*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**6*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (g3bar**2*mt**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(48.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) + (g3bar**2*mt**6*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(12.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) - (5*g3bar**2*mt**4*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) + (17*mt**8*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(432.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (371*mt**6*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(1728.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (83*mt**4*mW**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(288.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (19*mt**2*mW**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(192.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (4*mt**8*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (179*mt**6*mW**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(864.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt**4*mW**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(144.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (5*mt**2*mW**10*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(96.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (g1bar*mt*mW**4*einsum("Tt,pr,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mW**2))/(24.*sqrt(2)*(mt**2 - mW**2)*mZ**2*pi**2*vT) + (g3bar*mt*mW**2*einsum("Tt,pr,sT,TT",C["uGDag"],kd,kd,kdt)*log(scale**2/mW**2))/(sqrt(2)*(16*mt**2*Nc - 16*mW**2*Nc)*pi**2*vT) - (g3bar**2*mt**3*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) + (g3bar**2*mt*mW**7*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*Nc*pi**2) + (mt**7*mW**3*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(24.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (7*mt**3*mW**7*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(72.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt*mW**9*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(36.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (5*mt**7*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (3*mt**5*mW**7*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (5*mt**3*mW**9*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(18.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt*mW**11*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(36.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (g3bar**2*mt**8*einsum("Tt,sr,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2) - (g3bar**2*mt**6*mW**2*einsum("Tt,sr,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2) + (5*g3bar**2*mt**4*mW**4*einsum("Tt,sr,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(64.*(mt - mW)**4*(mt + mW)**4*pi**2) - (g3bar*mt*mW**2*einsum("Tt,sr,pT,TT",C["uGDag"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mt**2 - mW**2)*pi**2*vT) + (g3bar**2*mt**3*mW**5*einsum("Tt,sr,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2) - (g3bar**2*mt*mW**7*einsum("Tt,sr,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2) + (mt**2*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (g1bar*mt**5*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uB"],kdt)*log(scale**2/mW**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (g1bar*mt**3*mW**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uB"],kdt)*log(scale**2/mW**2))/(48.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (g1bar*mt**5*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uBDag"],kdt)*log(scale**2/mW**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (g1bar*mt**3*mW**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uBDag"],kdt)*log(scale**2/mW**2))/(48.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (g3bar*mt**5*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uG"],kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2*vT) + (g3bar*mt**3*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uG"],kdt)*log(scale**2/mW**2))/(32.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2*vT) - (g3bar*mt**5*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uGDag"],kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2*vT) + (g3bar*mt**3*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uGDag"],kdt)*log(scale**2/mW**2))/(32.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2*vT) - (mt**5*mW**3*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**3*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**5*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mt**3*mW**7*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mt**5*mW**3*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**3*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**5*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mt**3*mW**7*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (g3bar*mt**5*mW**2*einsum("pt,rT,sT,TT,TT",kd,kd,kd,C["uG"],kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT) - (g3bar*mt**3*mW**4*einsum("pt,rT,sT,TT,TT",kd,kd,kd,C["uG"],kdt)*log(scale**2/mW**2))/(32.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT) + (g3bar*mt**5*mW**2*einsum("pt,rT,sT,TT,TT",kd,kd,kd,C["uGDag"],kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT) - (g3bar*mt**3*mW**4*einsum("pt,rT,sT,TT,TT",kd,kd,kd,C["uGDag"],kdt)*log(scale**2/mW**2))/(32.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT) - (3*mt**6*mW**2*einsum("pT,rT,sT,Tt,TT",kd,kd,kd,C["phiq3"],kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (3*mt**5*mW**3*einsum("pT,rT,sT,Tt,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(8.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (3*mt**6*mW**2*einsum("pT,rT,tT,sT,TT",kd,kd,kd,C["phiq3"],kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (3*mt**5*mW**3*einsum("pT,rT,tT,sT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(8.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (3*mt**6*mW**2*einsum("pT,sT,tT,Tr,TT",kd,kd,kd,C["phiq3"],kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (3*mt**5*mW**3*einsum("pT,sT,tT,Tr,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(8.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (3*mt**6*mW**2*einsum("rT,sT,tT,pT,TT",kd,kd,kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) - (3*mt**6*mW**2*einsum("rT,sT,tT,pT,TT",kd,kd,kd,C["phiq3"],kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (3*mt**5*mW**3*einsum("rT,sT,tT,pT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(8.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (g3bar*mt**5*mW**2*einsum("sr,pT,tT,TT,TT",kd,kd,kd,C["uG"],kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT) - (g3bar*mt**3*mW**4*einsum("sr,pT,tT,TT,TT",kd,kd,kd,C["uG"],kdt)*log(scale**2/mW**2))/(32.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT) + (g3bar*mt**5*mW**2*einsum("sr,pT,tT,TT,TT",kd,kd,kd,C["uGDag"],kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT) - (g3bar*mt**3*mW**4*einsum("sr,pT,tT,TT,TT",kd,kd,kd,C["uGDag"],kdt)*log(scale**2/mW**2))/(32.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT) + (mt**2*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (g1bar*mt**5*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uB"],kdt)*log(scale**2/mW**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (g1bar*mt**3*mW**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uB"],kdt)*log(scale**2/mW**2))/(48.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (g1bar*mt**5*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uBDag"],kdt)*log(scale**2/mW**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (g1bar*mt**3*mW**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uBDag"],kdt)*log(scale**2/mW**2))/(48.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (g3bar*mt**5*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uG"],kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2*vT) + (g3bar*mt**3*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uG"],kdt)*log(scale**2/mW**2))/(32.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2*vT) - (g3bar*mt**5*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uGDag"],kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2*vT) + (g3bar*mt**3*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uGDag"],kdt)*log(scale**2/mW**2))/(32.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*Nc*pi**2*vT) - (mt**5*mW**3*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**3*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**5*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mt**3*mW**7*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mt**5*mW**3*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**3*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**5*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mt**3*mW**7*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mW**2*einsum("prst",C["qq1"])*log(scale**2/mZ**2))/(12.*pi**2*vT**2) - (mW**4*einsum("prst",C["qq1"])*log(scale**2/mZ**2))/(12.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("prst",C["qq1"])*log(scale**2/mZ**2))/(48.*pi**2*vT**2) - (mW**2*einsum("prst",C["qq3"])*log(scale**2/mZ**2))/(12.*pi**2*vT**2) - (mW**4*einsum("prst",C["qq3"])*log(scale**2/mZ**2))/(12.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("prst",C["qq3"])*log(scale**2/mZ**2))/(48.*pi**2*vT**2) - (mW**2*einsum("stpr",C["qq1"])*log(scale**2/mZ**2))/(12.*pi**2*vT**2) - (mW**4*einsum("stpr",C["qq1"])*log(scale**2/mZ**2))/(12.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("stpr",C["qq1"])*log(scale**2/mZ**2))/(48.*pi**2*vT**2) - (mW**2*einsum("stpr",C["qq3"])*log(scale**2/mZ**2))/(12.*pi**2*vT**2) - (mW**4*einsum("stpr",C["qq3"])*log(scale**2/mZ**2))/(12.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("stpr",C["qq3"])*log(scale**2/mZ**2))/(48.*pi**2*vT**2) - (11*mH**2*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(972.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (103*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(648.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (11*mH**2*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**4) - (11*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) - (11*mH**2*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(324.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) + (265*mW**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(1944.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (mW**4*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(12.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(32.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (mW**2*mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(12.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (mZ**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(48.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (11*g3bar**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(864.*Nc*pi**2*vT**2) + (11*g3bar**2*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(216.*mZ**4*Nc*pi**2*vT**2) + (11*g3bar**2*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(216.*mZ**2*Nc*pi**2*vT**2) + (mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (10*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(9.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (7*mH**2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(24.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (7*mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(18.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mW**6*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mH**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(24.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (23*mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(36.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mW**4*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mZ**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(12.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (7*mW**2*mZ**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(24.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mZ**8*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(24.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**4*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**2*mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mZ**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(24.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (11*g3bar**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(1728.*Nc*pi**2) + (11*g3bar**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(432.*mZ**4*Nc*pi**2) + (11*mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(1944.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (11*mH**2*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (11*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (221*mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3888.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**4*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(12.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**2*mZ**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(24.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (10*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(9.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (mH**2*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mW**4*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(18.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mW**6*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (11*mW**2*mZ**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(36.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mW**2*mZ**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (449*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(1944.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (259*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(486.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (22*g1bar*mH**4*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT) + (11*g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(486.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) - (44*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) - (11*g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(972.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (199*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(972.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (22*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**2*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(24.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (751*g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(1944.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mW**5*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (7*g1bar*mW*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(144.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mW**3*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mW*mZ**6*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(48.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (11*g1bar*g3bar**2*mW**3*vT*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(216.*mZ**4*Nc*pi**2) + (11*g1bar*g3bar**2*mW*vT*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(432.*mZ**2*Nc*pi**2) + (11*g3bar**2*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mZ**2))/(288.*Nc*pi**2) + (11*g3bar**2*mW**2*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mZ**2))/(144.*mZ**2*Nc*pi**2) - (11*mW**2*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mZ**2))/(324.*pi**2*vT**2) + (11*mW**6*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mZ**2))/(162.*mZ**4*pi**2*vT**2) - (11*mW**4*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mZ**2))/(324.*mZ**2*pi**2*vT**2) + (11*g3bar**2*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mZ**2))/(288.*Nc*pi**2) + (11*g3bar**2*mW**2*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mZ**2))/(144.*mZ**2*Nc*pi**2) - (11*mW**2*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mZ**2))/(324.*pi**2*vT**2) + (11*mW**6*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mZ**2))/(162.*mZ**4*pi**2*vT**2) - (11*mW**4*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mZ**2))/(324.*mZ**2*pi**2*vT**2) - (11*g3bar**2*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(864.*pi**2*vT**2) - (11*g3bar**2*mW**4*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(216.*mZ**4*pi**2*vT**2) - (11*g3bar**2*mW**2*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(216.*mZ**2*pi**2*vT**2) + (11*g3bar**2*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(1728.*pi**2) - (11*g3bar**2*mW**4*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(432.*mZ**4*pi**2) - (11*g1bar*g3bar**2*mW**3*vT*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(216.*mZ**4*pi**2) - (11*g1bar*g3bar**2*mW*vT*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(432.*mZ**2*pi**2) - (11*g3bar**2*einsum("pt,sr",C["phiq1"],kd)*log(scale**2/mZ**2))/(288.*pi**2) - (11*g3bar**2*mW**2*einsum("pt,sr",C["phiq1"],kd)*log(scale**2/mZ**2))/(144.*mZ**2*pi**2) - (11*g3bar**2*einsum("pt,sr",C["phiq3"],kd)*log(scale**2/mZ**2))/(288.*pi**2) - (11*g3bar**2*mW**2*einsum("pt,sr",C["phiq3"],kd)*log(scale**2/mZ**2))/(144.*mZ**2*pi**2) - (11*g3bar**2*einsum("sr,pt",C["phiq1"],kd)*log(scale**2/mZ**2))/(288.*pi**2) - (11*g3bar**2*mW**2*einsum("sr,pt",C["phiq1"],kd)*log(scale**2/mZ**2))/(144.*mZ**2*pi**2) - (11*g3bar**2*einsum("sr,pt",C["phiq3"],kd)*log(scale**2/mZ**2))/(288.*pi**2) - (11*g3bar**2*mW**2*einsum("sr,pt",C["phiq3"],kd)*log(scale**2/mZ**2))/(144.*mZ**2*pi**2) + (11*g3bar**2*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mZ**2))/(288.*Nc*pi**2) + (11*g3bar**2*mW**2*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mZ**2))/(144.*mZ**2*Nc*pi**2) - (11*mW**2*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mZ**2))/(324.*pi**2*vT**2) + (11*mW**6*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mZ**2))/(162.*mZ**4*pi**2*vT**2) - (11*mW**4*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mZ**2))/(324.*mZ**2*pi**2*vT**2) + (11*g3bar**2*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mZ**2))/(288.*Nc*pi**2) + (11*g3bar**2*mW**2*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mZ**2))/(144.*mZ**2*Nc*pi**2) - (11*mW**2*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mZ**2))/(324.*pi**2*vT**2) + (11*mW**6*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mZ**2))/(162.*mZ**4*pi**2*vT**2) - (11*mW**4*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mZ**2))/(324.*mZ**2*pi**2*vT**2) + (mW**3*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(81.*mt*pi**2*vT**2) + (mW**7*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**4*pi**2*vT**2) - (2*mW**5*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**2*pi**2*vT**2) + (mW**3*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*pi**2*vT**2) + (mW**7*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**4*pi**2*vT**2) - (2*mW**5*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**2*pi**2*vT**2) - (2*g1bar*mt*mW**6*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**6*pi**2*vT) - (2*g1bar*mt*mW**6*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**6*pi**2*vT) + (4*mt*mW**7*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**6*pi**2*vT**2) + (4*mt*mW**7*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**6*pi**2*vT**2))
    c['VedLL'] = ((-5*mW**4*einsum("prst",C["lq1"]))/(4.*mZ**2*pi**2*vT**2) + (bEvan*mW**4*einsum("prst",C["lq1"]))/(3.*mZ**2*pi**2*vT**2) + (5*mZ**2*einsum("prst",C["lq1"]))/(16.*pi**2*vT**2) - (bEvan*mZ**2*einsum("prst",C["lq1"]))/(12.*pi**2*vT**2) - (mW**2*einsum("prst",C["lq3"]))/(2.*pi**2*vT**2) + (bEvan*mW**2*einsum("prst",C["lq3"]))/(2.*pi**2*vT**2) - (5*mW**4*einsum("prst",C["lq3"]))/(4.*mZ**2*pi**2*vT**2) + (bEvan*mW**4*einsum("prst",C["lq3"]))/(3.*mZ**2*pi**2*vT**2) + (5*mZ**2*einsum("prst",C["lq3"]))/(16.*pi**2*vT**2) - (bEvan*mZ**2*einsum("prst",C["lq3"]))/(12.*pi**2*vT**2) - (7*mH**2*einsum("pr,st",kd,kd))/(96.*pi**2*vT**4) - (2369*mW**2*einsum("pr,st",kd,kd))/(9720.*pi**2*vT**4) - (bEvan*mW**2*einsum("pr,st",kd,kd))/(9.*pi**2*vT**4) + (mW**4*einsum("pr,st",kd,kd))/(12.*mH**2*pi**2*vT**4) + (524*mW**8*einsum("pr,st",kd,kd))/(243.*mZ**6*pi**2*vT**4) - (4*bEvan*mW**8*einsum("pr,st",kd,kd))/(9.*mZ**6*pi**2*vT**4) + (7*mH**2*mW**4*einsum("pr,st",kd,kd))/(24.*mZ**4*pi**2*vT**4) - (137*mW**6*einsum("pr,st",kd,kd))/(135.*mZ**4*pi**2*vT**4) + (4*bEvan*mW**6*einsum("pr,st",kd,kd))/(9.*mZ**4*pi**2*vT**4) + (mW**8*einsum("pr,st",kd,kd))/(3.*mH**2*mZ**4*pi**2*vT**4) - (3449*mW**4*einsum("pr,st",kd,kd))/(3240.*mZ**2*pi**2*vT**4) + (bEvan*mW**4*einsum("pr,st",kd,kd))/(9.*mZ**2*pi**2*vT**4) + (7*mZ**2*einsum("pr,st",kd,kd))/(96.*pi**2*vT**4) - (mZ**4*einsum("pr,st",kd,kd))/(24.*mH**2*pi**2*vT**4) + (mt**4*Nc*einsum("pr,st",kd,kd))/(6.*mH**2*pi**2*vT**4) - (16*mW**4*Nc*einsum("pr,st",kd,kd))/(405.*mt**2*pi**2*vT**4) - (2*mt**4*mW**4*Nc*einsum("pr,st",kd,kd))/(3.*mH**2*mZ**4*pi**2*vT**4) - (16*mW**8*Nc*einsum("pr,st",kd,kd))/(405.*mt**2*mZ**4*pi**2*vT**4) + (32*mW**6*Nc*einsum("pr,st",kd,kd))/(405.*mt**2*mZ**2*pi**2*vT**4) + (C["phi"]*einsum("pr,st",kd,kd))/(8.*pi**2) - (mW**4*C["phi"]*einsum("pr,st",kd,kd))/(2.*mZ**4*pi**2) + (2*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/((mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (2*mH**4*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (4*mW**10*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (2*mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (4*mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (4*mW**10*C["phiB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (2*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (4*mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(12.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mZ**6*C["phiB"]*einsum("pr,st",kd,kd))/(12.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (8*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (8*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (8*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (8*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (11*mH**2*C["phiBox"]*einsum("pr,st",kd,kd))/(48.*pi**2*vT**2) + (mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(6.*mH**2*pi**2*vT**2) + (11*mH**2*mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(12.*mZ**4*pi**2*vT**2) + (2*mW**8*C["phiBox"]*einsum("pr,st",kd,kd))/(3.*mH**2*mZ**4*pi**2*vT**2) - (5*mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(12.*mZ**2*pi**2*vT**2) + (5*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(48.*pi**2*vT**2) - (mZ**4*C["phiBox"]*einsum("pr,st",kd,kd))/(12.*mH**2*pi**2*vT**2) + (mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(3.*mH**2*pi**2*vT**2) - (4*mt**4*mW**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(3.*mH**2*mZ**4*pi**2*vT**2) + (mH**2*C["phiD"]*einsum("pr,st",kd,kd))/(12.*pi**2*vT**2) - (475*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(1944.*pi**2*vT**2) + (bEvan*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(18.*pi**2*vT**2) + (5*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(24.*mH**2*pi**2*vT**2) + (524*mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(243.*mZ**6*pi**2*vT**2) - (4*bEvan*mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(9.*mZ**6*pi**2*vT**2) - (mH**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(24.*mZ**4*pi**2*vT**2) - (59*mW**6*C["phiD"]*einsum("pr,st",kd,kd))/(270.*mZ**4*pi**2*vT**2) + (2*bEvan*mW**6*C["phiD"]*einsum("pr,st",kd,kd))/(9.*mZ**4*pi**2*vT**2) + (mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(6.*mH**2*mZ**4*pi**2*vT**2) - (209*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(1080.*mZ**2*pi**2*vT**2) - (mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(48.*pi**2*vT**2) - (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(12.*mH**2*pi**2*vT**2) - (mt**4*mW**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(3.*mH**2*mZ**4*pi**2*vT**2) - (16*mW**8*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(405.*mt**2*mZ**4*pi**2*vT**2) + (16*mW**6*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(405.*mt**2*mZ**2*pi**2*vT**2) - (11*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mH**4*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (4*mW**10*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (2*mH**4*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (2*mW**8*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (4*mW**10*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (2*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (2*mW**8*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (5*mW**4*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(6.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**2*mZ**4*C["phiW"]*einsum("pr,st",kd,kd))/(12.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (8*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (8*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (8*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (8*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (6257*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(9720.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (bEvan*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(2.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (1210*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(243.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) - (8*bEvan*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (2*g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(8.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (1876*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (4*bEvan*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (1210*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(243.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (8*bEvan*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (2*g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (2273*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(2430.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (bEvan*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (4967*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(2430.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (4*bEvan*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (g1bar*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(24.*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mW*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd))/(24.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) - (32*g1bar*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(405.*mt**2*(mH - mZ)*(mH + mZ)*pi**2*vT) - (4*g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (4*g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (32*g1bar*mH**2*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(405.*mt**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (32*g1bar*mH**2*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(405.*mt**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (32*g1bar*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(405.*mt**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (2*mW**7*C["W"]*einsum("pr,st",kd,kd))/(mZ**4*pi**2*vT**3) - (2*mW**5*C["W"]*einsum("pr,st",kd,kd))/(mZ**2*pi**2*vT**3) - (17*mW**2*einsum("pr,st",C["phil1"],kd))/(27.*pi**2*vT**2) + (bEvan*mW**2*einsum("pr,st",C["phil1"],kd))/(9.*pi**2*vT**2) + (55*mW**6*einsum("pr,st",C["phil1"],kd))/(54.*mZ**4*pi**2*vT**2) - (2*bEvan*mW**6*einsum("pr,st",C["phil1"],kd))/(9.*mZ**4*pi**2*vT**2) + (mW**4*einsum("pr,st",C["phil1"],kd))/(36.*mZ**2*pi**2*vT**2) + (bEvan*mW**4*einsum("pr,st",C["phil1"],kd))/(9.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("pr,st",C["phil1"],kd))/(24.*pi**2*vT**2) - (317*mW**2*einsum("pr,st",C["phil3"],kd))/(216.*pi**2*vT**2) + (bEvan*mW**2*einsum("pr,st",C["phil3"],kd))/(9.*pi**2*vT**2) + (55*mW**6*einsum("pr,st",C["phil3"],kd))/(54.*mZ**4*pi**2*vT**2) - (2*bEvan*mW**6*einsum("pr,st",C["phil3"],kd))/(9.*mZ**4*pi**2*vT**2) + (13*mW**4*einsum("pr,st",C["phil3"],kd))/(54.*mZ**2*pi**2*vT**2) + (bEvan*mW**4*einsum("pr,st",C["phil3"],kd))/(9.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("pr,st",C["phil3"],kd))/(24.*pi**2*vT**2) + (169*mW**2*einsum("st,pr",C["phiq1"],kd))/(162.*pi**2*vT**2) - (bEvan*mW**2*einsum("st,pr",C["phiq1"],kd))/(3.*pi**2*vT**2) + (607*mW**6*einsum("st,pr",C["phiq1"],kd))/(162.*mZ**4*pi**2*vT**2) - (2*bEvan*mW**6*einsum("st,pr",C["phiq1"],kd))/(3.*mZ**4*pi**2*vT**2) - (1471*mW**4*einsum("st,pr",C["phiq1"],kd))/(324.*mZ**2*pi**2*vT**2) + (bEvan*mW**4*einsum("st,pr",C["phiq1"],kd))/(mZ**2*pi**2*vT**2) + (mZ**2*einsum("st,pr",C["phiq1"],kd))/(8.*pi**2*vT**2) - (479*mW**2*einsum("st,pr",C["phiq3"],kd))/(648.*pi**2*vT**2) - (bEvan*mW**2*einsum("st,pr",C["phiq3"],kd))/(3.*pi**2*vT**2) + (607*mW**6*einsum("st,pr",C["phiq3"],kd))/(162.*mZ**4*pi**2*vT**2) - (2*bEvan*mW**6*einsum("st,pr",C["phiq3"],kd))/(3.*mZ**4*pi**2*vT**2) - (274*mW**4*einsum("st,pr",C["phiq3"],kd))/(81.*mZ**2*pi**2*vT**2) + (bEvan*mW**4*einsum("st,pr",C["phiq3"],kd))/(mZ**2*pi**2*vT**2) + (mZ**2*einsum("st,pr",C["phiq3"],kd))/(8.*pi**2*vT**2) - (3*mt**4*einsum("prsT,tT,TT",C["lq1"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("prsT,tT,TT",C["lq1"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("prsT,tT,TT",C["lq3"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("prsT,tT,TT",C["lq3"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("prTt,sT,TT",C["lq1"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("prTt,sT,TT",C["lq1"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("prTt,sT,TT",C["lq3"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("prTt,sT,TT",C["lq3"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(4.*pi**2*vT**2) - (2*mW**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(9.*pi**2*vT**2) - (mt**2*mW**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(2.*mZ**2*pi**2*vT**2) + (2*mW**4*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(9.*mZ**2*pi**2*vT**2) + (mt**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(4.*pi**2*vT**2) - (2*mW**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(9.*pi**2*vT**2) - (mt**2*mW**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(2.*mZ**2*pi**2*vT**2) + (2*mW**4*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(9.*mZ**2*pi**2*vT**2) - (mt**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(8.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) + (125*mt**6*mW**2*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(72.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) - (113*mt**4*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(36.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) + (5*mt**2*mW**6*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(3.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) - (2*mW**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(9.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) + (mt**8*mW**2*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(4.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) - (179*mt**6*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(72.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) + (307*mt**4*mW**6*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(72.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) - (13*mt**2*mW**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(6.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) + (2*mW**10*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(9.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) + (mt**8*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(64.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (9*mt**6*mW**2*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(64.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (15*mt**4*mW**4*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(64.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (7*mt**2*mW**6*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(64.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (3*mt**8*mW**2*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(32.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (277*mt**6*mW**4*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(288.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (479*mt**4*mW**6*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(288.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (83*mt**2*mW**8*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(96.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mW**10*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(9.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (g1bar*mt**8*mW*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(8.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (29*g1bar*mt**6*mW**3*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(18.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (113*g1bar*mt**4*mW**5*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(36.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (43*g1bar*mt**2*mW**7*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(24.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (2*g1bar*mW**9*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(9.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (9*mt**4*mW**3*C["W"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**3) - (3*mt**2*mW**5*C["W"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**3) - (9*mt**4*mW**5*C["W"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(4.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**3) + (3*mt**2*mW**7*C["W"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/(4.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**3) + (mt**4*einsum("pr,sT,tT,TT",C["phil1"],kd,kd,kdt))/((32*mt**2 - 32*mW**2)*pi**2*vT**2) - (7*mt**2*mW**2*einsum("pr,sT,tT,TT",C["phil1"],kd,kd,kdt))/((32*mt**2 - 32*mW**2)*pi**2*vT**2) + (7*mt**4*einsum("pr,sT,tT,TT",C["phil3"],kd,kd,kdt))/((32*mt**2 - 32*mW**2)*pi**2*vT**2) - (25*mt**2*mW**2*einsum("pr,sT,tT,TT",C["phil3"],kd,kd,kdt))/((32*mt**2 - 32*mW**2)*pi**2*vT**2) + (mt**2*einsum("prTT,sT,tT,TT",C["lq1"],kd,kd,kdt))/(8.*pi**2*vT**2) - (mt**2*einsum("prTT,sT,tT,TT",C["lq3"],kd,kd,kdt))/(8.*pi**2*vT**2) - (mt**4*einsum("prTT,sT,tT,TT",C["lu"],kd,kd,kdt))/(32.*(mt**2 - mW**2)*pi**2*vT**2) + (7*mt**2*mW**2*einsum("prTT,sT,tT,TT",C["lu"],kd,kd,kdt))/(32.*(mt**2 - mW**2)*pi**2*vT**2) - (3*mt**4*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt**4*mW**2*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt))/(32.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt))/(32.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) + (5*mt**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(64.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (595*mt**6*mW**2*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(576.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (1349*mt**4*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(576.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (263*mt**2*mW**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(192.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (2*mW**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(9.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (5*mt**8*mW**2*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(32.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (311*mt**6*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(288.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (769*mt**4*mW**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(288.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (151*mt**2*mW**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(96.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (2*mW**10*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(9.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (3*mt**7*mW*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(4.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (5*mt**5*mW**3*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(36.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (31*mt**3*mW**5*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(18.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (17*mt*mW**7*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(18.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (3*mt**7*mW**3*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(2.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (59*mt**5*mW**5*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(36.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (35*mt**3*mW**7*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(36.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (17*mt*mW**9*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(18.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (3*mt**4*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt**4*mW**2*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt))/(32.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt))/(32.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) + (5*mt**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(64.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (595*mt**6*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(576.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (1349*mt**4*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(576.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (263*mt**2*mW**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(192.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (2*mW**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(9.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (5*mt**8*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(32.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (311*mt**6*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(288.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (769*mt**4*mW**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(288.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (151*mt**2*mW**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(96.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (2*mW**10*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(9.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (3*mt**7*mW*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(4.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (5*mt**5*mW**3*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(36.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (31*mt**3*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(18.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (17*mt*mW**7*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(18.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (3*mt**7*mW**3*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(2.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (59*mt**5*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(36.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (35*mt**3*mW**7*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(36.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (17*mt*mW**9*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(18.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(12.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(3.*sqrt(2)*mH**2*mZ**4*pi**2*vT) - (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(12.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(3.*sqrt(2)*mH**2*mZ**4*pi**2*vT) + (mt**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiq1"],kdt))/(8.*pi**2*vT**2) - (mt**2*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiq1"],kdt))/(4.*mZ**2*pi**2*vT**2) - (mt**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiq3"],kdt))/(8.*pi**2*vT**2) + (mt**2*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiq3"],kdt))/(4.*mZ**2*pi**2*vT**2) - (mt**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(32.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (7*mt**2*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(32.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**4*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(16.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) - (7*mt**2*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(16.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) + (g1bar*mt**5*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uB"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) + (3*g1bar*mt**3*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uB"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) - (g1bar*mt*mW**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uB"],kdt))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) + (g1bar*mt**5*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uBDag"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) + (3*g1bar*mt**3*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uBDag"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) - (g1bar*mt*mW**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uBDag"],kdt))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) + (mt**5*mW*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**3*mW**3*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**5*mW**3*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (3*mt**3*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt*mW**7*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**5*mW*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**3*mW**3*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**5*mW**3*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (3*mt**3*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt*mW**7*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mH**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mH**4*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) - (mH**2*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) + (mH**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*pi**2) - (mW**4*C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*mZ**4*pi**2) + (2*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (2*mH**6*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT**2) + (2*mH**6*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) + (2*mH**4*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) - (2*mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (2*mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (5*mH**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(24.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (5*mH**4*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (4*mH**2*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mH**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mH**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mH**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (2*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (2*mH**6*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT**2) - (2*mH**6*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) - (2*mH**4*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) + (2*mH**4*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (2*mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (g1bar*mH**6*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**6*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) - (mt**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(24.*pi**2*vT**4) + (mt**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(6.*mH**2*pi**2*vT**4) - (32*mW**8*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**6*pi**2*vT**4) + (mt**2*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(6.*mZ**4*pi**2*vT**4) - (2*mt**4*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**4*pi**2*vT**4) + (52*mW**6*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**4) - (20*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**4) + (8*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**6*pi**2*vT**2) - (8*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**4*pi**2*vT**2) + (mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*pi**2*vT**2) - (4*mt**4*mW**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**4*pi**2*vT**2) + (mt**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(24.*pi**2*vT**2) - (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(12.*mH**2*pi**2*vT**2) - (32*mW**8*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**6*pi**2*vT**2) - (mt**4*mW**4*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**4*pi**2*vT**2) + (26*mW**6*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (8*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**6*pi**2*vT**2) + (8*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**4*pi**2*vT**2) - (4*g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**6*pi**2*vT) - (64*g1bar*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**6*pi**2*vT) + (g1bar*mt**2*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(6.*mZ**4*pi**2*vT) + (62*g1bar*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT) - (10*g1bar*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT) + (mt**2*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(24.*pi**2*vT**2) - (5*mW**2*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) - (8*mW**6*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(24.*pi**2*vT**2) - (5*mW**2*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) - (8*mW**6*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(8.*pi**2*vT**2) - (5*mW**2*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (8*mW**6*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(8.*pi**2*vT**2) - (5*mW**2*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (8*mW**6*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**6*einsum("prsT,tT,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("prsT,tT,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("prsT,tT,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("prsT,tT,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("prsT,tT,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("prsT,tT,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("prTt,sT,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("prTt,sT,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("prTt,sT,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("prTt,sT,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("prTt,sT,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("prTt,sT,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) - (mW**2*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("stTT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mW**2*Nc*einsum("stTT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("stTT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("stTT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("stTT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) - (mW**2*Nc*einsum("stTT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("stTT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("stTT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("stTT,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mW**2*Nc*einsum("stTT,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("stTT,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("stTT,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) - (mt**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(4.*pi**2*vT**2) + (2*mW**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) + (mt**2*mW**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(2.*mZ**2*pi**2*vT**2) - (2*mW**4*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) - (mt**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(4.*pi**2*vT**2) + (2*mW**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) + (mt**2*mW**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(2.*mZ**2*pi**2*vT**2) - (2*mW**4*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TTst,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mW**2*Nc*einsum("TTst,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TTst,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("TTst,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TTst,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) - (mW**2*Nc*einsum("TTst,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TTst,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("TTst,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) + (7*mt**8*mW**2*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (7*mt**6*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (17*mt**4*mW**6*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (25*mt**2*mW**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(18.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (2*mW**10*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(9.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (2*mt**8*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(3.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (mt**6*mW**6*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(6.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (7*mt**4*mW**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (25*mt**2*mW**10*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(18.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (2*mW**12*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (mt**10*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt**8*mW**2*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (9*mt**6*mW**4*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*mt**4*mW**6*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt**2*mW**8*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt**10*mW**2*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (7*mt**8*mW**4*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (31*mt**6*mW**6*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt**4*mW**8*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (4*mt**2*mW**10*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mW**12*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (13*g1bar*mt**8*mW**3*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (5*g1bar*mt**6*mW**5*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (9*g1bar*mt**4*mW**7*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) - (41*g1bar*mt**2*mW**9*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(36.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (2*g1bar*mW**11*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (3*mt**6*mW**3*C["W"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(2.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**3) - (3*mt**6*mW**5*C["W"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(2.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**3) - (mt**6*einsum("pr,sT,tT,TT",C["phil1"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("pr,sT,tT,TT",C["phil1"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("pr,sT,tT,TT",C["phil1"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*einsum("pr,sT,tT,TT",C["phil3"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (7*mt**4*mW**2*einsum("pr,sT,tT,TT",C["phil3"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("pr,sT,tT,TT",C["phil3"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*einsum("prTT,sT,tT,TT",C["lu"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("prTT,sT,tT,TT",C["lu"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("prTT,sT,tT,TT",C["lu"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*mW**2*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**4*mW**4*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**2*mW**6*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (7*mt**10*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (7*mt**8*mW**2*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (173*mt**6*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (45*mt**4*mW**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (109*mt**2*mW**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (2*mW**10*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (7*mt**10*mW**2*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (13*mt**8*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (109*mt**6*mW**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (25*mt**4*mW**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (59*mt**2*mW**10*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (2*mW**12*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (g1bar*mt*mW**4*einsum("sT,pr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt**2 - mW**2)*mZ**2*pi**2*vT) - (7*mt**7*mW**3*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (3*mt**5*mW**5*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (11*mt**3*mW**7*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt*mW**9*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*mt**7*mW**5*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (9*mt**5*mW**7*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (5*mt**3*mW**9*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt*mW**11*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt**6*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*mW**2*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**4*mW**4*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**2*mW**6*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (7*mt**10*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (7*mt**8*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (173*mt**6*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(96.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (45*mt**4*mW**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (109*mt**2*mW**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (2*mW**10*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (7*mt**10*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (13*mt**8*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (109*mt**6*mW**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (25*mt**4*mW**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (59*mt**2*mW**10*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (2*mW**12*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (g1bar*mt*mW**4*einsum("Tt,pr,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt**2 - mW**2)*mZ**2*pi**2*vT) - (7*mt**7*mW**3*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (3*mt**5*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (11*mt**3*mW**7*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt*mW**9*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*mt**7*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (9*mt**5*mW**7*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (5*mt**3*mW**9*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt*mW**11*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) - (mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*mZ**4*pi**2*vT**2) + (4*mW**6*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**2) - (4*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) + (mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*mZ**4*pi**2*vT**2) - (4*mW**6*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**2) + (4*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) + (mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*mZ**4*pi**2*vT**2) + (4*mW**6*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**2) - (4*mW**4*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (13*g1bar*mt*mW**4*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*mZ**4*pi**2*vT) + (13*g1bar*mt*mW**4*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*mZ**4*pi**2*vT) - (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*sqrt(2)*mH**2*mZ**4*pi**2*vT) - (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*sqrt(2)*mH**2*mZ**4*pi**2*vT) - (7*mt*mW**5*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*sqrt(2)*mZ**4*pi**2*vT**2) + (5*mt*mW**3*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*sqrt(2)*mZ**2*pi**2*vT**2) - (7*mt*mW**5*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*sqrt(2)*mZ**4*pi**2*vT**2) + (5*mt*mW**3*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*sqrt(2)*mZ**2*pi**2*vT**2) + (mt**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**4*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**2*mW**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(2.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (g1bar*mt**5*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uB"],kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (g1bar*mt**3*mW**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uB"],kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (g1bar*mt**5*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uBDag"],kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (g1bar*mt**3*mW**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uBDag"],kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (mt**5*mW**3*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**3*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**5*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**3*mW**7*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**5*mW**3*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**3*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**5*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**3*mW**7*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (25*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(72.*pi**2*vT**4) - (mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(4.*mH**2*pi**2*vT**4) + (14*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mZ**6*pi**2*vT**4) - (91*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(18.*mZ**4*pi**2*vT**4) + (mW**8*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**4*pi**2*vT**4) - (mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mZ**2*pi**2*vT**4) - (4*mW**10*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**6*pi**2*vT**2) + (4*mW**8*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**4*pi**2*vT**2) - (mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*pi**2*vT**2) + (2*mW**8*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**4*pi**2*vT**2) + (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(8.*mH**2*pi**2*vT**2) + (14*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mZ**6*pi**2*vT**2) - (49*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(18.*mZ**4*pi**2*vT**2) + (mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*mZ**4*pi**2*vT**2) - (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mZ**2*pi**2*vT**2) - (mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*pi**2*vT**2) + (4*mW**10*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**6*pi**2*vT**2) - (2*mW**8*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**4*pi**2*vT**2) + (22*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mZ**6*pi**2*vT) + (2*g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**6*pi**2*vT) - (13*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mZ**4*pi**2*vT) - (5*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(18.*mZ**2*pi**2*vT) + (24*mW**9*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mZ**6*pi**2*vT**3) - (26*mW**7*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mZ**4*pi**2*vT**3) + (2*mW**5*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mZ**2*pi**2*vT**3) + (7*mW**6*einsum("pr,st",C["phil1"],kd)*log(scale**2/mW**2))/(6.*mZ**4*pi**2*vT**2) - (7*mW**4*einsum("pr,st",C["phil1"],kd)*log(scale**2/mW**2))/(6.*mZ**2*pi**2*vT**2) - (11*mW**2*einsum("pr,st",C["phil3"],kd)*log(scale**2/mW**2))/(36.*pi**2*vT**2) + (7*mW**6*einsum("pr,st",C["phil3"],kd)*log(scale**2/mW**2))/(6.*mZ**4*pi**2*vT**2) - (29*mW**4*einsum("pr,st",C["phil3"],kd)*log(scale**2/mW**2))/(18.*mZ**2*pi**2*vT**2) + (7*mW**6*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mW**2))/(2.*mZ**4*pi**2*vT**2) - (7*mW**4*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mW**2))/(2.*mZ**2*pi**2*vT**2) + (37*mW**2*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mW**2))/(36.*pi**2*vT**2) + (7*mW**6*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mW**2))/(2.*mZ**4*pi**2*vT**2) - (95*mW**4*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mW**2))/(18.*mZ**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("prsT,tT,TT",C["lq1"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("prsT,tT,TT",C["lq3"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("prTt,sT,TT",C["lq1"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("prTt,sT,TT",C["lq3"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (37*mt**8*mW**2*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(72.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (11*mt**6*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(36.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (19*mt**4*mW**6*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(24.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (mt**2*mW**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(2.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (8*mt**8*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (19*mt**6*mW**6*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(18.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (5*mt**4*mW**8*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(12.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (mt**2*mW**10*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(2.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (3*mt**6*mW**4*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (3*mt**4*mW**6*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (3*mt**2*mW**8*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (4*mt**8*mW**4*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (103*mt**6*mW**6*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(144.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt**4*mW**8*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(6.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt**2*mW**10*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (55*g1bar*mt**8*mW**3*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(72.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) - (47*g1bar*mt**6*mW**5*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(36.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (5*g1bar*mt**4*mW**7*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(24.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (g1bar*mt**2*mW**9*C["phiWB"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) - (3*mt**6*mW**3*C["W"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(2.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**3) + (3*mt**6*mW**5*C["W"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(2.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**3) + (3*mt**2*mW**4*einsum("pr,sT,tT,TT",C["phil1"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**4*mW**2*einsum("pr,sT,tT,TT",C["phil3"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**2*mW**4*einsum("pr,sT,tT,TT",C["phil3"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**2*mW**4*einsum("prTT,sT,tT,TT",C["lu"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**2*mW**6*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (37*mt**8*mW**2*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(72.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (115*mt**6*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(288.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (29*mt**4*mW**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (13*mt**2*mW**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (8*mt**8*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (179*mt**6*mW**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(144.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt**4*mW**8*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(24.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (5*mt**2*mW**10*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (g1bar*mt*mW**4*einsum("sT,pr,tT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt**2 - mW**2)*mZ**2*pi**2*vT) + (7*mt**7*mW**3*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (3*mt**5*mW**5*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (11*mt**3*mW**7*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt*mW**9*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (5*mt**7*mW**5*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (9*mt**5*mW**7*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (5*mt**3*mW**9*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(3.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt*mW**11*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**2*mW**6*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (37*mt**8*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(72.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (115*mt**6*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(288.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (29*mt**4*mW**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (13*mt**2*mW**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (8*mt**8*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (179*mt**6*mW**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(144.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt**4*mW**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(24.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (5*mt**2*mW**10*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (g1bar*mt*mW**4*einsum("Tt,pr,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt**2 - mW**2)*mZ**2*pi**2*vT) + (7*mt**7*mW**3*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (3*mt**5*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (11*mt**3*mW**7*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt*mW**9*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (5*mt**7*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (9*mt**5*mW**7*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (5*mt**3*mW**9*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(3.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt*mW**11*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (3*mt**2*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (g1bar*mt**5*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uB"],kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (g1bar*mt**3*mW**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uB"],kdt)*log(scale**2/mW**2))/(8.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (g1bar*mt**5*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uBDag"],kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (g1bar*mt**3*mW**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uBDag"],kdt)*log(scale**2/mW**2))/(8.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (mt**5*mW**3*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**3*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**5*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mt**3*mW**7*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mt**5*mW**3*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**3*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**5*mW**5*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mt**3*mW**7*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mW**4*einsum("prst",C["lq1"])*log(scale**2/mZ**2))/(2.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("prst",C["lq1"])*log(scale**2/mZ**2))/(8.*pi**2*vT**2) - (mW**4*einsum("prst",C["lq3"])*log(scale**2/mZ**2))/(2.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("prst",C["lq3"])*log(scale**2/mZ**2))/(8.*pi**2*vT**2) + (17*mH**2*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(162.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (71*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(108.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (74*mH**2*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**4) - (10*mH**2*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) - (74*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) + (5*mH**2*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(54.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) + (10*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) - (17*mW**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(162.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (mW**4*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (3*mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mZ**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (3*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (20*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (3*mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (mH**2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (20*mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (3*mW**6*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mH**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (3*mW**4*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mZ**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mW**2*mZ**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mZ**8*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (3*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**4*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mZ**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (17*mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(324.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (3*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (74*mH**2*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (5*mH**2*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (74*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (5*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (17*mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(324.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**4*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (2*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (20*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (3*mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (mH**2*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (14*mW**4*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (3*mW**6*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mW**2*mZ**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (2*mW**4*mZ**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mW**2*mZ**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (85*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(324.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (368*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (148*g1bar*mH**4*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT) - (98*g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) - (296*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(162.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (635*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(162.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (148*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**2*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (29*g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(324.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (3*g1bar*mW**5*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mW*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mW*mZ**6*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (mW**2*einsum("pr,st",C["phil1"],kd)*log(scale**2/mZ**2))/(18.*pi**2*vT**2) + (5*mW**6*einsum("pr,st",C["phil1"],kd)*log(scale**2/mZ**2))/(9.*mZ**4*pi**2*vT**2) - (mW**4*einsum("pr,st",C["phil1"],kd)*log(scale**2/mZ**2))/(2.*mZ**2*pi**2*vT**2) - (mW**2*einsum("pr,st",C["phil3"],kd)*log(scale**2/mZ**2))/(18.*pi**2*vT**2) + (5*mW**6*einsum("pr,st",C["phil3"],kd)*log(scale**2/mZ**2))/(9.*mZ**4*pi**2*vT**2) - (mW**4*einsum("pr,st",C["phil3"],kd)*log(scale**2/mZ**2))/(2.*mZ**2*pi**2*vT**2) + (25*mW**2*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mZ**2))/(54.*pi**2*vT**2) + (29*mW**6*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mZ**2))/(27.*mZ**4*pi**2*vT**2) - (83*mW**4*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mZ**2))/(54.*mZ**2*pi**2*vT**2) + (25*mW**2*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mZ**2))/(54.*pi**2*vT**2) + (29*mW**6*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mZ**2))/(27.*mZ**4*pi**2*vT**2) - (83*mW**4*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mZ**2))/(54.*mZ**2*pi**2*vT**2) - (g1bar*mW**6*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*sqrt(2))/(27.*mt*mZ**4*pi**2*vT) + (g1bar*mW**4*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*sqrt(2))/(27.*mt*mZ**2*pi**2*vT) - (g1bar*mW**6*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*sqrt(2))/(27.*mt*mZ**4*pi**2*vT) + (g1bar*mW**4*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*sqrt(2))/(27.*mt*mZ**2*pi**2*vT) + (2*mW**3*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(27.*mt*pi**2*vT**2) + (2*mW**7*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(27.*mt*mZ**4*pi**2*vT**2) - (4*mW**5*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(27.*mt*mZ**2*pi**2*vT**2) + (2*mW**3*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(27.*mt*pi**2*vT**2) + (2*mW**7*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(27.*mt*mZ**4*pi**2*vT**2) - (4*mW**5*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(27.*mt*mZ**2*pi**2*vT**2) - (4*g1bar*mt*mW**6*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*mZ**6*pi**2*vT) - (4*g1bar*mt*mW**6*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*mZ**6*pi**2*vT) + (8*mt*mW**7*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*mZ**6*pi**2*vT**2) + (8*mt*mW**7*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*mZ**6*pi**2*vT**2))
    c['VeeLL'] = ((15*mW**2*einsum("prst",C["ll"]))/(16.*pi**2*vT**2) - (bEvan*mW**2*einsum("prst",C["ll"]))/(4.*pi**2*vT**2) - (15*mW**4*einsum("prst",C["ll"]))/(16.*mZ**2*pi**2*vT**2) + (bEvan*mW**4*einsum("prst",C["ll"]))/(4.*mZ**2*pi**2*vT**2) - (15*mZ**2*einsum("prst",C["ll"]))/(64.*pi**2*vT**2) + (bEvan*mZ**2*einsum("prst",C["ll"]))/(16.*pi**2*vT**2) + (15*mW**2*einsum("ptsr",C["ll"]))/(16.*pi**2*vT**2) - (bEvan*mW**2*einsum("ptsr",C["ll"]))/(4.*pi**2*vT**2) - (15*mW**4*einsum("ptsr",C["ll"]))/(16.*mZ**2*pi**2*vT**2) + (bEvan*mW**4*einsum("ptsr",C["ll"]))/(4.*mZ**2*pi**2*vT**2) - (15*mZ**2*einsum("ptsr",C["ll"]))/(64.*pi**2*vT**2) + (bEvan*mZ**2*einsum("ptsr",C["ll"]))/(16.*pi**2*vT**2) + (15*mW**2*einsum("srpt",C["ll"]))/(16.*pi**2*vT**2) - (bEvan*mW**2*einsum("srpt",C["ll"]))/(4.*pi**2*vT**2) - (15*mW**4*einsum("srpt",C["ll"]))/(16.*mZ**2*pi**2*vT**2) + (bEvan*mW**4*einsum("srpt",C["ll"]))/(4.*mZ**2*pi**2*vT**2) - (15*mZ**2*einsum("srpt",C["ll"]))/(64.*pi**2*vT**2) + (bEvan*mZ**2*einsum("srpt",C["ll"]))/(16.*pi**2*vT**2) + (15*mW**2*einsum("stpr",C["ll"]))/(16.*pi**2*vT**2) - (bEvan*mW**2*einsum("stpr",C["ll"]))/(4.*pi**2*vT**2) - (15*mW**4*einsum("stpr",C["ll"]))/(16.*mZ**2*pi**2*vT**2) + (bEvan*mW**4*einsum("stpr",C["ll"]))/(4.*mZ**2*pi**2*vT**2) - (15*mZ**2*einsum("stpr",C["ll"]))/(64.*pi**2*vT**2) + (bEvan*mZ**2*einsum("stpr",C["ll"]))/(16.*pi**2*vT**2) + (7*mH**2*einsum("pr,st",kd,kd))/(128.*pi**2*vT**4) - (241*mW**2*einsum("pr,st",kd,kd))/(240.*pi**2*vT**4) + (bEvan*mW**2*einsum("pr,st",kd,kd))/(4.*pi**2*vT**4) + (3*mW**4*einsum("pr,st",kd,kd))/(16.*mH**2*pi**2*vT**4) + (40*mW**8*einsum("pr,st",kd,kd))/(9.*mZ**6*pi**2*vT**4) - (bEvan*mW**8*einsum("pr,st",kd,kd))/(mZ**6*pi**2*vT**4) + (7*mH**2*mW**4*einsum("pr,st",kd,kd))/(32.*mZ**4*pi**2*vT**4) - (373*mW**6*einsum("pr,st",kd,kd))/(45.*mZ**4*pi**2*vT**4) + (2*bEvan*mW**6*einsum("pr,st",kd,kd))/(mZ**4*pi**2*vT**4) + (mW**8*einsum("pr,st",kd,kd))/(4.*mH**2*mZ**4*pi**2*vT**4) - (7*mH**2*mW**2*einsum("pr,st",kd,kd))/(32.*mZ**2*pi**2*vT**4) + (6937*mW**4*einsum("pr,st",kd,kd))/(1440.*mZ**2*pi**2*vT**4) - (5*bEvan*mW**4*einsum("pr,st",kd,kd))/(4.*mZ**2*pi**2*vT**4) - (mW**6*einsum("pr,st",kd,kd))/(4.*mH**2*mZ**2*pi**2*vT**4) + (mZ**2*einsum("pr,st",kd,kd))/(128.*pi**2*vT**4) - (mW**2*mZ**2*einsum("pr,st",kd,kd))/(8.*mH**2*pi**2*vT**4) + (mZ**4*einsum("pr,st",kd,kd))/(32.*mH**2*pi**2*vT**4) - (mt**4*Nc*einsum("pr,st",kd,kd))/(8.*mH**2*pi**2*vT**4) - (4*mW**4*Nc*einsum("pr,st",kd,kd))/(135.*mt**2*pi**2*vT**4) - (mt**4*mW**4*Nc*einsum("pr,st",kd,kd))/(2.*mH**2*mZ**4*pi**2*vT**4) - (4*mW**8*Nc*einsum("pr,st",kd,kd))/(135.*mt**2*mZ**4*pi**2*vT**4) + (mt**4*mW**2*Nc*einsum("pr,st",kd,kd))/(2.*mH**2*mZ**2*pi**2*vT**4) + (8*mW**6*Nc*einsum("pr,st",kd,kd))/(135.*mt**2*mZ**2*pi**2*vT**4) - (3*C["phi"]*einsum("pr,st",kd,kd))/(32.*pi**2) - (3*mW**4*C["phi"]*einsum("pr,st",kd,kd))/(8.*mZ**4*pi**2) + (3*mW**2*C["phi"]*einsum("pr,st",kd,kd))/(8.*mZ**2*pi**2) + (3*mH**2*mW**2*C["phiB"]*einsum("pr,st",kd,kd))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (19*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (5*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(2.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (mW**10*C["phiB"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (3*mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (3*mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (3*mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(2.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (mW**10*C["phiB"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**2*C["phiB"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (9*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(8.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (2*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (3*mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(2.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (15*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (5*mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (9*mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(16.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mZ**6*C["phiB"]*einsum("pr,st",kd,kd))/(16.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (3*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (2*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (3*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (11*mH**2*C["phiBox"]*einsum("pr,st",kd,kd))/(64.*pi**2*vT**2) + (5*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(16.*pi**2*vT**2) + (3*mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(8.*mH**2*pi**2*vT**2) + (11*mH**2*mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(16.*mZ**4*pi**2*vT**2) + (mW**8*C["phiBox"]*einsum("pr,st",kd,kd))/(2.*mH**2*mZ**4*pi**2*vT**2) - (11*mH**2*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(16.*mZ**2*pi**2*vT**2) - (5*mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(16.*mZ**2*pi**2*vT**2) - (mW**6*C["phiBox"]*einsum("pr,st",kd,kd))/(2.*mH**2*mZ**2*pi**2*vT**2) - (5*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(64.*pi**2*vT**2) - (mW**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(4.*mH**2*pi**2*vT**2) + (mZ**4*C["phiBox"]*einsum("pr,st",kd,kd))/(16.*mH**2*pi**2*vT**2) - (mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(4.*mH**2*pi**2*vT**2) - (mt**4*mW**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(mH**2*mZ**4*pi**2*vT**2) + (mt**4*mW**2*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(mH**2*mZ**2*pi**2*vT**2) - (mH**2*C["phiD"]*einsum("pr,st",kd,kd))/(16.*pi**2*vT**2) + (395*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(576.*pi**2*vT**2) - (bEvan*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(8.*pi**2*vT**2) + (3*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(32.*mH**2*pi**2*vT**2) + (40*mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(9.*mZ**6*pi**2*vT**2) - (bEvan*mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(mZ**6*pi**2*vT**2) - (mH**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(32.*mZ**4*pi**2*vT**2) - (707*mW**6*C["phiD"]*einsum("pr,st",kd,kd))/(180.*mZ**4*pi**2*vT**2) + (bEvan*mW**6*C["phiD"]*einsum("pr,st",kd,kd))/(mZ**4*pi**2*vT**2) + (mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(8.*mH**2*mZ**4*pi**2*vT**2) + (9*mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(64.*mZ**2*pi**2*vT**2) - (599*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(1440.*mZ**2*pi**2*vT**2) - (3*mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(64.*pi**2*vT**2) - (mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(16.*mH**2*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(16.*mH**2*pi**2*vT**2) - (mt**4*mW**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(4.*mH**2*mZ**4*pi**2*vT**2) - (4*mW**8*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(135.*mt**2*mZ**4*pi**2*vT**2) + (4*mW**6*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(135.*mt**2*mZ**2*pi**2*vT**2) - (3*mH**2*mW**2*C["phiW"]*einsum("pr,st",kd,kd))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (2*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/((mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(2.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (mW**10*C["phiW"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (3*mH**4*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (3*mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mW**8*C["phiW"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mW**10*C["phiW"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**2*C["phiW"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (9*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(8.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (3*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(2.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mW**8*C["phiW"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (11*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (7*mW**4*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(8.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (5*mW**2*mZ**4*C["phiW"]*einsum("pr,st",kd,kd))/(16.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (2*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (3*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (2*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (3*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (3*g1bar*mH**2*mW*C["phiWB"]*einsum("pr,st",kd,kd))/(32.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (5717*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(1440.*(mH - mZ)*(mH + mZ)*pi**2*vT) + (3*bEvan*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (3*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(8.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (169*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) - (2*bEvan*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd))/(2.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) - (g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(32.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (4153*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(360.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (5*bEvan*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(2.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (347*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(36.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (2*bEvan*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd))/(2.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (3*g1bar*mH**4*mW*C["phiWB"]*einsum("pr,st",kd,kd))/(64.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (2521*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(720.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (3*bEvan*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (536*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(45.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (5*bEvan*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(2.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(4.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (15*g1bar*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(64.*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) - (g1bar*mW*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd))/(32.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) - (8*g1bar*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(135.*mt**2*(mH - mZ)*(mH + mZ)*pi**2*vT) - (g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(2.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (8*g1bar*mH**2*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(135.*mt**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(2.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (8*g1bar*mH**2*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(135.*mt**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (8*g1bar*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(135.*mt**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (3*mW**3*C["W"]*einsum("pr,st",kd,kd))/(4.*pi**2*vT**3) + (3*mW**7*C["W"]*einsum("pr,st",kd,kd))/(2.*mZ**4*pi**2*vT**3) - (9*mW**5*C["W"]*einsum("pr,st",kd,kd))/(4.*mZ**2*pi**2*vT**3) + (101*mW**2*einsum("pr,st",C["phil1"],kd))/(72.*pi**2*vT**2) - (bEvan*mW**2*einsum("pr,st",C["phil1"],kd))/(4.*pi**2*vT**2) + (181*mW**6*einsum("pr,st",C["phil1"],kd))/(72.*mZ**4*pi**2*vT**2) - (bEvan*mW**6*einsum("pr,st",C["phil1"],kd))/(2.*mZ**4*pi**2*vT**2) - (179*mW**4*einsum("pr,st",C["phil1"],kd))/(48.*mZ**2*pi**2*vT**2) + (3*bEvan*mW**4*einsum("pr,st",C["phil1"],kd))/(4.*mZ**2*pi**2*vT**2) - (3*mZ**2*einsum("pr,st",C["phil1"],kd))/(32.*pi**2*vT**2) + (313*mW**2*einsum("pr,st",C["phil3"],kd))/(288.*pi**2*vT**2) - (bEvan*mW**2*einsum("pr,st",C["phil3"],kd))/(4.*pi**2*vT**2) + (181*mW**6*einsum("pr,st",C["phil3"],kd))/(72.*mZ**4*pi**2*vT**2) - (bEvan*mW**6*einsum("pr,st",C["phil3"],kd))/(2.*mZ**4*pi**2*vT**2) - (257*mW**4*einsum("pr,st",C["phil3"],kd))/(72.*mZ**2*pi**2*vT**2) + (3*bEvan*mW**4*einsum("pr,st",C["phil3"],kd))/(4.*mZ**2*pi**2*vT**2) - (3*mZ**2*einsum("pr,st",C["phil3"],kd))/(32.*pi**2*vT**2) + (7*mH**2*einsum("pt,sr",kd,kd))/(128.*pi**2*vT**4) - (241*mW**2*einsum("pt,sr",kd,kd))/(240.*pi**2*vT**4) + (bEvan*mW**2*einsum("pt,sr",kd,kd))/(4.*pi**2*vT**4) + (3*mW**4*einsum("pt,sr",kd,kd))/(16.*mH**2*pi**2*vT**4) + (40*mW**8*einsum("pt,sr",kd,kd))/(9.*mZ**6*pi**2*vT**4) - (bEvan*mW**8*einsum("pt,sr",kd,kd))/(mZ**6*pi**2*vT**4) + (7*mH**2*mW**4*einsum("pt,sr",kd,kd))/(32.*mZ**4*pi**2*vT**4) - (373*mW**6*einsum("pt,sr",kd,kd))/(45.*mZ**4*pi**2*vT**4) + (2*bEvan*mW**6*einsum("pt,sr",kd,kd))/(mZ**4*pi**2*vT**4) + (mW**8*einsum("pt,sr",kd,kd))/(4.*mH**2*mZ**4*pi**2*vT**4) - (7*mH**2*mW**2*einsum("pt,sr",kd,kd))/(32.*mZ**2*pi**2*vT**4) + (6937*mW**4*einsum("pt,sr",kd,kd))/(1440.*mZ**2*pi**2*vT**4) - (5*bEvan*mW**4*einsum("pt,sr",kd,kd))/(4.*mZ**2*pi**2*vT**4) - (mW**6*einsum("pt,sr",kd,kd))/(4.*mH**2*mZ**2*pi**2*vT**4) + (mZ**2*einsum("pt,sr",kd,kd))/(128.*pi**2*vT**4) - (mW**2*mZ**2*einsum("pt,sr",kd,kd))/(8.*mH**2*pi**2*vT**4) + (mZ**4*einsum("pt,sr",kd,kd))/(32.*mH**2*pi**2*vT**4) - (mt**4*Nc*einsum("pt,sr",kd,kd))/(8.*mH**2*pi**2*vT**4) - (4*mW**4*Nc*einsum("pt,sr",kd,kd))/(135.*mt**2*pi**2*vT**4) - (mt**4*mW**4*Nc*einsum("pt,sr",kd,kd))/(2.*mH**2*mZ**4*pi**2*vT**4) - (4*mW**8*Nc*einsum("pt,sr",kd,kd))/(135.*mt**2*mZ**4*pi**2*vT**4) + (mt**4*mW**2*Nc*einsum("pt,sr",kd,kd))/(2.*mH**2*mZ**2*pi**2*vT**4) + (8*mW**6*Nc*einsum("pt,sr",kd,kd))/(135.*mt**2*mZ**2*pi**2*vT**4) - (3*C["phi"]*einsum("pt,sr",kd,kd))/(32.*pi**2) - (3*mW**4*C["phi"]*einsum("pt,sr",kd,kd))/(8.*mZ**4*pi**2) + (3*mW**2*C["phi"]*einsum("pt,sr",kd,kd))/(8.*mZ**2*pi**2) + (3*mH**2*mW**2*C["phiB"]*einsum("pt,sr",kd,kd))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (19*mW**4*C["phiB"]*einsum("pt,sr",kd,kd))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (5*mW**6*C["phiB"]*einsum("pt,sr",kd,kd))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**6*C["phiB"]*einsum("pt,sr",kd,kd))/(2.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (mW**10*C["phiB"]*einsum("pt,sr",kd,kd))/((mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (3*mH**4*mW**4*C["phiB"]*einsum("pt,sr",kd,kd))/(4.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (3*mH**2*mW**6*C["phiB"]*einsum("pt,sr",kd,kd))/(4.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (3*mW**8*C["phiB"]*einsum("pt,sr",kd,kd))/(2.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (mW**10*C["phiB"]*einsum("pt,sr",kd,kd))/(mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**2*C["phiB"]*einsum("pt,sr",kd,kd))/(4.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (9*mH**2*mW**4*C["phiB"]*einsum("pt,sr",kd,kd))/(8.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (2*mW**6*C["phiB"]*einsum("pt,sr",kd,kd))/((mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (3*mW**8*C["phiB"]*einsum("pt,sr",kd,kd))/(2.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (15*mW**2*mZ**2*C["phiB"]*einsum("pt,sr",kd,kd))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (5*mW**4*mZ**2*C["phiB"]*einsum("pt,sr",kd,kd))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mZ**4*C["phiB"]*einsum("pt,sr",kd,kd))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (9*mW**2*mZ**4*C["phiB"]*einsum("pt,sr",kd,kd))/(16.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mZ**6*C["phiB"]*einsum("pt,sr",kd,kd))/(16.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mt**4*mW**2*Nc*C["phiB"]*einsum("pt,sr",kd,kd))/(mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mt**4*mW**6*Nc*C["phiB"]*einsum("pt,sr",kd,kd))/((mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (3*mt**4*mW**4*Nc*C["phiB"]*einsum("pt,sr",kd,kd))/((mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (2*mt**4*mW**6*Nc*C["phiB"]*einsum("pt,sr",kd,kd))/(mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (mt**4*mW**2*Nc*C["phiB"]*einsum("pt,sr",kd,kd))/((mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (3*mt**4*mW**4*Nc*C["phiB"]*einsum("pt,sr",kd,kd))/(mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (11*mH**2*C["phiBox"]*einsum("pt,sr",kd,kd))/(64.*pi**2*vT**2) + (5*mW**2*C["phiBox"]*einsum("pt,sr",kd,kd))/(16.*pi**2*vT**2) + (3*mW**4*C["phiBox"]*einsum("pt,sr",kd,kd))/(8.*mH**2*pi**2*vT**2) + (11*mH**2*mW**4*C["phiBox"]*einsum("pt,sr",kd,kd))/(16.*mZ**4*pi**2*vT**2) + (mW**8*C["phiBox"]*einsum("pt,sr",kd,kd))/(2.*mH**2*mZ**4*pi**2*vT**2) - (11*mH**2*mW**2*C["phiBox"]*einsum("pt,sr",kd,kd))/(16.*mZ**2*pi**2*vT**2) - (5*mW**4*C["phiBox"]*einsum("pt,sr",kd,kd))/(16.*mZ**2*pi**2*vT**2) - (mW**6*C["phiBox"]*einsum("pt,sr",kd,kd))/(2.*mH**2*mZ**2*pi**2*vT**2) - (5*mZ**2*C["phiBox"]*einsum("pt,sr",kd,kd))/(64.*pi**2*vT**2) - (mW**2*mZ**2*C["phiBox"]*einsum("pt,sr",kd,kd))/(4.*mH**2*pi**2*vT**2) + (mZ**4*C["phiBox"]*einsum("pt,sr",kd,kd))/(16.*mH**2*pi**2*vT**2) - (mt**4*Nc*C["phiBox"]*einsum("pt,sr",kd,kd))/(4.*mH**2*pi**2*vT**2) - (mt**4*mW**4*Nc*C["phiBox"]*einsum("pt,sr",kd,kd))/(mH**2*mZ**4*pi**2*vT**2) + (mt**4*mW**2*Nc*C["phiBox"]*einsum("pt,sr",kd,kd))/(mH**2*mZ**2*pi**2*vT**2) - (mH**2*C["phiD"]*einsum("pt,sr",kd,kd))/(16.*pi**2*vT**2) + (395*mW**2*C["phiD"]*einsum("pt,sr",kd,kd))/(576.*pi**2*vT**2) - (bEvan*mW**2*C["phiD"]*einsum("pt,sr",kd,kd))/(8.*pi**2*vT**2) + (3*mW**4*C["phiD"]*einsum("pt,sr",kd,kd))/(32.*mH**2*pi**2*vT**2) + (40*mW**8*C["phiD"]*einsum("pt,sr",kd,kd))/(9.*mZ**6*pi**2*vT**2) - (bEvan*mW**8*C["phiD"]*einsum("pt,sr",kd,kd))/(mZ**6*pi**2*vT**2) - (mH**2*mW**4*C["phiD"]*einsum("pt,sr",kd,kd))/(32.*mZ**4*pi**2*vT**2) - (707*mW**6*C["phiD"]*einsum("pt,sr",kd,kd))/(180.*mZ**4*pi**2*vT**2) + (bEvan*mW**6*C["phiD"]*einsum("pt,sr",kd,kd))/(mZ**4*pi**2*vT**2) + (mW**8*C["phiD"]*einsum("pt,sr",kd,kd))/(8.*mH**2*mZ**4*pi**2*vT**2) + (9*mH**2*mW**2*C["phiD"]*einsum("pt,sr",kd,kd))/(64.*mZ**2*pi**2*vT**2) - (599*mW**4*C["phiD"]*einsum("pt,sr",kd,kd))/(1440.*mZ**2*pi**2*vT**2) - (3*mZ**2*C["phiD"]*einsum("pt,sr",kd,kd))/(64.*pi**2*vT**2) - (mW**2*mZ**2*C["phiD"]*einsum("pt,sr",kd,kd))/(16.*mH**2*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pt,sr",kd,kd))/(16.*mH**2*pi**2*vT**2) - (mt**4*mW**4*Nc*C["phiD"]*einsum("pt,sr",kd,kd))/(4.*mH**2*mZ**4*pi**2*vT**2) - (4*mW**8*Nc*C["phiD"]*einsum("pt,sr",kd,kd))/(135.*mt**2*mZ**4*pi**2*vT**2) + (4*mW**6*Nc*C["phiD"]*einsum("pt,sr",kd,kd))/(135.*mt**2*mZ**2*pi**2*vT**2) - (3*mH**2*mW**2*C["phiW"]*einsum("pt,sr",kd,kd))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (2*mW**4*C["phiW"]*einsum("pt,sr",kd,kd))/((mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mW**6*C["phiW"]*einsum("pt,sr",kd,kd))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**6*C["phiW"]*einsum("pt,sr",kd,kd))/(2.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (mW**10*C["phiW"]*einsum("pt,sr",kd,kd))/((mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (3*mH**4*mW**4*C["phiW"]*einsum("pt,sr",kd,kd))/(4.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (3*mH**2*mW**6*C["phiW"]*einsum("pt,sr",kd,kd))/(4.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mW**8*C["phiW"]*einsum("pt,sr",kd,kd))/((mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mW**10*C["phiW"]*einsum("pt,sr",kd,kd))/(mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**2*C["phiW"]*einsum("pt,sr",kd,kd))/(4.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (9*mH**2*mW**4*C["phiW"]*einsum("pt,sr",kd,kd))/(8.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (3*mW**6*C["phiW"]*einsum("pt,sr",kd,kd))/(2.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mW**8*C["phiW"]*einsum("pt,sr",kd,kd))/(mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (11*mW**2*mZ**2*C["phiW"]*einsum("pt,sr",kd,kd))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (7*mW**4*mZ**2*C["phiW"]*einsum("pt,sr",kd,kd))/(8.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (5*mW**2*mZ**4*C["phiW"]*einsum("pt,sr",kd,kd))/(16.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mt**4*mW**2*Nc*C["phiW"]*einsum("pt,sr",kd,kd))/(mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (2*mt**4*mW**6*Nc*C["phiW"]*einsum("pt,sr",kd,kd))/((mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (3*mt**4*mW**4*Nc*C["phiW"]*einsum("pt,sr",kd,kd))/((mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (2*mt**4*mW**6*Nc*C["phiW"]*einsum("pt,sr",kd,kd))/(mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mt**4*mW**2*Nc*C["phiW"]*einsum("pt,sr",kd,kd))/((mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (3*mt**4*mW**4*Nc*C["phiW"]*einsum("pt,sr",kd,kd))/(mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (3*g1bar*mH**2*mW*C["phiWB"]*einsum("pt,sr",kd,kd))/(32.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (5717*g1bar*mW**3*C["phiWB"]*einsum("pt,sr",kd,kd))/(1440.*(mH - mZ)*(mH + mZ)*pi**2*vT) + (3*bEvan*g1bar*mW**3*C["phiWB"]*einsum("pt,sr",kd,kd))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (3*g1bar*mW**5*C["phiWB"]*einsum("pt,sr",kd,kd))/(8.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mH**4*mW**5*C["phiWB"]*einsum("pt,sr",kd,kd))/(4.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (169*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pt,sr",kd,kd))/(18.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) - (2*bEvan*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pt,sr",kd,kd))/((mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (g1bar*mW**9*C["phiWB"]*einsum("pt,sr",kd,kd))/(2.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) - (g1bar*mH**4*mW**3*C["phiWB"]*einsum("pt,sr",kd,kd))/(32.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (4153*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pt,sr",kd,kd))/(360.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (5*bEvan*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pt,sr",kd,kd))/(2.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (347*g1bar*mW**7*C["phiWB"]*einsum("pt,sr",kd,kd))/(36.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (2*bEvan*g1bar*mW**7*C["phiWB"]*einsum("pt,sr",kd,kd))/((mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (g1bar*mW**9*C["phiWB"]*einsum("pt,sr",kd,kd))/(2.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (3*g1bar*mH**4*mW*C["phiWB"]*einsum("pt,sr",kd,kd))/(64.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (2521*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pt,sr",kd,kd))/(720.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (3*bEvan*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pt,sr",kd,kd))/(4.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (536*g1bar*mW**5*C["phiWB"]*einsum("pt,sr",kd,kd))/(45.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (5*bEvan*g1bar*mW**5*C["phiWB"]*einsum("pt,sr",kd,kd))/(2.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (g1bar*mW**7*C["phiWB"]*einsum("pt,sr",kd,kd))/(4.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (15*g1bar*mW*mZ**2*C["phiWB"]*einsum("pt,sr",kd,kd))/(64.*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pt,sr",kd,kd))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) - (g1bar*mW*mZ**4*C["phiWB"]*einsum("pt,sr",kd,kd))/(32.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) - (8*g1bar*mW**5*Nc*C["phiWB"]*einsum("pt,sr",kd,kd))/(135.*mt**2*(mH - mZ)*(mH + mZ)*pi**2*vT) - (g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pt,sr",kd,kd))/((mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pt,sr",kd,kd))/(2.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pt,sr",kd,kd))/(mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (8*g1bar*mH**2*mW**7*Nc*C["phiWB"]*einsum("pt,sr",kd,kd))/(135.*mt**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pt,sr",kd,kd))/(2.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (8*g1bar*mH**2*mW**5*Nc*C["phiWB"]*einsum("pt,sr",kd,kd))/(135.*mt**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (8*g1bar*mW**7*Nc*C["phiWB"]*einsum("pt,sr",kd,kd))/(135.*mt**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (3*mW**3*C["W"]*einsum("pt,sr",kd,kd))/(4.*pi**2*vT**3) + (3*mW**7*C["W"]*einsum("pt,sr",kd,kd))/(2.*mZ**4*pi**2*vT**3) - (9*mW**5*C["W"]*einsum("pt,sr",kd,kd))/(4.*mZ**2*pi**2*vT**3) + (101*mW**2*einsum("pt,sr",C["phil1"],kd))/(72.*pi**2*vT**2) - (bEvan*mW**2*einsum("pt,sr",C["phil1"],kd))/(4.*pi**2*vT**2) + (181*mW**6*einsum("pt,sr",C["phil1"],kd))/(72.*mZ**4*pi**2*vT**2) - (bEvan*mW**6*einsum("pt,sr",C["phil1"],kd))/(2.*mZ**4*pi**2*vT**2) - (179*mW**4*einsum("pt,sr",C["phil1"],kd))/(48.*mZ**2*pi**2*vT**2) + (3*bEvan*mW**4*einsum("pt,sr",C["phil1"],kd))/(4.*mZ**2*pi**2*vT**2) - (3*mZ**2*einsum("pt,sr",C["phil1"],kd))/(32.*pi**2*vT**2) + (313*mW**2*einsum("pt,sr",C["phil3"],kd))/(288.*pi**2*vT**2) - (bEvan*mW**2*einsum("pt,sr",C["phil3"],kd))/(4.*pi**2*vT**2) + (181*mW**6*einsum("pt,sr",C["phil3"],kd))/(72.*mZ**4*pi**2*vT**2) - (bEvan*mW**6*einsum("pt,sr",C["phil3"],kd))/(2.*mZ**4*pi**2*vT**2) - (257*mW**4*einsum("pt,sr",C["phil3"],kd))/(72.*mZ**2*pi**2*vT**2) + (3*bEvan*mW**4*einsum("pt,sr",C["phil3"],kd))/(4.*mZ**2*pi**2*vT**2) - (3*mZ**2*einsum("pt,sr",C["phil3"],kd))/(32.*pi**2*vT**2) + (101*mW**2*einsum("sr,pt",C["phil1"],kd))/(72.*pi**2*vT**2) - (bEvan*mW**2*einsum("sr,pt",C["phil1"],kd))/(4.*pi**2*vT**2) + (181*mW**6*einsum("sr,pt",C["phil1"],kd))/(72.*mZ**4*pi**2*vT**2) - (bEvan*mW**6*einsum("sr,pt",C["phil1"],kd))/(2.*mZ**4*pi**2*vT**2) - (179*mW**4*einsum("sr,pt",C["phil1"],kd))/(48.*mZ**2*pi**2*vT**2) + (3*bEvan*mW**4*einsum("sr,pt",C["phil1"],kd))/(4.*mZ**2*pi**2*vT**2) - (3*mZ**2*einsum("sr,pt",C["phil1"],kd))/(32.*pi**2*vT**2) + (313*mW**2*einsum("sr,pt",C["phil3"],kd))/(288.*pi**2*vT**2) - (bEvan*mW**2*einsum("sr,pt",C["phil3"],kd))/(4.*pi**2*vT**2) + (181*mW**6*einsum("sr,pt",C["phil3"],kd))/(72.*mZ**4*pi**2*vT**2) - (bEvan*mW**6*einsum("sr,pt",C["phil3"],kd))/(2.*mZ**4*pi**2*vT**2) - (257*mW**4*einsum("sr,pt",C["phil3"],kd))/(72.*mZ**2*pi**2*vT**2) + (3*bEvan*mW**4*einsum("sr,pt",C["phil3"],kd))/(4.*mZ**2*pi**2*vT**2) - (3*mZ**2*einsum("sr,pt",C["phil3"],kd))/(32.*pi**2*vT**2) + (101*mW**2*einsum("st,pr",C["phil1"],kd))/(72.*pi**2*vT**2) - (bEvan*mW**2*einsum("st,pr",C["phil1"],kd))/(4.*pi**2*vT**2) + (181*mW**6*einsum("st,pr",C["phil1"],kd))/(72.*mZ**4*pi**2*vT**2) - (bEvan*mW**6*einsum("st,pr",C["phil1"],kd))/(2.*mZ**4*pi**2*vT**2) - (179*mW**4*einsum("st,pr",C["phil1"],kd))/(48.*mZ**2*pi**2*vT**2) + (3*bEvan*mW**4*einsum("st,pr",C["phil1"],kd))/(4.*mZ**2*pi**2*vT**2) - (3*mZ**2*einsum("st,pr",C["phil1"],kd))/(32.*pi**2*vT**2) + (313*mW**2*einsum("st,pr",C["phil3"],kd))/(288.*pi**2*vT**2) - (bEvan*mW**2*einsum("st,pr",C["phil3"],kd))/(4.*pi**2*vT**2) + (181*mW**6*einsum("st,pr",C["phil3"],kd))/(72.*mZ**4*pi**2*vT**2) - (bEvan*mW**6*einsum("st,pr",C["phil3"],kd))/(2.*mZ**4*pi**2*vT**2) - (257*mW**4*einsum("st,pr",C["phil3"],kd))/(72.*mZ**2*pi**2*vT**2) + (3*bEvan*mW**4*einsum("st,pr",C["phil3"],kd))/(4.*mZ**2*pi**2*vT**2) - (3*mZ**2*einsum("st,pr",C["phil3"],kd))/(32.*pi**2*vT**2) - (g1bar*mW**6*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt))/(18.*sqrt(2)*mt*mZ**4*pi**2*vT) + (g1bar*mW**4*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt))/(18.*sqrt(2)*mt*mZ**2*pi**2*vT) - (g1bar*mW**6*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt))/(18.*sqrt(2)*mt*mZ**4*pi**2*vT) + (g1bar*mW**4*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt))/(18.*sqrt(2)*mt*mZ**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(16.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(4.*sqrt(2)*mH**2*mZ**4*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(4.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(16.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(4.*sqrt(2)*mH**2*mZ**4*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(4.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (mW**3*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt))/(9.*sqrt(2)*mt*pi**2*vT**2) + (mW**7*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt))/(9.*sqrt(2)*mt*mZ**4*pi**2*vT**2) + (mW**3*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt))/(9.*sqrt(2)*mt*pi**2*vT**2) + (mW**7*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt))/(9.*sqrt(2)*mt*mZ**4*pi**2*vT**2) - (g1bar*mW**6*Nc*einsum("TT,pt,sr,TT",C["uB"],kd,kd,kdt))/(18.*sqrt(2)*mt*mZ**4*pi**2*vT) + (g1bar*mW**4*Nc*einsum("TT,pt,sr,TT",C["uB"],kd,kd,kdt))/(18.*sqrt(2)*mt*mZ**2*pi**2*vT) - (g1bar*mW**6*Nc*einsum("TT,pt,sr,TT",C["uBDag"],kd,kd,kdt))/(18.*sqrt(2)*mt*mZ**4*pi**2*vT) + (g1bar*mW**4*Nc*einsum("TT,pt,sr,TT",C["uBDag"],kd,kd,kdt))/(18.*sqrt(2)*mt*mZ**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pt,sr,TT",C["uphi"],kd,kd,kdt))/(16.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**4*Nc*einsum("TT,pt,sr,TT",C["uphi"],kd,kd,kdt))/(4.*sqrt(2)*mH**2*mZ**4*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pt,sr,TT",C["uphi"],kd,kd,kdt))/(4.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pt,sr,TT",C["uphiDag"],kd,kd,kdt))/(16.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**4*Nc*einsum("TT,pt,sr,TT",C["uphiDag"],kd,kd,kdt))/(4.*sqrt(2)*mH**2*mZ**4*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pt,sr,TT",C["uphiDag"],kd,kd,kdt))/(4.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (mW**3*Nc*einsum("TT,pt,sr,TT",C["uW"],kd,kd,kdt))/(9.*sqrt(2)*mt*pi**2*vT**2) + (mW**7*Nc*einsum("TT,pt,sr,TT",C["uW"],kd,kd,kdt))/(9.*sqrt(2)*mt*mZ**4*pi**2*vT**2) + (mW**3*Nc*einsum("TT,pt,sr,TT",C["uWDag"],kd,kd,kdt))/(9.*sqrt(2)*mt*pi**2*vT**2) + (mW**7*Nc*einsum("TT,pt,sr,TT",C["uWDag"],kd,kd,kdt))/(9.*sqrt(2)*mt*mZ**4*pi**2*vT**2) + (3*mH**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(64.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (3*mH**2*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (3*mH**4*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) - (3*mH**4*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) - (3*mH**2*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) - (3*mH**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(32.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (3*C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(32.*pi**2) - (3*mW**4*C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*mZ**4*pi**2) + (3*mW**2*C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*mZ**2*pi**2) + (3*mH**4*mW**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (9*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mH**6*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT**2) + (3*mH**6*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) + (3*mH**4*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) - (mH**6*mW**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (9*mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (3*mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (3*mH**2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (5*mH**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(32.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**2*mW**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)*(mH + mZ)*pi**2*vT**2) + (5*mH**4*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (5*mH**4*mW**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mH**2*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mH**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (5*mH**4*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(32.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mH**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mH**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mH**4*mW**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (9*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mH**6*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT**2) - (3*mH**6*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) - (3*mH**4*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) + (mH**6*mW**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (9*mH**4*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (3*mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (3*mH**2*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (3*g1bar*mH**4*mW*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(32.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (3*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**6*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**6*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) - (3*g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**6*mW*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(32.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (3*g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (3*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (3*mH**4*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(64.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (3*mH**2*mW**2*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (3*mH**4*mW**4*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) - (3*mH**4*mW**2*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) - (3*mH**2*mW**4*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) - (3*mH**2*mZ**2*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(32.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (3*C["phi"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(32.*pi**2) - (3*mW**4*C["phi"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(8.*mZ**4*pi**2) + (3*mW**2*C["phi"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(8.*mZ**2*pi**2) + (3*mH**4*mW**2*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (9*mH**2*mW**4*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mH**6*mW**6*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT**2) + (3*mH**6*mW**4*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) + (3*mH**4*mW**6*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) - (mH**6*mW**2*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (9*mH**4*mW**4*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (3*mH**2*mW**6*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (3*mH**2*mW**2*mZ**2*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (5*mH**4*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(32.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**2*mW**2*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/((mH - mZ)*(mH + mZ)*pi**2*vT**2) + (5*mH**4*mW**4*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (5*mH**4*mW**2*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mH**2*mW**4*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/((mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mH**2*mZ**2*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**4*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**2*mW**2*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**4*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (5*mH**4*mW**2*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(32.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mH**2*mW**4*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mH**2*mZ**2*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mH**4*mW**2*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (9*mH**2*mW**4*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mH**6*mW**6*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT**2) - (3*mH**6*mW**4*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) - (3*mH**4*mW**6*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) + (mH**6*mW**2*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (9*mH**4*mW**4*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (3*mH**2*mW**6*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (3*mH**2*mW**2*mZ**2*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (3*g1bar*mH**4*mW*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(32.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (3*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**6*mW**5*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**6*mW**3*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) - (3*g1bar*mH**4*mW**5*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**6*mW*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(32.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (3*g1bar*mH**4*mW**3*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (3*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (mt**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(32.*pi**2*vT**4) - (mt**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(8.*mH**2*pi**2*vT**4) + (5*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(54.*pi**2*vT**4) - (8*mW**8*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(27.*mZ**6*pi**2*vT**4) + (mt**2*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(8.*mZ**4*pi**2*vT**4) - (mt**4*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(2.*mH**2*mZ**4*pi**2*vT**4) + (17*mW**6*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**4) - (mt**2*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(8.*mZ**2*pi**2*vT**4) + (mt**4*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(2.*mH**2*mZ**2*pi**2*vT**4) - (23*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(54.*mZ**2*pi**2*vT**4) + (2*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**6*pi**2*vT**2) - (3*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**4*pi**2*vT**2) + (mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**2*pi**2*vT**2) - (mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(4.*mH**2*pi**2*vT**2) - (mt**4*mW**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**4*pi**2*vT**2) + (mt**4*mW**2*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**2*pi**2*vT**2) - (mt**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(32.*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(16.*mH**2*pi**2*vT**2) - (5*mW**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(108.*pi**2*vT**2) - (8*mW**8*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(27.*mZ**6*pi**2*vT**2) - (mt**4*mW**4*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(4.*mH**2*mZ**4*pi**2*vT**2) + (17*mW**6*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(54.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(16.*mZ**2*pi**2*vT**2) - (2*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**6*pi**2*vT**2) + (3*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**4*pi**2*vT**2) - (mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**2*pi**2*vT**2) - (g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**6*pi**2*vT) - (16*g1bar*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(27.*mZ**6*pi**2*vT) + (g1bar*mt**2*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(8.*mZ**4*pi**2*vT) + (g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(2.*mH**2*mZ**4*pi**2*vT) + (43*g1bar*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(54.*mZ**4*pi**2*vT) - (g1bar*mt**2*mW*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(16.*mZ**2*pi**2*vT) - (7*g1bar*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT) - (mt**2*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(32.*pi**2*vT**2) - (5*mW**2*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(108.*pi**2*vT**2) - (2*mW**6*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(16.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(108.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(32.*pi**2*vT**2) - (5*mW**2*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(108.*pi**2*vT**2) - (2*mW**6*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(16.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(108.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(32.*pi**2*vT**4) - (mt**4*Nc*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(8.*mH**2*pi**2*vT**4) + (5*mW**2*Nc*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(54.*pi**2*vT**4) - (8*mW**8*Nc*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(27.*mZ**6*pi**2*vT**4) + (mt**2*mW**4*Nc*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(8.*mZ**4*pi**2*vT**4) - (mt**4*mW**4*Nc*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(2.*mH**2*mZ**4*pi**2*vT**4) + (17*mW**6*Nc*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**4) - (mt**2*mW**2*Nc*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(8.*mZ**2*pi**2*vT**4) + (mt**4*mW**2*Nc*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(2.*mH**2*mZ**2*pi**2*vT**4) - (23*mW**4*Nc*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(54.*mZ**2*pi**2*vT**4) + (2*mt**4*mW**6*Nc*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**6*pi**2*vT**2) - (3*mt**4*mW**4*Nc*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**4*pi**2*vT**2) + (mt**4*mW**2*Nc*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**2*pi**2*vT**2) - (mt**4*Nc*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(4.*mH**2*pi**2*vT**2) - (mt**4*mW**4*Nc*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**4*pi**2*vT**2) + (mt**4*mW**2*Nc*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**2*pi**2*vT**2) - (mt**2*Nc*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(32.*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(16.*mH**2*pi**2*vT**2) - (5*mW**2*Nc*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(108.*pi**2*vT**2) - (8*mW**8*Nc*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(27.*mZ**6*pi**2*vT**2) - (mt**4*mW**4*Nc*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(4.*mH**2*mZ**4*pi**2*vT**2) + (17*mW**6*Nc*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(54.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(16.*mZ**2*pi**2*vT**2) - (2*mt**4*mW**6*Nc*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**6*pi**2*vT**2) + (3*mt**4*mW**4*Nc*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**4*pi**2*vT**2) - (mt**4*mW**2*Nc*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**2*pi**2*vT**2) - (g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**6*pi**2*vT) - (16*g1bar*mW**7*Nc*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(27.*mZ**6*pi**2*vT) + (g1bar*mt**2*mW**3*Nc*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(8.*mZ**4*pi**2*vT) + (g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(2.*mH**2*mZ**4*pi**2*vT) + (43*g1bar*mW**5*Nc*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(54.*mZ**4*pi**2*vT) - (g1bar*mt**2*mW*Nc*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(16.*mZ**2*pi**2*vT) - (7*g1bar*mW**3*Nc*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT) - (mt**2*Nc*einsum("pt,sr",C["phil1"],kd)*log(scale**2/mt**2))/(32.*pi**2*vT**2) - (5*mW**2*Nc*einsum("pt,sr",C["phil1"],kd)*log(scale**2/mt**2))/(108.*pi**2*vT**2) - (2*mW**6*Nc*einsum("pt,sr",C["phil1"],kd)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("pt,sr",C["phil1"],kd)*log(scale**2/mt**2))/(16.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("pt,sr",C["phil1"],kd)*log(scale**2/mt**2))/(108.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("pt,sr",C["phil3"],kd)*log(scale**2/mt**2))/(32.*pi**2*vT**2) - (5*mW**2*Nc*einsum("pt,sr",C["phil3"],kd)*log(scale**2/mt**2))/(108.*pi**2*vT**2) - (2*mW**6*Nc*einsum("pt,sr",C["phil3"],kd)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("pt,sr",C["phil3"],kd)*log(scale**2/mt**2))/(16.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("pt,sr",C["phil3"],kd)*log(scale**2/mt**2))/(108.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("sr,pt",C["phil1"],kd)*log(scale**2/mt**2))/(32.*pi**2*vT**2) - (5*mW**2*Nc*einsum("sr,pt",C["phil1"],kd)*log(scale**2/mt**2))/(108.*pi**2*vT**2) - (2*mW**6*Nc*einsum("sr,pt",C["phil1"],kd)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("sr,pt",C["phil1"],kd)*log(scale**2/mt**2))/(16.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("sr,pt",C["phil1"],kd)*log(scale**2/mt**2))/(108.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("sr,pt",C["phil3"],kd)*log(scale**2/mt**2))/(32.*pi**2*vT**2) - (5*mW**2*Nc*einsum("sr,pt",C["phil3"],kd)*log(scale**2/mt**2))/(108.*pi**2*vT**2) - (2*mW**6*Nc*einsum("sr,pt",C["phil3"],kd)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("sr,pt",C["phil3"],kd)*log(scale**2/mt**2))/(16.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("sr,pt",C["phil3"],kd)*log(scale**2/mt**2))/(108.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("st,pr",C["phil1"],kd)*log(scale**2/mt**2))/(32.*pi**2*vT**2) - (5*mW**2*Nc*einsum("st,pr",C["phil1"],kd)*log(scale**2/mt**2))/(108.*pi**2*vT**2) - (2*mW**6*Nc*einsum("st,pr",C["phil1"],kd)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("st,pr",C["phil1"],kd)*log(scale**2/mt**2))/(16.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("st,pr",C["phil1"],kd)*log(scale**2/mt**2))/(108.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("st,pr",C["phil3"],kd)*log(scale**2/mt**2))/(32.*pi**2*vT**2) - (5*mW**2*Nc*einsum("st,pr",C["phil3"],kd)*log(scale**2/mt**2))/(108.*pi**2*vT**2) - (2*mW**6*Nc*einsum("st,pr",C["phil3"],kd)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("st,pr",C["phil3"],kd)*log(scale**2/mt**2))/(16.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("st,pr",C["phil3"],kd)*log(scale**2/mt**2))/(108.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(32.*pi**2*vT**2) + (mW**2*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(36.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(16.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(36.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(32.*pi**2*vT**2) - (mW**2*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(36.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(16.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(36.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(32.*pi**2*vT**2) + (mW**2*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(36.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(16.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(36.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("ptTT,sr,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(32.*pi**2*vT**2) + (mW**2*Nc*einsum("ptTT,sr,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(36.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("ptTT,sr,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(16.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("ptTT,sr,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(36.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("ptTT,sr,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(32.*pi**2*vT**2) - (mW**2*Nc*einsum("ptTT,sr,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(36.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("ptTT,sr,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(16.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("ptTT,sr,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(36.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("ptTT,sr,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(32.*pi**2*vT**2) + (mW**2*Nc*einsum("ptTT,sr,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(36.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("ptTT,sr,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(16.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("ptTT,sr,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(36.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("srTT,pt,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(32.*pi**2*vT**2) + (mW**2*Nc*einsum("srTT,pt,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(36.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("srTT,pt,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(16.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("srTT,pt,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(36.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("srTT,pt,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(32.*pi**2*vT**2) - (mW**2*Nc*einsum("srTT,pt,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(36.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("srTT,pt,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(16.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("srTT,pt,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(36.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("srTT,pt,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(32.*pi**2*vT**2) + (mW**2*Nc*einsum("srTT,pt,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(36.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("srTT,pt,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(16.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("srTT,pt,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(36.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("stTT,pr,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(32.*pi**2*vT**2) + (mW**2*Nc*einsum("stTT,pr,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(36.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("stTT,pr,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(16.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("stTT,pr,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(36.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("stTT,pr,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(32.*pi**2*vT**2) - (mW**2*Nc*einsum("stTT,pr,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(36.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("stTT,pr,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(16.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("stTT,pr,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(36.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("stTT,pr,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(32.*pi**2*vT**2) + (mW**2*Nc*einsum("stTT,pr,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(36.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("stTT,pr,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(16.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("stTT,pr,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(36.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*pi**2*vT**2) + (mW**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*pi**2*vT**2) - (mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*mZ**4*pi**2*vT**2) + (mW**6*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*pi**2*vT**2) - (mW**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*pi**2*vT**2) + (mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*mZ**4*pi**2*vT**2) - (mW**6*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*pi**2*vT**2) + (mW**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*pi**2*vT**2) + (mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*mZ**4*pi**2*vT**2) + (mW**6*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) + (7*g1bar*mt*mW**4*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*mZ**4*pi**2*vT) - (13*g1bar*mt*mW**2*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*sqrt(2)*mZ**2*pi**2*vT) + (7*g1bar*mt*mW**4*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*mZ**4*pi**2*vT) - (13*g1bar*mt*mW**2*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*sqrt(2)*mZ**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*mH**2*mZ**4*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*mH**2*mZ**4*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*mH**2*mZ**2*pi**2*vT) - (5*mt*mW*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*pi**2*vT**2) - (29*mt*mW**5*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*mZ**4*pi**2*vT**2) + (31*mt*mW**3*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*mZ**2*pi**2*vT**2) - (5*mt*mW*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*pi**2*vT**2) - (29*mt*mW**5*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*mZ**4*pi**2*vT**2) + (31*mt*mW**3*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TT,pt,sr,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*pi**2*vT**2) + (mW**2*Nc*einsum("TT,pt,sr,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*pi**2*vT**2) - (mt**2*mW**4*Nc*einsum("TT,pt,sr,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*mZ**4*pi**2*vT**2) + (mW**6*Nc*einsum("TT,pt,sr,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TT,pt,sr,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("TT,pt,sr,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pt,sr,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*pi**2*vT**2) - (mW**2*Nc*einsum("TT,pt,sr,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*pi**2*vT**2) + (mt**2*mW**4*Nc*einsum("TT,pt,sr,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*mZ**4*pi**2*vT**2) - (mW**6*Nc*einsum("TT,pt,sr,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TT,pt,sr,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("TT,pt,sr,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pt,sr,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*pi**2*vT**2) + (mW**2*Nc*einsum("TT,pt,sr,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*pi**2*vT**2) + (mt**2*mW**4*Nc*einsum("TT,pt,sr,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*mZ**4*pi**2*vT**2) + (mW**6*Nc*einsum("TT,pt,sr,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TT,pt,sr,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("TT,pt,sr,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) + (7*g1bar*mt*mW**4*Nc*einsum("TT,pt,sr,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*mZ**4*pi**2*vT) - (13*g1bar*mt*mW**2*Nc*einsum("TT,pt,sr,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*sqrt(2)*mZ**2*pi**2*vT) + (7*g1bar*mt*mW**4*Nc*einsum("TT,pt,sr,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*mZ**4*pi**2*vT) - (13*g1bar*mt*mW**2*Nc*einsum("TT,pt,sr,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*sqrt(2)*mZ**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pt,sr,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**4*Nc*einsum("TT,pt,sr,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*mH**2*mZ**4*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pt,sr,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pt,sr,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**4*Nc*einsum("TT,pt,sr,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*mH**2*mZ**4*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pt,sr,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*mH**2*mZ**2*pi**2*vT) - (5*mt*mW*Nc*einsum("TT,pt,sr,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*pi**2*vT**2) - (29*mt*mW**5*Nc*einsum("TT,pt,sr,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*mZ**4*pi**2*vT**2) + (31*mt*mW**3*Nc*einsum("TT,pt,sr,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*mZ**2*pi**2*vT**2) - (5*mt*mW*Nc*einsum("TT,pt,sr,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*pi**2*vT**2) - (29*mt*mW**5*Nc*einsum("TT,pt,sr,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*mZ**4*pi**2*vT**2) + (31*mt*mW**3*Nc*einsum("TT,pt,sr,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*mZ**2*pi**2*vT**2) - (5*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(96.*pi**2*vT**4) + (3*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(16.*mH**2*pi**2*vT**4) + (7*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mZ**6*pi**2*vT**4) - (133*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(24.*mZ**4*pi**2*vT**4) + (3*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(4.*mH**2*mZ**4*pi**2*vT**4) + (2*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mZ**2*pi**2*vT**4) - (3*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(4.*mH**2*mZ**2*pi**2*vT**4) - (3*mW**10*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**6*pi**2*vT**2) + (9*mW**8*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*mZ**4*pi**2*vT**2) - (3*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*mZ**2*pi**2*vT**2) + (3*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(8.*mH**2*pi**2*vT**2) + (3*mW**8*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*mZ**4*pi**2*vT**2) - (3*mW**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*mZ**2*pi**2*vT**2) - (3*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(32.*mH**2*pi**2*vT**2) + (7*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mZ**6*pi**2*vT**2) - (35*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(12.*mZ**4*pi**2*vT**2) + (3*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(8.*mH**2*mZ**4*pi**2*vT**2) + (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(8.*mZ**2*pi**2*vT**2) + (3*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(8.*mH**2*pi**2*vT**2) + (3*mW**10*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**6*pi**2*vT**2) - (3*mW**8*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**4*pi**2*vT**2) + (11*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mZ**6*pi**2*vT) + (3*g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*mZ**6*pi**2*vT) - (41*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(8.*mZ**4*pi**2*vT) - (3*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(4.*mH**2*mZ**4*pi**2*vT) + (35*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(48.*mZ**2*pi**2*vT) - (3*mW**3*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(4.*pi**2*vT**3) + (18*mW**9*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mZ**6*pi**2*vT**3) - (57*mW**7*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mZ**4*pi**2*vT**3) + (45*mW**5*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(4.*mZ**2*pi**2*vT**3) + (7*mW**6*einsum("pr,st",C["phil1"],kd)*log(scale**2/mW**2))/(8.*mZ**4*pi**2*vT**2) - (7*mW**4*einsum("pr,st",C["phil1"],kd)*log(scale**2/mW**2))/(8.*mZ**2*pi**2*vT**2) + (7*mW**2*einsum("pr,st",C["phil3"],kd)*log(scale**2/mW**2))/(48.*pi**2*vT**2) + (7*mW**6*einsum("pr,st",C["phil3"],kd)*log(scale**2/mW**2))/(8.*mZ**4*pi**2*vT**2) - (29*mW**4*einsum("pr,st",C["phil3"],kd)*log(scale**2/mW**2))/(24.*mZ**2*pi**2*vT**2) - (5*mW**2*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(96.*pi**2*vT**4) + (3*mW**4*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(16.*mH**2*pi**2*vT**4) + (7*mW**8*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(2.*mZ**6*pi**2*vT**4) - (133*mW**6*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(24.*mZ**4*pi**2*vT**4) + (3*mW**8*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(4.*mH**2*mZ**4*pi**2*vT**4) + (2*mW**4*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(mZ**2*pi**2*vT**4) - (3*mW**6*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(4.*mH**2*mZ**2*pi**2*vT**4) - (3*mW**10*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**6*pi**2*vT**2) + (9*mW**8*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*mZ**4*pi**2*vT**2) - (3*mW**6*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*mZ**2*pi**2*vT**2) + (3*mW**4*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(8.*mH**2*pi**2*vT**2) + (3*mW**8*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*mZ**4*pi**2*vT**2) - (3*mW**6*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*mZ**2*pi**2*vT**2) - (3*mW**4*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(32.*mH**2*pi**2*vT**2) + (7*mW**8*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(2.*mZ**6*pi**2*vT**2) - (35*mW**6*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(12.*mZ**4*pi**2*vT**2) + (3*mW**8*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(8.*mH**2*mZ**4*pi**2*vT**2) + (mW**4*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(8.*mZ**2*pi**2*vT**2) + (3*mW**4*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(8.*mH**2*pi**2*vT**2) + (3*mW**10*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**6*pi**2*vT**2) - (3*mW**8*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**4*pi**2*vT**2) + (11*g1bar*mW**7*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(2.*mZ**6*pi**2*vT) + (3*g1bar*mW**9*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*mZ**6*pi**2*vT) - (41*g1bar*mW**5*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(8.*mZ**4*pi**2*vT) - (3*g1bar*mW**7*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(4.*mH**2*mZ**4*pi**2*vT) + (35*g1bar*mW**3*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(48.*mZ**2*pi**2*vT) - (3*mW**3*C["W"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(4.*pi**2*vT**3) + (18*mW**9*C["W"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(mZ**6*pi**2*vT**3) - (57*mW**7*C["W"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(2.*mZ**4*pi**2*vT**3) + (45*mW**5*C["W"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(4.*mZ**2*pi**2*vT**3) + (7*mW**6*einsum("pt,sr",C["phil1"],kd)*log(scale**2/mW**2))/(8.*mZ**4*pi**2*vT**2) - (7*mW**4*einsum("pt,sr",C["phil1"],kd)*log(scale**2/mW**2))/(8.*mZ**2*pi**2*vT**2) + (7*mW**2*einsum("pt,sr",C["phil3"],kd)*log(scale**2/mW**2))/(48.*pi**2*vT**2) + (7*mW**6*einsum("pt,sr",C["phil3"],kd)*log(scale**2/mW**2))/(8.*mZ**4*pi**2*vT**2) - (29*mW**4*einsum("pt,sr",C["phil3"],kd)*log(scale**2/mW**2))/(24.*mZ**2*pi**2*vT**2) + (7*mW**6*einsum("sr,pt",C["phil1"],kd)*log(scale**2/mW**2))/(8.*mZ**4*pi**2*vT**2) - (7*mW**4*einsum("sr,pt",C["phil1"],kd)*log(scale**2/mW**2))/(8.*mZ**2*pi**2*vT**2) + (7*mW**2*einsum("sr,pt",C["phil3"],kd)*log(scale**2/mW**2))/(48.*pi**2*vT**2) + (7*mW**6*einsum("sr,pt",C["phil3"],kd)*log(scale**2/mW**2))/(8.*mZ**4*pi**2*vT**2) - (29*mW**4*einsum("sr,pt",C["phil3"],kd)*log(scale**2/mW**2))/(24.*mZ**2*pi**2*vT**2) + (7*mW**6*einsum("st,pr",C["phil1"],kd)*log(scale**2/mW**2))/(8.*mZ**4*pi**2*vT**2) - (7*mW**4*einsum("st,pr",C["phil1"],kd)*log(scale**2/mW**2))/(8.*mZ**2*pi**2*vT**2) + (7*mW**2*einsum("st,pr",C["phil3"],kd)*log(scale**2/mW**2))/(48.*pi**2*vT**2) + (7*mW**6*einsum("st,pr",C["phil3"],kd)*log(scale**2/mW**2))/(8.*mZ**4*pi**2*vT**2) - (29*mW**4*einsum("st,pr",C["phil3"],kd)*log(scale**2/mW**2))/(24.*mZ**2*pi**2*vT**2) + (3*mW**2*einsum("prst",C["ll"])*log(scale**2/mZ**2))/(8.*pi**2*vT**2) - (3*mW**4*einsum("prst",C["ll"])*log(scale**2/mZ**2))/(8.*mZ**2*pi**2*vT**2) - (3*mZ**2*einsum("prst",C["ll"])*log(scale**2/mZ**2))/(32.*pi**2*vT**2) + (3*mW**2*einsum("ptsr",C["ll"])*log(scale**2/mZ**2))/(8.*pi**2*vT**2) - (3*mW**4*einsum("ptsr",C["ll"])*log(scale**2/mZ**2))/(8.*mZ**2*pi**2*vT**2) - (3*mZ**2*einsum("ptsr",C["ll"])*log(scale**2/mZ**2))/(32.*pi**2*vT**2) + (3*mW**2*einsum("srpt",C["ll"])*log(scale**2/mZ**2))/(8.*pi**2*vT**2) - (3*mW**4*einsum("srpt",C["ll"])*log(scale**2/mZ**2))/(8.*mZ**2*pi**2*vT**2) - (3*mZ**2*einsum("srpt",C["ll"])*log(scale**2/mZ**2))/(32.*pi**2*vT**2) + (3*mW**2*einsum("stpr",C["ll"])*log(scale**2/mZ**2))/(8.*pi**2*vT**2) - (3*mW**4*einsum("stpr",C["ll"])*log(scale**2/mZ**2))/(8.*mZ**2*pi**2*vT**2) - (3*mZ**2*einsum("stpr",C["ll"])*log(scale**2/mZ**2))/(32.*pi**2*vT**2) - (11*mH**2*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(24.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (83*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(48.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (11*mH**2*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**4) - (11*mH**2*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) - (11*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) + (55*mH**2*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(24.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) + (11*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) - (5*mW**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(48.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (3*mW**4*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (9*mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(64.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (3*mW**2*mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (3*mZ**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(32.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (15*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (5*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (9*mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (27*mH**2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (33*mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (9*mW**6*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (3*mH**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (29*mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (15*mW**4*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (3*mZ**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (27*mW**2*mZ**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (3*mZ**8*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (9*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (9*mW**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mW**4*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (9*mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(32.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (3*mW**2*mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mZ**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (11*mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(48.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (9*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (11*mH**2*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (11*mH**2*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (11*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (11*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (49*mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(96.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mW**4*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (3*mW**2*mZ**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (5*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (9*mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (15*mH**2*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (27*mW**4*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (9*mW**6*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (17*mW**2*mZ**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (3*mW**4*mZ**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (15*mW**2*mZ**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (53*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (85*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(12.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (11*g1bar*mH**4*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT) - (55*g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(12.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) - (22*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) + (11*g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (247*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(24.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (11*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (47*g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (9*g1bar*mW**5*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (5*g1bar*mW*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(32.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (3*g1bar*mW**3*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (3*g1bar*mW*mZ**6*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(32.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (11*mW**2*einsum("pr,st",C["phil1"],kd)*log(scale**2/mZ**2))/(24.*pi**2*vT**2) + (11*mW**6*einsum("pr,st",C["phil1"],kd)*log(scale**2/mZ**2))/(12.*mZ**4*pi**2*vT**2) - (11*mW**4*einsum("pr,st",C["phil1"],kd)*log(scale**2/mZ**2))/(8.*mZ**2*pi**2*vT**2) + (11*mW**2*einsum("pr,st",C["phil3"],kd)*log(scale**2/mZ**2))/(24.*pi**2*vT**2) + (11*mW**6*einsum("pr,st",C["phil3"],kd)*log(scale**2/mZ**2))/(12.*mZ**4*pi**2*vT**2) - (11*mW**4*einsum("pr,st",C["phil3"],kd)*log(scale**2/mZ**2))/(8.*mZ**2*pi**2*vT**2) - (11*mH**2*mW**2*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(24.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (83*mW**4*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(48.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (11*mH**2*mW**8*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**4) - (11*mH**2*mW**6*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) - (11*mW**8*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) + (55*mH**2*mW**4*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(24.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) + (11*mW**6*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) - (5*mW**2*mZ**2*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(48.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (3*mW**4*mZ**2*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(8.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (9*mZ**4*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(64.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (3*mW**2*mZ**4*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(8.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (3*mZ**6*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(32.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (15*mH**2*mW**4*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (5*mW**6*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (9*mH**2*mW**6*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (27*mH**2*mW**2*mZ**2*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (33*mW**4*mZ**2*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (9*mW**6*mZ**2*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (3*mH**2*mZ**4*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (29*mW**2*mZ**4*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (15*mW**4*mZ**4*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (3*mZ**6*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (27*mW**2*mZ**6*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(16.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (3*mZ**8*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(16.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (9*mW**4*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (9*mW**2*mZ**2*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mW**4*mZ**2*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (9*mZ**4*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(32.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (3*mW**2*mZ**4*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mZ**6*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(16.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (11*mH**2*mW**2*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(48.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (9*mW**4*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (11*mH**2*mW**8*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (11*mH**2*mW**6*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (11*mW**8*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (11*mW**6*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (49*mW**2*mZ**2*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(96.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mW**4*mZ**2*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(8.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (3*mW**2*mZ**4*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(16.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mH**2*mW**4*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (5*mW**6*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (9*mH**2*mW**6*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (15*mH**2*mW**2*mZ**2*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (27*mW**4*mZ**2*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (9*mW**6*mZ**2*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (17*mW**2*mZ**4*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (3*mW**4*mZ**4*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (15*mW**2*mZ**6*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(16.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (53*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (85*g1bar*mW**5*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(12.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (11*g1bar*mH**4*mW**7*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT) - (55*g1bar*mH**4*mW**5*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(12.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) - (22*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) + (11*g1bar*mH**4*mW**3*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (247*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(24.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (11*g1bar*mW**7*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (47*g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (9*g1bar*mW**5*mZ**2*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(8.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (5*g1bar*mW*mZ**4*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(32.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (3*g1bar*mW**3*mZ**4*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (3*g1bar*mW*mZ**6*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(32.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (11*mW**2*einsum("pt,sr",C["phil1"],kd)*log(scale**2/mZ**2))/(24.*pi**2*vT**2) + (11*mW**6*einsum("pt,sr",C["phil1"],kd)*log(scale**2/mZ**2))/(12.*mZ**4*pi**2*vT**2) - (11*mW**4*einsum("pt,sr",C["phil1"],kd)*log(scale**2/mZ**2))/(8.*mZ**2*pi**2*vT**2) + (11*mW**2*einsum("pt,sr",C["phil3"],kd)*log(scale**2/mZ**2))/(24.*pi**2*vT**2) + (11*mW**6*einsum("pt,sr",C["phil3"],kd)*log(scale**2/mZ**2))/(12.*mZ**4*pi**2*vT**2) - (11*mW**4*einsum("pt,sr",C["phil3"],kd)*log(scale**2/mZ**2))/(8.*mZ**2*pi**2*vT**2) + (11*mW**2*einsum("sr,pt",C["phil1"],kd)*log(scale**2/mZ**2))/(24.*pi**2*vT**2) + (11*mW**6*einsum("sr,pt",C["phil1"],kd)*log(scale**2/mZ**2))/(12.*mZ**4*pi**2*vT**2) - (11*mW**4*einsum("sr,pt",C["phil1"],kd)*log(scale**2/mZ**2))/(8.*mZ**2*pi**2*vT**2) + (11*mW**2*einsum("sr,pt",C["phil3"],kd)*log(scale**2/mZ**2))/(24.*pi**2*vT**2) + (11*mW**6*einsum("sr,pt",C["phil3"],kd)*log(scale**2/mZ**2))/(12.*mZ**4*pi**2*vT**2) - (11*mW**4*einsum("sr,pt",C["phil3"],kd)*log(scale**2/mZ**2))/(8.*mZ**2*pi**2*vT**2) + (11*mW**2*einsum("st,pr",C["phil1"],kd)*log(scale**2/mZ**2))/(24.*pi**2*vT**2) + (11*mW**6*einsum("st,pr",C["phil1"],kd)*log(scale**2/mZ**2))/(12.*mZ**4*pi**2*vT**2) - (11*mW**4*einsum("st,pr",C["phil1"],kd)*log(scale**2/mZ**2))/(8.*mZ**2*pi**2*vT**2) + (11*mW**2*einsum("st,pr",C["phil3"],kd)*log(scale**2/mZ**2))/(24.*pi**2*vT**2) + (11*mW**6*einsum("st,pr",C["phil3"],kd)*log(scale**2/mZ**2))/(12.*mZ**4*pi**2*vT**2) - (11*mW**4*einsum("st,pr",C["phil3"],kd)*log(scale**2/mZ**2))/(8.*mZ**2*pi**2*vT**2) - (mW**5*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(9.*mt*mZ**2*pi**2*vT**2) - (mW**5*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(9.*mt*mZ**2*pi**2*vT**2) - (mW**5*Nc*einsum("TT,pt,sr,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(9.*mt*mZ**2*pi**2*vT**2) - (mW**5*Nc*einsum("TT,pt,sr,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(9.*mt*mZ**2*pi**2*vT**2) - (g1bar*mt*mW**6*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(3.*mZ**6*pi**2*vT) - (g1bar*mt*mW**6*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(3.*mZ**6*pi**2*vT) + (2*mt*mW**7*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(3.*mZ**6*pi**2*vT**2) + (2*mt*mW**7*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(3.*mZ**6*pi**2*vT**2) - (g1bar*mt*mW**6*Nc*einsum("TT,pt,sr,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(3.*mZ**6*pi**2*vT) - (g1bar*mt*mW**6*Nc*einsum("TT,pt,sr,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(3.*mZ**6*pi**2*vT) + (2*mt*mW**7*Nc*einsum("TT,pt,sr,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(3.*mZ**6*pi**2*vT**2) + (2*mt*mW**7*Nc*einsum("TT,pt,sr,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(3.*mZ**6*pi**2*vT**2))
    c['VeuLL'] = ((-15*mW**2*einsum("prst",C["lq1"]))/(8.*pi**2*vT**2) + (bEvan*mW**2*einsum("prst",C["lq1"]))/(2.*pi**2*vT**2) + (5*mW**4*einsum("prst",C["lq1"]))/(2.*mZ**2*pi**2*vT**2) - (2*bEvan*mW**4*einsum("prst",C["lq1"]))/(3.*mZ**2*pi**2*vT**2) + (5*mZ**2*einsum("prst",C["lq1"]))/(16.*pi**2*vT**2) - (bEvan*mZ**2*einsum("prst",C["lq1"]))/(12.*pi**2*vT**2) - (11*mW**2*einsum("prst",C["lq3"]))/(8.*pi**2*vT**2) - (5*mW**4*einsum("prst",C["lq3"]))/(2.*mZ**2*pi**2*vT**2) + (2*bEvan*mW**4*einsum("prst",C["lq3"]))/(3.*mZ**2*pi**2*vT**2) - (5*mZ**2*einsum("prst",C["lq3"]))/(16.*pi**2*vT**2) + (bEvan*mZ**2*einsum("prst",C["lq3"]))/(12.*pi**2*vT**2) - (7*mH**2*einsum("pr,st",kd,kd))/(96.*pi**2*vT**4) - (10369*mW**2*einsum("pr,st",kd,kd))/(19440.*pi**2*vT**4) + (2*bEvan*mW**2*einsum("pr,st",kd,kd))/(9.*pi**2*vT**4) - (5*mW**4*einsum("pr,st",kd,kd))/(12.*mH**2*pi**2*vT**4) + (1910*mW**8*einsum("pr,st",kd,kd))/(243.*mZ**6*pi**2*vT**4) - (16*bEvan*mW**8*einsum("pr,st",kd,kd))/(9.*mZ**6*pi**2*vT**4) - (7*mH**2*mW**4*einsum("pr,st",kd,kd))/(12.*mZ**4*pi**2*vT**4) - (6068*mW**6*einsum("pr,st",kd,kd))/(405.*mZ**4*pi**2*vT**4) + (28*bEvan*mW**6*einsum("pr,st",kd,kd))/(9.*mZ**4*pi**2*vT**4) - (2*mW**8*einsum("pr,st",kd,kd))/(3.*mH**2*mZ**4*pi**2*vT**4) + (7*mH**2*mW**2*einsum("pr,st",kd,kd))/(16.*mZ**2*pi**2*vT**4) + (4753*mW**4*einsum("pr,st",kd,kd))/(540.*mZ**2*pi**2*vT**4) - (14*bEvan*mW**4*einsum("pr,st",kd,kd))/(9.*mZ**2*pi**2*vT**4) + (mW**6*einsum("pr,st",kd,kd))/(2.*mH**2*mZ**2*pi**2*vT**4) + (7*mZ**2*einsum("pr,st",kd,kd))/(96.*pi**2*vT**4) + (mW**2*mZ**2*einsum("pr,st",kd,kd))/(4.*mH**2*pi**2*vT**4) - (mZ**4*einsum("pr,st",kd,kd))/(24.*mH**2*pi**2*vT**4) + (mt**4*Nc*einsum("pr,st",kd,kd))/(6.*mH**2*pi**2*vT**4) + (32*mW**4*Nc*einsum("pr,st",kd,kd))/(405.*mt**2*pi**2*vT**4) + (4*mt**4*mW**4*Nc*einsum("pr,st",kd,kd))/(3.*mH**2*mZ**4*pi**2*vT**4) + (32*mW**8*Nc*einsum("pr,st",kd,kd))/(405.*mt**2*mZ**4*pi**2*vT**4) - (mt**4*mW**2*Nc*einsum("pr,st",kd,kd))/(mH**2*mZ**2*pi**2*vT**4) - (64*mW**6*Nc*einsum("pr,st",kd,kd))/(405.*mt**2*mZ**2*pi**2*vT**4) + (C["phi"]*einsum("pr,st",kd,kd))/(8.*pi**2) + (mW**4*C["phi"]*einsum("pr,st",kd,kd))/(mZ**4*pi**2) - (3*mW**2*C["phi"]*einsum("pr,st",kd,kd))/(4.*mZ**2*pi**2) - (3*mH**2*mW**2*C["phiB"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (23*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (4*mH**4*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (8*mW**10*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (11*mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (2*mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (11*mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (8*mW**10*C["phiB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**2*C["phiB"]*einsum("pr,st",kd,kd))/(2.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (11*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (5*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (11*mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (11*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (3*mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (13*mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(12.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mZ**6*C["phiB"]*einsum("pr,st",kd,kd))/(12.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (16*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (22*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (16*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (2*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (22*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (11*mH**2*C["phiBox"]*einsum("pr,st",kd,kd))/(48.*pi**2*vT**2) - (5*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(8.*pi**2*vT**2) - (5*mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(6.*mH**2*pi**2*vT**2) - (11*mH**2*mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(6.*mZ**4*pi**2*vT**2) - (4*mW**8*C["phiBox"]*einsum("pr,st",kd,kd))/(3.*mH**2*mZ**4*pi**2*vT**2) + (11*mH**2*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(8.*mZ**2*pi**2*vT**2) + (5*mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(6.*mZ**2*pi**2*vT**2) + (mW**6*C["phiBox"]*einsum("pr,st",kd,kd))/(mH**2*mZ**2*pi**2*vT**2) + (5*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(48.*pi**2*vT**2) + (mW**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(2.*mH**2*pi**2*vT**2) - (mZ**4*C["phiBox"]*einsum("pr,st",kd,kd))/(12.*mH**2*pi**2*vT**2) + (mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(3.*mH**2*pi**2*vT**2) + (8*mt**4*mW**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(3.*mH**2*mZ**4*pi**2*vT**2) - (2*mt**4*mW**2*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(mH**2*mZ**2*pi**2*vT**2) + (mH**2*C["phiD"]*einsum("pr,st",kd,kd))/(12.*pi**2*vT**2) + (3557*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(7776.*pi**2*vT**2) - (bEvan*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(9.*pi**2*vT**2) - (7*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(24.*mH**2*pi**2*vT**2) + (1910*mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(243.*mZ**6*pi**2*vT**2) - (16*bEvan*mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(9.*mZ**6*pi**2*vT**2) + (mH**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(12.*mZ**4*pi**2*vT**2) - (3268*mW**6*C["phiD"]*einsum("pr,st",kd,kd))/(405.*mZ**4*pi**2*vT**2) + (14*bEvan*mW**6*C["phiD"]*einsum("pr,st",kd,kd))/(9.*mZ**4*pi**2*vT**2) - (mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(3.*mH**2*mZ**4*pi**2*vT**2) - (9*mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(32.*mZ**2*pi**2*vT**2) + (1003*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(1080.*mZ**2*pi**2*vT**2) - (mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(48.*pi**2*vT**2) + (mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(8.*mH**2*pi**2*vT**2) - (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(12.*mH**2*pi**2*vT**2) + (2*mt**4*mW**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(3.*mH**2*mZ**4*pi**2*vT**2) + (32*mW**8*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(405.*mt**2*mZ**4*pi**2*vT**2) - (32*mW**6*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(405.*mt**2*mZ**2*pi**2*vT**2) + (3*mH**2*mW**2*C["phiW"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (59*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (4*mH**4*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (8*mW**10*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (11*mH**4*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (2*mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (7*mW**8*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (8*mW**10*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**2*C["phiW"]*einsum("pr,st",kd,kd))/(2.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (11*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (4*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (7*mW**8*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (4*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (13*mW**4*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(6.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (7*mW**2*mZ**4*C["phiW"]*einsum("pr,st",kd,kd))/(12.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (2*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (16*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (22*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (16*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (22*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (5*g1bar*mH**2*mW*C["phiWB"]*einsum("pr,st",kd,kd))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (40489*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(9720.*(mH - mZ)*(mH + mZ)*pi**2*vT) + (8*bEvan*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) - (2*g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (3496*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(243.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) - (32*bEvan*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) - (4*g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) - (40931*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(2430.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (34*bEvan*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (6749*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(486.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (32*bEvan*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (4*g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (3*g1bar*mH**4*mW*C["phiWB"]*einsum("pr,st",kd,kd))/(32.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (51019*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(9720.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (8*bEvan*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (38501*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(2430.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (34*bEvan*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(2.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (5*g1bar*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(96.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(2.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mW*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd))/(24.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) + (64*g1bar*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(405.*mt**2*(mH - mZ)*(mH + mZ)*pi**2*vT) + (8*g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) - (g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (8*g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (64*g1bar*mH**2*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(405.*mt**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (64*g1bar*mH**2*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(405.*mt**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (64*g1bar*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(405.*mt**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (3*mW**3*C["W"]*einsum("pr,st",kd,kd))/(2.*pi**2*vT**3) - (4*mW**7*C["W"]*einsum("pr,st",kd,kd))/(mZ**4*pi**2*vT**3) + (11*mW**5*C["W"]*einsum("pr,st",kd,kd))/(2.*mZ**2*pi**2*vT**3) + (163*mW**2*einsum("pr,st",C["phil1"],kd))/(108.*pi**2*vT**2) - (2*bEvan*mW**2*einsum("pr,st",C["phil1"],kd))/(9.*pi**2*vT**2) + (134*mW**6*einsum("pr,st",C["phil1"],kd))/(27.*mZ**4*pi**2*vT**2) - (8*bEvan*mW**6*einsum("pr,st",C["phil1"],kd))/(9.*mZ**4*pi**2*vT**2) - (109*mW**4*einsum("pr,st",C["phil1"],kd))/(18.*mZ**2*pi**2*vT**2) + (10*bEvan*mW**4*einsum("pr,st",C["phil1"],kd))/(9.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("pr,st",C["phil1"],kd))/(24.*pi**2*vT**2) + (877*mW**2*einsum("pr,st",C["phil3"],kd))/(216.*pi**2*vT**2) - (2*bEvan*mW**2*einsum("pr,st",C["phil3"],kd))/(9.*pi**2*vT**2) + (134*mW**6*einsum("pr,st",C["phil3"],kd))/(27.*mZ**4*pi**2*vT**2) - (8*bEvan*mW**6*einsum("pr,st",C["phil3"],kd))/(9.*mZ**4*pi**2*vT**2) - (175*mW**4*einsum("pr,st",C["phil3"],kd))/(27.*mZ**2*pi**2*vT**2) + (10*bEvan*mW**4*einsum("pr,st",C["phil3"],kd))/(9.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("pr,st",C["phil3"],kd))/(24.*pi**2*vT**2) - (581*mW**2*einsum("st,pr",C["phiq1"],kd))/(162.*pi**2*vT**2) + (2*bEvan*mW**2*einsum("st,pr",C["phiq1"],kd))/(3.*pi**2*vT**2) - (568*mW**6*einsum("st,pr",C["phiq1"],kd))/(81.*mZ**4*pi**2*vT**2) + (4*bEvan*mW**6*einsum("st,pr",C["phiq1"],kd))/(3.*mZ**4*pi**2*vT**2) + (818*mW**4*einsum("st,pr",C["phiq1"],kd))/(81.*mZ**2*pi**2*vT**2) - (2*bEvan*mW**4*einsum("st,pr",C["phiq1"],kd))/(mZ**2*pi**2*vT**2) + (mZ**2*einsum("st,pr",C["phiq1"],kd))/(8.*pi**2*vT**2) + (4283*mW**2*einsum("st,pr",C["phiq3"],kd))/(648.*pi**2*vT**2) - (2*bEvan*mW**2*einsum("st,pr",C["phiq3"],kd))/(3.*pi**2*vT**2) + (568*mW**6*einsum("st,pr",C["phiq3"],kd))/(81.*mZ**4*pi**2*vT**2) - (4*bEvan*mW**6*einsum("st,pr",C["phiq3"],kd))/(3.*mZ**4*pi**2*vT**2) - (3563*mW**4*einsum("st,pr",C["phiq3"],kd))/(324.*mZ**2*pi**2*vT**2) + (2*bEvan*mW**4*einsum("st,pr",C["phiq3"],kd))/(mZ**2*pi**2*vT**2) - (mZ**2*einsum("st,pr",C["phiq3"],kd))/(8.*pi**2*vT**2) + (mt**2*einsum("sTTt,pr,TT",C["qq1"],kd,kdt))/(8.*pi**2*vT**2) - (mW**2*einsum("sTTt,pr,TT",C["qq1"],kd,kdt))/(9.*pi**2*vT**2) - (mt**2*mW**2*einsum("sTTt,pr,TT",C["qq1"],kd,kdt))/(4.*mZ**2*pi**2*vT**2) + (mW**4*einsum("sTTt,pr,TT",C["qq1"],kd,kdt))/(9.*mZ**2*pi**2*vT**2) + (mt**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(8.*pi**2*vT**2) - (mW**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(9.*pi**2*vT**2) - (mt**2*mW**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(4.*mZ**2*pi**2*vT**2) + (mW**4*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(9.*mZ**2*pi**2*vT**2) + (mt**2*einsum("TtsT,pr,TT",C["qq1"],kd,kdt))/(8.*pi**2*vT**2) - (mW**2*einsum("TtsT,pr,TT",C["qq1"],kd,kdt))/(9.*pi**2*vT**2) - (mt**2*mW**2*einsum("TtsT,pr,TT",C["qq1"],kd,kdt))/(4.*mZ**2*pi**2*vT**2) + (mW**4*einsum("TtsT,pr,TT",C["qq1"],kd,kdt))/(9.*mZ**2*pi**2*vT**2) + (mt**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(8.*pi**2*vT**2) - (mW**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(9.*pi**2*vT**2) - (mt**2*mW**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(4.*mZ**2*pi**2*vT**2) + (mW**4*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(9.*mZ**2*pi**2*vT**2) - (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(12.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(2.*sqrt(2)*mH**2*mZ**2*pi**2*vT) - (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(12.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(2.*sqrt(2)*mH**2*mZ**2*pi**2*vT) - (mH**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (3*mH**2*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (mH**4*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) + (3*mH**4*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) + (mH**2*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) + (mH**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*pi**2) + (mW**4*C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(mZ**4*pi**2) - (3*mW**2*C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*mZ**2*pi**2) - (3*mH**4*mW**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (11*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (4*mH**6*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT**2) - (11*mH**6*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) - (4*mH**4*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) + (mH**6*mW**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (11*mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (4*mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (3*mH**2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (5*mH**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(24.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (2*mH**2*mW**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)*(mH + mZ)*pi**2*vT**2) - (5*mH**4*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (5*mH**4*mW**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (8*mH**2*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mH**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (5*mH**4*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mH**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mH**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (3*mH**4*mW**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (11*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (4*mH**6*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT**2) + (11*mH**6*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) + (4*mH**4*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) - (mH**6*mW**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (11*mH**4*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (4*mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (3*mH**2*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (3*g1bar*mH**4*mW*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (3*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (2*g1bar*mH**6*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**6*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) + (2*g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**6*mW*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) - (2*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) - (mt**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(24.*pi**2*vT**4) + (mt**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(6.*mH**2*pi**2*vT**4) - (5*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(27.*pi**2*vT**4) + (64*mW**8*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**6*pi**2*vT**4) - (mt**2*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mZ**4*pi**2*vT**4) + (4*mt**4*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**4*pi**2*vT**4) - (128*mW**6*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**4) + (mt**2*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**4) - (mt**4*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**2*pi**2*vT**4) + (79*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**4) - (16*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**6*pi**2*vT**2) + (22*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**4*pi**2*vT**2) - (2*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**2*pi**2*vT**2) + (mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*pi**2*vT**2) + (8*mt**4*mW**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**4*pi**2*vT**2) - (2*mt**4*mW**2*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**2*pi**2*vT**2) + (mt**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(24.*pi**2*vT**2) - (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(12.*mH**2*pi**2*vT**2) + (5*mW**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(54.*pi**2*vT**2) + (64*mW**8*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**6*pi**2*vT**2) + (2*mt**4*mW**4*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**4*pi**2*vT**2) - (64*mW**6*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(8.*mZ**2*pi**2*vT**2) + (16*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**6*pi**2*vT**2) - (22*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**4*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**2*pi**2*vT**2) + (8*g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**6*pi**2*vT) + (128*g1bar*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**6*pi**2*vT) - (g1bar*mt**2*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mZ**4*pi**2*vT) - (g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**4*pi**2*vT) - (160*g1bar*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT) + (g1bar*mt**2*mW*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(8.*mZ**2*pi**2*vT) + (47*g1bar*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT) + (mt**2*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (10*mW**2*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) + (16*mW**6*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) - (26*mW**4*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (10*mW**2*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) + (16*mW**6*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) - (26*mW**4*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(8.*pi**2*vT**2) - (5*mW**2*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (8*mW**6*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (5*mW**2*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (8*mW**6*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) - (13*mW**4*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) - (2*mW**2*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) + (2*mW**4*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (2*mW**2*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) - (2*mW**4*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) - (2*mW**2*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) + (2*mW**4*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("stTT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mW**2*Nc*einsum("stTT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("stTT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("stTT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("stTT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mW**2*Nc*einsum("stTT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("stTT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("stTT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("stTT,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mW**2*Nc*einsum("stTT,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("stTT,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("stTT,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) - (mt**2*einsum("sTTt,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mW**2*einsum("sTTt,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) + (mt**2*mW**2*einsum("sTTt,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) - (mW**4*einsum("sTTt,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) - (mt**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mW**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) + (mt**2*mW**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) - (mW**4*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) - (mt**2*einsum("TtsT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mW**2*einsum("TtsT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) + (mt**2*mW**2*einsum("TtsT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) - (mW**4*einsum("TtsT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) - (mt**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mW**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) + (mt**2*mW**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) - (mW**4*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TTst,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mW**2*Nc*einsum("TTst,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TTst,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("TTst,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TTst,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mW**2*Nc*einsum("TTst,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TTst,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("TTst,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) - (mW**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) + (2*mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*mZ**4*pi**2*vT**2) - (8*mW**6*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*mZ**2*pi**2*vT**2) + (11*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) + (mW**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) - (2*mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*mZ**4*pi**2*vT**2) + (8*mW**6*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*mZ**2*pi**2*vT**2) - (11*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) - (mW**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) - (2*mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*mZ**4*pi**2*vT**2) - (8*mW**6*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*mZ**2*pi**2*vT**2) + (11*mW**4*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (19*g1bar*mt*mW**4*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*sqrt(2)*mZ**4*pi**2*vT) + (13*g1bar*mt*mW**2*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*mZ**2*pi**2*vT) - (19*g1bar*mt*mW**4*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*sqrt(2)*mZ**4*pi**2*vT) + (13*g1bar*mt*mW**2*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*mZ**2*pi**2*vT) - (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*mH**2*mZ**2*pi**2*vT) - (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (5*mt*mW*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*pi**2*vT**2) - (103*mt*mW**3*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*sqrt(2)*mZ**2*pi**2*vT**2) + (5*mt*mW*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*pi**2*vT**2) - (103*mt*mW**3*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*sqrt(2)*mZ**2*pi**2*vT**2) - (3*mW**2*einsum("prst",C["lq3"])*log(scale**2/mW**2))/(2.*pi**2*vT**2) - (5*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(72.*pi**2*vT**4) - (mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(4.*mH**2*pi**2*vT**4) - (28*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mZ**6*pi**2*vT**4) + (245*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(18.*mZ**4*pi**2*vT**4) - (2*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**4*pi**2*vT**4) - (23*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mZ**2*pi**2*vT**4) + (3*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*mZ**2*pi**2*vT**4) + (8*mW**10*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**6*pi**2*vT**2) - (11*mW**8*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**4*pi**2*vT**2) + (3*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**2*pi**2*vT**2) - (mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*pi**2*vT**2) - (4*mW**8*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**4*pi**2*vT**2) + (3*mW**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**2*pi**2*vT**2) + (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(8.*mH**2*pi**2*vT**2) - (28*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mZ**6*pi**2*vT**2) + (259*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(36.*mZ**4*pi**2*vT**2) - (mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**4*pi**2*vT**2) - (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mZ**2*pi**2*vT**2) - (mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*pi**2*vT**2) - (8*mW**10*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**6*pi**2*vT**2) + (7*mW**8*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**4*pi**2*vT**2) - (44*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mZ**6*pi**2*vT) - (4*g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**6*pi**2*vT) + (149*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(12.*mZ**4*pi**2*vT) + (3*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*mZ**4*pi**2*vT) - (95*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(72.*mZ**2*pi**2*vT) + (3*mW**3*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*pi**2*vT**3) - (48*mW**9*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mZ**6*pi**2*vT**3) + (70*mW**7*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mZ**4*pi**2*vT**3) - (47*mW**5*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mZ**2*pi**2*vT**3) - (7*mW**6*einsum("pr,st",C["phil1"],kd)*log(scale**2/mW**2))/(3.*mZ**4*pi**2*vT**2) + (7*mW**4*einsum("pr,st",C["phil1"],kd)*log(scale**2/mW**2))/(3.*mZ**2*pi**2*vT**2) - (5*mW**2*einsum("pr,st",C["phil3"],kd)*log(scale**2/mW**2))/(36.*pi**2*vT**2) - (7*mW**6*einsum("pr,st",C["phil3"],kd)*log(scale**2/mW**2))/(3.*mZ**4*pi**2*vT**2) + (29*mW**4*einsum("pr,st",C["phil3"],kd)*log(scale**2/mW**2))/(9.*mZ**2*pi**2*vT**2) + (7*mW**6*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mW**2))/(2.*mZ**4*pi**2*vT**2) - (7*mW**4*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mW**2))/(2.*mZ**2*pi**2*vT**2) - (29*mW**2*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mW**2))/(36.*pi**2*vT**2) - (7*mW**6*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mW**2))/(2.*mZ**4*pi**2*vT**2) + (91*mW**4*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mW**2))/(18.*mZ**2*pi**2*vT**2) - (3*mW**2*einsum("prst",C["lq1"])*log(scale**2/mZ**2))/(4.*pi**2*vT**2) + (mW**4*einsum("prst",C["lq1"])*log(scale**2/mZ**2))/(mZ**2*pi**2*vT**2) + (mZ**2*einsum("prst",C["lq1"])*log(scale**2/mZ**2))/(8.*pi**2*vT**2) + (3*mW**2*einsum("prst",C["lq3"])*log(scale**2/mZ**2))/(4.*pi**2*vT**2) - (mW**4*einsum("prst",C["lq3"])*log(scale**2/mZ**2))/(mZ**2*pi**2*vT**2) - (mZ**2*einsum("prst",C["lq3"])*log(scale**2/mZ**2))/(8.*pi**2*vT**2) - (17*mH**2*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (19*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (164*mH**2*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**4) - (94*mH**2*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(27.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) - (164*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) + (5*mH**2*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) + (94*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(27.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) + (865*mW**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(648.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mW**4*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (3*mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (3*mW**2*mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mZ**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (9*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (40*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (6*mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (13*mH**2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (119*mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (6*mW**6*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mH**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (7*mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (9*mW**4*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mZ**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (13*mW**2*mZ**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mZ**8*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (3*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)*(mH + mZ)*pi**2*vT**2) + (9*mW**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mW**4*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mW**2*mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mZ**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (17*mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(162.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (164*mH**2*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (47*mH**2*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(27.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (164*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (47*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(27.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (593*mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(1296.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**4*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mW**2*mZ**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (7*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (40*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (6*mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (7*mH**2*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (95*mW**4*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (6*mW**6*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (4*mW**2*mZ**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (7*mW**4*mZ**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (7*mW**2*mZ**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (71*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (199*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (328*g1bar*mH**4*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT) - (341*g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) - (656*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) + (76*g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (439*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (328*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**2*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (695*g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(324.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (3*g1bar*mW**5*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (3*g1bar*mW*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (3*g1bar*mW**3*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mW*mZ**6*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (mW**2*einsum("pr,st",C["phil1"],kd)*log(scale**2/mZ**2))/(9.*pi**2*vT**2) + (8*mW**6*einsum("pr,st",C["phil1"],kd)*log(scale**2/mZ**2))/(9.*mZ**4*pi**2*vT**2) - (mW**4*einsum("pr,st",C["phil1"],kd)*log(scale**2/mZ**2))/(mZ**2*pi**2*vT**2) + (mW**2*einsum("pr,st",C["phil3"],kd)*log(scale**2/mZ**2))/(9.*pi**2*vT**2) + (8*mW**6*einsum("pr,st",C["phil3"],kd)*log(scale**2/mZ**2))/(9.*mZ**4*pi**2*vT**2) - (mW**4*einsum("pr,st",C["phil3"],kd)*log(scale**2/mZ**2))/(mZ**2*pi**2*vT**2) - (25*mW**2*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mZ**2))/(27.*pi**2*vT**2) - (46*mW**6*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mZ**2))/(27.*mZ**4*pi**2*vT**2) + (71*mW**4*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mZ**2))/(27.*mZ**2*pi**2*vT**2) + (25*mW**2*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mZ**2))/(27.*pi**2*vT**2) + (46*mW**6*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mZ**2))/(27.*mZ**4*pi**2*vT**2) - (71*mW**4*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mZ**2))/(27.*mZ**2*pi**2*vT**2) + (2*g1bar*mW**6*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*sqrt(2))/(27.*mt*mZ**4*pi**2*vT) - (2*g1bar*mW**4*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*sqrt(2))/(27.*mt*mZ**2*pi**2*vT) + (2*g1bar*mW**6*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*sqrt(2))/(27.*mt*mZ**4*pi**2*vT) - (2*g1bar*mW**4*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*sqrt(2))/(27.*mt*mZ**2*pi**2*vT) - (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*sqrt(2))/(3.*mH**2*mZ**4*pi**2*vT) - (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*sqrt(2))/(3.*mH**2*mZ**4*pi**2*vT) - (4*mW**3*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(27.*mt*pi**2*vT**2) - (4*mW**7*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(27.*mt*mZ**4*pi**2*vT**2) + (8*mW**5*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(27.*mt*mZ**2*pi**2*vT**2) - (4*mW**3*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(27.*mt*pi**2*vT**2) - (4*mW**7*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(27.*mt*mZ**4*pi**2*vT**2) + (8*mW**5*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(27.*mt*mZ**2*pi**2*vT**2) + (8*g1bar*mt*mW**6*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*mZ**6*pi**2*vT) + (8*g1bar*mt*mW**6*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*mZ**6*pi**2*vT) - (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(3.*mH**2*mZ**4*pi**2*vT) - (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(3.*mH**2*mZ**4*pi**2*vT) - (16*mt*mW**7*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*mZ**6*pi**2*vT**2) + (3*mt*mW**5*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(mZ**4*pi**2*vT**2) - (16*mt*mW**7*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*mZ**6*pi**2*vT**2) + (3*mt*mW**5*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(mZ**4*pi**2*vT**2))
    c['VnudLL'] = ((5*mW**2*einsum("prst",C["lq1"]))/(8.*pi**2*vT**2) - (bEvan*mW**2*einsum("prst",C["lq1"]))/(6.*pi**2*vT**2) + (5*mZ**2*einsum("prst",C["lq1"]))/(16.*pi**2*vT**2) - (bEvan*mZ**2*einsum("prst",C["lq1"]))/(12.*pi**2*vT**2) - (31*mW**2*einsum("prst",C["lq3"]))/(8.*pi**2*vT**2) + (2*bEvan*mW**2*einsum("prst",C["lq3"]))/(3.*pi**2*vT**2) - (5*mZ**2*einsum("prst",C["lq3"]))/(16.*pi**2*vT**2) + (bEvan*mZ**2*einsum("prst",C["lq3"]))/(12.*pi**2*vT**2) - (7*mH**2*einsum("pr,st",kd,kd))/(96.*pi**2*vT**4) + (205*mW**2*einsum("pr,st",kd,kd))/(144.*pi**2*vT**4) - (mW**4*einsum("pr,st",kd,kd))/(12.*mH**2*pi**2*vT**4) - (mW**6*einsum("pr,st",kd,kd))/(9.*mZ**4*pi**2*vT**4) - (7*mH**2*mW**2*einsum("pr,st",kd,kd))/(48.*mZ**2*pi**2*vT**4) - (mW**4*einsum("pr,st",kd,kd))/(6.*mZ**2*pi**2*vT**4) - (mW**6*einsum("pr,st",kd,kd))/(6.*mH**2*mZ**2*pi**2*vT**4) + (7*mZ**2*einsum("pr,st",kd,kd))/(96.*pi**2*vT**4) - (mW**2*mZ**2*einsum("pr,st",kd,kd))/(12.*mH**2*pi**2*vT**4) - (mZ**4*einsum("pr,st",kd,kd))/(24.*mH**2*pi**2*vT**4) + (mt**4*Nc*einsum("pr,st",kd,kd))/(6.*mH**2*pi**2*vT**4) + (mt**4*mW**2*Nc*einsum("pr,st",kd,kd))/(3.*mH**2*mZ**2*pi**2*vT**4) + (C["phi"]*einsum("pr,st",kd,kd))/(8.*pi**2) + (mW**2*C["phi"]*einsum("pr,st",kd,kd))/(4.*mZ**2*pi**2) + (mH**2*mW**2*C["phiB"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (7*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**2*C["phiB"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(2.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mZ**6*C["phiB"]*einsum("pr,st",kd,kd))/(12.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (2*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (2*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (2*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (11*mH**2*C["phiBox"]*einsum("pr,st",kd,kd))/(48.*pi**2*vT**2) + (5*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(24.*pi**2*vT**2) - (mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(6.*mH**2*pi**2*vT**2) - (11*mH**2*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(24.*mZ**2*pi**2*vT**2) - (mW**6*C["phiBox"]*einsum("pr,st",kd,kd))/(3.*mH**2*mZ**2*pi**2*vT**2) + (5*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(48.*pi**2*vT**2) - (mW**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(6.*mH**2*pi**2*vT**2) - (mZ**4*C["phiBox"]*einsum("pr,st",kd,kd))/(12.*mH**2*pi**2*vT**2) + (mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(3.*mH**2*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(3.*mH**2*mZ**2*pi**2*vT**2) + (mH**2*C["phiD"]*einsum("pr,st",kd,kd))/(12.*pi**2*vT**2) + (mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(96.*pi**2*vT**2) + (mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(24.*mH**2*pi**2*vT**2) - (mW**6*C["phiD"]*einsum("pr,st",kd,kd))/(18.*mZ**4*pi**2*vT**2) + (3*mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(32.*mZ**2*pi**2*vT**2) - (13*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(72.*mZ**2*pi**2*vT**2) - (mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(48.*pi**2*vT**2) - (mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(24.*mH**2*pi**2*vT**2) - (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(12.*mH**2*pi**2*vT**2) - (mH**2*mW**2*C["phiW"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mW**8*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**2*C["phiW"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mW**8*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**4*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(2.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**2*mZ**4*C["phiW"]*einsum("pr,st",kd,kd))/(12.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (2*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (2*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (5*g1bar*mH**2*mW*C["phiWB"]*einsum("pr,st",kd,kd))/(48.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (17*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(72.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (g1bar*mH**4*mW*C["phiWB"]*einsum("pr,st",kd,kd))/(32.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (5*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(72.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(6.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (7*g1bar*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(96.*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(6.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mW*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd))/(24.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (mW**3*C["W"]*einsum("pr,st",kd,kd))/(2.*pi**2*vT**3) - (mW**5*C["W"]*einsum("pr,st",kd,kd))/(2.*mZ**2*pi**2*vT**3) - (mW**2*einsum("pr,st",C["phil1"],kd))/(6.*pi**2*vT**2) + (mW**6*einsum("pr,st",C["phil1"],kd))/(9.*mZ**4*pi**2*vT**2) - (5*mW**4*einsum("pr,st",C["phil1"],kd))/(18.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("pr,st",C["phil1"],kd))/(24.*pi**2*vT**2) + (199*mW**2*einsum("pr,st",C["phil3"],kd))/(72.*pi**2*vT**2) - (mW**6*einsum("pr,st",C["phil3"],kd))/(9.*mZ**4*pi**2*vT**2) - (7*mW**4*einsum("pr,st",C["phil3"],kd))/(36.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("pr,st",C["phil3"],kd))/(24.*pi**2*vT**2) + (mW**2*einsum("st,pr",C["phiq1"],kd))/(4.*pi**2*vT**2) + (mZ**2*einsum("st,pr",C["phiq1"],kd))/(8.*pi**2*vT**2) + (19*mW**2*einsum("st,pr",C["phiq3"],kd))/(8.*pi**2*vT**2) + (mZ**2*einsum("st,pr",C["phiq3"],kd))/(8.*pi**2*vT**2) - (3*mt**4*einsum("prsT,tT,TT",C["lq1"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("prsT,tT,TT",C["lq1"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt**4*einsum("prsT,tT,TT",C["lq3"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt**2*mW**2*einsum("prsT,tT,TT",C["lq3"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("prTt,sT,TT",C["lq1"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("prTt,sT,TT",C["lq1"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt**4*einsum("prTt,sT,TT",C["lq3"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt**2*mW**2*einsum("prTt,sT,TT",C["lq3"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(4.*pi**2*vT**2) + (mt**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(4.*pi**2*vT**2) - (mt**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/((8*mt**2 - 8*mW**2)*pi**2*vT**4) - (2*mt**2*mW**2*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/((8*mt**2 - 8*mW**2)*pi**2*vT**4) + (mt**4*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/((64*mt**2 - 64*mW**2)*pi**2*vT**2) - (7*mt**2*mW**2*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt))/((64*mt**2 - 64*mW**2)*pi**2*vT**2) + (mt**4*einsum("pr,sT,tT,TT",C["phil1"],kd,kd,kdt))/((32*mt**2 - 32*mW**2)*pi**2*vT**2) - (7*mt**2*mW**2*einsum("pr,sT,tT,TT",C["phil1"],kd,kd,kdt))/((32*mt**2 - 32*mW**2)*pi**2*vT**2) - (7*mt**4*einsum("pr,sT,tT,TT",C["phil3"],kd,kd,kdt))/(32.*(mt**2 - mW**2)*pi**2*vT**2) - (23*mt**2*mW**2*einsum("pr,sT,tT,TT",C["phil3"],kd,kd,kdt))/(32.*(mt**2 - mW**2)*pi**2*vT**2) + (mt**2*einsum("prTT,sT,tT,TT",C["lq1"],kd,kd,kdt))/(8.*pi**2*vT**2) + (mt**2*einsum("prTT,sT,tT,TT",C["lq3"],kd,kd,kdt))/(8.*pi**2*vT**2) - (mt**4*einsum("prTT,sT,tT,TT",C["lu"],kd,kd,kdt))/(32.*(mt**2 - mW**2)*pi**2*vT**2) + (7*mt**2*mW**2*einsum("prTT,sT,tT,TT",C["lu"],kd,kd,kdt))/(32.*(mt**2 - mW**2)*pi**2*vT**2) - (3*mt**4*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (5*mt**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (35*mt**2*mW**2*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**3*mW*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(4.*sqrt(2)*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt*mW**3*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt))/(2.*sqrt(2)*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**4*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (5*mt**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (35*mt**2*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**3*mW*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(4.*sqrt(2)*(mt - mW)*(mt + mW)*pi**2*vT**2) + (3*mt*mW**3*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(2.*sqrt(2)*(mt - mW)*(mt + mW)*pi**2*vT**2) - (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(12.*sqrt(2)*mH**2*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(6.*sqrt(2)*mH**2*mZ**2*pi**2*vT) - (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(12.*sqrt(2)*mH**2*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(6.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (mt**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiq1"],kdt))/(8.*pi**2*vT**2) - (mt**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiq3"],kdt))/(8.*pi**2*vT**2) - (mt**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(32.*(mt**2 - mW**2)*pi**2*vT**2) + (7*mt**2*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(32.*(mt**2 - mW**2)*pi**2*vT**2) - (mH**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mH**2*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (mH**4*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) + (mH**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*pi**2) + (mW**2*C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*mZ**2*pi**2) + (mH**4*mW**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mH**6*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) - (mH**6*mW**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (mH**2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (5*mH**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(24.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mH**2*mW**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (5*mH**4*mW**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mH**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(24.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (5*mH**4*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(48.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mH**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mH**6*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) + (mH**6*mW**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (mH**4*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (mH**2*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (g1bar*mH**4*mW*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**6*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**6*mW*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(48.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) - (mt**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(24.*pi**2*vT**4) + (mt**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(6.*mH**2*pi**2*vT**4) + (5*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*pi**2*vT**4) + (8*mW**6*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**4) - (mt**2*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**4) + (mt**4*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**2*pi**2*vT**4) - (13*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**4) - (2*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**4*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**2*pi**2*vT**2) + (mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**2*pi**2*vT**2) + (mt**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(24.*pi**2*vT**2) - (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(12.*mH**2*pi**2*vT**2) - (5*mW**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(162.*pi**2*vT**2) + (4*mW**6*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(24.*mZ**2*pi**2*vT**2) + (2*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**4*pi**2*vT**2) - (2*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**2*pi**2*vT**2) + (g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**4*pi**2*vT) + (4*g1bar*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT) - (g1bar*mt**2*mW*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(24.*mZ**2*pi**2*vT) - (g1bar*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT) + (mt**2*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(24.*pi**2*vT**2) - (5*mW**2*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) - (8*mW**6*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (5*mW**2*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) + (8*mW**6*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (13*mW**4*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(8.*pi**2*vT**2) - (mt**2*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(8.*pi**2*vT**2) - (mt**6*einsum("prsT,tT,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("prsT,tT,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("prsT,tT,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*einsum("prsT,tT,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (13*mt**4*mW**2*einsum("prsT,tT,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (7*mt**2*mW**4*einsum("prsT,tT,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("prTt,sT,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("prTt,sT,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("prTt,sT,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*einsum("prTt,sT,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (13*mt**4*mW**2*einsum("prTt,sT,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (7*mt**2*mW**4*einsum("prTt,sT,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("stTT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mt**2*Nc*einsum("stTT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mt**2*Nc*einsum("stTT,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) - (mt**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(4.*pi**2*vT**2) - (mt**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(4.*pi**2*vT**2) - (mt**2*Nc*einsum("TTst,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mt**2*Nc*einsum("TTst,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (3*mt**4*mW**2*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**4) - (3*mt**2*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**4) - (mt**6*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("pr,sT,tT,TT",C["phil1"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("pr,sT,tT,TT",C["phil1"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("pr,sT,tT,TT",C["phil1"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("pr,sT,tT,TT",C["phil3"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (7*mt**4*mW**2*einsum("pr,sT,tT,TT",C["phil3"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (7*mt**2*mW**4*einsum("pr,sT,tT,TT",C["phil3"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*einsum("prTT,sT,tT,TT",C["lu"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("prTT,sT,tT,TT",C["lu"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("prTT,sT,tT,TT",C["lu"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (7*mt**6*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (5*mt**2*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**3*mW**3*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (7*mt**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (5*mt**2*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**3*mW**3*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) + (mW**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) - (mW**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) + (mW**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (13*g1bar*mt*mW**2*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*sqrt(2)*mZ**2*pi**2*vT) - (13*g1bar*mt*mW**2*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*sqrt(2)*mZ**2*pi**2*vT) - (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*mH**2*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*mH**2*mZ**2*pi**2*vT) - (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*mH**2*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*mH**2*mZ**2*pi**2*vT) - (5*mt*mW*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*sqrt(2)*pi**2*vT**2) + (7*mt*mW**3*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*mZ**2*pi**2*vT**2) - (5*mt*mW*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*sqrt(2)*pi**2*vT**2) + (7*mt*mW**3*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*mZ**2*pi**2*vT**2) + (mt**6*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mW**2*einsum("prst",C["lq3"])*log(scale**2/mW**2))/(2.*pi**2*vT**2) + (mW**2*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(24.*pi**2*vT**4) - (mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(4.*mH**2*pi**2*vT**4) - (7*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mZ**4*pi**2*vT**4) + (3*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mZ**2*pi**2*vT**4) - (mW**6*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*mZ**2*pi**2*vT**4) + (mW**8*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**4*pi**2*vT**2) - (mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**2*pi**2*vT**2) - (mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*pi**2*vT**2) - (mW**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**2*pi**2*vT**2) + (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(8.*mH**2*pi**2*vT**2) - (7*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(12.*mZ**4*pi**2*vT**2) + (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mZ**2*pi**2*vT**2) - (mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*pi**2*vT**2) - (mW**8*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**4*pi**2*vT**2) - (5*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(4.*mZ**4*pi**2*vT) - (g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*mZ**4*pi**2*vT) + (5*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(8.*mZ**2*pi**2*vT) - (mW**3*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*pi**2*vT**3) - (6*mW**7*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mZ**4*pi**2*vT**3) + (13*mW**5*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mZ**2*pi**2*vT**3) + (7*mW**6*einsum("pr,st",C["phil1"],kd)*log(scale**2/mW**2))/(6.*mZ**4*pi**2*vT**2) - (7*mW**4*einsum("pr,st",C["phil1"],kd)*log(scale**2/mW**2))/(6.*mZ**2*pi**2*vT**2) + (mW**2*einsum("pr,st",C["phil3"],kd)*log(scale**2/mW**2))/(12.*pi**2*vT**2) - (7*mW**6*einsum("pr,st",C["phil3"],kd)*log(scale**2/mW**2))/(6.*mZ**4*pi**2*vT**2) + (11*mW**4*einsum("pr,st",C["phil3"],kd)*log(scale**2/mW**2))/(6.*mZ**2*pi**2*vT**2) + (3*mW**2*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mW**2))/(4.*pi**2*vT**2) + (3*mt**2*mW**4*einsum("prsT,tT,TT",C["lq1"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**4*mW**2*einsum("prsT,tT,TT",C["lq3"],kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (27*mt**2*mW**4*einsum("prsT,tT,TT",C["lq3"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("prTt,sT,TT",C["lq1"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**4*mW**2*einsum("prTt,sT,TT",C["lq3"],kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (27*mt**2*mW**4*einsum("prTt,sT,TT",C["lq3"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**4*mW**2*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**4) + (3*mt**2*mW**4*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**4) + (3*mt**2*mW**4*C["phiD"]*einsum("pr,sT,tT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("pr,sT,tT,TT",C["phil1"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**4*mW**2*einsum("pr,sT,tT,TT",C["phil3"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (27*mt**2*mW**4*einsum("pr,sT,tT,TT",C["phil3"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**2*mW**4*einsum("prTT,sT,tT,TT",C["lu"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("sT,pr,tT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**4*mW**2*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (27*mt**2*mW**4*einsum("sT,pr,tT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**3*mW**3*einsum("sT,pr,tT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**4*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (27*mt**2*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**3*mW**3*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**2*mW**4*einsum("pr,sT,tT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mW**2*einsum("prst",C["lq1"])*log(scale**2/mZ**2))/(4.*pi**2*vT**2) + (mZ**2*einsum("prst",C["lq1"])*log(scale**2/mZ**2))/(8.*pi**2*vT**2) - (mW**2*einsum("prst",C["lq3"])*log(scale**2/mZ**2))/(4.*pi**2*vT**2) - (mZ**2*einsum("prst",C["lq3"])*log(scale**2/mZ**2))/(8.*pi**2*vT**2) - (3*mW**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (3*mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mW**2*mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mZ**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (3*mH**2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (13*mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mH**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (5*mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mW**4*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mZ**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (3*mW**2*mZ**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mZ**8*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (3*mW**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**2*mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mZ**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**2*mZ**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mH**2*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (13*mW**4*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (2*mW**2*mZ**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mW**4*mZ**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mW**2*mZ**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (3*g1bar*mH**2*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (13*g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(12.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (13*g1bar*mW*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(48.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mW**3*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mW*mZ**6*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mt*mW**4*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*mZ**4*pi**2*vT) + (g1bar*mt*mW**4*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*mZ**4*pi**2*vT) - (2*mt*mW**5*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*mZ**4*pi**2*vT**2) - (2*mt*mW**5*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*mZ**4*pi**2*vT**2))
    c['VnueduLL'] = ((-15*mW**2*einsum("prst",C["lq1"]))/(8.*pi**2*vT**2) + (bEvan*mW**2*einsum("prst",C["lq1"]))/(2.*pi**2*vT**2) + (mW**2*einsum("prst",C["lq3"]))/(8.*pi**2*vT**2) + (bEvan*mW**2*einsum("prst",C["lq3"]))/(3.*pi**2*vT**2) + (2*mW**4*einsum("prst",C["lq3"]))/(mZ**2*pi**2*vT**2) - (bEvan*mW**4*einsum("prst",C["lq3"]))/(6.*mZ**2*pi**2*vT**2) + (5*mZ**2*einsum("prst",C["lq3"]))/(8.*pi**2*vT**2) - (bEvan*mZ**2*einsum("prst",C["lq3"]))/(6.*pi**2*vT**2) + (7*mH**2*einsum("pr,st",kd,kd))/(16.*pi**2*vT**4) + (11*mW**2*einsum("pr,st",kd,kd))/(8.*pi**2*vT**4) - (bEvan*mW**2*einsum("pr,st",kd,kd))/(6.*pi**2*vT**4) + (mW**4*einsum("pr,st",kd,kd))/(2.*mH**2*pi**2*vT**4) - (2*mW**4*einsum("pr,st",kd,kd))/(mZ**2*pi**2*vT**4) + (bEvan*mW**4*einsum("pr,st",kd,kd))/(6.*mZ**2*pi**2*vT**4) - (5*mZ**2*einsum("pr,st",kd,kd))/(16.*pi**2*vT**4) + (mZ**4*einsum("pr,st",kd,kd))/(4.*mH**2*pi**2*vT**4) + (mt**2*Nc*einsum("pr,st",kd,kd))/(8.*pi**2*vT**4) - (mt**4*Nc*einsum("pr,st",kd,kd))/(mH**2*pi**2*vT**4) - (3*C["phi"]*einsum("pr,st",kd,kd))/(4.*pi**2) - (mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(2.*mH**2*pi**2*vT**2) + (mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(2.*mH**2*pi**2*vT**2) + (11*mH**2*C["phiBox"]*einsum("pr,st",kd,kd))/(8.*pi**2*vT**2) - (5*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(8.*pi**2*vT**2) + (mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(mH**2*pi**2*vT**2) + (mZ**4*C["phiBox"]*einsum("pr,st",kd,kd))/(2.*mH**2*pi**2*vT**2) - (2*mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(mH**2*pi**2*vT**2) - (11*mH**2*C["phiD"]*einsum("pr,st",kd,kd))/(32.*pi**2*vT**2) + (mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(pi**2*vT**2) - (mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(4.*mH**2*pi**2*vT**2) - (mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(mZ**2*pi**2*vT**2) + (bEvan*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(12.*mZ**2*pi**2*vT**2) - (5*mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(32.*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(2.*mH**2*pi**2*vT**2) + (mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(mH**2*pi**2*vT**2) + (mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(2.*mH**2*pi**2*vT**2) + (3*g1bar*mW*C["phiWB"]*einsum("pr,st",kd,kd))/(4.*pi**2*vT) - (2*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(mZ**2*pi**2*vT) + (bEvan*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(6.*mZ**2*pi**2*vT) + (g1bar*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(4.*mH**2*pi**2*vT) + (3*g1bar*mW*complex(0,1)*C["phiWtildeB"]*einsum("pr,st",kd,kd))/(4.*pi**2*vT) - (3*mW**2*einsum("pr,st",C["phil3"],kd))/(4.*pi**2*vT**2) - (bEvan*mW**2*einsum("pr,st",C["phil3"],kd))/(6.*pi**2*vT**2) - (2*mW**4*einsum("pr,st",C["phil3"],kd))/(mZ**2*pi**2*vT**2) + (bEvan*mW**4*einsum("pr,st",C["phil3"],kd))/(6.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("pr,st",C["phil3"],kd))/(8.*pi**2*vT**2) - (3*mW**2*einsum("st,pr",C["phiq3"],kd))/(4.*pi**2*vT**2) - (bEvan*mW**2*einsum("st,pr",C["phiq3"],kd))/(6.*pi**2*vT**2) - (2*mW**4*einsum("st,pr",C["phiq3"],kd))/(mZ**2*pi**2*vT**2) + (bEvan*mW**4*einsum("st,pr",C["phiq3"],kd))/(6.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("st,pr",C["phiq3"],kd))/(8.*pi**2*vT**2) - (3*mt**4*einsum("prTt,sT,TT",C["lq3"],kd,kdt))/(32.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("prTt,sT,TT",C["lq3"],kd,kdt))/(32.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (mt**2*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt))/(8.*pi**2*vT**2) - (mt**2*Nc*einsum("stTT,pr,TT",C["qq3"],kd,kdt))/(8.*pi**2*vT**2) + (mt**2*einsum("sTTt,pr,TT",C["qq1"],kd,kdt))/(16.*pi**2*vT**2) - (mt**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(16.*pi**2*vT**2) + (mt**2*einsum("TtsT,pr,TT",C["qq1"],kd,kdt))/(16.*pi**2*vT**2) - (mt**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(16.*pi**2*vT**2) - (mt**2*Nc*einsum("TTst,pr,TT",C["qq3"],kd,kdt))/(8.*pi**2*vT**2) - (9*mt**2*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt))/(32.*pi**2*vT**2) - (5*mW**2*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt))/(12.*pi**2*vT**2) + (11*mZ**2*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt))/(48.*pi**2*vT**2) + (3*mt**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(32.*(mt**2 - mW**2)*pi**2*vT**2) + (103*mt**2*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(96.*(mt**2 - mW**2)*pi**2*vT**2) - (19*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(24.*(mt**2 - mW**2)*pi**2*vT**2) - (11*mt**2*mZ**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(48.*(mt**2 - mW**2)*pi**2*vT**2) + (11*mW**2*mZ**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt))/(48.*(mt**2 - mW**2)*pi**2*vT**2) - (7*g1bar*mt*einsum("Tt,pr,sT,TT",C["uBDag"],kd,kd,kdt))/(96.*sqrt(2)*pi**2*vT) + (g1bar*mW**2*einsum("Tt,pr,sT,TT",C["uBDag"],kd,kd,kdt))/(3.*sqrt(2)*mt*pi**2*vT) - (5*g1bar*mZ**2*einsum("Tt,pr,sT,TT",C["uBDag"],kd,kd,kdt))/(24.*sqrt(2)*mt*pi**2*vT) - (5*cf*g3bar*mt*einsum("Tt,pr,sT,TT",C["uGDag"],kd,kd,kdt))/(8.*sqrt(2)*pi**2*vT) + (7*mt*einsum("Tt,pr,sT,TT",C["uphiDag"],kd,kd,kdt))/(32.*sqrt(2)*pi**2*vT) - (mW**4*einsum("Tt,pr,sT,TT",C["uphiDag"],kd,kd,kdt))/(4.*sqrt(2)*mH**2*mt*pi**2*vT) - (mZ**4*einsum("Tt,pr,sT,TT",C["uphiDag"],kd,kd,kdt))/(8.*sqrt(2)*mH**2*mt*pi**2*vT) + (mt**3*Nc*einsum("Tt,pr,sT,TT",C["uphiDag"],kd,kd,kdt))/(2.*sqrt(2)*mH**2*pi**2*vT) + (3*mt**3*mW*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(4.*sqrt(2)*(mt - mW)*(mt + mW)*pi**2*vT**2) - (55*mt*mW**3*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(24.*sqrt(2)*(mt - mW)*(mt + mW)*pi**2*vT**2) + (7*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(6.*sqrt(2)*mt*(mt - mW)*(mt + mW)*pi**2*vT**2) + (5*mt*mW*mZ**2*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(12.*sqrt(2)*(mt - mW)*(mt + mW)*pi**2*vT**2) - (5*mW**3*mZ**2*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt))/(12.*sqrt(2)*mt*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt))/(4.*pi**2*vT**2) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(2.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(2.*sqrt(2)*mH**2*pi**2*vT) + (mt**2*einsum("TtTT,pr,sT,TT",C["qu1"],kd,kd,kdt))/(4.*pi**2*vT**2) + (cf*mt**2*einsum("TtTT,pr,sT,TT",C["qu8"],kd,kd,kdt))/(4.*pi**2*vT**2) + (3*mH**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*(mH**2 - mW**2)*pi**2*vT**4) - (3*mH**2*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH**2 - mW**2)*pi**2*vT**4) - (3*C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*pi**2) + (5*mH**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((4*mH**2 - 4*mW**2)*pi**2*vT**2) - (8*mH**2*mW**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((4*mH**2 - 4*mW**2)*pi**2*vT**2) - (5*mH**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(16.*(mH**2 - mW**2)*pi**2*vT**2) + (mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH**2 - mW**2)*pi**2*vT**2) + (3*mH**4*mt*einsum("Tt,pr,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mH**2))/(16.*sqrt(2)*(mH - mt)*(mH + mt)*(mH - mW)*(mH + mW)*pi**2*vT) - (3*mH**2*mt*mW**2*einsum("Tt,pr,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mH**2))/(8.*sqrt(2)*(mH - mt)*(mH + mt)*(mH - mW)*(mH + mW)*pi**2*vT) + (mt**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(4.*pi**2*vT**4) - (mt**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(mH**2*pi**2*vT**4) - (2*mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(mH**2*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(2.*mH**2*pi**2*vT**2) + (mt**2*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(4.*pi**2*vT**2) + (mt**2*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(4.*pi**2*vT**2) - (3*mt**2*mW**2*einsum("prTt,sT,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt**2 - mW**2)*pi**2*vT**2) - (mt**6*einsum("prTt,sT,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("prTt,sT,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(2.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (5*mt**2*mW**4*einsum("prTt,sT,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(4.*pi**2*vT**2) - (mt**2*Nc*einsum("stTT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(4.*pi**2*vT**2) - (mt**2*einsum("sTTt,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mt**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) - (mt**2*einsum("TtsT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mt**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) - (mt**2*Nc*einsum("TTst,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(4.*pi**2*vT**2) - (5*mt**6*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (3*mt**4*mW**2*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*pi**2*vT**2) - (mt**2*mW**4*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (5*mt**4*mZ**2*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*pi**2*vT**2) - (mt**2*mW**2*mZ**2*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*pi**2*vT**2) - (mt**8*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (mt**6*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (5*mt**4*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) - (mt**2*mW**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) - (mt**6*mZ**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (mt**4*mW**2*mZ**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) - (mt**2*mW**4*mZ**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) - (5*g1bar*mt**5*einsum("Tt,pr,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*pi**2*vT) - (g1bar*mt**3*mW**2*einsum("Tt,pr,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*pi**2*vT) + (g1bar*mt*mW**4*einsum("Tt,pr,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)*(mt + mW)*(mt - mZ)*(mt + mZ)*pi**2*vT) - (3*cf*g3bar*mt*einsum("Tt,pr,sT,TT",C["uGDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*pi**2*vT) - (3*mt**5*einsum("Tt,pr,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) + (3*mt**3*mW**2*einsum("Tt,pr,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) + (mt**5*Nc*einsum("Tt,pr,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) - (mt**7*Nc*einsum("Tt,pr,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*mH**2*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) - (mt**3*mW**2*Nc*einsum("Tt,pr,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) + (mt**5*mW**2*Nc*einsum("Tt,pr,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*mH**2*(mH - mt)*(mH + mt)*(mt - mW)*(mt + mW)*pi**2*vT) - (5*mt**5*mW**3*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) - (mt**3*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (mt*mW**7*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (5*mt**5*mW*mZ**2*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (mt**3*mW**3*mZ**2*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) - (mt*mW**5*mZ**2*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mt - mZ)*(mt + mZ)*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*pi**2*vT**2) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*mH**2*pi**2*vT) + (mt**2*einsum("TtTT,pr,sT,TT",C["qu1"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*pi**2*vT**2) + (cf*mt**2*einsum("TtTT,pr,sT,TT",C["qu8"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*pi**2*vT**2) - (3*mW**2*einsum("prst",C["lq1"])*log(scale**2/mW**2))/(4.*pi**2*vT**2) + (3*mW**2*einsum("prst",C["lq3"])*log(scale**2/mW**2))/(4.*pi**2*vT**2) - (3*mH**2*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(8.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**4) + (9*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(4.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**4) - (3*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**4) + (3*mH**2*mW**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(4.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**4) - (21*mW**4*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(8.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**4) + (3*mW**6*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**4) + (15*mH**2*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/((4*mH**4 - 4*mH**2*mW**2)*pi**2*vT**2) - (12*mW**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/((4*mH**4 - 4*mH**2*mW**2)*pi**2*vT**2) + (5*mH**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(16.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**2) - (5*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(4.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (3*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(4.*mH**2*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**2) - (mH**2*mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(8.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (17*mW**4*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(16.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**2) - (3*mW**6*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(4.*mH**2*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (3*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*pi**2*vT**2) + (mW**2*einsum("pr,st",C["phil1"],kd)*log(scale**2/mW**2))/(4.*pi**2*vT**2) - (3*mW**2*einsum("pr,st",C["phil3"],kd)*log(scale**2/mW**2))/(4.*pi**2*vT**2) - (3*mW**2*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mW**2))/(4.*pi**2*vT**2) - (3*mW**2*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mW**2))/(4.*pi**2*vT**2) + (3*mt**2*mW**2*einsum("prTt,sT,TT",C["lq1"],kd,kdt)*log(scale**2/mW**2))/(8.*(mt**2 - mW**2)*pi**2*vT**2) - (3*mt**4*mW**2*einsum("prTt,sT,TT",C["lq3"],kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (9*mt**2*mW**4*einsum("prTt,sT,TT",C["lq3"],kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)*(mt + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**2) - (3*mt**2*mW**2*mZ**2*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)*(mt + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (mt**6*mW**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) - (7*mt**4*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) - (mt**2*mW**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) - (mt**6*mZ**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (5*mt**4*mW**2*mZ**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) - (mt**2*mW**4*mZ**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (3*g1bar*mt*mW**4*einsum("Tt,pr,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mt - mW)*(mt + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT) - (15*mt*mW**4*einsum("Tt,pr,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*sqrt(2)*(mH - mW)*(mt - mW)*(mH + mW)*(mt + mW)*pi**2*vT) + (3*mW**6*einsum("Tt,pr,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*mt*(mH - mW)*(mt - mW)*(mH + mW)*(mt + mW)*pi**2*vT) + (3*mt*mW**6*einsum("Tt,pr,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*mH**2*(mH - mW)*(mt - mW)*(mH + mW)*(mt + mW)*pi**2*vT) - (3*mW**8*einsum("Tt,pr,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*mH**2*mt*(mH - mW)*(mt - mW)*(mH + mW)*(mt + mW)*pi**2*vT) - (3*mt**3*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (9*mt*mW**7*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) - (3*mW**9*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*mt*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) - (15*mt*mW**5*mZ**2*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (3*mW**7*mZ**2*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*mt*(mt - mW)**2*(mt + mW)**2*(mW - mZ)*(mW + mZ)*pi**2*vT**2) - (mW**2*einsum("prst",C["lq3"])*log(scale**2/mZ**2))/(2.*pi**2*vT**2) + (mW**4*einsum("prst",C["lq3"])*log(scale**2/mZ**2))/(mZ**2*pi**2*vT**2) + (mZ**2*einsum("prst",C["lq3"])*log(scale**2/mZ**2))/(4.*pi**2*vT**2) + (2*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mW - mZ)*(mW + mZ)*pi**2*vT**4) - (mW**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mW - mZ)*mZ**2*(mW + mZ)*pi**2*vT**4) - (7*mW**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mW - mZ)*(mW + mZ)*pi**2*vT**4) + (3*mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*(mW - mZ)*(mW + mZ)*pi**2*vT**4) + (3*mW**2*mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mW - mZ)*(mW + mZ)*pi**2*vT**4) - (3*mZ**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mW - mZ)*(mW + mZ)*pi**2*vT**4) - (3*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*pi**2*vT**2) + (3*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*pi**2*vT**2) + (3*mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*pi**2*vT**2) - (3*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(-mW**2 + mZ**2)*pi**2*vT**2) + (mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*mZ**2*(-mW**2 + mZ**2)*pi**2*vT**2) + (5*mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*(-mW**2 + mZ**2)*pi**2*vT**2) - (3*mZ**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*(-mW**2 + mZ**2)*pi**2*vT**2) + (3*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*pi**2*vT**2) - (g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mZ**2*pi**2*vT) + (3*g1bar*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*pi**2*vT) + (g1bar*mW*complex(0,1)*C["phiWtildeB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*pi**2*vT) - (mW**2*einsum("pr,st",C["phil1"],kd)*log(scale**2/mZ**2))/(4.*pi**2*vT**2) + (mW**2*einsum("pr,st",C["phil3"],kd)*log(scale**2/mZ**2))/(4.*pi**2*vT**2) - (mW**4*einsum("pr,st",C["phil3"],kd)*log(scale**2/mZ**2))/(mZ**2*pi**2*vT**2) + (3*mW**2*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mZ**2))/(4.*pi**2*vT**2) + (mW**2*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mZ**2))/(4.*pi**2*vT**2) - (mW**4*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mZ**2))/(mZ**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (9*mt**2*mW**2*mZ**2*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/(8.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (mW**4*mZ**2*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) + (3*mt**2*mZ**4*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/(16.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) + (mW**2*mZ**4*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/((mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (mZ**6*einsum("Tt,pr,sT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (3*mt**2*mW**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) + (9*mt**2*mW**2*mZ**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/(8.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) + (mW**4*mZ**2*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (3*mt**2*mZ**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/(16.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (mW**2*mZ**4*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/((mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) + (mZ**6*einsum("Tt,pr,sT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (5*g1bar*mt*mW**4*einsum("Tt,pr,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT) + (7*g1bar*mt*mW**2*mZ**2*einsum("Tt,pr,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT) + (g1bar*mW**4*mZ**2*einsum("Tt,pr,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(sqrt(2)*mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT) - (5*g1bar*mt*mZ**4*einsum("Tt,pr,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(16.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT) - (13*g1bar*mW**2*mZ**4*einsum("Tt,pr,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(8.*sqrt(2)*mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT) + (5*g1bar*mZ**6*einsum("Tt,pr,sT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(8.*sqrt(2)*mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT) - (3*mZ**4*einsum("Tt,pr,sT,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(8.*sqrt(2)*mH**2*mt*pi**2*vT) + (5*mt*mW**5*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (7*mt*mW**3*mZ**2*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(2.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) + (5*mt*mW*mZ**4*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(8.*sqrt(2)*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) + (13*mW**3*mZ**4*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*sqrt(2)*mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (5*mW*mZ**6*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mZ**2))/(4.*sqrt(2)*mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2) - (mW**5*mZ**2*einsum("Tt,pr,sT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mZ**2)*sqrt(2))/(mt*(mt - mZ)*(mt + mZ)*(-mW + mZ)*(mW + mZ)*pi**2*vT**2))
    c['VnueLL'] = ((15*mW**2*einsum("prst",C["ll"]))/(8.*pi**2*vT**2) - (bEvan*mW**2*einsum("prst",C["ll"]))/(2.*pi**2*vT**2) - (15*mZ**2*einsum("prst",C["ll"]))/(16.*pi**2*vT**2) + (bEvan*mZ**2*einsum("prst",C["ll"]))/(4.*pi**2*vT**2) - (15*mW**2*einsum("ptsr",C["ll"]))/(8.*pi**2*vT**2) + (bEvan*mW**2*einsum("ptsr",C["ll"]))/(2.*pi**2*vT**2) - (15*mW**2*einsum("srpt",C["ll"]))/(8.*pi**2*vT**2) + (bEvan*mW**2*einsum("srpt",C["ll"]))/(2.*pi**2*vT**2) + (15*mW**2*einsum("stpr",C["ll"]))/(8.*pi**2*vT**2) - (bEvan*mW**2*einsum("stpr",C["ll"]))/(2.*pi**2*vT**2) - (15*mZ**2*einsum("stpr",C["ll"]))/(16.*pi**2*vT**2) + (bEvan*mZ**2*einsum("stpr",C["ll"]))/(4.*pi**2*vT**2) + (7*mH**2*einsum("pr,st",kd,kd))/(32.*pi**2*vT**4) + (73*mW**2*einsum("pr,st",kd,kd))/(48.*pi**2*vT**4) + (mW**4*einsum("pr,st",kd,kd))/(4.*mH**2*pi**2*vT**4) - (mW**6*einsum("pr,st",kd,kd))/(3.*mZ**4*pi**2*vT**4) - (7*mH**2*mW**2*einsum("pr,st",kd,kd))/(16.*mZ**2*pi**2*vT**4) - (mW**6*einsum("pr,st",kd,kd))/(2.*mH**2*mZ**2*pi**2*vT**4) + (mZ**2*einsum("pr,st",kd,kd))/(32.*pi**2*vT**4) - (mW**2*mZ**2*einsum("pr,st",kd,kd))/(4.*mH**2*pi**2*vT**4) + (mZ**4*einsum("pr,st",kd,kd))/(8.*mH**2*pi**2*vT**4) - (mt**4*Nc*einsum("pr,st",kd,kd))/(2.*mH**2*pi**2*vT**4) + (mt**4*mW**2*Nc*einsum("pr,st",kd,kd))/(mH**2*mZ**2*pi**2*vT**4) - (3*C["phi"]*einsum("pr,st",kd,kd))/(8.*pi**2) + (3*mW**2*C["phi"]*einsum("pr,st",kd,kd))/(4.*mZ**2*pi**2) + (3*mH**2*mW**2*C["phiB"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (7*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(2.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (mW**8*C["phiB"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**2*C["phiB"]*einsum("pr,st",kd,kd))/(2.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (3*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mW**6*C["phiB"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/((mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (5*mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mZ**6*C["phiB"]*einsum("pr,st",kd,kd))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (2*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (2*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (2*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (11*mH**2*C["phiBox"]*einsum("pr,st",kd,kd))/(16.*pi**2*vT**2) + (5*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(8.*pi**2*vT**2) + (mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(2.*mH**2*pi**2*vT**2) - (11*mH**2*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(8.*mZ**2*pi**2*vT**2) - (mW**6*C["phiBox"]*einsum("pr,st",kd,kd))/(mH**2*mZ**2*pi**2*vT**2) - (5*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(16.*pi**2*vT**2) - (mW**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(2.*mH**2*pi**2*vT**2) + (mZ**4*C["phiBox"]*einsum("pr,st",kd,kd))/(4.*mH**2*pi**2*vT**2) - (mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(mH**2*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(mH**2*mZ**2*pi**2*vT**2) - (mH**2*C["phiD"]*einsum("pr,st",kd,kd))/(4.*pi**2*vT**2) + (17*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(32.*pi**2*vT**2) - (mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(8.*mH**2*pi**2*vT**2) - (mW**6*C["phiD"]*einsum("pr,st",kd,kd))/(6.*mZ**4*pi**2*vT**2) + (9*mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(32.*mZ**2*pi**2*vT**2) - (13*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(24.*mZ**2*pi**2*vT**2) - (3*mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(16.*pi**2*vT**2) - (mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(8.*mH**2*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(4.*mH**2*pi**2*vT**2) - (3*mH**2*mW**2*C["phiW"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (5*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(2.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mW**8*C["phiW"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**2*C["phiW"]*einsum("pr,st",kd,kd))/(2.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (3*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mW**8*C["phiW"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (3*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(2.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**4*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(2.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mW**2*mZ**4*C["phiW"]*einsum("pr,st",kd,kd))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (2*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (2*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (3*g1bar*mH**2*mW*C["phiWB"]*einsum("pr,st",kd,kd))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (29*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(24.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(2.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (3*g1bar*mH**4*mW*C["phiWB"]*einsum("pr,st",kd,kd))/(32.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (17*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(24.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(2.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (17*g1bar*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(32.*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(2.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) - (g1bar*mW*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd))/(8.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (3*mW**3*C["W"]*einsum("pr,st",kd,kd))/(2.*pi**2*vT**3) - (3*mW**5*C["W"]*einsum("pr,st",kd,kd))/(2.*mZ**2*pi**2*vT**3) + (3*mW**2*einsum("pr,st",C["phil1"],kd))/(2.*pi**2*vT**2) + (mW**6*einsum("pr,st",C["phil1"],kd))/(3.*mZ**4*pi**2*vT**2) - (11*mW**4*einsum("pr,st",C["phil1"],kd))/(6.*mZ**2*pi**2*vT**2) - (3*mZ**2*einsum("pr,st",C["phil1"],kd))/(8.*pi**2*vT**2) + (49*mW**2*einsum("pr,st",C["phil3"],kd))/(24.*pi**2*vT**2) - (mW**6*einsum("pr,st",C["phil3"],kd))/(3.*mZ**4*pi**2*vT**2) + (5*mW**4*einsum("pr,st",C["phil3"],kd))/(12.*mZ**2*pi**2*vT**2) + (3*mZ**2*einsum("pr,st",C["phil3"],kd))/(8.*pi**2*vT**2) + (7*mH**2*einsum("pt,sr",kd,kd))/(16.*pi**2*vT**4) - (9*mW**2*einsum("pt,sr",kd,kd))/(8.*pi**2*vT**4) + (bEvan*mW**2*einsum("pt,sr",kd,kd))/(2.*pi**2*vT**4) + (mW**4*einsum("pt,sr",kd,kd))/(2.*mH**2*pi**2*vT**4) + (mW**4*einsum("pt,sr",kd,kd))/(2.*mZ**2*pi**2*vT**4) - (bEvan*mW**4*einsum("pt,sr",kd,kd))/(2.*mZ**2*pi**2*vT**4) - (5*mZ**2*einsum("pt,sr",kd,kd))/(16.*pi**2*vT**4) + (mZ**4*einsum("pt,sr",kd,kd))/(4.*mH**2*pi**2*vT**4) + (mt**2*Nc*einsum("pt,sr",kd,kd))/(8.*pi**2*vT**4) - (mt**4*Nc*einsum("pt,sr",kd,kd))/(mH**2*pi**2*vT**4) - (3*C["phi"]*einsum("pt,sr",kd,kd))/(4.*pi**2) - (mW**2*mZ**2*C["phiB"]*einsum("pt,sr",kd,kd))/(2.*mH**2*pi**2*vT**2) + (mZ**4*C["phiB"]*einsum("pt,sr",kd,kd))/(2.*mH**2*pi**2*vT**2) + (11*mH**2*C["phiBox"]*einsum("pt,sr",kd,kd))/(8.*pi**2*vT**2) - (5*mW**2*C["phiBox"]*einsum("pt,sr",kd,kd))/(8.*pi**2*vT**2) + (mW**4*C["phiBox"]*einsum("pt,sr",kd,kd))/(mH**2*pi**2*vT**2) + (mZ**4*C["phiBox"]*einsum("pt,sr",kd,kd))/(2.*mH**2*pi**2*vT**2) - (2*mt**4*Nc*C["phiBox"]*einsum("pt,sr",kd,kd))/(mH**2*pi**2*vT**2) - (11*mH**2*C["phiD"]*einsum("pt,sr",kd,kd))/(32.*pi**2*vT**2) + (mW**2*C["phiD"]*einsum("pt,sr",kd,kd))/(pi**2*vT**2) - (mW**4*C["phiD"]*einsum("pt,sr",kd,kd))/(4.*mH**2*pi**2*vT**2) + (mW**4*C["phiD"]*einsum("pt,sr",kd,kd))/(4.*mZ**2*pi**2*vT**2) - (bEvan*mW**4*C["phiD"]*einsum("pt,sr",kd,kd))/(4.*mZ**2*pi**2*vT**2) - (5*mZ**2*C["phiD"]*einsum("pt,sr",kd,kd))/(32.*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pt,sr",kd,kd))/(2.*mH**2*pi**2*vT**2) + (mW**4*C["phiW"]*einsum("pt,sr",kd,kd))/(mH**2*pi**2*vT**2) + (mW**2*mZ**2*C["phiW"]*einsum("pt,sr",kd,kd))/(2.*mH**2*pi**2*vT**2) + (3*g1bar*mW*C["phiWB"]*einsum("pt,sr",kd,kd))/(4.*pi**2*vT) + (g1bar*mW**3*C["phiWB"]*einsum("pt,sr",kd,kd))/(2.*mZ**2*pi**2*vT) - (bEvan*g1bar*mW**3*C["phiWB"]*einsum("pt,sr",kd,kd))/(2.*mZ**2*pi**2*vT) + (g1bar*mW*mZ**2*C["phiWB"]*einsum("pt,sr",kd,kd))/(4.*mH**2*pi**2*vT) - (13*mW**2*einsum("pt,sr",C["phil3"],kd))/(4.*pi**2*vT**2) + (bEvan*mW**2*einsum("pt,sr",C["phil3"],kd))/(2.*pi**2*vT**2) + (mW**4*einsum("pt,sr",C["phil3"],kd))/(2.*mZ**2*pi**2*vT**2) - (bEvan*mW**4*einsum("pt,sr",C["phil3"],kd))/(2.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("pt,sr",C["phil3"],kd))/(8.*pi**2*vT**2) - (13*mW**2*einsum("sr,pt",C["phil3"],kd))/(4.*pi**2*vT**2) + (bEvan*mW**2*einsum("sr,pt",C["phil3"],kd))/(2.*pi**2*vT**2) + (mW**4*einsum("sr,pt",C["phil3"],kd))/(2.*mZ**2*pi**2*vT**2) - (bEvan*mW**4*einsum("sr,pt",C["phil3"],kd))/(2.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("sr,pt",C["phil3"],kd))/(8.*pi**2*vT**2) + (3*mW**2*einsum("st,pr",C["phil1"],kd))/(4.*pi**2*vT**2) - (3*mZ**2*einsum("st,pr",C["phil1"],kd))/(8.*pi**2*vT**2) + (23*mW**2*einsum("st,pr",C["phil3"],kd))/(8.*pi**2*vT**2) - (3*mZ**2*einsum("st,pr",C["phil3"],kd))/(8.*pi**2*vT**2) - (mt**2*Nc*einsum("ptTT,sr,TT",C["lq3"],kd,kdt))/(8.*pi**2*vT**2) - (mt**2*Nc*einsum("srTT,pt,TT",C["lq3"],kd,kdt))/(8.*pi**2*vT**2) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(4.*sqrt(2)*mH**2*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(2.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(4.*sqrt(2)*mH**2*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(2.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (mt**2*Nc*einsum("TT,pt,sr,TT",C["phiq3"],kd,kd,kdt))/(4.*pi**2*vT**2) + (mt**3*Nc*einsum("TT,pt,sr,TT",C["uphi"],kd,kd,kdt))/(2.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pt,sr,TT",C["uphiDag"],kd,kd,kdt))/(2.*sqrt(2)*mH**2*pi**2*vT) + (3*mH**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (3*mH**2*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (3*mH**4*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) - (3*mH**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (3*C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*pi**2) + (3*mW**2*C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*mZ**2*pi**2) + (3*mH**4*mW**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (3*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mH**6*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) - (mH**6*mW**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (3*mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (3*mH**2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (5*mH**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mH**2*mW**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)*(mH + mZ)*pi**2*vT**2) - (5*mH**4*mW**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mH**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (5*mH**4*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mH**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mH**4*mW**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (3*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mH**6*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) + (mH**6*mW**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (3*mH**4*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (3*mH**2*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (3*g1bar*mH**4*mW*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (3*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**6*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**6*mW*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (3*g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (3*mH**4*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(8.*(mH**2 - mW**2)*pi**2*vT**4) - (3*mH**2*mW**2*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(4.*(mH**2 - mW**2)*pi**2*vT**4) - (3*C["phi"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(4.*pi**2) + (5*mH**4*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/((4*mH**2 - 4*mW**2)*pi**2*vT**2) - (8*mH**2*mW**2*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/((4*mH**2 - 4*mW**2)*pi**2*vT**2) - (5*mH**4*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(16.*(mH**2 - mW**2)*pi**2*vT**2) + (mH**2*mW**2*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(2.*(mH**2 - mW**2)*pi**2*vT**2) + (mt**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(8.*pi**2*vT**4) - (mt**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(2.*mH**2*pi**2*vT**4) + (5*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(27.*pi**2*vT**4) + (8*mW**6*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**4) - (mt**2*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**4) + (mt**4*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**2*pi**2*vT**4) - (13*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**4) - (2*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**4*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**2*pi**2*vT**2) - (mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(mH**2*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**2*pi**2*vT**2) - (mt**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(4.*mH**2*pi**2*vT**2) - (5*mW**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(54.*pi**2*vT**2) + (4*mW**6*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(8.*mZ**2*pi**2*vT**2) + (2*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**4*pi**2*vT**2) - (2*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**2*pi**2*vT**2) + (g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(mH**2*mZ**4*pi**2*vT) + (4*g1bar*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT) - (g1bar*mt**2*mW*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(8.*mZ**2*pi**2*vT) - (g1bar*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mZ**2*pi**2*vT) - (mt**2*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(8.*pi**2*vT**2) - (5*mW**2*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (8*mW**6*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (5*mW**2*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (8*mW**6*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) - (13*mW**4*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(4.*pi**2*vT**4) - (mt**4*Nc*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(mH**2*pi**2*vT**4) - (2*mt**4*Nc*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(mH**2*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(2.*mH**2*pi**2*vT**2) + (mt**2*Nc*einsum("pt,sr",C["phil3"],kd)*log(scale**2/mt**2))/(4.*pi**2*vT**2) + (mt**2*Nc*einsum("sr,pt",C["phil3"],kd)*log(scale**2/mt**2))/(4.*pi**2*vT**2) - (mt**2*Nc*einsum("st,pr",C["phil1"],kd)*log(scale**2/mt**2))/(8.*pi**2*vT**2) - (mt**2*Nc*einsum("st,pr",C["phil3"],kd)*log(scale**2/mt**2))/(8.*pi**2*vT**2) - (mt**2*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mW**2*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mW**2*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mW**2*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(4.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("ptTT,sr,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(4.*pi**2*vT**2) - (mt**2*Nc*einsum("srTT,pt,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(4.*pi**2*vT**2) - (mt**2*Nc*einsum("stTT,pr,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mt**2*Nc*einsum("stTT,pr,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mt**2*Nc*einsum("stTT,pr,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) - (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*pi**2*vT**2) + (mW**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*pi**2*vT**2) - (mW**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*pi**2*vT**2) + (mW**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) - (13*g1bar*mt*mW**2*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*mZ**2*pi**2*vT) - (13*g1bar*mt*mW**2*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*mZ**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*mH**2*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*mH**2*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*mH**2*mZ**2*pi**2*vT) - (5*mt*mW*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*pi**2*vT**2) + (7*mt*mW**3*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*mZ**2*pi**2*vT**2) - (5*mt*mW*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*pi**2*vT**2) + (7*mt*mW**3*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*sqrt(2)*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pt,sr,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*pi**2*vT**2) + (mt**3*Nc*einsum("TT,pt,sr,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pt,sr,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*mH**2*pi**2*vT) - (3*mW**2*einsum("ptsr",C["ll"])*log(scale**2/mW**2))/(4.*pi**2*vT**2) - (3*mW**2*einsum("srpt",C["ll"])*log(scale**2/mW**2))/(4.*pi**2*vT**2) - (5*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(8.*pi**2*vT**4) + (3*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(4.*mH**2*pi**2*vT**4) - (7*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mZ**4*pi**2*vT**4) + (9*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mZ**2*pi**2*vT**4) - (3*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*mZ**2*pi**2*vT**4) + (3*mW**8*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**4*pi**2*vT**2) - (3*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**2*pi**2*vT**2) + (3*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*pi**2*vT**2) - (3*mW**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**2*pi**2*vT**2) - (3*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(8.*mH**2*pi**2*vT**2) - (7*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(4.*mZ**4*pi**2*vT**2) + (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mZ**2*pi**2*vT**2) + (3*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*pi**2*vT**2) - (3*mW**8*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**4*pi**2*vT**2) - (15*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(4.*mZ**4*pi**2*vT) - (3*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*mZ**4*pi**2*vT) + (15*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(8.*mZ**2*pi**2*vT) - (3*mW**3*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*pi**2*vT**3) - (18*mW**7*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mZ**4*pi**2*vT**3) + (39*mW**5*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mZ**2*pi**2*vT**3) + (7*mW**6*einsum("pr,st",C["phil1"],kd)*log(scale**2/mW**2))/(2.*mZ**4*pi**2*vT**2) - (7*mW**4*einsum("pr,st",C["phil1"],kd)*log(scale**2/mW**2))/(2.*mZ**2*pi**2*vT**2) - (5*mW**2*einsum("pr,st",C["phil3"],kd)*log(scale**2/mW**2))/(4.*pi**2*vT**2) - (7*mW**6*einsum("pr,st",C["phil3"],kd)*log(scale**2/mW**2))/(2.*mZ**4*pi**2*vT**2) + (11*mW**4*einsum("pr,st",C["phil3"],kd)*log(scale**2/mW**2))/(2.*mZ**2*pi**2*vT**2) - (3*mH**2*mW**4*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(8.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**4) + (9*mW**6*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(4.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**4) - (3*mW**8*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**4) + (3*mH**2*mW**2*mZ**2*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(4.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**4) - (21*mW**4*mZ**2*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(8.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**4) + (3*mW**6*mZ**2*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**4) + (15*mH**2*mW**4*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/((4*mH**4 - 4*mH**2*mW**2)*pi**2*vT**2) - (12*mW**6*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/((4*mH**4 - 4*mH**2*mW**2)*pi**2*vT**2) - (3*mH**2*mW**4*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(16.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**2) - (3*mW**6*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(4.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (3*mW**8*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(4.*mH**2*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (3*mH**2*mW**2*mZ**2*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(8.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (9*mW**4*mZ**2*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(16.*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**2) - (3*mW**6*mZ**2*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(4.*mH**2*(mH - mW)*(mH + mW)*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (3*mW**4*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(mH**2*pi**2*vT**2) - (3*mW**2*einsum("pt,sr",C["phil1"],kd)*log(scale**2/mW**2))/(4.*pi**2*vT**2) - (3*mW**2*einsum("pt,sr",C["phil3"],kd)*log(scale**2/mW**2))/(4.*pi**2*vT**2) - (3*mW**2*einsum("sr,pt",C["phil1"],kd)*log(scale**2/mW**2))/(4.*pi**2*vT**2) - (3*mW**2*einsum("sr,pt",C["phil3"],kd)*log(scale**2/mW**2))/(4.*pi**2*vT**2) + (3*mW**2*einsum("st,pr",C["phil3"],kd)*log(scale**2/mW**2))/(4.*pi**2*vT**2) + (3*mW**2*einsum("prst",C["ll"])*log(scale**2/mZ**2))/(4.*pi**2*vT**2) - (3*mZ**2*einsum("prst",C["ll"])*log(scale**2/mZ**2))/(8.*pi**2*vT**2) + (3*mW**2*einsum("stpr",C["ll"])*log(scale**2/mZ**2))/(4.*pi**2*vT**2) - (3*mZ**2*einsum("stpr",C["ll"])*log(scale**2/mZ**2))/(8.*pi**2*vT**2) - (9*mW**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (9*mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (3*mW**2*mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (3*mZ**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (3*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (15*mH**2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (13*mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (3*mH**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (8*mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (3*mW**4*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (3*mZ**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (15*mW**2*mZ**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (3*mZ**8*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (9*mW**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (9*mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (3*mW**2*mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mZ**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (9*mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (3*mW**2*mZ**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (9*mH**2*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (13*mW**4*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (5*mW**2*mZ**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (3*mW**4*mZ**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (9*mW**2*mZ**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (3*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (3*g1bar*mH**2*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (13*g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (11*g1bar*mW*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (3*g1bar*mW**3*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (3*g1bar*mW*mZ**6*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (3*mW**2*mZ**2*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(4.*(mW - mZ)*(mW + mZ)*pi**2*vT**4) + (3*mZ**4*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(8.*(mW - mZ)*(mW + mZ)*pi**2*vT**4) + (3*mW**2*mZ**4*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mW - mZ)*(mW + mZ)*pi**2*vT**4) - (3*mZ**6*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mW - mZ)*(mW + mZ)*pi**2*vT**4) - (3*mW**2*mZ**2*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*pi**2*vT**2) + (3*mZ**4*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*pi**2*vT**2) + (3*mZ**4*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*pi**2*vT**2) + (3*mW**4*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(4.*(mW - mZ)*(mW + mZ)*pi**2*vT**2) - (9*mW**2*mZ**2*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(8.*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (3*mZ**4*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(16.*(mW - mZ)*(mW + mZ)*pi**2*vT**2) + (3*mW**2*mZ**2*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*pi**2*vT**2) + (3*g1bar*mW*mZ**2*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*pi**2*vT) + (3*mW**2*einsum("pt,sr",C["phil1"],kd)*log(scale**2/mZ**2))/(4.*pi**2*vT**2) - (3*mW**2*einsum("pt,sr",C["phil3"],kd)*log(scale**2/mZ**2))/(4.*pi**2*vT**2) + (3*mW**2*einsum("sr,pt",C["phil1"],kd)*log(scale**2/mZ**2))/(4.*pi**2*vT**2) - (3*mW**2*einsum("sr,pt",C["phil3"],kd)*log(scale**2/mZ**2))/(4.*pi**2*vT**2) + (g1bar*mt*mW**4*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(3.*mZ**4*pi**2*vT) + (g1bar*mt*mW**4*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(3.*mZ**4*pi**2*vT) - (2*mt*mW**5*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(3.*mZ**4*pi**2*vT**2) - (2*mt*mW**5*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(3.*mZ**4*pi**2*vT**2))
    c['VnunuLL'] = ((-15*mZ**2*einsum("prst",C["ll"]))/(64.*pi**2*vT**2) + (bEvan*mZ**2*einsum("prst",C["ll"]))/(16.*pi**2*vT**2) - (15*mZ**2*einsum("ptsr",C["ll"]))/(64.*pi**2*vT**2) + (bEvan*mZ**2*einsum("ptsr",C["ll"]))/(16.*pi**2*vT**2) - (15*mZ**2*einsum("srpt",C["ll"]))/(64.*pi**2*vT**2) + (bEvan*mZ**2*einsum("srpt",C["ll"]))/(16.*pi**2*vT**2) - (15*mZ**2*einsum("stpr",C["ll"]))/(64.*pi**2*vT**2) + (bEvan*mZ**2*einsum("stpr",C["ll"]))/(16.*pi**2*vT**2) + (7*mH**2*einsum("pr,st",kd,kd))/(128.*pi**2*vT**4) - (mW**2*einsum("pr,st",kd,kd))/(32.*pi**2*vT**4) + (mW**4*einsum("pr,st",kd,kd))/(16.*mH**2*pi**2*vT**4) + (mZ**2*einsum("pr,st",kd,kd))/(128.*pi**2*vT**4) + (mZ**4*einsum("pr,st",kd,kd))/(32.*mH**2*pi**2*vT**4) - (mt**4*Nc*einsum("pr,st",kd,kd))/(8.*mH**2*pi**2*vT**4) - (3*C["phi"]*einsum("pr,st",kd,kd))/(32.*pi**2) - (mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(16.*mH**2*pi**2*vT**2) + (mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(16.*mH**2*pi**2*vT**2) + (11*mH**2*C["phiBox"]*einsum("pr,st",kd,kd))/(64.*pi**2*vT**2) + (mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(8.*mH**2*pi**2*vT**2) - (5*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(64.*pi**2*vT**2) + (mZ**4*C["phiBox"]*einsum("pr,st",kd,kd))/(16.*mH**2*pi**2*vT**2) - (mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(4.*mH**2*pi**2*vT**2) - (mH**2*C["phiD"]*einsum("pr,st",kd,kd))/(16.*pi**2*vT**2) - (mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(32.*mH**2*pi**2*vT**2) - (3*mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(64.*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(16.*mH**2*pi**2*vT**2) + (mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(8.*mH**2*pi**2*vT**2) + (mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(16.*mH**2*pi**2*vT**2) + (g1bar*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(32.*mH**2*pi**2*vT) - (3*mZ**2*einsum("pr,st",C["phil1"],kd))/(32.*pi**2*vT**2) - (5*mW**2*einsum("pr,st",C["phil3"],kd))/(32.*pi**2*vT**2) + (3*mZ**2*einsum("pr,st",C["phil3"],kd))/(32.*pi**2*vT**2) + (7*mH**2*einsum("pt,sr",kd,kd))/(128.*pi**2*vT**4) - (mW**2*einsum("pt,sr",kd,kd))/(32.*pi**2*vT**4) + (mW**4*einsum("pt,sr",kd,kd))/(16.*mH**2*pi**2*vT**4) + (mZ**2*einsum("pt,sr",kd,kd))/(128.*pi**2*vT**4) + (mZ**4*einsum("pt,sr",kd,kd))/(32.*mH**2*pi**2*vT**4) - (mt**4*Nc*einsum("pt,sr",kd,kd))/(8.*mH**2*pi**2*vT**4) - (3*C["phi"]*einsum("pt,sr",kd,kd))/(32.*pi**2) - (mW**2*mZ**2*C["phiB"]*einsum("pt,sr",kd,kd))/(16.*mH**2*pi**2*vT**2) + (mZ**4*C["phiB"]*einsum("pt,sr",kd,kd))/(16.*mH**2*pi**2*vT**2) + (11*mH**2*C["phiBox"]*einsum("pt,sr",kd,kd))/(64.*pi**2*vT**2) + (mW**4*C["phiBox"]*einsum("pt,sr",kd,kd))/(8.*mH**2*pi**2*vT**2) - (5*mZ**2*C["phiBox"]*einsum("pt,sr",kd,kd))/(64.*pi**2*vT**2) + (mZ**4*C["phiBox"]*einsum("pt,sr",kd,kd))/(16.*mH**2*pi**2*vT**2) - (mt**4*Nc*C["phiBox"]*einsum("pt,sr",kd,kd))/(4.*mH**2*pi**2*vT**2) - (mH**2*C["phiD"]*einsum("pt,sr",kd,kd))/(16.*pi**2*vT**2) - (mW**4*C["phiD"]*einsum("pt,sr",kd,kd))/(32.*mH**2*pi**2*vT**2) - (3*mZ**2*C["phiD"]*einsum("pt,sr",kd,kd))/(64.*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pt,sr",kd,kd))/(16.*mH**2*pi**2*vT**2) + (mW**4*C["phiW"]*einsum("pt,sr",kd,kd))/(8.*mH**2*pi**2*vT**2) + (mW**2*mZ**2*C["phiW"]*einsum("pt,sr",kd,kd))/(16.*mH**2*pi**2*vT**2) + (g1bar*mW*mZ**2*C["phiWB"]*einsum("pt,sr",kd,kd))/(32.*mH**2*pi**2*vT) - (3*mZ**2*einsum("pt,sr",C["phil1"],kd))/(32.*pi**2*vT**2) - (5*mW**2*einsum("pt,sr",C["phil3"],kd))/(32.*pi**2*vT**2) + (3*mZ**2*einsum("pt,sr",C["phil3"],kd))/(32.*pi**2*vT**2) - (3*mZ**2*einsum("sr,pt",C["phil1"],kd))/(32.*pi**2*vT**2) - (5*mW**2*einsum("sr,pt",C["phil3"],kd))/(32.*pi**2*vT**2) + (3*mZ**2*einsum("sr,pt",C["phil3"],kd))/(32.*pi**2*vT**2) - (3*mZ**2*einsum("st,pr",C["phil1"],kd))/(32.*pi**2*vT**2) - (5*mW**2*einsum("st,pr",C["phil3"],kd))/(32.*pi**2*vT**2) + (3*mZ**2*einsum("st,pr",C["phil3"],kd))/(32.*pi**2*vT**2) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(16.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(16.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pt,sr,TT",C["uphi"],kd,kd,kdt))/(16.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pt,sr,TT",C["uphiDag"],kd,kd,kdt))/(16.*sqrt(2)*mH**2*pi**2*vT) + (3*mH**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(64.*(mH**2 - mZ**2)*pi**2*vT**4) - (3*mH**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(32.*(mH**2 - mZ**2)*pi**2*vT**4) - (3*C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(32.*pi**2) + (5*mH**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((32*mH**2 - 32*mZ**2)*pi**2*vT**2) - (8*mH**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((32*mH**2 - 32*mZ**2)*pi**2*vT**2) - (mH**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(16.*pi**2*vT**2) + (3*mH**4*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(64.*(mH**2 - mZ**2)*pi**2*vT**4) - (3*mH**2*mZ**2*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(32.*(mH**2 - mZ**2)*pi**2*vT**4) - (3*C["phi"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(32.*pi**2) + (5*mH**4*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/((32*mH**2 - 32*mZ**2)*pi**2*vT**2) - (8*mH**2*mZ**2*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/((32*mH**2 - 32*mZ**2)*pi**2*vT**2) - (mH**2*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mH**2))/(16.*pi**2*vT**2) + (mt**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(32.*pi**2*vT**4) - (mt**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(8.*mH**2*pi**2*vT**4) - (mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(4.*mH**2*pi**2*vT**2) - (mt**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(32.*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(16.*mH**2*pi**2*vT**2) - (mt**2*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(32.*pi**2*vT**2) + (mt**2*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(32.*pi**2*vT**2) + (mt**2*Nc*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(32.*pi**2*vT**4) - (mt**4*Nc*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(8.*mH**2*pi**2*vT**4) - (mt**4*Nc*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(4.*mH**2*pi**2*vT**2) - (mt**2*Nc*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(32.*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mt**2))/(16.*mH**2*pi**2*vT**2) - (mt**2*Nc*einsum("pt,sr",C["phil1"],kd)*log(scale**2/mt**2))/(32.*pi**2*vT**2) + (mt**2*Nc*einsum("pt,sr",C["phil3"],kd)*log(scale**2/mt**2))/(32.*pi**2*vT**2) - (mt**2*Nc*einsum("sr,pt",C["phil1"],kd)*log(scale**2/mt**2))/(32.*pi**2*vT**2) + (mt**2*Nc*einsum("sr,pt",C["phil3"],kd)*log(scale**2/mt**2))/(32.*pi**2*vT**2) - (mt**2*Nc*einsum("st,pr",C["phil1"],kd)*log(scale**2/mt**2))/(32.*pi**2*vT**2) + (mt**2*Nc*einsum("st,pr",C["phil3"],kd)*log(scale**2/mt**2))/(32.*pi**2*vT**2) - (mt**2*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(32.*pi**2*vT**2) - (mt**2*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(32.*pi**2*vT**2) + (mt**2*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(32.*pi**2*vT**2) - (mt**2*Nc*einsum("ptTT,sr,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(32.*pi**2*vT**2) - (mt**2*Nc*einsum("ptTT,sr,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(32.*pi**2*vT**2) + (mt**2*Nc*einsum("ptTT,sr,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(32.*pi**2*vT**2) - (mt**2*Nc*einsum("srTT,pt,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(32.*pi**2*vT**2) - (mt**2*Nc*einsum("srTT,pt,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(32.*pi**2*vT**2) + (mt**2*Nc*einsum("srTT,pt,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(32.*pi**2*vT**2) - (mt**2*Nc*einsum("stTT,pr,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(32.*pi**2*vT**2) - (mt**2*Nc*einsum("stTT,pr,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(32.*pi**2*vT**2) + (mt**2*Nc*einsum("stTT,pr,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(32.*pi**2*vT**2) - (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*pi**2*vT**2) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*mH**2*pi**2*vT) - (mt**2*Nc*einsum("TT,pt,sr,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pt,sr,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pt,sr,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*pi**2*vT**2) + (mt**3*Nc*einsum("TT,pt,sr,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pt,sr,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*sqrt(2)*mH**2*pi**2*vT) - (3*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(32.*pi**2*vT**4) + (3*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(16.*mH**2*pi**2*vT**4) + (3*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(8.*mH**2*pi**2*vT**2) - (3*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(32.*mH**2*pi**2*vT**2) + (3*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(8.*mH**2*pi**2*vT**2) - (3*mW**2*einsum("pr,st",C["phil3"],kd)*log(scale**2/mW**2))/(16.*pi**2*vT**2) - (3*mW**2*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(32.*pi**2*vT**4) + (3*mW**4*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(16.*mH**2*pi**2*vT**4) + (3*mW**4*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(8.*mH**2*pi**2*vT**2) - (3*mW**4*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(32.*mH**2*pi**2*vT**2) + (3*mW**4*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(8.*mH**2*pi**2*vT**2) - (3*mW**2*einsum("pt,sr",C["phil3"],kd)*log(scale**2/mW**2))/(16.*pi**2*vT**2) - (3*mW**2*einsum("sr,pt",C["phil3"],kd)*log(scale**2/mW**2))/(16.*pi**2*vT**2) - (3*mW**2*einsum("st,pr",C["phil3"],kd)*log(scale**2/mW**2))/(16.*pi**2*vT**2) - (3*mZ**2*einsum("prst",C["ll"])*log(scale**2/mZ**2))/(32.*pi**2*vT**2) - (3*mZ**2*einsum("ptsr",C["ll"])*log(scale**2/mZ**2))/(32.*pi**2*vT**2) - (3*mZ**2*einsum("srpt",C["ll"])*log(scale**2/mZ**2))/(32.*pi**2*vT**2) - (3*mZ**2*einsum("stpr",C["ll"])*log(scale**2/mZ**2))/(32.*pi**2*vT**2) + (9*mH**2*mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((64*mH**4 - 64*mH**2*mZ**2)*pi**2*vT**4) - (6*mZ**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((64*mH**4 - 64*mH**2*mZ**2)*pi**2*vT**4) - (3*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*mH**2*pi**2*vT**2) + (3*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*mH**2*pi**2*vT**2) + (9*mH**2*mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((32*mH**4 - 32*mH**2*mZ**2)*pi**2*vT**2) - (6*mZ**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((32*mH**4 - 32*mH**2*mZ**2)*pi**2*vT**2) + (3*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*mH**2*pi**2*vT**2) + (3*g1bar*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(32.*mH**2*pi**2*vT) + (9*mH**2*mZ**4*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/((64*mH**4 - 64*mH**2*mZ**2)*pi**2*vT**4) - (6*mZ**6*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/((64*mH**4 - 64*mH**2*mZ**2)*pi**2*vT**4) - (3*mW**2*mZ**2*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(16.*mH**2*pi**2*vT**2) + (3*mZ**4*C["phiB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(16.*mH**2*pi**2*vT**2) + (9*mH**2*mZ**4*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/((32*mH**4 - 32*mH**2*mZ**2)*pi**2*vT**2) - (6*mZ**6*C["phiBox"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/((32*mH**4 - 32*mH**2*mZ**2)*pi**2*vT**2) + (3*mW**2*mZ**2*C["phiW"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(16.*mH**2*pi**2*vT**2) + (3*g1bar*mW*mZ**2*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(32.*mH**2*pi**2*vT))
    c['VnuuLL'] = ((-5*mW**2*einsum("prst",C["lq1"]))/(4.*pi**2*vT**2) + (bEvan*mW**2*einsum("prst",C["lq1"]))/(3.*pi**2*vT**2) + (5*mZ**2*einsum("prst",C["lq1"]))/(16.*pi**2*vT**2) - (bEvan*mZ**2*einsum("prst",C["lq1"]))/(12.*pi**2*vT**2) - (7*mW**2*einsum("prst",C["lq3"]))/(4.*pi**2*vT**2) + (5*bEvan*mW**2*einsum("prst",C["lq3"]))/(6.*pi**2*vT**2) + (5*mZ**2*einsum("prst",C["lq3"]))/(16.*pi**2*vT**2) - (bEvan*mZ**2*einsum("prst",C["lq3"]))/(12.*pi**2*vT**2) - (7*mH**2*einsum("pr,st",kd,kd))/(96.*pi**2*vT**4) - (11*mW**2*einsum("pr,st",kd,kd))/(9.*pi**2*vT**4) - (mW**4*einsum("pr,st",kd,kd))/(12.*mH**2*pi**2*vT**4) + (2*mW**6*einsum("pr,st",kd,kd))/(9.*mZ**4*pi**2*vT**4) + (7*mH**2*mW**2*einsum("pr,st",kd,kd))/(24.*mZ**2*pi**2*vT**4) + (5*mW**4*einsum("pr,st",kd,kd))/(6.*mZ**2*pi**2*vT**4) + (mW**6*einsum("pr,st",kd,kd))/(3.*mH**2*mZ**2*pi**2*vT**4) + (7*mZ**2*einsum("pr,st",kd,kd))/(96.*pi**2*vT**4) + (mW**2*mZ**2*einsum("pr,st",kd,kd))/(6.*mH**2*pi**2*vT**4) - (mZ**4*einsum("pr,st",kd,kd))/(24.*mH**2*pi**2*vT**4) + (mt**4*Nc*einsum("pr,st",kd,kd))/(6.*mH**2*pi**2*vT**4) - (2*mt**4*mW**2*Nc*einsum("pr,st",kd,kd))/(3.*mH**2*mZ**2*pi**2*vT**4) + (C["phi"]*einsum("pr,st",kd,kd))/(8.*pi**2) - (mW**2*C["phi"]*einsum("pr,st",kd,kd))/(2.*mZ**2*pi**2) - (mH**2*mW**2*C["phiB"]*einsum("pr,st",kd,kd))/(2.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (7*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (2*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (2*mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**2*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(2.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (2*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (2*mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (5*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mZ**6*C["phiB"]*einsum("pr,st",kd,kd))/(12.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (4*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (4*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (4*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (4*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (11*mH**2*C["phiBox"]*einsum("pr,st",kd,kd))/(48.*pi**2*vT**2) - (5*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(12.*pi**2*vT**2) - (mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(6.*mH**2*pi**2*vT**2) + (11*mH**2*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(12.*mZ**2*pi**2*vT**2) + (2*mW**6*C["phiBox"]*einsum("pr,st",kd,kd))/(3.*mH**2*mZ**2*pi**2*vT**2) + (5*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(48.*pi**2*vT**2) + (mW**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(3.*mH**2*pi**2*vT**2) - (mZ**4*C["phiBox"]*einsum("pr,st",kd,kd))/(12.*mH**2*pi**2*vT**2) + (mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(3.*mH**2*pi**2*vT**2) - (4*mt**4*mW**2*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(3.*mH**2*mZ**2*pi**2*vT**2) + (mH**2*C["phiD"]*einsum("pr,st",kd,kd))/(12.*pi**2*vT**2) - (mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(48.*pi**2*vT**2) + (mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(24.*mH**2*pi**2*vT**2) + (mW**6*C["phiD"]*einsum("pr,st",kd,kd))/(9.*mZ**4*pi**2*vT**2) - (3*mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(16.*mZ**2*pi**2*vT**2) + (13*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(36.*mZ**2*pi**2*vT**2) - (mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(48.*pi**2*vT**2) + (mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(12.*mH**2*pi**2*vT**2) - (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(12.*mH**2*pi**2*vT**2) + (mH**2*mW**2*C["phiW"]*einsum("pr,st",kd,kd))/(2.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**4*C["phiW"]*einsum("pr,st",kd,kd))/((mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (2*mW**8*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**2*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(2.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (2*mW**8*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (11*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**4*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(2.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (5*mW**2*mZ**4*C["phiW"]*einsum("pr,st",kd,kd))/(12.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (4*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (4*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (4*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (4*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (5*g1bar*mH**2*mW*C["phiWB"]*einsum("pr,st",kd,kd))/(24.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(36.*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (2*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (g1bar*mH**4*mW*C["phiWB"]*einsum("pr,st",kd,kd))/(16.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (13*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(36.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (2*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (g1bar*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(48.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mW*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd))/(24.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) - (2*g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (2*g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (mW**3*C["W"]*einsum("pr,st",kd,kd))/(pi**2*vT**3) + (mW**5*C["W"]*einsum("pr,st",kd,kd))/(mZ**2*pi**2*vT**3) + (mW**2*einsum("pr,st",C["phil1"],kd))/(3.*pi**2*vT**2) - (2*mW**6*einsum("pr,st",C["phil1"],kd))/(9.*mZ**4*pi**2*vT**2) - (4*mW**4*einsum("pr,st",C["phil1"],kd))/(9.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("pr,st",C["phil1"],kd))/(24.*pi**2*vT**2) - (137*mW**2*einsum("pr,st",C["phil3"],kd))/(72.*pi**2*vT**2) + (2*mW**6*einsum("pr,st",C["phil3"],kd))/(9.*mZ**4*pi**2*vT**2) + (25*mW**4*einsum("pr,st",C["phil3"],kd))/(18.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("pr,st",C["phil3"],kd))/(24.*pi**2*vT**2) - (mW**2*einsum("st,pr",C["phiq1"],kd))/(2.*pi**2*vT**2) + (mZ**2*einsum("st,pr",C["phiq1"],kd))/(8.*pi**2*vT**2) - (mW**2*einsum("st,pr",C["phiq3"],kd))/(8.*pi**2*vT**2) - (mZ**2*einsum("st,pr",C["phiq3"],kd))/(8.*pi**2*vT**2) + (mt**2*einsum("sTTt,pr,TT",C["qq1"],kd,kdt))/(8.*pi**2*vT**2) + (mt**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(8.*pi**2*vT**2) + (mt**2*einsum("TtsT,pr,TT",C["qq1"],kd,kdt))/(8.*pi**2*vT**2) + (mt**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(8.*pi**2*vT**2) - (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(12.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(3.*sqrt(2)*mH**2*mZ**2*pi**2*vT) - (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(12.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(3.*sqrt(2)*mH**2*mZ**2*pi**2*vT) - (mH**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (mH**2*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mH**4*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) + (mH**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*pi**2) - (mW**2*C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*mZ**2*pi**2) - (mH**4*mW**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mH**6*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) + (mH**6*mW**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (mH**2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (5*mH**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(24.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (4*mH**2*mW**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (5*mH**4*mW**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mH**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (5*mH**4*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(24.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mH**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mH**6*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) - (mH**6*mW**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (mH**4*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (mH**2*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (g1bar*mH**4*mW*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(8.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**6*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**6*mW*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(24.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(2.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) - (mt**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(24.*pi**2*vT**4) + (mt**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(6.*mH**2*pi**2*vT**4) - (10*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*pi**2*vT**4) - (16*mW**6*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**4) + (mt**2*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**4) - (2*mt**4*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**2*pi**2*vT**4) + (26*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**4) + (4*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**4*pi**2*vT**2) - (4*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**2*pi**2*vT**2) + (mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*pi**2*vT**2) - (4*mt**4*mW**2*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**2*pi**2*vT**2) + (mt**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(24.*pi**2*vT**2) - (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(12.*mH**2*pi**2*vT**2) + (5*mW**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) - (8*mW**6*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (4*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**4*pi**2*vT**2) + (4*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**2*pi**2*vT**2) - (2*g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(3.*mH**2*mZ**4*pi**2*vT) - (8*g1bar*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT) + (g1bar*mt**2*mW*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT) + (2*g1bar*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT) + (mt**2*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (10*mW**2*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) + (16*mW**6*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) - (26*mW**4*Nc*einsum("pr,st",C["phil1"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(24.*pi**2*vT**2) - (10*mW**2*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) - (16*mW**6*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) + (26*mW**4*Nc*einsum("pr,st",C["phil3"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mt**2*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mt**2*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) - (2*mW**2*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) + (2*mW**4*Nc*einsum("prTT,st,TT",C["lq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) - (2*mW**2*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) + (2*mW**4*Nc*einsum("prTT,st,TT",C["lq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) - (2*mW**2*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) + (2*mW**4*Nc*einsum("prTT,st,TT",C["lu"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("stTT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) - (mt**2*Nc*einsum("stTT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mt**2*Nc*einsum("stTT,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) - (mt**2*einsum("sTTt,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) - (mt**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) - (mt**2*einsum("TtsT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) - (mt**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) - (mt**2*Nc*einsum("TTst,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) - (mt**2*Nc*einsum("TTst,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) - (2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*mZ**2*pi**2*vT**2) + (2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) + (2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*mZ**2*pi**2*vT**2) - (2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) - (2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*mZ**2*pi**2*vT**2) + (2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (13*g1bar*mt*mW**2*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*sqrt(2)*mZ**2*pi**2*vT) + (13*g1bar*mt*mW**2*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*sqrt(2)*mZ**2*pi**2*vT) - (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*sqrt(2)*mH**2*mZ**2*pi**2*vT) - (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (5*mt*mW*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*pi**2*vT**2) - (7*mt*mW**3*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*mZ**2*pi**2*vT**2) + (5*mt*mW*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*pi**2*vT**2) - (7*mt*mW**3*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*mZ**2*pi**2*vT**2) + (7*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(24.*pi**2*vT**4) - (mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(4.*mH**2*pi**2*vT**4) + (7*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mZ**4*pi**2*vT**4) - (3*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mZ**2*pi**2*vT**4) + (mW**6*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**2*pi**2*vT**4) - (2*mW**8*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**4*pi**2*vT**2) + (2*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**2*pi**2*vT**2) - (mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*pi**2*vT**2) + (2*mW**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**2*pi**2*vT**2) + (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(8.*mH**2*pi**2*vT**2) + (7*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mZ**4*pi**2*vT**2) - (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mZ**2*pi**2*vT**2) - (mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mH**2*pi**2*vT**2) + (2*mW**8*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**4*pi**2*vT**2) + (5*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(2.*mZ**4*pi**2*vT) + (g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**4*pi**2*vT) - (5*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(4.*mZ**2*pi**2*vT) + (mW**3*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(pi**2*vT**3) + (12*mW**7*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mZ**4*pi**2*vT**3) - (13*mW**5*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mZ**2*pi**2*vT**3) - (7*mW**6*einsum("pr,st",C["phil1"],kd)*log(scale**2/mW**2))/(3.*mZ**4*pi**2*vT**2) + (7*mW**4*einsum("pr,st",C["phil1"],kd)*log(scale**2/mW**2))/(3.*mZ**2*pi**2*vT**2) + (7*mW**2*einsum("pr,st",C["phil3"],kd)*log(scale**2/mW**2))/(12.*pi**2*vT**2) + (7*mW**6*einsum("pr,st",C["phil3"],kd)*log(scale**2/mW**2))/(3.*mZ**4*pi**2*vT**2) - (11*mW**4*einsum("pr,st",C["phil3"],kd)*log(scale**2/mW**2))/(3.*mZ**2*pi**2*vT**2) - (3*mW**2*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mW**2))/(4.*pi**2*vT**2) - (mW**2*einsum("prst",C["lq1"])*log(scale**2/mZ**2))/(2.*pi**2*vT**2) + (mZ**2*einsum("prst",C["lq1"])*log(scale**2/mZ**2))/(8.*pi**2*vT**2) - (mW**2*einsum("prst",C["lq3"])*log(scale**2/mZ**2))/(2.*pi**2*vT**2) + (mZ**2*einsum("prst",C["lq3"])*log(scale**2/mZ**2))/(8.*pi**2*vT**2) + (3*mW**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (3*mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (mW**2*mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mZ**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (2*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (9*mH**2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (13*mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mH**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (29*mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (2*mW**4*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mZ**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (9*mW**2*mZ**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mZ**8*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (3*mW**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (3*mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**2*mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mZ**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (3*mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*(mH**2 - mZ**2)*pi**2*vT**2) - (mW**2*mZ**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH**2 - mZ**2)*pi**2*vT**2) + (2*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (5*mH**2*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (13*mW**4*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (17*mW**2*mZ**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (2*mW**4*mZ**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (5*mW**2*mZ**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (13*g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (5*g1bar*mW*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(24.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mW**3*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mW*mZ**6*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (2*g1bar*mt*mW**4*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*mZ**4*pi**2*vT) - (2*g1bar*mt*mW**4*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*mZ**4*pi**2*vT) + (4*mt*mW**5*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*mZ**4*pi**2*vT**2) + (4*mt*mW**5*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*mZ**4*pi**2*vT**2))
    c['VuuLL'] = ((5*mW**2*einsum("prst",C["qq1"]))/(12.*pi**2*vT**2) - (bEvan*mW**2*einsum("prst",C["qq1"]))/(9.*pi**2*vT**2) - (5*mW**4*einsum("prst",C["qq1"]))/(6.*mZ**2*pi**2*vT**2) + (2*bEvan*mW**4*einsum("prst",C["qq1"]))/(9.*mZ**2*pi**2*vT**2) - (5*mZ**2*einsum("prst",C["qq1"]))/(96.*pi**2*vT**2) + (bEvan*mZ**2*einsum("prst",C["qq1"]))/(72.*pi**2*vT**2) + (mW**2*einsum("prst",C["qq3"]))/(6.*pi**2*vT**2) + (5*bEvan*mW**2*einsum("prst",C["qq3"]))/(36.*pi**2*vT**2) - (5*mW**4*einsum("prst",C["qq3"]))/(6.*mZ**2*pi**2*vT**2) + (2*bEvan*mW**4*einsum("prst",C["qq3"]))/(9.*mZ**2*pi**2*vT**2) - (5*mZ**2*einsum("prst",C["qq3"]))/(96.*pi**2*vT**2) + (bEvan*mZ**2*einsum("prst",C["qq3"]))/(72.*pi**2*vT**2) + (5*mW**2*einsum("stpr",C["qq1"]))/(12.*pi**2*vT**2) - (bEvan*mW**2*einsum("stpr",C["qq1"]))/(9.*pi**2*vT**2) - (5*mW**4*einsum("stpr",C["qq1"]))/(6.*mZ**2*pi**2*vT**2) + (2*bEvan*mW**4*einsum("stpr",C["qq1"]))/(9.*mZ**2*pi**2*vT**2) - (5*mZ**2*einsum("stpr",C["qq1"]))/(96.*pi**2*vT**2) + (bEvan*mZ**2*einsum("stpr",C["qq1"]))/(72.*pi**2*vT**2) + (mW**2*einsum("stpr",C["qq3"]))/(6.*pi**2*vT**2) + (5*bEvan*mW**2*einsum("stpr",C["qq3"]))/(36.*pi**2*vT**2) - (5*mW**4*einsum("stpr",C["qq3"]))/(6.*mZ**2*pi**2*vT**2) + (2*bEvan*mW**4*einsum("stpr",C["qq3"]))/(9.*mZ**2*pi**2*vT**2) - (5*mZ**2*einsum("stpr",C["qq3"]))/(96.*pi**2*vT**2) + (bEvan*mZ**2*einsum("stpr",C["qq3"]))/(72.*pi**2*vT**2) + (g3bar**4*einsum("pr,st",kd,kd))/(480.*mt**2*Nc*pi**2) + (7*mH**2*einsum("pr,st",kd,kd))/(576.*pi**2*vT**4) - (15091*mW**2*einsum("pr,st",kd,kd))/(58320.*pi**2*vT**4) + (2*bEvan*mW**2*einsum("pr,st",kd,kd))/(81.*pi**2*vT**4) + (mW**4*einsum("pr,st",kd,kd))/(8.*mH**2*pi**2*vT**4) + (1400*mW**8*einsum("pr,st",kd,kd))/(729.*mZ**6*pi**2*vT**4) - (32*bEvan*mW**8*einsum("pr,st",kd,kd))/(81.*mZ**6*pi**2*vT**4) + (7*mH**2*mW**4*einsum("pr,st",kd,kd))/(36.*mZ**4*pi**2*vT**4) - (2762*mW**6*einsum("pr,st",kd,kd))/(1215.*mZ**4*pi**2*vT**4) + (16*bEvan*mW**6*einsum("pr,st",kd,kd))/(27.*mZ**4*pi**2*vT**4) + (2*mW**8*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**4) - (7*mH**2*mW**2*einsum("pr,st",kd,kd))/(72.*mZ**2*pi**2*vT**4) + (103*mW**4*einsum("pr,st",kd,kd))/(180.*mZ**2*pi**2*vT**4) - (2*bEvan*mW**4*einsum("pr,st",kd,kd))/(9.*mZ**2*pi**2*vT**4) - (mW**6*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**2*pi**2*vT**4) - (13*mZ**2*einsum("pr,st",kd,kd))/(1728.*pi**2*vT**4) - (mW**2*mZ**2*einsum("pr,st",kd,kd))/(18.*mH**2*pi**2*vT**4) + (mZ**4*einsum("pr,st",kd,kd))/(144.*mH**2*pi**2*vT**4) - (mt**4*Nc*einsum("pr,st",kd,kd))/(36.*mH**2*pi**2*vT**4) - (32*mW**4*Nc*einsum("pr,st",kd,kd))/(1215.*mt**2*pi**2*vT**4) - (4*mt**4*mW**4*Nc*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**4) - (32*mW**8*Nc*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**4*pi**2*vT**4) + (2*mt**4*mW**2*Nc*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**2*pi**2*vT**4) + (64*mW**6*Nc*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**2*pi**2*vT**4) - (131*g3bar**2*einsum("pr,st",kd,kd))/(5184.*Nc*pi**2*vT**2) - (bEvan*g3bar**2*einsum("pr,st",kd,kd))/(144.*Nc*pi**2*vT**2) + (121*g3bar**2*mW**4*einsum("pr,st",kd,kd))/(324.*mZ**4*Nc*pi**2*vT**2) - (bEvan*g3bar**2*mW**4*einsum("pr,st",kd,kd))/(9.*mZ**4*Nc*pi**2*vT**2) - (121*g3bar**2*mW**2*einsum("pr,st",kd,kd))/(648.*mZ**2*Nc*pi**2*vT**2) + (bEvan*g3bar**2*mW**2*einsum("pr,st",kd,kd))/(18.*mZ**2*Nc*pi**2*vT**2) - (C["phi"]*einsum("pr,st",kd,kd))/(48.*pi**2) - (mW**4*C["phi"]*einsum("pr,st",kd,kd))/(3.*mZ**4*pi**2) + (mW**2*C["phi"]*einsum("pr,st",kd,kd))/(6.*mZ**2*pi**2) + (mH**2*mW**2*C["phiB"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (31*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (8*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (4*mH**4*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (8*mW**10*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (5*mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (2*mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (10*mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (8*mW**10*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**2*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (5*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (14*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (10*mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (29*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(72.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (8*mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(72.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (17*mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(72.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mZ**6*C["phiB"]*einsum("pr,st",kd,kd))/(72.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (4*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (16*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (20*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (16*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (4*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (20*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (11*mH**2*C["phiBox"]*einsum("pr,st",kd,kd))/(288.*pi**2*vT**2) + (5*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(36.*pi**2*vT**2) + (mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(4.*mH**2*pi**2*vT**2) + (11*mH**2*mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(18.*mZ**4*pi**2*vT**2) + (4*mW**8*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) - (11*mH**2*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(36.*mZ**2*pi**2*vT**2) - (5*mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(18.*mZ**2*pi**2*vT**2) - (2*mW**6*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**2*pi**2*vT**2) - (5*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(288.*pi**2*vT**2) - (mW**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*pi**2*vT**2) + (mZ**4*C["phiBox"]*einsum("pr,st",kd,kd))/(72.*mH**2*pi**2*vT**2) - (mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(18.*mH**2*pi**2*vT**2) - (8*mt**4*mW**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) + (4*mt**4*mW**2*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**2*pi**2*vT**2) - (121*g3bar**2*C["phiD"]*einsum("pr,st",kd,kd))/(10368.*Nc*pi**2) + (bEvan*g3bar**2*C["phiD"]*einsum("pr,st",kd,kd))/(288.*Nc*pi**2) + (121*g3bar**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(648.*mZ**4*Nc*pi**2) - (bEvan*g3bar**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(18.*mZ**4*Nc*pi**2) - (mH**2*C["phiD"]*einsum("pr,st",kd,kd))/(72.*pi**2*vT**2) + (997*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(11664.*pi**2*vT**2) - (bEvan*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(81.*pi**2*vT**2) + (5*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(48.*mH**2*pi**2*vT**2) + (1400*mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(729.*mZ**6*pi**2*vT**2) - (32*bEvan*mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(81.*mZ**6*pi**2*vT**2) - (mH**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(36.*mZ**4*pi**2*vT**2) - (1147*mW**6*C["phiD"]*einsum("pr,st",kd,kd))/(1215.*mZ**4*pi**2*vT**2) + (8*bEvan*mW**6*C["phiD"]*einsum("pr,st",kd,kd))/(27.*mZ**4*pi**2*vT**2) + (mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) + (mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(16.*mZ**2*pi**2*vT**2) - (101*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(405.*mZ**2*pi**2*vT**2) - (mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(864.*pi**2*vT**2) - (mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(36.*mH**2*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(72.*mH**2*pi**2*vT**2) - (2*mt**4*mW**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) - (32*mW**8*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**4*pi**2*vT**2) + (32*mW**6*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**2*pi**2*vT**2) - (mH**2*mW**2*C["phiW"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (53*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(36.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (2*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (4*mH**4*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (8*mW**10*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (5*mH**4*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (2*mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (2*mW**8*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (8*mW**10*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**2*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (5*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (4*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (2*mW**8*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (7*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(24.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (23*mW**4*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(36.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**2*mZ**4*C["phiW"]*einsum("pr,st",kd,kd))/(8.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (4*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (16*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (20*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (16*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (4*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (20*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (7*g1bar*mH**2*mW*C["phiWB"]*einsum("pr,st",kd,kd))/(216.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (2597*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(3645.*(mH - mZ)*(mH + mZ)*pi**2*vT) + (10*bEvan*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) + (2*g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (3124*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(729.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) - (64*bEvan*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (4*g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(36.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (12142*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(3645.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (56*bEvan*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (3205*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(729.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (64*bEvan*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (4*g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (g1bar*mH**4*mW*C["phiWB"]*einsum("pr,st",kd,kd))/(48.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (5933*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(14580.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (10*bEvan*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (13357*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(3645.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (56*bEvan*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (5*g1bar*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(216.*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) - (g1bar*mW*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd))/(144.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) - (64*g1bar*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*mt**2*(mH - mZ)*(mH + mZ)*pi**2*vT) - (8*g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (2*g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (8*g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (64*g1bar*mH**2*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*mt**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (2*g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (64*g1bar*mH**2*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*mt**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (64*g1bar*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*mt**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (121*g1bar*g3bar**2*mW**3*vT*C["phiWB"]*einsum("pr,st",kd,kd))/(324.*mZ**4*Nc*pi**2) - (bEvan*g1bar*g3bar**2*mW**3*vT*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*mZ**4*Nc*pi**2) - (121*g1bar*g3bar**2*mW*vT*C["phiWB"]*einsum("pr,st",kd,kd))/(1296.*mZ**2*Nc*pi**2) + (bEvan*g1bar*g3bar**2*mW*vT*C["phiWB"]*einsum("pr,st",kd,kd))/(36.*mZ**2*Nc*pi**2) + (mW**3*C["W"]*einsum("pr,st",kd,kd))/(3.*pi**2*vT**3) + (4*mW**7*C["W"]*einsum("pr,st",kd,kd))/(3.*mZ**4*pi**2*vT**3) - (5*mW**5*C["W"]*einsum("pr,st",kd,kd))/(3.*mZ**2*pi**2*vT**3) + (121*g3bar**2*einsum("pr,st",C["phiq1"],kd))/(1728.*Nc*pi**2) - (bEvan*g3bar**2*einsum("pr,st",C["phiq1"],kd))/(48.*Nc*pi**2) - (121*g3bar**2*mW**2*einsum("pr,st",C["phiq1"],kd))/(432.*mZ**2*Nc*pi**2) + (bEvan*g3bar**2*mW**2*einsum("pr,st",C["phiq1"],kd))/(12.*mZ**2*Nc*pi**2) - (323*mW**2*einsum("pr,st",C["phiq1"],kd))/(972.*pi**2*vT**2) + (2*bEvan*mW**2*einsum("pr,st",C["phiq1"],kd))/(27.*pi**2*vT**2) - (377*mW**6*einsum("pr,st",C["phiq1"],kd))/(243.*mZ**4*pi**2*vT**2) + (8*bEvan*mW**6*einsum("pr,st",C["phiq1"],kd))/(27.*mZ**4*pi**2*vT**2) + (821*mW**4*einsum("pr,st",C["phiq1"],kd))/(486.*mZ**2*pi**2*vT**2) - (10*bEvan*mW**4*einsum("pr,st",C["phiq1"],kd))/(27.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("pr,st",C["phiq1"],kd))/(144.*pi**2*vT**2) - (205*g3bar**2*einsum("pr,st",C["phiq3"],kd))/(1728.*Nc*pi**2) + (bEvan*g3bar**2*einsum("pr,st",C["phiq3"],kd))/(48.*Nc*pi**2) + (121*g3bar**2*mW**2*einsum("pr,st",C["phiq3"],kd))/(432.*mZ**2*Nc*pi**2) - (bEvan*g3bar**2*mW**2*einsum("pr,st",C["phiq3"],kd))/(12.*mZ**2*Nc*pi**2) - (1087*mW**2*einsum("pr,st",C["phiq3"],kd))/(3888.*pi**2*vT**2) - (2*bEvan*mW**2*einsum("pr,st",C["phiq3"],kd))/(27.*pi**2*vT**2) + (377*mW**6*einsum("pr,st",C["phiq3"],kd))/(243.*mZ**4*pi**2*vT**2) - (8*bEvan*mW**6*einsum("pr,st",C["phiq3"],kd))/(27.*mZ**4*pi**2*vT**2) - (1351*mW**4*einsum("pr,st",C["phiq3"],kd))/(972.*mZ**2*pi**2*vT**2) + (10*bEvan*mW**4*einsum("pr,st",C["phiq3"],kd))/(27.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("pr,st",C["phiq3"],kd))/(144.*pi**2*vT**2) - (g3bar**4*einsum("pt,sr",kd,kd))/(480.*mt**2*pi**2) + (131*g3bar**2*einsum("pt,sr",kd,kd))/(5184.*pi**2*vT**2) + (bEvan*g3bar**2*einsum("pt,sr",kd,kd))/(144.*pi**2*vT**2) - (121*g3bar**2*mW**4*einsum("pt,sr",kd,kd))/(324.*mZ**4*pi**2*vT**2) + (bEvan*g3bar**2*mW**4*einsum("pt,sr",kd,kd))/(9.*mZ**4*pi**2*vT**2) + (121*g3bar**2*mW**2*einsum("pt,sr",kd,kd))/(648.*mZ**2*pi**2*vT**2) - (bEvan*g3bar**2*mW**2*einsum("pt,sr",kd,kd))/(18.*mZ**2*pi**2*vT**2) + (121*g3bar**2*C["phiD"]*einsum("pt,sr",kd,kd))/(10368.*pi**2) - (bEvan*g3bar**2*C["phiD"]*einsum("pt,sr",kd,kd))/(288.*pi**2) - (121*g3bar**2*mW**4*C["phiD"]*einsum("pt,sr",kd,kd))/(648.*mZ**4*pi**2) + (bEvan*g3bar**2*mW**4*C["phiD"]*einsum("pt,sr",kd,kd))/(18.*mZ**4*pi**2) - (121*g1bar*g3bar**2*mW**3*vT*C["phiWB"]*einsum("pt,sr",kd,kd))/(324.*mZ**4*pi**2) + (bEvan*g1bar*g3bar**2*mW**3*vT*C["phiWB"]*einsum("pt,sr",kd,kd))/(9.*mZ**4*pi**2) + (121*g1bar*g3bar**2*mW*vT*C["phiWB"]*einsum("pt,sr",kd,kd))/(1296.*mZ**2*pi**2) - (bEvan*g1bar*g3bar**2*mW*vT*C["phiWB"]*einsum("pt,sr",kd,kd))/(36.*mZ**2*pi**2) - (121*g3bar**2*einsum("pt,sr",C["phiq1"],kd))/(1728.*pi**2) + (bEvan*g3bar**2*einsum("pt,sr",C["phiq1"],kd))/(48.*pi**2) + (121*g3bar**2*mW**2*einsum("pt,sr",C["phiq1"],kd))/(432.*mZ**2*pi**2) - (bEvan*g3bar**2*mW**2*einsum("pt,sr",C["phiq1"],kd))/(12.*mZ**2*pi**2) + (205*g3bar**2*einsum("pt,sr",C["phiq3"],kd))/(1728.*pi**2) - (bEvan*g3bar**2*einsum("pt,sr",C["phiq3"],kd))/(48.*pi**2) - (121*g3bar**2*mW**2*einsum("pt,sr",C["phiq3"],kd))/(432.*mZ**2*pi**2) + (bEvan*g3bar**2*mW**2*einsum("pt,sr",C["phiq3"],kd))/(12.*mZ**2*pi**2) - (121*g3bar**2*einsum("sr,pt",C["phiq1"],kd))/(1728.*pi**2) + (bEvan*g3bar**2*einsum("sr,pt",C["phiq1"],kd))/(48.*pi**2) + (121*g3bar**2*mW**2*einsum("sr,pt",C["phiq1"],kd))/(432.*mZ**2*pi**2) - (bEvan*g3bar**2*mW**2*einsum("sr,pt",C["phiq1"],kd))/(12.*mZ**2*pi**2) + (205*g3bar**2*einsum("sr,pt",C["phiq3"],kd))/(1728.*pi**2) - (bEvan*g3bar**2*einsum("sr,pt",C["phiq3"],kd))/(48.*pi**2) - (121*g3bar**2*mW**2*einsum("sr,pt",C["phiq3"],kd))/(432.*mZ**2*pi**2) + (bEvan*g3bar**2*mW**2*einsum("sr,pt",C["phiq3"],kd))/(12.*mZ**2*pi**2) + (121*g3bar**2*einsum("st,pr",C["phiq1"],kd))/(1728.*Nc*pi**2) - (bEvan*g3bar**2*einsum("st,pr",C["phiq1"],kd))/(48.*Nc*pi**2) - (121*g3bar**2*mW**2*einsum("st,pr",C["phiq1"],kd))/(432.*mZ**2*Nc*pi**2) + (bEvan*g3bar**2*mW**2*einsum("st,pr",C["phiq1"],kd))/(12.*mZ**2*Nc*pi**2) - (323*mW**2*einsum("st,pr",C["phiq1"],kd))/(972.*pi**2*vT**2) + (2*bEvan*mW**2*einsum("st,pr",C["phiq1"],kd))/(27.*pi**2*vT**2) - (377*mW**6*einsum("st,pr",C["phiq1"],kd))/(243.*mZ**4*pi**2*vT**2) + (8*bEvan*mW**6*einsum("st,pr",C["phiq1"],kd))/(27.*mZ**4*pi**2*vT**2) + (821*mW**4*einsum("st,pr",C["phiq1"],kd))/(486.*mZ**2*pi**2*vT**2) - (10*bEvan*mW**4*einsum("st,pr",C["phiq1"],kd))/(27.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("st,pr",C["phiq1"],kd))/(144.*pi**2*vT**2) - (205*g3bar**2*einsum("st,pr",C["phiq3"],kd))/(1728.*Nc*pi**2) + (bEvan*g3bar**2*einsum("st,pr",C["phiq3"],kd))/(48.*Nc*pi**2) + (121*g3bar**2*mW**2*einsum("st,pr",C["phiq3"],kd))/(432.*mZ**2*Nc*pi**2) - (bEvan*g3bar**2*mW**2*einsum("st,pr",C["phiq3"],kd))/(12.*mZ**2*Nc*pi**2) - (1087*mW**2*einsum("st,pr",C["phiq3"],kd))/(3888.*pi**2*vT**2) - (2*bEvan*mW**2*einsum("st,pr",C["phiq3"],kd))/(27.*pi**2*vT**2) + (377*mW**6*einsum("st,pr",C["phiq3"],kd))/(243.*mZ**4*pi**2*vT**2) - (8*bEvan*mW**6*einsum("st,pr",C["phiq3"],kd))/(27.*mZ**4*pi**2*vT**2) - (1351*mW**4*einsum("st,pr",C["phiq3"],kd))/(972.*mZ**2*pi**2*vT**2) + (10*bEvan*mW**4*einsum("st,pr",C["phiq3"],kd))/(27.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("st,pr",C["phiq3"],kd))/(144.*pi**2*vT**2) - (g3bar**2*einsum("pTTr,st,TT",C["qq1"],kd,kdt))/(96.*Nc*pi**2) - (mt**2*einsum("pTTr,st,TT",C["qq1"],kd,kdt))/(48.*pi**2*vT**2) + (mW**2*einsum("pTTr,st,TT",C["qq1"],kd,kdt))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("pTTr,st,TT",C["qq1"],kd,kdt))/(12.*mZ**2*pi**2*vT**2) - (mW**4*einsum("pTTr,st,TT",C["qq1"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) - (g3bar**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(96.*Nc*pi**2) - (mt**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(48.*pi**2*vT**2) + (mW**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(12.*mZ**2*pi**2*vT**2) - (mW**4*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) + (g3bar**2*einsum("pTTt,sr,TT",C["qq1"],kd,kdt))/(96.*pi**2) + (g3bar**2*einsum("pTTt,sr,TT",C["qq3"],kd,kdt))/(96.*pi**2) + (g3bar**2*einsum("sTTr,pt,TT",C["qq1"],kd,kdt))/(96.*pi**2) + (g3bar**2*einsum("sTTr,pt,TT",C["qq3"],kd,kdt))/(96.*pi**2) - (g3bar**2*einsum("sTTt,pr,TT",C["qq1"],kd,kdt))/(96.*Nc*pi**2) - (mt**2*einsum("sTTt,pr,TT",C["qq1"],kd,kdt))/(48.*pi**2*vT**2) + (mW**2*einsum("sTTt,pr,TT",C["qq1"],kd,kdt))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("sTTt,pr,TT",C["qq1"],kd,kdt))/(12.*mZ**2*pi**2*vT**2) - (mW**4*einsum("sTTt,pr,TT",C["qq1"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) - (g3bar**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(96.*Nc*pi**2) - (mt**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(48.*pi**2*vT**2) + (mW**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(12.*mZ**2*pi**2*vT**2) - (mW**4*einsum("sTTt,pr,TT",C["qq3"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) - (g3bar**2*einsum("TrpT,st,TT",C["qq1"],kd,kdt))/(96.*Nc*pi**2) - (mt**2*einsum("TrpT,st,TT",C["qq1"],kd,kdt))/(48.*pi**2*vT**2) + (mW**2*einsum("TrpT,st,TT",C["qq1"],kd,kdt))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("TrpT,st,TT",C["qq1"],kd,kdt))/(12.*mZ**2*pi**2*vT**2) - (mW**4*einsum("TrpT,st,TT",C["qq1"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) - (g3bar**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(96.*Nc*pi**2) - (mt**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(48.*pi**2*vT**2) + (mW**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(12.*mZ**2*pi**2*vT**2) - (mW**4*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) + (g3bar**2*einsum("TrsT,pt,TT",C["qq1"],kd,kdt))/(96.*pi**2) + (g3bar**2*einsum("TrsT,pt,TT",C["qq3"],kd,kdt))/(96.*pi**2) + (g3bar**2*einsum("TtpT,sr,TT",C["qq1"],kd,kdt))/(96.*pi**2) + (g3bar**2*einsum("TtpT,sr,TT",C["qq3"],kd,kdt))/(96.*pi**2) - (g3bar**2*einsum("TtsT,pr,TT",C["qq1"],kd,kdt))/(96.*Nc*pi**2) - (mt**2*einsum("TtsT,pr,TT",C["qq1"],kd,kdt))/(48.*pi**2*vT**2) + (mW**2*einsum("TtsT,pr,TT",C["qq1"],kd,kdt))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("TtsT,pr,TT",C["qq1"],kd,kdt))/(12.*mZ**2*pi**2*vT**2) - (mW**4*einsum("TtsT,pr,TT",C["qq1"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) - (g3bar**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(96.*Nc*pi**2) - (mt**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(48.*pi**2*vT**2) + (mW**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(12.*mZ**2*pi**2*vT**2) - (mW**4*einsum("TtsT,pr,TT",C["qq3"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) - (g3bar**3*vT*einsum("TT,pr,st,TT",C["uG"],kd,kd,kdt))/(96.*sqrt(2)*mt*Nc*pi**2) - (g3bar**3*vT*einsum("TT,pr,st,TT",C["uGDag"],kd,kd,kdt))/(96.*sqrt(2)*mt*Nc*pi**2) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(72.*sqrt(2)*mH**2*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(9.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(72.*sqrt(2)*mH**2*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(9.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (g3bar**3*vT*einsum("TT,pt,sr,TT",C["uG"],kd,kd,kdt))/(96.*sqrt(2)*mt*pi**2) + (g3bar**3*vT*einsum("TT,pt,sr,TT",C["uGDag"],kd,kd,kdt))/(96.*sqrt(2)*mt*pi**2) + (mH**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(96.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mH**2*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mH**4*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) - (mH**4*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) - (mH**2*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) - (mH**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(48.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(48.*pi**2) - (mW**4*C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*mZ**4*pi**2) + (mW**2*C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*mZ**2*pi**2) + (mH**4*mW**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (5*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (4*mH**6*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT**2) + (5*mH**6*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) + (4*mH**4*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) - (mH**6*mW**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (5*mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (4*mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (mH**2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (5*mH**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(144.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (4*mH**2*mW**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (5*mH**4*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (5*mH**4*mW**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (8*mH**2*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mH**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(72.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(36.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (5*mH**4*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(72.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mH**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mH**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(72.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (5*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (4*mH**6*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT**2) - (5*mH**6*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) - (4*mH**4*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) + (mH**6*mW**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (5*mH**4*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (4*mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (mH**2*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (g1bar*mH**4*mW*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(24.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (2*g1bar*mH**6*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT) - (2*g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**6*mW*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(72.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (2*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (mt**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(144.*pi**2*vT**4) - (mt**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(36.*mH**2*pi**2*vT**4) + (10*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*pi**2*vT**4) - (64*mW**8*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**6*pi**2*vT**4) + (mt**2*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**4) - (4*mt**4*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**4) + (40*mW**6*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**4) - (mt**2*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(18.*mZ**2*pi**2*vT**4) + (2*mt**4*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**2*pi**2*vT**4) - (22*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**4) + (16*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**6*pi**2*vT**2) - (20*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**2) + (4*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**2*pi**2*vT**2) - (mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(18.*mH**2*pi**2*vT**2) - (8*mt**4*mW**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**2) + (4*mt**4*mW**2*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**2*pi**2*vT**2) - (mt**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(144.*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(72.*mH**2*pi**2*vT**2) - (5*mW**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*pi**2*vT**2) - (64*mW**8*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**6*pi**2*vT**2) - (2*mt**4*mW**4*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**2) + (20*mW**6*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(36.*mZ**2*pi**2*vT**2) - (16*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**6*pi**2*vT**2) + (20*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**2) - (4*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**2*pi**2*vT**2) - (8*g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**6*pi**2*vT) - (128*g1bar*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**6*pi**2*vT) + (g1bar*mt**2*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT) + (2*g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT) + (148*g1bar*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**4*pi**2*vT) - (g1bar*mt**2*mW*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(36.*mZ**2*pi**2*vT) - (38*g1bar*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**2*pi**2*vT) + (mt**2*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(48.*pi**2*vT**2) + (5*mW**2*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) + (8*mW**6*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (13*mW**4*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (5*mW**2*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) - (8*mW**6*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(48.*pi**2*vT**2) + (5*mW**2*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) + (8*mW**6*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (13*mW**4*Nc*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (5*mW**2*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) - (8*mW**6*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("prTT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (mW**2*Nc*einsum("prTT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("prTT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("prTT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (mW**2*Nc*einsum("prTT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("prTT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("prTT,st,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (mW**2*Nc*einsum("prTT,st,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("prTT,st,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (g3bar**2*einsum("prTT,st,TT",C["qu8"],kd,kdt)*log(scale**2/mt**2))/(192.*Nc*pi**2) + (g3bar**2*einsum("pTTr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(96.*Nc*pi**2) + (mt**2*einsum("pTTr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (mW**2*einsum("pTTr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("pTTr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (mW**4*einsum("pTTr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (g3bar**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(96.*Nc*pi**2) + (mt**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (mW**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (mW**4*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (g3bar**2*einsum("ptTT,sr,TT",C["qu8"],kd,kdt)*log(scale**2/mt**2))/(192.*pi**2) - (g3bar**2*einsum("pTTt,sr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(96.*pi**2) - (g3bar**2*einsum("pTTt,sr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(96.*pi**2) - (g3bar**2*einsum("srTT,pt,TT",C["qu8"],kd,kdt)*log(scale**2/mt**2))/(192.*pi**2) - (g3bar**2*einsum("sTTr,pt,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(96.*pi**2) - (g3bar**2*einsum("sTTr,pt,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(96.*pi**2) + (mt**2*Nc*einsum("stTT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (mW**2*Nc*einsum("stTT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("stTT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("stTT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("stTT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (mW**2*Nc*einsum("stTT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("stTT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("stTT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("stTT,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (mW**2*Nc*einsum("stTT,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("stTT,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("stTT,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (g3bar**2*einsum("stTT,pr,TT",C["qu8"],kd,kdt)*log(scale**2/mt**2))/(192.*Nc*pi**2) + (g3bar**2*einsum("sTTt,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(96.*Nc*pi**2) + (mt**2*einsum("sTTt,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (mW**2*einsum("sTTt,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("sTTt,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (mW**4*einsum("sTTt,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (g3bar**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(96.*Nc*pi**2) + (mt**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (mW**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (mW**4*einsum("sTTt,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (g3bar**2*einsum("TrpT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(96.*Nc*pi**2) + (mt**2*einsum("TrpT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (mW**2*einsum("TrpT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("TrpT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (mW**4*einsum("TrpT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (g3bar**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(96.*Nc*pi**2) + (mt**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (mW**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (mW**4*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (g3bar**2*einsum("TrsT,pt,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(96.*pi**2) - (g3bar**2*einsum("TrsT,pt,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(96.*pi**2) + (mt**2*Nc*einsum("TTpr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (mW**2*Nc*einsum("TTpr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TTpr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("TTpr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TTpr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (mW**2*Nc*einsum("TTpr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TTpr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("TTpr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (g3bar**2*einsum("TtpT,sr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(96.*pi**2) - (g3bar**2*einsum("TtpT,sr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(96.*pi**2) + (g3bar**2*einsum("TtsT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(96.*Nc*pi**2) + (mt**2*einsum("TtsT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (mW**2*einsum("TtsT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("TtsT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (mW**4*einsum("TtsT,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (g3bar**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(96.*Nc*pi**2) + (mt**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (mW**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (mW**4*einsum("TtsT,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TTst,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (mW**2*Nc*einsum("TTst,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TTst,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("TTst,pr,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TTst,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(48.*pi**2*vT**2) - (mW**2*Nc*einsum("TTst,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TTst,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("TTst,pr,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*pi**2*vT**2) + (2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*pi**2*vT**2) - (2*mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**2) + (8*mW**6*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) - (10*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*pi**2*vT**2) - (2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*pi**2*vT**2) + (2*mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**2) - (8*mW**6*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) + (10*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*pi**2*vT**2) + (2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*pi**2*vT**2) + (2*mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**2) + (8*mW**6*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) - (10*mW**4*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) + (17*g1bar*mt*mW**4*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*sqrt(2)*mZ**4*pi**2*vT) - (13*g1bar*mt*mW**2*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*sqrt(2)*mZ**2*pi**2*vT) + (17*g1bar*mt*mW**4*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*sqrt(2)*mZ**4*pi**2*vT) - (13*g1bar*mt*mW**2*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*sqrt(2)*mZ**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*sqrt(2)*mH**2*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*sqrt(2)*mH**2*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*sqrt(2)*mH**2*mZ**2*pi**2*vT) - (5*mt*mW*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(54.*sqrt(2)*pi**2*vT**2) + (41*mt*mW**3*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(54.*sqrt(2)*mZ**2*pi**2*vT**2) - (5*mt*mW*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(54.*sqrt(2)*pi**2*vT**2) + (41*mt*mW**3*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(54.*sqrt(2)*mZ**2*pi**2*vT**2) + (31*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(432.*pi**2*vT**4) + (mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(24.*mH**2*pi**2*vT**4) + (28*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(9.*mZ**6*pi**2*vT**4) - (112*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(27.*mZ**4*pi**2*vT**4) + (2*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**4*pi**2*vT**4) + (7*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(9.*mZ**2*pi**2*vT**4) - (mW**6*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**2*pi**2*vT**4) + (g3bar**2*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(24.*Nc*pi**2*vT**2) - (8*mW**10*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**6*pi**2*vT**2) + (10*mW**8*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**4*pi**2*vT**2) - (2*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**2*pi**2*vT**2) + (mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(12.*mH**2*pi**2*vT**2) + (4*mW**8*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**4*pi**2*vT**2) - (2*mW**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**2*pi**2*vT**2) - (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(48.*mH**2*pi**2*vT**2) + (28*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(9.*mZ**6*pi**2*vT**2) - (119*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(54.*mZ**4*pi**2*vT**2) + (mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**4*pi**2*vT**2) + (mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(12.*mH**2*pi**2*vT**2) + (8*mW**10*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**6*pi**2*vT**2) - (2*mW**8*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**4*pi**2*vT**2) + (44*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(9.*mZ**6*pi**2*vT) + (4*g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**6*pi**2*vT) - (67*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(18.*mZ**4*pi**2*vT) - (g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**4*pi**2*vT) + (25*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(108.*mZ**2*pi**2*vT) - (mW**3*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*pi**2*vT**3) + (16*mW**9*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mZ**6*pi**2*vT**3) - (64*mW**7*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mZ**4*pi**2*vT**3) + (17*mW**5*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mZ**2*pi**2*vT**3) - (7*mW**6*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mW**2))/(6.*mZ**4*pi**2*vT**2) + (7*mW**4*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mW**2))/(6.*mZ**2*pi**2*vT**2) + (g3bar**2*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mW**2))/(24.*Nc*pi**2) + (31*mW**2*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mW**2))/(216.*pi**2*vT**2) + (7*mW**6*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mW**2))/(6.*mZ**4*pi**2*vT**2) - (91*mW**4*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mW**2))/(54.*mZ**2*pi**2*vT**2) - (g3bar**2*einsum("pt,sr",kd,kd)*log(scale**2/mW**2))/(24.*pi**2*vT**2) - (g3bar**2*einsum("pt,sr",C["phiq3"],kd)*log(scale**2/mW**2))/(24.*pi**2) - (g3bar**2*einsum("sr,pt",C["phiq3"],kd)*log(scale**2/mW**2))/(24.*pi**2) - (7*mW**6*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mW**2))/(6.*mZ**4*pi**2*vT**2) + (7*mW**4*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mW**2))/(6.*mZ**2*pi**2*vT**2) + (g3bar**2*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mW**2))/(24.*Nc*pi**2) + (31*mW**2*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mW**2))/(216.*pi**2*vT**2) + (7*mW**6*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mW**2))/(6.*mZ**4*pi**2*vT**2) - (91*mW**4*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mW**2))/(54.*mZ**2*pi**2*vT**2) + (mW**2*einsum("prst",C["qq1"])*log(scale**2/mZ**2))/(6.*pi**2*vT**2) - (mW**4*einsum("prst",C["qq1"])*log(scale**2/mZ**2))/(3.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("prst",C["qq1"])*log(scale**2/mZ**2))/(48.*pi**2*vT**2) + (mW**2*einsum("prst",C["qq3"])*log(scale**2/mZ**2))/(6.*pi**2*vT**2) - (mW**4*einsum("prst",C["qq3"])*log(scale**2/mZ**2))/(3.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("prst",C["qq3"])*log(scale**2/mZ**2))/(48.*pi**2*vT**2) + (mW**2*einsum("stpr",C["qq1"])*log(scale**2/mZ**2))/(6.*pi**2*vT**2) - (mW**4*einsum("stpr",C["qq1"])*log(scale**2/mZ**2))/(3.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("stpr",C["qq1"])*log(scale**2/mZ**2))/(48.*pi**2*vT**2) + (mW**2*einsum("stpr",C["qq3"])*log(scale**2/mZ**2))/(6.*pi**2*vT**2) - (mW**4*einsum("stpr",C["qq3"])*log(scale**2/mZ**2))/(3.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("stpr",C["qq3"])*log(scale**2/mZ**2))/(48.*pi**2*vT**2) - (11*mH**2*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (5*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(54.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (176*mH**2*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**4) - (88*mH**2*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) - (176*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) + (11*mH**2*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(27.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) + (88*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) - (199*mW**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(972.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (mW**4*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(32.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mW**2*mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (mZ**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(48.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (11*g3bar**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(864.*Nc*pi**2*vT**2) + (11*g3bar**2*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(54.*mZ**4*Nc*pi**2*vT**2) - (11*g3bar**2*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(108.*mZ**2*Nc*pi**2*vT**2) + (8*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (40*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(9.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (2*mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (17*mH**2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(24.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (53*mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(9.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (2*mW**6*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mH**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(24.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (55*mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(36.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (8*mW**4*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mZ**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(12.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (17*mW**2*mZ**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(24.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mZ**8*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(24.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (2*mW**4*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(16.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**2*mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mZ**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(24.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (11*g3bar**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(1728.*Nc*pi**2) + (11*g3bar**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(108.*mZ**4*Nc*pi**2) + (11*mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(486.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (176*mH**2*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (44*mH**2*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (176*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (44*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (287*mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(1944.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**4*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**2*mZ**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(12.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (2*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (40*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(9.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (2*mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (3*mH**2*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (41*mW**4*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(9.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (2*mW**6*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (31*mW**2*mZ**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(36.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (2*mW**4*mZ**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (3*mW**2*mZ**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (301*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(486.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (848*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (352*g1bar*mH**4*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT) - (308*g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) - (704*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) + (55*g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (859*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (352*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**2*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(48.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (217*g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mW**5*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mW*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(36.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mW**3*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mW*mZ**6*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(48.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (11*g1bar*g3bar**2*mW**3*vT*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(54.*mZ**4*Nc*pi**2) - (11*g1bar*g3bar**2*mW*vT*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(216.*mZ**2*Nc*pi**2) + (11*g3bar**2*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mZ**2))/(288.*Nc*pi**2) - (11*g3bar**2*mW**2*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mZ**2))/(72.*mZ**2*Nc*pi**2) - (11*mW**2*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mZ**2))/(81.*pi**2*vT**2) - (44*mW**6*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mZ**2))/(81.*mZ**4*pi**2*vT**2) + (55*mW**4*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mZ**2))/(81.*mZ**2*pi**2*vT**2) - (11*g3bar**2*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mZ**2))/(288.*Nc*pi**2) + (11*g3bar**2*mW**2*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mZ**2))/(72.*mZ**2*Nc*pi**2) + (11*mW**2*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mZ**2))/(81.*pi**2*vT**2) + (44*mW**6*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mZ**2))/(81.*mZ**4*pi**2*vT**2) - (55*mW**4*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mZ**2))/(81.*mZ**2*pi**2*vT**2) - (11*g3bar**2*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(864.*pi**2*vT**2) - (11*g3bar**2*mW**4*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(54.*mZ**4*pi**2*vT**2) + (11*g3bar**2*mW**2*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(108.*mZ**2*pi**2*vT**2) + (11*g3bar**2*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(1728.*pi**2) - (11*g3bar**2*mW**4*C["phiD"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(108.*mZ**4*pi**2) - (11*g1bar*g3bar**2*mW**3*vT*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(54.*mZ**4*pi**2) + (11*g1bar*g3bar**2*mW*vT*C["phiWB"]*einsum("pt,sr",kd,kd)*log(scale**2/mZ**2))/(216.*mZ**2*pi**2) - (11*g3bar**2*einsum("pt,sr",C["phiq1"],kd)*log(scale**2/mZ**2))/(288.*pi**2) + (11*g3bar**2*mW**2*einsum("pt,sr",C["phiq1"],kd)*log(scale**2/mZ**2))/(72.*mZ**2*pi**2) + (11*g3bar**2*einsum("pt,sr",C["phiq3"],kd)*log(scale**2/mZ**2))/(288.*pi**2) - (11*g3bar**2*mW**2*einsum("pt,sr",C["phiq3"],kd)*log(scale**2/mZ**2))/(72.*mZ**2*pi**2) - (11*g3bar**2*einsum("sr,pt",C["phiq1"],kd)*log(scale**2/mZ**2))/(288.*pi**2) + (11*g3bar**2*mW**2*einsum("sr,pt",C["phiq1"],kd)*log(scale**2/mZ**2))/(72.*mZ**2*pi**2) + (11*g3bar**2*einsum("sr,pt",C["phiq3"],kd)*log(scale**2/mZ**2))/(288.*pi**2) - (11*g3bar**2*mW**2*einsum("sr,pt",C["phiq3"],kd)*log(scale**2/mZ**2))/(72.*mZ**2*pi**2) + (11*g3bar**2*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mZ**2))/(288.*Nc*pi**2) - (11*g3bar**2*mW**2*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mZ**2))/(72.*mZ**2*Nc*pi**2) - (11*mW**2*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mZ**2))/(81.*pi**2*vT**2) - (44*mW**6*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mZ**2))/(81.*mZ**4*pi**2*vT**2) + (55*mW**4*einsum("st,pr",C["phiq1"],kd)*log(scale**2/mZ**2))/(81.*mZ**2*pi**2*vT**2) - (11*g3bar**2*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mZ**2))/(288.*Nc*pi**2) + (11*g3bar**2*mW**2*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mZ**2))/(72.*mZ**2*Nc*pi**2) + (11*mW**2*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mZ**2))/(81.*pi**2*vT**2) + (44*mW**6*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mZ**2))/(81.*mZ**4*pi**2*vT**2) - (55*mW**4*einsum("st,pr",C["phiq3"],kd)*log(scale**2/mZ**2))/(81.*mZ**2*pi**2*vT**2) - (2*g1bar*mW**6*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**4*pi**2*vT) + (2*g1bar*mW**4*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**2*pi**2*vT) - (2*g1bar*mW**6*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**4*pi**2*vT) + (2*g1bar*mW**4*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**2*pi**2*vT) + (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*sqrt(2))/(9.*mH**2*mZ**4*pi**2*vT) + (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*sqrt(2))/(9.*mH**2*mZ**4*pi**2*vT) + (4*mW**3*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(81.*mt*pi**2*vT**2) + (4*mW**7*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**4*pi**2*vT**2) - (8*mW**5*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**2*pi**2*vT**2) + (4*mW**3*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*pi**2*vT**2) + (4*mW**7*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**4*pi**2*vT**2) - (8*mW**5*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**2*pi**2*vT**2) - (8*g1bar*mt*mW**6*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**6*pi**2*vT) - (8*g1bar*mt*mW**6*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**6*pi**2*vT) + (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*mH**2*mZ**4*pi**2*vT) + (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*mH**2*mZ**4*pi**2*vT) + (16*mt*mW**7*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**6*pi**2*vT**2) - (25*mt*mW**5*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**4*pi**2*vT**2) + (16*mt*mW**7*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**6*pi**2*vT**2) - (25*mt*mW**5*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**4*pi**2*vT**2))
    c['V1ddLR'] = (-(mW**2*einsum("prst",C["qd1"]))/(24.*pi**2*vT**2) + (cEvan*mW**2*einsum("prst",C["qd1"]))/(18.*pi**2*vT**2) + (mW**4*einsum("prst",C["qd1"]))/(12.*mZ**2*pi**2*vT**2) - (cEvan*mW**4*einsum("prst",C["qd1"]))/(9.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("prst",C["qd1"]))/(24.*pi**2*vT**2) + (cEvan*mZ**2*einsum("prst",C["qd1"]))/(18.*pi**2*vT**2) - (7*mH**2*einsum("pr,st",kd,kd))/(144.*pi**2*vT**4) - (6743*mW**2*einsum("pr,st",kd,kd))/(58320.*pi**2*vT**4) + (2*cEvan*mW**2*einsum("pr,st",kd,kd))/(81.*pi**2*vT**4) + (40*mW**8*einsum("pr,st",kd,kd))/(729.*mZ**6*pi**2*vT**4) + (4*cEvan*mW**8*einsum("pr,st",kd,kd))/(81.*mZ**6*pi**2*vT**4) + (7*mH**2*mW**4*einsum("pr,st",kd,kd))/(72.*mZ**4*pi**2*vT**4) + (313*mW**6*einsum("pr,st",kd,kd))/(2430.*mZ**4*pi**2*vT**4) - (2*cEvan*mW**6*einsum("pr,st",kd,kd))/(27.*mZ**4*pi**2*vT**4) + (mW**8*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**4) - (7*mH**2*mW**2*einsum("pr,st",kd,kd))/(144.*mZ**2*pi**2*vT**4) - (101*mW**4*einsum("pr,st",kd,kd))/(1080.*mZ**2*pi**2*vT**4) - (mW**6*einsum("pr,st",kd,kd))/(18.*mH**2*mZ**2*pi**2*vT**4) + (11*mZ**2*einsum("pr,st",kd,kd))/(432.*pi**2*vT**4) - (mW**2*mZ**2*einsum("pr,st",kd,kd))/(36.*mH**2*pi**2*vT**4) - (mZ**4*einsum("pr,st",kd,kd))/(36.*mH**2*pi**2*vT**4) + (mt**4*Nc*einsum("pr,st",kd,kd))/(9.*mH**2*pi**2*vT**4) - (16*mW**4*Nc*einsum("pr,st",kd,kd))/(1215.*mt**2*pi**2*vT**4) - (2*mt**4*mW**4*Nc*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**4) - (16*mW**8*Nc*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**4*pi**2*vT**4) + (mt**4*mW**2*Nc*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**2*pi**2*vT**4) + (32*mW**6*Nc*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**2*pi**2*vT**4) + (C["phi"]*einsum("pr,st",kd,kd))/(12.*pi**2) - (mW**4*C["phi"]*einsum("pr,st",kd,kd))/(6.*mZ**4*pi**2) + (mW**2*C["phi"]*einsum("pr,st",kd,kd))/(12.*mZ**2*pi**2) + (mH**2*mW**2*C["phiB"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (31*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(36.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (4*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (2*mH**4*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (4*mW**10*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (5*mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (5*mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (4*mW**10*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**2*C["phiB"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (5*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (7*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (5*mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (5*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(36.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (4*mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(18.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mZ**6*C["phiB"]*einsum("pr,st",kd,kd))/(18.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (2*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (8*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (10*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (8*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (10*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (11*mH**2*C["phiBox"]*einsum("pr,st",kd,kd))/(72.*pi**2*vT**2) + (5*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(72.*pi**2*vT**2) + (11*mH**2*mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(36.*mZ**4*pi**2*vT**2) + (2*mW**8*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) - (11*mH**2*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(72.*mZ**2*pi**2*vT**2) - (5*mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(36.*mZ**2*pi**2*vT**2) - (mW**6*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**2*pi**2*vT**2) + (5*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(72.*pi**2*vT**2) - (mW**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(18.*mH**2*pi**2*vT**2) - (mZ**4*C["phiBox"]*einsum("pr,st",kd,kd))/(18.*mH**2*pi**2*vT**2) + (2*mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*pi**2*vT**2) - (4*mt**4*mW**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**2*pi**2*vT**2) + (mH**2*C["phiD"]*einsum("pr,st",kd,kd))/(18.*pi**2*vT**2) + (697*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(23328.*pi**2*vT**2) - (cEvan*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(81.*pi**2*vT**2) + (mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(12.*mH**2*pi**2*vT**2) + (40*mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(729.*mZ**6*pi**2*vT**2) + (4*cEvan*mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(81.*mZ**6*pi**2*vT**2) - (mH**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(72.*mZ**4*pi**2*vT**2) + (781*mW**6*C["phiD"]*einsum("pr,st",kd,kd))/(4860.*mZ**4*pi**2*vT**2) - (cEvan*mW**6*C["phiD"]*einsum("pr,st",kd,kd))/(27.*mZ**4*pi**2*vT**2) + (mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(18.*mH**2*mZ**4*pi**2*vT**2) + (mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(32.*mZ**2*pi**2*vT**2) - (167*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(1620.*mZ**2*pi**2*vT**2) + (mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(108.*pi**2*vT**2) - (mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(72.*mH**2*pi**2*vT**2) - (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(18.*mH**2*pi**2*vT**2) - (mt**4*mW**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) - (16*mW**8*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**4*pi**2*vT**2) + (16*mW**6*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**2*pi**2*vT**2) - (mH**2*mW**2*C["phiW"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (31*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(36.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mH**4*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (4*mW**10*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (5*mH**4*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mW**8*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (4*mW**10*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**2*C["phiW"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (5*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (2*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mW**8*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (4*mW**4*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (8*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (10*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (8*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (2*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (10*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (5*g1bar*mH**2*mW*C["phiWB"]*einsum("pr,st",kd,kd))/(432.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (571*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(3645.*(mH - mZ)*(mH + mZ)*pi**2*vT) + (cEvan*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(6.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (242*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(729.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (8*cEvan*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (2*g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(72.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (1859*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(14580.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (7*cEvan*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (565*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(1458.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (8*cEvan*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (2*g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (g1bar*mH**4*mW*C["phiWB"]*einsum("pr,st",kd,kd))/(96.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (113*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(29160.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (cEvan*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (4289*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(14580.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (7*cEvan*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(18.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (13*g1bar*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(864.*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(18.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mW*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd))/(36.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) - (32*g1bar*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*mt**2*(mH - mZ)*(mH + mZ)*pi**2*vT) - (4*g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (4*g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (32*g1bar*mH**2*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*mt**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (32*g1bar*mH**2*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*mt**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (32*g1bar*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*mt**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (mW**3*C["W"]*einsum("pr,st",kd,kd))/(6.*pi**2*vT**3) + (2*mW**7*C["W"]*einsum("pr,st",kd,kd))/(3.*mZ**4*pi**2*vT**3) - (5*mW**5*C["W"]*einsum("pr,st",kd,kd))/(6.*mZ**2*pi**2*vT**3) - (10*mW**2*einsum("pr,st",C["phiq1"],kd))/(243.*pi**2*vT**2) + (2*cEvan*mW**2*einsum("pr,st",C["phiq1"],kd))/(27.*pi**2*vT**2) - (41*mW**6*einsum("pr,st",C["phiq1"],kd))/(486.*mZ**4*pi**2*vT**2) + (2*cEvan*mW**6*einsum("pr,st",C["phiq1"],kd))/(27.*mZ**4*pi**2*vT**2) + (44*mW**4*einsum("pr,st",C["phiq1"],kd))/(243.*mZ**2*pi**2*vT**2) - (4*cEvan*mW**4*einsum("pr,st",C["phiq1"],kd))/(27.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("pr,st",C["phiq1"],kd))/(18.*pi**2*vT**2) - (415*mW**2*einsum("pr,st",C["phiq3"],kd))/(972.*pi**2*vT**2) + (2*cEvan*mW**2*einsum("pr,st",C["phiq3"],kd))/(27.*pi**2*vT**2) - (41*mW**6*einsum("pr,st",C["phiq3"],kd))/(486.*mZ**4*pi**2*vT**2) + (2*cEvan*mW**6*einsum("pr,st",C["phiq3"],kd))/(27.*mZ**4*pi**2*vT**2) + (551*mW**4*einsum("pr,st",C["phiq3"],kd))/(972.*mZ**2*pi**2*vT**2) - (4*cEvan*mW**4*einsum("pr,st",C["phiq3"],kd))/(27.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("pr,st",C["phiq3"],kd))/(18.*pi**2*vT**2) + (20*mW**2*einsum("st,pr",C["phid"],kd))/(243.*pi**2*vT**2) - (cEvan*mW**2*einsum("st,pr",C["phid"],kd))/(27.*pi**2*vT**2) - (41*mW**6*einsum("st,pr",C["phid"],kd))/(486.*mZ**4*pi**2*vT**2) + (2*cEvan*mW**6*einsum("st,pr",C["phid"],kd))/(27.*mZ**4*pi**2*vT**2) - (25*mW**4*einsum("st,pr",C["phid"],kd))/(972.*mZ**2*pi**2*vT**2) - (cEvan*mW**4*einsum("st,pr",C["phid"],kd))/(27.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("st,pr",C["phid"],kd))/(36.*pi**2*vT**2) - (3*mt**4*einsum("pTst,rT,TT",C["qd1"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("pTst,rT,TT",C["qd1"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(6.*pi**2*vT**2) - (2*mW**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(6.*mZ**2*pi**2*vT**2) + (2*mW**4*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) + (mt**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(6.*pi**2*vT**2) - (2*mW**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(6.*mZ**2*pi**2*vT**2) + (2*mW**4*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) - (3*mt**4*einsum("Trst,pT,TT",C["qd1"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("Trst,pT,TT",C["qd1"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (mt**4*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt))/(32.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (mt**2*mW**2*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt))/(32.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**4*mW**2*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt))/(32.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) + (mt**2*mW**4*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt))/(32.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) + (5*mt**8*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(96.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (311*mt**6*mW**2*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(864.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (769*mt**4*mW**4*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(864.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (151*mt**2*mW**6*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(288.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (2*mW**8*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (5*mt**8*mW**2*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(96.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (311*mt**6*mW**4*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(864.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (769*mt**4*mW**6*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(864.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (151*mt**2*mW**8*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(288.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (2*mW**10*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mt**7*mW*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(2.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (59*mt**5*mW**3*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(108.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (35*mt**3*mW**5*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(108.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (17*mt*mW**7*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(54.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**7*mW**3*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(2.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (59*mt**5*mW**5*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(108.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (35*mt**3*mW**7*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(108.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (17*mt*mW**9*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(54.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mt**8*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(12.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) + (179*mt**6*mW**2*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(216.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) - (307*mt**4*mW**4*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(216.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) + (13*mt**2*mW**6*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(18.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) - (2*mW**8*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) + (mt**8*mW**2*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(12.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) - (179*mt**6*mW**4*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(216.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) + (307*mt**4*mW**6*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(216.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) - (13*mt**2*mW**8*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(18.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) + (2*mW**10*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) + (mt**8*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(96.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (3*mt**6*mW**2*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(32.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (5*mt**4*mW**4*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(32.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (7*mt**2*mW**6*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(96.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**8*mW**2*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(32.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (277*mt**6*mW**4*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(864.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (479*mt**4*mW**6*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(864.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (83*mt**2*mW**8*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(288.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mW**10*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (g1bar*mt**8*mW*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(24.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (29*g1bar*mt**6*mW**3*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(54.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (113*g1bar*mt**4*mW**5*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(108.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (43*g1bar*mt**2*mW**7*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(72.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (2*g1bar*mW**9*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (3*mt**4*mW**3*C["W"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**3) - (mt**2*mW**5*C["W"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**3) - (3*mt**4*mW**5*C["W"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(4.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**3) + (mt**2*mW**7*C["W"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(4.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**3) + (mt**4*einsum("st,pT,rT,TT",C["phid"],kd,kd,kdt))/((32*mt**2 - 32*mW**2)*pi**2*vT**2) - (7*mt**2*mW**2*einsum("st,pT,rT,TT",C["phid"],kd,kd,kdt))/((32*mt**2 - 32*mW**2)*pi**2*vT**2) - (mt**4*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt))/(32.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (mt**2*mW**2*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt))/(32.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**4*mW**2*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt))/(32.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) + (mt**2*mW**4*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt))/(32.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) + (5*mt**8*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(96.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (311*mt**6*mW**2*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(864.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (769*mt**4*mW**4*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(864.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (151*mt**2*mW**6*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(288.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (2*mW**8*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (5*mt**8*mW**2*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(96.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (311*mt**6*mW**4*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(864.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (769*mt**4*mW**6*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(864.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (151*mt**2*mW**8*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(288.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (2*mW**10*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mt**7*mW*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(2.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (59*mt**5*mW**3*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(108.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (35*mt**3*mW**5*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(108.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (17*mt*mW**7*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(54.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**7*mW**3*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(2.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (59*mt**5*mW**5*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(108.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (35*mt**3*mW**7*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(108.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (17*mt*mW**9*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(54.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(18.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(9.*sqrt(2)*mH**2*mZ**4*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(18.*sqrt(2)*mH**2*mZ**2*pi**2*vT) - (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(18.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(9.*sqrt(2)*mH**2*mZ**4*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(18.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (mt**2*einsum("TTst,pT,rT,TT",C["qd1"],kd,kd,kdt))/(8.*pi**2*vT**2) - (mt**4*einsum("TTst,pT,rT,TT",C["ud1"],kd,kd,kdt))/(32.*(mt**2 - mW**2)*pi**2*vT**2) + (7*mt**2*mW**2*einsum("TTst,pT,rT,TT",C["ud1"],kd,kd,kdt))/(32.*(mt**2 - mW**2)*pi**2*vT**2) + (mt**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiq1"],kdt))/(12.*pi**2*vT**2) - (mt**2*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiq1"],kdt))/(12.*mZ**2*pi**2*vT**2) - (mt**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiq3"],kdt))/(12.*pi**2*vT**2) + (mt**2*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiq3"],kdt))/(12.*mZ**2*pi**2*vT**2) - (mt**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(48.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (7*mt**2*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(48.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**4*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(48.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) - (7*mt**2*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(48.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) + (g1bar*mt**5*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uB"],kdt))/(48.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) + (g1bar*mt**3*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uB"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) - (g1bar*mt*mW**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uB"],kdt))/(24.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) + (g1bar*mt**5*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uBDag"],kdt))/(48.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) + (g1bar*mt**3*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uBDag"],kdt))/(16.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) - (g1bar*mt*mW**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uBDag"],kdt))/(24.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) + (mt**5*mW*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt))/(24.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**3*mW**3*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt))/(12.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**5*mW**3*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt))/(24.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**3*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt*mW**7*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt))/(12.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**5*mW*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(24.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**3*mW**3*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(12.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**5*mW**3*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(24.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**3*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt*mW**7*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(12.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mH**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(24.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mH**2*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mH**4*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) - (mH**4*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(24.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) - (mH**2*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) + (mH**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*pi**2) - (mW**4*C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*mZ**4*pi**2) + (mW**2*C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*mZ**2*pi**2) + (mH**4*mW**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (5*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (2*mH**6*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT**2) + (5*mH**6*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) + (2*mH**4*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) - (mH**6*mW**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (5*mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (2*mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (mH**2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (5*mH**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(36.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mH**2*mW**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (5*mH**4*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (5*mH**4*mW**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(36.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (4*mH**2*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (2*mH**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(72.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(36.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (5*mH**4*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(144.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mH**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mH**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (5*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (2*mH**6*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT**2) - (5*mH**6*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) - (2*mH**4*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) + (mH**6*mW**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (5*mH**4*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (2*mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (mH**2*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (g1bar*mH**4*mW*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(48.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**6*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**6*mW*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(144.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) - (mt**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(36.*pi**2*vT**4) + (mt**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*pi**2*vT**4) + (5*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*pi**2*vT**4) - (32*mW**8*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**6*pi**2*vT**4) + (mt**2*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(18.*mZ**4*pi**2*vT**4) - (2*mt**4*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**4) + (20*mW**6*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**4) - (mt**2*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(36.*mZ**2*pi**2*vT**4) + (mt**4*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**2*pi**2*vT**4) - (11*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**4) + (8*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**6*pi**2*vT**2) - (10*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**2*pi**2*vT**2) + (2*mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*pi**2*vT**2) - (4*mt**4*mW**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**2) + (2*mt**4*mW**2*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**2*pi**2*vT**2) + (mt**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(36.*pi**2*vT**2) - (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(18.*mH**2*pi**2*vT**2) - (5*mW**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(486.*pi**2*vT**2) - (32*mW**8*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**6*pi**2*vT**2) - (mt**4*mW**4*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**2) + (10*mW**6*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(72.*mZ**2*pi**2*vT**2) - (8*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**6*pi**2*vT**2) + (10*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**2) - (2*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**2*pi**2*vT**2) - (4*g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**6*pi**2*vT) - (64*g1bar*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**6*pi**2*vT) + (g1bar*mt**2*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(18.*mZ**4*pi**2*vT) + (g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT) + (74*g1bar*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**4*pi**2*vT) - (g1bar*mt**2*mW*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(72.*mZ**2*pi**2*vT) - (19*g1bar*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**2*pi**2*vT) - (mt**2*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(12.*pi**2*vT**2) - (5*mW**2*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) - (8*mW**6*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(12.*pi**2*vT**2) - (5*mW**2*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) - (8*mW**6*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("st,pr",C["phid"],kd)*log(scale**2/mt**2))/(24.*pi**2*vT**2) - (5*mW**2*Nc*einsum("st,pr",C["phid"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) - (8*mW**6*Nc*einsum("st,pr",C["phid"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("st,pr",C["phid"],kd)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("st,pr",C["phid"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("prTT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) + (mW**2*Nc*einsum("prTT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("prTT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("prTT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) - (mW**2*Nc*einsum("prTT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("prTT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("prTT,st,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) + (mW**2*Nc*einsum("prTT,st,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("prTT,st,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**6*einsum("pTst,rT,TT",C["qd1"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("pTst,rT,TT",C["qd1"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("pTst,rT,TT",C["qd1"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(6.*pi**2*vT**2) + (2*mW**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) - (2*mW**4*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(6.*pi**2*vT**2) + (2*mW**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) - (2*mW**4*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**6*einsum("Trst,pT,TT",C["qd1"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("Trst,pT,TT",C["qd1"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("Trst,pT,TT",C["qd1"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*Nc*einsum("TTpr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) + (mW**2*Nc*einsum("TTpr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TTpr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("TTpr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TTpr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) - (mW**2*Nc*einsum("TTpr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TTpr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (mW**4*Nc*einsum("TTpr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TTst,pr,TT",C["qd1"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*Nc*einsum("TTst,pr,TT",C["qd1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TTst,pr,TT",C["qd1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("TTst,pr,TT",C["qd1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TTst,pr,TT",C["ud1"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*Nc*einsum("TTst,pr,TT",C["ud1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TTst,pr,TT",C["ud1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("TTst,pr,TT",C["ud1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**6*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*mW**2*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**4*mW**4*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**2*mW**6*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (7*mt**10*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (13*mt**8*mW**2*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (109*mt**6*mW**4*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(144.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (25*mt**4*mW**6*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (59*mt**2*mW**8*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (2*mW**10*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (7*mt**10*mW**2*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (13*mt**8*mW**4*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (109*mt**6*mW**6*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(144.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (25*mt**4*mW**8*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (59*mt**2*mW**10*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (2*mW**12*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (g1bar*mt*mW**4*einsum("pT,st,rT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT) - (5*mt**7*mW**3*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (3*mt**5*mW**5*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (5*mt**3*mW**7*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt*mW**9*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*mt**7*mW**5*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (3*mt**5*mW**7*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (5*mt**3*mW**9*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt*mW**11*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (2*mt**8*mW**2*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(9.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (mt**6*mW**4*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(18.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (7*mt**4*mW**6*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (25*mt**2*mW**8*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(54.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (2*mW**10*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (2*mt**8*mW**4*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (mt**6*mW**6*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(18.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (7*mt**4*mW**8*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (25*mt**2*mW**10*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(54.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (2*mW**12*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (mt**10*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt**8*mW**2*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (3*mt**6*mW**4*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*mt**4*mW**6*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt**2*mW**8*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt**10*mW**2*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (7*mt**8*mW**4*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(36.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (31*mt**6*mW**6*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(144.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt**4*mW**8*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (4*mt**2*mW**10*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mW**12*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (13*g1bar*mt**8*mW**3*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (5*g1bar*mt**6*mW**5*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(36.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (3*g1bar*mt**4*mW**7*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) - (41*g1bar*mt**2*mW**9*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(108.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (2*g1bar*mW**11*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (mt**6*mW**3*C["W"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(2.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**3) - (mt**6*mW**5*C["W"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(2.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**3) - (mt**6*einsum("st,pT,rT,TT",C["phid"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("st,pT,rT,TT",C["phid"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("st,pT,rT,TT",C["phid"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*mW**2*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**4*mW**4*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**2*mW**6*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (7*mt**10*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (13*mt**8*mW**2*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (109*mt**6*mW**4*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(144.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (25*mt**4*mW**6*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (59*mt**2*mW**8*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (2*mW**10*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (7*mt**10*mW**2*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(48.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (13*mt**8*mW**4*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(36.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (109*mt**6*mW**6*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(144.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (25*mt**4*mW**8*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (59*mt**2*mW**10*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (2*mW**12*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (g1bar*mt*mW**4*einsum("Tr,st,pT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT) - (5*mt**7*mW**3*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (3*mt**5*mW**5*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (5*mt**3*mW**7*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt*mW**9*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*mt**7*mW**5*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (3*mt**5*mW**7*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(2.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (5*mt**3*mW**9*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt*mW**11*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*pi**2*vT**2) + (mW**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*pi**2*vT**2) - (mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**2) + (4*mW**6*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*mZ**2*pi**2*vT**2) - (5*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*pi**2*vT**2) - (mW**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*pi**2*vT**2) + (mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**2) - (4*mW**6*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*mZ**2*pi**2*vT**2) + (5*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*pi**2*vT**2) + (mW**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*pi**2*vT**2) + (mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**2) + (4*mW**6*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*mZ**2*pi**2*vT**2) - (5*mW**4*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) + (17*g1bar*mt*mW**4*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(54.*sqrt(2)*mZ**4*pi**2*vT) - (13*g1bar*mt*mW**2*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(216.*sqrt(2)*mZ**2*pi**2*vT) + (17*g1bar*mt*mW**4*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(54.*sqrt(2)*mZ**4*pi**2*vT) - (13*g1bar*mt*mW**2*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(216.*sqrt(2)*mZ**2*pi**2*vT) - (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*sqrt(2)*mH**2*mZ**4*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*mH**2*mZ**2*pi**2*vT) - (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*sqrt(2)*mH**2*mZ**4*pi**2*vT) - (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*mH**2*mZ**2*pi**2*vT) - (5*mt*mW*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*sqrt(2)*pi**2*vT**2) - (25*mt*mW**5*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*sqrt(2)*mZ**4*pi**2*vT**2) + (41*mt*mW**3*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*sqrt(2)*mZ**2*pi**2*vT**2) - (5*mt*mW*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*sqrt(2)*pi**2*vT**2) - (25*mt*mW**5*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*sqrt(2)*mZ**4*pi**2*vT**2) + (41*mt*mW**3*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*sqrt(2)*mZ**2*pi**2*vT**2) + (mt**6*einsum("TTst,pT,rT,TT",C["ud1"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("TTst,pT,rT,TT",C["ud1"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("TTst,pT,rT,TT",C["ud1"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(6.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**4*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**2*mW**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(6.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (g1bar*mt**5*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uB"],kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (g1bar*mt**3*mW**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uB"],kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (g1bar*mt**5*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uBDag"],kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (g1bar*mt**3*mW**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uBDag"],kdt)*log(scale**2/mt**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (mt**5*mW**3*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**3*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**5*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**3*mW**7*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**5*mW**3*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**3*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**5*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**3*mW**7*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mW**2*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*pi**2*vT**4) - (mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mH**2*pi**2*vT**4) + (14*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(9.*mZ**6*pi**2*vT**4) - (56*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(27.*mZ**4*pi**2*vT**4) + (mW**8*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**4*pi**2*vT**4) + (19*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(54.*mZ**2*pi**2*vT**4) - (mW**6*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mH**2*mZ**2*pi**2*vT**4) - (4*mW**10*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**6*pi**2*vT**2) + (5*mW**8*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**4*pi**2*vT**2) - (mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**2*pi**2*vT**2) - (mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*pi**2*vT**2) + (2*mW**8*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**4*pi**2*vT**2) - (mW**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**2*pi**2*vT**2) + (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(12.*mH**2*pi**2*vT**2) + (14*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(9.*mZ**6*pi**2*vT**2) - (119*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(108.*mZ**4*pi**2*vT**2) + (mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mH**2*mZ**4*pi**2*vT**2) - (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(54.*mZ**2*pi**2*vT**2) - (mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*pi**2*vT**2) + (4*mW**10*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**6*pi**2*vT**2) - (mW**8*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**4*pi**2*vT**2) + (22*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(9.*mZ**6*pi**2*vT) + (2*g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**6*pi**2*vT) - (67*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(36.*mZ**4*pi**2*vT) - (g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mH**2*mZ**4*pi**2*vT) + (17*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(216.*mZ**2*pi**2*vT) - (mW**3*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*pi**2*vT**3) + (8*mW**9*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mZ**6*pi**2*vT**3) - (32*mW**7*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mZ**4*pi**2*vT**3) + (17*mW**5*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mZ**2*pi**2*vT**3) + (7*mW**6*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mW**2))/(6.*mZ**4*pi**2*vT**2) - (7*mW**4*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mW**2))/(6.*mZ**2*pi**2*vT**2) + (16*mW**2*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mW**2))/(27.*pi**2*vT**2) + (7*mW**6*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mW**2))/(6.*mZ**4*pi**2*vT**2) - (95*mW**4*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mW**2))/(54.*mZ**2*pi**2*vT**2) + (7*mW**6*einsum("st,pr",C["phid"],kd)*log(scale**2/mW**2))/(6.*mZ**4*pi**2*vT**2) - (7*mW**4*einsum("st,pr",C["phid"],kd)*log(scale**2/mW**2))/(6.*mZ**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("pTst,rT,TT",C["qd1"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("Trst,pT,TT",C["qd1"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**6*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (8*mt**8*mW**2*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (179*mt**6*mW**4*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(432.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt**4*mW**6*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(72.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (5*mt**2*mW**8*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (8*mt**8*mW**4*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (179*mt**6*mW**6*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(432.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt**4*mW**8*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(72.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (5*mt**2*mW**10*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(48.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (g1bar*mt*mW**4*einsum("pT,st,rT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt**2 - mW**2)*mZ**2*pi**2*vT) + (5*mt**7*mW**3*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (3*mt**5*mW**5*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*mt**3*mW**7*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(9.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt*mW**9*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(18.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (5*mt**7*mW**5*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (3*mt**5*mW**7*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (5*mt**3*mW**9*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(9.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt*mW**11*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(18.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (8*mt**8*mW**2*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (19*mt**6*mW**4*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(54.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (5*mt**4*mW**6*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(36.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (mt**2*mW**8*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(6.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (8*mt**8*mW**4*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (19*mt**6*mW**6*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(54.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (5*mt**4*mW**8*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(36.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (mt**2*mW**10*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(6.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (mt**6*mW**4*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt**4*mW**6*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt**2*mW**8*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (4*mt**8*mW**4*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (103*mt**6*mW**6*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(432.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt**4*mW**8*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(18.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt**2*mW**10*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(48.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (55*g1bar*mt**8*mW**3*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(216.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) - (47*g1bar*mt**6*mW**5*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(108.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (5*g1bar*mt**4*mW**7*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(72.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (g1bar*mt**2*mW**9*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(12.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) - (mt**6*mW**3*C["W"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(2.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**3) + (mt**6*mW**5*C["W"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(2.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**3) + (3*mt**2*mW**4*einsum("st,pT,rT,TT",C["phid"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**6*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (8*mt**8*mW**2*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (179*mt**6*mW**4*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(432.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt**4*mW**6*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(72.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (5*mt**2*mW**8*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(48.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (8*mt**8*mW**4*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (179*mt**6*mW**6*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(432.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt**4*mW**8*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(72.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (5*mt**2*mW**10*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(48.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (g1bar*mt*mW**4*einsum("Tr,st,pT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt**2 - mW**2)*mZ**2*pi**2*vT) + (5*mt**7*mW**3*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (3*mt**5*mW**5*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*mt**3*mW**7*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(9.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt*mW**9*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(18.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (5*mt**7*mW**5*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (3*mt**5*mW**7*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(2.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (5*mt**3*mW**9*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(9.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt*mW**11*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(18.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (3*mt**2*mW**4*einsum("TTst,pT,rT,TT",C["ud1"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (g1bar*mt**5*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uB"],kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (g1bar*mt**3*mW**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uB"],kdt)*log(scale**2/mW**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (g1bar*mt**5*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uBDag"],kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (g1bar*mt**3*mW**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uBDag"],kdt)*log(scale**2/mW**2))/(24.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (mt**5*mW**3*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**3*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**5*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mt**3*mW**7*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mt**5*mW**3*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**3*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**5*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mt**3*mW**7*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mW**2*einsum("prst",C["qd1"])*log(scale**2/mZ**2))/(12.*pi**2*vT**2) + (mW**4*einsum("prst",C["qd1"])*log(scale**2/mZ**2))/(6.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("prst",C["qd1"])*log(scale**2/mZ**2))/(12.*pi**2*vT**2) - (23*mH**2*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(486.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (25*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(108.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (14*mH**2*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**4) + (7*mH**2*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) + (14*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) + (mH**2*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(54.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) - (7*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) - (151*mW**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(1944.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (mW**4*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mW**2*mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(12.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mZ**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(12.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (4*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (20*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(9.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (mH**2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (53*mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(18.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mW**6*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mH**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (7*mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(18.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (4*mW**4*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mZ**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mW**2*mZ**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mZ**8*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**4*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**2*mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mZ**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (23*mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(972.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (14*mH**2*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (7*mH**2*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(162.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (14*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (7*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(162.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (335*mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3888.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**4*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**2*mZ**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(24.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (20*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(9.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (41*mW**4*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(18.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mW**6*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mW**2*mZ**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(18.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mW**4*mZ**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (145*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(972.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (491*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(486.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (28*g1bar*mH**4*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT) + (49*g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(486.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) + (56*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) + (8*g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (145*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(486.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) - (28*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) - (5*g1bar*mH**2*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(48.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (89*g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mW**5*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (25*g1bar*mW*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(144.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mW**3*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mW*mZ**6*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(12.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (10*mW**2*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mZ**2))/(81.*pi**2*vT**2) - (7*mW**6*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mZ**2))/(81.*mZ**4*pi**2*vT**2) + (17*mW**4*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mZ**2))/(81.*mZ**2*pi**2*vT**2) - (10*mW**2*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mZ**2))/(81.*pi**2*vT**2) - (7*mW**6*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mZ**2))/(81.*mZ**4*pi**2*vT**2) + (17*mW**4*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mZ**2))/(81.*mZ**2*pi**2*vT**2) + (13*mW**2*einsum("st,pr",C["phid"],kd)*log(scale**2/mZ**2))/(162.*pi**2*vT**2) - (7*mW**6*einsum("st,pr",C["phid"],kd)*log(scale**2/mZ**2))/(81.*mZ**4*pi**2*vT**2) + (mW**4*einsum("st,pr",C["phid"],kd)*log(scale**2/mZ**2))/(162.*mZ**2*pi**2*vT**2) - (g1bar*mW**6*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**4*pi**2*vT) + (g1bar*mW**4*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**2*pi**2*vT) - (g1bar*mW**6*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**4*pi**2*vT) + (g1bar*mW**4*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**2*pi**2*vT) + (2*mW**3*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(81.*mt*pi**2*vT**2) + (2*mW**7*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**4*pi**2*vT**2) - (4*mW**5*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**2*pi**2*vT**2) + (2*mW**3*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*pi**2*vT**2) + (2*mW**7*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**4*pi**2*vT**2) - (4*mW**5*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**2*pi**2*vT**2) - (4*g1bar*mt*mW**6*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**6*pi**2*vT) - (4*g1bar*mt*mW**6*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**6*pi**2*vT) + (8*mt*mW**7*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**6*pi**2*vT**2) + (8*mt*mW**7*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**6*pi**2*vT**2))
    c['V1duLR'] = ((mW**2*einsum("prst",C["qu1"]))/(12.*pi**2*vT**2) - (cEvan*mW**2*einsum("prst",C["qu1"]))/(9.*pi**2*vT**2) - (mW**4*einsum("prst",C["qu1"]))/(6.*mZ**2*pi**2*vT**2) + (2*cEvan*mW**4*einsum("prst",C["qu1"]))/(9.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("prst",C["qu1"]))/(12.*pi**2*vT**2) - (cEvan*mZ**2*einsum("prst",C["qu1"]))/(9.*pi**2*vT**2) + (7*mH**2*einsum("pr,st",kd,kd))/(72.*pi**2*vT**4) - (1417*mW**2*einsum("pr,st",kd,kd))/(29160.*pi**2*vT**4) + (8*cEvan*mW**2*einsum("pr,st",kd,kd))/(81.*pi**2*vT**4) - (362*mW**8*einsum("pr,st",kd,kd))/(729.*mZ**6*pi**2*vT**4) + (16*cEvan*mW**8*einsum("pr,st",kd,kd))/(81.*mZ**6*pi**2*vT**4) - (7*mH**2*mW**4*einsum("pr,st",kd,kd))/(36.*mZ**4*pi**2*vT**4) + (152*mW**6*einsum("pr,st",kd,kd))/(1215.*mZ**4*pi**2*vT**4) - (8*cEvan*mW**6*einsum("pr,st",kd,kd))/(27.*mZ**4*pi**2*vT**4) - (2*mW**8*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**4) + (7*mH**2*mW**2*einsum("pr,st",kd,kd))/(72.*mZ**2*pi**2*vT**4) + (853*mW**4*einsum("pr,st",kd,kd))/(1620.*mZ**2*pi**2*vT**4) + (mW**6*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**2*pi**2*vT**4) - (23*mZ**2*einsum("pr,st",kd,kd))/(216.*pi**2*vT**4) + (mW**2*mZ**2*einsum("pr,st",kd,kd))/(18.*mH**2*pi**2*vT**4) + (mZ**4*einsum("pr,st",kd,kd))/(18.*mH**2*pi**2*vT**4) - (2*mt**4*Nc*einsum("pr,st",kd,kd))/(9.*mH**2*pi**2*vT**4) + (32*mW**4*Nc*einsum("pr,st",kd,kd))/(1215.*mt**2*pi**2*vT**4) + (4*mt**4*mW**4*Nc*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**4) + (32*mW**8*Nc*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**4*pi**2*vT**4) - (2*mt**4*mW**2*Nc*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**2*pi**2*vT**4) - (64*mW**6*Nc*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**2*pi**2*vT**4) - (C["phi"]*einsum("pr,st",kd,kd))/(6.*pi**2) + (mW**4*C["phi"]*einsum("pr,st",kd,kd))/(3.*mZ**4*pi**2) - (mW**2*C["phi"]*einsum("pr,st",kd,kd))/(6.*mZ**2*pi**2) - (mH**2*mW**2*C["phiB"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (31*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (8*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (4*mH**4*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (8*mW**10*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (5*mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (2*mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (10*mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (8*mW**10*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**2*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (5*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (14*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (10*mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (5*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (8*mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mZ**6*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (4*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (16*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (20*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (16*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (4*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (20*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (11*mH**2*C["phiBox"]*einsum("pr,st",kd,kd))/(36.*pi**2*vT**2) - (5*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(36.*pi**2*vT**2) - (11*mH**2*mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(18.*mZ**4*pi**2*vT**2) - (4*mW**8*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) + (11*mH**2*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(36.*mZ**2*pi**2*vT**2) + (5*mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(18.*mZ**2*pi**2*vT**2) + (2*mW**6*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**2*pi**2*vT**2) - (5*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(36.*pi**2*vT**2) + (mW**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*pi**2*vT**2) + (mZ**4*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*pi**2*vT**2) - (4*mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*pi**2*vT**2) + (8*mt**4*mW**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) - (4*mt**4*mW**2*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**2*pi**2*vT**2) - (mH**2*C["phiD"]*einsum("pr,st",kd,kd))/(9.*pi**2*vT**2) + (935*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(11664.*pi**2*vT**2) - (4*cEvan*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(81.*pi**2*vT**2) - (mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(6.*mH**2*pi**2*vT**2) - (362*mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(729.*mZ**6*pi**2*vT**2) + (16*cEvan*mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(81.*mZ**6*pi**2*vT**2) + (mH**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(36.*mZ**4*pi**2*vT**2) - (158*mW**6*C["phiD"]*einsum("pr,st",kd,kd))/(1215.*mZ**4*pi**2*vT**2) - (4*cEvan*mW**6*C["phiD"]*einsum("pr,st",kd,kd))/(27.*mZ**4*pi**2*vT**2) - (mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) - (mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(16.*mZ**2*pi**2*vT**2) + (167*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(810.*mZ**2*pi**2*vT**2) + (mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(27.*pi**2*vT**2) + (mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(36.*mH**2*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(9.*mH**2*pi**2*vT**2) + (2*mt**4*mW**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) + (32*mW**8*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**4*pi**2*vT**2) - (32*mW**6*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**2*pi**2*vT**2) + (mH**2*mW**2*C["phiW"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (31*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (4*mH**4*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (8*mW**10*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (5*mH**4*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (2*mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (2*mW**8*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (8*mW**10*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (mH**4*mW**2*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (5*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (4*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (2*mW**8*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (8*mW**4*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (4*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (16*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (20*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (16*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (4*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (20*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (17*g1bar*mH**2*mW*C["phiWB"]*einsum("pr,st",kd,kd))/(216.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (88*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(3645.*(mH - mZ)*(mH + mZ)*pi**2*vT) + (4*cEvan*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) - (2*g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) - (1048*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(729.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (32*cEvan*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) - (4*g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) - (g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(36.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (2722*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(3645.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (28*cEvan*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (1129*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(729.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (32*cEvan*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (4*g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (g1bar*mH**4*mW*C["phiWB"]*einsum("pr,st",kd,kd))/(48.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (4807*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(14580.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (4*cEvan*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (3937*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(3645.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (28*cEvan*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (37*g1bar*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(432.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) - (g1bar*mW*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd))/(18.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) + (64*g1bar*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*mt**2*(mH - mZ)*(mH + mZ)*pi**2*vT) + (8*g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) - (2*g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (8*g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (64*g1bar*mH**2*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*mt**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (2*g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (64*g1bar*mH**2*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*mt**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (64*g1bar*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*mt**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (mW**3*C["W"]*einsum("pr,st",kd,kd))/(3.*pi**2*vT**3) - (4*mW**7*C["W"]*einsum("pr,st",kd,kd))/(3.*mZ**4*pi**2*vT**3) + (5*mW**5*C["W"]*einsum("pr,st",kd,kd))/(3.*mZ**2*pi**2*vT**3) - (61*mW**2*einsum("pr,st",C["phiq1"],kd))/(243.*pi**2*vT**2) + (8*cEvan*mW**2*einsum("pr,st",C["phiq1"],kd))/(27.*pi**2*vT**2) - (202*mW**6*einsum("pr,st",C["phiq1"],kd))/(243.*mZ**4*pi**2*vT**2) + (8*cEvan*mW**6*einsum("pr,st",C["phiq1"],kd))/(27.*mZ**4*pi**2*vT**2) + (317*mW**4*einsum("pr,st",C["phiq1"],kd))/(243.*mZ**2*pi**2*vT**2) - (16*cEvan*mW**4*einsum("pr,st",C["phiq1"],kd))/(27.*mZ**2*pi**2*vT**2) - (2*mZ**2*einsum("pr,st",C["phiq1"],kd))/(9.*pi**2*vT**2) + (253*mW**2*einsum("pr,st",C["phiq3"],kd))/(486.*pi**2*vT**2) + (8*cEvan*mW**2*einsum("pr,st",C["phiq3"],kd))/(27.*pi**2*vT**2) - (202*mW**6*einsum("pr,st",C["phiq3"],kd))/(243.*mZ**4*pi**2*vT**2) + (8*cEvan*mW**6*einsum("pr,st",C["phiq3"],kd))/(27.*mZ**4*pi**2*vT**2) + (259*mW**4*einsum("pr,st",C["phiq3"],kd))/(486.*mZ**2*pi**2*vT**2) - (16*cEvan*mW**4*einsum("pr,st",C["phiq3"],kd))/(27.*mZ**2*pi**2*vT**2) - (2*mZ**2*einsum("pr,st",C["phiq3"],kd))/(9.*pi**2*vT**2) - (82*mW**2*einsum("st,pr",C["phiu"],kd))/(243.*pi**2*vT**2) + (2*cEvan*mW**2*einsum("st,pr",C["phiu"],kd))/(27.*pi**2*vT**2) + (80*mW**6*einsum("st,pr",C["phiu"],kd))/(243.*mZ**4*pi**2*vT**2) - (4*cEvan*mW**6*einsum("st,pr",C["phiu"],kd))/(27.*mZ**4*pi**2*vT**2) + (31*mW**4*einsum("st,pr",C["phiu"],kd))/(486.*mZ**2*pi**2*vT**2) + (2*cEvan*mW**4*einsum("st,pr",C["phiu"],kd))/(27.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("st,pr",C["phiu"],kd))/(18.*pi**2*vT**2) - (3*mt**4*einsum("pTst,rT,TT",C["qu1"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("pTst,rT,TT",C["qu1"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (mt**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(3.*pi**2*vT**2) + (4*mW**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(3.*mZ**2*pi**2*vT**2) - (4*mW**4*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) + (mt**2*einsum("sTTt,pr,TT",C["uu"],kd,kdt))/(24.*pi**2*vT**2) - (mW**2*einsum("sTTt,pr,TT",C["uu"],kd,kdt))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("sTTt,pr,TT",C["uu"],kd,kdt))/(12.*mZ**2*pi**2*vT**2) + (mW**4*einsum("sTTt,pr,TT",C["uu"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) - (mt**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(3.*pi**2*vT**2) + (4*mW**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(3.*mZ**2*pi**2*vT**2) - (4*mW**4*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) - (3*mt**4*einsum("Trst,pT,TT",C["qu1"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (3*mt**2*mW**2*einsum("Trst,pT,TT",C["qu1"],kd,kdt))/(64.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**2*einsum("TtsT,pr,TT",C["uu"],kd,kdt))/(24.*pi**2*vT**2) - (mW**2*einsum("TtsT,pr,TT",C["uu"],kd,kdt))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("TtsT,pr,TT",C["uu"],kd,kdt))/(12.*mZ**2*pi**2*vT**2) + (mW**4*einsum("TtsT,pr,TT",C["uu"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) + (mt**4*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt))/(16.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**2*mW**2*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt))/(16.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (mt**4*mW**2*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt))/(16.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) - (mt**2*mW**4*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt))/(16.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) - (5*mt**8*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(48.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (311*mt**6*mW**2*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(432.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (769*mt**4*mW**4*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(432.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (151*mt**2*mW**6*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(144.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (4*mW**8*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (5*mt**8*mW**2*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(48.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (311*mt**6*mW**4*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(432.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (769*mt**4*mW**6*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(432.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (151*mt**2*mW**8*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(144.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (4*mW**10*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**7*mW*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (59*mt**5*mW**3*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(54.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (35*mt**3*mW**5*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(54.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (17*mt*mW**7*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(27.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**7*mW**3*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (59*mt**5*mW**5*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(54.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (35*mt**3*mW**7*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(54.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (17*mt*mW**9*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt))/(27.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**8*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(6.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) - (179*mt**6*mW**2*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(108.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) + (307*mt**4*mW**4*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(108.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) - (13*mt**2*mW**6*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(9.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) + (4*mW**8*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**4) - (mt**8*mW**2*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(6.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) + (179*mt**6*mW**4*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(108.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) - (307*mt**4*mW**6*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(108.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) + (13*mt**2*mW**8*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(9.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) - (4*mW**10*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**4) - (mt**8*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(48.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (3*mt**6*mW**2*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(16.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (5*mt**4*mW**4*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(16.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (7*mt**2*mW**6*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(48.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**8*mW**2*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(16.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (277*mt**6*mW**4*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(432.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (479*mt**4*mW**6*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(432.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (83*mt**2*mW**8*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(144.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (2*mW**10*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (g1bar*mt**8*mW*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(12.*(-mt + mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (29*g1bar*mt**6*mW**3*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(27.*(-mt + mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (113*g1bar*mt**4*mW**5*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(54.*(-mt + mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (43*g1bar*mt**2*mW**7*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(36.*(-mt + mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (4*g1bar*mW**9*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(27.*(-mt + mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (3*mt**4*mW**3*C["W"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(2.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**3) + (mt**2*mW**5*C["W"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(2.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**3) + (3*mt**4*mW**5*C["W"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(2.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**3) - (mt**2*mW**7*C["W"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt))/(2.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**3) + (mt**4*einsum("st,pT,rT,TT",C["phiu"],kd,kd,kdt))/((32*mt**2 - 32*mW**2)*pi**2*vT**2) - (7*mt**2*mW**2*einsum("st,pT,rT,TT",C["phiu"],kd,kd,kdt))/((32*mt**2 - 32*mW**2)*pi**2*vT**2) - (mt**4*einsum("stTT,pT,rT,TT",C["uu"],kd,kd,kdt))/(32.*(mt**2 - mW**2)*pi**2*vT**2) + (7*mt**2*mW**2*einsum("stTT,pT,rT,TT",C["uu"],kd,kd,kdt))/(32.*(mt**2 - mW**2)*pi**2*vT**2) - (mt**4*einsum("sTTt,pT,rT,TT",C["uu"],kd,kd,kdt))/(32.*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) - (aEvan*mt**4*einsum("sTTt,pT,rT,TT",C["uu"],kd,kd,kdt))/(16.*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) + (7*mt**2*mW**2*einsum("sTTt,pT,rT,TT",C["uu"],kd,kd,kdt))/(32.*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) + (aEvan*mt**2*mW**2*einsum("sTTt,pT,rT,TT",C["uu"],kd,kd,kdt))/(16.*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) + (mt**4*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt))/(16.*(mt - mW)*(mt + mW)*pi**2*vT**2) + (mt**2*mW**2*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt))/(16.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (mt**4*mW**2*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt))/(16.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) - (mt**2*mW**4*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt))/(16.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) - (5*mt**8*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(48.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (311*mt**6*mW**2*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(432.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (769*mt**4*mW**4*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(432.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (151*mt**2*mW**6*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(144.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (4*mW**8*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (5*mt**8*mW**2*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(48.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (311*mt**6*mW**4*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(432.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (769*mt**4*mW**6*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(432.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (151*mt**2*mW**8*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(144.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (4*mW**10*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt))/(27.*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**7*mW*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (59*mt**5*mW**3*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(54.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (35*mt**3*mW**5*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(54.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (17*mt*mW**7*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(27.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**7*mW**3*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (59*mt**5*mW**5*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(54.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (35*mt**3*mW**7*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(54.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (17*mt*mW**9*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt))/(27.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(9.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(9.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(9.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(9.*sqrt(2)*mH**2*mZ**2*pi**2*vT) - (mt**4*einsum("TtsT,pT,rT,TT",C["uu"],kd,kd,kdt))/(32.*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) - (aEvan*mt**4*einsum("TtsT,pT,rT,TT",C["uu"],kd,kd,kdt))/(16.*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) + (7*mt**2*mW**2*einsum("TtsT,pT,rT,TT",C["uu"],kd,kd,kdt))/(32.*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) + (aEvan*mt**2*mW**2*einsum("TtsT,pT,rT,TT",C["uu"],kd,kd,kdt))/(16.*(mt - mW)*(mt + mW)*Nc*pi**2*vT**2) + (mt**2*einsum("TTst,pT,rT,TT",C["qu1"],kd,kd,kdt))/(8.*pi**2*vT**2) - (mt**4*einsum("TTst,pT,rT,TT",C["uu"],kd,kd,kdt))/(32.*(mt**2 - mW**2)*pi**2*vT**2) + (7*mt**2*mW**2*einsum("TTst,pT,rT,TT",C["uu"],kd,kd,kdt))/(32.*(mt**2 - mW**2)*pi**2*vT**2) - (mt**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiq1"],kdt))/(6.*pi**2*vT**2) + (mt**2*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiq1"],kdt))/(6.*mZ**2*pi**2*vT**2) + (mt**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiq3"],kdt))/(6.*pi**2*vT**2) - (mt**2*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiq3"],kdt))/(6.*mZ**2*pi**2*vT**2) + (mt**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(24.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (7*mt**2*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(24.*(mt - mW)*(mt + mW)*pi**2*vT**2) - (mt**4*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(24.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) + (7*mt**2*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt))/(24.*(mt - mW)*(mt + mW)*mZ**2*pi**2*vT**2) - (g1bar*mt**5*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uB"],kdt))/(24.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) - (g1bar*mt**3*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uB"],kdt))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) + (g1bar*mt*mW**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uB"],kdt))/(12.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) - (g1bar*mt**5*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uBDag"],kdt))/(24.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) - (g1bar*mt**3*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uBDag"],kdt))/(8.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) + (g1bar*mt*mW**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uBDag"],kdt))/(12.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT) - (mt**5*mW*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt))/(12.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**3*mW**3*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt))/(6.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**5*mW**3*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt))/(12.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**3*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt*mW**7*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt))/(6.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**5*mW*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(12.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**3*mW**3*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(6.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**5*mW**3*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(12.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**3*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(4.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt*mW**7*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt))/(6.*sqrt(2)*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mH**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (mH**2*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (mH**4*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) + (mH**4*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) + (mH**2*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) - (mH**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*pi**2) + (mW**4*C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*mZ**4*pi**2) - (mW**2*C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*mZ**2*pi**2) - (mH**4*mW**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (5*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (4*mH**6*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT**2) - (5*mH**6*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) - (4*mH**4*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) + (mH**6*mW**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (5*mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (4*mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (mH**2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (5*mH**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (4*mH**2*mW**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (5*mH**4*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (5*mH**4*mW**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (8*mH**2*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (4*mH**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mH**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(36.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (5*mH**4*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(72.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mH**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mH**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (5*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (4*mH**6*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT**2) + (5*mH**6*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) + (4*mH**4*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) - (mH**6*mW**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (5*mH**4*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (4*mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (mH**2*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (g1bar*mH**4*mW*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(24.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (2*g1bar*mH**6*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT) + (2*g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**6*mW*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(72.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) - (2*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (mt**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(18.*pi**2*vT**4) - (2*mt**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*pi**2*vT**4) - (10*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*pi**2*vT**4) + (64*mW**8*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**6*pi**2*vT**4) - (mt**2*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**4) + (4*mt**4*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**4) - (40*mW**6*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**4) + (mt**2*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(18.*mZ**2*pi**2*vT**4) - (2*mt**4*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**2*pi**2*vT**4) + (22*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**4) - (16*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**6*pi**2*vT**2) + (20*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**2) - (4*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**2*pi**2*vT**2) - (4*mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*pi**2*vT**2) + (8*mt**4*mW**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**2) - (4*mt**4*mW**2*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**2*pi**2*vT**2) - (mt**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(18.*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*pi**2*vT**2) + (5*mW**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*pi**2*vT**2) + (64*mW**8*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**6*pi**2*vT**2) + (2*mt**4*mW**4*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**2) - (20*mW**6*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(36.*mZ**2*pi**2*vT**2) + (16*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**6*pi**2*vT**2) - (20*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**2) + (4*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**2*pi**2*vT**2) + (8*g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**6*pi**2*vT) + (128*g1bar*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**6*pi**2*vT) - (g1bar*mt**2*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT) - (2*g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT) - (148*g1bar*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**4*pi**2*vT) + (g1bar*mt**2*mW*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(36.*mZ**2*pi**2*vT) + (38*g1bar*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**2*pi**2*vT) + (mt**2*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(6.*pi**2*vT**2) + (10*mW**2*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) + (16*mW**6*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) - (26*mW**4*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(6.*pi**2*vT**2) + (10*mW**2*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) + (16*mW**6*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) - (26*mW**4*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("st,pr",C["phiu"],kd)*log(scale**2/mt**2))/(24.*pi**2*vT**2) - (5*mW**2*Nc*einsum("st,pr",C["phiu"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) - (8*mW**6*Nc*einsum("st,pr",C["phiu"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("st,pr",C["phiu"],kd)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("st,pr",C["phiu"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("prTT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(6.*pi**2*vT**2) - (2*mW**2*Nc*einsum("prTT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) + (2*mW**4*Nc*einsum("prTT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("prTT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(6.*pi**2*vT**2) + (2*mW**2*Nc*einsum("prTT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) - (2*mW**4*Nc*einsum("prTT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("prTT,st,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(6.*pi**2*vT**2) - (2*mW**2*Nc*einsum("prTT,st,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) + (2*mW**4*Nc*einsum("prTT,st,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**6*einsum("pTst,rT,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("pTst,rT,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("pTst,rT,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(3.*pi**2*vT**2) - (4*mW**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(3.*mZ**2*pi**2*vT**2) + (4*mW**4*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("stTT,pr,TT",C["uu"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*Nc*einsum("stTT,pr,TT",C["uu"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("stTT,pr,TT",C["uu"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("stTT,pr,TT",C["uu"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*einsum("sTTt,pr,TT",C["uu"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*einsum("sTTt,pr,TT",C["uu"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("sTTt,pr,TT",C["uu"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*einsum("sTTt,pr,TT",C["uu"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(3.*pi**2*vT**2) - (4*mW**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(3.*mZ**2*pi**2*vT**2) + (4*mW**4*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**6*einsum("Trst,pT,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("Trst,pT,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("Trst,pT,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*Nc*einsum("TTpr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(6.*pi**2*vT**2) - (2*mW**2*Nc*einsum("TTpr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TTpr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) + (2*mW**4*Nc*einsum("TTpr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TTpr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(6.*pi**2*vT**2) + (2*mW**2*Nc*einsum("TTpr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TTpr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) - (2*mW**4*Nc*einsum("TTpr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*einsum("TtsT,pr,TT",C["uu"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*einsum("TtsT,pr,TT",C["uu"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("TtsT,pr,TT",C["uu"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*einsum("TtsT,pr,TT",C["uu"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TTst,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*Nc*einsum("TTst,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TTst,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("TTst,pr,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TTst,pr,TT",C["uu"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (mW**2*Nc*einsum("TTst,pr,TT",C["uu"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TTst,pr,TT",C["uu"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("TTst,pr,TT",C["uu"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**6*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*mW**2*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**4*mW**4*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**2*mW**6*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (7*mt**10*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (13*mt**8*mW**2*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (109*mt**6*mW**4*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (25*mt**4*mW**6*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (59*mt**2*mW**8*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(54.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (4*mW**10*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (7*mt**10*mW**2*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (13*mt**8*mW**4*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (109*mt**6*mW**6*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (25*mt**4*mW**8*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (59*mt**2*mW**10*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(54.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (4*mW**12*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (g1bar*mt*mW**4*einsum("pT,st,rT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt**2 - mW**2)*mZ**2*pi**2*vT) + (5*mt**7*mW**3*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (3*mt**5*mW**5*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt*mW**9*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (5*mt**7*mW**5*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (3*mt**5*mW**7*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt*mW**11*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (4*mt**8*mW**2*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(9.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (mt**6*mW**4*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(9.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (7*mt**4*mW**6*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(6.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (25*mt**2*mW**8*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (4*mW**10*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (4*mt**8*mW**4*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (mt**6*mW**6*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (7*mt**4*mW**8*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(6.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (25*mt**2*mW**10*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (4*mW**12*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (mt**10*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt**8*mW**2*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(6.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (3*mt**6*mW**4*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (5*mt**4*mW**6*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt**2*mW**8*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(6.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt**10*mW**2*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (7*mt**8*mW**4*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(18.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (31*mt**6*mW**6*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt**4*mW**8*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(6.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (8*mt**2*mW**10*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (2*mW**12*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (13*g1bar*mt**8*mW**3*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(36.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) - (5*g1bar*mt**6*mW**5*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(18.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) - (3*g1bar*mt**4*mW**7*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (41*g1bar*mt**2*mW**9*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(54.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) - (4*g1bar*mW**11*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) - (mt**6*mW**3*C["W"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/((mt - mW)**3*(mt + mW)**3*pi**2*vT**3) + (mt**6*mW**5*C["W"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mt**2))/((mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**3) - (mt**6*einsum("st,pT,rT,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("st,pT,rT,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("st,pT,rT,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*einsum("stTT,pT,rT,TT",C["uu"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("stTT,pT,rT,TT",C["uu"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("stTT,pT,rT,TT",C["uu"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*einsum("sTTt,pT,rT,TT",C["uu"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) - (mt**4*mW**2*einsum("sTTt,pT,rT,TT",C["uu"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) + (mt**2*mW**4*einsum("sTTt,pT,rT,TT",C["uu"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) + (mt**6*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*mW**2*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**4*mW**4*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**2*mW**6*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (7*mt**10*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (13*mt**8*mW**2*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (109*mt**6*mW**4*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (25*mt**4*mW**6*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (59*mt**2*mW**8*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(54.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (4*mW**10*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (7*mt**10*mW**2*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(24.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (13*mt**8*mW**4*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (109*mt**6*mW**6*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(72.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (25*mt**4*mW**8*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (59*mt**2*mW**10*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(54.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (4*mW**12*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (g1bar*mt*mW**4*einsum("Tr,st,pT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt**2 - mW**2)*mZ**2*pi**2*vT) + (5*mt**7*mW**3*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (3*mt**5*mW**5*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt*mW**9*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (5*mt**7*mW**5*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(3.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (3*mt**5*mW**7*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt*mW**11*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) - (2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*pi**2*vT**2) + (2*mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**2) - (8*mW**6*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) + (10*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) + (2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*pi**2*vT**2) - (2*mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**2) + (8*mW**6*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) - (10*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*pi**2*vT**2) - (2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*pi**2*vT**2) - (2*mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**2) - (8*mW**6*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**2*pi**2*vT**2) + (10*mW**4*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) - (17*g1bar*mt*mW**4*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*sqrt(2)*mZ**4*pi**2*vT) + (13*g1bar*mt*mW**2*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*sqrt(2)*mZ**2*pi**2*vT) - (17*g1bar*mt*mW**4*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*sqrt(2)*mZ**4*pi**2*vT) + (13*g1bar*mt*mW**2*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*sqrt(2)*mZ**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*sqrt(2)*mH**2*pi**2*vT) + (mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (5*mt*mW*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(54.*sqrt(2)*pi**2*vT**2) - (41*mt*mW**3*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(54.*sqrt(2)*mZ**2*pi**2*vT**2) + (5*mt*mW*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(54.*sqrt(2)*pi**2*vT**2) - (41*mt*mW**3*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(54.*sqrt(2)*mZ**2*pi**2*vT**2) + (mt**6*einsum("TtsT,pT,rT,TT",C["uu"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) - (mt**4*mW**2*einsum("TtsT,pT,rT,TT",C["uu"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) + (mt**2*mW**4*einsum("TtsT,pT,rT,TT",C["uu"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) + (mt**6*einsum("TTst,pT,rT,TT",C["uu"],kd,kd,kdt)*log(scale**2/mt**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**4*mW**2*einsum("TTst,pT,rT,TT",C["uu"],kd,kd,kdt)*log(scale**2/mt**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("TTst,pT,rT,TT",C["uu"],kd,kd,kdt)*log(scale**2/mt**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**4*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(6.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(3.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**6*mW**2*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(12.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (mt**4*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(6.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (mt**2*mW**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mt**2))/(3.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) - (g1bar*mt**5*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uB"],kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (g1bar*mt**3*mW**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uB"],kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (g1bar*mt**5*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uBDag"],kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (g1bar*mt**3*mW**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uBDag"],kdt)*log(scale**2/mt**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (mt**5*mW**3*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(3.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**3*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**5*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(3.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mt**3*mW**7*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mt**5*mW**3*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(3.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**3*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) + (mt**5*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(3.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mt**3*mW**7*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mt**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) - (mW**2*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*pi**2*vT**4) + (mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*pi**2*vT**4) - (28*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(9.*mZ**6*pi**2*vT**4) + (112*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(27.*mZ**4*pi**2*vT**4) - (2*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**4*pi**2*vT**4) - (19*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(27.*mZ**2*pi**2*vT**4) + (mW**6*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**2*pi**2*vT**4) + (8*mW**10*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**6*pi**2*vT**2) - (10*mW**8*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**4*pi**2*vT**2) + (2*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**2*pi**2*vT**2) + (2*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*pi**2*vT**2) - (4*mW**8*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**4*pi**2*vT**2) + (2*mW**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**2*pi**2*vT**2) - (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mH**2*pi**2*vT**2) - (28*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(9.*mZ**6*pi**2*vT**2) + (119*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(54.*mZ**4*pi**2*vT**2) - (mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**4*pi**2*vT**2) + (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(27.*mZ**2*pi**2*vT**2) + (2*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*pi**2*vT**2) - (8*mW**10*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**6*pi**2*vT**2) + (2*mW**8*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**4*pi**2*vT**2) - (44*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(9.*mZ**6*pi**2*vT) - (4*g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**6*pi**2*vT) + (67*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(18.*mZ**4*pi**2*vT) + (g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**4*pi**2*vT) - (17*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(108.*mZ**2*pi**2*vT) + (mW**3*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*pi**2*vT**3) - (16*mW**9*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mZ**6*pi**2*vT**3) + (64*mW**7*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mZ**4*pi**2*vT**3) - (17*mW**5*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mZ**2*pi**2*vT**3) - (7*mW**6*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mW**2))/(3.*mZ**4*pi**2*vT**2) + (7*mW**4*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mW**2))/(3.*mZ**2*pi**2*vT**2) - (32*mW**2*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mW**2))/(27.*pi**2*vT**2) - (7*mW**6*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mW**2))/(3.*mZ**4*pi**2*vT**2) + (95*mW**4*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mW**2))/(27.*mZ**2*pi**2*vT**2) + (7*mW**6*einsum("st,pr",C["phiu"],kd)*log(scale**2/mW**2))/(6.*mZ**4*pi**2*vT**2) - (7*mW**4*einsum("st,pr",C["phiu"],kd)*log(scale**2/mW**2))/(6.*mZ**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("pTst,rT,TT",C["qu1"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (3*mt**2*mW**4*einsum("Trst,pT,TT",C["qu1"],kd,kdt)*log(scale**2/mW**2))/(32.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**4*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**6*einsum("pT,st,rT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (16*mt**8*mW**2*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (179*mt**6*mW**4*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(216.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt**4*mW**6*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(36.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*mt**2*mW**8*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(24.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (16*mt**8*mW**4*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (179*mt**6*mW**6*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(216.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt**4*mW**8*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(36.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (5*mt**2*mW**10*einsum("pT,st,rT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(24.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (g1bar*mt*mW**4*einsum("pT,st,rT,TT",C["uB"],kd,kd,kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt**2 - mW**2)*mZ**2*pi**2*vT) - (5*mt**7*mW**3*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(3.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (3*mt**5*mW**5*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt*mW**9*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(9.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*mt**7*mW**5*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(3.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (3*mt**5*mW**7*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt*mW**11*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2))/(9.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (16*mt**8*mW**2*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (19*mt**6*mW**4*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (5*mt**4*mW**6*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(18.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) + (mt**2*mW**8*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(3.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**4) - (16*mt**8*mW**4*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (19*mt**6*mW**6*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) + (5*mt**4*mW**8*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(18.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (mt**2*mW**10*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(3.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**4) - (mt**6*mW**4*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (mt**4*mW**6*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt**2*mW**8*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (8*mt**8*mW**4*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (103*mt**6*mW**6*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(216.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt**4*mW**8*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (mt**2*mW**10*C["phiD"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(24.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (55*g1bar*mt**8*mW**3*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(108.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (47*g1bar*mt**6*mW**5*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(54.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) - (5*g1bar*mt**4*mW**7*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(36.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) - (g1bar*mt**2*mW**9*C["phiWB"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/(6.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT) + (mt**6*mW**3*C["W"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/((mt - mW)**3*(mt + mW)**3*pi**2*vT**3) - (mt**6*mW**5*C["W"]*einsum("st,pT,rT,TT",kd,kd,kd,kdt)*log(scale**2/mW**2))/((mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**3) + (3*mt**2*mW**4*einsum("st,pT,rT,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**2*mW**4*einsum("stTT,pT,rT,TT",C["uu"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (3*mt**2*mW**4*einsum("sTTt,pT,rT,TT",C["uu"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) - (mt**2*mW**4*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**6*einsum("Tr,st,pT,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mW**2))/(8.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (16*mt**8*mW**2*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (179*mt**6*mW**4*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(216.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt**4*mW**6*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(36.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*mt**2*mW**8*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(24.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (16*mt**8*mW**4*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(27.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (179*mt**6*mW**6*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(216.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt**4*mW**8*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(36.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (5*mt**2*mW**10*einsum("Tr,st,pT,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mW**2))/(24.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (g1bar*mt*mW**4*einsum("Tr,st,pT,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt**2 - mW**2)*mZ**2*pi**2*vT) - (5*mt**7*mW**3*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(3.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (3*mt**5*mW**5*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (mt*mW**9*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(9.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*mt**7*mW**5*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(3.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (3*mt**5*mW**7*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (mt*mW**11*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2))/(9.*sqrt(2)*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (3*mt**2*mW**4*einsum("TtsT,pT,rT,TT",C["uu"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*Nc*pi**2*vT**2) - (3*mt**2*mW**4*einsum("TTst,pT,rT,TT",C["uu"],kd,kd,kdt)*log(scale**2/mW**2))/(16.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) + (mt**2*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*pi**2*vT**2) - (mt**2*mW**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["phiu"],kdt)*log(scale**2/mW**2))/(4.*(mt - mW)**2*(mt + mW)**2*mZ**2*pi**2*vT**2) + (g1bar*mt**5*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uB"],kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (g1bar*mt**3*mW**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uB"],kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (g1bar*mt**5*mW**4*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uBDag"],kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) - (g1bar*mt**3*mW**6*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uBDag"],kdt)*log(scale**2/mW**2))/(12.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT) + (mt**5*mW**3*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(3.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**3*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**5*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(3.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**3*mW**7*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uW"],kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**5*mW**3*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(3.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**3*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*pi**2*vT**2) - (mt**5*mW**5*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(3.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mt**3*mW**7*einsum("st,pT,rT,TT,TT",kd,kd,kd,C["uWDag"],kdt)*log(scale**2/mW**2))/(6.*sqrt(2)*(mt - mW)**3*(mt + mW)**3*mZ**2*pi**2*vT**2) + (mW**2*einsum("prst",C["qu1"])*log(scale**2/mZ**2))/(6.*pi**2*vT**2) - (mW**4*einsum("prst",C["qu1"])*log(scale**2/mZ**2))/(3.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("prst",C["qu1"])*log(scale**2/mZ**2))/(6.*pi**2*vT**2) - (19*mH**2*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (17*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(54.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (92*mH**2*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**4) + (52*mH**2*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) + (92*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) - (5*mH**2*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(27.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) - (52*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) + (319*mW**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(972.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mW**4*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (mW**2*mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (mZ**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (8*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (40*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(9.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (2*mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (mH**2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (53*mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(9.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (2*mW**6*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mH**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (7*mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(9.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (8*mW**4*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (2*mZ**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mW**2*mZ**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mZ**8*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mW**4*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**2*mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mZ**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (19*mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(486.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (92*mH**2*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (26*mH**2*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (92*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (26*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (167*mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(1944.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**4*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**2*mZ**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(12.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (40*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(9.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (2*mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (41*mW**4*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(9.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (2*mW**6*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mW**2*mZ**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(9.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (2*mW**4*mZ**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (133*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(486.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (728*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (184*g1bar*mH**4*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT) + (188*g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) + (368*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) - (13*g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) - (619*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) - (184*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (5*g1bar*mH**2*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(24.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (175*g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mW**5*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (25*g1bar*mW*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(72.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mW**3*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mW*mZ**6*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (34*mW**2*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mZ**2))/(81.*pi**2*vT**2) - (40*mW**6*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mZ**2))/(81.*mZ**4*pi**2*vT**2) + (74*mW**4*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mZ**2))/(81.*mZ**2*pi**2*vT**2) - (34*mW**2*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mZ**2))/(81.*pi**2*vT**2) - (40*mW**6*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mZ**2))/(81.*mZ**4*pi**2*vT**2) + (74*mW**4*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mZ**2))/(81.*mZ**2*pi**2*vT**2) - (mW**2*einsum("st,pr",C["phiu"],kd)*log(scale**2/mZ**2))/(81.*pi**2*vT**2) + (26*mW**6*einsum("st,pr",C["phiu"],kd)*log(scale**2/mZ**2))/(81.*mZ**4*pi**2*vT**2) - (25*mW**4*einsum("st,pr",C["phiu"],kd)*log(scale**2/mZ**2))/(81.*mZ**2*pi**2*vT**2) + (2*g1bar*mW**6*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**4*pi**2*vT) - (2*g1bar*mW**4*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**2*pi**2*vT) + (2*g1bar*mW**6*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**4*pi**2*vT) - (2*g1bar*mW**4*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**2*pi**2*vT) - (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*sqrt(2))/(9.*mH**2*mZ**4*pi**2*vT) - (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*sqrt(2))/(9.*mH**2*mZ**4*pi**2*vT) - (4*mW**3*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(81.*mt*pi**2*vT**2) - (4*mW**7*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**4*pi**2*vT**2) + (8*mW**5*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**2*pi**2*vT**2) - (4*mW**3*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*pi**2*vT**2) - (4*mW**7*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**4*pi**2*vT**2) + (8*mW**5*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**2*pi**2*vT**2) + (5*mt**3*mW**7*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (5*mt**3*mW**9*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (5*mt**3*mW**7*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) - (5*mt**3*mW**9*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) + (8*g1bar*mt*mW**6*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**6*pi**2*vT) + (8*g1bar*mt*mW**6*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**6*pi**2*vT) - (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*mH**2*mZ**4*pi**2*vT) - (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*mH**2*mZ**4*pi**2*vT) - (16*mt*mW**7*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**6*pi**2*vT**2) + (25*mt*mW**5*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**4*pi**2*vT**2) - (16*mt*mW**7*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**6*pi**2*vT**2) + (25*mt*mW**5*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**4*pi**2*vT**2) - (5*mt**3*mW**7*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2)*sqrt(2))/(9.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*mt**3*mW**9*einsum("pT,st,rT,TT",C["uW"],kd,kd,kdt)*log(scale**2/mW**2)*sqrt(2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2) - (5*mt**3*mW**7*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2)*sqrt(2))/(9.*(mt - mW)**4*(mt + mW)**4*pi**2*vT**2) + (5*mt**3*mW**9*einsum("Tr,st,pT,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mW**2)*sqrt(2))/(9.*(mt - mW)**4*(mt + mW)**4*mZ**2*pi**2*vT**2))
    c['V1udduLR'] = ((19*mW**2*einsum("st,pr",C["phiudDag"],kd))/(12.*pi**2*vT**2) - (cEvan*mW**2*einsum("st,pr",C["phiudDag"],kd))/(36.*pi**2*vT**2) - (17*mW**4*einsum("st,pr",C["phiudDag"],kd))/(24.*mZ**2*pi**2*vT**2) + (cEvan*mW**4*einsum("st,pr",C["phiudDag"],kd))/(36.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("st,pr",C["phiudDag"],kd))/(2.*pi**2*vT**2) + (mt**2*Nc*einsum("st,pr",C["phiudDag"],kd))/(16.*pi**2*vT**2) + (mt**2*Nc*einsum("st,pr",C["phiudDag"],kd)*log(scale**2/mt**2))/(8.*pi**2*vT**2) + (3*mW**2*mZ**2*einsum("st,pr",C["phiudDag"],kd)*log(scale**2/mW**2))/(8.*(mW**2 - mZ**2)*pi**2*vT**2) - (29*mW**4*einsum("st,pr",C["phiudDag"],kd)*log(scale**2/mZ**2))/(24.*(-mW**2 + mZ**2)*pi**2*vT**2) + (5*mW**6*einsum("st,pr",C["phiudDag"],kd)*log(scale**2/mZ**2))/(12.*mZ**2*(-mW**2 + mZ**2)*pi**2*vT**2) + (37*mW**2*mZ**2*einsum("st,pr",C["phiudDag"],kd)*log(scale**2/mZ**2))/(24.*(-mW**2 + mZ**2)*pi**2*vT**2) - (3*mZ**4*einsum("st,pr",C["phiudDag"],kd)*log(scale**2/mZ**2))/(8.*(-mW**2 + mZ**2)*pi**2*vT**2))
    c['V1udLR'] = ((5*mW**2*einsum("prst",C["qd1"]))/(24.*pi**2*vT**2) - (5*cEvan*mW**2*einsum("prst",C["qd1"]))/(18.*pi**2*vT**2) - (mW**4*einsum("prst",C["qd1"]))/(6.*mZ**2*pi**2*vT**2) + (2*cEvan*mW**4*einsum("prst",C["qd1"]))/(9.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("prst",C["qd1"]))/(24.*pi**2*vT**2) + (cEvan*mZ**2*einsum("prst",C["qd1"]))/(18.*pi**2*vT**2) - (7*mH**2*einsum("pr,st",kd,kd))/(144.*pi**2*vT**4) - (10409*mW**2*einsum("pr,st",kd,kd))/(58320.*pi**2*vT**4) - (4*cEvan*mW**2*einsum("pr,st",kd,kd))/(81.*pi**2*vT**4) - (mW**4*einsum("pr,st",kd,kd))/(6.*mH**2*pi**2*vT**4) - (362*mW**8*einsum("pr,st",kd,kd))/(729.*mZ**6*pi**2*vT**4) + (16*cEvan*mW**8*einsum("pr,st",kd,kd))/(81.*mZ**6*pi**2*vT**4) - (7*mH**2*mW**4*einsum("pr,st",kd,kd))/(36.*mZ**4*pi**2*vT**4) + (254*mW**6*einsum("pr,st",kd,kd))/(405.*mZ**4*pi**2*vT**4) - (4*cEvan*mW**6*einsum("pr,st",kd,kd))/(9.*mZ**4*pi**2*vT**4) - (2*mW**8*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**4) + (35*mH**2*mW**2*einsum("pr,st",kd,kd))/(144.*mZ**2*pi**2*vT**4) + (109*mW**4*einsum("pr,st",kd,kd))/(4860.*mZ**2*pi**2*vT**4) + (8*cEvan*mW**4*einsum("pr,st",kd,kd))/(27.*mZ**2*pi**2*vT**4) + (5*mW**6*einsum("pr,st",kd,kd))/(18.*mH**2*mZ**2*pi**2*vT**4) + (11*mZ**2*einsum("pr,st",kd,kd))/(432.*pi**2*vT**4) + (5*mW**2*mZ**2*einsum("pr,st",kd,kd))/(36.*mH**2*pi**2*vT**4) - (mZ**4*einsum("pr,st",kd,kd))/(36.*mH**2*pi**2*vT**4) + (mt**4*Nc*einsum("pr,st",kd,kd))/(9.*mH**2*pi**2*vT**4) + (32*mW**4*Nc*einsum("pr,st",kd,kd))/(1215.*mt**2*pi**2*vT**4) + (4*mt**4*mW**4*Nc*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**4) + (32*mW**8*Nc*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**4*pi**2*vT**4) - (5*mt**4*mW**2*Nc*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**2*pi**2*vT**4) - (64*mW**6*Nc*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**2*pi**2*vT**4) + (C["phi"]*einsum("pr,st",kd,kd))/(12.*pi**2) + (mW**4*C["phi"]*einsum("pr,st",kd,kd))/(3.*mZ**4*pi**2) - (5*mW**2*C["phi"]*einsum("pr,st",kd,kd))/(12.*mZ**2*pi**2) - (5*mH**2*mW**2*C["phiB"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (83*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(36.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (11*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (4*mH**4*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (8*mW**10*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (13*mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (2*mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (13*mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (8*mW**10*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (5*mH**4*mW**2*C["phiB"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (13*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (17*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (13*mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (37*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(36.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (11*mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (11*mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(18.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mZ**6*C["phiB"]*einsum("pr,st",kd,kd))/(18.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (10*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (16*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (26*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (16*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (10*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (26*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (11*mH**2*C["phiBox"]*einsum("pr,st",kd,kd))/(72.*pi**2*vT**2) - (25*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(72.*pi**2*vT**2) - (mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(3.*mH**2*pi**2*vT**2) - (11*mH**2*mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(18.*mZ**4*pi**2*vT**2) - (4*mW**8*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) + (55*mH**2*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(72.*mZ**2*pi**2*vT**2) + (5*mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(18.*mZ**2*pi**2*vT**2) + (5*mW**6*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**2*pi**2*vT**2) + (5*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(72.*pi**2*vT**2) + (5*mW**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(18.*mH**2*pi**2*vT**2) - (mZ**4*C["phiBox"]*einsum("pr,st",kd,kd))/(18.*mH**2*pi**2*vT**2) + (2*mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*pi**2*vT**2) + (8*mt**4*mW**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) - (10*mt**4*mW**2*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**2*pi**2*vT**2) + (mH**2*C["phiD"]*einsum("pr,st",kd,kd))/(18.*pi**2*vT**2) - (3257*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(23328.*pi**2*vT**2) + (2*cEvan*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(81.*pi**2*vT**2) - (mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(12.*mH**2*pi**2*vT**2) - (362*mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(729.*mZ**6*pi**2*vT**2) + (16*cEvan*mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(81.*mZ**6*pi**2*vT**2) + (mH**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(36.*mZ**4*pi**2*vT**2) + (49*mW**6*C["phiD"]*einsum("pr,st",kd,kd))/(405.*mZ**4*pi**2*vT**2) - (2*cEvan*mW**6*C["phiD"]*einsum("pr,st",kd,kd))/(9.*mZ**4*pi**2*vT**2) - (mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) - (5*mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(32.*mZ**2*pi**2*vT**2) + (1253*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(3240.*mZ**2*pi**2*vT**2) + (mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(108.*pi**2*vT**2) + (5*mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(72.*mH**2*pi**2*vT**2) - (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(18.*mH**2*pi**2*vT**2) + (2*mt**4*mW**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) + (32*mW**8*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**4*pi**2*vT**2) - (32*mW**6*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**2*pi**2*vT**2) + (5*mH**2*mW**2*C["phiW"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (71*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(36.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (4*mH**4*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (8*mW**10*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (13*mH**4*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (2*mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (mW**8*C["phiW"]*einsum("pr,st",kd,kd))/((mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (8*mW**10*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (5*mH**4*mW**2*C["phiW"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (13*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(12.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (4*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mW**8*C["phiW"]*einsum("pr,st",kd,kd))/(mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (3*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (8*mW**4*mZ**2*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**2*mZ**4*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (10*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (16*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (26*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (16*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (10*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (26*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (25*g1bar*mH**2*mW*C["phiWB"]*einsum("pr,st",kd,kd))/(432.*(mH - mZ)*(mH + mZ)*pi**2*vT) + (23281*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(29160.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (14*cEvan*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) - (2*g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) - (1048*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(729.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (32*cEvan*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) - (4*g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) + (g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (12149*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(7290.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (46*cEvan*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (2501*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(1458.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (32*cEvan*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (4*g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (5*g1bar*mH**4*mW*C["phiWB"]*einsum("pr,st",kd,kd))/(96.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (9511*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(29160.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (14*cEvan*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (14579*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(7290.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) + (46*cEvan*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd))/(81.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (5*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd))/(18.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (79*g1bar*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(864.*(mH - mZ)*(mH + mZ)*pi**2*vT) - (5*g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd))/(18.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) + (g1bar*mW*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd))/(36.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT) + (64*g1bar*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*mt**2*(mH - mZ)*(mH + mZ)*pi**2*vT) + (8*g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT) - (5*g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) - (8*g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (64*g1bar*mH**2*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*mt**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT) + (5*g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (64*g1bar*mH**2*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*mt**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (64*g1bar*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd))/(1215.*mt**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT) - (5*mW**3*C["W"]*einsum("pr,st",kd,kd))/(6.*pi**2*vT**3) - (4*mW**7*C["W"]*einsum("pr,st",kd,kd))/(3.*mZ**4*pi**2*vT**3) + (13*mW**5*C["W"]*einsum("pr,st",kd,kd))/(6.*mZ**2*pi**2*vT**3) + (101*mW**2*einsum("pr,st",C["phiq1"],kd))/(243.*pi**2*vT**2) - (4*cEvan*mW**2*einsum("pr,st",C["phiq1"],kd))/(27.*pi**2*vT**2) + (80*mW**6*einsum("pr,st",C["phiq1"],kd))/(243.*mZ**4*pi**2*vT**2) - (4*cEvan*mW**6*einsum("pr,st",C["phiq1"],kd))/(27.*mZ**4*pi**2*vT**2) - (335*mW**4*einsum("pr,st",C["phiq1"],kd))/(486.*mZ**2*pi**2*vT**2) + (8*cEvan*mW**4*einsum("pr,st",C["phiq1"],kd))/(27.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("pr,st",C["phiq1"],kd))/(18.*pi**2*vT**2) - (113*mW**2*einsum("pr,st",C["phiq3"],kd))/(972.*pi**2*vT**2) + (4*cEvan*mW**2*einsum("pr,st",C["phiq3"],kd))/(27.*pi**2*vT**2) - (80*mW**6*einsum("pr,st",C["phiq3"],kd))/(243.*mZ**4*pi**2*vT**2) + (4*cEvan*mW**6*einsum("pr,st",C["phiq3"],kd))/(27.*mZ**4*pi**2*vT**2) + (379*mW**4*einsum("pr,st",C["phiq3"],kd))/(972.*mZ**2*pi**2*vT**2) - (8*cEvan*mW**4*einsum("pr,st",C["phiq3"],kd))/(27.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("pr,st",C["phiq3"],kd))/(18.*pi**2*vT**2) - (241*mW**2*einsum("st,pr",C["phid"],kd))/(972.*pi**2*vT**2) + (2*cEvan*mW**2*einsum("st,pr",C["phid"],kd))/(27.*pi**2*vT**2) - (202*mW**6*einsum("st,pr",C["phid"],kd))/(243.*mZ**4*pi**2*vT**2) + (8*cEvan*mW**6*einsum("st,pr",C["phid"],kd))/(27.*mZ**4*pi**2*vT**2) + (511*mW**4*einsum("st,pr",C["phid"],kd))/(486.*mZ**2*pi**2*vT**2) - (10*cEvan*mW**4*einsum("st,pr",C["phid"],kd))/(27.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("st,pr",C["phid"],kd))/(36.*pi**2*vT**2) + (mt**2*einsum("pTTr,st,TT",C["qq1"],kd,kdt))/(12.*pi**2*vT**2) - (mW**2*einsum("pTTr,st,TT",C["qq1"],kd,kdt))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("pTTr,st,TT",C["qq1"],kd,kdt))/(12.*mZ**2*pi**2*vT**2) + (mW**4*einsum("pTTr,st,TT",C["qq1"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) + (mt**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(12.*pi**2*vT**2) - (mW**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(12.*mZ**2*pi**2*vT**2) + (mW**4*einsum("pTTr,st,TT",C["qq3"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) + (mt**2*einsum("TrpT,st,TT",C["qq1"],kd,kdt))/(12.*pi**2*vT**2) - (mW**2*einsum("TrpT,st,TT",C["qq1"],kd,kdt))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("TrpT,st,TT",C["qq1"],kd,kdt))/(12.*mZ**2*pi**2*vT**2) + (mW**4*einsum("TrpT,st,TT",C["qq1"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) + (mt**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(12.*pi**2*vT**2) - (mW**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(27.*pi**2*vT**2) - (mt**2*mW**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(12.*mZ**2*pi**2*vT**2) + (mW**4*einsum("TrpT,st,TT",C["qq3"],kd,kdt))/(27.*mZ**2*pi**2*vT**2) - (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(18.*sqrt(2)*mH**2*pi**2*vT) + (5*mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt))/(18.*sqrt(2)*mH**2*mZ**2*pi**2*vT) - (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(18.*sqrt(2)*mH**2*pi**2*vT) + (5*mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt))/(18.*sqrt(2)*mH**2*mZ**2*pi**2*vT) - (mH**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(24.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (5*mH**2*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (mH**4*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) + (5*mH**4*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(24.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) + (mH**2*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) + (mH**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*pi**2) + (mW**4*C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*mZ**4*pi**2) - (5*mW**2*C["phi"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*mZ**2*pi**2) - (5*mH**4*mW**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (13*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (4*mH**6*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT**2) - (13*mH**6*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) - (4*mH**4*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) + (5*mH**6*mW**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (13*mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (4*mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (5*mH**2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (5*mH**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(36.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (10*mH**2*mW**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (5*mH**4*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (25*mH**4*mW**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(36.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (8*mH**2*mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (2*mH**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (5*mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(72.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mH**4*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (25*mH**4*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(144.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (mH**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (mH**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (5*mH**4*mW**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (13*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (4*mH**6*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT**2) + (13*mH**6*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) + (4*mH**4*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT**2) - (5*mH**6*mW**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(18.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (13*mH**4*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (4*mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (5*mH**2*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (5*g1bar*mH**4*mW*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(48.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (5*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (2*g1bar*mH**6*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(9.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**6*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(12.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) + (2*g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) + (5*g1bar*mH**6*mW*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(144.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(4.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) - (2*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mH**2))/(3.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) - (mt**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(36.*pi**2*vT**4) + (mt**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*pi**2*vT**4) - (25*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*pi**2*vT**4) + (64*mW**8*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**6*pi**2*vT**4) - (mt**2*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**4) + (4*mt**4*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**4) - (16*mW**6*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**4) + (5*mt**2*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(36.*mZ**2*pi**2*vT**4) - (5*mt**4*mW**2*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**2*pi**2*vT**4) + (35*mW**4*Nc*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**4) - (16*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**6*pi**2*vT**2) + (26*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**2) - (10*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**2*pi**2*vT**2) + (2*mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*pi**2*vT**2) + (8*mt**4*mW**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**2) - (10*mt**4*mW**2*Nc*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**2*pi**2*vT**2) + (mt**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(36.*pi**2*vT**2) - (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(18.*mH**2*pi**2*vT**2) + (25*mW**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(486.*pi**2*vT**2) + (64*mW**8*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**6*pi**2*vT**2) + (2*mt**4*mW**4*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**2) - (8*mW**6*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(27.*mZ**4*pi**2*vT**2) - (5*mt**2*mW**2*Nc*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(72.*mZ**2*pi**2*vT**2) + (16*mt**4*mW**6*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**6*pi**2*vT**2) - (26*mt**4*mW**4*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT**2) + (10*mt**4*mW**2*Nc*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**2*pi**2*vT**2) + (8*g1bar*mt**4*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**6*pi**2*vT) + (128*g1bar*mW**7*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**6*pi**2*vT) - (g1bar*mt**2*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT) - (5*g1bar*mt**4*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(9.*mH**2*mZ**4*pi**2*vT) - (184*g1bar*mW**5*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**4*pi**2*vT) + (5*g1bar*mt**2*mW*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(72.*mZ**2*pi**2*vT) + (65*g1bar*mW**3*Nc*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mt**2))/(243.*mZ**2*pi**2*vT) - (mt**2*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(12.*pi**2*vT**2) - (5*mW**2*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) - (8*mW**6*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(12.*pi**2*vT**2) + (5*mW**2*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) + (8*mW**6*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (13*mW**4*Nc*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("st,pr",C["phid"],kd)*log(scale**2/mt**2))/(24.*pi**2*vT**2) + (10*mW**2*Nc*einsum("st,pr",C["phid"],kd)*log(scale**2/mt**2))/(81.*pi**2*vT**2) + (16*mW**6*Nc*einsum("st,pr",C["phid"],kd)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("st,pr",C["phid"],kd)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) - (26*mW**4*Nc*einsum("st,pr",C["phid"],kd)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("prTT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) + (mW**2*Nc*einsum("prTT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("prTT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("prTT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) + (mW**2*Nc*einsum("prTT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("prTT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("prTT,st,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) + (mW**2*Nc*einsum("prTT,st,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("prTT,st,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("prTT,st,TT",C["qu1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*einsum("pTTr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) + (mW**2*einsum("pTTr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("pTTr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*einsum("pTTr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) + (mW**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*einsum("pTTr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*einsum("TrpT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) + (mW**2*einsum("TrpT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("TrpT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*einsum("TrpT,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) + (mW**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*einsum("TrpT,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TTpr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) + (mW**2*Nc*einsum("TTpr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TTpr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("TTpr,st,TT",C["qq1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TTpr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*pi**2*vT**2) + (mW**2*Nc*einsum("TTpr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TTpr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(12.*mZ**2*pi**2*vT**2) - (mW**4*Nc*einsum("TTpr,st,TT",C["qq3"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TTst,pr,TT",C["qd1"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) - (2*mW**2*Nc*einsum("TTst,pr,TT",C["qd1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) - (mt**2*mW**2*Nc*einsum("TTst,pr,TT",C["qd1"],kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) + (2*mW**4*Nc*einsum("TTst,pr,TT",C["qd1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TTst,pr,TT",C["ud1"],kd,kdt)*log(scale**2/mt**2))/(24.*pi**2*vT**2) - (2*mW**2*Nc*einsum("TTst,pr,TT",C["ud1"],kd,kdt)*log(scale**2/mt**2))/(27.*pi**2*vT**2) + (mt**2*mW**2*Nc*einsum("TTst,pr,TT",C["ud1"],kd,kdt)*log(scale**2/mt**2))/(6.*mZ**2*pi**2*vT**2) + (2*mW**4*Nc*einsum("TTst,pr,TT",C["ud1"],kd,kdt)*log(scale**2/mt**2))/(27.*mZ**2*pi**2*vT**2) + (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*pi**2*vT**2) - (5*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*pi**2*vT**2) + (2*mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**2) - (8*mW**6*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) - (5*mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq1"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*pi**2*vT**2) + (5*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*pi**2*vT**2) - (2*mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**2) + (8*mW**6*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (5*mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*mZ**2*pi**2*vT**2) - (13*mW**4*Nc*einsum("TT,pr,st,TT",C["phiq3"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) - (mt**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*pi**2*vT**2) - (5*mW**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*pi**2*vT**2) - (2*mt**2*mW**4*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(9.*mZ**4*pi**2*vT**2) - (8*mW**6*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**4*pi**2*vT**2) + (5*mt**2*mW**2*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*mZ**2*pi**2*vT**2) + (13*mW**4*Nc*einsum("TT,pr,st,TT",C["phiu"],kd,kd,kdt)*log(scale**2/mt**2))/(81.*mZ**2*pi**2*vT**2) - (23*g1bar*mt*mW**4*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*sqrt(2)*mZ**4*pi**2*vT) + (65*g1bar*mt*mW**2*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2))/(216.*sqrt(2)*mZ**2*pi**2*vT) - (23*g1bar*mt*mW**4*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(27.*sqrt(2)*mZ**4*pi**2*vT) + (65*g1bar*mt*mW**2*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2))/(216.*sqrt(2)*mZ**2*pi**2*vT) - (mt**3*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*mH**2*pi**2*vT) + (5*mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*mH**2*mZ**2*pi**2*vT) - (mt**3*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*mH**2*pi**2*vT) + (5*mt**3*mW**2*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2))/(18.*sqrt(2)*mH**2*mZ**2*pi**2*vT) + (25*mt*mW*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*sqrt(2)*pi**2*vT**2) - (145*mt*mW**3*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*sqrt(2)*mZ**2*pi**2*vT**2) + (25*mt*mW*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*sqrt(2)*pi**2*vT**2) - (145*mt*mW**3*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2))/(108.*sqrt(2)*mZ**2*pi**2*vT**2) - (mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mH**2*pi**2*vT**4) - (28*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(9.*mZ**6*pi**2*vT**4) + (287*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(54.*mZ**4*pi**2*vT**4) - (2*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**4*pi**2*vT**4) - (119*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(54.*mZ**2*pi**2*vT**4) + (5*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mH**2*mZ**2*pi**2*vT**4) + (8*mW**10*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**6*pi**2*vT**2) - (13*mW**8*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**4*pi**2*vT**2) + (5*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**2*pi**2*vT**2) - (mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*pi**2*vT**2) - (4*mW**8*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**4*pi**2*vT**2) + (5*mW**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**2*pi**2*vT**2) + (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(12.*mH**2*pi**2*vT**2) - (28*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(9.*mZ**6*pi**2*vT**2) + (301*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(108.*mZ**4*pi**2*vT**2) - (mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**4*pi**2*vT**2) - (7*mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(54.*mZ**2*pi**2*vT**2) - (mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*pi**2*vT**2) - (8*mW**10*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**6*pi**2*vT**2) + (3*mW**8*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mH**2*mZ**4*pi**2*vT**2) - (44*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(9.*mZ**6*pi**2*vT) - (4*g1bar*mW**9*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mH**2*mZ**6*pi**2*vT) + (179*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(36.*mZ**4*pi**2*vT) + (5*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mH**2*mZ**4*pi**2*vT) - (169*g1bar*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(216.*mZ**2*pi**2*vT) + (5*mW**3*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*pi**2*vT**3) - (16*mW**9*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(mZ**6*pi**2*vT**3) + (82*mW**7*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(3.*mZ**4*pi**2*vT**3) - (73*mW**5*C["W"]*einsum("pr,st",kd,kd)*log(scale**2/mW**2))/(6.*mZ**2*pi**2*vT**3) + (7*mW**6*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mW**2))/(6.*mZ**4*pi**2*vT**2) - (7*mW**4*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mW**2))/(6.*mZ**2*pi**2*vT**2) - (14*mW**2*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mW**2))/(27.*pi**2*vT**2) - (7*mW**6*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mW**2))/(6.*mZ**4*pi**2*vT**2) + (91*mW**4*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mW**2))/(54.*mZ**2*pi**2*vT**2) - (7*mW**6*einsum("st,pr",C["phid"],kd)*log(scale**2/mW**2))/(3.*mZ**4*pi**2*vT**2) + (7*mW**4*einsum("st,pr",C["phid"],kd)*log(scale**2/mW**2))/(3.*mZ**2*pi**2*vT**2) + (5*mW**2*einsum("prst",C["qd1"])*log(scale**2/mZ**2))/(12.*pi**2*vT**2) - (mW**4*einsum("prst",C["qd1"])*log(scale**2/mZ**2))/(3.*mZ**2*pi**2*vT**2) - (mZ**2*einsum("prst",C["qd1"])*log(scale**2/mZ**2))/(12.*pi**2*vT**2) + (23*mH**2*mW**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (5*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(162.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (92*mH**2*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**4) + (22*mH**2*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(27.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) + (92*mW**8*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**4) - (43*mH**2*mW**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(81.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) - (22*mW**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(27.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**4) + (1031*mW**2*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(1944.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mW**4*mZ**2*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(8.*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (5*mW**2*mZ**4*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(12.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) + (mZ**6*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(12.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**4) - (11*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (40*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(9.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (2*mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) + (11*mH**2*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (145*mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(18.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (2*mW**6*mZ**2*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mH**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (71*mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(18.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (11*mW**4*mZ**4*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (mZ**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (11*mW**2*mZ**6*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mZ**8*C["phiB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mW**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)*(mH + mZ)*pi**2*vT**2) + (5*mW**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (2*mW**4*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(4.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (5*mW**2*mZ**4*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mZ**6*C["phiBox"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (23*mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(486.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mW**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(2.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (92*mH**2*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (11*mH**2*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(27.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (92*mW**8*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (11*mW**6*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(27.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (1399*mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3888.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mW**4*mZ**2*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(3.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (5*mW**2*mZ**4*C["phiD"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(24.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (3*mH**2*mW**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (40*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(9.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (2*mH**2*mW**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT**2) - (mH**2*mW**2*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/((mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (121*mW**4*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(18.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (2*mW**6*mZ**2*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (41*mW**2*mZ**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(18.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (3*mW**4*mZ**4*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) - (mW**2*mZ**6*C["phiW"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT**2) + (314*g1bar*mH**2*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (791*g1bar*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (184*g1bar*mH**4*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**6*(mH + mZ)**2*pi**2*vT) + (251*g1bar*mH**4*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) + (368*g1bar*mH**2*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**4*(mH + mZ)**2*pi**2*vT) - (76*g1bar*mH**4*mW**3*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) - (745*g1bar*mH**2*mW**5*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) - (184*g1bar*mW**7*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(243.*(mH - mZ)**2*mZ**2*(mH + mZ)**2*pi**2*vT) + (g1bar*mH**2*mW*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(48.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (2005*g1bar*mW**3*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(972.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mW**5*mZ**2*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (19*g1bar*mW*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(144.*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (5*g1bar*mW**3*mZ**4*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(6.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) - (g1bar*mW*mZ**6*C["phiWB"]*einsum("pr,st",kd,kd)*log(scale**2/mZ**2))/(12.*mH**2*(mH - mZ)**2*(mH + mZ)**2*pi**2*vT) + (20*mW**2*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mZ**2))/(81.*pi**2*vT**2) + (26*mW**6*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mZ**2))/(81.*mZ**4*pi**2*vT**2) - (46*mW**4*einsum("pr,st",C["phiq1"],kd)*log(scale**2/mZ**2))/(81.*mZ**2*pi**2*vT**2) - (20*mW**2*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mZ**2))/(81.*pi**2*vT**2) - (26*mW**6*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mZ**2))/(81.*mZ**4*pi**2*vT**2) + (46*mW**4*einsum("pr,st",C["phiq3"],kd)*log(scale**2/mZ**2))/(81.*mZ**2*pi**2*vT**2) - (13*mW**2*einsum("st,pr",C["phid"],kd)*log(scale**2/mZ**2))/(81.*pi**2*vT**2) - (40*mW**6*einsum("st,pr",C["phid"],kd)*log(scale**2/mZ**2))/(81.*mZ**4*pi**2*vT**2) + (53*mW**4*einsum("st,pr",C["phid"],kd)*log(scale**2/mZ**2))/(81.*mZ**2*pi**2*vT**2) + (2*g1bar*mW**6*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**4*pi**2*vT) - (2*g1bar*mW**4*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**2*pi**2*vT) + (2*g1bar*mW**6*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**4*pi**2*vT) - (2*g1bar*mW**4*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**2*pi**2*vT) - (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*sqrt(2))/(9.*mH**2*mZ**4*pi**2*vT) - (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*sqrt(2))/(9.*mH**2*mZ**4*pi**2*vT) - (4*mW**3*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(81.*mt*pi**2*vT**2) - (4*mW**7*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**4*pi**2*vT**2) + (8*mW**5*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**2*pi**2*vT**2) - (4*mW**3*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*pi**2*vT**2) - (4*mW**7*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**4*pi**2*vT**2) + (8*mW**5*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*sqrt(2))/(81.*mt*mZ**2*pi**2*vT**2) + (8*g1bar*mt*mW**6*Nc*einsum("TT,pr,st,TT",C["uB"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**6*pi**2*vT) + (8*g1bar*mt*mW**6*Nc*einsum("TT,pr,st,TT",C["uBDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**6*pi**2*vT) - (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphi"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*mH**2*mZ**4*pi**2*vT) - (mt**3*mW**4*Nc*einsum("TT,pr,st,TT",C["uphiDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(9.*mH**2*mZ**4*pi**2*vT) - (16*mt*mW**7*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**6*pi**2*vT**2) + (31*mt*mW**5*Nc*einsum("TT,pr,st,TT",C["uW"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**4*pi**2*vT**2) - (16*mt*mW**7*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**6*pi**2*vT**2) + (31*mt*mW**5*Nc*einsum("TT,pr,st,TT",C["uWDag"],kd,kd,kdt)*log(scale**2/mt**2)*sqrt(2))/(27.*mZ**4*pi**2*vT**2))
    c['V1uuLR'] = ((-5*mW**2*einsum("prst",C["qu1"]))/(12.*pi**2*vT**2) + (5*cEvan*mW**2*einsum("prst",C["qu1"]))/(9.*pi**2*vT**2) + (mW**4*einsum("prst",C["qu1"]))/(3.*mZ**2*pi**2*vT**2) - (4*cEvan*mW**4*einsum("prst",C["qu1"]))/(9.*mZ**2*pi**2*vT**2) + (mZ**2*einsum("prst",C["qu1"]))/(12.*pi**2*vT**2) - (cEvan*mZ**2*einsum("prst",C["qu1"]))/(9.*pi**2*vT**2) + (7*mH**2*einsum("pr,st",kd,kd))/(72.*pi**2*vT**4) + (36449*mW**2*einsum("pr,st",kd,kd))/(29160.*pi**2*vT**4) - (16*cEvan*mW**2*einsum("pr,st",kd,kd))/(81.*pi**2*vT**4) + (mW**4*einsum("pr,st",kd,kd))/(3.*mH**2*pi**2*vT**4) - (656*mW**8*einsum("pr,st",kd,kd))/(729.*mZ**6*pi**2*vT**4) + (64*cEvan*mW**8*einsum("pr,st",kd,kd))/(81.*mZ**6*pi**2*vT**4) + (7*mH**2*mW**4*einsum("pr,st",kd,kd))/(18.*mZ**4*pi**2*vT**4) + (1342*mW**6*einsum("pr,st",kd,kd))/(405.*mZ**4*pi**2*vT**4) - (16*cEvan*mW**6*einsum("pr,st",kd,kd))/(9.*mZ**4*pi**2*vT**4) + (4*mW**8*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**4) - (35*mH**2*mW**2*einsum("pr,st",kd,kd))/(72.*mZ**2*pi**2*vT**4) - (4322*mW**4*einsum("pr,st",kd,kd))/(1215.*mZ**2*pi**2*vT**4) + (32*cEvan*mW**4*einsum("pr,st",kd,kd))/(27.*mZ**2*pi**2*vT**4) - (5*mW**6*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**2*pi**2*vT**4) - (23*mZ**2*einsum("pr,st",kd,kd))/(216.*pi**2*vT**4) - (5*mW**2*mZ**2*einsum("pr,st",kd,kd))/(18.*mH**2*pi**2*vT**4) + (mZ**4*einsum("pr,st",kd,kd))/(18.*mH**2*pi**2*vT**4) - (2*mt**4*Nc*einsum("pr,st",kd,kd))/(9.*mH**2*pi**2*vT**4) - (64*mW**4*Nc*einsum("pr,st",kd,kd))/(1215.*mt**2*pi**2*vT**4) - (8*mt**4*mW**4*Nc*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**4) - (64*mW**8*Nc*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**4*pi**2*vT**4) + (10*mt**4*mW**2*Nc*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**2*pi**2*vT**4) + (128*mW**6*Nc*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**2*pi**2*vT**4) - (C["phi"]*einsum("pr,st",kd,kd))/(6.*pi**2) - (2*mW**4*C["phi"]*einsum("pr,st",kd,kd))/(3.*mZ**4*pi**2) + (5*mW**2*C["phi"]*einsum("pr,st",kd,kd))/(6.*mZ**2*pi**2) + (5*mH**2*mW**2*C["phiB"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (83*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (22*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (8*mH**4*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (16*mW**10*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) + (13*mH**4*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (4*mH**2*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(3.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (26*mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (16*mW**10*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (5*mH**4*mW**2*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (13*mH**2*mW**4*C["phiB"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (34*mW**6*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (26*mW**8*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) - (37*mW**2*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (22*mW**4*mZ**2*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (11*mW**2*mZ**4*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (mZ**6*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (20*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*(mH + mZ)*pi**2*vT**2) + (32*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**6*(mH + mZ)*pi**2*vT**2) - (52*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) - (32*mt**4*mW**6*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**4*(mH + mZ)*pi**2*vT**2) + (20*mt**4*mW**2*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (52*mt**4*mW**4*Nc*C["phiB"]*einsum("pr,st",kd,kd))/(9.*mH**2*(mH - mZ)*mZ**2*(mH + mZ)*pi**2*vT**2) + (11*mH**2*C["phiBox"]*einsum("pr,st",kd,kd))/(36.*pi**2*vT**2) + (25*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(36.*pi**2*vT**2) + (2*mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(3.*mH**2*pi**2*vT**2) + (11*mH**2*mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mZ**4*pi**2*vT**2) + (8*mW**8*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) - (55*mH**2*mW**2*C["phiBox"]*einsum("pr,st",kd,kd))/(36.*mZ**2*pi**2*vT**2) - (5*mW**4*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mZ**2*pi**2*vT**2) - (10*mW**6*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**2*pi**2*vT**2) - (5*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(36.*pi**2*vT**2) - (5*mW**2*mZ**2*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*pi**2*vT**2) + (mZ**4*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*pi**2*vT**2) - (4*mt**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*pi**2*vT**2) - (16*mt**4*mW**4*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) + (20*mt**4*mW**2*Nc*C["phiBox"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**2*pi**2*vT**2) - (mH**2*C["phiD"]*einsum("pr,st",kd,kd))/(9.*pi**2*vT**2) - (1951*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(11664.*pi**2*vT**2) + (8*cEvan*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(81.*pi**2*vT**2) + (mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(6.*mH**2*pi**2*vT**2) - (656*mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(729.*mZ**6*pi**2*vT**2) + (64*cEvan*mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(81.*mZ**6*pi**2*vT**2) - (mH**2*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(18.*mZ**4*pi**2*vT**2) + (827*mW**6*C["phiD"]*einsum("pr,st",kd,kd))/(405.*mZ**4*pi**2*vT**2) - (8*cEvan*mW**6*C["phiD"]*einsum("pr,st",kd,kd))/(9.*mZ**4*pi**2*vT**2) + (2*mW**8*C["phiD"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) + (5*mH**2*mW**2*C["phiD"]*einsum("pr,st",kd,kd))/(16.*mZ**2*pi**2*vT**2) - (1253*mW**4*C["phiD"]*einsum("pr,st",kd,kd))/(1620.*mZ**2*pi**2*vT**2) + (mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(27.*pi**2*vT**2) - (5*mW**2*mZ**2*C["phiD"]*einsum("pr,st",kd,kd))/(36.*mH**2*pi**2*vT**2) + (mt**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(9.*mH**2*pi**2*vT**2) - (4*mt**4*mW**4*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(9.*mH**2*mZ**4*pi**2*vT**2) - (64*mW**8*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**4*pi**2*vT**2) + (64*mW**6*Nc*C["phiD"]*einsum("pr,st",kd,kd))/(1215.*mt**2*mZ**2*pi**2*vT**2) - (5*mH**2*mW**2*C["phiW"]*einsum("pr,st",kd,kd))/(6.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (71*mW**4*C["phiW"]*einsum("pr,st",kd,kd))/(18.*(mH - mZ)*(mH + mZ)*pi**2*vT**2) - (4*mW**6*C["phiW"]*einsum("pr,st",kd,kd))/(3.*mH**2*(mH - mZ