"""Word+inflection mapping for numbers in Finnish.

You can add inflections here. Note that the names of the forms must
conform regular expression "[A-Z]+". Note that a special symbols !
and " are used for ordinal versions of 1 and 2.

Currently supported inflections:

* ERI = 0567 -> nolla viisi kuusi seitsemän
* NOM = nominatiivi (viisi)
* PAR = partitiivi (viittä)
* GEN = genetiivi (viiden)
* INE = inessiivi (viidessä)
* ELA = elatiivi (viidestä)
* ILL = illatiivi (viiteen)
* ADE = adessiivi (viidellä)
* ABL = ablatiivi (viideltä)
* ALL = allatiivi (viidelle)
* ESS = essiivi (viitenä)
* TRA = translatiivi (viideksi)
* JNOM = järjestys nominatiivi (viides)
* JPAR = järjestys partitiivi (viidettä)
* JGEN = järjestys genetiivi (viidennen)
* JINE = järjestys inessiivi (viidennessä)
* JELA = järjestys elatiivi (viidennestä)
* JILL = järjestys illatiivi (viidenteen)
* JADE = järjestys adessiivi (viidennellä)
* JABL = järjestys ablatiivi (viidenneltä)
* JALL = järjestys allatiivi (viidennelle)
* JESS = järjestys essiivi (viidentenä)
* JTRA = järjestys translatiivi (viidenneksi)
"""
# Encodings for different bases of ten (ones, tens, hunderds, etc...)
UNITS = {0: "y", 1: "k", 2: "s", 3: "t", 6: "m", 9: "r", 12: "b"}

INFLECTIONS = {
    "NOM": {
        "0": "nolla",
        "1": "yksi",
        "2": "kaksi",
        "3": "kolme",
        "4": "neljä",
        "5": "viisi",
        "6": "kuusi",
        "7": "seitsemän",
        "8": "kahdeksan",
        "9": "yhdeksän",
        "o": "toista",
        "k": "kymmenen",
        "s": "sata",
        "t": "tuhat",
        "m": "miljoona",
        "r": "miljardi",
        "b": "biljoona",
    },
    "PAR": {
        "1": "yhtä",
        "2": "kahta",
        "3": "kolmea",
        "4": "neljää",
        "5": "viittä",
        "6": "kuutta",
        "7": "seitsemää",
        "8": "kahdeksaa",
        "9": "yhdeksää",
        "o": "toista",
        "k": "kymmentä",
        "s": "sataa",
        "t": "tuhatta",
        "m": "miljoonaa",
        "r": "miljardia",
        "b": "biljoonaa",
    },
    "GEN": {
        "1": "yhden",
        "2": "kahden",
        "3": "kolmen",
        "4": "neljän",
        "5": "viiden",
        "6": "kuuden",
        "7": "seitsemän",
        "8": "kahdeksan",
        "9": "yhdeksän",
        "o": "toista",
        "k": "kymmenen",
        "s": "sadan",
        "t": "tuhannen",
        "m": "miljoonan",
        "r": "miljardin",
        "b": "biljoonan",
    },
    "INE": {
        "1": "yhdessä",
        "2": "kahdessa",
        "3": "kolmessa",
        "4": "neljässä",
        "5": "viidessä",
        "6": "kuudessa",
        "7": "seitsemässä",
        "8": "kahdeksassa",
        "9": "yhdeksässä",
        "o": "toista",
        "k": "kymmenessä",
        "s": "sadassa",
        "t": "tuhannessa",
        "m": "miljoonassa",
        "r": "miljardissa",
        "b": "biljoonassa",
    },
    "ELA": {
        "1": "yhdestä",
        "2": "kahdesta",
        "3": "kolmesta",
        "4": "neljästä",
        "5": "viidestä",
        "6": "kuudesta",
        "7": "seitsemästä",
        "8": "kahdeksasta",
        "9": "yhdeksästä",
        "o": "toista",
        "k": "kymmenestä",
        "s": "sadasta",
        "t": "tuhannesta",
        "m": "miljoonasta",
        "r": "miljardista",
        "b": "biljoonasta",
    },
    "ILL": {
        "1": "yhteen",
        "2": "kahteen",
        "3": "kolmeen",
        "4": "neljään",
        "5": "viiteen",
        "6": "kuuteen",
        "7": "seitsemään",
        "8": "kahdeksaan",
        "9": "yhdeksään",
        "o": "toista",
        "k": "kymmeneen",
        "s": "sataan",
        "t": "tuhanteen",
        "m": "miljoonaan",
        "r": "miljardiin",
        "b": "biljoonaan",
    },
    "ADE": {
        "1": "yhdellä",
        "2": "kahdella",
        "3": "kolmella",
        "4": "neljällä",
        "5": "viidellä",
        "6": "kuudella",
        "7": "seitsemällä",
        "8": "kahdeksalla",
        "9": "yhdeksällä",
        "o": "toista",
        "k": "kymmenellä",
        "s": "sadalla",
        "t": "tuhannella",
        "m": "miljoonalla",
        "r": "miljardilla",
        "b": "biljoonalla",
    },
    "ABL": {
        "1": "yhdeltä",
        "2": "kahdelta",
        "3": "kolmelta",
        "4": "neljältä",
        "5": "viideltä",
        "6": "kuudelta",
        "7": "seitsemältä",
        "8": "kahdeksalta",
        "9": "yhdeksältä",
        "o": "toista",
        "k": "kymmeneltä",
        "s": "sadalta",
        "t": "tuhannelta",
        "m": "miljoonalta",
        "r": "miljardilta",
        "b": "biljoonalta",
    },
    "ALL": {
        "1": "yhdelle",
        "2": "kahdelle",
        "3": "kolmelle",
        "4": "neljälle",
        "5": "viidelle",
        "6": "kuudelle",
        "7": "seitsemälle",
        "8": "kahdeksalle",
        "9": "yhdeksälle",
        "o": "toista",
        "k": "kymmenelle",
        "s": "sadalle",
        "t": "tuhannelle",
        "m": "miljoonalle",
        "r": "miljardille",
        "b": "biljoonalle",
    },
    "ESS": {
        "1": "yhtenä",
        "2": "kahtena",
        "3": "kolmena",
        "4": "neljänä",
        "5": "viitenä",
        "6": "kuutena",
        "7": "seitsemänä",
        "8": "kahdeksana",
        "9": "yhdeksänä",
        "o": "toista",
        "k": "kymmenenä",
        "s": "satana",
        "t": "tuhantena",
        "m": "miljoonana",
        "r": "miljardina",
        "b": "biljoonana",
    },
    "TRA": {
        "1": "yhdeksi",
        "2": "kahdeksi",
        "3": "kolmeksi",
        "4": "neljäksi",
        "5": "viideksi",
        "6": "kuudeksi",
        "7": "seitsemäksi",
        "8": "kahdeksaksi",
        "9": "yhdeksäksi",
        "o": "toista",
        "k": "kymmeneksi",
        "s": "sadaksi",
        "t": "tuhanneksi",
        "m": "miljoonaksi",
        "r": "miljardiksi",
        "b": "biljoonaksi",
    },
    "JNOM": {
        "!": "ensimmäinen",
        '"': "toinen",
        "1": "yhdes",
        "2": "kahdes",
        "3": "kolmas",
        "4": "neljäs",
        "5": "viides",
        "6": "kuudes",
        "7": "seitsemäs",
        "8": "kahdeksas",
        "9": "yhdeksäs",
        "o": "toista",
        "k": "kymmenes",
        "s": "sadas",
        "t": "tuhannes",
        "m": "miljoonas",
        "r": "miljardis",
        "b": "biljoonas",
    },
    "JPAR": {
        "!": "ensimmäistä",
        '"': "toista",
        "1": "yhdettä",
        "2": "kahdetta",
        "3": "kolmatta",
        "4": "neljättä",
        "5": "viidettä",
        "6": "kuudetta",
        "7": "seitsemättä",
        "8": "kahdeksatta",
        "9": "yhdeksättä",
        "o": "toista",
        "k": "kymmenettä",
        "s": "sadatta",
        "t": "tuhannetta",
        "m": "miljoonatta",
        "r": "miljarditta",
        "b": "biljoonatta",
    },
    "JGEN": {
        "!": "ensimmäisen",
        '"': "toisen",
        "1": "yhdennen",
        "2": "kahdennen",
        "3": "kolmannen",
        "4": "neljännen",
        "5": "viidennen",
        "6": "kuudennen",
        "7": "seitsemännen",
        "8": "kahdeksannen",
        "9": "yhdeksännen",
        "o": "toista",
        "k": "kymmenennen",
        "s": "sadannen",
        "t": "tuhannennen",
        "m": "miljoonannen",
        "r": "miljardinnen",
        "b": "biljoonannen",
    },
    "JINE": {
        "!": "ensimmäisessä",
        '"': "toisessa",
        "1": "yhdennessä",
        "2": "kahdennessa",
        "3": "kolmannessa",
        "4": "neljännessä",
        "5": "viidennessä",
        "6": "kuudennessa",
        "7": "seitsemännessä",
        "8": "kahdeksannessa",
        "9": "yhdeksännessä",
        "o": "toista",
        "k": "kymmenennessä",
        "s": "sadannessa",
        "t": "tuhannennessa",
        "m": "miljoonannessa",
        "r": "miljardinnessa",
        "b": "biljoonannessa",
    },
    "JELA": {
        "!": "ensimmäisestä",
        '"': "toisesta",
        "1": "yhdennestä",
        "2": "kahdennesta",
        "3": "kolmannesta",
        "4": "neljännestä",
        "5": "viidennestä",
        "6": "kuudennesta",
        "7": "seitsemännestä",
        "8": "kahdeksannesta",
        "9": "yhdeksännestä",
        "o": "toista",
        "k": "kymmenennestä",
        "s": "sadannesta",
        "t": "tuhannennesta",
        "m": "miljoonannesta",
        "r": "miljardinnesta",
        "b": "biljoonannesta",
    },
    "JILL": {
        "!": "ensimmäiseen",
        '"': "toiseen",
        "1": "yhdenteen",
        "2": "kahdenteen",
        "3": "kolmanteen",
        "4": "neljänteen",
        "5": "viidenteen",
        "6": "kuudenteen",
        "7": "seitsemänteen",
        "8": "kahdeksanteen",
        "9": "yhdeksänteen",
        "o": "toista",
        "k": "kymmenenteen",
        "s": "sadanteen",
        "t": "tuhannenteen",
        "m": "miljoonanteen",
        "r": "miljardinteen",
        "b": "biljoonanteen",
    },
    "JADE": {
        "!": "ensimmäisellä",
        '"': "toisella",
        "1": "yhdennellä",
        "2": "kahdennella",
        "3": "kolmannella",
        "4": "neljännellä",
        "5": "viidennellä",
        "6": "kuudennella",
        "7": "seitsemännellä",
        "8": "kahdeksannella",
        "9": "yhdeksännellä",
        "o": "toista",
        "k": "kymmenennellä",
        "s": "sadannella",
        "t": "tuhannennella",
        "m": "miljoonannella",
        "r": "miljardinnella",
        "b": "biljoonannella",
    },
    "JABL": {
        "!": "ensimmäiseltä",
        '"': "toiselta",
        "1": "yhdenneltä",
        "2": "kahdennelta",
        "3": "kolmannelta",
        "4": "neljänneltä",
        "5": "viidenneltä",
        "6": "kuudennelta",
        "7": "seitsemänneltä",
        "8": "kahdeksannelta",
        "9": "yhdeksänneltä",
        "o": "toista",
        "k": "kymmenenneltä",
        "s": "sadannelta",
        "t": "tuhannennelta",
        "m": "miljoonannelta",
        "r": "miljardinnelta",
        "b": "biljoonannelta",
    },
    "JALL": {
        "!": "ensimmäiselle",
        '"': "toiselle",
        "1": "yhdennelle",
        "2": "kahdennelle",
        "3": "kolmannelle",
        "4": "neljännelle",
        "5": "viidennelle",
        "6": "kuudennelle",
        "7": "seitsemännelle",
        "8": "kahdeksannelle",
        "9": "yhdeksännelle",
        "o": "toista",
        "k": "kymmenennelle",
        "s": "sadannelle",
        "t": "tuhannennelle",
        "m": "miljoonannelle",
        "r": "miljardinnelle",
        "b": "biljoonannelle",
    },
    "JESS": {
        "!": "ensimmäisenä",
        '"': "toisena",
        "1": "yhdentenä",
        "2": "kahdentena",
        "3": "kolmantena",
        "4": "neljäntenä",
        "5": "viidentenä",
        "6": "kuudentena",
        "7": "seitsemäntenä",
        "8": "kahdeksantena",
        "9": "yhdeksäntenä",
        "o": "toista",
        "k": "kymmenentenä",
        "s": "sadantena",
        "t": "tuhannentena",
        "m": "miljoonantena",
        "r": "miljardintena",
        "b": "biljoonantena",
    },
    "JTRA": {
        "!": "ensimmäiseksi",
        '"': "toiseksi",
        "1": "yhdenneksi",
        "2": "kahdenneksi",
        "3": "kolmanneksi",
        "4": "neljänneksi",
        "5": "viidenneksi",
        "6": "kuudenneksi",
        "7": "seitsemänneksi",
        "8": "kahdeksanneksi",
        "9": "yhdeksänneksi",
        "o": "toista",
        "k": "kymmenenneksi",
        "s": "sadanneksi",
        "t": "tuhannenneksi",
        "m": "miljoonanneksi",
        "r": "miljardinneksi",
        "b": "biljoonanneksi",
    },
}
