"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchLogsAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const role_1 = require("./private/role");
/**
 * The action to send data to Amazon CloudWatch Logs
 */
class CloudWatchLogsAction {
    /**
     * @param logGroup The CloudWatch log group to which the action sends data
     * @param props Optional properties to not use default
     */
    constructor(logGroup, props = {}) {
        this.logGroup = logGroup;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_CloudWatchLogsActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.role = props.role;
    }
    bind(rule) {
        var _b;
        const role = (_b = this.role) !== null && _b !== void 0 ? _b : role_1.singletonActionRole(rule);
        this.logGroup.grantWrite(role);
        this.logGroup.grant(role, 'logs:DescribeLogStreams');
        return {
            configuration: {
                cloudwatchLogs: {
                    logGroupName: this.logGroup.logGroupName,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.CloudWatchLogsAction = CloudWatchLogsAction;
_a = JSII_RTTI_SYMBOL_1;
CloudWatchLogsAction[_a] = { fqn: "@aws-cdk/aws-iot-actions.CloudWatchLogsAction", version: "1.158.0" };
//# sourceMappingURL=data:application/json;base64,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