# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/00_plotped.ipynb (unless otherwise specified).

__all__ = ['GraphPedCli', 'GraphPed', 'update_attributes', 'plotped']

# Cell
def GraphPedCli():
    import argparse
    parser = argparse.ArgumentParser(description="Just an example",
                                     formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument("-p", "--ped", help="ped file")
    parser.add_argument("-o", "--output", help="output folder")
    args = parser.parse_args()
    print(args)

def GraphPed(ped,output,fmt,attr):
    pass

# Cell
from graphviz import Digraph
def update_attributes(r):
    attributes={'shape':'polygon','height':'0.3','width':'0.5','regular':'0','style':"filled,setlinewidth(4)",'fontcolor':'black'}
    gender = {"m":"box","1":"box",1:"box","f":"ellipse","2":"ellipse",2:"ellipse",0:"polygon"}
    trait = {1:'white',2:'dimgrey',-9:'aquamarine3'}
    vcf = {True:"filled,setlinewidth(4)",False:"filled"}
    trim = {True:'darkorange',False:'black'}
    attributes['shape'] = gender[r.sex]
    attributes['fillcolor']=trait[r.ad]
    attributes['style']=vcf[r.vcf]
    try:
        attributes['fontcolor'] = trim[r.trim]
    except:
        pass
    return attributes

def plotped(fi,output=False,folder='',format='svg'):
    #nodes
    #create iid nodes
    #create parent nodes
    #edges
    #parent to iid
    #fathid,mothid to parent
    # Create Digraph object
    dot = Digraph()
    # Add nodes
    parents = []
    for i,r in fi.iterrows():
        dot.node(r.iid,shape='box',_attributes=update_attributes(r))
        if r.fathid !='0' and r.mothid !='0':
            parents.append(r.fathid+'x'+r.mothid)
            dot.edge(r.fathid+'x'+r.mothid,r.iid)
        #edge to children
        ch_r = (fi.fathid==r.iid) | (fi.mothid==r.iid)
        if ch_r.any():
            for p in fi[ch_r][['fathid','mothid']].agg('x'.join, axis=1).unique():
                dot.edge(r.iid,p)
    for p in set(parents):
        dot.node(p,shape='diamond',label='',height='.1',width='.1')
    if output:
        dot.render(outfile=folder+'/ADfam_'+str(list(fi.fid)[0])+'.'+format,format=format,overwrite_source=True)
    return dot