import argparse
import sys

import cds_extraction_args as cds_extraction
import gen_coords_args as gen_coords
import junction_peptides_args as junction_peptides
import junction_summary_args as junction_summary
import rpg_output_processing_args as rpg_output_processing
import summary_stats_args as summary_stats
import unique_count_args as unique_count
import replace_underscores_args as replace_underscores

# make a parser in this with help options etc
parser = argparse.ArgumentParser(prog='ProtView',
                                 description="ProtView is a a tool for comparing proteases and their combinations \n"
                                             "in silico, in a proteomic and transcriptomic context")

subparsers = parser.add_subparsers()

# cds_extraction parser
cds_extraction_subparser = subparsers.add_parser("cds_extraction",
                                                 parents=[cds_extraction.parser])
cds_extraction_subparser.set_defaults(func="cds_extraction")

# gen coordinate parser
gen_coords_subparser = subparsers.add_parser("gen_coords",
                                             parents=[gen_coords.parser])
gen_coords_subparser.set_defaults(func="gen_coords")

# junction peptides parser
junction_peptides_subparser = subparsers.add_parser("junction_peptides",
                                                    parents=[junction_peptides.parser])
junction_peptides_subparser.set_defaults(func="junction_peptides")

# junction summary parser
junction_summary_subparser = subparsers.add_parser("junction_summary",
                                                   parents=[junction_summary.parser])
junction_summary_subparser.set_defaults(func="junction_summary")

# rpg_output_processing parser
rpg_output_processing_subparser = subparsers.add_parser("rpg_output_processing",
                                                        parents=[rpg_output_processing.parser])
rpg_output_processing_subparser.set_defaults(func="rpg_output_processing")

# summary stats parser
summary_stats_subparser = subparsers.add_parser("summary_stats",
                                                parents=[summary_stats.parser])
summary_stats_subparser.set_defaults(func="summary_stats")

# unique count parser
unique_count_subparser = subparsers.add_parser("unique_count",
                                               parents=[unique_count.parser])
unique_count_subparser.set_defaults(func="unique_count")

#replace underscores parser
replace_underscores_subparser = subparsers.add_parser("replace_underscores",
                                               parents = [replace_underscores.parser])
replace_underscores_subparser.set_defaults(func="replace_underscores")


def main():
    args = parser.parse_args()

    if len(sys.argv) == 1:
        parser.print_help()
        sys.exit(1)

    if args.func == "cds_extraction":
        cds_extraction.parser = parser
        cds_extraction.main()
    elif args.func == "gen_coords":
        gen_coords.parser = parser
        gen_coords.main()
    elif args.func == "junction_peptides":
        junction_peptides.parser = parser
        junction_peptides.main()
    elif args.func == "junction_summary":
        junction_summary.parser = parser
        junction_summary.main()
    elif args.func == "rpg_output_processing":
        rpg_output_processing.parser = parser
        rpg_output_processing.main()
    elif args.func == "summary_stats":
        summary_stats.parser = parser
        summary_stats.main()
    elif args.func == "unique_count":
        unique_count.parser = parser
        unique_count.main()
    elif args.func == "replace_underscores":
        replace_underscores.parser = parser
        replace_underscores.main()


if __name__ == '__main__':
    main()
