# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['data_to_model',
 'data_to_model.console',
 'data_to_model.data_parsers',
 'data_to_model.generators',
 'data_to_model.models',
 'data_to_model.name_formatters',
 'data_to_model.type_detectors']

package_data = \
{'': ['*']}

install_requires = \
['aiocsv>=1.2.1,<2.0.0',
 'aiofiles>=0.8.0,<0.9.0',
 'anyio>=3.5.0,<4.0.0',
 'click>=8.0.3,<9.0.0']

entry_points = \
{'console_scripts': ['data2model = data_to_model.console.application:main']}

setup_kwargs = {
    'name': 'data2model',
    'version': '0.2.1b0',
    'description': 'Python library and CLI tool for converting data to different Python data classes',
    'long_description': '# data2model\n\n![kdpv](https://github.com/dmitriiweb/data2model/raw/main/imgs/matrix-g69866a888_640.jpg)\n\n![Tests](https://github.com/mCodingLLC/SlapThatLikeButton-TestingStarterProject/actions/workflows/tests.yml/badge.svg)\n[![PyPI version](https://badge.fury.io/py/data2model.svg)](https://badge.fury.io/py/data2model)\n\nPython library and CLI tool for generating different Python data classes from data.\n\nSupported data formats:\n- CSV\n\nSupported data classes:\n- [dataclasses](https://docs.python.org/3.8/library/dataclasses.html)\n\n## Requirements\n\n- Python 3.8+\n\n## Installation\n```shell\npip install data2model\n```\n\n## Usage\n\n### As library\n```python\nimport asyncio\nimport pathlib\n\nfrom data_to_model import ModelGenerator\n\n\nfiles = [\n    {"input": pathlib.Path("example.csv"), "output": pathlib.Path("example.py")},\n]\n\n\nasync def model_generator(input_file: pathlib.Path, output_file: pathlib.Path):\n    mg = ModelGenerator(input_file)\n    model = await mg.get_model()\n    await model.save(output_file)\n\n\nasync def main():\n    tasks = [model_generator(i["input"], i["output"]) for i in files]\n    await asyncio.gather(*tasks)\n\n\nif __name__ == "__main__":\n    asyncio.run(main())\n```\n![output](https://github.com/dmitriiweb/data2model/raw/main/imgs/carbon.png)\n\n\n### As CLI\n#### from single file\n```shell\n$ cat data.csv\ncol1,col2\n1,2\n,2.0\n\n$ data2model file -if data.csv -of data.py\n$ cat data.py\n# This file was generated by data_to_model.\nfrom dataclasses import dataclass\nfrom typing import Any, Dict, Optional, Union\n\n\n@dataclass\nclass Data:\n    col1: Optional[int]\n    col2: Union[float, int]\n\n    @classmethod\n    def from_dict(cls, data: Dict[str, Any]) -> "Data":\n        col1 = data["col1"]\n        col2 = data["col2"]\n        return cls(col1=col1, col2=col2)\n\n    def to_dict(self) -> Dict[str, Any]:\n        return {"col1": self.col1, "col2": self.col2}\n```\n\n#### from directory\n```shell\n\n$ data2model folder -if data -of models\n\n$ ls data\ndata1.csv  data2.csv\n\n$ ls models\ndata1.py  data2.py\n```',
    'author': 'Dmitrii Kurlov',
    'author_email': 'dmitriik@protonmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/dmitriiweb/data2model',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<3.11',
}


setup(**setup_kwargs)
