from abc import ABC, abstractmethod
from typing import List

from ..models.data_class_model import DataClassModel
from .types import ClassData


class BaseGenerator(ABC):
    disclaimer = "# This file was generated by data_to_model."

    def __init__(self, classes: List[ClassData]):
        self.classes = classes
        self.content = [self.disclaimer]

    @abstractmethod
    def generate_file_content(self) -> DataClassModel:
        pass
