# coding: utf-8

"""
    Aspose.PDF Cloud API Reference


   Copyright (c) 2020 Aspose.PDF Cloud
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:
 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.



    OpenAPI spec version: 3.0
    
"""


from pprint import pformat
from six import iteritems
import re


class OptimizeOptions(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'allow_reuse_page_content': 'bool',
        'compress_images': 'bool',
        'image_quality': 'int',
        'link_duplcate_streams': 'bool',
        'remove_unused_objects': 'bool',
        'remove_unused_streams': 'bool',
        'unembed_fonts': 'bool'
    }

    attribute_map = {
        'allow_reuse_page_content': 'AllowReusePageContent',
        'compress_images': 'CompressImages',
        'image_quality': 'ImageQuality',
        'link_duplcate_streams': 'LinkDuplcateStreams',
        'remove_unused_objects': 'RemoveUnusedObjects',
        'remove_unused_streams': 'RemoveUnusedStreams',
        'unembed_fonts': 'UnembedFonts'
    }

    def __init__(self, allow_reuse_page_content=None, compress_images=None, image_quality=None, link_duplcate_streams=None, remove_unused_objects=None, remove_unused_streams=None, unembed_fonts=None):
        """
        OptimizeOptions - a model defined in Swagger
        """

        self._allow_reuse_page_content = None
        self._compress_images = None
        self._image_quality = None
        self._link_duplcate_streams = None
        self._remove_unused_objects = None
        self._remove_unused_streams = None
        self._unembed_fonts = None

        self.allow_reuse_page_content = allow_reuse_page_content
        self.compress_images = compress_images
        self.image_quality = image_quality
        self.link_duplcate_streams = link_duplcate_streams
        self.remove_unused_objects = remove_unused_objects
        self.remove_unused_streams = remove_unused_streams
        self.unembed_fonts = unembed_fonts

    @property
    def allow_reuse_page_content(self):
        """
        Gets the allow_reuse_page_content of this OptimizeOptions.
        If true page contents will be reused when document is optimized for equal pages.

        :return: The allow_reuse_page_content of this OptimizeOptions.
        :rtype: bool
        """
        return self._allow_reuse_page_content

    @allow_reuse_page_content.setter
    def allow_reuse_page_content(self, allow_reuse_page_content):
        """
        Sets the allow_reuse_page_content of this OptimizeOptions.
        If true page contents will be reused when document is optimized for equal pages.

        :param allow_reuse_page_content: The allow_reuse_page_content of this OptimizeOptions.
        :type: bool
        """
        if allow_reuse_page_content is None:
            raise ValueError("Invalid value for `allow_reuse_page_content`, must not be `None`")

        self._allow_reuse_page_content = allow_reuse_page_content

    @property
    def compress_images(self):
        """
        Gets the compress_images of this OptimizeOptions.
        If this flag is set to true images will be compressed in the document. compression level is specfied with ImageQuality property.

        :return: The compress_images of this OptimizeOptions.
        :rtype: bool
        """
        return self._compress_images

    @compress_images.setter
    def compress_images(self, compress_images):
        """
        Sets the compress_images of this OptimizeOptions.
        If this flag is set to true images will be compressed in the document. compression level is specfied with ImageQuality property.

        :param compress_images: The compress_images of this OptimizeOptions.
        :type: bool
        """
        if compress_images is None:
            raise ValueError("Invalid value for `compress_images`, must not be `None`")

        self._compress_images = compress_images

    @property
    def image_quality(self):
        """
        Gets the image_quality of this OptimizeOptions.
        Specifie slevel of image compression when CompressIamges flag is used.

        :return: The image_quality of this OptimizeOptions.
        :rtype: int
        """
        return self._image_quality

    @image_quality.setter
    def image_quality(self, image_quality):
        """
        Sets the image_quality of this OptimizeOptions.
        Specifie slevel of image compression when CompressIamges flag is used.

        :param image_quality: The image_quality of this OptimizeOptions.
        :type: int
        """
        if image_quality is None:
            raise ValueError("Invalid value for `image_quality`, must not be `None`")

        self._image_quality = image_quality

    @property
    def link_duplcate_streams(self):
        """
        Gets the link_duplcate_streams of this OptimizeOptions.
        If this flag is set to true, Resource streams will be analyzed. If duplicate streams are found (i.e. if stream contents is equal), then thes streams will be stored as one object.  This allows to decrease document size in some cases (for example, when same document was concatenedted multiple times).

        :return: The link_duplcate_streams of this OptimizeOptions.
        :rtype: bool
        """
        return self._link_duplcate_streams

    @link_duplcate_streams.setter
    def link_duplcate_streams(self, link_duplcate_streams):
        """
        Sets the link_duplcate_streams of this OptimizeOptions.
        If this flag is set to true, Resource streams will be analyzed. If duplicate streams are found (i.e. if stream contents is equal), then thes streams will be stored as one object.  This allows to decrease document size in some cases (for example, when same document was concatenedted multiple times).

        :param link_duplcate_streams: The link_duplcate_streams of this OptimizeOptions.
        :type: bool
        """
        if link_duplcate_streams is None:
            raise ValueError("Invalid value for `link_duplcate_streams`, must not be `None`")

        self._link_duplcate_streams = link_duplcate_streams

    @property
    def remove_unused_objects(self):
        """
        Gets the remove_unused_objects of this OptimizeOptions.
        If this flag is set to true, all document objects will be checked and unused objects (i.e. objects which does not have any reference) are removed from document.

        :return: The remove_unused_objects of this OptimizeOptions.
        :rtype: bool
        """
        return self._remove_unused_objects

    @remove_unused_objects.setter
    def remove_unused_objects(self, remove_unused_objects):
        """
        Sets the remove_unused_objects of this OptimizeOptions.
        If this flag is set to true, all document objects will be checked and unused objects (i.e. objects which does not have any reference) are removed from document.

        :param remove_unused_objects: The remove_unused_objects of this OptimizeOptions.
        :type: bool
        """
        if remove_unused_objects is None:
            raise ValueError("Invalid value for `remove_unused_objects`, must not be `None`")

        self._remove_unused_objects = remove_unused_objects

    @property
    def remove_unused_streams(self):
        """
        Gets the remove_unused_streams of this OptimizeOptions.
        If this flag set to true, every resource is checked on it's usage. If resource is never used, then resources is removed. This may decrease document size for example when pages were extracted from document. 

        :return: The remove_unused_streams of this OptimizeOptions.
        :rtype: bool
        """
        return self._remove_unused_streams

    @remove_unused_streams.setter
    def remove_unused_streams(self, remove_unused_streams):
        """
        Sets the remove_unused_streams of this OptimizeOptions.
        If this flag set to true, every resource is checked on it's usage. If resource is never used, then resources is removed. This may decrease document size for example when pages were extracted from document. 

        :param remove_unused_streams: The remove_unused_streams of this OptimizeOptions.
        :type: bool
        """
        if remove_unused_streams is None:
            raise ValueError("Invalid value for `remove_unused_streams`, must not be `None`")

        self._remove_unused_streams = remove_unused_streams

    @property
    def unembed_fonts(self):
        """
        Gets the unembed_fonts of this OptimizeOptions.
        Make fonts not embedded if set to true. 

        :return: The unembed_fonts of this OptimizeOptions.
        :rtype: bool
        """
        return self._unembed_fonts

    @unembed_fonts.setter
    def unembed_fonts(self, unembed_fonts):
        """
        Sets the unembed_fonts of this OptimizeOptions.
        Make fonts not embedded if set to true. 

        :param unembed_fonts: The unembed_fonts of this OptimizeOptions.
        :type: bool
        """
        if unembed_fonts is None:
            raise ValueError("Invalid value for `unembed_fonts`, must not be `None`")

        self._unembed_fonts = unembed_fonts

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, OptimizeOptions):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
