import os

class BaseCIAdapter():

    def __init__(self, logger=None):
        self.logger = logger
        self.env_map = {}

    def convert_environment_variables(self):
        for key, value in os.environ.items():
            if key in self.env_map and not self.env_map[key] in os.environ:
                os.environ[self.env_map[key]] = value
                os.environ.pop(key)

    def write_file(self, path, text):
        file_text = """
/*************************************************
 * DO NOT EDIT THIS FILE, see .servicer/ instead *
 * CI Configuration Auto-generated by Servicer   *
 *************************************************/

"""
        file_text += text

        with open(path, "w") as text_file:
            text_file.write(file_text)

        self.logger.log('CI config file generated: %s' % path)
