# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class UserBestPointsItem(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        UserBestPointsItem - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'granularity_type': 'str',
            'points': 'int',
            'date_start_workday': 'date',
            'date_end_workday': 'date',
            'rank': 'int'
        }

        self.attribute_map = {
            'granularity_type': 'granularityType',
            'points': 'points',
            'date_start_workday': 'dateStartWorkday',
            'date_end_workday': 'dateEndWorkday',
            'rank': 'rank'
        }

        self._granularity_type = None
        self._points = None
        self._date_start_workday = None
        self._date_end_workday = None
        self._rank = None

    @property
    def granularity_type(self):
        """
        Gets the granularity_type of this UserBestPointsItem.
        Best points aggregation interval granularity

        :return: The granularity_type of this UserBestPointsItem.
        :rtype: str
        """
        return self._granularity_type

    @granularity_type.setter
    def granularity_type(self, granularity_type):
        """
        Sets the granularity_type of this UserBestPointsItem.
        Best points aggregation interval granularity

        :param granularity_type: The granularity_type of this UserBestPointsItem.
        :type: str
        """
        allowed_values = ["Daily", "Weekly", "Monthly"]
        if granularity_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for granularity_type -> " + granularity_type)
            self._granularity_type = "outdated_sdk_version"
        else:
            self._granularity_type = granularity_type

    @property
    def points(self):
        """
        Gets the points of this UserBestPointsItem.
        Gamification points

        :return: The points of this UserBestPointsItem.
        :rtype: int
        """
        return self._points

    @points.setter
    def points(self, points):
        """
        Sets the points of this UserBestPointsItem.
        Gamification points

        :param points: The points of this UserBestPointsItem.
        :type: int
        """
        

        self._points = points

    @property
    def date_start_workday(self):
        """
        Gets the date_start_workday of this UserBestPointsItem.
        Start workday of the best points aggregation interval. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_start_workday of this UserBestPointsItem.
        :rtype: date
        """
        return self._date_start_workday

    @date_start_workday.setter
    def date_start_workday(self, date_start_workday):
        """
        Sets the date_start_workday of this UserBestPointsItem.
        Start workday of the best points aggregation interval. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_start_workday: The date_start_workday of this UserBestPointsItem.
        :type: date
        """
        

        self._date_start_workday = date_start_workday

    @property
    def date_end_workday(self):
        """
        Gets the date_end_workday of this UserBestPointsItem.
        End workday of the best points aggregation interval. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_end_workday of this UserBestPointsItem.
        :rtype: date
        """
        return self._date_end_workday

    @date_end_workday.setter
    def date_end_workday(self, date_end_workday):
        """
        Sets the date_end_workday of this UserBestPointsItem.
        End workday of the best points aggregation interval. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_end_workday: The date_end_workday of this UserBestPointsItem.
        :type: date
        """
        

        self._date_end_workday = date_end_workday

    @property
    def rank(self):
        """
        Gets the rank of this UserBestPointsItem.
        The rank of this user

        :return: The rank of this UserBestPointsItem.
        :rtype: int
        """
        return self._rank

    @rank.setter
    def rank(self, rank):
        """
        Sets the rank of this UserBestPointsItem.
        The rank of this user

        :param rank: The rank of this UserBestPointsItem.
        :type: int
        """
        

        self._rank = rank

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

