# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class Signature(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Signature - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'enabled': 'bool',
            'canned_response_id': 'str',
            'always_included': 'bool',
            'inclusion_type': 'str'
        }

        self.attribute_map = {
            'enabled': 'enabled',
            'canned_response_id': 'cannedResponseId',
            'always_included': 'alwaysIncluded',
            'inclusion_type': 'inclusionType'
        }

        self._enabled = None
        self._canned_response_id = None
        self._always_included = None
        self._inclusion_type = None

    @property
    def enabled(self):
        """
        Gets the enabled of this Signature.
        A toggle to enable the signature on email send.

        :return: The enabled of this Signature.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this Signature.
        A toggle to enable the signature on email send.

        :param enabled: The enabled of this Signature.
        :type: bool
        """
        

        self._enabled = enabled

    @property
    def canned_response_id(self):
        """
        Gets the canned_response_id of this Signature.
        The identifier referring to an email signature canned response.

        :return: The canned_response_id of this Signature.
        :rtype: str
        """
        return self._canned_response_id

    @canned_response_id.setter
    def canned_response_id(self, canned_response_id):
        """
        Sets the canned_response_id of this Signature.
        The identifier referring to an email signature canned response.

        :param canned_response_id: The canned_response_id of this Signature.
        :type: str
        """
        

        self._canned_response_id = canned_response_id

    @property
    def always_included(self):
        """
        Gets the always_included of this Signature.
        A toggle that defines if a signature is always included or only set on the first email in an email chain.

        :return: The always_included of this Signature.
        :rtype: bool
        """
        return self._always_included

    @always_included.setter
    def always_included(self, always_included):
        """
        Sets the always_included of this Signature.
        A toggle that defines if a signature is always included or only set on the first email in an email chain.

        :param always_included: The always_included of this Signature.
        :type: bool
        """
        

        self._always_included = always_included

    @property
    def inclusion_type(self):
        """
        Gets the inclusion_type of this Signature.
        The configuration to indicate when the signature of a conversation has to be included

        :return: The inclusion_type of this Signature.
        :rtype: str
        """
        return self._inclusion_type

    @inclusion_type.setter
    def inclusion_type(self, inclusion_type):
        """
        Sets the inclusion_type of this Signature.
        The configuration to indicate when the signature of a conversation has to be included

        :param inclusion_type: The inclusion_type of this Signature.
        :type: str
        """
        allowed_values = ["Draft", "Send", "SendOnce"]
        if inclusion_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for inclusion_type -> " + inclusion_type)
            self._inclusion_type = "outdated_sdk_version"
        else:
            self._inclusion_type = inclusion_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

