# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ReportingTurn(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ReportingTurn - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'user_input': 'str',
            'bot_prompts': 'list[str]',
            'session_id': 'str',
            'ask_action': 'ReportingTurnAction',
            'intent': 'ReportingTurnIntent',
            'knowledge': 'ReportingTurnKnowledge',
            'date_created': 'datetime',
            'ask_action_result': 'str',
            'session_end_details': 'SessionEndDetails',
            'conversation': 'AddressableEntityRef'
        }

        self.attribute_map = {
            'user_input': 'userInput',
            'bot_prompts': 'botPrompts',
            'session_id': 'sessionId',
            'ask_action': 'askAction',
            'intent': 'intent',
            'knowledge': 'knowledge',
            'date_created': 'dateCreated',
            'ask_action_result': 'askActionResult',
            'session_end_details': 'sessionEndDetails',
            'conversation': 'conversation'
        }

        self._user_input = None
        self._bot_prompts = None
        self._session_id = None
        self._ask_action = None
        self._intent = None
        self._knowledge = None
        self._date_created = None
        self._ask_action_result = None
        self._session_end_details = None
        self._conversation = None

    @property
    def user_input(self):
        """
        Gets the user_input of this ReportingTurn.
        The chosen user input associated with this reporting turn.

        :return: The user_input of this ReportingTurn.
        :rtype: str
        """
        return self._user_input

    @user_input.setter
    def user_input(self, user_input):
        """
        Sets the user_input of this ReportingTurn.
        The chosen user input associated with this reporting turn.

        :param user_input: The user_input of this ReportingTurn.
        :type: str
        """
        

        self._user_input = user_input

    @property
    def bot_prompts(self):
        """
        Gets the bot_prompts of this ReportingTurn.
        The bot prompts associated with this reporting turn.

        :return: The bot_prompts of this ReportingTurn.
        :rtype: list[str]
        """
        return self._bot_prompts

    @bot_prompts.setter
    def bot_prompts(self, bot_prompts):
        """
        Sets the bot_prompts of this ReportingTurn.
        The bot prompts associated with this reporting turn.

        :param bot_prompts: The bot_prompts of this ReportingTurn.
        :type: list[str]
        """
        

        self._bot_prompts = bot_prompts

    @property
    def session_id(self):
        """
        Gets the session_id of this ReportingTurn.
        The bot session ID that this reporting turn is grouped under.

        :return: The session_id of this ReportingTurn.
        :rtype: str
        """
        return self._session_id

    @session_id.setter
    def session_id(self, session_id):
        """
        Sets the session_id of this ReportingTurn.
        The bot session ID that this reporting turn is grouped under.

        :param session_id: The session_id of this ReportingTurn.
        :type: str
        """
        

        self._session_id = session_id

    @property
    def ask_action(self):
        """
        Gets the ask_action of this ReportingTurn.
        The bot flow 'ask' action associated with this reporting turn (e.g. AskForIntent).

        :return: The ask_action of this ReportingTurn.
        :rtype: ReportingTurnAction
        """
        return self._ask_action

    @ask_action.setter
    def ask_action(self, ask_action):
        """
        Sets the ask_action of this ReportingTurn.
        The bot flow 'ask' action associated with this reporting turn (e.g. AskForIntent).

        :param ask_action: The ask_action of this ReportingTurn.
        :type: ReportingTurnAction
        """
        

        self._ask_action = ask_action

    @property
    def intent(self):
        """
        Gets the intent of this ReportingTurn.
        The intent and associated slots detected during this reporting turn.

        :return: The intent of this ReportingTurn.
        :rtype: ReportingTurnIntent
        """
        return self._intent

    @intent.setter
    def intent(self, intent):
        """
        Sets the intent of this ReportingTurn.
        The intent and associated slots detected during this reporting turn.

        :param intent: The intent of this ReportingTurn.
        :type: ReportingTurnIntent
        """
        

        self._intent = intent

    @property
    def knowledge(self):
        """
        Gets the knowledge of this ReportingTurn.
        The knowledge data captured during this reporting turn.

        :return: The knowledge of this ReportingTurn.
        :rtype: ReportingTurnKnowledge
        """
        return self._knowledge

    @knowledge.setter
    def knowledge(self, knowledge):
        """
        Sets the knowledge of this ReportingTurn.
        The knowledge data captured during this reporting turn.

        :param knowledge: The knowledge of this ReportingTurn.
        :type: ReportingTurnKnowledge
        """
        

        self._knowledge = knowledge

    @property
    def date_created(self):
        """
        Gets the date_created of this ReportingTurn.
        Timestamp indicating when the original turn was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this ReportingTurn.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """
        Sets the date_created of this ReportingTurn.
        Timestamp indicating when the original turn was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this ReportingTurn.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def ask_action_result(self):
        """
        Gets the ask_action_result of this ReportingTurn.
        Result of the bot flow 'ask' action.

        :return: The ask_action_result of this ReportingTurn.
        :rtype: str
        """
        return self._ask_action_result

    @ask_action_result.setter
    def ask_action_result(self, ask_action_result):
        """
        Sets the ask_action_result of this ReportingTurn.
        Result of the bot flow 'ask' action.

        :param ask_action_result: The ask_action_result of this ReportingTurn.
        :type: str
        """
        allowed_values = ["SuccessCollection", "SuccessConfirmationYes", "SuccessConfirmationNo", "NoMatchCollection", "NoMatchConfirmation", "AgentRequestedByUser", "ConfirmationRequired", "Error", "ExpressionError", "NoInputCollection", "NoInputConfirmation", "DisambiguationRequired", "SuccessDisambiguation", "SuccessDisambiguationNone", "NoMatchDisambiguation", "NoInputDisambiguation"]
        if ask_action_result.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for ask_action_result -> " + ask_action_result)
            self._ask_action_result = "outdated_sdk_version"
        else:
            self._ask_action_result = ask_action_result

    @property
    def session_end_details(self):
        """
        Gets the session_end_details of this ReportingTurn.
        The details related to end of bot flow session.

        :return: The session_end_details of this ReportingTurn.
        :rtype: SessionEndDetails
        """
        return self._session_end_details

    @session_end_details.setter
    def session_end_details(self, session_end_details):
        """
        Sets the session_end_details of this ReportingTurn.
        The details related to end of bot flow session.

        :param session_end_details: The session_end_details of this ReportingTurn.
        :type: SessionEndDetails
        """
        

        self._session_end_details = session_end_details

    @property
    def conversation(self):
        """
        Gets the conversation of this ReportingTurn.
        The conversation details, across potentially multiple Bot Flow sessions.

        :return: The conversation of this ReportingTurn.
        :rtype: AddressableEntityRef
        """
        return self._conversation

    @conversation.setter
    def conversation(self, conversation):
        """
        Sets the conversation of this ReportingTurn.
        The conversation details, across potentially multiple Bot Flow sessions.

        :param conversation: The conversation of this ReportingTurn.
        :type: AddressableEntityRef
        """
        

        self._conversation = conversation

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

