# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ProgramTranscriptionEngines(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ProgramTranscriptionEngines - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'program': 'BaseProgramEntity',
            'transcription_engines': 'list[TranscriptionEngines]',
            'modified_by': 'AddressableEntityRef',
            'date_modified': 'datetime'
        }

        self.attribute_map = {
            'program': 'program',
            'transcription_engines': 'transcriptionEngines',
            'modified_by': 'modifiedBy',
            'date_modified': 'dateModified'
        }

        self._program = None
        self._transcription_engines = None
        self._modified_by = None
        self._date_modified = None

    @property
    def program(self):
        """
        Gets the program of this ProgramTranscriptionEngines.
        The ID of the program

        :return: The program of this ProgramTranscriptionEngines.
        :rtype: BaseProgramEntity
        """
        return self._program

    @program.setter
    def program(self, program):
        """
        Sets the program of this ProgramTranscriptionEngines.
        The ID of the program

        :param program: The program of this ProgramTranscriptionEngines.
        :type: BaseProgramEntity
        """
        

        self._program = program

    @property
    def transcription_engines(self):
        """
        Gets the transcription_engines of this ProgramTranscriptionEngines.
        The program transcription engine settings

        :return: The transcription_engines of this ProgramTranscriptionEngines.
        :rtype: list[TranscriptionEngines]
        """
        return self._transcription_engines

    @transcription_engines.setter
    def transcription_engines(self, transcription_engines):
        """
        Sets the transcription_engines of this ProgramTranscriptionEngines.
        The program transcription engine settings

        :param transcription_engines: The transcription_engines of this ProgramTranscriptionEngines.
        :type: list[TranscriptionEngines]
        """
        

        self._transcription_engines = transcription_engines

    @property
    def modified_by(self):
        """
        Gets the modified_by of this ProgramTranscriptionEngines.
        The user last modified the record

        :return: The modified_by of this ProgramTranscriptionEngines.
        :rtype: AddressableEntityRef
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by):
        """
        Sets the modified_by of this ProgramTranscriptionEngines.
        The user last modified the record

        :param modified_by: The modified_by of this ProgramTranscriptionEngines.
        :type: AddressableEntityRef
        """
        

        self._modified_by = modified_by

    @property
    def date_modified(self):
        """
        Gets the date_modified of this ProgramTranscriptionEngines.
        The last modified date of the record. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this ProgramTranscriptionEngines.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this ProgramTranscriptionEngines.
        The last modified date of the record. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this ProgramTranscriptionEngines.
        :type: datetime
        """
        

        self._date_modified = date_modified

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

