# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class InfrastructureascodeJob(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        InfrastructureascodeJob - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'dry_run': 'bool',
            'date_submitted': 'datetime',
            'submitted_by': 'UserReference',
            'status': 'str',
            'error_info': 'ErrorInfo',
            'results': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'dry_run': 'dryRun',
            'date_submitted': 'dateSubmitted',
            'submitted_by': 'submittedBy',
            'status': 'status',
            'error_info': 'errorInfo',
            'results': 'results',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._dry_run = None
        self._date_submitted = None
        self._submitted_by = None
        self._status = None
        self._error_info = None
        self._results = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this InfrastructureascodeJob.
        The globally unique identifier for the object.

        :return: The id of this InfrastructureascodeJob.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this InfrastructureascodeJob.
        The globally unique identifier for the object.

        :param id: The id of this InfrastructureascodeJob.
        :type: str
        """
        

        self._id = id

    @property
    def dry_run(self):
        """
        Gets the dry_run of this InfrastructureascodeJob.
        dryRun

        :return: The dry_run of this InfrastructureascodeJob.
        :rtype: bool
        """
        return self._dry_run

    @dry_run.setter
    def dry_run(self, dry_run):
        """
        Sets the dry_run of this InfrastructureascodeJob.
        dryRun

        :param dry_run: The dry_run of this InfrastructureascodeJob.
        :type: bool
        """
        

        self._dry_run = dry_run

    @property
    def date_submitted(self):
        """
        Gets the date_submitted of this InfrastructureascodeJob.
        dateSubmitted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_submitted of this InfrastructureascodeJob.
        :rtype: datetime
        """
        return self._date_submitted

    @date_submitted.setter
    def date_submitted(self, date_submitted):
        """
        Sets the date_submitted of this InfrastructureascodeJob.
        dateSubmitted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_submitted: The date_submitted of this InfrastructureascodeJob.
        :type: datetime
        """
        

        self._date_submitted = date_submitted

    @property
    def submitted_by(self):
        """
        Gets the submitted_by of this InfrastructureascodeJob.
        submittedBy

        :return: The submitted_by of this InfrastructureascodeJob.
        :rtype: UserReference
        """
        return self._submitted_by

    @submitted_by.setter
    def submitted_by(self, submitted_by):
        """
        Sets the submitted_by of this InfrastructureascodeJob.
        submittedBy

        :param submitted_by: The submitted_by of this InfrastructureascodeJob.
        :type: UserReference
        """
        

        self._submitted_by = submitted_by

    @property
    def status(self):
        """
        Gets the status of this InfrastructureascodeJob.
        status

        :return: The status of this InfrastructureascodeJob.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this InfrastructureascodeJob.
        status

        :param status: The status of this InfrastructureascodeJob.
        :type: str
        """
        allowed_values = ["Created", "Queued", "Running", "Complete", "Failed", "Incomplete"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def error_info(self):
        """
        Gets the error_info of this InfrastructureascodeJob.
        errorInfo

        :return: The error_info of this InfrastructureascodeJob.
        :rtype: ErrorInfo
        """
        return self._error_info

    @error_info.setter
    def error_info(self, error_info):
        """
        Sets the error_info of this InfrastructureascodeJob.
        errorInfo

        :param error_info: The error_info of this InfrastructureascodeJob.
        :type: ErrorInfo
        """
        

        self._error_info = error_info

    @property
    def results(self):
        """
        Gets the results of this InfrastructureascodeJob.
        results

        :return: The results of this InfrastructureascodeJob.
        :rtype: str
        """
        return self._results

    @results.setter
    def results(self, results):
        """
        Sets the results of this InfrastructureascodeJob.
        results

        :param results: The results of this InfrastructureascodeJob.
        :type: str
        """
        

        self._results = results

    @property
    def self_uri(self):
        """
        Gets the self_uri of this InfrastructureascodeJob.
        The URI for this object

        :return: The self_uri of this InfrastructureascodeJob.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this InfrastructureascodeJob.
        The URI for this object

        :param self_uri: The self_uri of this InfrastructureascodeJob.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

