# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ExternalMetricDataWriteResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ExternalMetricDataWriteResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'processed_entities': 'list[ExternalMetricDataProcessedItem]',
            'unprocessed_entities': 'list[ExternalMetricDataUnprocessedItem]'
        }

        self.attribute_map = {
            'processed_entities': 'processedEntities',
            'unprocessed_entities': 'unprocessedEntities'
        }

        self._processed_entities = None
        self._unprocessed_entities = None

    @property
    def processed_entities(self):
        """
        Gets the processed_entities of this ExternalMetricDataWriteResponse.
        The list of processed entities

        :return: The processed_entities of this ExternalMetricDataWriteResponse.
        :rtype: list[ExternalMetricDataProcessedItem]
        """
        return self._processed_entities

    @processed_entities.setter
    def processed_entities(self, processed_entities):
        """
        Sets the processed_entities of this ExternalMetricDataWriteResponse.
        The list of processed entities

        :param processed_entities: The processed_entities of this ExternalMetricDataWriteResponse.
        :type: list[ExternalMetricDataProcessedItem]
        """
        

        self._processed_entities = processed_entities

    @property
    def unprocessed_entities(self):
        """
        Gets the unprocessed_entities of this ExternalMetricDataWriteResponse.
        The list of unprocessed entities

        :return: The unprocessed_entities of this ExternalMetricDataWriteResponse.
        :rtype: list[ExternalMetricDataUnprocessedItem]
        """
        return self._unprocessed_entities

    @unprocessed_entities.setter
    def unprocessed_entities(self, unprocessed_entities):
        """
        Sets the unprocessed_entities of this ExternalMetricDataWriteResponse.
        The list of unprocessed entities

        :param unprocessed_entities: The unprocessed_entities of this ExternalMetricDataWriteResponse.
        :type: list[ExternalMetricDataUnprocessedItem]
        """
        

        self._unprocessed_entities = unprocessed_entities

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

