# coding: utf-8

"""
OrganizationAuthorizationApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class OrganizationAuthorizationApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_orgauthorization_trustee(self, trustee_org_id, **kwargs):
        """
        Delete Org Trust
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_orgauthorization_trustee(trustee_org_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustee_org_id: Trustee Organization Id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustee_org_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_orgauthorization_trustee" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustee_org_id' is set
        if ('trustee_org_id' not in params) or (params['trustee_org_id'] is None):
            raise ValueError("Missing the required parameter `trustee_org_id` when calling `delete_orgauthorization_trustee`")


        resource_path = '/api/v2/orgauthorization/trustees/{trusteeOrgId}'.replace('{format}', 'json')
        path_params = {}
        if 'trustee_org_id' in params:
            path_params['trusteeOrgId'] = params['trustee_org_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_orgauthorization_trustee_cloneduser(self, trustee_org_id, trustee_user_id, **kwargs):
        """
        Deletes cloned user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_orgauthorization_trustee_cloneduser(trustee_org_id, trustee_user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustee_org_id: Trustee Organization Id (required)
        :param str trustee_user_id: Id of the cloned user to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustee_org_id', 'trustee_user_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_orgauthorization_trustee_cloneduser" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustee_org_id' is set
        if ('trustee_org_id' not in params) or (params['trustee_org_id'] is None):
            raise ValueError("Missing the required parameter `trustee_org_id` when calling `delete_orgauthorization_trustee_cloneduser`")
        # verify the required parameter 'trustee_user_id' is set
        if ('trustee_user_id' not in params) or (params['trustee_user_id'] is None):
            raise ValueError("Missing the required parameter `trustee_user_id` when calling `delete_orgauthorization_trustee_cloneduser`")


        resource_path = '/api/v2/orgauthorization/trustees/{trusteeOrgId}/clonedusers/{trusteeUserId}'.replace('{format}', 'json')
        path_params = {}
        if 'trustee_org_id' in params:
            path_params['trusteeOrgId'] = params['trustee_org_id']
        if 'trustee_user_id' in params:
            path_params['trusteeUserId'] = params['trustee_user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_orgauthorization_trustee_group(self, trustee_org_id, trustee_group_id, **kwargs):
        """
        Delete Trustee Group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_orgauthorization_trustee_group(trustee_org_id, trustee_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustee_org_id: Trustee Organization Id (required)
        :param str trustee_group_id: Trustee Group Id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustee_org_id', 'trustee_group_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_orgauthorization_trustee_group" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustee_org_id' is set
        if ('trustee_org_id' not in params) or (params['trustee_org_id'] is None):
            raise ValueError("Missing the required parameter `trustee_org_id` when calling `delete_orgauthorization_trustee_group`")
        # verify the required parameter 'trustee_group_id' is set
        if ('trustee_group_id' not in params) or (params['trustee_group_id'] is None):
            raise ValueError("Missing the required parameter `trustee_group_id` when calling `delete_orgauthorization_trustee_group`")


        resource_path = '/api/v2/orgauthorization/trustees/{trusteeOrgId}/groups/{trusteeGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'trustee_org_id' in params:
            path_params['trusteeOrgId'] = params['trustee_org_id']
        if 'trustee_group_id' in params:
            path_params['trusteeGroupId'] = params['trustee_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_orgauthorization_trustee_group_roles(self, trustee_org_id, trustee_group_id, **kwargs):
        """
        Delete Trustee Group Roles
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_orgauthorization_trustee_group_roles(trustee_org_id, trustee_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustee_org_id: Trustee Organization Id (required)
        :param str trustee_group_id: Trustee Group Id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustee_org_id', 'trustee_group_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_orgauthorization_trustee_group_roles" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustee_org_id' is set
        if ('trustee_org_id' not in params) or (params['trustee_org_id'] is None):
            raise ValueError("Missing the required parameter `trustee_org_id` when calling `delete_orgauthorization_trustee_group_roles`")
        # verify the required parameter 'trustee_group_id' is set
        if ('trustee_group_id' not in params) or (params['trustee_group_id'] is None):
            raise ValueError("Missing the required parameter `trustee_group_id` when calling `delete_orgauthorization_trustee_group_roles`")


        resource_path = '/api/v2/orgauthorization/trustees/{trusteeOrgId}/groups/{trusteeGroupId}/roles'.replace('{format}', 'json')
        path_params = {}
        if 'trustee_org_id' in params:
            path_params['trusteeOrgId'] = params['trustee_org_id']
        if 'trustee_group_id' in params:
            path_params['trusteeGroupId'] = params['trustee_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_orgauthorization_trustee_user(self, trustee_org_id, trustee_user_id, **kwargs):
        """
        Delete Trustee User
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_orgauthorization_trustee_user(trustee_org_id, trustee_user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustee_org_id: Trustee Organization Id (required)
        :param str trustee_user_id: Trustee User Id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustee_org_id', 'trustee_user_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_orgauthorization_trustee_user" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustee_org_id' is set
        if ('trustee_org_id' not in params) or (params['trustee_org_id'] is None):
            raise ValueError("Missing the required parameter `trustee_org_id` when calling `delete_orgauthorization_trustee_user`")
        # verify the required parameter 'trustee_user_id' is set
        if ('trustee_user_id' not in params) or (params['trustee_user_id'] is None):
            raise ValueError("Missing the required parameter `trustee_user_id` when calling `delete_orgauthorization_trustee_user`")


        resource_path = '/api/v2/orgauthorization/trustees/{trusteeOrgId}/users/{trusteeUserId}'.replace('{format}', 'json')
        path_params = {}
        if 'trustee_org_id' in params:
            path_params['trusteeOrgId'] = params['trustee_org_id']
        if 'trustee_user_id' in params:
            path_params['trusteeUserId'] = params['trustee_user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_orgauthorization_trustee_user_roles(self, trustee_org_id, trustee_user_id, **kwargs):
        """
        Delete Trustee User Roles
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_orgauthorization_trustee_user_roles(trustee_org_id, trustee_user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustee_org_id: Trustee Organization Id (required)
        :param str trustee_user_id: Trustee User Id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustee_org_id', 'trustee_user_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_orgauthorization_trustee_user_roles" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustee_org_id' is set
        if ('trustee_org_id' not in params) or (params['trustee_org_id'] is None):
            raise ValueError("Missing the required parameter `trustee_org_id` when calling `delete_orgauthorization_trustee_user_roles`")
        # verify the required parameter 'trustee_user_id' is set
        if ('trustee_user_id' not in params) or (params['trustee_user_id'] is None):
            raise ValueError("Missing the required parameter `trustee_user_id` when calling `delete_orgauthorization_trustee_user_roles`")


        resource_path = '/api/v2/orgauthorization/trustees/{trusteeOrgId}/users/{trusteeUserId}/roles'.replace('{format}', 'json')
        path_params = {}
        if 'trustee_org_id' in params:
            path_params['trusteeOrgId'] = params['trustee_org_id']
        if 'trustee_user_id' in params:
            path_params['trusteeUserId'] = params['trustee_user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_orgauthorization_trustor(self, trustor_org_id, **kwargs):
        """
        Delete Org Trust
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_orgauthorization_trustor(trustor_org_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustor_org_id: Trustor Organization Id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustor_org_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_orgauthorization_trustor" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustor_org_id' is set
        if ('trustor_org_id' not in params) or (params['trustor_org_id'] is None):
            raise ValueError("Missing the required parameter `trustor_org_id` when calling `delete_orgauthorization_trustor`")


        resource_path = '/api/v2/orgauthorization/trustors/{trustorOrgId}'.replace('{format}', 'json')
        path_params = {}
        if 'trustor_org_id' in params:
            path_params['trustorOrgId'] = params['trustor_org_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_orgauthorization_trustor_cloneduser(self, trustor_org_id, trustee_user_id, **kwargs):
        """
        Delete Cloned User
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_orgauthorization_trustor_cloneduser(trustor_org_id, trustee_user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustor_org_id: Trustor Organization Id (required)
        :param str trustee_user_id: Trustee User Id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustor_org_id', 'trustee_user_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_orgauthorization_trustor_cloneduser" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustor_org_id' is set
        if ('trustor_org_id' not in params) or (params['trustor_org_id'] is None):
            raise ValueError("Missing the required parameter `trustor_org_id` when calling `delete_orgauthorization_trustor_cloneduser`")
        # verify the required parameter 'trustee_user_id' is set
        if ('trustee_user_id' not in params) or (params['trustee_user_id'] is None):
            raise ValueError("Missing the required parameter `trustee_user_id` when calling `delete_orgauthorization_trustor_cloneduser`")


        resource_path = '/api/v2/orgauthorization/trustors/{trustorOrgId}/clonedusers/{trusteeUserId}'.replace('{format}', 'json')
        path_params = {}
        if 'trustor_org_id' in params:
            path_params['trustorOrgId'] = params['trustor_org_id']
        if 'trustee_user_id' in params:
            path_params['trusteeUserId'] = params['trustee_user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_orgauthorization_trustor_group(self, trustor_org_id, trustor_group_id, **kwargs):
        """
        Delete Trustee Group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_orgauthorization_trustor_group(trustor_org_id, trustor_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustor_org_id: Trustor Organization Id (required)
        :param str trustor_group_id: Trustor Group Id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustor_org_id', 'trustor_group_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_orgauthorization_trustor_group" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustor_org_id' is set
        if ('trustor_org_id' not in params) or (params['trustor_org_id'] is None):
            raise ValueError("Missing the required parameter `trustor_org_id` when calling `delete_orgauthorization_trustor_group`")
        # verify the required parameter 'trustor_group_id' is set
        if ('trustor_group_id' not in params) or (params['trustor_group_id'] is None):
            raise ValueError("Missing the required parameter `trustor_group_id` when calling `delete_orgauthorization_trustor_group`")


        resource_path = '/api/v2/orgauthorization/trustors/{trustorOrgId}/groups/{trustorGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'trustor_org_id' in params:
            path_params['trustorOrgId'] = params['trustor_org_id']
        if 'trustor_group_id' in params:
            path_params['trustorGroupId'] = params['trustor_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_orgauthorization_trustor_user(self, trustor_org_id, trustee_user_id, **kwargs):
        """
        Delete Trustee User
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_orgauthorization_trustor_user(trustor_org_id, trustee_user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustor_org_id: Trustor Organization Id (required)
        :param str trustee_user_id: Trustee User Id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustor_org_id', 'trustee_user_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_orgauthorization_trustor_user" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustor_org_id' is set
        if ('trustor_org_id' not in params) or (params['trustor_org_id'] is None):
            raise ValueError("Missing the required parameter `trustor_org_id` when calling `delete_orgauthorization_trustor_user`")
        # verify the required parameter 'trustee_user_id' is set
        if ('trustee_user_id' not in params) or (params['trustee_user_id'] is None):
            raise ValueError("Missing the required parameter `trustee_user_id` when calling `delete_orgauthorization_trustor_user`")


        resource_path = '/api/v2/orgauthorization/trustors/{trustorOrgId}/users/{trusteeUserId}'.replace('{format}', 'json')
        path_params = {}
        if 'trustor_org_id' in params:
            path_params['trustorOrgId'] = params['trustor_org_id']
        if 'trustee_user_id' in params:
            path_params['trusteeUserId'] = params['trustee_user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_orgauthorization_pairing(self, pairing_id, **kwargs):
        """
        Get Pairing Info
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_orgauthorization_pairing(pairing_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pairing_id: Pairing Id (required)
        :return: TrustRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pairing_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orgauthorization_pairing" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'pairing_id' is set
        if ('pairing_id' not in params) or (params['pairing_id'] is None):
            raise ValueError("Missing the required parameter `pairing_id` when calling `get_orgauthorization_pairing`")


        resource_path = '/api/v2/orgauthorization/pairings/{pairingId}'.replace('{format}', 'json')
        path_params = {}
        if 'pairing_id' in params:
            path_params['pairingId'] = params['pairing_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrustRequest',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_orgauthorization_trustee(self, trustee_org_id, **kwargs):
        """
        Get Org Trust
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_orgauthorization_trustee(trustee_org_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustee_org_id: Trustee Organization Id (required)
        :return: Trustee
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustee_org_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orgauthorization_trustee" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustee_org_id' is set
        if ('trustee_org_id' not in params) or (params['trustee_org_id'] is None):
            raise ValueError("Missing the required parameter `trustee_org_id` when calling `get_orgauthorization_trustee`")


        resource_path = '/api/v2/orgauthorization/trustees/{trusteeOrgId}'.replace('{format}', 'json')
        path_params = {}
        if 'trustee_org_id' in params:
            path_params['trusteeOrgId'] = params['trustee_org_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Trustee',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_orgauthorization_trustee_clonedusers(self, trustee_org_id, **kwargs):
        """
        The list of cloned users from the trustee organization (i.e. users with a native user record).
        There can be no more than 5 cloned users per organization, so results are represented as simple list and not paged

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_orgauthorization_trustee_clonedusers(trustee_org_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustee_org_id: Trustee Organization Id (required)
        :return: ClonedUserEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustee_org_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orgauthorization_trustee_clonedusers" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustee_org_id' is set
        if ('trustee_org_id' not in params) or (params['trustee_org_id'] is None):
            raise ValueError("Missing the required parameter `trustee_org_id` when calling `get_orgauthorization_trustee_clonedusers`")


        resource_path = '/api/v2/orgauthorization/trustees/{trusteeOrgId}/clonedusers'.replace('{format}', 'json')
        path_params = {}
        if 'trustee_org_id' in params:
            path_params['trusteeOrgId'] = params['trustee_org_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ClonedUserEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_orgauthorization_trustee_group(self, trustee_org_id, trustee_group_id, **kwargs):
        """
        Get Trustee Group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_orgauthorization_trustee_group(trustee_org_id, trustee_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustee_org_id: Trustee Organization Id (required)
        :param str trustee_group_id: Trustee Group Id (required)
        :return: TrustGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustee_org_id', 'trustee_group_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orgauthorization_trustee_group" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustee_org_id' is set
        if ('trustee_org_id' not in params) or (params['trustee_org_id'] is None):
            raise ValueError("Missing the required parameter `trustee_org_id` when calling `get_orgauthorization_trustee_group`")
        # verify the required parameter 'trustee_group_id' is set
        if ('trustee_group_id' not in params) or (params['trustee_group_id'] is None):
            raise ValueError("Missing the required parameter `trustee_group_id` when calling `get_orgauthorization_trustee_group`")


        resource_path = '/api/v2/orgauthorization/trustees/{trusteeOrgId}/groups/{trusteeGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'trustee_org_id' in params:
            path_params['trusteeOrgId'] = params['trustee_org_id']
        if 'trustee_group_id' in params:
            path_params['trusteeGroupId'] = params['trustee_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrustGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_orgauthorization_trustee_group_roles(self, trustee_org_id, trustee_group_id, **kwargs):
        """
        Get Trustee Group Roles
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_orgauthorization_trustee_group_roles(trustee_org_id, trustee_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustee_org_id: Trustee Organization Id (required)
        :param str trustee_group_id: Trustee Group Id (required)
        :return: UserAuthorization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustee_org_id', 'trustee_group_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orgauthorization_trustee_group_roles" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustee_org_id' is set
        if ('trustee_org_id' not in params) or (params['trustee_org_id'] is None):
            raise ValueError("Missing the required parameter `trustee_org_id` when calling `get_orgauthorization_trustee_group_roles`")
        # verify the required parameter 'trustee_group_id' is set
        if ('trustee_group_id' not in params) or (params['trustee_group_id'] is None):
            raise ValueError("Missing the required parameter `trustee_group_id` when calling `get_orgauthorization_trustee_group_roles`")


        resource_path = '/api/v2/orgauthorization/trustees/{trusteeOrgId}/groups/{trusteeGroupId}/roles'.replace('{format}', 'json')
        path_params = {}
        if 'trustee_org_id' in params:
            path_params['trusteeOrgId'] = params['trustee_org_id']
        if 'trustee_group_id' in params:
            path_params['trusteeGroupId'] = params['trustee_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserAuthorization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_orgauthorization_trustee_groups(self, trustee_org_id, **kwargs):
        """
        The list of trustee groups for this organization (i.e. groups granted access to this organization).
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_orgauthorization_trustee_groups(trustee_org_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustee_org_id: Trustee Organization Id (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: TrustGroupEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustee_org_id', 'page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orgauthorization_trustee_groups" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustee_org_id' is set
        if ('trustee_org_id' not in params) or (params['trustee_org_id'] is None):
            raise ValueError("Missing the required parameter `trustee_org_id` when calling `get_orgauthorization_trustee_groups`")


        resource_path = '/api/v2/orgauthorization/trustees/{trusteeOrgId}/groups'.replace('{format}', 'json')
        path_params = {}
        if 'trustee_org_id' in params:
            path_params['trusteeOrgId'] = params['trustee_org_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrustGroupEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_orgauthorization_trustee_user(self, trustee_org_id, trustee_user_id, **kwargs):
        """
        Get Trustee User
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_orgauthorization_trustee_user(trustee_org_id, trustee_user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustee_org_id: Trustee Organization Id (required)
        :param str trustee_user_id: Trustee User Id (required)
        :return: TrustUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustee_org_id', 'trustee_user_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orgauthorization_trustee_user" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustee_org_id' is set
        if ('trustee_org_id' not in params) or (params['trustee_org_id'] is None):
            raise ValueError("Missing the required parameter `trustee_org_id` when calling `get_orgauthorization_trustee_user`")
        # verify the required parameter 'trustee_user_id' is set
        if ('trustee_user_id' not in params) or (params['trustee_user_id'] is None):
            raise ValueError("Missing the required parameter `trustee_user_id` when calling `get_orgauthorization_trustee_user`")


        resource_path = '/api/v2/orgauthorization/trustees/{trusteeOrgId}/users/{trusteeUserId}'.replace('{format}', 'json')
        path_params = {}
        if 'trustee_org_id' in params:
            path_params['trusteeOrgId'] = params['trustee_org_id']
        if 'trustee_user_id' in params:
            path_params['trusteeUserId'] = params['trustee_user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrustUser',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_orgauthorization_trustee_user_roles(self, trustee_org_id, trustee_user_id, **kwargs):
        """
        Get Trustee User Roles
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_orgauthorization_trustee_user_roles(trustee_org_id, trustee_user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustee_org_id: Trustee Organization Id (required)
        :param str trustee_user_id: Trustee User Id (required)
        :return: UserAuthorization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustee_org_id', 'trustee_user_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orgauthorization_trustee_user_roles" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustee_org_id' is set
        if ('trustee_org_id' not in params) or (params['trustee_org_id'] is None):
            raise ValueError("Missing the required parameter `trustee_org_id` when calling `get_orgauthorization_trustee_user_roles`")
        # verify the required parameter 'trustee_user_id' is set
        if ('trustee_user_id' not in params) or (params['trustee_user_id'] is None):
            raise ValueError("Missing the required parameter `trustee_user_id` when calling `get_orgauthorization_trustee_user_roles`")


        resource_path = '/api/v2/orgauthorization/trustees/{trusteeOrgId}/users/{trusteeUserId}/roles'.replace('{format}', 'json')
        path_params = {}
        if 'trustee_org_id' in params:
            path_params['trusteeOrgId'] = params['trustee_org_id']
        if 'trustee_user_id' in params:
            path_params['trusteeUserId'] = params['trustee_user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserAuthorization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_orgauthorization_trustee_users(self, trustee_org_id, **kwargs):
        """
        The list of trustee users for this organization (i.e. users granted access to this organization).
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_orgauthorization_trustee_users(trustee_org_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustee_org_id: Trustee Organization Id (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: TrustUserEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustee_org_id', 'page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orgauthorization_trustee_users" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustee_org_id' is set
        if ('trustee_org_id' not in params) or (params['trustee_org_id'] is None):
            raise ValueError("Missing the required parameter `trustee_org_id` when calling `get_orgauthorization_trustee_users`")


        resource_path = '/api/v2/orgauthorization/trustees/{trusteeOrgId}/users'.replace('{format}', 'json')
        path_params = {}
        if 'trustee_org_id' in params:
            path_params['trusteeOrgId'] = params['trustee_org_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrustUserEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_orgauthorization_trustees(self, **kwargs):
        """
        The list of trustees for this organization (i.e. organizations granted access to this organization).
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_orgauthorization_trustees(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: TrustEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orgauthorization_trustees" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/orgauthorization/trustees'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrustEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_orgauthorization_trustees_default(self, **kwargs):
        """
        Get organization authorization trust with Customer Care, if one exists.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_orgauthorization_trustees_default(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: Trustee
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orgauthorization_trustees_default" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/orgauthorization/trustees/default'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Trustee',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_orgauthorization_trustor(self, trustor_org_id, **kwargs):
        """
        Get Org Trust
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_orgauthorization_trustor(trustor_org_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustor_org_id: Trustor Organization Id (required)
        :return: Trustor
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustor_org_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orgauthorization_trustor" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustor_org_id' is set
        if ('trustor_org_id' not in params) or (params['trustor_org_id'] is None):
            raise ValueError("Missing the required parameter `trustor_org_id` when calling `get_orgauthorization_trustor`")


        resource_path = '/api/v2/orgauthorization/trustors/{trustorOrgId}'.replace('{format}', 'json')
        path_params = {}
        if 'trustor_org_id' in params:
            path_params['trustorOrgId'] = params['trustor_org_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Trustor',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_orgauthorization_trustor_cloneduser(self, trustor_org_id, trustee_user_id, **kwargs):
        """
        Get Cloned User
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_orgauthorization_trustor_cloneduser(trustor_org_id, trustee_user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustor_org_id: Trustor Organization Id (required)
        :param str trustee_user_id: Trustee User Id (required)
        :return: ClonedUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustor_org_id', 'trustee_user_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orgauthorization_trustor_cloneduser" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustor_org_id' is set
        if ('trustor_org_id' not in params) or (params['trustor_org_id'] is None):
            raise ValueError("Missing the required parameter `trustor_org_id` when calling `get_orgauthorization_trustor_cloneduser`")
        # verify the required parameter 'trustee_user_id' is set
        if ('trustee_user_id' not in params) or (params['trustee_user_id'] is None):
            raise ValueError("Missing the required parameter `trustee_user_id` when calling `get_orgauthorization_trustor_cloneduser`")


        resource_path = '/api/v2/orgauthorization/trustors/{trustorOrgId}/clonedusers/{trusteeUserId}'.replace('{format}', 'json')
        path_params = {}
        if 'trustor_org_id' in params:
            path_params['trustorOrgId'] = params['trustor_org_id']
        if 'trustee_user_id' in params:
            path_params['trusteeUserId'] = params['trustee_user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ClonedUser',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_orgauthorization_trustor_clonedusers(self, trustor_org_id, **kwargs):
        """
        The list of cloned users in the trustor organization (i.e. users with a native user record).
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_orgauthorization_trustor_clonedusers(trustor_org_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustor_org_id: Trustor Organization Id (required)
        :return: ClonedUserEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustor_org_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orgauthorization_trustor_clonedusers" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustor_org_id' is set
        if ('trustor_org_id' not in params) or (params['trustor_org_id'] is None):
            raise ValueError("Missing the required parameter `trustor_org_id` when calling `get_orgauthorization_trustor_clonedusers`")


        resource_path = '/api/v2/orgauthorization/trustors/{trustorOrgId}/clonedusers'.replace('{format}', 'json')
        path_params = {}
        if 'trustor_org_id' in params:
            path_params['trustorOrgId'] = params['trustor_org_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ClonedUserEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_orgauthorization_trustor_group(self, trustor_org_id, trustor_group_id, **kwargs):
        """
        Get Trustee Group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_orgauthorization_trustor_group(trustor_org_id, trustor_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustor_org_id: Trustor Organization Id (required)
        :param str trustor_group_id: Trustor Group Id (required)
        :return: TrustGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustor_org_id', 'trustor_group_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orgauthorization_trustor_group" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustor_org_id' is set
        if ('trustor_org_id' not in params) or (params['trustor_org_id'] is None):
            raise ValueError("Missing the required parameter `trustor_org_id` when calling `get_orgauthorization_trustor_group`")
        # verify the required parameter 'trustor_group_id' is set
        if ('trustor_group_id' not in params) or (params['trustor_group_id'] is None):
            raise ValueError("Missing the required parameter `trustor_group_id` when calling `get_orgauthorization_trustor_group`")


        resource_path = '/api/v2/orgauthorization/trustors/{trustorOrgId}/groups/{trustorGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'trustor_org_id' in params:
            path_params['trustorOrgId'] = params['trustor_org_id']
        if 'trustor_group_id' in params:
            path_params['trustorGroupId'] = params['trustor_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrustGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_orgauthorization_trustor_groups(self, trustor_org_id, **kwargs):
        """
        The list of groups in the trustor organization (i.e. groups granted access).
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_orgauthorization_trustor_groups(trustor_org_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustor_org_id: Trustee Organization Id (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: TrustGroupEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustor_org_id', 'page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orgauthorization_trustor_groups" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustor_org_id' is set
        if ('trustor_org_id' not in params) or (params['trustor_org_id'] is None):
            raise ValueError("Missing the required parameter `trustor_org_id` when calling `get_orgauthorization_trustor_groups`")


        resource_path = '/api/v2/orgauthorization/trustors/{trustorOrgId}/groups'.replace('{format}', 'json')
        path_params = {}
        if 'trustor_org_id' in params:
            path_params['trustorOrgId'] = params['trustor_org_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrustGroupEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_orgauthorization_trustor_user(self, trustor_org_id, trustee_user_id, **kwargs):
        """
        Get Trustee User
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_orgauthorization_trustor_user(trustor_org_id, trustee_user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustor_org_id: Trustor Organization Id (required)
        :param str trustee_user_id: Trustee User Id (required)
        :return: TrustUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustor_org_id', 'trustee_user_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orgauthorization_trustor_user" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustor_org_id' is set
        if ('trustor_org_id' not in params) or (params['trustor_org_id'] is None):
            raise ValueError("Missing the required parameter `trustor_org_id` when calling `get_orgauthorization_trustor_user`")
        # verify the required parameter 'trustee_user_id' is set
        if ('trustee_user_id' not in params) or (params['trustee_user_id'] is None):
            raise ValueError("Missing the required parameter `trustee_user_id` when calling `get_orgauthorization_trustor_user`")


        resource_path = '/api/v2/orgauthorization/trustors/{trustorOrgId}/users/{trusteeUserId}'.replace('{format}', 'json')
        path_params = {}
        if 'trustor_org_id' in params:
            path_params['trustorOrgId'] = params['trustor_org_id']
        if 'trustee_user_id' in params:
            path_params['trusteeUserId'] = params['trustee_user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrustUser',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_orgauthorization_trustor_users(self, trustor_org_id, **kwargs):
        """
        The list of users in the trustor organization (i.e. users granted access).
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_orgauthorization_trustor_users(trustor_org_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustor_org_id: Trustee Organization Id (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: TrustUserEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustor_org_id', 'page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orgauthorization_trustor_users" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustor_org_id' is set
        if ('trustor_org_id' not in params) or (params['trustor_org_id'] is None):
            raise ValueError("Missing the required parameter `trustor_org_id` when calling `get_orgauthorization_trustor_users`")


        resource_path = '/api/v2/orgauthorization/trustors/{trustorOrgId}/users'.replace('{format}', 'json')
        path_params = {}
        if 'trustor_org_id' in params:
            path_params['trustorOrgId'] = params['trustor_org_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrustUserEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_orgauthorization_trustors(self, **kwargs):
        """
        The list of organizations that have authorized/trusted your organization.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_orgauthorization_trustors(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: TrustorEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orgauthorization_trustors" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/orgauthorization/trustors'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrustorEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_orgauthorization_pairings(self, body, **kwargs):
        """
        A pairing id is created by the trustee and given to the trustor to create a trust.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_orgauthorization_pairings(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TrustRequestCreate body: Pairing Info (required)
        :return: TrustRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_orgauthorization_pairings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_orgauthorization_pairings`")


        resource_path = '/api/v2/orgauthorization/pairings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrustRequest',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_orgauthorization_trustee_groups(self, trustee_org_id, body, **kwargs):
        """
        Add a group to the trust.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_orgauthorization_trustee_groups(trustee_org_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustee_org_id: Trustee Organization Id (required)
        :param TrustMemberCreate body: Trust (required)
        :return: TrustGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustee_org_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_orgauthorization_trustee_groups" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustee_org_id' is set
        if ('trustee_org_id' not in params) or (params['trustee_org_id'] is None):
            raise ValueError("Missing the required parameter `trustee_org_id` when calling `post_orgauthorization_trustee_groups`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_orgauthorization_trustee_groups`")


        resource_path = '/api/v2/orgauthorization/trustees/{trusteeOrgId}/groups'.replace('{format}', 'json')
        path_params = {}
        if 'trustee_org_id' in params:
            path_params['trusteeOrgId'] = params['trustee_org_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrustGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_orgauthorization_trustee_users(self, trustee_org_id, body, **kwargs):
        """
        Add a user to the trust.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_orgauthorization_trustee_users(trustee_org_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustee_org_id: Trustee Organization Id (required)
        :param TrustMemberCreate body: Trust (required)
        :return: TrustUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustee_org_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_orgauthorization_trustee_users" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustee_org_id' is set
        if ('trustee_org_id' not in params) or (params['trustee_org_id'] is None):
            raise ValueError("Missing the required parameter `trustee_org_id` when calling `post_orgauthorization_trustee_users`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_orgauthorization_trustee_users`")


        resource_path = '/api/v2/orgauthorization/trustees/{trusteeOrgId}/users'.replace('{format}', 'json')
        path_params = {}
        if 'trustee_org_id' in params:
            path_params['trusteeOrgId'] = params['trustee_org_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrustUser',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_orgauthorization_trustees(self, body, **kwargs):
        """
        Create a new organization authorization trust. This is required to grant other organizations access to your organization.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_orgauthorization_trustees(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TrustCreate body: Trust (required)
        :return: Trustee
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_orgauthorization_trustees" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_orgauthorization_trustees`")


        resource_path = '/api/v2/orgauthorization/trustees'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Trustee',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_orgauthorization_trustees_audits(self, body, **kwargs):
        """
        Get Org Trustee Audits
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_orgauthorization_trustees_audits(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TrusteeAuditQueryRequest body: Values to scope the request. (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'page_size', 'page_number', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_orgauthorization_trustees_audits" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_orgauthorization_trustees_audits`")


        resource_path = '/api/v2/orgauthorization/trustees/audits'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_orgauthorization_trustees_default(self, **kwargs):
        """
        Create a new organization authorization trust with Customer Care. This is required to grant your regional Customer Care organization access to your organization.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_orgauthorization_trustees_default(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool assign_default_role: Assign Admin role to default pairing with Customer Care
        :param bool auto_expire: Automatically expire pairing after 30 days
        :return: Trustee
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assign_default_role', 'auto_expire']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_orgauthorization_trustees_default" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/orgauthorization/trustees/default'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'assign_default_role' in params:
            query_params['assignDefaultRole'] = params['assign_default_role']
        if 'auto_expire' in params:
            query_params['autoExpire'] = params['auto_expire']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Trustee',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_orgauthorization_trustor_audits(self, body, **kwargs):
        """
        Get Org Trustor Audits
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_orgauthorization_trustor_audits(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TrustorAuditQueryRequest body: Values to scope the request. (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'page_size', 'page_number', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_orgauthorization_trustor_audits" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_orgauthorization_trustor_audits`")


        resource_path = '/api/v2/orgauthorization/trustor/audits'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_orgauthorization_trustee(self, trustee_org_id, body, **kwargs):
        """
        Update Org Trust
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_orgauthorization_trustee(trustee_org_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustee_org_id: Trustee Organization Id (required)
        :param TrustUpdate body: Client (required)
        :return: Trustee
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustee_org_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_orgauthorization_trustee" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustee_org_id' is set
        if ('trustee_org_id' not in params) or (params['trustee_org_id'] is None):
            raise ValueError("Missing the required parameter `trustee_org_id` when calling `put_orgauthorization_trustee`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_orgauthorization_trustee`")


        resource_path = '/api/v2/orgauthorization/trustees/{trusteeOrgId}'.replace('{format}', 'json')
        path_params = {}
        if 'trustee_org_id' in params:
            path_params['trusteeOrgId'] = params['trustee_org_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Trustee',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_orgauthorization_trustee_group_roledivisions(self, trustee_org_id, trustee_group_id, body, **kwargs):
        """
        Update Trustee Group Roles
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_orgauthorization_trustee_group_roledivisions(trustee_org_id, trustee_group_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustee_org_id: Trustee Organization Id (required)
        :param str trustee_group_id: Trustee Group Id (required)
        :param RoleDivisionGrants body: Set of roles with corresponding divisions to apply (required)
        :return: UserAuthorization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustee_org_id', 'trustee_group_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_orgauthorization_trustee_group_roledivisions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustee_org_id' is set
        if ('trustee_org_id' not in params) or (params['trustee_org_id'] is None):
            raise ValueError("Missing the required parameter `trustee_org_id` when calling `put_orgauthorization_trustee_group_roledivisions`")
        # verify the required parameter 'trustee_group_id' is set
        if ('trustee_group_id' not in params) or (params['trustee_group_id'] is None):
            raise ValueError("Missing the required parameter `trustee_group_id` when calling `put_orgauthorization_trustee_group_roledivisions`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_orgauthorization_trustee_group_roledivisions`")


        resource_path = '/api/v2/orgauthorization/trustees/{trusteeOrgId}/groups/{trusteeGroupId}/roledivisions'.replace('{format}', 'json')
        path_params = {}
        if 'trustee_org_id' in params:
            path_params['trusteeOrgId'] = params['trustee_org_id']
        if 'trustee_group_id' in params:
            path_params['trusteeGroupId'] = params['trustee_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserAuthorization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_orgauthorization_trustee_group_roles(self, trustee_org_id, trustee_group_id, body, **kwargs):
        """
        Update Trustee Group Roles
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_orgauthorization_trustee_group_roles(trustee_org_id, trustee_group_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustee_org_id: Trustee Organization Id (required)
        :param str trustee_group_id: Trustee Group Id (required)
        :param list[str] body: List of roles (required)
        :return: UserAuthorization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustee_org_id', 'trustee_group_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_orgauthorization_trustee_group_roles" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustee_org_id' is set
        if ('trustee_org_id' not in params) or (params['trustee_org_id'] is None):
            raise ValueError("Missing the required parameter `trustee_org_id` when calling `put_orgauthorization_trustee_group_roles`")
        # verify the required parameter 'trustee_group_id' is set
        if ('trustee_group_id' not in params) or (params['trustee_group_id'] is None):
            raise ValueError("Missing the required parameter `trustee_group_id` when calling `put_orgauthorization_trustee_group_roles`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_orgauthorization_trustee_group_roles`")


        resource_path = '/api/v2/orgauthorization/trustees/{trusteeOrgId}/groups/{trusteeGroupId}/roles'.replace('{format}', 'json')
        path_params = {}
        if 'trustee_org_id' in params:
            path_params['trusteeOrgId'] = params['trustee_org_id']
        if 'trustee_group_id' in params:
            path_params['trusteeGroupId'] = params['trustee_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserAuthorization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_orgauthorization_trustee_user_roledivisions(self, trustee_org_id, trustee_user_id, body, **kwargs):
        """
        Update Trustee User Roles
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_orgauthorization_trustee_user_roledivisions(trustee_org_id, trustee_user_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustee_org_id: Trustee Organization Id (required)
        :param str trustee_user_id: Trustee User Id (required)
        :param RoleDivisionGrants body: Set of roles with corresponding divisions to apply (required)
        :return: UserAuthorization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustee_org_id', 'trustee_user_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_orgauthorization_trustee_user_roledivisions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustee_org_id' is set
        if ('trustee_org_id' not in params) or (params['trustee_org_id'] is None):
            raise ValueError("Missing the required parameter `trustee_org_id` when calling `put_orgauthorization_trustee_user_roledivisions`")
        # verify the required parameter 'trustee_user_id' is set
        if ('trustee_user_id' not in params) or (params['trustee_user_id'] is None):
            raise ValueError("Missing the required parameter `trustee_user_id` when calling `put_orgauthorization_trustee_user_roledivisions`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_orgauthorization_trustee_user_roledivisions`")


        resource_path = '/api/v2/orgauthorization/trustees/{trusteeOrgId}/users/{trusteeUserId}/roledivisions'.replace('{format}', 'json')
        path_params = {}
        if 'trustee_org_id' in params:
            path_params['trusteeOrgId'] = params['trustee_org_id']
        if 'trustee_user_id' in params:
            path_params['trusteeUserId'] = params['trustee_user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserAuthorization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_orgauthorization_trustee_user_roles(self, trustee_org_id, trustee_user_id, body, **kwargs):
        """
        Update Trustee User Roles
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_orgauthorization_trustee_user_roles(trustee_org_id, trustee_user_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustee_org_id: Trustee Organization Id (required)
        :param str trustee_user_id: Trustee User Id (required)
        :param list[str] body: List of roles (required)
        :return: UserAuthorization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustee_org_id', 'trustee_user_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_orgauthorization_trustee_user_roles" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustee_org_id' is set
        if ('trustee_org_id' not in params) or (params['trustee_org_id'] is None):
            raise ValueError("Missing the required parameter `trustee_org_id` when calling `put_orgauthorization_trustee_user_roles`")
        # verify the required parameter 'trustee_user_id' is set
        if ('trustee_user_id' not in params) or (params['trustee_user_id'] is None):
            raise ValueError("Missing the required parameter `trustee_user_id` when calling `put_orgauthorization_trustee_user_roles`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_orgauthorization_trustee_user_roles`")


        resource_path = '/api/v2/orgauthorization/trustees/{trusteeOrgId}/users/{trusteeUserId}/roles'.replace('{format}', 'json')
        path_params = {}
        if 'trustee_org_id' in params:
            path_params['trusteeOrgId'] = params['trustee_org_id']
        if 'trustee_user_id' in params:
            path_params['trusteeUserId'] = params['trustee_user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserAuthorization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_orgauthorization_trustor_cloneduser(self, trustor_org_id, trustee_user_id, **kwargs):
        """
        Creates a clone of the trustee user in the trustor org.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_orgauthorization_trustor_cloneduser(trustor_org_id, trustee_user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustor_org_id: Trustor Organization Id (required)
        :param str trustee_user_id: Trustee User Id (required)
        :return: ClonedUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustor_org_id', 'trustee_user_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_orgauthorization_trustor_cloneduser" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustor_org_id' is set
        if ('trustor_org_id' not in params) or (params['trustor_org_id'] is None):
            raise ValueError("Missing the required parameter `trustor_org_id` when calling `put_orgauthorization_trustor_cloneduser`")
        # verify the required parameter 'trustee_user_id' is set
        if ('trustee_user_id' not in params) or (params['trustee_user_id'] is None):
            raise ValueError("Missing the required parameter `trustee_user_id` when calling `put_orgauthorization_trustor_cloneduser`")


        resource_path = '/api/v2/orgauthorization/trustors/{trustorOrgId}/clonedusers/{trusteeUserId}'.replace('{format}', 'json')
        path_params = {}
        if 'trustor_org_id' in params:
            path_params['trustorOrgId'] = params['trustor_org_id']
        if 'trustee_user_id' in params:
            path_params['trusteeUserId'] = params['trustee_user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ClonedUser',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_orgauthorization_trustor_group(self, trustor_org_id, trustor_group_id, **kwargs):
        """
        Add a Trustee Group to the trust.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_orgauthorization_trustor_group(trustor_org_id, trustor_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustor_org_id: Trustor Organization Id (required)
        :param str trustor_group_id: Trustor Group Id (required)
        :return: TrustGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustor_org_id', 'trustor_group_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_orgauthorization_trustor_group" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustor_org_id' is set
        if ('trustor_org_id' not in params) or (params['trustor_org_id'] is None):
            raise ValueError("Missing the required parameter `trustor_org_id` when calling `put_orgauthorization_trustor_group`")
        # verify the required parameter 'trustor_group_id' is set
        if ('trustor_group_id' not in params) or (params['trustor_group_id'] is None):
            raise ValueError("Missing the required parameter `trustor_group_id` when calling `put_orgauthorization_trustor_group`")


        resource_path = '/api/v2/orgauthorization/trustors/{trustorOrgId}/groups/{trustorGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'trustor_org_id' in params:
            path_params['trustorOrgId'] = params['trustor_org_id']
        if 'trustor_group_id' in params:
            path_params['trustorGroupId'] = params['trustor_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrustGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_orgauthorization_trustor_user(self, trustor_org_id, trustee_user_id, **kwargs):
        """
        Add a Trustee user to the trust.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_orgauthorization_trustor_user(trustor_org_id, trustee_user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trustor_org_id: Trustor Organization Id (required)
        :param str trustee_user_id: Trustee User Id (required)
        :return: TrustUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trustor_org_id', 'trustee_user_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_orgauthorization_trustor_user" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trustor_org_id' is set
        if ('trustor_org_id' not in params) or (params['trustor_org_id'] is None):
            raise ValueError("Missing the required parameter `trustor_org_id` when calling `put_orgauthorization_trustor_user`")
        # verify the required parameter 'trustee_user_id' is set
        if ('trustee_user_id' not in params) or (params['trustee_user_id'] is None):
            raise ValueError("Missing the required parameter `trustee_user_id` when calling `put_orgauthorization_trustor_user`")


        resource_path = '/api/v2/orgauthorization/trustors/{trustorOrgId}/users/{trusteeUserId}'.replace('{format}', 'json')
        path_params = {}
        if 'trustor_org_id' in params:
            path_params['trustorOrgId'] = params['trustor_org_id']
        if 'trustee_user_id' in params:
            path_params['trusteeUserId'] = params['trustee_user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrustUser',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
