# generated by datamodel-codegen:
#   filename:  schema.json
#   timestamp: 2023-03-11T12:30:23+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, constr


class Tag(BaseModel):
    name: constr(regex=r'^@')
    line: Optional[int] = None


class Status(Enum):
    passed = 'passed'
    Passed = 'Passed'
    PASSED = 'PASSED'
    failed = 'failed'
    Failed = 'Failed'
    FAILED = 'FAILED'
    undefined = 'undefined'
    Undefined = 'Undefined'
    UNDEFINED = 'UNDEFINED'
    skipped = 'skipped'
    Skipped = 'Skipped'
    SKIPPED = 'SKIPPED'
    pending = 'pending'
    Pending = 'Pending'
    PENDING = 'PENDING'
    ambiguous = 'ambiguous'
    Ambiguous = 'Ambiguous'
    AMBIGUOUS = 'AMBIGUOUS'


class Result(BaseModel):
    status: Status
    duration: Optional[float] = None
    error_message: Optional[str] = None


class Step(BaseModel):
    keyword: str
    line: Optional[int] = None
    name: Optional[str] = None
    hidden: Optional[bool] = None
    result: Optional[Result] = None


class Element(BaseModel):
    keyword: Optional[str] = None
    type: str
    id: Optional[str] = None
    line: int
    name: str
    tags: Optional[List[Tag]] = None
    steps: Optional[List[Step]] = None


class Feature(BaseModel):
    uri: str
    name: str
    description: str = None
    keyword: Optional[str] = None
    tags: Optional[List[Tag]] = None
    elements: Optional[List[Element]] = None

    @staticmethod
    def replace_square_brackets(value: str):
        return value.replace('[', '(').replace(']', ')') 

    def __init__(self, uri, name, **kwargs):
        # Remove characters from the name variable
        name = Feature.replace_square_brackets(name)

        super().__init__(uri=uri, name=name, **kwargs)


    def __setattr__(self, name, value):
        if name == 'name' and value is not None:
            # Remove characters from the name variable
            value = Feature.replace_square_brackets(value)

        super().__setattr__(name, value)


class Model(BaseModel):
    __root__: List[Feature]
