import logging
import pathlib

from mopidy import config, ext

__version__ = '0.5.0'

# TODO: If you need to log, use loggers named after the current Python module
logger = logging.getLogger(__name__)


class Extension(ext.Extension):

    dist_name = "Mopidy-Multisonic"
    ext_name = "multisonic"
    version = __version__

    def get_default_config(self):
        return config.read(pathlib.Path(__file__).parent / "ext.conf")

    def get_config_schema(self):
        schema = super().get_config_schema()

        schema["providers"] = config.List()

        return schema

    def setup(self, registry):
        from .backend import MultisonicBackend
        registry.add("backend", MultisonicBackend)
