"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import Thoth.Trade.EnumType_pb2
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class SessionControl(google.protobuf.message.Message):
    """---- 协议整体约定：1、资金为整数，2位小数；2、价格小数位依据行情中相应信息处理 3、数量小数位 0 ----
    ---- 协议时间格式：YYYYMMDD-HH:MM:SS或YYYYMMDD-HH:MM:SS.xxx (若无特殊说明，则所有时间使用此格式)
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_FIELD_NUMBER: builtins.int
    SESSION_STATUS_FIELD_NUMBER: builtins.int
    session: builtins.str
    session_status: Thoth.Trade.EnumType_pb2.ESessionStatus.ValueType
    def __init__(
        self,
        *,
        session: builtins.str = ...,
        session_status: Thoth.Trade.EnumType_pb2.ESessionStatus.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["session", b"session", "session_status", b"session_status"]) -> None: ...

global___SessionControl = SessionControl

@typing_extensions.final
class UserRegisterInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STRATEGY_ID_FIELD_NUMBER: builtins.int
    ACCOUNT_FIELD_NUMBER: builtins.int
    PASSWD_FIELD_NUMBER: builtins.int
    ACC_STATUS_FIELD_NUMBER: builtins.int
    strategy_id: builtins.str
    """/ 策略ID"""
    account: builtins.str
    """/"""
    passwd: builtins.str
    """/"""
    acc_status: Thoth.Trade.EnumType_pb2.EAccStatus.ValueType
    """/"""
    def __init__(
        self,
        *,
        strategy_id: builtins.str = ...,
        account: builtins.str = ...,
        passwd: builtins.str = ...,
        acc_status: Thoth.Trade.EnumType_pb2.EAccStatus.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["acc_status", b"acc_status", "account", b"account", "passwd", b"passwd", "strategy_id", b"strategy_id"]) -> None: ...

global___UserRegisterInfo = UserRegisterInfo

@typing_extensions.final
class RegisterReq(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STRATEGY_ID_FIELD_NUMBER: builtins.int
    STRATEGY_CHECK_CODE_FIELD_NUMBER: builtins.int
    strategy_id: builtins.str
    """/ 策略ID"""
    strategy_check_code: builtins.str
    """/ 策略校验码"""
    def __init__(
        self,
        *,
        strategy_id: builtins.str = ...,
        strategy_check_code: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["strategy_check_code", b"strategy_check_code", "strategy_id", b"strategy_id"]) -> None: ...

global___RegisterReq = RegisterReq

@typing_extensions.final
class RegisterAck(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REGISTE_INFO_FIELD_NUMBER: builtins.int
    REGIST_CODE_FIELD_NUMBER: builtins.int
    @property
    def registe_info(self) -> global___UserRegisterInfo:
        """/"""
    regist_code: Thoth.Trade.EnumType_pb2.ERegisterRet.ValueType
    """/ 注册结果"""
    def __init__(
        self,
        *,
        registe_info: global___UserRegisterInfo | None = ...,
        regist_code: Thoth.Trade.EnumType_pb2.ERegisterRet.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["registe_info", b"registe_info"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["regist_code", b"regist_code", "registe_info", b"registe_info"]) -> None: ...

global___RegisterAck = RegisterAck

@typing_extensions.final
class UnregisterReq(google.protobuf.message.Message):
    """unregister"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STRATEGY_ID_FIELD_NUMBER: builtins.int
    STRATEGY_CHECK_CODE_FIELD_NUMBER: builtins.int
    strategy_id: builtins.str
    """/ 策略ID"""
    strategy_check_code: builtins.str
    """/ 策略校验码"""
    def __init__(
        self,
        *,
        strategy_id: builtins.str = ...,
        strategy_check_code: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["strategy_check_code", b"strategy_check_code", "strategy_id", b"strategy_id"]) -> None: ...

global___UnregisterReq = UnregisterReq

@typing_extensions.final
class UnregisterAck(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RET_CODE_FIELD_NUMBER: builtins.int
    RET_MSG_FIELD_NUMBER: builtins.int
    ret_code: builtins.int
    ret_msg: builtins.str
    def __init__(
        self,
        *,
        ret_code: builtins.int = ...,
        ret_msg: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["ret_code", b"ret_code", "ret_msg", b"ret_msg"]) -> None: ...

global___UnregisterAck = UnregisterAck

@typing_extensions.final
class LoginReq(google.protobuf.message.Message):
    """/ ACK : LoginInfo"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_FIELD_NUMBER: builtins.int
    PASSWD_FIELD_NUMBER: builtins.int
    account: builtins.str
    passwd: builtins.str
    def __init__(
        self,
        *,
        account: builtins.str = ...,
        passwd: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account", "passwd", b"passwd"]) -> None: ...

global___LoginReq = LoginReq

@typing_extensions.final
class LoginInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_FIELD_NUMBER: builtins.int
    TRADING_DAY_FIELD_NUMBER: builtins.int
    EXCHANGE_NAME_FIELD_NUMBER: builtins.int
    EXCHANGE_TIME_FIELD_NUMBER: builtins.int
    SESSION_FIELD_NUMBER: builtins.int
    account: builtins.str
    trading_day: builtins.str
    exchange_name: builtins.str
    exchange_time: builtins.str
    session: builtins.bytes
    """系统使用，客户端不关注"""
    def __init__(
        self,
        *,
        account: builtins.str = ...,
        trading_day: builtins.str = ...,
        exchange_name: builtins.str = ...,
        exchange_time: builtins.str = ...,
        session: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account", "exchange_name", b"exchange_name", "exchange_time", b"exchange_time", "session", b"session", "trading_day", b"trading_day"]) -> None: ...

global___LoginInfo = LoginInfo

@typing_extensions.final
class LoginAck(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOGIN_INFO_FIELD_NUMBER: builtins.int
    RET_CODE_FIELD_NUMBER: builtins.int
    @property
    def login_info(self) -> global___LoginInfo: ...
    ret_code: Thoth.Trade.EnumType_pb2.ELoginRetCode.ValueType
    def __init__(
        self,
        *,
        login_info: global___LoginInfo | None = ...,
        ret_code: Thoth.Trade.EnumType_pb2.ELoginRetCode.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["login_info", b"login_info"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["login_info", b"login_info", "ret_code", b"ret_code"]) -> None: ...

global___LoginAck = LoginAck

@typing_extensions.final
class LogoutReq(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_FIELD_NUMBER: builtins.int
    account: builtins.str
    def __init__(
        self,
        *,
        account: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account"]) -> None: ...

global___LogoutReq = LogoutReq

@typing_extensions.final
class UserInfoQryReq(google.protobuf.message.Message):
    """account and passwd | strategy and check_code
    若查询条件是 strategy_id + chenk_code，则返回 所有；
    若查询条件是 account + passwd; 则只返回 account 和 acc_satus

    ACK: UserRegisterInfo
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_FIELD_NUMBER: builtins.int
    PASSWD_FIELD_NUMBER: builtins.int
    STRATEGY_ID_FIELD_NUMBER: builtins.int
    STRATEGY_CHECK_CODE_FIELD_NUMBER: builtins.int
    account: builtins.str
    """/"""
    passwd: builtins.str
    """/"""
    strategy_id: builtins.str
    """/ 策略ID"""
    strategy_check_code: builtins.str
    """/ 策略校验码"""
    def __init__(
        self,
        *,
        account: builtins.str = ...,
        passwd: builtins.str = ...,
        strategy_id: builtins.str = ...,
        strategy_check_code: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account", "passwd", b"passwd", "strategy_check_code", b"strategy_check_code", "strategy_id", b"strategy_id"]) -> None: ...

global___UserInfoQryReq = UserInfoQryReq

@typing_extensions.final
class HeartBeatReq(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REAL_TIME_FIELD_NUMBER: builtins.int
    real_time: builtins.str
    def __init__(
        self,
        *,
        real_time: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["real_time", b"real_time"]) -> None: ...

global___HeartBeatReq = HeartBeatReq

@typing_extensions.final
class HeartBeatAck(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___HeartBeatAck = HeartBeatAck

@typing_extensions.final
class QrySecurityStaticReq(google.protobuf.message.Message):
    """market和code皆可为空; 若market为空，则忽略code值
    market : SZSE | SHSE；或空
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_FIELD_NUMBER: builtins.int
    MARKET_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    account: builtins.str
    """/ required"""
    market: builtins.str
    code: builtins.str
    def __init__(
        self,
        *,
        account: builtins.str = ...,
        market: builtins.str = ...,
        code: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account", "code", b"code", "market", b"market"]) -> None: ...

global___QrySecurityStaticReq = QrySecurityStaticReq

@typing_extensions.final
class AccDepositReq(google.protobuf.message.Message):
    """//////////////////////////////////////////////////////////////////////////////"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SENDER_USER_FIELD_NUMBER: builtins.int
    ACCOUNT_FIELD_NUMBER: builtins.int
    CLIENT_REF_FIELD_NUMBER: builtins.int
    AMOUNT_FIELD_NUMBER: builtins.int
    SENDING_TIME_FIELD_NUMBER: builtins.int
    AMOUNT_DECIMAL_PLACE_FIELD_NUMBER: builtins.int
    sender_user: builtins.str
    """/ 发送者"""
    account: builtins.str
    """/ 资金帐号"""
    client_ref: builtins.str
    """/ 用户请求编号(uuid)"""
    amount: builtins.int
    sending_time: builtins.str
    amount_decimal_place: builtins.int
    def __init__(
        self,
        *,
        sender_user: builtins.str = ...,
        account: builtins.str = ...,
        client_ref: builtins.str = ...,
        amount: builtins.int = ...,
        sending_time: builtins.str = ...,
        amount_decimal_place: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account", "amount", b"amount", "amount_decimal_place", b"amount_decimal_place", "client_ref", b"client_ref", "sender_user", b"sender_user", "sending_time", b"sending_time"]) -> None: ...

global___AccDepositReq = AccDepositReq

@typing_extensions.final
class AccDepositAck(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACC_MARGIN_FIELD_NUMBER: builtins.int
    ERROR_CODE_FIELD_NUMBER: builtins.int
    @property
    def acc_margin(self) -> global___AccMargin: ...
    error_code: Thoth.Trade.EnumType_pb2.EDepositRetCode.ValueType
    def __init__(
        self,
        *,
        acc_margin: global___AccMargin | None = ...,
        error_code: Thoth.Trade.EnumType_pb2.EDepositRetCode.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["acc_margin", b"acc_margin"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["acc_margin", b"acc_margin", "error_code", b"error_code"]) -> None: ...

global___AccDepositAck = AccDepositAck

@typing_extensions.final
class TradingAccQryReq(google.protobuf.message.Message):
    """/ 交易账户资金信息查询消息
    / ACK: AccMargin
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_FIELD_NUMBER: builtins.int
    account: builtins.str
    """/"""
    def __init__(
        self,
        *,
        account: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account"]) -> None: ...

global___TradingAccQryReq = TradingAccQryReq

@typing_extensions.final
class QueryOrdersReq(google.protobuf.message.Message):
    """/ 除account外，皆可为空；
    / client_ref 与 order_id 只填写一个即可, 则不填写market和code
    / 查询未结委托，只填写 account 与 unfinished=true
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_FIELD_NUMBER: builtins.int
    MARKET_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    CLIENT_REF_FIELD_NUMBER: builtins.int
    ORDER_ID_FIELD_NUMBER: builtins.int
    UNFINISHED_FIELD_NUMBER: builtins.int
    account: builtins.str
    """/"""
    market: builtins.str
    """/ 标的市场"""
    code: builtins.str
    """/ 标的代码"""
    client_ref: builtins.str
    """/ 委托客户端编号"""
    order_id: builtins.str
    """/ 委托编号(交易所收单后填写：交易所委托编号)"""
    unfinished: builtins.bool
    """/ 是否查询未结(true，查询未结委托，只填写 account和unfinished=true )"""
    def __init__(
        self,
        *,
        account: builtins.str = ...,
        market: builtins.str = ...,
        code: builtins.str = ...,
        client_ref: builtins.str = ...,
        order_id: builtins.str = ...,
        unfinished: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account", "client_ref", b"client_ref", "code", b"code", "market", b"market", "order_id", b"order_id", "unfinished", b"unfinished"]) -> None: ...

global___QueryOrdersReq = QueryOrdersReq

@typing_extensions.final
class QueryHistoryOrdersReq(google.protobuf.message.Message):
    """/ market code 可空"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_FIELD_NUMBER: builtins.int
    MARKET_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    account: builtins.str
    """/"""
    market: builtins.str
    """/ 标的市场"""
    code: builtins.str
    """/ 标的代码"""
    start_time: builtins.str
    """/ YYYYMMDD-HH:MM:SS"""
    end_time: builtins.str
    def __init__(
        self,
        *,
        account: builtins.str = ...,
        market: builtins.str = ...,
        code: builtins.str = ...,
        start_time: builtins.str = ...,
        end_time: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account", "code", b"code", "end_time", b"end_time", "market", b"market", "start_time", b"start_time"]) -> None: ...

global___QueryHistoryOrdersReq = QueryHistoryOrdersReq

@typing_extensions.final
class QueryOrdersAck(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORDER_REPORTS_FIELD_NUMBER: builtins.int
    @property
    def order_reports(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OrdReport]: ...
    def __init__(
        self,
        *,
        order_reports: collections.abc.Iterable[global___OrdReport] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["order_reports", b"order_reports"]) -> None: ...

global___QueryOrdersAck = QueryOrdersAck

@typing_extensions.final
class QueryTradesReq(google.protobuf.message.Message):
    """/ 除account外，皆可为空；
    / trade_id 或 order_id 或 account market code  填写，则无效（不用填写）
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_FIELD_NUMBER: builtins.int
    MARKET_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    ORDER_ID_FIELD_NUMBER: builtins.int
    TRADE_ID_FIELD_NUMBER: builtins.int
    account: builtins.str
    """/"""
    market: builtins.str
    """/ 标的市场"""
    code: builtins.str
    """/ 标的代码"""
    order_id: builtins.str
    """/ 委托编号(交易所收单后填写：交易所委托编号)"""
    trade_id: builtins.str
    """/ 成交编号"""
    def __init__(
        self,
        *,
        account: builtins.str = ...,
        market: builtins.str = ...,
        code: builtins.str = ...,
        order_id: builtins.str = ...,
        trade_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account", "code", b"code", "market", b"market", "order_id", b"order_id", "trade_id", b"trade_id"]) -> None: ...

global___QueryTradesReq = QueryTradesReq

@typing_extensions.final
class QueryHistoryTradesReq(google.protobuf.message.Message):
    """/ market code 可空"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_FIELD_NUMBER: builtins.int
    MARKET_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    account: builtins.str
    """/"""
    market: builtins.str
    """/ 标的市场"""
    code: builtins.str
    """/ 标的代码"""
    start_time: builtins.str
    end_time: builtins.str
    def __init__(
        self,
        *,
        account: builtins.str = ...,
        market: builtins.str = ...,
        code: builtins.str = ...,
        start_time: builtins.str = ...,
        end_time: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account", "code", b"code", "end_time", b"end_time", "market", b"market", "start_time", b"start_time"]) -> None: ...

global___QueryHistoryTradesReq = QueryHistoryTradesReq

@typing_extensions.final
class QueryTradesAck(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRADE_REPORTS_FIELD_NUMBER: builtins.int
    @property
    def trade_reports(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TradeReport]: ...
    def __init__(
        self,
        *,
        trade_reports: collections.abc.Iterable[global___TradeReport] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["trade_reports", b"trade_reports"]) -> None: ...

global___QueryTradesAck = QueryTradesAck

@typing_extensions.final
class QueryPositionsReq(google.protobuf.message.Message):
    """/ 除account外，皆可为空；"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_FIELD_NUMBER: builtins.int
    MARKET_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    account: builtins.str
    """/"""
    market: builtins.str
    """/ 标的市场"""
    code: builtins.str
    """/ 标的代码"""
    def __init__(
        self,
        *,
        account: builtins.str = ...,
        market: builtins.str = ...,
        code: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account", "code", b"code", "market", b"market"]) -> None: ...

global___QueryPositionsReq = QueryPositionsReq

@typing_extensions.final
class QueryPositionsAck(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POSITIONS_FIELD_NUMBER: builtins.int
    @property
    def positions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___StokPosition]: ...
    def __init__(
        self,
        *,
        positions: collections.abc.Iterable[global___StokPosition] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["positions", b"positions"]) -> None: ...

global___QueryPositionsAck = QueryPositionsAck

@typing_extensions.final
class QueryHisPositionsReq(google.protobuf.message.Message):
    """/ 除account外，皆可为空；"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_FIELD_NUMBER: builtins.int
    MARKET_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    account: builtins.str
    """/"""
    market: builtins.str
    """/ 标的市场"""
    code: builtins.str
    """/ 标的代码"""
    start_time: builtins.str
    """/ YYYYMMDD"""
    end_time: builtins.str
    def __init__(
        self,
        *,
        account: builtins.str = ...,
        market: builtins.str = ...,
        code: builtins.str = ...,
        start_time: builtins.str = ...,
        end_time: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account", "code", b"code", "end_time", b"end_time", "market", b"market", "start_time", b"start_time"]) -> None: ...

global___QueryHisPositionsReq = QueryHisPositionsReq

@typing_extensions.final
class QueryHisPositionsAck(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POSITIONS_FIELD_NUMBER: builtins.int
    @property
    def positions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___StokPosition]: ...
    def __init__(
        self,
        *,
        positions: collections.abc.Iterable[global___StokPosition] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["positions", b"positions"]) -> None: ...

global___QueryHisPositionsAck = QueryHisPositionsAck

@typing_extensions.final
class QryHisAccReq(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_FIELD_NUMBER: builtins.int
    SETTLEMENT_DATE_FIELD_NUMBER: builtins.int
    account: builtins.str
    """/"""
    settlement_date: builtins.str
    """/ 结算日期(交易日) 可空"""
    def __init__(
        self,
        *,
        account: builtins.str = ...,
        settlement_date: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account", "settlement_date", b"settlement_date"]) -> None: ...

global___QryHisAccReq = QryHisAccReq

@typing_extensions.final
class QryHisAccAck(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACC_MARGINS_FIELD_NUMBER: builtins.int
    @property
    def acc_margins(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AccMargin]:
        """/其中，update_time填充结算交易日"""
    def __init__(
        self,
        *,
        acc_margins: collections.abc.Iterable[global___AccMargin] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["acc_margins", b"acc_margins"]) -> None: ...

global___QryHisAccAck = QryHisAccAck

@typing_extensions.final
class QryHisDepositReq(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_FIELD_NUMBER: builtins.int
    SETTLEMENT_DATE_FIELD_NUMBER: builtins.int
    account: builtins.str
    """/"""
    settlement_date: builtins.str
    """/ 结算日期(交易日) 可空"""
    def __init__(
        self,
        *,
        account: builtins.str = ...,
        settlement_date: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account", "settlement_date", b"settlement_date"]) -> None: ...

global___QryHisDepositReq = QryHisDepositReq

@typing_extensions.final
class HisDeposit(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SETTLEMENT_DATE_FIELD_NUMBER: builtins.int
    ACCOUNT_FIELD_NUMBER: builtins.int
    CLIENT_REF_FIELD_NUMBER: builtins.int
    DEPOSIT_FIELD_NUMBER: builtins.int
    AMOUNT_DECIMAL_PLACE_FIELD_NUMBER: builtins.int
    DEPOSIT_TIME_FIELD_NUMBER: builtins.int
    settlement_date: builtins.str
    """/ 结算日期(交易日)"""
    account: builtins.str
    """/"""
    client_ref: builtins.str
    """/ 客户端入金编号"""
    deposit: builtins.int
    """/ 入金金额"""
    amount_decimal_place: builtins.int
    deposit_time: builtins.str
    """/ 入金时间"""
    def __init__(
        self,
        *,
        settlement_date: builtins.str = ...,
        account: builtins.str = ...,
        client_ref: builtins.str = ...,
        deposit: builtins.int = ...,
        amount_decimal_place: builtins.int = ...,
        deposit_time: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account", "amount_decimal_place", b"amount_decimal_place", "client_ref", b"client_ref", "deposit", b"deposit", "deposit_time", b"deposit_time", "settlement_date", b"settlement_date"]) -> None: ...

global___HisDeposit = HisDeposit

@typing_extensions.final
class QryHisDepositAck(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HIS_DEPOSITS_FIELD_NUMBER: builtins.int
    @property
    def his_deposits(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HisDeposit]: ...
    def __init__(
        self,
        *,
        his_deposits: collections.abc.Iterable[global___HisDeposit] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["his_deposits", b"his_deposits"]) -> None: ...

global___QryHisDepositAck = QryHisDepositAck

@typing_extensions.final
class PlaceOrder(google.protobuf.message.Message):
    """//////////////////////////////////////////////////////////////////////////////
    委托订单
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLIENT_REF_FIELD_NUMBER: builtins.int
    SENDER_USER_FIELD_NUMBER: builtins.int
    ACCOUNT_FIELD_NUMBER: builtins.int
    MARKET_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    ORDER_TYPE_FIELD_NUMBER: builtins.int
    BUSINESS_TYPE_FIELD_NUMBER: builtins.int
    ORDER_SIDE_FIELD_NUMBER: builtins.int
    EFFECT_FIELD_NUMBER: builtins.int
    ORDER_PRICE_FIELD_NUMBER: builtins.int
    ORDER_QTY_FIELD_NUMBER: builtins.int
    ORDER_ID_FIELD_NUMBER: builtins.int
    DISCRETION_PRICE_FIELD_NUMBER: builtins.int
    PRICE_DECIMAL_PLACE_FIELD_NUMBER: builtins.int
    SEND_TIME_FIELD_NUMBER: builtins.int
    client_ref: builtins.str
    """/ 客户端订(发起方或本地)单编号"""
    sender_user: builtins.str
    """/ 发送者(策略发起:填写策略ID)"""
    account: builtins.str
    """/ 资金帐号"""
    market: builtins.str
    """/ 标的市场"""
    code: builtins.str
    """/ 标的代码"""
    order_type: Thoth.Trade.EnumType_pb2.EOrderType.ValueType
    """/ 委托类型"""
    business_type: Thoth.Trade.EnumType_pb2.EBusinessType.ValueType
    """/ 业务类型-股票业务可以不填写"""
    order_side: Thoth.Trade.EnumType_pb2.EOrderSide.ValueType
    """/ 买卖方向-buy / sell"""
    effect: Thoth.Trade.EnumType_pb2.EPositionEffect.ValueType
    """/ 开平方向-股票业务可以不填写"""
    order_price: builtins.int
    """/ 委托价格"""
    order_qty: builtins.int
    """/ 委托数量"""
    order_id: builtins.str
    """/ 委托编号(交易所收单后填写：交易所委托编号)"""
    discretion_price: builtins.int
    """/ 对应申报市价转限价的订单，这里填写转为限价订单的价格"""
    price_decimal_place: builtins.int
    """/ 价格参数小数位数(依据行情中的价格小数位设定)"""
    send_time: builtins.str
    """/ 委托时间 (format:YYYYMMDD-HH:MM:SS.xxx)"""
    def __init__(
        self,
        *,
        client_ref: builtins.str = ...,
        sender_user: builtins.str = ...,
        account: builtins.str = ...,
        market: builtins.str = ...,
        code: builtins.str = ...,
        order_type: Thoth.Trade.EnumType_pb2.EOrderType.ValueType = ...,
        business_type: Thoth.Trade.EnumType_pb2.EBusinessType.ValueType = ...,
        order_side: Thoth.Trade.EnumType_pb2.EOrderSide.ValueType = ...,
        effect: Thoth.Trade.EnumType_pb2.EPositionEffect.ValueType = ...,
        order_price: builtins.int = ...,
        order_qty: builtins.int = ...,
        order_id: builtins.str = ...,
        discretion_price: builtins.int = ...,
        price_decimal_place: builtins.int = ...,
        send_time: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account", "business_type", b"business_type", "client_ref", b"client_ref", "code", b"code", "discretion_price", b"discretion_price", "effect", b"effect", "market", b"market", "order_id", b"order_id", "order_price", b"order_price", "order_qty", b"order_qty", "order_side", b"order_side", "order_type", b"order_type", "price_decimal_place", b"price_decimal_place", "send_time", b"send_time", "sender_user", b"sender_user"]) -> None: ...

global___PlaceOrder = PlaceOrder

@typing_extensions.final
class OrdStatusMsg(google.protobuf.message.Message):
    """委托状态消息"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORDER_STATUS_FIELD_NUMBER: builtins.int
    TRADED_QTY_FIELD_NUMBER: builtins.int
    TRADED_AMOUNT_FIELD_NUMBER: builtins.int
    TOTAL_FEE_FIELD_NUMBER: builtins.int
    FROZEN_MARGIN_FIELD_NUMBER: builtins.int
    FROZEN_PRICE_FIELD_NUMBER: builtins.int
    REJECT_REASON_FIELD_NUMBER: builtins.int
    REJECT_REASON_DETAIL_FIELD_NUMBER: builtins.int
    PRICE_DECIMAL_PLACE_FIELD_NUMBER: builtins.int
    REPORT_TIME_FIELD_NUMBER: builtins.int
    order_status: Thoth.Trade.EnumType_pb2.EOrderStatus.ValueType
    """/ 委托状态"""
    traded_qty: builtins.int
    """/ 累计成交量"""
    traded_amount: builtins.int
    """/ 累计成交金额"""
    total_fee: builtins.int
    """/ 累计手续费"""
    frozen_margin: builtins.int
    """/ 冻结资金"""
    frozen_price: builtins.int
    """/ 冻结价格"""
    reject_reason: Thoth.Trade.EnumType_pb2.EOrderRejectReason.ValueType
    """/ 委托被拒绝原因"""
    reject_reason_detail: builtins.bytes
    """/ 委托被拒绝原因结节描述"""
    price_decimal_place: builtins.int
    """/ 冻结价格小数位数"""
    report_time: builtins.str
    """/ 回报时间 (format:YYYYMMDD-HH:MM:SS.xxx)"""
    def __init__(
        self,
        *,
        order_status: Thoth.Trade.EnumType_pb2.EOrderStatus.ValueType = ...,
        traded_qty: builtins.int = ...,
        traded_amount: builtins.int = ...,
        total_fee: builtins.int = ...,
        frozen_margin: builtins.int = ...,
        frozen_price: builtins.int = ...,
        reject_reason: Thoth.Trade.EnumType_pb2.EOrderRejectReason.ValueType = ...,
        reject_reason_detail: builtins.bytes = ...,
        price_decimal_place: builtins.int = ...,
        report_time: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["frozen_margin", b"frozen_margin", "frozen_price", b"frozen_price", "order_status", b"order_status", "price_decimal_place", b"price_decimal_place", "reject_reason", b"reject_reason", "reject_reason_detail", b"reject_reason_detail", "report_time", b"report_time", "total_fee", b"total_fee", "traded_amount", b"traded_amount", "traded_qty", b"traded_qty"]) -> None: ...

global___OrdStatusMsg = OrdStatusMsg

@typing_extensions.final
class CancelOrder(google.protobuf.message.Message):
    """撤请求"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLIENT_REF_FIELD_NUMBER: builtins.int
    SENDER_USER_FIELD_NUMBER: builtins.int
    ACCOUNT_FIELD_NUMBER: builtins.int
    ORG_ORDER_ID_FIELD_NUMBER: builtins.int
    SEND_TIME_FIELD_NUMBER: builtins.int
    client_ref: builtins.str
    """/ 客户端订(发起方或本地)单编号"""
    sender_user: builtins.str
    """/ 发送者"""
    account: builtins.str
    """/ 资金帐号"""
    org_order_id: builtins.str
    """/ 委托单号(order_id)"""
    send_time: builtins.str
    """/ 发送时间-(format:YYYYMMDD-HH:MM:SS.xxx)"""
    def __init__(
        self,
        *,
        client_ref: builtins.str = ...,
        sender_user: builtins.str = ...,
        account: builtins.str = ...,
        org_order_id: builtins.str = ...,
        send_time: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account", "client_ref", b"client_ref", "org_order_id", b"org_order_id", "send_time", b"send_time", "sender_user", b"sender_user"]) -> None: ...

global___CancelOrder = CancelOrder

@typing_extensions.final
class CancelOrderReject(google.protobuf.message.Message):
    """撤单拒绝回报"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLIENT_REF_FIELD_NUMBER: builtins.int
    ORG_ORDER_ID_FIELD_NUMBER: builtins.int
    REJECT_REASON_FIELD_NUMBER: builtins.int
    REJECT_REASON_DETAIL_FIELD_NUMBER: builtins.int
    REPORT_TIME_FIELD_NUMBER: builtins.int
    client_ref: builtins.str
    """/ 客户端订(发起方或本地)单编号"""
    org_order_id: builtins.str
    """/ 撤单交易平台委托单号"""
    reject_reason: Thoth.Trade.EnumType_pb2.ECxRejReasonType.ValueType
    """/ 拒绝原因类型"""
    reject_reason_detail: builtins.bytes
    """/ 委托被拒绝原因结节描述"""
    report_time: builtins.str
    """/ 发送时间-(format:20170322T145152.571447)"""
    def __init__(
        self,
        *,
        client_ref: builtins.str = ...,
        org_order_id: builtins.str = ...,
        reject_reason: Thoth.Trade.EnumType_pb2.ECxRejReasonType.ValueType = ...,
        reject_reason_detail: builtins.bytes = ...,
        report_time: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["client_ref", b"client_ref", "org_order_id", b"org_order_id", "reject_reason", b"reject_reason", "reject_reason_detail", b"reject_reason_detail", "report_time", b"report_time"]) -> None: ...

global___CancelOrderReject = CancelOrderReject

@typing_extensions.final
class StokPosition(google.protobuf.message.Message):
    """持仓信息"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_FIELD_NUMBER: builtins.int
    MARKET_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    TOTAL_QTY_FIELD_NUMBER: builtins.int
    TODAY_QTY_FIELD_NUMBER: builtins.int
    OPEN_AVG_PRICE_FIELD_NUMBER: builtins.int
    SURPLUS_CLOSE_QTY_FIELD_NUMBER: builtins.int
    FROZEN_QTY_FIELD_NUMBER: builtins.int
    PRICE_DECIMAL_PLACE_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    account: builtins.str
    """/ 资金帐号"""
    market: builtins.str
    """/ 市场"""
    code: builtins.str
    """/ 合约代码"""
    total_qty: builtins.int
    """/ 持仓数量"""
    today_qty: builtins.int
    """/ 今仓量"""
    open_avg_price: builtins.int
    """/ 开仓均价"""
    surplus_close_qty: builtins.int
    """/ 可用(平)仓量(昨仓)"""
    frozen_qty: builtins.int
    """/ 平仓冻结量"""
    price_decimal_place: builtins.int
    """/ 开仓均价小数位数"""
    update_time: builtins.str
    """/ 更新时间-(format:20170322T145152.571447)"""
    def __init__(
        self,
        *,
        account: builtins.str = ...,
        market: builtins.str = ...,
        code: builtins.str = ...,
        total_qty: builtins.int = ...,
        today_qty: builtins.int = ...,
        open_avg_price: builtins.int = ...,
        surplus_close_qty: builtins.int = ...,
        frozen_qty: builtins.int = ...,
        price_decimal_place: builtins.int = ...,
        update_time: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account", "code", b"code", "frozen_qty", b"frozen_qty", "market", b"market", "open_avg_price", b"open_avg_price", "price_decimal_place", b"price_decimal_place", "surplus_close_qty", b"surplus_close_qty", "today_qty", b"today_qty", "total_qty", b"total_qty", "update_time", b"update_time"]) -> None: ...

global___StokPosition = StokPosition

@typing_extensions.final
class AccMargin(google.protobuf.message.Message):
    """账户资产信息"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_FIELD_NUMBER: builtins.int
    TOTAL_AMOUNT_FIELD_NUMBER: builtins.int
    AVAILABLE_AMOUNT_FIELD_NUMBER: builtins.int
    DEPOSIT_FIELD_NUMBER: builtins.int
    OPEN_BALANCE_FIELD_NUMBER: builtins.int
    TRADE_FROZEN_MARGIN_FIELD_NUMBER: builtins.int
    POSITION_MARKET_AMOUNT_FIELD_NUMBER: builtins.int
    TOTAL_BUY_AMOUNT_FIELD_NUMBER: builtins.int
    TOTAL_BUY_FEE_FIELD_NUMBER: builtins.int
    TOTAL_SELL_AMOUNT_FIELD_NUMBER: builtins.int
    TOTAL_SELL_FEE_FIELD_NUMBER: builtins.int
    AMOUNT_DECIMAL_PLACE_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    account: builtins.str
    """/ 资金帐号"""
    total_amount: builtins.int
    """/ 总资产"""
    available_amount: builtins.int
    """/ 可用资金"""
    deposit: builtins.int
    """/ 入金金额(当日)"""
    open_balance: builtins.int
    """/ 期初结存"""
    trade_frozen_margin: builtins.int
    """/ 冻结资金"""
    position_market_amount: builtins.int
    """/ 持仓市值   -- 结算时填写,其他时间为0"""
    total_buy_amount: builtins.int
    """/ 累计买入成交占用资金"""
    total_buy_fee: builtins.int
    """/ 累计买入成交交易费用"""
    total_sell_amount: builtins.int
    """/ 累计卖出成交所得资金"""
    total_sell_fee: builtins.int
    """/ 累计卖出成交交易费用"""
    amount_decimal_place: builtins.int
    """/ 金额小数位(系统默认2位)"""
    update_time: builtins.str
    """/ 更新时间"""
    def __init__(
        self,
        *,
        account: builtins.str = ...,
        total_amount: builtins.int = ...,
        available_amount: builtins.int = ...,
        deposit: builtins.int = ...,
        open_balance: builtins.int = ...,
        trade_frozen_margin: builtins.int = ...,
        position_market_amount: builtins.int = ...,
        total_buy_amount: builtins.int = ...,
        total_buy_fee: builtins.int = ...,
        total_sell_amount: builtins.int = ...,
        total_sell_fee: builtins.int = ...,
        amount_decimal_place: builtins.int = ...,
        update_time: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account", "amount_decimal_place", b"amount_decimal_place", "available_amount", b"available_amount", "deposit", b"deposit", "open_balance", b"open_balance", "position_market_amount", b"position_market_amount", "total_amount", b"total_amount", "total_buy_amount", b"total_buy_amount", "total_buy_fee", b"total_buy_fee", "total_sell_amount", b"total_sell_amount", "total_sell_fee", b"total_sell_fee", "trade_frozen_margin", b"trade_frozen_margin", "update_time", b"update_time"]) -> None: ...

global___AccMargin = AccMargin

@typing_extensions.final
class OrdReport(google.protobuf.message.Message):
    """//////////////////////////////////////////////////////////////////
    委托回报 -- 后续可以只推送给客户端一类回报即可
    message OrdReport
    {
     PlaceOrder    place_order   = 1;
     OrdStatusMsg  status_msg    = 2;
     AccMargin     acc_margin    = 3;
     TradeReport   traded_report = 4;
    }

    委托回报
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLACE_ORDER_FIELD_NUMBER: builtins.int
    STATUS_MSG_FIELD_NUMBER: builtins.int
    @property
    def place_order(self) -> global___PlaceOrder: ...
    @property
    def status_msg(self) -> global___OrdStatusMsg: ...
    def __init__(
        self,
        *,
        place_order: global___PlaceOrder | None = ...,
        status_msg: global___OrdStatusMsg | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["place_order", b"place_order", "status_msg", b"status_msg"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["place_order", b"place_order", "status_msg", b"status_msg"]) -> None: ...

global___OrdReport = OrdReport

@typing_extensions.final
class TradeReport(google.protobuf.message.Message):
    """成交回报信息"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORDER_ID_FIELD_NUMBER: builtins.int
    CLIENT_REF_FIELD_NUMBER: builtins.int
    ACCOUNT_FIELD_NUMBER: builtins.int
    MARKET_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    TRADED_ID_FIELD_NUMBER: builtins.int
    TRADED_INDEX_FIELD_NUMBER: builtins.int
    EXEC_TYPE_FIELD_NUMBER: builtins.int
    TRADED_QTY_FIELD_NUMBER: builtins.int
    TRADED_PRICE_FIELD_NUMBER: builtins.int
    FEE_FIELD_NUMBER: builtins.int
    PRICE_DECIMAL_PLACE_FIELD_NUMBER: builtins.int
    TRANSACT_TIME_FIELD_NUMBER: builtins.int
    order_id: builtins.str
    """/ 委托编号(交易所委托编号)"""
    client_ref: builtins.str
    """/ 客户端订(发起方或本地)单编号"""
    account: builtins.str
    """/ 资金帐号"""
    market: builtins.str
    """/ 标的市场"""
    code: builtins.str
    """/ 标的代码"""
    traded_id: builtins.str
    """/ 成交编号"""
    traded_index: builtins.int
    """/ 成交序号(本委托的成交序号，从0递增)"""
    exec_type: Thoth.Trade.EnumType_pb2.EExecType.ValueType
    """/ 成交回报类型"""
    traded_qty: builtins.int
    """/ 成交量"""
    traded_price: builtins.int
    """/ 成交价格"""
    fee: builtins.int
    """/ 手续费"""
    price_decimal_place: builtins.int
    """/ 成交价格小数位数"""
    transact_time: builtins.str
    """/ 执行报告时间 (format:YYYYMMDD-HH:MM:SS.xxx)"""
    def __init__(
        self,
        *,
        order_id: builtins.str = ...,
        client_ref: builtins.str = ...,
        account: builtins.str = ...,
        market: builtins.str = ...,
        code: builtins.str = ...,
        traded_id: builtins.str = ...,
        traded_index: builtins.int = ...,
        exec_type: Thoth.Trade.EnumType_pb2.EExecType.ValueType = ...,
        traded_qty: builtins.int = ...,
        traded_price: builtins.int = ...,
        fee: builtins.int = ...,
        price_decimal_place: builtins.int = ...,
        transact_time: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account", "client_ref", b"client_ref", "code", b"code", "exec_type", b"exec_type", "fee", b"fee", "market", b"market", "order_id", b"order_id", "price_decimal_place", b"price_decimal_place", "traded_id", b"traded_id", "traded_index", b"traded_index", "traded_price", b"traded_price", "traded_qty", b"traded_qty", "transact_time", b"transact_time"]) -> None: ...

global___TradeReport = TradeReport
