# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog] and this project adheres to
[Semantic Versioning].

Types of changes are:
* **Security** in case of vulnerabilities.
* **Deprecated** for soon-to-be removed features.
* **Added** for new features.
* **Changed** for changes in existing functionality.
* **Removed** for now removed features.
* **Fixed** for any bug fixes.

## [Unreleased]

## [0.4.0] - 2020-03-29
### Added
* Added support for `allOf` keyword. Ensures match against all
  schemas, returns instance of the first.
* Added support for multiple composition keywords within one schema,
  including compositions of outer keywords and composition keywords.

### Changed
* Property names which are not valid python attribute names are now
  mapped to a valid python attribute. Whitespace is replaced by "_"
  and symbols are assigned their Unicode names.

## [0.3.0] - 2020-03-29
### Added
* Added `source` keyword argument to `Property`. This allows mapping
  of input properties to differing model attribute names.
* Added support for `additionalProperties` keyword argument.
* Added support for `default` as a property name in object schemas.
* Added support for `self` as a property name in object schemas.
* Added support for `default` and validation keywords in un-typed
  schemas.
* Added support for array `items` keyword in un-typed schemas.
* Added support for object `required`, `properties` and
  `additionalProperties` keywords in un-typed schemas.

### Changed
* Moved bulk of python serialization logic to DSL element methods.

## [0.2.0] - 2020-03-20
### Added
* A JSONSchema DSL (see `statham/dsl/`) has been added, and is
  now used for both the internal representation and the output.
* `anyOf` composition keyword now supported.
    - Creates models for each schema provided in the list.
    - Generated models will instantiate the first compatible model,
      based on the order they are presented.
* `oneOf` composition keyword now supported.
    - Creates models for each schema provided in the list.
    - Generated models will instantiate any compatible model, but
      fail if more than one succeeds.

### Changed
* Naming of anonymous schemas declared within the items
  of an array now uses the context of the array name.
    - For example, items of a list declared under field `volumes`,
      would previously have been named `Items`, but would now be
      named `VolumesItem`.
* Generated models switched to using a new DSL model.
* Schemas defined in the top-level `definitions` keyword are now
  detected.
* Now uses `json-ref-dict` version 0.5.0. Enables compatibility
  with a wider range of schemas.
* Name counters only increment for objects on autogenerated names.

### Removed
* Dependencies on `attrs` and `jinja2`.

### Fixed
* Name collisions where the last segment of the JSON Pointer for
  a schema's location was the same as another.
* Array schemas now accept missing items keyword as an implicit
  blank schema.
* Error reporting improved on cyclical dependencies.
* Fixed bug in title formatting.

## [0.1.1] - 2019-12-13
### Fixed
* Fix documentation now that package is available via `pip`.

## [0.1.0] - 2019-12-13
### Added
* Command run as `statham --input {reference} [--output {output}]`
* Resolve local and remote JSONSchema references to load and
  parse JSONSchema documents.
* Class-generation based on singular types.
* Class-generation based on combinations of
    - `boolean`
    - `number`
    - `integer`
    - `string`
    - `null`
* Declaration resolution for declared models.
* Validation support for the following type-specific keywords:
    - `array`:
        + `items`
        + `minItems`
        + `maxItems`
    - `object`:
        + `properties`
        + `required`
    - `boolean`:
        + `default`
    - `number`/`integer`:
        + `default`
        + `minimum`
        + `exclusiveMinimum`
        + `maximum`
        + `exclusiveMaximum`
        + `multipleOf`
    - `string`:
        + `default`
        + `format` (via extensible validation register)
        + `pattern`
        + `minLength`
        + `maxLength`
    - `null`


## [0.0.0]
Nothing here.

[Unreleased]: http://github.com/jacksmith15/statham-schema/compare/0.4.0..HEAD
[0.4.0]: http://github.com/jacksmith15/statham-schema/compare/0.3.0..0.4.0
[0.3.0]: http://github.com/jacksmith15/statham-schema/compare/0.2.0..0.3.0
[0.2.0]: http://github.com/jacksmith15/statham-schema/compare/0.1.1..0.2.0
[0.1.1]: http://github.com/jacksmith15/statham-schema/compare/0.1.0..0.1.1
[0.1.0]: http://github.com/jacksmith15/statham-schema/compare/initial..0.1.0

[Keep a Changelog]: http://keepachangelog.com/en/1.0.0/
[Semantic Versioning]: http://semver.org/spec/v2.0.0.html
