"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockerImageFunction = exports.DockerImageCode = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const code_1 = require("./code");
const function_1 = require("./function");
const handler_1 = require("./handler");
const runtime_1 = require("./runtime");
/**
 * Code property for the DockerImageFunction construct
 */
class DockerImageCode {
    /**
     * Use an existing ECR image as the Lambda code.
     * @param repository the ECR repository that the image is in
     * @param props properties to further configure the selected image
     */
    static fromEcr(repository, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_EcrImageCodeProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEcr);
            }
            throw error;
        }
        return {
            _bind() {
                return new code_1.EcrImageCode(repository, props);
            },
        };
    }
    /**
     * Create an ECR image from the specified asset and bind it as the Lambda code.
     * @param directory the directory from which the asset must be created
     * @param props properties to further configure the selected image
     */
    static fromImageAsset(directory, props = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_AssetImageCodeProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromImageAsset);
            }
            throw error;
        }
        return {
            _bind() {
                return new code_1.AssetImageCode(directory, props);
            },
        };
    }
}
exports.DockerImageCode = DockerImageCode;
_a = JSII_RTTI_SYMBOL_1;
DockerImageCode[_a] = { fqn: "@aws-cdk/aws-lambda.DockerImageCode", version: "1.194.0" };
/**
 * Create a lambda function where the handler is a docker image
 */
class DockerImageFunction extends function_1.Function {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            handler: handler_1.Handler.FROM_IMAGE,
            runtime: runtime_1.Runtime.FROM_IMAGE,
            code: props.code._bind(),
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_DockerImageFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DockerImageFunction);
            }
            throw error;
        }
    }
}
exports.DockerImageFunction = DockerImageFunction;
_b = JSII_RTTI_SYMBOL_1;
DockerImageFunction[_b] = { fqn: "@aws-cdk/aws-lambda.DockerImageFunction", version: "1.194.0" };
//# sourceMappingURL=data:application/json;base64,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