# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2019-04-15 11:50
from __future__ import unicode_literals

from django.db import migrations


def fix_project_keys(apps, schema_editor):
    """ Fix missing RemoteProject.project foreign keys (issue #197)"""
    RemoteProject = apps.get_model('projectroles', 'RemoteProject')
    Project = apps.get_model('projectroles', 'Project')

    for rp in RemoteProject.objects.all():
        if not rp.project:
            rp.project = Project.objects.filter(
                sodar_uuid=rp.project_uuid
            ).first()
            rp.save()


class Migration(migrations.Migration):

    dependencies = [
        ('projectroles', '0006_add_remote_projects'),
    ]

    operations = [
        migrations.RunPython(fix_project_keys),
    ]
