import React from "react";
import { FormatType } from "../../components/../types";
import { removeIfPresent } from "../../components/../utils/arrays";
import { getDisplayColumnHeader } from "../../components/../utils/columnHeaders";
import { changeFormatOfColumnID, getColumnFormatDropdownItemsUsingColumnID, getFormatTitle } from "../../components/../utils/formatColumns";
import DropdownButton from "../../components/elements/DropdownButton";
import DropdownItem from "../../components/elements/DropdownItem";
import Select from "../../components/elements/Select";
import XIcon from "../../components/icons/XIcon";
import Col from "../../components/spacing/Col";
import Row from "../../components/spacing/Row";
import { isNumberDtype } from "../../utils/dtypes";
const ExcelFormatSection = (props) => {
    // Returns the approporiate disabled message, not letting the user format a non-number column or a column that already has formatting
    const getFormatAddDisabledMessage = (columnID, exportedSheetIndex) => {
        const columnDtype = props.sheetDataArray[exportedSheetIndex].columnDtypeMap[columnID];
        return !isNumberDtype(columnDtype) ? 'Formatting is only available for number columns.' :
            props.sheetDataArray[exportedSheetIndex].columnFormatTypeObjMap[columnID].type != FormatType.DEFAULT ? 'This column already has a format applied to it. Find it in the list below.' : '';
    };
    return (React.createElement(React.Fragment, null, props.exportState.sheetIndexes.map(exportedSheetIndex => {
        var _a;
        const columnIDsMap = props.sheetDataArray[exportedSheetIndex].columnIDsMap;
        const newlyFormattedColumns = Object.keys(props.newlyFormattedColumns || {}).length >= exportedSheetIndex ? props.newlyFormattedColumns[exportedSheetIndex] : [];
        const columnFormatTypeObjMap = Object.entries(props.sheetDataArray[exportedSheetIndex].columnFormatTypeObjMap).filter(([, formatTypeObj]) => {
            // Filter out any column with default formatting, which is most!
            return formatTypeObj.type !== FormatType.DEFAULT;
        }).sort(([columnIDOne,], [columnIDTwo,]) => {
            // Sort the columns to be dispalyed such that the newest columns that the user
            // formats using this taskpane are shown at the top
            const idxOne = newlyFormattedColumns.indexOf(columnIDOne);
            const idxTwo = newlyFormattedColumns.indexOf(columnIDTwo);
            if (idxOne >= 0 && idxTwo === -1) {
                return -1;
            }
            else if (idxOne === -1 && idxTwo >= 0) {
                return 1;
            }
            else if (idxOne === -1 && idxTwo === -1) {
                return 0;
            }
            else {
                return idxOne < idxTwo ? -1 : 1;
            }
        });
        return (React.createElement("div", { key: exportedSheetIndex, className: 'mt-10px' },
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, { span: 16 },
                    React.createElement("p", { className: 'text-header-3' },
                        props.dfNames[exportedSheetIndex],
                        " formatting")),
                React.createElement(DropdownButton, { text: '+ Format', width: 'small', searchable: true }, Object.keys(((_a = props.sheetDataArray[exportedSheetIndex]) === null || _a === void 0 ? void 0 : _a.columnIDsMap) || {}).map(columnID => {
                    const columnHeader = getDisplayColumnHeader(columnIDsMap[columnID]);
                    const disabledText = getFormatAddDisabledMessage(columnID, exportedSheetIndex);
                    return (React.createElement(DropdownItem, { key: exportedSheetIndex.toString() + columnHeader, title: columnHeader, onClick: () => {
                            props.setNewlyFormattedColumns(prevNewlyFormattedColumns => {
                                // Add the columnID to the front of the list so it is displayed at the top
                                const copySheetNewlyFormattedColumns = [...prevNewlyFormattedColumns[exportedSheetIndex]];
                                copySheetNewlyFormattedColumns.unshift(columnID);
                                prevNewlyFormattedColumns[exportedSheetIndex] = copySheetNewlyFormattedColumns;
                                return prevNewlyFormattedColumns;
                            });
                            void changeFormatOfColumnID(exportedSheetIndex, columnID, { type: FormatType.PLAIN_TEXT }, props.mitoAPI);
                        }, disabled: disabledText !== '', hideSubtext: true, displaySubtextOnHover: true, subtext: disabledText }));
                }))),
            columnFormatTypeObjMap.map(([columnID, columnFormatTypeObj]) => {
                var _a;
                const columnHeader = getDisplayColumnHeader(columnIDsMap[columnID]);
                const columnDtype = props.sheetDataArray[exportedSheetIndex].columnDtypeMap[columnID];
                return (React.createElement(Row, { justify: 'space-between', align: 'center', key: exportedSheetIndex.toString() + columnHeader },
                    React.createElement(Select, { value: columnHeader, width: 'medium', onChange: (newColumnID) => {
                            /*
                                If the user uses the select to change the column header that a formatting is applied to:
                                2. set the previous columnID to have DEFAULT formatting
                                3. set the new columnID to have the formatting that was previously applied
                            */
                            // Get rid of the formatting from the previous column that was selected
                            void changeFormatOfColumnID(exportedSheetIndex, columnID, { type: FormatType.DEFAULT }, props.mitoAPI);
                            // Add the previous column's formatting to the new column
                            void changeFormatOfColumnID(exportedSheetIndex, newColumnID, columnFormatTypeObj, props.mitoAPI);
                        } }, Object.keys(((_a = props.sheetDataArray[exportedSheetIndex]) === null || _a === void 0 ? void 0 : _a.columnIDsMap) || {}).map(columnID => {
                        const columnHeader = getDisplayColumnHeader(columnIDsMap[columnID]);
                        const disabledText = getFormatAddDisabledMessage(columnID, exportedSheetIndex);
                        return (React.createElement(DropdownItem, { key: exportedSheetIndex.toString() + columnHeader, id: columnID, title: columnHeader, disabled: disabledText !== '', hideSubtext: true, displaySubtextOnHover: true, subtext: disabledText }));
                    })),
                    React.createElement(Select, { value: getFormatTitle(columnFormatTypeObj), width: 'medium' }, getColumnFormatDropdownItemsUsingColumnID(exportedSheetIndex, columnID, props.mitoAPI, columnDtype, props.sheetDataArray[exportedSheetIndex], false)),
                    React.createElement(Col, { offsetRight: 1 },
                        React.createElement("div", { className: 'default-taskpane-header-exit-button-div', onClick: () => {
                                // If the columnID is included in the list of newly formatted columns, remove it. 
                                props.setNewlyFormattedColumns(prevNewlyFormattedColumns => {
                                    const copySheetNewlyFormattedColumns = [...prevNewlyFormattedColumns[exportedSheetIndex]];
                                    removeIfPresent(copySheetNewlyFormattedColumns, columnID);
                                    return Object.assign(Object.assign({}, prevNewlyFormattedColumns), { exportedSheetIndex: copySheetNewlyFormattedColumns });
                                });
                                // Actually set the format of the column to default 
                                void changeFormatOfColumnID(exportedSheetIndex, columnID, { type: FormatType.DEFAULT }, props.mitoAPI);
                            } },
                            React.createElement(XIcon, null)))));
            }),
            columnFormatTypeObjMap.length == 0 &&
                React.createElement(Row, { justify: 'space-around' },
                    React.createElement("p", { className: 'ma-25px text-align-center' }, "There is no formatting applied to this sheet."))));
    })));
};
export default ExcelFormatSection;
//# sourceMappingURL=ExcelFormatSection.js.map