import React from 'react';
import { Filter } from './Filter';
import TextButton from '../../../../elements/TextButton';
/*
    Component that contains a group of filters
*/
export default function FilterGroup(props) {
    return (React.createElement("div", { className: "filter-group" },
        props.filters.map((filter, index) => {
            return (React.createElement(Filter, { first: index === 0, key: index, filter: filter, operator: props.groupOperator, displayOperator: true, setFilter: (newFilter) => {
                    props.setFilter(index, newFilter);
                }, setOperator: props.setOperator, deleteFilter: () => { props.deleteFilter(index); }, inGroup: true, columnDtype: props.columnDtype }));
        }),
        React.createElement(TextButton, { variant: 'light', onClick: props.addFilter, width: 'medium' }, "+ Add a Filter")));
}
//# sourceMappingURL=FilterGroup.js.map