import React, { useState } from "react";
import useSyncedParams from "../../../hooks/useSyncedParams";
import { StepType } from "../../../types";
import DropdownButton from "../../elements/DropdownButton";
import DropdownItem from "../../elements/DropdownItem";
import Select from "../../elements/Select";
import SelectAndXIconCard from "../../elements/SelectAndXIconCard";
import Toggle from "../../elements/Toggle";
import Col from "../../spacing/Col";
import Row from "../../spacing/Row";
import DefaultEmptyTaskpane from "../DefaultTaskpane/DefaultEmptyTaskpane";
import DefaultTaskpane from "../DefaultTaskpane/DefaultTaskpane";
import DefaultTaskpaneBody from "../DefaultTaskpane/DefaultTaskpaneBody";
import DefaultTaskpaneHeader from "../DefaultTaskpane/DefaultTaskpaneHeader";
/*
    This taskpane allows users to concatenate two or more
    dataframes together.
*/
const ConcatTaskpane = (props) => {
    const { params, setParams } = useSyncedParams({
        join: 'inner',
        ignore_index: true,
        sheet_indexes: []
    }, StepType.Concat, props.mitoAPI, props.analysisData, 50 // 50 ms debounce delay
    );
    // Make sure the user cannot select the newly created dataframe
    const [selectableSheetIndexes] = useState(props.sheetDataArray.map((sd, index) => index));
    if (params === undefined) {
        return (React.createElement(DefaultEmptyTaskpane, { setUIState: props.setUIState, message: "Import at least two datasets before concating." }));
    }
    const dataframeCards = params.sheet_indexes.map((sheetIndex, arrIndex) => {
        return (React.createElement(SelectAndXIconCard, { key: arrIndex, titleMap: Object.fromEntries(props.sheetDataArray.map((sheetData, index) => {
                return [index + '', sheetData.dfName];
            })), value: sheetIndex + '', onChange: (newSheetIndexStr) => {
                const newSheetIndex = parseInt(newSheetIndexStr);
                setParams(prevConcatParams => {
                    const newSheetIndexes = [...prevConcatParams.sheet_indexes];
                    newSheetIndexes[arrIndex] = newSheetIndex;
                    return Object.assign(Object.assign({}, prevConcatParams), { sheet_indexes: newSheetIndexes });
                });
            }, onDelete: () => {
                setParams(prevConcatParams => {
                    const newSheetIndexes = [...prevConcatParams.sheet_indexes];
                    newSheetIndexes.splice(arrIndex, 1);
                    return Object.assign(Object.assign({}, prevConcatParams), { sheet_indexes: newSheetIndexes });
                });
            }, selectableValues: Object.keys(props.sheetDataArray) }));
    });
    return (React.createElement(DefaultTaskpane, null,
        React.createElement(DefaultTaskpaneHeader, { header: "Concatenate Sheet", setUIState: props.setUIState }),
        React.createElement(DefaultTaskpaneBody, null,
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", { className: 'text-header-3' }, "Join Type")),
                React.createElement(Col, null,
                    React.createElement(Select, { value: params.join, onChange: (newJoin) => {
                            setParams(prevConcatParams => {
                                return Object.assign(Object.assign({}, prevConcatParams), { join: newJoin });
                            });
                        }, width: 'medium' },
                        React.createElement(DropdownItem, { title: 'inner', subtext: "Only includes columns that exist in all sheets" }),
                        React.createElement(DropdownItem, { title: "outer", subtext: "Includes all columns from all sheets, regardless of if these columns are in the other sheets." })))),
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", { className: 'text-header-3' }, "Ignore Existing Indexes")),
                React.createElement(Col, null,
                    React.createElement(Toggle, { value: params.ignore_index, onChange: () => {
                            setParams(prevConcatParams => {
                                return Object.assign(Object.assign({}, prevConcatParams), { ignore_index: !prevConcatParams.ignore_index });
                            });
                        } }))),
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", { className: 'text-header-3' }, "Dataframes to Concatenate")),
                React.createElement(Col, null,
                    React.createElement(DropdownButton, { text: '+ Add', width: 'small', searchable: true }, [
                        React.createElement(DropdownItem, { key: -1, title: "Add all sheets", onClick: () => {
                                setParams(prevConcatParams => {
                                    const newSheetIndexes = [...selectableSheetIndexes];
                                    return Object.assign(Object.assign({}, prevConcatParams), { sheet_indexes: newSheetIndexes });
                                });
                            } })
                    ].concat(props.sheetDataArray.filter((sheetData, index) => {
                        if (!selectableSheetIndexes.includes(index)) {
                            return false;
                        }
                        return true;
                    }).map((sheetData, index) => {
                        return (React.createElement(DropdownItem, { key: index, title: sheetData.dfName, onClick: () => {
                                setParams(prevConcatParams => {
                                    const newSheetIndexes = [...prevConcatParams.sheet_indexes];
                                    newSheetIndexes.push(index);
                                    return Object.assign(Object.assign({}, prevConcatParams), { sheet_indexes: newSheetIndexes });
                                });
                            } }));
                    }))))),
            dataframeCards)));
};
export default ConcatTaskpane;
//# sourceMappingURL=ConcatTaskpane.js.map