"""add catches and places tables

Revision ID: 3b91c7a8865e
Revises: 
Create Date: 2023-04-03 12:50:20.689552

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision = '3b91c7a8865e'
down_revision = None
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('places',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('name', sa.String(length=25), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('catches',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('species', sa.Enum('CARP', name='species'), nullable=False),
    sa.Column('mass', mysql.DOUBLE(asdecimal=True), nullable=False),
    sa.Column('length', sa.Integer(), nullable=False),
    sa.Column('circumference', sa.Integer(), nullable=False),
    sa.Column('time', sa.DateTime(), nullable=False),
    sa.Column('place_id', sa.Integer(), nullable=False),
    sa.Column('bait', sa.String(length=25), nullable=False),
    sa.Column('gear', sa.String(length=100), nullable=False),
    sa.Column('others', sa.String(length=100), nullable=False),
    sa.ForeignKeyConstraint(['place_id'], ['places.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('catches')
    op.drop_table('places')
    # ### end Alembic commands ###
