"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Backup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * Construct to create a Backup Plan with specific backing cadence.
 *
 * @stability stable
 */
class Backup extends constructs_1.Construct {
    /**
     *
     * @param scope Construct's scope
     * @param id Construct's id
     * @param props Construct's props
     */
    constructor(scope, id, props) {
        super(scope, id);
        const hourlyRate = `0/${props.backupRateHour || 24}`;
        const completionWindow = props.backupCompletionWindow || aws_cdk_lib_1.Duration.hours(3);
        const startWindow = props.backupStartWindow || aws_cdk_lib_1.Duration.hours(completionWindow.toHours() - 1);
        if (completionWindow.toHours() - startWindow.toHours() < 1) {
            throw Error('Backup completion window must be at least 60 minutes greater than backup start window');
        }
        const scheduledBkRule = new aws_cdk_lib_1.aws_backup.BackupPlanRule({
            completionWindow,
            startWindow,
            deleteAfter: props.deleteBackupAfter || aws_cdk_lib_1.Duration.days(30),
            // Only cron expressions are supported
            scheduleExpression: aws_cdk_lib_1.aws_events.Schedule.cron({
                minute: '0',
                hour: hourlyRate,
            }),
            moveToColdStorageAfter: props.moveBackupToColdStorageAfter,
        });
        this.backupPlan = new aws_cdk_lib_1.aws_backup.BackupPlan(this, 'BackupPlan', {
            backupPlanName: props.backupPlanName,
            backupPlanRules: [scheduledBkRule],
        });
        this.backupPlan.addSelection('BackupSelection', {
            resources: props.resources,
        });
        // Outputs
        const outputVars = {
            BackupPlanId: this.backupPlan.backupPlanId,
            BackupPlanArn: this.backupPlan.backupPlanArn,
        };
        Object.entries(outputVars).forEach(([outName, outValue]) => new aws_cdk_lib_1.CfnOutput(this, outName, { value: outValue }));
    }
}
exports.Backup = Backup;
_a = JSII_RTTI_SYMBOL_1;
Backup[_a] = { fqn: "cdk-backup-plan.Backup", version: "0.0.1" };
//# sourceMappingURL=data:application/json;base64,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