import { Duration, aws_backup as bk } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export interface BackupProps {
    /**
     * Resources to apply backup plan.
     */
    readonly resources: bk.BackupResource[];
    /**
     * The display name of the backup plan.
     */
    readonly backupPlanName: string;
    /**
     * The duration after a backup job is successfully
     * started before it must be completed or it is
     * canceled by AWS Backup.
     *
     * Note: `backupCompletionWindow` must be at least 60 minutes greater
     * than @backupStartWindows
     *
     * @default - 3 hours
     */
    readonly backupCompletionWindow?: Duration;
    /**
     * The duration after a backup is scheduled before
     * a job is canceled if it doesn't start successfully.
     *
     * @default - 1 hour less than @backupCompletionWindow
     */
    readonly backupStartWindow?: Duration;
    /**
     * Specifies the duration after creation that a recovery point is deleted.
     * Must be greater than moveToColdStorageAfter.
     *
     * @default - 30 days
     */
    readonly deleteBackupAfter?: Duration;
    /**
     * Specifies the duration after creation that a recovery point is moved to cold storage.
     *
     * @default - recovery point is never moved to cold storage
     */
    readonly moveBackupToColdStorageAfter?: Duration;
    /**
     * How frequently backup jobs would be started.
     *
     * @default - 24 hours
     */
    readonly backupRateHour?: number;
}
/**
 * Construct to create a Backup Plan with specific backing cadence.
 *
 * @stability stable
 */
export declare class Backup extends Construct {
    /**
     * Backup plan
     */
    readonly backupPlan: bk.BackupPlan;
    /**
     *
     * @param scope Construct's scope
     * @param id Construct's id
     * @param props Construct's props
     */
    constructor(scope: Construct, id: string, props: BackupProps);
}
