import json
import setuptools

kwargs = json.loads(
    """
{
    "name": "cdk-backup-plan",
    "version": "0.0.1",
    "description": "CDK construct to create AWS Backup Plans",
    "license": "MIT-0",
    "url": "https://github.com/aws-samples/cdk-backup-plan.git",
    "long_description_content_type": "text/markdown",
    "author": "Mauricio Villaescusa<maurovc@amazon.com>",
    "bdist_wheel": {
        "universal": true
    },
    "project_urls": {
        "Source": "https://github.com/aws-samples/cdk-backup-plan.git"
    },
    "package_dir": {
        "": "src"
    },
    "packages": [
        "cdk_backup_plan",
        "cdk_backup_plan._jsii"
    ],
    "package_data": {
        "cdk_backup_plan._jsii": [
            "cdk-backup-plan@0.0.1.jsii.tgz"
        ],
        "cdk_backup_plan": [
            "py.typed"
        ]
    },
    "python_requires": "~=3.7",
    "install_requires": [
        "aws-cdk-lib>=2.1.0, <3.0.0",
        "constructs>=10.0.5, <11.0.0",
        "jsii>=1.61.0, <2.0.0",
        "publication>=0.0.3"
    ],
    "classifiers": [
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: JavaScript",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Typing :: Typed",
        "Development Status :: 5 - Production/Stable",
        "License :: OSI Approved"
    ],
    "scripts": []
}
"""
)

with open("README.md", encoding="utf8") as fp:
    kwargs["long_description"] = fp.read()


setuptools.setup(**kwargs)
