LAYER_RESULT_COUNT_MAP = {
    '2020 Census Public Use Microdata Areas': 450,
    '2010 Census Public Use Microdata Areas': 450,
    '2020 Census Zip Code Tabulation Areas': 650,
    '2010 Census Zip Code Tabulation Areas': 650,
    'Tribal Census Tracts': 500,
    'Tribal Block Groups': 1000,
    'Census Tracts': 5000,
    'Census Block Groups': 4750,
    '2020 Census Blocks': 160000,
    '2010 Census Blocks': 160000,
    'Unified School Districts': 1250,
    'Secondary School Districts': 500,
    'Elementary School Districts': 2000,
    'School District Administrative Areas': 60,
    'Estates': 450,
    'County Subdivisions': 2000,
    'Subbarrios': 150,
    'Consolidated Cities': 20,
    'Incorporated Places': 3000,
    'Census Designated Places': 4000,
    'Alaska Native Regional Corporations': 20,
    'Tribal Subdivisions': 500,
    'Federal AMerican Indian Reservations': 320,
    'Off-Reservation Trust Lands': 175,
    'State American Indian Reservations': 20,
    'Hawaiian Home Lands': 100,
    'Alaska Native Village Statistical Areas': 225,
    'Oklahoma Tribal Statistical Areas': 30,
    'State Designated Tribal Statistical Areas': 40,
    'Tribal Designated Statistical Areas': 10,
    'American Indian Joint-Use Areas': 10,
    '118th Congressional Districts': 125,
    '117th Congressional Districts': 125,
    '116th Congressional Districts': 125,
    '115th Congressional Districts': 125,
    '114th Congressional Districts': 125,
    '113th Congressional Districts': 125,
    '112th Congressional Districts': 125,
    '111th Congressional Districts': 125,
    '2022 State Legislative Districts - Upper': 350,
    '2021 State Legislative Districts - Upper': 350,
    '2020 State Legislative Districts - Upper': 350,
    '2019 State Legislative Districts - Upper': 350,
    '2018 State Legislative Districts - Upper': 350,
    '2017 State Legislative Districts - Upper': 350,
    '2016 State Legislative Districts - Upper': 350,
    '2015 State Legislative Districts - Upper': 350,
    '2014 State Legislative Districts - Upper': 350,
    '2013 State Legislative Districts - Upper': 350,
    '2012 State Legislative Districts - Upper': 350,
    '2011 State Legislative Districts - Upper': 350,
    '2010 State Legislative Districts - Upper': 350,
    '2022 State Legislative Districts - Lower': 350,
    '2021 State Legislative Districts - Lower': 350,
    '2020 State Legislative Districts - Lower': 350,
    '2019 State Legislative Districts - Lower': 350,
    '2018 State Legislative Districts - Lower': 350,
    '2017 State Legislative Districts - Lower': 350,
    '2016 State Legislative Districts - Lower': 350,
    '2015 State Legislative Districts - Lower': 350,
    '2014 State Legislative Districts - Lower': 350,
    '2013 State Legislative Districts - Lower': 350,
    '2012 State Legislative Districts - Lower': 350,
    '2011 State Legislative Districts - Lower': 350,
    '2010 State Legislative Districts - Lower': 350,
    'Census Divisions': 10,
    'Census Regions': 10,
    'States': 60,
    'Counties': 150,
    'Urban Areas': 450
}

FEATURE_ATTRIBUTE_MAP = {
    'ZCTA5': 'zip code tabulation area',
    'TTRACT': 'tribal census tract',
    'TRACT': 'tract',
    'TBLKGRP': 'tribal block group',
    'BLKGRP': 'block group',
    'BLOCK': 'block',
    'SDUDI': 'school district (unified)',
    'SDSEC': 'school district (secondary)',
    'SDELM': 'school district (elementary)',
    'COUSUB': 'county subdivision',
    'CONCITY': 'consolidated city',
    'PLACE': 'place',
    'ANRC': 'alaskan national regional corporation',
    'CD118': 'congressional district',
    'CD117': 'congressional district',
    'CD116': 'congressional district',
    'CD115': 'congressional district',
    'CD114': 'congressional district',
    'CD113': 'congressional district',
    'CD112': 'congressional district',
    'CD111': 'congressional district',
    'SLDU': 'state legislative district (upper)',
    'SLDL': 'state legislative district (lower)',
    'REGION': 'region',
    'DIVISION': 'division',
    'CNECTA': 'combined new england city and town area',
    'NECTA': 'new england city and town area',
    'CSA': 'combined statistical area',
    'CBSA': 'metropolitan statistical area/micropolitan statistical area',
    'METDIV': 'metropolitan division',
    'STATE': 'state',
    'COUNTY': 'county',
}

LAYER_NAME_MAP = {
    '2020 Census Public Use Microdata Areas': 450,
    '2010 Census Public Use Microdata Areas': 450,
    '2020 Census Zip Code Tabulation Areas': 'zip code tabulation area',
    '2010 Census Zip Code Tabulation Areas': 'zip code tabulation area',
    'Tribal Census Tracts': 'tribal census tract',
    'Tribal Block Groups': 'tribal block group',
    'Census Tracts': 'tract',
    'Census Block Groups': 'block group',
    '2020 Census Blocks': 'block',
    '2010 Census Blocks': 'block',
    'Unified School Districts': 'school district (unified)',
    'Secondary School Districts': 'school district (secondary)',
    'Elementary School Districts': 'school district (elementary)',
    'County Subdivisions': 'county subdivision',
    'Consolidated Cities': 'consolidated city',
    'Incorporated Places': 'place',
    'Census Designated Places': 'place',
    'Alaska Native Regional Corporations': 'alaska native regional corporation',
    'Tribal Subdivisions': 'tribal subdivision',
    'Off-Reservation Trust Lands': 'american indian area (off-reservation trust land only)/hawaiian home land',
    'Hawaiian Home Lands': 'american indian area/alaska native area/hawaiian home land',
    '118th Congressional Districts': 'congressional district',
    '117th Congressional Districts': 'congressional district',
    '116th Congressional Districts': 'congressional district',
    '115th Congressional Districts': 'congressional district',
    '114th Congressional Districts': 'congressional district',
    '113th Congressional Districts': 'congressional district',
    '112th Congressional Districts': 'congressional district',
    '111th Congressional Districts': 'congressional district',
    '2022 State Legislative Districts - Upper': 'state legislative district (upper)',
    '2021 State Legislative Districts - Upper': 'state legislative district (upper)',
    '2020 State Legislative Districts - Upper': 'state legislative district (upper)',
    '2019 State Legislative Districts - Upper': 'state legislative district (upper)',
    '2018 State Legislative Districts - Upper': 'state legislative district (upper)',
    '2017 State Legislative Districts - Upper': 'state legislative district (upper)',
    '2016 State Legislative Districts - Upper': 'state legislative district (upper)',
    '2015 State Legislative Districts - Upper': 'state legislative district (upper)',
    '2014 State Legislative Districts - Upper': 'state legislative district (upper)',
    '2013 State Legislative Districts - Upper': 'state legislative district (upper)',
    '2012 State Legislative Districts - Upper': 'state legislative district (upper)',
    '2011 State Legislative Districts - Upper': 'state legislative district (upper)',
    '2010 State Legislative Districts - Upper': 'state legislative district (upper)',
    '2022 State Legislative Districts - Lower': 'state legislative district (lower)',
    '2021 State Legislative Districts - Lower': 'state legislative district (lower)',
    '2020 State Legislative Districts - Lower': 'state legislative district (lower)',
    '2019 State Legislative Districts - Lower': 'state legislative district (lower)',
    '2018 State Legislative Districts - Lower': 'state legislative district (lower)',
    '2017 State Legislative Districts - Lower': 'state legislative district (lower)',
    '2016 State Legislative Districts - Lower': 'state legislative district (lower)',
    '2015 State Legislative Districts - Lower': 'state legislative district (lower)',
    '2014 State Legislative Districts - Lower': 'state legislative district (lower)',
    '2013 State Legislative Districts - Lower': 'state legislative district (lower)',
    '2012 State Legislative Districts - Lower': 'state legislative district (lower)',
    '2011 State Legislative Districts - Lower': 'state legislative district (lower)',
    '2010 State Legislative Districts - Lower': 'state legislative district (lower)',
    'Census Divisions': 'division',
    'Census Regions': 'region',
    'States': 'state',
    'Counties': 'county',
    'Urban Areas': 'urban area'
}

FIPS_TO_ABBR = {
   "01":"AL",
   "02":"AK",
   "04":"AZ",
   "05":"AR",
   "06":"CA",
   "08":"CO",
   "09":"CT",
   "10":"DE",
   "11":"DC",
   "12":"FL",
   "13":"GA",
   "15":"HI",
   "16":"ID",
   "17":"IL",
   "18":"IN",
   "19":"IA",
   "20":"KS",
   "21":"KY",
   "22":"LA",
   "23":"ME",
   "24":"MD",
   "25":"MA",
   "26":"MI",
   "27":"MN",
   "28":"MS",
   "29":"MO",
   "30":"MT",
   "31":"NE",
   "32":"NV",
   "33":"NH",
   "34":"NJ",
   "35":"NM",
   "36":"NY",
   "37":"NC",
   "38":"ND",
   "39":"OH",
   "40":"OK",
   "41":"OR",
   "42":"PA",
   "44":"RI",
   "45":"SC",
   "46":"SD",
   "47":"TN",
   "48":"TX",
   "49":"UT",
   "50":"VT",
   "51":"VA",
   "53":"WA",
   "54":"WV",
   "55":"WI",
   "56":"WY",
   "60":"AS",
   "66":"GU",
   "69":"MP",
   "72":"PR",
   "78":"VI",
}

ABBR_TO_FULL = {
    'AK': 'Alaska',
    'AL': 'Alabama',
    'AR': 'Arkansas',
    'AZ': 'Arizona',
    'CA': 'California',
    'CO': 'Colorado',
    'CT': 'Connecticut',
    'DC': 'District of Columbia',
    'DE': 'Delaware',
    'FL': 'Florida',
    'GA': 'Georgia',
    'HI': 'Hawaii',
    'IA': 'Iowa',
    'ID': 'Idaho',
    'IL': 'Illinois',
    'IN': 'Indiana',
    'KS': 'Kansas',
    'KY': 'Kentucky',
    'LA': 'Louisiana',
    'MA': 'Massachusetts',
    'MD': 'Maryland',
    'ME': 'Maine',
    'MI': 'Michigan',
    'MN': 'Minnesota',
    'MO': 'Missouri',
    'MS': 'Mississippi',
    'MT': 'Montana',
    'NC': 'North Carolina',
    'ND': 'North Dakota',
    'NE': 'Nebraska',
    'NH': 'New Hampshire',
    'NJ': 'New Jersey',
    'NM': 'New Mexico',
    'NV': 'Nevada',
    'NY': 'New York',
    'OH': 'Ohio',
    'OK': 'Oklahoma',
    'OR': 'Oregon',
    'PA': 'Pennsylvania',
    'RI': 'Rhode Island',
    'SC': 'South Carolina',
    'SD': 'South Dakota',
    'TN': 'Tennessee',
    'TX': 'Texas',
    'UT': 'Utah',
    'VA': 'Virginia',
    'VT': 'Vermont',
    'WA': 'Washington',
    'WI': 'Wisconsin',
    'WV': 'West Virginia',
    'WY': 'Wyoming',
    'AS': 'American Samoa',
    'GU': 'Guam',
    'MP': 'Commonwealth of the Northern Mariana Islands',
    'PR': 'Puerto Rico',
    'VI': 'Virgin Islands'
}

FIPS_TO_FULL = {k: ABBR_TO_FULL[v] for k, v in FIPS_TO_ABBR.items()}

ABBR_TO_FULL_REGEX = '(' +  '|'.join([f'(?P<{v}>(?<![A-Za-z0-9])({k}|{k.lower()})(?![A-Za-z0-9]))' for k, v in {k: v.replace(' ', '_') for k, v in ABBR_TO_FULL.items()}.items()]) + ')'

BAD_VALUES = ['-666666666', '-', '-999999999', 'N', '-888888888', '(X)', 'Varies', 'median-', 'median+', '-222222222', '**', '-333333333', '***', '-555555555', '****', '*', 'N/A', 'null']