# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: services/universal-wallet/v1/universal-wallet.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import Dict, List, Optional

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


@dataclass(eq=False, repr=False)
class CreateWalletRequest(betterproto.Message):
    controller: str = betterproto.string_field(1)
    description: str = betterproto.string_field(2)
    # (Optional) Supply an invitation id to associate this caller profile to an
    # existing cloud wallet.
    security_code: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class CreateWalletResponse(betterproto.Message):
    status: "__common_v1__.ResponseStatus" = betterproto.enum_field(1)
    wallet_id: str = betterproto.string_field(2)
    capability: str = betterproto.string_field(3)
    invoker: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class ConnectRequest(betterproto.Message):
    email: str = betterproto.string_field(5, group="contact_method")
    phone: str = betterproto.string_field(6, group="contact_method")


@dataclass(eq=False, repr=False)
class ConnectResponse(betterproto.Message):
    status: "__common_v1__.ResponseStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class InvitationToken(betterproto.Message):
    security_code: str = betterproto.string_field(1)
    wallet_id: str = betterproto.string_field(2)
    email: str = betterproto.string_field(5, group="contact_method")
    phone: str = betterproto.string_field(6, group="contact_method")


@dataclass(eq=False, repr=False)
class WalletProfile(betterproto.Message):
    """
    Stores profile data for accessing a wallet.This result should be stored
    somewhere safe,as it contains private key information.
    """

    did_document: "__common_v1__.JsonPayload" = betterproto.message_field(1)
    wallet_id: str = betterproto.string_field(2)
    invoker: str = betterproto.string_field(3)
    capability: str = betterproto.string_field(4)
    invoker_jwk: bytes = betterproto.bytes_field(5)


@dataclass(eq=False, repr=False)
class GrantAccessRequest(betterproto.Message):
    wallet_id: str = betterproto.string_field(1)
    did: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class GrantAccessResponse(betterproto.Message):
    status: "__common_v1__.ResponseStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class RevokeAccessRequest(betterproto.Message):
    wallet_id: str = betterproto.string_field(1)
    did: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class RevokeAccessResponse(betterproto.Message):
    status: "__common_v1__.ResponseStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class GetProviderConfigurationRequest(betterproto.Message):
    request_options: "__common_v1__.RequestOptions" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetProviderConfigurationResponse(betterproto.Message):
    did_document: "__common_v1__.JsonPayload" = betterproto.message_field(1)
    key_agreement_key_id: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class SearchRequest(betterproto.Message):
    query: str = betterproto.string_field(1)
    continuation_token: str = betterproto.string_field(2)
    options: "__common_v1__.RequestOptions" = betterproto.message_field(5)


@dataclass(eq=False, repr=False)
class SearchResponse(betterproto.Message):
    items: List["__common_v1__.JsonPayload"] = betterproto.message_field(1)
    has_more: bool = betterproto.bool_field(2)
    count: int = betterproto.int32_field(3)
    continuation_token: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class InsertItemRequest(betterproto.Message):
    item: "__common_v1__.JsonPayload" = betterproto.message_field(1)
    item_type: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class InsertItemResponse(betterproto.Message):
    status: "__common_v1__.ResponseStatus" = betterproto.enum_field(1)
    item_id: str = betterproto.string_field(2)


class WalletStub(betterproto.ServiceStub):
    async def get_provider_configuration(
        self, *, request_options: "__common_v1__.RequestOptions" = None
    ) -> "GetProviderConfigurationResponse":

        request = GetProviderConfigurationRequest()
        if request_options is not None:
            request.request_options = request_options

        return await self._unary_unary(
            "/services.universalwallet.v1.Wallet/GetProviderConfiguration",
            request,
            GetProviderConfigurationResponse,
        )

    async def connect_external_identity(
        self, *, email: str = "", phone: str = ""
    ) -> "ConnectResponse":

        request = ConnectRequest()
        request.email = email
        request.phone = phone

        return await self._unary_unary(
            "/services.universalwallet.v1.Wallet/ConnectExternalIdentity",
            request,
            ConnectResponse,
        )

    async def create_wallet(
        self, *, controller: str = "", description: str = "", security_code: str = ""
    ) -> "CreateWalletResponse":

        request = CreateWalletRequest()
        request.controller = controller
        request.description = description
        request.security_code = security_code

        return await self._unary_unary(
            "/services.universalwallet.v1.Wallet/CreateWallet",
            request,
            CreateWalletResponse,
        )

    async def create_wallet_with_workflow(
        self, *, controller: str = "", description: str = "", security_code: str = ""
    ) -> "CreateWalletResponse":

        request = CreateWalletRequest()
        request.controller = controller
        request.description = description
        request.security_code = security_code

        return await self._unary_unary(
            "/services.universalwallet.v1.Wallet/CreateWalletWithWorkflow",
            request,
            CreateWalletResponse,
        )

    async def create_wallet_encrypted(
        self,
        *,
        iv: bytes = b"",
        aad: bytes = b"",
        ciphertext: bytes = b"",
        tag: bytes = b"",
        recipients: Optional[List["EncryptionRecipient"]] = None,
    ) -> "___pbmse_v1__.EncryptedMessage":
        recipients = recipients or []

        request = ___pbmse_v1__.EncryptedMessage()
        request.iv = iv
        request.aad = aad
        request.ciphertext = ciphertext
        request.tag = tag
        if recipients is not None:
            request.recipients = recipients

        return await self._unary_unary(
            "/services.universalwallet.v1.Wallet/CreateWalletEncrypted",
            request,
            ___pbmse_v1__.EncryptedMessage,
        )

    async def search(
        self,
        *,
        query: str = "",
        continuation_token: str = "",
        options: "__common_v1__.RequestOptions" = None,
    ) -> "SearchResponse":

        request = SearchRequest()
        request.query = query
        request.continuation_token = continuation_token
        if options is not None:
            request.options = options

        return await self._unary_unary(
            "/services.universalwallet.v1.Wallet/Search", request, SearchResponse
        )

    async def insert_item(
        self, *, item: "__common_v1__.JsonPayload" = None, item_type: str = ""
    ) -> "InsertItemResponse":

        request = InsertItemRequest()
        if item is not None:
            request.item = item
        request.item_type = item_type

        return await self._unary_unary(
            "/services.universalwallet.v1.Wallet/InsertItem",
            request,
            InsertItemResponse,
        )

    async def grant_access(
        self, *, wallet_id: str = "", did: str = ""
    ) -> "GrantAccessResponse":

        request = GrantAccessRequest()
        request.wallet_id = wallet_id
        request.did = did

        return await self._unary_unary(
            "/services.universalwallet.v1.Wallet/GrantAccess",
            request,
            GrantAccessResponse,
        )

    async def revoke_access(
        self, *, wallet_id: str = "", did: str = ""
    ) -> "RevokeAccessResponse":

        request = RevokeAccessRequest()
        request.wallet_id = wallet_id
        request.did = did

        return await self._unary_unary(
            "/services.universalwallet.v1.Wallet/RevokeAccess",
            request,
            RevokeAccessResponse,
        )


class WalletBase(ServiceBase):
    async def get_provider_configuration(
        self, request_options: "__common_v1__.RequestOptions"
    ) -> "GetProviderConfigurationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def connect_external_identity(
        self, email: str, phone: str
    ) -> "ConnectResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def create_wallet(
        self, controller: str, description: str, security_code: str
    ) -> "CreateWalletResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def create_wallet_with_workflow(
        self, controller: str, description: str, security_code: str
    ) -> "CreateWalletResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def create_wallet_encrypted(
        self,
        iv: bytes,
        aad: bytes,
        ciphertext: bytes,
        tag: bytes,
        recipients: Optional[List["EncryptionRecipient"]],
    ) -> "___pbmse_v1__.EncryptedMessage":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def search(
        self,
        query: str,
        continuation_token: str,
        options: "__common_v1__.RequestOptions",
    ) -> "SearchResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def insert_item(
        self, item: "__common_v1__.JsonPayload", item_type: str
    ) -> "InsertItemResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def grant_access(self, wallet_id: str, did: str) -> "GrantAccessResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def revoke_access(self, wallet_id: str, did: str) -> "RevokeAccessResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_get_provider_configuration(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "request_options": request.request_options,
        }

        response = await self.get_provider_configuration(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_connect_external_identity(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "email": request.email,
            "phone": request.phone,
        }

        response = await self.connect_external_identity(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_create_wallet(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "controller": request.controller,
            "description": request.description,
            "security_code": request.security_code,
        }

        response = await self.create_wallet(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_create_wallet_with_workflow(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "controller": request.controller,
            "description": request.description,
            "security_code": request.security_code,
        }

        response = await self.create_wallet_with_workflow(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_create_wallet_encrypted(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "iv": request.iv,
            "aad": request.aad,
            "ciphertext": request.ciphertext,
            "tag": request.tag,
            "recipients": request.recipients,
        }

        response = await self.create_wallet_encrypted(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_search(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "query": request.query,
            "continuation_token": request.continuation_token,
            "options": request.options,
        }

        response = await self.search(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_insert_item(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "item": request.item,
            "item_type": request.item_type,
        }

        response = await self.insert_item(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_grant_access(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "wallet_id": request.wallet_id,
            "did": request.did,
        }

        response = await self.grant_access(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_revoke_access(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "wallet_id": request.wallet_id,
            "did": request.did,
        }

        response = await self.revoke_access(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/services.universalwallet.v1.Wallet/GetProviderConfiguration": grpclib.const.Handler(
                self.__rpc_get_provider_configuration,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetProviderConfigurationRequest,
                GetProviderConfigurationResponse,
            ),
            "/services.universalwallet.v1.Wallet/ConnectExternalIdentity": grpclib.const.Handler(
                self.__rpc_connect_external_identity,
                grpclib.const.Cardinality.UNARY_UNARY,
                ConnectRequest,
                ConnectResponse,
            ),
            "/services.universalwallet.v1.Wallet/CreateWallet": grpclib.const.Handler(
                self.__rpc_create_wallet,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreateWalletRequest,
                CreateWalletResponse,
            ),
            "/services.universalwallet.v1.Wallet/CreateWalletWithWorkflow": grpclib.const.Handler(
                self.__rpc_create_wallet_with_workflow,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreateWalletRequest,
                CreateWalletResponse,
            ),
            "/services.universalwallet.v1.Wallet/CreateWalletEncrypted": grpclib.const.Handler(
                self.__rpc_create_wallet_encrypted,
                grpclib.const.Cardinality.UNARY_UNARY,
                ___pbmse_v1__.EncryptedMessage,
                ___pbmse_v1__.EncryptedMessage,
            ),
            "/services.universalwallet.v1.Wallet/Search": grpclib.const.Handler(
                self.__rpc_search,
                grpclib.const.Cardinality.UNARY_UNARY,
                SearchRequest,
                SearchResponse,
            ),
            "/services.universalwallet.v1.Wallet/InsertItem": grpclib.const.Handler(
                self.__rpc_insert_item,
                grpclib.const.Cardinality.UNARY_UNARY,
                InsertItemRequest,
                InsertItemResponse,
            ),
            "/services.universalwallet.v1.Wallet/GrantAccess": grpclib.const.Handler(
                self.__rpc_grant_access,
                grpclib.const.Cardinality.UNARY_UNARY,
                GrantAccessRequest,
                GrantAccessResponse,
            ),
            "/services.universalwallet.v1.Wallet/RevokeAccess": grpclib.const.Handler(
                self.__rpc_revoke_access,
                grpclib.const.Cardinality.UNARY_UNARY,
                RevokeAccessRequest,
                RevokeAccessResponse,
            ),
        }


from ....pbmse import v1 as ___pbmse_v1__
from ...common import v1 as __common_v1__
