"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualServiceProvider = exports.VirtualService = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const appmesh_generated_1 = require("./appmesh.generated");
const mesh_1 = require("./mesh");
/**
 * (experimental) VirtualService represents a service inside an AppMesh.
 *
 * It routes traffic either to a Virtual Node or to a Virtual Router.
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_services.html
 * @experimental
 */
class VirtualService extends cdk.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.virtualServiceName || cdk.Lazy.string({ produce: () => cdk.Names.uniqueId(this) }),
        });
        const providerConfig = props.virtualServiceProvider.bind(this);
        this.mesh = providerConfig.mesh;
        const svc = new appmesh_generated_1.CfnVirtualService(this, 'Resource', {
            meshName: this.mesh.meshName,
            virtualServiceName: this.physicalName,
            spec: {
                provider: providerConfig.virtualNodeProvider || providerConfig.virtualRouterProvider
                    ? {
                        virtualNode: providerConfig.virtualNodeProvider,
                        virtualRouter: providerConfig.virtualRouterProvider,
                    }
                    : undefined,
            },
        });
        this.virtualServiceName = this.getResourceNameAttribute(svc.attrVirtualServiceName);
        this.virtualServiceArn = this.getResourceArnAttribute(svc.ref, {
            service: 'appmesh',
            resource: `mesh/${this.mesh.meshName}/virtualService`,
            resourceName: this.physicalName,
        });
    }
    /**
     * (experimental) Import an existing VirtualService given an ARN.
     *
     * @experimental
     */
    static fromVirtualServiceArn(scope, id, virtualServiceArn) {
        return new class extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.virtualServiceArn = virtualServiceArn;
                this.parsedArn = cdk.Fn.split('/', cdk.Stack.of(scope).parseArn(virtualServiceArn).resourceName);
                this.virtualServiceName = cdk.Fn.select(2, this.parsedArn);
                this.mesh = mesh_1.Mesh.fromMeshName(this, 'Mesh', cdk.Fn.select(0, this.parsedArn));
            }
        }(scope, id);
    }
    /**
     * (experimental) Import an existing VirtualService given its attributes.
     *
     * @experimental
     */
    static fromVirtualServiceAttributes(scope, id, attrs) {
        return new class extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.virtualServiceName = attrs.virtualServiceName;
                this.mesh = attrs.mesh;
                this.virtualServiceArn = cdk.Stack.of(this).formatArn({
                    service: 'appmesh',
                    resource: `mesh/${attrs.mesh.meshName}/virtualService`,
                    resourceName: this.virtualServiceName,
                });
            }
        }(scope, id);
    }
}
exports.VirtualService = VirtualService;
_a = JSII_RTTI_SYMBOL_1;
VirtualService[_a] = { fqn: "@aws-cdk/aws-appmesh.VirtualService", version: "1.106.0" };
/**
 * (experimental) Represents the properties needed to define the provider for a VirtualService.
 *
 * @experimental
 */
class VirtualServiceProvider {
    /**
     * (experimental) Returns a VirtualNode based Provider for a VirtualService.
     *
     * @experimental
     */
    static virtualNode(virtualNode) {
        return new VirtualServiceProviderImpl(virtualNode, undefined);
    }
    /**
     * (experimental) Returns a VirtualRouter based Provider for a VirtualService.
     *
     * @experimental
     */
    static virtualRouter(virtualRouter) {
        return new VirtualServiceProviderImpl(undefined, virtualRouter);
    }
    /**
     * (experimental) Returns an Empty Provider for a VirtualService.
     *
     * This provides no routing capabilities
     * and should only be used as a placeholder
     *
     * @experimental
     */
    static none(mesh) {
        return new VirtualServiceProviderImpl(undefined, undefined, mesh);
    }
}
exports.VirtualServiceProvider = VirtualServiceProvider;
_b = JSII_RTTI_SYMBOL_1;
VirtualServiceProvider[_b] = { fqn: "@aws-cdk/aws-appmesh.VirtualServiceProvider", version: "1.106.0" };
class VirtualServiceProviderImpl extends VirtualServiceProvider {
    constructor(virtualNode, virtualRouter, mesh) {
        var _c, _d, _e, _f;
        super();
        this.virtualNode = virtualNode;
        this.virtualRouter = virtualRouter;
        const providedMesh = (_f = (_d = (_c = this.virtualNode) === null || _c === void 0 ? void 0 : _c.mesh) !== null && _d !== void 0 ? _d : (_e = this.virtualRouter) === null || _e === void 0 ? void 0 : _e.mesh) !== null && _f !== void 0 ? _f : mesh;
        this.mesh = providedMesh;
    }
    bind(_construct) {
        return {
            mesh: this.mesh,
            virtualNodeProvider: this.virtualNode
                ? {
                    virtualNodeName: this.virtualNode.virtualNodeName,
                }
                : undefined,
            virtualRouterProvider: this.virtualRouter
                ? {
                    virtualRouterName: this.virtualRouter.virtualRouterName,
                }
                : undefined,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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