"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RouteSpec = exports.GrpcRetryEvent = exports.TcpRetryEvent = exports.HttpRetryEvent = exports.HttpHeaderMatch = exports.HttpRouteProtocol = exports.HttpRouteMatchMethod = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * (experimental) Supported values for matching routes based on the HTTP request method.
 *
 * @experimental
 */
var HttpRouteMatchMethod;
(function (HttpRouteMatchMethod) {
    HttpRouteMatchMethod["GET"] = "GET";
    HttpRouteMatchMethod["HEAD"] = "HEAD";
    HttpRouteMatchMethod["POST"] = "POST";
    HttpRouteMatchMethod["PUT"] = "PUT";
    HttpRouteMatchMethod["DELETE"] = "DELETE";
    HttpRouteMatchMethod["CONNECT"] = "CONNECT";
    HttpRouteMatchMethod["OPTIONS"] = "OPTIONS";
    HttpRouteMatchMethod["TRACE"] = "TRACE";
    HttpRouteMatchMethod["PATCH"] = "PATCH";
})(HttpRouteMatchMethod = exports.HttpRouteMatchMethod || (exports.HttpRouteMatchMethod = {}));
/**
 * (experimental) Supported :scheme options for HTTP2.
 *
 * @experimental
 */
var HttpRouteProtocol;
(function (HttpRouteProtocol) {
    HttpRouteProtocol["HTTP"] = "http";
    HttpRouteProtocol["HTTPS"] = "https";
})(HttpRouteProtocol = exports.HttpRouteProtocol || (exports.HttpRouteProtocol = {}));
/**
 * (experimental) Used to generate header matching methods.
 *
 * @experimental
 */
class HttpHeaderMatch {
    /**
     * (experimental) The value of the header with the given name in the request must match the specified value exactly.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param headerValue The exact value to test against.
     * @experimental
     */
    static valueIs(headerName, headerValue) {
        return new HeaderMatchImpl(headerName, false, { exact: headerValue });
    }
    /**
     * (experimental) The value of the header with the given name in the request must not match the specified value exactly.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param headerValue The exact value to test against.
     * @experimental
     */
    static valueIsNot(headerName, headerValue) {
        return new HeaderMatchImpl(headerName, true, { exact: headerValue });
    }
    /**
     * (experimental) The value of the header with the given name in the request must start with the specified characters.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param prefix The prefix to test against.
     * @experimental
     */
    static valueStartsWith(headerName, prefix) {
        return new HeaderMatchImpl(headerName, false, { prefix });
    }
    /**
     * (experimental) The value of the header with the given name in the request must not start with the specified characters.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param prefix The prefix to test against.
     * @experimental
     */
    static valueDoesNotStartWith(headerName, prefix) {
        return new HeaderMatchImpl(headerName, true, { prefix });
    }
    /**
     * (experimental) The value of the header with the given name in the request must end with the specified characters.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param suffix The suffix to test against.
     * @experimental
     */
    static valueEndsWith(headerName, suffix) {
        return new HeaderMatchImpl(headerName, false, { suffix });
    }
    /**
     * (experimental) The value of the header with the given name in the request must not end with the specified characters.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param suffix The suffix to test against.
     * @experimental
     */
    static valueDoesNotEndWith(headerName, suffix) {
        return new HeaderMatchImpl(headerName, true, { suffix });
    }
    /**
     * (experimental) The value of the header with the given name in the request must include the specified characters.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param regex The regex to test against.
     * @experimental
     */
    static valueMatchesRegex(headerName, regex) {
        return new HeaderMatchImpl(headerName, false, { regex });
    }
    /**
     * (experimental) The value of the header with the given name in the request must not include the specified characters.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param regex The regex to test against.
     * @experimental
     */
    static valueDoesNotMatchRegex(headerName, regex) {
        return new HeaderMatchImpl(headerName, true, { regex });
    }
    /**
     * (experimental) The value of the header with the given name in the request must be in a range of values.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param start Match on values starting at and including this value.
     * @param end Match on values up to but not including this value.
     * @experimental
     */
    static valuesIsInRange(headerName, start, end) {
        return new HeaderMatchImpl(headerName, false, {
            range: {
                start,
                end,
            },
        });
    }
    /**
     * (experimental) The value of the header with the given name in the request must not be in a range of values.
     *
     * @param headerName the name of the HTTP header to match against.
     * @param start Match on values starting at and including this value.
     * @param end Match on values up to but not including this value.
     * @experimental
     */
    static valuesIsNotInRange(headerName, start, end) {
        return new HeaderMatchImpl(headerName, true, {
            range: {
                start,
                end,
            },
        });
    }
}
exports.HttpHeaderMatch = HttpHeaderMatch;
_a = JSII_RTTI_SYMBOL_1;
HttpHeaderMatch[_a] = { fqn: "@aws-cdk/aws-appmesh.HttpHeaderMatch", version: "1.106.0" };
class HeaderMatchImpl extends HttpHeaderMatch {
    constructor(headerName, invert, matchProperty) {
        super();
        this.headerName = headerName;
        this.invert = invert;
        this.matchProperty = matchProperty;
    }
    bind(_scope) {
        return {
            httpRouteHeader: {
                name: this.headerName,
                invert: this.invert,
                match: this.matchProperty,
            },
        };
    }
}
/**
 * (experimental) HTTP events on which to retry.
 *
 * @experimental
 */
var HttpRetryEvent;
(function (HttpRetryEvent) {
    HttpRetryEvent["SERVER_ERROR"] = "server-error";
    HttpRetryEvent["GATEWAY_ERROR"] = "gateway-error";
    HttpRetryEvent["CLIENT_ERROR"] = "client-error";
    HttpRetryEvent["STREAM_ERROR"] = "stream-error";
})(HttpRetryEvent = exports.HttpRetryEvent || (exports.HttpRetryEvent = {}));
/**
 * TCP events on which you may retry
 */
var TcpRetryEvent;
(function (TcpRetryEvent) {
    TcpRetryEvent["CONNECTION_ERROR"] = "connection-error";
})(TcpRetryEvent = exports.TcpRetryEvent || (exports.TcpRetryEvent = {}));
/**
 * (experimental) gRPC events.
 *
 * @experimental
 */
var GrpcRetryEvent;
(function (GrpcRetryEvent) {
    GrpcRetryEvent["CANCELLED"] = "cancelled";
    GrpcRetryEvent["DEADLINE_EXCEEDED"] = "deadline-exceeded";
    GrpcRetryEvent["INTERNAL_ERROR"] = "internal";
    GrpcRetryEvent["RESOURCE_EXHAUSTED"] = "resource-exhausted";
    GrpcRetryEvent["UNAVAILABLE"] = "unavailable";
})(GrpcRetryEvent = exports.GrpcRetryEvent || (exports.GrpcRetryEvent = {}));
/**
 * (experimental) Used to generate specs with different protocols for a RouteSpec.
 *
 * @experimental
 */
class RouteSpec {
    /**
     * (experimental) Creates an HTTP Based RouteSpec.
     *
     * @experimental
     */
    static http(options) {
        return new HttpRouteSpec(options, shared_interfaces_1.Protocol.HTTP);
    }
    /**
     * (experimental) Creates an HTTP2 Based RouteSpec.
     *
     * @experimental
     */
    static http2(options) {
        return new HttpRouteSpec(options, shared_interfaces_1.Protocol.HTTP2);
    }
    /**
     * (experimental) Creates a TCP Based RouteSpec.
     *
     * @experimental
     */
    static tcp(options) {
        return new TcpRouteSpec(options);
    }
    /**
     * (experimental) Creates a GRPC Based RouteSpec.
     *
     * @experimental
     */
    static grpc(options) {
        return new GrpcRouteSpec(options);
    }
}
exports.RouteSpec = RouteSpec;
_b = JSII_RTTI_SYMBOL_1;
RouteSpec[_b] = { fqn: "@aws-cdk/aws-appmesh.RouteSpec", version: "1.106.0" };
class HttpRouteSpec extends RouteSpec {
    constructor(props, protocol) {
        var _c, _d;
        super();
        this.protocol = protocol;
        this.match = props.match;
        this.weightedTargets = props.weightedTargets;
        this.timeout = props.timeout;
        this.priority = props.priority;
        if (props.retryPolicy) {
            const httpRetryEvents = (_c = props.retryPolicy.httpRetryEvents) !== null && _c !== void 0 ? _c : [];
            const tcpRetryEvents = (_d = props.retryPolicy.tcpRetryEvents) !== null && _d !== void 0 ? _d : [];
            if (httpRetryEvents.length + tcpRetryEvents.length === 0) {
                throw new Error('You must specify one value for at least one of `httpRetryEvents` or `tcpRetryEvents`');
            }
            this.retryPolicy = {
                ...props.retryPolicy,
                httpRetryEvents: httpRetryEvents.length > 0 ? httpRetryEvents : undefined,
                tcpRetryEvents: tcpRetryEvents.length > 0 ? tcpRetryEvents : undefined,
            };
        }
    }
    bind(scope) {
        var _c, _d, _e, _f;
        const prefixPath = this.match ? this.match.prefixPath : '/';
        if (prefixPath[0] != '/') {
            throw new Error(`Prefix Path must start with \'/\', got: ${prefixPath}`);
        }
        const httpConfig = {
            action: {
                weightedTargets: renderWeightedTargets(this.weightedTargets),
            },
            match: {
                prefix: prefixPath,
                headers: (_d = (_c = this.match) === null || _c === void 0 ? void 0 : _c.headers) === null || _d === void 0 ? void 0 : _d.map(header => header.bind(scope).httpRouteHeader),
                method: (_e = this.match) === null || _e === void 0 ? void 0 : _e.method,
                scheme: (_f = this.match) === null || _f === void 0 ? void 0 : _f.protocol,
            },
            timeout: renderTimeout(this.timeout),
            retryPolicy: this.retryPolicy ? renderHttpRetryPolicy(this.retryPolicy) : undefined,
        };
        return {
            priority: this.priority,
            httpRouteSpec: this.protocol === shared_interfaces_1.Protocol.HTTP ? httpConfig : undefined,
            http2RouteSpec: this.protocol === shared_interfaces_1.Protocol.HTTP2 ? httpConfig : undefined,
        };
    }
}
class TcpRouteSpec extends RouteSpec {
    constructor(props) {
        super();
        this.weightedTargets = props.weightedTargets;
        this.timeout = props.timeout;
        this.priority = props.priority;
    }
    bind(_scope) {
        return {
            priority: this.priority,
            tcpRouteSpec: {
                action: {
                    weightedTargets: renderWeightedTargets(this.weightedTargets),
                },
                timeout: renderTimeout(this.timeout),
            },
        };
    }
}
class GrpcRouteSpec extends RouteSpec {
    constructor(props) {
        var _c, _d, _e;
        super();
        this.weightedTargets = props.weightedTargets;
        this.match = props.match;
        this.timeout = props.timeout;
        this.priority = props.priority;
        if (props.retryPolicy) {
            const grpcRetryEvents = (_c = props.retryPolicy.grpcRetryEvents) !== null && _c !== void 0 ? _c : [];
            const httpRetryEvents = (_d = props.retryPolicy.httpRetryEvents) !== null && _d !== void 0 ? _d : [];
            const tcpRetryEvents = (_e = props.retryPolicy.tcpRetryEvents) !== null && _e !== void 0 ? _e : [];
            if (grpcRetryEvents.length + httpRetryEvents.length + tcpRetryEvents.length === 0) {
                throw new Error('You must specify one value for at least one of `grpcRetryEvents`, `httpRetryEvents` or `tcpRetryEvents`');
            }
            this.retryPolicy = {
                ...props.retryPolicy,
                grpcRetryEvents: grpcRetryEvents.length > 0 ? grpcRetryEvents : undefined,
                httpRetryEvents: httpRetryEvents.length > 0 ? httpRetryEvents : undefined,
                tcpRetryEvents: tcpRetryEvents.length > 0 ? tcpRetryEvents : undefined,
            };
        }
    }
    bind(_scope) {
        return {
            priority: this.priority,
            grpcRouteSpec: {
                action: {
                    weightedTargets: renderWeightedTargets(this.weightedTargets),
                },
                match: {
                    serviceName: this.match.serviceName,
                },
                timeout: renderTimeout(this.timeout),
                retryPolicy: this.retryPolicy ? renderGrpcRetryPolicy(this.retryPolicy) : undefined,
            },
        };
    }
}
/**
* Utility method to add weighted route targets to an existing route
*/
function renderWeightedTargets(weightedTargets) {
    const renderedTargets = [];
    for (const t of weightedTargets) {
        renderedTargets.push({
            virtualNode: t.virtualNode.virtualNodeName,
            weight: t.weight || 1,
        });
    }
    return renderedTargets;
}
/**
 * Utility method to construct a route timeout object
 */
function renderTimeout(timeout) {
    return timeout
        ? {
            idle: (timeout === null || timeout === void 0 ? void 0 : timeout.idle) !== undefined
                ? {
                    unit: 'ms',
                    value: timeout === null || timeout === void 0 ? void 0 : timeout.idle.toMilliseconds(),
                }
                : undefined,
            perRequest: (timeout === null || timeout === void 0 ? void 0 : timeout.perRequest) !== undefined
                ? {
                    unit: 'ms',
                    value: timeout === null || timeout === void 0 ? void 0 : timeout.perRequest.toMilliseconds(),
                }
                : undefined,
        }
        : undefined;
}
function renderHttpRetryPolicy(retryPolicy) {
    return {
        maxRetries: retryPolicy.retryAttempts,
        perRetryTimeout: {
            unit: 'ms',
            value: retryPolicy.retryTimeout.toMilliseconds(),
        },
        httpRetryEvents: retryPolicy.httpRetryEvents,
        tcpRetryEvents: retryPolicy.tcpRetryEvents,
    };
}
function renderGrpcRetryPolicy(retryPolicy) {
    return {
        ...renderHttpRetryPolicy(retryPolicy),
        grpcRetryEvents: retryPolicy.grpcRetryEvents,
    };
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicm91dGUtc3BlYy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInJvdXRlLXNwZWMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFFQSwyREFBcUY7Ozs7OztBQThEckYsSUFBWSxvQkE2Q1g7QUE3Q0QsV0FBWSxvQkFBb0I7SUFJOUIsbUNBQVcsQ0FBQTtJQUtYLHFDQUFhLENBQUE7SUFLYixxQ0FBYSxDQUFBO0lBS2IsbUNBQVcsQ0FBQTtJQUtYLHlDQUFpQixDQUFBO0lBS2pCLDJDQUFtQixDQUFBO0lBS25CLDJDQUFtQixDQUFBO0lBS25CLHVDQUFlLENBQUE7SUFLZix1Q0FBZSxDQUFBO0FBQ2pCLENBQUMsRUE3Q1csb0JBQW9CLEdBQXBCLDRCQUFvQixLQUFwQiw0QkFBb0IsUUE2Qy9COzs7Ozs7QUFLRCxJQUFZLGlCQVVYO0FBVkQsV0FBWSxpQkFBaUI7SUFJM0Isa0NBQWEsQ0FBQTtJQUtiLG9DQUFlLENBQUE7QUFDakIsQ0FBQyxFQVZXLGlCQUFpQixHQUFqQix5QkFBaUIsS0FBakIseUJBQWlCLFFBVTVCOzs7Ozs7QUFlRCxNQUFzQixlQUFlOzs7Ozs7OztJQVFuQyxNQUFNLENBQUMsT0FBTyxDQUFDLFVBQWtCLEVBQUUsV0FBbUI7UUFDcEQsT0FBTyxJQUFJLGVBQWUsQ0FBQyxVQUFVLEVBQUUsS0FBSyxFQUFFLEVBQUUsS0FBSyxFQUFFLFdBQVcsRUFBRSxDQUFDLENBQUM7SUFDeEUsQ0FBQzs7Ozs7Ozs7SUFTRCxNQUFNLENBQUMsVUFBVSxDQUFDLFVBQWtCLEVBQUUsV0FBbUI7UUFDdkQsT0FBTyxJQUFJLGVBQWUsQ0FBQyxVQUFVLEVBQUUsSUFBSSxFQUFFLEVBQUUsS0FBSyxFQUFFLFdBQVcsRUFBRSxDQUFDLENBQUM7SUFDdkUsQ0FBQzs7Ozs7Ozs7SUFTRCxNQUFNLENBQUMsZUFBZSxDQUFDLFVBQWtCLEVBQUUsTUFBYztRQUN2RCxPQUFPLElBQUksZUFBZSxDQUFDLFVBQVUsRUFBRSxLQUFLLEVBQUUsRUFBRSxNQUFNLEVBQUUsQ0FBQyxDQUFDO0lBQzVELENBQUM7Ozs7Ozs7O0lBU0QsTUFBTSxDQUFDLHFCQUFxQixDQUFDLFVBQWtCLEVBQUUsTUFBYztRQUM3RCxPQUFPLElBQUksZUFBZSxDQUFDLFVBQVUsRUFBRSxJQUFJLEVBQUUsRUFBRSxNQUFNLEVBQUUsQ0FBQyxDQUFDO0lBQzNELENBQUM7Ozs7Ozs7O0lBU0QsTUFBTSxDQUFDLGFBQWEsQ0FBQyxVQUFrQixFQUFFLE1BQWM7UUFDckQsT0FBTyxJQUFJLGVBQWUsQ0FBQyxVQUFVLEVBQUUsS0FBSyxFQUFFLEVBQUUsTUFBTSxFQUFFLENBQUMsQ0FBQztJQUM1RCxDQUFDOzs7Ozs7OztJQVNELE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxVQUFrQixFQUFFLE1BQWM7UUFDM0QsT0FBTyxJQUFJLGVBQWUsQ0FBQyxVQUFVLEVBQUUsSUFBSSxFQUFFLEVBQUUsTUFBTSxFQUFFLENBQUMsQ0FBQztJQUMzRCxDQUFDOzs7Ozs7OztJQVNELE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQyxVQUFrQixFQUFFLEtBQWE7UUFDeEQsT0FBTyxJQUFJLGVBQWUsQ0FBQyxVQUFVLEVBQUUsS0FBSyxFQUFFLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQztJQUMzRCxDQUFDOzs7Ozs7OztJQVNELE1BQU0sQ0FBQyxzQkFBc0IsQ0FBQyxVQUFrQixFQUFFLEtBQWE7UUFDN0QsT0FBTyxJQUFJLGVBQWUsQ0FBQyxVQUFVLEVBQUUsSUFBSSxFQUFFLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQztJQUMxRCxDQUFDOzs7Ozs7Ozs7SUFVRCxNQUFNLENBQUMsZUFBZSxDQUFDLFVBQWtCLEVBQUUsS0FBYSxFQUFFLEdBQVc7UUFDbkUsT0FBTyxJQUFJLGVBQWUsQ0FBQyxVQUFVLEVBQUUsS0FBSyxFQUFFO1lBQzVDLEtBQUssRUFBRTtnQkFDTCxLQUFLO2dCQUNMLEdBQUc7YUFDSjtTQUNGLENBQUMsQ0FBQztJQUNMLENBQUM7Ozs7Ozs7OztJQVVELE1BQU0sQ0FBQyxrQkFBa0IsQ0FBQyxVQUFrQixFQUFFLEtBQWEsRUFBRSxHQUFXO1FBQ3RFLE9BQU8sSUFBSSxlQUFlLENBQUMsVUFBVSxFQUFFLElBQUksRUFBRTtZQUMzQyxLQUFLLEVBQUU7Z0JBQ0wsS0FBSztnQkFDTCxHQUFHO2FBQ0o7U0FDRixDQUFDLENBQUM7SUFDTCxDQUFDOztBQXpISCwwQ0ErSEM7OztBQUVELE1BQU0sZUFBZ0IsU0FBUSxlQUFlO0lBQzNDLFlBQ21CLFVBQWtCLEVBQ2xCLE1BQWUsRUFDZixhQUFpRDtRQUVsRSxLQUFLLEVBQUUsQ0FBQztRQUpTLGVBQVUsR0FBVixVQUFVLENBQVE7UUFDbEIsV0FBTSxHQUFOLE1BQU0sQ0FBUztRQUNmLGtCQUFhLEdBQWIsYUFBYSxDQUFvQztJQUdwRSxDQUFDO0lBRUQsSUFBSSxDQUFDLE1BQWlCO1FBQ3BCLE9BQU87WUFDTCxlQUFlLEVBQUU7Z0JBQ2YsSUFBSSxFQUFFLElBQUksQ0FBQyxVQUFVO2dCQUNyQixNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU07Z0JBQ25CLEtBQUssRUFBRSxJQUFJLENBQUMsYUFBYTthQUMxQjtTQUNGLENBQUM7SUFDSixDQUFDO0NBQ0Y7Ozs7OztBQTRGRCxJQUFZLGNBb0JYO0FBcEJELFdBQVksY0FBYztJQUl4QiwrQ0FBNkIsQ0FBQTtJQUs3QixpREFBK0IsQ0FBQTtJQUsvQiwrQ0FBNkIsQ0FBQTtJQUs3QiwrQ0FBNkIsQ0FBQTtBQUMvQixDQUFDLEVBcEJXLGNBQWMsR0FBZCxzQkFBYyxLQUFkLHNCQUFjLFFBb0J6QjtBQUVEOztHQUVHO0FBQ0gsSUFBWSxhQUtYO0FBTEQsV0FBWSxhQUFhO0lBSXZCLHNEQUFxQyxDQUFBO0FBQ3ZDLENBQUMsRUFMVyxhQUFhLEdBQWIscUJBQWEsS0FBYixxQkFBYSxRQUt4Qjs7Ozs7O0FBOERELElBQVksY0FtQ1g7QUFuQ0QsV0FBWSxjQUFjO0lBTXhCLHlDQUF1QixDQUFBO0lBT3ZCLHlEQUF1QyxDQUFBO0lBT3ZDLDZDQUEyQixDQUFBO0lBTzNCLDJEQUF5QyxDQUFBO0lBT3pDLDZDQUEyQixDQUFBO0FBQzdCLENBQUMsRUFuQ1csY0FBYyxHQUFkLHNCQUFjLEtBQWQsc0JBQWMsUUFtQ3pCOzs7Ozs7QUE4Q0QsTUFBc0IsU0FBUzs7Ozs7O0lBSXRCLE1BQU0sQ0FBQyxJQUFJLENBQUMsT0FBNkI7UUFDOUMsT0FBTyxJQUFJLGFBQWEsQ0FBQyxPQUFPLEVBQUUsNEJBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUNuRCxDQUFDOzs7Ozs7SUFNTSxNQUFNLENBQUMsS0FBSyxDQUFDLE9BQTZCO1FBQy9DLE9BQU8sSUFBSSxhQUFhLENBQUMsT0FBTyxFQUFFLDRCQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDcEQsQ0FBQzs7Ozs7O0lBS00sTUFBTSxDQUFDLEdBQUcsQ0FBQyxPQUE0QjtRQUM1QyxPQUFPLElBQUksWUFBWSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0lBQ25DLENBQUM7Ozs7OztJQUtNLE1BQU0sQ0FBQyxJQUFJLENBQUMsT0FBNkI7UUFDOUMsT0FBTyxJQUFJLGFBQWEsQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUNwQyxDQUFDOztBQTVCSCw4QkFtQ0M7OztBQUVELE1BQU0sYUFBYyxTQUFRLFNBQVM7SUFhbkMsWUFBWSxLQUEyQixFQUFFLFFBQWtCOztRQUN6RCxLQUFLLEVBQUUsQ0FBQztRQUNSLElBQUksQ0FBQyxRQUFRLEdBQUcsUUFBUSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDLEtBQUssQ0FBQztRQUN6QixJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQyxlQUFlLENBQUM7UUFDN0MsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBQzdCLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUUvQixJQUFJLEtBQUssQ0FBQyxXQUFXLEVBQUU7WUFDckIsTUFBTSxlQUFlLFNBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQyxlQUFlLG1DQUFJLEVBQUUsQ0FBQztZQUNoRSxNQUFNLGNBQWMsU0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDLGNBQWMsbUNBQUksRUFBRSxDQUFDO1lBRTlELElBQUksZUFBZSxDQUFDLE1BQU0sR0FBRyxjQUFjLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRTtnQkFDeEQsTUFBTSxJQUFJLEtBQUssQ0FBQyxzRkFBc0YsQ0FBQyxDQUFDO2FBQ3pHO1lBRUQsSUFBSSxDQUFDLFdBQVcsR0FBRztnQkFDakIsR0FBRyxLQUFLLENBQUMsV0FBVztnQkFDcEIsZUFBZSxFQUFFLGVBQWUsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFDLFNBQVM7Z0JBQ3pFLGNBQWMsRUFBRSxjQUFjLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxTQUFTO2FBQ3ZFLENBQUM7U0FDSDtJQUNILENBQUM7SUFFTSxJQUFJLENBQUMsS0FBZ0I7O1FBQzFCLE1BQU0sVUFBVSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQUM7UUFDNUQsSUFBSSxVQUFVLENBQUMsQ0FBQyxDQUFDLElBQUksR0FBRyxFQUFFO1lBQ3hCLE1BQU0sSUFBSSxLQUFLLENBQUMsMkNBQTJDLFVBQVUsRUFBRSxDQUFDLENBQUM7U0FDMUU7UUFFRCxNQUFNLFVBQVUsR0FBK0I7WUFDN0MsTUFBTSxFQUFFO2dCQUNOLGVBQWUsRUFBRSxxQkFBcUIsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDO2FBQzdEO1lBQ0QsS0FBSyxFQUFFO2dCQUNMLE1BQU0sRUFBRSxVQUFVO2dCQUNsQixPQUFPLGNBQUUsSUFBSSxDQUFDLEtBQUssMENBQUUsT0FBTywwQ0FBRSxHQUFHLENBQUMsTUFBTSxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLGVBQWUsQ0FBQztnQkFDL0UsTUFBTSxRQUFFLElBQUksQ0FBQyxLQUFLLDBDQUFFLE1BQU07Z0JBQzFCLE1BQU0sUUFBRSxJQUFJLENBQUMsS0FBSywwQ0FBRSxRQUFRO2FBQzdCO1lBQ0QsT0FBTyxFQUFFLGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDO1lBQ3BDLFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVM7U0FDcEYsQ0FBQztRQUNGLE9BQU87WUFDTCxRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDdkIsYUFBYSxFQUFFLElBQUksQ0FBQyxRQUFRLEtBQUssNEJBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsU0FBUztZQUN2RSxjQUFjLEVBQUUsSUFBSSxDQUFDLFFBQVEsS0FBSyw0QkFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxTQUFTO1NBQzFFLENBQUM7SUFDSixDQUFDO0NBQ0Y7QUFFRCxNQUFNLFlBQWEsU0FBUSxTQUFTO0lBZ0JsQyxZQUFZLEtBQTBCO1FBQ3BDLEtBQUssRUFBRSxDQUFDO1FBQ1IsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUMsZUFBZSxDQUFDO1FBQzdDLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUM3QixJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7SUFDakMsQ0FBQztJQUVNLElBQUksQ0FBQyxNQUFpQjtRQUMzQixPQUFPO1lBQ0wsUUFBUSxFQUFFLElBQUksQ0FBQyxRQUFRO1lBQ3ZCLFlBQVksRUFBRTtnQkFDWixNQUFNLEVBQUU7b0JBQ04sZUFBZSxFQUFFLHFCQUFxQixDQUFDLElBQUksQ0FBQyxlQUFlLENBQUM7aUJBQzdEO2dCQUNELE9BQU8sRUFBRSxhQUFhLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQzthQUNyQztTQUNGLENBQUM7SUFDSixDQUFDO0NBQ0Y7QUFFRCxNQUFNLGFBQWMsU0FBUSxTQUFTO0lBZW5DLFlBQVksS0FBMkI7O1FBQ3JDLEtBQUssRUFBRSxDQUFDO1FBQ1IsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUMsZUFBZSxDQUFDO1FBQzdDLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDLEtBQUssQ0FBQztRQUN6QixJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUM7UUFDN0IsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1FBRS9CLElBQUksS0FBSyxDQUFDLFdBQVcsRUFBRTtZQUNyQixNQUFNLGVBQWUsU0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDLGVBQWUsbUNBQUksRUFBRSxDQUFDO1lBQ2hFLE1BQU0sZUFBZSxTQUFHLEtBQUssQ0FBQyxXQUFXLENBQUMsZUFBZSxtQ0FBSSxFQUFFLENBQUM7WUFDaEUsTUFBTSxjQUFjLFNBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQyxjQUFjLG1DQUFJLEVBQUUsQ0FBQztZQUU5RCxJQUFJLGVBQWUsQ0FBQyxNQUFNLEdBQUcsZUFBZSxDQUFDLE1BQU0sR0FBRyxjQUFjLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRTtnQkFDakYsTUFBTSxJQUFJLEtBQUssQ0FBQyx5R0FBeUcsQ0FBQyxDQUFDO2FBQzVIO1lBRUQsSUFBSSxDQUFDLFdBQVcsR0FBRztnQkFDakIsR0FBRyxLQUFLLENBQUMsV0FBVztnQkFDcEIsZUFBZSxFQUFFLGVBQWUsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFDLFNBQVM7Z0JBQ3pFLGVBQWUsRUFBRSxlQUFlLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQyxTQUFTO2dCQUN6RSxjQUFjLEVBQUUsY0FBYyxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsU0FBUzthQUN2RSxDQUFDO1NBQ0g7SUFDSCxDQUFDO0lBRU0sSUFBSSxDQUFDLE1BQWlCO1FBQzNCLE9BQU87WUFDTCxRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDdkIsYUFBYSxFQUFFO2dCQUNiLE1BQU0sRUFBRTtvQkFDTixlQUFlLEVBQUUscUJBQXFCLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQztpQkFDN0Q7Z0JBQ0QsS0FBSyxFQUFFO29CQUNMLFdBQVcsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVc7aUJBQ3BDO2dCQUNELE9BQU8sRUFBRSxhQUFhLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQztnQkFDcEMsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLHFCQUFxQixDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUzthQUNwRjtTQUNGLENBQUM7SUFDSixDQUFDO0NBQ0Y7QUFFRDs7RUFFRTtBQUNGLFNBQVMscUJBQXFCLENBQUMsZUFBaUM7SUFDOUQsTUFBTSxlQUFlLEdBQXNDLEVBQUUsQ0FBQztJQUM5RCxLQUFLLE1BQU0sQ0FBQyxJQUFJLGVBQWUsRUFBRTtRQUMvQixlQUFlLENBQUMsSUFBSSxDQUFDO1lBQ25CLFdBQVcsRUFBRSxDQUFDLENBQUMsV0FBVyxDQUFDLGVBQWU7WUFDMUMsTUFBTSxFQUFFLENBQUMsQ0FBQyxNQUFNLElBQUksQ0FBQztTQUN0QixDQUFDLENBQUM7S0FDSjtJQUNELE9BQU8sZUFBZSxDQUFDO0FBQ3pCLENBQUM7QUFFRDs7R0FFRztBQUNILFNBQVMsYUFBYSxDQUFDLE9BQXFCO0lBQzFDLE9BQU8sT0FBTztRQUNaLENBQUMsQ0FBQztZQUNBLElBQUksRUFBRSxDQUFBLE9BQU8sYUFBUCxPQUFPLHVCQUFQLE9BQU8sQ0FBRSxJQUFJLE1BQUssU0FBUztnQkFDL0IsQ0FBQyxDQUFDO29CQUNBLElBQUksRUFBRSxJQUFJO29CQUNWLEtBQUssRUFBRSxPQUFPLGFBQVAsT0FBTyx1QkFBUCxPQUFPLENBQUUsSUFBSSxDQUFDLGNBQWMsRUFBRTtpQkFDdEM7Z0JBQ0QsQ0FBQyxDQUFDLFNBQVM7WUFDYixVQUFVLEVBQUUsQ0FBQSxPQUFPLGFBQVAsT0FBTyx1QkFBUCxPQUFPLENBQUUsVUFBVSxNQUFLLFNBQVM7Z0JBQzNDLENBQUMsQ0FBQztvQkFDQSxJQUFJLEVBQUUsSUFBSTtvQkFDVixLQUFLLEVBQUUsT0FBTyxhQUFQLE9BQU8sdUJBQVAsT0FBTyxDQUFFLFVBQVUsQ0FBQyxjQUFjLEVBQUU7aUJBQzVDO2dCQUNELENBQUMsQ0FBQyxTQUFTO1NBQ2Q7UUFDRCxDQUFDLENBQUMsU0FBUyxDQUFDO0FBQ2hCLENBQUM7QUFFRCxTQUFTLHFCQUFxQixDQUFDLFdBQTRCO0lBQ3pELE9BQU87UUFDTCxVQUFVLEVBQUUsV0FBVyxDQUFDLGFBQWE7UUFDckMsZUFBZSxFQUFFO1lBQ2YsSUFBSSxFQUFFLElBQUk7WUFDVixLQUFLLEVBQUUsV0FBVyxDQUFDLFlBQVksQ0FBQyxjQUFjLEVBQUU7U0FDakQ7UUFDRCxlQUFlLEVBQUUsV0FBVyxDQUFDLGVBQWU7UUFDNUMsY0FBYyxFQUFFLFdBQVcsQ0FBQyxjQUFjO0tBQzNDLENBQUM7QUFDSixDQUFDO0FBRUQsU0FBUyxxQkFBcUIsQ0FBQyxXQUE0QjtJQUN6RCxPQUFPO1FBQ0wsR0FBRyxxQkFBcUIsQ0FBQyxXQUFXLENBQUM7UUFDckMsZUFBZSxFQUFFLFdBQVcsQ0FBQyxlQUFlO0tBQzdDLENBQUM7QUFDSixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgQ2ZuUm91dGUgfSBmcm9tICcuL2FwcG1lc2guZ2VuZXJhdGVkJztcbmltcG9ydCB7IEh0dHBUaW1lb3V0LCBHcnBjVGltZW91dCwgUHJvdG9jb2wsIFRjcFRpbWVvdXQgfSBmcm9tICcuL3NoYXJlZC1pbnRlcmZhY2VzJztcbmltcG9ydCB7IElWaXJ0dWFsTm9kZSB9IGZyb20gJy4vdmlydHVhbC1ub2RlJztcblxuLy8ga2VlcCB0aGlzIGltcG9ydCBzZXBhcmF0ZSBmcm9tIG90aGVyIGltcG9ydHMgdG8gcmVkdWNlIGNoYW5jZSBmb3IgbWVyZ2UgY29uZmxpY3RzIHdpdGggdjItbWFpblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLWR1cGxpY2F0ZS1pbXBvcnRzLCBpbXBvcnQvb3JkZXJcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBXZWlnaHRlZFRhcmdldCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHZpcnR1YWxOb2RlOiBJVmlydHVhbE5vZGU7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB3ZWlnaHQ/OiBudW1iZXI7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBIdHRwUm91dGVNYXRjaCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHByZWZpeFBhdGg6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgaGVhZGVycz86IEh0dHBIZWFkZXJNYXRjaFtdO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1ldGhvZD86IEh0dHBSb3V0ZU1hdGNoTWV0aG9kO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHByb3RvY29sPzogSHR0cFJvdXRlUHJvdG9jb2w7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgZW51bSBIdHRwUm91dGVNYXRjaE1ldGhvZCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEdFVCA9ICdHRVQnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBIRUFEID0gJ0hFQUQnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBQT1NUID0gJ1BPU1QnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIFBVVCA9ICdQVVQnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIERFTEVURSA9ICdERUxFVEUnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBDT05ORUNUID0gJ0NPTk5FQ1QnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBPUFRJT05TID0gJ09QVElPTlMnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgVFJBQ0UgPSAnVFJBQ0UnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgUEFUQ0ggPSAnUEFUQ0gnLFxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgZW51bSBIdHRwUm91dGVQcm90b2NvbCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgSFRUUCA9ICdodHRwJyxcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBIVFRQUyA9ICdodHRwcycsXG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBIdHRwSGVhZGVyTWF0Y2hDb25maWcge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGh0dHBSb3V0ZUhlYWRlcjogQ2ZuUm91dGUuSHR0cFJvdXRlSGVhZGVyUHJvcGVydHk7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBIdHRwSGVhZGVyTWF0Y2gge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHN0YXRpYyB2YWx1ZUlzKGhlYWRlck5hbWU6IHN0cmluZywgaGVhZGVyVmFsdWU6IHN0cmluZyk6IEh0dHBIZWFkZXJNYXRjaCB7XG4gICAgcmV0dXJuIG5ldyBIZWFkZXJNYXRjaEltcGwoaGVhZGVyTmFtZSwgZmFsc2UsIHsgZXhhY3Q6IGhlYWRlclZhbHVlIH0pO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgc3RhdGljIHZhbHVlSXNOb3QoaGVhZGVyTmFtZTogc3RyaW5nLCBoZWFkZXJWYWx1ZTogc3RyaW5nKTogSHR0cEhlYWRlck1hdGNoIHtcbiAgICByZXR1cm4gbmV3IEhlYWRlck1hdGNoSW1wbChoZWFkZXJOYW1lLCB0cnVlLCB7IGV4YWN0OiBoZWFkZXJWYWx1ZSB9KTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHN0YXRpYyB2YWx1ZVN0YXJ0c1dpdGgoaGVhZGVyTmFtZTogc3RyaW5nLCBwcmVmaXg6IHN0cmluZyk6IEh0dHBIZWFkZXJNYXRjaCB7XG4gICAgcmV0dXJuIG5ldyBIZWFkZXJNYXRjaEltcGwoaGVhZGVyTmFtZSwgZmFsc2UsIHsgcHJlZml4IH0pO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHN0YXRpYyB2YWx1ZURvZXNOb3RTdGFydFdpdGgoaGVhZGVyTmFtZTogc3RyaW5nLCBwcmVmaXg6IHN0cmluZyk6IEh0dHBIZWFkZXJNYXRjaCB7XG4gICAgcmV0dXJuIG5ldyBIZWFkZXJNYXRjaEltcGwoaGVhZGVyTmFtZSwgdHJ1ZSwgeyBwcmVmaXggfSk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgc3RhdGljIHZhbHVlRW5kc1dpdGgoaGVhZGVyTmFtZTogc3RyaW5nLCBzdWZmaXg6IHN0cmluZyk6IEh0dHBIZWFkZXJNYXRjaCB7XG4gICAgcmV0dXJuIG5ldyBIZWFkZXJNYXRjaEltcGwoaGVhZGVyTmFtZSwgZmFsc2UsIHsgc3VmZml4IH0pO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBzdGF0aWMgdmFsdWVEb2VzTm90RW5kV2l0aChoZWFkZXJOYW1lOiBzdHJpbmcsIHN1ZmZpeDogc3RyaW5nKTogSHR0cEhlYWRlck1hdGNoIHtcbiAgICByZXR1cm4gbmV3IEhlYWRlck1hdGNoSW1wbChoZWFkZXJOYW1lLCB0cnVlLCB7IHN1ZmZpeCB9KTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBzdGF0aWMgdmFsdWVNYXRjaGVzUmVnZXgoaGVhZGVyTmFtZTogc3RyaW5nLCByZWdleDogc3RyaW5nKTogSHR0cEhlYWRlck1hdGNoIHtcbiAgICByZXR1cm4gbmV3IEhlYWRlck1hdGNoSW1wbChoZWFkZXJOYW1lLCBmYWxzZSwgeyByZWdleCB9KTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgc3RhdGljIHZhbHVlRG9lc05vdE1hdGNoUmVnZXgoaGVhZGVyTmFtZTogc3RyaW5nLCByZWdleDogc3RyaW5nKTogSHR0cEhlYWRlck1hdGNoIHtcbiAgICByZXR1cm4gbmV3IEhlYWRlck1hdGNoSW1wbChoZWFkZXJOYW1lLCB0cnVlLCB7IHJlZ2V4IH0pO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBzdGF0aWMgdmFsdWVzSXNJblJhbmdlKGhlYWRlck5hbWU6IHN0cmluZywgc3RhcnQ6IG51bWJlciwgZW5kOiBudW1iZXIpOiBIdHRwSGVhZGVyTWF0Y2gge1xuICAgIHJldHVybiBuZXcgSGVhZGVyTWF0Y2hJbXBsKGhlYWRlck5hbWUsIGZhbHNlLCB7XG4gICAgICByYW5nZToge1xuICAgICAgICBzdGFydCxcbiAgICAgICAgZW5kLFxuICAgICAgfSxcbiAgICB9KTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHN0YXRpYyB2YWx1ZXNJc05vdEluUmFuZ2UoaGVhZGVyTmFtZTogc3RyaW5nLCBzdGFydDogbnVtYmVyLCBlbmQ6IG51bWJlcik6IEh0dHBIZWFkZXJNYXRjaCB7XG4gICAgcmV0dXJuIG5ldyBIZWFkZXJNYXRjaEltcGwoaGVhZGVyTmFtZSwgdHJ1ZSwge1xuICAgICAgcmFuZ2U6IHtcbiAgICAgICAgc3RhcnQsXG4gICAgICAgIGVuZCxcbiAgICAgIH0sXG4gICAgfSk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgYWJzdHJhY3QgYmluZChzY29wZTogQ29uc3RydWN0KTogSHR0cEhlYWRlck1hdGNoQ29uZmlnO1xufVxuXG5jbGFzcyBIZWFkZXJNYXRjaEltcGwgZXh0ZW5kcyBIdHRwSGVhZGVyTWF0Y2gge1xuICBjb25zdHJ1Y3RvcihcbiAgICBwcml2YXRlIHJlYWRvbmx5IGhlYWRlck5hbWU6IHN0cmluZyxcbiAgICBwcml2YXRlIHJlYWRvbmx5IGludmVydDogYm9vbGVhbixcbiAgICBwcml2YXRlIHJlYWRvbmx5IG1hdGNoUHJvcGVydHk6IENmblJvdXRlLkhlYWRlck1hdGNoTWV0aG9kUHJvcGVydHksXG4gICkge1xuICAgIHN1cGVyKCk7XG4gIH1cblxuICBiaW5kKF9zY29wZTogQ29uc3RydWN0KTogSHR0cEhlYWRlck1hdGNoQ29uZmlnIHtcbiAgICByZXR1cm4ge1xuICAgICAgaHR0cFJvdXRlSGVhZGVyOiB7XG4gICAgICAgIG5hbWU6IHRoaXMuaGVhZGVyTmFtZSxcbiAgICAgICAgaW52ZXJ0OiB0aGlzLmludmVydCxcbiAgICAgICAgbWF0Y2g6IHRoaXMubWF0Y2hQcm9wZXJ0eSxcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgR3JwY1JvdXRlTWF0Y2gge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHNlcnZpY2VOYW1lOiBzdHJpbmc7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFJvdXRlU3BlY09wdGlvbnNCYXNlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcHJpb3JpdHk/OiBudW1iZXI7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSHR0cFJvdXRlU3BlY09wdGlvbnMgZXh0ZW5kcyBSb3V0ZVNwZWNPcHRpb25zQmFzZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtYXRjaD86IEh0dHBSb3V0ZU1hdGNoO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHdlaWdodGVkVGFyZ2V0czogV2VpZ2h0ZWRUYXJnZXRbXTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdGltZW91dD86IEh0dHBUaW1lb3V0O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHJldHJ5UG9saWN5PzogSHR0cFJldHJ5UG9saWN5O1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEh0dHBSZXRyeVBvbGljeSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGh0dHBSZXRyeUV2ZW50cz86IEh0dHBSZXRyeUV2ZW50W107XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHJldHJ5QXR0ZW1wdHM6IG51bWJlcjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHJldHJ5VGltZW91dDogY2RrLkR1cmF0aW9uO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHRjcFJldHJ5RXZlbnRzPzogVGNwUmV0cnlFdmVudFtdO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGVudW0gSHR0cFJldHJ5RXZlbnQge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgU0VSVkVSX0VSUk9SID0gJ3NlcnZlci1lcnJvcicsXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgR0FURVdBWV9FUlJPUiA9ICdnYXRld2F5LWVycm9yJyxcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBDTElFTlRfRVJST1IgPSAnY2xpZW50LWVycm9yJyxcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBTVFJFQU1fRVJST1IgPSAnc3RyZWFtLWVycm9yJyxcbn1cblxuLyoqXG4gKiBUQ1AgZXZlbnRzIG9uIHdoaWNoIHlvdSBtYXkgcmV0cnlcbiAqL1xuZXhwb3J0IGVudW0gVGNwUmV0cnlFdmVudCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBDT05ORUNUSU9OX0VSUk9SID0gJ2Nvbm5lY3Rpb24tZXJyb3InLFxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBUY3BSb3V0ZVNwZWNPcHRpb25zIGV4dGVuZHMgUm91dGVTcGVjT3B0aW9uc0Jhc2Uge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB3ZWlnaHRlZFRhcmdldHM6IFdlaWdodGVkVGFyZ2V0W107XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdGltZW91dD86IFRjcFRpbWVvdXQ7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBHcnBjUm91dGVTcGVjT3B0aW9ucyBleHRlbmRzIFJvdXRlU3BlY09wdGlvbnNCYXNlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1hdGNoOiBHcnBjUm91dGVNYXRjaDtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdGltZW91dD86IEdycGNUaW1lb3V0O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHdlaWdodGVkVGFyZ2V0czogV2VpZ2h0ZWRUYXJnZXRbXTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZXRyeVBvbGljeT86IEdycGNSZXRyeVBvbGljeTtcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEdycGNSZXRyeVBvbGljeSBleHRlbmRzIEh0dHBSZXRyeVBvbGljeSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBncnBjUmV0cnlFdmVudHM/OiBHcnBjUmV0cnlFdmVudFtdO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgZW51bSBHcnBjUmV0cnlFdmVudCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBDQU5DRUxMRUQgPSAnY2FuY2VsbGVkJyxcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIERFQURMSU5FX0VYQ0VFREVEID0gJ2RlYWRsaW5lLWV4Y2VlZGVkJyxcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBJTlRFUk5BTF9FUlJPUiA9ICdpbnRlcm5hbCcsXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIFJFU09VUkNFX0VYSEFVU1RFRCA9ICdyZXNvdXJjZS1leGhhdXN0ZWQnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIFVOQVZBSUxBQkxFID0gJ3VuYXZhaWxhYmxlJyxcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFJvdXRlU3BlY0NvbmZpZyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBodHRwUm91dGVTcGVjPzogQ2ZuUm91dGUuSHR0cFJvdXRlUHJvcGVydHk7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgaHR0cDJSb3V0ZVNwZWM/OiBDZm5Sb3V0ZS5IdHRwUm91dGVQcm9wZXJ0eTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBncnBjUm91dGVTcGVjPzogQ2ZuUm91dGUuR3JwY1JvdXRlUHJvcGVydHk7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHRjcFJvdXRlU3BlYz86IENmblJvdXRlLlRjcFJvdXRlUHJvcGVydHk7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcHJpb3JpdHk/OiBudW1iZXI7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgUm91dGVTcGVjIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIGh0dHAob3B0aW9uczogSHR0cFJvdXRlU3BlY09wdGlvbnMpOiBSb3V0ZVNwZWMge1xuICAgIHJldHVybiBuZXcgSHR0cFJvdXRlU3BlYyhvcHRpb25zLCBQcm90b2NvbC5IVFRQKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBodHRwMihvcHRpb25zOiBIdHRwUm91dGVTcGVjT3B0aW9ucyk6IFJvdXRlU3BlYyB7XG4gICAgcmV0dXJuIG5ldyBIdHRwUm91dGVTcGVjKG9wdGlvbnMsIFByb3RvY29sLkhUVFAyKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgdGNwKG9wdGlvbnM6IFRjcFJvdXRlU3BlY09wdGlvbnMpOiBSb3V0ZVNwZWMge1xuICAgIHJldHVybiBuZXcgVGNwUm91dGVTcGVjKG9wdGlvbnMpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgZ3JwYyhvcHRpb25zOiBHcnBjUm91dGVTcGVjT3B0aW9ucyk6IFJvdXRlU3BlYyB7XG4gICAgcmV0dXJuIG5ldyBHcnBjUm91dGVTcGVjKG9wdGlvbnMpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBhYnN0cmFjdCBiaW5kKHNjb3BlOiBDb25zdHJ1Y3QpOiBSb3V0ZVNwZWNDb25maWc7XG59XG5cbmNsYXNzIEh0dHBSb3V0ZVNwZWMgZXh0ZW5kcyBSb3V0ZVNwZWMge1xuICBwdWJsaWMgcmVhZG9ubHkgcHJpb3JpdHk/OiBudW1iZXI7XG4gIHB1YmxpYyByZWFkb25seSBwcm90b2NvbDogUHJvdG9jb2w7XG4gIHB1YmxpYyByZWFkb25seSBtYXRjaD86IEh0dHBSb3V0ZU1hdGNoO1xuICBwdWJsaWMgcmVhZG9ubHkgdGltZW91dD86IEh0dHBUaW1lb3V0O1xuXG4gIHB1YmxpYyByZWFkb25seSB3ZWlnaHRlZFRhcmdldHM6IFdlaWdodGVkVGFyZ2V0W107XG5cbiAgLyoqXG4gICAqIFRoZSByZXRyeSBwb2xpY3lcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSByZXRyeVBvbGljeT86IEh0dHBSZXRyeVBvbGljeTtcblxuICBjb25zdHJ1Y3Rvcihwcm9wczogSHR0cFJvdXRlU3BlY09wdGlvbnMsIHByb3RvY29sOiBQcm90b2NvbCkge1xuICAgIHN1cGVyKCk7XG4gICAgdGhpcy5wcm90b2NvbCA9IHByb3RvY29sO1xuICAgIHRoaXMubWF0Y2ggPSBwcm9wcy5tYXRjaDtcbiAgICB0aGlzLndlaWdodGVkVGFyZ2V0cyA9IHByb3BzLndlaWdodGVkVGFyZ2V0cztcbiAgICB0aGlzLnRpbWVvdXQgPSBwcm9wcy50aW1lb3V0O1xuICAgIHRoaXMucHJpb3JpdHkgPSBwcm9wcy5wcmlvcml0eTtcblxuICAgIGlmIChwcm9wcy5yZXRyeVBvbGljeSkge1xuICAgICAgY29uc3QgaHR0cFJldHJ5RXZlbnRzID0gcHJvcHMucmV0cnlQb2xpY3kuaHR0cFJldHJ5RXZlbnRzID8/IFtdO1xuICAgICAgY29uc3QgdGNwUmV0cnlFdmVudHMgPSBwcm9wcy5yZXRyeVBvbGljeS50Y3BSZXRyeUV2ZW50cyA/PyBbXTtcblxuICAgICAgaWYgKGh0dHBSZXRyeUV2ZW50cy5sZW5ndGggKyB0Y3BSZXRyeUV2ZW50cy5sZW5ndGggPT09IDApIHtcbiAgICAgICAgdGhyb3cgbmV3IEVycm9yKCdZb3UgbXVzdCBzcGVjaWZ5IG9uZSB2YWx1ZSBmb3IgYXQgbGVhc3Qgb25lIG9mIGBodHRwUmV0cnlFdmVudHNgIG9yIGB0Y3BSZXRyeUV2ZW50c2AnKTtcbiAgICAgIH1cblxuICAgICAgdGhpcy5yZXRyeVBvbGljeSA9IHtcbiAgICAgICAgLi4ucHJvcHMucmV0cnlQb2xpY3ksXG4gICAgICAgIGh0dHBSZXRyeUV2ZW50czogaHR0cFJldHJ5RXZlbnRzLmxlbmd0aCA+IDAgPyBodHRwUmV0cnlFdmVudHMgOiB1bmRlZmluZWQsXG4gICAgICAgIHRjcFJldHJ5RXZlbnRzOiB0Y3BSZXRyeUV2ZW50cy5sZW5ndGggPiAwID8gdGNwUmV0cnlFdmVudHMgOiB1bmRlZmluZWQsXG4gICAgICB9O1xuICAgIH1cbiAgfVxuXG4gIHB1YmxpYyBiaW5kKHNjb3BlOiBDb25zdHJ1Y3QpOiBSb3V0ZVNwZWNDb25maWcge1xuICAgIGNvbnN0IHByZWZpeFBhdGggPSB0aGlzLm1hdGNoID8gdGhpcy5tYXRjaC5wcmVmaXhQYXRoIDogJy8nO1xuICAgIGlmIChwcmVmaXhQYXRoWzBdICE9ICcvJykge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGBQcmVmaXggUGF0aCBtdXN0IHN0YXJ0IHdpdGggXFwnL1xcJywgZ290OiAke3ByZWZpeFBhdGh9YCk7XG4gICAgfVxuXG4gICAgY29uc3QgaHR0cENvbmZpZzogQ2ZuUm91dGUuSHR0cFJvdXRlUHJvcGVydHkgPSB7XG4gICAgICBhY3Rpb246IHtcbiAgICAgICAgd2VpZ2h0ZWRUYXJnZXRzOiByZW5kZXJXZWlnaHRlZFRhcmdldHModGhpcy53ZWlnaHRlZFRhcmdldHMpLFxuICAgICAgfSxcbiAgICAgIG1hdGNoOiB7XG4gICAgICAgIHByZWZpeDogcHJlZml4UGF0aCxcbiAgICAgICAgaGVhZGVyczogdGhpcy5tYXRjaD8uaGVhZGVycz8ubWFwKGhlYWRlciA9PiBoZWFkZXIuYmluZChzY29wZSkuaHR0cFJvdXRlSGVhZGVyKSxcbiAgICAgICAgbWV0aG9kOiB0aGlzLm1hdGNoPy5tZXRob2QsXG4gICAgICAgIHNjaGVtZTogdGhpcy5tYXRjaD8ucHJvdG9jb2wsXG4gICAgICB9LFxuICAgICAgdGltZW91dDogcmVuZGVyVGltZW91dCh0aGlzLnRpbWVvdXQpLFxuICAgICAgcmV0cnlQb2xpY3k6IHRoaXMucmV0cnlQb2xpY3kgPyByZW5kZXJIdHRwUmV0cnlQb2xpY3kodGhpcy5yZXRyeVBvbGljeSkgOiB1bmRlZmluZWQsXG4gICAgfTtcbiAgICByZXR1cm4ge1xuICAgICAgcHJpb3JpdHk6IHRoaXMucHJpb3JpdHksXG4gICAgICBodHRwUm91dGVTcGVjOiB0aGlzLnByb3RvY29sID09PSBQcm90b2NvbC5IVFRQID8gaHR0cENvbmZpZyA6IHVuZGVmaW5lZCxcbiAgICAgIGh0dHAyUm91dGVTcGVjOiB0aGlzLnByb3RvY29sID09PSBQcm90b2NvbC5IVFRQMiA/IGh0dHBDb25maWcgOiB1bmRlZmluZWQsXG4gICAgfTtcbiAgfVxufVxuXG5jbGFzcyBUY3BSb3V0ZVNwZWMgZXh0ZW5kcyBSb3V0ZVNwZWMge1xuICAvKipcbiAgICogVGhlIHByaW9yaXR5IGZvciB0aGUgcm91dGUuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgcHJpb3JpdHk/OiBudW1iZXI7XG5cbiAgLypcbiAgICogTGlzdCBvZiB0YXJnZXRzIHRoYXQgdHJhZmZpYyBpcyByb3V0ZWQgdG8gd2hlbiBhIHJlcXVlc3QgbWF0Y2hlcyB0aGUgcm91dGVcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSB3ZWlnaHRlZFRhcmdldHM6IFdlaWdodGVkVGFyZ2V0W107XG5cbiAgLyoqXG4gICAqIFRoZSBjcml0ZXJpYSBmb3IgZGV0ZXJtaW5pbmcgYSB0aW1lb3V0IGNvbmZpZ3VyYXRpb25cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSB0aW1lb3V0PzogVGNwVGltZW91dDtcblxuICBjb25zdHJ1Y3Rvcihwcm9wczogVGNwUm91dGVTcGVjT3B0aW9ucykge1xuICAgIHN1cGVyKCk7XG4gICAgdGhpcy53ZWlnaHRlZFRhcmdldHMgPSBwcm9wcy53ZWlnaHRlZFRhcmdldHM7XG4gICAgdGhpcy50aW1lb3V0ID0gcHJvcHMudGltZW91dDtcbiAgICB0aGlzLnByaW9yaXR5ID0gcHJvcHMucHJpb3JpdHk7XG4gIH1cblxuICBwdWJsaWMgYmluZChfc2NvcGU6IENvbnN0cnVjdCk6IFJvdXRlU3BlY0NvbmZpZyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHByaW9yaXR5OiB0aGlzLnByaW9yaXR5LFxuICAgICAgdGNwUm91dGVTcGVjOiB7XG4gICAgICAgIGFjdGlvbjoge1xuICAgICAgICAgIHdlaWdodGVkVGFyZ2V0czogcmVuZGVyV2VpZ2h0ZWRUYXJnZXRzKHRoaXMud2VpZ2h0ZWRUYXJnZXRzKSxcbiAgICAgICAgfSxcbiAgICAgICAgdGltZW91dDogcmVuZGVyVGltZW91dCh0aGlzLnRpbWVvdXQpLFxuICAgICAgfSxcbiAgICB9O1xuICB9XG59XG5cbmNsYXNzIEdycGNSb3V0ZVNwZWMgZXh0ZW5kcyBSb3V0ZVNwZWMge1xuICAvKipcbiAgICogVGhlIHByaW9yaXR5IGZvciB0aGUgcm91dGUuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgcHJpb3JpdHk/OiBudW1iZXI7XG5cbiAgcHVibGljIHJlYWRvbmx5IHdlaWdodGVkVGFyZ2V0czogV2VpZ2h0ZWRUYXJnZXRbXTtcbiAgcHVibGljIHJlYWRvbmx5IG1hdGNoOiBHcnBjUm91dGVNYXRjaDtcbiAgcHVibGljIHJlYWRvbmx5IHRpbWVvdXQ/OiBHcnBjVGltZW91dDtcblxuICAvKipcbiAgICogVGhlIHJldHJ5IHBvbGljeS5cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSByZXRyeVBvbGljeT86IEdycGNSZXRyeVBvbGljeTtcblxuICBjb25zdHJ1Y3Rvcihwcm9wczogR3JwY1JvdXRlU3BlY09wdGlvbnMpIHtcbiAgICBzdXBlcigpO1xuICAgIHRoaXMud2VpZ2h0ZWRUYXJnZXRzID0gcHJvcHMud2VpZ2h0ZWRUYXJnZXRzO1xuICAgIHRoaXMubWF0Y2ggPSBwcm9wcy5tYXRjaDtcbiAgICB0aGlzLnRpbWVvdXQgPSBwcm9wcy50aW1lb3V0O1xuICAgIHRoaXMucHJpb3JpdHkgPSBwcm9wcy5wcmlvcml0eTtcblxuICAgIGlmIChwcm9wcy5yZXRyeVBvbGljeSkge1xuICAgICAgY29uc3QgZ3JwY1JldHJ5RXZlbnRzID0gcHJvcHMucmV0cnlQb2xpY3kuZ3JwY1JldHJ5RXZlbnRzID8/IFtdO1xuICAgICAgY29uc3QgaHR0cFJldHJ5RXZlbnRzID0gcHJvcHMucmV0cnlQb2xpY3kuaHR0cFJldHJ5RXZlbnRzID8/IFtdO1xuICAgICAgY29uc3QgdGNwUmV0cnlFdmVudHMgPSBwcm9wcy5yZXRyeVBvbGljeS50Y3BSZXRyeUV2ZW50cyA/PyBbXTtcblxuICAgICAgaWYgKGdycGNSZXRyeUV2ZW50cy5sZW5ndGggKyBodHRwUmV0cnlFdmVudHMubGVuZ3RoICsgdGNwUmV0cnlFdmVudHMubGVuZ3RoID09PSAwKSB7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcignWW91IG11c3Qgc3BlY2lmeSBvbmUgdmFsdWUgZm9yIGF0IGxlYXN0IG9uZSBvZiBgZ3JwY1JldHJ5RXZlbnRzYCwgYGh0dHBSZXRyeUV2ZW50c2Agb3IgYHRjcFJldHJ5RXZlbnRzYCcpO1xuICAgICAgfVxuXG4gICAgICB0aGlzLnJldHJ5UG9saWN5ID0ge1xuICAgICAgICAuLi5wcm9wcy5yZXRyeVBvbGljeSxcbiAgICAgICAgZ3JwY1JldHJ5RXZlbnRzOiBncnBjUmV0cnlFdmVudHMubGVuZ3RoID4gMCA/IGdycGNSZXRyeUV2ZW50cyA6IHVuZGVmaW5lZCxcbiAgICAgICAgaHR0cFJldHJ5RXZlbnRzOiBodHRwUmV0cnlFdmVudHMubGVuZ3RoID4gMCA/IGh0dHBSZXRyeUV2ZW50cyA6IHVuZGVmaW5lZCxcbiAgICAgICAgdGNwUmV0cnlFdmVudHM6IHRjcFJldHJ5RXZlbnRzLmxlbmd0aCA+IDAgPyB0Y3BSZXRyeUV2ZW50cyA6IHVuZGVmaW5lZCxcbiAgICAgIH07XG4gICAgfVxuICB9XG5cbiAgcHVibGljIGJpbmQoX3Njb3BlOiBDb25zdHJ1Y3QpOiBSb3V0ZVNwZWNDb25maWcge1xuICAgIHJldHVybiB7XG4gICAgICBwcmlvcml0eTogdGhpcy5wcmlvcml0eSxcbiAgICAgIGdycGNSb3V0ZVNwZWM6IHtcbiAgICAgICAgYWN0aW9uOiB7XG4gICAgICAgICAgd2VpZ2h0ZWRUYXJnZXRzOiByZW5kZXJXZWlnaHRlZFRhcmdldHModGhpcy53ZWlnaHRlZFRhcmdldHMpLFxuICAgICAgICB9LFxuICAgICAgICBtYXRjaDoge1xuICAgICAgICAgIHNlcnZpY2VOYW1lOiB0aGlzLm1hdGNoLnNlcnZpY2VOYW1lLFxuICAgICAgICB9LFxuICAgICAgICB0aW1lb3V0OiByZW5kZXJUaW1lb3V0KHRoaXMudGltZW91dCksXG4gICAgICAgIHJldHJ5UG9saWN5OiB0aGlzLnJldHJ5UG9saWN5ID8gcmVuZGVyR3JwY1JldHJ5UG9saWN5KHRoaXMucmV0cnlQb2xpY3kpIDogdW5kZWZpbmVkLFxuICAgICAgfSxcbiAgICB9O1xuICB9XG59XG5cbi8qKlxuKiBVdGlsaXR5IG1ldGhvZCB0byBhZGQgd2VpZ2h0ZWQgcm91dGUgdGFyZ2V0cyB0byBhbiBleGlzdGluZyByb3V0ZVxuKi9cbmZ1bmN0aW9uIHJlbmRlcldlaWdodGVkVGFyZ2V0cyh3ZWlnaHRlZFRhcmdldHM6IFdlaWdodGVkVGFyZ2V0W10pOiBDZm5Sb3V0ZS5XZWlnaHRlZFRhcmdldFByb3BlcnR5W10ge1xuICBjb25zdCByZW5kZXJlZFRhcmdldHM6IENmblJvdXRlLldlaWdodGVkVGFyZ2V0UHJvcGVydHlbXSA9IFtdO1xuICBmb3IgKGNvbnN0IHQgb2Ygd2VpZ2h0ZWRUYXJnZXRzKSB7XG4gICAgcmVuZGVyZWRUYXJnZXRzLnB1c2goe1xuICAgICAgdmlydHVhbE5vZGU6IHQudmlydHVhbE5vZGUudmlydHVhbE5vZGVOYW1lLFxuICAgICAgd2VpZ2h0OiB0LndlaWdodCB8fCAxLFxuICAgIH0pO1xuICB9XG4gIHJldHVybiByZW5kZXJlZFRhcmdldHM7XG59XG5cbi8qKlxuICogVXRpbGl0eSBtZXRob2QgdG8gY29uc3RydWN0IGEgcm91dGUgdGltZW91dCBvYmplY3RcbiAqL1xuZnVuY3Rpb24gcmVuZGVyVGltZW91dCh0aW1lb3V0PzogSHR0cFRpbWVvdXQpOiBDZm5Sb3V0ZS5IdHRwVGltZW91dFByb3BlcnR5IHwgdW5kZWZpbmVkIHtcbiAgcmV0dXJuIHRpbWVvdXRcbiAgICA/IHtcbiAgICAgIGlkbGU6IHRpbWVvdXQ/LmlkbGUgIT09IHVuZGVmaW5lZFxuICAgICAgICA/IHtcbiAgICAgICAgICB1bml0OiAnbXMnLFxuICAgICAgICAgIHZhbHVlOiB0aW1lb3V0Py5pZGxlLnRvTWlsbGlzZWNvbmRzKCksXG4gICAgICAgIH1cbiAgICAgICAgOiB1bmRlZmluZWQsXG4gICAgICBwZXJSZXF1ZXN0OiB0aW1lb3V0Py5wZXJSZXF1ZXN0ICE9PSB1bmRlZmluZWRcbiAgICAgICAgPyB7XG4gICAgICAgICAgdW5pdDogJ21zJyxcbiAgICAgICAgICB2YWx1ZTogdGltZW91dD8ucGVyUmVxdWVzdC50b01pbGxpc2Vjb25kcygpLFxuICAgICAgICB9XG4gICAgICAgIDogdW5kZWZpbmVkLFxuICAgIH1cbiAgICA6IHVuZGVmaW5lZDtcbn1cblxuZnVuY3Rpb24gcmVuZGVySHR0cFJldHJ5UG9saWN5KHJldHJ5UG9saWN5OiBIdHRwUmV0cnlQb2xpY3kpOiBDZm5Sb3V0ZS5IdHRwUmV0cnlQb2xpY3lQcm9wZXJ0eSB7XG4gIHJldHVybiB7XG4gICAgbWF4UmV0cmllczogcmV0cnlQb2xpY3kucmV0cnlBdHRlbXB0cyxcbiAgICBwZXJSZXRyeVRpbWVvdXQ6IHtcbiAgICAgIHVuaXQ6ICdtcycsXG4gICAgICB2YWx1ZTogcmV0cnlQb2xpY3kucmV0cnlUaW1lb3V0LnRvTWlsbGlzZWNvbmRzKCksXG4gICAgfSxcbiAgICBodHRwUmV0cnlFdmVudHM6IHJldHJ5UG9saWN5Lmh0dHBSZXRyeUV2ZW50cyxcbiAgICB0Y3BSZXRyeUV2ZW50czogcmV0cnlQb2xpY3kudGNwUmV0cnlFdmVudHMsXG4gIH07XG59XG5cbmZ1bmN0aW9uIHJlbmRlckdycGNSZXRyeVBvbGljeShyZXRyeVBvbGljeTogR3JwY1JldHJ5UG9saWN5KTogQ2ZuUm91dGUuR3JwY1JldHJ5UG9saWN5UHJvcGVydHkge1xuICByZXR1cm4ge1xuICAgIC4uLnJlbmRlckh0dHBSZXRyeVBvbGljeShyZXRyeVBvbGljeSksXG4gICAgZ3JwY1JldHJ5RXZlbnRzOiByZXRyeVBvbGljeS5ncnBjUmV0cnlFdmVudHMsXG4gIH07XG59XG4iXX0=