# coding: utf-8

"""
    Vectara REST API v2

    Vectara provides an end-to-end platform for creating GenAI products using  a simple to use API.  You can [sign up for an account](https://console.vectara.com/signup) and  then view several [API Recipes](https://docs.vectara.com/docs/api-recipes) with example queries  and parameter values.  The Vectara API Playground lets you experiment with REST endpoints from  your browser. Select an endpoint to view its definition, including the  required or optional headers, body, responses, and sample commands. On the  right side of each endpoint page, like [Get Corpus](/docs/rest-api/get-corpus), you manually  enter your API Key or OAuth Bearer Token, `customer_id`, and then any  required body parameters like the `corpusID` before sending the API  request.  :::note  Vectara supports two primary methods of authentication: API keys and OAuth  2.0, which are applicable to all endpoints. Query API Keys are used for  read-only querying operations, while Index API Keys provide read and write  access. The OAuth 2.0 operations authenticate with a Bearer Token via the  OAuth 2.0 client credentials grant. Review the [**OAuth 2.0 section**](https://docs.vectara.com/docs/learn/authentication/oauth-2) about  how to generate the token. 

    The version of the OpenAPI document: 2.0.0
    Contact: feedback@vectara.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vectara_client.models.api_policy import ApiPolicy
from vectara_client.models.api_role import ApiRole
from typing import Optional, Set
from typing_extensions import Self

class User(BaseModel):
    """
    User
    """ # noqa: E501
    id: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="The Vectara ID for the user.")
    email: Optional[StrictStr] = Field(default=None, description="The email address for the user.")
    username: Optional[StrictStr] = Field(default=None, description="The username for the user.")
    enabled: Optional[StrictBool] = Field(default=None, description="Indicates whether the user is enabled or disabled.")
    description: Optional[StrictStr] = Field(default=None, description="The description for the user.")
    created_at: Optional[datetime] = Field(default=None, description="When the user was created.")
    updated_at: Optional[datetime] = Field(default=None, description="When a user property was last updated.")
    api_roles: Optional[List[ApiRole]] = Field(default=None, description="The role names of the user.")
    api_policy: Optional[ApiPolicy] = None
    __properties: ClassVar[List[str]] = ["id", "email", "username", "enabled", "description", "created_at", "updated_at", "api_roles", "api_policy"]

    @field_validator('id')
    def id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"usr_.+", value):
            raise ValueError(r"must validate the regular expression /usr_.+/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of User from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of api_policy
        if self.api_policy:
            _dict['api_policy'] = self.api_policy.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of User from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "email": obj.get("email"),
            "username": obj.get("username"),
            "enabled": obj.get("enabled"),
            "description": obj.get("description"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "api_roles": obj.get("api_roles"),
            "api_policy": ApiPolicy.from_dict(obj["api_policy"]) if obj.get("api_policy") is not None else None
        })
        return _obj


