# coding: utf-8

"""
    Vectara REST API v2

    Vectara provides an end-to-end platform for creating GenAI products using  a simple to use API.  You can [sign up for an account](https://console.vectara.com/signup) and  then view several [API Recipes](https://docs.vectara.com/docs/api-recipes) with example queries  and parameter values.  The Vectara API Playground lets you experiment with REST endpoints from  your browser. Select an endpoint to view its definition, including the  required or optional headers, body, responses, and sample commands. On the  right side of each endpoint page, like [Get Corpus](/docs/rest-api/get-corpus), you manually  enter your API Key or OAuth Bearer Token, `customer_id`, and then any  required body parameters like the `corpusID` before sending the API  request.  :::note  Vectara supports two primary methods of authentication: API keys and OAuth  2.0, which are applicable to all endpoints. Query API Keys are used for  read-only querying operations, while Index API Keys provide read and write  access. The OAuth 2.0 operations authenticate with a Bearer Token via the  OAuth 2.0 client credentials grant. Review the [**OAuth 2.0 section**](https://docs.vectara.com/docs/learn/authentication/oauth-2) about  how to generate the token. 

    The version of the OpenAPI document: 2.0.0
    Contact: feedback@vectara.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class Language(str, Enum):
    """
    Languages that the Vectara platform supports.
    """

    """
    allowed enum values
    """
    AUTO = 'auto'
    ENG = 'eng'
    DEU = 'deu'
    FRA = 'fra'
    ZHO = 'zho'
    KOR = 'kor'
    ARA = 'ara'
    RUS = 'rus'
    THA = 'tha'
    NLD = 'nld'
    ITA = 'ita'
    POR = 'por'
    SPA = 'spa'
    JPN = 'jpn'
    POL = 'pol'
    TUR = 'tur'
    VIE = 'vie'
    IND = 'ind'
    CES = 'ces'
    UKR = 'ukr'
    ELL = 'ell'
    HEB = 'heb'
    FAS = 'fas'
    HIN = 'hin'
    URD = 'urd'
    SWE = 'swe'
    BEN = 'ben'
    MSA = 'msa'
    RON = 'ron'

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of Language from a JSON string"""
        return cls(json.loads(json_str))


