# coding: utf-8

"""
    Vectara REST API v2

    Vectara provides an end-to-end platform for creating GenAI products using  a simple to use API.  You can [sign up for an account](https://console.vectara.com/signup) and  then view several [API Recipes](https://docs.vectara.com/docs/api-recipes) with example queries  and parameter values.  The Vectara API Playground lets you experiment with REST endpoints from  your browser. Select an endpoint to view its definition, including the  required or optional headers, body, responses, and sample commands. On the  right side of each endpoint page, like [Get Corpus](/docs/rest-api/get-corpus), you manually  enter your API Key or OAuth Bearer Token, `customer_id`, and then any  required body parameters like the `corpusID` before sending the API  request.  :::note  Vectara supports two primary methods of authentication: API keys and OAuth  2.0, which are applicable to all endpoints. Query API Keys are used for  read-only querying operations, while Index API Keys provide read and write  access. The OAuth 2.0 operations authenticate with a Bearer Token via the  OAuth 2.0 client credentials grant. Review the [**OAuth 2.0 section**](https://docs.vectara.com/docs/learn/authentication/oauth-2) about  how to generate the token. 

    The version of the OpenAPI document: 2.0.0
    Contact: feedback@vectara.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vectara_client.models.citation_parameters import CitationParameters
from vectara_client.models.language import Language
from vectara_client.models.model_parameters import ModelParameters
from typing import Optional, Set
from typing_extensions import Self

class GenerationParameters(BaseModel):
    """
    The parameters to control generation.
    """ # noqa: E501
    prompt_name: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(default=None, description="The prompt to use to feed the query results and other context to the model. By specifying the prompt name you also specify the model and other `model_parameter` defaults. ")
    max_used_search_results: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=5, description="The maximum number of search results to be available to the prompt.")
    prompt_text: Optional[StrictStr] = Field(default=None, description="Vectara manages both system and user roles and prompts for the generative LLM out of the box by default. However, Scale customers can override the prompt_text via this variable. The prompt_text is in the form of an Apache Velocity template. For more details on how to configure the prompt_text, see the long-form documentation at https://docs.vectara.com/docs/prompts/vectara-prompt-engine. See https://vectara.com/pricing/ for more details on becoming a Scale customer. ")
    max_response_characters: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, description="Controls the length of the generated output. This is a rough estimate and not a hard limit: the end output can be longer or shorter than this value.  This is currently a Scale-only feature. See https://vectara.com/pricing/ for more details on becoming a Scale customer. ")
    response_language: Optional[Language] = None
    model_parameters: Optional[ModelParameters] = None
    citations: Optional[CitationParameters] = None
    enable_factual_consistency_score: Optional[StrictBool] = Field(default=True, description="Enable returning the factual consistency score with query results.")
    __properties: ClassVar[List[str]] = ["prompt_name", "max_used_search_results", "prompt_text", "max_response_characters", "response_language", "model_parameters", "citations", "enable_factual_consistency_score"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GenerationParameters from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of model_parameters
        if self.model_parameters:
            _dict['model_parameters'] = self.model_parameters.to_dict()
        # override the default output from pydantic by calling `to_dict()` of citations
        if self.citations:
            _dict['citations'] = self.citations.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GenerationParameters from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "prompt_name": obj.get("prompt_name"),
            "max_used_search_results": obj.get("max_used_search_results") if obj.get("max_used_search_results") is not None else 5,
            "prompt_text": obj.get("prompt_text"),
            "max_response_characters": obj.get("max_response_characters"),
            "response_language": obj.get("response_language"),
            "model_parameters": ModelParameters.from_dict(obj["model_parameters"]) if obj.get("model_parameters") is not None else None,
            "citations": CitationParameters.from_dict(obj["citations"]) if obj.get("citations") is not None else None,
            "enable_factual_consistency_score": obj.get("enable_factual_consistency_score") if obj.get("enable_factual_consistency_score") is not None else True
        })
        return _obj


