# coding: utf-8

"""
    Vectara REST API v2

    Vectara provides an end-to-end platform for creating GenAI products using  a simple to use API.  You can [sign up for an account](https://console.vectara.com/signup) and  then view several [API Recipes](https://docs.vectara.com/docs/api-recipes) with example queries  and parameter values.  The Vectara API Playground lets you experiment with REST endpoints from  your browser. Select an endpoint to view its definition, including the  required or optional headers, body, responses, and sample commands. On the  right side of each endpoint page, like [Get Corpus](/docs/rest-api/get-corpus), you manually  enter your API Key or OAuth Bearer Token, `customer_id`, and then any  required body parameters like the `corpusID` before sending the API  request.  :::note  Vectara supports two primary methods of authentication: API keys and OAuth  2.0, which are applicable to all endpoints. Query API Keys are used for  read-only querying operations, while Index API Keys provide read and write  access. The OAuth 2.0 operations authenticate with a Bearer Token via the  OAuth 2.0 client credentials grant. Review the [**OAuth 2.0 section**](https://docs.vectara.com/docs/learn/authentication/oauth-2) about  how to generate the token. 

    The version of the OpenAPI document: 2.0.0
    Contact: feedback@vectara.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class ContextConfiguration(BaseModel):
    """
    Configuration on the presentation of each document part in the result set.
    """ # noqa: E501
    characters_before: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=0, description="The number of characters before the matching document part that are shown. This is useful to show the context of the document part in the wider document. Ignored if `sentences_before` is set. Vectara will capture the full sentence that contains the captured characters, so as to not lose the meaning caused by a truncated word or sentence. ")
    characters_after: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=0, description="The number of characters after the matching document part that are shown.  This is useful to show the context of the document part in the wider document. Ignored if `sentences_after` is set. Vectara will capture the full sentence that contains the captured characters, so as to not lose the meaning caused by a truncated word or sentence. ")
    sentences_before: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=0, description="The number of sentences before the matching document part that are shown. This is useful to show the context of the document part in the wider document. ")
    sentences_after: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=0, description="The number of sentences after the matching document part that are shown.  This is useful to show the context of the document part in the wider document. ")
    start_tag: Optional[StrictStr] = Field(default=None, description="The tag that wraps the document part at the start. This is often used to  provide a start HTML/XML tag or some other delimiter you can use in an  application to understand where to provide highlighting in your UI and  understand where the context before ends and the document part begins. ")
    end_tag: Optional[StrictStr] = Field(default=None, description="The tag that wraps the document part at the end. This is often used to  provide a start HTML/XML tag or some other delimiter you can use in an  application to understand where to provide highlighting in your UI and  understand where the context before ends and the document part begins. ")
    __properties: ClassVar[List[str]] = ["characters_before", "characters_after", "sentences_before", "sentences_after", "start_tag", "end_tag"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContextConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContextConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "characters_before": obj.get("characters_before") if obj.get("characters_before") is not None else 0,
            "characters_after": obj.get("characters_after") if obj.get("characters_after") is not None else 0,
            "sentences_before": obj.get("sentences_before") if obj.get("sentences_before") is not None else 0,
            "sentences_after": obj.get("sentences_after") if obj.get("sentences_after") is not None else 0,
            "start_tag": obj.get("start_tag"),
            "end_tag": obj.get("end_tag")
        })
        return _obj


