# coding: utf-8

"""
    Vectara REST API v2

    Vectara provides an end-to-end platform for creating GenAI products using  a simple to use API.  You can [sign up for an account](https://console.vectara.com/signup) and  then view several [API Recipes](https://docs.vectara.com/docs/api-recipes) with example queries  and parameter values.  The Vectara API Playground lets you experiment with REST endpoints from  your browser. Select an endpoint to view its definition, including the  required or optional headers, body, responses, and sample commands. On the  right side of each endpoint page, like [Get Corpus](/docs/rest-api/get-corpus), you manually  enter your API Key or OAuth Bearer Token, `customer_id`, and then any  required body parameters like the `corpusID` before sending the API  request.  :::note  Vectara supports two primary methods of authentication: API keys and OAuth  2.0, which are applicable to all endpoints. Query API Keys are used for  read-only querying operations, while Index API Keys provide read and write  access. The OAuth 2.0 operations authenticate with a Bearer Token via the  OAuth 2.0 client credentials grant. Review the [**OAuth 2.0 section**](https://docs.vectara.com/docs/learn/authentication/oauth-2) about  how to generate the token. 

    The version of the OpenAPI document: 2.0.0
    Contact: feedback@vectara.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CitationParameters(BaseModel):
    """
    Style the generator should use when making citations.
    """ # noqa: E501
    style: Optional[StrictStr] = Field(default=None, description="The citation style to be used in summary. Can be one of: * `numeric` - Citations formatted as simple numerals: \\[1\\], \\[2\\] ... * `none` - Citations removed from text. * `html` - Citation formatted as url like `<a href=\"url_pattern\">text_pattern</a>`. * `markdown` - Formatted as `[text_pattern](url_pattern)`. ")
    url_pattern: Optional[StrictStr] = Field(default=None, description="The url pattern if the citation_style is set to `html` or `markdown`. The pattern can access metadata attributes in the document or part. e.g. `https://my.doc/foo/{doc.id}/{part.id}`  The default `url_pattern` is an empty string. ")
    text_pattern: Optional[StrictStr] = Field(default=None, description="The text pattern if the citation_style is set to `html` or `markdown`. This pattern sets the href for html or the text within `[]` in markdown, and defaults to N being the index of result if it is not set.  The default citation style looks like `[N](<url_pattern>)` for markdown.  You can use metadata attributes in the `text_pattern`. For example, the pattern `{doc.title}` with citation style `markdown` would result in final citation output like `[Title](<url_pattern>)` when the document's metadata includes `{\"title\":\"Title\"}`. ")
    __properties: ClassVar[List[str]] = ["style", "url_pattern", "text_pattern"]

    @field_validator('style')
    def style_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['none', 'numeric', 'html', 'markdown']):
            raise ValueError("must be one of enum values ('none', 'numeric', 'html', 'markdown')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CitationParameters from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CitationParameters from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "style": obj.get("style"),
            "url_pattern": obj.get("url_pattern"),
            "text_pattern": obj.get("text_pattern")
        })
        return _obj


