# coding: utf-8

# flake8: noqa
"""
    Vectara REST API v2

    Vectara provides an end-to-end platform for creating GenAI products using  a simple to use API.  You can [sign up for an account](https://console.vectara.com/signup) and  then view several [API Recipes](https://docs.vectara.com/docs/api-recipes) with example queries  and parameter values.  The Vectara API Playground lets you experiment with REST endpoints from  your browser. Select an endpoint to view its definition, including the  required or optional headers, body, responses, and sample commands. On the  right side of each endpoint page, like [Get Corpus](/docs/rest-api/get-corpus), you manually  enter your API Key or OAuth Bearer Token, `customer_id`, and then any  required body parameters like the `corpusID` before sending the API  request.  :::note  Vectara supports two primary methods of authentication: API keys and OAuth  2.0, which are applicable to all endpoints. Query API Keys are used for  read-only querying operations, while Index API Keys provide read and write  access. The OAuth 2.0 operations authenticate with a Bearer Token via the  OAuth 2.0 client credentials grant. Review the [**OAuth 2.0 section**](https://docs.vectara.com/docs/learn/authentication/oauth-2) about  how to generate the token. 

    The version of the OpenAPI document: 2.0.0
    Contact: feedback@vectara.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


# import models into model package
from vectara_client.models.api_key import ApiKey
from vectara_client.models.api_key_role import ApiKeyRole
from vectara_client.models.api_operation_policy import ApiOperationPolicy
from vectara_client.models.api_policy import ApiPolicy
from vectara_client.models.api_role import ApiRole
from vectara_client.models.app_client import AppClient
from vectara_client.models.bad_request_error import BadRequestError
from vectara_client.models.chat import Chat
from vectara_client.models.chat_full_response import ChatFullResponse
from vectara_client.models.chat_info_response import ChatInfoResponse
from vectara_client.models.chat_parameters import ChatParameters
from vectara_client.models.chat_request import ChatRequest
from vectara_client.models.chat_streamed_response import ChatStreamedResponse
from vectara_client.models.citation_parameters import CitationParameters
from vectara_client.models.context_configuration import ContextConfiguration
from vectara_client.models.core_document import CoreDocument
from vectara_client.models.core_document_part import CoreDocumentPart
from vectara_client.models.corpus import Corpus
from vectara_client.models.corpus_custom_dimension import CorpusCustomDimension
from vectara_client.models.corpus_limits import CorpusLimits
from vectara_client.models.create_api_key_request import CreateApiKeyRequest
from vectara_client.models.create_app_client_request import CreateAppClientRequest
from vectara_client.models.create_client_credentials_request import CreateClientCredentialsRequest
from vectara_client.models.create_corpus_request import CreateCorpusRequest
from vectara_client.models.create_document_request import CreateDocumentRequest
from vectara_client.models.create_user_request import CreateUserRequest
from vectara_client.models.customer_specific_reranker import CustomerSpecificReranker
from vectara_client.models.document import Document
from vectara_client.models.document_storage_usage import DocumentStorageUsage
from vectara_client.models.encoder import Encoder
from vectara_client.models.error import Error
from vectara_client.models.factual_consistency_score import FactualConsistencyScore
from vectara_client.models.filter_attribute import FilterAttribute
from vectara_client.models.generation_parameters import GenerationParameters
from vectara_client.models.individual_search_result import IndividualSearchResult
from vectara_client.models.job import Job
from vectara_client.models.job_state import JobState
from vectara_client.models.keyed_search_corpus import KeyedSearchCorpus
from vectara_client.models.llm import LLM
from vectara_client.models.language import Language
from vectara_client.models.list_api_keys_response import ListApiKeysResponse
from vectara_client.models.list_app_clients_response import ListAppClientsResponse
from vectara_client.models.list_chat_turns_response import ListChatTurnsResponse
from vectara_client.models.list_chats_response import ListChatsResponse
from vectara_client.models.list_corpora_response import ListCorporaResponse
from vectara_client.models.list_documents_response import ListDocumentsResponse
from vectara_client.models.list_encoders_response import ListEncodersResponse
from vectara_client.models.list_jobs_response import ListJobsResponse
from vectara_client.models.list_llms_response import ListLLMsResponse
from vectara_client.models.list_metadata import ListMetadata
from vectara_client.models.list_rerankers_response import ListRerankersResponse
from vectara_client.models.list_users_response import ListUsersResponse
from vectara_client.models.mmr_reranker import MMRReranker
from vectara_client.models.model_parameters import ModelParameters
from vectara_client.models.not_found_error import NotFoundError
from vectara_client.models.prompt import Prompt
from vectara_client.models.query_corpus_request import QueryCorpusRequest
from vectara_client.models.query_full_response import QueryFullResponse
from vectara_client.models.query_request import QueryRequest
from vectara_client.models.query_streamed_response import QueryStreamedResponse
from vectara_client.models.replace_filter_attributes_request import ReplaceFilterAttributesRequest
from vectara_client.models.replace_filter_attributes_response import ReplaceFilterAttributesResponse
from vectara_client.models.reranker import Reranker
from vectara_client.models.search_corpora_parameters import SearchCorporaParameters
from vectara_client.models.search_corpus import SearchCorpus
from vectara_client.models.search_corpus_parameters import SearchCorpusParameters
from vectara_client.models.search_parameters import SearchParameters
from vectara_client.models.search_reranker import SearchReranker
from vectara_client.models.search_semantics import SearchSemantics
from vectara_client.models.stream_error import StreamError
from vectara_client.models.stream_generation_chunk import StreamGenerationChunk
from vectara_client.models.stream_generation_end import StreamGenerationEnd
from vectara_client.models.stream_response_end import StreamResponseEnd
from vectara_client.models.stream_search_response import StreamSearchResponse
from vectara_client.models.structured_document import StructuredDocument
from vectara_client.models.structured_document_section import StructuredDocumentSection
from vectara_client.models.turn import Turn
from vectara_client.models.update_api_key_request import UpdateApiKeyRequest
from vectara_client.models.update_app_client_request import UpdateAppClientRequest
from vectara_client.models.update_corpus_request import UpdateCorpusRequest
from vectara_client.models.update_turn_request import UpdateTurnRequest
from vectara_client.models.update_user_request import UpdateUserRequest
from vectara_client.models.user import User
