# vectara-client
Vectara provides an end-to-end platform for creating GenAI products using 
a simple to use API.

You can [sign up for an account](https://console.vectara.com/signup) and 
then view several [API Recipes](https://docs.vectara.com/docs/api-recipes) with example queries 
and parameter values.

The Vectara API Playground lets you experiment with REST endpoints from 
your browser. Select an endpoint to view its definition, including the 
required or optional headers, body, responses, and sample commands. On the 
right side of each endpoint page, like [Get Corpus](/docs/rest-api/get-corpus), you manually 
enter your API Key or OAuth Bearer Token, `customer_id`, and then any 
required body parameters like the `corpusID` before sending the API 
request.

:::note

Vectara supports two primary methods of authentication: API keys and OAuth 
2.0, which are applicable to all endpoints. Query API Keys are used for 
read-only querying operations, while Index API Keys provide read and write 
access. The OAuth 2.0 operations authenticate with a Bearer Token via the 
OAuth 2.0 client credentials grant. Review the [**OAuth 2.0 section**](https://docs.vectara.com/docs/learn/authentication/oauth-2) about 
how to generate the token.


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.0.0
- Package version: 1.0.0
- Generator version: 7.6.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import vectara_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import vectara_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import vectara_client
from vectara_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.vectara.io
# See configuration.py for a list of all supported configuration parameters.
configuration = vectara_client.Configuration(
    host = "https://api.vectara.io"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with vectara_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = vectara_client.APIKeysApi(api_client)
    create_api_key_request = vectara_client.CreateApiKeyRequest() # CreateApiKeyRequest |  (optional)

    try:
        # Create an API key
        api_response = api_instance.create_api_key(create_api_key_request=create_api_key_request)
        print("The response of APIKeysApi->create_api_key:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling APIKeysApi->create_api_key: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.vectara.io*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*APIKeysApi* | [**create_api_key**](docs/APIKeysApi.md#create_api_key) | **POST** /v2/api_keys | Create an API key
*APIKeysApi* | [**delete_api_key**](docs/APIKeysApi.md#delete_api_key) | **DELETE** /v2/api_keys/{api_key_id} | Delete an API key
*APIKeysApi* | [**get_api_key**](docs/APIKeysApi.md#get_api_key) | **GET** /v2/api_keys/{api_key_id} | Get an API key
*APIKeysApi* | [**list_api_keys**](docs/APIKeysApi.md#list_api_keys) | **GET** /v2/api_keys | List API keys
*APIKeysApi* | [**update_api_key**](docs/APIKeysApi.md#update_api_key) | **PATCH** /v2/api_keys/{api_key_id} | Update an API key
*ApplicationClientsApi* | [**create_app_client**](docs/ApplicationClientsApi.md#create_app_client) | **POST** /v2/app_clients | Create an App Client
*ApplicationClientsApi* | [**delete_app_client**](docs/ApplicationClientsApi.md#delete_app_client) | **DELETE** /v2/app_clients/{app_client_id} | Delete an App Client
*ApplicationClientsApi* | [**get_app_client**](docs/ApplicationClientsApi.md#get_app_client) | **GET** /v2/app_clients/{app_client_id} | Get an App Client
*ApplicationClientsApi* | [**list_app_client**](docs/ApplicationClientsApi.md#list_app_client) | **GET** /v2/app_clients | List App Clients
*ApplicationClientsApi* | [**update_app_client**](docs/ApplicationClientsApi.md#update_app_client) | **PATCH** /v2/app_clients/{app_client_id} | Update an App Client
*ChatsApi* | [**create_chat**](docs/ChatsApi.md#create_chat) | **POST** /v2/chats | Start a chat
*ChatsApi* | [**create_chat_turn**](docs/ChatsApi.md#create_chat_turn) | **POST** /v2/chats/{chat_id}/turns | Create a new turn in the chat
*ChatsApi* | [**delete_chat**](docs/ChatsApi.md#delete_chat) | **DELETE** /v2/chats/{chat_id} | Delete a chat
*ChatsApi* | [**delete_chat_turn**](docs/ChatsApi.md#delete_chat_turn) | **DELETE** /v2/chats/{chat_id}/turns/{turn_id} | Delete a turn
*ChatsApi* | [**get_chat**](docs/ChatsApi.md#get_chat) | **GET** /v2/chats/{chat_id} | Get a chat
*ChatsApi* | [**get_chat_turn**](docs/ChatsApi.md#get_chat_turn) | **GET** /v2/chats/{chat_id}/turns/{turn_id} | Get a turn
*ChatsApi* | [**list_chat_turns**](docs/ChatsApi.md#list_chat_turns) | **GET** /v2/chats/{chat_id}/turns | List turns in a chat
*ChatsApi* | [**list_chats**](docs/ChatsApi.md#list_chats) | **GET** /v2/chats | List chats
*ChatsApi* | [**update_chat_turn**](docs/ChatsApi.md#update_chat_turn) | **PATCH** /v2/chats/{chat_id}/turns/{turn_id} | Update a turn
*CorporaApi* | [**create_corpus**](docs/CorporaApi.md#create_corpus) | **POST** /v2/corpora | Create a corpus
*CorporaApi* | [**delete_corpus**](docs/CorporaApi.md#delete_corpus) | **DELETE** /v2/corpora/{corpus_key} | Delete a corpus and all its data
*CorporaApi* | [**get_corpus**](docs/CorporaApi.md#get_corpus) | **GET** /v2/corpora/{corpus_key} | Retrieve metadata about a corpus
*CorporaApi* | [**list_corpora**](docs/CorporaApi.md#list_corpora) | **GET** /v2/corpora | List corpora
*CorporaApi* | [**replace_filter_attributes**](docs/CorporaApi.md#replace_filter_attributes) | **POST** /v2/corpora/{corpus_key}/replace_filter_attributes | Replace the filter attributes of a corpus
*CorporaApi* | [**reset_corpus**](docs/CorporaApi.md#reset_corpus) | **POST** /v2/corpora/{corpus_key}/reset | Remove all documents and data in a corpus
*CorporaApi* | [**update_corpus**](docs/CorporaApi.md#update_corpus) | **PATCH** /v2/corpora/{corpus_key} | Update a corpus
*DocumentsApi* | [**delete_corpus_document**](docs/DocumentsApi.md#delete_corpus_document) | **DELETE** /v2/corpora/{corpus_key}/documents/{document_id} | Delete a document
*DocumentsApi* | [**list_corpus_documents**](docs/DocumentsApi.md#list_corpus_documents) | **GET** /v2/corpora/{corpus_key}/documents | List the documents in the corpus
*EncodersApi* | [**list_encoders**](docs/EncodersApi.md#list_encoders) | **GET** /v2/encoders | List the available encoders
*IndexApi* | [**create_corpus_document**](docs/IndexApi.md#create_corpus_document) | **POST** /v2/corpora/{corpus_key}/documents | Add a document to a corpus
*JobsApi* | [**get_job**](docs/JobsApi.md#get_job) | **GET** /v2/jobs/{job_id} | Get a job by ID
*JobsApi* | [**list_jobs**](docs/JobsApi.md#list_jobs) | **GET** /v2/jobs | List jobs
*LargeLanguageModelsApi* | [**list_llms**](docs/LargeLanguageModelsApi.md#list_llms) | **GET** /v2/llms | List LLMs.
*QueriesApi* | [**query**](docs/QueriesApi.md#query) | **POST** /v2/query | Query Corpora
*QueriesApi* | [**query_corpus**](docs/QueriesApi.md#query_corpus) | **POST** /v2/corpora/{corpus_key}/query | Corpus Query
*QueriesApi* | [**search_corpus**](docs/QueriesApi.md#search_corpus) | **GET** /v2/corpora/{corpus_key}/query | Simple Corpus Query
*RerankersApi* | [**list_rerankers**](docs/RerankersApi.md#list_rerankers) | **GET** /v2/rerankers | List the available rerankers
*UploadApi* | [**upload_file**](docs/UploadApi.md#upload_file) | **POST** /v2/corpora/{corpus_key}/upload_file | Upload a file to the corpus
*UsersApi* | [**create_user**](docs/UsersApi.md#create_user) | **POST** /v2/users | Create a user in the current customer account
*UsersApi* | [**delete_user**](docs/UsersApi.md#delete_user) | **DELETE** /v2/users/{username} | Delete a user
*UsersApi* | [**get_user**](docs/UsersApi.md#get_user) | **GET** /v2/users/{username} | Get a user
*UsersApi* | [**list_users**](docs/UsersApi.md#list_users) | **GET** /v2/users | List users in the account
*UsersApi* | [**reset_user_password**](docs/UsersApi.md#reset_user_password) | **POST** /v2/users/{username}/reset_password | Reset the password for a user
*UsersApi* | [**update_user**](docs/UsersApi.md#update_user) | **PATCH** /v2/users/{username} | Update a user


## Documentation For Models

 - [ApiKey](docs/ApiKey.md)
 - [ApiKeyRole](docs/ApiKeyRole.md)
 - [ApiOperationPolicy](docs/ApiOperationPolicy.md)
 - [ApiPolicy](docs/ApiPolicy.md)
 - [ApiRole](docs/ApiRole.md)
 - [AppClient](docs/AppClient.md)
 - [BadRequestError](docs/BadRequestError.md)
 - [Chat](docs/Chat.md)
 - [ChatFullResponse](docs/ChatFullResponse.md)
 - [ChatInfoResponse](docs/ChatInfoResponse.md)
 - [ChatParameters](docs/ChatParameters.md)
 - [ChatRequest](docs/ChatRequest.md)
 - [ChatStreamedResponse](docs/ChatStreamedResponse.md)
 - [CitationParameters](docs/CitationParameters.md)
 - [ContextConfiguration](docs/ContextConfiguration.md)
 - [CoreDocument](docs/CoreDocument.md)
 - [CoreDocumentPart](docs/CoreDocumentPart.md)
 - [Corpus](docs/Corpus.md)
 - [CorpusCustomDimension](docs/CorpusCustomDimension.md)
 - [CorpusLimits](docs/CorpusLimits.md)
 - [CreateApiKeyRequest](docs/CreateApiKeyRequest.md)
 - [CreateAppClientRequest](docs/CreateAppClientRequest.md)
 - [CreateClientCredentialsRequest](docs/CreateClientCredentialsRequest.md)
 - [CreateCorpusRequest](docs/CreateCorpusRequest.md)
 - [CreateDocumentRequest](docs/CreateDocumentRequest.md)
 - [CreateUserRequest](docs/CreateUserRequest.md)
 - [CustomerSpecificReranker](docs/CustomerSpecificReranker.md)
 - [Document](docs/Document.md)
 - [DocumentStorageUsage](docs/DocumentStorageUsage.md)
 - [Encoder](docs/Encoder.md)
 - [Error](docs/Error.md)
 - [FactualConsistencyScore](docs/FactualConsistencyScore.md)
 - [FilterAttribute](docs/FilterAttribute.md)
 - [GenerationParameters](docs/GenerationParameters.md)
 - [IndividualSearchResult](docs/IndividualSearchResult.md)
 - [Job](docs/Job.md)
 - [JobState](docs/JobState.md)
 - [KeyedSearchCorpus](docs/KeyedSearchCorpus.md)
 - [LLM](docs/LLM.md)
 - [Language](docs/Language.md)
 - [ListApiKeysResponse](docs/ListApiKeysResponse.md)
 - [ListAppClientsResponse](docs/ListAppClientsResponse.md)
 - [ListChatTurnsResponse](docs/ListChatTurnsResponse.md)
 - [ListChatsResponse](docs/ListChatsResponse.md)
 - [ListCorporaResponse](docs/ListCorporaResponse.md)
 - [ListDocumentsResponse](docs/ListDocumentsResponse.md)
 - [ListEncodersResponse](docs/ListEncodersResponse.md)
 - [ListJobsResponse](docs/ListJobsResponse.md)
 - [ListLLMsResponse](docs/ListLLMsResponse.md)
 - [ListMetadata](docs/ListMetadata.md)
 - [ListRerankersResponse](docs/ListRerankersResponse.md)
 - [ListUsersResponse](docs/ListUsersResponse.md)
 - [MMRReranker](docs/MMRReranker.md)
 - [ModelParameters](docs/ModelParameters.md)
 - [NotFoundError](docs/NotFoundError.md)
 - [Prompt](docs/Prompt.md)
 - [QueryCorpusRequest](docs/QueryCorpusRequest.md)
 - [QueryFullResponse](docs/QueryFullResponse.md)
 - [QueryRequest](docs/QueryRequest.md)
 - [QueryStreamedResponse](docs/QueryStreamedResponse.md)
 - [ReplaceFilterAttributesRequest](docs/ReplaceFilterAttributesRequest.md)
 - [ReplaceFilterAttributesResponse](docs/ReplaceFilterAttributesResponse.md)
 - [Reranker](docs/Reranker.md)
 - [SearchCorporaParameters](docs/SearchCorporaParameters.md)
 - [SearchCorpus](docs/SearchCorpus.md)
 - [SearchCorpusParameters](docs/SearchCorpusParameters.md)
 - [SearchParameters](docs/SearchParameters.md)
 - [SearchReranker](docs/SearchReranker.md)
 - [SearchSemantics](docs/SearchSemantics.md)
 - [StreamError](docs/StreamError.md)
 - [StreamGenerationChunk](docs/StreamGenerationChunk.md)
 - [StreamGenerationEnd](docs/StreamGenerationEnd.md)
 - [StreamResponseEnd](docs/StreamResponseEnd.md)
 - [StreamSearchResponse](docs/StreamSearchResponse.md)
 - [StructuredDocument](docs/StructuredDocument.md)
 - [StructuredDocumentSection](docs/StructuredDocumentSection.md)
 - [Turn](docs/Turn.md)
 - [UpdateApiKeyRequest](docs/UpdateApiKeyRequest.md)
 - [UpdateAppClientRequest](docs/UpdateAppClientRequest.md)
 - [UpdateCorpusRequest](docs/UpdateCorpusRequest.md)
 - [UpdateTurnRequest](docs/UpdateTurnRequest.md)
 - [UpdateUserRequest](docs/UpdateUserRequest.md)
 - [User](docs/User.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="OAuth2"></a>
### OAuth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: N/A

<a id="ApiKeyAuth"></a>
### ApiKeyAuth

- **Type**: API key
- **API key parameter name**: x-api-key
- **Location**: HTTP header


## Author

feedback@vectara.com


