'''
Author     : knight-byte ( Abunachar )
File       : ums_main.py
'''

# ---------------IMPORTS ---------------
from typing import final
import requests
from bs4 import BeautifulSoup as bs
import re
from datetime import datetime


# ------------- MAIN USER CLASS ---------------
class User:

    # Different Error messages like login failure and error to fetch data
    __ERROR_MESSAGES = {
        "ERROR_FETCH": {
            "error": "Fail to extract data, please try again after sometime"
        },
        "LOGIN_ERROR": {
            "error": "Error Fail to login, check user Credentials"
        },
    }

    # Different request links as dictionary object
    __UMS_URLS = {
        "LOGIN_URL": "https://ums.lpu.in/lpuums/",
        "HOME_URL": "https://ums.lpu.in/lpuums/Default3.aspx",
        "MESSAGES_URL": "https://ums.lpu.in/lpuums/frmStudentsMyMessages.aspx/GetDataforMyMessages",
        "EXAM_SEATING_URL": "https://ums.lpu.in/lpuums/frmSeatingPlan.aspx",
        "GRADES_URL": "https://ums.lpu.in/lpuums/StudentDashboard.aspx/TermWiseCGPA",
        "MARKS_URL": "https://ums.lpu.in/lpuums/StudentDashboard.aspx/TermWiseMarks",
    }

    # ----------- INIT FUNCTION ----------
    def __init__(self, registration, password) -> None:
        # user Account Credentials ( Registration no., Password )
        self.__REGNO = str(registration)
        self.__PASSWORD = str(password)
        # user Success account login
        self.__LOGIN_SUCCESS = False
        # requests Headers
        self.__HEADERS = {
            'user-agent': 'Mozilla/5.0 (Windows NT x.y; Win64; x64; rv:10.0) Gecko/20100101 Firefox/10.0'
        }
        # user requests session
        self.__USER_SESSION = requests.session()
        # user session expire
        self.__SESSION_EXP = False
        # Login Function
        self.__login()

    # ------- LGOIN FUNCTION----------
    def __login(self) -> None:

        # - If user is successfully logged in and again enter this function means the user previous session expired and
        # refreshing/ creating a new session
        if self.__LOGIN_SUCCESS:
            self.__SESSION_EXP = True
        else:
            self.__SESSION_EXP = False

        # - login request response
        # - login request uses get method to first to get EVENTTARGET, EVENTTARGET etc
        # for the complete session these are unique parament for teh entire login session

        login_response = self.__USER_SESSION.get(
            url=self.__UMS_URLS["LOGIN_URL"],
            headers=self.__HEADERS)

        # The Values are scraped from the get response a then passed as parameter to the POST request
        soup = bs(login_response.content, "lxml")
        login_data = {
            "__EVENTTARGET": soup.find('input', {'name': "__EVENTTARGET"}).get('value'),
            "__EVENTARGUMENT": soup.find('input', {'name': "__EVENTARGUMENT"}).get('value'),
            "__VIEWSTATE": soup.find('input', {'name': "__VIEWSTATE"}).get('value'),
            "__VIEWSTATEGENERATOR": soup.find('input', {'name': "__VIEWSTATEGENERATOR"}).get('value'),
            "__SCROLLPOSITIONX": soup.find('input', {'name': "__SCROLLPOSITIONX"}).get('value'),
            "__SCROLLPOSITIONY": soup.find('input', {'name': "__SCROLLPOSITIONY"}).get('value'),
            "__EVENTVALIDATION": soup.find('input', {'name': "__EVENTVALIDATION"}).get('value'),
            "txtU": self.__REGNO, "TxtpwdAutoId_8767": self.__PASSWORD, "DropDownList1": "1", "iBtnLogins.x": "39", "iBtnLogins.y": " 49"
        }

        response = self.__USER_SESSION.post(
            url=self.__UMS_URLS["LOGIN_URL"], data=login_data, headers=self.__HEADERS)

        # Check if success login
        # NOTE : didnt use status_code 200 to check where login success as it returns status 200 for both success and failure

        check = bs(response.content, "lxml").find(
            class_="TodayEvents")
        if check != None:
            self.__LOGIN_SUCCESS = True
        else:
            self.__LOGIN_SUCCESS = False

    # --------- UNIX TIME --------------
    # this function is used to return the timestamp when a new data is generated by the user
    def __unix_time(self): return datetime.utcnow().strftime("%s")

    # ----------- ANNOUNCEMENT MEDIA -------------
    # - this function is used to exact the URLS from Announcement attachments
    def __announce_media(self, links) -> dict:
        temp = {}
        for link in links:
            l = link.text.strip()
            temp[l] = f"{self.__UMS_URLS['LOGIN_URL']}{link['href']}"
        return temp

    # ----------- ANNOUNCEMENT SCRAP FUNCTION -------------------
    def __announcement_func(self) -> dict:
        if self.__LOGIN_SUCCESS:
            final_data = []

            # - Announcememt request response
            announcement_responce = self.__USER_SESSION.get(
                url=self.__UMS_URLS["HOME_URL"],
                headers=self.__HEADERS)
            soup = bs(announcement_responce.content, "lxml")

            # - annouce1 and announce2 as data is formated as
            #   two alternative different row in webpage
            announce1, announce2 = None, None
            try:
                announce1 = soup.find(class_="rgDataDiv").find(
                    "table").find_all(class_="rgRow")
                announce2 = soup.find(class_="rgDataDiv").find(
                    "table").find_all(class_="rgAltRow")

            # - If fail to get this attribute it throws an attribute error
            # which will be catched here , this error change can come if user login session has expired
            # - if expired it will refresh / create a new session
            except AttributeError:
                if not self.__SESSION_EXP:
                    self.__login()
                    return self.__announcement_func()
                else:
                    self.__SESSION_EXP = False
                    return self.__ERROR_MESSAGES["ERROR_FETCH"]

            annoucement = []
            min_length = min(len(announce1), len(announce2))
            for single in range(min_length):
                # appending the announce from both as alternative
                annoucement.append(announce1[single])
                annoucement.append(announce2[single])
            annoucement += announce1[min_length-1:]+announce2[min_length-1:]
            for ind, single in enumerate(annoucement):
                try:
                    id = ind+1
                    title = single.find("strong").text.strip()
                    string = "\n".join([i.strip()
                                        for i in single.text.split("\n")])
                    body = re.sub(r"\n{2,}", "\n", string=string)

                    # - link are extracted if any link then these raw link is passed to announcement media
                    # function to filter out and returned
                    raw_links = single.find_all("a")
                    links = self.__announce_media(raw_links) if len(
                        raw_links) > 0 else "No Media/Links"
                    temp = {
                        "id": id,
                        "title": title,
                        "body": body,
                        "media": links
                    }
                    final_data.append(temp)
                except AttributeError:
                    if len(final_data) == 0:
                        return self.__ERROR_MESSAGES["ERROR_FETCH"]
            return {"data": final_data, "datetime": self.__unix_time()}
        else:
            return self.__ERROR_MESSAGES["LOGIN_ERROR"]

    # ---------- MESSAGES SCRAP FUNCTION ------------
    def __messages_func(self) -> dict:
        if self.__LOGIN_SUCCESS:
            final_data = []
            self.__USER_SESSION.get(
                url=self.__UMS_URLS["MESSAGES_URL"], headers=self.__HEADERS)
            message_data = {"pageIndex": 1, "Subject": "", "Description": ""}
            message_response = self.__USER_SESSION.post(
                url=self.__UMS_URLS["MESSAGES_URL"],
                json=message_data,
                headers=self.__HEADERS)
            data = None
            if message_response.status_code == 200:
                try:
                    data = message_response.json()["d"]
                except KeyError:
                    return self.__ERROR_MESSAGES["ERROR_FETCH"]

                for single in data:
                    try:
                        body = bs(single["Announcement"],
                                  "lxml").get_text(strip=True)
                        temp = {
                            "id": single["SrNo"],
                            "subject": single["Subject"],
                            "body": body,
                            "date": single["AnnouncementDate"]
                        }
                        final_data.append(temp)

                    except AttributeError:
                        if not self.__SESSION_EXP:
                            self.__login()
                            return self.__messages_func()
                        else:
                            self.__SESSION_EXP = False
                            return self.__ERROR_MESSAGES["ERROR_FETCH"]
                return {"data": final_data, "datetime": self.__unix_time()}
            else:
                return self.__ERROR_MESSAGES["ERROR_FETCH"]

        else:
            return self.__ERROR_MESSAGES["LOGIN_ERROR"]

    def __name_spliter(self, name) -> tuple:
        name_l = name.split()
        fname = "".join(re.findall(
            r"[a-z]+", string=name_l[0], flags=re.IGNORECASE))
        lname = ""
        mname = ""
        if len(name_l) > 1:
            lname = "".join(re.findall(
                r"[a-z]+", string=name_l[-1], flags=re.IGNORECASE))
        if len(name_l) > 2:
            mname = " ".join(name_l[1:-1])
        return (name, fname, mname, lname)

    def __user_profile_func(self):
        if self.__LOGIN_SUCCESS:
            profile_responce = self.__USER_SESSION.get(
                url=self.__UMS_URLS["HOME_URL"], headers=self.__HEADERS)
            soup = bs(profile_responce.content, "lxml")

            main_content = soup.find(class_="middle_profile_left")
            if main_content == None:
                if not self.__SESSION_EXP:
                    self.__login()
                    return self.__user_profile_func()
                else:
                    self.__SESSION_EXP = False
                    return self.__ERROR_MESSAGES["ERROR_FETCH"]

            main_content = "\n".join([i.strip()
                                      for i in main_content.text.split("\n")])
            main_content = re.sub(r"\n{1,}", "\n", main_content)
            content_list = main_content.split("\n")
            name = self.__name_spliter(content_list[2].split("(")[0].strip())
            regn = content_list[2].split("(")[1][:-1].strip()
            rollno = content_list[4].split()[0].strip()
            term = content_list[4].split()[1].split(":")[1][:-1].strip()
            group = content_list[6].split()[0].strip()
            section = content_list[6].split()[1].split(":")[1][:-1].strip()
            prog = f'{content_list[7].split("-")[1].split(")")[0]})'.strip()
            books = content_list[9].strip()

            final_data = {
                "Name": {
                    "Full Name": name[0],
                    "First Name": name[1],
                    "Middle Name": name[2],
                    "Last Name": name[3]
                },
                "RegNo": regn,
                "Rollno": rollno,
                "Term": term,
                "Group": group,
                "Section": section,
                "Programme": prog,
                "Books Issued": books,
            }

            return {"data": final_data, "datetime": self.__unix_time()}
        else:
            return self.__ERROR_MESSAGES["LOGIN_ERROR"]

    def __datesheet_func(self):
        if self.__LOGIN_SUCCESS:
            final_data = []
            datesheet_responce = self.__USER_SESSION.get(
                url=self.__UMS_URLS["EXAM_SEATING_URL"], headers=self.__HEADERS)
            soup = bs(datesheet_responce.content, "lxml")
            try:

                table = soup.find("tbody").find_all("tr")
                if len(table) == 1 and "No records" in table[0].text:
                    return {"message": "No Exam to Display"}
                for i, tr in enumerate(table):
                    td = tr.find_all("td")
                    single_data = {
                        "id": i,
                        "c_code": td[0].text,
                        "course": td[1].text,
                        "report": td[4].text,
                        "date": td[5].text,
                        "timing": td[6].text
                    }
                    final_data.append(single_data)
            except AttributeError:
                if not self.__SESSION_EXP:
                    self.__login()
                    return self.__datesheet_func()
                else:
                    self.__SESSION_EXP = False
                    return self.__ERROR_MESSAGES["ERROR_FETCH"]
            return {"data": final_data, "datetime": self.__unix_time()}

        else:
            return self.__ERROR_MESSAGES["LOGIN_ERROR"]

    def __term_grades_func(self):
        if self.__LOGIN_SUCCESS:
            final_data = []

            grades_response = self.__USER_SESSION.post(
                url=self.__UMS_URLS["GRADES_URL"],
                json={},
                headers=self.__HEADERS)
            if grades_response.status_code == 200:
                try:
                    soup = bs(grades_response.json()["d"], "lxml")
                    tgpa = soup.find_all(class_="row")
                    tgpa_data = []
                    for term in tgpa:
                        temp = 0
                        try:
                            temp = str(term.text.split()[-1]).strip()
                            temp = float(temp)
                        except ValueError:
                            temp = str(term.text.split()[-1]).strip()
                        tgpa_data.append(temp)

                    table = soup.find_all("tbody")
                    term_data = []
                    for term in table:
                        tr = term.find_all("tr")
                        term_temp = []
                        for i in tr:
                            temp = i.find_all("td")
                            course_filter = temp[0].text.strip().split(":")
                            course = {
                                "course": f"{course_filter[0]}: {course_filter[-1].strip().title()}",
                                "grade": temp[1].text.split(":")[1].strip()
                            }
                            term_temp.append(course)
                        term_data.append(term_temp)

                    for ind, single in enumerate(term_data):
                        temp = {
                            "term": ind+1,
                            "tgpa": tgpa_data[ind],
                            "grades": single
                        }
                        final_data.append(temp)

                    return {"data": final_data, "datetime": self.__unix_time()}

                except KeyError:
                    return self.__ERROR_MESSAGES["ERROR_FETCH"]

                except AttributeError:
                    if not self.__SESSION_EXP:
                        self.__login()
                        self.__term_grades_func()
                    else:
                        self.__SESSION_EXP = False
                        return self.__ERROR_MESSAGES["ERROR_FETCH"]
            else:
                return self.__ERROR_MESSAGES["ERROR_FETCH"]
        else:
            return self.__ERROR_MESSAGES["LOGIN_ERROR"]

    def __term_marks_func(self):
        if self.__LOGIN_SUCCESS:
            marks_response = self.__USER_SESSION.post(
                url=self.__UMS_URLS["MARKS_URL"],
                json={},
                headers=self.__HEADERS)
            if marks_response.status_code == 200:
                final_data = []
                try:
                    soup = bs(marks_response.json()["d"], "lxml")
                    term = soup.find_all(class_="border")
                    for per_term in term:

                        subjects = per_term.find_all(class_="divdetail")
                        per_temp = []
                        for subject in subjects:
                            name = subject.find("h4").text.strip()
                            marks = subject.find_all("tr")

                            temp_all_marks = []
                            for mark in marks:
                                all_marks = mark.find_all("td")
                                if len(all_marks) > 1:
                                    temp_marks = {
                                        "type": all_marks[0].text.strip(),
                                        "marks": [single_mark.text.strip() for single_mark in all_marks[1:]],
                                    }
                                    temp_all_marks.append(temp_marks)
                            temp_subject = {
                                "course": name,
                                "marks": temp_all_marks}
                            per_temp.append(temp_subject)
                        temp = {
                            "termid": per_term.find(class_="main-heading").text.split()[-1].strip(),
                            "courses": per_temp}
                        final_data.append(temp)
                    return {"data": final_data, "datetime": self.__unix_time()}

                except KeyError:
                    return self.__ERROR_MESSAGES["ERROR_FETCH"]

                except AttributeError:
                    if not self.__SESSION_EXP:
                        self.__login()
                        return self.__term_marks_func()
                    else:
                        self.__SESSION_EXP = False
                        return self.__ERROR_MESSAGES["ERROR_FETCH"]
            else:
                return self.__ERROR_MESSAGES["ERROR_FETCH"]
        else:
            return self.__ERROR_MESSAGES["LOGIN_ERROR"]

    def __timetable_func(self):
        if self.__LOGIN_SUCCESS:
            timetable_response = self.__USER_SESSION.get(
                url=self.__UMS_URLS["HOME_URL"], headers=self.__HEADERS)
            if timetable_response.status_code == 200:
                final_data = []
                try:
                    soup = bs(timetable_response.content, "lxml")
                    timetable = soup.find(class_="tt_div")
                    trs = timetable.find_all("tr")
                    if len(trs) > 1:
                        for tr in trs:
                            tds = [td.text.strip() for td in tr.find_all("td")]
                            temp = {
                                "course": tds[1],
                                "timing": tds[0],
                                "platform": tds[-2],
                                "status": tds[-1]
                            }
                            final_data.append(temp)
                    else:
                        temp = {
                            "message": "No Classes today"
                        }
                        final_data.append(temp)
                    return {"data": final_data, "datetime": self.__unix_time()}

                except AttributeError:
                    if not self.__SESSION_EXP:
                        self.__login()
                        return self.__datesheet_func()
                    else:
                        self.__SESSION_EXP = False
                        return self.__ERROR_MESSAGES["ERROR_FETCH"]
            else:
                return self.__ERROR_MESSAGES["ERROR_FETCH"]
        else:
            return self.__ERROR_MESSAGES["LOGIN_ERROR"]

    # --------------------------------------------------------------------------------------

    ''' -------------------- USER FUNCTIONS / METHODS ---------------------- '''

    # ------ ANNOUCEMENT FUNCTION -----------
    def annoucements(self) -> dict:
        """
        - To get All recent annoucements
        - This function takes no argument
        - This function returns a Dictionary object
            -> data : list of all announcement 
                > id : Annoucement Id
                > title : Title of the announcement
                > body : Main body of the annoucement
                > media : list of media attached to the announcement ( if any )
            -> datatime : timestamp when data is generated
        """

        return self.__announcement_func()

    # ----------------- MESSAGES FUNCTION -------------------
    def messages(self):
        """
        - To get all the recent messages
        - This function takes no argument 
        - This function return a Dictionary object
            -> data : list of all messages
                > id : Message Id
                > subject : Subject of message
                > body : Main body of the message
                > date : date of message when published
            -> datetime : timestamp when data is generated
        """

        return self.__messages_func()

    # ---------------- USER-PROFILE FUNCTION ------------------
    def user_profile(self) -> dict:
        """
        - To get User detail
        - This function takes no argument 
        - This function return a Dictionary Object
            -> data : user detail
                > Name : Name of the User ( dict object )
                    - Full Name : Fullname of User
                    - First Name : First name
                    - Middle Name : Middle name ( if available )
                    - Last Name : Last Name ( if available )
                > RegNo : Registration Number of user
                > Rollno : Roll Number of User
                > Term : Current Term
                > Group : Class Group
                > Section : Class section
                > Programme : User Programme Name
                > Book Issued : Number of Book user issued from University Library
            -> datetime : timestamp when data is generated
        """

        return self.__user_profile_func()

    # ------------------ DATESHEET FUNCTION ---------------------
    def datesheet(self) -> dict:
        """
        - To get Upcoming Exam Sheet ( if available )
        - This function takes no argument
        - This function return a Dictionary Object
            -> data : List of different courses
                > id  : Id
                > c_code : Course Code
                > course : Course name
                > report : Reporting timing
                > date : Exam date
                > timing : Exam timing
            -> datetime : timestamp when data is generated
        """
        return self.__datesheet_func()

    # --------------- GRADES FUNCTION -------------------
    def grades(self) -> dict:
        """
        - To get Termwise grade
        - This function takes no argument
        - This function return a Dictionary Object
            -> data : List of Different term
                > term : term / semester number
                > tgpa : term / semester tgpa
                > grades : List of grades of all subject of that term
                    - course : Course name
                    - grade : grade in that course
            -> datetime : timestamp when data is generated
        """

        return self.__term_grades_func()

    # -------------- MARKS FUNCTION ----------------------
    def marks(self) -> dict:
        """
        - To get Termwise Marks
        - This function takes no argument
        - This functiom return a Dictionary Object
            -> data : List of different term
                > termid : term id 
                > courses : list of diffeent courses of that term
                    - course : Name of the course
                    - marks : list of different marks of that course
                        -> type : type of mark
                        -> marks : list of marks out of different scheme
            -> datetime : timestamp when data is generated
        """

        return self.__term_marks_func()

    # --------------- CLASSES FUNCTION --------------------
    def classes(self) -> dict:
        """
        - To get all classes of current Day
        - This function takes no argument 
        - This function return a Dictionary Object
            -> data : List of different Courses
                > course : Course name
                > timing : class timing
                > platform : Class platform
                > status : current class status of that course
            -> datetime : timestamp when data is generated
        """

        return self.__timetable_func()

    ''' ----------- END OF USER FUNCTIONS / METHODS HERE ----------- '''
