#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['sklearndf',
 'sklearndf.classification',
 'sklearndf.classification.extra',
 'sklearndf.pipeline',
 'sklearndf.regression',
 'sklearndf.regression.extra',
 'sklearndf.transformation',
 'sklearndf.transformation.extra']

package_data = \
{'': ['*']}

package_dir = \
{'': 'src'}

install_requires = \
['boruta         >= 0.3',
 'gamma-pytools  >=1.0.2,<2',
 'lightgbm       >= 3.0',
 'numpy          >=1.16,<1.21',
 'packaging      >=20',
 'pandas         >=0.24,<1.3',
 'scikit-learn   >=0.21,<0.24',
 'joblib         >=0.13,<1.1',
 'matplotlib     >=3.0,<3.4',
 'scipy          >=1.2,<1.6',
 'typing_inspect >=0.4,<0.7']

extras_require = \
{'docs': ['sphinx == 3.4.*',
          'sphinx-autodoc-typehints == 1.11.*',
          'pydata-sphinx-theme == 0.4.*',
          'nbsphinx == 0.7.*',
          'jupyter >= 1.0',
          'docutils',
          'xlrd == 1.2.*',
          'm2r == 0.2.*'],
 'testing': ['pytest >= 5.2.*',
             'pytest-cov == 2.8.*',
             'flake8 == 3.8.*',
             'flake8-comprehensions == 3.2.*',
             'isort == 5.5.*']}

setup(name='sklearndf',
      version='1.0.2',
      description='DataFrame support and feature traceability for scikit-learn.',
      author='Boston Consulting Group (BCG)',
      author_email=None,
      url='https://github.com/BCG-Gamma/sklearndf',
      packages=packages,
      package_data=package_data,
      package_dir=package_dir,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.6,<4',
     )
