# This file was automatically generated by scripts/templates/wrap_0_1.py.jinja2.
# DO NOT MODIFY IT BY HAND. Instead, modify scripts/templates/wrap_0_1.py.jinja2,
# run python ./scripts/generate.py to regenerate this file.
#
# TODO: Create a custom template to generate this file.
# Currently, we are using the default template from improved_datamodel_codegen.

"""This module contains functions and types for Wrap Manifest 0.1 ."""

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, Extra, Field  # pylint: disable=no-name-in-module


class Version(Enum):
    """WRAP Standard Version."""

    VERSION_0_1_0 = "0.1.0"
    VERSION_0_1 = "0.1"


class Type(Enum):
    """Wrapper Package Type."""

    WASM = "wasm"
    INTERFACE = "interface"
    PLUGIN = "plugin"


class Env(BaseModel):
    """Allows marking the env as required for the method."""

    required: Optional[bool] = None


class GetImplementations(BaseModel):
    """Allows enabling/disabling the `getImplementations` capability."""

    enabled: bool


class CapabilityDefinition(BaseModel):
    """Capability definition that contains the list of capabilities."""

    get_implementations: Optional[GetImplementations] = Field(
        None,
        alias="getImplementations",
        description="Allows enabling/disabling the `getImplementations` capability",
    )


class ImportedDefinition(BaseModel):
    """Imported definition that contains the information about the imported `definitions`."""

    uri: str
    namespace: str
    native_type: str = Field(..., alias="nativeType")


class WithKind(BaseModel):
    """With kind definition that describes the kind of the definition."""

    kind: float


class WithComment(BaseModel):
    """With comment definition that describes the comment of the definition."""

    comment: Optional[str] = None


class GenericDefinition(WithKind):
    """Generic definition that describes the structure of the definition."""

    type: Union[str, Enum, None]
    name: Optional[str] = None
    required: Optional[bool] = None


class ScalarType(Enum):
    """Scalar type that describes the type of the `scalar`."""

    U_INT = "UInt"
    U_INT8 = "UInt8"
    U_INT16 = "UInt16"
    U_INT32 = "UInt32"
    INT = "Int"
    INT8 = "Int8"
    INT16 = "Int16"
    INT32 = "Int32"
    STRING = "String"
    BOOLEAN = "Boolean"
    BYTES = "Bytes"
    BIG_INT = "BigInt"
    BIG_NUMBER = "BigNumber"
    JSON = "JSON"


class ScalarDefinition(GenericDefinition):
    """Scalar definition that describes the structure of the `scalar` type."""

    type: ScalarType


class MapKeyType(Enum):
    """Map key type that describes the type of the `map` key."""

    U_INT = "UInt"
    U_INT8 = "UInt8"
    U_INT16 = "UInt16"
    U_INT32 = "UInt32"
    INT = "Int"
    INT8 = "Int8"
    INT16 = "Int16"
    INT32 = "Int32"
    STRING = "String"


class ObjectRef(GenericDefinition):
    """Object reference that points to an object definition."""


class EnumRef(GenericDefinition):
    """Enum reference that points to an enum definition."""


class UnresolvedObjectOrEnumRef(GenericDefinition):
    """Unresolved object or enum reference that doesn't point to any object or enum definition."""


class ImportedModuleRef(BaseModel):
    """Imported module points that refers to an imported module."""

    type: Optional[str] = None


class InterfaceImplementedDefinition(GenericDefinition):
    """Interface Implemented definition that describes the interface implemented by the module."""


class EnumDefinition(GenericDefinition, WithComment):
    """Enum definition that describes the structure of the enum."""

    constants: Optional[List[str]] = None


class InterfaceDefinition(GenericDefinition, ImportedDefinition):
    """Interface definition that describes the structure of the interface."""

    capabilities: Optional[CapabilityDefinition] = None


class ImportedEnumDefinition(EnumDefinition, ImportedDefinition):
    """Imported enum definition that describes the structure of the imported `enum`."""


class WrapManifest(BaseModel):
    """Wrap Manifest that contains metadata for the WRAP package."""

    class Config:
        """Pydantic model config."""

        extra = Extra.forbid

    version: Version = Field(..., description="WRAP Standard Version")
    type: Type = Field(..., description="Wrapper Package Type")
    name: str = Field(..., description="Wrapper Name", regex="^[a-zA-Z0-9\\-\\_]+$")
    abi: Abi = Field(..., description="Information of modules")


class Abi(BaseModel):
    """WRAP ABI that describes the interface of the WRAP module."""

    version: Optional[str] = Field(None, description="ABI Version")
    object_types: Optional[List[ObjectDefinition]] = Field(None, alias="objectTypes")
    module_type: Optional[ModuleDefinition] = Field(None, alias="moduleType")
    enum_types: Optional[List[EnumDefinition]] = Field(None, alias="enumTypes")
    interface_types: Optional[List[InterfaceDefinition]] = Field(
        None, alias="interfaceTypes"
    )
    imported_object_types: Optional[List[ImportedObjectDefinition]] = Field(
        None, alias="importedObjectTypes"
    )
    imported_module_types: Optional[List[ImportedModuleDefinition]] = Field(
        None, alias="importedModuleTypes"
    )
    imported_enum_types: Optional[List[ImportedEnumDefinition]] = Field(
        None, alias="importedEnumTypes"
    )
    imported_env_types: Optional[List[ImportedEnvDefinition]] = Field(
        None, alias="importedEnvTypes"
    )
    env_type: Optional[EnvDefinition] = Field(None, alias="envType")


class ObjectDefinition(GenericDefinition, WithComment):
    """Object definition that describes the structure of the object."""

    properties: Optional[List[PropertyDefinition]] = None
    interfaces: Optional[List[InterfaceImplementedDefinition]] = None


class ModuleDefinition(GenericDefinition, WithComment):
    """Module definition that describes the structure of the module."""

    methods: Optional[List[MethodDefinition]] = None
    imports: Optional[List[ImportedModuleRef]] = None
    interfaces: Optional[List[InterfaceImplementedDefinition]] = None


class MethodDefinition(GenericDefinition, WithComment):
    """Method definition that describes the signature of the method."""

    arguments: Optional[List[PropertyDefinition]] = None
    env: Optional[Env] = Field(
        None, description="Allows marking the env as required for the method."
    )
    return_: Optional[PropertyDefinition] = Field(None, alias="return")


class ImportedModuleDefinition(GenericDefinition, ImportedDefinition, WithComment):
    """Imported module definition that describes the structure of the imported `module`."""

    methods: Optional[List[MethodDefinition]] = None
    is_interface: Optional[bool] = Field(None, alias="isInterface")


class AnyDefinition(GenericDefinition):
    """Any definition that describes the structure of any `definition`."""

    array: Optional[ArrayDefinition] = None
    scalar: Optional[ScalarDefinition] = None
    map: Optional[MapDefinition] = None
    object: Optional[ObjectRef] = None
    enum: Optional[EnumRef] = None
    unresolved_object_or_enum: Optional[UnresolvedObjectOrEnumRef] = Field(
        None, alias="unresolvedObjectOrEnum"
    )


class EnvDefinition(ObjectDefinition):
    """Env definition that describes the structure of the env."""


class ImportedObjectDefinition(ObjectDefinition, ImportedDefinition, WithComment):
    """Imported object definition that describes the structure of the imported `object`."""


class PropertyDefinition(WithComment, AnyDefinition):
    """Property definition that describes the structure of the property."""


class ArrayDefinition(AnyDefinition):
    """Array definition that describes the structure of the `array`."""

    item: Optional[GenericDefinition] = None


class MapKeyDefinition(AnyDefinition):
    """Map key definition that describes the structure of the `map` key."""

    type: Optional[MapKeyType] = None


class MapDefinition(AnyDefinition, WithComment):
    """Map definition that describes the structure of the `map`."""

    key: Optional[MapKeyDefinition] = None
    value: Optional[GenericDefinition] = None


class ImportedEnvDefinition(ImportedObjectDefinition):
    """Imported env definition that describes the structure of the imported `env`."""


WrapManifest.update_forward_refs()
Abi.update_forward_refs()
ObjectDefinition.update_forward_refs()
ModuleDefinition.update_forward_refs()
MethodDefinition.update_forward_refs()
AnyDefinition.update_forward_refs()
EnvDefinition.update_forward_refs()
ImportedObjectDefinition.update_forward_refs()
PropertyDefinition.update_forward_refs()
ArrayDefinition.update_forward_refs()
MapKeyDefinition.update_forward_refs()
MapDefinition.update_forward_refs()
ImportedEnvDefinition.update_forward_refs()
