"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventInvokeConfig = void 0;
const core_1 = require("@aws-cdk/core");
const destination_1 = require("./destination");
const lambda_generated_1 = require("./lambda.generated");
/**
 * Configure options for asynchronous invocation on a version or an alias.
 *
 * By default, Lambda retries an asynchronous invocation twice if the function
 * returns an error. It retains events in a queue for up to six hours. When an
 * event fails all processing attempts or stays in the asynchronous invocation
 * queue for too long, Lambda discards it.
 *
 * @stability stable
 */
class EventInvokeConfig extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        if (props.maxEventAge && (props.maxEventAge.toSeconds() < 60 || props.maxEventAge.toSeconds() > 21600)) {
            throw new Error('`maximumEventAge` must represent a `Duration` that is between 60 and 21600 seconds.');
        }
        if (props.retryAttempts && (props.retryAttempts < 0 || props.retryAttempts > 2)) {
            throw new Error('`retryAttempts` must be between 0 and 2.');
        }
        new lambda_generated_1.CfnEventInvokeConfig(this, 'Resource', {
            destinationConfig: props.onFailure || props.onSuccess
                ? {
                    ...props.onFailure ? { onFailure: props.onFailure.bind(this, props.function, { type: destination_1.DestinationType.FAILURE }) } : {},
                    ...props.onSuccess ? { onSuccess: props.onSuccess.bind(this, props.function, { type: destination_1.DestinationType.SUCCESS }) } : {},
                }
                : undefined,
            functionName: props.function.functionName,
            maximumEventAgeInSeconds: props.maxEventAge && props.maxEventAge.toSeconds(),
            maximumRetryAttempts: (_a = props.retryAttempts) !== null && _a !== void 0 ? _a : undefined,
            qualifier: props.qualifier || '$LATEST',
        });
    }
}
exports.EventInvokeConfig = EventInvokeConfig;
//# sourceMappingURL=data:application/json;base64,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