"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoFunction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const lambda = require("aws-cdk-lib/aws-lambda");
const bundling_1 = require("./bundling");
const util_1 = require("./util");
/**
 * A Golang Lambda function
 */
class GoFunction extends lambda.Function {
    constructor(scope, id, props) {
        var _b, _c, _d;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_go_alpha_GoFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (props.runtime && (props.runtime.family !== lambda.RuntimeFamily.GO && props.runtime.family != lambda.RuntimeFamily.OTHER)) {
            throw new Error('Only `go` and `provided` runtimes are supported.');
        }
        const entry = path.resolve(props.entry);
        // Find the project root
        let moduleDir;
        if (props.moduleDir) {
            const parsedModuleDir = path.parse(props.moduleDir);
            if (parsedModuleDir.base && parsedModuleDir.ext && parsedModuleDir.base === 'go.mod') {
                if (!fs.existsSync(props.moduleDir)) {
                    throw new Error(`go.mod file at ${props.moduleDir} doesn't exist`);
                }
            }
            else if (parsedModuleDir.base && parsedModuleDir.ext && parsedModuleDir.base != 'go.mod') {
                throw new Error('moduleDir is specifying a file that is not go.mod');
            }
            else if (!fs.existsSync(path.join(props.moduleDir, 'go.mod'))) {
                throw new Error(`go.mod file at ${props.moduleDir} doesn't exist`);
            }
            moduleDir = props.moduleDir;
        }
        else {
            const modFile = util_1.findUp('go.mod', entry);
            if (!modFile) {
                throw new Error('Cannot find go.mod. Please specify it with `moduleDir`.');
            }
            moduleDir = modFile;
        }
        const runtime = (_b = props.runtime) !== null && _b !== void 0 ? _b : lambda.Runtime.PROVIDED_AL2;
        const architecture = (_c = props.architecture) !== null && _c !== void 0 ? _c : lambda.Architecture.X86_64;
        super(scope, id, {
            ...props,
            runtime,
            code: bundling_1.Bundling.bundle({
                ...(_d = props.bundling) !== null && _d !== void 0 ? _d : {},
                entry,
                runtime,
                architecture,
                moduleDir,
            }),
            handler: 'bootstrap',
        });
    }
}
exports.GoFunction = GoFunction;
_a = JSII_RTTI_SYMBOL_1;
GoFunction[_a] = { fqn: "@aws-cdk/aws-lambda-go-alpha.GoFunction", version: "2.26.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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